#!/usr/bin/env sh
#
# ----------------------------------------------------------------------------
#
# Copyright 2019 IBM Corporation
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# ----------------------------------------------------------------------------
#

############################################################
# NAME        : compile-client.sh
# DESCRIPTION : Define command line arguments and help
#               for the main ChopStiX executable
# ARGUMENTS   :
#    out  : Output header file
#    cmds : List of all available commands
############################################################

out=$1 ; shift
cmds="$*"
outdir=$(dirname "$out")
mkdir -p "$outdir"

{
cat << EndOfMessage
/************************************************************
 * Autogenerated header file for client
 ************************************************************/

#pragma once

#include "support/options.h"

using OptionDef = chopstix::OptionDef;

/* Include all commands */
EndOfMessage

for cmd in $cmds ; do
    echo "#include \"cmd/$cmd.h\""
done

cat << EndOfMessage

/* Define command list macro */
#define COMMAND_LIST(X) \\
EndOfMessage

for cmd in $cmds ; do
    [ "$cmd" != "main" ] && echo "    X($cmd) \\"
done

echo
} > "$out"
