# aicollective.tools

> Explore a curated selection of AI tools and resources.

We're thrilled to invite you to this our open-source community dedicated in creating a comprehensive collection of tools that developers, researchers, and enthusiasts can access, and collaborate on.You can help by sending [Pull Requests](https://github.com/Hyraze/ai-collective-tools/pulls) to add more services and make sure to review our [Contribution Guidelines](https://github.com/Hyraze/ai-collective-tools/blob/main/CONTRIBUTING.md) for detailed information on how to get started.

[![Open Source Love svg1](https://badges.frapsoft.com/os/v1/open-source.svg?v=103)](https://github.com/ellerbrock/open-source-badges/)
[![Track Awesome List](https://www.trackawesomelist.com/badge.svg)](https://www.trackawesomelist.com/Hyraze/ai-collective-tools)
[![FOSSA Status](https://app.fossa.com/api/projects/git%2Bgithub.com%2FHyraze%2Fai-collective-tools.svg?type=shield&issueType=license)](https://app.fossa.com/projects/git%2Bgithub.com%2FHyraze%2Fai-collective-tools?ref=badge_shield&issueType=license)
![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat)
![Visitors](https://api.visitorbadge.io/api/visitors?path=https%3A%2F%2Fgithub.com%2FHyraze%2Fai-collective-tools&countColor=%2337d67a&style=flat)
![GitHub contributors](https://img.shields.io/github/contributors/Hyraze/ai-collective-tools)
![GitHub last commit](https://img.shields.io/github/last-commit/Hyraze/ai-collective-tools)
![Github](https://img.shields.io/github/license/Hyraze/ai-collective-tools)
![GitHub issues](https://img.shields.io/github/issues/Hyraze/ai-collective-tools)
![GitHub pull requests](https://img.shields.io/github/issues-pr/Hyraze/ai-collective-tools)

<a href="https://www.producthunt.com/posts/ai-collective-tools?utm_source=badge-featured&utm_medium=badge&utm_souce=badge-ai&#0045;collective&#0045;tools" target="_blank"><img src="https://api.producthunt.com/widgets/embed-image/v1/featured.svg?post_id=419835&theme=light" alt="AI&#0032;Collective&#0032;Tools - Explore&#0032;a&#0032;curated&#0032;selection&#0032;of&#0032;AI&#0032;tools&#0032;and&#0032;resources&#0046; | Product Hunt" style="width: 250px; height: 54px;" width="250" height="54" /></a>

## Pricing

Use these hashtags in search to filter out the tools

- `#free`
- `#freemium`
- `#paid`
- `#opensource`

# Table of Contents

- [3D](#3d)
- [Agriculture](#agriculture)
- [Art](#art)
- [Audio Editing](#audio-editing)
- [Avatars](#avatars)
- [Chatbots](#chatbots)
- [Code Assistant](#code-assistant)
- [Cooking](#cooking)
- [Copywriting](#copywriting)
- [Crypto](#crypto)
- [Customer Support](#customer-support)
- [Dating](#dating)
- [Design Assistant](#design-assistant)
- [Design Generator](#design-generator)
- [Developer](#developer)
- [E-Commerce](#e-commerce)
- [Education](#education)
- [Email Assistant](#email-assistant)
- [Experiments](#experiments)
- [Fashion](#fashion)
- [Finance](#finance)
- [Fitness](#fitness)
- [Fun Tools](#fun-tools)
- [Gaming](#gaming)
- [General Writing](#general-writing)
- [Gift Ideas](#gift-ideas)
- [HealthCare](#healthcare)
- [Human Resources](#human-resources)
- [Image Classification](#image-classification)
- [Image Editing](#image-editing)
- [Image Generator](#image-generator)
- [Interior Designing](#interior-designing)
- [Legal Assistant](#legal-assistant)
- [Logo Generator](#logo-generator)
- [Low Code](#low-code)
- [Models](#models)
- [Music](#music)
- [Paraphraser](#paraphraser)
- [Personal Assistant](#personal-assistant)
- [Presentations](#presentations)
- [Productivity](#productivity)
- [Prompt Generator](#prompt-generator)
- [Psychology](#psychology)
- [Real Estate](#real-estate)
- [Religion](#religion)
- [Research](#research)
- [Resume](#resume)
- [Sales](#sales)
- [Search Engine](#search-engine)
- [SEO](#seo)
- [Shopping](#shopping)
- [Social Media](#social-media)
- [Spreadsheets](#spreadsheets)
- [SQL](#sql)
- [Startup Tools](#startup-tools)
- [Story Teller](#story-teller)
- [Summarizer](#summarizer)
- [Testing](#testing)
- [Text to Speech](#text-to-speech)
- [Text to Image](#text-to-image)
- [Transcriber](#transcriber)
- [Travel](#travel)
- [Video Editing](#video-editing)
- [Video Generator](#video-generator)
- [Weather](#weather)
- [Writing Generator](#writing-generator)
- [Other Resources](#other-resources)

## 3D

- [3DFY](https://app.3dfy.ai/) - Generate high-quality 3D models, automatically, in certain object categories using text-prompts. `#paid`
- [Alpha3D](https://www.alpha3d.io/) - Alpha3D is a revolutionary generative AI-powered platform that transforms 2D images into high-quality 3D assets at scale. `#paid`
- [Any Image to 3D](https://www.csm.ai/any-image-to-3d) - Simplifies the process of converting 2D images into fully detailed 3D models, catering to industries like gaming, robotics, mixed reality, VFX, and e-commerce. `#free`
- [OctoEverywhere](https://octoeverywhere.com/) - OctoEverywhere is a 3D printing failure detection assistant that uses computer vision algorithms to detect printing errors such as spaghetti, layer shifts, adhesion issues, and more `#paid`
- [Spyne](https://www.spyne.ai/) - Spyne is helping used-car dealerships and marketplaces create engaging VDPs with 360° views and images that sell better. `#paid`
- [GET3D-Nvidia](https://nv-tlabs.github.io/GET3D/) - Generative 3D Textured Shapes from Images. `#free`
- [Meshy](https://www.meshy.ai) - Create Stunning 3D Game Assets with AI `#free`
- [Pixela AI](https://pixela.ai/) - AI-generated game textures. Share yours with the community! `#free`
- [StudioGPT by Latent Labs](https://www.latentlabs.art/) - Reimagine Your Visual Designs with AI-Powered Creativity. `#paid`
- [Pool Planner AI](https://poolplannerai.com/) - Visualize Your Dream Pool Design `#paid`
- [Omnia](https://www.theomnia.io/) - Create 3D models based on text prompts or uploaded images. `#paid`
- [Heroify](https://www.heroify.lol/) - Generate high-quality 3D graphics for landing pages. `#paid`
- [Tafi Avatar](https://www.maketafi.com/ai) - Text-to-3D Character Engine. `#paid`
- [Unity](https://unity.com/ai) - Craft interactive, dynamic 3D content for AR, VR, mobile, desktop, and web platforms. `#paid`
-

**[⬆️ Back to Top](#table-of-contents)**

## Agriculture

- [Cybertiks](https://cybertiks.com/) - Revolutionizing Agriculture and Environmental Monitoring with AI `#paid`
- [GreenThumb](https://www.messengerx.io/) - Unlock the World of Gardening with Your AI Companion `#free`
- [Vinetribe](https://vinetribe.co/concierge) - Fosters an inclusive wine community through guided at-home tastings `#free`

**[⬆️ Back to Top](#table-of-contents)**

## Art

- [BlueWillow](https://www.bluewillow.ai) - Prompt based AI image generating tool for logos, characters, digital artwork, etc. `#free`
- [Easy-Peasy.ai](https://easy-peasy.ai) - AI copywriting tools to help you tell your story in the most engaging way. `#freemium`
- [Dall-E 3](https://openai.com/dall-e-3) - AI image generator accesible Microsoft's Bing Chat and Bing Image Creator `#free`
- [PixAI.Art](https://pixai.art) - AI art generator designed specifically for creating anime-inspired artwork `#free`
- [lexical.Art](https://lexica.art) -AI image generation tool that allows you to create images from text descriptions. `#free`
- [seaart.ai](https://www.seaart.ai/) - AI image generation tool with advanced configurations available, tons of ready to use models and image enhancements, text to img , img to text and much. `#freemium`

**[⬆️ Back to Top](#table-of-contents)**

## Audio Editing

- [AI Sound Copilot](https://www.waanda.org/) - Effortless Sound Effects Creation for Videos and Games `#free`
- [Audiogen](https://www.audiogen.co/) - Elevate Your Creations with AI-Generated Sounds `#freemium`
- [CrystalSound](https://crystalsound.ai/) - Experience noise-free audio with AI.`#freemium`
- [Diktatorial Suite](https://diktatorial.com) - Audio mastering and music enhancer with text prompts. `#freemium`
- [Gladia](https://www.gladia.io/) - Speech-to-Text API. `#freemium`
- [Krisp](https://krisp.ai) - Krisp's AI removes background noise & echo from meetings `#freemium`
- [VideoDubber](https://videodubber.ai) - Offers free video translation, dubbing, voice cloning, and text-to-speech services. `#freemium`


**[⬆️ Back to Top](#table-of-contents)**

## Avatars

- [Ascendant Art](https://apps.apple.com/us/app/ascendant-art-ai-avatars/) - Utilizes artificial intelligence to enable users to craft personalized avatar images. `#paid`
- [Never AI](https://www.never.tech) - Unlock Your Imagination with Never's Hyper-Realistic AI Images. `#paid`
- [Staf](https://www.staf.ai/) - Streamline Your Business with Curated AI Solutions `#paid`

**[⬆️ Back to Top](#table-of-contents)**

## Chatbots

- [Bard](https://bard.google.com/) - An experimental AI chatbot by Google, powered by the LaMDA model. `#free`
- [Bing Chat](https://www.bing.com/chat) - A conversational AI language model powered by Microsoft Bing. `#free`
- [Character.AI](https://character.ai/) - Character.AI lets you create characters and chat to them. `#freemium`
- [ChatGPT](https://chat.openai.com/chat) - ChatGPT by OpenAI is a large language model that interacts in a conversational way. `#freemium`
- [ChatPDF](https://www.chatpdf.com/) - Chat with any PDF. `#free`
- [ChatSonic](https://writesonic.com/chat) - An AI-powered assistant that enables text and image creation. `#freemium`
- [Earkick](https://earkick.com/chat) - a virtual mental health trained chatbot
- [MediSearch](https://medisearch.io) - This tool is a medical AI chatbot which gives you direct science-based answers to medical questions `#free`
- [Phind](https://www.phind.com/) - An AI-powered coding and technical assistant, making complex tasks simpler. `#freemium`
- [Smitty](https://www.smitty.ai/) - Streamlining processes and providing agile, efficient responses to your unique business needs. `#freemium`
- [Tidio](https://www.tidio.com/) - Tidio Live Chat & AI Chatbots , Accelerate your growth with AI customer service `#freemium`

**[⬆️ Back to Top](#table-of-contents)**

## Code Assistant

- [Blackbox](https://blackbox.dev/) - Blackbox is an AI-powered code editor that helps developers write code faster and more efficiently. `#freemium`
- [Bugasura](https://bugasura.io/) - Bug tracker designed to streamline the reporting, tracking, and closing of bugs for modern technology teams. `#freemium`
- [Codeium](https://codeium.com/) - AI-powered code acceleration toolkit to code smarter, not harder. `#free`
- [Copilot](https://github.com/features/copilot) - AI assistant that speeds up delivery and keeps your code safe `#paid`
- [Cursor.sh](https://cursor.sh) - This tool uses GPT-4 to help you code that increases productivity `#freemium`
- [Devassistant.ai](https://devassistant.ai/) - Your AI Co-Programmer for Efficient Development `#paid`
- [Lintrule](https://www.lintrule.com/) - Supercharge Code Reviews and Policy Enforcement `#paid`
- [Safurai](https://www.safurai.com/) - The AI Code Assistant that really helps developers. `#free`
- [Sizzle AI](https://web.szl.ai/) - Sizzle isn't just any app It's your personalized AI-powered tutor with the mission to make learning amazing for all.Search any Maths, coding Problems with Sizzle. `#free`
- [Tabnine](https://www.tabnine.com/) - Tabnine helps developers write code faster, in any IDE. `#freemium`

**[⬆️ Back to Top](#table-of-contents)**

## Cooking

- [dishgen](https://www.dishgen.com/) - DishGen is a smart recipe assistant that can simplify healthy cooking for you. `#freemium`
- [Mr. Cook](https://www.mrcook.app/en/tools/recipe-generator) - Your AI-Powered Recipe Generator `#free`

**[⬆️ Back to Top](#table-of-contents)**

## Copywriting

- [Heroguide](https://www.heroguide.ai/) - Craft your unique brand message effortlessly with the Heroguide. `#free`
- [SmartBird](https://smartbird.ai/) - SmartBird: Your AI Assistant for Effortless Communication `#paid`

**[⬆️ Back to Top](#table-of-contents)**

## Crypto

- [Coinfeeds](https://chat.coinfeeds.io/)- Your Crypto Chatbot Companion, ask it anything! `#free`

**[⬆️ Back to Top](#table-of-contents)**

## Customer Support

- [Boom AI](https://boom.ai/) - powered voice agents and services built by contact center experts. `#freemium`
- [Chatfuel AI](https://chatfuel.com/lite) - AI-powered chatbot platform: elevate customer support and sales `#freemium`
- [Doks](https://doks.ai/) - Chatbot creation tool that empowers businesses to train chatbots using their website and documentation content. `#paid`
- [Humata AI](https://www.humata.ai/) - ChatGPT for your files. `#free`

**[⬆️ Back to Top](#table-of-contents)**

## Dating

- [FantasyGF.ai](https://fantasygf.ai/) - (N)SFW Chat with AI Girlfriends. Create your own AI Girlfriend, chat with her, ask her for pictures, or listen to her voice. Most advanced AI Girlfriend builder and chatting model. Chat with AI versions of OnlyFans Girls. `#freemium`
- [Candy.ai](https://candy.ai/discover) - Your dream companion awaits! Create your Virtual Girlfriend, shape her personality and bring her to life in one click. 100% powered by Artificial Intelligence. `#freemium`
- [DatePlanner.ai](https://dateplanner.ai/) - Online dating is competitive. Stand out with thoughtful date ideas and interesting conversation topics. `#paid`
- [Dates.ai](https://www.dates.ai) - Dates.ai: Where authenticity meets AI to revolutionize dating, fostering genuine connections in a fraud-free and fair environment. `#free`
- [DreamGF](https://dreamgf.ai/) - DreamGF uses AI algorithms to generate virtual partners according to user preferences. Users can customize the appearance, personality, and other traits. `#freemium`
- [Pickmyline](https://www.pickmyline.online/) - Not able to start conversation even after getting matched? Here is a ChatGPT powered pickup line generator for you!! `#free`
- [Yourmove.ai](https://www.yourmove.ai/) - Making conversations easier. So you can spend less time texting, and more time dating. `#freemium`

**[⬆️ Back to Top](#table-of-contents)**

## Design Assistant

- [AI Site Builder](https://library.relume.io/ai-site-builder) - Create a marketing website for any company in minutes using systems you already love. `#freemium`
- [Diagrammaton](https://www.figma.com/community/plugin/1295127627739218424/diagrammaton) - Diagrammaton converts natural language descriptions into fleshed out diagrams. `#free`
- [Feathery](https://ai.feathery.io/) - Users can design forms in seconds without coding or design skills. `#freemium`
- [Paintit.ai](https://paintit.ai/interior-ai/) - Paintit.ai is an AI-powered tool that enables users to generate unique AI interior visualizations in minutes `#free`

**[⬆️ Back to Top](#table-of-contents)**

## Design Generator

- [Book Witch](https://bookwitch.io/) - Use the power of AI to create complete e-books with just one click! `#freemium`
- [Canva](https://www.canva.com/) - Use it to create social media posts, presentations, posters, videos, logos and more. `#freemium`
- [Designs AI](https://designs.ai/) - Make a logo, video, social media banner, business card, flyer, mockup and more with AI. `#freemium`
- [Galileo AI](https://www.usegalileo.ai/explore) -Galileo AI is a UI generation platform for easy and fast design ideation.Generative AI for user interface design, empowering you to design beyond imagination with speed . `#freemium`
- [Fly.io](https://openui.fly.dev/ai/) - Generate a modal popup for user feedback, including text area and submit button. Create a sticky header that becomes visible when scrolling up and hides on,It also convert our screenshot to UI/UX designs. `free`
- [Stream Slides](https://streamslide.io/) - YouTube Video to Slides Converter. `#free`
- [svg.io](https://svg.io) - The power of AI with our Free Text-to-SVG Generator! Effortlessly convert your text prompts into stunning SVG images using our advanced AI technology. `free`

  
## Developer

- [Mintlify](https://mintlify.com/) - Mintlify: Streamline code documentation with one-click automation for developers, enhancing code clarity and saving time. `#freemium`
- [Floom](https://github.com/FloomAI/Floom) - AI gateway and marketplace for developers, enables streamlined integration of AI features into products. `#opensource`

**[⬆️ Back to Top](#table-of-contents)**

## E-Commerce

- [Aidaptive](https://aidaptive.com/request-demo) - Predictive personalization engines for eCommerce and Hospitality `#paid`
- [Hulk](https://hulkhelper-ai.webflow.io/) - Personalized Shopping Experience `#free`
- [Lumiere 3D](https://www.lumiere3d.ai/) - This tool is verified because it is either an established company or has good social media presence `#paid`
- [Sellesta](https://sellesta.com/marketplace/) - Revamp your Amazon business with Sellesta AI tools! Keyword Research, Listing Optimization, and Keyword Tracking. `#freemium`

**[⬆️ Back to Top](#table-of-contents)**

## Education

- [ClassPoint AI](https://www.classpoint.io/) - AI tool for teachers to generate questions out of any PowerPoint slide. `#free`
- [ClipDish](https://apps.apple.com/us/app/clipdish-simplify-cooking/id1465427291) - AI-Enhanced Recipe Revolution with ClipDish `#paid`
- [Education CoPilot](https://educationcopilot.com/) - AI tool helps teachers design their curriculum, lesson plans and activities, and track the progress of their students. `#freemium`
- [Formative AI](https://www.formative.com/ai-powered) - AI tool that assists teachers in assessing their students’ work. `#free`
- [Gradescope](https://www.gradescope.com/) - AI-powered grading and assessment tool. `#freemium`
- [Huxli.ai](https://huxli.ai/) - Elevate Your Writing, Supercharge Your Productivity `#freemium`
- [PagePundit](https://pagepundit.com/) - Discover Tailored Book Suggestions Effortlessly `#free`
- [QuillBot](https://quillbot.com/) - AI-powered paraphrasing tool. `#freemium`
- [SlidesAI.io](https://www.slidesai.io/) - powerful AI tool that can help teachers create visually appealing and engaging presentations for their classroom teaching instantly. `#freemium`
- [Sibyl AI](https://sibyls.ai/) - Provide guidance, insights, and support for individuals at different levels of spiritual exploration, from neophytes to adepts and holistic practitioners. `#paid`
- [SocratiQ](https://socratiq.ai/) - The Future of Education, Integrated `#paid`
- [Textero.ai AI Essay Writer](https://textero.ai/) - Your reliable AI academic assistant for tasks of any scale. `#free`
- [Otter.ai](https://otter.ai/) - Ai meeting assistant that records audio, write notes, captures action items, and generates summaries. `#freemium`
- [Text With History](https://textwith.me/history/) - Chat with famous politicians, scientists, artists, world leaders and more. Also includes history tutors. `#freemium`
- [Text With Authors](https://textwith.me/authors/) - Chat with famous authors, poets, playwrights, philosophers and more from classical literature. `#freemium`

**[⬆️ Back to Top](#table-of-contents)**

## Email Assistant

- [Rytr](https://rytr.me/) - AI writing assistant for fast, affordable, high-quality content. `#freemium`
- [Zapier](https://zapier.com/blog/best-ai-email-assistant/) - Discover the top AI email assistants that streamline your inbox and supercharge your productivity. `#freemium`

**[⬆️ Back to Top](#table-of-contents)**

## Experiments

- [Hey Data](https://heydata.org/) - Personalized prompt framework and shortcut suite for Apple devices that replaces Siri with ChatGPT. `#paid`

**[⬆️ Back to Top](#table-of-contents)**

## Fashion

- [Artificial Printer](https://artificialprinter.com/) - Print personalized t-shirts. `#free`
- [Dressrious](https://www.dressrious.com/) - Offers personalized daily outfit recommendations based on users' wardrobe items, weather conditions, occasions, and color preferences. `#free`

**[⬆️ Back to Top](#table-of-contents)**

## Finance

- [BeeBee AI](https://www.beebee.ai/) - Financial reports and earnings calls become easily understandable with key insights for everyday investors. `#free`
- [Coinfeeds](https://chat.coinfeeds.io/) - Your Crypto Chatbot Companion, ask it anything! `#free`
- [Durable](https://durable.co/) - Build a website in 30 seconds with AI, leveraging AI-powered design and marketing tools to boost traffic and increase revenue. `#freemium`
- [EarningsEdge](https://www.earningsedge.ai/) - Gain the Edge in Competitive Investing `#freemium`
- [HoopsAI](https://www.hoopsai.com/) - Offers real-time trading insights and analysis for retail investors. `#free`
- [Uptrends.ai](https://app.uptrends.ai/trending) - The first AI stock market news monitoring platform made for DIY investors. Uptrends.ai analyzes chatter to help you find the trends & events that matter. `#paid`

**[⬆️ Back to Top](#table-of-contents)**

## Fitness

- [Alpa AI](https://www.alfa-ai.com/) - To train the right way without depending on anyone but their self-anytime, everywhere. `#freemium`
- [Hypereficient](https://hyperficient.org/) - Optimizes workout routines for maximum muscle gain in less time. `#free`
- [PPLEGPT](https://pplegpt.vercel.app/) - Your next exercise in seconds `#free`
- [Sista.AI](https://sista.ai/fitness-coach) - Personalized workout plans, goal setting, nutrition coaching, injury prevention, mind-body connection, and ongoing support to help you achieve your fitness goals. `#paid`
- [Zing Coach](https://zing.body.scan.zingproduction.com/) - AI-powered fitness tool, streamlines the process of evaluating fitness levels `#free`
- [Coachify](https://coachify.ai/) - Your Personalized Fitness Coach Powered by AI `#paid`


**[⬆️ Back to Top](#table-of-contents)**

## Fun Tools

- [BabbleBox](https://babblebox.ai/) - AI tool that enhances conversational experiences by emulating human-like conversations `#free`
- [ComicifyAI](https://comicify-ai.vercel.app/) - Turn Text into Captivating Comics with ComicifyAI `#free`
- [Convenient Hairstyle](https://hairstyle.cvhtechnology.com/) - Transform Your Look with Personalized Hairstyle Exploration `#free`
- [Dream Interpreter](https://dreaminterpreter.ai/) - Dream interpreter using GPT-3 `#free`
- [GreenThumb](https://www.messengerx.io/greenthumb) - Unlock the World of Gardening with Your AI Companion `#free`
- [SomniAI](https://somniai.com/) - Offers accurate and personalized interpretations of dreams in seconds. `#free`

**[⬆️ Back to Top](#table-of-contents)**

## Gaming

- [Booom.ai](https://joinplayroom.com/games/booom/) - Generate a trivia game using AI `#free`

**[⬆️ Back to Top](#table-of-contents)**

## General Writing

- [AIEpics](https://aiepics.com/) - Generates unique and copyright-free poems based on user-entered prompts. #opensource `#free`
- [Free Essay Generator](https://academichelp.net/free-essay-generator/) - Assists students and writers in creating high-quality essays effortlessly. `#free`
- [Incribo](https://incribo.com/) - Your AI Writing Companion. `#paid`
- [QuillBot](https://quillbot.com/) - An AI writing assistance, paraphrasing tool, Plagiarism Checker, Citation generator `#free`
- [StealthGPT](https://www.stealthgpt.ai/) - Generates undetectable AI Content avoiding plagiarism issues. `#paid`


**[⬆️ Back to Top](#table-of-contents)**

## Gift Ideas

- [AICardshop](https://www.aicardshop.com/) - Online platform for unique and personalized AI-generated art gifts for special occasions `#free`
- [Almowafir](https://almowafir.com/en/gift-hunter/) - Almowafir AI Gift Hunter finds the best gift for you `#free`
- [Botsy AI](https://botsy.ai/) - Recommends top-rated gifts from Amazon.com based on the recipient's interests and preferences. `#free`
- [Cool Gift Ideas](https://www.coolgiftideas.io/) - Find the perfect gift for anyone with creative ideas tailored to them. `#free`
- [DreamGift](https://dreamgift.ai/) - Discover personalized and unique gift ideas for every occasion. `#free`
- [Elf Help](https://www.elfhelp.ai/) - Free personalized gifting ideas for everyone on your list. `#free`
- [Giftassistant](https://www.giftassistant.io/) - Giftassistant.io is an AI-powered tool that quickly generates personalized gift ideas for any occasion. `#free`
- [Giftastic.ai](https://giftastic.ai/) - Personalized, unique and thoughtful gift recommendations `#free`
- [Giftbox](https://www.giftbox.co/) - Personalised gift recommendation for any occasion `#free`
- [Giftgenie AI](https://www.giftgenie.ai/) - Gift Genie AI is an AI-powered tool that assists users in finding the perfect gift for their recipient by generating personalized gift recommendations based on a brief description. `#free`
- [Gifts Genie](https://gen.gifts/) - Genie takes the stress out of gift-giving with AI-powered birthday gift ideas. `#free`
- [Gift Ideas AI](https://www.giftideasai.xyz/) - Provides personalized gift recommendations based on recipients' interests, age, gender, and occasions, making gift-giving effortless and enjoyable. `#free`
- [GiftHuntr](https://gifthuntr.com/) - GIft Giver powered by AI `#free`
- [Gift Matchr](https://giftmatchr.com/) - Your personal AI gift Assistant `#free`
- [Giftmethat](https://www.giftmethat.io/) - Revolutionizing Gift-Giving : GiftMeThat's AI-Powered Platform `#free`
- [Imajinn.ai](https://imajinn.ai/portrait) - Imajinn AIP's AI Couple Portrait Canvas is a one-of-a-kind and romantic way to immortalize your love. `#paid`
- [Intelli Gift](https://intelli.gift/) - Gift smarter with intelli.gift - The AI-powered gift advisor `#free`
- [Lazy Cards](https://lazy.cards/) - Lazy Cards is a convenient and thoughtful service that offers AI-written greeting cards for various occasions `#free`
- [Magic Type AI](https://www.magictype.ai/) - Write greetings, poetry and rap lyrics using AI. `#free`
- [Outdone](https://www.outdone.io/) - Outdone is a gift recommender that simplifies the process of shopping for special occasions `#free`
- [Perfectgift](https://perfectgift.ai/) - PerfectGift.AI is an AI-powered tool that generates personalized gift ideas for any occasion by utilizing advanced Artificial Intelligence algorithms. `#free`
- [Santa AI](https://www.santa.artflow.ai/) - Create your own unique Santa video greeting `#free`
- [Silly Robot Cards](https://www.sillyrobotcards.com/) - Customized greeting card design with unique touch. `#paid`
- [Smart Gift AI](https://smartgiftai.com/) - AI-powered gifting platform `#free`
- [Snappy](https://snappygifts.com/home) - Send personalized choices—for any budget or occasion, now or later—and let the recipient pick the gift they want.`#free`
- [Spread Positivity Today](https://spreadpositivitytoday.com/) - Send a Note. Spread Joy. `#free`
- [Text2present](https://text2present.com/) - Text2present.com is an AI-powered tool that enables users to effortlessly create customized presents for their friends, family, and acquaintances. `#free`
- [Write-a-card](https://write-a-card.co/) - Content generation for greeting cards. `#paid`
- [Your GiftWhisperer](https://yourgiftwhisperer.com/) - Discover the perfect personlized Gift! `#free`

**[⬆️ Back to Top](#table-of-contents)**

## HealthCare

- [Enlitic](https://enlitic.com/) - an AI-driven application that lets you transform big data into relevant insights that can help you make more accurate, strategic, and timely decisions. `#paid`
- [MIRI](https://www.miri.health/) - Comprehensive Wellness Platform That Puts Experts in Your Pocket 24/7 `#free` 
- [Viz.AI](https://www.viz.ai/) - Offers a wide range of features to help healthcare professionals run their operations more efficiently and accurately. `#paid`

**[⬆️ Back to Top](#table-of-contents)**

## Human Resources

- [Cover Letter Copilot](https://coverlettercopilot.ai/) - Your AI-Powered Cover Letter Generator `#freemium`
- [Deepbrain AI](https://www.deepbrain.io/) - Innovate HR Process with AI Interview. `#paid`
- [ZapHire](https://www.zap-hire.com/) - AI-Powered Recruitment for Data-Driven Hiring. `#free`

**[⬆️ Back to Top](#table-of-contents)**

## Image Classification

- [AI or NOT](https://www.aiornot.com) - Determine whether an image has been generated by artificial intelligence or a human `#free`

**[⬆️ Back to Top](#table-of-contents)**

## Image Editing

- [AIPhotoeditor](https://photoeditor.ai/) - AIPhotoeditor is a free photo editor that allows users to remove unwanted objects, people, blemishes, or text from their images in seconds. `#free`
- [Image Candy](https://imgcandy.com/) - Online Image Editor - Image Candy `#free`
- [Photostockeditor](https://photostockeditor.com/tools/socialmedia-resize) - Intelligence Image Crop/Resize: Perfectly Tailored Social Media Images `#free`

**[⬆️ Back to Top](#table-of-contents)**

## Image Generator

- [AI Passport Photo](https://aipassportphoto.com/) - Take A Photo with Your Mobile Phone and Get Your Passport Photo in Seconds. `freemium`
- [Bing Image Creator](https://www.bing.com/images/create) - Image Creator from Microsoft Designer allows you to generate captivating images based on your words using AI. `freemium`
- [GenPictures](https://www.getconverse.com/pics) - Create stunning AI art, images, and pictures in seconds for free with GenPictures. Turn your text into visual masterpieces effortlessly. `freemium`
- [Ideaogram](https://ideogram.ai/t/trending) - This tool helps us to generate text in an image `#free`
- [ImageCreator](https://imagecreator.alkaidvision.com/) - A Professional PS plug-in powered by AI `#free`
- [Imagine](https://www.imagine.art) - Text to image with AI Art Generator `#freemium`
- [Ipic.ai](https://www.ipic.ai/) - Ipic.ai is a free AI image generator that can effortlessly create unique AI art. `#free`
- [Kaiber](https://kaiber.ai/) - Tell stories like never before with our advanced AI generation engine `#freemium`
- [Leonardo](https://leonardo.ai) - Text-to-image Create production-quality visual assets for your projects with unprecedented quality, speed, and style-consistency `#free`
- [MergeML](https://mergeml.com/) - Lightning Fast Image Generation `#free`
- [Midjourney AI](https://www.midjourneyai.ai/) - Just enter your prompt and click the generate button.No code required to generate your image!
- [Novita.ai](https://novita.ai/) - Novita is your go-to solution for fast and affordable AI image generation. `#paid`
- [Picsart](https://picsart.com/ai-image-generator/) - Convert words into an image in mere seconds with the Picsart AI Image Generator. `#freemium`
- [pica-ai](https://www.pica-ai.com/) - Experience funny or realistic face swapping effects. Begin by uploading your photo!. `freemium`
- [Playground AI](https://playground.com/) - Free-to-use online tool to create art, social media posts, presentations, posters, videos, logos and more. `#free`
- [Remaker-Ai](https://remaker.ai/en) - All-in-one tool leveraging the capabilities of artificial intelligence. Craft and produce diverse content formats, spanning text, images, and beyond.`#free`
- [removebg](https://remove.bg/) - Remove any Image Background `#free`
- [Rentoor](https://rentoor.vercel.app) - Enhance your images with Rentoor's super-resolution feature, restoring clarity and detail for stunning visuals. `freemium`
- [Stable Diffusion Online](https://stablediffusionweb.com/#ai-image-generator) - text-to-image diffusion model capable of generating photo-realistic images given any text input, cultivates autonomous freedom to produce incredible imagery, empowers billions of people to create stunning art within seconds. `#opensource`
- [stockimg.ai](https://stockimg.ai/) - Stockimg is an all in one design and content creation tool powered by AI. You can easily generate logo, illustration, wallpaper, poster and more. `#freemium`
- [Top VS Best](https://topvsbest.com/aiimagecreator/) - Effortlessly craft mesmerizing and exclusive images through our AI-powered image generation. `#free`
- [Wepik AI](https://wepik.com/ai) - Text to Image Converter `#free`
- [Zoo](https://zoo.replicate.dev/) - Text-to-Image Playground `#free`

**[⬆️ Back to Top](#table-of-contents)**

## Interior Designing

- [AI Room Planner](https://airoomplanner.com/) - Get hundreds of interior design ideas for your room - free with no limit. `#free`

**[⬆️ Back to Top](#table-of-contents)**

## Legal Assistant

- [Casetext](https://casetext.com/) - an award-winning legal AI company developing cutting-edge tech for 10+ years. `#paid`
- [DoNotPay](https://donotpay.com/) - DoNotPay is an online legal service and chatbot. `#paid`
- [Latch](https://www.latchapp.com/) - Latch helps legal teams reduce the time, effort, and cost spent towards negotiating agreements. `#paid`

**[⬆️ Back to Top](#table-of-contents)**

## Logo Generator

- [LogoAi](https://www.logoai.com/logo-maker) - AI-powered logo maker and online design tool. `#freemium`
- [Placeit](https://placeit.net/) - user-friendly design platform that can be used to create logos, mockups, and videos. `#paid`
- [Zarla](https://www.zarla.com/) - Zarla uses AI to generate unique logo designs through various prompts. `#free`
- [Looka](https://looka.com/) - Use Looka's AI-powered platform to design a logo and build a brand you love. `#free`

**[⬆️ Back to Top](#table-of-contents)**

## Low Code

- [LoginLlama](https://loginllama.app/) - Enhance Security with LoginLlama's Suspicious Login Detection `#freemium`
- [Luminal](https://www.csv-gpt.com/) - Clean, transform and analyze spreadsheets at lightspeed with AI `#freemium`
- [Xero.AI](https://www.xerodotai.com/) - No-Code AI Platform for Simplified Machine Learning `#paid`

**[⬆️ Back to Top](#table-of-contents)**

## Models

- [AI/ML API](https://aimlapi.com) - One API, 100+ AI Models, Accessible 24/7. `#opensource``#freemium``#paid`
- [Bloom](https://huggingface.co/docs/transformers/model_doc/bloom) - BLOOM by Hugging Face is a model similar to GPT-3
- [Claude 2](https://claude.ai/) - Talk to Claude, an AI assistant from Anthropic. `#paid`
- [Gopher](https://www.deepmind.com/blog/language-modelling-at-scale-gopher-ethical-considerations-and-retrieval) - Gopher by DeepMind is a 280 billion parameter language model. `#free`
- [LiteLLM](https://litellm.ai/) - An open-source library to simplify LLM completion + embedding calls. `#free` `#opensource`
- [LLaMA](https://ai.facebook.com/blog/large-language-model-llama-meta-ai/) - A foundational, 65-billion-parameter large language model by Meta. `#opensource` `#free`
- [LLaVA](https://llava-vl.github.io/) - Large Language and Vision Assistant #opensource `#free`
- [Llama 2](https://ai.meta.com/llama/) - The next generation of Meta's open source large language model. `#opensource` `#free`
- [OpenAI API](https://openai.com/api/) - OpenAI's API provides access to GPT-3 and GPT-4 models, which performs a wide variety of natural language tasks, and Codex, which translates natural language to code. `#freemium`
- [OPT](https://opt.alpa.ai/) - Open Pretrained Transformers (OPT) by Facebook is a suite of decoder-only pre-trained transformers. `#opensource` `#free`
- [Qwen](https://github.com/QwenLM/Qwen) - Pretrained large language model proposed by Alibaba Cloud. `#free`
- [Vicuna-13B](https://lmsys.org/blog/2023-03-30-vicuna/) - An open-source chatbot trained by fine-tuning LLaMA on user-shared conversations collected from ShareGPT. `#free`

**[⬆️ Back to Top](#table-of-contents)**

## Music

- [Riffusion](https://www.riffusion.com/) - Create music from text with styles, instruments, modifiers and genres. `#free`

**[⬆️ Back to Top](#table-of-contents)**

## Paraphraser

- [Better Synonyms](https://www.bettersynonyms.com/) - A convenient way to find better synonyms for words in a specific context. `#free`
- [Franz AI](https://chrome.google.com/webstore/detail/franz-ai-text-rewriter/lclcncbdhfpolppomniofbkiaaebaefg) - A Chrome extension to rewrite text using OpenAI API. `#free`
- [Penelope AI](https://penelope-ai.vercel.app/) - Speed up writing with paraphrasing, summarizing and story generation `#paid`
- [Quillbot Paraphraser](https://try.quillbot.com/) - Rewrite text for free. `#freemium`
- [Rewriteit AI](https://rewriteit.ai/) - Rewrite with Confidence: Enhance Your Writing with AI Technology `#free`
- [StudyCrumb](https://studycrumb.com/paraphrasing-tool) - This essay rephraser can change the wording of any content `#free`

**[⬆️ Back to Top](#table-of-contents)**

## Personal Assistant

- [ChatGPT Sidebar](https://chatgpt-sidebar.com/) - AI & you work side by side on any page `#free`
- [Pathfinder](https://www.summit.im/pathfinder/) - Pathfinder, brought to you by Summit, is an innovative AI-driven tool designed to assist individuals in creating personalized plans and strategies to achieve their goals. `#free`

**[⬆️ Back to Top](#table-of-contents)**

## Presentations
- [gamma.app](https://gamma.app) - Gamma is a new platform that allows users to create polished documents, presentations, and webpages in seconds using AI. `freemium`
- [Journey.io](https://journey.io/) - Journey.io is a storytelling platform that enables users to create interactive presentations, combining videos, slides, text, and embeds to captivate their audience. `#freemium`
**[⬆️ Back to Top](#table-of-contents)**

## Productivity

- [40h](https://40h.io/) - Map your career path and unlock your potential with the guidance of 40h. `#paid`
- [Accountabilabuddy](https://www.summit.im/accountabilabuddy) - Sends simple text reminders to help you stay on track and achieve your objectives. `#free`
- [DigestDiff](https://www.digestdiff.com/) - Codebase Insights Without Code Access with DigestDiff `#free`
- [Glimpse](https://glimpse.surf/) - Seamless browsing experience with conversation, writing, and editing assistance `#free`
- [Happy Copy](https://www.hoppycopy.co/) - Use AI to create powerful content for hundreds of different email campaigns, drips, newsletters and more—in seconds
- [Message AI](https://apps.apple.com/us/app/message-ai-gpt-tts/id6448740961) - Transform Text to Speech with Natural Accuracy `#paid`
- [Notion](https://www.notion.so/product/ai/) - Access the limitless power of AI, right inside Notion. Work faster. Write better. Think bigger. `#paid`
- [Posylanki](https://www.posylanki.live/) - Streamline Web Content Management & Enhance Browsing Experience `#free`
- [Releases Notes](https://www.releasesnotes.dev/) - Effortless Release Notes with Automation. `#free`
- [Scribot](https://play.google.com/store/apps/details?id=com.scribot.app) - Efficient Note-Taking with AI `#free`
- [Supermanage AI](https://supermanage.ai/) - Effortless prep for your 1-on-1 `#free`
- [Taskade](https://www.taskade.com/) - Taskade elegantly unifies your team tasks, notes, and mind, stripping away the noise to reveal the essence of productivity. `#freemium`
- [Uizard](https://uizard.io) - With this AI tool you can create a beautiful website and app `paid`

**[⬆️ Back to Top](#table-of-contents)**

## Prompt Generator

- [Geniea](https://geniea.com/) - Generated prompts for personal journeys. `#free`
- [PromptFolder](https://promptfolder.com/) - Allows users to create, save, and explore innovative prompts with features like variables, organization, and sharing. `#free`

**[⬆️ Back to Top](#table-of-contents)**

## Psychology

- [Selfgazer](https://www.selfgazer.com/) - Provides psychological tarot readings for users seeking self-exploration and personal insights through classic tarot symbolism. `#free`

**[⬆️ Back to Top](#table-of-contents)**

## Real Estate

- [HomeByte](https://homebyte.com/) - Find your dream home with the most advanced home search on the planet. `#free`
- [IACrea](https://iacrea.com/) - AI-powered Home Staging Solution `#paid`
- [InteriorAI](https://interiorai.com/) - Interior design ideas using Artificial Intelligence `#paid`
- [RealtyNinja](https://get.realtyninja.com/ai-listing-description-generator) - AI Listing Description Generator `#free`
- [RealtyGenius](https://realtygenius.ai/) - Offers efficient document management and collaboration functionalities for real estate professionals. `#freemium`
- [VirtualStagingAI](https://www.virtualstagingai.app/) - Virtually stage in one click `#paid`
- [Virtual House Flip](https://www.virtualhouseflip.com/) - Remodel homes using AI for stunning results `#paid`
- [Write.homes](https://write.homes/) - The ultimate real estate content creation tool `#free`
- [VSDECO](https://vsdeco.com/) - Transform Your Space with Photorealistic Restyling `#paid`

**[⬆️ Back to Top](#table-of-contents)**

## Religion

- [AstroGPT](https://vedicastrogpt.com/) - AstroGPT is a personalized astrology service that provides expert guidance for love, career, and more. `#free`
- [Gita GPT](https://www.gitagpt.in/) - Unlock the Power of AI with the Bhagavad Gita `#free`
- [Tarteel](https://www.tarteel.ai/) - Tarteel is an AI-powered Quran companion that helps users improve their recitation and memorization skills by providing real-time feedback, highlighting words, offering translations, and customizable challenges. `#paid`
- [Text With Jesus](https://textwith.me/jesus) - Enlightening conversations and a deeper connection to revered biblical figures. `#freemium`

**[⬆️ Back to Top](#table-of-contents)**

## Research

- [Lime AI](https://www.datalimeai.com/) - AI-powered research assistant for data-related tasks, designed to streamline and simplify data research and analysis processes. `#paid`

**[⬆️ Back to Top](#table-of-contents)**

## Resume

- [LoopCV](https://www.loopcv.pro/) - Upload your CV, Select the type of Job You Want, and Press Start! Loopcv will Mass Apply on your behalf Every Single Day `#freemium`
- [resumA.I.](https://www.resumai.com/) - resumA.I. is a next generation intelligent resume builder for enabling more effective job applications `#freemium`
- [Resume AI Scanner](https://pdf.ai/tools/resume-ai-scanner) - Assists in assessing candidates by scanning their resumes, extracting relevant information, and generating questions to evaluate their suitability for a position. `#free`

**[⬆️ Back to Top](#table-of-contents)**

## Sales

- [Sellesta](https://sellesta.com/marketplace/) - Revamp your Amazon business with Sellesta AI tools! Keyword Research, Listing Optimization, and Keyword Tracking. Start Free Now! `#freemium`

**[⬆️ Back to Top](#table-of-contents)**

## Search Engine

- [Andi](https://andisearch.com/) - Andi is a generative AI-powered search engine `#free`
- [Anse](https://anse.app/) - Your Elegant AI Answer Companion `#paid`
- [GPTGO](https://googpt.ai/) - ChatGPT combined with Google search `#free`
- [Hai News](https://hai.news/) - Search with generative AI - Hai News `#free`
- [Opera One Browser](https://www.opera.com/one) - Opera One offers a liquid navigation experience with a focus on modular design and AI-powered web services. `#free`

**[⬆️ Back to Top](#table-of-contents)**

## SEO

- [Adaptify](https://www.adaptify.ai/) - Empower Business Success with AI-Powered ChatGPT `#paid`
- [AutoBlogging Pro](https://autoblogging.pro/) - AI-Powered Content Automation for WordPress Blogs `#freemium`
- [Frase](https://www.frase.io/) - Content optimization tool that helps businesses create SEO-friendly content quickly and easily. `#paid`
- [Surfer SEO](https://surferseo.com/) - SEO tool that helps users optimize their content for better search engine rankings. `#paid`
- [GrowthBar](https://www.growthbarseo.com/) - SEO tool designed to help marketers, bloggers, and content teams create SEO-friendly content. `#paid`

**[⬆️ Back to Top](#table-of-contents)**

## Shopping

- [Shop Guru AI](https://www.shopguru.io/) - Analyze customer reviews, providing you with trusted answers based on specific product information. `#free`

**[⬆️ Back to Top](#table-of-contents)**

## Social Media

- [Piggy Magic](https://piggy.to/magic) - Piggy Magic - Social Story Maker `#free`
- [StoriAI](https://storiai.com/) - Elevate Your Brand's Social Presence with StoriAI `#paid`

**[⬆️ Back to Top](#table-of-contents)**

## Spreadsheets

- [AI Excel Bot](https://aiexcelbot.com) - Write Excel and Google Sheets Formulas Faster With AI `#freemium`
- [Arcwise AI](https://arcwise.app/ai) - AI Copilot for Spreadsheets `#free`
- [CSV-GPT](https://www.csv-gpt.com/) - Enables users to ask natural language questions about their data and receive instant analysis and insights. `#free`
- [DataDistillr](https://datadistillr.com/) - Integrating your data has never been easier. `#paid`
- [Dataspot](https://dataspot.ai/) - Understand any data instantly using AI `#freemium`
- [Excel Formula Bot](https://excelformulabot.com/) - Create Excel formulas in seconds with AI-powered formula generators. `#freemium`
- [GPTExcel](https://gptexcel.uk/) - Effortlessly create and understand formulas in Excel and Google Sheets! `#paid`
- [Parseur](https://parseur.com/) - Parseur is a powerful data entry software that automates text extraction from emails, PDFs, and other documents, enhancing productivity by eliminating manual data entry. `#freemium`
- [SheetAI.app](https://sheetai.app/) - AI-powered tool to quickly generate formulas for Google Sheets. `#freemium`
- [SheetGod](https://www.boloforms.com/sheetgod/) - Effortlessly create and understand formulas in Excel and Google Sheets! `#paid`

**[⬆️ Back to Top](#table-of-contents)**

## SQL

- [Airops](https://www.airops.com/) - Task-specific AI Apps that go beyond Chat-GPT—run NLP, generate-data-informed content, draft/fix/optimize SQL queries, and more `#free`
- [QueryCraft](https://www.querycraft.io/) - AI-Powered Data Query Generator `#free`
- [dbdiagram.io](https://dbdiagram.io/home) - It's an online AI-Powered database diagram design tool that allows you to visually create and edit database schemas `#free`

**[⬆️ Back to Top](#table-of-contents)**

## Startup Tools

- [ClickUp](https://clickup.com/) - All of your work in one place: Tasks, Docs, Chat, Goals, & more. `#free`
- [Cookup.ai](https://cookup.ai/) - AI apps for every usecase `#free`
- [DeskDay](https://deskday.ai/) - Revolutionizing IT Support for MSPs `#paid`
- [Jasper AI](https://www.jasper.ai/) - Jasper is an AI copilot for enterprise marketing teams. `#paid`
- [Namelix](https://namelix.com/) - Generate short, brandable business names & domain names. `#free`
- [Olympia](https://olympia.chat) - AI-powered virtual staffing tool tailored for solopreneurs and bootstrapped startups. `#paid`
- [Rasgo](https://www.rasgoml.com/) - Your Self-Service AI Analytics Revolution `#free`
- [Sidekick](https://www.jigso.io/lp-sidekick) - Get answers from your apps using natural language. `#free`

**[⬆️ Back to Top](#table-of-contents)**

## Story Teller

- [AI Storyboard Generator](https://boords.com/) - Eliminates the need for drawing skills, enabling quick and easy storyboard creation. `#paid`
- [Plot Factory](https://plotfactory.com/) - An online collaborative story planner that lets writers plan, organize, and write stories & fictional universes. `#paid`
- [Sudowrite](https://www.sudowrite.com/) - The model generates text by guessing what's most likely to come next, one word at a time. Kind of like autocomplete on your phone. `#paid`
- [Tome](https://beta.tome.app/) - Unlock your best work with AI-powered generative storytelling from Tome. `#free`

**[⬆️ Back to Top](#table-of-contents)**

## Summarizer

- [ChatGPT Summary Assistant](https://chrome.google.com/webstore/detail/chatgpt-summary-assistant/nnjcoododbeemlmmhbfmmkbneniepaog) - Free AI-Powered Chrome Extension for Instant Article Summaries `#free`
- [ChatPulse](https://chatpulse.dev) -ChatPulse allows you to have conversations with any PDF document. Simply upload your file and start asking questions right away!. `#freemium`
- [Earkind](https://www.earkind.com/) - AI-Generated Podcasts on AI Topics `#free`
- [LeaseLens](https://leaselens.ai/) - Automate the extraction of crucial data points from real estate and commercial lease documents `#free`
- [Neural Times](https://www.neuraltimes.org/) - Your Unbiased AI-Powered News Source `#free`
- [Quill](https://apps.apple.com/us/app/quill-news-digest/id1669557131) - The AI Way to Stay Informed `#free`
- [Recall](https://www.recall.wiki/) - Summarize YouTube videos, blog posts, PDFs, articles or any other online content. `#freemium`
- [Too Long](https://toolongapp.com/) - Your Article Summarization Companion `#free`


**[⬆️ Back to Top](#table-of-contents)**

## Testing

- [Keploy](https://www.keploy.io/) - A  developer-centric backend testing tool which makes backend tests with built-in-mocks faster than unit tests, from user traffic, making it easy to use, powerful, and extensible. `#opensource`

**[⬆️ Back to Top](#table-of-contents)**

## Text to Speech

- [Dubverse](https://dubverse.ai/text-to-speech/) - AI-powered text-to-speech with Dubverse is accurate, real, and fast! Type, paste, or upload a document & convert text to speech for free. `#freemium`
- [ElevenLabs](https://elevenlabs.io/) - AI-powered text-to-speech and voice cloning technology.`#freemium`

**[⬆️ Back to Top](#table-of-contents)**

## Text to Image

- [FollowFox](https://followfox.ai/) - Open-source text-to-image generator with impressive features and capabilities. `#free`

**[⬆️ Back to Top](#table-of-contents)**

## Transcriber

- [AI Transcription by Riverside](https://riverside.fm/transcription) - Video and audio transcription `#free`
- [HappySRT](https://www.happysrt.com/) - Generate SRT Files for youtube using AI Technology `#freemium`
- [PodPilot](https://www.podpilot.ai/) - PodPilot is an AI tool designed to simplify the process of creating high-quality podcast series for organizations `#paid`
- [VideoToBlog](https://www.videotoblog.ai/) - Convert YouTube videos to blog content in one click `#free`

**[⬆️ Back to Top](#table-of-contents)**

## Travel

- [PLAN by Ixigo](https://www.ixigo.com/) - Your AI-Powered Travel Planning Companion `#free`
- [Roam Around](https://www.roamaround.io/) - Find interesting and fun places to visit `#free`
- [Travelnaut](https://travelnaut.com/) - Find travel information on attractions, food, culture, and more in one place to prepare the next trip of your dreams `#free`
- [WanderGenie](https://www.wandergenie.app/) - Transform the way you explore the world. `#free`
- [WonderPlan](https://wonderplan.ai/) - Your personal trip planner and travel curator, creating custom itineraries tailored to your interests and budget. `#free`
- [Famxplor](https://famxplor.com/) - Find activities for your family vacations worldwide. `#paid`

**[⬆️ Back to Top](#table-of-contents)**

## Video Editing

- [FineShare FineCam](https://www.fineshare.com/finecam/) - Transform your video calls and recordings with FineShare FineCam's advanced capabilities `#paid`
- [Thumbnail Ai](https://thumbnail-ai.ybouane.com/) - Will provide reviews of youtube thumbnails using AI `#free`

**[⬆️ Back to Top](#table-of-contents)**

## Video Generator

- [Chromox](https://chromox.alkaidvision.com/) - Transforming Ideas into Visual Stories. `#free`
- [D-ID](https://www.d-id.com/) - D-ID is a platform to generate videos. `#freemium`
- [FabDream AI](https://www.fabdream.art/) - Discover the world of Ai digital art through the lens of Swiss-based artist Fabio Comparelli aka fabdream. Immerse yourself in visually stunning Quality videos. `#freemium`
- [Fliki.ai](https://fliki.ai/) - Your AI partner for video creation. Create a video from text, voice or image. `#freemium`
- [Heygen](https://www.heygen.com/) - Create videos from text in minutes with AI-generated avatars and voices. `#freemium`
- [Invideo](https://invideo.io/) - InVideo simplifies video creation with ready-made templates. `#freemium`
- [Pictory AI](https://pictory.ai/) - Pictory AI is a video creation tool that makes it effortless to produce short videos from your long-form content like scripts, posts `#paid`
- [pika.art](https://pika.art/) - An idea-to-video platform that brings your creativity to motion. `#freemium`
- [Quickads](https://www.quickads.ai/) - AI Ad Creation Platform for all your Ad Campaigns. `#freemium`
- [Runway](https://runwayml.com/) - With Runway AI, you have the power to create videos using text prompts in so many incredible ways `#free`
- [Syllaby.io](https://ai.syllaby.io) - AI Video Script Generator, Syllaby shows you how to create a content strategy for social media in minute `paid`
- [Vidnoz](https://www.vidnoz.com/) - Use Vidnoz AI and Vidnoz Flex to make winning videos! `#freemium`

**[⬆️ Back to Top](#table-of-contents)**

## Writing Generator

- [Bidlytics](https://www.bidlytics.co/) - Master the Art of Government Contracting `#freemium`
- [Free Essay Generator](https://academichelp.net/free-essay-generator/) - Assists students and writers in creating high-quality essays effortlessly. `#free`

**[⬆️ Back to Top](#table-of-contents)**

## Weather

- [Atmo Global Forecast](https://earth.atmo.ai/) - Precision Weather Forecasting with AI `#free`

**[⬆️ Back to Top](#table-of-contents)**

## Other Resources

**[⬆️ Back to Top](#table-of-contents)**

# License
[![FOSSA Status](https://app.fossa.com/api/projects/git%2Bgithub.com%2FHyraze%2Fai-collective-tools.svg?type=large)](https://app.fossa.com/projects/git%2Bgithub.com%2FHyraze%2Fai-collective-tools?ref=badge_large)

# Contributors

<a href="https://github.com/Hyraze/ai-collective-tools/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=Hyraze/ai-collective-tools" />
</a>
