#include "client_lua_api.h"

#include "../input/input_state.h"
#include <SFML/Window/Keyboard.hpp>
#include <common/lua/script_engine.h>

namespace {
    void initMouseControlApi(sol::table& inputTable, sf::Window& window,
                             InputState& inputState)
    {
        inputTable["hideMouse"] = [&window, &inputState]() {
            window.setMouseCursorVisible(false);
            inputState.isMouseLocked = true;
        };
        inputTable["showMouse"] = [&window, &inputState]() {
            window.setMouseCursorVisible(true);
            inputState.isMouseLocked = false;
        };
    }

    void initKeysApi(ScriptEngine& scriptEngine);
} // namespace

void luaInitInputApi(ScriptEngine& scriptEngine, sf::Window& window,
                     InputState& inputState)
{
    auto inputTable = scriptEngine.addTable("input");
    initMouseControlApi(inputTable, window, inputState);
    initKeysApi(scriptEngine);
}

namespace {
    void initKeysApi(ScriptEngine& scriptEngine)
    {
        // Don't worry, this code is generated by a python script lol
        auto keys = scriptEngine.addTable("Keyboard");
        keys["A"] = sf::Keyboard::A;
        keys["B"] = sf::Keyboard::B;
        keys["C"] = sf::Keyboard::C;
        keys["D"] = sf::Keyboard::D;
        keys["E"] = sf::Keyboard::E;
        keys["F"] = sf::Keyboard::F;
        keys["G"] = sf::Keyboard::G;
        keys["H"] = sf::Keyboard::H;
        keys["I"] = sf::Keyboard::I;
        keys["J"] = sf::Keyboard::J;
        keys["K"] = sf::Keyboard::K;
        keys["L"] = sf::Keyboard::L;
        keys["M"] = sf::Keyboard::M;
        keys["N"] = sf::Keyboard::N;
        keys["O"] = sf::Keyboard::O;
        keys["P"] = sf::Keyboard::P;
        keys["Q"] = sf::Keyboard::Q;
        keys["R"] = sf::Keyboard::R;
        keys["S"] = sf::Keyboard::S;
        keys["T"] = sf::Keyboard::T;
        keys["U"] = sf::Keyboard::U;
        keys["V"] = sf::Keyboard::V;
        keys["W"] = sf::Keyboard::W;
        keys["X"] = sf::Keyboard::X;
        keys["Y"] = sf::Keyboard::Y;
        keys["Z"] = sf::Keyboard::Z;
        keys["Num0"] = sf::Keyboard::Num0;
        keys["Num1"] = sf::Keyboard::Num1;
        keys["Num2"] = sf::Keyboard::Num2;
        keys["Num3"] = sf::Keyboard::Num3;
        keys["Num4"] = sf::Keyboard::Num4;
        keys["Num5"] = sf::Keyboard::Num5;
        keys["Num6"] = sf::Keyboard::Num6;
        keys["Num7"] = sf::Keyboard::Num7;
        keys["Num8"] = sf::Keyboard::Num8;
        keys["Num9"] = sf::Keyboard::Num9;
        keys["Escape"] = sf::Keyboard::Escape;
        keys["LControl"] = sf::Keyboard::LControl;
        keys["LShift"] = sf::Keyboard::LShift;
        keys["LAlt"] = sf::Keyboard::LAlt;
        keys["LSystem"] = sf::Keyboard::LSystem;
        keys["RControl"] = sf::Keyboard::RControl;
        keys["RShift"] = sf::Keyboard::RShift;
        keys["RAlt"] = sf::Keyboard::RAlt;
        keys["RSystem"] = sf::Keyboard::RSystem;
        keys["Menu"] = sf::Keyboard::Menu;
        keys["LBracket"] = sf::Keyboard::LBracket;
        keys["RBracket"] = sf::Keyboard::RBracket;
        keys["Semicolon"] = sf::Keyboard::SemiColon;
        keys["Comma"] = sf::Keyboard::Comma;
        keys["Period"] = sf::Keyboard::Period;
        keys["Quote"] = sf::Keyboard::Quote;
        keys["Slash"] = sf::Keyboard::Slash;
        keys["Backslash"] = sf::Keyboard::BackSlash;
        keys["Tilde"] = sf::Keyboard::Tilde;
        keys["Equal"] = sf::Keyboard::Equal;
        keys["Dash"] = sf::Keyboard::Dash;
        keys["Space"] = sf::Keyboard::Space;
        keys["Enter"] = sf::Keyboard::Return;
        keys["BackSpace"] = sf::Keyboard::BackSpace;
        keys["Tab"] = sf::Keyboard::Tab;
        keys["PageUp"] = sf::Keyboard::PageUp;
        keys["PageDown"] = sf::Keyboard::PageDown;
        keys["End"] = sf::Keyboard::End;
        keys["Home"] = sf::Keyboard::Home;
        keys["Insert"] = sf::Keyboard::Insert;
        keys["Delete"] = sf::Keyboard::Delete;
        keys["Add"] = sf::Keyboard::Add;
        keys["Subtract"] = sf::Keyboard::Subtract;
        keys["Multiply"] = sf::Keyboard::Multiply;
        keys["Divide"] = sf::Keyboard::Divide;
        keys["Left"] = sf::Keyboard::Left;
        keys["Right"] = sf::Keyboard::Right;
        keys["Up"] = sf::Keyboard::Up;
        keys["Down"] = sf::Keyboard::Down;
        keys["Numpad0"] = sf::Keyboard::Numpad0;
        keys["Numpad1"] = sf::Keyboard::Numpad1;
        keys["Numpad2"] = sf::Keyboard::Numpad2;
        keys["Numpad3"] = sf::Keyboard::Numpad3;
        keys["Numpad4"] = sf::Keyboard::Numpad4;
        keys["Numpad5"] = sf::Keyboard::Numpad5;
        keys["Numpad6"] = sf::Keyboard::Numpad6;
        keys["Numpad7"] = sf::Keyboard::Numpad7;
        keys["Numpad8"] = sf::Keyboard::Numpad8;
        keys["Numpad9"] = sf::Keyboard::Numpad9;
        keys["F1"] = sf::Keyboard::F1;
        keys["F2"] = sf::Keyboard::F2;
        keys["F3"] = sf::Keyboard::F3;
        keys["F4"] = sf::Keyboard::F4;
        keys["F5"] = sf::Keyboard::F5;
        keys["F6"] = sf::Keyboard::F6;
        keys["F7"] = sf::Keyboard::F7;
        keys["F8"] = sf::Keyboard::F8;
        keys["F9"] = sf::Keyboard::F9;
        keys["F10"] = sf::Keyboard::F10;
        keys["F11"] = sf::Keyboard::F11;
        keys["F12"] = sf::Keyboard::F12;
        keys["F13"] = sf::Keyboard::F13;
        keys["F14"] = sf::Keyboard::F14;
        keys["F15"] = sf::Keyboard::F15;
        keys["Pause"] = sf::Keyboard::Pause;
    }
} // namespace
