# C# Framework Extensions

[![Build](https://github.com/Hawkynt/C--FrameworkExtensions/actions/workflows/NewBuild.yml/badge.svg)](https://github.com/Hawkynt/C--FrameworkExtensions/actions/workflows/NewBuild.yml)
[![Tests](https://github.com/Hawkynt/C--FrameworkExtensions/actions/workflows/Tests.yml/badge.svg)](https://github.com/Hawkynt/C--FrameworkExtensions/actions/workflows/Tests.yml)
[![Last Commit](https://img.shields.io/github/last-commit/Hawkynt/C--FrameworkExtensions?branch=master) ![Activity](https://img.shields.io/github/commit-activity/y/Hawkynt/C--FrameworkExtensions?branch=master)](https://github.com/Hawkynt/C--FrameworkExtensions/commits/master)
[![License](https://img.shields.io/badge/License-LGPL_3.0-blue)](https://licenses.nuget.org/LGPL-3.0-or-later)
![Language](https://img.shields.io/github/languages/top/Hawkynt/C--FrameworkExtensions?color=purple)
![LineCount](https://tokei.rs/b1/github/Hawkynt/C--FrameworkExtensions?color=magenta)
![Size](https://img.shields.io/github/languages/code-size/Hawkynt/C--FrameworkExtensions?color=green) /
 ![Repo-Size](https://img.shields.io/github/repo-size/Hawkynt/C--FrameworkExtensions?color=red)
[![Stars](https://img.shields.io/github/stars/Hawkynt/C--FrameworkExtensions?color=yellow)](https://github.com/Hawkynt/C--FrameworkExtensions/stargazers)
[![NuGet.org](https://img.shields.io/badge/Packages_on-NuGet.org-dodgerblue)](https://www.nuget.org/profiles/Hawkynt)

![Build History](https://buildstats.info/github/chart/hawkynt/C--FrameworkExtensions)

Extensions to the [.NET Framework](https://en.wikipedia.org/wiki/.NET_Framework) and [.Net Core](https://en.wikipedia.org/wiki/.NET) for use with [C# programming language](https://en.wikipedia.org/wiki/C_Sharp_(programming_language)) or any other compatible .[NET language](https://en.wikipedia.org/wiki/List_of_.NET_libraries_and_frameworks).

## Packages

| Package | Description | Version | Downloads |
| --- | --- | --- | --- |
| [FrameworkExtensions.Backports](https://www.nuget.org/packages/FrameworkExtensions.Backports) | Extensions to assure newer compiler features work in older versions. | [![NuGet Version](https://img.shields.io/nuget/v/FrameworkExtensions.Backports)](https://www.nuget.org/packages/FrameworkExtensions.Backports/) | [![NuGet Downloads](https://img.shields.io/nuget/dt/FrameworkExtensions.Backports)](https://www.nuget.org/stats/packages/FrameworkExtensions.Backports?groupby=Version) |
| [FrameworkExtensions.Corlib](https://www.nuget.org/packages/FrameworkExtensions.Corlib) | Extensions for every type of project. | [![NuGet Version](https://img.shields.io/nuget/v/FrameworkExtensions.Corlib)](https://www.nuget.org/packages/FrameworkExtensions.Corlib/) | [![NuGet Dwonloads](https://img.shields.io/nuget/dt/FrameworkExtensions.Corlib)](https://www.nuget.org/stats/packages/FrameworkExtensions.Corlib?groupby=Version) |
| [FrameworkExtensions.DirectoryServices](https://www.nuget.org/packages/FrameworkExtensions.DirectoryServices) | Extensions to DirectoryServices. | [![NuGet Version](https://img.shields.io/nuget/v/FrameworkExtensions.DirectoryServices)](https://www.nuget.org/packages/FrameworkExtensions.DirectoryServices/) | [![NuGet Downloads](https://img.shields.io/nuget/dt/FrameworkExtensions.DirectoryServices)](https://www.nuget.org/stats/packages/FrameworkExtensions.DirectoryServices?groupby=Version) |
| [FrameworkExtensions.System.Drawing](https://www.nuget.org/packages/FrameworkExtensions.System.Drawing) | Extensions to System.Drawing. | [![NuGet Version](https://img.shields.io/nuget/v/FrameworkExtensions.System.Drawing)](https://www.nuget.org/packages/FrameworkExtensions.System.Drawing/) | [![NuGet Downloads](https://img.shields.io/nuget/dt/FrameworkExtensions.System.Drawing)](https://www.nuget.org/stats/packages/FrameworkExtensions.System.Drawing?groupby=Version) |
| [FrameworkExtensions.System.Windows.Forms](https://www.nuget.org/packages/FrameworkExtensions.System.Windows.Forms) | Extensions to WindowsForms. | [![NuGet Version](https://img.shields.io/nuget/v/FrameworkExtensions.System.Windows.Forms)](https://www.nuget.org/packages/FrameworkExtensions.System.Windows.Forms/) | [![NuGet Version](https://img.shields.io/nuget/dt/FrameworkExtensions.System.Windows.Forms)](https://www.nuget.org/stats/packages/FrameworkExtensions.System.Windows.Forms?groupby=Version) |
| [FrameworkExtensions.PresentationCore](https://www.nuget.org/packages/FrameworkExtensions.PresentationCore) | Extensions to WPF. | [![NuGet Version](https://img.shields.io/nuget/v/FrameworkExtensions.PresentationCore)](https://www.nuget.org/packages/FrameworkExtensions.PresentationCore/) | [![NuGet Downloads](https://img.shields.io/nuget/dt/FrameworkExtensions.PresentationCore)](https://www.nuget.org/stats/packages/FrameworkExtensions.PresentationCore?groupby=Version) |

## Licensing

* [LGPL-3.0](https://en.wikipedia.org/wiki/GNU_Lesser_General_Public_License)
* give credit to ***Hawkynt*** when using
* please do **pull**-requests if you add something
* report issues to and get in contact at [GitHub](https://github.com/Hawkynt/C--FrameworkExtensions)
* always deliver the [LICENSE](https://www.gnu.org/licenses/lgpl-3.0.txt) file to your code's customer

## Rules

See [CONTRIBUTING](CONTRIBUTING.md)
