﻿using System.Windows;
using System.Windows.Input;

namespace NotifyIconWpf.Sample.ShowCases.Commands;

/// <summary>
/// Closes the current window.
/// </summary>
public class CloseWindowCommand : CommandBase<CloseWindowCommand>
{
    public override void Execute(object? parameter)
    {
        GetTaskbarWindow(parameter)?.Close();
        CommandManager.InvalidateRequerySuggested();
    }


    public override bool CanExecute(object? parameter)
    {
        var win = GetTaskbarWindow(parameter);
        return win != null;
    }
}
