import { j as VitestRunMode, U as UserConfig, N as Vitest, ax as ModuleCacheMap, ay as ViteNodeRunnerOptions, az as MockMap, aA as ViteNodeRunner, aB as TestSequencer } from './types-1cf24598.js';
export { aB as TestSequencer, aD as TestSequencerConstructor, N as Vitest, aC as startVitest } from './types-1cf24598.js';
import { UserConfig as UserConfig$1, Plugin } from 'vite';
import 'tinybench';
import 'fs';
import 'worker_threads';

declare function createVitest(mode: VitestRunMode, options: UserConfig, viteOverrides?: UserConfig$1): Promise<Vitest>;

declare function VitestPlugin(options?: UserConfig, ctx?: Vitest): Promise<Plugin[]>;

declare type Key = string | symbol;
interface ViteRunnerRequest {
    (dep: string): any;
    callstack: string[];
}
declare class VitestMocker {
    options: ExecuteOptions;
    private moduleCache;
    private request;
    private static pendingIds;
    private static spyModule?;
    private resolveCache;
    constructor(options: ExecuteOptions, moduleCache: ModuleCacheMap, request: ViteRunnerRequest);
    private get root();
    private get base();
    private get mockMap();
    getSuiteFilepath(): string;
    getMocks(): {
        [x: string]: string | (() => unknown) | null;
    };
    private resolvePath;
    private resolveMocks;
    private callFunctionMock;
    private getMockPath;
    getDependencyMock(id: string): string | (() => unknown) | null;
    normalizePath(path: string): string;
    getFsPath(path: string, external: string | null): string;
    resolveMockPath(mockPath: string, external: string | null): string | null;
    mockObject(object: Record<Key, any>, mockExports?: Record<Key, any>): Record<Key, any>;
    unmockPath(path: string): void;
    mockPath(originalId: string, path: string, external: string | null, factory?: () => any): void;
    importActual<T>(id: string, importer: string): Promise<T>;
    importMock(id: string, importer: string): Promise<any>;
    private ensureSpy;
    requestWithMock(dep: string): Promise<any>;
    queueMock(id: string, importer: string, factory?: () => unknown): void;
    queueUnmock(id: string, importer: string): void;
}

interface ExecuteOptions extends ViteNodeRunnerOptions {
    mockMap: MockMap;
}
declare class VitestRunner extends ViteNodeRunner {
    options: ExecuteOptions;
    constructor(options: ExecuteOptions);
    prepareContext(context: Record<string, any>): Record<string, any> & {
        __vite_ssr_import__: (dep: string) => Promise<any>;
        __vite_ssr_dynamic_import__: (dep: string) => Promise<any>;
        __vitest_mocker__: VitestMocker;
    };
}

declare class BaseSequencer implements TestSequencer {
    protected ctx: Vitest;
    constructor(ctx: Vitest);
    shard(files: string[]): Promise<string[]>;
    sort(files: string[]): Promise<string[]>;
}

export { BaseSequencer, ExecuteOptions, VitestPlugin, VitestRunner, createVitest };
