import { getConfig } from '../config.js';
import { createServerSupabaseClient } from '@supabase/auth-helpers-shared';
const CACHE_KEY = Symbol('supabase-client');
export function getRequestSupabaseClient(event) {
    const { cookies, request } = event;
    const locals = event.locals;
    if (locals[CACHE_KEY]) {
        return locals[CACHE_KEY];
    }
    const { supabaseUrl, supabaseKey, options, cookieOptions } = getConfig();
    const client = createServerSupabaseClient({
        supabaseUrl,
        supabaseKey,
        getCookie(name) {
            return cookies.get(name);
        },
        setCookie(name, value, options) {
            cookies.set(name, value, options);
        },
        getRequestHeader(name) {
            return request.headers.get(name) ?? undefined;
        },
        options,
        cookieOptions
    });
    locals[CACHE_KEY] = client;
    return client;
}
