import { getLoadSupabaseClient } from './supabase-load.js';
import { getRequestSupabaseClient } from './supabase-request.js';
export async function getSupabase(event) {
    const requestOrServerLoadEvent = event;
    const loadEvent = event;
    let supabaseClient;
    if (typeof loadEvent.depends === 'function') {
        // depend on `supabase:auth` to allow reloading all data fetched with rls
        loadEvent.depends('supabase:auth');
    }
    // prefer request/server-load over load
    if (requestOrServerLoadEvent.locals) {
        supabaseClient = getRequestSupabaseClient(requestOrServerLoadEvent);
    }
    else if (typeof loadEvent.parent === 'function') {
        supabaseClient = getLoadSupabaseClient(loadEvent);
    }
    else {
        throw new Error('invalid event');
    }
    const { data: { session } } = await supabaseClient.auth.getSession();
    return {
        supabaseClient,
        session
    };
}
