import { getRequestSupabaseClient } from './supabase-request.js';
export async function getServerSession(event, expiry_margin = 60) {
    const supabase = getRequestSupabaseClient(event);
    let { data: { session } } = await supabase.auth.getSession();
    if (session?.expires_at &&
        session.expires_at + expiry_margin <= Date.now() / 1000) {
        const refreshed = await supabase.auth.refreshSession(session);
        session = refreshed.data.session;
    }
    return session;
}
