import { createBrowserSupabaseClient } from '@supabase/auth-helpers-shared';
import { setConfig } from './config.js';
import { PKG_NAME, PKG_VERSION } from './constants.js';
export function createClient(supabaseUrl, supabaseKey, options, cookieOptions) {
    const opts = {
        ...options,
        global: {
            ...options?.global,
            headers: {
                ...options?.global?.headers,
                'X-Client-Info': `${PKG_NAME}@${PKG_VERSION}`
            }
        },
        auth: {
            storageKey: cookieOptions?.name ?? 'supabase-auth-token'
        }
    };
    const globalInstance = createBrowserSupabaseClient({
        supabaseUrl,
        supabaseKey,
        options: opts,
        cookieOptions
    });
    setConfig({
        globalInstance,
        supabaseUrl,
        supabaseKey,
        options: opts,
        cookieOptions: {
            name: 'supabase-auth-token',
            path: '/',
            sameSite: 'lax',
            maxAge: 1000 * 60 * 60 * 24 * 365,
            ...cookieOptions
        }
    });
    return globalInstance;
}
