"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __esm = (fn, res) => function __init() {
  return fn && (res = (0, fn[__getOwnPropNames(fn)[0]])(fn = 0)), res;
};
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// ../../node_modules/.pnpm/tsup@5.12.9/node_modules/tsup/assets/cjs_shims.js
var init_cjs_shims = __esm({
  "../../node_modules/.pnpm/tsup@5.12.9/node_modules/tsup/assets/cjs_shims.js"() {
  }
});

// ../../node_modules/.pnpm/cookie@0.5.0/node_modules/cookie/index.js
var require_cookie = __commonJS({
  "../../node_modules/.pnpm/cookie@0.5.0/node_modules/cookie/index.js"(exports) {
    "use strict";
    init_cjs_shims();
    exports.parse = parse3;
    exports.serialize = serialize3;
    var __toString = Object.prototype.toString;
    var fieldContentRegExp = /^[\u0009\u0020-\u007e\u0080-\u00ff]+$/;
    function parse3(str, options) {
      if (typeof str !== "string") {
        throw new TypeError("argument str must be a string");
      }
      var obj = {};
      var opt = options || {};
      var dec = opt.decode || decode;
      var index = 0;
      while (index < str.length) {
        var eqIdx = str.indexOf("=", index);
        if (eqIdx === -1) {
          break;
        }
        var endIdx = str.indexOf(";", index);
        if (endIdx === -1) {
          endIdx = str.length;
        } else if (endIdx < eqIdx) {
          index = str.lastIndexOf(";", eqIdx - 1) + 1;
          continue;
        }
        var key = str.slice(index, eqIdx).trim();
        if (void 0 === obj[key]) {
          var val = str.slice(eqIdx + 1, endIdx).trim();
          if (val.charCodeAt(0) === 34) {
            val = val.slice(1, -1);
          }
          obj[key] = tryDecode(val, dec);
        }
        index = endIdx + 1;
      }
      return obj;
    }
    function serialize3(name, val, options) {
      var opt = options || {};
      var enc = opt.encode || encode;
      if (typeof enc !== "function") {
        throw new TypeError("option encode is invalid");
      }
      if (!fieldContentRegExp.test(name)) {
        throw new TypeError("argument name is invalid");
      }
      var value = enc(val);
      if (value && !fieldContentRegExp.test(value)) {
        throw new TypeError("argument val is invalid");
      }
      var str = name + "=" + value;
      if (null != opt.maxAge) {
        var maxAge = opt.maxAge - 0;
        if (isNaN(maxAge) || !isFinite(maxAge)) {
          throw new TypeError("option maxAge is invalid");
        }
        str += "; Max-Age=" + Math.floor(maxAge);
      }
      if (opt.domain) {
        if (!fieldContentRegExp.test(opt.domain)) {
          throw new TypeError("option domain is invalid");
        }
        str += "; Domain=" + opt.domain;
      }
      if (opt.path) {
        if (!fieldContentRegExp.test(opt.path)) {
          throw new TypeError("option path is invalid");
        }
        str += "; Path=" + opt.path;
      }
      if (opt.expires) {
        var expires = opt.expires;
        if (!isDate(expires) || isNaN(expires.valueOf())) {
          throw new TypeError("option expires is invalid");
        }
        str += "; Expires=" + expires.toUTCString();
      }
      if (opt.httpOnly) {
        str += "; HttpOnly";
      }
      if (opt.secure) {
        str += "; Secure";
      }
      if (opt.priority) {
        var priority = typeof opt.priority === "string" ? opt.priority.toLowerCase() : opt.priority;
        switch (priority) {
          case "low":
            str += "; Priority=Low";
            break;
          case "medium":
            str += "; Priority=Medium";
            break;
          case "high":
            str += "; Priority=High";
            break;
          default:
            throw new TypeError("option priority is invalid");
        }
      }
      if (opt.sameSite) {
        var sameSite = typeof opt.sameSite === "string" ? opt.sameSite.toLowerCase() : opt.sameSite;
        switch (sameSite) {
          case true:
            str += "; SameSite=Strict";
            break;
          case "lax":
            str += "; SameSite=Lax";
            break;
          case "strict":
            str += "; SameSite=Strict";
            break;
          case "none":
            str += "; SameSite=None";
            break;
          default:
            throw new TypeError("option sameSite is invalid");
        }
      }
      return str;
    }
    function decode(str) {
      return str.indexOf("%") !== -1 ? decodeURIComponent(str) : str;
    }
    function encode(val) {
      return encodeURIComponent(val);
    }
    function isDate(val) {
      return __toString.call(val) === "[object Date]" || val instanceof Date;
    }
    function tryDecode(str, decode2) {
      try {
        return decode2(str);
      } catch (e) {
        return str;
      }
    }
  }
});

// src/index.ts
var src_exports = {};
__export(src_exports, {
  AccessTokenNotFound: () => AccessTokenNotFound,
  AuthHelperError: () => AuthHelperError,
  CallbackUrlFailed: () => CallbackUrlFailed,
  CookieNotFound: () => CookieNotFound,
  CookieNotParsed: () => CookieNotParsed,
  CookieNotSaved: () => CookieNotSaved,
  JWTInvalid: () => JWTInvalid,
  JWTPayloadFailed: () => JWTPayloadFailed,
  ProviderTokenNotFound: () => ProviderTokenNotFound,
  RefreshTokenNotFound: () => RefreshTokenNotFound,
  createBrowserSupabaseClient: () => createBrowserSupabaseClient,
  createServerSupabaseClient: () => createServerSupabaseClient,
  ensureArray: () => ensureArray,
  filterCookies: () => filterCookies,
  isBrowser: () => isBrowser,
  parseCookies: () => import_cookie.parse,
  serializeCookie: () => import_cookie.serialize
});
module.exports = __toCommonJS(src_exports);
init_cjs_shims();

// src/supabase-browser.ts
init_cjs_shims();
var import_supabase_js = require("@supabase/supabase-js");
var import_cookie2 = __toESM(require_cookie());

// src/utils/cookies.ts
init_cjs_shims();
var import_cookie = __toESM(require_cookie());
function filterCookies(cookies, key) {
  const indexes = new Set(
    cookies.map((cookie) => (0, import_cookie.parse)(cookie)).reduce((acc, cookie, i) => {
      if (key in cookie) {
        acc.push(i);
      }
      return acc;
    }, new Array())
  );
  return cookies.filter((_, i) => !indexes.has(i));
}
function isSecureEnvironment(headerHost) {
  if (!headerHost) {
    throw new Error('The "host" request header is not available');
  }
  const headerHostStr = Array.isArray(headerHost) ? headerHost[0] : headerHost;
  const host = headerHostStr.indexOf(":") > -1 && headerHostStr.split(":")[0] || headerHostStr;
  if (["localhost", "127.0.0.1"].indexOf(host) > -1 || host.endsWith(".local")) {
    return false;
  }
  return true;
}
var decodeBase64URL = (value) => {
  try {
    return decodeURIComponent(
      atob(value.replace(/[-]/g, "+").replace(/[_]/g, "/")).split("").map((c) => "%" + ("00" + c.charCodeAt(0).toString(16)).slice(-2)).join("")
    );
  } catch (e) {
    if (e instanceof ReferenceError) {
      return Buffer.from(value, "base64").toString("utf-8");
    } else {
      throw e;
    }
  }
};
function parseSupabaseCookie(str) {
  if (!str) {
    return null;
  }
  try {
    const session = JSON.parse(str);
    if (!session) {
      return null;
    }
    if (session.constructor.name === "Object") {
      return session;
    }
    if (session.constructor.name !== "Array") {
      throw new Error(`Unexpected format: ${session.constructor.name}`);
    }
    const [_header, payloadStr, _signature] = session[0].split(".");
    const payload = decodeBase64URL(payloadStr);
    const { exp, sub, ...user } = JSON.parse(payload);
    return {
      expires_at: exp,
      expires_in: exp - Math.round(Date.now() / 1e3),
      token_type: "bearer",
      access_token: session[0],
      refresh_token: session[1],
      provider_token: session[2],
      provider_refresh_token: session[3],
      user: {
        id: sub,
        ...user
      }
    };
  } catch (err) {
    console.warn("Failed to parse cookie string:", err);
    return null;
  }
}
function stringifySupabaseSession(session) {
  return JSON.stringify([
    session.access_token,
    session.refresh_token,
    session.provider_token,
    session.provider_refresh_token
  ]);
}

// src/utils/helpers.ts
init_cjs_shims();
function ensureArray(data) {
  return Array.isArray(data) ? data : [data];
}
function isBrowser() {
  return typeof window !== "undefined";
}

// src/supabase-browser.ts
function createBrowserSupabaseClient({
  supabaseUrl,
  supabaseKey,
  options,
  cookieOptions: {
    name = "supabase-auth-token",
    domain,
    path = "/",
    sameSite = "lax",
    secure,
    maxAge = 1e3 * 60 * 60 * 24 * 365
  } = {}
}) {
  return (0, import_supabase_js.createClient)(supabaseUrl, supabaseKey, {
    ...options,
    auth: {
      storageKey: name,
      storage: {
        getItem(key) {
          if (!isBrowser()) {
            return null;
          }
          const cookies = (0, import_cookie2.parse)(document.cookie);
          const session = parseSupabaseCookie(cookies[key]);
          return session ? JSON.stringify(session) : null;
        },
        setItem(key, _value) {
          var _a;
          if (!isBrowser()) {
            return;
          }
          let session = JSON.parse(_value);
          const value = stringifySupabaseSession(session);
          document.cookie = (0, import_cookie2.serialize)(key, value, {
            domain,
            path,
            maxAge,
            httpOnly: false,
            sameSite,
            secure: secure != null ? secure : ((_a = document.location) == null ? void 0 : _a.protocol) === "https:"
          });
        },
        removeItem(key) {
          if (!isBrowser()) {
            return;
          }
          document.cookie = (0, import_cookie2.serialize)(key, "", {
            domain,
            path,
            expires: new Date(0),
            httpOnly: false,
            sameSite,
            secure
          });
        }
      }
    }
  });
}

// src/supabase-server.ts
init_cjs_shims();
var import_supabase_js2 = require("@supabase/supabase-js");
function createServerSupabaseClient({
  supabaseUrl,
  supabaseKey,
  getCookie,
  setCookie,
  getRequestHeader,
  options,
  cookieOptions: {
    name = "supabase-auth-token",
    domain,
    path = "/",
    sameSite = "lax",
    secure,
    maxAge = 1e3 * 60 * 60 * 24 * 365
  } = {}
}) {
  var _a;
  let currentSession = (_a = parseSupabaseCookie(getCookie(name))) != null ? _a : null;
  return (0, import_supabase_js2.createClient)(supabaseUrl, supabaseKey, {
    ...options,
    auth: {
      detectSessionInUrl: false,
      autoRefreshToken: false,
      storageKey: name,
      storage: {
        getItem(key) {
          return JSON.stringify(currentSession);
        },
        setItem(key, _value) {
          let session = JSON.parse(_value);
          const value = stringifySupabaseSession(session);
          currentSession = session;
          setCookie(key, value, {
            domain,
            path,
            maxAge,
            httpOnly: false,
            sameSite,
            secure: secure != null ? secure : isSecureEnvironment(getRequestHeader("host"))
          });
        },
        removeItem(key) {
          if (!currentSession) {
            return;
          }
          setCookie(key, "", {
            domain,
            path,
            expires: new Date(0),
            httpOnly: false,
            sameSite,
            secure: secure != null ? secure : isSecureEnvironment(getRequestHeader("host"))
          });
        }
      }
    }
  });
}

// src/types.ts
init_cjs_shims();

// src/utils/index.ts
init_cjs_shims();

// src/utils/errors.ts
init_cjs_shims();
var AuthHelperError = class extends Error {
  constructor(message, errorType) {
    super(message);
    this.errorType = errorType;
    this.source = "sb_auth_helpers";
  }
  toObj() {
    return {
      type: this.errorType,
      message: this.message,
      source: this.source
    };
  }
  toString() {
    return JSON.stringify(this.toObj());
  }
};
var CookieNotFound = class extends AuthHelperError {
  constructor() {
    super("No cookie was found!", "cookie_not_found");
  }
};
var CookieNotSaved = class extends AuthHelperError {
  constructor() {
    super("Cookies cannot be saved!", "cookie_not_saved");
  }
};
var AccessTokenNotFound = class extends AuthHelperError {
  constructor() {
    super("No access token was found!", "cookie_not_found");
  }
};
var RefreshTokenNotFound = class extends AuthHelperError {
  constructor() {
    super("No refresh token was found!", "cookie_not_found");
  }
};
var ProviderTokenNotFound = class extends AuthHelperError {
  constructor() {
    super("No provider token was found!", "cookie_not_found");
  }
};
var CookieNotParsed = class extends AuthHelperError {
  constructor() {
    super("Not able to parse cookies!", "cookie_not_parsed");
  }
};
var CallbackUrlFailed = class extends AuthHelperError {
  constructor(callbackUrl) {
    super(`The request to ${callbackUrl} failed!`, "callback_url_failed");
  }
};
var JWTPayloadFailed = class extends AuthHelperError {
  constructor() {
    super("Not able to parse JWT payload!", "jwt_payload_failed");
  }
};
var JWTInvalid = class extends AuthHelperError {
  constructor() {
    super("Invalid jwt!", "jwt_invalid");
  }
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  AccessTokenNotFound,
  AuthHelperError,
  CallbackUrlFailed,
  CookieNotFound,
  CookieNotParsed,
  CookieNotSaved,
  JWTInvalid,
  JWTPayloadFailed,
  ProviderTokenNotFound,
  RefreshTokenNotFound,
  createBrowserSupabaseClient,
  createServerSupabaseClient,
  ensureArray,
  filterCookies,
  isBrowser,
  parseCookies,
  serializeCookie
});
/*!
 * cookie
 * Copyright(c) 2012-2014 Roman Shtylman
 * Copyright(c) 2015 Douglas Christopher Wilson
 * MIT Licensed
 */
//# sourceMappingURL=index.js.map