import * as _supabase_supabase_js from '@supabase/supabase-js';
import { SupabaseClientOptions as SupabaseClientOptions$1 } from '@supabase/supabase-js';
import * as _supabase_supabase_js_dist_module_lib_types from '@supabase/supabase-js/dist/module/lib/types';
import { CookieSerializeOptions } from 'cookie';
export { parse as parseCookies, serialize as serializeCookie } from 'cookie';

declare type CookieOptions = {
    name?: string;
} & Pick<CookieSerializeOptions, 'domain' | 'secure' | 'path' | 'sameSite' | 'maxAge'>;
declare type SupabaseClientOptions<T = 'public'> = Omit<SupabaseClientOptions$1<T>, 'auth'>;

declare function createBrowserSupabaseClient<Database = any, SchemaName extends string & keyof Database = 'public' extends keyof Database ? 'public' : string & keyof Database>({ supabaseUrl, supabaseKey, options, cookieOptions: { name, domain, path, sameSite, secure, maxAge } }: {
    supabaseUrl: string;
    supabaseKey: string;
    options?: SupabaseClientOptions<SchemaName>;
    cookieOptions?: CookieOptions;
}): _supabase_supabase_js.SupabaseClient<Database, SchemaName, Database[SchemaName] extends _supabase_supabase_js_dist_module_lib_types.GenericSchema ? Database[SchemaName] : any>;

declare function createServerSupabaseClient<Database = any, SchemaName extends string & keyof Database = 'public' extends keyof Database ? 'public' : string & keyof Database>({ supabaseUrl, supabaseKey, getCookie, setCookie, getRequestHeader, options, cookieOptions: { name, domain, path, sameSite, secure, maxAge } }: {
    supabaseUrl: string;
    supabaseKey: string;
    getCookie: (name: string) => string | undefined;
    setCookie: (name: string, value: string, options: CookieSerializeOptions) => void;
    getRequestHeader: (name: string) => string | string[] | undefined;
    options?: SupabaseClientOptions<SchemaName>;
    cookieOptions?: CookieOptions;
}): _supabase_supabase_js.SupabaseClient<Database, SchemaName, Database[SchemaName] extends _supabase_supabase_js_dist_module_lib_types.GenericSchema ? Database[SchemaName] : any>;

interface ErrorPayload {
    type?: string;
    message: string;
    source?: string;
}
declare class AuthHelperError extends Error {
    errorType: string;
    source: string;
    constructor(message: string, errorType: string);
    toObj(): ErrorPayload;
    toString(): string;
}
declare class CookieNotFound extends AuthHelperError {
    constructor();
}
declare class CookieNotSaved extends AuthHelperError {
    constructor();
}
declare class AccessTokenNotFound extends AuthHelperError {
    constructor();
}
declare class RefreshTokenNotFound extends AuthHelperError {
    constructor();
}
declare class ProviderTokenNotFound extends AuthHelperError {
    constructor();
}
declare class CookieNotParsed extends AuthHelperError {
    constructor();
}
declare class CallbackUrlFailed extends AuthHelperError {
    constructor(callbackUrl: string);
}
declare class JWTPayloadFailed extends AuthHelperError {
    constructor();
}
declare class JWTInvalid extends AuthHelperError {
    constructor();
}

/**
 * Filter out the cookies based on a key
 */
declare function filterCookies(cookies: string[], key: string): string[];

declare function ensureArray<T>(data: T | T[]): T[];
declare function isBrowser(): boolean;

export { AccessTokenNotFound, AuthHelperError, CallbackUrlFailed, CookieNotFound, CookieNotParsed, CookieNotSaved, CookieOptions, ErrorPayload, JWTInvalid, JWTPayloadFailed, ProviderTokenNotFound, RefreshTokenNotFound, SupabaseClientOptions, createBrowserSupabaseClient, createServerSupabaseClient, ensureArray, filterCookies, isBrowser };
