
# Real Time Event Feedback Analysis System

## Overview:
The Real Time Event Feedback Analysis System is a web-based application designed to streamline event management and enhance attendee engagement. Unlike traditional feedback systems, our platform collects feedback data in real-time during events and instantly presents it to organizers, presenters, and administrators. This innovative approach empowers event organizers to dynamically adjust presentations, content, and agendas based on live feedback, resulting in more engaging, interactive, and impactful events.

## Key Features/Functionality:
### User Functionality 
- **User Registration:** Users can register for an account on the platform, providing their email address, password, and user type (user).
- **User Login:** On successful login user is redirected to user dashboard.
- **Live Feedback Submission:** During events, users can provide real-time feedback on presentations, speakers, and content.
- **Feedback Analysis:** Users can view aggregated feedback data to gain insights into overall audience sentiment and opinions.
- **User Logout:** Users can securely log out of their accounts to ensure the protection of their personal information.
### Admin Functionality
- **Admin Registration:** Admin can register for an account on the platform, providing their email address, password, and user type (admin).
- **Admin Login:** On successful login Admin is redirected to Admin dashboard.
- **Event Management:** Admins can create, manage(Start, Pause, End, Edit, Delete), and schedule events through the platform.
- **Real-Time Feedback Monitoring:** Monitor live feedback submissions during events and analyze trends.
- **Control Comment Permissions**: Admins have the authority to set permissions for commenting, such as enabling or disabling comments.
- **Admin Logout:** Admin can securely log out of their accounts to ensure the protection of their personal information.


## Hardware Components:
- Server
- networking equipment
- user devices (e.g., computers, smartphones).


## Software Components:
- HTML, CSS, JavaScript, (Bootstrap, jQuery) for web interface development.
- PHP for server-side scripting.
- MySQL database for storing attendance data.
- Google Charts: to create interactive and visually appealing data visualizations, allowing administrators to gain insights from feedback data more effectively.

## Functionality:
### User Functionality:
1. **Registration/Login:**
   - Users can register with their email and password.
   - Upon registration, users can log in securely.

2. **Feedback Submission:**
   - Users provide real-time feedback during events.

3. **Feedback Analysis:**
   - Users can view aggregated feedback for insights.

4. **Logout:**
   - Users can securely log out when finished.

### Admin Functionality:
   1. **Registration/Login:**
       - Admins can register/login with email and password.
   
   2. **Event Management:**
       - Admins create, edit, and schedule events.
   
   3. **Feedback Monitoring:**
       - Admins monitor live feedback during events.
   
   4. **Comment Control:**
       - Admins manage comment permissions.
   
   5. **Logout:**
       - Admins securely log out when finished.

## File Structure:

### 1. Code Files: 
- all the file are Maintain in properly hierarchy.
### 2. Database:
- **database.sql**: SQL script for creating the necessary tables and schema for the MySQL database.

### 3. Documentation:
- **README.md**: This file, containing project overview, installation instructions, usage guide, etc.



## Installation:
1. Clone or download the repository.
2. Set up the MySQL database with the provided schema.
- database.sql file contains database schema.
3. Configure the PHP scripts for database communication.
4. Setup all the files  properly.
- Maintain the folder or files hierarchy. 
5. Run the system on localhost or online server.

## Contributors:

1. Haridas Khambe (me)
2. Sakshi Jagadhane.
3. Soham Patil.
4. Aditya Bhagat.

## Support:
For any questions or issues, please open an issue on GitHub or contact Haridas Khmabe at haridaskhambe2003@gmail.com

## Related Images:


![Project Overview](OUTPUTS/login.png)
![Project Overview](OUTPUTS/register.png)
![Project Overview](OUTPUTS/reg-error.png)

### User Pages
![Project Overview](OUTPUTS/user/events.png)
![Project Overview](OUTPUTS/user/give-feedback.png)
![Project Overview](OUTPUTS/user/comment-disabled.png)
![Project Overview](OUTPUTS/user/feedback-1.png)
![Project Overview](OUTPUTS/user/feedback-2.png)

### Admin Pages
![Project Overview](OUTPUTS/admin/events.png)
![Project Overview](OUTPUTS/admin/add-event.png)
![Project Overview](OUTPUTS/admin/feedback-1.png)
![Project Overview](OUTPUTS/admin/feedback-2.png)
![Project Overview](OUTPUTS/admin/comment-disabled.png)
![Project Overview](OUTPUTS/admin/manage.png)
![Project Overview](OUTPUTS/admin/comment-enable.png)
![Project Overview](OUTPUTS/admin/edit-event.png)
![Project Overview](OUTPUTS/admin/end-event.png)
![Project Overview](OUTPUTS/admin/delete-event.png)



