<?php include("header.php"); ?> 
    <div class="container">
		<div class="wrapper">
			<div class="row">
				<div class="col-sm-12">
					<div class="breadcrumbs">
				        <ul>
				          	<li><a href="#">Home</a></li>
				         	<li><span class="dot">/</span><a href="#">Gluten Allergy</a></li>
				        </ul>
	                </div>
                </div>
		    </div>
		    <div class="row">
		    	<div class="col-sm-12">
		    		<h2>Gluten Allergy</h2>
		    		<hr>
		    		<h6 class="btm20"><i>If you need help with gluten allergy, reserve your private consultation with ADD VEDA, or go through our herbal product ADD GLUTEN.<br>
					If you are looking for information about gluten allergy, please read on…</i></h5>
					<h3>What is Wheat/Gluten Allergy</h3>
					<p>A wheat/gluten allergy is a type of food allergy characterized by adverse reactions to the consumption of wheat. In addition to causing problems when wheat s eaten, wheat allergies may also result in skin reactions in response to contact with wheat, and in respiratory problems after inhaling wheat pollen and wheat dust (Baker's Asthma). Some people may have allergic symptoms if they do exercise within a few hours of consuming wheat proteins or if they also take aspirin or some other NSAIDs (nonsteroidal anti-inflammatory drugs) a few hours before exercising.<p>
					<p>People with a wheat allergy have an abnormal immune system response to at least one of the proteins that exist in wheat. It is one of the most common childhood food allergies, but may affect adults as well.</p>
					<p>The allergic reaction involves IgE (immunoglobulin) antibodies to at least one of the following proteins found in wheat:</p>
					<div class="pane" >
			        	<ul>
			        		<li>Albumin</li>
			        		<li>Globulin</li>
			        		<li>Gliadin</li>
			        		<li>Glutenin (gluten)</li>
			        	</ul>
				    </div>
			    	<p>Some people are allergic to just one of them, while others may be allergic to two or even more.</p>
					<p>Wheat allergies are among the eight most common food allergies, affecting as many as six percent of children under the age of three (they are less common among adults)</p>
					<hr>
					<div class="panel-group" id="accordion">
						<div class="panel panel-default">
						    <div class="panel-heading">
						      <h4 class="panel-title">
						        <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion" href="#collapseOne">
						          What are the causes of wheat allergy?
						        </a>
						      </h4>
						    </div>
						    <div id="collapseOne" class="panel-collapse collapse">
						      <div class="panel-body">
						        <p>A wheat allergy is an immune system response. Our immune system is designed to protect us from foreign bodies and pathogens (things that cause disease), such as bacteria, viruses, and toxic substances. An allergic reaction occurs when the immune system mistakes a normal or good substance for a pathogen, and attacks it. Sometimes our immune system may attack good tissues and cells in our bodies; this is called an autoimmune disease. In the cases of wheat allergy, the immune system attacks wheat proteins as if they were, for example, harmful bacteria.</p>
								<p>The body of a person who is allergic to wheat produces an antibody to a protein found in wheat, causing an allergy.</p>
								<p>When the human body has developed an allergy -causing antibody to a specific agent (an allergen), which in this case is a wheat protein, the immune system becomes sensitive to it. Whenever that person eats a protein contained in wheat, the immune system learns to identify the proteins, their immune system attacks it, thereby triggering an allergic reaction.</p>
						      </div>
						    </div>
						</div>
						<div class="panel panel-default">
						    <div class="panel-heading">
						      <h4 class="panel-title">
						        <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion" href="#collapseTwo">
						          What are the signs and symptoms of wheat allergy?
						        </a>
						      </h4>
						    </div>
						    <div id="collapseTwo" class="panel-collapse collapse">
						        <div class="panel-body">
							        <p>If you or your child has wheat allergy, you or your child will likely experience symptoms within a few minutes to a few hours after eating something containing wheat. Wheat allergy symptoms include:</p>
							        <div class="pane" >
							        	<ul>
							        		<li>Asthma /Breathing difficulties</li>
							        		<li>Atopic dermatitis (Skin eczema)</li>
							        		<li>Diarrhea</li>
							        		<li>Mouth &amp; throat irritation and possible swelling</li>
							        		<li>Nausea</li>
							        		<li>Urticaria - hives, an itchy rash (possible swelling of the skin)</li>
							        		<li>Vomiting</li>
							        		<li>Watery and/or itchy eyes</li>
							        		<li>Bloated stomach</li>
							        	</ul>
									</div>
									<h6><strong>Signs and symptoms of Anaphylaxis (severe life endangering allergic reaction) may include:</strong></h6>
									<div class="pane">
										<ul>
							        		<li>Throat swells and becomes tight</li>
							        		<li>Chest tightness</li>
							        		<li>Chest pain</li>
							        		<li>More severe breathing difficulties</li>
							        		<li>Swallowing difficulties</li>
							        		<li>Skin becomes pale or bluish</li>
							        		<li>Weak pulse</li>
							        		<li>Hypotension -a serious drop in blood pressure</li>
							        	</ul>
									</div>	
						        </div>
						    </div>
						</div>
						<div class="panel panel-default">
						    <div class="panel-heading">
						      <h4 class="panel-title">
						        <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion" href="#collapseThree">
						          What are the risk factors for wheat allergy?
						        </a>
						      </h4>
						    </div>
						    <div id="collapseThree" class="panel-collapse collapse">
						        <div class="panel-body">
						       		<div class="pane">
										<ul>
							        		<li><strong>Family history</strong>- If a close relative, such as a parent or sibling has an allergy, a person may have a higher risk of developing wheat allergy. A family history of allergies may include wheat allergy, hay fever, asthma -any allergy.</li>
							        		<li><strong>Age</strong>- Infants and toddlers are much more likely to have wheat allergy, compared to other people.  Their immune and digestive systems are still immature.</li>
							        	</ul>
									</div>
						        </div>
						    </div>
						</div>
						<div class="panel panel-default">
						    <div class="panel-heading">
						      <h4 class="panel-title">
						        <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion" href="#collapse4">
						          What is celiac disease?
						        </a>
						      </h4>
						    </div>
						    <div id="collapse4" class="panel-collapse collapse">
						      	<div class="panel-body">
						       		<p>Celiac disease, or gluten -sensitive enteropathy, is considered a food sensitivity rather than a food allergy. Celiac disease is an immune system reaction to gluten, a protein found mainly in wheat, rye and barley that causes inflammation in the small intestines, damages it and interferes with absorption of nutrients from food that leads to symptoms and signs of nutritional, vitamin, and mineral deficiencies.</p>
									<p>In celiac disease, the inflammation destroys the villi, causing the inner lining of the small intestine to become flattened. This loss of villi reduces the cells and surface area available for absorption of nutrients.</p>
									<p>The impaired absorption of nutrients is referred to as malabsorption that further leads to nutrient deficiencies, referred to as malnutrition. Celiac disease is genetic, meaning it runs in families: Sometimes  the disease is triggered—or becomes active for the first time—after surgery, pregnancy, childbirth, viral infection, or severe emotional stress.</p>
									<h6><strong>Symptoms may occur in the digestive system or in other parts of the body. Digestive symptoms are more common in infants and young children and may include:</strong></h6>
									<div class="pane">
										<ul>
										    <li>Abdominal bloating and pain</li>
										    <li>Chronic diarrhea vomiting</li>
										    <li>Constipation</li>
										    <li>Pale, foul-smelling, or fatty stool</li>
										    <li>Weight loss</li>
										</ul>	
									</div>	
									<p>Irritability is another common symptom in children, malabsorption of nutrient during the years when nutrition is critical to a child's normal growth and development can result in other problems such as failure to thrive in infants, delayed growth and short stature, delayed puberty, and dental enamel defects of the permanent teeth.</p>
									<h6><strong>Adults are less likely to have digestive symptoms and may instead have one or more of the following:</strong></h6>
									<div class="pane">
										<ul>
										    <li>Unexplained iron -deficiency anemia</li>
										    <li>Fatigue</li>
										    <li>Bone or joint pain</li>
										    <li>Arthritis</li>
										    <li>Bone loss or osteoporosis</li>
										    <li>Depression or anxiety</li>
										    <li>Tingling numbness in the hands and feet</li>
										    <li>Seizures</li>
										    <li>Missed menstrual periods</li>
										    <li>Infertility or recurrent miscarriage</li>
										    <li>Canker sores inside the mouth</li>
										    <li>An itchy skin rash called dermatitis herpetiformis</li>
										</ul>	
									</div>
									<p>The length of time a person was breastfed, the age a person started eating gluten –containing foods, and the amount of gluten -containing foods one eats are three factors thought to play a role in when and how celiac disease appears.</p>	
						      	</div>
						    </div>
						</div>
						<div class="panel panel-default">
						    <div class="panel-heading">
						      <h4 class="panel-title">
						        <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion" href="#collapse5">
						          How is celiac disease diagnosed?
						        </a>
						      </h4>
						    </div>
						    <div id="collapse5" class="panel-collapse collapse">
						        <div class="panel-body">
						       		<h6><strong>The diagnosis of celiac disease is based on a combination of:</strong></h6>
						       		<div class="pane">
										<ul>
										    <li>Clinical symptoms</li>
										    <li>Serological testing (and other immunological tests)</li>
										    <li>Intestinal biopsy (histology)</li>
										    <li>Response to a gluten -free diet</li>
										</ul>	
									</div>
									<p>Food diary the doctor may ask the patient to write down everything they eat and when, as well as detailed notes on symptoms to identify particular foods causing problem.</p>
									<h6><strong>Serological Blood Tests</strong></h6>
									<p>People with celiac disease have higher than normal levels of certain autoantibodies—proteins that react against the body's own cells or tissues—in their blood. To diagnose celiac disease, doctors will test blood for high levels of anti -tissue transglutaminase antibodies (tTGA) or anti-endomysium antibodies.</p>
									<p>A sensitive testing protocol includes testing for both IgA and IgG anti-gliadin antibodies since a significant portion of celiac patients (approx. 2-5%) are IgA deficient. IgA gliadin antibodies increase rapidly in response to gluten in the diet and decrease rapidly when gluten is absent from the diet.</p>
									<p>The IgA anti-gliadin antibodies can totally disappear in 2-6 months on a gluten free diet, so they are useful as a diet control. By contrast, IgG anti-gliadin antibodies need a long time, sometimes more than a year, to become negative. The reverse is also true. That is, a patient with celiac disease who has been on a gluten free diet and tests negative for IgA anti-gliadin antibodies, will show a rapid increase in antibody production when challenged by gluten in the diet. Approximately 90% of challenged patients will yield a positive IgA anti-gliadin result within 14-35 days after being challenged. The IgG antibodies are somewhat slower. A 0.3 g/kg body weight/day of single gluten challenge causes immunological changes (cellular immunity) in the intestine in patients on a gluten-free diet. IgA class anti-endomysial antibodies (AEA) are very specific, occurring only in celiac disease and DH. These antibodies are found in approximately 80% of patients with DH and in essentially 100% of patients with active celiac disease.</p>
									<p>The test for anti-endomysial antibodies is more subjective and more complicated for the lab to perform than the anti-gliadin assays.</p>
									<h6><strong>Intestinal  Biopsy</strong></h6>
									<p>Endoscopic removal of tiny pieces of tissue from the small intestine to check for damage to the villi.</p>
									<h6><strong>Dermatitis Herpetiformis</strong></h6>
									<p>Dermatitis herpetiformis (DH) is an intensely itchy, blistering skin rash that affects 15 to 25 percent of people with celiac disease.' The rash usually occurs on the elbows, knees, and buttocks.</p>
									<p>If the antibody tests are positive and the skin biopsy has the typical findings of DH, patients do not need to have an intestinal biopsy.</p>
									<p>"None of these tests, or any others, can report accurate results if the patient has been following a Gluten free diet because the challenge by gluten/Wheat in the diet is necessary to trigger the body to produce these antibodies or to cause a change in the jejunum that would be observable by endoscopy or detectable by biopsy.</p>
									<h6><strong>Other tests to help determine the severity of the disease and the extent of a patient's malnutrition, malabsorption, and the involvement of other organs might include:</strong></h6>
									<div class="pane">
										<ul>
											<li>CBC (complete blood count) to look for anemia</li>
											<li>ESR (erythrocyte sedimentation rate) to evaluate inflammation</li>
											<li>CRP (C-Reactive Protein) to evaluate inflammation</li>
											<li>Stool fat, to help evaluate malabsorption.</li>
										</ul>
									</div>		
						        </div>
						    </div>
						</div>
						<div class="panel panel-default">
						    <div class="panel-heading">
						      <h4 class="panel-title">
						        <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion" href="#collapse6">
						          What are the treatment options for wheat allergy?
						        </a>
						      </h4>
						    </div>
						    <div id="collapse6" class="panel-collapse collapse">
						      	<div class="panel-body">
						       		<p>As per allopathic system of medicine, the best treatment is to avoid wheat proteins. This is not easy, as wheat appears in so many foods. Even seemingly non -wheat foods require careful label inspection.</p>
						       		<p><strong>Antihistamines</strong> - this is a type of medication which lowers the patient's immune system, often resulting either in the elimination of allergy symptoms, or a significant reduction temporarily whenever symptoms appear.</p>
									<p>For most people, following this diet will stop symptoms, heal existing intestinal damage, and prevent further damage. Improvements begin within days of starting the diet. The small intestine is usually completely healed in 3 to 6 months in children and younger adults and within 2 years for older adults. Healed means a person now has villi that can absorb nutrients from food into the bloodstream.</p>
									<p><strong>According to allopathic (Conventional System) System of Medicine:</strong> In order to stay well, people with coeliac disease must avoid gluten for the rest of their lives. Eating any gluten, no matter how small an amount, can damage the small intestine. Some people with coeliac disease show no improvement on the gluten -free diet. The condition is called unresponsive coeliac disease.</p>
						      	</div>
						    </div>
						</div>
					</div>
					<p><i>Want to know about gluten free diet or how you can get relief from gluten allergy? Feel free to get in touch with us!</i></p>
		    	</div>
	        </div>
		</div>
	</div>
<?php include("footer.php"); ?> 