package app.simple.inure.preferences

object AnalyticsPreferences {

    const val SDK_VALUE = "analytics_sdk_value"
    const val PIE_HOLE_RADIUS = "pie_hole_radius"

    // ---------------------------------------------------------------------------------------------------------- //

    fun setSDKValue(value: Boolean) {
        SharedPreferences.getSharedPreferences().edit().putBoolean(SDK_VALUE, value).apply()
    }

    fun getSDKValue(): Boolean {
        return SharedPreferences.getSharedPreferences().getBoolean(SDK_VALUE, true)
    }

    // ---------------------------------------------------------------------------------------------------------- //

    fun setPieHoleRadiusValue(value: Float) {
        SharedPreferences.getSharedPreferences().edit().putFloat(PIE_HOLE_RADIUS, value).apply()
    }

    fun getPieHoleRadiusValue(): Float {
        return SharedPreferences.getSharedPreferences().getFloat(PIE_HOLE_RADIUS, 50F)
    }

}
