# Contribution Guidelines

Thank you for considering contributing to Inure! Here are some guidelines to help you get
started:

## How to Contribute

1. **Fork the repository**: Click the "Fork" button at the top right of the repository page.
2. **Clone your fork**: Clone your forked repository to your local machine.
   ```sh
   git clone https://github.com/Hamza417/Inure.git
    ```
3. **Create a branch**: Create a new branch for your contribution.
    ```sh
    git checkout -b your-branch-name
     ```
4. **Make changes**: Make your changes to the codebase.
5. **Commit your changes**: Commit your changes to your branch.
   ```sh
   git commit -m "Your message here"
    ```
6. **Push your changes**: Push your changes to your forked repository.
   ```sh
   git push origin your-branch-name
    ```
7. **Submit a pull request**: Go to the original repository and click the "New pull request" button.
8. **Wait for review**: Wait for your pull request to be reviewed and merged.
9. **Sync your fork**: Sync your forked repository with the original repository.
   ```sh
    git remote add upstream
    git fetch upstream
    git checkout main
    git merge upstream/main
    git push origin main
    ```
10. **Delete your branch**: After your pull request has been merged, you can delete your branch.
    ```sh
    git branch -d your-branch-name
    ```
11. **Celebrate**: Your contribution has been merged! 🎉
