package fr.adrienbrault.idea.symfony2plugin.action;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import fr.adrienbrault.idea.symfony2plugin.Symfony2ProjectComponent;
import org.jetbrains.annotations.NotNull;

import javax.swing.*;

/**
 * @author Daniel Espendiller <daniel@espendiller.net>
 */
abstract public class AbstractProjectDumbAwareAction extends DumbAwareAction {

    @Override
    public @NotNull ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public AbstractProjectDumbAwareAction(String text, String description, Icon phpFile) {
        super(text, description, phpFile);
    }

    public void update(@NotNull AnActionEvent event) {
        setStatus(event, false);

        Project project = event.getData(PlatformDataKeys.PROJECT);
        if (Symfony2ProjectComponent.isEnabled(project)) {
            setStatus(event, true);
        }
    }

    protected void setStatus(AnActionEvent event, boolean status) {
        event.getPresentation().setVisible(status);
        event.getPresentation().setEnabled(status);
    }
}
