<?php

declare(strict_types=1);

/**
 * NOTICE OF LICENSE.
 *
 * UNIT3D Community Edition is open-sourced software licensed under the GNU Affero General Public License v3.0
 * The details is bundled with this project in the file LICENSE.txt.
 *
 * @project    UNIT3D Community Edition
 *
 * @author     HDVinnie <hdinnovations@protonmail.com>
 * @license    https://www.gnu.org/licenses/agpl-3.0.en.html/ GNU Affero General Public License v3.0
 */

use App\Http\Controllers\User\TransactionController;
use App\Http\Requests\StoreTransactionRequest;
use App\Models\BonExchange;
use App\Models\User;

test('create returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $user = User::factory()->create();
    $bonExchanges = BonExchange::factory()->times(3)->create();
    $authUser = User::factory()->create();

    $response = $this->actingAs($authUser)->get(route('users.transactions.create', [$user]));

    $response->assertOk();
    $response->assertViewIs('user.transaction.create');
    $response->assertViewHas('user', $user);
    $response->assertViewHas('bon');
    $response->assertViewHas('activefl');
    $response->assertViewHas('items');

    // TODO: perform additional assertions
});

test('create aborts with a 403', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $user = User::factory()->create();
    $bonExchanges = BonExchange::factory()->times(3)->create();
    $authUser = User::factory()->create();

    // TODO: perform additional setup to trigger `abort_unless(403)`...

    $response = $this->actingAs($authUser)->get(route('users.transactions.create', [$user]));

    $response->assertForbidden();
});

test('store validates with a form request', function (): void {
    $this->assertActionUsesFormRequest(
        TransactionController::class,
        'store',
        StoreTransactionRequest::class
    );
});

test('store returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $user = User::factory()->create();
    $bonExchange = BonExchange::factory()->create();
    $authUser = User::factory()->create();

    $response = $this->actingAs($authUser)->post(route('users.transactions.store', [$user]), [
        // TODO: send request data
    ]);

    $response->assertOk();

    // TODO: perform additional assertions
});

test('store aborts with a 403', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $user = User::factory()->create();
    $bonExchange = BonExchange::factory()->create();
    $authUser = User::factory()->create();

    // TODO: perform additional setup to trigger `abort_unless(403)`...

    $response = $this->actingAs($authUser)->post(route('users.transactions.store', [$user]), [
        // TODO: send request data
    ]);

    $response->assertForbidden();
});

// test cases...
