<?php

declare(strict_types=1);

/**
 * NOTICE OF LICENSE.
 *
 * UNIT3D Community Edition is open-sourced software licensed under the GNU Affero General Public License v3.0
 * The details is bundled with this project in the file LICENSE.txt.
 *
 * @project    UNIT3D Community Edition
 *
 * @author     HDVinnie <hdinnovations@protonmail.com>
 * @license    https://www.gnu.org/licenses/agpl-3.0.en.html/ GNU Affero General Public License v3.0
 */

use App\Http\Controllers\User\PostTipController;
use App\Http\Requests\User\StorePostTipRequest;
use App\Models\BonTransactions;
use App\Models\Post;
use App\Models\Torrent;
use App\Models\User;

test('index returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $user = User::factory()->create();
    $bonTransactions = BonTransactions::factory()->times(3)->create();
    $authUser = User::factory()->create();

    $response = $this->actingAs($authUser)->get(route('users.post_tips.index', [$user]));

    $response->assertOk();
    $response->assertViewIs('user.post-tip.index');
    $response->assertViewHas('user', $user);
    $response->assertViewHas('tips');
    $response->assertViewHas('bon');
    $response->assertViewHas('sentTips');
    $response->assertViewHas('receivedTips');

    // TODO: perform additional assertions
});

test('index aborts with a 403', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $user = User::factory()->create();
    $bonTransactions = BonTransactions::factory()->times(3)->create();
    $authUser = User::factory()->create();

    // TODO: perform additional setup to trigger `abort_unless(403)`...

    $response = $this->actingAs($authUser)->get(route('users.post_tips.index', [$user]));

    $response->assertForbidden();
});

test('store validates with a form request', function (): void {
    $this->assertActionUsesFormRequest(
        PostTipController::class,
        'store',
        StorePostTipRequest::class
    );
});

test('store returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $user = User::factory()->create();
    $torrent = Torrent::factory()->create();
    $post = Post::factory()->create();
    $authUser = User::factory()->create();

    $response = $this->actingAs($authUser)->post(route('users.post_tips.store', [$user]), [
        // TODO: send request data
    ]);

    $response->assertRedirect(withSuccess(trans('bon.success-tip')));

    // TODO: perform additional assertions
});

test('store aborts with a 403', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $user = User::factory()->create();
    $torrent = Torrent::factory()->create();
    $post = Post::factory()->create();
    $authUser = User::factory()->create();

    // TODO: perform additional setup to trigger `abort_unless(403)`...

    $response = $this->actingAs($authUser)->post(route('users.post_tips.store', [$user]), [
        // TODO: send request data
    ]);

    $response->assertForbidden();
});

// test cases...
