<?php

declare(strict_types=1);

/**
 * NOTICE OF LICENSE.
 *
 * UNIT3D Community Edition is open-sourced software licensed under the GNU Affero General Public License v3.0
 * The details is bundled with this project in the file LICENSE.txt.
 *
 * @project    UNIT3D Community Edition
 *
 * @author     HDVinnie <hdinnovations@protonmail.com>
 * @license    https://www.gnu.org/licenses/agpl-3.0.en.html/ GNU Affero General Public License v3.0
 */

use App\Models\Group;
use App\Models\Invite;
use App\Models\User;
use Illuminate\Support\Facades\Mail;

test('create returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $user = User::factory()->create();
    $authUser = User::factory()->create();

    $response = $this->actingAs($authUser)->get(route('users.invites.create', [$user]));

    $response->assertOk();
    $response->assertViewIs('user.invite.create');
    $response->assertViewHas('user', $user);

    // TODO: perform additional assertions
});

test('create aborts with a 403', function (): void {
    $group = Group::factory()->create([]);

    $user = User::factory()->create([
        'group_id'                => $group->id,
        'can_invite'              => 0,
        'invites'                 => 1,
        'two_factor_confirmed_at' => now(),
    ]);

    $response = $this->actingAs($user)->get(route('users.invites.create', [$user]), []);

    $response->assertRedirect(route('home.index'));
    $this->assertDatabaseHas('users', [
        'id'      => $user->id,
        'invites' => 1,
    ]);
    $this->assertDatabaseMissing('invites', [
        'user_id' => $user->id,
    ]);
});

test('destroy returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $user = User::factory()->create();
    $invite = Invite::factory()->create();
    $authUser = User::factory()->create();

    $response = $this->actingAs($authUser)->delete(route('users.invites.destroy', [$user, $invite]));

    $response->assertOk();
    $this->assertModelMissing($invite);

    // TODO: perform additional assertions
});

test('destroy aborts with a 403', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $user = User::factory()->create();
    $invite = Invite::factory()->create();
    $authUser = User::factory()->create();

    // TODO: perform additional setup to trigger `abort_unless(403)`...

    $response = $this->actingAs($authUser)->delete(route('users.invites.destroy', [$user, $invite]));

    $response->assertForbidden();
});

test('index returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $user = User::factory()->create();
    $authUser = User::factory()->create();

    $response = $this->actingAs($authUser)->get(route('users.invites.index', [$user]));

    $response->assertOk();
    $response->assertViewIs('user.invite.index');
    $response->assertViewHas('user', $user);
    $response->assertViewHas('invites');

    // TODO: perform additional assertions
});

test('index aborts with a 403', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $user = User::factory()->create();
    $authUser = User::factory()->create();

    // TODO: perform additional setup to trigger `abort_unless(403)`...

    $response = $this->actingAs($authUser)->get(route('users.invites.index', [$user]));

    $response->assertForbidden();
});

test('send returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $user = User::factory()->create();
    $invite = Invite::factory()->create();
    $authUser = User::factory()->create();

    $response = $this->actingAs($authUser)->post(route('users.invites.send', [$user, $invite]), [
        // TODO: send request data
    ]);

    $response->assertOk();

    // TODO: perform additional assertions
});

test('send aborts with a 403', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $user = User::factory()->create();
    $invite = Invite::factory()->create();
    $authUser = User::factory()->create();

    // TODO: perform additional setup to trigger `abort_unless(403)`...

    $response = $this->actingAs($authUser)->post(route('users.invites.send', [$user, $invite]), [
        // TODO: send request data
    ]);

    $response->assertForbidden();
});

test('store returns an ok response', function (): void {
    $group = Group::factory()->create([]);

    $user = User::factory()->create([
        'group_id'                => $group->id,
        'can_invite'              => 1,
        'invites'                 => 1,
        'two_factor_confirmed_at' => now(),
    ]);

    $inviteEmail = 'test@unit3d.dev';

    config(['other.invites_restriced' => true]);
    config(['other.invite_groups' => [$group->name]]);
    config(['other.invite_groups' => [$group->name]]);
    config(['email-blacklist.enabled' => false]);

    Mail::fake();

    $response = $this->actingAs($user)->post(route('users.invites.store', [$user]), [
        'email'   => $inviteEmail,
        'message' => 'Test Invite',
    ]);

    $response->assertRedirect();
    $this->assertDatabaseHas('users', [
        'id'      => $user->id,
        'invites' => 0,
    ]);
    $this->assertDatabaseHas('invites', [
        'user_id' => $user->id,
        'email'   => $inviteEmail,
    ]);
});

test('store with internal note as staff user', function (): void {
    $group = Group::factory()->create(['is_modo' => true, 'can_invite' => true]);

    $user = User::factory()->for($group)->create([
        'can_invite'              => 1,
        'invites'                 => 1,
        'two_factor_confirmed_at' => now(),
    ]);

    $inviteEmail = 'test@unit3d.dev';

    config(['other' => [
        'invites_restriced' => true,
        'invite_groups'     => [$group->name],
    ],
        'email-blacklist.enabled' => false,
    ]);

    Mail::fake();

    $response = $this->actingAs($user)->post(route('users.invites.store', [$user]), [
        'email'         => $inviteEmail,
        'message'       => 'Test Invite',
        'internal_note' => 'Test Internal Note',
    ]);

    $response->assertRedirect();
    $this->assertDatabaseHas('invites', [
        'user_id'       => $user->id,
        'email'         => $inviteEmail,
        'internal_note' => 'Test Internal Note',
    ]);
});

test('store aborts with a 403', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $user = User::factory()->create();
    $authUser = User::factory()->create();

    // TODO: perform additional setup to trigger `abort_unless(403)`...

    $response = $this->actingAs($authUser)->post(route('users.invites.store', [$user]), [
        // TODO: send request data
    ]);

    $response->assertForbidden();
});

// test cases...
