<?php

declare(strict_types=1);

/**
 * NOTICE OF LICENSE.
 *
 * UNIT3D Community Edition is open-sourced software licensed under the GNU Affero General Public License v3.0
 * The details is bundled with this project in the file LICENSE.txt.
 *
 * @project    UNIT3D Community Edition
 *
 * @author     HDVinnie <hdinnovations@protonmail.com>
 * @license    https://www.gnu.org/licenses/agpl-3.0.en.html/ GNU Affero General Public License v3.0
 */

use App\Models\Forum;
use App\Models\Subscription;
use App\Models\Topic;
use App\Models\User;

test('close returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $topic = Topic::factory()->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->post(route('topics.close', ['id' => $topic->id]), [
        // TODO: send request data
    ]);

    $response->assertOk();

    // TODO: perform additional assertions
});

test('create returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $forum = Forum::factory()->create();
    $topic = Topic::factory()->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->get(route('topics.create', ['id' => $topic->id]));

    $response->assertOk();
    $response->assertViewIs('forum.forum_topic.create');
    $response->assertViewHas('forum', $forum);

    // TODO: perform additional assertions
});

test('destroy returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $topic = Topic::factory()->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->delete(route('topics.destroy', ['id' => $topic->id]));

    $response->assertOk();
    $this->assertModelMissing($topic);

    // TODO: perform additional assertions
});

test('edit returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $topic = Topic::factory()->create();
    $forums = Forum::factory()->times(3)->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->get(route('topics.edit', ['id' => $topic->id]));

    $response->assertOk();
    $response->assertViewIs('forum.topic.edit');
    $response->assertViewHas('topic', $topic);
    $response->assertViewHas('categories');

    // TODO: perform additional assertions
});

test('edit aborts with a 403', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $topic = Topic::factory()->create();
    $forums = Forum::factory()->times(3)->create();
    $user = User::factory()->create();

    // TODO: perform additional setup to trigger `abort_unless(403)`...

    $response = $this->actingAs($user)->get(route('topics.edit', ['id' => $topic->id]));

    $response->assertForbidden();
});

test('index returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $user = User::factory()->create();

    $response = $this->actingAs($user)->get(route('topics.index'));

    $response->assertOk();
    $response->assertViewIs('forum.topic.index');

    // TODO: perform additional assertions
});

test('open returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $topic = Topic::factory()->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->post(route('topics.open', ['id' => $topic->id]), [
        // TODO: send request data
    ]);

    $response->assertOk();

    // TODO: perform additional assertions
});

test('pin returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $topic = Topic::factory()->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->post(route('topics.pin', ['id' => $topic->id]), [
        // TODO: send request data
    ]);

    $response->assertOk();

    // TODO: perform additional assertions
});

test('show returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $topic = Topic::factory()->create();
    $subscription = Subscription::factory()->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->get(route('topics.show', ['id' => $topic->id]));

    $response->assertOk();
    $response->assertViewIs('forum.topic.show');
    $response->assertViewHas('topic', $topic);
    $response->assertViewHas('forum');
    $response->assertViewHas('subscription', $subscription);

    // TODO: perform additional assertions
});

test('store returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $forum = Forum::factory()->create();
    $topic = Topic::factory()->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->post(route('topics.store', ['id' => $topic->id]), [
        // TODO: send request data
    ]);

    $response->assertOk();

    // TODO: perform additional assertions
});

test('unpin returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $topic = Topic::factory()->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->post(route('topics.unpin', ['id' => $topic->id]), [
        // TODO: send request data
    ]);

    $response->assertOk();

    // TODO: perform additional assertions
});

test('update returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $topic = Topic::factory()->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->patch(route('topics.update', ['id' => $topic->id]), [
        // TODO: send request data
    ]);

    $response->assertOk();

    // TODO: perform additional assertions
});

test('update aborts with a 403', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $topic = Topic::factory()->create();
    $user = User::factory()->create();

    // TODO: perform additional setup to trigger `abort_unless(403)`...

    $response = $this->actingAs($user)->patch(route('topics.update', ['id' => $topic->id]), [
        // TODO: send request data
    ]);

    $response->assertForbidden();
});

// test cases...
