<?php

declare(strict_types=1);

/**
 * NOTICE OF LICENSE.
 *
 * UNIT3D Community Edition is open-sourced software licensed under the GNU Affero General Public License v3.0
 * The details is bundled with this project in the file LICENSE.txt.
 *
 * @project    UNIT3D Community Edition
 *
 * @author     HDVinnie <hdinnovations@protonmail.com>
 * @license    https://www.gnu.org/licenses/agpl-3.0.en.html/ GNU Affero General Public License v3.0
 */

use App\Http\Controllers\SubtitleController;
use App\Http\Requests\StoreSubtitleRequest;
use App\Http\Requests\UpdateSubtitleRequest;
use App\Models\MediaLanguage;
use App\Models\Subtitle;
use App\Models\Torrent;
use App\Models\User;

test('create returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $torrent = Torrent::factory()->create();
    $mediaLanguages = MediaLanguage::factory()->times(3)->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->get(route('subtitles.create'));

    $response->assertOk();
    $response->assertViewIs('subtitle.create');
    $response->assertViewHas('torrent', $torrent);
    $response->assertViewHas('media_languages');

    // TODO: perform additional assertions
});

test('destroy returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $subtitle = Subtitle::factory()->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->delete(route('subtitles.destroy', [$subtitle]));

    $response->assertOk();
    $this->assertModelMissing($subtitle);

    // TODO: perform additional assertions
});

test('destroy aborts with a 403', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $subtitle = Subtitle::factory()->create();
    $user = User::factory()->create();

    // TODO: perform additional setup to trigger `abort_unless(403)`...

    $response = $this->actingAs($user)->delete(route('subtitles.destroy', [$subtitle]));

    $response->assertForbidden();
});

test('download returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $subtitle = Subtitle::factory()->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->get(route('subtitles.download', [$subtitle]));

    $response->assertOk();

    // TODO: perform additional assertions
});

test('index returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $user = User::factory()->create();

    $response = $this->actingAs($user)->get(route('subtitles.index'));

    $response->assertOk();
    $response->assertViewIs('subtitle.index');

    // TODO: perform additional assertions
});

test('store validates with a form request', function (): void {
    $this->assertActionUsesFormRequest(
        SubtitleController::class,
        'store',
        StoreSubtitleRequest::class
    );
});

test('store returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $torrent = Torrent::factory()->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->post(route('subtitles.store'), [
        // TODO: send request data
    ]);

    $response->assertOk();

    // TODO: perform additional assertions
});

test('update validates with a form request', function (): void {
    $this->assertActionUsesFormRequest(
        SubtitleController::class,
        'update',
        UpdateSubtitleRequest::class
    );
});

test('update returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $subtitle = Subtitle::factory()->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->patch(route('subtitles.update', [$subtitle]), [
        // TODO: send request data
    ]);

    $response->assertOk();

    // TODO: perform additional assertions
});

test('update aborts with a 403', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $subtitle = Subtitle::factory()->create();
    $user = User::factory()->create();

    // TODO: perform additional setup to trigger `abort_unless(403)`...

    $response = $this->actingAs($user)->patch(route('subtitles.update', [$subtitle]), [
        // TODO: send request data
    ]);

    $response->assertForbidden();
});

// test cases...
