<?php

declare(strict_types=1);

/**
 * NOTICE OF LICENSE.
 *
 * UNIT3D Community Edition is open-sourced software licensed under the GNU Affero General Public License v3.0
 * The details is bundled with this project in the file LICENSE.txt.
 *
 * @project    UNIT3D Community Edition
 *
 * @author     HDVinnie <hdinnovations@protonmail.com>
 * @license    https://www.gnu.org/licenses/agpl-3.0.en.html/ GNU Affero General Public License v3.0
 */

use App\Http\Controllers\Staff\UserController;
use App\Http\Requests\Staff\UpdateUserRequest;
use App\Models\Group;
use App\Models\Internal;
use App\Models\User;

test('edit returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $user = User::factory()->create();
    $groups = Group::factory()->times(3)->create();
    $internals = Internal::factory()->times(3)->create();
    $authUser = User::factory()->create();

    $response = $this->actingAs($authUser)->get(route('staff.users.edit', [$user]));

    $response->assertOk();
    $response->assertViewIs('Staff.user.edit');
    $response->assertViewHas('user', $user);
    $response->assertViewHas('groups', $groups);
    $response->assertViewHas('internals', $internals);

    // TODO: perform additional assertions
});

test('index returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $user = User::factory()->create();

    $response = $this->actingAs($user)->get(route('staff.users.index'));

    $response->assertOk();
    $response->assertViewIs('Staff.user.index');

    // TODO: perform additional assertions
});

test('permissions returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $user = User::factory()->create();
    $authUser = User::factory()->create();

    $response = $this->actingAs($authUser)->patch(route('staff.users.update_permissions', [$user]), [
        // TODO: send request data
    ]);

    $response->assertOk();

    // TODO: perform additional assertions
});

test('update validates with a form request', function (): void {
    $this->assertActionUsesFormRequest(
        UserController::class,
        'update',
        UpdateUserRequest::class
    );
});

test('update returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $user = User::factory()->create();
    $group = Group::factory()->create();
    $authUser = User::factory()->create();

    $response = $this->actingAs($authUser)->patch(route('staff.users.update', [$user]), [
        // TODO: send request data
    ]);

    $response->assertOk();

    // TODO: perform additional assertions
});

test('update aborts with a 403', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $user = User::factory()->create();
    $group = Group::factory()->create();
    $authUser = User::factory()->create();

    // TODO: perform additional setup to trigger `abort_if(403)`...

    $response = $this->actingAs($authUser)->patch(route('staff.users.update', [$user]), [
        // TODO: send request data
    ]);

    $response->assertForbidden();
});

// test cases...
