<?php

declare(strict_types=1);

/**
 * NOTICE OF LICENSE.
 *
 * UNIT3D Community Edition is open-sourced software licensed under the GNU Affero General Public License v3.0
 * The details is bundled with this project in the file LICENSE.txt.
 *
 * @project    UNIT3D Community Edition
 *
 * @author     HDVinnie <hdinnovations@protonmail.com>
 * @license    https://www.gnu.org/licenses/agpl-3.0.en.html/ GNU Affero General Public License v3.0
 */

use App\Http\Controllers\Staff\MediaLanguageController;
use App\Http\Requests\Staff\StoreMediaLanguageRequest;
use App\Http\Requests\Staff\UpdateMediaLanguageRequest;
use App\Models\MediaLanguage;
use App\Models\User;

test('create returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $user = User::factory()->create();

    $response = $this->actingAs($user)->get(route('staff.media_languages.create'));

    $response->assertOk();
    $response->assertViewIs('Staff.media_language.create');

    // TODO: perform additional assertions
});

test('destroy returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $mediaLanguage = MediaLanguage::factory()->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->delete(route('staff.media_languages.destroy', [$mediaLanguage]));

    $response->assertOk();
    $this->assertModelMissing($mediaLanguage);

    // TODO: perform additional assertions
});

test('edit returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $mediaLanguage = MediaLanguage::factory()->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->get(route('staff.media_languages.edit', [$mediaLanguage]));

    $response->assertOk();
    $response->assertViewIs('Staff.media_language.edit');
    $response->assertViewHas('media_language');

    // TODO: perform additional assertions
});

test('index returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $mediaLanguages = MediaLanguage::factory()->times(3)->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->get(route('staff.media_languages.index'));

    $response->assertOk();
    $response->assertViewIs('Staff.media_language.index');
    $response->assertViewHas('media_languages');

    // TODO: perform additional assertions
});

test('store validates with a form request', function (): void {
    $this->assertActionUsesFormRequest(
        MediaLanguageController::class,
        'store',
        StoreMediaLanguageRequest::class
    );
});

test('store returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $user = User::factory()->create();

    $response = $this->actingAs($user)->post(route('staff.media_languages.store'), [
        // TODO: send request data
    ]);

    $response->assertOk();

    // TODO: perform additional assertions
});

test('update validates with a form request', function (): void {
    $this->assertActionUsesFormRequest(
        MediaLanguageController::class,
        'update',
        UpdateMediaLanguageRequest::class
    );
});

test('update returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $mediaLanguage = MediaLanguage::factory()->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->patch(route('staff.media_languages.update', [$mediaLanguage]), [
        // TODO: send request data
    ]);

    $response->assertOk();

    // TODO: perform additional assertions
});

// test cases...
