<?php

declare(strict_types=1);

/**
 * NOTICE OF LICENSE.
 *
 * UNIT3D Community Edition is open-sourced software licensed under the GNU Affero General Public License v3.0
 * The details is bundled with this project in the file LICENSE.txt.
 *
 * @project    UNIT3D Community Edition
 *
 * @author     HDVinnie <hdinnovations@protonmail.com>
 * @license    https://www.gnu.org/licenses/agpl-3.0.en.html/ GNU Affero General Public License v3.0
 */

use App\Http\Controllers\Staff\ForumController;
use App\Http\Requests\Staff\StoreForumRequest;
use App\Http\Requests\Staff\UpdateForumRequest;
use App\Models\Forum;
use App\Models\Group;
use App\Models\ForumPermission;
use App\Models\User;

test('create returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $forums = Forum::factory()->times(3)->create();
    $groups = Group::factory()->times(3)->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->get(route('staff.forums.create'));

    $response->assertOk();
    $response->assertViewIs('Staff.forum.create');
    $response->assertViewHas('categories');
    $response->assertViewHas('groups', $groups);

    // TODO: perform additional assertions
});

test('destroy returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $forum = Forum::factory()->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->delete(route('staff.forums.destroy', [$forum]));

    $response->assertOk();
    $this->assertModelMissing($forum);

    // TODO: perform additional assertions
});

test('edit returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $forum = Forum::factory()->create();
    $forums = Forum::factory()->times(3)->create();
    $groups = Group::factory()->times(3)->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->get(route('staff.forums.edit', [$forum]));

    $response->assertOk();
    $response->assertViewIs('Staff.forum.edit');
    $response->assertViewHas('categories');
    $response->assertViewHas('groups', $groups);
    $response->assertViewHas('forum', $forum);

    // TODO: perform additional assertions
});

test('store validates with a form request', function (): void {
    $this->assertActionUsesFormRequest(
        ForumController::class,
        'store',
        StoreForumRequest::class
    );
});

test('store returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $permission = ForumPermission::factory()->create();
    $groups = Group::factory()->times(3)->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->post(route('staff.forums.store'), [
        // TODO: send request data
    ]);

    $response->assertOk();

    // TODO: perform additional assertions
});

test('update validates with a form request', function (): void {
    $this->assertActionUsesFormRequest(
        ForumController::class,
        'update',
        UpdateForumRequest::class
    );
});

test('update returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $forum = Forum::factory()->create();
    $groups = Group::factory()->times(3)->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->patch(route('staff.forums.update', [$forum]), [
        // TODO: send request data
    ]);

    $response->assertOk();

    // TODO: perform additional assertions
});

// test cases...
