<?php

declare(strict_types=1);

/**
 * NOTICE OF LICENSE.
 *
 * UNIT3D Community Edition is open-sourced software licensed under the GNU Affero General Public License v3.0
 * The details is bundled with this project in the file LICENSE.txt.
 *
 * @project    UNIT3D Community Edition
 *
 * @author     HDVinnie <hdinnovations@protonmail.com>
 * @license    https://www.gnu.org/licenses/agpl-3.0.en.html/ GNU Affero General Public License v3.0
 */

use App\Models\Category;
use App\Models\Movie;
use App\Models\Tv;
use App\Models\User;

test('show returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $category = Category::factory()->create();
    $movie = Movie::factory()->create();
    $tv = Tv::factory()->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->get(route(
        'torrents.similar',
        ['category_id' => $category_id, 'tmdb' => $tmdb]
    ));

    $response->assertOk();
    $response->assertViewIs('torrent.similar');
    $response->assertViewHas('meta');
    $response->assertViewHas('personal_freeleech');
    $response->assertViewHas('trailer');
    $response->assertViewHas('platforms');
    $response->assertViewHas('category', $category);
    $response->assertViewHas('tmdb');
    $response->assertViewHas('igdb');

    // TODO: perform additional assertions
});

test('show aborts with a 404', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $category = Category::factory()->create();
    $movie = Movie::factory()->create();
    $tv = Tv::factory()->create();
    $user = User::factory()->create();

    // TODO: perform additional setup to trigger `abort_unless(404)`...

    $response = $this->actingAs($user)->get(route(
        'torrents.similar',
        ['category_id' => $category_id, 'tmdb' => $tmdb]
    ));

    $response->assertNotFound();
});

// test cases...
