<?php

declare(strict_types=1);

/**
 * NOTICE OF LICENSE.
 *
 * UNIT3D Community Edition is open-sourced software licensed under the GNU Affero General Public License v3.0
 * The details is bundled with this project in the file LICENSE.txt.
 *
 * @project    UNIT3D Community Edition
 *
 * @author     HDVinnie <hdinnovations@protonmail.com>
 * @license    https://www.gnu.org/licenses/agpl-3.0.en.html/ GNU Affero General Public License v3.0
 */

use App\Models\Post;
use App\Models\Topic;
use App\Models\User;

test('destroy returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $post = Post::factory()->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->delete(route('posts.destroy', ['id' => $post->id]));

    $response->assertOk();
    $this->assertModelMissing($post);

    // TODO: perform additional assertions
});

test('destroy aborts with a 403', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $post = Post::factory()->create();
    $user = User::factory()->create();

    // TODO: perform additional setup to trigger `abort_unless(403)`...

    $response = $this->actingAs($user)->delete(route('posts.destroy', ['id' => $post->id]));

    $response->assertForbidden();
});

test('edit returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $post = Post::factory()->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->get(route('posts.edit', ['id' => $post->id]));

    $response->assertOk();
    $response->assertViewIs('forum.post.edit');
    $response->assertViewHas('topic');
    $response->assertViewHas('forum');
    $response->assertViewHas('post', $post);
    $response->assertViewHas('category');

    // TODO: perform additional assertions
});

test('edit aborts with a 403', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $post = Post::factory()->create();
    $user = User::factory()->create();

    // TODO: perform additional setup to trigger `abort_unless(403)`...

    $response = $this->actingAs($user)->get(route('posts.edit', ['id' => $post->id]));

    $response->assertForbidden();
});

test('index returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $user = User::factory()->create();

    $response = $this->actingAs($user)->get(route('posts.index'));

    $response->assertOk();
    $response->assertViewIs('forum.post.index');

    // TODO: perform additional assertions
});

test('store returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $topic = Topic::factory()->create();
    $users = User::factory()->times(3)->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->post(route('posts.store'), [
        // TODO: send request data
    ]);

    $response->assertRedirect(withSuccess(trans('forum.reply-topic-success')));

    // TODO: perform additional assertions
});

test('update returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $post = Post::factory()->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->patch(route('posts.update', ['id' => $post->id]), [
        // TODO: send request data
    ]);

    $response->assertRedirect(withSuccess(trans('forum.edit-post-success')));

    // TODO: perform additional assertions
});

// test cases...
