<?php

declare(strict_types=1);

/**
 * NOTICE OF LICENSE.
 *
 * UNIT3D Community Edition is open-sourced software licensed under the GNU Affero General Public License v3.0
 * The details is bundled with this project in the file LICENSE.txt.
 *
 * @project    UNIT3D Community Edition
 *
 * @author     HDVinnie <hdinnovations@protonmail.com>
 * @license    https://www.gnu.org/licenses/agpl-3.0.en.html/ GNU Affero General Public License v3.0
 */

use App\Http\Controllers\ClaimController;
use App\Http\Requests\StoreTorrentRequestClaimRequest;
use App\Models\TorrentRequest;
use App\Models\TorrentRequestClaim;
use App\Models\User;

test('destroy returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $torrentRequest = TorrentRequest::factory()->create();
    $torrentRequestClaim = TorrentRequestClaim::factory()->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->delete(route('requests.claims.destroy', [$torrentRequest, 'claim' => $claim]));

    $response->assertOk();
    $this->assertModelMissing($claim);

    // TODO: perform additional assertions
});

test('destroy aborts with a 403', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $torrentRequest = TorrentRequest::factory()->create();
    $torrentRequestClaim = TorrentRequestClaim::factory()->create();
    $user = User::factory()->create();

    // TODO: perform additional setup to trigger `abort_unless(403)`...

    $response = $this->actingAs($user)->delete(route('requests.claims.destroy', [$torrentRequest, 'claim' => $claim]));

    $response->assertForbidden();
});

test('store validates with a form request', function (): void {
    $this->assertActionUsesFormRequest(
        ClaimController::class,
        'store',
        StoreTorrentRequestClaimRequest::class
    );
});

test('store returns an ok response', function (): void {
    $this->markTestIncomplete('This test case was generated by Shift. When you are ready, remove this line and complete this test case.');

    $torrentRequest = TorrentRequest::factory()->create();
    $user = User::factory()->create();

    $response = $this->actingAs($user)->post(route('requests.claims.store', [$torrentRequest]), [
        // TODO: send request data
    ]);

    $response->assertOk();

    // TODO: perform additional assertions
});

// test cases...
