<?php

declare(strict_types=1);
/**
 * NOTICE OF LICENSE.
 *
 * UNIT3D Community Edition is open-sourced software licensed under the GNU Affero General Public License v3.0
 * The details is bundled with this project in the file LICENSE.txt.
 *
 * @project    UNIT3D Community Edition
 *
 * @author     HDVinnie <hdinnovations@protonmail.com>
 * @license    https://www.gnu.org/licenses/agpl-3.0.en.html/ GNU Affero General Public License v3.0
 */

return [
    'about'                         => 'About',
    'about-me'                      => 'About Me',
    'accepted-at'                   => 'Accepted at',
    'accepted-by'                   => 'Accepted by',
    'account-notification'          => 'Account Notification Settings',
    'account-notification-follow'   => 'Receive a notification when a user follows your account',
    'account-notification-unfollow' => 'Receive a notification when a user unfollows your account',
    'account-notification-help'     => 'Control which notifications are sent concerning your account.
    These settings are overridden if you do not allow any groups to send notifications concerning your account or if you <strong>Disable Notifications</strong>',
    'account-settings'         => 'Account Settings',
    'achievement-privacy'      => 'Achievement Settings',
    'achievement-privacy-list' => 'Allow users to view a list of your achievements',
    'achievement-help'         => 'Control the sharing of specific achievement related information with groups that are allowed to access to your profile.
    These settings are overridden if you do not allow any groups to access your achievements or if you <strong>Go Private</strong>',
    'achievements'          => 'Achievements',
    'active'                => 'Active',
    'active-table'          => 'My Active Table',
    'active-torrents'       => 'Active Torrents',
    'active-warning'        => 'Active Warning',
    'active-warnings'       => 'Active Warnings',
    'add-seedbox'           => 'Add Seedbox',
    'all-torrents'          => 'All Torrents',
    'apikey'                => 'API Key',
    'apikeys'               => 'API Keys',
    'article-comments'      => 'Article Comments Made',
    'avatar'                => 'Avatar',
    'avg-seedtime'          => 'Average Seedtime',
    'badges'                => 'Badges',
    'ban'                   => 'Ban User',
    'bans'                  => 'Bans',
    'ban-log'               => 'Ban Log',
    'become-hidden'         => 'Become Hidden',
    'become-visible'        => 'Become Visible',
    'bon'                   => 'BON',
    'bon-notification'      => 'BON Notification Settings',
    'bon-notification-gift' => 'Receive a notification when a user gifts you bon',
    'bon-notification-help' => 'Control which notifications are sent concerning BON transactions.
    These settings are overridden if you do not allow any groups to send notifications concerning BON or if you <strong>Disable Notifications</strong>',
    'bookmarks'                 => 'Bookmarks',
    'bounty-given'              => 'Bounty Given',
    'bounty-received'           => 'Bounty Received',
    'can-chat'                  => 'Can Chat',
    'can-comment'               => 'Can Comment',
    'can-download'              => 'Can Download',
    'can-invite'                => 'Can Invite',
    'can-request'               => 'Can Request',
    'can-upload'                => 'Can Upload',
    'certified-banker'          => 'Certified Banker',
    'certified-banker-desc'     => 'Has 50,000 Or More BON In Bank',
    'certified-downloader'      => 'Certified Downloader',
    'certified-downloader-desc' => 'Downloaded 100 or More Torrents!',
    'certified-seeder'          => 'Certified Seeder',
    'certified-seeder-desc'     => 'Seeding 150 or More Torrents!',
    'change-email'              => 'Change Email',
    'change-email-help'         => 'You will have to re-confirm your account, after you change your email',
    'change-password'           => 'Change Password',
    'change-password-help'      => 'You will have to login again, after you change your password',
    'client-connectable-state'  => '{0}No|{1}Yes',
    'client-list'               => 'Clients and IP-Addresses',
    'client-ip-address'         => 'Client IP Address',
    'code'                      => 'Code',
    'comments'                  => 'Comments',
    'created'                   => 'Created',
    'created-on'                => 'Created on',
    'credited-download'         => 'Credited Download',
    'credited-upload'           => 'Credited Upload',
    'current-password'          => 'Current Password',
    'custom-title'              => 'Custom Title',
    'deactivate'                => 'Deactivate',
    'deactivate-all'            => 'Deactivate All',
    'delete'                    => 'Delete User',
    'delete-all'                => 'Delete All',
    'deleted-by'                => 'Deleted By',
    'deleted-on'                => 'Deleted On',
    'disable-notifications'     => 'Disable Notifications',
    'disclaimer'                => 'Disclaimer',
    'disclaimer-info'           => 'We by default do not log users IP addresses like most trackers. By adding your seedbox IP below it is expected that you know your IPs listed below are now stored in our database unless you delete the records.',
    'disclaimer-info-bordered'  => 'Seedbox IPs added will then trigger high speed torrent tag on torrents seeded from IPs listed below',
    'download-bon'              => 'Download Removed from BON Store',
    'download-recorded'         => 'Recorded Download',
    'download-true'             => 'True Download',
    'downloads'                 => 'Downloads',
    'edit'                      => 'Edit User',
    'edit-profile'              => 'Edit Profile',
    'email-updates'             => 'Email Updates',
    'enable-notifications'      => 'Enable Notifications',
    'expired'                   => 'Expired',
    'expires-on'                => 'Expires On',
    'extra'                     => 'Extra',
    'filled-request'            => 'Filled Members Requests',
    'follow'                    => 'Follow',
    'follow-already'            => 'You are already following this user',
    'follow-not-to-begin-with'  => 'You are not following this user to begin with',
    'follow-revoked'            => 'You are no longer following %s',
    'follow-user'               => 'You are now following %s',
    'follow-yourself'           => 'Nice try, but sadly you can not follow yourself.',
    'follower-privacy'          => 'Follower Settings',
    'follower-privacy-list'     => 'Allow users to view a list of your followers',
    'follower-help'             => 'Control the sharing of specific follower related information with groups that are allowed to access to your profile.
    These settings are overridden if you do not allow any groups to access your followers or if you <strong>Go Private</strong>',
    'followers'                     => 'Followers',
    'following'                     => 'Following',
    'following-notification'        => 'Followed User Notification Settings',
    'following-notification-upload' => 'Receive a notification when a followed user uploads a torrent',
    'following-notification-help'   => 'Control which notifications are sent concerning followed user site actions.
    These settings are overridden if you do not allow any groups to send notifications concerning followed users or if you <strong>Disable Notifications</strong>',
    'formats-are-supported'    => ':formats are supported',
    'forum-notification'       => 'Forum Notification Settings',
    'forum-notification-topic' => 'Receive a notification when a topic that you started gets a new post',
    'forum-notification-help'  => 'Control which notifications are sent concerning forum activities.
    These settings are overridden if you do not allow any groups to send notifications concerning forum activities or if you <strong>Disable Notifications</strong>',
    'forum-privacy'       => 'Forum Settings',
    'forum-privacy-post'  => 'Allow users to view a list of forum posts that you have posted',
    'forum-privacy-topic' => 'Allow users to view a list of forum topics that you have started',
    'forum-help'          => 'Control the sharing of specific forum related statistics and information with groups that are allowed to access to your profile.
    These settings are overridden if you do not allow any groups to access your forum related statistics and information or if you <strong>Go Private</strong>',
    'forum-signature'                      => 'Forum Signature',
    'forums'                               => 'Forums',
    'general'                              => 'General',
    'general-settings'                     => 'General Settings',
    'gift-given'                           => 'Gift Given',
    'gift-received'                        => 'Gift Received',
    'go-public'                            => 'Go Public',
    'go-private'                           => 'Go Private',
    'history'                              => 'History',
    'history-table'                        => 'My History Table',
    'hit-n-runs'                           => 'Hit and Runs',
    'hit-n-runs-count'                     => 'Hit and Run Count (All Time)',
    'hit-n-runs-history'                   => 'Torrent Hit and Runs History',
    'id-permissions'                       => 'ID & Permissions',
    'image'                                => 'Image',
    'important'                            => 'Important',
    'important-info'                       => 'Important Info',
    'information'                          => 'Information',
    'internal-releases'                    => 'Internal Releases',
    'invited-by'                           => 'Invited By',
    'invite-already-sent'                  => 'The email address your trying to send a invite to has already been sent one.',
    'invite-already-used'                  => 'The invite you are trying to resend has already been used.',
    'invite-expired'                       => 'The invite you are trying to resend has expired.',
    'invite-friend'                        => 'Invite your friend (Email + Message Required)',
    'invite-resent-success'                => 'Invite was resent successfully!',
    'invite-sent-success'                  => 'Invite was sent successfully!',
    'invite-tree'                          => 'Invite Tree',
    'invites'                              => 'Invites',
    'invites-banned'                       => 'Error: Your Invite Rights Have Been Disabled',
    'invites-banned-desc'                  => 'If You Feel This Is In Error, Please Contact Staff!',
    'invites-count'                        => 'You Have :count Invite Tokens',
    'invites-disabled'                     => 'Attention: Invites Are Disabled Due To Open Registration!',
    'invites-disabled-desc'                => 'Please Check Back Soon!',
    'invites-disabled-group'               => 'Invites are currently disabled for your group.',
    'invites-rules'                        => '<li class="text-success">Only invite people you know and trust.</li><li class="text-danger">You will be held personally responsible for those you invite.</li><li class="text-danger">Dont invite yourself, we check every invited user.</li><li class="text-danger">Dont trade or sell Invites.</li><li class="text-danger">If a person you invited is caught cheating, trading account or selling/trading invites, you will be warned.</li>',
    'invites-send'                         => 'Invites Send',
    'judge'                                => 'Judge',
    'last-login'                           => 'Last Login',
    'last-action'                          => 'Last Action',
    'locked'                               => 'Locked',
    'locked-achievements'                  => 'Locked Achievements',
    'member-since'                         => 'Member Since',
    'members-desc'                         => 'List of users registered on :title in all groups. Find a user now.',
    'mention-notification'                 => '@Mention Notification Settings',
    'mention-notification-article-comment' => 'Receive a notification when you are @mentioned in an article comment',
    'mention-notification-torrent-comment' => 'Receive a notification when you are @mentioned in a torrent comment',
    'mention-notification-request-comment' => 'Receive a notification when you are @mentioned in a request comment',
    'mention-notification-forum-post'      => 'Receive a notification when you are @mentioned in a forum post',
    'mention-notification-help'            => 'Control which notifications are sent when a user @mentions you.
    These settings are overridden if you do not allow any groups to send notifications if a user @mentions you or if you <strong>Disable Notifications</strong>',
    'moderated-by'                   => 'Moderated by :mod on',
    'my-achievements'                => 'My Achievements',
    'my-bonus-points'                => 'My Bonus Points',
    'my-bookmarks'                   => 'My Bookmarks',
    'my-downloads'                   => 'My Downloads',
    'my-fl-tokens'                   => 'My FL tokens',
    'my-general-settings'            => 'My General Settings',
    'my-notification'                => 'My Notification',
    'my-notification-settings'       => 'My Notification Settings',
    'my-playlists'                   => 'My Playlists',
    'my-privacy'                     => 'My Privacy',
    'my-privacy-settings'            => 'My Privacy Settings',
    'my-profile'                     => 'My Profile',
    'my-requested'                   => 'My Requested',
    'my-security'                    => 'My Security',
    'my-security-settings'           => 'My Security Settings',
    'my-seedboxes'                   => 'My Seedboxes',
    'my-settings'                    => 'My Settings',
    'my-uploads'                     => 'My Uploads',
    'my-wishlist'                    => 'My Wishlist',
    'no-ban'                         => 'The are no bans in the database for this user!',
    'no-logs'                        => 'The are no invite logs in the database for this user!',
    'no-seedboxes'                   => 'No Seedboxes 😔',
    'no-soft-warning'                => 'There are no soft deleted warnings in the database for this user!',
    'no-warning'                     => 'The are no warnings in the database for this user!',
    'not-authorized'                 => 'You are not authorized to view this page. This member prefers to be hidden like a ninja!',
    'not-enough-invites'             => 'You do not have enough invites!',
    'not-satisfied-not-immune'       => 'Not Satisfied / Not Immune',
    'note'                           => 'Note',
    'notification'                   => 'Notification',
    'notification-settings'          => 'Notification Settings',
    'notification-from-account'      => 'Receive Account Notifications From',
    'notification-from-account-help' => 'You will only receive account notifications from the system, staff and the following groups.
    These settings are overridden if you <strong>Disable Notifications</strong>',
    'notification-from-bon'      => 'Receive BON Notifications From',
    'notification-from-bon-help' => 'You will only receive BON notifications from the system, staff and the following groups.
    These settings are overridden if you <strong>Disable Notifications</strong>',
    'notification-from-following'      => 'Receive Followed User Notifications From',
    'notification-from-following-help' => 'You will only receive followed user notifications from the following groups.
    These settings are overridden if you <strong>Disable Notifications</strong>',
    'notification-from-forum'      => 'Receive Forum Notifications From',
    'notification-from-forum-help' => 'You will only receive forum notifications from the system, staff and the following groups.
    These settings are overridden if you <strong>Disable Notifications</strong>',
    'notification-from-subscription'      => 'Receive Subscription Notifications From',
    'notification-from-subscription-help' => 'You will only receive forum notifications from the system, staff and the following groups.
    These settings are overridden if you <strong>Disable Notifications</strong>',
    'notification-from-torrent'      => 'Receive Torrent Notifications From',
    'notification-from-torrent-help' => 'You will only receive torrent notifications from the system, staff and the following groups.
    These settings are overridden if you <strong>Disable Notifications</strong>',
    'notification-from-mention'      => 'Receive @Mention Notifications From',
    'notification-from-mention-help' => 'You will only receive @mention notifications from the system, staff and the following groups.
    These settings are overridden if you <strong>Disable Notifications</strong>',
    'notification-from-request'      => 'Receive Request Notifications From',
    'notification-from-request-help' => 'You will only receive request notifications from the system, staff and the following groups.
    These settings are overridden if you <strong>Disable Notifications</strong>',
    'notifications'     => 'Notifications',
    'offline'           => 'User is Offline!',
    'online'            => 'User is Online!',
    'open-registration' => 'Open Registration',
    'options'           => 'Options',
    'other-help'        => 'Control the sharing of other statistics and information with groups that are allowed to access to your profile.
    These settings are overridden if you do not allow any groups to access your other statistics and information or if you <strong>Go Private</strong>',
    'other-privacy'                 => 'Other Settings',
    'other-privacy-online'          => 'Allow users to see you in the online users block',
    'passkey'                       => 'Passkey',
    'passkey-warning'               => 'PID is like your password, you must keep it safe!',
    'password-resets'               => 'Password Resets',
    'pending-achievements'          => 'Pending Achievements',
    'per-torrent'                   => 'Per Torrent',
    'posts'                         => 'Posts',
    'posts-posted'                  => 'Forum Posts Posted',
    'privacy'                       => 'Privacy',
    'privacy-settings'              => 'Privacy Settings',
    'private-info'                  => 'Private Info',
    'private-forum-profile'         => 'Attention: This Member\'s Topic & Post History Has Been Set To PRIVATE!',
    'private-profile'               => 'Attention: This Profile Has Been Set To PRIVATE!',
    'profile'                       => 'Profile',
    'profile-desc'                  => 'User :user profile registered on :title',
    'profile-privacy'               => 'Profile Settings',
    'profile-privacy-torrent-count' => 'Share your total number of downloads, uploads, seeds and leeches',
    'profile-privacy-torrent-ratio' => 'Share your total upload/download data along with recorded ratio',
    'profile-privacy-torrent-seed'  => 'Share your total seeding time and average',
    'profile-privacy-title'         => 'Share your personal title information',
    'profile-privacy-about'         => 'Share your personal about me information',
    'profile-privacy-bon-extra'     => 'Share your BON statistics',
    'profile-privacy-comment-extra' => 'Share your comment statistics',
    'profile-privacy-forum-extra'   => 'Share your forum statistics',
    'profile-privacy-request-extra' => 'Share your request statistics',
    'profile-privacy-torrent-extra' => 'Share your torrent statistics',
    'profile-privacy-badge'         => 'Share your earned badges',
    'profile-privacy-achievement'   => 'Share your recent achievements',
    'profile-privacy-follower'      => 'Share your recent followers',
    'profile-privacy-warning'       => 'Share your H&R warnings',
    'profile-privacy-help'          => 'Control which statistics and pieces of information appear on your profile.
    These settings are overridden if you do not allow any groups to access your profile or if you <strong>Go Private</strong>',
    'public-info'         => 'Public Info',
    'reactivate'          => 'Reactivate',
    'reason-ban'          => 'Ban Reason',
    'reason-unban'        => 'Unban Reason',
    'recent-achievements' => 'Recent Achievements',
    'recent-followers'    => 'Recent Followers',
    'registration-date'   => 'Registration date',
    'removed'             => 'Removed',
    'report'              => 'Report',
    'report-sent'         => 'Your report has been successfully sent',
    'request-help'        => 'Control the sharing of specific request related statistics and information with groups that are allowed to access to your profile.
    These settings are overridden if you do not allow any groups to access your requested related statistics and information or if you <strong>Go Private</strong>',
    'request'                           => 'Request',
    'requested'                         => 'Requested',
    'requests'                          => 'Requests',
    'request-comments'                  => 'Request Comments Made',
    'request-notification'              => 'Request Notification Settings',
    'request-notification-bounty'       => 'Receive a notification when a requested torrent gets a new bounty',
    'request-notification-comment'      => 'Receive a notification when a requested torrent gets a new comment',
    'request-notification-fill'         => 'Receive a notification when a requested torrent gets filled',
    'request-notification-fill-approve' => 'Receive a notification when a requested torrent fill gets approved',
    'request-notification-fill-reject'  => 'Receive a notification when a requested torrent fill gets rejected',
    'request-notification-claim'        => 'Receive a notification when a requested torrent gets claimed',
    'request-notification-unclaim'      => 'Receive a notification when a requested torrent gets unclaimed',
    'request-notification-help'         => 'Control which notifications are sent concerning request activities.
    These settings are overridden if you do not allow any groups to send notifications concerning request activities or if you <strong>Disable Notifications</strong>',
    'request-privacy'                 => 'Request Settings',
    'request-privacy-requested'       => 'Allow users to view a list of requests that you have made',
    'reset-api-token'                 => 'Reset API Token',
    'reset-api-help'                  => 'You will have to update any scripts or applications you are using with your new token, after resetting the API Token',
    'reset-passkey'                   => 'Reset Pass Key (PID)',
    'reset-passkey-help'              => 'You will have to re-download all of your active torrents, after resetting the PID',
    'reset-rss'                       => 'Reset RSS Key (RID)',
    'reset-rss-help'                  => 'You will have to re-load all of your active RSS feeds, after resetting the RID',
    'resurrections'                   => 'Resurrections',
    'restore'                         => 'Restore',
    'rsskey'                          => 'RSS Key',
    'rsskeys'                         => 'RSS Keys',
    'satisfied-immune'                => 'Satisfied / Immune',
    'search'                          => 'Quick Search by Username/Email',
    'security'                        => 'Security',
    'security-settings'               => 'Security Settings',
    'seedbox-added-success'           => 'Seedbox Has Been Successfully Added!',
    'seedbox-deleted-success'         => 'Seedbox Has Been Successfully Deleted',
    'seedboxes'                       => 'Seedboxes',
    'seeding-size'                    => 'Seeding Size',
    'seeds'                           => 'Seeds',
    'send-invite'                     => 'Send Invite',
    'sender'                          => 'Sender',
    'settings'                        => 'Settings',
    'show-passkey'                    => 'Show PID',
    'soft-deleted-warnings'           => 'Soft Deleted Warnings',
    'staff-noted'                     => 'Staff Noted Account',
    'statistics'                      => 'Statistics',
    'subscription-notification'       => 'Subscription Notification Settings',
    'subscription-notification-forum' => 'Receive a notification when a subscribed forum gets a new topic',
    'subscription-notification-topic' => 'Receive a notification when a subscribed topic gets a new post',
    'subscription-notification-help'  => 'Control which notifications are sent concerning your subscriptions.
    These settings are overridden if you do not allow any groups to send notifications concerning your subscriptions or if you <strong>Disable Notifications</strong>',
    'thanks-given'         => 'Thanks Given',
    'thanks-received'      => 'Thanks Received',
    'tips-given'           => 'Tips Given',
    'tips-received'        => 'Tips Received',
    'title'                => 'Title',
    'top-bankers'          => 'Top Bankers',
    'top-bountied'         => 'Top Bountied',
    'top-completed'        => 'Top Completed',
    'top-downloaders-data' => 'Top Downloaders (Data)',
    'top-dead'             => 'Top Dead',
    'top-dying'            => 'Top Dying',
    'top-leeched'          => 'Top Leeched',
    'top-leechers'         => 'Top Leechers',
    'top-leechers-count'   => 'Top Leechers (Count)',
    'top-seeded'           => 'Top Seeded',
    'top-seeders'          => 'Top Seeders',
    'top-seeders-count'    => 'Top Seeders (Count)',
    'top-seeding-size'     => 'Top Seeding (Size)',
    'top-seedtime'         => 'Top Seedtime',
    'top-uploaders-data'   => 'Top Uploaders (Data)',
    'top-uploaders-count'  => 'Top Uploaders (Count)',
    'topics'               => 'Topics',
    'topics-started'       => 'Forum Topics Started',
    'torrent-comments'     => 'Torrent Comments Made',
    'torrent-help'         => 'Control the sharing of specific torrent related statistics and information with groups that are allowed to access to your profile.
    These settings are overridden if you do not allow any groups to access your torrent related statistics and information or if you <strong>Go Private</strong>',
    'torrent-notification'         => 'Torrent Notification Settings',
    'torrent-notification-comment' => 'Receive a notification when an uploaded torrent gets a new comment',
    'torrent-notification-thank'   => 'Receive a notification when an uploaded torrent gets a new thank',
    'torrent-notification-tip'     => 'Receive a notification when an uploaded torrent gets a new tip',
    'torrent-notification-help'    => 'Control which notifications are sent concerning torrent activities.
    These settings are overridden if you do not allow any groups to send notifications concerning torrent activities or if you <strong>Disable Notifications</strong>',
    'torrent-privacy'          => 'Torrent Settings',
    'torrent-privacy-download' => 'Allow users to view a list of torrents that you have downloaded',
    'torrent-privacy-upload'   => 'Allow users to view a list of torrents that you have uploaded',
    'torrent-privacy-peer'     => 'Allow users to see you in the torrent peer history table',
    'torrents'                 => 'Torrents',
    'torrents-history'         => 'Torrents History',
    'total-download'           => 'Total Download',
    'total-downloads'          => 'Total Downloads',
    'total-internal-releases'  => 'Total Internal Releases',
    'total-leeching'           => 'Total Leeching',
    'total-seeding'            => 'Total Seeding',
    'total-seedtime'           => 'Total Seedtime',
    'total-upload'             => 'Total Upload',
    'total-uploads'            => 'Total Uploads',
    'total-personal-releases'  => 'Total Personal Releases',
    'two-step-auth'            => [
        'title'                     => 'Two-Factor Authentication',
        'totp'                      => 'Time-based One-time Password (TOTP) Authentication',
        'email'                     => 'Email Authentication',
        'totp-is-enabled'           => 'TOTP Authentication is currently enabled. To disable it, please click the \'Disable\' button below.',
        'totp-is-disabled'          => 'TOTP Authentication is currently disabled. To enable it, please click the \'Enable\' button below.',
        'password-confirm'          => 'Requires password confirmation',
        'upon-enabling'             => 'Upon enabling, you will be required to enter a valid two factor authentication code.',
        'complete-setup'            => 'To finish enabling TOTP Authentication, please scan the barcode below with you Authentication App (Google Authenticator, Authy, BitWarden, etc.) and enter the TOTP code in the form below.',
        'confirm-code'              => 'Confirm TOTP Code',
        'recovery-code'             => 'Time-based One-time Password (TOTP) Recovery Codes',
        'recovery-code-description' => 'Click the \'Reveal\' button to show your recovery codes for your account. Save these codes securely offline in case you lose access to your TOTP device. If you feel these codes could have been compromised, please click the  \'Reset\' to generate a new set of codes.',
        'recovery-code-reveal'      => 'Reveal',
        'recovery-code-reset'       => 'Reset',
    ],
    'unban'                       => 'Unban User',
    'unfollow'                    => 'Unfollow',
    'unlocked'                    => 'Unlocked',
    'unlocked-achievements'       => 'Unlocked Achievements',
    'unsatisfieds'                => 'Unsatisfieds',
    'upload-bon'                  => 'Upload Added from BON Store',
    'upload-recorded'             => 'Recorded Upload',
    'upload-snatches'             => 'Upload Snatches',
    'upload-true'                 => 'True Upload',
    'uploads'                     => 'Uploads',
    'uploads-table'               => 'Uploads Table',
    'personal-releases'           => 'Personal Releases',
    'user'                        => 'User',
    'user-id'                     => 'User ID',
    'username-seedbox'            => 'Username Seedbox',
    'visible-to-achievement'      => 'Achievements Visible To',
    'visible-to-achievement-help' => 'Your achievements will only be visible to staff and the following groups.
    These settings are overridden if you <strong>Go Private</strong>',
    'visible-to-follower'      => 'Followers Visible To',
    'visible-to-follower-help' => 'Your followers will only be visible to staff and the following groups.
    These settings are overridden if you <strong>Go Private</strong>',
    'visible-to-forum'      => 'Forum Information Visible To',
    'visible-to-forum-help' => 'Your forum information will only be visible to staff and the following groups.
    These settings are overridden if you <strong>Go Private</strong>',
    'visible-to-other'      => 'Other Visible To',
    'visible-to-other-help' => 'Other information concerning your account will only be visible to staff and the following groups.
    These settings are overridden if you <strong>Go Private</strong> or if you <strong>Go Hidden</strong>',
    'visible-to-profile'      => 'Profile Visible To',
    'visible-to-profile-help' => 'Your profile will only be visible to staff and the following groups.
    These settings are overridden if you <strong>Go Private</strong>',
    'visible-to-request'      => 'Request Information Visible To',
    'visible-to-request-help' => 'Your request information will only be visible to staff and the following groups.
    These settings are overridden if you <strong>Go Private</strong>',
    'visible-to-torrent'      => 'Torrent Information Visible To',
    'visible-to-torrent-help' => 'Your torrent information will only be visible to staff and the following groups.
    These settings are overridden if you <strong>Go Private</strong> or if you <strong>Go Hidden</strong>',
    'warned-by'   => 'Warned By',
    'warned-on'   => 'Warned On',
    'warning'     => 'Warning',
    'warnings'    => 'Warnings',
    'warning-log' => 'Warning Log',
    'wishlist'    => 'Wishlist',
];
