<?php

declare(strict_types=1);

/**
 * NOTICE OF LICENSE.
 *
 * UNIT3D Community Edition is open-sourced software licensed under the GNU Affero General Public License v3.0
 * The details is bundled with this project in the file LICENSE.txt.
 *
 * @project    UNIT3D Community Edition
 *
 * @author     HDVinnie <hdinnovations@protonmail.com>
 * @license    https://www.gnu.org/licenses/agpl-3.0.en.html/ GNU Affero General Public License v3.0
 */

namespace Database\Seeders;

use App\Models\Distributor;
use Illuminate\Database\Seeder;

class DistributorsTableSeeder extends Seeder
{
    public function run(): void
    {
        Distributor::upsert([
            [
                'id'   => 1,
                'name' => '01 Distribution',
            ],
            [
                'id'   => 2,
                'name' => '100 Destinations Travel Film',
            ],
            [
                'id'   => 3,
                'name' => '101 Films',
            ],
            [
                'id'   => 4,
                'name' => '1Films',
            ],
            [
                'id'   => 5,
                'name' => '2 Entertain Video',
            ],
            [
                'id'   => 6,
                'name' => '20th Century Fox',
            ],
            [
                'id'   => 7,
                'name' => '2L',
            ],
            [
                'id'   => 8,
                'name' => '3D Content Hub',
            ],
            [
                'id'   => 9,
                'name' => '3D Media',
            ],
            [
                'id'   => 10,
                'name' => '3L Film',
            ],
            [
                'id'   => 11,
                'name' => '4Digital',
            ],
            [
                'id'   => 12,
                'name' => '4dvd',
            ],
            [
                'id'   => 13,
                'name' => '4K Ultra HD Movies',
            ],
            [
                'id'   => 14,
                'name' => '8-Films',
            ],
            [
                'id'   => 15,
                'name' => '84 Entertainment',
            ],
            [
                'id'   => 16,
                'name' => '88 Films',
            ],
            [
                'id'   => 17,
                'name' => '@Anime',
            ],
            [
                'id'   => 18,
                'name' => 'A Contracorriente',
            ],
            [
                'id'   => 19,
                'name' => 'A Contracorriente Films',
            ],
            [
                'id'   => 20,
                'name' => 'A&E Home Video',
            ],
            [
                'id'   => 21,
                'name' => 'A&M Records',
            ],
            [
                'id'   => 22,
                'name' => 'A+E Networks',
            ],
            [
                'id'   => 23,
                'name' => 'A+R',
            ],
            [
                'id'   => 24,
                'name' => 'A-film',
            ],
            [
                'id'   => 25,
                'name' => 'AAA',
            ],
            [
                'id'   => 26,
                'name' => 'AB Vidéo',
            ],
            [
                'id'   => 27,
                'name' => 'ABC - (Australian Broadcasting Corporation)',
            ],
            [
                'id'   => 28,
                'name' => 'abkco',
            ],
            [
                'id'   => 29,
                'name' => 'Absolut Medien',
            ],
            [
                'id'   => 30,
                'name' => 'Absolute',
            ],
            [
                'id'   => 31,
                'name' => 'Accent Film Entertainment',
            ],
            [
                'id'   => 32,
                'name' => 'Accentus',
            ],
            [
                'id'   => 33,
                'name' => 'Acorn Media',
            ],
            [
                'id'   => 34,
                'name' => 'Ad Vitam',
            ],
            [
                'id'   => 35,
                'name' => 'Ada',
            ],
            [
                'id'   => 36,
                'name' => 'Aditya Videos',
            ],
            [
                'id'   => 37,
                'name' => 'ADSO Films',
            ],
            [
                'id'   => 38,
                'name' => 'AFM Records',
            ],
            [
                'id'   => 39,
                'name' => 'AGFA',
            ],
            [
                'id'   => 40,
                'name' => 'AIX Records',
            ],
            [
                'id'   => 41,
                'name' => 'Alamode Film',
            ],
            [
                'id'   => 42,
                'name' => 'Alba Records',
            ],
            [
                'id'   => 43,
                'name' => 'Albany Records',
            ],
            [
                'id'   => 44,
                'name' => 'Albatros',
            ],
            [
                'id'   => 45,
                'name' => 'Alchemy',
            ],
            [
                'id'   => 46,
                'name' => 'Alive',
            ],
            [
                'id'   => 47,
                'name' => 'All Anime',
            ],
            [
                'id'   => 48,
                'name' => 'All Interactive Entertainment',
            ],
            [
                'id'   => 49,
                'name' => 'Allegro',
            ],
            [
                'id'   => 50,
                'name' => 'Alliance',
            ],
            [
                'id'   => 51,
                'name' => 'Alpha Music',
            ],
            [
                'id'   => 52,
                'name' => 'AlterDystrybucja',
            ],
            [
                'id'   => 53,
                'name' => 'Altered Innocence',
            ],
            [
                'id'   => 54,
                'name' => 'Altitude Film Distribution',
            ],
            [
                'id'   => 55,
                'name' => 'Alucard Records',
            ],
            [
                'id'   => 56,
                'name' => 'Amazing D.C.',
            ],
            [
                'id'   => 57,
                'name' => 'Ammo Content',
            ],
            [
                'id'   => 58,
                'name' => 'Amuse Soft Entertainment',
            ],
            [
                'id'   => 59,
                'name' => 'ANConnect',
            ],
            [
                'id'   => 60,
                'name' => 'Anec',
            ],
            [
                'id'   => 61,
                'name' => 'Animatsu',
            ],
            [
                'id'   => 62,
                'name' => 'Anime House',
            ],
            [
                'id'   => 63,
                'name' => 'Anime Ltd',
            ],
            [
                'id'   => 64,
                'name' => 'Anime Works',
            ],
            [
                'id'   => 65,
                'name' => 'AnimEigo',
            ],
            [
                'id'   => 66,
                'name' => 'Aniplex',
            ],
            [
                'id'   => 67,
                'name' => 'Anolis Entertainment',
            ],
            [
                'id'   => 68,
                'name' => 'Another World Entertainment',
            ],
            [
                'id'   => 69,
                'name' => 'AP International',
            ],
            [
                'id'   => 70,
                'name' => 'Apple',
            ],
            [
                'id'   => 71,
                'name' => 'Ara Media',
            ],
            [
                'id'   => 72,
                'name' => 'Arbelos',
            ],
            [
                'id'   => 73,
                'name' => 'Arc Entertainment',
            ],
            [
                'id'   => 74,
                'name' => 'ARP Sélection',
            ],
            [
                'id'   => 75,
                'name' => 'Arrow',
            ],
            [
                'id'   => 76,
                'name' => 'Art Service',
            ],
            [
                'id'   => 77,
                'name' => 'Art Vision',
            ],
            [
                'id'   => 78,
                'name' => 'Arte Éditions',
            ],
            [
                'id'   => 79,
                'name' => 'Arte Vidéo',
            ],
            [
                'id'   => 80,
                'name' => 'Arthaus Musik',
            ],
            [
                'id'   => 81,
                'name' => 'Artificial Eye',
            ],
            [
                'id'   => 82,
                'name' => 'Artsploitation Films',
            ],
            [
                'id'   => 83,
                'name' => 'Artus Films',
            ],
            [
                'id'   => 84,
                'name' => 'Ascot Elite Home Entertainment',
            ],
            [
                'id'   => 85,
                'name' => 'Asia Video',
            ],
            [
                'id'   => 86,
                'name' => 'Asmik Ace',
            ],
            [
                'id'   => 87,
                'name' => 'Astro Records & Filmworks',
            ],
            [
                'id'   => 88,
                'name' => 'Asylum',
            ],
            [
                'id'   => 89,
                'name' => 'Atlantic Film',
            ],
            [
                'id'   => 90,
                'name' => 'Atlantic Records',
            ],
            [
                'id'   => 91,
                'name' => 'Atlas Film',
            ],
            [
                'id'   => 92,
                'name' => 'Audio Visual Entertainment',
            ],
            [
                'id'   => 93,
                'name' => 'Auro-3D Creative Label',
            ],
            [
                'id'   => 94,
                'name' => 'Aurum',
            ],
            [
                'id'   => 95,
                'name' => 'AV Visionen',
            ],
            [
                'id'   => 96,
                'name' => 'AV-JET',
            ],
            [
                'id'   => 97,
                'name' => 'Avalon',
            ],
            [
                'id'   => 98,
                'name' => 'Aventi',
            ],
            [
                'id'   => 99,
                'name' => 'Avex Trax',
            ],
            [
                'id'   => 100,
                'name' => 'Axiom',
            ],
            [
                'id'   => 101,
                'name' => 'Axis Records',
            ],
            [
                'id'   => 102,
                'name' => 'Ayngaran',
            ],
            [
                'id'   => 103,
                'name' => 'BAC Films',
            ],
            [
                'id'   => 104,
                'name' => 'Bach Films',
            ],
            [
                'id'   => 105,
                'name' => 'Bandai Visual',
            ],
            [
                'id'   => 106,
                'name' => 'Barclay',
            ],
            [
                'id'   => 107,
                'name' => 'BBC',
            ],
            [
                'id'   => 108,
                'name' => 'BBi films',
            ],
            [
                'id'   => 109,
                'name' => 'BCI Home Entertainment',
            ],
            [
                'id'   => 110,
                'name' => 'Beggars Banquet',
            ],
            [
                'id'   => 111,
                'name' => 'Bel Air Classiques',
            ],
            [
                'id'   => 112,
                'name' => 'Belga Films',
            ],
            [
                'id'   => 113,
                'name' => 'Belvedere',
            ],
            [
                'id'   => 114,
                'name' => 'Benelux Film Distributors',
            ],
            [
                'id'   => 115,
                'name' => 'Bennett-Watt Media',
            ],
            [
                'id'   => 116,
                'name' => 'Berlin Classics',
            ],
            [
                'id'   => 117,
                'name' => 'Berliner Philharmoniker Recordings',
            ],
            [
                'id'   => 118,
                'name' => 'Best Entertainment',
            ],
            [
                'id'   => 119,
                'name' => 'Beyond Home Entertainment',
            ],
            [
                'id'   => 120,
                'name' => 'BFI Video',
            ],
            [
                'id'   => 121,
                'name' => 'BFS Entertainment',
            ],
            [
                'id'   => 122,
                'name' => 'Bhavani',
            ],
            [
                'id'   => 123,
                'name' => 'Biber Records',
            ],
            [
                'id'   => 124,
                'name' => 'Big Home Video',
            ],
            [
                'id'   => 125,
                'name' => 'Bildstörung',
            ],
            [
                'id'   => 126,
                'name' => 'Bill Zebub',
            ],
            [
                'id'   => 127,
                'name' => 'Birnenblatt',
            ],
            [
                'id'   => 128,
                'name' => 'Bit Wel',
            ],
            [
                'id'   => 129,
                'name' => 'Black Box',
            ],
            [
                'id'   => 130,
                'name' => 'Black Hill Pictures',
            ],
            [
                'id'   => 131,
                'name' => 'Black Hole Recordings',
            ],
            [
                'id'   => 132,
                'name' => 'Blaqout',
            ],
            [
                'id'   => 133,
                'name' => 'Blaufield Music',
            ],
            [
                'id'   => 134,
                'name' => 'Blockbuster Entertainment',
            ],
            [
                'id'   => 135,
                'name' => 'Blu Phase Media',
            ],
            [
                'id'   => 136,
                'name' => 'Blu-ray Only',
            ],
            [
                'id'   => 137,
                'name' => 'Blue Gentian Records',
            ],
            [
                'id'   => 138,
                'name' => 'Blue Kino',
            ],
            [
                'id'   => 139,
                'name' => 'Blue Underground',
            ],
            [
                'id'   => 140,
                'name' => 'BMG/Arista',
            ],
            [
                'id'   => 141,
                'name' => 'Bonton Film',
            ],
            [
                'id'   => 142,
                'name' => 'Boomerang Pictures',
            ],
            [
                'id'   => 143,
                'name' => 'BQHL Éditions',
            ],
            [
                'id'   => 144,
                'name' => 'Breaking Glass',
            ],
            [
                'id'   => 145,
                'name' => 'Bridgestone',
            ],
            [
                'id'   => 146,
                'name' => 'Brink',
            ],
            [
                'id'   => 147,
                'name' => 'Broad Green Pictures',
            ],
            [
                'id'   => 148,
                'name' => 'Busch Media Group',
            ],
            [
                'id'   => 149,
                'name' => 'C MAJOR',
            ],
            [
                'id'   => 150,
                'name' => 'C.B.S.',
            ],
            [
                'id'   => 151,
                'name' => 'CaiChang',
            ],
            [
                'id'   => 152,
                'name' => 'Califórnia Filmes',
            ],
            [
                'id'   => 153,
                'name' => 'Cameo',
            ],
            [
                'id'   => 154,
                'name' => 'Camera Obscura',
            ],
            [
                'id'   => 155,
                'name' => 'Camerata',
            ],
            [
                'id'   => 156,
                'name' => 'Camp Motion Pictures',
            ],
            [
                'id'   => 157,
                'name' => 'Capelight Pictures',
            ],
            [
                'id'   => 158,
                'name' => 'Capitol',
            ],
            [
                'id'   => 159,
                'name' => 'Capitol Records',
            ],
            [
                'id'   => 160,
                'name' => 'Capricci',
            ],
            [
                'id'   => 161,
                'name' => 'Cargo Records',
            ],
            [
                'id'   => 162,
                'name' => 'Carlotta Films',
            ],
            [
                'id'   => 163,
                'name' => 'Carmen Film',
            ],
            [
                'id'   => 164,
                'name' => 'Cascade',
            ],
            [
                'id'   => 165,
                'name' => 'Catchplay',
            ],
            [
                'id'   => 166,
                'name' => 'Cauldron Films',
            ],
            [
                'id'   => 167,
                'name' => 'CBS Television Studios',
            ],
            [
                'id'   => 168,
                'name' => 'CCTV',
            ],
            [
                'id'   => 169,
                'name' => 'CCV Entertainment',
            ],
            [
                'id'   => 170,
                'name' => 'CD Baby',
            ],
            [
                'id'   => 171,
                'name' => 'CD Land',
            ],
            [
                'id'   => 172,
                'name' => 'Cecchi Gori',
            ],
            [
                'id'   => 173,
                'name' => 'Century Media',
            ],
            [
                'id'   => 174,
                'name' => 'Chuan Xun Shi Dai Multimedia',
            ],
            [
                'id'   => 175,
                'name' => 'Cine-Asia',
            ],
            [
                'id'   => 176,
                'name' => 'Cinéart',
            ],
            [
                'id'   => 177,
                'name' => 'Cinedigm',
            ],
            [
                'id'   => 178,
                'name' => 'Cinefil Imagica',
            ],
            [
                'id'   => 179,
                'name' => 'Cinema Epoch',
            ],
            [
                'id'   => 180,
                'name' => 'Cinema Guild',
            ],
            [
                'id'   => 181,
                'name' => 'Cinema Libre Studios',
            ],
            [
                'id'   => 182,
                'name' => 'Cinema Mondo',
            ],
            [
                'id'   => 183,
                'name' => 'Cinematic Vision',
            ],
            [
                'id'   => 184,
                'name' => 'Cineploit Records',
            ],
            [
                'id'   => 185,
                'name' => 'Cinestrange Extreme',
            ],
            [
                'id'   => 186,
                'name' => 'Citel Video',
            ],
            [
                'id'   => 187,
                'name' => 'CJ Entertainment',
            ],
            [
                'id'   => 188,
                'name' => 'Classic Media',
            ],
            [
                'id'   => 189,
                'name' => 'ClassicFlix',
            ],
            [
                'id'   => 190,
                'name' => 'ClassicLine',
            ],
            [
                'id'   => 191,
                'name' => 'Claudio Records',
            ],
            [
                'id'   => 192,
                'name' => 'Clear Vision',
            ],
            [
                'id'   => 193,
                'name' => 'Cleopatra',
            ],
            [
                'id'   => 194,
                'name' => 'Close Up',
            ],
            [
                'id'   => 195,
                'name' => 'CMS Media Limited',
            ],
            [
                'id'   => 196,
                'name' => 'CMV Laservision',
            ],
            [
                'id'   => 197,
                'name' => 'CN Entertainment',
            ],
            [
                'id'   => 198,
                'name' => 'Code Red',
            ],
            [
                'id'   => 199,
                'name' => 'Cohen Media Group',
            ],
            [
                'id'   => 200,
                'name' => 'Coin de mire Cinéma',
            ],
            [
                'id'   => 201,
                'name' => 'Colosseo Film',
            ],
            [
                'id'   => 202,
                'name' => 'Columbia',
            ],
            [
                'id'   => 203,
                'name' => 'Columbia Pictures',
            ],
            [
                'id'   => 204,
                'name' => 'Columbia/Tri-Star',
            ],
            [
                'id'   => 205,
                'name' => 'Commercial Marketing',
            ],
            [
                'id'   => 206,
                'name' => 'Concord Music Group',
            ],
            [
                'id'   => 207,
                'name' => 'Concorde Video',
            ],
            [
                'id'   => 208,
                'name' => 'Condor',
            ],
            [
                'id'   => 209,
                'name' => 'Constantin Film',
            ],
            [
                'id'   => 210,
                'name' => 'Constantino Filmes',
            ],
            [
                'id'   => 211,
                'name' => 'Constructive Media Service',
            ],
            [
                'id'   => 212,
                'name' => 'Content Zone',
            ],
            [
                'id'   => 213,
                'name' => 'Contents Gate',
            ],
            [
                'id'   => 214,
                'name' => 'Coqueiro Verde',
            ],
            [
                'id'   => 215,
                'name' => 'Cornerstone Media',
            ],
            [
                'id'   => 216,
                'name' => 'CP Digital',
            ],
            [
                'id'   => 217,
                'name' => 'Crest Movies',
            ],
            [
                'id'   => 218,
                'name' => 'Criterion',
            ],
            [
                'id'   => 219,
                'name' => 'Crystal Classics',
            ],
            [
                'id'   => 220,
                'name' => 'Cult Epics',
            ],
            [
                'id'   => 221,
                'name' => 'Cult Films',
            ],
            [
                'id'   => 222,
                'name' => 'Cult Video',
            ],
            [
                'id'   => 223,
                'name' => 'Curzon Film World',
            ],
            [
                'id'   => 224,
                'name' => 'D Films',
            ],
            [
                'id'   => 225,
                'name' => 'D\'ailly Company',
            ],
            [
                'id'   => 226,
                'name' => 'Da Capo',
            ],
            [
                'id'   => 227,
                'name' => 'DA Music',
            ],
            [
                'id'   => 228,
                'name' => 'Dall\'Angelo Pictures',
            ],
            [
                'id'   => 229,
                'name' => 'Daredo',
            ],
            [
                'id'   => 230,
                'name' => 'Dark Force Entertainment',
            ],
            [
                'id'   => 231,
                'name' => 'Dark Side Releasing',
            ],
            [
                'id'   => 232,
                'name' => 'Dazzler Media',
            ],
            [
                'id'   => 233,
                'name' => 'DCM Pictures',
            ],
            [
                'id'   => 234,
                'name' => 'DeAPlaneta',
            ],
            [
                'id'   => 235,
                'name' => 'Decca',
            ],
            [
                'id'   => 236,
                'name' => 'Deepjoy',
            ],
            [
                'id'   => 237,
                'name' => 'Defiant Screen Entertainment',
            ],
            [
                'id'   => 238,
                'name' => 'Delos',
            ],
            [
                'id'   => 239,
                'name' => 'Delphian Records',
            ],
            [
                'id'   => 240,
                'name' => 'Delta Music & Entertainment',
            ],
            [
                'id'   => 241,
                'name' => 'Deltamac Co. Ltd.',
            ],
            [
                'id'   => 242,
                'name' => 'Demand Media',
            ],
            [
                'id'   => 243,
                'name' => 'DEP',
            ],
            [
                'id'   => 244,
                'name' => 'Deutsche Grammophon',
            ],
            [
                'id'   => 245,
                'name' => 'DFW',
            ],
            [
                'id'   => 246,
                'name' => 'DGM',
            ],
            [
                'id'   => 247,
                'name' => 'Diaphana',
            ],
            [
                'id'   => 248,
                'name' => 'DigiDreams Studios',
            ],
            [
                'id'   => 249,
                'name' => 'Digital Environments',
            ],
            [
                'id'   => 250,
                'name' => 'Discotek Media',
            ],
            [
                'id'   => 251,
                'name' => 'Discovery Channel',
            ],
            [
                'id'   => 252,
                'name' => 'Disk Kino',
            ],
            [
                'id'   => 253,
                'name' => 'Disney / Buena Vista',
            ],
            [
                'id'   => 254,
                'name' => 'Distribution Select',
            ],
            [
                'id'   => 255,
                'name' => 'Divisa',
            ],
            [
                'id'   => 256,
                'name' => 'Dnc Entertainment',
            ],
            [
                'id'   => 257,
                'name' => 'Dogwoof',
            ],
            [
                'id'   => 258,
                'name' => 'Dolmen Home Video',
            ],
            [
                'id'   => 259,
                'name' => 'Donau Film',
            ],
            [
                'id'   => 260,
                'name' => 'Dorado Films',
            ],
            [
                'id'   => 261,
                'name' => 'Drafthouse Films',
            ],
            [
                'id'   => 262,
                'name' => 'Dragon Film Entertainment',
            ],
            [
                'id'   => 263,
                'name' => 'DreamWorks',
            ],
            [
                'id'   => 264,
                'name' => 'Drive On Records',
            ],
            [
                'id'   => 265,
                'name' => 'DS Media',
            ],
            [
                'id'   => 266,
                'name' => 'DTP Entertainment AG',
            ],
            [
                'id'   => 267,
                'name' => 'DTS Entertainment',
            ],
            [
                'id'   => 268,
                'name' => 'Duke Marketing',
            ],
            [
                'id'   => 269,
                'name' => 'Duke Video Distribution',
            ],
            [
                'id'   => 270,
                'name' => 'Dutch FilmWorks',
            ],
            [
                'id'   => 271,
                'name' => 'DVD International',
            ],
            [
                'id'   => 272,
                'name' => 'Dybex',
            ],
            [
                'id'   => 273,
                'name' => 'Dynamic',
            ],
            [
                'id'   => 274,
                'name' => 'Dynit',
            ],
            [
                'id'   => 275,
                'name' => 'E1 Entertainment',
            ],
            [
                'id'   => 276,
                'name' => 'Eagle Entertainment',
            ],
            [
                'id'   => 277,
                'name' => 'Eagle Home Entertainment Pvt.Ltd.',
            ],
            [
                'id'   => 278,
                'name' => 'Eagle Pictures',
            ],
            [
                'id'   => 279,
                'name' => 'Eagle Rock Entertainment',
            ],
            [
                'id'   => 280,
                'name' => 'Eagle Vision Media',
            ],
            [
                'id'   => 281,
                'name' => 'Earmusic',
            ],
            [
                'id'   => 282,
                'name' => 'Earth Entertainment',
            ],
            [
                'id'   => 283,
                'name' => 'Echo Bridge Entertainment',
            ],
            [
                'id'   => 284,
                'name' => 'Edel Germany GmbH',
            ],
            [
                'id'   => 285,
                'name' => 'Edel records',
            ],
            [
                'id'   => 286,
                'name' => 'Edition Tonfilm',
            ],
            [
                'id'   => 287,
                'name' => 'Editions Montparnasse',
            ],
            [
                'id'   => 288,
                'name' => 'Edko Films Ltd.',
            ],
            [
                'id'   => 289,
                'name' => 'Ein\'s M&M CO',
            ],
            [
                'id'   => 290,
                'name' => 'ELEA-Media',
            ],
            [
                'id'   => 291,
                'name' => 'Electric Picture',
            ],
            [
                'id'   => 292,
                'name' => 'Elephant Films',
            ],
            [
                'id'   => 293,
                'name' => 'Elevation',
            ],
            [
                'id'   => 294,
                'name' => 'EMI',
            ],
            [
                'id'   => 295,
                'name' => 'Emon',
            ],
            [
                'id'   => 296,
                'name' => 'EMS',
            ],
            [
                'id'   => 297,
                'name' => 'Emylia',
            ],
            [
                'id'   => 298,
                'name' => 'ENE Media',
            ],
            [
                'id'   => 299,
                'name' => 'Entertainment in Video',
            ],
            [
                'id'   => 300,
                'name' => 'Entertainment One',
            ],
            [
                'id'   => 301,
                'name' => 'Entertainment One Films Canada Inc.',
            ],
            [
                'id'   => 302,
                'name' => 'entertainmentone',
            ],
            [
                'id'   => 303,
                'name' => 'Eone',
            ],
            [
                'id'   => 304,
                'name' => 'Eos',
            ],
            [
                'id'   => 305,
                'name' => 'Epic Pictures',
            ],
            [
                'id'   => 306,
                'name' => 'Epic Records',
            ],
            [
                'id'   => 307,
                'name' => 'Erato',
            ],
            [
                'id'   => 308,
                'name' => 'Eros',
            ],
            [
                'id'   => 309,
                'name' => 'ESC Editions',
            ],
            [
                'id'   => 310,
                'name' => 'Escapi Media BV',
            ],
            [
                'id'   => 311,
                'name' => 'Esoteric Recordings',
            ],
            [
                'id'   => 312,
                'name' => 'ESPN Films',
            ],
            [
                'id'   => 313,
                'name' => 'Eureka Entertainment',
            ],
            [
                'id'   => 314,
                'name' => 'Euro Pictures',
            ],
            [
                'id'   => 315,
                'name' => 'Euro Video',
            ],
            [
                'id'   => 316,
                'name' => 'EuroArts',
            ],
            [
                'id'   => 317,
                'name' => 'Europa Filmes',
            ],
            [
                'id'   => 318,
                'name' => 'EuropaCorp',
            ],
            [
                'id'   => 319,
                'name' => 'Eurozoom',
            ],
            [
                'id'   => 320,
                'name' => 'Excel',
            ],
            [
                'id'   => 321,
                'name' => 'Explosive Media',
            ],
            [
                'id'   => 322,
                'name' => 'Extralucid Films',
            ],
            [
                'id'   => 323,
                'name' => 'Eye See Movies',
            ],
            [
                'id'   => 324,
                'name' => 'EYK Media',
            ],
            [
                'id'   => 325,
                'name' => 'Fabulous Films',
            ],
            [
                'id'   => 326,
                'name' => 'Factoris Films',
            ],
            [
                'id'   => 327,
                'name' => 'Farao Records',
            ],
            [
                'id'   => 328,
                'name' => 'Farbfilm Home Entertainment',
            ],
            [
                'id'   => 329,
                'name' => 'Feelgood Entertainment',
            ],
            [
                'id'   => 330,
                'name' => 'Fernsehjuwelen',
            ],
            [
                'id'   => 331,
                'name' => 'Film Chest',
            ],
            [
                'id'   => 332,
                'name' => 'Film Media',
            ],
            [
                'id'   => 333,
                'name' => 'Film Movement',
            ],
            [
                'id'   => 334,
                'name' => 'Film4',
            ],
            [
                'id'   => 335,
                'name' => 'Filmart',
            ],
            [
                'id'   => 336,
                'name' => 'Filmauro',
            ],
            [
                'id'   => 337,
                'name' => 'Filmax',
            ],
            [
                'id'   => 338,
                'name' => 'FilmConfect Home Entertainment',
            ],
            [
                'id'   => 339,
                'name' => 'Filmedia',
            ],
            [
                'id'   => 340,
                'name' => 'Filmjuwelen',
            ],
            [
                'id'   => 341,
                'name' => 'Filmoteka Narodawa',
            ],
            [
                'id'   => 342,
                'name' => 'FilmRise',
            ],
            [
                'id'   => 343,
                'name' => 'Final Cut Entertainment',
            ],
            [
                'id'   => 344,
                'name' => 'Firehouse 12 Records',
            ],
            [
                'id'   => 345,
                'name' => 'First International Production',
            ],
            [
                'id'   => 346,
                'name' => 'First Look Studios',
            ],
            [
                'id'   => 347,
                'name' => 'Flagman trade',
            ],
            [
                'id'   => 348,
                'name' => 'Flashstar Filmes',
            ],
            [
                'id'   => 349,
                'name' => 'Flicker Alley',
            ],
            [
                'id'   => 350,
                'name' => 'FNC Add Culture',
            ],
            [
                'id'   => 351,
                'name' => 'Focus Filmes',
            ],
            [
                'id'   => 352,
                'name' => 'Fokus Media',
            ],
            [
                'id'   => 353,
                'name' => 'Fox Pathe Europa',
            ],
            [
                'id'   => 354,
                'name' => 'Fox/MGM',
            ],
            [
                'id'   => 355,
                'name' => 'FPE',
            ],
            [
                'id'   => 356,
                'name' => 'France Télévisions Distribution',
            ],
            [
                'id'   => 357,
                'name' => 'Free Dolphin Entertainment',
            ],
            [
                'id'   => 358,
                'name' => 'Freestyle Digital Media',
            ],
            [
                'id'   => 359,
                'name' => 'Fremantle Home Entertainment',
            ],
            [
                'id'   => 360,
                'name' => 'Frenetic Films',
            ],
            [
                'id'   => 361,
                'name' => 'Frontier Works',
            ],
            [
                'id'   => 362,
                'name' => 'Frontiers Music',
            ],
            [
                'id'   => 363,
                'name' => 'Frontiers Records',
            ],
            [
                'id'   => 364,
                'name' => 'FS Film Oy',
            ],
            [
                'id'   => 365,
                'name' => 'Full Moon Features',
            ],
            [
                'id'   => 366,
                'name' => 'Fun City Editions',
            ],
            [
                'id'   => 367,
                'name' => 'FUNimation Entertainment',
            ],
            [
                'id'   => 368,
                'name' => 'Fusion',
            ],
            [
                'id'   => 369,
                'name' => 'Futurefilm',
            ],
            [
                'id'   => 370,
                'name' => 'G2 Pictures',
            ],
            [
                'id'   => 371,
                'name' => 'Gaga Communications',
            ],
            [
                'id'   => 372,
                'name' => 'Gaiam',
            ],
            [
                'id'   => 373,
                'name' => 'Galapagos',
            ],
            [
                'id'   => 374,
                'name' => 'Gamma Home Entertainment',
            ],
            [
                'id'   => 375,
                'name' => 'Garagehouse Pictures',
            ],
            [
                'id'   => 376,
                'name' => 'GaragePlay (車庫娛樂)',
            ],
            [
                'id'   => 377,
                'name' => 'Gaumont',
            ],
            [
                'id'   => 378,
                'name' => 'Geffen',
            ],
            [
                'id'   => 379,
                'name' => 'Geneon Entertainment',
            ],
            [
                'id'   => 380,
                'name' => 'Geneon Universal Entertainment',
            ],
            [
                'id'   => 381,
                'name' => 'General Video Recording',
            ],
            [
                'id'   => 382,
                'name' => 'Glass Doll Films',
            ],
            [
                'id'   => 383,
                'name' => 'Globe Music Media',
            ],
            [
                'id'   => 384,
                'name' => 'Go Entertain',
            ],
            [
                'id'   => 385,
                'name' => 'Golden Harvest',
            ],
            [
                'id'   => 386,
                'name' => 'good!movies',
            ],
            [
                'id'   => 387,
                'name' => 'Grapevine Video',
            ],
            [
                'id'   => 388,
                'name' => 'Grasshopper Film',
            ],
            [
                'id'   => 389,
                'name' => 'Gravitas Ventures',
            ],
            [
                'id'   => 390,
                'name' => 'Great Movies',
            ],
            [
                'id'   => 391,
                'name' => 'Green Apple Entertainment',
            ],
            [
                'id'   => 392,
                'name' => 'GreenNarae Media',
            ],
            [
                'id'   => 393,
                'name' => 'Grindhouse Releasing',
            ],
            [
                'id'   => 394,
                'name' => 'Gryphon Entertainment',
            ],
            [
                'id'   => 395,
                'name' => 'Gunpowder & Sky',
            ],
            [
                'id'   => 396,
                'name' => 'Hanabee Entertainment',
            ],
            [
                'id'   => 397,
                'name' => 'Hannover House',
            ],
            [
                'id'   => 398,
                'name' => 'HanseSound',
            ],
            [
                'id'   => 399,
                'name' => 'Happinet',
            ],
            [
                'id'   => 400,
                'name' => 'Harmonia Mundi',
            ],
            [
                'id'   => 401,
                'name' => 'HBO',
            ],
            [
                'id'   => 402,
                'name' => 'HDC',
            ],
            [
                'id'   => 403,
                'name' => 'HEC',
            ],
            [
                'id'   => 404,
                'name' => 'Hell & Back Recordings',
            ],
            [
                'id'   => 405,
                'name' => 'Hen\'s Tooth Video',
            ],
            [
                'id'   => 406,
                'name' => 'High Fliers',
            ],
            [
                'id'   => 407,
                'name' => 'Highlight',
            ],
            [
                'id'   => 408,
                'name' => 'Hillsong',
            ],
            [
                'id'   => 409,
                'name' => 'History Channel',
            ],
            [
                'id'   => 410,
                'name' => 'HK Vidéo',
            ],
            [
                'id'   => 411,
                'name' => 'HMH Hamburger Medien Haus',
            ],
            [
                'id'   => 412,
                'name' => 'Hollywood Classic Entertainment',
            ],
            [
                'id'   => 413,
                'name' => 'Hollywood Pictures',
            ],
            [
                'id'   => 414,
                'name' => 'Hopscotch Entertainment',
            ],
            [
                'id'   => 415,
                'name' => 'HPM',
            ],
            [
                'id'   => 416,
                'name' => 'Hännsler Classic',
            ],
            [
                'id'   => 417,
                'name' => 'i-catcher',
            ],
            [
                'id'   => 418,
                'name' => 'I-ON New Media',
            ],
            [
                'id'   => 419,
                'name' => 'IAN Productions',
            ],
            [
                'id'   => 420,
                'name' => 'Icestorm',
            ],
            [
                'id'   => 421,
                'name' => 'Icon Film Distribution',
            ],
            [
                'id'   => 422,
                'name' => 'Ideale Audience',
            ],
            [
                'id'   => 423,
                'name' => 'IFC Films',
            ],
            [
                'id'   => 424,
                'name' => 'ifilm',
            ],
            [
                'id'   => 425,
                'name' => 'Illusions Unltd.',
            ],
            [
                'id'   => 426,
                'name' => 'Image Entertainment',
            ],
            [
                'id'   => 427,
                'name' => 'Imagem Filmes',
            ],
            [
                'id'   => 428,
                'name' => 'Imovision',
            ],
            [
                'id'   => 429,
                'name' => 'Imperial Cinepix',
            ],
            [
                'id'   => 430,
                'name' => 'Imprint',
            ],
            [
                'id'   => 431,
                'name' => 'Impuls Home Entertainment',
            ],
            [
                'id'   => 432,
                'name' => 'in-akustik',
            ],
            [
                'id'   => 433,
                'name' => 'Inception Media Group',
            ],
            [
                'id'   => 434,
                'name' => 'Independent',
            ],
            [
                'id'   => 435,
                'name' => 'Indican',
            ],
            [
                'id'   => 436,
                'name' => 'Indie Rights',
            ],
            [
                'id'   => 437,
                'name' => 'Indigo',
            ],
            [
                'id'   => 438,
                'name' => 'INFO',
            ],
            [
                'id'   => 439,
                'name' => 'Injoingan',
            ],
            [
                'id'   => 440,
                'name' => 'Inked Pictures',
            ],
            [
                'id'   => 441,
                'name' => 'Inside Out Music',
            ],
            [
                'id'   => 442,
                'name' => 'InterCom',
            ],
            [
                'id'   => 443,
                'name' => 'Intercontinental Video',
            ],
            [
                'id'   => 444,
                'name' => 'Intergroove',
            ],
            [
                'id'   => 445,
                'name' => 'Interscope',
            ],
            [
                'id'   => 446,
                'name' => 'Invincible Pictures',
            ],
            [
                'id'   => 447,
                'name' => 'Island/Mercury',
            ],
            [
                'id'   => 448,
                'name' => 'ITN',
            ],
            [
                'id'   => 449,
                'name' => 'ITV DVD',
            ],
            [
                'id'   => 450,
                'name' => 'IVC',
            ],
            [
                'id'   => 451,
                'name' => 'Ive Entertainment',
            ],
            [
                'id'   => 452,
                'name' => 'J&R Adventures',
            ],
            [
                'id'   => 453,
                'name' => 'Jakob',
            ],
            [
                'id'   => 454,
                'name' => 'Jonu Media',
            ],
            [
                'id'   => 455,
                'name' => 'JRB Productions',
            ],
            [
                'id'   => 456,
                'name' => 'Just Bridge Entertainment',
            ],
            [
                'id'   => 457,
                'name' => 'Kaboom Entertainment',
            ],
            [
                'id'   => 458,
                'name' => 'Kadokawa Entertainment',
            ],
            [
                'id'   => 459,
                'name' => 'Kairos',
            ],
            [
                'id'   => 460,
                'name' => 'Kaleidoscope Entertainment',
            ],
            [
                'id'   => 461,
                'name' => 'Kam & Ronson Enterprises',
            ],
            [
                'id'   => 462,
                'name' => 'Kana Home Video',
            ],
            [
                'id'   => 463,
                'name' => 'Karma Films',
            ],
            [
                'id'   => 464,
                'name' => 'Katzenberger',
            ],
            [
                'id'   => 465,
                'name' => 'Kaze',
            ],
            [
                'id'   => 466,
                'name' => 'KBS Media',
            ],
            [
                'id'   => 467,
                'name' => 'KD MEDIA',
            ],
            [
                'id'   => 468,
                'name' => 'King Media',
            ],
            [
                'id'   => 469,
                'name' => 'King Records',
            ],
            [
                'id'   => 470,
                'name' => 'Kino Lorber',
            ],
            [
                'id'   => 471,
                'name' => 'Kino Swiat',
            ],
            [
                'id'   => 472,
                'name' => 'Kinokuniya',
            ],
            [
                'id'   => 473,
                'name' => 'Kinowelt Home Entertainment/DVD',
            ],
            [
                'id'   => 474,
                'name' => 'Kit Parker Films',
            ],
            [
                'id'   => 475,
                'name' => 'Kitty Media',
            ],
            [
                'id'   => 476,
                'name' => 'KNM Home Entertainment',
            ],
            [
                'id'   => 477,
                'name' => 'Koba Films',
            ],
            [
                'id'   => 478,
                'name' => 'Koch Entertainment',
            ],
            [
                'id'   => 479,
                'name' => 'Koch Media',
            ],
            [
                'id'   => 480,
                'name' => 'Kraken Releasing',
            ],
            [
                'id'   => 481,
                'name' => 'Kscope',
            ],
            [
                'id'   => 482,
                'name' => 'KSM',
            ],
            [
                'id'   => 483,
                'name' => 'Kultur',
            ],
            [
                'id'   => 484,
                'name' => 'L\'atelier d\'images',
            ],
            [
                'id'   => 485,
                'name' => 'La Aventura Audiovisual',
            ],
            [
                'id'   => 486,
                'name' => 'Lace Group',
            ],
            [
                'id'   => 487,
                'name' => 'Laser Paradise',
            ],
            [
                'id'   => 488,
                'name' => 'Layons',
            ],
            [
                'id'   => 489,
                'name' => 'LCJ Editions',
            ],
            [
                'id'   => 490,
                'name' => 'Le chat qui fume',
            ],
            [
                'id'   => 491,
                'name' => 'Le Pacte',
            ],
            [
                'id'   => 492,
                'name' => 'Ledick Filmhandel',
            ],
            [
                'id'   => 493,
                'name' => 'Legend',
            ],
            [
                'id'   => 494,
                'name' => 'Leomark Studios',
            ],
            [
                'id'   => 495,
                'name' => 'Leonine Films',
            ],
            [
                'id'   => 496,
                'name' => 'Lichtung Media Ltd',
            ],
            [
                'id'   => 497,
                'name' => 'Lighthouse Home Entertainment',
            ],
            [
                'id'   => 498,
                'name' => 'Lightyear',
            ],
            [
                'id'   => 499,
                'name' => 'Lionsgate Films',
            ],
            [
                'id'   => 500,
                'name' => 'Lizard Cinema Trade',
            ],
            [
                'id'   => 501,
                'name' => 'Llamentol',
            ],
            [
                'id'   => 502,
                'name' => 'Lobster Films',
            ],
            [
                'id'   => 503,
                'name' => 'LogOn',
            ],
            [
                'id'   => 504,
                'name' => 'Lorber Films',
            ],
            [
                'id'   => 505,
                'name' => 'Los Banditos Films',
            ],
            [
                'id'   => 506,
                'name' => 'Loud & Proud Records',
            ],
            [
                'id'   => 507,
                'name' => 'LSO Live',
            ],
            [
                'id'   => 508,
                'name' => 'Lucasfilm',
            ],
            [
                'id'   => 509,
                'name' => 'Lucky Red',
            ],
            [
                'id'   => 510,
                'name' => 'Lumière Home Entertainment',
            ],
            [
                'id'   => 511,
                'name' => 'M6 Video',
            ],
            [
                'id'   => 512,
                'name' => 'Mad Dimension',
            ],
            [
                'id'   => 513,
                'name' => 'Madman Entertainment',
            ],
            [
                'id'   => 514,
                'name' => 'Magic Box',
            ],
            [
                'id'   => 515,
                'name' => 'Magic Play',
            ],
            [
                'id'   => 516,
                'name' => 'Magna Home Entertainment',
            ],
            [
                'id'   => 517,
                'name' => 'Magnolia Pictures',
            ],
            [
                'id'   => 518,
                'name' => 'Maiden Japan',
            ],
            [
                'id'   => 519,
                'name' => 'Majeng Media',
            ],
            [
                'id'   => 520,
                'name' => 'Majestic Home Entertainment',
            ],
            [
                'id'   => 521,
                'name' => 'Manga Home Entertainment',
            ],
            [
                'id'   => 522,
                'name' => 'Manta Lab',
            ],
            [
                'id'   => 523,
                'name' => 'Maple Studios',
            ],
            [
                'id'   => 524,
                'name' => 'Marco Polo Production',
            ],
            [
                'id'   => 525,
                'name' => 'Mariinsky',
            ],
            [
                'id'   => 526,
                'name' => 'Marvel Studios',
            ],
            [
                'id'   => 527,
                'name' => 'Mascot Records',
            ],
            [
                'id'   => 528,
                'name' => 'Massacre Video',
            ],
            [
                'id'   => 529,
                'name' => 'Matchbox',
            ],
            [
                'id'   => 530,
                'name' => 'Matrix D',
            ],
            [
                'id'   => 531,
                'name' => 'Maxam',
            ],
            [
                'id'   => 532,
                'name' => 'Maya Home Entertainment',
            ],
            [
                'id'   => 533,
                'name' => 'MDG',
            ],
            [
                'id'   => 534,
                'name' => 'Media Blasters',
            ],
            [
                'id'   => 535,
                'name' => 'Media Factory',
            ],
            [
                'id'   => 536,
                'name' => 'Media Target Distribution',
            ],
            [
                'id'   => 537,
                'name' => 'MediaInVision',
            ],
            [
                'id'   => 538,
                'name' => 'Mediatoon',
            ],
            [
                'id'   => 539,
                'name' => 'Mediatres Estudio',
            ],
            [
                'id'   => 540,
                'name' => 'Medici Arts',
            ],
            [
                'id'   => 541,
                'name' => 'Medici Classics',
            ],
            [
                'id'   => 542,
                'name' => 'Mediumrare Entertainment',
            ],
            [
                'id'   => 543,
                'name' => 'Medusa',
            ],
            [
                'id'   => 544,
                'name' => 'MegaStar',
            ],
            [
                'id'   => 545,
                'name' => 'Mei Ah',
            ],
            [
                'id'   => 546,
                'name' => 'Meli Médias',
            ],
            [
                'id'   => 547,
                'name' => 'Memento Films',
            ],
            [
                'id'   => 548,
                'name' => 'Menemsha Films',
            ],
            [
                'id'   => 549,
                'name' => 'Mercury',
            ],
            [
                'id'   => 550,
                'name' => 'Mercury Studios',
            ],
            [
                'id'   => 551,
                'name' => 'Merge Soft Productions',
            ],
            [
                'id'   => 552,
                'name' => 'Metal Blade Records',
            ],
            [
                'id'   => 553,
                'name' => 'Meteor',
            ],
            [
                'id'   => 554,
                'name' => 'Metro-Goldwyn-Mayer',
            ],
            [
                'id'   => 555,
                'name' => 'Metrodome Video',
            ],
            [
                'id'   => 556,
                'name' => 'Metropolitan',
            ],
            [
                'id'   => 557,
                'name' => 'MFA+',
            ],
            [
                'id'   => 558,
                'name' => 'MIG Filmgroup',
            ],
            [
                'id'   => 559,
                'name' => 'Milestone',
            ],
            [
                'id'   => 560,
                'name' => 'Mill Creek Entertainment',
            ],
            [
                'id'   => 561,
                'name' => 'Millennium Media',
            ],
            [
                'id'   => 562,
                'name' => 'Mirage Entertainment',
            ],
            [
                'id'   => 563,
                'name' => 'Miramax',
            ],
            [
                'id'   => 564,
                'name' => 'Misteriya Zvuka',
            ],
            [
                'id'   => 565,
                'name' => 'MK2',
            ],
            [
                'id'   => 566,
                'name' => 'Mode Records',
            ],
            [
                'id'   => 567,
                'name' => 'Momentum Pictures',
            ],
            [
                'id'   => 568,
                'name' => 'Mondo Home Entertainment',
            ],
            [
                'id'   => 569,
                'name' => 'Mondo Macabro',
            ],
            [
                'id'   => 570,
                'name' => 'Mongrel Media',
            ],
            [
                'id'   => 571,
                'name' => 'Monolit',
            ],
            [
                'id'   => 572,
                'name' => 'Monolith Video',
            ],
            [
                'id'   => 573,
                'name' => 'Monster Pictures',
            ],
            [
                'id'   => 574,
                'name' => 'Monterey Video',
            ],
            [
                'id'   => 575,
                'name' => 'Monument Releasing',
            ],
            [
                'id'   => 576,
                'name' => 'Morningstar',
            ],
            [
                'id'   => 577,
                'name' => 'Moserbaer',
            ],
            [
                'id'   => 578,
                'name' => 'Moviemax',
            ],
            [
                'id'   => 579,
                'name' => 'Movinside',
            ],
            [
                'id'   => 580,
                'name' => 'MPI Media Group',
            ],
            [
                'id'   => 581,
                'name' => 'Mr. Bongo Films',
            ],
            [
                'id'   => 582,
                'name' => 'Mrg (Meridian)',
            ],
            [
                'id'   => 583,
                'name' => 'MUBI',
            ],
            [
                'id'   => 584,
                'name' => 'Mug Shot Productions',
            ],
            [
                'id'   => 585,
                'name' => 'Multimusic',
            ],
            [
                'id'   => 586,
                'name' => 'Muse',
            ],
            [
                'id'   => 587,
                'name' => 'Music Box Films',
            ],
            [
                'id'   => 588,
                'name' => 'Music Brokers',
            ],
            [
                'id'   => 589,
                'name' => 'Music Theories',
            ],
            [
                'id'   => 590,
                'name' => 'Music Video Distributors',
            ],
            [
                'id'   => 591,
                'name' => 'Mustang Entertainment',
            ],
            [
                'id'   => 592,
                'name' => 'MVD Visual',
            ],
            [
                'id'   => 593,
                'name' => 'MVD/VSC',
            ],
            [
                'id'   => 594,
                'name' => 'MVL',
            ],
            [
                'id'   => 595,
                'name' => 'MVM Entertainment',
            ],
            [
                'id'   => 596,
                'name' => 'Myndform',
            ],
            [
                'id'   => 597,
                'name' => 'Mystic Night Pictures',
            ],
            [
                'id'   => 598,
                'name' => 'Nameless Media',
            ],
            [
                'id'   => 599,
                'name' => 'Napalm Records',
            ],
            [
                'id'   => 600,
                'name' => 'National Entertainment Media',
            ],
            [
                'id'   => 601,
                'name' => 'National Film Archive',
            ],
            [
                'id'   => 602,
                'name' => 'National Geographic',
            ],
            [
                'id'   => 603,
                'name' => 'Naxos',
            ],
            [
                'id'   => 604,
                'name' => 'NBCUniversal Entertainment Japan',
            ],
            [
                'id'   => 605,
                'name' => 'NBO Entertainment',
            ],
            [
                'id'   => 606,
                'name' => 'Neos',
            ],
            [
                'id'   => 607,
                'name' => 'Netflix',
            ],
            [
                'id'   => 608,
                'name' => 'Network',
            ],
            [
                'id'   => 609,
                'name' => 'New Blood',
            ],
            [
                'id'   => 610,
                'name' => 'New Disc',
            ],
            [
                'id'   => 611,
                'name' => 'New KSM',
            ],
            [
                'id'   => 612,
                'name' => 'New Line Cinema',
            ],
            [
                'id'   => 613,
                'name' => 'New Movie Trading Co. Ltd',
            ],
            [
                'id'   => 614,
                'name' => 'New Wave Films',
            ],
            [
                'id'   => 615,
                'name' => 'NFi',
            ],
            [
                'id'   => 616,
                'name' => 'NHK',
            ],
            [
                'id'   => 617,
                'name' => 'Nipponart',
            ],
            [
                'id'   => 618,
                'name' => 'NIS America',
            ],
            [
                'id'   => 619,
                'name' => 'Njutafilms',
            ],
            [
                'id'   => 620,
                'name' => 'Noble Entertainment',
            ],
            [
                'id'   => 621,
                'name' => 'Nordisk Film',
            ],
            [
                'id'   => 622,
                'name' => 'Norsk Film',
            ],
            [
                'id'   => 623,
                'name' => 'North American Motion Pictures',
            ],
            [
                'id'   => 624,
                'name' => 'NOS Audiovisuais',
            ],
            [
                'id'   => 625,
                'name' => 'Notorious Pictures',
            ],
            [
                'id'   => 626,
                'name' => 'Nova Media',
            ],
            [
                'id'   => 627,
                'name' => 'Nova Sales and Distribution',
            ],
            [
                'id'   => 628,
                'name' => 'NSM',
            ],
            [
                'id'   => 629,
                'name' => 'NSM Records',
            ],
            [
                'id'   => 630,
                'name' => 'Nuclear Blast',
            ],
            [
                'id'   => 631,
                'name' => 'Nucleus Films',
            ],
            [
                'id'   => 632,
                'name' => 'Oberlin Music',
            ],
            [
                'id'   => 633,
                'name' => 'Obras-Primas do Cinema',
            ],
            [
                'id'   => 634,
                'name' => 'Odeon',
            ],
            [
                'id'   => 635,
                'name' => 'OFDb Filmworks',
            ],
            [
                'id'   => 636,
                'name' => 'Olive Films',
            ],
            [
                'id'   => 637,
                'name' => 'Ondine',
            ],
            [
                'id'   => 638,
                'name' => 'OnScreen Films',
            ],
            [
                'id'   => 639,
                'name' => 'Opening Distribution',
            ],
            [
                'id'   => 640,
                'name' => 'Opera Australia',
            ],
            [
                'id'   => 641,
                'name' => 'Optimum Home Entertainment',
            ],
            [
                'id'   => 642,
                'name' => 'Opus Arte',
            ],
            [
                'id'   => 643,
                'name' => 'Orange Studio',
            ],
            [
                'id'   => 644,
                'name' => 'Orlando Eastwood Films',
            ],
            [
                'id'   => 645,
                'name' => 'Orustak Pictures',
            ],
            [
                'id'   => 646,
                'name' => 'Oscilloscope Pictures',
            ],
            [
                'id'   => 647,
                'name' => 'Outplay',
            ],
            [
                'id'   => 648,
                'name' => 'Palisades Tartan',
            ],
            [
                'id'   => 649,
                'name' => 'Pan Vision',
            ],
            [
                'id'   => 650,
                'name' => 'Panamint Cinema',
            ],
            [
                'id'   => 651,
                'name' => 'Pandastorm Entertainment',
            ],
            [
                'id'   => 652,
                'name' => 'Pandora Film',
            ],
            [
                'id'   => 653,
                'name' => 'Panegyric',
            ],
            [
                'id'   => 654,
                'name' => 'Panorama',
            ],
            [
                'id'   => 655,
                'name' => 'Parade Deck Films',
            ],
            [
                'id'   => 656,
                'name' => 'Paradise',
            ],
            [
                'id'   => 657,
                'name' => 'Paradiso Films',
            ],
            [
                'id'   => 658,
                'name' => 'Paradox',
            ],
            [
                'id'   => 659,
                'name' => 'Paramount Pictures',
            ],
            [
                'id'   => 660,
                'name' => 'Paris Filmes',
            ],
            [
                'id'   => 661,
                'name' => 'Park Circus',
            ],
            [
                'id'   => 662,
                'name' => 'Parlophone',
            ],
            [
                'id'   => 663,
                'name' => 'Passion River',
            ],
            [
                'id'   => 664,
                'name' => 'Pathe Distribution',
            ],
            [
                'id'   => 665,
                'name' => 'PBS',
            ],
            [
                'id'   => 666,
                'name' => 'Peace Arch Trinity',
            ],
            [
                'id'   => 667,
                'name' => 'Peccadillo Pictures',
            ],
            [
                'id'   => 668,
                'name' => 'peppermint',
            ],
            [
                'id'   => 669,
                'name' => 'Phase 4 Films',
            ],
            [
                'id'   => 670,
                'name' => 'Philharmonia Baroque',
            ],
            [
                'id'   => 671,
                'name' => 'Picture House Entertainment',
            ],
            [
                'id'   => 672,
                'name' => 'Pidax',
            ],
            [
                'id'   => 673,
                'name' => 'Pink Floyd Records',
            ],
            [
                'id'   => 674,
                'name' => 'Pinnacle Films',
            ],
            [
                'id'   => 675,
                'name' => 'Plain',
            ],
            [
                'id'   => 676,
                'name' => 'Platform Entertainment Limited',
            ],
            [
                'id'   => 677,
                'name' => 'PlayArte',
            ],
            [
                'id'   => 678,
                'name' => 'PLG UK Classics',
            ],
            [
                'id'   => 679,
                'name' => 'Polyband & Toppic Video/WVG',
            ],
            [
                'id'   => 680,
                'name' => 'Polydor',
            ],
            [
                'id'   => 681,
                'name' => 'Pony',
            ],
            [
                'id'   => 682,
                'name' => 'Pony Canyon',
            ],
            [
                'id'   => 683,
                'name' => 'Potemkine',
            ],
            [
                'id'   => 684,
                'name' => 'Powerhouse Films',
            ],
            [
                'id'   => 685,
                'name' => 'Powerstatiom',
            ],
            [
                'id'   => 686,
                'name' => 'Pride & Joy',
            ],
            [
                'id'   => 687,
                'name' => 'Prinz Media',
            ],
            [
                'id'   => 688,
                'name' => 'Pris Audiovisuais',
            ],
            [
                'id'   => 689,
                'name' => 'Pro Video',
            ],
            [
                'id'   => 690,
                'name' => 'Pro-Motion',
            ],
            [
                'id'   => 691,
                'name' => 'Prod. JRB',
            ],
            [
                'id'   => 692,
                'name' => 'ProDisc',
            ],
            [
                'id'   => 693,
                'name' => 'Prokino',
            ],
            [
                'id'   => 694,
                'name' => 'Provogue Records',
            ],
            [
                'id'   => 695,
                'name' => 'Proware',
            ],
            [
                'id'   => 696,
                'name' => 'Pulp Video',
            ],
            [
                'id'   => 697,
                'name' => 'Pulse Video',
            ],
            [
                'id'   => 698,
                'name' => 'Pure Audio Recordings',
            ],
            [
                'id'   => 699,
                'name' => 'Pure Flix Entertainment',
            ],
            [
                'id'   => 700,
                'name' => 'Pyramide Video',
            ],
            [
                'id'   => 701,
                'name' => 'Quality Films',
            ],
            [
                'id'   => 702,
                'name' => 'Quarto Valley Records',
            ],
            [
                'id'   => 703,
                'name' => 'Questar',
            ],
            [
                'id'   => 704,
                'name' => 'R Squared Films',
            ],
            [
                'id'   => 705,
                'name' => 'Rapid Eye Movies',
            ],
            [
                'id'   => 706,
                'name' => 'Raro Video',
            ],
            [
                'id'   => 707,
                'name' => 'RaroVideo U.S.',
            ],
            [
                'id'   => 708,
                'name' => 'Raven Banner Releasing',
            ],
            [
                'id'   => 709,
                'name' => 'Razor Digital Entertainment',
            ],
            [
                'id'   => 710,
                'name' => 'RCA',
            ],
            [
                'id'   => 711,
                'name' => 'RCO Live',
            ],
            [
                'id'   => 712,
                'name' => 'RCV',
            ],
            [
                'id'   => 713,
                'name' => 'Real Gone Music',
            ],
            [
                'id'   => 714,
                'name' => 'Reanimedia',
            ],
            [
                'id'   => 715,
                'name' => 'Redemption',
            ],
            [
                'id'   => 716,
                'name' => 'Reel',
            ],
            [
                'id'   => 717,
                'name' => 'Reliance Home Video & Games',
            ],
            [
                'id'   => 718,
                'name' => 'REM Culture',
            ],
            [
                'id'   => 719,
                'name' => 'Remain in Light',
            ],
            [
                'id'   => 720,
                'name' => 'Reprise',
            ],
            [
                'id'   => 721,
                'name' => 'Resen',
            ],
            [
                'id'   => 722,
                'name' => 'Retromedia',
            ],
            [
                'id'   => 723,
                'name' => 'Revelation Films Ltd.',
            ],
            [
                'id'   => 724,
                'name' => 'Revolver Entertainment',
            ],
            [
                'id'   => 725,
                'name' => 'Rhino Music',
            ],
            [
                'id'   => 726,
                'name' => 'RHV',
            ],
            [
                'id'   => 727,
                'name' => 'Right Stuf',
            ],
            [
                'id'   => 728,
                'name' => 'Rimini Editions',
            ],
            [
                'id'   => 729,
                'name' => 'Rising Sun Media',
            ],
            [
                'id'   => 730,
                'name' => 'RLJ Entertainment',
            ],
            [
                'id'   => 731,
                'name' => 'Roadrunner Records',
            ],
            [
                'id'   => 732,
                'name' => 'Roadshow Entertainment',
            ],
            [
                'id'   => 733,
                'name' => 'Rone',
            ],
            [
                'id'   => 734,
                'name' => 'Ronin Flix',
            ],
            [
                'id'   => 735,
                'name' => 'Rotana Home Entertainment',
            ],
            [
                'id'   => 736,
                'name' => 'Rough Trade',
            ],
            [
                'id'   => 737,
                'name' => 'Rounder',
            ],
            [
                'id'   => 738,
                'name' => 'Saffron Hill Films',
            ],
            [
                'id'   => 739,
                'name' => 'Samuel Goldwyn Films',
            ],
            [
                'id'   => 740,
                'name' => 'San Francisco Symphony',
            ],
            [
                'id'   => 741,
                'name' => 'Sandrew Metronome',
            ],
            [
                'id'   => 742,
                'name' => 'Saphrane',
            ],
            [
                'id'   => 743,
                'name' => 'Savor',
            ],
            [
                'id'   => 744,
                'name' => 'Scanbox Entertainment',
            ],
            [
                'id'   => 745,
                'name' => 'Scenic Labs',
            ],
            [
                'id'   => 746,
                'name' => 'SchröderMedia',
            ],
            [
                'id'   => 747,
                'name' => 'Scorpion Releasing',
            ],
            [
                'id'   => 748,
                'name' => 'Scream Team Releasing',
            ],
            [
                'id'   => 749,
                'name' => 'Screen Media',
            ],
            [
                'id'   => 750,
                'name' => 'Screenbound Pictures',
            ],
            [
                'id'   => 751,
                'name' => 'Screenwave Media',
            ],
            [
                'id'   => 752,
                'name' => 'Second Run',
            ],
            [
                'id'   => 753,
                'name' => 'Second Sight',
            ],
            [
                'id'   => 754,
                'name' => 'Seedsman Group',
            ],
            [
                'id'   => 755,
                'name' => 'Select Video',
            ],
            [
                'id'   => 756,
                'name' => 'Selecta Vision',
            ],
            [
                'id'   => 757,
                'name' => 'Senator',
            ],
            [
                'id'   => 758,
                'name' => 'Sentai Filmworks',
            ],
            [
                'id'   => 759,
                'name' => 'Seven7',
            ],
            [
                'id'   => 760,
                'name' => 'Severin Films',
            ],
            [
                'id'   => 761,
                'name' => 'Seville',
            ],
            [
                'id'   => 762,
                'name' => 'Seyons Entertainment',
            ],
            [
                'id'   => 763,
                'name' => 'SF Studios',
            ],
            [
                'id'   => 764,
                'name' => 'SGL Entertainment',
            ],
            [
                'id'   => 765,
                'name' => 'Shameless',
            ],
            [
                'id'   => 766,
                'name' => 'Shamrock Media',
            ],
            [
                'id'   => 767,
                'name' => 'Shanghai Epic Music Entertainment',
            ],
            [
                'id'   => 768,
                'name' => 'Shemaroo',
            ],
            [
                'id'   => 769,
                'name' => 'Shochiku',
            ],
            [
                'id'   => 770,
                'name' => 'Shock',
            ],
            [
                'id'   => 771,
                'name' => 'Shogaku Kan',
            ],
            [
                'id'   => 772,
                'name' => 'Shout Factory',
            ],
            [
                'id'   => 773,
                'name' => 'Showbox',
            ],
            [
                'id'   => 774,
                'name' => 'Showtime Entertainment',
            ],
            [
                'id'   => 775,
                'name' => 'Shriek Show',
            ],
            [
                'id'   => 776,
                'name' => 'Shudder',
            ],
            [
                'id'   => 777,
                'name' => 'Sidonis',
            ],
            [
                'id'   => 778,
                'name' => 'Sidonis Calysta',
            ],
            [
                'id'   => 779,
                'name' => 'Signal One Entertainment',
            ],
            [
                'id'   => 780,
                'name' => 'Signature Entertainment',
            ],
            [
                'id'   => 781,
                'name' => 'Silver Vision',
            ],
            [
                'id'   => 782,
                'name' => 'Sinister Film',
            ],
            [
                'id'   => 783,
                'name' => 'Siren Visual Entertainment',
            ],
            [
                'id'   => 784,
                'name' => 'Skani',
            ],
            [
                'id'   => 785,
                'name' => 'Sky Digi',
            ],
            [
                'id'   => 786,
                'name' => 'Slasher // Video',
            ],
            [
                'id'   => 787,
                'name' => 'Slovak Film Institute',
            ],
            [
                'id'   => 788,
                'name' => 'SM Life Design Group',
            ],
            [
                'id'   => 789,
                'name' => 'Smooth Pictures',
            ],
            [
                'id'   => 790,
                'name' => 'Snapper Music',
            ],
            [
                'id'   => 791,
                'name' => 'Soda Pictures',
            ],
            [
                'id'   => 792,
                'name' => 'Sono Luminus',
            ],
            [
                'id'   => 793,
                'name' => 'Sony Music',
            ],
            [
                'id'   => 794,
                'name' => 'Sony Pictures',
            ],
            [
                'id'   => 795,
                'name' => 'Sony Pictures Classics',
            ],
            [
                'id'   => 796,
                'name' => 'Soul Media',
            ],
            [
                'id'   => 797,
                'name' => 'Soulfood Music Distribution',
            ],
            [
                'id'   => 798,
                'name' => 'Soyuz',
            ],
            [
                'id'   => 799,
                'name' => 'Spectrum',
            ],
            [
                'id'   => 800,
                'name' => 'Spentzos Film',
            ],
            [
                'id'   => 801,
                'name' => 'Spirit Entertainment',
            ],
            [
                'id'   => 802,
                'name' => 'Spirit Media GmbH',
            ],
            [
                'id'   => 803,
                'name' => 'Splendid Entertainment',
            ],
            [
                'id'   => 804,
                'name' => 'Splendid Film',
            ],
            [
                'id'   => 805,
                'name' => 'SPO',
            ],
            [
                'id'   => 806,
                'name' => 'Square Enix',
            ],
            [
                'id'   => 807,
                'name' => 'Sri Balaji Video',
            ],
            [
                'id'   => 808,
                'name' => 'SRS Cinema',
            ],
            [
                'id'   => 809,
                'name' => 'SSO Recordings',
            ],
            [
                'id'   => 810,
                'name' => 'ST2 Music',
            ],
            [
                'id'   => 811,
                'name' => 'Star Media Entertainment',
            ],
            [
                'id'   => 812,
                'name' => 'Starlight',
            ],
            [
                'id'   => 813,
                'name' => 'Starz / Anchor Bay',
            ],
            [
                'id'   => 814,
                'name' => 'Ster Kinekor',
            ],
            [
                'id'   => 815,
                'name' => 'Sterling Entertainment',
            ],
            [
                'id'   => 816,
                'name' => 'Stingray',
            ],
            [
                'id'   => 817,
                'name' => 'Stockfisch Records',
            ],
            [
                'id'   => 818,
                'name' => 'Strand Releasing',
            ],
            [
                'id'   => 819,
                'name' => 'Studio 4K',
            ],
            [
                'id'   => 820,
                'name' => 'Studio Canal',
            ],
            [
                'id'   => 821,
                'name' => 'Studio Ghibli',
            ],
            [
                'id'   => 822,
                'name' => 'Studio Hamburg Enterprises',
            ],
            [
                'id'   => 823,
                'name' => 'Studio S',
            ],
            [
                'id'   => 824,
                'name' => 'Subkultur Entertainment',
            ],
            [
                'id'   => 825,
                'name' => 'Suevia Films',
            ],
            [
                'id'   => 826,
                'name' => 'Summit Entertainment',
            ],
            [
                'id'   => 827,
                'name' => 'Sunfilm Entertainment',
            ],
            [
                'id'   => 828,
                'name' => 'Surround Records',
            ],
            [
                'id'   => 829,
                'name' => 'Svensk Filmindustri',
            ],
            [
                'id'   => 830,
                'name' => 'Swen Filmes',
            ],
            [
                'id'   => 831,
                'name' => 'Synapse Films',
            ],
            [
                'id'   => 832,
                'name' => 'Syndicado',
            ],
            [
                'id'   => 833,
                'name' => 'Synergetic',
            ],
            [
                'id'   => 834,
                'name' => 'T- Series',
            ],
            [
                'id'   => 835,
                'name' => 'T.V.P.',
            ],
            [
                'id'   => 836,
                'name' => 'Tacet Records',
            ],
            [
                'id'   => 837,
                'name' => 'Tai Seng',
            ],
            [
                'id'   => 838,
                'name' => 'Tai Sheng',
            ],
            [
                'id'   => 839,
                'name' => 'TakeOne',
            ],
            [
                'id'   => 840,
                'name' => 'Takeshobo',
            ],
            [
                'id'   => 841,
                'name' => 'Tamasa Diffusion',
            ],
            [
                'id'   => 842,
                'name' => 'TC Entertainment',
            ],
            [
                'id'   => 843,
                'name' => 'TDK',
            ],
            [
                'id'   => 844,
                'name' => 'Team Marketing',
            ],
            [
                'id'   => 845,
                'name' => 'Teatro Real',
            ],
            [
                'id'   => 846,
                'name' => 'Tema Distribuciones',
            ],
            [
                'id'   => 847,
                'name' => 'Tempe Digital',
            ],
            [
                'id'   => 848,
                'name' => 'TF1 Vidéo',
            ],
            [
                'id'   => 849,
                'name' => 'The Blu',
            ],
            [
                'id'   => 850,
                'name' => 'The Ecstasy of Films',
            ],
            [
                'id'   => 851,
                'name' => 'The Film Detective',
            ],
            [
                'id'   => 852,
                'name' => 'The Jokers',
            ],
            [
                'id'   => 853,
                'name' => 'The On',
            ],
            [
                'id'   => 854,
                'name' => 'Thimfilm',
            ],
            [
                'id'   => 855,
                'name' => 'Third Window Films',
            ],
            [
                'id'   => 856,
                'name' => 'Thunderbean Animation',
            ],
            [
                'id'   => 857,
                'name' => 'Thunderbird Releasing',
            ],
            [
                'id'   => 858,
                'name' => 'Tiberius Film',
            ],
            [
                'id'   => 859,
                'name' => 'Time Life',
            ],
            [
                'id'   => 860,
                'name' => 'Timeless Media Group',
            ],
            [
                'id'   => 861,
                'name' => 'TLA Releasing',
            ],
            [
                'id'   => 862,
                'name' => 'Tobis Film',
            ],
            [
                'id'   => 863,
                'name' => 'Toei',
            ],
            [
                'id'   => 864,
                'name' => 'Toho',
            ],
            [
                'id'   => 865,
                'name' => 'Tokyo Shock',
            ],
            [
                'id'   => 866,
                'name' => 'Tonpool Medien GmbH',
            ],
            [
                'id'   => 867,
                'name' => 'Topics Entertainment',
            ],
            [
                'id'   => 868,
                'name' => 'Touchstone Pictures',
            ],
            [
                'id'   => 869,
                'name' => 'Transmission Films',
            ],
            [
                'id'   => 870,
                'name' => 'Travel Video Store',
            ],
            [
                'id'   => 871,
                'name' => 'TriArt',
            ],
            [
                'id'   => 872,
                'name' => 'Trigon Film',
            ],
            [
                'id'   => 873,
                'name' => 'Trinity Home Entertainment',
            ],
            [
                'id'   => 874,
                'name' => 'TriPictures',
            ],
            [
                'id'   => 875,
                'name' => 'Troma',
            ],
            [
                'id'   => 876,
                'name' => 'Turbine Medien',
            ],
            [
                'id'   => 877,
                'name' => 'Turtle Records',
            ],
            [
                'id'   => 878,
                'name' => 'TVA Films',
            ],
            [
                'id'   => 879,
                'name' => 'Twilight Time',
            ],
            [
                'id'   => 880,
                'name' => 'TWIN Co., Ltd.',
            ],
            [
                'id'   => 881,
                'name' => 'UCA',
            ],
            [
                'id'   => 882,
                'name' => 'UDR',
            ],
            [
                'id'   => 883,
                'name' => 'UEK',
            ],
            [
                'id'   => 884,
                'name' => 'UFA/DVD',
            ],
            [
                'id'   => 885,
                'name' => 'UGC PH',
            ],
            [
                'id'   => 886,
                'name' => 'Ultimate3DHeaven',
            ],
            [
                'id'   => 887,
                'name' => 'Ultra',
            ],
            [
                'id'   => 888,
                'name' => 'Umbrella Entertainment',
            ],
            [
                'id'   => 889,
                'name' => 'UMC',
            ],
            [
                'id'   => 890,
                'name' => 'Uncork\'d Entertainment',
            ],
            [
                'id'   => 891,
                'name' => 'Unearthed Films',
            ],
            [
                'id'   => 892,
                'name' => 'UNI DISC',
            ],
            [
                'id'   => 893,
                'name' => 'Unimundos',
            ],
            [
                'id'   => 894,
                'name' => 'Unitel',
            ],
            [
                'id'   => 895,
                'name' => 'Universal Music',
            ],
            [
                'id'   => 896,
                'name' => 'Universal Sony Pictures Home Entertainment',
            ],
            [
                'id'   => 897,
                'name' => 'Universal Studios',
            ],
            [
                'id'   => 898,
                'name' => 'Universe Laser & Video Co.',
            ],
            [
                'id'   => 899,
                'name' => 'Universum Film',
            ],
            [
                'id'   => 900,
                'name' => 'UTV',
            ],
            [
                'id'   => 901,
                'name' => 'VAP',
            ],
            [
                'id'   => 902,
                'name' => 'VCI',
            ],
            [
                'id'   => 903,
                'name' => 'Vendetta Films',
            ],
            [
                'id'   => 904,
                'name' => 'Versátil Home Video',
            ],
            [
                'id'   => 905,
                'name' => 'Vertical Entertainment',
            ],
            [
                'id'   => 906,
                'name' => 'Vértice 360º',
            ],
            [
                'id'   => 907,
                'name' => 'Vertigo Berlin',
            ],
            [
                'id'   => 908,
                'name' => 'Vértigo Films',
            ],
            [
                'id'   => 909,
                'name' => 'Verve Pictures',
            ],
            [
                'id'   => 910,
                'name' => 'Via Vision Entertainment',
            ],
            [
                'id'   => 911,
                'name' => 'Vicol Entertainment',
            ],
            [
                'id'   => 912,
                'name' => 'Vicom',
            ],
            [
                'id'   => 913,
                'name' => 'Victor Entertainment',
            ],
            [
                'id'   => 914,
                'name' => 'Videa Cde',
            ],
            [
                'id'   => 915,
                'name' => 'Video Film Express',
            ],
            [
                'id'   => 916,
                'name' => 'Video Music, Inc.',
            ],
            [
                'id'   => 917,
                'name' => 'Video Service Corp.',
            ],
            [
                'id'   => 918,
                'name' => 'Video Travel',
            ],
            [
                'id'   => 919,
                'name' => 'Videomax',
            ],
            [
                'id'   => 920,
                'name' => 'Vii Pillars Entertainment',
            ],
            [
                'id'   => 921,
                'name' => 'Village Films',
            ],
            [
                'id'   => 922,
                'name' => 'Vinegar Syndrome',
            ],
            [
                'id'   => 923,
                'name' => 'Vinny Movies',
            ],
            [
                'id'   => 924,
                'name' => 'Virgil Films & Entertainment',
            ],
            [
                'id'   => 925,
                'name' => 'Virgin Records',
            ],
            [
                'id'   => 926,
                'name' => 'Vision Films',
            ],
            [
                'id'   => 927,
                'name' => 'Visual Entertainment Group',
            ],
            [
                'id'   => 928,
                'name' => 'Vivendi Visual Entertainment',
            ],
            [
                'id'   => 929,
                'name' => 'Viz Pictures',
            ],
            [
                'id'   => 930,
                'name' => 'VLMedia',
            ],
            [
                'id'   => 931,
                'name' => 'Volga',
            ],
            [
                'id'   => 932,
                'name' => 'VVS Films',
            ],
            [
                'id'   => 933,
                'name' => 'VZ Handels GmbH',
            ],
            [
                'id'   => 934,
                'name' => 'Ward Records',
            ],
            [
                'id'   => 935,
                'name' => 'Warner Bros.',
            ],
            [
                'id'   => 936,
                'name' => 'Warner Music',
            ],
            [
                'id'   => 937,
                'name' => 'WEA',
            ],
            [
                'id'   => 938,
                'name' => 'Weinstein Company',
            ],
            [
                'id'   => 939,
                'name' => 'Well Go USA',
            ],
            [
                'id'   => 940,
                'name' => 'Weltkino Filmverleih',
            ],
            [
                'id'   => 941,
                'name' => 'West Video',
            ],
            [
                'id'   => 942,
                'name' => 'White Pearl Movies',
            ],
            [
                'id'   => 943,
                'name' => 'Wicked-Vision Media',
            ],
            [
                'id'   => 944,
                'name' => 'Wienerworld',
            ],
            [
                'id'   => 945,
                'name' => 'Wild Bunch',
            ],
            [
                'id'   => 946,
                'name' => 'Wild Eye Releasing',
            ],
            [
                'id'   => 947,
                'name' => 'Wild Side Video',
            ],
            [
                'id'   => 948,
                'name' => 'WME',
            ],
            [
                'id'   => 949,
                'name' => 'Wolfe Video',
            ],
            [
                'id'   => 950,
                'name' => 'Word on Fire',
            ],
            [
                'id'   => 951,
                'name' => 'Works Film Group',
            ],
            [
                'id'   => 952,
                'name' => 'World Wrestling',
            ],
            [
                'id'   => 953,
                'name' => 'WVG Medien',
            ],
            [
                'id'   => 954,
                'name' => 'WWE Studios',
            ],
            [
                'id'   => 955,
                'name' => 'X Rated Kult',
            ],
            [
                'id'   => 956,
                'name' => 'XCess',
            ],
            [
                'id'   => 957,
                'name' => 'XLrator',
            ],
            [
                'id'   => 958,
                'name' => 'XT Video',
            ],
            [
                'id'   => 959,
                'name' => 'Yamato Video',
            ],
            [
                'id'   => 960,
                'name' => 'Yash Raj Films',
            ],
            [
                'id'   => 961,
                'name' => 'Zeitgeist Films',
            ],
            [
                'id'   => 962,
                'name' => 'Zenith Pictures',
            ],
            [
                'id'   => 963,
                'name' => 'Zima',
            ],
            [
                'id'   => 964,
                'name' => 'Zylo',
            ],
            [
                'id'   => 965,
                'name' => 'Zyx Music',
            ],
        ], ['id'], []);
    }
}
