<?php

declare(strict_types=1);

/**
 * NOTICE OF LICENSE.
 *
 * UNIT3D Community Edition is open-sourced software licensed under the GNU Affero General Public License v3.0
 * The details is bundled with this project in the file LICENSE.txt.
 *
 * @project    UNIT3D Community Edition
 *
 * @author     HDVinnie <hdinnovations@protonmail.com>
 * @license    https://www.gnu.org/licenses/agpl-3.0.en.html/ GNU Affero General Public License v3.0
 */

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class () extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('playlists', function (Blueprint $table): void {
            $table->bigIncrements('id');
            $table->integer('user_id')->index();
            $table->string('name');
            $table->text('description');
            $table->string('cover_image')->nullable();
            $table->integer('position')->nullable();
            $table->boolean('is_private')->default(0)->index();
            $table->boolean('is_pinned')->default(0)->index();
            $table->boolean('is_featured')->default(0)->index();
            $table->timestamps();
        });
    }
};
