<?php

declare(strict_types=1);

/**
 * NOTICE OF LICENSE.
 *
 * UNIT3D Community Edition is open-sourced software licensed under the GNU Affero General Public License v3.0
 * The details is bundled with this project in the file LICENSE.txt.
 *
 * @project    UNIT3D Community Edition
 *
 * @author     HDVinnie <hdinnovations@protonmail.com>
 * @license    https://www.gnu.org/licenses/agpl-3.0.en.html/ GNU Affero General Public License v3.0
 */

namespace App\Http\Resources;

use App\Helpers\Bbcode;
use hdvinnie\LaravelJoyPixels\LaravelJoyPixels;
use Illuminate\Http\Resources\Json\JsonResource;
use voku\helper\AntiXSS;

/**
 * @mixin \App\Models\Message
 */
class ChatMessageResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @throws \Illuminate\Contracts\Container\BindingResolutionException
     */
    public function toArray($request): array
    {
        $emojiOne = app()->make(LaravelJoyPixels::class);

        $bbcode = new Bbcode();

        if ($this->user_id == 1) {
            $logger = $bbcode->parse('<div class="align-left"><div class="chatTriggers">'.$this->message.'</div></div>');
            $logger = $emojiOne->toImage($logger);
            $logger = str_replace('a href="/#', 'a trigger="bot" class="chatTrigger" href="/#', $logger);
        } else {
            $logger = $bbcode->parse('<div class="align-left">'.$this->message.'</div>');
            $logger = $emojiOne->toImage($logger);
        }

        return [
            'id'         => $this->id,
            'bot'        => new BotResource($this->whenLoaded('bot')),
            'user'       => new ChatUserResource($this->whenLoaded('user')),
            'receiver'   => new ChatUserResource($this->whenLoaded('receiver')),
            'chatroom'   => new ChatRoomResource($this->whenLoaded('chatroom')),
            'message'    => (new AntiXSS())->xss_clean($logger),
            'created_at' => $this->created_at->toIso8601String(),
            'updated_at' => $this->updated_at->toIso8601String(),
        ];
    }
}
