<?php

declare(strict_types=1);

/**
 * NOTICE OF LICENSE.
 *
 * UNIT3D Community Edition is open-sourced software licensed under the GNU Affero General Public License v3.0
 * The details is bundled with this project in the file LICENSE.txt.
 *
 * @project    UNIT3D Community Edition
 *
 * @author     Roardom <roardom@protonmail.com>
 * @license    https://www.gnu.org/licenses/agpl-3.0.en.html/ GNU Affero General Public License v3.0
 */

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdatePollRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\Rule|array<\Illuminate\Contracts\Validation\Rule|string>|string>
     */
    public function rules(): array
    {
        return [
            'title' => [
                'required',
                'min:10',
            ],
            'expires_at' => [
                'sometimes',
                'nullable',
                'date',
            ],
            'multiple_choice' => [
                'required',
                'boolean',
            ],
            'options.*.name' => [
                'required',
                'max:255',
            ],
            'options.*.id' => [
                'required',
                'integer',
            ],
            'options' => [
                'array',
                'min:2',
            ],
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array<string, string>
     */
    public function messages(): array
    {
        return [
            'options.*.required' => 'You must fill in all options fields',
        ];
    }
}
