<?php
class ChanpinAction extends HomeAction{
    // 产品搜索
    public function search(){
		//获取地址栏参数
		$Url = ff_param_url();
		//$JumpUrl传递分页及跳转参数
		$JumpUrl = ff_param_jump($Url);
		$JumpUrl['p'] = '{!page!}';
		C('jumpurl',UU('Home-chanpin/search',$JumpUrl,false,true));	
		C('currentpage',$Url['page']);
		//变量赋值
		$search = $this->Lable_Search($Url,'chanpin');
		$this->assign($search);
		$this->display($search['search_skin']);
    }			
    // 产品列表页
    public function show(){
		$Url = ff_param_url();
		$JumpUrl = ff_param_jump($Url);
		$JumpUrl['p'] = '{!page!}';	
		C('jumpurl',UU('Home-chanpin/show',$JumpUrl,false,true));
		C('currentpage',$Url['page']);
		$List = list_search(F('_GxlcmsQY/list'),'list_id='.$Url['id']);
		$channel = $this->Lable_Chanpin_List($Url,$List[0]);
		$this->assign($channel);
		$this->display($channel['list_skin']);
    }
    // 多分类筛选
    public function type(){
		$Url = ff_param_url();
		$Type = $this->Lable_Chanpin_Type($Url);
		$this->assign($Type);
		$this->display($Type['type_skin']);
    }	
	// 产品内容页
    public function read(){
		$array_detail = $this->get_cache_detail( intval($_GET['id']) );
		if($array_detail){
			$this->assign($array_detail['show']);
			$this->assign($array_detail['read']);
			$this->display($array_detail['read']['chanpin_skin_detail']);
		}else{
			$this->assign("jumpUrl",C('site_path'));
			$this->error('此产品已经删除，请选择浏览其他产品！');
		}
    }
	// 产品播放页
    public function play(){
		$array_detail = $this->get_cache_detail( intval($_GET['id']) );
		if($array_detail){
			$array_detail['read'] = $this->Lable_Chanpin_Play($array_detail['read'],array('id'=>intval($_GET['id']), 'sid'=>intval($_GET['sid']), 'pid'=>intval($_GET['pid'])));
			$this->assign($array_detail['show']);
			$this->assign($array_detail['read']);
			$this->display($array_detail['read']['chanpin_skin_play']);
		}else{
			$this->assign("jumpUrl",C('site_path'));
			$this->error('此产品已经删除，请选择浏览其他产品！');
		}
    }
	// 从数据库获取数据
	private function get_cache_detail($chanpin_id){
		if(!$chanpin_id){ return false; }
		//优先读取缓存数据
		if(C('data_cache_chanpin')){
			$array_detail = S('data_cache_chanpin_'.$chanpin_id);
			if($array_detail){
				return $array_detail;
			}
		}
		//未中缓存则从数据库读取
		$where = array();
		$where['chanpin_id'] = $chanpin_id;
		$where['chanpin_cid'] = array('gt',0);
		$where['chanpin_status'] = array('eq',1);
		$rs = D("Chanpin");
		$array = $rs->where($where)->relation('Tag')->find();
		if($array){
			//解析标签
			$array_detail = $this->Lable_Chanpin_Read($array);
			if( C('data_cache_chanpin') ){
				S('data_cache_chanpin_'.$chanpin_id, $array_detail, intval(C('data_cache_chanpin')));
			}
			return $array_detail;
		}
		return false;
	}
}
?>