<h1 align="center">
  CppGuide
</h1>

> 「C/C++学习+面试指南」一份涵盖大部分 C++ 程序员所需要掌握的知识。入门、进阶、深入、校招、社招，准备 C++学习 &amp; 面试，首选 **CppGuide**！

目录

**[1、往期编程资源推荐](#往期编程资源推荐)**

- 可能是**最好的互联网面试求职网站**
- 在这里你能找到**所有的计算机编程学习PDF电子书**
- 一些你绝对用的上的编程资源汇总
- 知名大学计算机系开源课程收录（清华、北大、浙大、上交等）

**[2、C语言相关](#2、C语言相关)**

- 可能是最好的C语言学习路线
- C语言相关书籍（附赠PDF资源）
- C语言干货文章
- C语言视频推荐
- C语言开源项目推荐

**[3、C++相关](#3、C++相关)**

- 入门教程（阿里云大学）
- 可能是最亲民的C++学习路线
- C++相关书籍（附赠PDF资源）
- C++学习笔记
- C++干货文章
- C++视频推荐
- C++开源推荐

**[4、Linux C/C++ 校招](#LinuxC/C++校招)**

**[5、Linux C/C++ 社招](#LinuxC/C++社招)**



<p id="往期编程资源推荐"></p>

# **1、往期编程资源推荐**

## 1、可能是最好的互联网面试求职网站

前段时间我发现了一个很好的面试求职网站，能够根据**指定行业、公司、面试岗位、科目以及考察时间**等进行**定向筛选面试真题**，还附带了**最近考察时间**和**累计考察次数**。

**简直是一大神器**！！！比如我想查一下行业为互联网，公司为字节跳动，考察岗位为后端，科目不限，而考察时间为最近一年之类的面试题有哪些？

![](http://oss.interviewguide.cn/img/202307291803868.png)

行业除了互联网还有国企、银行、外企等行业，截止我发现的时候是这样的，好像该网站后期又在逐步添加新的数据了。

![](http://oss.interviewguide.cn/img/202307291805445.png)

就拿互联网来说，国内外主流一二线大厂全都覆盖了，比如字节跳动、阿里、腾讯、百度、美团等。

![](http://oss.interviewguide.cn/img/202307291804434.png)

这里分享一下该网站，这么好的东西不能藏私，如果对你有帮助的话，帮忙点个赞就是最大的支持了！！感谢感谢！

**网站链接**：https://top.interviewguide.cn/



## 2、[在这里你能找到所有的计算机编程学习PDF电子书料](https://github.com/GrindGold/pdf)

## 3、一些你绝对用的上的编程资源汇总

- [速来！牛客网大佬的互联网面试总结经验PDF文件！](https://mp.weixin.qq.com/s?__biz=MzkxNzQzNDM2Ng==&mid=2247493759&idx=1&sn=3b3ef94153a4f9ff54d3fbc1ddc15e98&chksm=c14212eef6359bf8dbb3af65636d768807b5cfb9b53c70b8344aee7507c2539ae38297172aad&token=470740699&lang=zh_CN#rd)
- [离线版C语言速查手册！免费分享！](https://mp.weixin.qq.com/s?__biz=MzkxNzQzNDM2Ng==&mid=2247493745&idx=1&sn=7cb0d97376a9f331622e5f8a7fab1fbd&chksm=c14212e0f6359bf6bcf10adba443b90a1c6cd061af972939c30bf74ad73b48cb64b722f21e29&token=470740699&lang=zh_CN#rd)
- [开发必备！C++离线版参考手册！免费分享！](https://mp.weixin.qq.com/s?__biz=MzkxNzQzNDM2Ng==&mid=2247493751&idx=1&sn=5a46307334ee30ad8e1f385e27072bb6&chksm=c14212e6f6359bf08273924f6107bd639e038114a855657458366efb5ef4842a1fdbcb3f9d5a&token=470740699&lang=zh_CN#rd)
- [谷歌高级研发工程师出品！支持Java、C++、Go三种语言的Leetcode刷题笔记~](https://mp.weixin.qq.com/s?__biz=MzkxNzQzNDM2Ng==&mid=2247493709&idx=1&sn=09abadbe003a211dc3ccd2f73d939aea&chksm=c14212dcf6359bca3922720a54571aad316ef3921db095de92a38814cbedd617a0916c5fd0b4&token=470740699&lang=zh_CN#rd)
- [《Pro Git 中文版》PDF，带你学会git的骚操作~](https://mp.weixin.qq.com/s?__biz=MzkxNzQzNDM2Ng==&mid=2247493739&idx=1&sn=e0023cd238f022a8f14c39568cf82cc4&chksm=c14212faf6359bec95c23c43f864df05af5768d0d1105b1783741260bd1dafe037ae7a96088f&token=470740699&lang=zh_CN#rd)
- [10套程序员最适合的简历模板！Word格式，白嫖可用~](https://mp.weixin.qq.com/s?__biz=MzkxNzQzNDM2Ng==&mid=2247493732&idx=1&sn=af9cb0d92b78b7f5968abf8d9d1c0f69&chksm=c14212f5f6359be3aa9407db92d19f28c3113b2885e7fc7472310a19b5f3c49edbbe661a5705&token=470740699&lang=zh_CN#rd)
- [后端必备！SQL语法速成手册免费分享！~](https://mp.weixin.qq.com/s?__biz=MzkxNzQzNDM2Ng==&mid=2247493726&idx=1&sn=7d443a0f55a18cfd2453671cd8742453&chksm=c14212cff6359bd93a57ec828f11b8894392648a8db3a6f036a6b9681ec854d6c267c8a86b96&token=470740699&lang=zh_CN#rd)
- [图解操作系统、网络、计算机组成PDF下载！那些让你起飞的计算机基础知识~](https://mp.weixin.qq.com/s?__biz=MzkxNzQzNDM2Ng==&mid=2247493725&idx=1&sn=e8fff9b9c1fe7acb019580b68a1a4521&chksm=c14212ccf6359bda7bda1529fb49aa08b152afcaaa0597dc96e97dc8fc5f568ca8b07cb327fa&token=470740699&lang=zh_CN#rd)
- [分享一下Github 上爆火的各种硬核技术学习路线思维导图~](https://mp.weixin.qq.com/s?__biz=MzkxNzQzNDM2Ng==&mid=2247493721&idx=1&sn=27689564bc72d2e8e4183118d6be3a22&chksm=c14212c8f6359bde1976f0457c77fe001271a678ec2aab91887490af516f5de2c15a33c7f4c3&token=470740699&lang=zh_CN#rd)
- [快来白嫖！腾讯字节阿里美团等一二线互联网大厂真实面经！](https://mp.weixin.qq.com/s?__biz=MzkxNzQzNDM2Ng==&mid=2247493718&idx=1&sn=95dfa688810c7b6a84b3c76e9a227d1f&chksm=c14212c7f6359bd13709eedeed3f942b171053089ce37ddf612bd50889823156713b18d2574e&token=470740699&lang=zh_CN#rd)
- [速来！浙江大学计算机本科课程已开源！附赠离线版资源！](https://mp.weixin.qq.com/s?__biz=MzkxNzQzNDM2Ng==&mid=2247494070&idx=1&sn=4bf8c4a999f805a4a3f1afc5d2072b7a&chksm=c1421327f6359a31ca52ca8d026cd07490de7c5d10ac701d6bbc1f77954b0147d97cdafa52b4&token=692843928&lang=zh_CN#rd)
- [大格局！清华大学计算机系课程攻略共享计划！附赠离线版资源！](https://mp.weixin.qq.com/s?__biz=MzkxNzQzNDM2Ng==&mid=2247494080&idx=1&sn=478e6640f13c9f73ea3053db2f4ccaff&chksm=c1421351f6359a475c26f8a7e629196b254d737d254f8f11b7d3fd50be07b737997ac2ea2919&token=692843928&lang=zh_CN#rd)
- [C语言源码免费分享！超级玛丽、贪吃蛇、学生管理系统等](https://mp.weixin.qq.com/s/ZUHtQxaahrGjvAZVu5jKKg)





## 4、知名大学计算机系开源课程收录

- [浙江大学课程攻略共享计划](https://qsctech.github.io/zju-icicles/)  
- [清华大学计算机系课程攻略](https://rekcarc-tsc-uht.readthedocs.io/en/latest/)  
- [上海交通大学课程资料分享](https://github.com/kxxwz/SJTU-Courses)   
- [北京航空航天大学(北航)课程作业资料共享计划](https://github.com/TheBloodthirster/BUAA_Course_Sharing)  
- [华北电力大学计算机系课程攻略](https://github.com/IammyselfYBX/NCEPU_CS_course)  
- [北京邮电大学计算机考研信息汇总](https://ningzimu.github.io/See_you_in_BUPT/) 

<p id="2、C语言相关"></p>

# **2、C语言相关**

## 可能是最好的C语言学习路线

[可能是北半球最好的零基础C语言学习路线](https://mp.weixin.qq.com/s/eXphn7fpiKzwZfTULQ9OrQ)

C 语言可以零基础入门，它的语法是很多高级编程语言的基础，比如说 Java、C++；并且起到承上启下的作用，向上可以学习高级编程语言，向下可以学习计算机组成原理、操作系统等等偏基础的计算机基础知识。  

## C语言相关书籍（附赠PDF资源）

推荐书籍：  

- 第一本书《阿哈C语言》的写书风格个人认为比较风趣幽默，对于培养兴趣，基础学习还是很不错的  

- 《C程序设计语言》，机械工业出版社，作者Brian W. Kernighan / （美）Dennis M. Ritchie。C 语言之父写的，入门经典书籍。  

- 《C Primer Plus》 ，人民邮电出版社，作者 Stephen Prata。 可以作为 C 语言工具书，也可以作为入门，内容循序渐进，能够锻炼编程思想。  

- 《C和指针》 深入了解指针，看完以后对指针不再害怕。  

- 《C陷阱与缺陷》 正如书上所说，“本书所揭示的知识，至少能够帮助你减少 C 代码和初级 C++ 代码中 90% 的 Bug”，看完后可以避免 C 语言开发的一些坑。 

需要下载下面电子书的话，直接点击书名，输入提取码！  


-  [征服C指针](https://pan.baidu.com/s/1e0zPOp-fhGKKKiILGHx_Ew )  提取码：wwcd 
-  [经典C程序100例](https://pan.baidu.com/s/10HoWoPO_Iz0FVqMhpfP2rQ  )  提取码：t8oe   
-  [C专家编程](https://pan.baidu.com/s/1Zqt4x3_mCYvGA1m9Hc70pg )  提取码：uso7
-  [C语言指针经验总结](https://pan.baidu.com/s/1v6rRsBZHFMQxmVDPpItJMw  )  提取码：ibjw 
-  [C语言深度解剖](https://pan.baidu.com/s/18KcTHqx3sYnyBPd9wr4UsQ )  提取码：6qho 
-  [C语言深度解剖 解开程序员面试笔试的秘密](https://pan.baidu.com/s/1tiZPiojVO2XYpsj6iZdcng)  提取码：ffh1 
-  [c语言入门经典(第5版)](https://pan.baidu.com/s/11cWRyRkw0bruMCx1o2Xabw )  提取码：lzro 
-  [C语言解析教程](https://pan.baidu.com/s/162zKIVChLj5NO_hk16kjKw  )  提取码：mfgv  
-  [C语言函数大全](https://pan.baidu.com/s/1J_6Sox35PTV8Ubb-DSnRSA )  提取码：ir2d 
-  [C语言的科学和艺术](https://pan.baidu.com/s/198IWQcTQzbkYt_iVPK8CQA )  提取码：zm88 
-  [C语言答疑解惑与典型题解](https://pan.baidu.com/s/158HXBJpwXzyK5woz1NA5dQ )  提取码：8cw5  
-  [C语言从入门到精通  第2版明日科技](https://pan.baidu.com/s/1t4dcufnZVMEb8xNY0MyrZQ  )  提取码：4s8h  
-  [C语言程序设计_现代方法](https://pan.baidu.com/s/1Y3CpiqSYjS4LZxo3t43qqA  )  提取码：t4vn  
-  [C语言常见问题集（问题提高版）](https://pan.baidu.com/s/1kAuQzyTsmAihKa8UZHrXCg  )  提取码：xto5 
-  [C语言参悟之旅](https://pan.baidu.com/s/1Gxh6hgUL7L3rFQ4FkoDwng  )  提取码：5h1t 
-  [C语言参考手册第五版](https://pan.baidu.com/s/1dXxjpmbiA36TV5sOhlfhjA  )  提取码：t3g1
-  [C语言编程精粹](https://pan.baidu.com/s/1f3jELV0xaRchBv6wVDYIZQ  )  提取码：5oai 
-  [C陷阱与缺陷](https://pan.baidu.com/s/19tUkgpfpjU3N-3aKX7Y6xg  )  提取码：nejz 
-  [C和指针（中文版）](https://pan.baidu.com/s/1CjnR6FbGHJvkEG1AThQQZA )  提取码：1gvd  
-  [C程序设计语言(英文第2版)及其课后题答案](https://pan.baidu.com/s/1HllCwheCvwivaEEMi85izA)  提取码：wzky  
-  [C程序设计语言（第2版 新版）及课后答案](https://pan.baidu.com/s/1SXAXi-AtdcVS33k3EZCatQ )  提取码：rowl 
-  [C 程序设计语言（第2版）](https://pan.baidu.com/s/1n1Nr42g06FvTt5PiqLyWDQ  )  提取码：4s98 
-  [C Primer Plus 中英版](https://pan.baidu.com/s/1PLKZZA0E9-T8iPKx3M2giw  )  提取码：um90  
-  [C Primer Plus 第6版 中文版](https://pan.baidu.com/s/1DXVKEAhd2Agfz0dxi7F9UQ   )  提取码：n30r 
-  [21天学通C语言  第7版](https://pan.baidu.com/s/129wk9RragTHjgf86sHoPQg )  提取码：8fuj 
-  [[学通C语言的24堂课].刘彬彬&孙秀梅](https://pan.baidu.com/s/1-i_7N12pDkq4O8zske3gRg )  提取码：f44n 
-  [[C语言必须知道的300个问题].明日科技.扫描版](https://pan.baidu.com/s/1NgAyb0DoAq3zQvAQI53GXA  )  提取码：bn80  

## C语言干货文章

- [C语言最全入门笔记](https://mp.weixin.qq.com/s/JgxmKoXsuiReD_21nd1Pdw)  
- [C语言书籍、软件、60个源码](https://mp.weixin.qq.com/s/YSqz5tvUI2oCcib4UoYcjg)
- [一文带你学C/C++，详细知识点思维导图！](https://mp.weixin.qq.com/s/NupTFEnoC4XKuhLWdnnZfg)  
- [10W+ 字C语言从入门到精通保姆级教程（2021版上）](https://mp.weixin.qq.com/s/4ZL52lcZiQqog01wzr9k1w)  
- [10W+字C语言从入门到精通保姆级教程（2021版下）](https://mp.weixin.qq.com/s/0S0FOQh5DEfidwdztGwS9g)  
- [熬夜整理的C/C++万字知识总结（一）](https://zhuanlan.zhihu.com/p/395188209)  
- [熬夜整理的C/C++万字知识总结（二）](https://zhuanlan.zhihu.com/p/395189325)  
- [熬夜整理的C/C++万字知识总结（三）](https://zhuanlan.zhihu.com/p/395195932)  
- [熬夜整理的C/C++万字知识总结（四）](https://zhuanlan.zhihu.com/p/395198080)  
- [熬夜整理的C/C++万字知识总结（五）](https://zhuanlan.zhihu.com/p/395802212)  
- [聊聊我是如何编程入门的](https://mp.weixin.qq.com/s/3vMi2-r8I6Cy3TOs3kDRVA)  
- [C语言中三块难啃的硬骨头](https://mp.weixin.qq.com/s/pLAG4Gr6X55DgQ10COHYJg) 
- [C语言/C++基本语句编程风格](https://mp.weixin.qq.com/s/MkLr6cLU2KpzyS7QKWb1ig)  
- [C语言C++中assert的用法](https://mp.weixin.qq.com/s/HYaltIVBJaBb02VbIz1ZQA)  
- [字符串操作的全面总结](https://mp.weixin.qq.com/s/jT8M9y6cgAz0gKIEV0SVuQ) 
- [C/C++ 位操作详解](https://mp.weixin.qq.com/s/vFeIyJokYTcedQWzblRQHw)   
- [C/C++基础之sizeof使用](https://mp.weixin.qq.com/s/-0AEMHMyLHVC4U6u80YTEg)  
- [C语言常用标准库解读](https://mp.weixin.qq.com/s/8jxaJVOAwpzGCqpR4Q9JMw)  
- [C/C++ 头文件 “ 细节 ”](https://mp.weixin.qq.com/s/qAxRWE8HCR_nofpoG5QDtQ)  
- [详细剖析 extern "C"](https://mp.weixin.qq.com/s/OdJkgNOub1F3I-azLhLyWg)   
- [头文件防卫式声明](https://mp.weixin.qq.com/s/UjcAdWMoyNycYznhhmhZSw)  
- [长文详解：C语言预处理命令](https://mp.weixin.qq.com/s/DX6CQp6L_PEu8P0hVZu6iw)  
- [C语言最常用的贪心算法就这么被攻克了](https://mp.weixin.qq.com/s/D1vcRudud7tLDYMV-ZFIXg)
- [干货|手把手教你写单片机的C语言结构体](https://mp.weixin.qq.com/s/379UL8cNiyE_DOQD4X2m6A)  
- [常见的C语言内存错误及对策](https://mp.weixin.qq.com/s/g-59gP_0b7exj_uOPKbTng)  
- [C语言实现面向对象的原理](https://mp.weixin.qq.com/s/ZroQJPFEeRQWQJcynCO-5g)  
- [一步步分析-C语言如何面向对象编程](https://mp.weixin.qq.com/s/NU4Mb8zCqoCWieUapG6wqg)  
- [C语言字符串详解](https://mp.weixin.qq.com/s/kEpVW38yMhsvSgfuTKSWmg)  
- [干货 | 深度剖析C语言的main函数](https://mp.weixin.qq.com/s/z5AqgTqpmxc59NqwLMNiqw)  
- [C语言头文件组织与包含原则](https://mp.weixin.qq.com/s/ZEGSQKp75FuRyJpfSdrOoQ)  
- [C 语言怎么可能被淘汰呢？](https://mp.weixin.qq.com/s/mei9LzvJTZDRL_oSpA6-iA)  
- [数组越界及其避免方法，C语言数组越界详解](https://mp.weixin.qq.com/s/J1L1s6OZBLXBFNMWQyZC6g)  
- [看完这篇你还能不懂C语言/C++内存管理？](https://mp.weixin.qq.com/s/HAPtnOGhF2z17RhqMmUpNg)  
- [C语言/C++ 堆栈工作机制](https://mp.weixin.qq.com/s/ar2w4xWzmw4szUg16dzNjA)   
- [关于堆栈的讲解(我见过的最经典的)](https://mp.weixin.qq.com/s/-igztLayaR_L1HhAwSd7vw) 
- [C/C++ 基础栈溢出及保护机制](https://mp.weixin.qq.com/s/3VrUfBRVS0guHVEScJJngg)  
- [C语言指针详解](https://mp.weixin.qq.com/s/f3CIK8Zr7TRaA2r8xahr7g)  
- [再谈指针：大佬给你拨开 C 指针的云雾](https://mp.weixin.qq.com/s/h9mlOGbsj2ptkMEmeVs2ww)  
- [C语言函数指针之回调函数](https://mp.weixin.qq.com/s/EIJPbiphjRVtIWTU8pD28A)  
- [C语言高效编程与代码优化](https://mp.weixin.qq.com/s/PTK5cOjXD0Ac36bMCVuJTA)  
- [C语言之结构体就这样被攻克了！值得收藏！](https://mp.weixin.qq.com/s/Rz7HtCB0NCMQF0r_q12iZA)  
- [原码, 反码, 补码 详解](https://mp.weixin.qq.com/s/01M26CWGktnYmM12tFETDw) 
- [浮点数的秘密](https://mp.weixin.qq.com/s/tlcjdXd1rPvs1fHhpKZJCQ)  
- [浮点数比较的精度问题](https://mp.weixin.qq.com/s/bUiP-9tfX-2J1uRKmVv4Fg)  
- [简述C语言宏定义的使用](https://mp.weixin.qq.com/s/hR-hWz9zJf6j6BkwpWcxuA)  
- [一些值得被定义为常用C语言头文件库的漂亮宏定义(值得收藏,以备使用参考)](https://mp.weixin.qq.com/s/LUiE7WSr9IS5URopokikAQ) 
- [c语言之共用体union、枚举、大小端模式](https://mp.weixin.qq.com/s/jtT8Z6qOmJcurBSDMFKY2w)  
- [C语言文件操作](https://mp.weixin.qq.com/s/J7Sm6Mh8-dv8r_MlxQo2jw)  
- [C语言常用的一些转换工具函数！](https://mp.weixin.qq.com/s/NTMxGmI6dDlvAPeFpSA7OA)  
- [几种特殊的函数宏封装方式](https://mp.weixin.qq.com/s/fPoC3iYfk4fIk3eEfNAvZg)   
- [C/C++程序员的编程修养](https://mp.weixin.qq.com/s/CH19z4xU1SW55K5CW59_PQ)  
- [编写可移植 C/C++ 程序的一些要点](https://mp.weixin.qq.com/s/Q_vCEHmJuF6WB5NsfyHkpw)    
- [C语言干货分享|更高层次编写嵌入式C代码](https://mp.weixin.qq.com/s/b9ywcm2tf_0iunkE3-wq7A)  
- [C语言编程规范 clean code](https://mp.weixin.qq.com/s/fd-0i2t1Ek31KREF9MZThw)  
- [C语言代码优化方案(深度好文)](https://mp.weixin.qq.com/s/ZeYfnkFk--zA67nrTDCVuw)  
- [C语言执行效率如何保证，看这一文就够了！](https://mp.weixin.qq.com/s/LRiq8gDpzPpwvd0FMZlt8w)  
- [关于可重入函数](https://mp.weixin.qq.com/s/TFSkytqpv2TsBqhVglin5Q)   
- [听说有人不了解柔性数组](https://mp.weixin.qq.com/s/JPJkSdBkiqKByBITFTA8Jw)   
- [一文读懂C语言与C++动态内存](https://mp.weixin.qq.com/s/CTM26nwzDpRQwUoo3ZukwA)   
- [OOP 面向对象编程：由 C语言到 C++](https://mp.weixin.qq.com/s/H5jnrOZH8o4E14dufGNnWQ)   
- [C语言与C++常见面试题](https://mp.weixin.qq.com/s/PKiDBSyf9SeASg83f36lhw)  
- [难得啊，C语言/C++基础面试知识大集合](https://mp.weixin.qq.com/s/9fzG9EMitYbthmCjGkXkCQ) 
- [面试中常见的C语言与C++区别的问题](https://mp.weixin.qq.com/s/nHKgWwc0G_fTNdB8yyzjRQ) 
- [C/C++ 八股文](https://mp.weixin.qq.com/s/z9kqrJvG8BpLklyud4i-dg)  
- [熬夜整理，五万字长文总结 C/C++ 知识点](https://mp.weixin.qq.com/s/0ezk8bIMornLRqiDvinzoQ)  
- [面试大全 | C语言高级部分总结](https://mp.weixin.qq.com/s/BCp2xyCBUOPI-2SKDBy5xA)  
- [两万字带你狙击嵌入式笔试面试题](https://mp.weixin.qq.com/s/YwqVnTV3eR3KD0tKfQ-qig)  
- [面试：C/C++常见库函数实现](https://mp.weixin.qq.com/s/xa71fIekYtZYWWQb8NkMqA)  
- [学生成绩管理系统案例](https://mp.weixin.qq.com/s/WnW7DXTGjqzX5mdv4R311Q)  
- [二叉树操作详解](https://mp.weixin.qq.com/s/HP3AsXiXapx49sptC63Bug)  
- [字符串之正则表达式](https://mp.weixin.qq.com/s/KlXRb2L88StTDd4H9xUMEA)  
- [熬夜总结14个秒杀算法题的套路！](https://mp.weixin.qq.com/s/_Hr4nAigU5AeiqzTcTKuNQ) 
- [深拷贝与浅拷贝到底是什么](https://mp.weixin.qq.com/s/emgZO229CTrtiJidAojpHA)   
- [十大经典排序算法(动态演示+代码)](https://mp.weixin.qq.com/s/fJEiPQ_iLvz0ecS9Cb2DJg)  
- [C 语言实现一个简单的 web 服务器](https://mp.weixin.qq.com/s/ISxqB3NJ8KxOR94VswXprg)  
- [400 行 C 代码实现一个虚拟机](https://mp.weixin.qq.com/s/09fIouiuCoWC9j9Fzo1a_g)  
- [C/C++ 套接字通信类的封装](https://mp.weixin.qq.com/s/-9sfkIVIFXe6euIQMfLUFA)  
- [C/C++ 服务器并发](https://mp.weixin.qq.com/s/EN3UiTZbvuWEHPD8fxiVgQ)  
- [手写线程池 - C语言版](https://mp.weixin.qq.com/s/gdt68vvK7wVLMQviQjSs6g)  
- [C语言线程库的使用](https://mp.weixin.qq.com/s/nXW7MVLFzbYhuMY-sYhFZg) 
- [C/C++动态检测内存错误利器 - ASan](https://mp.weixin.qq.com/s/TrDsapZkxjtIEjt9A343EQ)  
- [C/C++ 关于 cJson 库的使用](https://mp.weixin.qq.com/s/096er5n0v8LFe6l8BnQvyg) 

## C语言视频推荐

- [《郝斌C语言自学教程》](https://www.bilibili.com/video/BV1os411h77o?from=search&seid=15026475169248378667)  
- [《程序设计入门——C语言（浙大翁恺）》](https://www.bilibili.com/video/BV1ME411h75N?p=48)  

## C语言开源项目推荐

- [60个好玩的C语言程序，训练编程思维，培养解决问题的思路，领略多姿多彩的C语言](https://mp.weixin.qq.com/s/ZUHtQxaahrGjvAZVu5jKKg)  
- [The Algorithms - C](https://github.com/TheAlgorithms/C#the-algorithms---c--mainpage)  
- [C语言PAT练习](https://pintia.cn/problem-sets?tab=0)  
- [Learn-Algorithms](https://github.com/nonstriater/Learn-Algorithms)  
- [C语言单元测试框架](https://github.com/google/cmockery)  
- [CJson：json解码器，C文件只有500行](https://sourceforge.net/projects/cjson/)  
- [EasyLogger-一款轻量级高性能的日志库](https://gitee.com/Armink/EasyLogger)  
- [小型Lisp解释器，不超过1000行代码](https://www.buildyourownlisp.com/)  
- [PAT实验辅助平台](https://pintia.cn/problem-sets?tab=0)  
- [cwebsocket：一款轻量级websocket库](https://github.com/m8rge/cwebsocket)  
- [C语言：斗地主的发牌器](https://study.163.com/course/introduction/1321006.htm#/courseDetail)  
- [C 语言实现通讯录](https://www.lanqiao.cn/courses/125)  
- [C 语言实现 2048 游戏](https://www.lanqiao.cn/courses/155)  
- [Tinyhttpd,一个不到 500 行的超轻量型 HTTP Server，可以用来理解服务器程序的原理和本质](https://github.com/EZLippi/Tinyhttpd)  
- [db_tutorial,用 C 从零创建一个简单的数据库](https://github.com/cstack/db_tutorial)  
- [分享10个适合初学者学习的C开源项目代码](https://mp.weixin.qq.com/s/uwSBqS-VGj2PU3ZIp6FlyA)  

<p id="3、C++相关"></p>

# **3、C++相关**

## 入门教程

### [C++ 入门教程阿里云大学](./file/入门教程阿里云大学.md)

- [C++ 教程](./file/入门教程阿里云大学.md#c-教程)
- [C++ 简介](./file/入门教程阿里云大学.md#c-简介)
- [C++ 环境设置](./file/入门教程阿里云大学.md#c-环境设置)
- [C++ 基本语法](./file/入门教程阿里云大学.md#c-基本语法)
- [C++ 注释](./file/入门教程阿里云大学.md#c-注释)
- [C++ 数据类型](./file/入门教程阿里云大学.md#c-数据类型)
- [C++ 变量类型](./file/入门教程阿里云大学.md#c-变量类型)
- [C++ 变量作用域](./file/入门教程阿里云大学.md#c-变量作用域)
- [C++ 常量](./file/入门教程阿里云大学.md#c-常量)
- [C++ 修饰符类型](./file/入门教程阿里云大学.md#c-修饰符类型)
- [C++ 存储类](./file/入门教程阿里云大学.md#c-存储类)
- [C++ 运算符](./file/入门教程阿里云大学.md#c-运算符)
- [C++ 循环](./file/入门教程阿里云大学.md#c-循环)
- [C++ 判断](./file/入门教程阿里云大学.md#c-判断)
- [C++ 函数](./file/入门教程阿里云大学.md#c-函数)
- [C++ 数字](./file/入门教程阿里云大学.md#c-数字)
- [C++ 数组](./file/入门教程阿里云大学.md#c-数组)
- [C++ 字符串](./file/入门教程阿里云大学.md#c-字符串)
- [C++ 指针](./file/入门教程阿里云大学.md#c-指针)
- [C++ 引用](./file/入门教程阿里云大学.md#c-引用)
- [C++ 日期 & 时间](./file/入门教程阿里云大学.md#c-日期--时间)
- [C++ 基本的输入输出](./file/入门教程阿里云大学.md#c-基本的输入输出)
- [C++ 数据结构](./file/入门教程阿里云大学.md#c-数据结构)
- [C++ 类 & 对象](./file/入门教程阿里云大学.md#c-类--对象)
- [C++ 继承](./file/入门教程阿里云大学.md#c-继承)
- [C++ 重载运算符和重载函数](./file/入门教程阿里云大学.md#c-重载运算符和重载函数)
- [C++ 多态](./file/入门教程阿里云大学.md#c-多态)
- [C++ 数据抽象](./file/入门教程阿里云大学.md#c-数据抽象)
- [C++ 数据封装](./file/入门教程阿里云大学.md#c-数据封装)
- [C++ 接口（抽象类）](./file/入门教程阿里云大学.md#c-接口抽象类)
- [C++ 文件和流](./file/入门教程阿里云大学.md#c-文件和流)
- [C++ 异常处理](./file/入门教程阿里云大学.md#c-异常处理)
- [C++ 动态内存](./file/入门教程阿里云大学.md#c-动态内存)
- [C++ 命名空间](./file/入门教程阿里云大学.md#c-命名空间)
- [C++ 模板](./file/入门教程阿里云大学.md#c-模板)
- [C++ 预处理器](./file/入门教程阿里云大学.md#c-预处理器)
- [C++ 信号处理](./file/入门教程阿里云大学.md#c-信号处理)
- [C++ 多线程](./file/入门教程阿里云大学.md#c-多线程)
- [C++ Web 编程](./file/入门教程阿里云大学.md#c-web-编程)
- [C++ STL 教程](./file/入门教程阿里云大学.md#c-stl-教程)
- [C++ 标准库](./file/入门教程阿里云大学.md#c-标准库)

## 可能是最亲民的C++学习路线

[这不就是你想要的保姆级 C++ 学习路线吗？](https://mp.weixin.qq.com/s/QCtQoIOg6_f1GX9rT8jG4Q)

C语言->C with class -> C++; 
由C++的演变可以看出来，C++ 刚开始就是带类的 C 语言，C 语言和 C++ 的关系到底是什么呢？  
看过侯捷老师的视频或者《Effective C++》这本书就知道，现如今我们提到 C++，都应该视其为一个庞大的「语言联邦」，最起码包含如下几个重要的组成部分：  

- 面向过程编程
- 面向对象编程
- 泛型编程
- 元编程
- 函数式编程
- STL标准库  


其中「面向过程编程」，正是 C++ 提供的向后兼容 C语言的部分。 

C++演化（C++ 98 ->C++ 03 -> C++ 11 -> C++ 14 -> C++20 -> ..... ）



## C++相关书籍（附赠PDF资源）

**书籍推荐：**  

- 《C++ Primer中文版》本书面向 C++ 语言的初学者，是一本很友好的自学教材。作者把 C 语言的基础概念和需要注意的编程细节说得很清楚，并且例程和习题丰富，相信认真读过之后，可以完成 C 语言入门这个目标。
- 《高质量程序设计指南》，墙裂推荐，这本书看得比较过瘾，书里面有一些编程规范的东西，对于写程序的人来说，还是不错的，可以培养好的编码习惯，加深了一些知识的巩固。比较实用，也适合面试前看看。
- 《Essential C++中文版》是一本内容不多但很实用的 C++ 入门书籍，强调快速上手与理解 C++ 编程。本书主要围绕一系列逐渐复杂的程序问题，以及用以解决这些问题的语言特性展开讲解。你不只学到 C++ 的函数和结构，也会学习到它们的设计目的和基本原理。
- 《More Effective C++（中文版）》，该书围绕55条准则，每一条都介绍了一个可让你写出更好的C++程序代码的方法，并以特别设计过的例子详加讨论。
- 《提高C++性能的编程技术》，本书认为 20% 的性能缺陷将会占用我们 80% 的时间。因此我们把精力集中在最有价值的地方。本书详细讨论了临时对象、内存管理、继承、虚函数、内联、引用计数以及 STL 等一切有可能提升 C++ 效率的细节内容。无论你是相关领域的从业人员，还是 C++ 程序设计爱好者，或者是渴望突破编程瓶颈、大幅提升自我修为的程序设计爱好者，本书都必将使你获益良多。
- 《从缺陷中学习C/C++》从本质上来说，这就是一个 C/C++ 的错题集。全书中包括 63 个问题引发的错误，即书名中的缺陷。也是避坑指南。
- 《C++ Templates中文版》，深入了解现代 c++ 模板的实用书籍。本书不仅是对 C++ 模板的权威解释，而且本书还深入地介绍了其他一般的 C++ 思想。
- 《STL源码剖析》详细地了解 STL 的底层实现机制，同时也可以对常用数据结构，C++ 内存管理拥有更深的理解。

- 还有《C++标准库(第2版)》、《C++并发编程实战》、《C++编程思想（两卷合订本）》等，介绍的这些书我都买了，不过说实话，后面的几本都是泛泛的看了下，当作工具书。


**其他文档:**  

- [华为最牛逼的c++ 基础与提高PDF](https://mp.weixin.qq.com/s/_3VNj3Hh28Eg21_I3Q7vrg)  
- [LeetCode101题解](https://wwr.lanzoui.com/iPONZp2zd9e)  
- [Google 开源项目风格指南——中文版](https://zh-google-styleguide.readthedocs.io/en/latest/google-cpp-styleguide/contents/)  

需要下载下面电子书的话，直接点击书名，输入提取码！   

-  [第二套、侯捷老师全系列八部曲 - 手把手教你进阶系列](https://pan.baidu.com/s/1rNfHasapQuwFf_X0nxfJOQ )  提取码：rb16 
-  [00 - 侯捷系列-全部课件](https://pan.baidu.com/s/1mAH1wMVPyXFHQNckDv16Xw  )  提取码：poo3 
-  [01、C++面向对象高级编程（上）](https://pan.baidu.com/s/1_FFv0cPEPsxpLw66vmZ3BQ )  提取码：51rd
-  [01、C++面向对象高级编程（下）](https://pan.baidu.com/s/16OrZgRnGooXeocAoN4dKeg)  提取码：0869 
-  [00 - 侯捷系列-全部课件](https://pan.baidu.com/s/1mAH1wMVPyXFHQNckDv16Xw  )  提取码：poo3 
-  [03 - 侯捷-C++设计模式](https://pan.baidu.com/s/1ljhdglrfS6GETAWz9bZQfQ)  提取码：zn8n  
-  [04 - 侯捷-C++新标准C++11&14](https://pan.baidu.com/s/1qoiG_1ZFi6ulSKGvQFZkSw )  提取码：5jl1 
-  [05 - 侯捷-C++内存管理机制_60_侯捷](https://pan.baidu.com/s/1UcuXs_eOu-5H-veSbtU4IQ )  提取码：b8b3
-  [06 - 侯捷-C++ Startup 揭密：C++ 程序的生前和死后](https://pan.baidu.com/s/1_m9kEmUWQNCMoiH7e-WHpw)  提取码：adro 
-  [07、算法原理与实践（选修）](https://pan.baidu.com/s/18jqE_lNuJHTsSkmCb5Laxw)  提取码：7548 
-  [08、系统设计与实践（选修）](https://pan.baidu.com/s/16Kr9P2fiUlpq3LlL4Ln5yg )  提取码：697b
-  [第三套、Linux CC++网络编程实践-陈硕](https://pan.baidu.com/s/1OcymYPgisLPsJLFPpuFSJg)  提取码：wv79
-  [陈硕 - C++实践工程学](https://pan.baidu.com/s/1tg57seNQmTQGPFxFbFOTdQ  )  提取码：blou 
-  [易学C++](https://pan.baidu.com/s/1hPL7zN0XyVqfQgVTtlyK6g )  提取码：yiwo 
-  [提高C++性能的编程技术.左飞](https://pan.baidu.com/s/1wfBHSsOPuG4hIAI4KC-C_Q )  提取码：anft   
-  [深入理解C++11](https://pan.baidu.com/s/1GV2HvK41eTjDMs2huX-DYw)  提取码：py26 
-  [深度探索C++对象模型](https://pan.baidu.com/s/1UeCtZpL_I33IahDlWNzvFQ)  提取码：0v2p  
-  [侯捷STL课件](https://pan.baidu.com/s/1nbL2yzl6aPi3kR5w-CjVjA )  提取码：fuuh 
-  [跟我一起写makefile](https://pan.baidu.com/s/1M0NmPBPZxrZq0o0m7_7gPA )  提取码：k090 
-  [大话设计模式C++](https://pan.baidu.com/s/1r_twlwt7NmYSM09LVAS8ag  )  提取码：r1wi 
-  [陈硕 - C++实践工程学](https://pan.baidu.com/s/1YmxlyHXTXOnXA_XvhweqUA)  提取码：dgy4 
-  [STL源码剖析+源码](https://pan.baidu.com/s/1cip_DvjiaomxMOxTofqAtA)  提取码：nkcl 
-  [Modern C++ Design](https://pan.baidu.com/s/1kJmaP8NF0gxkJr7NgdZ8Mg )  提取码：t1kk 
-  [Effective-C++-第二版](https://pan.baidu.com/s/1zjy1JRGZXn-rwfIkUlunDQ  )  提取码：vy1b 
-  [Effective STL中文版](https://pan.baidu.com/s/1_0dRltY1HAYRine3MaRDJA  )  提取码：t3gy 
-  [Effective C++  第三版 高清PDF](https://pan.baidu.com/s/1QcOXHAJT7IpA6-UXOvTvag )  提取码：bd36 
-  [C++设计新思维-泛型编程与设计之应用](https://pan.baidu.com/s/1zl_OWNTSn4infueomtQhdQ )  提取码：7gew 
-  [C++工程实践经验课](https://pan.baidu.com/s/1sOpVEU9m7RwcRzTzvHugNg )  提取码：o5v4 
-  [C++对象模型](https://pan.baidu.com/s/1nrhoEgVIiFJCebvciD6uiw )  提取码：azv9 
-  [C++大学教程](https://pan.baidu.com/s/14g4vGDiTrcWeY0f-LPRpqA  )  提取码：012g 
-  [C++程序设计语言](https://pan.baidu.com/s/1qKkfideylmnSeKBt8yjdnQ )  提取码：abu1 
-  [C++沉思录中文第2版](https://pan.baidu.com/s/1_1upGAMJmjEtCVex593XIA )  提取码：o88v 
-  [C++并发编程实战](https://pan.baidu.com/s/1HX3vAzkp6q0oPqlwU3K_Mg)  提取码：fuj8 
-  [C++标准程序库](https://pan.baidu.com/s/13LcniMz8UPxAJPxsZqeP7A )  提取码：318m 
-  [C++编程调试秘笈](https://pan.baidu.com/s/1Wuac8u3x8kwcfJuGjz6pDw )  提取码：8ool 
-  [C++编程思想（两卷合订本）](https://pan.baidu.com/s/1XpBB-AMrNpZR_2wYpXY-Vw  )  提取码：ekkz
-  [C++编程规范-101条规则准则与最佳实践](https://pan.baidu.com/s/1-qMz_AWH6LBxJsOp8S2lRw )  提取码：0o6k 
-  [C++Primer 5th 英文版](https://pan.baidu.com/s/1LAdu9NA8zFCQu6mUhJv1gQ )  提取码：cxmu
-  [C++ Primer习题集](https://pan.baidu.com/s/1J2ASpvZiJLKSonyDVyR5pg)  提取码：lvmx 
-  [C++ Primer-第4版](https://pan.baidu.com/s/1Mxqah7DdcDn4idTfCZT5sA  )  提取码：8gyu
-  [C++ Primer（第5版）_带书签_高清完整版](https://pan.baidu.com/s/1rlvQYjV7xWQhd7vYhR4yww )  提取码：x6rl 
-  [C++ Primer Plus](https://pan.baidu.com/s/1X-p7BY5n2SR9_QF5YDyULg )  提取码：i0p7 

## [C++学习笔记](./file/学习笔记.md#c学习笔记)

- [一、基础知识](./file/学习笔记.md#一基础知识)
  - 1、goto 语句(不建议使用)
  - 2、一维数组
  - 3、二维数组
  - 4、函数中的值传递
  - 5、函数的声明
  - 6、函数的分文件编写
  - 7、指针
    - 7.1 指针的基本概念
    - 7.2 指针变量的定义和使用
    - 7.3 指针所占内存空间
    - 7.4 空指针和野指针
    - 7.5 const修饰指针
    - 7.6 指针和数组
    - 7.7 指针和函数
    - 7.8 指针、数组、函数
  - 8、结构体
    - 8.1 结构体基本概念
    - 8.2 结构体定义和使用
    - 8.3 结构体数组
    - 8.4 结构体指针
    - 8.5 结构体嵌套结构体
    - 8.6 结构体做函数参数
    - 8.7 结构体中 const使用场景
- [二、核心编程](./file/学习笔记.md#二核心编程)
  - 1、内存分区模型
    - 1.1 程序运行前
    - 1.2 程序运行后
    - 1.3 new操作符
  - 2、引用
    - 2.1 引用的基本使用
    - 2.2 引用注意事项
    - 2.3 引用做函数参数
    - 2.4 引用做函数返回值
    - 2.5 引用的本质
    - 2.6 常量引用
  - 3、函数
    - 3.1 函数默认参数
    - 3.2 函数占位参数
    - 3.3 函数重载

## C++干货文章

- [深入探究C++虚函数表——从内存的角度](https://mp.weixin.qq.com/s/xTj_FLz0P3uXi-hi8jN_zA)

- [一文让你学完C++，干货收藏！！！](https://mp.weixin.qq.com/s/HxQjYzhqXeKwiQWy_jKFIA)  
- [2022最稳C/C++学习路线](https://mp.weixin.qq.com/s/e0QsJcfHf6WLCMp1wpg9ig)  
- [呐，这不就是你要的C++后台开发学习路线吗？](https://mp.weixin.qq.com/s/OQy7h-gfGIGk1Bl23ViQUw) 
- [这才是你需要的C语言、C++学习路线！](https://mp.weixin.qq.com/s/uK1nwc7B54eUjCMba1uM4g)   
- [校招｜ C++ 后台开发学习路线](https://mp.weixin.qq.com/s/inRmCrVp0IHtxG9B8XZIfA)  
- [STL总结与常见面试题+资料](https://mp.weixin.qq.com/s/0qdya1iTrAd2TbatT6zM2g)  
- [一定用得到的免费C++资源集合，值得收藏](https://mp.weixin.qq.com/s/OurC9r-7KQR20yh2fUwYyg)  
- [两万字总结《C++ Primer》要点](https://mp.weixin.qq.com/s/l2e8PLoZVpormYJlCm4kwA)  
- [深度探索C++对象模型笔记](https://mp.weixin.qq.com/s/Zb_DAt5N1JJvxBXuYjLB2w)  
- [Effective C++学习笔记](https://mp.weixin.qq.com/s/Sn-AeA41-ZjLzCMtmNnx_A)  
- [C/C++框架和第三方库汇总](https://mp.weixin.qq.com/s/OO0K-fahKxe8-6RZ1FvOQw)   
- [万字长文系统梳理C++函数指针](https://mp.weixin.qq.com/s/EMVJ-SJbySIAnwlWeImeWQ)
- [学过 C++ 的你，不得不知的这 10 条细节！](https://mp.weixin.qq.com/s/sVIQVNmXSB3-Itr7mNasoQ)     
- [值得收藏的几个 C/C++ 学习网站](https://mp.weixin.qq.com/s/hedIn_0aAm84uO1L-eL-NQ)  
- [假如C++是一只箭，你会用它来射哪只雕？| 就业岗位分享](https://mp.weixin.qq.com/s/vFp7-qf6IbNVvnKiWfB9pw)  
- [如何优雅地利用C++编程从1乘到20？](https://mp.weixin.qq.com/s/pJPHgTzQ7MYuOJ4ZL5gAtQ)  
- [C/C++ 中的 #pragma once 作用是什么？](https://mp.weixin.qq.com/s/2CPb0voypyf5tpx37S7hnQ)  
- [C++ Best Practices (C++最佳实践)翻译与阅读笔记](https://mp.weixin.qq.com/s/zq0en7hQ8vl1IhgBGy77Sw)  
- [防御性编程技巧](https://mp.weixin.qq.com/s/70iBVxXiPkGvbPASjoOX6w)  
- [五万字读懂c++](https://mp.weixin.qq.com/s/GOk0jlbJPl9NNtXmdLz9WQ)   
- [看完这 7 条，模拟 C++ 新功能只是一个小目标！](https://mp.weixin.qq.com/s/0I_tD3y0zUZVW2ZcMpgmmQ)  
- [硬核 | C++ 基础大全](https://mp.weixin.qq.com/s/qQp_tmorfXV3b17_R9wi4Q)  
- [C++模板总结](https://mp.weixin.qq.com/s/M5fSiJldrfnIuosk6ZzN0A)  
- [C++ 读取 UTF-8 及 GBK 系列的文本方法及原理](https://mp.weixin.qq.com/s/_k7Cm-WnWpWjo2FL7rLqIw)   
- [C++ 日期和时间编程](https://mp.weixin.qq.com/s/XSC6W7M2WWoiES4auCpVBg)  
- [C++ 编程习惯与编程要点](https://mp.weixin.qq.com/s/Y-AjsYYnXrhiagBSKEXtTQ)  
- [C++ 内存模型](https://mp.weixin.qq.com/s/fghS3Ai0yMM1bbGXJ5GbHA)  
- [编程5分钟，命名2小时！聊聊命名规则！](https://mp.weixin.qq.com/s/x_JyQsYmnEMPHAO-L-kmXw)  
- [C++ 与正则表达式](https://mp.weixin.qq.com/s/9fJUgt1puvdhlAH-2-436g)  
- [手写线程池 - C++版](https://mp.weixin.qq.com/s/kysLdHnziy8p4v-20cOh7g)   
- [C++ 线程的使用](https://mp.weixin.qq.com/s/tMWxvw4Kmga5ayUfXHaaIw)  
- [C++ 八股文（一）](https://mp.weixin.qq.com/s/n77Qrz2d2CimssPcWho9DQ)  
- [C++ 使用 chrono 库处理日期和时间](https://mp.weixin.qq.com/s/mf8Q5BsVKBWFjeYibpLQKQ)  
- [硬核 | 50 家企业 C++ 面经分享](https://mp.weixin.qq.com/s/5dMx4TIKNsN5rlLWOewDKQ)  
- [C++编译期多态与运行期多态](https://mp.weixin.qq.com/s/cql9RVO6pDmqgsWg3dk58A)  
- [C++ 并发编程（C++11 到 C++17 ）](https://mp.weixin.qq.com/s/vJOuz_l-Szqh0n0IdCQKAg)  
- [C++内存管理（建议收藏）](https://mp.weixin.qq.com/s/ZesF70cdJpRNVuMTCmR6kw)  
- [两万字长文，见过最好的模板元编程文章！](https://mp.weixin.qq.com/s/nAxnBM0bqdBUWbK8jizDTg)  
- [C++虚函数表原理浅析](https://mp.weixin.qq.com/s/ajBkEAht8EVYNzIB0noTuQ)  
- [C++函数调用过程深入分析](https://mp.weixin.qq.com/s/tYfAmrqDh25JYNwtssUWew)  
- [动图演示：如何彻底理解红黑树？](https://mp.weixin.qq.com/s/z7VroLvuXjDWU0zePxQXwg)  
- [C++性能优化](https://mp.weixin.qq.com/s/8fhF6QxAUbo35nIK5nfV1A)  
- [万字长文|深入 C++ 内存管理](https://mp.weixin.qq.com/s/uZfPNsx5bZzDzneZ-7DB1A)  
- [一个程序员的C++学习之路](https://mp.weixin.qq.com/s/rSMNHHHYkG7FqC3WrsX6EQ)  
- [C++异常机制概述](https://mp.weixin.qq.com/s/36ZPzr8C0fdym01dbzAp9w)  
- [这些课堂上不教的 C++ 的基本特性你都知道吗？](https://mp.weixin.qq.com/s/9fWm1UeFTWJHvcT_oMkbJw)  
- [C++ 如何避免内存泄露？](https://mp.weixin.qq.com/s/oUkUPatxE9ey9Z5tanQx5w)  
- [C++11 中的左值、右值和将亡值](https://mp.weixin.qq.com/s/D6GOlOUnDMXQNzapQpojSw)  
- [C/C++函数指针与指针函数](https://mp.weixin.qq.com/s/CXWk46p2jHSH0lvjYxeFHQ)  
- [delete 和 delete [] 的真正区别](https://mp.weixin.qq.com/s/068JYAbUgM_ZxPNkMsUYng)  
- [C++ 学习笔记](https://mp.weixin.qq.com/s/6JgrV4BZYxokRy4RWvdx8Q)  
- [一起探索C++类内存分布](https://mp.weixin.qq.com/s/nBemv1mfzB471lVjho0RMA)  
- [【最佳实践】C++陷阱与套路](https://mp.weixin.qq.com/s/SEX4zzAnrBc0F9vV0a0Tfw)  
- [泛型Lambda，如此强大！](https://mp.weixin.qq.com/s/fZlSPdbyGofuT6-Wy_vJsg)  
- [架构思维：如何让写程序像搭积木一样轻松？](https://mp.weixin.qq.com/s/UEoLqC3q2Yg-JPLc0jO1ow)  
- [打工人万字讲清软件性能优化](https://mp.weixin.qq.com/s/atf3XlF9MF0MKNt8yHYFdg)  
- [C++按值返回对象那些事](https://mp.weixin.qq.com/s/5ZZ9JhyTYJiPhMCnYQZZAw)  
- [哪个程序经得起这样的优化？](https://mp.weixin.qq.com/s/fN2ZCNUVWrcZLgHZ3cU9ZA)  
- [C++ 的门门道道](https://mp.weixin.qq.com/s/mlUFce8ZxdVWAE51nd3WtA)  
- [线程安全代码到底是怎么编写的？](https://mp.weixin.qq.com/s/bg_thr0Sw1if11POnBYBMw)  
- [内存管理：程序是如何被优雅的装载到内存中](https://mp.weixin.qq.com/s/ieAdSq1EMelxdpTeLDvWOQ)  
- [简单！代码原来是这样被CPU跑起来的](https://mp.weixin.qq.com/s/_ZCu-KBFhiAlC-ZMFaDcWw)  
- [600 条最强 Linux 命令总结](https://mp.weixin.qq.com/s/3EzA5KfzP9p1JqrJEkj6kg)  
- [C++对象的底层原理都在这儿了，还敢说学不会？](https://mp.weixin.qq.com/s/HnIXrPSS2WZkYGflHdq6_Q)  
- [C++是如何从代码到游戏的？](https://mp.weixin.qq.com/s/Iov4pyyzpSq7HC6GcOfHag)  
- [if-else和switch-case哪个效率更高？看这四张图。](https://mp.weixin.qq.com/s/zZ2O1tamQ6NDMneu9kKZRQ)  
- [谈谈 C++ 单例模式](https://mp.weixin.qq.com/s/bv1danVw0cgtFOKofVlyeA)  
- [亲身体验！后端工程师学习路径、书籍、视频推荐](https://mp.weixin.qq.com/s/vYKgLYzvzyQp3qdCrP5giA)  
- [C++常见的三种内存破坏的场景和分析](https://mp.weixin.qq.com/s/uG4R-oSjf2AO-OVm2A1rPw)  
- [你踩过几种C++内存泄露的坑？](https://mp.weixin.qq.com/s/8h_ek1NLE9mOKdA2WiOoQw)  
- [内存池设计与实现](https://mp.weixin.qq.com/s/_eKL38Mpj2FwbYqPeT0zCA)  
- [打开线程 | 进程 | 协程的大门](https://mp.weixin.qq.com/s/If1tQkkCxH8YBoYwb5ML0g)  
- [深度好文|面试官：进程和线程，我只问这19个问题](https://mp.weixin.qq.com/s/18naExy4OziASr8I20iLIg)  
- [效能优化实践 | C/C++单元测试万能插桩工具](https://mp.weixin.qq.com/s/keRFxCHe1zZjSWoBuxFm1A)  
- [手写线程池 - C++版](https://mp.weixin.qq.com/s/kysLdHnziy8p4v-20cOh7g)  
- [C++ 线程的使用](https://mp.weixin.qq.com/s/tMWxvw4Kmga5ayUfXHaaIw)  
- [C++学到什么程度可以面试工作？](https://mp.weixin.qq.com/s/g1fJzMHn0llsl8QyTCqhXw)  
- [C++ 内存管理（一）](https://mp.weixin.qq.com/s/0L0ElVuGxZc7UkMvFEpXzQ)  
- [std 源码剖析及 C++ 内存管理(二)](https://mp.weixin.qq.com/s/xWxnWrXtak8qUKvgbuK-gw)  
- [C++代码简化之道](https://mp.weixin.qq.com/s/VSM6nUzfg6k-la03Gyh9JQ)  
- [揭开高性能服务器底层面纱](https://mp.weixin.qq.com/s/GIXA8xeoTpNSp8nQkKdrnQ)  
- [windows程序崩溃调试终极武器](https://mp.weixin.qq.com/s/MQhQgiTjT9quPhCSRhYscA)  
- [长文预警！C语言与C++常见问答题](https://mp.weixin.qq.com/s/RuRmysepgvy2mRbPzmap0Q)  
- [提升 C++ 开发效率的几个小技巧](https://mp.weixin.qq.com/s/6OlwI4BVpmYX_rvJlEgQdQ)  
- [书单：拓展对C++的认知层次](https://mp.weixin.qq.com/s/DytH3UGF8aTOKeSKd0XhpA)  
- [和各种诡异 Bug 打交道 13 年，我总结了 18 个经验](https://mp.weixin.qq.com/s/y9btrBRgFMRyIfJLH7wTAg)  
- [去银行写代码是什么样的体验](https://mp.weixin.qq.com/s/37R9RQIKZ3DZfe8VWJdx0g)   
- [谈谈C++新标准带来的属性（Attribute）](https://mp.weixin.qq.com/s/rlUzED3Lbzz-R580J8896A)  
- [百度C++工程师的那些极限优化（并发篇）](https://mp.weixin.qq.com/s/9e3_6yqkzmzHJsazPFiTJQ)  
- [百度C++工程师的那些极限优化（内存篇）](https://mp.weixin.qq.com/s/KxluQI2LrmRwMUvA5bULvQ)    
- [图解|从武侠角度探究STL排序算法的奥秘](https://mp.weixin.qq.com/s/aG07yqdgUr6n7WyHYqBfXQ)  
- [C++中是如何调用C接口的？](https://mp.weixin.qq.com/s/NNJyZtQaLkbGSbhLkDZZIg)  
- [C++编码优化之减少冗余拷贝或赋值](https://mp.weixin.qq.com/s/6S95N763ZbTFm65jt9z4lg)  
- [计算机为什么要用补码？](https://mp.weixin.qq.com/s/yxCUKm7oGHEV8eADDHlB5g)  
- [生成随机数的方式你选对了吗？](https://mp.weixin.qq.com/s/dQTl0Xqzd1agvUpIlAuhgw)   
- [总结了24个C++的大坑，看你能躲过几个？](https://mp.weixin.qq.com/s/wJW0DLO2LuBKZ0tMihh0Zw)  
- [这些知识点你都知道吗，测试你的C++入门程度](https://mp.weixin.qq.com/s/t91aaV2-QGj3sGpayP3SnQ)  
- [超硬核 | 2 万字+20 图带你手撕 STL 序列式容器源码](https://mp.weixin.qq.com/s/Xl7mrv5utdPXYEebv8WwHA)  
- [浅析C++智能指针和enable_shared_from_this 机制](https://mp.weixin.qq.com/s/qWL_UDbErmQLUHw8wNXvGw)  
- [经典永不过时！重温设计模式](https://mp.weixin.qq.com/s/DgnYYWSKMItSbe_e34ukQQ)  
- [全网首发！！C++20新特性全在这一张图里了](https://mp.weixin.qq.com/s/Za8hUHOqVUm3EvE1W-NZ9g)  
- [C++的最后一道坎|百万年薪的程序员](https://mp.weixin.qq.com/s/lEvFZiD-_RBYOTWNmb2SMA)  
- [C++模版的本质](https://mp.weixin.qq.com/s/7gC9T0rSM9honWrmawYpkw)  
- [10 个内存引发的大坑，你能躲开几个？](https://mp.weixin.qq.com/s/EJ2h7lApmFxNgxqj7BKSpQ)   
- [C++内存管理全景指南](https://mp.weixin.qq.com/s/rvNF6FRo3QD4Xvj9RfV5Tw)  
- [9个提高代码运行效率的小技巧你知道几个？](https://mp.weixin.qq.com/s/4DpErJGcpY0TD9l6mB8IEw)  
- [精选 30 个 C++ 面试题（含解析）](https://mp.weixin.qq.com/s/eCoDUsDZHBhcb1SJhkYtZQ)  
- [腾讯 C++ 笔试/面试题及答案](https://mp.weixin.qq.com/s/lX9mmmRecu2gw84xkInsww) 
- [C++ 万字长文第一篇---拿下字节面试](https://mp.weixin.qq.com/s/HKDfeufP5Qdd3aOOb2HUXQ)  
- [《逆袭进大厂》之C++篇49问49答(绝对的干货)](https://mp.weixin.qq.com/s/HhK07ERK0qoBaIl6uyDrHw)  
- [《逆袭进大厂》第二弹之C++进阶篇59问59答(超硬核干货)](https://mp.weixin.qq.com/s/JAks8CXr1t-X3BkPtsKRpQ)  
- [《逆袭进大厂》之C++提高篇79问79答](https://mp.weixin.qq.com/s/JEwjRYlgB9HTawu11eycnQ)  
- [自己动手实现一个malloc内存分配器 | 30图](https://mp.weixin.qq.com/s/T1084cymO-XWuSVLnguMuw)  
- [现代C++之手写智能指针](https://mp.weixin.qq.com/s/YrCI5oCRha501BZSI59WeA)  
- [10张图22段代码，万字长文带你搞懂虚拟内存模型和malloc内部原理](https://mp.weixin.qq.com/s/yIjVZfS4KzR3bJyBFPxvZQ)  
- [面试系列之C++的对象布局【建议收藏】](https://mp.weixin.qq.com/s/YUrGmRZeA4YyOxsSS_UMyQ)  
- [c++代码整洁之道](https://mp.weixin.qq.com/s/WYu3zEyvH-BkV8p5Ofw5_Q)  
- [源码分析C++的string的实现](https://mp.weixin.qq.com/s/olfCAm9QmJd60TMbSBYU5w)  
- [23种设计模式的通俗解释，看完秒懂](https://mp.weixin.qq.com/s/iUllkGYI4YZDjJidHj-xnA) 
- [一位大佬对于 Qt 学习的最全总结（三万字干货）](https://mp.weixin.qq.com/s/z0QY26H2nhlQyhMrlx01xg)  
- [3万字Linux总结](https://mp.weixin.qq.com/s/f5qjGkCBEtDJrw6FOR1Knw)    
- [加密与解密](https://mp.weixin.qq.com/s/wRo9UyOAQxT1gSE6jVkPKQ)  
- [TCP数据粘包的处理](https://mp.weixin.qq.com/s/WacXXMUKD-O8iFvEodpoOA)  

## C++视频推荐

- [C++视频学习教程基础篇](https://www.bilibili.com/video/BV18h411Q75D/)   
- [华郑莉老师视频](https://space.bilibili.com/702528832)  
- [侯捷C++视频全集与陈硕网络编程](https://mp.weixin.qq.com/s/302poB-agGUSepqNlmi9sQ)  
- [最好的Qt全套视频教程](https://www.bilibili.com/video/BV1jK4y1m7d4)  

## C++开源推荐

- [FreeNOS](https://github.com/Neirth/FreeNOS):深入理解C++，以及操作系统原理。FreeNOS（Free Niek的操作系统）是一个基于C++的基于微内核的学习操作系统。这是一个用C++实现的微内核的操作系统，各种宏内核中的服务作为一个独立的services在微内核中，基于消息的通信方式，这点其实跟mac内核中的mach那部分机制相似。  
- [Boost](https://www.boost.org/):Boost 库是一个经过千锤百炼、可移植、提供源代码的C++ 库，作为标准库的后备，是C++ 标准化进程的发动机之一。 Boost 库由C++标准委员会库工作组成员发起，在C++ 社区中影响甚大，其成员已近2000 人。 Boost 库为我们带来了最新、最酷、最实用的技术，是不折不扣的“ 准” 标准库。
- [muduo](https://github.com/AlexStocks/muduo):一个基于 Reactor 模式的现代 C++ 网络库，它采用非阻塞 IO 模型，基于事件驱动和回调，支持多核多线程，适合编写 Linux 服务端多线程网络应用程序。   
- [libevent](https://github.com/libevent/):一个是轻量级的网络库.
- [log4cpp](https://sourceforge.net/p/log4cplus/wiki/Home/):日志库， 支持多线程， 日志重定向到网络等都有， 反正你能想到的日志的功能， 都有。
- [OpenSSL](https://www.openssl.org/source/):OpenSSL 包含一个命令行工具用来完成OpenSSL 库中的所有功能，更好的是，它可能已经安装到你的系统中了。
- [wfrest](https://github.com/wfrest/wfrest):简单高效的c++11异步restful网络框架。
- [workflow](https://github.com/sogou/workflow):当前最火最简洁好用的c++异步网络库workflow。
- [modern-cpp-tutorial](https://github.com/changkun/modern-cpp-tutorial):modern-cpp-tutorial 是现代 C++ 教程，它的目的是提供关于现代 C++（2020 年前）的相关特性的全面介绍。
- [MyTinySTL](https://github.com/Alinshans/MyTinySTL):用 C++11 重新复写了一个小型 STL（容器库＋算法库）。代码结构清晰规范、包含中文文档与注释，并且自带一个简单的测试框架，适合 C++ 新手来实践一番。
- [Tinytetris](https://link.zhihu.com/?target=https%3A//github.com/taylorconor/tinytetris):Tinytetris 是一个用 C++ 编写的终端版俄罗斯方块游戏。它提供了两个版本的源码，分为注释版和库版，注释较多易于理解和学习。



<p id="LinuxC/C++校招"></p>

# **4、Linux C/C++ 校招**

- [春招要到了，推荐几个可以练习C/C++以及算法的题库](https://mp.weixin.qq.com/s/hPKwlOq4WzsABeAi_avG4w)

- [CS本，刚接了字节的offer，分享一下我的经验](https://mp.weixin.qq.com/s/SuJ7bnIOPZsqrqQquQO_YA)
- [万字详解我今年经历的腾讯Linux C++ 笔试/面试题及答案](https://mp.weixin.qq.com/s/HFiolswK_CRyXRPD4cHstg)
- [20道必须掌握的C++面试题](https://mp.weixin.qq.com/s/CklZPq6T3lD6C3Eg_lQd3Q)
- [盘点一下Linux/C/C++/嵌入式/硬件相关的公司](https://mp.weixin.qq.com/s/o8C2R3kWJeT1pa49M-LqmQ)

<p id="LinuxC/C++社招"></p>

# **5、Linux C/C++ 社招**

- [硬核 | 50 家企业 C++ 面经分享](https://mp.weixin.qq.com/s/kOOqurMW7NML-A0ow_mD7g)
- [盘点一下Linux/C/C++/嵌入式/硬件相关的公司](https://mp.weixin.qq.com/s/o8C2R3kWJeT1pa49M-LqmQ)







