/* Copyright (c) 2019-2024 Griefer@Work                                       *
 *                                                                            *
 * This software is provided 'as-is', without any express or implied          *
 * warranty. In no event will the authors be held liable for any damages      *
 * arising from the use of this software.                                     *
 *                                                                            *
 * Permission is granted to anyone to use this software for any purpose,      *
 * including commercial applications, and to alter it and redistribute it     *
 * freely, subject to the following restrictions:                             *
 *                                                                            *
 * 1. The origin of this software must not be misrepresented; you must not    *
 *    claim that you wrote the original software. If you use this software    *
 *    in a product, an acknowledgement (see the following) in the product     *
 *    documentation is required:                                              *
 *    Portions Copyright (c) 2019-2024 Griefer@Work                           *
 * 2. Altered source versions must be plainly marked as such, and must not be *
 *    misrepresented as being the original software.                          *
 * 3. This notice may not be removed or altered from any source distribution. *
 */
%(c_prefix){
/* (#) Portability: Cygwin        (/newlib/libc/include/langinfo.h) */
/* (#) Portability: DragonFly BSD (/include/langinfo.h) */
/* (#) Portability: EMX kLIBC     (/libc/include/langinfo.h) */
/* (#) Portability: FreeBSD       (/include/langinfo.h) */
/* (#) Portability: GNU C Library (/locale/langinfo.h) */
/* (#) Portability: GNU Hurd      (/usr/include/langinfo.h) */
/* (#) Portability: NetBSD        (/include/langinfo.h) */
/* (#) Portability: Newlib        (/newlib/libc/include/langinfo.h) */
/* (#) Portability: OpenBSD       (/include/langinfo.h) */
/* (#) Portability: OpenSolaris   (/usr/src/head/langinfo.h) */
/* (#) Portability: diet libc     (/include/langinfo.h) */
/* (#) Portability: libc6         (/include/langinfo.h) */
/* (#) Portability: musl libc     (/include/langinfo.h) */
/* (#) Portability: uClibc        (/include/langinfo.h) */
}

%[default:section(".text.crt{|.dos}.i18n")]

%[insert:prefix(
#include <features.h>
)]%[insert:prefix(
#include <asm/crt/langinfo.h>
)]%[insert:prefix(
#include <nl_types.h>
)]%{
#ifdef __USE_XOPEN2K8
#include <xlocale.h>
#endif /* __USE_XOPEN2K8 */

}
%#ifdef __CC__
%{
__SYSDECL_BEGIN

/* Construct an index for use with `nl_langinfo(3)' or `nl_langinfo_l(3)',
 * that will return the name of the locale currently used for  `category'.
 * @param: category: One of `LC_*' from <locale.h> */
#define _NL_LOCALE_NAME(category) _NL_ITEM(category, 0xffff)
#ifdef __USE_GNU
#define NL_LOCALE_NAME(category) _NL_LOCALE_NAME(category)
#endif /* __USE_GNU */

/* Possible values for `nl_langinfo(3)' */
#define ABDAY_1              _NL_TIME_ABDAY_1                /* "Sun" */
#define ABDAY_2              _NL_TIME_ABDAY_2                /* "Mon" */
#define ABDAY_3              _NL_TIME_ABDAY_3                /* "Tue" */
#define ABDAY_4              _NL_TIME_ABDAY_4                /* "Wed" */
#define ABDAY_5              _NL_TIME_ABDAY_5                /* "Thu" */
#define ABDAY_6              _NL_TIME_ABDAY_6                /* "Fri" */
#define ABDAY_7              _NL_TIME_ABDAY_7                /* "Sat" */
#define DAY_1                _NL_TIME_DAY_1                  /* "Sunday" */
#define DAY_2                _NL_TIME_DAY_2                  /* "Monday" */
#define DAY_3                _NL_TIME_DAY_3                  /* "Tuesday" */
#define DAY_4                _NL_TIME_DAY_4                  /* "Wednesday" */
#define DAY_5                _NL_TIME_DAY_5                  /* "Thursday" */
#define DAY_6                _NL_TIME_DAY_6                  /* "Friday" */
#define DAY_7                _NL_TIME_DAY_7                  /* "Saturday" */
#define ABMON_1              _NL_TIME_ABMON_1                /* "Jan" */
#define ABMON_2              _NL_TIME_ABMON_2                /* "Feb" */
#define ABMON_3              _NL_TIME_ABMON_3                /* "Mar" */
#define ABMON_4              _NL_TIME_ABMON_4                /* "Apr" */
#define ABMON_5              _NL_TIME_ABMON_5                /* "May" */
#define ABMON_6              _NL_TIME_ABMON_6                /* "Jun" */
#define ABMON_7              _NL_TIME_ABMON_7                /* "Jul" */
#define ABMON_8              _NL_TIME_ABMON_8                /* "Aug" */
#define ABMON_9              _NL_TIME_ABMON_9                /* "Sep" */
#define ABMON_10             _NL_TIME_ABMON_10               /* "Oct" */
#define ABMON_11             _NL_TIME_ABMON_11               /* "Nov" */
#define ABMON_12             _NL_TIME_ABMON_12               /* "Dec" */
#define MON_1                _NL_TIME_MON_1                  /* "January" */
#define MON_2                _NL_TIME_MON_2                  /* "February" */
#define MON_3                _NL_TIME_MON_3                  /* "March" */
#define MON_4                _NL_TIME_MON_4                  /* "April" */
#define MON_5                _NL_TIME_MON_5                  /* "May" */
#define MON_6                _NL_TIME_MON_6                  /* "June" */
#define MON_7                _NL_TIME_MON_7                  /* "July" */
#define MON_8                _NL_TIME_MON_8                  /* "August" */
#define MON_9                _NL_TIME_MON_9                  /* "September" */
#define MON_10               _NL_TIME_MON_10                 /* "October" */
#define MON_11               _NL_TIME_MON_11                 /* "November" */
#define MON_12               _NL_TIME_MON_12                 /* "December" */
#define AM_STR               _NL_TIME_AM_STR                 /* "AM" */
#define PM_STR               _NL_TIME_PM_STR                 /* "PM" */
#define D_T_FMT              _NL_TIME_D_T_FMT                /* "%a %b %e %H:%M:%S %Y" */
#define D_FMT                _NL_TIME_D_FMT                  /* "%m/%d/%y" */
#define T_FMT                _NL_TIME_T_FMT                  /* "%H:%M:%S" */
#define T_FMT_AMPM           _NL_TIME_T_FMT_AMPM             /* "%I:%M:%S %p" */
#define ERA                  _NL_TIME_ERA                    /* "" */
#define __ERA_YEAR           _NL_TIME_ERA_YEAR               /* "" */
#define ERA_D_FMT            _NL_TIME_ERA_D_FMT              /* "" */
#define ALT_DIGITS           _NL_TIME_ALT_DIGITS             /* "" */
#define ERA_D_T_FMT          _NL_TIME_ERA_D_T_FMT            /* "" */
#define ERA_T_FMT            _NL_TIME_ERA_T_FMT              /* "" */
#define _NL_WABDAY_1         _NL_TIME_WABDAY_1               /* L"Sun" */
#define _NL_WABDAY_2         _NL_TIME_WABDAY_2               /* L"Mon" */
#define _NL_WABDAY_3         _NL_TIME_WABDAY_3               /* L"Tue" */
#define _NL_WABDAY_4         _NL_TIME_WABDAY_4               /* L"Wed" */
#define _NL_WABDAY_5         _NL_TIME_WABDAY_5               /* L"Thu" */
#define _NL_WABDAY_6         _NL_TIME_WABDAY_6               /* L"Fri" */
#define _NL_WABDAY_7         _NL_TIME_WABDAY_7               /* L"Sat" */
#define _NL_WDAY_1           _NL_TIME_WDAY_1                 /* L"Sunday" */
#define _NL_WDAY_2           _NL_TIME_WDAY_2                 /* L"Monday" */
#define _NL_WDAY_3           _NL_TIME_WDAY_3                 /* L"Tuesday" */
#define _NL_WDAY_4           _NL_TIME_WDAY_4                 /* L"Wednesday" */
#define _NL_WDAY_5           _NL_TIME_WDAY_5                 /* L"Thursday" */
#define _NL_WDAY_6           _NL_TIME_WDAY_6                 /* L"Friday" */
#define _NL_WDAY_7           _NL_TIME_WDAY_7                 /* L"Saturday" */
#define _NL_WABMON_1         _NL_TIME_WABMON_1               /* L"Jan" */
#define _NL_WABMON_2         _NL_TIME_WABMON_2               /* L"Feb" */
#define _NL_WABMON_3         _NL_TIME_WABMON_3               /* L"Mar" */
#define _NL_WABMON_4         _NL_TIME_WABMON_4               /* L"Apr" */
#define _NL_WABMON_5         _NL_TIME_WABMON_5               /* L"May" */
#define _NL_WABMON_6         _NL_TIME_WABMON_6               /* L"Jun" */
#define _NL_WABMON_7         _NL_TIME_WABMON_7               /* L"Jul" */
#define _NL_WABMON_8         _NL_TIME_WABMON_8               /* L"Aug" */
#define _NL_WABMON_9         _NL_TIME_WABMON_9               /* L"Sep" */
#define _NL_WABMON_10        _NL_TIME_WABMON_10              /* L"Oct" */
#define _NL_WABMON_11        _NL_TIME_WABMON_11              /* L"Nov" */
#define _NL_WABMON_12        _NL_TIME_WABMON_12              /* L"Dec" */
#define _NL_WMON_1           _NL_TIME_WMON_1                 /* L"January" */
#define _NL_WMON_2           _NL_TIME_WMON_2                 /* L"February" */
#define _NL_WMON_3           _NL_TIME_WMON_3                 /* L"March" */
#define _NL_WMON_4           _NL_TIME_WMON_4                 /* L"April" */
#define _NL_WMON_5           _NL_TIME_WMON_5                 /* L"May" */
#define _NL_WMON_6           _NL_TIME_WMON_6                 /* L"June" */
#define _NL_WMON_7           _NL_TIME_WMON_7                 /* L"July" */
#define _NL_WMON_8           _NL_TIME_WMON_8                 /* L"August" */
#define _NL_WMON_9           _NL_TIME_WMON_9                 /* L"September" */
#define _NL_WMON_10          _NL_TIME_WMON_10                /* L"October" */
#define _NL_WMON_11          _NL_TIME_WMON_11                /* L"November" */
#define _NL_WMON_12          _NL_TIME_WMON_12                /* L"December" */
#define _NL_WAM_STR          _NL_TIME_WAM_STR                /* L"AM" */
#define _NL_WPM_STR          _NL_TIME_WPM_STR                /* L"PM" */
#define _NL_WD_T_FMT         _NL_TIME_WD_T_FMT               /* L"%a %b %e %H:%M:%S %Y" */
#define _NL_WD_FMT           _NL_TIME_WD_FMT                 /* L"%m/%d/%y" */
#define _NL_WT_FMT           _NL_TIME_WT_FMT                 /* L"%H:%M:%S" */
#define _NL_WT_FMT_AMPM      _NL_TIME_WT_FMT_AMPM            /* L"%I:%M:%S %p" */
#define _NL_WERA_YEAR        _NL_TIME_WERA_YEAR              /* L"" */
#define _NL_WERA_D_FMT       _NL_TIME_WERA_D_FMT             /* L"" */
#define _NL_WALT_DIGITS      _NL_TIME_WALT_DIGITS            /* L"" */
#define _NL_WERA_D_T_FMT     _NL_TIME_WERA_D_T_FMT           /* L"" */
#define _NL_WERA_T_FMT       _NL_TIME_WERA_T_FMT             /* L"" */
#define _DATE_FMT            _NL_TIME_DATE_FMT               /* "%a %b %e %H:%M:%S %Z %Y" */
#define _NL_W_DATE_FMT       _NL_TIME_W_DATE_FMT             /* L"%a %b %e %H:%M:%S %Z %Y" */
#define __INT_CURR_SYMBOL    _NL_MONETARY_INT_CURR_SYMBOL    /* "" */
#define __CURRENCY_SYMBOL    _NL_MONETARY_CURRENCY_SYMBOL    /* "" */
#define __MON_DECIMAL_POINT  _NL_MONETARY_MON_DECIMAL_POINT  /* "" */
#define __MON_THOUSANDS_SEP  _NL_MONETARY_MON_THOUSANDS_SEP  /* "" */
#define __MON_GROUPING       _NL_MONETARY_MON_GROUPING       /* [0x00] [array-of-uint8_t] */
#define __POSITIVE_SIGN      _NL_MONETARY_POSITIVE_SIGN      /* "" */
#define __NEGATIVE_SIGN      _NL_MONETARY_NEGATIVE_SIGN      /* "" */
#define __INT_FRAC_DIGITS    _NL_MONETARY_INT_FRAC_DIGITS    /* 0xff [pointer-to-uint8_t] */
#define __FRAC_DIGITS        _NL_MONETARY_FRAC_DIGITS        /* 0xff [pointer-to-uint8_t] */
#define __P_CS_PRECEDES      _NL_MONETARY_P_CS_PRECEDES      /* 0xff [pointer-to-uint8_t] */
#define __P_SEP_BY_SPACE     _NL_MONETARY_P_SEP_BY_SPACE     /* 0xff [pointer-to-uint8_t] */
#define __N_CS_PRECEDES      _NL_MONETARY_N_CS_PRECEDES      /* 0xff [pointer-to-uint8_t] */
#define __N_SEP_BY_SPACE     _NL_MONETARY_N_SEP_BY_SPACE     /* 0xff [pointer-to-uint8_t] */
#define __P_SIGN_POSN        _NL_MONETARY_P_SIGN_POSN        /* 0xff [pointer-to-uint8_t] */
#define __N_SIGN_POSN        _NL_MONETARY_N_SIGN_POSN        /* 0xff [pointer-to-uint8_t] */
#define __INT_P_CS_PRECEDES  _NL_MONETARY_INT_P_CS_PRECEDES  /* 0xff [pointer-to-uint8_t] */
#define __INT_P_SEP_BY_SPACE _NL_MONETARY_INT_P_SEP_BY_SPACE /* 0xff [pointer-to-uint8_t] */
#define __INT_N_CS_PRECEDES  _NL_MONETARY_INT_N_CS_PRECEDES  /* 0xff [pointer-to-uint8_t] */
#define __INT_N_SEP_BY_SPACE _NL_MONETARY_INT_N_SEP_BY_SPACE /* 0xff [pointer-to-uint8_t] */
#define __INT_P_SIGN_POSN    _NL_MONETARY_INT_P_SIGN_POSN    /* 0xff [pointer-to-uint8_t] */
#define __INT_N_SIGN_POSN    _NL_MONETARY_INT_N_SIGN_POSN    /* 0xff [pointer-to-uint8_t] */
#define __DECIMAL_POINT      _NL_NUMERIC_DECIMAL_POINT       /* "." */
#define __THOUSANDS_SEP      _NL_NUMERIC_THOUSANDS_SEP       /* "" */
#define __GROUPING           _NL_NUMERIC_GROUPING            /* [0x00] [array-of-uint8_t] */
#define __YESEXPR            _NL_MESSAGES_YESEXPR            /* "^[yY]" */
#define __NOEXPR             _NL_MESSAGES_NOEXPR             /* "^[nN]" */
#define __YESSTR             _NL_MESSAGES_YESSTR             /* "" */
#define __NOSTR              _NL_MESSAGES_NOSTR              /* "" */
#define __ALTMON_1           _NL_TIME_ALTMON_1               /* "January" */
#define __ALTMON_2           _NL_TIME_ALTMON_2               /* "February" */
#define __ALTMON_3           _NL_TIME_ALTMON_3               /* "March" */
#define __ALTMON_4           _NL_TIME_ALTMON_4               /* "April" */
#define __ALTMON_5           _NL_TIME_ALTMON_5               /* "May" */
#define __ALTMON_6           _NL_TIME_ALTMON_6               /* "June" */
#define __ALTMON_7           _NL_TIME_ALTMON_7               /* "July" */
#define __ALTMON_8           _NL_TIME_ALTMON_8               /* "August" */
#define __ALTMON_9           _NL_TIME_ALTMON_9               /* "September" */
#define __ALTMON_10          _NL_TIME_ALTMON_10              /* "October" */
#define __ALTMON_11          _NL_TIME_ALTMON_11              /* "November" */
#define __ALTMON_12          _NL_TIME_ALTMON_12              /* "December" */

/* Some more unescaped aliases for `nl_langinfo(3)' */
#define CODESET   _NL_CTYPE_CODESET_NAME /* "utf-8" */
#define CRNCYSTR  _NL_MONETARY_CRNCYSTR  /* "-" */
#define RADIXCHAR __DECIMAL_POINT        /* "." */
#define THOUSEP   __THOUSANDS_SEP        /* "" */
#define YESEXPR   __YESEXPR              /* "^[yY]" */
#define NOEXPR    __NOEXPR               /* "^[nN]" */

/* Feature-specific aliases for `nl_langinfo(3)' */
#ifdef __USE_GNU
#define ERA_YEAR           __ERA_YEAR           /* "" */
#define INT_CURR_SYMBOL    __INT_CURR_SYMBOL    /* "" */
#define CURRENCY_SYMBOL    __CURRENCY_SYMBOL    /* "" */
#define MON_DECIMAL_POINT  __MON_DECIMAL_POINT  /* "" */
#define MON_THOUSANDS_SEP  __MON_THOUSANDS_SEP  /* "" */
#define MON_GROUPING       __MON_GROUPING       /* [0x00] [array-of-uint8_t] */
#define POSITIVE_SIGN      __POSITIVE_SIGN      /* "" */
#define NEGATIVE_SIGN      __NEGATIVE_SIGN      /* "" */
#define INT_FRAC_DIGITS    __INT_FRAC_DIGITS    /* 0xff [pointer-to-uint8_t] */
#define FRAC_DIGITS        __FRAC_DIGITS        /* 0xff [pointer-to-uint8_t] */
#define P_CS_PRECEDES      __P_CS_PRECEDES      /* 0xff [pointer-to-uint8_t] */
#define P_SEP_BY_SPACE     __P_SEP_BY_SPACE     /* 0xff [pointer-to-uint8_t] */
#define N_CS_PRECEDES      __N_CS_PRECEDES      /* 0xff [pointer-to-uint8_t] */
#define N_SEP_BY_SPACE     __N_SEP_BY_SPACE     /* 0xff [pointer-to-uint8_t] */
#define P_SIGN_POSN        __P_SIGN_POSN        /* 0xff [pointer-to-uint8_t] */
#define N_SIGN_POSN        __N_SIGN_POSN        /* 0xff [pointer-to-uint8_t] */
#define INT_P_CS_PRECEDES  __INT_P_CS_PRECEDES  /* 0xff [pointer-to-uint8_t] */
#define INT_P_SEP_BY_SPACE __INT_P_SEP_BY_SPACE /* 0xff [pointer-to-uint8_t] */
#define INT_N_CS_PRECEDES  __INT_N_CS_PRECEDES  /* 0xff [pointer-to-uint8_t] */
#define INT_N_SEP_BY_SPACE __INT_N_SEP_BY_SPACE /* 0xff [pointer-to-uint8_t] */
#define INT_P_SIGN_POSN    __INT_P_SIGN_POSN    /* 0xff [pointer-to-uint8_t] */
#define INT_N_SIGN_POSN    __INT_N_SIGN_POSN    /* 0xff [pointer-to-uint8_t] */
#define DECIMAL_POINT      __DECIMAL_POINT      /* "." */
#define THOUSANDS_SEP      __THOUSANDS_SEP      /* "" */
#define GROUPING           __GROUPING           /* [0x00] [array-of-uint8_t] */
#define ALTMON_1           _NL_TIME_ALTMON_1    /* "January" */
#define ALTMON_2           _NL_TIME_ALTMON_2    /* "February" */
#define ALTMON_3           _NL_TIME_ALTMON_3    /* "March" */
#define ALTMON_4           _NL_TIME_ALTMON_4    /* "April" */
#define ALTMON_5           _NL_TIME_ALTMON_5    /* "May" */
#define ALTMON_6           _NL_TIME_ALTMON_6    /* "June" */
#define ALTMON_7           _NL_TIME_ALTMON_7    /* "July" */
#define ALTMON_8           _NL_TIME_ALTMON_8    /* "August" */
#define ALTMON_9           _NL_TIME_ALTMON_9    /* "September" */
#define ALTMON_10          _NL_TIME_ALTMON_10   /* "October" */
#define ALTMON_11          _NL_TIME_ALTMON_11   /* "November" */
#define ALTMON_12          _NL_TIME_ALTMON_12   /* "December" */
#endif /* __USE_GNU */
#if defined(__USE_GNU) || (defined(__USE_XOPEN) && !defined(__USE_XOPEN2K))
#define YESSTR __YESSTR /* "" */
#define NOSTR  __NOSTR  /* "" */
#endif /* __USE_GNU || (__USE_XOPEN && !__USE_XOPEN2K) */

}

%[define_c_language_keyword(__KOS_FIXED_CONST)]

@@>> nl_langinfo(3), nl_langinfo_l(3)
@@Return the name of the given `item' (one of the macros above)
@@to be returned for  the current locale (s.a.  `setlocale(3)')
@@This function never returns `NULL',  but may return an  empty
@@string when `item' is invalid.
@@@param: item: One of the macros from <langinfo.h>, or one of `_NL_*'
[[nonnull, decl_include("<features.h>")]]
[[impl_include("<asm/crt/langinfo.h>", "<asm/crt/locale.h>")]]
[[impl_include("<hybrid/byteorder.h>", "<hybrid/typecore.h>")]]
char __KOS_FIXED_CONST *nl_langinfo(__STDC_INT_AS_UINT_T item) {
	char const *result = "";
	unsigned int idx = @_NL_ITEM_INDEX@(item);
/*[[[deemon
// Default implementation (returning values from comments found in <asm/crt/langinfo.h>)
import * from deemon;
@@Mapping from category-name -> index -> (nl_name, int | Bytes),
@@where the last element is @int for [uintptr_t], and Bytes for
@@all other elements. When 2 Bytes are given, they're (le, be)
local nl_cat: {string: {int: (string, int | Bytes | (Bytes, Bytes))}} = Dict();
for (local l: File.open("../../../include/asm/crt/langinfo.h")) {
	local nl_name, cat, idx, com;
	try {
		nl_name, cat, idx, com = l.scanf(" # define _NL_%[^ ] _NL_ITEM ( __%[^,], %[^)]) /" "* %[^]")...;
	} catch (...) {
		continue;
	}
	nl_name = "_NL_" + nl_name.strip().decode("utf-8");
	cat     = cat.strip().decode("utf-8");
	idx     = int(idx.strip());
	com     = com.strip().rsstrip("*" "/").rstrip();
	local val;
	if (com.startswith("\"") && com.endswith("\"")) {
		val = com[1:-1].decode("c-escape").bytes();
		if (val == "...") {
			val = Bytes({ 0 });
		} else {
			val = val + Bytes({ 0 });
		}
	} else if (com.startswith("L\"") && com.endswith("\"")) {
		val = com[2:-1].decode("c-escape");
		if (val == "...") {
			val = Bytes({ 0, 0, 0, 0 });
		} else {
			val = val + "\0";
			val = (val.encode("utf-32-le").bytes(), val.encode("utf-32-be").bytes());
		}
	} else if (com.endswith("[pointer-to-uint8_t]")) {
		val = Bytes({ int(com[:-#"[pointer-to-uint8_t]"].rstrip()), 0 });
	} else if (com.endswith("[array-of-uint8_t]")) {
		com = com[:-#"[array-of-uint8_t]"].rstrip();
		assert com.startswith("[") && com.endswith("]");
		if ("..." in com) {
			val = Bytes({ 0 });
		} else {
			val = Bytes(for (local x: com[1:-1].split(",").each.strip()) int(x));
		}
	} else if (com.endswith("[array-of-uint32_t]")) {
		com = com[:-#"[array-of-uint32_t]"].rstrip();
		assert com.startswith("[") && com.endswith("]");
		if ("..." in com) {
			val = Bytes({ 0 });
		} else {
			function makebytes(endian) ->
				(for (local x: com[1:-1].split(",").each.strip())
					int(x).tobytes(4, endian, false)) + ...;
			val = (makebytes("little"), makebytes("big"));
		}
	} else if (com.endswith("[uintptr_t]")) {
		val = int(com[:-#"[uintptr_t]"].rstrip());
	} else if (!com) {
		continue;
	} else {
		throw Error("Unrecognized value format: " + repr com);
	}
	local tab = nl_cat.get(cat);
	if (tab is none)
		nl_cat[cat] = tab = Dict();
	tab[idx] = (nl_name, val);
}

// Gather referenced byte-blobs
local knownBytesLe = HashSet();
local knownBytesBe = HashSet();
for (local tab: nl_cat.values) {
	for (local none, value: tab.values) {
		if (value is Bytes) {
			knownBytesLe.insert(value);
			knownBytesBe.insert(value);
		} else if (value is Sequence) {
			local a, b = value...;
			knownBytesLe.insert(a);
			knownBytesBe.insert(b);
		}
	}
}

// Sorted referenced byte-blobs by length (descendingly)
function sortByLength(x) {
	x = x.sorted();
	x.sort(key: x -> -#x);
	return x;
}
knownBytesLe = sortByLength(knownBytesLe);
knownBytesBe = sortByLength(knownBytesBe);

// Generate string tables for byte sequences
function generateByteBlob(byteList: {Bytes...}): Bytes {
	local result = Bytes();
	for (local e: byteList) {
		if (e !in result)
			result = result + e;
	}
	return result;
}
local byteBlobLe = generateByteBlob(knownBytesLe);
local byteBlobBe = generateByteBlob(knownBytesBe);

// Print raw byte tables.
function printByteBlob(blob: Bytes) {
	print("	static byte_t const byteblob[", #blob, "] = {");
	for (local line: blob.segments(16)) {
		print("		"),;
		print((",".join(for (local b: line) b.hex(2)) + ",").ljust(80)),;
		print(" /" "* " + repr(str(line)).replace("\\u000", "\\") + " *" "/");
	}
	print("	};");
}
print("@@pp_if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__@@");
printByteBlob(byteBlobLe);
print("@@pp_else@@");
printByteBlob(byteBlobBe);
print("@@pp_endif@@");

print("	switch(@_NL_ITEM_CATEGORY@(item)) {");
print("");

for (local name, tab: nl_cat) {
	print("	case __", name, ": {");
	local numIndices = (tab.keys > ...) + 1;
	local byteOffsetTableLe = List();
	local byteOffsetTableBe = List();
	for (local idx: [:numIndices]) {
		local translit = tab.get(idx, ("", "".bytes())).last;
		if (translit is Bytes) {
			byteOffsetTableLe.append(byteBlobLe.index(translit));
			byteOffsetTableBe.append(byteBlobBe.index(translit));
		} else if (translit is Sequence) {
			local a, b = translit...;
			byteOffsetTableLe.append(byteBlobLe.index(a));
			byteOffsetTableBe.append(byteBlobBe.index(b));
		} else {
			assert translit is int;
			byteOffsetTableLe.append(~translit);
			byteOffsetTableBe.append(~translit);
		}
	}
	local maxOffset = { byteOffsetTableLe > ..., byteOffsetTableBe > ... } > ...;
	local blobOffsetType;
	if (maxOffset >= 0x8000) {
		blobOffsetType = "int32_t";
	} else if (maxOffset >= 0x80) {
		blobOffsetType = "int16_t";
	} else {
		blobOffsetType = "int8_t";
	}
	local maxImmediateInteger = {
		"int8_t"  : 0x7f,
		"int16_t" : 0x7fff,
		"int32_t" : 0x7fffffff,
	}[blobOffsetType];
	local needIndirectIntegerTable = 0;
	local numberOfWordValues = 0;
	local numberOfRequiredIndEntries = 0;
	for (local none, value: tab.values) {
		if (value is int) {
			if (needIndirectIntegerTable < value)
				needIndirectIntegerTable = value;
			if (value > maxImmediateInteger)
				++numberOfRequiredIndEntries;
			++numberOfWordValues;
		}
	}
	local indirectTableValues = [];
	if (needIndirectIntegerTable > maxImmediateInteger) {
		local indirectTableType;
		if (maxOffset > 0xffff) {
			indirectTableType = "uint32_t";
		} else if (maxOffset > 0xff) {
			indirectTableType = "uint16_t";
		} else {
			indirectTableType = "uint8_t";
		}
		for (local idx: [:numIndices]) {
			local x = byteOffsetTableLe[idx];
			if (x < 0) {
				x = ~x;
				local slot = indirectTableValues.find(x);
				if (slot < 0) {
					slot = #indirectTableValues;
					indirectTableValues.append(x);
				}
				slot = ~slot;
				byteOffsetTableLe[idx] = slot;
				byteOffsetTableBe[idx] = slot;
			}
		}
		needIndirectIntegerTable = numberOfRequiredIndEntries > 2;
		// Print the indirect integer table (if needed)
		if (needIndirectIntegerTable) {
			print("		static ", indirectTableType, " const indint_", name, "[", #indirectTableValues, "] = {");
			print("			", ",\n\t\t\t".join(
				for (local line: indirectTableValues.segments(16))
					",".join(line)
			));
			print("		};");
		}
	} else {
		needIndirectIntegerTable = false;
	}
	if (!numberOfWordValues) {
		blobOffsetType = "u" + blobOffsetType;
	} else {
		// When all negatives get handled explicitly, then we can use unsigned offsets!
		local numberOfExplicit = 0;
		for (local idx, entry: tab) {
			local name, value = entry...;
			if (value !is int || value <= maxImmediateInteger)
				continue;
			++numberOfExplicit;
		}
		assert numberOfExplicit <= numberOfWordValues;
		if (numberOfExplicit >= numberOfWordValues)
			blobOffsetType = "u" + blobOffsetType;
	}

	// Print the word-value/byteblob-/indirect-offset table
	function printOffsetValues(byteOffsetTable: {int...}) {
		function getByteBlobOffsetTableValue(x: int): string {
			if (x >= 0)
				return str x;
			if (!needIndirectIntegerTable && indirectTableValues)
				x = ~indirectTableValues[~x];
			if (~x <= maxImmediateInteger)
				return "~"+str(~x);
			return 0;
		}
		print("			", ",\n\t\t\t".join(
			for (local line: byteOffsetTable.segments(16))
				",".join(for (local x: line)
					getByteBlobOffsetTableValue(x))
		));
	}
	print("		static ", blobOffsetType, " const offtab_", name, "[", numIndices, "] = {");
	if (byteOffsetTableLe == byteOffsetTableBe) {
		printOffsetValues(byteOffsetTableLe);
	} else {
		print("@@pp_if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__@@");
		printOffsetValues(byteOffsetTableLe);
		print("@@pp_else@@");
		printOffsetValues(byteOffsetTableBe);
		print("@@pp_endif@@");
	}
	print("		};");

	// Special handling for category name
	print("		if (idx == 0xffff) {");
	print("			result = ", repr name, ";");
	print("			break;");
	print("		}");
	if (!needIndirectIntegerTable && indirectTableValues) {
		// Don't want to generate an indirect table word values.
		// -- Instead, check for such values explicitly
		for (local idx, entry: tab) {
			local name, value = entry...;
			if (value !is int || value <= maxImmediateInteger)
				continue;
			print("		if (idx == ", idx, ") { /" "* ", name, " *" "/");
			print("			result = (char const *)(uintptr_t)UINTPTR_C(", value, ");");
			print("			break;");
			print("		}");
		}
	}

	// Check index bounds against `numIndices'
	print("		if likely(idx < ", numIndices, ") {");
	// Load offset into byte-blob
	print("			", blobOffsetType, " offset = offtab_", name, "[idx];");
	if (needIndirectIntegerTable) {
		assert !blobOffsetType.startswith("u");
		print("			if (offset < 0) {");
		print("				result = (char const *)(uintptr_t)indint_", name, "[~offset];");
		print("				break;");
		print("			}");
	} else if (!blobOffsetType.startswith("u")) {
		print("			if (offset < 0) {");
		print("				result = (char const *)(uintptr_t)~offset;");
		print("				break;");
		print("			}");
	}
	print("			result = (char const *)(byteblob + offset);");
	print("		}");
	print("	}	break;");
	print("");
}

print("	default:");
print("		break;");
print("	}");

]]]*/
@@pp_if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__@@
	static byte_t const byteblob[1762] = {
		0x25,0x00,0x00,0x00,0x61,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x25,0x00,0x00,0x00, /* "%\0\0\0a\0\0\0 \0\0\0%\0\0\0" */
		0x62,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x65,0x00,0x00,0x00, /* "b\0\0\0 \0\0\0%\0\0\0e\0\0\0" */
		0x20,0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x48,0x00,0x00,0x00,0x3a,0x00,0x00,0x00, /* " \0\0\0%\0\0\0H\0\0\0:\0\0\0" */
		0x25,0x00,0x00,0x00,0x4d,0x00,0x00,0x00,0x3a,0x00,0x00,0x00,0x25,0x00,0x00,0x00, /* "%\0\0\0M\0\0\0:\0\0\0%\0\0\0" */
		0x53,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x5a,0x00,0x00,0x00, /* "S\0\0\0 \0\0\0%\0\0\0Z\0\0\0" */
		0x20,0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x59,0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* " \0\0\0%\0\0\0Y\0\0\0\0\0\0\0" */
		0x25,0x00,0x00,0x00,0x61,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x25,0x00,0x00,0x00, /* "%\0\0\0a\0\0\0 \0\0\0%\0\0\0" */
		0x62,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x65,0x00,0x00,0x00, /* "b\0\0\0 \0\0\0%\0\0\0e\0\0\0" */
		0x20,0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x48,0x00,0x00,0x00,0x3a,0x00,0x00,0x00, /* " \0\0\0%\0\0\0H\0\0\0:\0\0\0" */
		0x25,0x00,0x00,0x00,0x4d,0x00,0x00,0x00,0x3a,0x00,0x00,0x00,0x25,0x00,0x00,0x00, /* "%\0\0\0M\0\0\0:\0\0\0%\0\0\0" */
		0x53,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x59,0x00,0x00,0x00, /* "S\0\0\0 \0\0\0%\0\0\0Y\0\0\0" */
		0x00,0x00,0x00,0x00,0x75,0x70,0x70,0x65,0x72,0x00,0x6c,0x6f,0x77,0x65,0x72,0x00, /* "\0\0\0\0upper\0lower\0" */
		0x61,0x6c,0x70,0x68,0x61,0x00,0x64,0x69,0x67,0x69,0x74,0x00,0x78,0x64,0x69,0x67, /* "alpha\0digit\0xdig" */
		0x69,0x74,0x00,0x73,0x70,0x61,0x63,0x65,0x00,0x70,0x72,0x69,0x6e,0x74,0x00,0x67, /* "it\0space\0print\0g" */
		0x72,0x61,0x70,0x68,0x00,0x62,0x6c,0x61,0x6e,0x6b,0x00,0x63,0x6e,0x74,0x72,0x6c, /* "raph\0blank\0cntrl" */
		0x00,0x70,0x75,0x6e,0x63,0x74,0x00,0x61,0x6c,0x6e,0x75,0x6d,0x00,0x00,0x00,0x25, /* "\0punct\0alnum\0\0\0%" */
		0x00,0x00,0x00,0x49,0x00,0x00,0x00,0x3a,0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x4d, /* "\0\0\0I\0\0\0:\0\0\0%\0\0\0M" */
		0x00,0x00,0x00,0x3a,0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x53,0x00,0x00,0x00,0x20, /* "\0\0\0:\0\0\0%\0\0\0S\0\0\0 " */
		0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x25, /* "\0\0\0%\0\0\0p\0\0\0\0\0\0\0%" */
		0x61,0x25,0x4e,0x25,0x66,0x25,0x4e,0x25,0x64,0x25,0x4e,0x25,0x62,0x25,0x4e,0x25, /* "a%N%f%N%d%N%b%N%" */
		0x73,0x20,0x25,0x68,0x20,0x25,0x65,0x20,0x25,0x72,0x25,0x4e,0x25,0x43,0x2d,0x25, /* "s %h %e %r%N%C-%" */
		0x7a,0x20,0x25,0x54,0x25,0x4e,0x25,0x63,0x25,0x4e,0x00,0x57,0x00,0x00,0x00,0x65, /* "z %T%N%c%N\0W\0\0\0e" */
		0x00,0x00,0x00,0x64,0x00,0x00,0x00,0x6e,0x00,0x00,0x00,0x65,0x00,0x00,0x00,0x73, /* "\0\0\0d\0\0\0n\0\0\0e\0\0\0s" */
		0x00,0x00,0x00,0x64,0x00,0x00,0x00,0x61,0x00,0x00,0x00,0x79,0x00,0x00,0x00,0x00, /* "\0\0\0d\0\0\0a\0\0\0y\0\0\0\0" */
		0x00,0x00,0x00,0x53,0x00,0x00,0x00,0x65,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x74, /* "\0\0\0S\0\0\0e\0\0\0p\0\0\0t" */
		0x00,0x00,0x00,0x65,0x00,0x00,0x00,0x6d,0x00,0x00,0x00,0x62,0x00,0x00,0x00,0x65, /* "\0\0\0e\0\0\0m\0\0\0b\0\0\0e" */
		0x00,0x00,0x00,0x72,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x54,0x00,0x00,0x00,0x68, /* "\0\0\0r\0\0\0\0\0\0\0T\0\0\0h" */
		0x00,0x00,0x00,0x75,0x00,0x00,0x00,0x72,0x00,0x00,0x00,0x73,0x00,0x00,0x00,0x64, /* "\0\0\0u\0\0\0r\0\0\0s\0\0\0d" */
		0x00,0x00,0x00,0x61,0x00,0x00,0x00,0x79,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x53, /* "\0\0\0a\0\0\0y\0\0\0\0\0\0\0S" */
		0x00,0x00,0x00,0x61,0x00,0x00,0x00,0x74,0x00,0x00,0x00,0x75,0x00,0x00,0x00,0x72, /* "\0\0\0a\0\0\0t\0\0\0u\0\0\0r" */
		0x00,0x00,0x00,0x64,0x00,0x00,0x00,0x61,0x00,0x00,0x00,0x79,0x00,0x00,0x00,0x00, /* "\0\0\0d\0\0\0a\0\0\0y\0\0\0\0" */
		0x00,0x00,0x00,0x4e,0x00,0x00,0x00,0x6f,0x00,0x00,0x00,0x76,0x00,0x00,0x00,0x65, /* "\0\0\0N\0\0\0o\0\0\0v\0\0\0e" */
		0x00,0x00,0x00,0x6d,0x00,0x00,0x00,0x62,0x00,0x00,0x00,0x65,0x00,0x00,0x00,0x72, /* "\0\0\0m\0\0\0b\0\0\0e\0\0\0r" */
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x46,0x00,0x00,0x00,0x65,0x00,0x00,0x00,0x62, /* "\0\0\0\0\0\0\0F\0\0\0e\0\0\0b" */
		0x00,0x00,0x00,0x72,0x00,0x00,0x00,0x75,0x00,0x00,0x00,0x61,0x00,0x00,0x00,0x72, /* "\0\0\0r\0\0\0u\0\0\0a\0\0\0r" */
		0x00,0x00,0x00,0x79,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x44,0x00,0x00,0x00,0x65, /* "\0\0\0y\0\0\0\0\0\0\0D\0\0\0e" */
		0x00,0x00,0x00,0x63,0x00,0x00,0x00,0x65,0x00,0x00,0x00,0x6d,0x00,0x00,0x00,0x62, /* "\0\0\0c\0\0\0e\0\0\0m\0\0\0b" */
		0x00,0x00,0x00,0x65,0x00,0x00,0x00,0x72,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x25, /* "\0\0\0e\0\0\0r\0\0\0\0\0\0\0%" */
		0x00,0x00,0x00,0x6d,0x00,0x00,0x00,0x2f,0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x64, /* "\0\0\0m\0\0\0/\0\0\0%\0\0\0d" */
		0x00,0x00,0x00,0x2f,0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x79,0x00,0x00,0x00,0x00, /* "\0\0\0/\0\0\0%\0\0\0y\0\0\0\0" */
		0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x48,0x00,0x00,0x00,0x3a,0x00,0x00,0x00,0x25, /* "\0\0\0%\0\0\0H\0\0\0:\0\0\0%" */
		0x00,0x00,0x00,0x4d,0x00,0x00,0x00,0x3a,0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x53, /* "\0\0\0M\0\0\0:\0\0\0%\0\0\0S" */
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x54,0x00,0x00,0x00,0x75,0x00,0x00,0x00,0x65, /* "\0\0\0\0\0\0\0T\0\0\0u\0\0\0e" */
		0x00,0x00,0x00,0x73,0x00,0x00,0x00,0x64,0x00,0x00,0x00,0x61,0x00,0x00,0x00,0x79, /* "\0\0\0s\0\0\0d\0\0\0a\0\0\0y" */
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x4f,0x00,0x00,0x00,0x63,0x00,0x00,0x00,0x74, /* "\0\0\0\0\0\0\0O\0\0\0c\0\0\0t" */
		0x00,0x00,0x00,0x6f,0x00,0x00,0x00,0x62,0x00,0x00,0x00,0x65,0x00,0x00,0x00,0x72, /* "\0\0\0o\0\0\0b\0\0\0e\0\0\0r" */
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x4a,0x00,0x00,0x00,0x61,0x00,0x00,0x00,0x6e, /* "\0\0\0\0\0\0\0J\0\0\0a\0\0\0n" */
		0x00,0x00,0x00,0x75,0x00,0x00,0x00,0x61,0x00,0x00,0x00,0x72,0x00,0x00,0x00,0x79, /* "\0\0\0u\0\0\0a\0\0\0r\0\0\0y" */
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x53,0x00,0x00,0x00,0x75,0x00,0x00,0x00,0x6e, /* "\0\0\0\0\0\0\0S\0\0\0u\0\0\0n" */
		0x00,0x00,0x00,0x64,0x00,0x00,0x00,0x61,0x00,0x00,0x00,0x79,0x00,0x00,0x00,0x00, /* "\0\0\0d\0\0\0a\0\0\0y\0\0\0\0" */
		0x00,0x00,0x00,0x4d,0x00,0x00,0x00,0x6f,0x00,0x00,0x00,0x6e,0x00,0x00,0x00,0x64, /* "\0\0\0M\0\0\0o\0\0\0n\0\0\0d" */
		0x00,0x00,0x00,0x61,0x00,0x00,0x00,0x79,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x46, /* "\0\0\0a\0\0\0y\0\0\0\0\0\0\0F" */
		0x00,0x00,0x00,0x72,0x00,0x00,0x00,0x69,0x00,0x00,0x00,0x64,0x00,0x00,0x00,0x61, /* "\0\0\0r\0\0\0i\0\0\0d\0\0\0a" */
		0x00,0x00,0x00,0x79,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x75, /* "\0\0\0y\0\0\0\0\0\0\0A\0\0\0u" */
		0x00,0x00,0x00,0x67,0x00,0x00,0x00,0x75,0x00,0x00,0x00,0x73,0x00,0x00,0x00,0x74, /* "\0\0\0g\0\0\0u\0\0\0s\0\0\0t" */
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x4d,0x00,0x00,0x00,0x61,0x00,0x00,0x00,0x72, /* "\0\0\0\0\0\0\0M\0\0\0a\0\0\0r" */
		0x00,0x00,0x00,0x63,0x00,0x00,0x00,0x68,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41, /* "\0\0\0c\0\0\0h\0\0\0\0\0\0\0A" */
		0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x72,0x00,0x00,0x00,0x69,0x00,0x00,0x00,0x6c, /* "\0\0\0p\0\0\0r\0\0\0i\0\0\0l" */
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x25,0x61,0x20,0x25,0x62,0x20,0x25,0x65,0x20, /* "\0\0\0\0\0\0\0%a %b %e " */
		0x25,0x48,0x3a,0x25,0x4d,0x3a,0x25,0x53,0x20,0x25,0x5a,0x20,0x25,0x59,0x00,0x25, /* "%H:%M:%S %Z %Y\0%" */
		0x61,0x20,0x25,0x62,0x20,0x25,0x65,0x20,0x25,0x48,0x3a,0x25,0x4d,0x3a,0x25,0x53, /* "a %b %e %H:%M:%S" */
		0x20,0x25,0x59,0x00,0x4a,0x00,0x00,0x00,0x75,0x00,0x00,0x00,0x6e,0x00,0x00,0x00, /* " %Y\0J\0\0\0u\0\0\0n\0\0\0" */
		0x65,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x4a,0x00,0x00,0x00,0x75,0x00,0x00,0x00, /* "e\0\0\0\0\0\0\0J\0\0\0u\0\0\0" */
		0x6c,0x00,0x00,0x00,0x79,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x74,0x6f,0x75,0x70, /* "l\0\0\0y\0\0\0\0\0\0\0toup" */
		0x70,0x65,0x72,0x00,0x74,0x6f,0x6c,0x6f,0x77,0x65,0x72,0x00,0x00,0x00,0x57,0x00, /* "per\0tolower\0\0\0W\0" */
		0x00,0x00,0x65,0x00,0x00,0x00,0x64,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x54,0x00, /* "\0\0e\0\0\0d\0\0\0\0\0\0\0T\0" */
		0x00,0x00,0x75,0x00,0x00,0x00,0x65,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x54,0x00, /* "\0\0u\0\0\0e\0\0\0\0\0\0\0T\0" */
		0x00,0x00,0x68,0x00,0x00,0x00,0x75,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x53,0x00, /* "\0\0h\0\0\0u\0\0\0\0\0\0\0S\0" */
		0x00,0x00,0x75,0x00,0x00,0x00,0x6e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x53,0x00, /* "\0\0u\0\0\0n\0\0\0\0\0\0\0S\0" */
		0x00,0x00,0x65,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x53,0x00, /* "\0\0e\0\0\0p\0\0\0\0\0\0\0S\0" */
		0x00,0x00,0x61,0x00,0x00,0x00,0x74,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x4f,0x00, /* "\0\0a\0\0\0t\0\0\0\0\0\0\0O\0" */
		0x00,0x00,0x63,0x00,0x00,0x00,0x74,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x4e,0x00, /* "\0\0c\0\0\0t\0\0\0\0\0\0\0N\0" */
		0x00,0x00,0x6f,0x00,0x00,0x00,0x76,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x4d,0x00, /* "\0\0o\0\0\0v\0\0\0\0\0\0\0M\0" */
		0x00,0x00,0x6f,0x00,0x00,0x00,0x6e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x4d,0x00, /* "\0\0o\0\0\0n\0\0\0\0\0\0\0M\0" */
		0x00,0x00,0x61,0x00,0x00,0x00,0x79,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x4d,0x00, /* "\0\0a\0\0\0y\0\0\0\0\0\0\0M\0" */
		0x00,0x00,0x61,0x00,0x00,0x00,0x72,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x4a,0x00, /* "\0\0a\0\0\0r\0\0\0\0\0\0\0J\0" */
		0x00,0x00,0x75,0x00,0x00,0x00,0x6e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x4a,0x00, /* "\0\0u\0\0\0n\0\0\0\0\0\0\0J\0" */
		0x00,0x00,0x75,0x00,0x00,0x00,0x6c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x4a,0x00, /* "\0\0u\0\0\0l\0\0\0\0\0\0\0J\0" */
		0x00,0x00,0x61,0x00,0x00,0x00,0x6e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x46,0x00, /* "\0\0a\0\0\0n\0\0\0\0\0\0\0F\0" */
		0x00,0x00,0x72,0x00,0x00,0x00,0x69,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x46,0x00, /* "\0\0r\0\0\0i\0\0\0\0\0\0\0F\0" */
		0x00,0x00,0x65,0x00,0x00,0x00,0x62,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x44,0x00, /* "\0\0e\0\0\0b\0\0\0\0\0\0\0D\0" */
		0x00,0x00,0x65,0x00,0x00,0x00,0x63,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00, /* "\0\0e\0\0\0c\0\0\0\0\0\0\0A\0" */
		0x00,0x00,0x75,0x00,0x00,0x00,0x67,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00, /* "\0\0u\0\0\0g\0\0\0\0\0\0\0A\0" */
		0x00,0x00,0x70,0x00,0x00,0x00,0x72,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x25,0x70, /* "\0\0p\0\0\0r\0\0\0\0\0\0\0%p" */
		0x25,0x74,0x25,0x67,0x25,0x74,0x25,0x6d,0x25,0x74,0x25,0x66,0x00,0x50,0x00,0x00, /* "%t%g%t%m%t%f\0P\0\0" */
		0x00,0x4d,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x4d,0x00,0x00, /* "\0M\0\0\0\0\0\0\0A\0\0\0M\0\0" */
		0x00,0x00,0x00,0x00,0x00,0x25,0x49,0x3a,0x25,0x4d,0x3a,0x25,0x53,0x20,0x25,0x70, /* "\0\0\0\0\0%I:%M:%S %p" */
		0x00,0x57,0x65,0x64,0x6e,0x65,0x73,0x64,0x61,0x79,0x00,0x53,0x65,0x70,0x74,0x65, /* "\0Wednesday\0Septe" */
		0x6d,0x62,0x65,0x72,0x00,0x2b,0x25,0x63,0x20,0x25,0x61,0x20,0x25,0x6c,0x00,0x54, /* "mber\0+%c %a %l\0T" */
		0x68,0x75,0x72,0x73,0x64,0x61,0x79,0x00,0x53,0x61,0x74,0x75,0x72,0x64,0x61,0x79, /* "hursday\0Saturday" */
		0x00,0x4e,0x6f,0x76,0x65,0x6d,0x62,0x65,0x72,0x00,0x46,0x65,0x62,0x72,0x75,0x61, /* "\0November\0Februa" */
		0x72,0x79,0x00,0x44,0x65,0x63,0x65,0x6d,0x62,0x65,0x72,0x00,0x25,0x6d,0x2f,0x25, /* "ry\0December\0%m/%" */
		0x64,0x2f,0x25,0x79,0x00,0x25,0x48,0x3a,0x25,0x4d,0x3a,0x25,0x53,0x00,0x54,0x75, /* "d/%y\0%H:%M:%S\0Tu" */
		0x65,0x73,0x64,0x61,0x79,0x00,0x4f,0x63,0x74,0x6f,0x62,0x65,0x72,0x00,0x4a,0x61, /* "esday\0October\0Ja" */
		0x6e,0x75,0x61,0x72,0x79,0x00,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x39,0x00, /* "nuary\0?\0\0\0\0\0\0\09\0" */
		0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x37,0x00, /* "\0\0\0\0\0\08\0\0\0\0\0\0\0007\0" */
		0x00,0x00,0x00,0x00,0x00,0x00,0x36,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x35,0x00, /* "\0\0\0\0\0\0006\0\0\0\0\0\0\0005\0" */
		0x00,0x00,0x00,0x00,0x00,0x00,0x34,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x33,0x00, /* "\0\0\0\0\0\0004\0\0\0\0\0\0\0003\0" */
		0x00,0x00,0x00,0x00,0x00,0x00,0x32,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x31,0x00, /* "\0\0\0\0\0\0002\0\0\0\0\0\0\0001\0" */
		0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x53,0x75, /* "\0\0\0\0\0\0000\0\0\0\0\0\0\0Su" */
		0x6e,0x64,0x61,0x79,0x00,0x4d,0x6f,0x6e,0x64,0x61,0x79,0x00,0x46,0x72,0x69,0x64, /* "nday\0Monday\0Frid" */
		0x61,0x79,0x00,0x41,0x75,0x67,0x75,0x73,0x74,0x00,0x5e,0x5b,0x79,0x59,0x5d,0x00, /* "ay\0August\0^[yY]\0" */
		0x5e,0x5b,0x6e,0x4e,0x5d,0x00,0x55,0x54,0x46,0x2d,0x38,0x00,0x4d,0x61,0x72,0x63, /* "^[nN]\0UTF-8\0Marc" */
		0x68,0x00,0x41,0x70,0x72,0x69,0x6c,0x00,0x4a,0x75,0x6e,0x65,0x00,0x4a,0x75,0x6c, /* "h\0April\0June\0Jul" */
		0x79,0x00,0x57,0x65,0x64,0x00,0x54,0x75,0x65,0x00,0x54,0x68,0x75,0x00,0x53,0x75, /* "y\0Wed\0Tue\0Thu\0Su" */
		0x6e,0x00,0x53,0x65,0x70,0x00,0x53,0x61,0x74,0x00,0x4f,0x63,0x74,0x00,0x4e,0x6f, /* "n\0Sep\0Sat\0Oct\0No" */
		0x76,0x00,0x4d,0x6f,0x6e,0x00,0x4d,0x61,0x79,0x00,0x4d,0x61,0x72,0x00,0x4a,0x75, /* "v\0Mon\0May\0Mar\0Ju" */
		0x6e,0x00,0x4a,0x75,0x6c,0x00,0x4a,0x61,0x6e,0x00,0x46,0x72,0x69,0x00,0x46,0x65, /* "n\0Jul\0Jan\0Fri\0Fe" */
		0x62,0x00,0x44,0x65,0x63,0x00,0x41,0x75,0x67,0x00,0x41,0x70,0x72,0x00,0x50,0x4d, /* "b\0Dec\0Aug\0Apr\0PM" */
		0x00,0x41,0x4d,0x00,0xff,0x00,0x2e,0x00,0x2d,0x00,0x07,0x00,0x04,0x00,0x02,0x00, /* "\0AM\0\u00FF\0.\0-\0\a\0\4\0\2\0" */
		0x01,0x00,                                                                       /* "\1\0" */
	};
@@pp_else@@
	static byte_t const byteblob[1762] = {
		0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x61,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x25, /* "\0\0\0%\0\0\0a\0\0\0 \0\0\0%" */
		0x00,0x00,0x00,0x62,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x65, /* "\0\0\0b\0\0\0 \0\0\0%\0\0\0e" */
		0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x48,0x00,0x00,0x00,0x3a, /* "\0\0\0 \0\0\0%\0\0\0H\0\0\0:" */
		0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x4d,0x00,0x00,0x00,0x3a,0x00,0x00,0x00,0x25, /* "\0\0\0%\0\0\0M\0\0\0:\0\0\0%" */
		0x00,0x00,0x00,0x53,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x5a, /* "\0\0\0S\0\0\0 \0\0\0%\0\0\0Z" */
		0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x59,0x00,0x00,0x00,0x00, /* "\0\0\0 \0\0\0%\0\0\0Y\0\0\0\0" */
		0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x61,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x25, /* "\0\0\0%\0\0\0a\0\0\0 \0\0\0%" */
		0x00,0x00,0x00,0x62,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x65, /* "\0\0\0b\0\0\0 \0\0\0%\0\0\0e" */
		0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x48,0x00,0x00,0x00,0x3a, /* "\0\0\0 \0\0\0%\0\0\0H\0\0\0:" */
		0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x4d,0x00,0x00,0x00,0x3a,0x00,0x00,0x00,0x25, /* "\0\0\0%\0\0\0M\0\0\0:\0\0\0%" */
		0x00,0x00,0x00,0x53,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x59, /* "\0\0\0S\0\0\0 \0\0\0%\0\0\0Y" */
		0x00,0x00,0x00,0x00,0x75,0x70,0x70,0x65,0x72,0x00,0x6c,0x6f,0x77,0x65,0x72,0x00, /* "\0\0\0\0upper\0lower\0" */
		0x61,0x6c,0x70,0x68,0x61,0x00,0x64,0x69,0x67,0x69,0x74,0x00,0x78,0x64,0x69,0x67, /* "alpha\0digit\0xdig" */
		0x69,0x74,0x00,0x73,0x70,0x61,0x63,0x65,0x00,0x70,0x72,0x69,0x6e,0x74,0x00,0x67, /* "it\0space\0print\0g" */
		0x72,0x61,0x70,0x68,0x00,0x62,0x6c,0x61,0x6e,0x6b,0x00,0x63,0x6e,0x74,0x72,0x6c, /* "raph\0blank\0cntrl" */
		0x00,0x70,0x75,0x6e,0x63,0x74,0x00,0x61,0x6c,0x6e,0x75,0x6d,0x00,0x00,0x00,0x00, /* "\0punct\0alnum\0\0\0\0" */
		0x00,0x00,0x25,0x00,0x00,0x00,0x49,0x00,0x00,0x00,0x3a,0x00,0x00,0x00,0x25,0x00, /* "\0\0%\0\0\0I\0\0\0:\0\0\0%\0" */
		0x00,0x00,0x4d,0x00,0x00,0x00,0x3a,0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x53,0x00, /* "\0\0M\0\0\0:\0\0\0%\0\0\0S\0" */
		0x00,0x00,0x20,0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x25, /* "\0\0 \0\0\0%\0\0\0p\0\0\0\0%" */
		0x61,0x25,0x4e,0x25,0x66,0x25,0x4e,0x25,0x64,0x25,0x4e,0x25,0x62,0x25,0x4e,0x25, /* "a%N%f%N%d%N%b%N%" */
		0x73,0x20,0x25,0x68,0x20,0x25,0x65,0x20,0x25,0x72,0x25,0x4e,0x25,0x43,0x2d,0x25, /* "s %h %e %r%N%C-%" */
		0x7a,0x20,0x25,0x54,0x25,0x4e,0x25,0x63,0x25,0x4e,0x00,0x00,0x00,0x00,0x57,0x00, /* "z %T%N%c%N\0\0\0\0W\0" */
		0x00,0x00,0x65,0x00,0x00,0x00,0x64,0x00,0x00,0x00,0x6e,0x00,0x00,0x00,0x65,0x00, /* "\0\0e\0\0\0d\0\0\0n\0\0\0e\0" */
		0x00,0x00,0x73,0x00,0x00,0x00,0x64,0x00,0x00,0x00,0x61,0x00,0x00,0x00,0x79,0x00, /* "\0\0s\0\0\0d\0\0\0a\0\0\0y\0" */
		0x00,0x00,0x00,0x00,0x00,0x00,0x53,0x00,0x00,0x00,0x65,0x00,0x00,0x00,0x70,0x00, /* "\0\0\0\0\0\0S\0\0\0e\0\0\0p\0" */
		0x00,0x00,0x74,0x00,0x00,0x00,0x65,0x00,0x00,0x00,0x6d,0x00,0x00,0x00,0x62,0x00, /* "\0\0t\0\0\0e\0\0\0m\0\0\0b\0" */
		0x00,0x00,0x65,0x00,0x00,0x00,0x72,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x54,0x00, /* "\0\0e\0\0\0r\0\0\0\0\0\0\0T\0" */
		0x00,0x00,0x68,0x00,0x00,0x00,0x75,0x00,0x00,0x00,0x72,0x00,0x00,0x00,0x73,0x00, /* "\0\0h\0\0\0u\0\0\0r\0\0\0s\0" */
		0x00,0x00,0x64,0x00,0x00,0x00,0x61,0x00,0x00,0x00,0x79,0x00,0x00,0x00,0x00,0x00, /* "\0\0d\0\0\0a\0\0\0y\0\0\0\0\0" */
		0x00,0x00,0x53,0x00,0x00,0x00,0x61,0x00,0x00,0x00,0x74,0x00,0x00,0x00,0x75,0x00, /* "\0\0S\0\0\0a\0\0\0t\0\0\0u\0" */
		0x00,0x00,0x72,0x00,0x00,0x00,0x64,0x00,0x00,0x00,0x61,0x00,0x00,0x00,0x79,0x00, /* "\0\0r\0\0\0d\0\0\0a\0\0\0y\0" */
		0x00,0x00,0x00,0x00,0x00,0x00,0x4e,0x00,0x00,0x00,0x6f,0x00,0x00,0x00,0x76,0x00, /* "\0\0\0\0\0\0N\0\0\0o\0\0\0v\0" */
		0x00,0x00,0x65,0x00,0x00,0x00,0x6d,0x00,0x00,0x00,0x62,0x00,0x00,0x00,0x65,0x00, /* "\0\0e\0\0\0m\0\0\0b\0\0\0e\0" */
		0x00,0x00,0x72,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x46,0x00,0x00,0x00,0x65,0x00, /* "\0\0r\0\0\0\0\0\0\0F\0\0\0e\0" */
		0x00,0x00,0x62,0x00,0x00,0x00,0x72,0x00,0x00,0x00,0x75,0x00,0x00,0x00,0x61,0x00, /* "\0\0b\0\0\0r\0\0\0u\0\0\0a\0" */
		0x00,0x00,0x72,0x00,0x00,0x00,0x79,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x44,0x00, /* "\0\0r\0\0\0y\0\0\0\0\0\0\0D\0" */
		0x00,0x00,0x65,0x00,0x00,0x00,0x63,0x00,0x00,0x00,0x65,0x00,0x00,0x00,0x6d,0x00, /* "\0\0e\0\0\0c\0\0\0e\0\0\0m\0" */
		0x00,0x00,0x62,0x00,0x00,0x00,0x65,0x00,0x00,0x00,0x72,0x00,0x00,0x00,0x00,0x00, /* "\0\0b\0\0\0e\0\0\0r\0\0\0\0\0" */
		0x00,0x00,0x25,0x00,0x00,0x00,0x6d,0x00,0x00,0x00,0x2f,0x00,0x00,0x00,0x25,0x00, /* "\0\0%\0\0\0m\0\0\0/\0\0\0%\0" */
		0x00,0x00,0x64,0x00,0x00,0x00,0x2f,0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x79,0x00, /* "\0\0d\0\0\0/\0\0\0%\0\0\0y\0" */
		0x00,0x00,0x00,0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x48,0x00,0x00,0x00,0x3a,0x00, /* "\0\0\0\0\0\0%\0\0\0H\0\0\0:\0" */
		0x00,0x00,0x25,0x00,0x00,0x00,0x4d,0x00,0x00,0x00,0x3a,0x00,0x00,0x00,0x25,0x00, /* "\0\0%\0\0\0M\0\0\0:\0\0\0%\0" */
		0x00,0x00,0x53,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x54,0x00,0x00,0x00,0x75,0x00, /* "\0\0S\0\0\0\0\0\0\0T\0\0\0u\0" */
		0x00,0x00,0x65,0x00,0x00,0x00,0x73,0x00,0x00,0x00,0x64,0x00,0x00,0x00,0x61,0x00, /* "\0\0e\0\0\0s\0\0\0d\0\0\0a\0" */
		0x00,0x00,0x79,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x4f,0x00,0x00,0x00,0x63,0x00, /* "\0\0y\0\0\0\0\0\0\0O\0\0\0c\0" */
		0x00,0x00,0x74,0x00,0x00,0x00,0x6f,0x00,0x00,0x00,0x62,0x00,0x00,0x00,0x65,0x00, /* "\0\0t\0\0\0o\0\0\0b\0\0\0e\0" */
		0x00,0x00,0x72,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x4a,0x00,0x00,0x00,0x61,0x00, /* "\0\0r\0\0\0\0\0\0\0J\0\0\0a\0" */
		0x00,0x00,0x6e,0x00,0x00,0x00,0x75,0x00,0x00,0x00,0x61,0x00,0x00,0x00,0x72,0x00, /* "\0\0n\0\0\0u\0\0\0a\0\0\0r\0" */
		0x00,0x00,0x79,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x53,0x00,0x00,0x00,0x75,0x00, /* "\0\0y\0\0\0\0\0\0\0S\0\0\0u\0" */
		0x00,0x00,0x6e,0x00,0x00,0x00,0x64,0x00,0x00,0x00,0x61,0x00,0x00,0x00,0x79,0x00, /* "\0\0n\0\0\0d\0\0\0a\0\0\0y\0" */
		0x00,0x00,0x00,0x00,0x00,0x00,0x4d,0x00,0x00,0x00,0x6f,0x00,0x00,0x00,0x6e,0x00, /* "\0\0\0\0\0\0M\0\0\0o\0\0\0n\0" */
		0x00,0x00,0x64,0x00,0x00,0x00,0x61,0x00,0x00,0x00,0x79,0x00,0x00,0x00,0x00,0x00, /* "\0\0d\0\0\0a\0\0\0y\0\0\0\0\0" */
		0x00,0x00,0x46,0x00,0x00,0x00,0x72,0x00,0x00,0x00,0x69,0x00,0x00,0x00,0x64,0x00, /* "\0\0F\0\0\0r\0\0\0i\0\0\0d\0" */
		0x00,0x00,0x61,0x00,0x00,0x00,0x79,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00, /* "\0\0a\0\0\0y\0\0\0\0\0\0\0A\0" */
		0x00,0x00,0x75,0x00,0x00,0x00,0x67,0x00,0x00,0x00,0x75,0x00,0x00,0x00,0x73,0x00, /* "\0\0u\0\0\0g\0\0\0u\0\0\0s\0" */
		0x00,0x00,0x74,0x00,0x00,0x00,0x00,0x25,0x61,0x20,0x25,0x62,0x20,0x25,0x65,0x20, /* "\0\0t\0\0\0\0%a %b %e " */
		0x25,0x48,0x3a,0x25,0x4d,0x3a,0x25,0x53,0x20,0x25,0x5a,0x20,0x25,0x59,0x00,0x00, /* "%H:%M:%S %Z %Y\0\0" */
		0x00,0x00,0x4d,0x00,0x00,0x00,0x61,0x00,0x00,0x00,0x72,0x00,0x00,0x00,0x63,0x00, /* "\0\0M\0\0\0a\0\0\0r\0\0\0c\0" */
		0x00,0x00,0x68,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x70,0x00, /* "\0\0h\0\0\0\0\0\0\0A\0\0\0p\0" */
		0x00,0x00,0x72,0x00,0x00,0x00,0x69,0x00,0x00,0x00,0x6c,0x00,0x00,0x00,0x00,0x25, /* "\0\0r\0\0\0i\0\0\0l\0\0\0\0%" */
		0x61,0x20,0x25,0x62,0x20,0x25,0x65,0x20,0x25,0x48,0x3a,0x25,0x4d,0x3a,0x25,0x53, /* "a %b %e %H:%M:%S" */
		0x20,0x25,0x59,0x00,0x00,0x00,0x00,0x4a,0x00,0x00,0x00,0x75,0x00,0x00,0x00,0x6e, /* " %Y\0\0\0\0J\0\0\0u\0\0\0n" */
		0x00,0x00,0x00,0x65,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x4a,0x00,0x00,0x00,0x75, /* "\0\0\0e\0\0\0\0\0\0\0J\0\0\0u" */
		0x00,0x00,0x00,0x6c,0x00,0x00,0x00,0x79,0x00,0x00,0x00,0x00,0x74,0x6f,0x75,0x70, /* "\0\0\0l\0\0\0y\0\0\0\0toup" */
		0x70,0x65,0x72,0x00,0x74,0x6f,0x6c,0x6f,0x77,0x65,0x72,0x00,0x00,0x00,0x00,0x00, /* "per\0tolower\0\0\0\0\0" */
		0x00,0x57,0x00,0x00,0x00,0x65,0x00,0x00,0x00,0x64,0x00,0x00,0x00,0x00,0x00,0x00, /* "\0W\0\0\0e\0\0\0d\0\0\0\0\0\0" */
		0x00,0x54,0x00,0x00,0x00,0x75,0x00,0x00,0x00,0x65,0x00,0x00,0x00,0x00,0x00,0x00, /* "\0T\0\0\0u\0\0\0e\0\0\0\0\0\0" */
		0x00,0x54,0x00,0x00,0x00,0x68,0x00,0x00,0x00,0x75,0x00,0x00,0x00,0x00,0x00,0x00, /* "\0T\0\0\0h\0\0\0u\0\0\0\0\0\0" */
		0x00,0x53,0x00,0x00,0x00,0x75,0x00,0x00,0x00,0x6e,0x00,0x00,0x00,0x00,0x00,0x00, /* "\0S\0\0\0u\0\0\0n\0\0\0\0\0\0" */
		0x00,0x53,0x00,0x00,0x00,0x65,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00, /* "\0S\0\0\0e\0\0\0p\0\0\0\0\0\0" */
		0x00,0x53,0x00,0x00,0x00,0x61,0x00,0x00,0x00,0x74,0x00,0x00,0x00,0x00,0x00,0x00, /* "\0S\0\0\0a\0\0\0t\0\0\0\0\0\0" */
		0x00,0x4f,0x00,0x00,0x00,0x63,0x00,0x00,0x00,0x74,0x00,0x00,0x00,0x00,0x00,0x00, /* "\0O\0\0\0c\0\0\0t\0\0\0\0\0\0" */
		0x00,0x4e,0x00,0x00,0x00,0x6f,0x00,0x00,0x00,0x76,0x00,0x00,0x00,0x00,0x00,0x00, /* "\0N\0\0\0o\0\0\0v\0\0\0\0\0\0" */
		0x00,0x4d,0x00,0x00,0x00,0x6f,0x00,0x00,0x00,0x6e,0x00,0x00,0x00,0x00,0x00,0x00, /* "\0M\0\0\0o\0\0\0n\0\0\0\0\0\0" */
		0x00,0x4d,0x00,0x00,0x00,0x61,0x00,0x00,0x00,0x79,0x00,0x00,0x00,0x00,0x00,0x00, /* "\0M\0\0\0a\0\0\0y\0\0\0\0\0\0" */
		0x00,0x4d,0x00,0x00,0x00,0x61,0x00,0x00,0x00,0x72,0x00,0x00,0x00,0x00,0x00,0x00, /* "\0M\0\0\0a\0\0\0r\0\0\0\0\0\0" */
		0x00,0x4a,0x00,0x00,0x00,0x75,0x00,0x00,0x00,0x6e,0x00,0x00,0x00,0x00,0x00,0x00, /* "\0J\0\0\0u\0\0\0n\0\0\0\0\0\0" */
		0x00,0x4a,0x00,0x00,0x00,0x75,0x00,0x00,0x00,0x6c,0x00,0x00,0x00,0x00,0x00,0x00, /* "\0J\0\0\0u\0\0\0l\0\0\0\0\0\0" */
		0x00,0x4a,0x00,0x00,0x00,0x61,0x00,0x00,0x00,0x6e,0x00,0x00,0x00,0x00,0x00,0x00, /* "\0J\0\0\0a\0\0\0n\0\0\0\0\0\0" */
		0x00,0x46,0x00,0x00,0x00,0x72,0x00,0x00,0x00,0x69,0x00,0x00,0x00,0x00,0x00,0x00, /* "\0F\0\0\0r\0\0\0i\0\0\0\0\0\0" */
		0x00,0x46,0x00,0x00,0x00,0x65,0x00,0x00,0x00,0x62,0x00,0x00,0x00,0x00,0x00,0x00, /* "\0F\0\0\0e\0\0\0b\0\0\0\0\0\0" */
		0x00,0x44,0x00,0x00,0x00,0x65,0x00,0x00,0x00,0x63,0x00,0x00,0x00,0x00,0x00,0x00, /* "\0D\0\0\0e\0\0\0c\0\0\0\0\0\0" */
		0x00,0x41,0x00,0x00,0x00,0x75,0x00,0x00,0x00,0x67,0x00,0x00,0x00,0x00,0x00,0x00, /* "\0A\0\0\0u\0\0\0g\0\0\0\0\0\0" */
		0x00,0x41,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x72,0x00,0x00,0x00,0x00,0x25,0x70, /* "\0A\0\0\0p\0\0\0r\0\0\0\0%p" */
		0x25,0x74,0x25,0x67,0x25,0x74,0x25,0x6d,0x25,0x74,0x25,0x66,0x00,0x25,0x49,0x3a, /* "%t%g%t%m%t%f\0%I:" */
		0x25,0x4d,0x3a,0x25,0x53,0x20,0x25,0x70,0x00,0x00,0x00,0x00,0x50,0x00,0x00,0x00, /* "%M:%S %p\0\0\0\0P\0\0\0" */
		0x4d,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x4d,0x00,0x00,0x00, /* "M\0\0\0\0\0\0\0A\0\0\0M\0\0\0" */
		0x00,0x57,0x65,0x64,0x6e,0x65,0x73,0x64,0x61,0x79,0x00,0x53,0x65,0x70,0x74,0x65, /* "\0Wednesday\0Septe" */
		0x6d,0x62,0x65,0x72,0x00,0x2b,0x25,0x63,0x20,0x25,0x61,0x20,0x25,0x6c,0x00,0x54, /* "mber\0+%c %a %l\0T" */
		0x68,0x75,0x72,0x73,0x64,0x61,0x79,0x00,0x53,0x61,0x74,0x75,0x72,0x64,0x61,0x79, /* "hursday\0Saturday" */
		0x00,0x4e,0x6f,0x76,0x65,0x6d,0x62,0x65,0x72,0x00,0x46,0x65,0x62,0x72,0x75,0x61, /* "\0November\0Februa" */
		0x72,0x79,0x00,0x44,0x65,0x63,0x65,0x6d,0x62,0x65,0x72,0x00,0x25,0x6d,0x2f,0x25, /* "ry\0December\0%m/%" */
		0x64,0x2f,0x25,0x79,0x00,0x25,0x48,0x3a,0x25,0x4d,0x3a,0x25,0x53,0x00,0x54,0x75, /* "d/%y\0%H:%M:%S\0Tu" */
		0x65,0x73,0x64,0x61,0x79,0x00,0x4f,0x63,0x74,0x6f,0x62,0x65,0x72,0x00,0x4a,0x61, /* "esday\0October\0Ja" */
		0x6e,0x75,0x61,0x72,0x79,0x00,0x00,0x00,0x00,0x3f,0x00,0x00,0x00,0x00,0x00,0x00, /* "nuary\0\0\0\0?\0\0\0\0\0\0" */
		0x00,0x39,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00, /* "\09\0\0\0\0\0\0\08\0\0\0\0\0\0" */
		0x00,0x37,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x36,0x00,0x00,0x00,0x00,0x00,0x00, /* "\0007\0\0\0\0\0\0\0006\0\0\0\0\0\0" */
		0x00,0x35,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x34,0x00,0x00,0x00,0x00,0x00,0x00, /* "\0005\0\0\0\0\0\0\0004\0\0\0\0\0\0" */
		0x00,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x32,0x00,0x00,0x00,0x00,0x00,0x00, /* "\0003\0\0\0\0\0\0\0002\0\0\0\0\0\0" */
		0x00,0x31,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x00,0x53,0x75, /* "\0001\0\0\0\0\0\0\0000\0\0\0\0Su" */
		0x6e,0x64,0x61,0x79,0x00,0x4d,0x6f,0x6e,0x64,0x61,0x79,0x00,0x46,0x72,0x69,0x64, /* "nday\0Monday\0Frid" */
		0x61,0x79,0x00,0x41,0x75,0x67,0x75,0x73,0x74,0x00,0x5e,0x5b,0x79,0x59,0x5d,0x00, /* "ay\0August\0^[yY]\0" */
		0x5e,0x5b,0x6e,0x4e,0x5d,0x00,0x55,0x54,0x46,0x2d,0x38,0x00,0x4d,0x61,0x72,0x63, /* "^[nN]\0UTF-8\0Marc" */
		0x68,0x00,0x41,0x70,0x72,0x69,0x6c,0x00,0x4a,0x75,0x6e,0x65,0x00,0x4a,0x75,0x6c, /* "h\0April\0June\0Jul" */
		0x79,0x00,0x57,0x65,0x64,0x00,0x54,0x75,0x65,0x00,0x54,0x68,0x75,0x00,0x53,0x75, /* "y\0Wed\0Tue\0Thu\0Su" */
		0x6e,0x00,0x53,0x65,0x70,0x00,0x53,0x61,0x74,0x00,0x4f,0x63,0x74,0x00,0x4e,0x6f, /* "n\0Sep\0Sat\0Oct\0No" */
		0x76,0x00,0x4d,0x6f,0x6e,0x00,0x4d,0x61,0x79,0x00,0x4d,0x61,0x72,0x00,0x4a,0x75, /* "v\0Mon\0May\0Mar\0Ju" */
		0x6e,0x00,0x4a,0x75,0x6c,0x00,0x4a,0x61,0x6e,0x00,0x46,0x72,0x69,0x00,0x46,0x65, /* "n\0Jul\0Jan\0Fri\0Fe" */
		0x62,0x00,0x44,0x65,0x63,0x00,0x41,0x75,0x67,0x00,0x41,0x70,0x72,0x00,0x50,0x4d, /* "b\0Dec\0Aug\0Apr\0PM" */
		0x00,0x41,0x4d,0x00,0xff,0x00,0x2e,0x00,0x2d,0x00,0x07,0x00,0x04,0x00,0x02,0x00, /* "\0AM\0\u00FF\0.\0-\0\a\0\4\0\2\0" */
		0x01,0x00,                                                                       /* "\1\0" */
	};
@@pp_endif@@
	switch(@_NL_ITEM_CATEGORY@(item)) {

	case __LC_NAME: {
		static uint16_t const offtab_LC_NAME[7] = {
@@pp_if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__@@
			1342,1,1,1,1,1,1638
@@pp_else@@
			1342,0,0,0,0,0,1638
@@pp_endif@@
		};
		if (idx == 0xffff) {
			result = "LC_NAME";
			break;
		}
		if likely(idx < 7) {
			uint16_t offset = offtab_LC_NAME[idx];
			result = (char const *)(byteblob + offset);
		}
	}	break;

	case __LC_MEASUREMENT: {
		static uint16_t const offtab_LC_MEASUREMENT[2] = {
			1760,1638
		};
		if (idx == 0xffff) {
			result = "LC_MEASUREMENT";
			break;
		}
		if likely(idx < 2) {
			uint16_t offset = offtab_LC_MEASUREMENT[idx];
			result = (char const *)(byteblob + offset);
		}
	}	break;

	case __LC_MONETARY: {
		static int16_t const offtab_LC_MONETARY[46] = {
@@pp_if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__@@
			1,1,1,1,1,1,1,1748,1748,1748,1748,1748,1748,1748,1748,1752,
			1748,1748,1748,1748,1748,1748,1,1,1748,1748,1748,1748,1748,1748,1748,1748,
			1748,1748,1748,1748,1748,1748,~10101,0,~10101,0,1,~0,~0,1638
@@pp_else@@
			0,0,0,0,0,0,0,1748,1748,1748,1748,1748,1748,1748,1748,1752,
			1748,1748,1748,1748,1748,1748,0,0,1748,1748,1748,1748,1748,1748,1748,1748,
			1748,1748,1748,1748,1748,1748,~10101,0,~10101,0,0,~0,~0,1638
@@pp_endif@@
		};
		if (idx == 0xffff) {
			result = "LC_MONETARY";
			break;
		}
		if (idx == 39) { /* _NL_MONETARY_UNO_VALID_TO */
			result = (char const *)(uintptr_t)UINTPTR_C(99991231);
			break;
		}
		if (idx == 41) { /* _NL_MONETARY_DUO_VALID_TO */
			result = (char const *)(uintptr_t)UINTPTR_C(99991231);
			break;
		}
		if likely(idx < 46) {
			int16_t offset = offtab_LC_MONETARY[idx];
			if (offset < 0) {
				result = (char const *)(uintptr_t)~offset;
				break;
			}
			result = (char const *)(byteblob + offset);
		}
	}	break;

	case __LC_TIME: {
		static uint16_t const offtab_LC_TIME[159] = {
@@pp_if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__@@
			1678,1698,1670,1666,1674,1722,1686,1598,1605,1486,1393,1423,1612,1432,1718,1726,
			1706,1738,1702,1710,1714,1734,1682,1690,1694,1730,1502,1450,1644,1650,1702,1656,
			1661,1619,1403,1494,1441,1459,1745,1742,959,1468,1477,1381,1,1,1,1,
			1,1,1,1,1086,1166,1054,1038,1070,1262,1118,775,803,679,347,427,
			831,463,1246,1278,1198,1326,1182,1214,1230,1310,1102,1134,1150,1294,743,535,
			887,911,1182,980,1000,859,387,711,499,571,1369,1357,96,607,643,255,
			89,89,89,89,89,1754,0,1756,1760,1758,1760,1,935,0,1638,1502,
			1450,1644,1650,1702,1656,1661,1619,1403,1494,1441,1459,743,535,887,911,1182,
			980,1000,859,387,711,499,571,1718,1726,1706,1738,1702,1710,1714,1734,1682,
			1690,1694,1730,1246,1278,1198,1326,1182,1214,1230,1310,1102,1134,1150,1294
@@pp_else@@
			1678,1698,1670,1666,1674,1722,1686,1598,1605,1486,1393,1423,1612,1432,1718,1726,
			1706,1738,1702,1710,1714,1734,1682,1690,1694,1730,1502,1450,1644,1650,1702,1656,
			1661,1619,1403,1494,1441,1459,1745,1742,959,1468,1477,1357,0,0,0,0,
			0,0,0,0,1086,1166,1054,1038,1070,1262,1118,775,803,679,347,427,
			831,463,1246,1278,1198,1326,1182,1214,1230,1310,1102,1134,1150,1294,743,535,
			911,935,1182,980,1000,859,387,711,499,571,1381,1369,96,607,643,255,
			92,92,92,92,92,1754,0,1756,1760,1758,1760,0,887,0,1638,1502,
			1450,1644,1650,1702,1656,1661,1619,1403,1494,1441,1459,743,535,911,935,1182,
			980,1000,859,387,711,499,571,1718,1726,1706,1738,1702,1710,1714,1734,1682,
			1690,1694,1730,1246,1278,1198,1326,1182,1214,1230,1310,1102,1134,1150,1294
@@pp_endif@@
		};
		if (idx == 0xffff) {
			result = "LC_TIME";
			break;
		}
		if (idx == 102) { /* _NL_TIME_WEEK_1STDAY */
			result = (char const *)(uintptr_t)UINTPTR_C(19971130);
			break;
		}
		if likely(idx < 159) {
			uint16_t offset = offtab_LC_TIME[idx];
			result = (char const *)(byteblob + offset);
		}
	}	break;

	case __LC_PAPER: {
		static int16_t const offtab_LC_PAPER[3] = {
			~297,~210,1638
		};
		if (idx == 0xffff) {
			result = "LC_PAPER";
			break;
		}
		if likely(idx < 3) {
			int16_t offset = offtab_LC_PAPER[idx];
			if (offset < 0) {
				result = (char const *)(uintptr_t)~offset;
				break;
			}
			result = (char const *)(byteblob + offset);
		}
	}	break;

	case __LC_IDENTIFICATION: {
		static uint16_t const offtab_LC_IDENTIFICATION[16] = {
@@pp_if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__@@
			1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1638
@@pp_else@@
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1638
@@pp_endif@@
		};
		if (idx == 0xffff) {
			result = "LC_IDENTIFICATION";
			break;
		}
		if likely(idx < 16) {
			uint16_t offset = offtab_LC_IDENTIFICATION[idx];
			result = (char const *)(byteblob + offset);
		}
	}	break;

	case __LC_NUMERIC: {
		static int16_t const offtab_LC_NUMERIC[6] = {
@@pp_if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__@@
			1750,1,1,~46,~0,1638
@@pp_else@@
			1750,0,0,~46,~0,1638
@@pp_endif@@
		};
		if (idx == 0xffff) {
			result = "LC_NUMERIC";
			break;
		}
		if likely(idx < 6) {
			int16_t offset = offtab_LC_NUMERIC[idx];
			if (offset < 0) {
				result = (char const *)(uintptr_t)~offset;
				break;
			}
			result = (char const *)(byteblob + offset);
		}
	}	break;

	case __LC_MESSAGES: {
		static uint16_t const offtab_LC_MESSAGES[5] = {
@@pp_if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__@@
			1626,1632,1,1,1638
@@pp_else@@
			1626,1632,0,0,1638
@@pp_endif@@
		};
		if (idx == 0xffff) {
			result = "LC_MESSAGES";
			break;
		}
		if likely(idx < 5) {
			uint16_t offset = offtab_LC_MESSAGES[idx];
			result = (char const *)(byteblob + offset);
		}
	}	break;

	case __LC_ADDRESS: {
		static int16_t const offtab_LC_ADDRESS[13] = {
@@pp_if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__@@
			303,1,1,1,1,1,~0,1,1,1,1,1,1638
@@pp_else@@
			303,0,0,0,0,0,~0,0,0,0,0,0,1638
@@pp_endif@@
		};
		if (idx == 0xffff) {
			result = "LC_ADDRESS";
			break;
		}
		if likely(idx < 13) {
			int16_t offset = offtab_LC_ADDRESS[idx];
			if (offset < 0) {
				result = (char const *)(uintptr_t)~offset;
				break;
			}
			result = (char const *)(byteblob + offset);
		}
	}	break;

	case __LC_COLLATE: {
		static int16_t const offtab_LC_COLLATE[19] = {
@@pp_if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__@@
			~0,1,89,89,89,89,89,89,89,89,89,89,89,~0,89,89,
			89,89,1638
@@pp_else@@
			~0,0,92,92,92,92,92,92,92,92,92,92,92,~0,92,92,
			92,92,1638
@@pp_endif@@
		};
		if (idx == 0xffff) {
			result = "LC_COLLATE";
			break;
		}
		if likely(idx < 19) {
			int16_t offset = offtab_LC_COLLATE[idx];
			if (offset < 0) {
				result = (char const *)(uintptr_t)~offset;
				break;
			}
			result = (char const *)(byteblob + offset);
		}
	}	break;

	case __LC_CTYPE: {
		static int16_t const offtab_LC_CTYPE[86] = {
@@pp_if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__@@
			89,89,1,89,1,89,1,1,1,1,180,1020,1754,~1,1638,89,
			89,~72,~84,~1,1590,1582,1574,1566,1558,1550,1542,1534,1526,1518,~1,1590,
			1582,1574,1566,1558,1550,1542,1534,1526,1518,1590,1582,1574,1566,1558,1550,1542,
			1534,1526,1518,~48,~49,~50,~51,~52,~53,~54,~55,~56,~57,~0,89,89,
			89,89,~1,1510,~0,1,~0,~0,89,89,89,89,89,89,89,89,
			89,89,89,89,89,89
@@pp_else@@
			92,92,0,92,0,92,0,0,0,0,180,1020,1754,~1,1638,92,
			92,~72,~84,~1,1593,1585,1577,1569,1561,1553,1545,1537,1529,1521,~1,1590,
			1582,1574,1566,1558,1550,1542,1534,1526,1518,1593,1585,1577,1569,1561,1553,1545,
			1537,1529,1521,~48,~49,~50,~51,~52,~53,~54,~55,~56,~57,~0,92,92,
			92,92,~1,1510,~0,0,~0,~0,92,92,92,92,92,92,92,92,
			92,92,92,92,92,92
@@pp_endif@@
		};
		if (idx == 0xffff) {
			result = "LC_CTYPE";
			break;
		}
		if likely(idx < 86) {
			int16_t offset = offtab_LC_CTYPE[idx];
			if (offset < 0) {
				result = (char const *)(uintptr_t)~offset;
				break;
			}
			result = (char const *)(byteblob + offset);
		}
	}	break;

	case __LC_TELEPHONE: {
		static uint16_t const offtab_LC_TELEPHONE[5] = {
@@pp_if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__@@
			1413,1,1,1,1638
@@pp_else@@
			1413,0,0,0,1638
@@pp_endif@@
		};
		if (idx == 0xffff) {
			result = "LC_TELEPHONE";
			break;
		}
		if likely(idx < 5) {
			uint16_t offset = offtab_LC_TELEPHONE[idx];
			result = (char const *)(byteblob + offset);
		}
	}	break;

	default:
		break;
	}
/*[[[end]]]*/
	COMPILER_IMPURE(); /* Prevent warning: `-Wsuggest-attribute=pure' */
	return (char *)result;
}


%
%#ifdef __USE_XOPEN2K
[[doc_alias("nl_langinfo"), export_alias("__nl_langinfo_l")]]
[[nonnull, requires_function(nl_langinfo), decl_include("<features.h>")]]
char __KOS_FIXED_CONST *nl_langinfo_l(__STDC_INT_AS_UINT_T item, $locale_t locale) {
	(void)locale;
	return nl_langinfo(item);
}
%#endif /* __USE_XOPEN2K */



%{

__SYSDECL_END
}
%#endif /* __CC__ */
%{

}
