/* HASH CRC-32:0xfcce0a2d */
/* Copyright (c) 2019-2024 Griefer@Work                                       *
 *                                                                            *
 * This software is provided 'as-is', without any express or implied          *
 * warranty. In no event will the authors be held liable for any damages      *
 * arising from the use of this software.                                     *
 *                                                                            *
 * Permission is granted to anyone to use this software for any purpose,      *
 * including commercial applications, and to alter it and redistribute it     *
 * freely, subject to the following restrictions:                             *
 *                                                                            *
 * 1. The origin of this software must not be misrepresented; you must not    *
 *    claim that you wrote the original software. If you use this software    *
 *    in a product, an acknowledgement (see the following) in the product     *
 *    documentation is required:                                              *
 *    Portions Copyright (c) 2019-2024 Griefer@Work                           *
 * 2. Altered source versions must be plainly marked as such, and must not be *
 *    misrepresented as being the original software.                          *
 * 3. This notice may not be removed or altered from any source distribution. *
 */
#ifndef GUARD_LIBC_AUTO_COMPLEX_C
#define GUARD_LIBC_AUTO_COMPLEX_C 1

#include "../api.h"
#include <hybrid/typecore.h>
#include <kos/types.h>
#include "complex.h"
#include "../user/math.h"

DECL_BEGIN

#ifndef __KERNEL__
/* calculate cosh and sinh */
INTERN ATTR_SECTION(".text.crt.math.complex") ATTR_OUT(2) ATTR_OUT(3) void
NOTHROW_NCX(LIBCCALL libc__cchshf)(float x,
                                   float *c,
                                   float *s) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	float e, ei;
	if (libc_fabsf(x) <= 0.5f) {
		*c = libc_coshf(x);
		*s = libc_sinhf(x);
	} else {
		e = libc_expf(x);
		ei = 0.5f / e;
		e = 0.5f * e;
		*s = e - ei;
		*c = e + ei;
	}



}
#include <hybrid/typecore.h>
#ifdef __ARCH_LONG_DOUBLE_IS_DOUBLE
DEFINE_INTERN_ALIAS_P_VOID(libc__cchshl,libc__cchsh,ATTR_OUT(2) ATTR_OUT(3),NOTHROW_NCX,LIBCCALL,(__LONGDOUBLE x, __LONGDOUBLE *c, __LONGDOUBLE *s),(x,c,s));
#else /* __ARCH_LONG_DOUBLE_IS_DOUBLE */
/* calculate cosh and sinh */
INTERN ATTR_SECTION(".text.crt.math.complex") ATTR_OUT(2) ATTR_OUT(3) void
NOTHROW_NCX(LIBCCALL libc__cchshl)(__LONGDOUBLE x,
                                   __LONGDOUBLE *c,
                                   __LONGDOUBLE *s) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	__LONGDOUBLE e, ei;
	if (libc_fabsl(x) <= 0.5L) {
		*c = libc_coshl(x);
		*s = libc_sinhl(x);
	} else {
		e = libc_expl(x);
		ei = 0.5L / e;
		e = 0.5L * e;
		*s = e - ei;
		*c = e + ei;
	}



}
#endif /* !__ARCH_LONG_DOUBLE_IS_DOUBLE */
/* calculate cosh and sinh */
INTERN ATTR_SECTION(".text.crt.math.complex") ATTR_OUT(2) ATTR_OUT(3) void
NOTHROW_NCX(LIBCCALL libc__cchsh)(double x,
                                  double *c,
                                  double *s) {
	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	double e, ei;
	if (libc_fabs(x) <= 0.5) {
		*c = libc_cosh(x);
		*s = libc_sinh(x);
	} else {
		e = libc_exp(x);
		ei = 0.5 / e;
		e = 0.5 * e;
		*s = e - ei;
		*c = e + ei;
	}
}
INTERN ATTR_SECTION(".text.crt.math.complex") ATTR_CONST WUNUSED float
NOTHROW(LIBCCALL libc__redupif)(float x) {
	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	float t;




	long i;
	t = x / (float)3.14159265358979323846f /*M_PI*/;

	if (t >= 0.0f) {
		t += 0.5f;
	} else {
		t -= 0.5f;
	}
	i = t; /* the multiple */
	t = i;










	t = ((x - t * 3.140625f) -
	     t * 9.67502593994140625E-4f) -
	    t * 1.509957990978376432E-7f;





	return t;
}
#include <hybrid/typecore.h>
#ifdef __ARCH_LONG_DOUBLE_IS_DOUBLE
DEFINE_INTERN_ALIAS_P(libc__redupil,libc__redupi,ATTR_CONST WUNUSED,__LONGDOUBLE,NOTHROW,LIBCCALL,(__LONGDOUBLE x),(x));
#else /* __ARCH_LONG_DOUBLE_IS_DOUBLE */
INTERN ATTR_SECTION(".text.crt.math.complex") ATTR_CONST WUNUSED __LONGDOUBLE
NOTHROW(LIBCCALL libc__redupil)(__LONGDOUBLE x) {
	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	__LONGDOUBLE t;

	__LONGLONG i;
	t = x / (__LONGDOUBLE)3.141592653589793238462643383279502884L /*M_PIl*/;




	if (t >= 0.0L) {
		t += 0.5L;
	} else {
		t -= 0.5L;
	}
	i = t; /* the multiple */
	t = i;

	t = ((x - t * 3.14159265358979323829596852490908531763125L) -
	     t * 1.6667485837041756656403424829301998703007e-19L) -
#ifndef __vax__
	    t * 1.8830410776607851167459095484560349402753e-39L
#else /* !__vax__ */
	    t * 0L
#endif /* __vax__ */
	    ;









	return t;
}
#endif /* !__ARCH_LONG_DOUBLE_IS_DOUBLE */
INTERN ATTR_SECTION(".text.crt.math.complex") ATTR_CONST WUNUSED double
NOTHROW(LIBCCALL libc__redupi)(double x) {
	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	double t;




	long i;
	t = x / (double)3.14159265358979323846 /*M_PI*/;

	if (t >= 0.0) {
		t += 0.5;
	} else {
		t -= 0.5;
	}
	i = t; /* the multiple */
	t = i;














	t = ((x - t * 3.14159265160560607910E0) -
	     t * 1.98418714791870343106E-9) -
	    t * 1.14423774522196636802E-17;

	return t;
}
/* Taylor series expansion for cosh(2y) - cos(2x) */
INTERN ATTR_SECTION(".text.crt.math.complex") ATTR_CONST WUNUSED float
NOTHROW(LIBCCALL libc__ctansf)(float _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	float f, x, x2, y, y2, rn, t, d;
	x  = libc_fabsf(2.0f * libc_crealf(z));
	y  = libc_fabsf(2.0f * libc_cimagf(z));
	x  = libc__redupif(x);
	x  = x * x;
	y  = y * y;
	x2 = 1.0f;
	y2 = 1.0f;
	f  = 1.0f;
	rn = 0.0f;
	d  = 0.0f;
	do {
		rn += 1.0f;
		f *= rn;
		rn += 1.0f;
		f *= rn;
		x2 *= x;
		y2 *= y;
		t = y2 + x2;
		t /= f;
		d += t;
		rn += 1.0f;
		f *= rn;
		rn += 1.0f;
		f *= rn;
		x2 *= x;
		y2 *= y;
		t = y2 - x2;
		t /= f;
		d += t;
	}







	while (libc_fabsf(t/d) > 3.0e-8f);



	return d;



}
#include <hybrid/typecore.h>
#ifdef __ARCH_LONG_DOUBLE_IS_DOUBLE
DEFINE_INTERN_ALIAS_P(libc__ctansl,libc__ctans,ATTR_CONST WUNUSED,__LONGDOUBLE,NOTHROW,LIBCCALL,(long double _Complex z),(z));
#else /* __ARCH_LONG_DOUBLE_IS_DOUBLE */
/* Taylor series expansion for cosh(2y) - cos(2x) */
INTERN ATTR_SECTION(".text.crt.math.complex") ATTR_CONST WUNUSED __LONGDOUBLE
NOTHROW(LIBCCALL libc__ctansl)(long double _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	__LONGDOUBLE f, x, x2, y, y2, rn, t, d;
	x  = libc_fabsl(2.0L * libc_creall(z));
	y  = libc_fabsl(2.0L * libc_cimagl(z));
	x  = libc__redupil(x);
	x  = x * x;
	y  = y * y;
	x2 = 1.0L;
	y2 = 1.0L;
	f  = 1.0L;
	rn = 0.0L;
	d  = 0.0L;
	do {
		rn += 1.0L;
		f *= rn;
		rn += 1.0L;
		f *= rn;
		x2 *= x;
		y2 *= y;
		t = y2 + x2;
		t /= f;
		d += t;
		rn += 1.0L;
		f *= rn;
		rn += 1.0L;
		f *= rn;
		x2 *= x;
		y2 *= y;
		t = y2 - x2;
		t /= f;
		d += t;
	}

#ifndef __vax__
	while (libc_fabsl(t/d) > 1.1e-38L);
#else /* !__vax__ */
	while (libc_fabsl(t/d) > 1.1e-19L);
#endif /* __vax__ */





	return d;



}
#endif /* !__ARCH_LONG_DOUBLE_IS_DOUBLE */
/* Taylor series expansion for cosh(2y) - cos(2x) */
INTERN ATTR_SECTION(".text.crt.math.complex") ATTR_CONST WUNUSED double
NOTHROW(LIBCCALL libc__ctans)(double _Complex z) {
	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	double f, x, x2, y, y2, rn, t, d;
	x  = libc_fabs(2.0 * libc_creal(z));
	y  = libc_fabs(2.0 * libc_cimag(z));
	x  = libc__redupi(x);
	x  = x * x;
	y  = y * y;
	x2 = 1.0;
	y2 = 1.0;
	f  = 1.0;
	rn = 0.0;
	d  = 0.0;
	do {
		rn += 1.0;
		f *= rn;
		rn += 1.0;
		f *= rn;
		x2 *= x;
		y2 *= y;
		t = y2 + x2;
		t /= f;
		d += t;
		rn += 1.0;
		f *= rn;
		rn += 1.0;
		f *= rn;
		x2 *= x;
		y2 *= y;
		t = y2 - x2;
		t /= f;
		d += t;
	}









	while (libc_fabs(t/d) > 1.1e-16);

	return d;
}
INTERN ATTR_SECTION(".text.crt.math.complex") float
NOTHROW_NCX(LIBCCALL libc_cabsf)(float _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	return libc_hypotf(libc_crealf(z), libc_cimagf(z));



}
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED float _Complex
NOTHROW_NCX(LIBCCALL libc_cexpf)(float _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	float _Complex w;
	float r, x, y;
	float siny, cosy;
	x = libc_crealf(z);
	y = libc_cimagf(z);
	r = libc_expf(x);
	libc_sincosf(y, &siny, &cosy);
	w = CMPLXF(r * cosy, r * siny);
	return w;



}
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED float _Complex
NOTHROW_NCX(LIBCCALL libc_clogf)(float _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	float _Complex w;
	float p, rr;
	rr = libc_cabsf(z);
	p = libc_logf(rr);
	rr = libc_atan2f(libc_cimagf(z), libc_crealf(z));
	w = CMPLXF(p, rr);
	return w;



}
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED float _Complex
NOTHROW_NCX(LIBCCALL libc_cpowf)(float _Complex a,
                                 float _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	float _Complex w;
	float x, y, r, theta, absa, arga;
	float sin_theta, cos_theta;
	x    = libc_crealf(z);
	y    = libc_cimagf(z);
	absa = libc_cabsf(a);
	if (absa == 0.0f)
		return CMPLXF(0.0f, 0.0f);
	arga  = libc_cargf(a);
	r     = libc_powf(absa, x);
	theta = x * arga;
	if (y != 0.0f) {
		r     = r * libc_expf(-y * arga);
		theta = theta + y * libc_logf(absa);
	}
	libc_sincosf(theta, &sin_theta, &cos_theta);
	w = CMPLXF(r * cos_theta, r * sin_theta);
	return w;



}
#include <hybrid/floatcore.h>
#include <bits/math-constants.h>
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED float _Complex
NOTHROW_NCX(LIBCCALL libc_csqrtf)(float _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */

























































	float _Complex w;
	float x, y, r, t, scale;
	x = libc_crealf(z);
	y = libc_cimagf(z);
	/* input is a real number and imaginary part isn't -0.0.
	 * negative zero is on the branch cut. */
	if ((y == 0.0f) && !libc___signbitf(y)) {
		if (x == 0.0f) {
			w = CMPLXF(0.0f, y);
		} else {
			if (x < 0.0f) {
				r = libc_sqrtf(-x);
				w = CMPLXF(0.0f, r);
			} else {
				r = libc_sqrtf(x);
				w = r;
			}
		}
		return w;
	}
	if (x == 0.0f) {
		if (y > 0) {
			r = libc_sqrtf(0.5f * y);
			w = CMPLXF(r, r);
		} else {
			r = libc_sqrtf(-0.5f * y);
			w = CMPLXF(r, -r);
		}
		return w;
	}
	/* Rescale to avoid internal overflow or underflow.  */
	if ((libc_fabsf(x) > 4.0f) || (libc_fabsf(y) > 4.0f)) {
		x *= 0.25f;
		y *= 0.25f;
		scale = 2.0f;
	} else {

		x *= 6.7108864e7f; /* 2^26 */
		y *= 6.7108864e7f;
		scale = 1.220703125e-4f; /* 2^-13 */









	}
	w = CMPLXF(x, y);
	r = libc_cabsf(w);
	if (x > 0) {
		t = libc_sqrtf(0.5f * r + 0.5f * x);
		r = scale * libc_fabsf((0.5f * y) / t );
		t *= scale;
	} else {
		r = libc_sqrtf(0.5f * r - 0.5f * x);
		t = scale * libc_fabsf((0.5f * y) / r);
		r *= scale;
	}
	if (y > 0) {
		w = CMPLXF(t, r);
	} else {
		w = CMPLXF(t, -r);
	}
	return w;




}
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED float _Complex
NOTHROW_NCX(LIBCCALL libc_csinf)(float _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	float _Complex w;
	float ch, sh;
	float sin_creal_z, cos_creal_z;
	libc__cchshf(libc_cimagf(z), &ch, &sh);
	libc_sincosf(libc_crealf(z), &sin_creal_z, &cos_creal_z);
	w = CMPLXF(sin_creal_z * ch, cos_creal_z * sh);
	return w;



}
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED float _Complex
NOTHROW_NCX(LIBCCALL libc_ccosf)(float _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	float _Complex w;
	float ch, sh;
	float sin_creal_z, cos_creal_z;
	libc__cchshf(libc_cimagf(z), &ch, &sh);
	libc_sincosf(libc_crealf(z), &sin_creal_z, &cos_creal_z);
	w = CMPLXF(cos_creal_z * ch, -(sin_creal_z * sh));
	return w;



}
#include <bits/crt/complex.h>
#include <hybrid/floatcore.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED float _Complex
NOTHROW_NCX(LIBCCALL libc_ctanf)(float _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	float _Complex w;
	float d;
	float sin_2_0_creal_z, cos_2_0_creal_z;
	libc_sincosf(2.0f * libc_crealf(z), &sin_2_0_creal_z, &cos_2_0_creal_z);
	d = cos_2_0_creal_z + libc_coshf(2.0f * libc_cimagf(z));
	if (libc_fabsf(d) < 0.25f)
		d = libc__ctansf(z);
	if (d == 0.0f) {
		/* mtherr("ctan", OVERFLOW); */
		w = CMPLXF(__FLT_MAX__, __FLT_MAX__);
		return w;
	}
	w = CMPLXF(sin_2_0_creal_z / d, libc_sinhf(2.0f * libc_cimagf(z)) / d);
	return w;



}
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED float _Complex
NOTHROW_NCX(LIBCCALL libc_casinf)(float _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	float _Complex w;
	float _Complex ca, ct, zz, z2;
	float x, y;
	x  = libc_crealf(z);
	y  = libc_cimagf(z);
	ca = CMPLXF(x, y);
	ct = CMPLXF(0.0f, ca);
	/* sqrt( 1 - z*z) */
	/* cmul( &ca, &ca, &zz ) */
	/*x * x  -  y * y */
	zz = CMPLXF((x - y) * (x + y), (2.0f * x * y));
	zz = CMPLXF(1.0f - libc_crealf(zz), -libc_cimagf(zz));
	z2 = libc_csqrtf(zz);
	zz = ct + z2;
	zz = libc_clogf(zz);
	/* multiply by 1/i = -i */
	w = zz * CMPLXF(0.0f, -1.0f);
	return w;



}
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED float _Complex
NOTHROW_NCX(LIBCCALL libc_cacosf)(float _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	float _Complex w;
	w = libc_casinf(z);



	w = CMPLXF(((float)1.57079632679489661923f /* M_PI_2 */ - libc_crealf(w)), -libc_cimagf(w));

	return w;



}
#include <bits/crt/complex.h>
#include <hybrid/floatcore.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED float _Complex
NOTHROW_NCX(LIBCCALL libc_catanf)(float _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	float _Complex w;
	float a, t, x, x2, y;
	x = libc_crealf(z);
	y = libc_cimagf(z);
	if ((x == 0.0f) && (y > 1.0f))
		goto ovrf;
	x2 = x * x;
	a = 1.0f - x2 - (y * y);
	if (a == 0.0f)
		goto ovrf;
	t = 0.5f * libc_atan2f(2.0f * x, a);
	w = libc__redupif(t);
	t = y - 1.0f;
	a = x2 + (t * t);
	if (a == 0.0f)
		goto ovrf;
	t = y + 1.0f;
	a = (x2 + (t * t))/a;
	w = CMPLXF(w, (0.25f * libc_logf(a)));
	return w;
ovrf:
	/* matherr("catan", OVERFLOW); */
	w = CMPLXF(__FLT_MAX__, __FLT_MAX__);
	return w;



}
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED float _Complex
NOTHROW_NCX(LIBCCALL libc_csinhf)(float _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	float _Complex w;
	float x, y;
	float sin_y, cos_y;
	x = libc_crealf(z);
	y = libc_cimagf(z);
	libc_sincosf(y, &sin_y, &cos_y);
	w = CMPLXF(libc_sinhf(x) * cos_y, libc_coshf(x) * sin_y);
	return w;



}
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED float _Complex
NOTHROW_NCX(LIBCCALL libc_ccoshf)(float _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	float _Complex w;
	float x, y;
	float sin_y, cos_y;
	x = libc_crealf(z);
	y = libc_cimagf(z);
	libc_sincosf(y, &sin_y, &cos_y);
	w = CMPLXF(libc_coshf(x) * cos_y, libc_sinhf(x) * sin_y);
	return w;



}
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED float _Complex
NOTHROW_NCX(LIBCCALL libc_ctanhf)(float _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	float _Complex w;
	float x, y, d;
	float sin_2_0_y, cos_2_0_y;
	x = libc_crealf(z);
	y = libc_cimagf(z);
	libc_sincosf(2.0f * y, &sin_2_0_y, &cos_2_0_y);
	d = libc_coshf(2.0f * x) + cos_2_0_y;
	w = CMPLXF(libc_sinhf(2.0f * x) / d, sin_2_0_y / d);
	return w;



}
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED float _Complex
NOTHROW_NCX(LIBCCALL libc_casinhf)(float _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	float _Complex w;
	w = -1.0f * _Complex_I * libc_casinf(z * _Complex_I);
	return w;



}
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED float _Complex
NOTHROW_NCX(LIBCCALL libc_cacoshf)(float _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	float _Complex w;
	w = libc_clogf(z + libc_csqrtf(z + 1) * libc_csqrtf(z - 1));
	return w;



}
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED float _Complex
NOTHROW_NCX(LIBCCALL libc_catanhf)(float _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	float _Complex w;
	w = -1.0f * _Complex_I * libc_catanf(z * _Complex_I);
	return w;



}
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED float
NOTHROW_NCX(LIBCCALL libc_cargf)(float _Complex z) {

	return libc_atan2f(libc_cimagf(z), libc_crealf(z));



}
INTERN ATTR_SECTION(".text.crt.math.complex") ATTR_CONST WUNUSED float _Complex
NOTHROW(LIBCCALL libc_conjf)(float _Complex z) {
	union {
		float _Complex x;
		float parts[2];
	} v;
	v.x = z;
	v.parts[1] = -v.parts[1];
	return v.x;
}
INTERN ATTR_SECTION(".text.crt.math.complex") ATTR_CONST WUNUSED float
NOTHROW(LIBCCALL libc_crealf)(float _Complex z) {
	union {
		float _Complex x;
		float parts[2];
	} v;
	v.x = z;
	return v.parts[0];
}
INTERN ATTR_SECTION(".text.crt.math.complex") ATTR_CONST WUNUSED float
NOTHROW(LIBCCALL libc_cimagf)(float _Complex z) {
	union {
		float _Complex x;
		float parts[2];
	} v;
	v.x = z;
	return v.parts[1];
}
#include <bits/math-constants.h>
INTERN ATTR_SECTION(".text.crt.math.complex") ATTR_CONST WUNUSED float _Complex
NOTHROW(LIBCCALL libc_cprojf)(float _Complex z) {

	union {
		float _Complex x;
		float parts[2];
	} v;
	v.x = z;
	if (libc_isinff(libc_crealf(z)) || libc_isinff(libc_cimagf(z))) {
		v.parts[0] = __HUGE_VALF;              /* Real-part */
		v.parts[1] = libc_copysignf(0.0f, libc_cimagf(z)); /* Imag-part */
	}
	return v.x;



}
INTERN ATTR_SECTION(".text.crt.math.complex") double
NOTHROW_NCX(LIBCCALL libc_cabs)(double _Complex z) {
	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	return libc_hypot(libc_creal(z), libc_cimag(z));
}
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED double _Complex
NOTHROW_NCX(LIBCCALL libc_cexp)(double _Complex z) {
	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	double _Complex w;
	double r, x, y;
	double siny, cosy;
	x = libc_creal(z);
	y = libc_cimag(z);
	r = libc_exp(x);
	libc_sincos(y, &siny, &cosy);
	w = CMPLX(r * cosy, r * siny);
	return w;
}
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED double _Complex
NOTHROW_NCX(LIBCCALL libc_clog)(double _Complex z) {
	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	double _Complex w;
	double p, rr;
	rr = libc_cabs(z);
	p = libc_log(rr);
	rr = libc_atan2(libc_cimag(z), libc_creal(z));
	w = CMPLX(p, rr);
	return w;
}
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED double _Complex
NOTHROW_NCX(LIBCCALL libc_cpow)(double _Complex a,
                                double _Complex z) {
	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	double _Complex w;
	double x, y, r, theta, absa, arga;
	double sin_theta, cos_theta;
	x    = libc_creal(z);
	y    = libc_cimag(z);
	absa = libc_cabs(a);
	if (absa == 0.0)
		return CMPLX(0.0, 0.0);
	arga  = libc_carg(a);
	r     = libc_pow(absa, x);
	theta = x * arga;
	if (y != 0.0) {
		r     = r * libc_exp(-y * arga);
		theta = theta + y * libc_log(absa);
	}
	libc_sincos(theta, &sin_theta, &cos_theta);
	w = CMPLX(r * cos_theta, r * sin_theta);
	return w;
}
#include <hybrid/floatcore.h>
#include <bits/math-constants.h>
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED double _Complex
NOTHROW_NCX(LIBCCALL libc_csqrt)(double _Complex z) {
	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */

























































	double _Complex w;
	double x, y, r, t, scale;
	x = libc_creal(z);
	y = libc_cimag(z);
	/* input is a real number and imaginary part isn't -0.0.
	 * negative zero is on the branch cut. */
	if ((y == 0.0) && !libc___signbit(y)) {
		if (x == 0.0) {
			w = CMPLX(0.0, y);
		} else {
			if (x < 0.0) {
				r = libc_sqrt(-x);
				w = CMPLX(0.0, r);
			} else {
				r = libc_sqrt(x);
				w = r;
			}
		}
		return w;
	}
	if (x == 0.0) {
		if (y > 0) {
			r = libc_sqrt(0.5 * y);
			w = CMPLX(r, r);
		} else {
			r = libc_sqrt(-0.5 * y);
			w = CMPLX(r, -r);
		}
		return w;
	}
	/* Rescale to avoid internal overflow or underflow.  */
	if ((libc_fabs(x) > 4.0) || (libc_fabs(y) > 4.0)) {
		x *= 0.25;
		y *= 0.25;
		scale = 2.0;
	} else {





		x *= 1.8014398509481984e16;  /* 2^54 */
		y *= 1.8014398509481984e16;
		scale = 7.450580596923828125e-9; /* 2^-27 */





	}
	w = CMPLX(x, y);
	r = libc_cabs(w);
	if (x > 0) {
		t = libc_sqrt(0.5 * r + 0.5 * x);
		r = scale * libc_fabs((0.5 * y) / t );
		t *= scale;
	} else {
		r = libc_sqrt(0.5 * r - 0.5 * x);
		t = scale * libc_fabs((0.5 * y) / r);
		r *= scale;
	}
	if (y > 0) {
		w = CMPLX(t, r);
	} else {
		w = CMPLX(t, -r);
	}
	return w;

}
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED double _Complex
NOTHROW_NCX(LIBCCALL libc_csin)(double _Complex z) {
	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	double _Complex w;
	double ch, sh;
	double sin_creal_z, cos_creal_z;
	libc__cchsh(libc_cimag(z), &ch, &sh);
	libc_sincos(libc_creal(z), &sin_creal_z, &cos_creal_z);
	w = CMPLX(sin_creal_z * ch, cos_creal_z * sh);
	return w;
}
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED double _Complex
NOTHROW_NCX(LIBCCALL libc_ccos)(double _Complex z) {
	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	double _Complex w;
	double ch, sh;
	double sin_creal_z, cos_creal_z;
	libc__cchsh(libc_cimag(z), &ch, &sh);
	libc_sincos(libc_creal(z), &sin_creal_z, &cos_creal_z);
	w = CMPLX(cos_creal_z * ch, -(sin_creal_z * sh));
	return w;
}
#include <bits/crt/complex.h>
#include <hybrid/floatcore.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED double _Complex
NOTHROW_NCX(LIBCCALL libc_ctan)(double _Complex z) {
	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	double _Complex w;
	double d;
	double sin_2_0_creal_z, cos_2_0_creal_z;
	libc_sincos(2.0 * libc_creal(z), &sin_2_0_creal_z, &cos_2_0_creal_z);
	d = cos_2_0_creal_z + libc_cosh(2.0 * libc_cimag(z));
	if (libc_fabs(d) < 0.25)
		d = libc__ctans(z);
	if (d == 0.0) {
		/* mtherr("ctan", OVERFLOW); */
		w = CMPLX(__DBL_MAX__, __DBL_MAX__);
		return w;
	}
	w = CMPLX(sin_2_0_creal_z / d, libc_sinh(2.0 * libc_cimag(z)) / d);
	return w;
}
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED double _Complex
NOTHROW_NCX(LIBCCALL libc_casin)(double _Complex z) {
	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	double _Complex w;
	double _Complex ca, ct, zz, z2;
	double x, y;
	x  = libc_creal(z);
	y  = libc_cimag(z);
	ca = CMPLX(x, y);
	ct = CMPLX(0.0, ca);
	/* sqrt( 1 - z*z) */
	/* cmul( &ca, &ca, &zz ) */
	/*x * x  -  y * y */
	zz = CMPLX((x - y) * (x + y), (2.0 * x * y));
	zz = CMPLX(1.0 - libc_creal(zz), -libc_cimag(zz));
	z2 = libc_csqrt(zz);
	zz = ct + z2;
	zz = libc_clog(zz);
	/* multiply by 1/i = -i */
	w = zz * CMPLX(0.0, -1.0);
	return w;
}
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED double _Complex
NOTHROW_NCX(LIBCCALL libc_cacos)(double _Complex z) {
	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	double _Complex w;
	w = libc_casin(z);



	w = CMPLX(((double)1.57079632679489661923 /* M_PI_2 */ - libc_creal(w)), -libc_cimag(w));

	return w;
}
#include <bits/crt/complex.h>
#include <hybrid/floatcore.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED double _Complex
NOTHROW_NCX(LIBCCALL libc_catan)(double _Complex z) {
	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	double _Complex w;
	double a, t, x, x2, y;
	x = libc_creal(z);
	y = libc_cimag(z);
	if ((x == 0.0) && (y > 1.0))
		goto ovrf;
	x2 = x * x;
	a = 1.0 - x2 - (y * y);
	if (a == 0.0)
		goto ovrf;
	t = 0.5 * libc_atan2(2.0 * x, a);
	w = libc__redupi(t);
	t = y - 1.0;
	a = x2 + (t * t);
	if (a == 0.0)
		goto ovrf;
	t = y + 1.0;
	a = (x2 + (t * t))/a;
	w = CMPLX(w, (0.25 * libc_log(a)));
	return w;
ovrf:
	/* matherr("catan", OVERFLOW); */
	w = CMPLX(__DBL_MAX__, __DBL_MAX__);
	return w;
}
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED double _Complex
NOTHROW_NCX(LIBCCALL libc_csinh)(double _Complex z) {
	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	double _Complex w;
	double x, y;
	double sin_y, cos_y;
	x = libc_creal(z);
	y = libc_cimag(z);
	libc_sincos(y, &sin_y, &cos_y);
	w = CMPLX(libc_sinh(x) * cos_y, libc_cosh(x) * sin_y);
	return w;
}
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED double _Complex
NOTHROW_NCX(LIBCCALL libc_ccosh)(double _Complex z) {
	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	double _Complex w;
	double x, y;
	double sin_y, cos_y;
	x = libc_creal(z);
	y = libc_cimag(z);
	libc_sincos(y, &sin_y, &cos_y);
	w = CMPLX(libc_cosh(x) * cos_y, libc_sinh(x) * sin_y);
	return w;
}
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED double _Complex
NOTHROW_NCX(LIBCCALL libc_ctanh)(double _Complex z) {
	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	double _Complex w;
	double x, y, d;
	double sin_2_0_y, cos_2_0_y;
	x = libc_creal(z);
	y = libc_cimag(z);
	libc_sincos(2.0 * y, &sin_2_0_y, &cos_2_0_y);
	d = libc_cosh(2.0 * x) + cos_2_0_y;
	w = CMPLX(libc_sinh(2.0 * x) / d, sin_2_0_y / d);
	return w;
}
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED double _Complex
NOTHROW_NCX(LIBCCALL libc_casinh)(double _Complex z) {
	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	double _Complex w;
	w = -1.0 * _Complex_I * libc_casin(z * _Complex_I);
	return w;
}
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED double _Complex
NOTHROW_NCX(LIBCCALL libc_cacosh)(double _Complex z) {
	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	double _Complex w;
	w = libc_clog(z + libc_csqrt(z + 1) * libc_csqrt(z - 1));
	return w;
}
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED double _Complex
NOTHROW_NCX(LIBCCALL libc_catanh)(double _Complex z) {
	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	double _Complex w;
	w = -1.0 * _Complex_I * libc_catan(z * _Complex_I);
	return w;
}
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED double
NOTHROW_NCX(LIBCCALL libc_carg)(double _Complex z) {
	return libc_atan2(libc_cimag(z), libc_creal(z));
}
INTERN ATTR_SECTION(".text.crt.math.complex") ATTR_CONST WUNUSED double _Complex
NOTHROW(LIBCCALL libc_conj)(double _Complex z) {
	union {
		double _Complex x;
		double parts[2];
	} v;
	v.x = z;
	v.parts[1] = -v.parts[1];
	return v.x;
}
INTERN ATTR_SECTION(".text.crt.math.complex") ATTR_CONST WUNUSED double
NOTHROW(LIBCCALL libc_creal)(double _Complex z) {
	union {
		double _Complex x;
		double parts[2];
	} v;
	v.x = z;
	return v.parts[0];
}
INTERN ATTR_SECTION(".text.crt.math.complex") ATTR_CONST WUNUSED double
NOTHROW(LIBCCALL libc_cimag)(double _Complex z) {
	union {
		double _Complex x;
		double parts[2];
	} v;
	v.x = z;
	return v.parts[1];
}
#include <bits/math-constants.h>
INTERN ATTR_SECTION(".text.crt.math.complex") ATTR_CONST WUNUSED double _Complex
NOTHROW(LIBCCALL libc_cproj)(double _Complex z) {
	union {
		double _Complex x;
		double parts[2];
	} v;
	v.x = z;
	if (libc_isinf(libc_creal(z)) || libc_isinf(libc_cimag(z))) {
		v.parts[0] = __HUGE_VAL;              /* Real-part */
		v.parts[1] = libc_copysign(0.0, libc_cimag(z)); /* Imag-part */
	}
	return v.x;
}
#include <hybrid/typecore.h>
#ifdef __ARCH_LONG_DOUBLE_IS_DOUBLE
DEFINE_INTERN_ALIAS_P(libc_cabsl,libc_cabs,,__LONGDOUBLE,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
#else /* __ARCH_LONG_DOUBLE_IS_DOUBLE */
INTERN ATTR_SECTION(".text.crt.math.complex") __LONGDOUBLE
NOTHROW_NCX(LIBCCALL libc_cabsl)(long double _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	return libc_hypotl(libc_creall(z), libc_cimagl(z));



}
#endif /* !__ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <hybrid/typecore.h>
#ifdef __ARCH_LONG_DOUBLE_IS_DOUBLE
DEFINE_INTERN_ALIAS_P(libc_cexpl,libc_cexp,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
#else /* __ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED long double _Complex
NOTHROW_NCX(LIBCCALL libc_cexpl)(long double _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	long double _Complex w;
	__LONGDOUBLE r, x, y;
	__LONGDOUBLE siny, cosy;
	x = libc_creall(z);
	y = libc_cimagl(z);
	r = libc_expl(x);
	libc_sincosl(y, &siny, &cosy);
	w = CMPLXL(r * cosy, r * siny);
	return w;



}
#endif /* !__ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <hybrid/typecore.h>
#ifdef __ARCH_LONG_DOUBLE_IS_DOUBLE
DEFINE_INTERN_ALIAS_P(libc_clogl,libc_clog,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
#else /* __ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED long double _Complex
NOTHROW_NCX(LIBCCALL libc_clogl)(long double _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	long double _Complex w;
	__LONGDOUBLE p, rr;
	rr = libc_cabsl(z);
	p = libc_logl(rr);
	rr = libc_atan2l(libc_cimagl(z), libc_creall(z));
	w = CMPLXL(p, rr);
	return w;



}
#endif /* !__ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <hybrid/typecore.h>
#ifdef __ARCH_LONG_DOUBLE_IS_DOUBLE
DEFINE_INTERN_ALIAS_P(libc_cpowl,libc_cpow,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex a, long double _Complex z),(a,z));
#else /* __ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED long double _Complex
NOTHROW_NCX(LIBCCALL libc_cpowl)(long double _Complex a,
                                 long double _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	long double _Complex w;
	__LONGDOUBLE x, y, r, theta, absa, arga;
	__LONGDOUBLE sin_theta, cos_theta;
	x    = libc_creall(z);
	y    = libc_cimagl(z);
	absa = libc_cabsl(a);
	if (absa == 0.0L)
		return CMPLXL(0.0L, 0.0L);
	arga  = libc_cargl(a);
	r     = libc_powl(absa, x);
	theta = x * arga;
	if (y != 0.0L) {
		r     = r * libc_expl(-y * arga);
		theta = theta + y * libc_logl(absa);
	}
	libc_sincosl(theta, &sin_theta, &cos_theta);
	w = CMPLXL(r * cos_theta, r * sin_theta);
	return w;



}
#endif /* !__ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <hybrid/typecore.h>
#ifdef __ARCH_LONG_DOUBLE_IS_DOUBLE
DEFINE_INTERN_ALIAS_P(libc_csqrtl,libc_csqrt,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
#else /* __ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <hybrid/floatcore.h>
#include <bits/math-constants.h>
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED long double _Complex
NOTHROW_NCX(LIBCCALL libc_csqrtl)(long double _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */

	long double _Complex result;
	__LONGDOUBLE a, b;
	__LONGDOUBLE t;
	bool scale;
	a = libc_creall(z);
	b = libc_cimagl(z);

	/* Handle special cases. */
	if (z == 0.0L)
		return CMPLXL(0.0L, b);
	if (libc_isinfl(b))
		return CMPLXL(__INFINITYL, b);
	if (libc_isnanl(a)) {
		t = (b - b) / (b - b); /* raise invalid if b is not a NaN */
		return CMPLXL(a, t);    /* return NaN + NaN i */
	}
	if (libc_isinfl(a)) {
		/* csqrt(inf + NaN i)  = inf +  NaN i
		 * csqrt(inf + y i)    = inf +  0 i
		 * csqrt(-inf + NaN i) = NaN +- inf i
		 * csqrt(-inf + y i)   = 0   +  inf i */
		if (libc___signbitl(a)) {
			return CMPLXL(libc_fabsl(b - b), libc_copysignl(a, b));
		} else {
			return CMPLXL(a, libc_copysignl(b - b, b));
		}
	}

	/* The remaining special case (b is NaN) is handled just fine by
	 * the normal code path below. */

	/* Scale to avoid overflow. */
	if (libc_fabsl(a) >= (__LDBL_MAX__ / 2.414213562373095048801688724209698L) ||
	    libc_fabsl(b) >= (__LDBL_MAX__ / 2.414213562373095048801688724209698L)) {
		a *= 0.25L;
		b *= 0.25L;
		scale = true;
	} else {
		scale = false;
	}

	/* Algorithm 312, CACM vol 10, Oct 1967. */
	if (a >= 0) {
		t      = libc_sqrtl((a + libc_hypotl(a, b)) * 0.5L);
		result = CMPLXL(t, (b / (2.0L * t)));
	} else {
		t      = libc_sqrtl((-a + libc_hypotl(a, b)) * 0.5L);
		result = CMPLXL(libc_fabsl(b) / (2.0L * t), libc_copysignl(t, b));
	}
	/* Rescale. */
	if (scale) {
		return (result * 2.0L);
	} else {
		return (result);
	}








































































}
#endif /* !__ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <hybrid/typecore.h>
#ifdef __ARCH_LONG_DOUBLE_IS_DOUBLE
DEFINE_INTERN_ALIAS_P(libc_csinl,libc_csin,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
#else /* __ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED long double _Complex
NOTHROW_NCX(LIBCCALL libc_csinl)(long double _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	long double _Complex w;
	__LONGDOUBLE ch, sh;
	__LONGDOUBLE sin_creal_z, cos_creal_z;
	libc__cchshl(libc_cimagl(z), &ch, &sh);
	libc_sincosl(libc_creall(z), &sin_creal_z, &cos_creal_z);
	w = CMPLXL(sin_creal_z * ch, cos_creal_z * sh);
	return w;



}
#endif /* !__ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <hybrid/typecore.h>
#ifdef __ARCH_LONG_DOUBLE_IS_DOUBLE
DEFINE_INTERN_ALIAS_P(libc_ccosl,libc_ccos,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
#else /* __ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED long double _Complex
NOTHROW_NCX(LIBCCALL libc_ccosl)(long double _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	long double _Complex w;
	__LONGDOUBLE ch, sh;
	__LONGDOUBLE sin_creal_z, cos_creal_z;
	libc__cchshl(libc_cimagl(z), &ch, &sh);
	libc_sincosl(libc_creall(z), &sin_creal_z, &cos_creal_z);
	w = CMPLXL(cos_creal_z * ch, -(sin_creal_z * sh));
	return w;



}
#endif /* !__ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <hybrid/typecore.h>
#ifdef __ARCH_LONG_DOUBLE_IS_DOUBLE
DEFINE_INTERN_ALIAS_P(libc_ctanl,libc_ctan,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
#else /* __ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <bits/crt/complex.h>
#include <hybrid/floatcore.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED long double _Complex
NOTHROW_NCX(LIBCCALL libc_ctanl)(long double _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	long double _Complex w;
	__LONGDOUBLE d;
	__LONGDOUBLE sin_2_0_creal_z, cos_2_0_creal_z;
	libc_sincosl(2.0L * libc_creall(z), &sin_2_0_creal_z, &cos_2_0_creal_z);
	d = cos_2_0_creal_z + libc_coshl(2.0L * libc_cimagl(z));
	if (libc_fabsl(d) < 0.25L)
		d = libc__ctansl(z);
	if (d == 0.0L) {
		/* mtherr("ctan", OVERFLOW); */
		w = CMPLXL(__LDBL_MAX__, __LDBL_MAX__);
		return w;
	}
	w = CMPLXL(sin_2_0_creal_z / d, libc_sinhl(2.0L * libc_cimagl(z)) / d);
	return w;



}
#endif /* !__ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <hybrid/typecore.h>
#ifdef __ARCH_LONG_DOUBLE_IS_DOUBLE
DEFINE_INTERN_ALIAS_P(libc_casinl,libc_casin,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
#else /* __ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED long double _Complex
NOTHROW_NCX(LIBCCALL libc_casinl)(long double _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	long double _Complex w;
	long double _Complex ca, ct, zz, z2;
	__LONGDOUBLE x, y;
	x  = libc_creall(z);
	y  = libc_cimagl(z);
	ca = CMPLXL(x, y);
	ct = CMPLXL(0.0L, ca);
	/* sqrt( 1 - z*z) */
	/* cmul( &ca, &ca, &zz ) */
	/*x * x  -  y * y */
	zz = CMPLXL((x - y) * (x + y), (2.0L * x * y));
	zz = CMPLXL(1.0L - libc_creall(zz), -libc_cimagl(zz));
	z2 = libc_csqrtl(zz);
	zz = ct + z2;
	zz = libc_clogl(zz);
	/* multiply by 1/i = -i */
	w = zz * CMPLXL(0.0L, -1.0L);
	return w;



}
#endif /* !__ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <hybrid/typecore.h>
#ifdef __ARCH_LONG_DOUBLE_IS_DOUBLE
DEFINE_INTERN_ALIAS_P(libc_cacosl,libc_cacos,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
#else /* __ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED long double _Complex
NOTHROW_NCX(LIBCCALL libc_cacosl)(long double _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	long double _Complex w;
	w = libc_casinl(z);

	w = CMPLXL((1.570796326794896619231321691639751442L /* M_PI_2l */ - libc_creall(w)), -libc_cimagl(w));



	return w;



}
#endif /* !__ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <hybrid/typecore.h>
#ifdef __ARCH_LONG_DOUBLE_IS_DOUBLE
DEFINE_INTERN_ALIAS_P(libc_catanl,libc_catan,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
#else /* __ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <bits/crt/complex.h>
#include <hybrid/floatcore.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED long double _Complex
NOTHROW_NCX(LIBCCALL libc_catanl)(long double _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	long double _Complex w;
	__LONGDOUBLE a, t, x, x2, y;
	x = libc_creall(z);
	y = libc_cimagl(z);
	if ((x == 0.0L) && (y > 1.0L))
		goto ovrf;
	x2 = x * x;
	a = 1.0L - x2 - (y * y);
	if (a == 0.0L)
		goto ovrf;
	t = 0.5L * libc_atan2l(2.0L * x, a);
	w = libc__redupil(t);
	t = y - 1.0L;
	a = x2 + (t * t);
	if (a == 0.0L)
		goto ovrf;
	t = y + 1.0L;
	a = (x2 + (t * t))/a;
	w = CMPLXL(w, (0.25L * libc_logl(a)));
	return w;
ovrf:
	/* matherr("catan", OVERFLOW); */
	w = CMPLXL(__LDBL_MAX__, __LDBL_MAX__);
	return w;



}
#endif /* !__ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <hybrid/typecore.h>
#ifdef __ARCH_LONG_DOUBLE_IS_DOUBLE
DEFINE_INTERN_ALIAS_P(libc_csinhl,libc_csinh,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
#else /* __ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED long double _Complex
NOTHROW_NCX(LIBCCALL libc_csinhl)(long double _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	long double _Complex w;
	__LONGDOUBLE x, y;
	__LONGDOUBLE sin_y, cos_y;
	x = libc_creall(z);
	y = libc_cimagl(z);
	libc_sincosl(y, &sin_y, &cos_y);
	w = CMPLXL(libc_sinhl(x) * cos_y, libc_coshl(x) * sin_y);
	return w;



}
#endif /* !__ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <hybrid/typecore.h>
#ifdef __ARCH_LONG_DOUBLE_IS_DOUBLE
DEFINE_INTERN_ALIAS_P(libc_ccoshl,libc_ccosh,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
#else /* __ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED long double _Complex
NOTHROW_NCX(LIBCCALL libc_ccoshl)(long double _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	long double _Complex w;
	__LONGDOUBLE x, y;
	__LONGDOUBLE sin_y, cos_y;
	x = libc_creall(z);
	y = libc_cimagl(z);
	libc_sincosl(y, &sin_y, &cos_y);
	w = CMPLXL(libc_coshl(x) * cos_y, libc_sinhl(x) * sin_y);
	return w;



}
#endif /* !__ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <hybrid/typecore.h>
#ifdef __ARCH_LONG_DOUBLE_IS_DOUBLE
DEFINE_INTERN_ALIAS_P(libc_ctanhl,libc_ctanh,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
#else /* __ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <bits/crt/complex.h>
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED long double _Complex
NOTHROW_NCX(LIBCCALL libc_ctanhl)(long double _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	long double _Complex w;
	__LONGDOUBLE x, y, d;
	__LONGDOUBLE sin_2_0_y, cos_2_0_y;
	x = libc_creall(z);
	y = libc_cimagl(z);
	libc_sincosl(2.0L * y, &sin_2_0_y, &cos_2_0_y);
	d = libc_coshl(2.0L * x) + cos_2_0_y;
	w = CMPLXL(libc_sinhl(2.0L * x) / d, sin_2_0_y / d);
	return w;



}
#endif /* !__ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <hybrid/typecore.h>
#ifdef __ARCH_LONG_DOUBLE_IS_DOUBLE
DEFINE_INTERN_ALIAS_P(libc_casinhl,libc_casinh,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
#else /* __ARCH_LONG_DOUBLE_IS_DOUBLE */
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED long double _Complex
NOTHROW_NCX(LIBCCALL libc_casinhl)(long double _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	long double _Complex w;
	w = -1.0L * _Complex_I * libc_casinl(z * _Complex_I);
	return w;



}
#endif /* !__ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <hybrid/typecore.h>
#ifdef __ARCH_LONG_DOUBLE_IS_DOUBLE
DEFINE_INTERN_ALIAS_P(libc_cacoshl,libc_cacosh,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
#else /* __ARCH_LONG_DOUBLE_IS_DOUBLE */
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED long double _Complex
NOTHROW_NCX(LIBCCALL libc_cacoshl)(long double _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	long double _Complex w;
	w = libc_clogl(z + libc_csqrtl(z + 1) * libc_csqrtl(z - 1));
	return w;



}
#endif /* !__ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <hybrid/typecore.h>
#ifdef __ARCH_LONG_DOUBLE_IS_DOUBLE
DEFINE_INTERN_ALIAS_P(libc_catanhl,libc_catanh,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
#else /* __ARCH_LONG_DOUBLE_IS_DOUBLE */
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED long double _Complex
NOTHROW_NCX(LIBCCALL libc_catanhl)(long double _Complex z) {

	/* Implementation derived from NetBSD. -- See the following copyright notice. */
	/*-
	 * Copyright (c) 2007 The NetBSD Foundation, Inc.
	 * All rights reserved.
	 *
	 * This code is derived from software written by Stephen L. Moshier.
	 * It is redistributed by the NetBSD Foundation by permission of the author.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions
	 * are met:
	 * 1. Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 * 2. Redistributions in binary form must reproduce the above copyright
	 *    notice, this list of conditions and the following disclaimer in the
	 *    documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
	 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
	 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
	 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
	 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
	 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
	 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	 * POSSIBILITY OF SUCH DAMAGE.
	 */
	long double _Complex w;
	w = -1.0L * _Complex_I * libc_catanl(z * _Complex_I);
	return w;



}
#endif /* !__ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <hybrid/typecore.h>
#ifdef __ARCH_LONG_DOUBLE_IS_DOUBLE
DEFINE_INTERN_ALIAS_P(libc_cargl,libc_carg,WUNUSED,__LONGDOUBLE,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
#else /* __ARCH_LONG_DOUBLE_IS_DOUBLE */
INTERN ATTR_SECTION(".text.crt.math.complex") WUNUSED __LONGDOUBLE
NOTHROW_NCX(LIBCCALL libc_cargl)(long double _Complex z) {

	return libc_atan2l(libc_cimagl(z), libc_creall(z));



}
#endif /* !__ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <hybrid/typecore.h>
#ifdef __ARCH_LONG_DOUBLE_IS_DOUBLE
DEFINE_INTERN_ALIAS_P(libc_conjl,libc_conj,ATTR_CONST WUNUSED,long double _Complex,NOTHROW,LIBCCALL,(long double _Complex z),(z));
#else /* __ARCH_LONG_DOUBLE_IS_DOUBLE */
INTERN ATTR_SECTION(".text.crt.math.complex") ATTR_CONST WUNUSED long double _Complex
NOTHROW(LIBCCALL libc_conjl)(long double _Complex z) {
	union {
		long double _Complex x;
		__LONGDOUBLE parts[2];
	} v;
	v.x = z;
	v.parts[1] = -v.parts[1];
	return v.x;
}
#endif /* !__ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <hybrid/typecore.h>
#ifdef __ARCH_LONG_DOUBLE_IS_DOUBLE
DEFINE_INTERN_ALIAS_P(libc_creall,libc_creal,ATTR_CONST WUNUSED,__LONGDOUBLE,NOTHROW,LIBCCALL,(long double _Complex z),(z));
#else /* __ARCH_LONG_DOUBLE_IS_DOUBLE */
INTERN ATTR_SECTION(".text.crt.math.complex") ATTR_CONST WUNUSED __LONGDOUBLE
NOTHROW(LIBCCALL libc_creall)(long double _Complex z) {
	union {
		long double _Complex x;
		__LONGDOUBLE parts[2];
	} v;
	v.x = z;
	return v.parts[0];
}
#endif /* !__ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <hybrid/typecore.h>
#ifdef __ARCH_LONG_DOUBLE_IS_DOUBLE
DEFINE_INTERN_ALIAS_P(libc_cimagl,libc_cimag,ATTR_CONST WUNUSED,__LONGDOUBLE,NOTHROW,LIBCCALL,(long double _Complex z),(z));
#else /* __ARCH_LONG_DOUBLE_IS_DOUBLE */
INTERN ATTR_SECTION(".text.crt.math.complex") ATTR_CONST WUNUSED __LONGDOUBLE
NOTHROW(LIBCCALL libc_cimagl)(long double _Complex z) {
	union {
		long double _Complex x;
		__LONGDOUBLE parts[2];
	} v;
	v.x = z;
	return v.parts[1];
}
#endif /* !__ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <hybrid/typecore.h>
#ifdef __ARCH_LONG_DOUBLE_IS_DOUBLE
DEFINE_INTERN_ALIAS_P(libc_cprojl,libc_cproj,ATTR_CONST WUNUSED,long double _Complex,NOTHROW,LIBCCALL,(long double _Complex z),(z));
#else /* __ARCH_LONG_DOUBLE_IS_DOUBLE */
#include <bits/math-constants.h>
INTERN ATTR_SECTION(".text.crt.math.complex") ATTR_CONST WUNUSED long double _Complex
NOTHROW(LIBCCALL libc_cprojl)(long double _Complex z) {

	union {
		long double _Complex x;
		__LONGDOUBLE parts[2];
	} v;
	v.x = z;
	if (libc_isinfl(libc_creall(z)) || libc_isinfl(libc_cimagl(z))) {
		v.parts[0] = __HUGE_VALL;              /* Real-part */
		v.parts[1] = libc_copysignl(0.0L, libc_cimagl(z)); /* Imag-part */
	}
	return v.x;



}
#endif /* !__ARCH_LONG_DOUBLE_IS_DOUBLE */
#endif /* !__KERNEL__ */

DECL_END

#ifndef __KERNEL__
DEFINE_PUBLIC_ALIAS_P(__cabsf,libc_cabsf,,float,NOTHROW_NCX,LIBCCALL,(float _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(cabsf,libc_cabsf,,float,NOTHROW_NCX,LIBCCALL,(float _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(cexpf,libc_cexpf,WUNUSED,float _Complex,NOTHROW_NCX,LIBCCALL,(float _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(clogf,libc_clogf,WUNUSED,float _Complex,NOTHROW_NCX,LIBCCALL,(float _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(cpowf,libc_cpowf,WUNUSED,float _Complex,NOTHROW_NCX,LIBCCALL,(float _Complex a, float _Complex z),(a,z));
DEFINE_PUBLIC_ALIAS_P(csqrtf,libc_csqrtf,WUNUSED,float _Complex,NOTHROW_NCX,LIBCCALL,(float _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(csinf,libc_csinf,WUNUSED,float _Complex,NOTHROW_NCX,LIBCCALL,(float _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(ccosf,libc_ccosf,WUNUSED,float _Complex,NOTHROW_NCX,LIBCCALL,(float _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(ctanf,libc_ctanf,WUNUSED,float _Complex,NOTHROW_NCX,LIBCCALL,(float _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(casinf,libc_casinf,WUNUSED,float _Complex,NOTHROW_NCX,LIBCCALL,(float _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(cacosf,libc_cacosf,WUNUSED,float _Complex,NOTHROW_NCX,LIBCCALL,(float _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(catanf,libc_catanf,WUNUSED,float _Complex,NOTHROW_NCX,LIBCCALL,(float _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(csinhf,libc_csinhf,WUNUSED,float _Complex,NOTHROW_NCX,LIBCCALL,(float _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(ccoshf,libc_ccoshf,WUNUSED,float _Complex,NOTHROW_NCX,LIBCCALL,(float _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(ctanhf,libc_ctanhf,WUNUSED,float _Complex,NOTHROW_NCX,LIBCCALL,(float _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(casinhf,libc_casinhf,WUNUSED,float _Complex,NOTHROW_NCX,LIBCCALL,(float _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(cacoshf,libc_cacoshf,WUNUSED,float _Complex,NOTHROW_NCX,LIBCCALL,(float _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(catanhf,libc_catanhf,WUNUSED,float _Complex,NOTHROW_NCX,LIBCCALL,(float _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(cargf,libc_cargf,WUNUSED,float,NOTHROW_NCX,LIBCCALL,(float _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(conjf,libc_conjf,ATTR_CONST WUNUSED,float _Complex,NOTHROW,LIBCCALL,(float _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(crealf,libc_crealf,ATTR_CONST WUNUSED,float,NOTHROW,LIBCCALL,(float _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(cimagf,libc_cimagf,ATTR_CONST WUNUSED,float,NOTHROW,LIBCCALL,(float _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(cprojf,libc_cprojf,ATTR_CONST WUNUSED,float _Complex,NOTHROW,LIBCCALL,(float _Complex z),(z));
#ifdef __LIBCCALL_IS_LIBDCALL
DEFINE_PUBLIC_ALIAS_P(_cabs,libc_cabs,,double,NOTHROW_NCX,LIBCCALL,(double _Complex z),(z));
#endif /* __LIBCCALL_IS_LIBDCALL */
DEFINE_PUBLIC_ALIAS_P(__cabs,libc_cabs,,double,NOTHROW_NCX,LIBCCALL,(double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(cabs,libc_cabs,,double,NOTHROW_NCX,LIBCCALL,(double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(cexp,libc_cexp,WUNUSED,double _Complex,NOTHROW_NCX,LIBCCALL,(double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(clog,libc_clog,WUNUSED,double _Complex,NOTHROW_NCX,LIBCCALL,(double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(cpow,libc_cpow,WUNUSED,double _Complex,NOTHROW_NCX,LIBCCALL,(double _Complex a, double _Complex z),(a,z));
DEFINE_PUBLIC_ALIAS_P(csqrt,libc_csqrt,WUNUSED,double _Complex,NOTHROW_NCX,LIBCCALL,(double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(csin,libc_csin,WUNUSED,double _Complex,NOTHROW_NCX,LIBCCALL,(double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(ccos,libc_ccos,WUNUSED,double _Complex,NOTHROW_NCX,LIBCCALL,(double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(ctan,libc_ctan,WUNUSED,double _Complex,NOTHROW_NCX,LIBCCALL,(double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(casin,libc_casin,WUNUSED,double _Complex,NOTHROW_NCX,LIBCCALL,(double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(cacos,libc_cacos,WUNUSED,double _Complex,NOTHROW_NCX,LIBCCALL,(double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(catan,libc_catan,WUNUSED,double _Complex,NOTHROW_NCX,LIBCCALL,(double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(csinh,libc_csinh,WUNUSED,double _Complex,NOTHROW_NCX,LIBCCALL,(double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(ccosh,libc_ccosh,WUNUSED,double _Complex,NOTHROW_NCX,LIBCCALL,(double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(ctanh,libc_ctanh,WUNUSED,double _Complex,NOTHROW_NCX,LIBCCALL,(double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(casinh,libc_casinh,WUNUSED,double _Complex,NOTHROW_NCX,LIBCCALL,(double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(cacosh,libc_cacosh,WUNUSED,double _Complex,NOTHROW_NCX,LIBCCALL,(double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(catanh,libc_catanh,WUNUSED,double _Complex,NOTHROW_NCX,LIBCCALL,(double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(carg,libc_carg,WUNUSED,double,NOTHROW_NCX,LIBCCALL,(double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(conj,libc_conj,ATTR_CONST WUNUSED,double _Complex,NOTHROW,LIBCCALL,(double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(creal,libc_creal,ATTR_CONST WUNUSED,double,NOTHROW,LIBCCALL,(double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(cimag,libc_cimag,ATTR_CONST WUNUSED,double,NOTHROW,LIBCCALL,(double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(cproj,libc_cproj,ATTR_CONST WUNUSED,double _Complex,NOTHROW,LIBCCALL,(double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(__cabsl,libc_cabsl,,__LONGDOUBLE,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(cabsl,libc_cabsl,,__LONGDOUBLE,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(cexpl,libc_cexpl,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(clogl,libc_clogl,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(cpowl,libc_cpowl,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex a, long double _Complex z),(a,z));
DEFINE_PUBLIC_ALIAS_P(csqrtl,libc_csqrtl,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(csinl,libc_csinl,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(ccosl,libc_ccosl,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(ctanl,libc_ctanl,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(casinl,libc_casinl,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(cacosl,libc_cacosl,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(catanl,libc_catanl,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(csinhl,libc_csinhl,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(ccoshl,libc_ccoshl,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(ctanhl,libc_ctanhl,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(casinhl,libc_casinhl,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(cacoshl,libc_cacoshl,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(catanhl,libc_catanhl,WUNUSED,long double _Complex,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(cargl,libc_cargl,WUNUSED,__LONGDOUBLE,NOTHROW_NCX,LIBCCALL,(long double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(conjl,libc_conjl,ATTR_CONST WUNUSED,long double _Complex,NOTHROW,LIBCCALL,(long double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(creall,libc_creall,ATTR_CONST WUNUSED,__LONGDOUBLE,NOTHROW,LIBCCALL,(long double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(cimagl,libc_cimagl,ATTR_CONST WUNUSED,__LONGDOUBLE,NOTHROW,LIBCCALL,(long double _Complex z),(z));
DEFINE_PUBLIC_ALIAS_P(cprojl,libc_cprojl,ATTR_CONST WUNUSED,long double _Complex,NOTHROW,LIBCCALL,(long double _Complex z),(z));
#endif /* !__KERNEL__ */

#endif /* !GUARD_LIBC_AUTO_COMPLEX_C */
