/* HASH CRC-32:0x2cb06bc1 */
/* Copyright (c) 2019-2024 Griefer@Work                                       *
 *                                                                            *
 * This software is provided 'as-is', without any express or implied          *
 * warranty. In no event will the authors be held liable for any damages      *
 * arising from the use of this software.                                     *
 *                                                                            *
 * Permission is granted to anyone to use this software for any purpose,      *
 * including commercial applications, and to alter it and redistribute it     *
 * freely, subject to the following restrictions:                             *
 *                                                                            *
 * 1. The origin of this software must not be misrepresented; you must not    *
 *    claim that you wrote the original software. If you use this software    *
 *    in a product, an acknowledgement (see the following) in the product     *
 *    documentation is required:                                              *
 *    Portions Copyright (c) 2019-2024 Griefer@Work                           *
 * 2. Altered source versions must be plainly marked as such, and must not be *
 *    misrepresented as being the original software.                          *
 * 3. This notice may not be removed or altered from any source distribution. *
 */
#ifndef GUARD_KERNEL_CORE_ARCH_I386_SYSCALL_WRAPPERS64_S
#define GUARD_KERNEL_CORE_ARCH_I386_SYSCALL_WRAPPERS64_S 1

#include <kernel/compiler.h>

#include <cfi.h>
#include <asm/instr/movzxq.h>
#include <asm/instr/interrupt.h>
#include <kos/kernel/paging.h>
#include <kernel/arch/syscall.h>










/* Read up to `bufsize' bytes from `fd' into `buf'
 * When  `fd' has the `O_NONBLOCK' flag set, only read as much data as was
 * available at the time the call was made, and throw `E_WOULDBLOCK' if no
 * data was available at the time.
 * @return: <= bufsize: The actual amount of read bytes
 * @return: 0         : EOF */
/* ssize_t read(fd_t fd, void *buf, size_t bufsize) */
.section .text.x86.asm64_syscall.read
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_read)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x0
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_read)
	call   sys_read
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_read)

/* Write up to `bufsize' bytes from `buf' into `fd'
 * When `fd' has the `O_NONBLOCK' flag set, only write as much data as
 * possible at the time the call was made, and throw `E_WOULDBLOCK' if
 * no data could be written at the time.
 * @return: <= bufsize: The actual amount of written bytes
 * @return: 0         : No more data can be written */
/* ssize_t write(fd_t fd, void const *buf, size_t bufsize) */
.section .text.x86.asm64_syscall.write
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_write)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x1
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_write)
	call   sys_write
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_write)

/* Open  a  new  file  handle  to  the  file  specified  by `filename'
 * When  `oflags & O_CREAT',   then  `mode'   specifies  the   initial
 * file  access  permissions with  which  the file  should  be opened.
 * On KOS, the returned handle can be anything, but is usually one of:
 *   - HANDLE_TYPE_PATH:       When `O_PATH' was given
 *   - HANDLE_TYPE_FILEHANDLE: For `S_IFREG' regular files
 *   - HANDLE_TYPE_FIFOHANDLE: For `S_IFIFO' pipe files
 *   - HANDLE_TYPE_DIRHANDLE:  For `S_IFDIR' directories
 *   - HANDLE_TYPE_MFILE:      The actual filesystem object (including device files)
 *   - *:                      Certain filesystem names can literally return anything, such
 *                             as `/proc/self/fd/1234',  which  is  more  like  `dup(1234)' */
/* fd_t open(char const *filename, oflag_t oflags, mode_t mode) */
.section .text.x86.asm64_syscall.open
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_open)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x2
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_open)
	call   sys_open
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_open)

/* Close a given file descriptor/handle `fd' */
/* errno_t close(fd_t fd) */
.section .text.x86.asm64_syscall.close
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_close)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x3
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_close)
	call   sys_close
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_close)

/* errno_t stat(char const *filename, struct linux_statx64 *statbuf) */
.section .text.x86.asm64_syscall.stat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_stat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x4
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_stat)
	call   sys_stat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_stat)

/* errno_t fstat(fd_t fd, struct linux_statx64 *statbuf) */
.section .text.x86.asm64_syscall.fstat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_fstat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x5
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_fstat)
	call   sys_fstat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_fstat)

/* errno_t lstat(char const *filename, struct linux_statx64 *statbuf) */
.section .text.x86.asm64_syscall.lstat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_lstat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x6
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_lstat)
	call   sys_lstat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_lstat)

/* ssize_t poll(struct pollfd *fds, size_t nfds, syscall_slong_t timeout) */
.section .text.x86.asm64_syscall.poll
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_poll)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x7
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_poll)
	call   sys_poll
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_poll)

/* syscall_slong_t lseek(fd_t fd, syscall_slong_t offset, syscall_ulong_t whence) */
.section .text.x86.asm64_syscall.lseek
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_lseek)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x8
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_lseek)
	call   sys_lseek
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_lseek)

/* @param: prot:  Either `PROT_NONE', or set of `PROT_EXEC | PROT_WRITE | PROT_READ | PROT_SEM | PROT_SHARED'
 * @param: flags: One of `MAP_SHARED', 'MAP_SHARED_VALIDATE' or `MAP_PRIVATE', optionally or'd
 *               with  a  set of  `MAP_ANONYMOUS  | MAP_FIXED  |  MAP_GROWSDOWN |  MAP_LOCKED |
 *               MAP_NONBLOCK  |  MAP_NORESERVE  |  MAP_POPULATE  |  MAP_STACK  |  MAP_SYNC   |
 *               MAP_UNINITIALIZED | MAP_DONT_MAP | MAP_FIXED_NOREPLACE | MAP_OFFSET64_POINTER' */
/* void *mmap(void *addr, size_t len, syscall_ulong_t prot, syscall_ulong_t flags, fd_t fd, syscall_ulong_t offset) */
.section .text.x86.asm64_syscall.mmap
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_mmap)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x9
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_mmap)
	call   sys_mmap
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_mmap)

/* @param: prot: Either `PROT_NONE', or set of `PROT_EXEC | PROT_WRITE | PROT_READ | PROT_SEM | PROT_SHARED' */
/* errno_t mprotect(void *addr, size_t len, syscall_ulong_t prot) */
.section .text.x86.asm64_syscall.mprotect
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_mprotect)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xa
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_mprotect)
	call   sys_mprotect
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_mprotect)

/* errno_t munmap(void *addr, size_t len) */
.section .text.x86.asm64_syscall.munmap
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_munmap)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xb
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_munmap)
	call   sys_munmap
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_munmap)

/* errno_t brk(void *addr) */
.section .text.x86.asm64_syscall.brk
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_brk)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xc
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_brk)
	call   sys_brk
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_brk)

/* errno_t rt_sigaction(signo_t signo, struct __kernel_sigactionx64 const *act, struct __kernel_sigactionx64 *oact, size_t sigsetsize) */
.section .text.x86.asm64_syscall.rt_sigaction
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_rt_sigaction)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xd
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_rt_sigaction)
	call   sys_rt_sigaction
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_rt_sigaction)

/* @param: how: One of `SIG_BLOCK', `SIG_UNBLOCK' or `SIG_SETMASK' */
/* errno_t rt_sigprocmask(syscall_ulong_t how, struct __sigset_struct const *set, struct __sigset_struct *oset, size_t sigsetsize) */
.section .text.x86.asm64_syscall.rt_sigprocmask
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_rt_sigprocmask)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xe
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_rt_sigprocmask)
	call   sys_rt_sigprocmask
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_rt_sigprocmask)

/* void rt_sigreturn(void) */
.section .text.x86.asm64_syscall.rt_sigreturn
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_rt_sigreturn)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xf
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_rt_sigreturn)
	call   sys_rt_sigreturn
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_rt_sigreturn)

/* syscall_slong_t ioctl(fd_t fd, ioctl_t command, void *arg) */
.section .text.x86.asm64_syscall.ioctl
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_ioctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x10
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_ioctl)
	call   sys_ioctl
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_ioctl)

/* ssize_t pread64(fd_t fd, void *buf, size_t bufsize, uint64_t offset) */
.section .text.x86.asm64_syscall.pread64
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_pread64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x11
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_pread64)
	call   sys_pread64
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_pread64)

/* ssize_t pwrite64(fd_t fd, void const *buf, size_t bufsize, uint64_t offset) */
.section .text.x86.asm64_syscall.pwrite64
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_pwrite64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x12
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_pwrite64)
	call   sys_pwrite64
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_pwrite64)

/* Same as `read(2)', but rather than specifying a single, continuous buffer,
 * read  data into `count'  separate buffers, though  still return the actual
 * number of read bytes.
 * When `fd' has the `O_NONBLOCK' flag set, only read as much data as was
 * available at  the time  the call  was made,  and throw  `E_WOULDBLOCK'
 * no data was available at the time.
 * @return: <= SUM(iov[*].iov_len): The actual amount of read bytes
 * @return: 0                     : EOF */
/* ssize_t readv(fd_t fd, struct iovecx64 const *iovec, size_t count) */
.section .text.x86.asm64_syscall.readv
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_readv)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x13
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_readv)
	call   sys_readv
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_readv)

/* Same as `write(2)', but rather than specifying a single, continuous buffer,
 * write  data from `count'  separate buffers, though  still return the actual
 * number of written bytes.
 * When  `fd' has the  `O_NONBLOCK' flag set, only  write as much data
 * as possible at the time the call was made, and throw `E_WOULDBLOCK'
 * if no data could be written at the time.
 * @return: <= SUM(iov[*].iov_len): The actual amount of written bytes
 * @return: 0                     : No more data can be written */
/* ssize_t writev(fd_t fd, struct iovecx64 const *iovec, size_t count) */
.section .text.x86.asm64_syscall.writev
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_writev)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x14
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_writev)
	call   sys_writev
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_writev)

/* @param: type: Set of `R_OK|W_OK|X_OK' or `F_OK' */
/* errno_t access(char const *filename, syscall_ulong_t type) */
.section .text.x86.asm64_syscall.access
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_access)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x15
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_access)
	call   sys_access
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_access)

/* errno_t pipe(fd_t[2] pipedes) */
.section .text.x86.asm64_syscall.pipe
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_pipe)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x16
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_pipe)
	call   sys_pipe
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_pipe)

/* ssize_t select(size_t nfds, struct __fd_set_struct *readfds, struct __fd_set_struct *writefds, struct __fd_set_struct *exceptfds, struct timevalx64 *timeout) */
.section .text.x86.asm64_syscall.select
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_select)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x17
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_select)
	call   sys_select
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_select)

/* errno_t sched_yield(void) */
.section .text.x86.asm64_syscall.sched_yield
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_sched_yield)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x18
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_sched_yield)
	call   sys_sched_yield
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_sched_yield)

/* @param: flags: Set of `MREMAP_MAYMOVE | MREMAP_FIXED' */
/* void *mremap(void *addr, size_t old_len, size_t new_len, syscall_ulong_t flags, void *new_address) */
.section .text.x86.asm64_syscall.mremap
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_mremap)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x19
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_mremap)
	call   sys_mremap
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_mremap)

/* errno_t msync(void *addr, size_t len, syscall_ulong_t flags) */
.section .text.x86.asm64_syscall.msync
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_msync)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x1a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_msync)
	call   sys_msync
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_msync)

/* errno_t mincore(void *start, size_t len, uint8_t *vec) */
.section .text.x86.asm64_syscall.mincore
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_mincore)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x1b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_mincore)
	call   sys_mincore
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_mincore)

/* errno_t madvise(void *addr, size_t len, syscall_ulong_t advice) */
.section .text.x86.asm64_syscall.madvise
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_madvise)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x1c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_madvise)
	call   sys_madvise
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_madvise)

/* errno_t shmget(key_t key, size_t size, syscall_ulong_t shmflg) */
.section .text.x86.asm64_syscall.shmget
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_shmget)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x1d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_shmget)
	call   sys_shmget
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_shmget)

/* errno_t shmat(syscall_ulong_t shmid, void const *shmaddr, syscall_ulong_t shmflg) */
.section .text.x86.asm64_syscall.shmat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_shmat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x1e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_shmat)
	call   sys_shmat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_shmat)

/* errno_t shmctl(syscall_ulong_t shmid, syscall_ulong_t cmd, struct shmid_ds *buf) */
.section .text.x86.asm64_syscall.shmctl
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_shmctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x1f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_shmctl)
	call   sys_shmctl
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_shmctl)

/* fd_t dup(fd_t fd) */
.section .text.x86.asm64_syscall.dup
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_dup)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x20
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_dup)
	call   sys_dup
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_dup)

/* fd_t dup2(fd_t oldfd, fd_t newfd) */
.section .text.x86.asm64_syscall.dup2
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_dup2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x21
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_dup2)
	call   sys_dup2
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_dup2)

/* Same as `select(0, NULL, NULL, NULL, NULL)' */
/* errno_t pause(void) */
.section .text.x86.asm64_syscall.pause
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_pause)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x22
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_pause)
	call   sys_pause
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_pause)

/* errno_t nanosleep(struct timespecx64 const *req, struct timespecx64 *rem) */
.section .text.x86.asm64_syscall.nanosleep
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_nanosleep)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x23
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_nanosleep)
	call   sys_nanosleep
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_nanosleep)

/* @param: which: One of `ITIMER_REAL', `ITIMER_VIRTUAL' or `ITIMER_PROF' */
/* errno_t getitimer(syscall_ulong_t which, struct __itimervalx64 *curr_value) */
.section .text.x86.asm64_syscall.getitimer
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_getitimer)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x24
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_getitimer)
	call   sys_getitimer
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_getitimer)

/* syscall_ulong_t alarm(syscall_ulong_t seconds) */
.section .text.x86.asm64_syscall.alarm
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_alarm)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x25
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_alarm)
	call   sys_alarm
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_alarm)

/* @param: which: One of `ITIMER_REAL', `ITIMER_VIRTUAL' or `ITIMER_PROF' */
/* errno_t setitimer(syscall_ulong_t which, struct __itimervalx64 const *newval, struct __itimervalx64 *oldval) */
.section .text.x86.asm64_syscall.setitimer
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_setitimer)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x26
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_setitimer)
	call   sys_setitimer
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_setitimer)

/* pid_t getpid(void) */
.section .text.x86.asm64_syscall.getpid
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_getpid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x27
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_getpid)
	call   sys_getpid
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_getpid)

/* Read up to `num_bytes' from `infd', and write that data to `outfd'
 * Files must be opened with the relevant access permissions (same as
 * would be enforced by `read(2)' and `write(2)')
 * When `pin_offset != NULL', the pointed-to location is used to track
 * the read-position in `infd'. Note that in the event that writing to
 * this address faults, data may  have still been written to  `outfd',
 * so be sure to have this point to writable memory.
 * @param: outfd:      Output file descriptor
 * @param: infd:       Input file descriptor
 * @param: pin_offset: If non-NULL, position from which to start reading,
 *                     and updated to reflect  how much could be  copied.
 * @param: num_bytes:  The max number of bytes to transfer
 * @return: * :        The actual number of bytes transferred */
/* ssize_t sendfile(fd_t outfd, fd_t infd, syscall_ulong_t *pin_offset, size_t num_bytes) */
.section .text.x86.asm64_syscall.sendfile
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_sendfile)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x28
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_sendfile)
	call   sys_sendfile
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_sendfile)

/* Create a new socket for the given domain/type/protocol triple.
 * @param: domain:   Socket address domain/family (one of `AF_*' from `<sys/socket.h>')
 * @param: type:     Socket type (one of `SOCK_*' from `<sys/socket.h>')
 *                   May optionally be or'd with `SOCK_CLOEXEC | SOCK_CLOFORK | SOCK_NONBLOCK'
 * @param: protocol: Socket protocol (`0' for automatic). Available socket protocols mainly
 *                   depend on the selected `domain', and may be further specialized by the
 *                   `type' argument.  for  example,  `AF_INET' takes  one  of  `IPPROTO_*'
 *                   >> socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
 *                   Also note that protocol IDs can be enumerated by `getprotoent(3)' from `<netdb.h>'
 * @return: * : A file descriptor for the newly created socket. */
/* fd_t socket(syscall_ulong_t domain, syscall_ulong_t type, syscall_ulong_t protocol) */
.section .text.x86.asm64_syscall.socket
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_socket)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x29
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_socket)
	call   sys_socket
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_socket)

/* Connect to the specified address.
 * If the given `sockfd' isn't connection-oriented, this will set the address
 * that  will implicitly be  used as destination  by `send(2)' and `write(2)'
 * @throw: E_NET_ADDRESS_IN_USE:E_NET_ADDRESS_IN_USE_CONTEXT_CONNECT
 * @throw: E_INVALID_ARGUMENT_UNEXPECTED_COMMAND:E_INVALID_ARGUMENT_CONTEXT_BIND_WRONG_ADDRESS_FAMILY
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_BIND_ALREADY_BOUND
 * @throw: E_NET_ADDRESS_NOT_AVAILABLE
 * @throw: E_NET_CONNECTION_REFUSED
 * @throw: E_BUFFER_TOO_SMALL   (addr_len is incorrect)
 * @return: 0 : Success */
/* errno_t connect(fd_t sockfd, struct sockaddr const *addr, socklen_t addr_len) */
.section .text.x86.asm64_syscall.connect
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_connect)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x2a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_connect)
	call   sys_connect
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_connect)

/* Accept incoming client (aka. peer) connection requests.
 * @param: addr:      Peer address of the sender (or `NULL' when `addr_len' is `NULL')
 * @param: addr_len:  [NULL] Don't fill in the client's peer address
 *                    [in]   The amount of available memory starting at `addr'
 *                    [out]  The  amount  of required  memory for  the address.
 *                           This  may be  more than  was given,  in which case
 *                           the  address  was  truncated and  may  be invalid.
 *                           If this happens,  the caller  can still  determine
 *                           the correct address through use of `getpeername()'
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_ACCEPT_NOT_LISTENING
 * @throw: E_INVALID_HANDLE_NET_OPERATION:E_NET_OPERATION_ACCEPT
 * @throw: E_NET_CONNECTION_ABORT
 * @return: * : A file descriptor for the newly accept(2)-ed connection */
/* fd_t accept(fd_t sockfd, struct sockaddr *addr, socklen_t *addr_len) */
.section .text.x86.asm64_syscall.accept
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_accept)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x2b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_accept)
	call   sys_accept
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_accept)

/* Send the contents of a given buffer over this socket to the specified address
 * @param: buf:       Buffer of data to send (with a length of `bufsize' bytes)
 * @param: bufsize:   Size of `buf' (in bytes)
 * @param: msg_flags: Set of `MSG_CONFIRM | MSG_DONTROUTE | MSG_DONTWAIT |
 *                            MSG_EOR | MSG_MORE | MSG_NOSIGNAL | MSG_OOB'
 * @param: addr:      Address where to send data (or NULL when `addr_len' is 0)
 * @param: addr_len:  Size of `addr', or `0' to have this behave as an alias
 *                    for            `send(sockfd, buf, bufsize, msg_flags)'
 * @throw: E_INVALID_ARGUMENT_UNEXPECTED_COMMAND:E_INVALID_ARGUMENT_CONTEXT_SENDTO_WRONG_ADDRESS_FAMILY
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_SEND_NOT_CONNECTED
 * @throw: E_NET_MESSAGE_TOO_LONG
 * @throw: E_NET_CONNECTION_RESET
 * @throw: E_NET_SHUTDOWN
 * @throw: E_BUFFER_TOO_SMALL  (`addr_len' is incorrect)
 * @return: * : [<= bufsize] The actual # of send bytes */
/* ssize_t sendto(fd_t sockfd, void const *buf, size_t bufsize, syscall_ulong_t msg_flags, struct sockaddr const *addr, socklen_t addr_len) */
.section .text.x86.asm64_syscall.sendto
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_sendto)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x2c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_sendto)
	call   sys_sendto
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_sendto)

/* Receive data over this socket, and store the contents within the given buffer.
 * @param: buf:       Buffer to-be filled with up to `bufsize' bytes of received data
 * @param: bufsize:   Max # of bytes to receive
 * @param: msg_flags: Set of `MSG_DONTWAIT | MSG_ERRQUEUE | MSG_OOB |
 *                            MSG_PEEK | MSG_TRUNC | MSG_WAITALL'
 * @param: addr:      Peer address of the sender (or `NULL' when `addr_len' is `NULL')
 * @param: addr_len:  [NULL] behave as an alias for `recv(sockfd, buf, bufsize, msg_flags)'
 *                    [in]   The amount of available memory starting at `addr'
 *                    [out]  The amount of required memory for the address.
 *                           This may be more than was given, in which case
 *                           the address was truncated and may be invalid.
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_RECV_NOT_CONNECTED
 * @throw: E_NET_CONNECTION_REFUSED
 * @throw: E_WOULDBLOCK (`MSG_DONTWAIT' was given, and the operation would have blocked)
 * @return: * : [<= bufsize] The actual # of received bytes */
/* ssize_t recvfrom(fd_t sockfd, void *buf, size_t bufsize, syscall_ulong_t msg_flags, struct sockaddr *addr, socklen_t *addr_len) */
.section .text.x86.asm64_syscall.recvfrom
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_recvfrom)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x2d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_recvfrom)
	call   sys_recvfrom
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_recvfrom)

/* Same as `send(2)' and `sendto(2)', but also allows for sending ancillary
 * data as well as  for data buffers  to be represented  by an IOV  vector.
 * @param: msg_flags: Set of `MSG_CONFIRM | MSG_DONTROUTE | MSG_DONTWAIT |
 *                            MSG_EOR | MSG_MORE | MSG_NOSIGNAL | MSG_OOB'
 * @throw: ... Same as for `send(2)' and `sendto(2)'
 * @return: * : [<= bufsize] The actual # of send payload bytes */
/* ssize_t sendmsg(fd_t sockfd, struct msghdrx64 const *message, syscall_ulong_t msg_flags) */
.section .text.x86.asm64_syscall.sendmsg
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_sendmsg)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x2e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_sendmsg)
	call   sys_sendmsg
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_sendmsg)

/* Same as `recv(2)' and `recvfrom(2)', but also allows for receiving ancillary
 * data as  well as  for  data buffers  to be  represented  by an  IOV  vector.
 * @param: msg_flags: Set of `MSG_CMSG_CLOEXEC | MSG_CMSG_CLOFORK |
 *                            MSG_DONTWAIT | MSG_ERRQUEUE | MSG_OOB |
 *                            MSG_PEEK  |  MSG_TRUNC  |  MSG_WAITALL'
 * @throw: ... Same as for `recv(2)' and `recvfrom(2)'
 * @return: * : [<= bufsize] The actual # of received payload bytes */
/* ssize_t recvmsg(fd_t sockfd, struct msghdrx64 *message, syscall_ulong_t msg_flags) */
.section .text.x86.asm64_syscall.recvmsg
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_recvmsg)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x2f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_recvmsg)
	call   sys_recvmsg
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_recvmsg)

/* Disallow further reception of data (causing `recv(2)' to return `0' as soon
 * as  all currently queued  data has been  read), and/or further transmission
 * of data (causing `send(2)' to throw an `E_NET_SHUTDOWN' exception)
 * @param: how: One of `SHUT_RD', `SHUT_WR' or `SHUT_RDWR'
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_SHUTDOWN_NOT_CONNECTED
 * @return: 0 : Success */
/* errno_t shutdown(fd_t sockfd, syscall_ulong_t how) */
.section .text.x86.asm64_syscall.shutdown
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_shutdown)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x30
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_shutdown)
	call   sys_shutdown
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_shutdown)

/* Bind the given socket `sockfd' to the specified local address.
 * @throw: E_NET_ADDRESS_IN_USE:E_NET_ADDRESS_IN_USE_CONTEXT_CONNECT
 * @throw: E_INVALID_ARGUMENT_UNEXPECTED_COMMAND:E_INVALID_ARGUMENT_CONTEXT_BIND_WRONG_ADDRESS_FAMILY
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_BIND_ALREADY_BOUND
 * @throw: E_NET_ADDRESS_NOT_AVAILABLE
 * @throw: E_BUFFER_TOO_SMALL   (`addr_len' is incorrect)
 * @return: 0 : Success */
/* errno_t bind(fd_t sockfd, struct sockaddr const *addr, socklen_t addr_len) */
.section .text.x86.asm64_syscall.bind
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_bind)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x31
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_bind)
	call   sys_bind
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_bind)

/* Begin to listen for incoming client (aka. peer) connection requests.
 * @param: max_backlog: The max number of clients  pending to be accept(2)-ed,  before
 *                      the kernel will refuse to enqueue additional clients, and will
 *                      instead automatically refuse  any further  requests until  the
 *                      less than `max_backlog' clients are still pending.
 * @throw: E_NET_ADDRESS_IN_USE:E_NET_ADDRESS_IN_USE_CONTEXT_LISTEN
 * @throw: E_INVALID_HANDLE_NET_OPERATION:E_NET_OPERATION_LISTEN
 * @return: 0 : Success */
/* errno_t listen(fd_t sockfd, syscall_ulong_t max_backlog) */
.section .text.x86.asm64_syscall.listen
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_listen)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x32
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_listen)
	call   sys_listen
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_listen)

/* Determine the local address (aka. name) for the given socket `sockfd'.
 * This  is usually the  same address as was  previously set by `bind(2)'
 * NOTE: Before the socket has actually be bound or connected, the exact
 *       address that is returned by this function is weakly  undefined.
 *       e.g.: For AF_INET, sin_addr=0.0.0.0, sin_port=0 is returned.
 * @param: addr:     [out] Buffer where to store the sock address.
 * @param: addr_len: [in]  The amount of available memory starting at `addr'
 *                   [out] The amount of required memory for the address.
 *                         This may be more than was given, in which case
 *                         the  address was truncated and may be invalid.
 * return: 0 : Success */
/* errno_t getsockname(fd_t sockfd, struct sockaddr *addr, socklen_t *addr_len) */
.section .text.x86.asm64_syscall.getsockname
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_getsockname)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x33
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_getsockname)
	call   sys_getsockname
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_getsockname)

/* Lookup the peer (remote) address of `sockfd' and store it in `*addr...+=*addr_len'
 * @param: addr:     [out] Buffer where to store the sock address.
 * @param: addr_len: [in]  The amount of available memory starting at `addr'
 *                   [out] The amount of required memory for the address.
 *                         This may be more than was given, in which case
 *                         the  address was truncated and may be invalid.
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_GETPEERNAME_NOT_CONNECTED
 * @return: 0 : Success */
/* errno_t getpeername(fd_t sockfd, struct sockaddr *addr, socklen_t *addr_len) */
.section .text.x86.asm64_syscall.getpeername
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_getpeername)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x34
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_getpeername)
	call   sys_getpeername
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_getpeername)

/* Create a new socket for the given domain/type/protocol triple.
 * @param: domain:   Socket address domain/family (one of `AF_*' from `<sys/socket.h>')
 * @param: type:     Socket type (one of `SOCK_*' from `<sys/socket.h>')
 *                   May optionally be or'd with `SOCK_CLOEXEC | SOCK_CLOFORK | SOCK_NONBLOCK'
 * @param: protocol: Socket protocol (`0' for automatic). Available socket protocols mainly
 *                   depend on the selected `domain', and may be further specialized by the
 *                   `type' argument.  for  example,  `AF_INET' takes  one  of  `IPPROTO_*'
 *                   >> socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
 *                   Also note that protocol IDs can be enumerated by `getprotoent(3)' from `<netdb.h>'
 * @return: * : A file descriptor for the newly created socket. */
/* errno_t socketpair(syscall_ulong_t domain, syscall_ulong_t type, syscall_ulong_t protocol, fd_t[2] fds) */
.section .text.x86.asm64_syscall.socketpair
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_socketpair)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x35
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_socketpair)
	call   sys_socketpair
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_socketpair)

/* Set the value of the named socket option `level:optname' from what is given in `optval'
 * @param: level:   One of `SOL_*' (e.g.: `SOL_SOCKET')
 * @param: optname: Dependent on `level'
 * @param: optval:  Buffer for where to write the value of the socket option.
 * @param: optlen:  The amount of available memory starting at `optval'
 * @throw: E_INVALID_ARGUMENT_SOCKET_OPT:E_INVALID_ARGUMENT_CONTEXT_SETSOCKOPT
 * @throw: E_BUFFER_TOO_SMALL  (The specified `optlen' is invalid for the given option)
 * @return: 0 : Success */
/* errno_t setsockopt(fd_t sockfd, syscall_ulong_t level, syscall_ulong_t optname, void const *optval, socklen_t optlen) */
.section .text.x86.asm64_syscall.setsockopt
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_setsockopt)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x36
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_setsockopt)
	call   sys_setsockopt
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_setsockopt)

/* Get the value of the named socket option `level:optname' and store it in `optval'
 * @param: level:   One of `SOL_*' (e.g.: `SOL_SOCKET')
 * @param: optname: Dependent on `level'
 * @param: optval:  Buffer for where to write the value of the socket option.
 * @param: optlen:  [in]  The amount of available memory starting at `optval'
 *                  [out] The amount of required memory for the option value.
 *                        This may be more than was given, in which case
 *                        the  contents  of   `optval'  are   undefined.
 * @throw: E_INVALID_ARGUMENT_SOCKET_OPT:E_INVALID_ARGUMENT_CONTEXT_GETSOCKOPT
 * @return: 0 : Success */
/* errno_t getsockopt(fd_t sockfd, syscall_ulong_t level, syscall_ulong_t optname, void *optval, socklen_t *optlen) */
.section .text.x86.asm64_syscall.getsockopt
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_getsockopt)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x37
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_getsockopt)
	call   sys_getsockopt
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_getsockopt)

/* pid_t clone(syscall_ulong_t flags, void *child_stack, pid_t *ptid, pid_t *ctid, uintptr_t newtls) */
.section .text.x86.asm64_syscall.clone
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_clone)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x38
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_clone)
	call   sys_clone
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_clone)

/* Clone the calling thread into a second process and return twice, once
 * in  the parent process where this function returns the (non-zero) PID
 * of  the forked child process, and a  second time in the child process
 * itself, where ZERO(0) is returned.
 * The child then usually proceeds by calling `exec(2)' to replace its
 * application image with  that of another  program that the  original
 * parent can then `wait(2)' for. (s.a. `vfork(2)')
 * @return: 0 : You're the new process that was created
 * @return: * : The `return' value is the pid of your new child process */
/* pid_t fork(void) */
.section .text.x86.asm64_syscall.fork
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_fork)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x39
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_fork)
	call   sys_fork
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_fork)

/* Same as `fork(2)', but the child process may be executed within in the same VM
 * as the parent process, with the  parent process remaining suspended until  the
 * child process invokes one of the following system calls:
 *   - `exit(2)'       Terminate the child process
 *   - `exit_group(2)' Terminate the child process
 *   - `execve(2)'     Create a new VM that is populated with the specified process
 *                     image. The parent process will  only be resumed in case  the
 *                     new  program image could  be loaded successfully. Otherwise,
 *                     the call  to  `execve(2)'  returns normally  in  the  child.
 *                     Other functions from the exec()-family behave the same
 * 
 * Care  must be taken when using this system call, since you have to make sure that
 * the  child process doesn't clobber any part of its (shared) stack that may be re-
 * used once execution resumes in  the parent process. The  same also goes for  heap
 * functions,  but generally speaking:  you really shouldn't  do anything that isn't
 * reentrant after calling any one of the fork() functions (since anything but would
 * rely on underlying implementations making proper use of pthread_atfork(3),  which
 * is something that KOS intentionally doesn't do,  since I feel like doing so  only
 * adds unnecessary bloat to code that doesn't rely on this)
 * 
 * Additionally, this system call may be implemented as an alias for `fork(2)', in
 * which  case the parent process will not  actually get suspended until the child
 * process performs any of the actions above. */
/* pid_t vfork(void) */
.section .text.x86.asm64_syscall.vfork
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_vfork)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x3a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_vfork)
	call   sys_vfork
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_vfork)

/* Replace the calling  process with  the application  image referred  to by  `path' /  `file'
 * and execute it's `main()' method, passing the given `argv', and setting `environ' to `envp' */
/* errno_t execve(char const *path, __HYBRID_PTR64(char const) const *argv, __HYBRID_PTR64(char const) const *envp) */
.section .text.x86.asm64_syscall.execve
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_execve)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x3b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_execve)
	call   sys_execve
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_execve)

/* Terminate the calling thread (_NOT_ process!)
 * @param: exit_code: Thread exit code (as returned by `wait(2)') */
/* void exit(syscall_ulong_t exit_code) */
.section .text.x86.asm64_syscall.exit
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_exit)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x3c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_exit)
	call   sys_exit
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_exit)

/* Same as `waitpid(pid, STAT_LOC, OPTIONS)', though also fills in `USAGE' when non-NULL
 * @param: options: Set of `WNOHANG | WUNTRACED | WCONTINUED' (as a KOS extension, `WNOWAIT' is also accepted) */
/* pid_t wait4(pid_t pid, int32_t *stat_loc, syscall_ulong_t options, struct rusagex64 *usage) */
.section .text.x86.asm64_syscall.wait4
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_wait4)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x3d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_wait4)
	call   sys_wait4
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_wait4)

/* errno_t kill(pid_t pid, signo_t signo) */
.section .text.x86.asm64_syscall.kill
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_kill)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x3e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_kill)
	call   sys_kill
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_kill)

/* errno_t uname(struct utsname *name) */
.section .text.x86.asm64_syscall.uname
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_uname)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x3f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_uname)
	call   sys_uname
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_uname)

/* errno_t semget(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.semget
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_semget)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x40
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_semget)
	call   sys_semget
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_semget)

/* errno_t semop(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.semop
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_semop)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x41
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_semop)
	call   sys_semop
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_semop)

/* errno_t semctl(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.semctl
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_semctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x42
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_semctl)
	call   sys_semctl
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_semctl)

/* errno_t shmdt(void const *shmaddr) */
.section .text.x86.asm64_syscall.shmdt
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_shmdt)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x43
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_shmdt)
	call   sys_shmdt
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_shmdt)

/* errno_t msgget(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.msgget
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_msgget)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x44
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_msgget)
	call   sys_msgget
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_msgget)

/* errno_t msgsnd(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.msgsnd
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_msgsnd)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x45
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_msgsnd)
	call   sys_msgsnd
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_msgsnd)

/* errno_t msgrcv(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.msgrcv
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_msgrcv)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x46
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_msgrcv)
	call   sys_msgrcv
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_msgrcv)

/* errno_t msgctl(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.msgctl
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_msgctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x47
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_msgctl)
	call   sys_msgctl
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_msgctl)

/* syscall_slong_t fcntl(fd_t fd, fcntl_t command, void *arg) */
.section .text.x86.asm64_syscall.fcntl
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_fcntl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x48
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_fcntl)
	call   sys_fcntl
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_fcntl)

/* errno_t flock(fd_t fd, syscall_ulong_t operation) */
.section .text.x86.asm64_syscall.flock
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_flock)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x49
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_flock)
	call   sys_flock
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_flock)

/* Synchronize a file (including its descriptor which contains timestamps, and its size),
 * meaning  that  changes   to  its   data  and/or   descriptor  are   written  to   disk */
/* errno_t fsync(fd_t fd) */
.section .text.x86.asm64_syscall.fsync
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_fsync)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x4a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_fsync)
	call   sys_fsync
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_fsync)

/* Synchronize only the data of a file (not its descriptor which contains
 * timestamps,  and its size),  meaning that changes  are written to disk */
/* errno_t fdatasync(fd_t fd) */
.section .text.x86.asm64_syscall.fdatasync
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_fdatasync)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x4b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_fdatasync)
	call   sys_fdatasync
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_fdatasync)

/* errno_t truncate(char const *filename, syscall_ulong_t length) */
.section .text.x86.asm64_syscall.truncate
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_truncate)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x4c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_truncate)
	call   sys_truncate
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_truncate)

/* errno_t ftruncate(fd_t fd, syscall_ulong_t length) */
.section .text.x86.asm64_syscall.ftruncate
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_ftruncate)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x4d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_ftruncate)
	call   sys_ftruncate
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_ftruncate)

/* @return: * : The actual number of read entries
 * @return: 0 : End-of-directory */
/* ssize_t getdents(fd_t fd, struct linux_direntx64 *buf, size_t buflen) */
.section .text.x86.asm64_syscall.getdents
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_getdents)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x4e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_getdents)
	call   sys_getdents
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_getdents)

/* ssize_t getcwd(char *buf, size_t size) */
.section .text.x86.asm64_syscall.getcwd
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_getcwd)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x4f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_getcwd)
	call   sys_getcwd
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_getcwd)

/* errno_t chdir(char const *path) */
.section .text.x86.asm64_syscall.chdir
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_chdir)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x50
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_chdir)
	call   sys_chdir
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_chdir)

/* errno_t fchdir(fd_t fd) */
.section .text.x86.asm64_syscall.fchdir
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_fchdir)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x51
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_fchdir)
	call   sys_fchdir
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_fchdir)

/* errno_t rename(char const *oldname, char const *newname_or_path) */
.section .text.x86.asm64_syscall.rename
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_rename)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x52
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_rename)
	call   sys_rename
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_rename)

/* errno_t mkdir(char const *pathname, mode_t mode) */
.section .text.x86.asm64_syscall.mkdir
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_mkdir)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x53
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_mkdir)
	call   sys_mkdir
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_mkdir)

/* errno_t rmdir(char const *path) */
.section .text.x86.asm64_syscall.rmdir
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_rmdir)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x54
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_rmdir)
	call   sys_rmdir
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_rmdir)

/* fd_t creat(char const *filename, mode_t mode) */
.section .text.x86.asm64_syscall.creat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_creat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x55
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_creat)
	call   sys_creat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_creat)

/* errno_t link(char const *existing_file, char const *link_file) */
.section .text.x86.asm64_syscall.link
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_link)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x56
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_link)
	call   sys_link
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_link)

/* errno_t unlink(char const *filename) */
.section .text.x86.asm64_syscall.unlink
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_unlink)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x57
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_unlink)
	call   sys_unlink
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_unlink)

/* errno_t symlink(char const *link_text, char const *target_path) */
.section .text.x86.asm64_syscall.symlink
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_symlink)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x58
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_symlink)
	call   sys_symlink
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_symlink)

/* ssize_t readlink(char const *path, char *buf, size_t buflen) */
.section .text.x86.asm64_syscall.readlink
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_readlink)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x59
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_readlink)
	call   sys_readlink
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_readlink)

/* errno_t chmod(char const *filename, mode_t mode) */
.section .text.x86.asm64_syscall.chmod
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_chmod)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x5a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_chmod)
	call   sys_chmod
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_chmod)

/* errno_t fchmod(fd_t fd, mode_t mode) */
.section .text.x86.asm64_syscall.fchmod
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_fchmod)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x5b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_fchmod)
	call   sys_fchmod
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_fchmod)

/* errno_t chown(char const *filename, uid_t owner, gid_t group) */
.section .text.x86.asm64_syscall.chown
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_chown)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x5c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_chown)
	call   sys_chown
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_chown)

/* errno_t fchown(fd_t fd, uid_t owner, gid_t group) */
.section .text.x86.asm64_syscall.fchown
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_fchown)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x5d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_fchown)
	call   sys_fchown
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_fchown)

/* errno_t lchown(char const *filename, uid_t owner, gid_t group) */
.section .text.x86.asm64_syscall.lchown
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_lchown)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x5e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_lchown)
	call   sys_lchown
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_lchown)

/* mode_t umask(mode_t mode) */
.section .text.x86.asm64_syscall.umask
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_umask)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x5f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_umask)
	call   sys_umask
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_umask)

/* errno_t gettimeofday(struct timevalx64 *tv, struct timezone *tz) */
.section .text.x86.asm64_syscall.gettimeofday
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_gettimeofday)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x60
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_gettimeofday)
	call   sys_gettimeofday
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_gettimeofday)

/* @param: resource: One of `RLIMIT_*' from <sys/resource.h> */
/* errno_t getrlimit(syscall_ulong_t resource, struct rlimitx64 *rlimits) */
.section .text.x86.asm64_syscall.getrlimit
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_getrlimit)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x61
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_getrlimit)
	call   sys_getrlimit
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_getrlimit)

/* @param: who: One of `RUSAGE_SELF', `RUSAGE_CHILDREN' or `RUSAGE_THREAD' */
/* errno_t getrusage(syscall_slong_t who, struct rusagex64 *tv) */
.section .text.x86.asm64_syscall.getrusage
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_getrusage)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x62
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_getrusage)
	call   sys_getrusage
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_getrusage)

/* errno_t sysinfo(struct __sysinfox64 *info) */
.section .text.x86.asm64_syscall.sysinfo
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_sysinfo)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x63
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_sysinfo)
	call   sys_sysinfo
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_sysinfo)

/* clock_t times(struct tmsx64 *buf) */
.section .text.x86.asm64_syscall.times
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_times)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x64
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_times)
	call   sys_times
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_times)

/* syscall_slong_t ptrace(syscall_ulong_t request, pid_t pid, void *addr, void *data) */
.section .text.x86.asm64_syscall.ptrace
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_ptrace)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x65
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_ptrace)
	call   sys_ptrace
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_ptrace)

/* >> getuid(2)
 * @return: * : The UID of the calling thread (this is the so-called ~real~ UID) */
/* uid_t getuid(void) */
.section .text.x86.asm64_syscall.getuid
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_getuid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x66
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_getuid)
	call   sys_getuid
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_getuid)

/* ssize_t syslog(syscall_ulong_t level, char const *str, size_t len) */
.section .text.x86.asm64_syscall.syslog
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_syslog)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x67
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_syslog)
	call   sys_syslog
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_syslog)

/* >> getgid(2)
 * @return: * : The GID of the calling thread (this is the so-called ~real~ GID) */
/* gid_t getgid(void) */
.section .text.x86.asm64_syscall.getgid
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_getgid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x68
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_getgid)
	call   sys_getgid
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_getgid)

/* >> setuid(2)
 * Set the UID of the calling thread (this is the so-called ~real~ UID)
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setuid(uid_t uid) */
.section .text.x86.asm64_syscall.setuid
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_setuid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x69
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_setuid)
	call   sys_setuid
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_setuid)

/* >> setgid(2)
 * Set the GID of the calling thread (this is the so-called ~real~ GID)
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setgid(gid_t gid) */
.section .text.x86.asm64_syscall.setgid
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_setgid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x6a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_setgid)
	call   sys_setgid
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_setgid)

/* >> geteuid(2)
 * @return: * : The   effective  UID  of  the  calling  thread.
 *              This is the one used for most permission checks */
/* uid_t geteuid(void) */
.section .text.x86.asm64_syscall.geteuid
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_geteuid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x6b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_geteuid)
	call   sys_geteuid
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_geteuid)

/* >> getegid(2)
 * @return: * : The   effective  GID  of  the  calling  thread.
 *              This is the one used for most permission checks */
/* gid_t getegid(void) */
.section .text.x86.asm64_syscall.getegid
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_getegid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x6c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_getegid)
	call   sys_getegid
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_getegid)

/* errno_t setpgid(pid_t pid, pid_t pgid) */
.section .text.x86.asm64_syscall.setpgid
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_setpgid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x6d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_setpgid)
	call   sys_setpgid
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_setpgid)

/* pid_t getppid(void) */
.section .text.x86.asm64_syscall.getppid
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_getppid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x6e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_getppid)
	call   sys_getppid
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_getppid)

/* pid_t getpgrp(void) */
.section .text.x86.asm64_syscall.getpgrp
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_getpgrp)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x6f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_getpgrp)
	call   sys_getpgrp
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_getpgrp)

/* pid_t setsid(void) */
.section .text.x86.asm64_syscall.setsid
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_setsid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x70
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_setsid)
	call   sys_setsid
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_setsid)

/* >> setreuid(2)
 * Set the real and effective UID of the calling thread.
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setreuid(uid_t ruid, uid_t euid) */
.section .text.x86.asm64_syscall.setreuid
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_setreuid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x71
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_setreuid)
	call   sys_setreuid
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_setreuid)

/* >> setregid(2)
 * Set the real and effective GID of the calling thread.
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setregid(gid_t rgid, gid_t egid) */
.section .text.x86.asm64_syscall.setregid
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_setregid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x72
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_setregid)
	call   sys_setregid
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_setregid)

/* @return: * :     [count == 0] The required number of groups
 * @return: * :     [count != 0] The number of groups that were actually returned
 * @throw: -EINVAL: [count != 0] There are more than `count' groups (NOTE: No exception is thrown for this case!) */
/* ssize_t getgroups(size_t count, gid_t[] list) */
.section .text.x86.asm64_syscall.getgroups
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_getgroups)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x73
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_getgroups)
	call   sys_getgroups
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_getgroups)

/* errno_t setgroups(size_t count, gid_t const *groups) */
.section .text.x86.asm64_syscall.setgroups
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_setgroups)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x74
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_setgroups)
	call   sys_setgroups
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_setgroups)

/* >> setresuid(2)
 * @return: 0 : Success
 * Set the real, effective, and saved UID of the calling thread.
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setresuid(uid_t ruid, uid_t euid, uid_t suid) */
.section .text.x86.asm64_syscall.setresuid
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_setresuid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x75
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_setresuid)
	call   sys_setresuid
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_setresuid)

/* >> getresuid(2)
 * Get the real, effective, and saved UID of the calling thread.
 * @return: 0 : Success */
/* errno_t getresuid(uid_t *ruid, uid_t *euid, uid_t *suid) */
.section .text.x86.asm64_syscall.getresuid
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_getresuid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x76
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_getresuid)
	call   sys_getresuid
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_getresuid)

/* >> setresgid(2)
 * Set the real, effective, and saved GID of the calling thread.
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setresgid(gid_t rgid, gid_t egid, gid_t sgid) */
.section .text.x86.asm64_syscall.setresgid
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_setresgid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x77
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_setresgid)
	call   sys_setresgid
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_setresgid)

/* >> getresgid(2)
 * Get the real, effective, and saved GID of the calling thread.
 * @return: 0 : Success */
/* errno_t getresgid(gid_t *rgid, gid_t *egid, gid_t *sgid) */
.section .text.x86.asm64_syscall.getresgid
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_getresgid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x78
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_getresgid)
	call   sys_getresgid
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_getresgid)

/* pid_t getpgid(pid_t pid) */
.section .text.x86.asm64_syscall.getpgid
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_getpgid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x79
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_getpgid)
	call   sys_getpgid
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_getpgid)

/* >> setfsuid(2)
 * Set the  user ID  for the  cred-context (s.a.  `CLONE_CRED') of  the
 * calling thread. The calling thread needs the `CAP_SETUID' privilege.
 * @return: 0:  Success.
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setfsuid(uid_t uid) */
.section .text.x86.asm64_syscall.setfsuid
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_setfsuid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x7a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_setfsuid)
	call   sys_setfsuid
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_setfsuid)

/* >> setfsgid(2)
 * Set the group  ID for  the cred-context (s.a.  `CLONE_CRED') of  the
 * calling thread. The calling thread needs the `CAP_SETGID' privilege.
 * @return: 0:  Success.
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setfsgid(gid_t gid) */
.section .text.x86.asm64_syscall.setfsgid
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_setfsgid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x7b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_setfsgid)
	call   sys_setfsgid
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_setfsgid)

/* pid_t getsid(pid_t pid) */
.section .text.x86.asm64_syscall.getsid
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_getsid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x7c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_getsid)
	call   sys_getsid
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_getsid)

/* errno_t capget(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.capget
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_capget)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x7d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_capget)
	call   sys_capget
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_capget)

/* errno_t capset(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.capset
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_capset)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x7e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_capset)
	call   sys_capset
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_capset)

/* errno_t rt_sigpending(struct __sigset_struct *set, size_t sigsetsize) */
.section .text.x86.asm64_syscall.rt_sigpending
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_rt_sigpending)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x7f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_rt_sigpending)
	call   sys_rt_sigpending
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_rt_sigpending)

/* syscall_slong_t rt_sigtimedwait(struct __sigset_struct const *set, struct __siginfox64_struct *info, struct timespecx64 const *timeout, size_t sigsetsize) */
.section .text.x86.asm64_syscall.rt_sigtimedwait
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_rt_sigtimedwait)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x80
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_rt_sigtimedwait)
	call   sys_rt_sigtimedwait
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_rt_sigtimedwait)

/* @param: usigno: The signal that should be sent
 * @param: uinfo:  [0..1] Additional signal information
 * @throw: E_INVALID_ARGUMENT_UNEXPECTED_COMMAND:E_INVALID_ARGUMENT_CONTEXT_SIGINFO_SIGNO: [...]
 * @throw: E_INVALID_ARGUMENT_BAD_VALUE:E_INVALID_ARGUMENT_CONTEXT_BAD_SIGNO:              [...]
 * @throw: E_INVALID_ARGUMENT_BAD_VALUE:E_INVALID_ARGUMENT_CONTEXT_RAISE_SIGINFO_BADCODE:  [...]
 * @throw: E_ILLEGAL_OPERATION:                                                            [...] */
/* errno_t rt_sigqueueinfo(pid_t pid, signo_t usigno, struct __siginfox64_struct const *uinfo) */
.section .text.x86.asm64_syscall.rt_sigqueueinfo
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_rt_sigqueueinfo)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x81
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_rt_sigqueueinfo)
	call   sys_rt_sigqueueinfo
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_rt_sigqueueinfo)

/* >> sigsuspend(2), rt_sigsuspend(2)
 * Atomically save and  set the caller's  signal mask to  `set', then wait  for
 * one of the unmasked (iow: `!sigismember')-signals to arrive before restoring
 * the old signal mask.
 * @param: set: The set of signals on which to wait
 * @return: -1: [errno=EINTR] The signal handler for `signo' was executed. */
/* errno_t rt_sigsuspend(struct __sigset_struct const *set, size_t sigsetsize) */
.section .text.x86.asm64_syscall.rt_sigsuspend
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_rt_sigsuspend)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x82
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_rt_sigsuspend)
	call   sys_rt_sigsuspend
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_rt_sigsuspend)

/* errno_t sigaltstack(struct __sigaltstackx64 const *ss, struct __sigaltstackx64 *oss) */
.section .text.x86.asm64_syscall.sigaltstack
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_sigaltstack)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x83
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_sigaltstack)
	call   sys_sigaltstack
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_sigaltstack)

/* @param: times: When NULL, set the current time */
/* errno_t utime(char const *filename, struct utimbufx64 const *times) */
.section .text.x86.asm64_syscall.utime
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_utime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x84
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_utime)
	call   sys_utime
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_utime)

/* errno_t mknod(char const *nodename, mode_t mode, dev_t dev) */
.section .text.x86.asm64_syscall.mknod
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_mknod)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x85
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_mknod)
	call   sys_mknod
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_mknod)

/* errno_t uselib(char const *library) */
.section .text.x86.asm64_syscall.uselib
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_uselib)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x86
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_uselib)
	call   sys_uselib
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_uselib)

/* errno_t personality(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.personality
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_personality)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x87
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_personality)
	call   sys_personality
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_personality)

/* errno_t ustat(dev_t dev, struct ustat *ubuf) */
.section .text.x86.asm64_syscall.ustat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_ustat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x88
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_ustat)
	call   sys_ustat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_ustat)

/* errno_t statfs(char const *file, struct statfsx64 *buf) */
.section .text.x86.asm64_syscall.statfs
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_statfs)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x89
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_statfs)
	call   sys_statfs
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_statfs)

/* errno_t fstatfs(fd_t file, struct statfsx64 *buf) */
.section .text.x86.asm64_syscall.fstatfs
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_fstatfs)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x8a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_fstatfs)
	call   sys_fstatfs
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_fstatfs)

/* errno_t sysfs(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.sysfs
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_sysfs)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x8b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_sysfs)
	call   sys_sysfs
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_sysfs)

/* @param: which: One of `PRIO_PROCESS', `PRIO_PGRP' or `PRIO_USER' */
/* syscall_slong_t getpriority(syscall_ulong_t which, id_t who) */
.section .text.x86.asm64_syscall.getpriority
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_getpriority)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x8c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_getpriority)
	call   sys_getpriority
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_getpriority)

/* @param: which: One of `PRIO_PROCESS', `PRIO_PGRP' or `PRIO_USER' */
/* errno_t setpriority(syscall_ulong_t which, id_t who, syscall_ulong_t value) */
.section .text.x86.asm64_syscall.setpriority
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_setpriority)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x8d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_setpriority)
	call   sys_setpriority
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_setpriority)

/* errno_t sched_setparam(pid_t pid, struct sched_param const *param) */
.section .text.x86.asm64_syscall.sched_setparam
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_sched_setparam)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x8e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_sched_setparam)
	call   sys_sched_setparam
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_sched_setparam)

/* errno_t sched_getparam(pid_t pid, struct sched_param *param) */
.section .text.x86.asm64_syscall.sched_getparam
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_sched_getparam)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x8f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_sched_getparam)
	call   sys_sched_getparam
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_sched_getparam)

/* @param: policy: One of `SCHED_OTHER', `SCHED_FIFO', `SCHED_RR', `SCHED_BATCH',
 *                 `SCHED_IDLE',  optionally   or'd  with   `SCHED_RESET_ON_FORK' */
/* errno_t sched_setscheduler(pid_t pid, syscall_ulong_t policy, struct sched_param const *param) */
.section .text.x86.asm64_syscall.sched_setscheduler
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_sched_setscheduler)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x90
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_sched_setscheduler)
	call   sys_sched_setscheduler
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_sched_setscheduler)

/* syscall_slong_t sched_getscheduler(pid_t pid) */
.section .text.x86.asm64_syscall.sched_getscheduler
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_sched_getscheduler)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x91
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_sched_getscheduler)
	call   sys_sched_getscheduler
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_sched_getscheduler)

/* syscall_slong_t sched_get_priority_max(syscall_ulong_t algorithm) */
.section .text.x86.asm64_syscall.sched_get_priority_max
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_sched_get_priority_max)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x92
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_sched_get_priority_max)
	call   sys_sched_get_priority_max
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_sched_get_priority_max)

/* syscall_slong_t sched_get_priority_min(syscall_ulong_t algorithm) */
.section .text.x86.asm64_syscall.sched_get_priority_min
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_sched_get_priority_min)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x93
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_sched_get_priority_min)
	call   sys_sched_get_priority_min
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_sched_get_priority_min)

/* errno_t sched_rr_get_interval(pid_t pid, struct timespecx64 *ts) */
.section .text.x86.asm64_syscall.sched_rr_get_interval
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_sched_rr_get_interval)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x94
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_sched_rr_get_interval)
	call   sys_sched_rr_get_interval
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_sched_rr_get_interval)

/* errno_t mlock(void const *addr, size_t len) */
.section .text.x86.asm64_syscall.mlock
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_mlock)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x95
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_mlock)
	call   sys_mlock
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_mlock)

/* errno_t munlock(void const *addr, size_t len) */
.section .text.x86.asm64_syscall.munlock
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_munlock)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x96
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_munlock)
	call   sys_munlock
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_munlock)

/* @param: flags: Set of `MCL_CURRENT | MCL_FUTURE | MCL_ONFAULT' */
/* errno_t mlockall(syscall_ulong_t flags) */
.section .text.x86.asm64_syscall.mlockall
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_mlockall)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x97
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_mlockall)
	call   sys_mlockall
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_mlockall)

/* errno_t munlockall(void) */
.section .text.x86.asm64_syscall.munlockall
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_munlockall)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x98
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_munlockall)
	call   sys_munlockall
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_munlockall)

/* errno_t vhangup(void) */
.section .text.x86.asm64_syscall.vhangup
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_vhangup)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x99
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_vhangup)
	call   sys_vhangup
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_vhangup)

/* syscall_slong_t modify_ldt(syscall_ulong_t func, void *ptr, syscall_ulong_t bytecount) */
.section .text.x86.asm64_syscall.modify_ldt
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_modify_ldt)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x9a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_modify_ldt)
	call   sys_modify_ldt
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_modify_ldt)

/* errno_t pivot_root(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.pivot_root
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_pivot_root)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x9b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_pivot_root)
	call   sys_pivot_root
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_pivot_root)

/* errno_t _sysctl(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall._sysctl
INTERN_WEAK_FUNCTION(__x86_asm64_syscall__sysctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x9c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys__sysctl)
	call   sys__sysctl
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall__sysctl)

/* >> prctl(2)
 * System process control interface. (Linux compatible)
 * @param: command: One of `PR_*' (from <linux/prctl.h>)
 * @param: ... : Up  to 4 additional arguments (dependent on `command')
 *               Note that some control codes  require you to pass  `0'
 *               for  all seemingly "unused" arguments. In these cases,
 *               the documentation for that command includes the number
 *               of unused, but required trailing 0s in its comment.
 * @return: * :  Return value depends on `command' */
/* syscall_slong_t prctl(unsigned int command, syscall_ulong_t arg2, syscall_ulong_t arg3, syscall_ulong_t arg4, syscall_ulong_t arg5) */
.section .text.x86.asm64_syscall.prctl
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_prctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x9d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_prctl)
	call   sys_prctl
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_prctl)

/* >> arch_prctl(2)
 * Arch-dependent system process control interface. (But don't go and
 * think that the  normal `prctl(2)'  doesn't feature  arch-dependent
 * commands  -- honestly, this syscall shouldn't exist if you ask me,
 * but it does on linux, and so it must also on KOS...)
 * @param: command: One of `ARCH_*' (from <asm/prctl.h>)
 * @param: addr: Either a `syscall_ulong_t' or `syscall_ulong_t *', depending on `command'
 * @return: * :  Return value depends on `command' */
/* syscall_slong_t arch_prctl(unsigned int command, uint64_t *addr) */
.section .text.x86.asm64_syscall.arch_prctl
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_arch_prctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x9e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_arch_prctl)
	call   sys_arch_prctl
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_arch_prctl)

/* errno_t adjtimex(struct timex *ntx) */
.section .text.x86.asm64_syscall.adjtimex
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_adjtimex)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x9f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_adjtimex)
	call   sys_adjtimex
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_adjtimex)

/* @param: resource: One of `RLIMIT_*' from <sys/resource.h> */
/* errno_t setrlimit(syscall_ulong_t resource, struct rlimitx64 const *rlimits) */
.section .text.x86.asm64_syscall.setrlimit
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_setrlimit)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xa0
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_setrlimit)
	call   sys_setrlimit
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_setrlimit)

/* errno_t chroot(char const *path) */
.section .text.x86.asm64_syscall.chroot
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_chroot)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xa1
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_chroot)
	call   sys_chroot
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_chroot)

/* errno_t sync(void) */
.section .text.x86.asm64_syscall.sync
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_sync)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xa2
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_sync)
	call   sys_sync
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_sync)

/* errno_t acct(char const *filename) */
.section .text.x86.asm64_syscall.acct
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_acct)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xa3
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_acct)
	call   sys_acct
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_acct)

/* errno_t settimeofday(struct timevalx64 const *tv, struct timezone const *tz) */
.section .text.x86.asm64_syscall.settimeofday
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_settimeofday)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xa4
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_settimeofday)
	call   sys_settimeofday
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_settimeofday)

/* errno_t mount(char const *special_file, char const *dir, char const *fstype, syscall_ulong_t mountflags, void const *data) */
.section .text.x86.asm64_syscall.mount
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_mount)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xa5
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_mount)
	call   sys_mount
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_mount)

/* errno_t umount2(char const *special_file, syscall_ulong_t flags) */
.section .text.x86.asm64_syscall.umount2
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_umount2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xa6
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_umount2)
	call   sys_umount2
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_umount2)

/* @param: swapflags: Set of `SWAP_FLAG_*' */
/* errno_t swapon(char const *pathname, syscall_ulong_t swapflags) */
.section .text.x86.asm64_syscall.swapon
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_swapon)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xa7
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_swapon)
	call   sys_swapon
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_swapon)

/* errno_t swapoff(char const *pathname) */
.section .text.x86.asm64_syscall.swapoff
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_swapoff)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xa8
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_swapoff)
	call   sys_swapoff
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_swapoff)

/* @param: how: One of the `RB_*' constants from <sys/reboot.h> */
/* errno_t reboot(syscall_ulong_t how) */
.section .text.x86.asm64_syscall.reboot
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_reboot)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xa9
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_reboot)
	call   sys_reboot
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_reboot)

/* errno_t sethostname(char const *name, size_t len) */
.section .text.x86.asm64_syscall.sethostname
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_sethostname)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xaa
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_sethostname)
	call   sys_sethostname
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_sethostname)

/* errno_t setdomainname(char const *name, size_t len) */
.section .text.x86.asm64_syscall.setdomainname
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_setdomainname)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xab
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_setdomainname)
	call   sys_setdomainname
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_setdomainname)

/* errno_t iopl(syscall_ulong_t level) */
.section .text.x86.asm64_syscall.iopl
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_iopl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xac
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_iopl)
	call   sys_iopl
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_iopl)

/* errno_t ioperm(syscall_ulong_t from, syscall_ulong_t num, syscall_ulong_t turn_on) */
.section .text.x86.asm64_syscall.ioperm
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_ioperm)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xad
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_ioperm)
	call   sys_ioperm
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_ioperm)

/* errno_t create_module(void) */
.section .text.x86.asm64_syscall.create_module
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_create_module)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xae
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_create_module)
	call   sys_create_module
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_create_module)

/* Load a  kernel  driver  from an  ELF  image  `module_image...+=len'
 * This system call exists for linux compatibility, and is implemented
 * as an alias for  `KSYSCTL_DRIVER_INSMOD:KSYSCTL_DRIVER_FORMAT_BLOB'
 * 
 * Note however that that is where linux compatibility ends. Since the
 * linux kernel does not implement any semblance of a stable ABI,  you
 * have to realize that on KOS, this system call can only load drivers
 * specifically built to run within the KOS kernel!
 * @param: uargs: The driver commandline */
/* errno_t init_module(void const *module_image, size_t len, char const *uargs) */
.section .text.x86.asm64_syscall.init_module
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_init_module)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xaf
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_init_module)
	call   sys_init_module
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_init_module)

/* Try to unload a driver, given its `name'
 * This system call exists for linux compatibility, and is implemented
 * as an alias for  `KSYSCTL_DRIVER_DELMOD:KSYSCTL_DRIVER_FORMAT_FILE'
 * @param: name:  The name of the driver
 * @param: flags: Set of `O_NONBLOCK | O_TRUNC', where:
 *                - O_NONBLOCK: s.a. `KSYSCTL_DRIVER_DELMOD_FNONBLOCK'
 *                - O_TRUNC:    s.a. `KSYSCTL_DRIVER_DELMOD_FFORCE' */
/* errno_t delete_module(char const *name, oflag_t flags) */
.section .text.x86.asm64_syscall.delete_module
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_delete_module)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xb0
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_delete_module)
	call   sys_delete_module
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_delete_module)

/* errno_t get_kernel_syms(void) */
.section .text.x86.asm64_syscall.get_kernel_syms
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_get_kernel_syms)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xb1
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_get_kernel_syms)
	call   sys_get_kernel_syms
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_get_kernel_syms)

/* errno_t query_module(void) */
.section .text.x86.asm64_syscall.query_module
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_query_module)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xb2
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_query_module)
	call   sys_query_module
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_query_module)

/* errno_t quotactl(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.quotactl
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_quotactl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xb3
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_quotactl)
	call   sys_quotactl
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_quotactl)

/* errno_t nfsservctl(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.nfsservctl
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_nfsservctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xb4
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_nfsservctl)
	call   sys_nfsservctl
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_nfsservctl)

/* errno_t getpmsg(void) */
.section .text.x86.asm64_syscall.getpmsg
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_getpmsg)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xb5
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_getpmsg)
	call   sys_getpmsg
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_getpmsg)

/* errno_t putpmsg(void) */
.section .text.x86.asm64_syscall.putpmsg
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_putpmsg)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xb6
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_putpmsg)
	call   sys_putpmsg
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_putpmsg)

/* errno_t afs_syscall(void) */
.section .text.x86.asm64_syscall.afs_syscall
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_afs_syscall)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xb7
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_afs_syscall)
	call   sys_afs_syscall
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_afs_syscall)

/* errno_t tuxcall(void) */
.section .text.x86.asm64_syscall.tuxcall
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_tuxcall)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xb8
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_tuxcall)
	call   sys_tuxcall
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_tuxcall)

/* errno_t security(void) */
.section .text.x86.asm64_syscall.security
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_security)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xb9
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_security)
	call   sys_security
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_security)

/* pid_t gettid(void) */
.section .text.x86.asm64_syscall.gettid
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_gettid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xba
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_gettid)
	call   sys_gettid
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_gettid)

/* ssize_t readahead(fd_t fd, uint64_t offset, size_t count) */
.section .text.x86.asm64_syscall.readahead
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_readahead)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xbb
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_readahead)
	call   sys_readahead
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_readahead)

/* @param: flags: One of `0', `XATTR_CREATE' or `XATTR_REPLACE' */
/* errno_t setxattr(char const *path, char const *name, void const *buf, size_t bufsize, syscall_ulong_t flags) */
.section .text.x86.asm64_syscall.setxattr
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_setxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xbc
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_setxattr)
	call   sys_setxattr
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_setxattr)

/* @param: flags: One of `0', `XATTR_CREATE' or `XATTR_REPLACE' */
/* errno_t lsetxattr(char const *path, char const *name, void const *buf, size_t bufsize, syscall_ulong_t flags) */
.section .text.x86.asm64_syscall.lsetxattr
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_lsetxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xbd
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_lsetxattr)
	call   sys_lsetxattr
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_lsetxattr)

/* @param: flags: One of `0', `XATTR_CREATE' or `XATTR_REPLACE' */
/* errno_t fsetxattr(fd_t fd, char const *name, void const *buf, size_t bufsize, syscall_ulong_t flags) */
.section .text.x86.asm64_syscall.fsetxattr
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_fsetxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xbe
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_fsetxattr)
	call   sys_fsetxattr
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_fsetxattr)

/* ssize_t getxattr(char const *path, char const *name, void *buf, size_t bufsize) */
.section .text.x86.asm64_syscall.getxattr
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_getxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xbf
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_getxattr)
	call   sys_getxattr
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_getxattr)

/* ssize_t lgetxattr(char const *path, char const *name, void *buf, size_t bufsize) */
.section .text.x86.asm64_syscall.lgetxattr
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_lgetxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xc0
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_lgetxattr)
	call   sys_lgetxattr
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_lgetxattr)

/* ssize_t fgetxattr(fd_t fd, char const *name, void *buf, size_t bufsize) */
.section .text.x86.asm64_syscall.fgetxattr
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_fgetxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xc1
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_fgetxattr)
	call   sys_fgetxattr
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_fgetxattr)

/* ssize_t listxattr(char const *path, char *listbuf, size_t listbufsize) */
.section .text.x86.asm64_syscall.listxattr
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_listxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xc2
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_listxattr)
	call   sys_listxattr
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_listxattr)

/* ssize_t llistxattr(char const *path, char *listbuf, size_t listbufsize) */
.section .text.x86.asm64_syscall.llistxattr
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_llistxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xc3
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_llistxattr)
	call   sys_llistxattr
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_llistxattr)

/* ssize_t flistxattr(fd_t fd, char *listbuf, size_t listbufsize) */
.section .text.x86.asm64_syscall.flistxattr
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_flistxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xc4
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_flistxattr)
	call   sys_flistxattr
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_flistxattr)

/* errno_t removexattr(char const *path, char const *name) */
.section .text.x86.asm64_syscall.removexattr
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_removexattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xc5
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_removexattr)
	call   sys_removexattr
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_removexattr)

/* errno_t lremovexattr(char const *path, char const *name) */
.section .text.x86.asm64_syscall.lremovexattr
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_lremovexattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xc6
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_lremovexattr)
	call   sys_lremovexattr
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_lremovexattr)

/* errno_t fremovexattr(fd_t fd, char const *name) */
.section .text.x86.asm64_syscall.fremovexattr
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_fremovexattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xc7
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_fremovexattr)
	call   sys_fremovexattr
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_fremovexattr)

/* errno_t tkill(pid_t tid, signo_t signo) */
.section .text.x86.asm64_syscall.tkill
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_tkill)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xc8
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_tkill)
	call   sys_tkill
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_tkill)

/* time32_t time(time32_t *timer) */
.section .text.x86.asm64_syscall.time
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_time)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xc9
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_time)
	call   sys_time
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_time)

/* @param: futex_op: One of `FUTEX_*' from <linux/futex.h> */
/* syscall_slong_t futex(uint32_t *uaddr, syscall_ulong_t futex_op, uint32_t val, struct timespecx64 const *timeout_or_val2, uint32_t *uaddr2, uint32_t val3) */
.section .text.x86.asm64_syscall.futex
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_futex)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xca
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_futex)
	call   sys_futex
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_futex)

/* errno_t sched_setaffinity(pid_t pid, size_t cpusetsize, struct __cpu_set_struct const *cpuset) */
.section .text.x86.asm64_syscall.sched_setaffinity
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_sched_setaffinity)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xcb
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_sched_setaffinity)
	call   sys_sched_setaffinity
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_sched_setaffinity)

/* errno_t sched_getaffinity(pid_t pid, size_t cpusetsize, struct __cpu_set_struct *cpuset) */
.section .text.x86.asm64_syscall.sched_getaffinity
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_sched_getaffinity)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xcc
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_sched_getaffinity)
	call   sys_sched_getaffinity
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_sched_getaffinity)

/* errno_t set_thread_area(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.set_thread_area
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_set_thread_area)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xcd
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_set_thread_area)
	call   sys_set_thread_area
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_set_thread_area)

/* errno_t io_setup(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.io_setup
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_io_setup)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xce
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_io_setup)
	call   sys_io_setup
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_io_setup)

/* errno_t io_destroy(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.io_destroy
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_io_destroy)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xcf
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_io_destroy)
	call   sys_io_destroy
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_io_destroy)

/* errno_t io_getevents(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.io_getevents
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_io_getevents)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xd0
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_io_getevents)
	call   sys_io_getevents
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_io_getevents)

/* errno_t io_submit(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.io_submit
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_io_submit)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xd1
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_io_submit)
	call   sys_io_submit
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_io_submit)

/* errno_t io_cancel(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.io_cancel
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_io_cancel)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xd2
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_io_cancel)
	call   sys_io_cancel
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_io_cancel)

/* errno_t get_thread_area(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.get_thread_area
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_get_thread_area)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xd3
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_get_thread_area)
	call   sys_get_thread_area
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_get_thread_area)

/* errno_t lookup_dcookie(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.lookup_dcookie
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_lookup_dcookie)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xd4
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_lookup_dcookie)
	call   sys_lookup_dcookie
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_lookup_dcookie)

/* >> epoll_create(2)
 * Deprecated alias for `epoll_create1(0)' (the `size' argument is ignored)
 * @return: * : The newly created epoll control descriptor.
 * @return: -1: Error (s.a. `errno') */
/* fd_t epoll_create(syscall_ulong_t size) */
.section .text.x86.asm64_syscall.epoll_create
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_epoll_create)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xd5
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_epoll_create)
	call   sys_epoll_create
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_epoll_create)

/* >> epoll_ctl(2)
 * Manipulate a given  epoll controller  `epfd', as previously  returned by  `epoll_create1(2)'
 * in order to register (`EPOLL_CTL_ADD'), remove (`EPOLL_CTL_DEL') or modify (`EPOLL_CTL_MOD')
 * the file descriptors being monitored
 * @param: op:       One of `EPOLL_CTL_ADD', `EPOLL_CTL_DEL' or `EPOLL_CTL_MOD'
 * @param: fd:       The file descriptor to add/remove/modify
 * @param: info:     The new configuration for `fd' (ignored when `op' is `EPOLL_CTL_DEL')
 * @return: 0 :      Success
 * @return: -EEXIST: [op=EPOLL_CTL_ADD] The given `fd' (and its kernel object) has already been registered
 * @return: -ENOENT: [op=EPOLL_CTL_MOD|EPOLL_CTL_DEL] The given `fd' (and its kernel object) aren't registered
 * @throw: E_ILLEGAL_REFERENCE_LOOP: The  given  `fd'  is  another  epoll  that either
 *                                   forms a loop with `epfd', or has too many nested.
 * @throw: E_INVALID_ARGUMENT_UNKNOWN_COMMAND:E_INVALID_ARGUMENT_CONTEXT_EPOLL_CTL_OP: [...] */
/* errno_t epoll_ctl_old(fd_t epfd, syscall_ulong_t op, fd_t fd, struct epoll_event *info) */
.section .text.x86.asm64_syscall.epoll_ctl_old
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_epoll_ctl_old)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xd6
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_epoll_ctl_old)
	call   sys_epoll_ctl_old
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_epoll_ctl_old)

/* >> epoll_wait(2)
 * Wait until at least one of the conditions monitored by `epfd' to be met.
 * @param: epfd:      The epoll controller on which to wait.
 * @param: events:    A buffer where the kernel can store information on the
 *                    events that actually took place.
 * @param: maxevents: The # of events that can be stored in `events' (must be >= 1)
 * @param: timeout:   The max amount of time (in milliseconds) before  returning
 *                    in the case where no event occurred in the mean time. When
 *                    set to `-1', wait indefinitely
 * @return: >= 1:     The # of events that happened (written to the first `return'
 *                    items of `events')
 * @return: 0:        No events happened before `timeout' expired.
 * @return: -1:       Error (s.a. `errno') */
/* ssize_t epoll_wait_old(fd_t epfd, struct epoll_event *events, size_t maxevents, syscall_slong_t timeout) */
.section .text.x86.asm64_syscall.epoll_wait_old
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_epoll_wait_old)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xd7
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_epoll_wait_old)
	call   sys_epoll_wait_old
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_epoll_wait_old)

/* errno_t remap_file_pages(void *start, size_t size, syscall_ulong_t prot, size_t pgoff, syscall_ulong_t flags) */
.section .text.x86.asm64_syscall.remap_file_pages
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_remap_file_pages)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xd8
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_remap_file_pages)
	call   sys_remap_file_pages
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_remap_file_pages)

/* @return: * : The actual number of read entries
 * @return: 0 : End-of-directory */
/* ssize_t getdents64(fd_t fd, struct linux_dirent64 *buf, size_t buflen) */
.section .text.x86.asm64_syscall.getdents64
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_getdents64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xd9
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_getdents64)
	call   sys_getdents64
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_getdents64)

/* pid_t set_tid_address(pid_t *tidptr) */
.section .text.x86.asm64_syscall.set_tid_address
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_set_tid_address)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xda
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_set_tid_address)
	call   sys_set_tid_address
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_set_tid_address)

/* errno_t restart_syscall(void) */
.section .text.x86.asm64_syscall.restart_syscall
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_restart_syscall)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xdb
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_restart_syscall)
	call   sys_restart_syscall
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_restart_syscall)

/* errno_t semtimedop(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.semtimedop
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_semtimedop)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xdc
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_semtimedop)
	call   sys_semtimedop
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_semtimedop)

/* errno_t fadvise64(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.fadvise64
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_fadvise64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xdd
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_fadvise64)
	call   sys_fadvise64
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_fadvise64)

/* errno_t timer_create(clockid_t clock_id, struct sigevent *evp, timer_t *timerid) */
.section .text.x86.asm64_syscall.timer_create
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_timer_create)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xde
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_timer_create)
	call   sys_timer_create
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_timer_create)

/* @param: flags: Set of `0 | TIMER_ABSTIME' */
/* errno_t timer_settime(timer_t timerid, syscall_ulong_t flags, struct itimerspecx64 const *value, struct itimerspecx64 *ovalue) */
.section .text.x86.asm64_syscall.timer_settime
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_timer_settime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xdf
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_timer_settime)
	call   sys_timer_settime
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_timer_settime)

/* errno_t timer_gettime(timer_t timerid, struct itimerspecx64 *value) */
.section .text.x86.asm64_syscall.timer_gettime
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_timer_gettime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xe0
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_timer_gettime)
	call   sys_timer_gettime
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_timer_gettime)

/* syscall_slong_t timer_getoverrun(timer_t timerid) */
.section .text.x86.asm64_syscall.timer_getoverrun
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_timer_getoverrun)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xe1
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_timer_getoverrun)
	call   sys_timer_getoverrun
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_timer_getoverrun)

/* errno_t timer_delete(timer_t timerid) */
.section .text.x86.asm64_syscall.timer_delete
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_timer_delete)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xe2
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_timer_delete)
	call   sys_timer_delete
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_timer_delete)

/* errno_t clock_settime(clockid_t clock_id, struct timespecx64 const *tp) */
.section .text.x86.asm64_syscall.clock_settime
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_clock_settime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xe3
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_clock_settime)
	call   sys_clock_settime
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_clock_settime)

/* errno_t clock_gettime(clockid_t clock_id, struct timespecx64 *tp) */
.section .text.x86.asm64_syscall.clock_gettime
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_clock_gettime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xe4
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_clock_gettime)
	call   sys_clock_gettime
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_clock_gettime)

/* errno_t clock_getres(clockid_t clock_id, struct timespecx64 *res) */
.section .text.x86.asm64_syscall.clock_getres
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_clock_getres)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xe5
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_clock_getres)
	call   sys_clock_getres
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_clock_getres)

/* errno_t clock_nanosleep(clockid_t clock_id, syscall_ulong_t flags, struct timespecx64 const *requested_time, struct timespecx64 *remaining) */
.section .text.x86.asm64_syscall.clock_nanosleep
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_clock_nanosleep)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xe6
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_clock_nanosleep)
	call   sys_clock_nanosleep
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_clock_nanosleep)

/* Terminate the calling process
 * @param: exit_code: Thread exit code (as returned by `wait(2)') */
/* void exit_group(syscall_ulong_t exit_code) */
.section .text.x86.asm64_syscall.exit_group
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_exit_group)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xe7
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_exit_group)
	call   sys_exit_group
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_exit_group)

/* >> epoll_wait(2)
 * Wait until at least one of the conditions monitored by `epfd' to be met.
 * @param: epfd:      The epoll controller on which to wait.
 * @param: events:    A buffer where the kernel can store information on the
 *                    events that actually took place.
 * @param: maxevents: The # of events that can be stored in `events' (must be >= 1)
 * @param: timeout:   The max amount of time (in milliseconds) before  returning
 *                    in the case where no event occurred in the mean time. When
 *                    set to `-1', wait indefinitely
 * @return: >= 1:     The # of events that happened (written to the first `return'
 *                    items of `events')
 * @return: 0:        No events happened before `timeout' expired.
 * @return: -1:       Error (s.a. `errno') */
/* ssize_t epoll_wait(fd_t epfd, struct epoll_event *events, size_t maxevents, syscall_slong_t timeout) */
.section .text.x86.asm64_syscall.epoll_wait
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_epoll_wait)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xe8
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_epoll_wait)
	call   sys_epoll_wait
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_epoll_wait)

/* >> epoll_ctl(2)
 * Manipulate a given  epoll controller  `epfd', as previously  returned by  `epoll_create1(2)'
 * in order to register (`EPOLL_CTL_ADD'), remove (`EPOLL_CTL_DEL') or modify (`EPOLL_CTL_MOD')
 * the file descriptors being monitored
 * @param: op:       One of `EPOLL_CTL_ADD', `EPOLL_CTL_DEL' or `EPOLL_CTL_MOD'
 * @param: fd:       The file descriptor to add/remove/modify
 * @param: info:     The new configuration for `fd' (ignored when `op' is `EPOLL_CTL_DEL')
 * @return: 0 :      Success
 * @return: -EEXIST: [op=EPOLL_CTL_ADD] The given `fd' (and its kernel object) has already been registered
 * @return: -ENOENT: [op=EPOLL_CTL_MOD|EPOLL_CTL_DEL] The given `fd' (and its kernel object) aren't registered
 * @throw: E_ILLEGAL_REFERENCE_LOOP: The  given  `fd'  is  another  epoll  that either
 *                                   forms a loop with `epfd', or has too many nested.
 * @throw: E_INVALID_ARGUMENT_UNKNOWN_COMMAND:E_INVALID_ARGUMENT_CONTEXT_EPOLL_CTL_OP: [...] */
/* errno_t epoll_ctl(fd_t epfd, syscall_ulong_t op, fd_t fd, struct epoll_event *info) */
.section .text.x86.asm64_syscall.epoll_ctl
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_epoll_ctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xe9
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_epoll_ctl)
	call   sys_epoll_ctl
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_epoll_ctl)

/* errno_t tgkill(pid_t pid, pid_t tid, signo_t signo) */
.section .text.x86.asm64_syscall.tgkill
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_tgkill)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xea
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_tgkill)
	call   sys_tgkill
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_tgkill)

/* @param: times:    When NULL, set the current time
 * @param: times[0]: New access time
 * @param: times[1]: New last-modified time */
/* errno_t utimes(char const *filename, struct timevalx64 const[2] times) */
.section .text.x86.asm64_syscall.utimes
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_utimes)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xeb
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_utimes)
	call   sys_utimes
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_utimes)

/* errno_t vserver(void) */
.section .text.x86.asm64_syscall.vserver
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_vserver)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xec
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_vserver)
	call   sys_vserver
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_vserver)

/* errno_t mbind(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.mbind
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_mbind)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xed
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_mbind)
	call   sys_mbind
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_mbind)

/* errno_t set_mempolicy(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.set_mempolicy
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_set_mempolicy)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xee
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_set_mempolicy)
	call   sys_set_mempolicy
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_set_mempolicy)

/* errno_t get_mempolicy(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.get_mempolicy
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_get_mempolicy)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xef
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_get_mempolicy)
	call   sys_get_mempolicy
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_get_mempolicy)

/* fd_t mq_open(char const *name, oflag_t oflags, mode_t mode) */
.section .text.x86.asm64_syscall.mq_open
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_mq_open)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xf0
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_mq_open)
	call   sys_mq_open
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_mq_open)

/* errno_t mq_unlink(char const *name) */
.section .text.x86.asm64_syscall.mq_unlink
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_mq_unlink)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xf1
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_mq_unlink)
	call   sys_mq_unlink
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_mq_unlink)

/* errno_t mq_timedsend(fd_t mqdes, char const *msg_ptr, size_t msg_len, uint32_t msg_prio, struct timespecx64 const *abs_timeout) */
.section .text.x86.asm64_syscall.mq_timedsend
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_mq_timedsend)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xf2
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_mq_timedsend)
	call   sys_mq_timedsend
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_mq_timedsend)

/* ssize_t mq_timedreceive(fd_t mqdes, char *msg_ptr, size_t msg_len, uint32_t *pmsg_prio, struct timespecx64 const *abs_timeout) */
.section .text.x86.asm64_syscall.mq_timedreceive
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_mq_timedreceive)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xf3
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_mq_timedreceive)
	call   sys_mq_timedreceive
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_mq_timedreceive)

/* errno_t mq_notify(fd_t mqdes, struct sigevent const *notification) */
.section .text.x86.asm64_syscall.mq_notify
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_mq_notify)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xf4
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_mq_notify)
	call   sys_mq_notify
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_mq_notify)

/* errno_t mq_getsetattr(fd_t mqdes, struct mq_attr const *newattr, struct mq_attr *oldattr) */
.section .text.x86.asm64_syscall.mq_getsetattr
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_mq_getsetattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xf5
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_mq_getsetattr)
	call   sys_mq_getsetattr
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_mq_getsetattr)

/* errno_t kexec_load(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.kexec_load
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_kexec_load)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xf6
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_kexec_load)
	call   sys_kexec_load
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_kexec_load)

/* @param: idtype:  One of `P_ALL', `P_PID', `P_PGID'
 * @param: options: At least one of `WEXITED', `WSTOPPED', `WCONTINUED', optionally or'd with `WNOHANG | WNOWAIT' */
/* errno_t waitid(syscall_ulong_t idtype, id_t id, struct __siginfox64_struct *infop, syscall_ulong_t options, struct rusagex64 *ru) */
.section .text.x86.asm64_syscall.waitid
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_waitid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xf7
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_waitid)
	call   sys_waitid
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_waitid)

/* errno_t add_key(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.add_key
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_add_key)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xf8
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_add_key)
	call   sys_add_key
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_add_key)

/* errno_t request_key(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.request_key
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_request_key)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xf9
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_request_key)
	call   sys_request_key
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_request_key)

/* errno_t keyctl(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.keyctl
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_keyctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xfa
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_keyctl)
	call   sys_keyctl
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_keyctl)

/* NOTE: Linux calls `who' `which', and `id' `who' (refactored to prevent confusion)
 * @param: who: One of `IOPRIO_WHO_PROCESS', `IOPRIO_WHO_PGRP' or `IOPRIO_WHO_USER' */
/* errno_t ioprio_set(syscall_ulong_t who, syscall_ulong_t id, syscall_ulong_t ioprio) */
.section .text.x86.asm64_syscall.ioprio_set
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_ioprio_set)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xfb
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_ioprio_set)
	call   sys_ioprio_set
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_ioprio_set)

/* NOTE: Linux calls `who' `which', and `id' `who' (refactored to prevent confusion)
 * @param: who: One of `IOPRIO_WHO_PROCESS', `IOPRIO_WHO_PGRP' or `IOPRIO_WHO_USER' */
/* syscall_slong_t ioprio_get(syscall_ulong_t who, syscall_ulong_t id) */
.section .text.x86.asm64_syscall.ioprio_get
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_ioprio_get)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xfc
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_ioprio_get)
	call   sys_ioprio_get
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_ioprio_get)

/* fd_t inotify_init(void) */
.section .text.x86.asm64_syscall.inotify_init
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_inotify_init)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xfd
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_inotify_init)
	call   sys_inotify_init
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_inotify_init)

/* @param: mask: Set of `IN_ALL_EVENTS | ...' */
/* int inotify_add_watch(fd_t notify_fd, char const *pathname, uint32_t mask) */
.section .text.x86.asm64_syscall.inotify_add_watch
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_inotify_add_watch)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xfe
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_inotify_add_watch)
	call   sys_inotify_add_watch
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_inotify_add_watch)

/* @param: wd: Watch fd (as returned by `inotify_add_watch{_at}') */
/* errno_t inotify_rm_watch(fd_t notify_fd, int wd) */
.section .text.x86.asm64_syscall.inotify_rm_watch
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_inotify_rm_watch)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xff
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_inotify_rm_watch)
	call   sys_inotify_rm_watch
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_inotify_rm_watch)

/* errno_t migrate_pages(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.migrate_pages
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_migrate_pages)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x100
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_migrate_pages)
	call   sys_migrate_pages
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_migrate_pages)

/* Open  a  new  file  handle  to  the  file  specified  by `filename'
 * When  `oflags & O_CREAT',   then  `mode'   specifies  the   initial
 * file  access  permissions with  which  the file  should  be opened.
 * On KOS, the returned handle can be anything, but is usually one of:
 *   - HANDLE_TYPE_PATH:       When `O_PATH' was given
 *   - HANDLE_TYPE_FILEHANDLE: For `S_IFREG' regular files
 *   - HANDLE_TYPE_FIFOHANDLE: For `S_IFIFO' pipe files
 *   - HANDLE_TYPE_DIRHANDLE:  For `S_IFDIR' directories
 *   - HANDLE_TYPE_MFILE:      The actual filesystem object (including device files)
 *   - *:                      Certain filesystem names can literally return anything, such
 *                             as `/proc/self/fd/1234',  which  is  more  like  `dup(1234)' */
/* fd_t openat(fd_t dirfd, char const *filename, oflag_t oflags, mode_t mode) */
.section .text.x86.asm64_syscall.openat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_openat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x101
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_openat)
	call   sys_openat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_openat)

/* errno_t mkdirat(fd_t dirfd, char const *pathname, mode_t mode) */
.section .text.x86.asm64_syscall.mkdirat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_mkdirat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x102
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_mkdirat)
	call   sys_mkdirat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_mkdirat)

/* errno_t mknodat(fd_t dirfd, char const *nodename, mode_t mode, dev_t dev) */
.section .text.x86.asm64_syscall.mknodat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_mknodat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x103
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_mknodat)
	call   sys_mknodat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_mknodat)

/* @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_DOSPATH' */
/* errno_t fchownat(fd_t dirfd, char const *filename, uid_t owner, gid_t group, atflag_t flags) */
.section .text.x86.asm64_syscall.fchownat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_fchownat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x104
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_fchownat)
	call   sys_fchownat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_fchownat)

/* errno_t futimesat(fd_t dirfd, char const *filename, struct timevalx64 const[2] times) */
.section .text.x86.asm64_syscall.futimesat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_futimesat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x105
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_futimesat)
	call   sys_futimesat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_futimesat)

/* errno_t newfstatat(fd_t dirfd, char const *filename, struct linux64_stat32 *statbuf, atflag_t flags) */
.section .text.x86.asm64_syscall.newfstatat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_newfstatat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x106
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_newfstatat)
	call   sys_newfstatat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_newfstatat)

/* @param: flags: Set of `0 | AT_REMOVEDIR | AT_REMOVEREG | AT_DOSPATH' */
/* errno_t unlinkat(fd_t dirfd, char const *name, atflag_t flags) */
.section .text.x86.asm64_syscall.unlinkat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_unlinkat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x107
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_unlinkat)
	call   sys_unlinkat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_unlinkat)

/* errno_t renameat(fd_t oldfd, char const *oldname, fd_t newfd, char const *newname_or_path) */
.section .text.x86.asm64_syscall.renameat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_renameat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x108
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_renameat)
	call   sys_renameat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_renameat)

/* @param: flags: Set of `0 | AT_EMPTY_PATH | AT_SYMLINK_FOLLOW | AT_DOSPATH' */
/* errno_t linkat(fd_t fromfd, char const *existing_file, fd_t tofd, char const *target_path, atflag_t flags) */
.section .text.x86.asm64_syscall.linkat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_linkat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x109
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_linkat)
	call   sys_linkat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_linkat)

/* errno_t symlinkat(char const *link_text, fd_t tofd, char const *target_path) */
.section .text.x86.asm64_syscall.symlinkat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_symlinkat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x10a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_symlinkat)
	call   sys_symlinkat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_symlinkat)

/* ssize_t readlinkat(fd_t dirfd, char const *path, char *buf, size_t buflen) */
.section .text.x86.asm64_syscall.readlinkat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_readlinkat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x10b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_readlinkat)
	call   sys_readlinkat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_readlinkat)

/* @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_DOSPATH' */
/* errno_t fchmodat(fd_t dirfd, char const *filename, mode_t mode, atflag_t flags) */
.section .text.x86.asm64_syscall.fchmodat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_fchmodat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x10c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_fchmodat)
	call   sys_fchmodat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_fchmodat)

/* @param: type: Set of `R_OK | W_OK | X_OK' or `F_OK' */
/* errno_t faccessat(fd_t dirfd, char const *filename, syscall_ulong_t type) */
.section .text.x86.asm64_syscall.faccessat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_faccessat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x10d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_faccessat)
	call   sys_faccessat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_faccessat)

/* ssize_t pselect6(size_t nfds, struct __fd_set_struct *readfds, struct __fd_set_struct *writefds, struct __fd_set_struct *exceptfds, struct timespecx64 const *timeout, struct __sigset_with_sizex64 const *sigmask_sigset_with_size) */
.section .text.x86.asm64_syscall.pselect6
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_pselect6)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x10e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_pselect6)
	call   sys_pselect6
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_pselect6)

/* ssize_t ppoll(struct pollfd *fds, size_t nfds, struct timespecx64 const *timeout_ts, struct __sigset_struct const *sigmask, size_t sigsetsize) */
.section .text.x86.asm64_syscall.ppoll
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_ppoll)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x10f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_ppoll)
	call   sys_ppoll
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_ppoll)

/* param: what: Set of `CLONE_*' */
/* errno_t unshare(syscall_ulong_t what) */
.section .text.x86.asm64_syscall.unshare
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_unshare)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x110
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_unshare)
	call   sys_unshare
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_unshare)

/* errno_t set_robust_list(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.set_robust_list
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_set_robust_list)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x111
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_set_robust_list)
	call   sys_set_robust_list
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_set_robust_list)

/* errno_t get_robust_list(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.get_robust_list
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_get_robust_list)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x112
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_get_robust_list)
	call   sys_get_robust_list
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_get_robust_list)

/* @param: flags: Set of `SPLICE_F_MOVE | SPLICE_F_NONBLOCK | SPLICE_F_MORE | SPLICE_F_GIFT' */
/* ssize_t splice(fd_t fdin, uint64_t *offin, fd_t fdout, uint64_t *offout, size_t length, syscall_ulong_t flags) */
.section .text.x86.asm64_syscall.splice
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_splice)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x113
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_splice)
	call   sys_splice
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_splice)

/* @param: flags: Set of `SPLICE_F_MOVE | SPLICE_F_NONBLOCK | SPLICE_F_MORE | SPLICE_F_GIFT' */
/* ssize_t tee(fd_t fdin, fd_t fdout, size_t length, syscall_ulong_t flags) */
.section .text.x86.asm64_syscall.tee
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_tee)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x114
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_tee)
	call   sys_tee
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_tee)

/* @param: flags: Set of `SYNC_FILE_RANGE_WAIT_BEFORE | SYNC_FILE_RANGE_WRITE | SYNC_FILE_RANGE_WAIT_AFTER' */
/* errno_t sync_file_range(fd_t fd, uint64_t offset, uint64_t count, syscall_ulong_t flags) */
.section .text.x86.asm64_syscall.sync_file_range
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_sync_file_range)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x115
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_sync_file_range)
	call   sys_sync_file_range
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_sync_file_range)

/* @param: flags: Set of `SPLICE_F_MOVE | SPLICE_F_NONBLOCK | SPLICE_F_MORE | SPLICE_F_GIFT' */
/* ssize_t vmsplice(fd_t fdout, struct iovecx64 const *iov, size_t count, syscall_ulong_t flags) */
.section .text.x86.asm64_syscall.vmsplice
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_vmsplice)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x116
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_vmsplice)
	call   sys_vmsplice
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_vmsplice)

/* errno_t move_pages(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.move_pages
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_move_pages)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x117
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_move_pages)
	call   sys_move_pages
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_move_pages)

/* @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_CHANGE_BTIME | AT_DOSPATH' */
/* errno_t utimensat(fd_t dirfd, char const *filename, struct timespecx64 const[2] times, atflag_t flags) */
.section .text.x86.asm64_syscall.utimensat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_utimensat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x118
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_utimensat)
	call   sys_utimensat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_utimensat)

/* >> epoll_pwait(2)
 * Same as `epoll_wait(2)', but change the calling thread's signal mask to `ss' while
 * waiting.  Wait until at least one of the conditions monitored by `epfd' to be met.
 * @param: epfd:      The epoll controller on which to wait.
 * @param: events:    A buffer where the kernel can store information on the
 *                    events that actually took place.
 * @param: maxevents: The # of events that can be stored in `events' (must be >= 1)
 * @param: timeout:   The max amount of time (in milliseconds) before  returning
 *                    in the case where no event occurred in the mean time. When
 *                    set to `-1', wait indefinitely
 * @param: ss:        The signal mask to apply while waiting for an event to happen.
 * @return: >= 1:     The # of events that happened (written to the first `return'
 *                    items of `events')
 * @return: 0:        No events happened before `timeout' expired.
 * @return: -1:       Error (s.a. `errno') */
/* ssize_t epoll_pwait(fd_t epfd, struct epoll_event *events, size_t maxevents, syscall_slong_t timeout, struct __sigset_struct const *ss, size_t sigsetsize) */
.section .text.x86.asm64_syscall.epoll_pwait
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_epoll_pwait)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x119
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_epoll_pwait)
	call   sys_epoll_pwait
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_epoll_pwait)

/* Create a poll(2)-able file descriptor which can be used to wait for the
 * delivery of signals masked by `sigmask' to the waiting  thread/process. */
/* errno_t signalfd(fd_t fd, struct __sigset_struct const *sigmask, size_t sigmasksize) */
.section .text.x86.asm64_syscall.signalfd
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_signalfd)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x11a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_signalfd)
	call   sys_signalfd
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_signalfd)

/* Return file descriptor for new interval timer source
 * @param: flags: Set of `0 | TFD_NONBLOCK | TFD_CLOEXEC | TFD_CLOFORK' */
/* fd_t timerfd_create(clockid_t clock_id, syscall_ulong_t flags) */
.section .text.x86.asm64_syscall.timerfd_create
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_timerfd_create)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x11b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_timerfd_create)
	call   sys_timerfd_create
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_timerfd_create)

/* fd_t eventfd(syscall_ulong_t initval) */
.section .text.x86.asm64_syscall.eventfd
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_eventfd)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x11c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_eventfd)
	call   sys_eventfd
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_eventfd)

/* @param: mode: Set of `0 | FALLOC_FL_KEEP_SIZE | FALLOC_FL_PUNCH_HOLE | FALLOC_FL_COLLAPSE_RANGE | FALLOC_FL_ZERO_RANGE' */
/* errno_t fallocate(fd_t fd, syscall_ulong_t mode, syscall_ulong_t offset, syscall_ulong_t length) */
.section .text.x86.asm64_syscall.fallocate
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_fallocate)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x11d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_fallocate)
	call   sys_fallocate
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_fallocate)

/* Set next expiration time of interval timer source `timerfd' to `utmr'.
 * If `flags'  has the  `TFD_TIMER_ABSTIME' flag  set the  timeout  value
 * is absolute. Optionally return the old expiration time in `otmr'
 * @param: flags: Set of `0 | TFD_TIMER_ABSTIME' */
/* errno_t timerfd_settime(fd_t timerfd, syscall_ulong_t flags, struct itimerspecx64 const *utmr, struct itimerspecx64 *otmr) */
.section .text.x86.asm64_syscall.timerfd_settime
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_timerfd_settime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x11e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_timerfd_settime)
	call   sys_timerfd_settime
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_timerfd_settime)

/* Return the next expiration time of UFD */
/* errno_t timerfd_gettime(fd_t timerfd, struct itimerspecx64 *otmr) */
.section .text.x86.asm64_syscall.timerfd_gettime
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_timerfd_gettime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x11f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_timerfd_gettime)
	call   sys_timerfd_gettime
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_timerfd_gettime)

/* Accept incoming client (aka. peer) connection requests.
 * @param: addr:       Peer address of the sender (or `NULL' when `addr_len' is `NULL')
 * @param: addr_len:   [NULL] Don't fill in the client's peer address
 *                     [in]   The amount of available memory starting at `addr'
 *                     [out]  The  amount  of required  memory for  the address.
 *                            This  may be  more than  was given,  in which case
 *                            the  address  was  truncated and  may  be invalid.
 *                            If this happens,  the caller  can still  determine
 *                            the correct address through use of `getpeername()'
 * @param: sock_flags: Set of `SOCK_NONBLOCK | SOCK_CLOEXEC | SOCK_CLOFORK'
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_ACCEPT_NOT_LISTENING
 * @throw: E_INVALID_HANDLE_NET_OPERATION:E_NET_OPERATION_ACCEPT
 * @throw: E_NET_CONNECTION_ABORT
 * @return: * : A file descriptor for the newly accept(2)-ed connection */
/* fd_t accept4(fd_t sockfd, struct sockaddr *addr, socklen_t *addr_len, syscall_ulong_t sock_flags) */
.section .text.x86.asm64_syscall.accept4
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_accept4)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x120
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_accept4)
	call   sys_accept4
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_accept4)

/* Create a poll(2)-able file descriptor which can be used to wait for the
 * delivery of signals masked by `sigmask' to the waiting  thread/process.
 * @param: flags: Set of `0 | SFD_NONBLOCK | SFD_CLOEXEC | SFD_CLOFORK' */
/* errno_t signalfd4(fd_t fd, struct __sigset_struct const *sigmask, size_t sigmasksize, syscall_ulong_t flags) */
.section .text.x86.asm64_syscall.signalfd4
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_signalfd4)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x121
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_signalfd4)
	call   sys_signalfd4
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_signalfd4)

/* @param: flags: Set of `EFD_SEMAPHORE | EFD_NONBLOCK | EFD_CLOEXEC | EFD_CLOFORK' */
/* fd_t eventfd2(syscall_ulong_t initval, syscall_ulong_t flags) */
.section .text.x86.asm64_syscall.eventfd2
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_eventfd2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x122
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_eventfd2)
	call   sys_eventfd2
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_eventfd2)

/* >> epoll_create1(2)
 * Create  a new epoll control descriptor which can be used for
 * monitoring of pollable events happening in registered files.
 * @param: flags: Set of `EPOLL_CLOEXEC | EPOLL_CLOFORK'
 * @return: * :   The newly created epoll control descriptor.
 * @throw: E_INVALID_ARGUMENT_UNKNOWN_FLAG:E_INVALID_ARGUMENT_CONTEXT_EPOLL_CREATE1_FLAGS: [...] */
/* fd_t epoll_create1(syscall_ulong_t flags) */
.section .text.x86.asm64_syscall.epoll_create1
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_epoll_create1)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x123
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_epoll_create1)
	call   sys_epoll_create1
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_epoll_create1)

/* @param: flags:  Set of `O_CLOEXEC | O_CLOFORK' */
/* fd_t dup3(fd_t oldfd, fd_t newfd, oflag_t flags) */
.section .text.x86.asm64_syscall.dup3
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_dup3)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x124
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_dup3)
	call   sys_dup3
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_dup3)

/* errno_t pipe2(fd_t[2] pipedes, oflag_t flags) */
.section .text.x86.asm64_syscall.pipe2
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_pipe2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x125
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_pipe2)
	call   sys_pipe2
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_pipe2)

/* @param: flags: Set of `IN_NONBLOCK | IN_CLOEXEC | IN_CLOFORK' */
/* fd_t inotify_init1(syscall_ulong_t flags) */
.section .text.x86.asm64_syscall.inotify_init1
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_inotify_init1)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x126
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_inotify_init1)
	call   sys_inotify_init1
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_inotify_init1)

/* Same as  `readv(2)', but  read data  from a  file at  a
 * specific `offset', rather than the current R/W position
 * @return: <= SUM(iov[*].iov_len): The actual amount of read bytes */
/* ssize_t preadv(fd_t fd, struct iovecx64 const *iovec, size_t count, uint64_t offset) */
.section .text.x86.asm64_syscall.preadv
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_preadv)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x127
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_preadv)
	call   sys_preadv
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_preadv)

/* Same as  `writev(2)', but  write data  to a  file at  a
 * specific `offset', rather than the current R/W position
 * @return: <= SUM(iov[*].iov_len): The actual amount of written bytes */
/* ssize_t pwritev(fd_t fd, struct iovecx64 const *iovec, size_t count, uint64_t offset) */
.section .text.x86.asm64_syscall.pwritev
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_pwritev)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x128
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_pwritev)
	call   sys_pwritev
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_pwritev)

/* @param: usigno: The signal that should be sent
 * @param: uinfo:  [0..1] Additional signal information
 * @throw: E_INVALID_ARGUMENT_UNEXPECTED_COMMAND:E_INVALID_ARGUMENT_CONTEXT_SIGINFO_SIGNO: [...]
 * @throw: E_INVALID_ARGUMENT_BAD_VALUE:E_INVALID_ARGUMENT_CONTEXT_BAD_SIGNO:              [...]
 * @throw: E_INVALID_ARGUMENT_BAD_VALUE:E_INVALID_ARGUMENT_CONTEXT_RAISE_SIGINFO_BADCODE:  [...]
 * @throw: E_ILLEGAL_OPERATION:                                                            [...] */
/* errno_t rt_tgsigqueueinfo(pid_t pid, pid_t tid, signo_t usigno, struct __siginfox64_struct const *uinfo) */
.section .text.x86.asm64_syscall.rt_tgsigqueueinfo
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_rt_tgsigqueueinfo)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x129
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_rt_tgsigqueueinfo)
	call   sys_rt_tgsigqueueinfo
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_rt_tgsigqueueinfo)

/* errno_t perf_event_open(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.perf_event_open
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_perf_event_open)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x12a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_perf_event_open)
	call   sys_perf_event_open
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_perf_event_open)

/* Same as `recvmsg(2)', but may be used to receive many
 * messages  (datagrams)  with  a  single  system  call.
 * @param: msg_flags: Set of `MSG_CMSG_CLOEXEC | MSG_CMSG_CLOFORK |
 *                            MSG_DONTWAIT | MSG_ERRQUEUE | MSG_OOB |
 *                            MSG_PEEK  |  MSG_TRUNC |  MSG_WAITALL |
 *                            MSG_WAITFORONE'
 * @throw: Error (s.a. `recvmsg(2)')
 * @return: * : The # of datagrams successfully received. */
/* ssize_t recvmmsg(fd_t sockfd, struct mmsghdrx64 *vmessages, size_t vlen, syscall_ulong_t msg_flags, struct timespecx64 const *tmo) */
.section .text.x86.asm64_syscall.recvmmsg
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_recvmmsg)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x12b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_recvmmsg)
	call   sys_recvmmsg
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_recvmmsg)

/* errno_t fanotify_init(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.fanotify_init
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_fanotify_init)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x12c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_fanotify_init)
	call   sys_fanotify_init
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_fanotify_init)

/* errno_t fanotify_mark(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.fanotify_mark
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_fanotify_mark)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x12d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_fanotify_mark)
	call   sys_fanotify_mark
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_fanotify_mark)

/* @param: resource: One of `RLIMIT_*' from <sys/resource.h> */
/* errno_t prlimit64(pid_t pid, syscall_ulong_t resource, struct rlimitx64 const *new_limit, struct rlimitx64 *old_limit) */
.section .text.x86.asm64_syscall.prlimit64
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_prlimit64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x12e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_prlimit64)
	call   sys_prlimit64
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_prlimit64)

/* @param: flags: Set of `0 | AT_EMPTY_PATH | AT_SYMLINK_FOLLOW | AT_DOSPATH' */
/* errno_t name_to_handle_at(fd_t dirfd, char const *filename, struct file_handle *handle, int32_t *mnt_id, atflag_t flags) */
.section .text.x86.asm64_syscall.name_to_handle_at
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_name_to_handle_at)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x12f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_name_to_handle_at)
	call   sys_name_to_handle_at
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_name_to_handle_at)

/* fd_t open_by_handle_at(fd_t mountdirfd, struct file_handle const *handle, oflag_t flags) */
.section .text.x86.asm64_syscall.open_by_handle_at
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_open_by_handle_at)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x130
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_open_by_handle_at)
	call   sys_open_by_handle_at
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_open_by_handle_at)

/* errno_t clock_adjtime(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.clock_adjtime
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_clock_adjtime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x131
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_clock_adjtime)
	call   sys_clock_adjtime
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_clock_adjtime)

/* errno_t syncfs(fd_t fd) */
.section .text.x86.asm64_syscall.syncfs
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_syncfs)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x132
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_syncfs)
	call   sys_syncfs
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_syncfs)

/* Same as `sendmsg(2)', but may be used to send many
 * messages (datagrams)  with a  single system  call.
 * @param: msg_flags: Set of `MSG_CONFIRM | MSG_DONTROUTE | MSG_DONTWAIT |
 *                            MSG_EOR | MSG_MORE | MSG_NOSIGNAL | MSG_OOB'
 * @throw: ... Same as `sendmsg(2)'
 * @return: * : The # of datagrams successfully sent. */
/* ssize_t sendmmsg(fd_t sockfd, struct mmsghdrx64 *vmessages, size_t vlen, syscall_ulong_t msg_flags) */
.section .text.x86.asm64_syscall.sendmmsg
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_sendmmsg)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x133
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_sendmmsg)
	call   sys_sendmmsg
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_sendmmsg)

/* errno_t setns(fd_t fd, syscall_ulong_t nstype) */
.section .text.x86.asm64_syscall.setns
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_setns)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x134
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_setns)
	call   sys_setns
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_setns)

/* errno_t getcpu(uint32_t *cpu, uint32_t *node, struct getcpu_cache *tcache) */
.section .text.x86.asm64_syscall.getcpu
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_getcpu)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x135
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_getcpu)
	call   sys_getcpu
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_getcpu)

/* Read memory from another process's VM
 * @param: flags: Must be `0'
 * @return: * :   The actual number of read bytes */
/* ssize_t process_vm_readv(pid_t pid, struct iovecx64 const *local_iov, size_t liovcnt, struct iovecx64 const *remote_iov, size_t riovcnt, syscall_ulong_t flags) */
.section .text.x86.asm64_syscall.process_vm_readv
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_process_vm_readv)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x136
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_process_vm_readv)
	call   sys_process_vm_readv
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_process_vm_readv)

/* Write memory to another process's VM
 * @param: flags: Must be `0'
 * @return: * :   The actual number of written bytes */
/* ssize_t process_vm_writev(pid_t pid, struct iovecx64 const *local_iov, size_t liovcnt, struct iovecx64 const *remote_iov, size_t riovcnt, syscall_ulong_t flags) */
.section .text.x86.asm64_syscall.process_vm_writev
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_process_vm_writev)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x137
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_process_vm_writev)
	call   sys_process_vm_writev
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_process_vm_writev)

/* @param: type: One of  `KCMP_FILE',  `KCMP_FILES',  `KCMP_FS',  `KCMP_IO',
 *               `KCMP_SIGHAND', `KCMP_SYSVSEM', `KCMP_VM', `KCMP_EPOLL_TFD' */
/* syscall_slong_t kcmp(pid_t pid1, pid_t pid2, syscall_ulong_t type, syscall_ulong_t idx1, syscall_ulong_t idx2) */
.section .text.x86.asm64_syscall.kcmp
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_kcmp)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x138
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_kcmp)
	call   sys_kcmp
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_kcmp)

/* Load a  kernel  driver  from an  ELF  image  `module_image...+=len'
 * This system call exists for linux compatibility, and is implemented
 * as an alias for  `KSYSCTL_DRIVER_INSMOD:KSYSCTL_DRIVER_FORMAT_FILE'
 * 
 * Note however that that is where linux compatibility ends. Since the
 * linux kernel does not implement any semblance of a stable ABI,  you
 * have to realize that on KOS, this system call can only load drivers
 * specifically built to run within the KOS kernel!
 * @param: uargs: The driver commandline */
/* errno_t finit_module(fd_t fd, char const *uargs, syscall_ulong_t flags) */
.section .text.x86.asm64_syscall.finit_module
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_finit_module)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x139
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_finit_module)
	call   sys_finit_module
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_finit_module)

/* errno_t sched_setattr(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.sched_setattr
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_sched_setattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x13a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_sched_setattr)
	call   sys_sched_setattr
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_sched_setattr)

/* errno_t sched_getattr(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.sched_getattr
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_sched_getattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x13b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_sched_getattr)
	call   sys_sched_getattr
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_sched_getattr)

/* @param: flags: Set of `0 | AT_RENAME_NOREPLACE | AT_RENAME_EXCHANGE | AT_RENAME_WHITEOUT | AT_RENAME_MOVETODIR | AT_DOSPATH' */
/* errno_t renameat2(fd_t olddirfd, char const *oldpath, fd_t newdirfd, char const *newpath, atflag_t flags) */
.section .text.x86.asm64_syscall.renameat2
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_renameat2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x13c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_renameat2)
	call   sys_renameat2
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_renameat2)

/* errno_t seccomp(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.seccomp
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_seccomp)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x13d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_seccomp)
	call   sys_seccomp
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_seccomp)

/* @param: flags: Set of `0 | GRND_RANDOM | GRND_NONBLOCK' */
/* ssize_t getrandom(void *buf, size_t num_bytes, syscall_ulong_t flags) */
.section .text.x86.asm64_syscall.getrandom
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_getrandom)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x13e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_getrandom)
	call   sys_getrandom
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_getrandom)

/* @param: flags: Set of `MFD_CLOEXEC | MFD_CLOFORK | MFD_ALLOW_SEALING | MFD_HUGETLB' */
/* fd_t memfd_create(char const *name, syscall_ulong_t flags) */
.section .text.x86.asm64_syscall.memfd_create
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_memfd_create)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x13f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_memfd_create)
	call   sys_memfd_create
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_memfd_create)

/* errno_t kexec_file_load(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.kexec_file_load
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_kexec_file_load)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x140
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_kexec_file_load)
	call   sys_kexec_file_load
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_kexec_file_load)

/* errno_t bpf(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.bpf
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_bpf)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x141
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_bpf)
	call   sys_bpf
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_bpf)

/* Replace the calling  process with  the application  image referred  to by  `path' /  `file'
 * and execute it's `main()' method, passing the given `argv', and setting `environ' to `envp'
 * @param: flags: Set of `0 | AT_EMPTY_PATH | AT_SYMLINK_NOFOLLOW | AT_DOSPATH' */
/* errno_t execveat(fd_t dirfd, char const *pathname, __HYBRID_PTR64(char const) const *argv, __HYBRID_PTR64(char const) const *envp, atflag_t flags) */
.section .text.x86.asm64_syscall.execveat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_execveat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x142
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_execveat)
	call   sys_execveat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_execveat)

/* fd_t userfaultfd(syscall_ulong_t flags) */
.section .text.x86.asm64_syscall.userfaultfd
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_userfaultfd)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x143
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_userfaultfd)
	call   sys_userfaultfd
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_userfaultfd)

/* errno_t membarrier(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.membarrier
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_membarrier)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x144
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_membarrier)
	call   sys_membarrier
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_membarrier)

/* errno_t mlock2(void const *addr, size_t length, syscall_ulong_t flags) */
.section .text.x86.asm64_syscall.mlock2
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_mlock2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x145
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_mlock2)
	call   sys_mlock2
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_mlock2)

/* errno_t copy_file_range(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.copy_file_range
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_copy_file_range)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x146
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_copy_file_range)
	call   sys_copy_file_range
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_copy_file_range)

/* errno_t preadv2(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.preadv2
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_preadv2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x147
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_preadv2)
	call   sys_preadv2
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_preadv2)

/* errno_t pwritev2(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.pwritev2
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_pwritev2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x148
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_pwritev2)
	call   sys_pwritev2
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_pwritev2)

/* errno_t pkey_mprotect(void *addr, size_t len, syscall_ulong_t prot, syscall_ulong_t pkey) */
.section .text.x86.asm64_syscall.pkey_mprotect
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_pkey_mprotect)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x149
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_pkey_mprotect)
	call   sys_pkey_mprotect
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_pkey_mprotect)

/* syscall_slong_t pkey_alloc(syscall_ulong_t flags, syscall_ulong_t access_rights) */
.section .text.x86.asm64_syscall.pkey_alloc
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_pkey_alloc)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x14a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_pkey_alloc)
	call   sys_pkey_alloc
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_pkey_alloc)

/* errno_t pkey_free(syscall_ulong_t key) */
.section .text.x86.asm64_syscall.pkey_free
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_pkey_free)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x14b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_pkey_free)
	call   sys_pkey_free
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_pkey_free)

/* errno_t statx(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.statx
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_statx)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x14c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_statx)
	call   sys_statx
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_statx)

/* errno_t io_pgetevents(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.io_pgetevents
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_io_pgetevents)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x14d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_io_pgetevents)
	call   sys_io_pgetevents
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_io_pgetevents)

/* errno_t rseq(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.rseq
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_rseq)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x14e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_rseq)
	call   sys_rseq
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_rseq)

/* Send a signal to the process of a given pidfd
 * @param: pidfd:  A `HANDLE_TYPE_PIDFD'-handle
 * @param: usigno: The signal that should be sent
 * @param: uinfo:  [0..1] Additional signal information
 * @param: flags:  Must always be `0' (for now)
 * @throw: E_PROCESS_EXITED:                                                                  [...]
 * @throw: E_INVALID_ARGUMENT_RESERVED_ARGUMENT:E_INVALID_ARGUMENT_CONTEXT_PIDFD_GETFD_FLAGS: [...]
 * @throw: E_INVALID_ARGUMENT_UNEXPECTED_COMMAND:E_INVALID_ARGUMENT_CONTEXT_SIGINFO_SIGNO:    [...]
 * @throw: E_INVALID_ARGUMENT_BAD_VALUE:E_INVALID_ARGUMENT_CONTEXT_BAD_SIGNO:                 [...]
 * @throw: E_INVALID_ARGUMENT_BAD_VALUE:E_INVALID_ARGUMENT_CONTEXT_RAISE_SIGINFO_BADCODE:     [...]
 * @throw: E_INVALID_HANDLE_FILE:                                                             [...]
 * @throw: E_ILLEGAL_OPERATION:                                                               [...] */
/* errno_t pidfd_send_signal(fd_t pidfd, signo_t usigno, struct __siginfox64_struct const *uinfo, syscall_ulong_t flags) */
.section .text.x86.asm64_syscall.pidfd_send_signal
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_pidfd_send_signal)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x1a8
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_pidfd_send_signal)
	call   sys_pidfd_send_signal
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_pidfd_send_signal)

/* errno_t io_uring_setup(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.io_uring_setup
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_io_uring_setup)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x1a9
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_io_uring_setup)
	call   sys_io_uring_setup
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_io_uring_setup)

/* errno_t io_uring_enter(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.io_uring_enter
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_io_uring_enter)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x1aa
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_io_uring_enter)
	call   sys_io_uring_enter
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_io_uring_enter)

/* errno_t io_uring_register(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.io_uring_register
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_io_uring_register)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x1ab
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_io_uring_register)
	call   sys_io_uring_register
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_io_uring_register)

/* errno_t open_tree(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.open_tree
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_open_tree)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x1ac
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_open_tree)
	call   sys_open_tree
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_open_tree)

/* errno_t move_mount(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.move_mount
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_move_mount)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x1ad
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_move_mount)
	call   sys_move_mount
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_move_mount)

/* errno_t fsopen(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.fsopen
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_fsopen)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x1ae
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_fsopen)
	call   sys_fsopen
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_fsopen)

/* errno_t fsconfig(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.fsconfig
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_fsconfig)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x1af
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_fsconfig)
	call   sys_fsconfig
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_fsconfig)

/* errno_t fsmount(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.fsmount
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_fsmount)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x1b0
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_fsmount)
	call   sys_fsmount
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_fsmount)

/* errno_t fspick(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.fspick
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_fspick)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x1b1
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_fspick)
	call   sys_fspick
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_fspick)

/* Return a `HANDLE_TYPE_PIDFD' handle for the given `pid'
 * This system call exists for compatibility with linux, which does not  allow
 * this call to succeed when `pid' isn't a process leader (i.e. main() thread)
 * @param: flags: Must always be `0' (for now)
 * @return: * :   A handle for the process `pid'
 * @throw: E_PROCESS_EXITED:                                                                 [...]
 * @throw: E_INVALID_ARGUMENT_RESERVED_ARGUMENT:E_INVALID_ARGUMENT_CONTEXT_PIDFD_OPEN_FLAGS: [...]
 * @throw: E_BADALLOC_INSUFFICIENT_HANDLE_NUMBERS:                                           [...] */
/* fd_t pidfd_open(pid_t pid, syscall_ulong_t flags) */
.section .text.x86.asm64_syscall.pidfd_open
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_pidfd_open)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x1b2
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_pidfd_open)
	call   sys_pidfd_open
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_pidfd_open)

/* syscall_slong_t clone3(struct clone_args *cl_args, size_t size) */
.section .text.x86.asm64_syscall.clone3
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_clone3)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x1b3
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_clone3)
	call   sys_clone3
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_clone3)

/* @param: flags: Set of `CLOSE_RANGE_*' from <linux/close_range.h> */
/* errno_t close_range(unsigned int minfd, unsigned int maxfd, unsigned int flags) */
.section .text.x86.asm64_syscall.close_range
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_close_range)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x1b4
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_close_range)
	call   sys_close_range
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_close_range)

/* errno_t openat2(int TODO_PROTOTYPE) */
.section .text.x86.asm64_syscall.openat2
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_openat2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x1b5
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_openat2)
	call   sys_openat2
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_openat2)

/* Duplicate the  handle  of  a  foreign  process into  a  handle  for  the  caller.
 * This system call duplicates the functionality of `open("/proc/[pid]/fd/[fdno]")',
 * which may also be used to duplicate file handles from another process.
 * @param: pidfd: A `HANDLE_TYPE_PIDFD'-handle
 * @param: fd:    The FD-number of the handle to clone
 * @param: flags: Must always be `0' (for now)
 * @return: * :   The duplicated handle number
 * @throw: E_PROCESS_EXITED:                                                                  [...]
 * @throw: E_INVALID_ARGUMENT_RESERVED_ARGUMENT:E_INVALID_ARGUMENT_CONTEXT_PIDFD_GETFD_FLAGS: [...]
 * @throw: E_BADALLOC_INSUFFICIENT_HANDLE_NUMBERS:                                            [...]
 * @throw: E_INVALID_HANDLE_FILE:                                                             [...]
 * @throw: E_ILLEGAL_OPERATION:                                                               [...] */
/* fd_t pidfd_getfd(fd_t pidfd, fd_t foreign_fd, syscall_ulong_t flags) */
.section .text.x86.asm64_syscall.pidfd_getfd
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_pidfd_getfd)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x1b6
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_pidfd_getfd)
	call   sys_pidfd_getfd
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_pidfd_getfd)

/* @param: type: Set of `R_OK | W_OK | X_OK' or `F_OK'
 * @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_EACCESS | AT_DOSPATH' */
/* errno_t faccessat2(fd_t dirfd, char const *filename, syscall_ulong_t type, atflag_t flags) */
.section .text.x86.asm64_syscall.faccessat2
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_faccessat2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0x1b7
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_faccessat2)
	call   sys_faccessat2
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_faccessat2)

/* Same as  `writev(2)', but  write data  to a  file at  a
 * specific `offset', rather than the current R/W position
 * @return: <= SUM(iov[*].iov_len): The actual amount of written bytes */
/* ssize_t pwritevf(fd_t fd, struct iovecx64 const *iovec, size_t count, uint64_t offset, iomode_t mode) */
.section .text.x86.asm64_syscall.pwritevf
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_pwritevf)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xfffffffffffffed8
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_pwritevf)
	call   sys_pwritevf
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_pwritevf)

/* Same as  `readv(2)', but  read data  from a  file at  a
 * specific `offset', rather than the current R/W position
 * @return: <= SUM(iov[*].iov_len): The actual amount of read bytes */
/* ssize_t preadvf(fd_t fd, struct iovecx64 const *iovec, size_t count, uint64_t offset, iomode_t mode) */
.section .text.x86.asm64_syscall.preadvf
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_preadvf)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xfffffffffffffed9
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_preadvf)
	call   sys_preadvf
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_preadvf)

/* @param: flags: Set of `0 | AT_READLINK_REQSIZE | AT_DOSPATH' */
/* ssize_t freadlinkat(fd_t dirfd, char const *path, char *buf, size_t buflen, atflag_t flags) */
.section .text.x86.asm64_syscall.freadlinkat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_freadlinkat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xfffffffffffffef5
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_freadlinkat)
	call   sys_freadlinkat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_freadlinkat)

/* @param: flags: Set of `0 | AT_DOSPATH' */
/* errno_t fsymlinkat(char const *link_text, fd_t tofd, char const *target_path, atflag_t flags) */
.section .text.x86.asm64_syscall.fsymlinkat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_fsymlinkat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xfffffffffffffef6
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_fsymlinkat)
	call   sys_fsymlinkat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_fsymlinkat)

/* @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_DOSPATH' */
/* errno_t kfstatat(fd_t dirfd, char const *filename, struct __kos_stat *statbuf, atflag_t flags) */
.section .text.x86.asm64_syscall.kfstatat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_kfstatat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xfffffffffffffefa
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_kfstatat)
	call   sys_kfstatat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_kfstatat)

/* @param: flags: Set of `0 | AT_DOSPATH' */
/* errno_t fmknodat(fd_t dirfd, char const *nodename, mode_t mode, dev_t dev, atflag_t flags) */
.section .text.x86.asm64_syscall.fmknodat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_fmknodat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xfffffffffffffefd
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_fmknodat)
	call   sys_fmknodat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_fmknodat)

/* @param: flags: Set of `0 | AT_DOSPATH' */
/* errno_t fmkdirat(fd_t dirfd, char const *pathname, mode_t mode, atflag_t flags) */
.section .text.x86.asm64_syscall.fmkdirat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_fmkdirat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xfffffffffffffefe
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_fmkdirat)
	call   sys_fmkdirat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_fmkdirat)

/* @param: atflags: Set of `AT_SYMLINK_NOFOLLOW | AT_DOSPATH'
 * @param: mask:    Set of `IN_ALL_EVENTS | ...' */
/* int inotify_add_watch_at(fd_t notify_fd, fd_t dirfd, char const *pathname, atflag_t atflags, uint32_t mask) */
.section .text.x86.asm64_syscall.inotify_add_watch_at
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_inotify_add_watch_at)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xffffffffffffff02
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_inotify_add_watch_at)
	call   sys_inotify_add_watch_at
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_inotify_add_watch_at)

/* syscall_slong_t ksysctl(ioctl_t command, void *arg) */
.section .text.x86.asm64_syscall.ksysctl
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_ksysctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xffffffffffffff64
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_ksysctl)
	call   sys_ksysctl
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_ksysctl)

/* Map the segments of a given library into memory
 * @param: addr:  Hint address (ignored unless `MAP_FIXED' is passed)
 * @param: flags: Set of `MAP_FIXED | MAP_32BIT | MAP_GROWSDOWN |
 *                MAP_GROWSUP  |  MAP_LOCKED  |  MAP_NORESERVE  |
 *                MAP_POPULATE  |  MAP_NONBLOCK   |  MAP_SYNC   |
 *                MAP_FIXED_NOREPLACE | MAP_NOASLR'
 * @param: fd:    A handle for the library file being mapped (must be mmap(2)-able)
 * @param: hdrv:  Pointer  to  a vector  of `Elf32_Phdr'  or `Elf64_Phdr'
 *                (depending on the caller running in 32- or 64-bit mode)
 * @param: hdrc:  The number of program headers */
/* void *maplibrary(void *addr, syscall_ulong_t flags, fd_t fd, struct elf64_phdr const *hdrv, size_t hdrc) */
.section .text.x86.asm64_syscall.maplibrary
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_maplibrary)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xffffffffffffff7a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_maplibrary)
	call   sys_maplibrary
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_maplibrary)

/* uint64_t fsmode(uint64_t mode) */
.section .text.x86.asm64_syscall.fsmode
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_fsmode)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xffffffffffffffa1
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_fsmode)
	call   sys_fsmode
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_fsmode)

/* @param: flags: Set of `0 | AT_DOSPATH' */
/* errno_t fchdirat(fd_t dirfd, char const *path, atflag_t flags) */
.section .text.x86.asm64_syscall.fchdirat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_fchdirat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xffffffffffffffb0
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_fchdirat)
	call   sys_fchdirat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_fchdirat)

/* @param: mode: One of `READDIR_DEFAULT', `READDIR_CONTINUE', `READDIR_PEEK' or `READDIR_MULTIPLE',
 *               optionally     or'd     with     any     of     `READDIR_SKIPREL | READDIR_WANTEOF' */
/* ssize_t kreaddirf(fd_t fd, struct dirent *buf, size_t bufsize, syscall_ulong_t mode, iomode_t iomode) */
.section .text.x86.asm64_syscall.kreaddirf
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_kreaddirf)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xffffffffffffffb1
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_kreaddirf)
	call   sys_kreaddirf
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_kreaddirf)

/* @param: mode: One of `READDIR_DEFAULT', `READDIR_CONTINUE', `READDIR_PEEK' or `READDIR_MULTIPLE',
 *               optionally     or'd     with     any     of     `READDIR_SKIPREL | READDIR_WANTEOF' */
/* ssize_t kreaddir(fd_t fd, struct dirent *buf, size_t bufsize, syscall_ulong_t mode) */
.section .text.x86.asm64_syscall.kreaddir
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_kreaddir)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xffffffffffffffb2
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_kreaddir)
	call   sys_kreaddir
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_kreaddir)

/* Set the exception handler mode for the calling thread.
 * Examples:
 *   - Set mode #3 from you `main()': `set_exception_handler(EXCEPT_HANDLER_MODE_SIGHAND, NULL, NULL)'
 *   - Set mode #4 (as done by libc): `set_exception_handler(EXCEPT_HANDLER_MODE_SIGHAND |
 *                                                           EXCEPT_HANDLER_FLAG_SETHANDLER,
 *                                                           &except_handler4, NULL)'
 * @param: mode:       One of `EXCEPT_HANDLER_MODE_*', optionally or'd with `EXCEPT_HANDLER_FLAG_*'
 * @param: handler:    When `EXCEPT_HANDLER_FLAG_SETHANDLER' is set, the address of the exception handler to use
 * @param: handler_sp: When `EXCEPT_HANDLER_FLAG_SETSTACK' is set, the address of the exception handler stack
 * @return: 0 :        Success.
 * @return: -1:EINVAL: The given `mode' is invalid */
/* errno_t set_exception_handler(syscall_ulong_t mode, except_handler_t handler, void *handler_sp) */
.section .text.x86.asm64_syscall.set_exception_handler
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_set_exception_handler)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xffffffffffffffd9
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_set_exception_handler)
	call   sys_set_exception_handler
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_set_exception_handler)

/* Get the current exception handler mode for the calling thread.
 * @param: pmode:       When non-`NULL', store the current mode, which is encoded as:
 *                       - One of `EXCEPT_HANDLER_MODE_(DISABLED|ENABLED|SIGHAND)'
 *                       - Or'd with a set of `EXCEPT_HANDLER_FLAG_(ONESHOT|SETHANDLER|SETSTACK)'
 * @param: phandler:    When   non-`NULL',   store  the   address   of  the   user-space   exception  handler.
 *                      Note that when no handler has been set (`!(*pmode & EXCEPT_HANDLER_FLAG_SETHANDLER)'),
 *                      then this pointer is set to `NULL'.
 * @param: phandler_sp: When non-`NULL', store the starting address of the user-space exception handler stack.
 *                      Note that  when no  stack has  been set  (`!(*pmode & EXCEPT_HANDLER_FLAG_SETSTACK)'),
 *                      or when the stack was defined to re-use the previous stack,
 *                      then this pointer is set to `EXCEPT_HANDLER_SP_CURRENT'.
 * @return: 0 :         Success.
 * @return: -1:EFAULT:  One of the given pointers is non-`NULL' and faulty */
/* errno_t get_exception_handler(__ULONG64_TYPE__ *pmode, __except_handler64_t *phandler, __HYBRID_PTR64(void) *phandler_sp) */
.section .text.x86.asm64_syscall.get_exception_handler
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_get_exception_handler)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xffffffffffffffda
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_get_exception_handler)
	call   sys_get_exception_handler
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_get_exception_handler)

/* >> rpc_serve_sysret(2)
 * Very similar to `rpc_serve(2)', but with the addition that this one
 * will only serve RPCs that can be handled in `RPC_REASONCTX_SYSRET',
 * aka. `RPC_REASONCTX_ASYNC' contexts. Additionally, this system call
 * ignores the state of the  internal `TASK_FRPC' flag, and should  be
 * invoked  when  the calling  thread  makes use  of  the userprocmask
 * mechanism, and the  signal mask became  less restrictive while  the
 * `USERPROCMASK_FLAG_HASPENDING' flag was set.
 * 
 * When userprocmask is disabled, this system call is pretty much just
 * a no-op (semnatically speaking, it does nothing). But when enabled,
 * it is really only usable  in conjuction with the userprocmask.  The
 * exact usage can be seen in `chkuserprocmask(3)'.
 * 
 * @return: 0 : Always, unconditionally returned. */
/* errno_t rpc_serve_sysret(void) */
.section .text.x86.asm64_syscall.rpc_serve_sysret
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_rpc_serve_sysret)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xffffffffffffffdb
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_rpc_serve_sysret)
	call   sys_rpc_serve_sysret
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_rpc_serve_sysret)

/* >> set_userprocmask_address(2)
 * Register the address of  the calling thread's userprocmask  controller.
 * This also  initializes `*ctl->pm_sigmask'  and `ctl->pm_pending',  such
 * that `*ctl->pm_sigmask' is filled with the current kernel-level  signal
 * mask, as would be returned by `sigprocmask(2)', while `ctl->pm_pending'
 * is filled in with the equivalent of `sigpending(2)'
 * Additionally,  the address  of `&ctl->pm_mytid'  is stored  as an override
 * for `set_tid_address(2)', and the kernel may read from `*ctl->pm_sigmask',
 * and write to `ctl->pm_pending' (using  atomic-or for the later) from  this
 * point forth.
 * NOTE: Before calling this function, the caller must:
 *       >> bzero(ctl, sizeof(struct userprocmask));
 *       >> ctl->pm_sigsize = sizeof(sigset_t);
 *       >> ctl->pm_sigmask = &initial_sigmask;
 *       Where the initial bzero() is needed to initialize potential
 *       additional,   arch-specific   fields    to   all    zeroes.
 * NOTE: This system call will then initialize:
 *       >> ctl->pm_mytid = gettid();
 *       >> sigprocmask(0, NULL, ctl->pm_sigmask);
 *       >> sigpending(&ctl->pm_pending);
 * NOTE: Passing `NULL' for `ctl' disables userprocmask-mode, though
 *       before this is done, the kernel will copy the  `pm_sigmask'
 *       of the previously set  controller into its internal  signal
 *       mask. (i.e. the one used outside of userprocmask-mode)
 * Note though  that  `pm_sigmask'  is ignored  for  `SIGKILL'  and  `SIGSTOP'
 * Note also  that  this  function replaces  `set_tid_address(2)',  such  that
 * it negates a  prior call  to said  function, while  a future  call to  said
 * function will once again disable userprocmask, same as passing `NULL' would */
/* errno_t set_userprocmask_address(struct userprocmask *ctl) */
.section .text.x86.asm64_syscall.set_userprocmask_address
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_set_userprocmask_address)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xffffffffffffffdc
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_set_userprocmask_address)
	call   sys_set_userprocmask_address
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_set_userprocmask_address)

/* Check if a transaction is currently in progress
 * @return: 0 : No RTM operation in progress
 * @return: 1 : An RTM operation is currently in progress */
/* syscall_ulong_t rtm_test(void) */
.section .text.x86.asm64_syscall.rtm_test
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_rtm_test)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xffffffffffffffdd
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_rtm_test)
	call   sys_rtm_test
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_rtm_test)

/* Abort the current transaction  by having `sys_rtm_begin()' return  with
 * `RTM_ABORT_EXPLICIT | ((code << RTM_ABORT_CODE_S) & RTM_ABORT_CODE_M)'
 * If no transaction was in progress, behave as a no-op and return `-EOK'.
 * Otherwise,  this system call does not return normally, but returns from
 * the original `sys_rtm_begin()' */
/* errno_t rtm_abort(syscall_ulong_t code) */
.section .text.x86.asm64_syscall.rtm_abort
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_rtm_abort)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xffffffffffffffde
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_rtm_abort)
	call   sys_rtm_abort
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_rtm_abort)

/* End a transaction
 * If  the  transaction was  successful,  return normally  (by  returning `-EOK').
 * If    the   transaction   failed,   `sys_rtm_begin()'   returns   `RTM_ABORT_*'
 * If no transaction was in progress, an `E_ILLEGAL_OPERATION' exception is thrown */
/* errno_t rtm_end(void) */
.section .text.x86.asm64_syscall.rtm_end
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_rtm_end)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xffffffffffffffdf
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_rtm_end)
	call   sys_rtm_end
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_rtm_end)

/* Begin  an  RTM operation.  Note that  if  the arch-specific  RTM driver
 * wasn't already loaded into the kernel, it will be loaded automatically,
 * though any error that may happen during this will result in `RTM_NOSYS'
 * begin returned.
 * Note that while an RTM  operation is in progress,  only a very small  hand
 * full  of system calls are allowed to  be used. Attempting to use arbitrary
 * system calls will most likely  result in an `RTM_ABORT_FAILED' error,  and
 * attempting to access too much system memory in general will result in this
 * function returning  with  `RTM_ABORT_CAPACITY',  rather  than  succeeding.
 * The following is  a list  of system calls  which are  whitelisted for  use
 * during a transaction:
 *   - sys_rtm_begin:  Nested RTM operation
 *   - sys_rtm_end:    End an RTM operation
 *   - sys_rtm_abort:  Abort an RTM operation
 *   - sys_rtm_test:   Check if an RTM operation is in progress (always returns `1')
 * Anything else will most likely result in this system call returning `RTM_ABORT_FAILED'
 * @return: RTM_STARTED : RTM operation was started.
 * @return: RTM_NOSYS   : RTM isn't supposed because the RTM driver is missing, or cannot be loaded.
 * @return: RTM_ABORT_* : RTM operation failed (s.a. code from `<kos/rtm.h>') */
/* rtm_status_t rtm_begin(void) */
.section .text.x86.asm64_syscall.rtm_begin
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_rtm_begin)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xffffffffffffffe0
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_rtm_begin)
	call   sys_rtm_begin
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_rtm_begin)

/* Construct   a   user-vio-fd  object   supporting  mmap(2),   with  actual
 * memory  accesses  being dispatched  by  adding them  as  pending requests
 * to an internal  queue that  should be read(2)  from by  a worker  thread,
 * which should then service those requests before responding by write(2)ing
 * the results of the operation back to the same fd.
 * HINT: The format of the structures that are read(2) and
 *       write(2)en can be found in `<libvio/userviofd.h>'
 * NOTE: Don't use this system call directly. Use `vio_create(3)'
 *       from `<libvio/vio.h>' instead.
 * @param: initial_size: The initial mmap(2)able size of the returned handle.
 *                       This  size may be  altered at a  later point in time
 *                       through use of `ftruncate(return)'
 * @param: flags:        Set of `0 | O_CLOEXEC | O_CLOFORK | O_NONBLOCK' */
/* fd_t userviofd(size_t initial_size, syscall_ulong_t flags) */
.section .text.x86.asm64_syscall.userviofd
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_userviofd)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xffffffffffffffe1
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_userviofd)
	call   sys_userviofd
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_userviofd)

/* Trigger a coredump of the calling process.
 * @param: curr_state:       The  state as is still valid after any possible unwinding has already been done
 *                           Note that this state does not necessarily point to the location that originally
 *                           caused the problem that escalated into a coredump, but is the last valid stack-
 *                           unwind location at which unwinding could no longer continue.
 *                           When `NULL', `orig_state' is used instead, and `traceback_vector' and `traceback_length' are ignored.
 * @param: orig_state:       The original CPU state at where the associated `reason' got triggered
 *                           When `NULL', `curr_state' is used instead, and `traceback_vector' and `traceback_length' are ignored.
 *                           When   `curr_state'   is   also   `NULL',   then   the   current   CPU   state   is   used   instead.
 * @param: traceback_vector: (potentially  incomplete)   vector  of   additional  program   pointers  that   were
 *                           traversed   when   the  stack   was   walked  from   `orig_state'   to  `curr_state'
 *                           Note that earlier  entries within this  vector are further  up the call-stack,  with
 *                           traceback_vector[0] being meant to be the call-site of the function of `orig_state'.
 *                           Note that when `traceback_length != 0 && traceback_vector[traceback_length-1] == ucpustate_getpc(curr_state)',
 *                           it  can  be  assumed  that  the  traceback is  complete  and  contains  all  traversed  instruction locations.
 *                           In   this   case,  a   traceback  displayed   to   a  human   should  not   include   the  text   location  at
 *                           `traceback_vector[traceback_length-1]',    since    that    location    would    also    be    printed    when
 *                           unwinding is completed for the purposes of displaying a traceback.
 * @param: traceback_length: The number of program counters stored within `traceback_vector'
 * @param: reason:           The reason that resulted in the coredump (or `NULL' to get the same behavior as `E_OK')
 *                           For certain `unwind_error' values, this can also  point to other things, but is  always
 *                           allowed to be `NULL' to indicate default/stub values.
 * @param: unwind_error:     The  unwind  error that  caused the  coredump,  or `UNWIND_SUCCESS'  if unwinding
 *                           was  never  actually  performed,  and   `reason'  is  actually  a   `siginfo_t *'
 *                           Ignored when `reason == NULL', in which case `UNWIND_SUCCESS' is assumed instead. */
/* errno_t coredump(struct ucpustate64 const *curr_state, struct ucpustate64 const *orig_state, __HYBRID_PTR64(void const) const *traceback_vector, size_t traceback_length, union coredump_info64 const *reason, unwind_errno_t unwind_error) */
.section .text.x86.asm64_syscall.coredump
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_coredump)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xffffffffffffffe3
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_coredump)
	call   sys_coredump
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_coredump)

/* Create and return a new tty terminal controller connected to the given keyboard and display
 * The  newly created  device automatically gets  assigned an arbitrary  device number, before
 * being made available under a file `/dev/${name}'  (or rather: as ${name} within the  devfs)
 * @param: reserved: Reserved set of flags (Must pass `0'; for future expansion) */
/* fd_t mktty(char const *name, fd_t keyboard, fd_t display, syscall_ulong_t rsvd) */
.section .text.x86.asm64_syscall.mktty
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_mktty)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xffffffffffffffe5
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_mktty)
	call   sys_mktty
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_mktty)

/* >> lfutexexpr(2)
 * The lfutexexpr(2) system call can be used to specify arbitrarily complex
 * expressions that must atomically (in relation to other futex operations)
 * hold true before the scheduler will suspend the calling thread.
 * @param: futexaddr: The futex on which to wait
 * @param: base:      Base pointer added to the `fe_offset' fields of given expressions
 * @param: expr:      Vector of expressions for which to check, terminated by `LFUTEX_EXPREND'
 * @param: timeout:   Timeout for wait operations (s.a. `LFUTEX_WAIT_FLAG_TIMEOUT_*')
 *                    When `LFUTEX_FDBIT'  is  set,  this argument  must  be  `NULL'.
 * @param: flags:     Set of `LFUTEX_WAIT_FLAG_TIMEOUT_*' or `LFUTEX_FDBIT'
 * @return: * : The first  non-zero  return value  from  executing  all of  the  given  `expr'
 *              in order (s.a. the documentations of the individual `LFUTEX_WAIT_*'  functions
 *              to see their  possible return  values, which are  always `0'  when they  would
 *              perform a wait  operation, and usually  `1' otherwise) or  `0' if the  calling
 *              thread had to perform a wait operation, at which point this function returning
 *              that value means that you've once again been re-awoken.
 *              When `LFUTEX_FDBIT' is set, the return value is an `fd_t' for a futex fd that
 *              can be used to poll for the specified `exprv'. Note that in this case `exprv'
 *              is limited to `LFUTEXFD_DEFAULT_MAXEXPR' (`/proc/kos/futexfd-maxexpr')
 * @return: -1:EFAULT:    A faulty pointer was given
 * @return: -1:EINVAL:    One of the given commands is invalid, or `expr[0].fe_condition == LFUTEX_EXPREND'
 * @return: -1:EINTR:     A blocking futex-wait operation was interrupted
 * @return: -1:ETIMEDOUT: A blocking futex-wait operation has timed out */
/* errno_t lfutexexpr(uint64_t *futexaddr, void *base, struct lfutexexprx64 const *expr, struct timespecx64 const *timeout, syscall_ulong_t flags) */
.section .text.x86.asm64_syscall.lfutexexpr
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_lfutexexpr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xffffffffffffffe6
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_lfutexexpr)
	call   sys_lfutexexpr
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_lfutexexpr)

/* >> lfutex(2)
 * Provide the bottom-most API for implementing user-space synchronization on KOS
 * @param: futex_op: One of:
 *    - LFUTEX_WAKE:                (lfutex_t *uaddr, LFUTEX_WAKE, size_t count)
 *    - LFUTEX_WAKEMASK:            (lfutex_t *uaddr, LFUTEX_WAKEMASK, size_t count, lfutex_t mask_and, lfutex_t mask_or)
 *    - LFUTEX_WAIT_WHILE:          (lfutex_t *uaddr, LFUTEX_WAIT_WHILE, lfutex_t value, struct timespec const *timeout)
 *    - LFUTEX_WAIT_UNTIL:          (lfutex_t *uaddr, LFUTEX_WAIT_UNTIL, lfutex_t value, struct timespec const *timeout)
 *    - LFUTEX_WAIT_WHILE_ABOVE:    (lfutex_t *uaddr, LFUTEX_WAIT_WHILE_ABOVE, lfutex_t value, struct timespec const *timeout)
 *    - LFUTEX_WAIT_WHILE_BELOW:    (lfutex_t *uaddr, LFUTEX_WAIT_WHILE_BELOW, lfutex_t value, struct timespec const *timeout)
 *    - LFUTEX_WAIT_WHILE_BITMASK:  (lfutex_t *uaddr, LFUTEX_WAIT_WHILE_BITMASK, lfutex_t bitmask, struct timespec const *timeout, lfutex_t setmask)
 *    - LFUTEX_WAIT_UNTIL_BITMASK:  (lfutex_t *uaddr, LFUTEX_WAIT_UNTIL_BITMASK, lfutex_t bitmask, struct timespec const *timeout, lfutex_t setmask)
 *    - LFUTEX_WAIT_WHILE_EX:       (lfutex_t *uaddr, LFUTEX_WAIT_WHILE_EX, void const *rhs, struct timespec const *timeout, size_t num_bytes)
 *    - LFUTEX_WAIT_UNTIL_EX:       (lfutex_t *uaddr, LFUTEX_WAIT_UNTIL_EX, void const *rhs, struct timespec const *timeout, size_t num_bytes)
 *    - LFUTEX_WAIT_WHILE_ABOVE_EX: (lfutex_t *uaddr, LFUTEX_WAIT_WHILE_ABOVE_EX, void const *rhs, struct timespec const *timeout, size_t num_bytes)
 *    - LFUTEX_WAIT_WHILE_BELOW_EX: (lfutex_t *uaddr, LFUTEX_WAIT_WHILE_BELOW_EX, void const *rhs, struct timespec const *timeout, size_t num_bytes)
 * @param: timeout: Timeout for wait operations (s.a. `LFUTEX_WAIT_FLAG_TIMEOUT_*')
 * @return: * : Depending on `futex_op'
 * @return: -1:EFAULT:    A faulty pointer was given
 * @throw:  E_INVALID_ARGUMENT: The given `futex_op' is invalid
 * @throw:  E_INTERRUPT:        A blocking futex-wait operation was interrupted
 * @return: -ETIMEDOUT:         A blocking futex-wait operation has timed out */
/* syscall_slong_t lfutex(uint64_t *uaddr, syscall_ulong_t futex_op, uint64_t val, struct timespecx64 const *timeout, uint64_t val2) */
.section .text.x86.asm64_syscall.lfutex
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_lfutex)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xffffffffffffffe8
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_lfutex)
	call   sys_lfutex
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_lfutex)

/* >> rpc_serve(2)
 * Check for pending signals and RPCs. This is a wrapper around the
 * kernel `task_serve()' function, which is always invoked before a
 * thread begins waiting for a blocking operation. All system calls
 * marked as cancellation  points probably  call `task_serve()'  at
 * some point.
 * Note that unlike (say) `pause(2)', this function doesn't  block,
 * and may be used to implement `pthread_testcancel(3)' (should KOS
 * RPCs be used to facility pthread cancellation points, as done by
 * KOS's builtin libc)
 * @return: 0:      Nothing was handled.
 * @return: -EINTR: RPCs (or posix signals) were handled. */
/* errno_t rpc_serve(void) */
.section .text.x86.asm64_syscall.rpc_serve
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_rpc_serve)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xffffffffffffffe9
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_rpc_serve)
	call   sys_rpc_serve
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_rpc_serve)

/* Trigger a debugger trap `trapno', optionally extended with  `regs'
 * at either the system call return location, or at the given `state'
 * In the later case, this system call will by default return to  the
 * given  `state', though given the purpose of this system call being
 * to inform a connected debugger  of some breakable event,  allowing
 * it to do whatever it wishes before execution is resumed.
 * @param: reason:   When non-NULL, the reason for the debug trap (else: use `SIGTRAP:DEBUGTRAP_REASON_NONE')
 * @param: state:    When non-NULL, the CPU state where the trap should return to by default
 * @return: -EOK:    `state' was NULL and the trap returned successfully
 * @return: -ENOENT: No debugger is connected to the calling process/process-group/system */
/* errno_t debugtrap(struct ucpustate64 const *state, struct debugtrap_reason64 const *reason) */
.section .text.x86.asm64_syscall.debugtrap
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_debugtrap)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xffffffffffffffea
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_debugtrap)
	call   sys_debugtrap
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_debugtrap)

/* Same as `write(2)', but rather than specifying a single, continuous buffer,
 * write  data from `count'  separate buffers, though  still return the actual
 * number of written bytes.
 * When  `fd' has the  `O_NONBLOCK' flag set, only  write as much data
 * as possible at the time the call was made, and throw `E_WOULDBLOCK'
 * if no data could be written at the time.
 * @return: <= SUM(iov[*].iov_len): The actual amount of written bytes
 * @return: 0                     : No more data can be written */
/* ssize_t writevf(fd_t fd, struct iovecx64 const *iovec, size_t count, iomode_t mode) */
.section .text.x86.asm64_syscall.writevf
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_writevf)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xffffffffffffffec
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_writevf)
	call   sys_writevf
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_writevf)

/* Same as `read(2)', but rather than specifying a single, continuous buffer,
 * read  data into `count'  separate buffers, though  still return the actual
 * number of read bytes.
 * When `fd' has the `O_NONBLOCK' flag set, only read as much data as was
 * available at  the time  the call  was made,  and throw  `E_WOULDBLOCK'
 * no data was available at the time.
 * @return: <= SUM(iov[*].iov_len): The actual amount of read bytes
 * @return: 0                     : EOF */
/* ssize_t readvf(fd_t fd, struct iovecx64 const *iovec, size_t count, iomode_t mode) */
.section .text.x86.asm64_syscall.readvf
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_readvf)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xffffffffffffffed
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_readvf)
	call   sys_readvf
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_readvf)

/* ssize_t pwrite64f(fd_t fd, void const *buf, size_t bufsize, uint64_t offset, iomode_t mode) */
.section .text.x86.asm64_syscall.pwrite64f
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_pwrite64f)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xffffffffffffffee
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_pwrite64f)
	call   sys_pwrite64f
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_pwrite64f)

/* ssize_t pread64f(fd_t fd, void *buf, size_t bufsize, uint64_t offset, iomode_t mode) */
.section .text.x86.asm64_syscall.pread64f
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_pread64f)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xffffffffffffffef
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_pread64f)
	call   sys_pread64f
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_pread64f)

/* syscall_slong_t ioctlf(fd_t fd, ioctl_t command, iomode_t mode, void *arg) */
.section .text.x86.asm64_syscall.ioctlf
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_ioctlf)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xfffffffffffffff0
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_ioctlf)
	call   sys_ioctlf
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_ioctlf)

/* Restore  the  given CPU/FPU  context descriptors,  as  well as  signal mask
 * before resuming execution by either invoking another system call `sc_info',
 * which  will then return  to `restore_cpu', or  by directly returning there.
 * Arguments:
 *  - %rbp: [1..1] struct ucpustate64 const *restore_cpu;
 *  - %rbx: [0..1] struct fpustate64 const *restore_fpu;
 *  - %r12: [0..1] struct __sigset_with_sizex64 const *restore_sigmask;
 *  - %r13: [0..1] struct rpc_syscall_info64 const *sc_info;
 * This system call uses a custom calling convention because registers passed
 * must not get clobbered  during execution of a  normal C function. On  i386
 * this doesn't require  a custom calling  convention since enough  registers
 * exist  that are preserved by a C function,  but are still used by at least
 * one  system call invocation  method. However on  x86_64, no such registers
 * exist, requiring the use of a custom protocol. */
/* void ksigreturn(void) */
.section .text.x86.asm64_syscall.ksigreturn
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_ksigreturn)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xfffffffffffffff1
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_ksigreturn)
	call   sys_ksigreturn
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_ksigreturn)

/* Create a new pseudo-terminal driver and store handles to both the
 * master  and slave ends  of the connection  in the given pointers. */
/* errno_t openpty(fd_t *amaster, fd_t *aslave, char *name, struct termios const *termp, struct winsize const *winp) */
.section .text.x86.asm64_syscall.openpty
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_openpty)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xfffffffffffffff3
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_openpty)
	call   sys_openpty
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_openpty)

/* >> rpc_schedule(2)
 * Schedule an RPC program to-be executed by some other thread. This  function
 * cannot guaranty that  the RPC  program is  always executed,  as the  target
 * thread terminate before the  conditions for the RPC  to be served are  ever
 * met. Note that these  conditions depend on the  given `mode'. Note that  on
 * multi-arch  platforms (such as  x86), the register numbers,  as well as the
 * address size used by `program' depend on the execution mode of `target_tid'
 * 
 * NOTE: Only a cancellation point when `RPC_JOIN_WAITFOR' is used!
 * 
 * @param: target_tid:      The TID of the targeted thread
 * @param: mode:            One of `RPC_SYNCMODE_*',  optionally or'd  with
 *                          one of `RPC_SYSRESTART_*', optionally or'd with
 *                          one of `RPC_PRIORITY_*',  optionally or'd  with
 *                          one of  `RPC_DOMAIN_*',  optionally  or'd  with
 *                          one of `RPC_JOIN_*'
 * @param: program:         The RPC program to execute (sequences of `RPC_OP_*')
 * @param: params:          RPC program parameters (for `RPC_OP_push_param')
 * @param: max_param_count: The max # of `params' used by `program'
 * 
 * @return: 0 :                Success
 * @throws: E_SEGFAULT:        Faulty pointers were given
 * @throws: E_INVALID_ARGUMENT:E_INVALID_ARGUMENT_CONTEXT_RPC_SCHEDULE_MODE:
 *                             The given `mode' is invalid.
 * @throws: E_INVALID_ARGUMENT:E_INVALID_ARGUMENT_CONTEXT_RPC_PROGRAM_INSTRUCTION:
 *                             The RPC program  contains illegal  instructions.
 *                             In this case, modifications made by instructions
 *                             encountered before the illegal one(s) will still
 *                             have  happened, meaning that the target thread's
 *                             state may have become inconsistent.
 * @throws: E_PROCESS_EXITED:  The target thread has already terminated, or
 *                             doesn't exist. Note  though that unless  the
 *                             thread  is  part  of your  own  process, are
 *                             still many reasons  outside of your  control
 *                             for why it  may terminate immediately  after
 *                             the RPC program finished. */
/* errno_t rpc_schedule(pid_t target_tid, syscall_ulong_t mode, void const *program, __HYBRID_PTR64(void const) const *params, size_t max_param_count) */
.section .text.x86.asm64_syscall.rpc_schedule
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_rpc_schedule)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xfffffffffffffff4
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_rpc_schedule)
	call   sys_rpc_schedule
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_rpc_schedule)

/* Returns  the  absolute   filesystem  path  for   the  specified   file
 * When `AT_SYMLINK_NOFOLLOW' is given, a final symlink is  dereferenced,
 * causing the pointed-to file location to be retrieved. - Otherwise, the
 * location of the link is printed instead.
 * You may pass `AT_READLINK_REQSIZE' to always have the function return
 * the   required   buffer   size,   rather   than   the   used    size.
 * @param: flags: Set of `0 | AT_ALTPATH | AT_SYMLINK_NOFOLLOW | AT_READLINK_REQSIZE | AT_DOSPATH' */
/* ssize_t frealpathat(fd_t dirfd, char const *filename, char *buf, size_t buflen, atflag_t flags) */
.section .text.x86.asm64_syscall.frealpathat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_frealpathat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xfffffffffffffff5
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_frealpathat)
	call   sys_frealpathat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_frealpathat)

/* You may pass `AT_READLINK_REQSIZE' to always have the function return
 * the   required   buffer   size,   rather   than   the   used    size.
 * @param: flags: Set of `0 | AT_ALTPATH | AT_READLINK_REQSIZE | AT_DOSPATH' */
/* ssize_t frealpath4(fd_t fd, char *resolved, size_t buflen, atflag_t flags) */
.section .text.x86.asm64_syscall.frealpath4
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_frealpath4)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xfffffffffffffff6
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_frealpath4)
	call   sys_frealpath4
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_frealpath4)

/* Returns a bitset of all of the currently mounted dos-drives */
/* syscall_slong_t getdrives(void) */
.section .text.x86.asm64_syscall.getdrives
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_getdrives)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xfffffffffffffff7
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_getdrives)
	call   sys_getdrives
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_getdrives)

/* >> detach(2)
 * Detach the descriptor of `PID' from the thread that
 * would have received a signal when it changes state,
 * as well as prevent the  thread from turning into  a
 * zombie once it dies.
 * For simplicity, think of it like this:
 *   - pthread_create()  -->  clone()
 *   - pthread_join()    -->  wait()
 *   - pthread_detach()  -->  detach()  // Linux's missing link, now implemented
 * A total of 4 special cases exists to alter the behavior of this function:
 *   - PID == 0 || PID == gettid():
 *     Detach the calling  thread from  the set of  running children  within
 *     its own process.  Note however  that when this  is done  by the  main
 *     thread of the process, gettid() will equal getpid(), and the behavior
 *     will be different.
 *   - PID == getpid():
 *     Detach the calling process from its parent, essentially daemonizing
 *     the  calling   process   the   same  way   a   double-fork   would:
 *     >> if (fork() == 0) {
 *     >> 	if (fork() == 0) {
 *     >> 		// This is a daemonized process
 *     >> 		// aka. the parent process no longer knows
 *     >> 		// about us, and also can't wait(2) on us.
 *     >> 		...
 *     >> 	}
 *     >> 	exit(0);
 *     >> }
 *     Same as:
 *     >> if (fork() == 0) {
 *     >> 	detach(0); // or `detach(getpid())', since 0 --> gettid() and gettid() == getpid()
 *     >> 	// This is a daemonized process
 *     >> 	// aka. the parent process no longer knows
 *     >> 	// about us, and also can't wait(2) on us.
 *     >> 	...
 *     >> }
 *   - PID == -1:
 *     Detach all child processes/threads  of the calling process,  essentially
 *     turning its chain of children into a clean slate that no longer contains
 *     any wait(2)able child threads or processes.
 *     If no waitable children existed, `ECHILD' is set; else `0' is returned.
 * The given `pid' must be:
 *   - A thread without the caller's process
 *   - A child process of the caller's process
 * NOTE: If a thread is created using clone() with `CLONE_DETACHED' set,
 *       it will behave effectively as though this function had  already
 *       be called.
 * @return: -ECHILD:         `PID' was equal to `-1', but no waitable children existed
 * @throw: E_PROCESS_EXITED: No such  thread/process exists,  or  the thread  isn't  isn't
 *                           a thread in your process, or a child process of your process. */
/* errno_t detach(pid_t pid) */
.section .text.x86.asm64_syscall.detach
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_detach)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xfffffffffffffff8
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_detach)
	call   sys_detach
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_detach)

/* Read up to `bufsize' bytes from `fd' into `buf'
 * When  `fd' has the `O_NONBLOCK' flag set, only read as much data as was
 * available at the time the call was made, and throw `E_WOULDBLOCK' if no
 * data was available at the time.
 * @return: <= bufsize: The actual amount of read bytes
 * @return: 0         : EOF */
/* ssize_t readf(fd_t fd, void *buf, size_t bufsize, iomode_t mode) */
.section .text.x86.asm64_syscall.readf
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_readf)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xfffffffffffffff9
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_readf)
	call   sys_readf
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_readf)

/* errno_t klstat(char const *filename, struct __kos_stat *statbuf) */
.section .text.x86.asm64_syscall.klstat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_klstat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xfffffffffffffffa
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_klstat)
	call   sys_klstat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_klstat)

/* errno_t kfstat(fd_t fd, struct __kos_stat *statbuf) */
.section .text.x86.asm64_syscall.kfstat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_kfstat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xfffffffffffffffb
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_kfstat)
	call   sys_kfstat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_kfstat)

/* errno_t kstat(char const *filename, struct __kos_stat *statbuf) */
.section .text.x86.asm64_syscall.kstat
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_kstat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xfffffffffffffffc
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	EXTERN(sys_kstat)
	call   sys_kstat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_kstat)

/* Write up to `bufsize' bytes from `buf' into `fd'
 * When `fd' has the `O_NONBLOCK' flag set, only write as much data as
 * possible at the time the call was made, and throw `E_WOULDBLOCK' if
 * no data could be written at the time.
 * @return: <= bufsize: The actual amount of written bytes
 * @return: 0         : No more data can be written */
/* ssize_t writef(fd_t fd, void const *buf, size_t bufsize, iomode_t mode) */
.section .text.x86.asm64_syscall.writef
INTERN_WEAK_FUNCTION(__x86_asm64_syscall_writef)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm64_syscall
	.cfi_lsda 0, 0xffffffffffffffff
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movq   %r10, %rcx
	EXTERN(sys_writef)
	call   sys_writef
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET64
	.cfi_endproc
END(__x86_asm64_syscall_writef)










/* errno_t restart_syscall(void) */
.section .text.x86.asm32_syscall_int80.restart_syscall
INTERN_WEAK_FUNCTION(__x86_asm32_int80_restart_syscall)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x0
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_restart_syscall)
	call   sys32_restart_syscall
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_restart_syscall)

/* Terminate the calling thread (_NOT_ process!)
 * @param: exit_code: Thread exit code (as returned by `wait(2)') */
/* void exit(syscall_ulong_t exit_code) */
.section .text.x86.asm32_syscall_int80.exit
INTERN_WEAK_FUNCTION(__x86_asm32_int80_exit)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_exit)
	call   sys32_exit
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_exit)

/* Clone the calling thread into a second process and return twice, once
 * in  the parent process where this function returns the (non-zero) PID
 * of  the forked child process, and a  second time in the child process
 * itself, where ZERO(0) is returned.
 * The child then usually proceeds by calling `exec(2)' to replace its
 * application image with  that of another  program that the  original
 * parent can then `wait(2)' for. (s.a. `vfork(2)')
 * @return: 0 : You're the new process that was created
 * @return: * : The `return' value is the pid of your new child process */
/* pid_t fork(void) */
.section .text.x86.asm32_syscall_int80.fork
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fork)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x2
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_fork)
	call   sys32_fork
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fork)

/* Read up to `bufsize' bytes from `fd' into `buf'
 * When  `fd' has the `O_NONBLOCK' flag set, only read as much data as was
 * available at the time the call was made, and throw `E_WOULDBLOCK' if no
 * data was available at the time.
 * @return: <= bufsize: The actual amount of read bytes
 * @return: 0         : EOF */
/* ssize_t read(fd_t fd, void *buf, size_t bufsize) */
.section .text.x86.asm32_syscall_int80.read
INTERN_WEAK_FUNCTION(__x86_asm32_int80_read)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x3
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_read)
	call   sys32_read
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_read)

/* Write up to `bufsize' bytes from `buf' into `fd'
 * When `fd' has the `O_NONBLOCK' flag set, only write as much data as
 * possible at the time the call was made, and throw `E_WOULDBLOCK' if
 * no data could be written at the time.
 * @return: <= bufsize: The actual amount of written bytes
 * @return: 0         : No more data can be written */
/* ssize_t write(fd_t fd, void const *buf, size_t bufsize) */
.section .text.x86.asm32_syscall_int80.write
INTERN_WEAK_FUNCTION(__x86_asm32_int80_write)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x4
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_write)
	call   sys32_write
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_write)

/* Open  a  new  file  handle  to  the  file  specified  by `filename'
 * When  `oflags & O_CREAT',   then  `mode'   specifies  the   initial
 * file  access  permissions with  which  the file  should  be opened.
 * On KOS, the returned handle can be anything, but is usually one of:
 *   - HANDLE_TYPE_PATH:       When `O_PATH' was given
 *   - HANDLE_TYPE_FILEHANDLE: For `S_IFREG' regular files
 *   - HANDLE_TYPE_FIFOHANDLE: For `S_IFIFO' pipe files
 *   - HANDLE_TYPE_DIRHANDLE:  For `S_IFDIR' directories
 *   - HANDLE_TYPE_MFILE:      The actual filesystem object (including device files)
 *   - *:                      Certain filesystem names can literally return anything, such
 *                             as `/proc/self/fd/1234',  which  is  more  like  `dup(1234)' */
/* fd_t open(char const *filename, oflag_t oflags, mode_t mode) */
.section .text.x86.asm32_syscall_int80.open
INTERN_WEAK_FUNCTION(__x86_asm32_int80_open)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x5
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movslq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_open)
	call   sys32_open
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_open)

/* Close a given file descriptor/handle `fd' */
/* errno_t close(fd_t fd) */
.section .text.x86.asm32_syscall_int80.close
INTERN_WEAK_FUNCTION(__x86_asm32_int80_close)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x6
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_close)
	call   sys32_close
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_close)

/* Wait for a child process:
 *  - `pid < -1':  Wait for any child process whose process group ID is `-PID'
 *  - `pid == -1': Wait for any child process
 *  - `pid == 0':  Wait for any child process whose process group ID is that of the caller
 *  - `pid > 0':   Wait for the child whose process ID is equal to `PID'
 * @param: options: Set of `WNOHANG | WUNTRACED | WCONTINUED' (as a KOS extension, `WNOWAIT' is also accepted) */
/* pid_t waitpid(pid_t pid, int32_t *stat_loc, syscall_ulong_t options) */
.section .text.x86.asm32_syscall_int80.waitpid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_waitpid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x7
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_waitpid)
	call   sys32_waitpid
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_waitpid)

/* fd_t creat(char const *filename, mode_t mode) */
.section .text.x86.asm32_syscall_int80.creat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_creat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x8
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_creat)
	call   sys32_creat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_creat)

/* errno_t link(char const *existing_file, char const *link_file) */
.section .text.x86.asm32_syscall_int80.link
INTERN_WEAK_FUNCTION(__x86_asm32_int80_link)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x9
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_link)
	call   sys32_link
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_link)

/* errno_t unlink(char const *filename) */
.section .text.x86.asm32_syscall_int80.unlink
INTERN_WEAK_FUNCTION(__x86_asm32_int80_unlink)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xa
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_unlink)
	call   sys32_unlink
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_unlink)

/* Replace the calling  process with  the application  image referred  to by  `path' /  `file'
 * and execute it's `main()' method, passing the given `argv', and setting `environ' to `envp' */
/* errno_t execve(char const *path, __HYBRID_PTR32(char const) const *argv, __HYBRID_PTR32(char const) const *envp) */
.section .text.x86.asm32_syscall_int80.execve
INTERN_WEAK_FUNCTION(__x86_asm32_int80_execve)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xb
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_execve)
	call   sys32_execve
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_execve)

/* errno_t chdir(char const *path) */
.section .text.x86.asm32_syscall_int80.chdir
INTERN_WEAK_FUNCTION(__x86_asm32_int80_chdir)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xc
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_chdir)
	call   sys32_chdir
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_chdir)

/* int32_t time(int32_t *timer) */
.section .text.x86.asm32_syscall_int80.time
INTERN_WEAK_FUNCTION(__x86_asm32_int80_time)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xd
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_time)
	call   sys32_time
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_time)

/* errno_t mknod(char const *nodename, mode_t mode, dev_t dev) */
.section .text.x86.asm32_syscall_int80.mknod
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mknod)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xe
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_mknod)
	call   sys32_mknod
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_mknod)

/* errno_t chmod(char const *filename, mode_t mode) */
.section .text.x86.asm32_syscall_int80.chmod
INTERN_WEAK_FUNCTION(__x86_asm32_int80_chmod)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xf
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_chmod)
	call   sys32_chmod
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_chmod)

/* errno_t lchown(char const *filename, uint16_t owner, uint16_t group) */
.section .text.x86.asm32_syscall_int80.lchown
INTERN_WEAK_FUNCTION(__x86_asm32_int80_lchown)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x10
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzwq %cx, %rsi /* ARG1 = REG1 (16-bit) */
	movzwq %dx, %rdx /* ARG2 = REG2 (16-bit) */
	EXTERN(sys32_lchown)
	call   sys32_lchown
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_lchown)

/* errno_t break(void) */
.section .text.x86.asm32_syscall_int80.break
INTERN_WEAK_FUNCTION(__x86_asm32_int80_break)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x11
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_break)
	call   sys32_break
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_break)

/* errno_t oldstat(char const *filename, struct linux_oldstat *statbuf) */
.section .text.x86.asm32_syscall_int80.oldstat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_oldstat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x12
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_oldstat)
	call   sys32_oldstat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_oldstat)

/* syscall_slong_t lseek(fd_t fd, syscall_slong_t offset, syscall_ulong_t whence) */
.section .text.x86.asm32_syscall_int80.lseek
INTERN_WEAK_FUNCTION(__x86_asm32_int80_lseek)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x13
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movslq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_lseek)
	call   sys32_lseek
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_lseek)

/* pid_t getpid(void) */
.section .text.x86.asm32_syscall_int80.getpid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getpid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x14
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_getpid)
	call   sys32_getpid
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getpid)

/* errno_t mount(char const *special_file, char const *dir, char const *fstype, syscall_ulong_t mountflags, void const *data) */
.section .text.x86.asm32_syscall_int80.mount
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mount)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x15
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_mount)
	call   sys32_mount
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_mount)

/* errno_t umount(char const *special_file) */
.section .text.x86.asm32_syscall_int80.umount
INTERN_WEAK_FUNCTION(__x86_asm32_int80_umount)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x16
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_umount)
	call   sys32_umount
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_umount)

/* >> setuid(2)
 * Set the UID of the calling thread (this is the so-called ~real~ UID)
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setuid(uint16_t uid) */
.section .text.x86.asm32_syscall_int80.setuid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setuid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x17
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzwq %bx, %rdi /* ARG0 = REG0 (16-bit) */
	EXTERN(sys32_setuid)
	call   sys32_setuid
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_setuid)

/* >> getuid(2)
 * @return: * : The UID of the calling thread (this is the so-called ~real~ UID) */
/* uint16_t getuid(void) */
.section .text.x86.asm32_syscall_int80.getuid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getuid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x18
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_getuid)
	call   sys32_getuid
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getuid)

/* errno_t stime(time32_t const *t) */
.section .text.x86.asm32_syscall_int80.stime
INTERN_WEAK_FUNCTION(__x86_asm32_int80_stime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x19
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_stime)
	call   sys32_stime
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_stime)

/* syscall_slong_t ptrace(syscall_ulong_t request, pid_t pid, void *addr, void *data) */
.section .text.x86.asm32_syscall_int80.ptrace
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ptrace)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_ptrace)
	call   sys32_ptrace
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_ptrace)

/* syscall_ulong_t alarm(syscall_ulong_t seconds) */
.section .text.x86.asm32_syscall_int80.alarm
INTERN_WEAK_FUNCTION(__x86_asm32_int80_alarm)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_alarm)
	call   sys32_alarm
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_alarm)

/* errno_t oldfstat(fd_t fd, struct linux_oldstat *statbuf) */
.section .text.x86.asm32_syscall_int80.oldfstat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_oldfstat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_oldfstat)
	call   sys32_oldfstat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_oldfstat)

/* Same as `select(0, NULL, NULL, NULL, NULL)' */
/* errno_t pause(void) */
.section .text.x86.asm32_syscall_int80.pause
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pause)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_pause)
	call   sys32_pause
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_pause)

/* @param: times: When NULL, set the current time */
/* errno_t utime(char const *filename, struct utimbufx32 const *times) */
.section .text.x86.asm32_syscall_int80.utime
INTERN_WEAK_FUNCTION(__x86_asm32_int80_utime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_utime)
	call   sys32_utime
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_utime)

/* errno_t stty(void) */
.section .text.x86.asm32_syscall_int80.stty
INTERN_WEAK_FUNCTION(__x86_asm32_int80_stty)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_stty)
	call   sys32_stty
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_stty)

/* errno_t gtty(void) */
.section .text.x86.asm32_syscall_int80.gtty
INTERN_WEAK_FUNCTION(__x86_asm32_int80_gtty)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x20
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_gtty)
	call   sys32_gtty
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_gtty)

/* @param: type: Set of `R_OK|W_OK|X_OK' or `F_OK' */
/* errno_t access(char const *filename, syscall_ulong_t type) */
.section .text.x86.asm32_syscall_int80.access
INTERN_WEAK_FUNCTION(__x86_asm32_int80_access)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x21
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_access)
	call   sys32_access
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_access)

/* errno_t nice(syscall_slong_t inc) */
.section .text.x86.asm32_syscall_int80.nice
INTERN_WEAK_FUNCTION(__x86_asm32_int80_nice)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x22
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_nice)
	call   sys32_nice
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_nice)

/* errno_t ftime(struct timebx32 *tp) */
.section .text.x86.asm32_syscall_int80.ftime
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ftime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x23
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_ftime)
	call   sys32_ftime
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_ftime)

/* errno_t sync(void) */
.section .text.x86.asm32_syscall_int80.sync
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sync)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x24
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_sync)
	call   sys32_sync
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_sync)

/* errno_t kill(pid_t pid, signo_t signo) */
.section .text.x86.asm32_syscall_int80.kill
INTERN_WEAK_FUNCTION(__x86_asm32_int80_kill)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x25
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movslq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_kill)
	call   sys32_kill
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_kill)

/* errno_t rename(char const *oldname, char const *newname_or_path) */
.section .text.x86.asm32_syscall_int80.rename
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rename)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x26
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_rename)
	call   sys32_rename
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_rename)

/* errno_t mkdir(char const *pathname, mode_t mode) */
.section .text.x86.asm32_syscall_int80.mkdir
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mkdir)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x27
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_mkdir)
	call   sys32_mkdir
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_mkdir)

/* errno_t rmdir(char const *path) */
.section .text.x86.asm32_syscall_int80.rmdir
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rmdir)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x28
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_rmdir)
	call   sys32_rmdir
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_rmdir)

/* fd_t dup(fd_t fd) */
.section .text.x86.asm32_syscall_int80.dup
INTERN_WEAK_FUNCTION(__x86_asm32_int80_dup)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x29
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_dup)
	call   sys32_dup
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_dup)

/* errno_t pipe(fd_t[2] pipedes) */
.section .text.x86.asm32_syscall_int80.pipe
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pipe)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x2a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_pipe)
	call   sys32_pipe
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_pipe)

/* clock_t times(struct tmsx32 *buf) */
.section .text.x86.asm32_syscall_int80.times
INTERN_WEAK_FUNCTION(__x86_asm32_int80_times)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x2b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_times)
	call   sys32_times
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_times)

/* errno_t prof(void) */
.section .text.x86.asm32_syscall_int80.prof
INTERN_WEAK_FUNCTION(__x86_asm32_int80_prof)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x2c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_prof)
	call   sys32_prof
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_prof)

/* errno_t brk(void *addr) */
.section .text.x86.asm32_syscall_int80.brk
INTERN_WEAK_FUNCTION(__x86_asm32_int80_brk)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x2d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_brk)
	call   sys32_brk
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_brk)

/* >> setgid(2)
 * Set the GID of the calling thread (this is the so-called ~real~ GID)
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setgid(uint16_t gid) */
.section .text.x86.asm32_syscall_int80.setgid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setgid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x2e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzwq %bx, %rdi /* ARG0 = REG0 (16-bit) */
	EXTERN(sys32_setgid)
	call   sys32_setgid
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_setgid)

/* >> getgid(2)
 * @return: * : The GID of the calling thread (this is the so-called ~real~ GID) */
/* uint16_t getgid(void) */
.section .text.x86.asm32_syscall_int80.getgid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getgid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x2f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_getgid)
	call   sys32_getgid
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getgid)

/* __sigactionx32_sa_handler_t signal(signo_t signo, __sigactionx32_sa_handler_t handler) */
.section .text.x86.asm32_syscall_int80.signal
INTERN_WEAK_FUNCTION(__x86_asm32_int80_signal)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x30
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_signal)
	call   sys32_signal
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_signal)

/* >> geteuid(2)
 * @return: * : The   effective  UID  of  the  calling  thread.
 *              This is the one used for most permission checks */
/* uint16_t geteuid(void) */
.section .text.x86.asm32_syscall_int80.geteuid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_geteuid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x31
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_geteuid)
	call   sys32_geteuid
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_geteuid)

/* >> getegid(2)
 * @return: * : The   effective  GID  of  the  calling  thread.
 *              This is the one used for most permission checks */
/* uint16_t getegid(void) */
.section .text.x86.asm32_syscall_int80.getegid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getegid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x32
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_getegid)
	call   sys32_getegid
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getegid)

/* errno_t acct(char const *filename) */
.section .text.x86.asm32_syscall_int80.acct
INTERN_WEAK_FUNCTION(__x86_asm32_int80_acct)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x33
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_acct)
	call   sys32_acct
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_acct)

/* errno_t umount2(char const *special_file, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.umount2
INTERN_WEAK_FUNCTION(__x86_asm32_int80_umount2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x34
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_umount2)
	call   sys32_umount2
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_umount2)

/* errno_t lock(void) */
.section .text.x86.asm32_syscall_int80.lock
INTERN_WEAK_FUNCTION(__x86_asm32_int80_lock)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x35
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_lock)
	call   sys32_lock
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_lock)

/* syscall_slong_t ioctl(fd_t fd, ioctl_t command, void *arg) */
.section .text.x86.asm32_syscall_int80.ioctl
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ioctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x36
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_ioctl)
	call   sys32_ioctl
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_ioctl)

/* syscall_slong_t fcntl(fd_t fd, fcntl_t command, void *arg) */
.section .text.x86.asm32_syscall_int80.fcntl
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fcntl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x37
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_fcntl)
	call   sys32_fcntl
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fcntl)

/* errno_t mpx(void) */
.section .text.x86.asm32_syscall_int80.mpx
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mpx)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x38
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_mpx)
	call   sys32_mpx
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_mpx)

/* errno_t setpgid(pid_t pid, pid_t pgid) */
.section .text.x86.asm32_syscall_int80.setpgid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setpgid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x39
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_setpgid)
	call   sys32_setpgid
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_setpgid)

/* errno_t ulimit(void) */
.section .text.x86.asm32_syscall_int80.ulimit
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ulimit)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x3a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_ulimit)
	call   sys32_ulimit
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_ulimit)

/* errno_t oldolduname(struct linux_oldolduname *name) */
.section .text.x86.asm32_syscall_int80.oldolduname
INTERN_WEAK_FUNCTION(__x86_asm32_int80_oldolduname)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x3b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_oldolduname)
	call   sys32_oldolduname
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_oldolduname)

/* mode_t umask(mode_t mode) */
.section .text.x86.asm32_syscall_int80.umask
INTERN_WEAK_FUNCTION(__x86_asm32_int80_umask)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x3c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_umask)
	call   sys32_umask
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_umask)

/* errno_t chroot(char const *path) */
.section .text.x86.asm32_syscall_int80.chroot
INTERN_WEAK_FUNCTION(__x86_asm32_int80_chroot)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x3d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_chroot)
	call   sys32_chroot
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_chroot)

/* errno_t ustat(dev_t dev, struct ustat *ubuf) */
.section .text.x86.asm32_syscall_int80.ustat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ustat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x3e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_ustat)
	call   sys32_ustat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_ustat)

/* fd_t dup2(fd_t oldfd, fd_t newfd) */
.section .text.x86.asm32_syscall_int80.dup2
INTERN_WEAK_FUNCTION(__x86_asm32_int80_dup2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x3f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movslq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_dup2)
	call   sys32_dup2
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_dup2)

/* pid_t getppid(void) */
.section .text.x86.asm32_syscall_int80.getppid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getppid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x40
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_getppid)
	call   sys32_getppid
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getppid)

/* pid_t getpgrp(void) */
.section .text.x86.asm32_syscall_int80.getpgrp
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getpgrp)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x41
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_getpgrp)
	call   sys32_getpgrp
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getpgrp)

/* pid_t setsid(void) */
.section .text.x86.asm32_syscall_int80.setsid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setsid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x42
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_setsid)
	call   sys32_setsid
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_setsid)

/* errno_t sigaction(signo_t signo, struct __old_kernel_sigactionx32 const *act, struct __old_kernel_sigactionx32 *oact) */
.section .text.x86.asm32_syscall_int80.sigaction
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sigaction)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x43
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_sigaction)
	call   sys32_sigaction
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_sigaction)

/* uint32_t sgetmask(void) */
.section .text.x86.asm32_syscall_int80.sgetmask
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sgetmask)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x44
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_sgetmask)
	call   sys32_sgetmask
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_sgetmask)

/* uint32_t ssetmask(uint32_t sigmask) */
.section .text.x86.asm32_syscall_int80.ssetmask
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ssetmask)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x45
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_ssetmask)
	call   sys32_ssetmask
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_ssetmask)

/* >> setreuid(2)
 * Set the real and effective UID of the calling thread.
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setreuid(uint16_t ruid, uint16_t euid) */
.section .text.x86.asm32_syscall_int80.setreuid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setreuid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x46
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzwq %bx, %rdi /* ARG0 = REG0 (16-bit) */
	movzwq %cx, %rsi /* ARG1 = REG1 (16-bit) */
	EXTERN(sys32_setreuid)
	call   sys32_setreuid
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_setreuid)

/* >> setregid(2)
 * Set the real and effective GID of the calling thread.
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setregid(uint16_t rgid, uint16_t egid) */
.section .text.x86.asm32_syscall_int80.setregid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setregid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x47
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzwq %bx, %rdi /* ARG0 = REG0 (16-bit) */
	movzwq %cx, %rsi /* ARG1 = REG1 (16-bit) */
	EXTERN(sys32_setregid)
	call   sys32_setregid
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_setregid)

/* >> sigsuspend(2), rt_sigsuspend(2)
 * Atomically save and  set the caller's  signal mask to  `set', then wait  for
 * one of the unmasked (iow: `!sigismember')-signals to arrive before restoring
 * the old signal mask.
 * @param: set: The set of signals on which to wait
 * @return: -1: [errno=EINTR] The signal handler for `signo' was executed. */
/* errno_t sigsuspend(struct __old_sigset_struct const *set) */
.section .text.x86.asm32_syscall_int80.sigsuspend
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sigsuspend)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x48
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_sigsuspend)
	call   sys32_sigsuspend
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_sigsuspend)

/* errno_t sigpending(struct __old_sigset_struct *set) */
.section .text.x86.asm32_syscall_int80.sigpending
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sigpending)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x49
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_sigpending)
	call   sys32_sigpending
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_sigpending)

/* errno_t sethostname(char const *name, size_t len) */
.section .text.x86.asm32_syscall_int80.sethostname
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sethostname)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x4a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_sethostname)
	call   sys32_sethostname
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_sethostname)

/* @param: resource: One of `RLIMIT_*' from <sys/resource.h> */
/* errno_t setrlimit(syscall_ulong_t resource, struct rlimitx32 const *rlimits) */
.section .text.x86.asm32_syscall_int80.setrlimit
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setrlimit)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x4b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_setrlimit)
	call   sys32_setrlimit
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_setrlimit)

/* @param: resource: One of `RLIMIT_*' from <sys/resource.h> */
/* errno_t getrlimit(syscall_ulong_t resource, struct rlimitx32 *rlimits) */
.section .text.x86.asm32_syscall_int80.getrlimit
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getrlimit)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x4c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_getrlimit)
	call   sys32_getrlimit
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getrlimit)

/* @param: who: One of `RUSAGE_SELF', `RUSAGE_CHILDREN' or `RUSAGE_THREAD' */
/* errno_t getrusage(syscall_slong_t who, struct rusagex32 *tv) */
.section .text.x86.asm32_syscall_int80.getrusage
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getrusage)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x4d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_getrusage)
	call   sys32_getrusage
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getrusage)

/* errno_t gettimeofday(struct timevalx32 *tv, struct timezone *tz) */
.section .text.x86.asm32_syscall_int80.gettimeofday
INTERN_WEAK_FUNCTION(__x86_asm32_int80_gettimeofday)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x4e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_gettimeofday)
	call   sys32_gettimeofday
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_gettimeofday)

/* errno_t settimeofday(struct timevalx32 const *tv, struct timezone const *tz) */
.section .text.x86.asm32_syscall_int80.settimeofday
INTERN_WEAK_FUNCTION(__x86_asm32_int80_settimeofday)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x4f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_settimeofday)
	call   sys32_settimeofday
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_settimeofday)

/* @return: * :     [count == 0] The required number of groups
 * @return: * :     [count != 0] The number of groups that were actually returned
 * @throw: -EINVAL: [count != 0] There are more than `count' groups (NOTE: No exception is thrown for this case!) */
/* ssize_t getgroups(size_t count, uint16_t[] list) */
.section .text.x86.asm32_syscall_int80.getgroups
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getgroups)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x50
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_getgroups)
	call   sys32_getgroups
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getgroups)

/* errno_t setgroups(size_t count, uint16_t const *groups) */
.section .text.x86.asm32_syscall_int80.setgroups
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setgroups)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x51
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_setgroups)
	call   sys32_setgroups
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_setgroups)

/* ssize_t select(struct sel_arg_structx32 const *arg) */
.section .text.x86.asm32_syscall_int80.select
INTERN_WEAK_FUNCTION(__x86_asm32_int80_select)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x52
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_select)
	call   sys32_select
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_select)

/* errno_t symlink(char const *link_text, char const *target_path) */
.section .text.x86.asm32_syscall_int80.symlink
INTERN_WEAK_FUNCTION(__x86_asm32_int80_symlink)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x53
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_symlink)
	call   sys32_symlink
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_symlink)

/* errno_t oldlstat(char const *filename, struct linux_oldstat *statbuf) */
.section .text.x86.asm32_syscall_int80.oldlstat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_oldlstat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x54
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_oldlstat)
	call   sys32_oldlstat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_oldlstat)

/* ssize_t readlink(char const *path, char *buf, size_t buflen) */
.section .text.x86.asm32_syscall_int80.readlink
INTERN_WEAK_FUNCTION(__x86_asm32_int80_readlink)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x55
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_readlink)
	call   sys32_readlink
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_readlink)

/* errno_t uselib(char const *library) */
.section .text.x86.asm32_syscall_int80.uselib
INTERN_WEAK_FUNCTION(__x86_asm32_int80_uselib)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x56
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_uselib)
	call   sys32_uselib
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_uselib)

/* @param: swapflags: Set of `SWAP_FLAG_*' */
/* errno_t swapon(char const *pathname, syscall_ulong_t swapflags) */
.section .text.x86.asm32_syscall_int80.swapon
INTERN_WEAK_FUNCTION(__x86_asm32_int80_swapon)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x57
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_swapon)
	call   sys32_swapon
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_swapon)

/* @param: how: One of the `RB_*' constants from <sys/reboot.h> */
/* errno_t reboot(syscall_ulong_t how) */
.section .text.x86.asm32_syscall_int80.reboot
INTERN_WEAK_FUNCTION(__x86_asm32_int80_reboot)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x58
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_reboot)
	call   sys32_reboot
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_reboot)

/* Read exactly one directory entry from `fd'
 * Note that the linux version of this system call has one additional argument `count'.
 * However, within the  linux kernel implementation,  that argument is  unconditionally
 * ignored,  and the system call will _always_ read exactly 1 directory entry from `fd'
 * @return: 1 : Read on directory entry
 * @return: 0 : End-of-directory */
/* syscall_slong_t readdir(fd_t fd, struct old_linux_direntx32 *buf) */
.section .text.x86.asm32_syscall_int80.readdir
INTERN_WEAK_FUNCTION(__x86_asm32_int80_readdir)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x59
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_readdir)
	call   sys32_readdir
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_readdir)

/* @param: prot:  Either `PROT_NONE', or set of `PROT_EXEC | PROT_WRITE | PROT_READ | PROT_SEM | PROT_SHARED'
 * @param: flags: One of `MAP_SHARED', 'MAP_SHARED_VALIDATE' or `MAP_PRIVATE', optionally or'd
 *               with  a  set of  `MAP_ANONYMOUS  | MAP_FIXED  |  MAP_GROWSDOWN |  MAP_LOCKED |
 *               MAP_NONBLOCK  |  MAP_NORESERVE  |  MAP_POPULATE  |  MAP_STACK  |  MAP_SYNC   |
 *               MAP_UNINITIALIZED | MAP_DONT_MAP | MAP_FIXED_NOREPLACE | MAP_OFFSET64_POINTER' */
/* void *mmap(void *addr, size_t len, syscall_ulong_t prot, syscall_ulong_t flags, fd_t fd, syscall_ulong_t offset) */
.section .text.x86.asm32_syscall_int80.mmap
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mmap)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x5a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %edi, %r8 /* ARG4 = REG4 */
	movzlq %ebp, %r9 /* ARG5 = REG5 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_mmap)
	call   sys32_mmap
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_mmap)

/* errno_t munmap(void *addr, size_t len) */
.section .text.x86.asm32_syscall_int80.munmap
INTERN_WEAK_FUNCTION(__x86_asm32_int80_munmap)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x5b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_munmap)
	call   sys32_munmap
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_munmap)

/* errno_t truncate(char const *filename, syscall_ulong_t length) */
.section .text.x86.asm32_syscall_int80.truncate
INTERN_WEAK_FUNCTION(__x86_asm32_int80_truncate)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x5c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_truncate)
	call   sys32_truncate
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_truncate)

/* errno_t ftruncate(fd_t fd, syscall_ulong_t length) */
.section .text.x86.asm32_syscall_int80.ftruncate
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ftruncate)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x5d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_ftruncate)
	call   sys32_ftruncate
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_ftruncate)

/* errno_t fchmod(fd_t fd, mode_t mode) */
.section .text.x86.asm32_syscall_int80.fchmod
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fchmod)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x5e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_fchmod)
	call   sys32_fchmod
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fchmod)

/* errno_t fchown(fd_t fd, uint16_t owner, uint16_t group) */
.section .text.x86.asm32_syscall_int80.fchown
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fchown)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x5f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzwq %cx, %rsi /* ARG1 = REG1 (16-bit) */
	movzwq %dx, %rdx /* ARG2 = REG2 (16-bit) */
	EXTERN(sys32_fchown)
	call   sys32_fchown
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fchown)

/* @param: which: One of `PRIO_PROCESS', `PRIO_PGRP' or `PRIO_USER' */
/* syscall_slong_t getpriority(syscall_ulong_t which, id_t who) */
.section .text.x86.asm32_syscall_int80.getpriority
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getpriority)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x60
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_getpriority)
	call   sys32_getpriority
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getpriority)

/* @param: which: One of `PRIO_PROCESS', `PRIO_PGRP' or `PRIO_USER' */
/* errno_t setpriority(syscall_ulong_t which, id_t who, syscall_ulong_t value) */
.section .text.x86.asm32_syscall_int80.setpriority
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setpriority)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x61
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_setpriority)
	call   sys32_setpriority
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_setpriority)

/* errno_t profil(void) */
.section .text.x86.asm32_syscall_int80.profil
INTERN_WEAK_FUNCTION(__x86_asm32_int80_profil)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x62
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_profil)
	call   sys32_profil
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_profil)

/* errno_t statfs(char const *file, struct statfsx32 *buf) */
.section .text.x86.asm32_syscall_int80.statfs
INTERN_WEAK_FUNCTION(__x86_asm32_int80_statfs)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x63
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_statfs)
	call   sys32_statfs
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_statfs)

/* errno_t fstatfs(fd_t file, struct statfsx32 *buf) */
.section .text.x86.asm32_syscall_int80.fstatfs
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fstatfs)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x64
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_fstatfs)
	call   sys32_fstatfs
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fstatfs)

/* errno_t ioperm(syscall_ulong_t from, syscall_ulong_t num, syscall_ulong_t turn_on) */
.section .text.x86.asm32_syscall_int80.ioperm
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ioperm)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x65
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_ioperm)
	call   sys32_ioperm
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_ioperm)

/* __LONG32_TYPE__ socketcall(__ULONG32_TYPE__ call, __ULONG32_TYPE__ *args) */
.section .text.x86.asm32_syscall_int80.socketcall
INTERN_WEAK_FUNCTION(__x86_asm32_int80_socketcall)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x66
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_socketcall)
	call   sys32_socketcall
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_socketcall)

/* ssize_t syslog(syscall_ulong_t level, char const *str, size_t len) */
.section .text.x86.asm32_syscall_int80.syslog
INTERN_WEAK_FUNCTION(__x86_asm32_int80_syslog)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x67
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_syslog)
	call   sys32_syslog
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_syslog)

/* @param: which: One of `ITIMER_REAL', `ITIMER_VIRTUAL' or `ITIMER_PROF' */
/* errno_t setitimer(syscall_ulong_t which, struct __itimervalx32 const *newval, struct __itimervalx32 *oldval) */
.section .text.x86.asm32_syscall_int80.setitimer
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setitimer)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x68
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_setitimer)
	call   sys32_setitimer
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_setitimer)

/* @param: which: One of `ITIMER_REAL', `ITIMER_VIRTUAL' or `ITIMER_PROF' */
/* errno_t getitimer(syscall_ulong_t which, struct __itimervalx32 *curr_value) */
.section .text.x86.asm32_syscall_int80.getitimer
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getitimer)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x69
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_getitimer)
	call   sys32_getitimer
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getitimer)

/* errno_t stat(char const *filename, struct linux_statx32 *statbuf) */
.section .text.x86.asm32_syscall_int80.stat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_stat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x6a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_stat)
	call   sys32_stat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_stat)

/* errno_t lstat(char const *filename, struct linux_statx32 *statbuf) */
.section .text.x86.asm32_syscall_int80.lstat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_lstat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x6b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_lstat)
	call   sys32_lstat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_lstat)

/* errno_t fstat(fd_t fd, struct linux_statx32 *statbuf) */
.section .text.x86.asm32_syscall_int80.fstat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fstat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x6c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_fstat)
	call   sys32_fstat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fstat)

/* errno_t olduname(struct linux_olduname *name) */
.section .text.x86.asm32_syscall_int80.olduname
INTERN_WEAK_FUNCTION(__x86_asm32_int80_olduname)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x6d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_olduname)
	call   sys32_olduname
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_olduname)

/* errno_t iopl(syscall_ulong_t level) */
.section .text.x86.asm32_syscall_int80.iopl
INTERN_WEAK_FUNCTION(__x86_asm32_int80_iopl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x6e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_iopl)
	call   sys32_iopl
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_iopl)

/* errno_t vhangup(void) */
.section .text.x86.asm32_syscall_int80.vhangup
INTERN_WEAK_FUNCTION(__x86_asm32_int80_vhangup)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x6f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_vhangup)
	call   sys32_vhangup
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_vhangup)

/* errno_t idle(void) */
.section .text.x86.asm32_syscall_int80.idle
INTERN_WEAK_FUNCTION(__x86_asm32_int80_idle)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x70
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_idle)
	call   sys32_idle
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_idle)

/* errno_t vm86old(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.vm86old
INTERN_WEAK_FUNCTION(__x86_asm32_int80_vm86old)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x71
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_vm86old)
	call   sys32_vm86old
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_vm86old)

/* Same as `waitpid(pid, STAT_LOC, OPTIONS)', though also fills in `USAGE' when non-NULL
 * @param: options: Set of `WNOHANG | WUNTRACED | WCONTINUED' (as a KOS extension, `WNOWAIT' is also accepted) */
/* pid_t wait4(pid_t pid, int32_t *stat_loc, syscall_ulong_t options, struct rusagex32 *usage) */
.section .text.x86.asm32_syscall_int80.wait4
INTERN_WEAK_FUNCTION(__x86_asm32_int80_wait4)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x72
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_wait4)
	call   sys32_wait4
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_wait4)

/* errno_t swapoff(char const *pathname) */
.section .text.x86.asm32_syscall_int80.swapoff
INTERN_WEAK_FUNCTION(__x86_asm32_int80_swapoff)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x73
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_swapoff)
	call   sys32_swapoff
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_swapoff)

/* errno_t sysinfo(struct __sysinfox32 *info) */
.section .text.x86.asm32_syscall_int80.sysinfo
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sysinfo)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x74
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_sysinfo)
	call   sys32_sysinfo
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_sysinfo)

/* errno_t ipc(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.ipc
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ipc)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x75
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_ipc)
	call   sys32_ipc
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_ipc)

/* Synchronize a file (including its descriptor which contains timestamps, and its size),
 * meaning  that  changes   to  its   data  and/or   descriptor  are   written  to   disk */
/* errno_t fsync(fd_t fd) */
.section .text.x86.asm32_syscall_int80.fsync
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fsync)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x76
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_fsync)
	call   sys32_fsync
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fsync)

/* void sigreturn(void) */
.section .text.x86.asm32_syscall_int80.sigreturn
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sigreturn)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x77
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_sigreturn)
	call   sys32_sigreturn
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_sigreturn)

/* pid_t clone(syscall_ulong_t flags, void *child_stack, pid_t *ptid, uintptr_t newtls, pid_t *ctid) */
.section .text.x86.asm32_syscall_int80.clone
INTERN_WEAK_FUNCTION(__x86_asm32_int80_clone)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x78
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_clone)
	call   sys32_clone
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_clone)

/* errno_t setdomainname(char const *name, size_t len) */
.section .text.x86.asm32_syscall_int80.setdomainname
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setdomainname)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x79
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_setdomainname)
	call   sys32_setdomainname
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_setdomainname)

/* errno_t uname(struct utsname *name) */
.section .text.x86.asm32_syscall_int80.uname
INTERN_WEAK_FUNCTION(__x86_asm32_int80_uname)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x7a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_uname)
	call   sys32_uname
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_uname)

/* syscall_slong_t modify_ldt(syscall_ulong_t func, void *ptr, syscall_ulong_t bytecount) */
.section .text.x86.asm32_syscall_int80.modify_ldt
INTERN_WEAK_FUNCTION(__x86_asm32_int80_modify_ldt)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x7b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_modify_ldt)
	call   sys32_modify_ldt
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_modify_ldt)

/* errno_t adjtimex(struct timex *ntx) */
.section .text.x86.asm32_syscall_int80.adjtimex
INTERN_WEAK_FUNCTION(__x86_asm32_int80_adjtimex)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x7c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_adjtimex)
	call   sys32_adjtimex
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_adjtimex)

/* @param: prot: Either `PROT_NONE', or set of `PROT_EXEC | PROT_WRITE | PROT_READ | PROT_SEM | PROT_SHARED' */
/* errno_t mprotect(void *addr, size_t len, syscall_ulong_t prot) */
.section .text.x86.asm32_syscall_int80.mprotect
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mprotect)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x7d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_mprotect)
	call   sys32_mprotect
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_mprotect)

/* @param: how: One of `SIG_BLOCK', `SIG_UNBLOCK' or `SIG_SETMASK' */
/* errno_t sigprocmask(syscall_ulong_t how, struct __old_sigset_struct const *set, struct __old_sigset_struct *oset) */
.section .text.x86.asm32_syscall_int80.sigprocmask
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sigprocmask)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x7e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_sigprocmask)
	call   sys32_sigprocmask
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_sigprocmask)

/* errno_t create_module(void) */
.section .text.x86.asm32_syscall_int80.create_module
INTERN_WEAK_FUNCTION(__x86_asm32_int80_create_module)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x7f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_create_module)
	call   sys32_create_module
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_create_module)

/* Load a  kernel  driver  from an  ELF  image  `module_image...+=len'
 * This system call exists for linux compatibility, and is implemented
 * as an alias for  `KSYSCTL_DRIVER_INSMOD:KSYSCTL_DRIVER_FORMAT_BLOB'
 * 
 * Note however that that is where linux compatibility ends. Since the
 * linux kernel does not implement any semblance of a stable ABI,  you
 * have to realize that on KOS, this system call can only load drivers
 * specifically built to run within the KOS kernel!
 * @param: uargs: The driver commandline */
/* errno_t init_module(void const *module_image, size_t len, char const *uargs) */
.section .text.x86.asm32_syscall_int80.init_module
INTERN_WEAK_FUNCTION(__x86_asm32_int80_init_module)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x80
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_init_module)
	call   sys32_init_module
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_init_module)

/* Try to unload a driver, given its `name'
 * This system call exists for linux compatibility, and is implemented
 * as an alias for  `KSYSCTL_DRIVER_DELMOD:KSYSCTL_DRIVER_FORMAT_FILE'
 * @param: name:  The name of the driver
 * @param: flags: Set of `O_NONBLOCK | O_TRUNC', where:
 *                - O_NONBLOCK: s.a. `KSYSCTL_DRIVER_DELMOD_FNONBLOCK'
 *                - O_TRUNC:    s.a. `KSYSCTL_DRIVER_DELMOD_FFORCE' */
/* errno_t delete_module(char const *name, oflag_t flags) */
.section .text.x86.asm32_syscall_int80.delete_module
INTERN_WEAK_FUNCTION(__x86_asm32_int80_delete_module)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x81
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movslq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_delete_module)
	call   sys32_delete_module
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_delete_module)

/* errno_t get_kernel_syms(void) */
.section .text.x86.asm32_syscall_int80.get_kernel_syms
INTERN_WEAK_FUNCTION(__x86_asm32_int80_get_kernel_syms)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x82
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_get_kernel_syms)
	call   sys32_get_kernel_syms
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_get_kernel_syms)

/* errno_t quotactl(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.quotactl
INTERN_WEAK_FUNCTION(__x86_asm32_int80_quotactl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x83
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_quotactl)
	call   sys32_quotactl
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_quotactl)

/* pid_t getpgid(pid_t pid) */
.section .text.x86.asm32_syscall_int80.getpgid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getpgid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x84
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_getpgid)
	call   sys32_getpgid
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getpgid)

/* errno_t fchdir(fd_t fd) */
.section .text.x86.asm32_syscall_int80.fchdir
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fchdir)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x85
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_fchdir)
	call   sys32_fchdir
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fchdir)

/* errno_t bdflush(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.bdflush
INTERN_WEAK_FUNCTION(__x86_asm32_int80_bdflush)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x86
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_bdflush)
	call   sys32_bdflush
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_bdflush)

/* errno_t sysfs(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.sysfs
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sysfs)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x87
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_sysfs)
	call   sys32_sysfs
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_sysfs)

/* errno_t personality(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.personality
INTERN_WEAK_FUNCTION(__x86_asm32_int80_personality)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x88
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_personality)
	call   sys32_personality
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_personality)

/* errno_t afs_syscall(void) */
.section .text.x86.asm32_syscall_int80.afs_syscall
INTERN_WEAK_FUNCTION(__x86_asm32_int80_afs_syscall)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x89
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_afs_syscall)
	call   sys32_afs_syscall
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_afs_syscall)

/* >> setfsuid(2)
 * Set the  user ID  for the  cred-context (s.a.  `CLONE_CRED') of  the
 * calling thread. The calling thread needs the `CAP_SETUID' privilege.
 * @return: 0:  Success.
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setfsuid(uint16_t uid) */
.section .text.x86.asm32_syscall_int80.setfsuid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setfsuid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x8a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzwq %bx, %rdi /* ARG0 = REG0 (16-bit) */
	EXTERN(sys32_setfsuid)
	call   sys32_setfsuid
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_setfsuid)

/* >> setfsgid(2)
 * Set the group  ID for  the cred-context (s.a.  `CLONE_CRED') of  the
 * calling thread. The calling thread needs the `CAP_SETGID' privilege.
 * @return: 0:  Success.
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setfsgid(uint16_t gid) */
.section .text.x86.asm32_syscall_int80.setfsgid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setfsgid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x8b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzwq %bx, %rdi /* ARG0 = REG0 (16-bit) */
	EXTERN(sys32_setfsgid)
	call   sys32_setfsgid
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_setfsgid)

/* errno_t _llseek(fd_t fd, int64_t offset, uint64_t *result, syscall_ulong_t whence) */
.section .text.x86.asm32_syscall_int80._llseek
INTERN_WEAK_FUNCTION(__x86_asm32_int80__llseek)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x8c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edx, %rax          /* %rax = REG1:REG2 */
	movzlq %ecx, %r8           /* ... */
	shlq   $(32), %rax            /* ... */
	orq    %r8, %rax           /* ... */
	movzlq %esi, %rdx /* ARG2 = REG3 */
	movq   %rax, %rsi /* ARG1 = %rax */
	movzlq %edi, %rcx /* ARG3 = REG4 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32__llseek)
	call   sys32__llseek
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80__llseek)

/* @return: * : The actual number of read entries
 * @return: 0 : End-of-directory */
/* ssize_t getdents(fd_t fd, struct linux_direntx32 *buf, size_t buflen) */
.section .text.x86.asm32_syscall_int80.getdents
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getdents)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x8d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_getdents)
	call   sys32_getdents
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getdents)

/* ssize_t _newselect(size_t nfds, struct __fd_set_struct *readfds, struct __fd_set_struct *writefds, struct __fd_set_struct *exceptfds, struct timevalx32 *timeout) */
.section .text.x86.asm32_syscall_int80._newselect
INTERN_WEAK_FUNCTION(__x86_asm32_int80__newselect)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x8e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32__newselect)
	call   sys32__newselect
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80__newselect)

/* errno_t flock(fd_t fd, syscall_ulong_t operation) */
.section .text.x86.asm32_syscall_int80.flock
INTERN_WEAK_FUNCTION(__x86_asm32_int80_flock)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x8f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_flock)
	call   sys32_flock
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_flock)

/* errno_t msync(void *addr, size_t len, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.msync
INTERN_WEAK_FUNCTION(__x86_asm32_int80_msync)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x90
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_msync)
	call   sys32_msync
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_msync)

/* Same as `read(2)', but rather than specifying a single, continuous buffer,
 * read  data into `count'  separate buffers, though  still return the actual
 * number of read bytes.
 * When `fd' has the `O_NONBLOCK' flag set, only read as much data as was
 * available at  the time  the call  was made,  and throw  `E_WOULDBLOCK'
 * no data was available at the time.
 * @return: <= SUM(iov[*].iov_len): The actual amount of read bytes
 * @return: 0                     : EOF */
/* ssize_t readv(fd_t fd, struct iovecx32 const *iovec, size_t count) */
.section .text.x86.asm32_syscall_int80.readv
INTERN_WEAK_FUNCTION(__x86_asm32_int80_readv)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x91
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_readv)
	call   sys32_readv
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_readv)

/* Same as `write(2)', but rather than specifying a single, continuous buffer,
 * write  data from `count'  separate buffers, though  still return the actual
 * number of written bytes.
 * When  `fd' has the  `O_NONBLOCK' flag set, only  write as much data
 * as possible at the time the call was made, and throw `E_WOULDBLOCK'
 * if no data could be written at the time.
 * @return: <= SUM(iov[*].iov_len): The actual amount of written bytes
 * @return: 0                     : No more data can be written */
/* ssize_t writev(fd_t fd, struct iovecx32 const *iovec, size_t count) */
.section .text.x86.asm32_syscall_int80.writev
INTERN_WEAK_FUNCTION(__x86_asm32_int80_writev)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x92
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_writev)
	call   sys32_writev
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_writev)

/* pid_t getsid(pid_t pid) */
.section .text.x86.asm32_syscall_int80.getsid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getsid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x93
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_getsid)
	call   sys32_getsid
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getsid)

/* Synchronize only the data of a file (not its descriptor which contains
 * timestamps,  and its size),  meaning that changes  are written to disk */
/* errno_t fdatasync(fd_t fd) */
.section .text.x86.asm32_syscall_int80.fdatasync
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fdatasync)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x94
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_fdatasync)
	call   sys32_fdatasync
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fdatasync)

/* errno_t _sysctl(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80._sysctl
INTERN_WEAK_FUNCTION(__x86_asm32_int80__sysctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x95
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32__sysctl)
	call   sys32__sysctl
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80__sysctl)

/* errno_t mlock(void const *addr, size_t len) */
.section .text.x86.asm32_syscall_int80.mlock
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mlock)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x96
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_mlock)
	call   sys32_mlock
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_mlock)

/* errno_t munlock(void const *addr, size_t len) */
.section .text.x86.asm32_syscall_int80.munlock
INTERN_WEAK_FUNCTION(__x86_asm32_int80_munlock)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x97
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_munlock)
	call   sys32_munlock
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_munlock)

/* @param: flags: Set of `MCL_CURRENT | MCL_FUTURE | MCL_ONFAULT' */
/* errno_t mlockall(syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.mlockall
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mlockall)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x98
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_mlockall)
	call   sys32_mlockall
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_mlockall)

/* errno_t munlockall(void) */
.section .text.x86.asm32_syscall_int80.munlockall
INTERN_WEAK_FUNCTION(__x86_asm32_int80_munlockall)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x99
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_munlockall)
	call   sys32_munlockall
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_munlockall)

/* errno_t sched_setparam(pid_t pid, struct sched_param const *param) */
.section .text.x86.asm32_syscall_int80.sched_setparam
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sched_setparam)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x9a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_sched_setparam)
	call   sys32_sched_setparam
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_sched_setparam)

/* errno_t sched_getparam(pid_t pid, struct sched_param *param) */
.section .text.x86.asm32_syscall_int80.sched_getparam
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sched_getparam)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x9b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_sched_getparam)
	call   sys32_sched_getparam
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_sched_getparam)

/* @param: policy: One of `SCHED_OTHER', `SCHED_FIFO', `SCHED_RR', `SCHED_BATCH',
 *                 `SCHED_IDLE',  optionally   or'd  with   `SCHED_RESET_ON_FORK' */
/* errno_t sched_setscheduler(pid_t pid, syscall_ulong_t policy, struct sched_param const *param) */
.section .text.x86.asm32_syscall_int80.sched_setscheduler
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sched_setscheduler)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x9c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_sched_setscheduler)
	call   sys32_sched_setscheduler
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_sched_setscheduler)

/* syscall_slong_t sched_getscheduler(pid_t pid) */
.section .text.x86.asm32_syscall_int80.sched_getscheduler
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sched_getscheduler)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x9d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_sched_getscheduler)
	call   sys32_sched_getscheduler
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_sched_getscheduler)

/* errno_t sched_yield(void) */
.section .text.x86.asm32_syscall_int80.sched_yield
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sched_yield)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x9e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_sched_yield)
	call   sys32_sched_yield
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_sched_yield)

/* syscall_slong_t sched_get_priority_max(syscall_ulong_t algorithm) */
.section .text.x86.asm32_syscall_int80.sched_get_priority_max
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sched_get_priority_max)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x9f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_sched_get_priority_max)
	call   sys32_sched_get_priority_max
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_sched_get_priority_max)

/* syscall_slong_t sched_get_priority_min(syscall_ulong_t algorithm) */
.section .text.x86.asm32_syscall_int80.sched_get_priority_min
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sched_get_priority_min)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xa0
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_sched_get_priority_min)
	call   sys32_sched_get_priority_min
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_sched_get_priority_min)

/* errno_t sched_rr_get_interval(pid_t pid, struct timespecx32 *ts) */
.section .text.x86.asm32_syscall_int80.sched_rr_get_interval
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sched_rr_get_interval)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xa1
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_sched_rr_get_interval)
	call   sys32_sched_rr_get_interval
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_sched_rr_get_interval)

/* errno_t nanosleep(struct timespecx32 const *req, struct timespecx32 *rem) */
.section .text.x86.asm32_syscall_int80.nanosleep
INTERN_WEAK_FUNCTION(__x86_asm32_int80_nanosleep)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xa2
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_nanosleep)
	call   sys32_nanosleep
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_nanosleep)

/* @param: flags: Set of `MREMAP_MAYMOVE | MREMAP_FIXED' */
/* void *mremap(void *addr, size_t old_len, size_t new_len, syscall_ulong_t flags, void *new_address) */
.section .text.x86.asm32_syscall_int80.mremap
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mremap)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xa3
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_mremap)
	call   sys32_mremap
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_mremap)

/* >> setresuid(2)
 * @return: 0 : Success
 * Set the real, effective, and saved UID of the calling thread.
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setresuid(uint16_t ruid, uint16_t euid, uint16_t suid) */
.section .text.x86.asm32_syscall_int80.setresuid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setresuid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xa4
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzwq %bx, %rdi /* ARG0 = REG0 (16-bit) */
	movzwq %cx, %rsi /* ARG1 = REG1 (16-bit) */
	movzwq %dx, %rdx /* ARG2 = REG2 (16-bit) */
	EXTERN(sys32_setresuid)
	call   sys32_setresuid
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_setresuid)

/* >> getresuid(2)
 * Get the real, effective, and saved UID of the calling thread.
 * @return: 0 : Success */
/* errno_t getresuid(uint16_t *ruid, uint16_t *euid, uint16_t *suid) */
.section .text.x86.asm32_syscall_int80.getresuid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getresuid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xa5
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_getresuid)
	call   sys32_getresuid
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getresuid)

/* errno_t vm86(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.vm86
INTERN_WEAK_FUNCTION(__x86_asm32_int80_vm86)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xa6
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_vm86)
	call   sys32_vm86
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_vm86)

/* errno_t query_module(void) */
.section .text.x86.asm32_syscall_int80.query_module
INTERN_WEAK_FUNCTION(__x86_asm32_int80_query_module)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xa7
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_query_module)
	call   sys32_query_module
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_query_module)

/* ssize_t poll(struct pollfd *fds, size_t nfds, syscall_slong_t timeout) */
.section .text.x86.asm32_syscall_int80.poll
INTERN_WEAK_FUNCTION(__x86_asm32_int80_poll)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xa8
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movslq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_poll)
	call   sys32_poll
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_poll)

/* errno_t nfsservctl(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.nfsservctl
INTERN_WEAK_FUNCTION(__x86_asm32_int80_nfsservctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xa9
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_nfsservctl)
	call   sys32_nfsservctl
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_nfsservctl)

/* >> setresgid(2)
 * Set the real, effective, and saved GID of the calling thread.
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setresgid(uint16_t rgid, uint16_t egid, uint16_t sgid) */
.section .text.x86.asm32_syscall_int80.setresgid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setresgid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xaa
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzwq %bx, %rdi /* ARG0 = REG0 (16-bit) */
	movzwq %cx, %rsi /* ARG1 = REG1 (16-bit) */
	movzwq %dx, %rdx /* ARG2 = REG2 (16-bit) */
	EXTERN(sys32_setresgid)
	call   sys32_setresgid
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_setresgid)

/* >> getresgid(2)
 * Get the real, effective, and saved GID of the calling thread.
 * @return: 0 : Success */
/* errno_t getresgid(uint16_t *rgid, uint16_t *egid, uint16_t *sgid) */
.section .text.x86.asm32_syscall_int80.getresgid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getresgid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xab
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_getresgid)
	call   sys32_getresgid
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getresgid)

/* >> prctl(2)
 * System process control interface. (Linux compatible)
 * @param: command: One of `PR_*' (from <linux/prctl.h>)
 * @param: ... : Up  to 4 additional arguments (dependent on `command')
 *               Note that some control codes  require you to pass  `0'
 *               for  all seemingly "unused" arguments. In these cases,
 *               the documentation for that command includes the number
 *               of unused, but required trailing 0s in its comment.
 * @return: * :  Return value depends on `command' */
/* syscall_slong_t prctl(unsigned int command, syscall_ulong_t arg2, syscall_ulong_t arg3, syscall_ulong_t arg4, syscall_ulong_t arg5) */
.section .text.x86.asm32_syscall_int80.prctl
INTERN_WEAK_FUNCTION(__x86_asm32_int80_prctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xac
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_prctl)
	call   sys32_prctl
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_prctl)

/* void rt_sigreturn(void) */
.section .text.x86.asm32_syscall_int80.rt_sigreturn
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rt_sigreturn)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xad
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_rt_sigreturn)
	call   sys32_rt_sigreturn
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_rt_sigreturn)

/* errno_t rt_sigaction(signo_t signo, struct __kernel_sigactionx32 const *act, struct __kernel_sigactionx32 *oact, size_t sigsetsize) */
.section .text.x86.asm32_syscall_int80.rt_sigaction
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rt_sigaction)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xae
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_rt_sigaction)
	call   sys32_rt_sigaction
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_rt_sigaction)

/* @param: how: One of `SIG_BLOCK', `SIG_UNBLOCK' or `SIG_SETMASK' */
/* errno_t rt_sigprocmask(syscall_ulong_t how, struct __sigset_struct const *set, struct __sigset_struct *oset, size_t sigsetsize) */
.section .text.x86.asm32_syscall_int80.rt_sigprocmask
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rt_sigprocmask)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xaf
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_rt_sigprocmask)
	call   sys32_rt_sigprocmask
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_rt_sigprocmask)

/* errno_t rt_sigpending(struct __sigset_struct *set, size_t sigsetsize) */
.section .text.x86.asm32_syscall_int80.rt_sigpending
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rt_sigpending)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xb0
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_rt_sigpending)
	call   sys32_rt_sigpending
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_rt_sigpending)

/* syscall_slong_t rt_sigtimedwait(struct __sigset_struct const *set, struct __siginfox32_struct *info, struct timespecx32 const *timeout, size_t sigsetsize) */
.section .text.x86.asm32_syscall_int80.rt_sigtimedwait
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rt_sigtimedwait)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xb1
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_rt_sigtimedwait)
	call   sys32_rt_sigtimedwait
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_rt_sigtimedwait)

/* @param: usigno: The signal that should be sent
 * @param: uinfo:  [0..1] Additional signal information
 * @throw: E_INVALID_ARGUMENT_UNEXPECTED_COMMAND:E_INVALID_ARGUMENT_CONTEXT_SIGINFO_SIGNO: [...]
 * @throw: E_INVALID_ARGUMENT_BAD_VALUE:E_INVALID_ARGUMENT_CONTEXT_BAD_SIGNO:              [...]
 * @throw: E_INVALID_ARGUMENT_BAD_VALUE:E_INVALID_ARGUMENT_CONTEXT_RAISE_SIGINFO_BADCODE:  [...]
 * @throw: E_ILLEGAL_OPERATION:                                                            [...] */
/* errno_t rt_sigqueueinfo(pid_t pid, signo_t usigno, struct __siginfox32_struct const *uinfo) */
.section .text.x86.asm32_syscall_int80.rt_sigqueueinfo
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rt_sigqueueinfo)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xb2
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movslq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_rt_sigqueueinfo)
	call   sys32_rt_sigqueueinfo
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_rt_sigqueueinfo)

/* >> sigsuspend(2), rt_sigsuspend(2)
 * Atomically save and  set the caller's  signal mask to  `set', then wait  for
 * one of the unmasked (iow: `!sigismember')-signals to arrive before restoring
 * the old signal mask.
 * @param: set: The set of signals on which to wait
 * @return: -1: [errno=EINTR] The signal handler for `signo' was executed. */
/* errno_t rt_sigsuspend(struct __sigset_struct const *set, size_t sigsetsize) */
.section .text.x86.asm32_syscall_int80.rt_sigsuspend
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rt_sigsuspend)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xb3
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_rt_sigsuspend)
	call   sys32_rt_sigsuspend
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_rt_sigsuspend)

/* ssize_t pread64(fd_t fd, void *buf, size_t bufsize, uint64_t offset) */
.section .text.x86.asm32_syscall_int80.pread64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pread64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xb4
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %rax          /* %rax = REG3:REG4 */
	movzlq %esi, %r8           /* ... */
	shlq   $(32), %rax            /* ... */
	orq    %r8, %rax           /* ... */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movq   %rax, %rcx /* ARG3 = %rax */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_pread64)
	call   sys32_pread64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_pread64)

/* ssize_t pwrite64(fd_t fd, void const *buf, size_t bufsize, uint64_t offset) */
.section .text.x86.asm32_syscall_int80.pwrite64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pwrite64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xb5
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %rax          /* %rax = REG3:REG4 */
	movzlq %esi, %r8           /* ... */
	shlq   $(32), %rax            /* ... */
	orq    %r8, %rax           /* ... */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movq   %rax, %rcx /* ARG3 = %rax */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_pwrite64)
	call   sys32_pwrite64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_pwrite64)

/* errno_t chown(char const *filename, uint16_t owner, uint16_t group) */
.section .text.x86.asm32_syscall_int80.chown
INTERN_WEAK_FUNCTION(__x86_asm32_int80_chown)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xb6
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzwq %cx, %rsi /* ARG1 = REG1 (16-bit) */
	movzwq %dx, %rdx /* ARG2 = REG2 (16-bit) */
	EXTERN(sys32_chown)
	call   sys32_chown
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_chown)

/* ssize_t getcwd(char *buf, size_t size) */
.section .text.x86.asm32_syscall_int80.getcwd
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getcwd)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xb7
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_getcwd)
	call   sys32_getcwd
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getcwd)

/* errno_t capget(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.capget
INTERN_WEAK_FUNCTION(__x86_asm32_int80_capget)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xb8
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_capget)
	call   sys32_capget
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_capget)

/* errno_t capset(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.capset
INTERN_WEAK_FUNCTION(__x86_asm32_int80_capset)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xb9
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_capset)
	call   sys32_capset
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_capset)

/* errno_t sigaltstack(struct __sigaltstackx32 const *ss, struct __sigaltstackx32 *oss) */
.section .text.x86.asm32_syscall_int80.sigaltstack
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sigaltstack)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xba
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_sigaltstack)
	call   sys32_sigaltstack
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_sigaltstack)

/* Read up to `num_bytes' from `infd', and write that data to `outfd'
 * Files must be opened with the relevant access permissions (same as
 * would be enforced by `read(2)' and `write(2)')
 * When `pin_offset != NULL', the pointed-to location is used to track
 * the read-position in `infd'. Note that in the event that writing to
 * this address faults, data may  have still been written to  `outfd',
 * so be sure to have this point to writable memory.
 * @param: outfd:      Output file descriptor
 * @param: infd:       Input file descriptor
 * @param: pin_offset: If non-NULL, position from which to start reading,
 *                     and updated to reflect  how much could be  copied.
 * @param: num_bytes:  The max number of bytes to transfer
 * @return: * :        The actual number of bytes transferred */
/* ssize_t sendfile(fd_t outfd, fd_t infd, __ULONG32_TYPE__ *pin_offset, size_t num_bytes) */
.section .text.x86.asm32_syscall_int80.sendfile
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sendfile)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xbb
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movslq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_sendfile)
	call   sys32_sendfile
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_sendfile)

/* errno_t getpmsg(void) */
.section .text.x86.asm32_syscall_int80.getpmsg
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getpmsg)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xbc
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_getpmsg)
	call   sys32_getpmsg
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getpmsg)

/* errno_t putpmsg(void) */
.section .text.x86.asm32_syscall_int80.putpmsg
INTERN_WEAK_FUNCTION(__x86_asm32_int80_putpmsg)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xbd
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_putpmsg)
	call   sys32_putpmsg
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_putpmsg)

/* Same as `fork(2)', but the child process may be executed within in the same VM
 * as the parent process, with the  parent process remaining suspended until  the
 * child process invokes one of the following system calls:
 *   - `exit(2)'       Terminate the child process
 *   - `exit_group(2)' Terminate the child process
 *   - `execve(2)'     Create a new VM that is populated with the specified process
 *                     image. The parent process will  only be resumed in case  the
 *                     new  program image could  be loaded successfully. Otherwise,
 *                     the call  to  `execve(2)'  returns normally  in  the  child.
 *                     Other functions from the exec()-family behave the same
 * 
 * Care  must be taken when using this system call, since you have to make sure that
 * the  child process doesn't clobber any part of its (shared) stack that may be re-
 * used once execution resumes in  the parent process. The  same also goes for  heap
 * functions,  but generally speaking:  you really shouldn't  do anything that isn't
 * reentrant after calling any one of the fork() functions (since anything but would
 * rely on underlying implementations making proper use of pthread_atfork(3),  which
 * is something that KOS intentionally doesn't do,  since I feel like doing so  only
 * adds unnecessary bloat to code that doesn't rely on this)
 * 
 * Additionally, this system call may be implemented as an alias for `fork(2)', in
 * which  case the parent process will not  actually get suspended until the child
 * process performs any of the actions above. */
/* pid_t vfork(void) */
.section .text.x86.asm32_syscall_int80.vfork
INTERN_WEAK_FUNCTION(__x86_asm32_int80_vfork)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xbe
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_vfork)
	call   sys32_vfork
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_vfork)

/* errno_t ugetrlimit(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.ugetrlimit
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ugetrlimit)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xbf
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_ugetrlimit)
	call   sys32_ugetrlimit
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_ugetrlimit)

/* void *mmap2(void *addr, size_t len, syscall_ulong_t prot, syscall_ulong_t flags, fd_t fd, syscall_ulong_t pgoffset) */
.section .text.x86.asm32_syscall_int80.mmap2
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mmap2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xc0
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %edi, %r8 /* ARG4 = REG4 */
	movzlq %ebp, %r9 /* ARG5 = REG5 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_mmap2)
	call   sys32_mmap2
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_mmap2)

/* errno_t truncate64(char const *filename, uint64_t length) */
.section .text.x86.asm32_syscall_int80.truncate64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_truncate64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xc1
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rsi          /* ARG1 = REG1:REG2 */
	movzlq %ecx, %rax          /* ... */
	shlq   $(32), %rsi            /* ... */
	orq    %rax, %rsi          /* ... */
	EXTERN(sys32_truncate64)
	call   sys32_truncate64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_truncate64)

/* errno_t ftruncate64(fd_t fd, uint64_t length) */
.section .text.x86.asm32_syscall_int80.ftruncate64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ftruncate64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xc2
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rsi          /* ARG1 = REG1:REG2 */
	movzlq %ecx, %rax          /* ... */
	shlq   $(32), %rsi            /* ... */
	orq    %rax, %rsi          /* ... */
	EXTERN(sys32_ftruncate64)
	call   sys32_ftruncate64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_ftruncate64)

/* errno_t stat64(char const *filename, struct linux_statx32_64 *statbuf) */
.section .text.x86.asm32_syscall_int80.stat64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_stat64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xc3
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_stat64)
	call   sys32_stat64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_stat64)

/* errno_t lstat64(char const *filename, struct linux_statx32_64 *statbuf) */
.section .text.x86.asm32_syscall_int80.lstat64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_lstat64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xc4
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_lstat64)
	call   sys32_lstat64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_lstat64)

/* errno_t fstat64(fd_t fd, struct linux_statx32_64 *statbuf) */
.section .text.x86.asm32_syscall_int80.fstat64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fstat64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xc5
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_fstat64)
	call   sys32_fstat64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fstat64)

/* errno_t lchown32(char const *filename, uint32_t owner, uint32_t group) */
.section .text.x86.asm32_syscall_int80.lchown32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_lchown32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xc6
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_lchown32)
	call   sys32_lchown32
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_lchown32)

/* >> getuid(2)
 * @return: * : The UID of the calling thread (this is the so-called ~real~ UID) */
/* uint32_t getuid32(void) */
.section .text.x86.asm32_syscall_int80.getuid32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getuid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xc7
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_getuid32)
	call   sys32_getuid32
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getuid32)

/* >> getgid(2)
 * @return: * : The GID of the calling thread (this is the so-called ~real~ GID) */
/* uint32_t getgid32(void) */
.section .text.x86.asm32_syscall_int80.getgid32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getgid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xc8
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_getgid32)
	call   sys32_getgid32
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getgid32)

/* >> geteuid(2)
 * @return: * : The   effective  UID  of  the  calling  thread.
 *              This is the one used for most permission checks */
/* uint32_t geteuid32(void) */
.section .text.x86.asm32_syscall_int80.geteuid32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_geteuid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xc9
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_geteuid32)
	call   sys32_geteuid32
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_geteuid32)

/* >> getegid(2)
 * @return: * : The   effective  GID  of  the  calling  thread.
 *              This is the one used for most permission checks */
/* uint32_t getegid32(void) */
.section .text.x86.asm32_syscall_int80.getegid32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getegid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xca
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_getegid32)
	call   sys32_getegid32
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getegid32)

/* >> setreuid(2)
 * Set the real and effective UID of the calling thread.
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setreuid32(uint32_t ruid, uint32_t euid) */
.section .text.x86.asm32_syscall_int80.setreuid32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setreuid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xcb
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_setreuid32)
	call   sys32_setreuid32
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_setreuid32)

/* >> setregid(2)
 * Set the real and effective GID of the calling thread.
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setregid32(uint32_t rgid, uint32_t egid) */
.section .text.x86.asm32_syscall_int80.setregid32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setregid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xcc
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_setregid32)
	call   sys32_setregid32
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_setregid32)

/* @return: * :     [count == 0] The required number of groups
 * @return: * :     [count != 0] The number of groups that were actually returned
 * @throw: -EINVAL: [count != 0] There are more than `count' groups (NOTE: No exception is thrown for this case!) */
/* ssize_t getgroups32(size_t count, uint32_t[] list) */
.section .text.x86.asm32_syscall_int80.getgroups32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getgroups32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xcd
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_getgroups32)
	call   sys32_getgroups32
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getgroups32)

/* errno_t setgroups32(size_t count, uint32_t const *groups) */
.section .text.x86.asm32_syscall_int80.setgroups32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setgroups32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xce
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_setgroups32)
	call   sys32_setgroups32
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_setgroups32)

/* errno_t fchown32(fd_t fd, uint32_t owner, uint32_t group) */
.section .text.x86.asm32_syscall_int80.fchown32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fchown32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xcf
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_fchown32)
	call   sys32_fchown32
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fchown32)

/* >> setresuid(2)
 * @return: 0 : Success
 * Set the real, effective, and saved UID of the calling thread.
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setresuid32(uint32_t ruid, uint32_t euid, uint32_t suid) */
.section .text.x86.asm32_syscall_int80.setresuid32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setresuid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xd0
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_setresuid32)
	call   sys32_setresuid32
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_setresuid32)

/* >> getresuid(2)
 * Get the real, effective, and saved UID of the calling thread.
 * @return: 0 : Success */
/* errno_t getresuid32(uint32_t *ruid, uint32_t *euid, uint32_t *suid) */
.section .text.x86.asm32_syscall_int80.getresuid32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getresuid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xd1
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_getresuid32)
	call   sys32_getresuid32
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getresuid32)

/* >> setresgid(2)
 * Set the real, effective, and saved GID of the calling thread.
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setresgid32(uint32_t rgid, uint32_t egid, uint32_t sgid) */
.section .text.x86.asm32_syscall_int80.setresgid32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setresgid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xd2
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_setresgid32)
	call   sys32_setresgid32
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_setresgid32)

/* >> getresgid(2)
 * Get the real, effective, and saved GID of the calling thread.
 * @return: 0 : Success */
/* errno_t getresgid32(uint32_t *rgid, uint32_t *egid, uint32_t *sgid) */
.section .text.x86.asm32_syscall_int80.getresgid32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getresgid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xd3
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_getresgid32)
	call   sys32_getresgid32
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getresgid32)

/* errno_t chown32(char const *filename, uint32_t owner, uint32_t group) */
.section .text.x86.asm32_syscall_int80.chown32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_chown32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xd4
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_chown32)
	call   sys32_chown32
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_chown32)

/* >> setuid(2)
 * Set the UID of the calling thread (this is the so-called ~real~ UID)
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setuid32(uint32_t uid) */
.section .text.x86.asm32_syscall_int80.setuid32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setuid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xd5
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_setuid32)
	call   sys32_setuid32
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_setuid32)

/* >> setgid(2)
 * Set the GID of the calling thread (this is the so-called ~real~ GID)
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setgid32(uint32_t gid) */
.section .text.x86.asm32_syscall_int80.setgid32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setgid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xd6
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_setgid32)
	call   sys32_setgid32
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_setgid32)

/* >> setfsuid(2)
 * Set the  user ID  for the  cred-context (s.a.  `CLONE_CRED') of  the
 * calling thread. The calling thread needs the `CAP_SETUID' privilege.
 * @return: 0:  Success.
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setfsuid32(uint32_t uid) */
.section .text.x86.asm32_syscall_int80.setfsuid32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setfsuid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xd7
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_setfsuid32)
	call   sys32_setfsuid32
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_setfsuid32)

/* >> setfsgid(2)
 * Set the group  ID for  the cred-context (s.a.  `CLONE_CRED') of  the
 * calling thread. The calling thread needs the `CAP_SETGID' privilege.
 * @return: 0:  Success.
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setfsgid32(uint32_t gid) */
.section .text.x86.asm32_syscall_int80.setfsgid32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setfsgid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xd8
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_setfsgid32)
	call   sys32_setfsgid32
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_setfsgid32)

/* errno_t pivot_root(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.pivot_root
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pivot_root)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xd9
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_pivot_root)
	call   sys32_pivot_root
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_pivot_root)

/* errno_t mincore(void *start, size_t len, uint8_t *vec) */
.section .text.x86.asm32_syscall_int80.mincore
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mincore)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xda
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_mincore)
	call   sys32_mincore
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_mincore)

/* errno_t madvise(void *addr, size_t len, syscall_ulong_t advice) */
.section .text.x86.asm32_syscall_int80.madvise
INTERN_WEAK_FUNCTION(__x86_asm32_int80_madvise)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xdb
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_madvise)
	call   sys32_madvise
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_madvise)

/* @return: * : The actual number of read entries
 * @return: 0 : End-of-directory */
/* ssize_t getdents64(fd_t fd, struct linux_dirent64 *buf, size_t buflen) */
.section .text.x86.asm32_syscall_int80.getdents64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getdents64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xdc
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_getdents64)
	call   sys32_getdents64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getdents64)

/* syscall_slong_t fcntl64(fd_t fd, fcntl_t command, void *arg) */
.section .text.x86.asm32_syscall_int80.fcntl64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fcntl64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xdd
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_fcntl64)
	call   sys32_fcntl64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fcntl64)

/* pid_t gettid(void) */
.section .text.x86.asm32_syscall_int80.gettid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_gettid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xe0
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_gettid)
	call   sys32_gettid
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_gettid)

/* ssize_t readahead(fd_t fd, uint64_t offset, size_t count) */
.section .text.x86.asm32_syscall_int80.readahead
INTERN_WEAK_FUNCTION(__x86_asm32_int80_readahead)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xe1
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rax          /* %rax = REG1:REG2 */
	movzlq %ecx, %r8           /* ... */
	shlq   $(32), %rax            /* ... */
	orq    %r8, %rax           /* ... */
	movzlq %esi, %rdx /* ARG2 = REG3 */
	movq   %rax, %rsi /* ARG1 = %rax */
	EXTERN(sys32_readahead)
	call   sys32_readahead
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_readahead)

/* @param: flags: One of `0', `XATTR_CREATE' or `XATTR_REPLACE' */
/* errno_t setxattr(char const *path, char const *name, void const *buf, size_t bufsize, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.setxattr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xe2
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_setxattr)
	call   sys32_setxattr
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_setxattr)

/* @param: flags: One of `0', `XATTR_CREATE' or `XATTR_REPLACE' */
/* errno_t lsetxattr(char const *path, char const *name, void const *buf, size_t bufsize, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.lsetxattr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_lsetxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xe3
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_lsetxattr)
	call   sys32_lsetxattr
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_lsetxattr)

/* @param: flags: One of `0', `XATTR_CREATE' or `XATTR_REPLACE' */
/* errno_t fsetxattr(fd_t fd, char const *name, void const *buf, size_t bufsize, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.fsetxattr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fsetxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xe4
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_fsetxattr)
	call   sys32_fsetxattr
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fsetxattr)

/* ssize_t getxattr(char const *path, char const *name, void *buf, size_t bufsize) */
.section .text.x86.asm32_syscall_int80.getxattr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xe5
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_getxattr)
	call   sys32_getxattr
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getxattr)

/* ssize_t lgetxattr(char const *path, char const *name, void *buf, size_t bufsize) */
.section .text.x86.asm32_syscall_int80.lgetxattr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_lgetxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xe6
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_lgetxattr)
	call   sys32_lgetxattr
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_lgetxattr)

/* ssize_t fgetxattr(fd_t fd, char const *name, void *buf, size_t bufsize) */
.section .text.x86.asm32_syscall_int80.fgetxattr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fgetxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xe7
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_fgetxattr)
	call   sys32_fgetxattr
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fgetxattr)

/* ssize_t listxattr(char const *path, char *listbuf, size_t listbufsize) */
.section .text.x86.asm32_syscall_int80.listxattr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_listxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xe8
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_listxattr)
	call   sys32_listxattr
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_listxattr)

/* ssize_t llistxattr(char const *path, char *listbuf, size_t listbufsize) */
.section .text.x86.asm32_syscall_int80.llistxattr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_llistxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xe9
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_llistxattr)
	call   sys32_llistxattr
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_llistxattr)

/* ssize_t flistxattr(fd_t fd, char *listbuf, size_t listbufsize) */
.section .text.x86.asm32_syscall_int80.flistxattr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_flistxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xea
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_flistxattr)
	call   sys32_flistxattr
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_flistxattr)

/* errno_t removexattr(char const *path, char const *name) */
.section .text.x86.asm32_syscall_int80.removexattr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_removexattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xeb
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_removexattr)
	call   sys32_removexattr
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_removexattr)

/* errno_t lremovexattr(char const *path, char const *name) */
.section .text.x86.asm32_syscall_int80.lremovexattr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_lremovexattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xec
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_lremovexattr)
	call   sys32_lremovexattr
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_lremovexattr)

/* errno_t fremovexattr(fd_t fd, char const *name) */
.section .text.x86.asm32_syscall_int80.fremovexattr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fremovexattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xed
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_fremovexattr)
	call   sys32_fremovexattr
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fremovexattr)

/* errno_t tkill(pid_t tid, signo_t signo) */
.section .text.x86.asm32_syscall_int80.tkill
INTERN_WEAK_FUNCTION(__x86_asm32_int80_tkill)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xee
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movslq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_tkill)
	call   sys32_tkill
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_tkill)

/* Read up to `num_bytes' from `infd', and write that data to `outfd'
 * Files must be opened with the relevant access permissions (same as
 * would be enforced by `read(2)' and `write(2)')
 * When `pin_offset != NULL', the pointed-to location is used to track
 * the read-position in `infd'. Note that in the event that writing to
 * this address faults, data may  have still been written to  `outfd',
 * so be sure to have this point to writable memory.
 * @param: outfd:      Output file descriptor
 * @param: infd:       Input file descriptor
 * @param: pin_offset: If non-NULL, position from which to start reading,
 *                     and updated to reflect  how much could be  copied.
 * @param: num_bytes:  The max number of bytes to transfer
 * @return: * :        The actual number of bytes transferred */
/* ssize_t sendfile64(fd_t outfd, fd_t infd, __ULONG64_TYPE__ *pin_offset, size_t num_bytes) */
.section .text.x86.asm32_syscall_int80.sendfile64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sendfile64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xef
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movslq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_sendfile64)
	call   sys32_sendfile64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_sendfile64)

/* @param: futex_op: One of `FUTEX_*' from <linux/futex.h> */
/* syscall_slong_t futex(uint32_t *uaddr, syscall_ulong_t futex_op, uint32_t val, struct timespecx32 const *timeout_or_val2, uint32_t *uaddr2, uint32_t val3) */
.section .text.x86.asm32_syscall_int80.futex
INTERN_WEAK_FUNCTION(__x86_asm32_int80_futex)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xf0
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %ebp, %r9 /* ARG5 = REG5 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_futex)
	call   sys32_futex
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_futex)

/* errno_t sched_setaffinity(pid_t pid, size_t cpusetsize, struct __cpu_set_struct const *cpuset) */
.section .text.x86.asm32_syscall_int80.sched_setaffinity
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sched_setaffinity)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xf1
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_sched_setaffinity)
	call   sys32_sched_setaffinity
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_sched_setaffinity)

/* errno_t sched_getaffinity(pid_t pid, size_t cpusetsize, struct __cpu_set_struct *cpuset) */
.section .text.x86.asm32_syscall_int80.sched_getaffinity
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sched_getaffinity)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xf2
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_sched_getaffinity)
	call   sys32_sched_getaffinity
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_sched_getaffinity)

/* errno_t set_thread_area(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.set_thread_area
INTERN_WEAK_FUNCTION(__x86_asm32_int80_set_thread_area)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xf3
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_set_thread_area)
	call   sys32_set_thread_area
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_set_thread_area)

/* errno_t get_thread_area(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.get_thread_area
INTERN_WEAK_FUNCTION(__x86_asm32_int80_get_thread_area)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xf4
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_get_thread_area)
	call   sys32_get_thread_area
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_get_thread_area)

/* errno_t io_setup(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.io_setup
INTERN_WEAK_FUNCTION(__x86_asm32_int80_io_setup)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xf5
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_io_setup)
	call   sys32_io_setup
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_io_setup)

/* errno_t io_destroy(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.io_destroy
INTERN_WEAK_FUNCTION(__x86_asm32_int80_io_destroy)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xf6
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_io_destroy)
	call   sys32_io_destroy
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_io_destroy)

/* errno_t io_getevents(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.io_getevents
INTERN_WEAK_FUNCTION(__x86_asm32_int80_io_getevents)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xf7
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_io_getevents)
	call   sys32_io_getevents
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_io_getevents)

/* errno_t io_submit(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.io_submit
INTERN_WEAK_FUNCTION(__x86_asm32_int80_io_submit)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xf8
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_io_submit)
	call   sys32_io_submit
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_io_submit)

/* errno_t io_cancel(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.io_cancel
INTERN_WEAK_FUNCTION(__x86_asm32_int80_io_cancel)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xf9
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_io_cancel)
	call   sys32_io_cancel
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_io_cancel)

/* errno_t fadvise64(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.fadvise64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fadvise64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfa
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_fadvise64)
	call   sys32_fadvise64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fadvise64)

/* Terminate the calling process
 * @param: exit_code: Thread exit code (as returned by `wait(2)') */
/* void exit_group(syscall_ulong_t exit_code) */
.section .text.x86.asm32_syscall_int80.exit_group
INTERN_WEAK_FUNCTION(__x86_asm32_int80_exit_group)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfc
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_exit_group)
	call   sys32_exit_group
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_exit_group)

/* errno_t lookup_dcookie(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.lookup_dcookie
INTERN_WEAK_FUNCTION(__x86_asm32_int80_lookup_dcookie)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfd
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_lookup_dcookie)
	call   sys32_lookup_dcookie
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_lookup_dcookie)

/* >> epoll_create(2)
 * Deprecated alias for `epoll_create1(0)' (the `size' argument is ignored)
 * @return: * : The newly created epoll control descriptor.
 * @return: -1: Error (s.a. `errno') */
/* fd_t epoll_create(syscall_ulong_t size) */
.section .text.x86.asm32_syscall_int80.epoll_create
INTERN_WEAK_FUNCTION(__x86_asm32_int80_epoll_create)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfe
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_epoll_create)
	call   sys32_epoll_create
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_epoll_create)

/* >> epoll_ctl(2)
 * Manipulate a given  epoll controller  `epfd', as previously  returned by  `epoll_create1(2)'
 * in order to register (`EPOLL_CTL_ADD'), remove (`EPOLL_CTL_DEL') or modify (`EPOLL_CTL_MOD')
 * the file descriptors being monitored
 * @param: op:       One of `EPOLL_CTL_ADD', `EPOLL_CTL_DEL' or `EPOLL_CTL_MOD'
 * @param: fd:       The file descriptor to add/remove/modify
 * @param: info:     The new configuration for `fd' (ignored when `op' is `EPOLL_CTL_DEL')
 * @return: 0 :      Success
 * @return: -EEXIST: [op=EPOLL_CTL_ADD] The given `fd' (and its kernel object) has already been registered
 * @return: -ENOENT: [op=EPOLL_CTL_MOD|EPOLL_CTL_DEL] The given `fd' (and its kernel object) aren't registered
 * @throw: E_ILLEGAL_REFERENCE_LOOP: The  given  `fd'  is  another  epoll  that either
 *                                   forms a loop with `epfd', or has too many nested.
 * @throw: E_INVALID_ARGUMENT_UNKNOWN_COMMAND:E_INVALID_ARGUMENT_CONTEXT_EPOLL_CTL_OP: [...] */
/* errno_t epoll_ctl(fd_t epfd, syscall_ulong_t op, fd_t fd, struct epoll_event *info) */
.section .text.x86.asm32_syscall_int80.epoll_ctl
INTERN_WEAK_FUNCTION(__x86_asm32_int80_epoll_ctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xff
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movslq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_epoll_ctl)
	call   sys32_epoll_ctl
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_epoll_ctl)

/* >> epoll_wait(2)
 * Wait until at least one of the conditions monitored by `epfd' to be met.
 * @param: epfd:      The epoll controller on which to wait.
 * @param: events:    A buffer where the kernel can store information on the
 *                    events that actually took place.
 * @param: maxevents: The # of events that can be stored in `events' (must be >= 1)
 * @param: timeout:   The max amount of time (in milliseconds) before  returning
 *                    in the case where no event occurred in the mean time. When
 *                    set to `-1', wait indefinitely
 * @return: >= 1:     The # of events that happened (written to the first `return'
 *                    items of `events')
 * @return: 0:        No events happened before `timeout' expired.
 * @return: -1:       Error (s.a. `errno') */
/* ssize_t epoll_wait(fd_t epfd, struct epoll_event *events, size_t maxevents, syscall_slong_t timeout) */
.section .text.x86.asm32_syscall_int80.epoll_wait
INTERN_WEAK_FUNCTION(__x86_asm32_int80_epoll_wait)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x100
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movslq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_epoll_wait)
	call   sys32_epoll_wait
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_epoll_wait)

/* errno_t remap_file_pages(void *start, size_t size, syscall_ulong_t prot, size_t pgoff, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.remap_file_pages
INTERN_WEAK_FUNCTION(__x86_asm32_int80_remap_file_pages)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x101
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_remap_file_pages)
	call   sys32_remap_file_pages
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_remap_file_pages)

/* pid_t set_tid_address(pid_t *tidptr) */
.section .text.x86.asm32_syscall_int80.set_tid_address
INTERN_WEAK_FUNCTION(__x86_asm32_int80_set_tid_address)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x102
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_set_tid_address)
	call   sys32_set_tid_address
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_set_tid_address)

/* errno_t timer_create(clockid_t clock_id, struct sigevent *evp, timer_t *timerid) */
.section .text.x86.asm32_syscall_int80.timer_create
INTERN_WEAK_FUNCTION(__x86_asm32_int80_timer_create)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x103
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_timer_create)
	call   sys32_timer_create
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_timer_create)

/* @param: flags: Set of `0 | TIMER_ABSTIME' */
/* errno_t timer_settime(timer_t timerid, syscall_ulong_t flags, struct itimerspecx32 const *value, struct itimerspecx32 *ovalue) */
.section .text.x86.asm32_syscall_int80.timer_settime
INTERN_WEAK_FUNCTION(__x86_asm32_int80_timer_settime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x104
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_timer_settime)
	call   sys32_timer_settime
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_timer_settime)

/* errno_t timer_gettime(timer_t timerid, struct itimerspecx32 *value) */
.section .text.x86.asm32_syscall_int80.timer_gettime
INTERN_WEAK_FUNCTION(__x86_asm32_int80_timer_gettime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x105
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_timer_gettime)
	call   sys32_timer_gettime
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_timer_gettime)

/* syscall_slong_t timer_getoverrun(timer_t timerid) */
.section .text.x86.asm32_syscall_int80.timer_getoverrun
INTERN_WEAK_FUNCTION(__x86_asm32_int80_timer_getoverrun)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x106
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_timer_getoverrun)
	call   sys32_timer_getoverrun
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_timer_getoverrun)

/* errno_t timer_delete(timer_t timerid) */
.section .text.x86.asm32_syscall_int80.timer_delete
INTERN_WEAK_FUNCTION(__x86_asm32_int80_timer_delete)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x107
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_timer_delete)
	call   sys32_timer_delete
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_timer_delete)

/* errno_t clock_settime(clockid_t clock_id, struct timespecx32 const *tp) */
.section .text.x86.asm32_syscall_int80.clock_settime
INTERN_WEAK_FUNCTION(__x86_asm32_int80_clock_settime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x108
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_clock_settime)
	call   sys32_clock_settime
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_clock_settime)

/* errno_t clock_gettime(clockid_t clock_id, struct timespecx32 *tp) */
.section .text.x86.asm32_syscall_int80.clock_gettime
INTERN_WEAK_FUNCTION(__x86_asm32_int80_clock_gettime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x109
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_clock_gettime)
	call   sys32_clock_gettime
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_clock_gettime)

/* errno_t clock_getres(clockid_t clock_id, struct timespecx32 *res) */
.section .text.x86.asm32_syscall_int80.clock_getres
INTERN_WEAK_FUNCTION(__x86_asm32_int80_clock_getres)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x10a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_clock_getres)
	call   sys32_clock_getres
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_clock_getres)

/* errno_t clock_nanosleep(clockid_t clock_id, syscall_ulong_t flags, struct timespecx32 const *requested_time, struct timespecx32 *remaining) */
.section .text.x86.asm32_syscall_int80.clock_nanosleep
INTERN_WEAK_FUNCTION(__x86_asm32_int80_clock_nanosleep)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x10b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_clock_nanosleep)
	call   sys32_clock_nanosleep
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_clock_nanosleep)

/* errno_t statfs64(char const *file, struct statfsx32_64 *buf) */
.section .text.x86.asm32_syscall_int80.statfs64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_statfs64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x10c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_statfs64)
	call   sys32_statfs64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_statfs64)

/* errno_t fstatfs64(fd_t file, struct statfsx32_64 *buf) */
.section .text.x86.asm32_syscall_int80.fstatfs64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fstatfs64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x10d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_fstatfs64)
	call   sys32_fstatfs64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fstatfs64)

/* errno_t tgkill(pid_t pid, pid_t tid, signo_t signo) */
.section .text.x86.asm32_syscall_int80.tgkill
INTERN_WEAK_FUNCTION(__x86_asm32_int80_tgkill)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x10e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movslq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_tgkill)
	call   sys32_tgkill
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_tgkill)

/* @param: times:    When NULL, set the current time
 * @param: times[0]: New access time
 * @param: times[1]: New last-modified time */
/* errno_t utimes(char const *filename, struct timevalx32 const[2] times) */
.section .text.x86.asm32_syscall_int80.utimes
INTERN_WEAK_FUNCTION(__x86_asm32_int80_utimes)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x10f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_utimes)
	call   sys32_utimes
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_utimes)

/* errno_t fadvise64_64(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.fadvise64_64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fadvise64_64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x110
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_fadvise64_64)
	call   sys32_fadvise64_64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fadvise64_64)

/* errno_t vserver(void) */
.section .text.x86.asm32_syscall_int80.vserver
INTERN_WEAK_FUNCTION(__x86_asm32_int80_vserver)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x111
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_vserver)
	call   sys32_vserver
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_vserver)

/* errno_t mbind(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.mbind
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mbind)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x112
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_mbind)
	call   sys32_mbind
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_mbind)

/* errno_t get_mempolicy(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.get_mempolicy
INTERN_WEAK_FUNCTION(__x86_asm32_int80_get_mempolicy)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x113
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_get_mempolicy)
	call   sys32_get_mempolicy
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_get_mempolicy)

/* errno_t set_mempolicy(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.set_mempolicy
INTERN_WEAK_FUNCTION(__x86_asm32_int80_set_mempolicy)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x114
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_set_mempolicy)
	call   sys32_set_mempolicy
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_set_mempolicy)

/* fd_t mq_open(char const *name, oflag_t oflags, mode_t mode) */
.section .text.x86.asm32_syscall_int80.mq_open
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mq_open)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x115
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movslq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_mq_open)
	call   sys32_mq_open
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_mq_open)

/* errno_t mq_unlink(char const *name) */
.section .text.x86.asm32_syscall_int80.mq_unlink
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mq_unlink)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x116
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_mq_unlink)
	call   sys32_mq_unlink
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_mq_unlink)

/* errno_t mq_timedsend(fd_t mqdes, char const *msg_ptr, size_t msg_len, uint32_t msg_prio, struct timespecx32 const *abs_timeout) */
.section .text.x86.asm32_syscall_int80.mq_timedsend
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mq_timedsend)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x117
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_mq_timedsend)
	call   sys32_mq_timedsend
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_mq_timedsend)

/* ssize_t mq_timedreceive(fd_t mqdes, char *msg_ptr, size_t msg_len, uint32_t *pmsg_prio, struct timespecx32 const *abs_timeout) */
.section .text.x86.asm32_syscall_int80.mq_timedreceive
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mq_timedreceive)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x118
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_mq_timedreceive)
	call   sys32_mq_timedreceive
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_mq_timedreceive)

/* errno_t mq_notify(fd_t mqdes, struct sigevent const *notification) */
.section .text.x86.asm32_syscall_int80.mq_notify
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mq_notify)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x119
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_mq_notify)
	call   sys32_mq_notify
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_mq_notify)

/* errno_t mq_getsetattr(fd_t mqdes, struct mq_attr const *newattr, struct mq_attr *oldattr) */
.section .text.x86.asm32_syscall_int80.mq_getsetattr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mq_getsetattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x11a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_mq_getsetattr)
	call   sys32_mq_getsetattr
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_mq_getsetattr)

/* errno_t kexec_load(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.kexec_load
INTERN_WEAK_FUNCTION(__x86_asm32_int80_kexec_load)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x11b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_kexec_load)
	call   sys32_kexec_load
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_kexec_load)

/* @param: idtype:  One of `P_ALL', `P_PID', `P_PGID'
 * @param: options: At least one of `WEXITED', `WSTOPPED', `WCONTINUED', optionally or'd with `WNOHANG | WNOWAIT' */
/* errno_t waitid(syscall_ulong_t idtype, id_t id, struct __siginfox32_struct *infop, syscall_ulong_t options, struct rusagex32 *ru) */
.section .text.x86.asm32_syscall_int80.waitid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_waitid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x11c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_waitid)
	call   sys32_waitid
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_waitid)

/* errno_t add_key(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.add_key
INTERN_WEAK_FUNCTION(__x86_asm32_int80_add_key)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x11e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_add_key)
	call   sys32_add_key
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_add_key)

/* errno_t request_key(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.request_key
INTERN_WEAK_FUNCTION(__x86_asm32_int80_request_key)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x11f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_request_key)
	call   sys32_request_key
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_request_key)

/* errno_t keyctl(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.keyctl
INTERN_WEAK_FUNCTION(__x86_asm32_int80_keyctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x120
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_keyctl)
	call   sys32_keyctl
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_keyctl)

/* NOTE: Linux calls `who' `which', and `id' `who' (refactored to prevent confusion)
 * @param: who: One of `IOPRIO_WHO_PROCESS', `IOPRIO_WHO_PGRP' or `IOPRIO_WHO_USER' */
/* errno_t ioprio_set(syscall_ulong_t who, syscall_ulong_t id, syscall_ulong_t ioprio) */
.section .text.x86.asm32_syscall_int80.ioprio_set
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ioprio_set)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x121
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_ioprio_set)
	call   sys32_ioprio_set
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_ioprio_set)

/* NOTE: Linux calls `who' `which', and `id' `who' (refactored to prevent confusion)
 * @param: who: One of `IOPRIO_WHO_PROCESS', `IOPRIO_WHO_PGRP' or `IOPRIO_WHO_USER' */
/* syscall_slong_t ioprio_get(syscall_ulong_t who, syscall_ulong_t id) */
.section .text.x86.asm32_syscall_int80.ioprio_get
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ioprio_get)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x122
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_ioprio_get)
	call   sys32_ioprio_get
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_ioprio_get)

/* fd_t inotify_init(void) */
.section .text.x86.asm32_syscall_int80.inotify_init
INTERN_WEAK_FUNCTION(__x86_asm32_int80_inotify_init)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x123
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_inotify_init)
	call   sys32_inotify_init
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_inotify_init)

/* @param: mask: Set of `IN_ALL_EVENTS | ...' */
/* int inotify_add_watch(fd_t notify_fd, char const *pathname, uint32_t mask) */
.section .text.x86.asm32_syscall_int80.inotify_add_watch
INTERN_WEAK_FUNCTION(__x86_asm32_int80_inotify_add_watch)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x124
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_inotify_add_watch)
	call   sys32_inotify_add_watch
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_inotify_add_watch)

/* @param: wd: Watch fd (as returned by `inotify_add_watch{_at}') */
/* errno_t inotify_rm_watch(fd_t notify_fd, int wd) */
.section .text.x86.asm32_syscall_int80.inotify_rm_watch
INTERN_WEAK_FUNCTION(__x86_asm32_int80_inotify_rm_watch)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x125
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movslq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_inotify_rm_watch)
	call   sys32_inotify_rm_watch
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_inotify_rm_watch)

/* errno_t migrate_pages(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.migrate_pages
INTERN_WEAK_FUNCTION(__x86_asm32_int80_migrate_pages)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x126
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_migrate_pages)
	call   sys32_migrate_pages
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_migrate_pages)

/* Open  a  new  file  handle  to  the  file  specified  by `filename'
 * When  `oflags & O_CREAT',   then  `mode'   specifies  the   initial
 * file  access  permissions with  which  the file  should  be opened.
 * On KOS, the returned handle can be anything, but is usually one of:
 *   - HANDLE_TYPE_PATH:       When `O_PATH' was given
 *   - HANDLE_TYPE_FILEHANDLE: For `S_IFREG' regular files
 *   - HANDLE_TYPE_FIFOHANDLE: For `S_IFIFO' pipe files
 *   - HANDLE_TYPE_DIRHANDLE:  For `S_IFDIR' directories
 *   - HANDLE_TYPE_MFILE:      The actual filesystem object (including device files)
 *   - *:                      Certain filesystem names can literally return anything, such
 *                             as `/proc/self/fd/1234',  which  is  more  like  `dup(1234)' */
/* fd_t openat(fd_t dirfd, char const *filename, oflag_t oflags, mode_t mode) */
.section .text.x86.asm32_syscall_int80.openat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_openat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x127
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movslq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_openat)
	call   sys32_openat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_openat)

/* errno_t mkdirat(fd_t dirfd, char const *pathname, mode_t mode) */
.section .text.x86.asm32_syscall_int80.mkdirat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mkdirat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x128
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_mkdirat)
	call   sys32_mkdirat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_mkdirat)

/* errno_t mknodat(fd_t dirfd, char const *nodename, mode_t mode, dev_t dev) */
.section .text.x86.asm32_syscall_int80.mknodat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mknodat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x129
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_mknodat)
	call   sys32_mknodat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_mknodat)

/* @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_DOSPATH' */
/* errno_t fchownat(fd_t dirfd, char const *filename, uid_t owner, gid_t group, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.fchownat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fchownat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x12a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_fchownat)
	call   sys32_fchownat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fchownat)

/* errno_t futimesat(fd_t dirfd, char const *filename, struct timevalx32 const[2] times) */
.section .text.x86.asm32_syscall_int80.futimesat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_futimesat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x12b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_futimesat)
	call   sys32_futimesat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_futimesat)

/* @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_DOSPATH' */
/* errno_t fstatat64(fd_t dirfd, char const *filename, struct linux_statx32_64 *statbuf, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.fstatat64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fstatat64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x12c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_fstatat64)
	call   sys32_fstatat64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fstatat64)

/* @param: flags: Set of `0 | AT_REMOVEDIR | AT_REMOVEREG | AT_DOSPATH' */
/* errno_t unlinkat(fd_t dirfd, char const *name, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.unlinkat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_unlinkat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x12d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_unlinkat)
	call   sys32_unlinkat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_unlinkat)

/* errno_t renameat(fd_t oldfd, char const *oldname, fd_t newfd, char const *newname_or_path) */
.section .text.x86.asm32_syscall_int80.renameat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_renameat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x12e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movslq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_renameat)
	call   sys32_renameat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_renameat)

/* @param: flags: Set of `0 | AT_EMPTY_PATH | AT_SYMLINK_FOLLOW | AT_DOSPATH' */
/* errno_t linkat(fd_t fromfd, char const *existing_file, fd_t tofd, char const *target_path, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.linkat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_linkat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x12f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movslq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_linkat)
	call   sys32_linkat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_linkat)

/* errno_t symlinkat(char const *link_text, fd_t tofd, char const *target_path) */
.section .text.x86.asm32_syscall_int80.symlinkat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_symlinkat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x130
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movslq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_symlinkat)
	call   sys32_symlinkat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_symlinkat)

/* ssize_t readlinkat(fd_t dirfd, char const *path, char *buf, size_t buflen) */
.section .text.x86.asm32_syscall_int80.readlinkat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_readlinkat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x131
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_readlinkat)
	call   sys32_readlinkat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_readlinkat)

/* @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_DOSPATH' */
/* errno_t fchmodat(fd_t dirfd, char const *filename, mode_t mode, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.fchmodat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fchmodat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x132
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_fchmodat)
	call   sys32_fchmodat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fchmodat)

/* @param: type: Set of `R_OK | W_OK | X_OK' or `F_OK' */
/* errno_t faccessat(fd_t dirfd, char const *filename, syscall_ulong_t type) */
.section .text.x86.asm32_syscall_int80.faccessat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_faccessat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x133
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_faccessat)
	call   sys32_faccessat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_faccessat)

/* ssize_t pselect6(size_t nfds, struct __fd_set_struct *readfds, struct __fd_set_struct *writefds, struct __fd_set_struct *exceptfds, struct timespecx32 const *timeout, struct __sigset_with_sizex32 const *sigmask_sigset_with_size) */
.section .text.x86.asm32_syscall_int80.pselect6
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pselect6)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x134
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %ebp, %r9 /* ARG5 = REG5 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_pselect6)
	call   sys32_pselect6
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_pselect6)

/* ssize_t ppoll(struct pollfd *fds, size_t nfds, struct timespecx32 const *timeout_ts, struct __sigset_struct const *sigmask, size_t sigsetsize) */
.section .text.x86.asm32_syscall_int80.ppoll
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ppoll)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x135
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_ppoll)
	call   sys32_ppoll
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_ppoll)

/* param: what: Set of `CLONE_*' */
/* errno_t unshare(syscall_ulong_t what) */
.section .text.x86.asm32_syscall_int80.unshare
INTERN_WEAK_FUNCTION(__x86_asm32_int80_unshare)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x136
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_unshare)
	call   sys32_unshare
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_unshare)

/* errno_t set_robust_list(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.set_robust_list
INTERN_WEAK_FUNCTION(__x86_asm32_int80_set_robust_list)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x137
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_set_robust_list)
	call   sys32_set_robust_list
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_set_robust_list)

/* errno_t get_robust_list(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.get_robust_list
INTERN_WEAK_FUNCTION(__x86_asm32_int80_get_robust_list)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x138
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_get_robust_list)
	call   sys32_get_robust_list
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_get_robust_list)

/* @param: flags: Set of `SPLICE_F_MOVE | SPLICE_F_NONBLOCK | SPLICE_F_MORE | SPLICE_F_GIFT' */
/* ssize_t splice(fd_t fdin, uint64_t *offin, fd_t fdout, uint64_t *offout, size_t length, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.splice
INTERN_WEAK_FUNCTION(__x86_asm32_int80_splice)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x139
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %ebp, %r9 /* ARG5 = REG5 */
	movslq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_splice)
	call   sys32_splice
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_splice)

/* @param: flags: Set of `SYNC_FILE_RANGE_WAIT_BEFORE | SYNC_FILE_RANGE_WRITE | SYNC_FILE_RANGE_WAIT_AFTER' */
/* errno_t sync_file_range(fd_t fd, uint64_t offset, uint64_t count, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.sync_file_range
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sync_file_range)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x13a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edx, %rax          /* %rax = REG1:REG2 */
	movzlq %ecx, %r8           /* ... */
	shlq   $(32), %rax            /* ... */
	orq    %r8, %rax           /* ... */
	movzlq %edi, %rdx          /* ARG2 = REG3:REG4 */
	movzlq %esi, %r8           /* ... */
	shlq   $(32), %rdx            /* ... */
	orq    %r8, %rdx           /* ... */
	movq   %rax, %rsi /* ARG1 = %rax */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ebp, %rcx /* ARG3 = REG5 */
	EXTERN(sys32_sync_file_range)
	call   sys32_sync_file_range
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_sync_file_range)

/* @param: flags: Set of `SPLICE_F_MOVE | SPLICE_F_NONBLOCK | SPLICE_F_MORE | SPLICE_F_GIFT' */
/* ssize_t tee(fd_t fdin, fd_t fdout, size_t length, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.tee
INTERN_WEAK_FUNCTION(__x86_asm32_int80_tee)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x13b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movslq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_tee)
	call   sys32_tee
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_tee)

/* @param: flags: Set of `SPLICE_F_MOVE | SPLICE_F_NONBLOCK | SPLICE_F_MORE | SPLICE_F_GIFT' */
/* ssize_t vmsplice(fd_t fdout, struct iovecx32 const *iov, size_t count, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.vmsplice
INTERN_WEAK_FUNCTION(__x86_asm32_int80_vmsplice)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x13c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_vmsplice)
	call   sys32_vmsplice
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_vmsplice)

/* errno_t move_pages(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.move_pages
INTERN_WEAK_FUNCTION(__x86_asm32_int80_move_pages)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x13d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_move_pages)
	call   sys32_move_pages
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_move_pages)

/* errno_t getcpu(uint32_t *cpu, uint32_t *node, struct getcpu_cache *tcache) */
.section .text.x86.asm32_syscall_int80.getcpu
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getcpu)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x13e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_getcpu)
	call   sys32_getcpu
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getcpu)

/* >> epoll_pwait(2)
 * Same as `epoll_wait(2)', but change the calling thread's signal mask to `ss' while
 * waiting.  Wait until at least one of the conditions monitored by `epfd' to be met.
 * @param: epfd:      The epoll controller on which to wait.
 * @param: events:    A buffer where the kernel can store information on the
 *                    events that actually took place.
 * @param: maxevents: The # of events that can be stored in `events' (must be >= 1)
 * @param: timeout:   The max amount of time (in milliseconds) before  returning
 *                    in the case where no event occurred in the mean time. When
 *                    set to `-1', wait indefinitely
 * @param: ss:        The signal mask to apply while waiting for an event to happen.
 * @return: >= 1:     The # of events that happened (written to the first `return'
 *                    items of `events')
 * @return: 0:        No events happened before `timeout' expired.
 * @return: -1:       Error (s.a. `errno') */
/* ssize_t epoll_pwait(fd_t epfd, struct epoll_event *events, size_t maxevents, syscall_slong_t timeout, struct __sigset_struct const *ss, size_t sigsetsize) */
.section .text.x86.asm32_syscall_int80.epoll_pwait
INTERN_WEAK_FUNCTION(__x86_asm32_int80_epoll_pwait)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x13f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %ebp, %r9 /* ARG5 = REG5 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movslq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_epoll_pwait)
	call   sys32_epoll_pwait
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_epoll_pwait)

/* @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_CHANGE_BTIME | AT_DOSPATH' */
/* errno_t utimensat(fd_t dirfd, char const *filename, struct timespecx32 const[2] times, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.utimensat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_utimensat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x140
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_utimensat)
	call   sys32_utimensat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_utimensat)

/* Create a poll(2)-able file descriptor which can be used to wait for the
 * delivery of signals masked by `sigmask' to the waiting  thread/process. */
/* errno_t signalfd(fd_t fd, struct __sigset_struct const *sigmask, size_t sigmasksize) */
.section .text.x86.asm32_syscall_int80.signalfd
INTERN_WEAK_FUNCTION(__x86_asm32_int80_signalfd)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x141
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_signalfd)
	call   sys32_signalfd
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_signalfd)

/* Return file descriptor for new interval timer source
 * @param: flags: Set of `0 | TFD_NONBLOCK | TFD_CLOEXEC | TFD_CLOFORK' */
/* fd_t timerfd_create(clockid_t clock_id, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.timerfd_create
INTERN_WEAK_FUNCTION(__x86_asm32_int80_timerfd_create)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x142
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_timerfd_create)
	call   sys32_timerfd_create
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_timerfd_create)

/* fd_t eventfd(syscall_ulong_t initval) */
.section .text.x86.asm32_syscall_int80.eventfd
INTERN_WEAK_FUNCTION(__x86_asm32_int80_eventfd)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x143
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_eventfd)
	call   sys32_eventfd
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_eventfd)

/* @param: mode: Set of `0 | FALLOC_FL_KEEP_SIZE | FALLOC_FL_PUNCH_HOLE | FALLOC_FL_COLLAPSE_RANGE | FALLOC_FL_ZERO_RANGE' */
/* errno_t fallocate(fd_t fd, syscall_ulong_t mode, syscall_ulong_t offset, syscall_ulong_t length) */
.section .text.x86.asm32_syscall_int80.fallocate
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fallocate)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x144
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_fallocate)
	call   sys32_fallocate
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fallocate)

/* Set next expiration time of interval timer source `timerfd' to `utmr'.
 * If `flags'  has the  `TFD_TIMER_ABSTIME' flag  set the  timeout  value
 * is absolute. Optionally return the old expiration time in `otmr'
 * @param: flags: Set of `0 | TFD_TIMER_ABSTIME' */
/* errno_t timerfd_settime(fd_t timerfd, syscall_ulong_t flags, struct itimerspecx32 const *utmr, struct itimerspecx32 *otmr) */
.section .text.x86.asm32_syscall_int80.timerfd_settime
INTERN_WEAK_FUNCTION(__x86_asm32_int80_timerfd_settime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x145
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_timerfd_settime)
	call   sys32_timerfd_settime
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_timerfd_settime)

/* Return the next expiration time of UFD */
/* errno_t timerfd_gettime(fd_t timerfd, struct itimerspecx32 *otmr) */
.section .text.x86.asm32_syscall_int80.timerfd_gettime
INTERN_WEAK_FUNCTION(__x86_asm32_int80_timerfd_gettime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x146
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_timerfd_gettime)
	call   sys32_timerfd_gettime
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_timerfd_gettime)

/* Create a poll(2)-able file descriptor which can be used to wait for the
 * delivery of signals masked by `sigmask' to the waiting  thread/process.
 * @param: flags: Set of `0 | SFD_NONBLOCK | SFD_CLOEXEC | SFD_CLOFORK' */
/* errno_t signalfd4(fd_t fd, struct __sigset_struct const *sigmask, size_t sigmasksize, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.signalfd4
INTERN_WEAK_FUNCTION(__x86_asm32_int80_signalfd4)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x147
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_signalfd4)
	call   sys32_signalfd4
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_signalfd4)

/* @param: flags: Set of `EFD_SEMAPHORE | EFD_NONBLOCK | EFD_CLOEXEC | EFD_CLOFORK' */
/* fd_t eventfd2(syscall_ulong_t initval, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.eventfd2
INTERN_WEAK_FUNCTION(__x86_asm32_int80_eventfd2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x148
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_eventfd2)
	call   sys32_eventfd2
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_eventfd2)

/* >> epoll_create1(2)
 * Create  a new epoll control descriptor which can be used for
 * monitoring of pollable events happening in registered files.
 * @param: flags: Set of `EPOLL_CLOEXEC | EPOLL_CLOFORK'
 * @return: * :   The newly created epoll control descriptor.
 * @throw: E_INVALID_ARGUMENT_UNKNOWN_FLAG:E_INVALID_ARGUMENT_CONTEXT_EPOLL_CREATE1_FLAGS: [...] */
/* fd_t epoll_create1(syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.epoll_create1
INTERN_WEAK_FUNCTION(__x86_asm32_int80_epoll_create1)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x149
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_epoll_create1)
	call   sys32_epoll_create1
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_epoll_create1)

/* @param: flags:  Set of `O_CLOEXEC | O_CLOFORK' */
/* fd_t dup3(fd_t oldfd, fd_t newfd, oflag_t flags) */
.section .text.x86.asm32_syscall_int80.dup3
INTERN_WEAK_FUNCTION(__x86_asm32_int80_dup3)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x14a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movslq %ecx, %rsi /* ARG1 = REG1 */
	movslq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_dup3)
	call   sys32_dup3
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_dup3)

/* errno_t pipe2(fd_t[2] pipedes, oflag_t flags) */
.section .text.x86.asm32_syscall_int80.pipe2
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pipe2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x14b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movslq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_pipe2)
	call   sys32_pipe2
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_pipe2)

/* @param: flags: Set of `IN_NONBLOCK | IN_CLOEXEC | IN_CLOFORK' */
/* fd_t inotify_init1(syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.inotify_init1
INTERN_WEAK_FUNCTION(__x86_asm32_int80_inotify_init1)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x14c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_inotify_init1)
	call   sys32_inotify_init1
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_inotify_init1)

/* Same as  `readv(2)', but  read data  from a  file at  a
 * specific `offset', rather than the current R/W position
 * @return: <= SUM(iov[*].iov_len): The actual amount of read bytes */
/* ssize_t preadv(fd_t fd, struct iovecx32 const *iovec, size_t count, uint64_t offset) */
.section .text.x86.asm32_syscall_int80.preadv
INTERN_WEAK_FUNCTION(__x86_asm32_int80_preadv)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x14d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %rax          /* %rax = REG3:REG4 */
	movzlq %esi, %r8           /* ... */
	shlq   $(32), %rax            /* ... */
	orq    %r8, %rax           /* ... */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movq   %rax, %rcx /* ARG3 = %rax */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_preadv)
	call   sys32_preadv
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_preadv)

/* Same as  `writev(2)', but  write data  to a  file at  a
 * specific `offset', rather than the current R/W position
 * @return: <= SUM(iov[*].iov_len): The actual amount of written bytes */
/* ssize_t pwritev(fd_t fd, struct iovecx32 const *iovec, size_t count, uint64_t offset) */
.section .text.x86.asm32_syscall_int80.pwritev
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pwritev)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x14e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %rax          /* %rax = REG3:REG4 */
	movzlq %esi, %r8           /* ... */
	shlq   $(32), %rax            /* ... */
	orq    %r8, %rax           /* ... */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movq   %rax, %rcx /* ARG3 = %rax */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_pwritev)
	call   sys32_pwritev
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_pwritev)

/* @param: usigno: The signal that should be sent
 * @param: uinfo:  [0..1] Additional signal information
 * @throw: E_INVALID_ARGUMENT_UNEXPECTED_COMMAND:E_INVALID_ARGUMENT_CONTEXT_SIGINFO_SIGNO: [...]
 * @throw: E_INVALID_ARGUMENT_BAD_VALUE:E_INVALID_ARGUMENT_CONTEXT_BAD_SIGNO:              [...]
 * @throw: E_INVALID_ARGUMENT_BAD_VALUE:E_INVALID_ARGUMENT_CONTEXT_RAISE_SIGINFO_BADCODE:  [...]
 * @throw: E_ILLEGAL_OPERATION:                                                            [...] */
/* errno_t rt_tgsigqueueinfo(pid_t pid, pid_t tid, signo_t usigno, struct __siginfox32_struct const *uinfo) */
.section .text.x86.asm32_syscall_int80.rt_tgsigqueueinfo
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rt_tgsigqueueinfo)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x14f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movslq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_rt_tgsigqueueinfo)
	call   sys32_rt_tgsigqueueinfo
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_rt_tgsigqueueinfo)

/* errno_t perf_event_open(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.perf_event_open
INTERN_WEAK_FUNCTION(__x86_asm32_int80_perf_event_open)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x150
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_perf_event_open)
	call   sys32_perf_event_open
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_perf_event_open)

/* Same as `recvmsg(2)', but may be used to receive many
 * messages  (datagrams)  with  a  single  system  call.
 * @param: msg_flags: Set of `MSG_CMSG_CLOEXEC | MSG_CMSG_CLOFORK |
 *                            MSG_DONTWAIT | MSG_ERRQUEUE | MSG_OOB |
 *                            MSG_PEEK  |  MSG_TRUNC |  MSG_WAITALL |
 *                            MSG_WAITFORONE'
 * @throw: Error (s.a. `recvmsg(2)')
 * @return: * : The # of datagrams successfully received. */
/* ssize_t recvmmsg(fd_t sockfd, struct mmsghdrx32 *vmessages, size_t vlen, syscall_ulong_t msg_flags, struct timespecx32 const *tmo) */
.section .text.x86.asm32_syscall_int80.recvmmsg
INTERN_WEAK_FUNCTION(__x86_asm32_int80_recvmmsg)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x151
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_recvmmsg)
	call   sys32_recvmmsg
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_recvmmsg)

/* errno_t fanotify_init(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.fanotify_init
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fanotify_init)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x152
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_fanotify_init)
	call   sys32_fanotify_init
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fanotify_init)

/* errno_t fanotify_mark(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.fanotify_mark
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fanotify_mark)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x153
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_fanotify_mark)
	call   sys32_fanotify_mark
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fanotify_mark)

/* @param: resource: One of `RLIMIT_*' from <sys/resource.h> */
/* errno_t prlimit64(pid_t pid, syscall_ulong_t resource, struct rlimitx32_64 const *new_limit, struct rlimitx32_64 *old_limit) */
.section .text.x86.asm32_syscall_int80.prlimit64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_prlimit64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x154
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_prlimit64)
	call   sys32_prlimit64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_prlimit64)

/* @param: flags: Set of `0 | AT_EMPTY_PATH | AT_SYMLINK_FOLLOW | AT_DOSPATH' */
/* errno_t name_to_handle_at(fd_t dirfd, char const *filename, struct file_handle *handle, int32_t *mnt_id, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.name_to_handle_at
INTERN_WEAK_FUNCTION(__x86_asm32_int80_name_to_handle_at)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x155
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_name_to_handle_at)
	call   sys32_name_to_handle_at
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_name_to_handle_at)

/* fd_t open_by_handle_at(fd_t mountdirfd, struct file_handle const *handle, oflag_t flags) */
.section .text.x86.asm32_syscall_int80.open_by_handle_at
INTERN_WEAK_FUNCTION(__x86_asm32_int80_open_by_handle_at)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x156
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movslq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_open_by_handle_at)
	call   sys32_open_by_handle_at
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_open_by_handle_at)

/* errno_t clock_adjtime(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.clock_adjtime
INTERN_WEAK_FUNCTION(__x86_asm32_int80_clock_adjtime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x157
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_clock_adjtime)
	call   sys32_clock_adjtime
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_clock_adjtime)

/* errno_t syncfs(fd_t fd) */
.section .text.x86.asm32_syscall_int80.syncfs
INTERN_WEAK_FUNCTION(__x86_asm32_int80_syncfs)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x158
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_syncfs)
	call   sys32_syncfs
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_syncfs)

/* Same as `sendmsg(2)', but may be used to send many
 * messages (datagrams)  with a  single system  call.
 * @param: msg_flags: Set of `MSG_CONFIRM | MSG_DONTROUTE | MSG_DONTWAIT |
 *                            MSG_EOR | MSG_MORE | MSG_NOSIGNAL | MSG_OOB'
 * @throw: ... Same as `sendmsg(2)'
 * @return: * : The # of datagrams successfully sent. */
/* ssize_t sendmmsg(fd_t sockfd, struct mmsghdrx32 *vmessages, size_t vlen, syscall_ulong_t msg_flags) */
.section .text.x86.asm32_syscall_int80.sendmmsg
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sendmmsg)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x159
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_sendmmsg)
	call   sys32_sendmmsg
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_sendmmsg)

/* errno_t setns(fd_t fd, syscall_ulong_t nstype) */
.section .text.x86.asm32_syscall_int80.setns
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setns)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x15a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_setns)
	call   sys32_setns
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_setns)

/* Read memory from another process's VM
 * @param: flags: Must be `0'
 * @return: * :   The actual number of read bytes */
/* ssize_t process_vm_readv(pid_t pid, struct iovecx32 const *local_iov, size_t liovcnt, struct iovecx32 const *remote_iov, size_t riovcnt, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.process_vm_readv
INTERN_WEAK_FUNCTION(__x86_asm32_int80_process_vm_readv)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x15b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %ebp, %r9 /* ARG5 = REG5 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_process_vm_readv)
	call   sys32_process_vm_readv
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_process_vm_readv)

/* Write memory to another process's VM
 * @param: flags: Must be `0'
 * @return: * :   The actual number of written bytes */
/* ssize_t process_vm_writev(pid_t pid, struct iovecx32 const *local_iov, size_t liovcnt, struct iovecx32 const *remote_iov, size_t riovcnt, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.process_vm_writev
INTERN_WEAK_FUNCTION(__x86_asm32_int80_process_vm_writev)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x15c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %ebp, %r9 /* ARG5 = REG5 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_process_vm_writev)
	call   sys32_process_vm_writev
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_process_vm_writev)

/* @param: type: One of  `KCMP_FILE',  `KCMP_FILES',  `KCMP_FS',  `KCMP_IO',
 *               `KCMP_SIGHAND', `KCMP_SYSVSEM', `KCMP_VM', `KCMP_EPOLL_TFD' */
/* syscall_slong_t kcmp(pid_t pid1, pid_t pid2, syscall_ulong_t type, syscall_ulong_t idx1, syscall_ulong_t idx2) */
.section .text.x86.asm32_syscall_int80.kcmp
INTERN_WEAK_FUNCTION(__x86_asm32_int80_kcmp)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x15d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_kcmp)
	call   sys32_kcmp
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_kcmp)

/* Load a  kernel  driver  from an  ELF  image  `module_image...+=len'
 * This system call exists for linux compatibility, and is implemented
 * as an alias for  `KSYSCTL_DRIVER_INSMOD:KSYSCTL_DRIVER_FORMAT_FILE'
 * 
 * Note however that that is where linux compatibility ends. Since the
 * linux kernel does not implement any semblance of a stable ABI,  you
 * have to realize that on KOS, this system call can only load drivers
 * specifically built to run within the KOS kernel!
 * @param: uargs: The driver commandline */
/* errno_t finit_module(fd_t fd, char const *uargs, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.finit_module
INTERN_WEAK_FUNCTION(__x86_asm32_int80_finit_module)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x15e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_finit_module)
	call   sys32_finit_module
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_finit_module)

/* errno_t sched_setattr(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.sched_setattr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sched_setattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x15f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_sched_setattr)
	call   sys32_sched_setattr
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_sched_setattr)

/* errno_t sched_getattr(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.sched_getattr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sched_getattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x160
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_sched_getattr)
	call   sys32_sched_getattr
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_sched_getattr)

/* @param: flags: Set of `0 | AT_RENAME_NOREPLACE | AT_RENAME_EXCHANGE | AT_RENAME_WHITEOUT | AT_RENAME_MOVETODIR | AT_DOSPATH' */
/* errno_t renameat2(fd_t olddirfd, char const *oldpath, fd_t newdirfd, char const *newpath, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.renameat2
INTERN_WEAK_FUNCTION(__x86_asm32_int80_renameat2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x161
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movslq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_renameat2)
	call   sys32_renameat2
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_renameat2)

/* errno_t seccomp(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.seccomp
INTERN_WEAK_FUNCTION(__x86_asm32_int80_seccomp)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x162
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_seccomp)
	call   sys32_seccomp
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_seccomp)

/* @param: flags: Set of `0 | GRND_RANDOM | GRND_NONBLOCK' */
/* ssize_t getrandom(void *buf, size_t num_bytes, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.getrandom
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getrandom)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x163
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_getrandom)
	call   sys32_getrandom
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getrandom)

/* @param: flags: Set of `MFD_CLOEXEC | MFD_CLOFORK | MFD_ALLOW_SEALING | MFD_HUGETLB' */
/* fd_t memfd_create(char const *name, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.memfd_create
INTERN_WEAK_FUNCTION(__x86_asm32_int80_memfd_create)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x164
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_memfd_create)
	call   sys32_memfd_create
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_memfd_create)

/* errno_t bpf(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.bpf
INTERN_WEAK_FUNCTION(__x86_asm32_int80_bpf)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x165
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_bpf)
	call   sys32_bpf
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_bpf)

/* Replace the calling  process with  the application  image referred  to by  `path' /  `file'
 * and execute it's `main()' method, passing the given `argv', and setting `environ' to `envp'
 * @param: flags: Set of `0 | AT_EMPTY_PATH | AT_SYMLINK_NOFOLLOW | AT_DOSPATH' */
/* errno_t execveat(fd_t dirfd, char const *pathname, __HYBRID_PTR32(char const) const *argv, __HYBRID_PTR32(char const) const *envp, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.execveat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_execveat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x166
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_execveat)
	call   sys32_execveat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_execveat)

/* Create a new socket for the given domain/type/protocol triple.
 * @param: domain:   Socket address domain/family (one of `AF_*' from `<sys/socket.h>')
 * @param: type:     Socket type (one of `SOCK_*' from `<sys/socket.h>')
 *                   May optionally be or'd with `SOCK_CLOEXEC | SOCK_CLOFORK | SOCK_NONBLOCK'
 * @param: protocol: Socket protocol (`0' for automatic). Available socket protocols mainly
 *                   depend on the selected `domain', and may be further specialized by the
 *                   `type' argument.  for  example,  `AF_INET' takes  one  of  `IPPROTO_*'
 *                   >> socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
 *                   Also note that protocol IDs can be enumerated by `getprotoent(3)' from `<netdb.h>'
 * @return: * : A file descriptor for the newly created socket. */
/* fd_t socket(syscall_ulong_t domain, syscall_ulong_t type, syscall_ulong_t protocol) */
.section .text.x86.asm32_syscall_int80.socket
INTERN_WEAK_FUNCTION(__x86_asm32_int80_socket)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x167
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_socket)
	call   sys32_socket
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_socket)

/* Create a new socket for the given domain/type/protocol triple.
 * @param: domain:   Socket address domain/family (one of `AF_*' from `<sys/socket.h>')
 * @param: type:     Socket type (one of `SOCK_*' from `<sys/socket.h>')
 *                   May optionally be or'd with `SOCK_CLOEXEC | SOCK_CLOFORK | SOCK_NONBLOCK'
 * @param: protocol: Socket protocol (`0' for automatic). Available socket protocols mainly
 *                   depend on the selected `domain', and may be further specialized by the
 *                   `type' argument.  for  example,  `AF_INET' takes  one  of  `IPPROTO_*'
 *                   >> socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
 *                   Also note that protocol IDs can be enumerated by `getprotoent(3)' from `<netdb.h>'
 * @return: * : A file descriptor for the newly created socket. */
/* errno_t socketpair(syscall_ulong_t domain, syscall_ulong_t type, syscall_ulong_t protocol, fd_t[2] fds) */
.section .text.x86.asm32_syscall_int80.socketpair
INTERN_WEAK_FUNCTION(__x86_asm32_int80_socketpair)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x168
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_socketpair)
	call   sys32_socketpair
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_socketpair)

/* Bind the given socket `sockfd' to the specified local address.
 * @throw: E_NET_ADDRESS_IN_USE:E_NET_ADDRESS_IN_USE_CONTEXT_CONNECT
 * @throw: E_INVALID_ARGUMENT_UNEXPECTED_COMMAND:E_INVALID_ARGUMENT_CONTEXT_BIND_WRONG_ADDRESS_FAMILY
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_BIND_ALREADY_BOUND
 * @throw: E_NET_ADDRESS_NOT_AVAILABLE
 * @throw: E_BUFFER_TOO_SMALL   (`addr_len' is incorrect)
 * @return: 0 : Success */
/* errno_t bind(fd_t sockfd, struct sockaddr const *addr, socklen_t addr_len) */
.section .text.x86.asm32_syscall_int80.bind
INTERN_WEAK_FUNCTION(__x86_asm32_int80_bind)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x169
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_bind)
	call   sys32_bind
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_bind)

/* Connect to the specified address.
 * If the given `sockfd' isn't connection-oriented, this will set the address
 * that  will implicitly be  used as destination  by `send(2)' and `write(2)'
 * @throw: E_NET_ADDRESS_IN_USE:E_NET_ADDRESS_IN_USE_CONTEXT_CONNECT
 * @throw: E_INVALID_ARGUMENT_UNEXPECTED_COMMAND:E_INVALID_ARGUMENT_CONTEXT_BIND_WRONG_ADDRESS_FAMILY
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_BIND_ALREADY_BOUND
 * @throw: E_NET_ADDRESS_NOT_AVAILABLE
 * @throw: E_NET_CONNECTION_REFUSED
 * @throw: E_BUFFER_TOO_SMALL   (addr_len is incorrect)
 * @return: 0 : Success */
/* errno_t connect(fd_t sockfd, struct sockaddr const *addr, socklen_t addr_len) */
.section .text.x86.asm32_syscall_int80.connect
INTERN_WEAK_FUNCTION(__x86_asm32_int80_connect)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x16a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_connect)
	call   sys32_connect
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_connect)

/* Begin to listen for incoming client (aka. peer) connection requests.
 * @param: max_backlog: The max number of clients  pending to be accept(2)-ed,  before
 *                      the kernel will refuse to enqueue additional clients, and will
 *                      instead automatically refuse  any further  requests until  the
 *                      less than `max_backlog' clients are still pending.
 * @throw: E_NET_ADDRESS_IN_USE:E_NET_ADDRESS_IN_USE_CONTEXT_LISTEN
 * @throw: E_INVALID_HANDLE_NET_OPERATION:E_NET_OPERATION_LISTEN
 * @return: 0 : Success */
/* errno_t listen(fd_t sockfd, syscall_ulong_t max_backlog) */
.section .text.x86.asm32_syscall_int80.listen
INTERN_WEAK_FUNCTION(__x86_asm32_int80_listen)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x16b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_listen)
	call   sys32_listen
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_listen)

/* Accept incoming client (aka. peer) connection requests.
 * @param: addr:       Peer address of the sender (or `NULL' when `addr_len' is `NULL')
 * @param: addr_len:   [NULL] Don't fill in the client's peer address
 *                     [in]   The amount of available memory starting at `addr'
 *                     [out]  The  amount  of required  memory for  the address.
 *                            This  may be  more than  was given,  in which case
 *                            the  address  was  truncated and  may  be invalid.
 *                            If this happens,  the caller  can still  determine
 *                            the correct address through use of `getpeername()'
 * @param: sock_flags: Set of `SOCK_NONBLOCK | SOCK_CLOEXEC | SOCK_CLOFORK'
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_ACCEPT_NOT_LISTENING
 * @throw: E_INVALID_HANDLE_NET_OPERATION:E_NET_OPERATION_ACCEPT
 * @throw: E_NET_CONNECTION_ABORT
 * @return: * : A file descriptor for the newly accept(2)-ed connection */
/* fd_t accept4(fd_t sockfd, struct sockaddr *addr, socklen_t *addr_len, syscall_ulong_t sock_flags) */
.section .text.x86.asm32_syscall_int80.accept4
INTERN_WEAK_FUNCTION(__x86_asm32_int80_accept4)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x16c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_accept4)
	call   sys32_accept4
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_accept4)

/* Get the value of the named socket option `level:optname' and store it in `optval'
 * @param: level:   One of `SOL_*' (e.g.: `SOL_SOCKET')
 * @param: optname: Dependent on `level'
 * @param: optval:  Buffer for where to write the value of the socket option.
 * @param: optlen:  [in]  The amount of available memory starting at `optval'
 *                  [out] The amount of required memory for the option value.
 *                        This may be more than was given, in which case
 *                        the  contents  of   `optval'  are   undefined.
 * @throw: E_INVALID_ARGUMENT_SOCKET_OPT:E_INVALID_ARGUMENT_CONTEXT_GETSOCKOPT
 * @return: 0 : Success */
/* errno_t getsockopt(fd_t sockfd, syscall_ulong_t level, syscall_ulong_t optname, void *optval, socklen_t *optlen) */
.section .text.x86.asm32_syscall_int80.getsockopt
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getsockopt)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x16d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_getsockopt)
	call   sys32_getsockopt
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getsockopt)

/* Set the value of the named socket option `level:optname' from what is given in `optval'
 * @param: level:   One of `SOL_*' (e.g.: `SOL_SOCKET')
 * @param: optname: Dependent on `level'
 * @param: optval:  Buffer for where to write the value of the socket option.
 * @param: optlen:  The amount of available memory starting at `optval'
 * @throw: E_INVALID_ARGUMENT_SOCKET_OPT:E_INVALID_ARGUMENT_CONTEXT_SETSOCKOPT
 * @throw: E_BUFFER_TOO_SMALL  (The specified `optlen' is invalid for the given option)
 * @return: 0 : Success */
/* errno_t setsockopt(fd_t sockfd, syscall_ulong_t level, syscall_ulong_t optname, void const *optval, socklen_t optlen) */
.section .text.x86.asm32_syscall_int80.setsockopt
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setsockopt)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x16e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_setsockopt)
	call   sys32_setsockopt
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_setsockopt)

/* Determine the local address (aka. name) for the given socket `sockfd'.
 * This  is usually the  same address as was  previously set by `bind(2)'
 * NOTE: Before the socket has actually be bound or connected, the exact
 *       address that is returned by this function is weakly  undefined.
 *       e.g.: For AF_INET, sin_addr=0.0.0.0, sin_port=0 is returned.
 * @param: addr:     [out] Buffer where to store the sock address.
 * @param: addr_len: [in]  The amount of available memory starting at `addr'
 *                   [out] The amount of required memory for the address.
 *                         This may be more than was given, in which case
 *                         the  address was truncated and may be invalid.
 * return: 0 : Success */
/* errno_t getsockname(fd_t sockfd, struct sockaddr *addr, socklen_t *addr_len) */
.section .text.x86.asm32_syscall_int80.getsockname
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getsockname)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x16f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_getsockname)
	call   sys32_getsockname
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getsockname)

/* Lookup the peer (remote) address of `sockfd' and store it in `*addr...+=*addr_len'
 * @param: addr:     [out] Buffer where to store the sock address.
 * @param: addr_len: [in]  The amount of available memory starting at `addr'
 *                   [out] The amount of required memory for the address.
 *                         This may be more than was given, in which case
 *                         the  address was truncated and may be invalid.
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_GETPEERNAME_NOT_CONNECTED
 * @return: 0 : Success */
/* errno_t getpeername(fd_t sockfd, struct sockaddr *addr, socklen_t *addr_len) */
.section .text.x86.asm32_syscall_int80.getpeername
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getpeername)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x170
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_getpeername)
	call   sys32_getpeername
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getpeername)

/* Send the contents of a given buffer over this socket to the specified address
 * @param: buf:       Buffer of data to send (with a length of `bufsize' bytes)
 * @param: bufsize:   Size of `buf' (in bytes)
 * @param: msg_flags: Set of `MSG_CONFIRM | MSG_DONTROUTE | MSG_DONTWAIT |
 *                            MSG_EOR | MSG_MORE | MSG_NOSIGNAL | MSG_OOB'
 * @param: addr:      Address where to send data (or NULL when `addr_len' is 0)
 * @param: addr_len:  Size of `addr', or `0' to have this behave as an alias
 *                    for            `send(sockfd, buf, bufsize, msg_flags)'
 * @throw: E_INVALID_ARGUMENT_UNEXPECTED_COMMAND:E_INVALID_ARGUMENT_CONTEXT_SENDTO_WRONG_ADDRESS_FAMILY
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_SEND_NOT_CONNECTED
 * @throw: E_NET_MESSAGE_TOO_LONG
 * @throw: E_NET_CONNECTION_RESET
 * @throw: E_NET_SHUTDOWN
 * @throw: E_BUFFER_TOO_SMALL  (`addr_len' is incorrect)
 * @return: * : [<= bufsize] The actual # of send bytes */
/* ssize_t sendto(fd_t sockfd, void const *buf, size_t bufsize, syscall_ulong_t msg_flags, struct sockaddr const *addr, socklen_t addr_len) */
.section .text.x86.asm32_syscall_int80.sendto
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sendto)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x171
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %ebp, %r9 /* ARG5 = REG5 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_sendto)
	call   sys32_sendto
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_sendto)

/* Same as `send(2)' and `sendto(2)', but also allows for sending ancillary
 * data as well as  for data buffers  to be represented  by an IOV  vector.
 * @param: msg_flags: Set of `MSG_CONFIRM | MSG_DONTROUTE | MSG_DONTWAIT |
 *                            MSG_EOR | MSG_MORE | MSG_NOSIGNAL | MSG_OOB'
 * @throw: ... Same as for `send(2)' and `sendto(2)'
 * @return: * : [<= bufsize] The actual # of send payload bytes */
/* ssize_t sendmsg(fd_t sockfd, struct msghdrx32 const *message, syscall_ulong_t msg_flags) */
.section .text.x86.asm32_syscall_int80.sendmsg
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sendmsg)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x172
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_sendmsg)
	call   sys32_sendmsg
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_sendmsg)

/* Receive data over this socket, and store the contents within the given buffer.
 * @param: buf:       Buffer to-be filled with up to `bufsize' bytes of received data
 * @param: bufsize:   Max # of bytes to receive
 * @param: msg_flags: Set of `MSG_DONTWAIT | MSG_ERRQUEUE | MSG_OOB |
 *                            MSG_PEEK | MSG_TRUNC | MSG_WAITALL'
 * @param: addr:      Peer address of the sender (or `NULL' when `addr_len' is `NULL')
 * @param: addr_len:  [NULL] behave as an alias for `recv(sockfd, buf, bufsize, msg_flags)'
 *                    [in]   The amount of available memory starting at `addr'
 *                    [out]  The amount of required memory for the address.
 *                           This may be more than was given, in which case
 *                           the address was truncated and may be invalid.
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_RECV_NOT_CONNECTED
 * @throw: E_NET_CONNECTION_REFUSED
 * @throw: E_WOULDBLOCK (`MSG_DONTWAIT' was given, and the operation would have blocked)
 * @return: * : [<= bufsize] The actual # of received bytes */
/* ssize_t recvfrom(fd_t sockfd, void *buf, size_t bufsize, syscall_ulong_t msg_flags, struct sockaddr *addr, socklen_t *addr_len) */
.section .text.x86.asm32_syscall_int80.recvfrom
INTERN_WEAK_FUNCTION(__x86_asm32_int80_recvfrom)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x173
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %ebp, %r9 /* ARG5 = REG5 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_recvfrom)
	call   sys32_recvfrom
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_recvfrom)

/* Same as `recv(2)' and `recvfrom(2)', but also allows for receiving ancillary
 * data as  well as  for  data buffers  to be  represented  by an  IOV  vector.
 * @param: msg_flags: Set of `MSG_CMSG_CLOEXEC | MSG_CMSG_CLOFORK |
 *                            MSG_DONTWAIT | MSG_ERRQUEUE | MSG_OOB |
 *                            MSG_PEEK  |  MSG_TRUNC  |  MSG_WAITALL'
 * @throw: ... Same as for `recv(2)' and `recvfrom(2)'
 * @return: * : [<= bufsize] The actual # of received payload bytes */
/* ssize_t recvmsg(fd_t sockfd, struct msghdrx32 *message, syscall_ulong_t msg_flags) */
.section .text.x86.asm32_syscall_int80.recvmsg
INTERN_WEAK_FUNCTION(__x86_asm32_int80_recvmsg)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x174
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_recvmsg)
	call   sys32_recvmsg
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_recvmsg)

/* Disallow further reception of data (causing `recv(2)' to return `0' as soon
 * as  all currently queued  data has been  read), and/or further transmission
 * of data (causing `send(2)' to throw an `E_NET_SHUTDOWN' exception)
 * @param: how: One of `SHUT_RD', `SHUT_WR' or `SHUT_RDWR'
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_SHUTDOWN_NOT_CONNECTED
 * @return: 0 : Success */
/* errno_t shutdown(fd_t sockfd, syscall_ulong_t how) */
.section .text.x86.asm32_syscall_int80.shutdown
INTERN_WEAK_FUNCTION(__x86_asm32_int80_shutdown)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x175
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_shutdown)
	call   sys32_shutdown
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_shutdown)

/* fd_t userfaultfd(syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.userfaultfd
INTERN_WEAK_FUNCTION(__x86_asm32_int80_userfaultfd)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x176
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_userfaultfd)
	call   sys32_userfaultfd
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_userfaultfd)

/* errno_t membarrier(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.membarrier
INTERN_WEAK_FUNCTION(__x86_asm32_int80_membarrier)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x177
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_membarrier)
	call   sys32_membarrier
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_membarrier)

/* errno_t mlock2(void const *addr, size_t length, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.mlock2
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mlock2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x178
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_mlock2)
	call   sys32_mlock2
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_mlock2)

/* errno_t copy_file_range(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.copy_file_range
INTERN_WEAK_FUNCTION(__x86_asm32_int80_copy_file_range)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x179
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_copy_file_range)
	call   sys32_copy_file_range
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_copy_file_range)

/* errno_t preadv2(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.preadv2
INTERN_WEAK_FUNCTION(__x86_asm32_int80_preadv2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x17a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_preadv2)
	call   sys32_preadv2
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_preadv2)

/* errno_t pwritev2(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.pwritev2
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pwritev2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x17b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_pwritev2)
	call   sys32_pwritev2
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_pwritev2)

/* errno_t pkey_mprotect(void *addr, size_t len, syscall_ulong_t prot, syscall_ulong_t pkey) */
.section .text.x86.asm32_syscall_int80.pkey_mprotect
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pkey_mprotect)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x17c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_pkey_mprotect)
	call   sys32_pkey_mprotect
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_pkey_mprotect)

/* syscall_slong_t pkey_alloc(syscall_ulong_t flags, syscall_ulong_t access_rights) */
.section .text.x86.asm32_syscall_int80.pkey_alloc
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pkey_alloc)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x17d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_pkey_alloc)
	call   sys32_pkey_alloc
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_pkey_alloc)

/* errno_t pkey_free(syscall_ulong_t key) */
.section .text.x86.asm32_syscall_int80.pkey_free
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pkey_free)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x17e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_pkey_free)
	call   sys32_pkey_free
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_pkey_free)

/* errno_t statx(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.statx
INTERN_WEAK_FUNCTION(__x86_asm32_int80_statx)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x17f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_statx)
	call   sys32_statx
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_statx)

/* >> arch_prctl(2)
 * Arch-dependent system process control interface. (But don't go and
 * think that the  normal `prctl(2)'  doesn't feature  arch-dependent
 * commands  -- honestly, this syscall shouldn't exist if you ask me,
 * but it does on linux, and so it must also on KOS...)
 * @param: command: One of `ARCH_*' (from <asm/prctl.h>)
 * @param: addr: Either a `syscall_ulong_t' or `syscall_ulong_t *', depending on `command'
 * @return: * :  Return value depends on `command' */
/* syscall_slong_t arch_prctl(unsigned int command, uint32_t *addr) */
.section .text.x86.asm32_syscall_int80.arch_prctl
INTERN_WEAK_FUNCTION(__x86_asm32_int80_arch_prctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x180
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_arch_prctl)
	call   sys32_arch_prctl
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_arch_prctl)

/* errno_t io_pgetevents(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.io_pgetevents
INTERN_WEAK_FUNCTION(__x86_asm32_int80_io_pgetevents)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x181
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_io_pgetevents)
	call   sys32_io_pgetevents
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_io_pgetevents)

/* errno_t rseq(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.rseq
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rseq)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x182
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_rseq)
	call   sys32_rseq
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_rseq)

/* errno_t semget(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.semget
INTERN_WEAK_FUNCTION(__x86_asm32_int80_semget)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x189
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_semget)
	call   sys32_semget
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_semget)

/* errno_t semctl(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.semctl
INTERN_WEAK_FUNCTION(__x86_asm32_int80_semctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x18a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_semctl)
	call   sys32_semctl
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_semctl)

/* errno_t shmget(key_t key, size_t size, syscall_ulong_t shmflg) */
.section .text.x86.asm32_syscall_int80.shmget
INTERN_WEAK_FUNCTION(__x86_asm32_int80_shmget)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x18b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_shmget)
	call   sys32_shmget
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_shmget)

/* errno_t shmctl(syscall_ulong_t shmid, syscall_ulong_t cmd, struct shmid_ds *buf) */
.section .text.x86.asm32_syscall_int80.shmctl
INTERN_WEAK_FUNCTION(__x86_asm32_int80_shmctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x18c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_shmctl)
	call   sys32_shmctl
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_shmctl)

/* errno_t shmat(syscall_ulong_t shmid, void const *shmaddr, syscall_ulong_t shmflg) */
.section .text.x86.asm32_syscall_int80.shmat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_shmat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x18d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_shmat)
	call   sys32_shmat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_shmat)

/* errno_t shmdt(void const *shmaddr) */
.section .text.x86.asm32_syscall_int80.shmdt
INTERN_WEAK_FUNCTION(__x86_asm32_int80_shmdt)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x18e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_shmdt)
	call   sys32_shmdt
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_shmdt)

/* errno_t msgget(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.msgget
INTERN_WEAK_FUNCTION(__x86_asm32_int80_msgget)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x18f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_msgget)
	call   sys32_msgget
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_msgget)

/* errno_t msgsnd(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.msgsnd
INTERN_WEAK_FUNCTION(__x86_asm32_int80_msgsnd)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x190
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_msgsnd)
	call   sys32_msgsnd
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_msgsnd)

/* errno_t msgrcv(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.msgrcv
INTERN_WEAK_FUNCTION(__x86_asm32_int80_msgrcv)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x191
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_msgrcv)
	call   sys32_msgrcv
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_msgrcv)

/* errno_t msgctl(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.msgctl
INTERN_WEAK_FUNCTION(__x86_asm32_int80_msgctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x192
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_msgctl)
	call   sys32_msgctl
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_msgctl)

/* errno_t clock_gettime64(clockid_t clock_id, struct timespecx32_64 *tp) */
.section .text.x86.asm32_syscall_int80.clock_gettime64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_clock_gettime64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x193
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_clock_gettime64)
	call   sys32_clock_gettime64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_clock_gettime64)

/* errno_t clock_settime64(clockid_t clock_id, struct timespecx32_64 const *tp) */
.section .text.x86.asm32_syscall_int80.clock_settime64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_clock_settime64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x194
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_clock_settime64)
	call   sys32_clock_settime64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_clock_settime64)

/* errno_t clock_adjtime64(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.clock_adjtime64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_clock_adjtime64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x195
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_clock_adjtime64)
	call   sys32_clock_adjtime64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_clock_adjtime64)

/* errno_t clock_getres_time64(clockid_t clock_id, struct timespecx32_64 *res) */
.section .text.x86.asm32_syscall_int80.clock_getres_time64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_clock_getres_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x196
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_clock_getres_time64)
	call   sys32_clock_getres_time64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_clock_getres_time64)

/* errno_t clock_nanosleep_time64(clockid_t clock_id, syscall_ulong_t flags, struct timespecx32_64 const *requested_time, struct timespecx32_64 *remaining) */
.section .text.x86.asm32_syscall_int80.clock_nanosleep_time64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_clock_nanosleep_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x197
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_clock_nanosleep_time64)
	call   sys32_clock_nanosleep_time64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_clock_nanosleep_time64)

/* errno_t timer_gettime64(timer_t timerid, struct itimerspecx32_64 *value) */
.section .text.x86.asm32_syscall_int80.timer_gettime64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_timer_gettime64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x198
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_timer_gettime64)
	call   sys32_timer_gettime64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_timer_gettime64)

/* @param: flags: Set of `0 | TIMER_ABSTIME' */
/* errno_t timer_settime64(timer_t timerid, syscall_ulong_t flags, struct itimerspecx32_64 const *value, struct itimerspecx32_64 *ovalue) */
.section .text.x86.asm32_syscall_int80.timer_settime64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_timer_settime64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x199
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_timer_settime64)
	call   sys32_timer_settime64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_timer_settime64)

/* Return the next expiration time of UFD */
/* errno_t timerfd_gettime64(fd_t timerfd, struct itimerspecx32_64 *otmr) */
.section .text.x86.asm32_syscall_int80.timerfd_gettime64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_timerfd_gettime64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x19a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_timerfd_gettime64)
	call   sys32_timerfd_gettime64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_timerfd_gettime64)

/* Set next expiration time of interval timer source `timerfd' to `utmr'.
 * If `flags'  has the  `TFD_TIMER_ABSTIME' flag  set the  timeout  value
 * is absolute. Optionally return the old expiration time in `otmr'
 * @param: flags: Set of `0 | TFD_TIMER_ABSTIME' */
/* errno_t timerfd_settime64(fd_t timerfd, syscall_ulong_t flags, struct itimerspecx32_64 const *utmr, struct itimerspecx32_64 *otmr) */
.section .text.x86.asm32_syscall_int80.timerfd_settime64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_timerfd_settime64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x19b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_timerfd_settime64)
	call   sys32_timerfd_settime64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_timerfd_settime64)

/* @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_CHANGE_BTIME | AT_DOSPATH' */
/* errno_t utimensat_time64(fd_t dirfd, char const *filename, struct timespecx32_64 const[2] times, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.utimensat_time64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_utimensat_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x19c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_utimensat_time64)
	call   sys32_utimensat_time64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_utimensat_time64)

/* ssize_t pselect6_time64(size_t nfds, struct __fd_set_struct *readfds, struct __fd_set_struct *writefds, struct __fd_set_struct *exceptfds, struct timespecx32_64 const *timeout, struct __sigset_with_sizex32 const *sigmask_sigset_with_size) */
.section .text.x86.asm32_syscall_int80.pselect6_time64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pselect6_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x19d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %ebp, %r9 /* ARG5 = REG5 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_pselect6_time64)
	call   sys32_pselect6_time64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_pselect6_time64)

/* ssize_t ppoll_time64(struct pollfd *fds, size_t nfds, struct timespecx32_64 const *timeout_ts, struct __sigset_struct const *sigmask, size_t sigsetsize) */
.section .text.x86.asm32_syscall_int80.ppoll_time64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ppoll_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x19e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_ppoll_time64)
	call   sys32_ppoll_time64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_ppoll_time64)

/* errno_t io_pgetevents_time64(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.io_pgetevents_time64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_io_pgetevents_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1a0
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_io_pgetevents_time64)
	call   sys32_io_pgetevents_time64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_io_pgetevents_time64)

/* Same as `recvmsg(2)', but may be used to receive many
 * messages  (datagrams)  with  a  single  system  call.
 * @param: msg_flags: Set of `MSG_CMSG_CLOEXEC | MSG_CMSG_CLOFORK |
 *                            MSG_DONTWAIT | MSG_ERRQUEUE | MSG_OOB |
 *                            MSG_PEEK  |  MSG_TRUNC |  MSG_WAITALL |
 *                            MSG_WAITFORONE'
 * @throw: Error (s.a. `recvmsg(2)')
 * @return: * : The # of datagrams successfully received. */
/* ssize_t recvmmsg_time64(fd_t sockfd, struct mmsghdrx32 *vmessages, size_t vlen, syscall_ulong_t msg_flags, struct timespecx32_64 const *tmo) */
.section .text.x86.asm32_syscall_int80.recvmmsg_time64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_recvmmsg_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1a1
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_recvmmsg_time64)
	call   sys32_recvmmsg_time64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_recvmmsg_time64)

/* errno_t mq_timedsend_time64(fd_t mqdes, char const *msg_ptr, size_t msg_len, uint32_t msg_prio, struct timespecx32_64 const *abs_timeout) */
.section .text.x86.asm32_syscall_int80.mq_timedsend_time64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mq_timedsend_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1a2
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_mq_timedsend_time64)
	call   sys32_mq_timedsend_time64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_mq_timedsend_time64)

/* ssize_t mq_timedreceive_time64(fd_t mqdes, char *msg_ptr, size_t msg_len, uint32_t *pmsg_prio, struct timespecx32_64 const *abs_timeout) */
.section .text.x86.asm32_syscall_int80.mq_timedreceive_time64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mq_timedreceive_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1a3
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_mq_timedreceive_time64)
	call   sys32_mq_timedreceive_time64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_mq_timedreceive_time64)

/* errno_t semtimedop_time64(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.semtimedop_time64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_semtimedop_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1a4
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_semtimedop_time64)
	call   sys32_semtimedop_time64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_semtimedop_time64)

/* syscall_slong_t rt_sigtimedwait_time64(struct __sigset_struct const *set, struct __siginfox32_struct *info, struct timespecx32_64 const *timeout, size_t sigsetsize) */
.section .text.x86.asm32_syscall_int80.rt_sigtimedwait_time64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rt_sigtimedwait_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1a5
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_rt_sigtimedwait_time64)
	call   sys32_rt_sigtimedwait_time64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_rt_sigtimedwait_time64)

/* @param: futex_op: One of `FUTEX_*' from <linux/futex.h> */
/* syscall_slong_t futex_time64(uint32_t *uaddr, syscall_ulong_t futex_op, uint32_t val, struct timespecx32_64 const *timeout_or_val2, uint32_t *uaddr2, uint32_t val3) */
.section .text.x86.asm32_syscall_int80.futex_time64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_futex_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1a6
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %ebp, %r9 /* ARG5 = REG5 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_futex_time64)
	call   sys32_futex_time64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_futex_time64)

/* errno_t sched_rr_get_interval_time64(pid_t pid, struct timespecx32_64 *ts) */
.section .text.x86.asm32_syscall_int80.sched_rr_get_interval_time64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sched_rr_get_interval_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1a7
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_sched_rr_get_interval_time64)
	call   sys32_sched_rr_get_interval_time64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_sched_rr_get_interval_time64)

/* Send a signal to the process of a given pidfd
 * @param: pidfd:  A `HANDLE_TYPE_PIDFD'-handle
 * @param: usigno: The signal that should be sent
 * @param: uinfo:  [0..1] Additional signal information
 * @param: flags:  Must always be `0' (for now)
 * @throw: E_PROCESS_EXITED:                                                                  [...]
 * @throw: E_INVALID_ARGUMENT_RESERVED_ARGUMENT:E_INVALID_ARGUMENT_CONTEXT_PIDFD_GETFD_FLAGS: [...]
 * @throw: E_INVALID_ARGUMENT_UNEXPECTED_COMMAND:E_INVALID_ARGUMENT_CONTEXT_SIGINFO_SIGNO:    [...]
 * @throw: E_INVALID_ARGUMENT_BAD_VALUE:E_INVALID_ARGUMENT_CONTEXT_BAD_SIGNO:                 [...]
 * @throw: E_INVALID_ARGUMENT_BAD_VALUE:E_INVALID_ARGUMENT_CONTEXT_RAISE_SIGINFO_BADCODE:     [...]
 * @throw: E_INVALID_HANDLE_FILE:                                                             [...]
 * @throw: E_ILLEGAL_OPERATION:                                                               [...] */
/* errno_t pidfd_send_signal(fd_t pidfd, signo_t usigno, struct __siginfox32_struct const *uinfo, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.pidfd_send_signal
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pidfd_send_signal)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1a8
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movslq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_pidfd_send_signal)
	call   sys32_pidfd_send_signal
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_pidfd_send_signal)

/* errno_t io_uring_setup(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.io_uring_setup
INTERN_WEAK_FUNCTION(__x86_asm32_int80_io_uring_setup)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1a9
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_io_uring_setup)
	call   sys32_io_uring_setup
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_io_uring_setup)

/* errno_t io_uring_enter(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.io_uring_enter
INTERN_WEAK_FUNCTION(__x86_asm32_int80_io_uring_enter)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1aa
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_io_uring_enter)
	call   sys32_io_uring_enter
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_io_uring_enter)

/* errno_t io_uring_register(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.io_uring_register
INTERN_WEAK_FUNCTION(__x86_asm32_int80_io_uring_register)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1ab
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_io_uring_register)
	call   sys32_io_uring_register
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_io_uring_register)

/* errno_t open_tree(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.open_tree
INTERN_WEAK_FUNCTION(__x86_asm32_int80_open_tree)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1ac
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_open_tree)
	call   sys32_open_tree
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_open_tree)

/* errno_t move_mount(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.move_mount
INTERN_WEAK_FUNCTION(__x86_asm32_int80_move_mount)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1ad
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_move_mount)
	call   sys32_move_mount
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_move_mount)

/* errno_t fsopen(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.fsopen
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fsopen)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1ae
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_fsopen)
	call   sys32_fsopen
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fsopen)

/* errno_t fsconfig(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.fsconfig
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fsconfig)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1af
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_fsconfig)
	call   sys32_fsconfig
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fsconfig)

/* errno_t fsmount(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.fsmount
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fsmount)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1b0
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_fsmount)
	call   sys32_fsmount
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fsmount)

/* errno_t fspick(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.fspick
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fspick)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1b1
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_fspick)
	call   sys32_fspick
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fspick)

/* Return a `HANDLE_TYPE_PIDFD' handle for the given `pid'
 * This system call exists for compatibility with linux, which does not  allow
 * this call to succeed when `pid' isn't a process leader (i.e. main() thread)
 * @param: flags: Must always be `0' (for now)
 * @return: * :   A handle for the process `pid'
 * @throw: E_PROCESS_EXITED:                                                                 [...]
 * @throw: E_INVALID_ARGUMENT_RESERVED_ARGUMENT:E_INVALID_ARGUMENT_CONTEXT_PIDFD_OPEN_FLAGS: [...]
 * @throw: E_BADALLOC_INSUFFICIENT_HANDLE_NUMBERS:                                           [...] */
/* fd_t pidfd_open(pid_t pid, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.pidfd_open
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pidfd_open)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1b2
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_pidfd_open)
	call   sys32_pidfd_open
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_pidfd_open)

/* syscall_slong_t clone3(struct clone_args *cl_args, size_t size) */
.section .text.x86.asm32_syscall_int80.clone3
INTERN_WEAK_FUNCTION(__x86_asm32_int80_clone3)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1b3
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_clone3)
	call   sys32_clone3
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_clone3)

/* @param: flags: Set of `CLOSE_RANGE_*' from <linux/close_range.h> */
/* errno_t close_range(unsigned int minfd, unsigned int maxfd, unsigned int flags) */
.section .text.x86.asm32_syscall_int80.close_range
INTERN_WEAK_FUNCTION(__x86_asm32_int80_close_range)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1b4
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_close_range)
	call   sys32_close_range
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_close_range)

/* errno_t openat2(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.openat2
INTERN_WEAK_FUNCTION(__x86_asm32_int80_openat2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1b5
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_openat2)
	call   sys32_openat2
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_openat2)

/* Duplicate the  handle  of  a  foreign  process into  a  handle  for  the  caller.
 * This system call duplicates the functionality of `open("/proc/[pid]/fd/[fdno]")',
 * which may also be used to duplicate file handles from another process.
 * @param: pidfd: A `HANDLE_TYPE_PIDFD'-handle
 * @param: fd:    The FD-number of the handle to clone
 * @param: flags: Must always be `0' (for now)
 * @return: * :   The duplicated handle number
 * @throw: E_PROCESS_EXITED:                                                                  [...]
 * @throw: E_INVALID_ARGUMENT_RESERVED_ARGUMENT:E_INVALID_ARGUMENT_CONTEXT_PIDFD_GETFD_FLAGS: [...]
 * @throw: E_BADALLOC_INSUFFICIENT_HANDLE_NUMBERS:                                            [...]
 * @throw: E_INVALID_HANDLE_FILE:                                                             [...]
 * @throw: E_ILLEGAL_OPERATION:                                                               [...] */
/* fd_t pidfd_getfd(fd_t pidfd, fd_t foreign_fd, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.pidfd_getfd
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pidfd_getfd)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1b6
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movslq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_pidfd_getfd)
	call   sys32_pidfd_getfd
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_pidfd_getfd)

/* @param: type: Set of `R_OK | W_OK | X_OK' or `F_OK'
 * @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_EACCESS | AT_DOSPATH' */
/* errno_t faccessat2(fd_t dirfd, char const *filename, syscall_ulong_t type, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.faccessat2
INTERN_WEAK_FUNCTION(__x86_asm32_int80_faccessat2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1b7
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_faccessat2)
	call   sys32_faccessat2
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_faccessat2)

/* Same as  `writev(2)', but  write data  to a  file at  a
 * specific `offset', rather than the current R/W position
 * @return: <= SUM(iov[*].iov_len): The actual amount of written bytes */
/* ssize_t pwritevf(fd_t fd, struct iovecx32 const *iovec, size_t count, uint64_t offset, iomode_t mode) */
.section .text.x86.asm32_syscall_int80.pwritevf
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pwritevf)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffeb2
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %rax          /* %rax = REG3:REG4 */
	movzlq %esi, %r8           /* ... */
	shlq   $(32), %rax            /* ... */
	orq    %r8, %rax           /* ... */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movq   %rax, %rcx /* ARG3 = %rax */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ebp, %r8 /* ARG4 = REG5 */
	EXTERN(sys32_pwritevf)
	call   sys32_pwritevf
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_pwritevf)

/* Same as  `readv(2)', but  read data  from a  file at  a
 * specific `offset', rather than the current R/W position
 * @return: <= SUM(iov[*].iov_len): The actual amount of read bytes */
/* ssize_t preadvf(fd_t fd, struct iovecx32 const *iovec, size_t count, uint64_t offset, iomode_t mode) */
.section .text.x86.asm32_syscall_int80.preadvf
INTERN_WEAK_FUNCTION(__x86_asm32_int80_preadvf)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffeb3
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %rax          /* %rax = REG3:REG4 */
	movzlq %esi, %r8           /* ... */
	shlq   $(32), %rax            /* ... */
	orq    %r8, %rax           /* ... */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movq   %rax, %rcx /* ARG3 = %rax */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ebp, %r8 /* ARG4 = REG5 */
	EXTERN(sys32_preadvf)
	call   sys32_preadvf
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_preadvf)

/* errno_t fallocate64(fd_t fd, syscall_ulong_t mode, uint64_t offset, uint64_t length) */
.section .text.x86.asm32_syscall_int80.fallocate64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fallocate64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffebc
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %esi, %rdx          /* ARG2 = REG2:REG3 */
	movzlq %edx, %rax          /* ... */
	shlq   $(32), %rdx            /* ... */
	orq    %rax, %rdx          /* ... */
	movzlq %ebp, %rax          /* %rax = REG4:REG5 */
	movzlq %edi, %r8           /* ... */
	shlq   $(32), %rax            /* ... */
	orq    %r8, %rax           /* ... */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movq   %rax, %rcx /* ARG3 = %rax */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_fallocate64)
	call   sys32_fallocate64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fallocate64)

/* @param: flags: Set of `0 | AT_READLINK_REQSIZE | AT_DOSPATH' */
/* ssize_t freadlinkat(fd_t dirfd, char const *path, char *buf, size_t buflen, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.freadlinkat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_freadlinkat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffecf
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_freadlinkat)
	call   sys32_freadlinkat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_freadlinkat)

/* @param: flags: Set of `0 | AT_DOSPATH' */
/* errno_t fsymlinkat(char const *link_text, fd_t tofd, char const *target_path, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.fsymlinkat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fsymlinkat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffed0
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movslq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_fsymlinkat)
	call   sys32_fsymlinkat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fsymlinkat)

/* @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_DOSPATH' */
/* errno_t kfstatat(fd_t dirfd, char const *filename, struct __kos_stat *statbuf, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.kfstatat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_kfstatat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffed4
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_kfstatat)
	call   sys32_kfstatat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_kfstatat)

/* errno_t futimesat64(fd_t dirfd, char const *filename, struct timevalx32_64 const[2] times) */
.section .text.x86.asm32_syscall_int80.futimesat64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_futimesat64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffed5
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_futimesat64)
	call   sys32_futimesat64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_futimesat64)

/* @param: flags: Set of `0 | AT_DOSPATH' */
/* errno_t fmknodat(fd_t dirfd, char const *nodename, mode_t mode, dev_t dev, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.fmknodat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fmknodat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffed7
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_fmknodat)
	call   sys32_fmknodat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fmknodat)

/* @param: flags: Set of `0 | AT_DOSPATH' */
/* errno_t fmkdirat(fd_t dirfd, char const *pathname, mode_t mode, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.fmkdirat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fmkdirat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffed8
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_fmkdirat)
	call   sys32_fmkdirat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fmkdirat)

/* @param: atflags: Set of `AT_SYMLINK_NOFOLLOW | AT_DOSPATH'
 * @param: mask:    Set of `IN_ALL_EVENTS | ...' */
/* int inotify_add_watch_at(fd_t notify_fd, fd_t dirfd, char const *pathname, atflag_t atflags, uint32_t mask) */
.section .text.x86.asm32_syscall_int80.inotify_add_watch_at
INTERN_WEAK_FUNCTION(__x86_asm32_int80_inotify_add_watch_at)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffedc
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movslq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_inotify_add_watch_at)
	call   sys32_inotify_add_watch_at
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_inotify_add_watch_at)

/* @param: idtype:  One of `P_ALL', `P_PID', `P_PGID'
 * @param: options: At least one of `WEXITED', `WSTOPPED', `WCONTINUED', optionally or'd with `WNOHANG | WNOWAIT' */
/* errno_t waitid64(syscall_ulong_t idtype, id_t id, struct __siginfox32_struct *infop, syscall_ulong_t options, struct rusagex32_64 *ru) */
.section .text.x86.asm32_syscall_int80.waitid64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_waitid64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffee4
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_waitid64)
	call   sys32_waitid64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_waitid64)

/* @param: times:    When NULL, set the current time
 * @param: times[0]: New access time
 * @param: times[1]: New last-modified time */
/* errno_t utimes64(char const *filename, struct timevalx32_64 const[2] times) */
.section .text.x86.asm32_syscall_int80.utimes64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_utimes64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffef1
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_utimes64)
	call   sys32_utimes64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_utimes64)

/* >> set_userprocmask_address(2)
 * Register the address of  the calling thread's userprocmask  controller.
 * This also  initializes `*ctl->pm_sigmask'  and `ctl->pm_pending',  such
 * that `*ctl->pm_sigmask' is filled with the current kernel-level  signal
 * mask, as would be returned by `sigprocmask(2)', while `ctl->pm_pending'
 * is filled in with the equivalent of `sigpending(2)'
 * Additionally,  the address  of `&ctl->pm_mytid'  is stored  as an override
 * for `set_tid_address(2)', and the kernel may read from `*ctl->pm_sigmask',
 * and write to `ctl->pm_pending' (using  atomic-or for the later) from  this
 * point forth.
 * NOTE: Before calling this function, the caller must:
 *       >> bzero(ctl, sizeof(struct userprocmask));
 *       >> ctl->pm_sigsize = sizeof(sigset_t);
 *       >> ctl->pm_sigmask = &initial_sigmask;
 *       Where the initial bzero() is needed to initialize potential
 *       additional,   arch-specific   fields    to   all    zeroes.
 * NOTE: This system call will then initialize:
 *       >> ctl->pm_mytid = gettid();
 *       >> sigprocmask(0, NULL, ctl->pm_sigmask);
 *       >> sigpending(&ctl->pm_pending);
 * NOTE: Passing `NULL' for `ctl' disables userprocmask-mode, though
 *       before this is done, the kernel will copy the  `pm_sigmask'
 *       of the previously set  controller into its internal  signal
 *       mask. (i.e. the one used outside of userprocmask-mode)
 * Note though  that  `pm_sigmask'  is ignored  for  `SIGKILL'  and  `SIGSTOP'
 * Note also  that  this  function replaces  `set_tid_address(2)',  such  that
 * it negates a  prior call  to said  function, while  a future  call to  said
 * function will once again disable userprocmask, same as passing `NULL' would */
/* errno_t set_userprocmask_address(struct userprocmask *ctl) */
.section .text.x86.asm32_syscall_int80.set_userprocmask_address
INTERN_WEAK_FUNCTION(__x86_asm32_int80_set_userprocmask_address)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffefe
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_set_userprocmask_address)
	call   sys32_set_userprocmask_address
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_set_userprocmask_address)

/* >> lfutexexpr(2)
 * The lfutexexpr(2) system call can be used to specify arbitrarily complex
 * expressions that must atomically (in relation to other futex operations)
 * hold true before the scheduler will suspend the calling thread.
 * @param: futexaddr: The futex on which to wait
 * @param: base:      Base pointer added to the `fe_offset' fields of given expressions
 * @param: expr:      Vector of expressions for which to check, terminated by `LFUTEX_EXPREND'
 * @param: timeout:   Timeout for wait operations (s.a. `LFUTEX_WAIT_FLAG_TIMEOUT_*')
 *                    When `LFUTEX_FDBIT'  is  set,  this argument  must  be  `NULL'.
 * @param: flags:     Set of `LFUTEX_WAIT_FLAG_TIMEOUT_*' or `LFUTEX_FDBIT'
 * @return: * : The first  non-zero  return value  from  executing  all of  the  given  `expr'
 *              in order (s.a. the documentations of the individual `LFUTEX_WAIT_*'  functions
 *              to see their  possible return  values, which are  always `0'  when they  would
 *              perform a wait  operation, and usually  `1' otherwise) or  `0' if the  calling
 *              thread had to perform a wait operation, at which point this function returning
 *              that value means that you've once again been re-awoken.
 *              When `LFUTEX_FDBIT' is set, the return value is an `fd_t' for a futex fd that
 *              can be used to poll for the specified `exprv'. Note that in this case `exprv'
 *              is limited to `LFUTEXFD_DEFAULT_MAXEXPR' (`/proc/kos/futexfd-maxexpr')
 * @return: -1:EFAULT:    A faulty pointer was given
 * @return: -1:EINVAL:    One of the given commands is invalid, or `expr[0].fe_condition == LFUTEX_EXPREND'
 * @return: -1:EINTR:     A blocking futex-wait operation was interrupted
 * @return: -1:ETIMEDOUT: A blocking futex-wait operation has timed out */
/* errno_t lfutexexpr(uint32_t *futexaddr, void *base, struct lfutexexprx32 const *expr, struct timespecx32_64 const *timeout, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.lfutexexpr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_lfutexexpr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff0f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_lfutexexpr)
	call   sys32_lfutexexpr
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_lfutexexpr)

/* >> lfutex(2)
 * Provide the bottom-most API for implementing user-space synchronization on KOS
 * @param: futex_op: One of:
 *    - LFUTEX_WAKE:                (lfutex_t *uaddr, LFUTEX_WAKE, size_t count)
 *    - LFUTEX_WAKEMASK:            (lfutex_t *uaddr, LFUTEX_WAKEMASK, size_t count, lfutex_t mask_and, lfutex_t mask_or)
 *    - LFUTEX_WAIT_WHILE:          (lfutex_t *uaddr, LFUTEX_WAIT_WHILE, lfutex_t value, struct timespec const *timeout)
 *    - LFUTEX_WAIT_UNTIL:          (lfutex_t *uaddr, LFUTEX_WAIT_UNTIL, lfutex_t value, struct timespec const *timeout)
 *    - LFUTEX_WAIT_WHILE_ABOVE:    (lfutex_t *uaddr, LFUTEX_WAIT_WHILE_ABOVE, lfutex_t value, struct timespec const *timeout)
 *    - LFUTEX_WAIT_WHILE_BELOW:    (lfutex_t *uaddr, LFUTEX_WAIT_WHILE_BELOW, lfutex_t value, struct timespec const *timeout)
 *    - LFUTEX_WAIT_WHILE_BITMASK:  (lfutex_t *uaddr, LFUTEX_WAIT_WHILE_BITMASK, lfutex_t bitmask, struct timespec const *timeout, lfutex_t setmask)
 *    - LFUTEX_WAIT_UNTIL_BITMASK:  (lfutex_t *uaddr, LFUTEX_WAIT_UNTIL_BITMASK, lfutex_t bitmask, struct timespec const *timeout, lfutex_t setmask)
 *    - LFUTEX_WAIT_WHILE_EX:       (lfutex_t *uaddr, LFUTEX_WAIT_WHILE_EX, void const *rhs, struct timespec const *timeout, size_t num_bytes)
 *    - LFUTEX_WAIT_UNTIL_EX:       (lfutex_t *uaddr, LFUTEX_WAIT_UNTIL_EX, void const *rhs, struct timespec const *timeout, size_t num_bytes)
 *    - LFUTEX_WAIT_WHILE_ABOVE_EX: (lfutex_t *uaddr, LFUTEX_WAIT_WHILE_ABOVE_EX, void const *rhs, struct timespec const *timeout, size_t num_bytes)
 *    - LFUTEX_WAIT_WHILE_BELOW_EX: (lfutex_t *uaddr, LFUTEX_WAIT_WHILE_BELOW_EX, void const *rhs, struct timespec const *timeout, size_t num_bytes)
 * @param: timeout: Timeout for wait operations (s.a. `LFUTEX_WAIT_FLAG_TIMEOUT_*')
 * @return: * : Depending on `futex_op'
 * @return: -1:EFAULT:    A faulty pointer was given
 * @throw:  E_INVALID_ARGUMENT: The given `futex_op' is invalid
 * @throw:  E_INTERRUPT:        A blocking futex-wait operation was interrupted
 * @return: -ETIMEDOUT:         A blocking futex-wait operation has timed out */
/* syscall_slong_t lfutex(uint32_t *uaddr, syscall_ulong_t futex_op, uint32_t val, struct timespecx32_64 const *timeout, uint32_t val2) */
.section .text.x86.asm32_syscall_int80.lfutex
INTERN_WEAK_FUNCTION(__x86_asm32_int80_lfutex)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff10
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_lfutex)
	call   sys32_lfutex
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_lfutex)

/* @param: mode: One of `READDIR_DEFAULT', `READDIR_CONTINUE', `READDIR_PEEK' or `READDIR_MULTIPLE',
 *               optionally     or'd     with     any     of     `READDIR_SKIPREL | READDIR_WANTEOF' */
/* ssize_t kreaddirf(fd_t fd, struct dirent *buf, size_t bufsize, syscall_ulong_t mode, iomode_t iomode) */
.section .text.x86.asm32_syscall_int80.kreaddirf
INTERN_WEAK_FUNCTION(__x86_asm32_int80_kreaddirf)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff23
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_kreaddirf)
	call   sys32_kreaddirf
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_kreaddirf)

/* @param: mode: One of `READDIR_DEFAULT', `READDIR_CONTINUE', `READDIR_PEEK' or `READDIR_MULTIPLE',
 *               optionally     or'd     with     any     of     `READDIR_SKIPREL | READDIR_WANTEOF' */
/* ssize_t kreaddir(fd_t fd, struct dirent *buf, size_t bufsize, syscall_ulong_t mode) */
.section .text.x86.asm32_syscall_int80.kreaddir
INTERN_WEAK_FUNCTION(__x86_asm32_int80_kreaddir)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff24
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_kreaddir)
	call   sys32_kreaddir
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_kreaddir)

/* errno_t kfstat(fd_t fd, struct __kos_stat *statbuf) */
.section .text.x86.asm32_syscall_int80.kfstat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_kfstat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff3b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_kfstat)
	call   sys32_kfstat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_kfstat)

/* errno_t klstat(char const *filename, struct __kos_stat *statbuf) */
.section .text.x86.asm32_syscall_int80.klstat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_klstat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff3c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_klstat)
	call   sys32_klstat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_klstat)

/* errno_t kstat(char const *filename, struct __kos_stat *statbuf) */
.section .text.x86.asm32_syscall_int80.kstat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_kstat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff3d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_kstat)
	call   sys32_kstat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_kstat)

/* ssize_t pwrite64f(fd_t fd, void const *buf, size_t bufsize, uint64_t offset, iomode_t mode) */
.section .text.x86.asm32_syscall_int80.pwrite64f
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pwrite64f)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff4b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %rax          /* %rax = REG3:REG4 */
	movzlq %esi, %r8           /* ... */
	shlq   $(32), %rax            /* ... */
	orq    %r8, %rax           /* ... */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movq   %rax, %rcx /* ARG3 = %rax */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ebp, %r8 /* ARG4 = REG5 */
	EXTERN(sys32_pwrite64f)
	call   sys32_pwrite64f
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_pwrite64f)

/* ssize_t pread64f(fd_t fd, void *buf, size_t bufsize, uint64_t offset, iomode_t mode) */
.section .text.x86.asm32_syscall_int80.pread64f
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pread64f)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff4c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %rax          /* %rax = REG3:REG4 */
	movzlq %esi, %r8           /* ... */
	shlq   $(32), %rax            /* ... */
	orq    %r8, %rax           /* ... */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movq   %rax, %rcx /* ARG3 = %rax */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ebp, %r8 /* ARG4 = REG5 */
	EXTERN(sys32_pread64f)
	call   sys32_pread64f
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_pread64f)

/* Restore the specified register state when returning from a signal handler
 * Note that the order and locations of arguments taken by this system  call
 * are of great importance, as they must match what is encoded by the kernel
 * within `userexcept_callsignal()'
 * The order chosen is also important, as it is selected such that arguments
 * are only passed through registers  that are natively preserved by  signal
 * handler functions. */
/* void ksigreturn(struct fpustate32 const *restore_fpu, syscall_ulong_t unused1, syscall_ulong_t unused2, struct __sigset_with_sizex32 const *restore_sigmask, struct rpc_syscall_info32 const *sc_info, struct ucpustate32 const *restore_cpu) */
.section .text.x86.asm32_syscall_int80.ksigreturn
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ksigreturn)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff53
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %ebp, %r9 /* ARG5 = REG5 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_ksigreturn)
	call   sys32_ksigreturn
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_ksigreturn)

/* errno_t nanosleep64(struct timespecx32_64 const *req, struct timespecx32_64 *rem) */
.section .text.x86.asm32_syscall_int80.nanosleep64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_nanosleep64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff5e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_nanosleep64)
	call   sys32_nanosleep64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_nanosleep64)

/* >> rpc_serve_sysret(2)
 * Very similar to `rpc_serve(2)', but with the addition that this one
 * will only serve RPCs that can be handled in `RPC_REASONCTX_SYSRET',
 * aka. `RPC_REASONCTX_ASYNC' contexts. Additionally, this system call
 * ignores the state of the  internal `TASK_FRPC' flag, and should  be
 * invoked  when  the calling  thread  makes use  of  the userprocmask
 * mechanism, and the  signal mask became  less restrictive while  the
 * `USERPROCMASK_FLAG_HASPENDING' flag was set.
 * 
 * When userprocmask is disabled, this system call is pretty much just
 * a no-op (semnatically speaking, it does nothing). But when enabled,
 * it is really only usable  in conjuction with the userprocmask.  The
 * exact usage can be seen in `chkuserprocmask(3)'.
 * 
 * @return: 0 : Always, unconditionally returned. */
/* errno_t rpc_serve_sysret(void) */
.section .text.x86.asm32_syscall_int80.rpc_serve_sysret
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rpc_serve_sysret)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff61
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_rpc_serve_sysret)
	call   sys32_rpc_serve_sysret
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_rpc_serve_sysret)

/* >> rpc_serve(2)
 * Check for pending signals and RPCs. This is a wrapper around the
 * kernel `task_serve()' function, which is always invoked before a
 * thread begins waiting for a blocking operation. All system calls
 * marked as cancellation  points probably  call `task_serve()'  at
 * some point.
 * Note that unlike (say) `pause(2)', this function doesn't  block,
 * and may be used to implement `pthread_testcancel(3)' (should KOS
 * RPCs be used to facility pthread cancellation points, as done by
 * KOS's builtin libc)
 * @return: 0:      Nothing was handled.
 * @return: -EINTR: RPCs (or posix signals) were handled. */
/* errno_t rpc_serve(void) */
.section .text.x86.asm32_syscall_int80.rpc_serve
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rpc_serve)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff62
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_rpc_serve)
	call   sys32_rpc_serve
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_rpc_serve)

/* syscall_slong_t ksysctl(ioctl_t command, void *arg) */
.section .text.x86.asm32_syscall_int80.ksysctl
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ksysctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff6b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_ksysctl)
	call   sys32_ksysctl
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_ksysctl)

/* Same as `write(2)', but rather than specifying a single, continuous buffer,
 * write  data from `count'  separate buffers, though  still return the actual
 * number of written bytes.
 * When  `fd' has the  `O_NONBLOCK' flag set, only  write as much data
 * as possible at the time the call was made, and throw `E_WOULDBLOCK'
 * if no data could be written at the time.
 * @return: <= SUM(iov[*].iov_len): The actual amount of written bytes
 * @return: 0                     : No more data can be written */
/* ssize_t writevf(fd_t fd, struct iovecx32 const *iovec, size_t count, iomode_t mode) */
.section .text.x86.asm32_syscall_int80.writevf
INTERN_WEAK_FUNCTION(__x86_asm32_int80_writevf)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff6e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_writevf)
	call   sys32_writevf
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_writevf)

/* Same as `read(2)', but rather than specifying a single, continuous buffer,
 * read  data into `count'  separate buffers, though  still return the actual
 * number of read bytes.
 * When `fd' has the `O_NONBLOCK' flag set, only read as much data as was
 * available at  the time  the call  was made,  and throw  `E_WOULDBLOCK'
 * no data was available at the time.
 * @return: <= SUM(iov[*].iov_len): The actual amount of read bytes
 * @return: 0                     : EOF */
/* ssize_t readvf(fd_t fd, struct iovecx32 const *iovec, size_t count, iomode_t mode) */
.section .text.x86.asm32_syscall_int80.readvf
INTERN_WEAK_FUNCTION(__x86_asm32_int80_readvf)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff6f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_readvf)
	call   sys32_readvf
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_readvf)

/* ssize_t select64(size_t nfds, struct __fd_set_struct *readfds, struct __fd_set_struct *writefds, struct __fd_set_struct *exceptfds, struct timevalx32_64 *timeout) */
.section .text.x86.asm32_syscall_int80.select64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_select64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff72
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_select64)
	call   sys32_select64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_select64)

/* Same as `waitpid(pid, STAT_LOC, OPTIONS)', though also fills in `USAGE' when non-NULL
 * @param: options: Set of `WNOHANG | WUNTRACED | WCONTINUED' (as a KOS extension, `WNOWAIT' is also accepted) */
/* pid_t wait4_64(pid_t pid, int32_t *stat_loc, syscall_ulong_t options, struct rusagex32_64 *usage) */
.section .text.x86.asm32_syscall_int80.wait4_64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_wait4_64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff8e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_wait4_64)
	call   sys32_wait4_64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_wait4_64)

/* @param: which: One of `ITIMER_REAL', `ITIMER_VIRTUAL' or `ITIMER_PROF' */
/* errno_t getitimer64(syscall_ulong_t which, struct __itimervalx32_64 *curr_value) */
.section .text.x86.asm32_syscall_int80.getitimer64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getitimer64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff97
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_getitimer64)
	call   sys32_getitimer64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getitimer64)

/* @param: which: One of `ITIMER_REAL', `ITIMER_VIRTUAL' or `ITIMER_PROF' */
/* errno_t setitimer64(syscall_ulong_t which, struct __itimervalx32_64 const *newval, struct __itimervalx32_64 *oldval) */
.section .text.x86.asm32_syscall_int80.setitimer64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setitimer64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff98
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_setitimer64)
	call   sys32_setitimer64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_setitimer64)

/* Map the segments of a given library into memory
 * @param: addr:  Hint address (ignored unless `MAP_FIXED' is passed)
 * @param: flags: Set of `MAP_FIXED | MAP_32BIT | MAP_GROWSDOWN |
 *                MAP_GROWSUP  |  MAP_LOCKED  |  MAP_NORESERVE  |
 *                MAP_POPULATE  |  MAP_NONBLOCK   |  MAP_SYNC   |
 *                MAP_FIXED_NOREPLACE | MAP_NOASLR'
 * @param: fd:    A handle for the library file being mapped (must be mmap(2)-able)
 * @param: hdrv:  Pointer  to  a vector  of `Elf32_Phdr'  or `Elf64_Phdr'
 *                (depending on the caller running in 32- or 64-bit mode)
 * @param: hdrc:  The number of program headers */
/* void *maplibrary(void *addr, syscall_ulong_t flags, fd_t fd, struct elf32_phdr const *hdrv, size_t hdrc) */
.section .text.x86.asm32_syscall_int80.maplibrary
INTERN_WEAK_FUNCTION(__x86_asm32_int80_maplibrary)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffaa
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movslq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_maplibrary)
	call   sys32_maplibrary
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_maplibrary)

/* errno_t settimeofday64(struct timevalx32_64 const *tv, struct timezone const *tz) */
.section .text.x86.asm32_syscall_int80.settimeofday64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_settimeofday64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffb1
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_settimeofday64)
	call   sys32_settimeofday64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_settimeofday64)

/* errno_t gettimeofday64(struct timevalx32_64 *tv, struct timezone *tz) */
.section .text.x86.asm32_syscall_int80.gettimeofday64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_gettimeofday64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffb2
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_gettimeofday64)
	call   sys32_gettimeofday64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_gettimeofday64)

/* @param: who: One of `RUSAGE_SELF', `RUSAGE_CHILDREN' or `RUSAGE_THREAD' */
/* errno_t getrusage64(syscall_slong_t who, struct rusagex32_64 *tv) */
.section .text.x86.asm32_syscall_int80.getrusage64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getrusage64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffb3
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_getrusage64)
	call   sys32_getrusage64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getrusage64)

/* uint64_t fsmode(uint64_t mode) */
.section .text.x86.asm32_syscall_int80.fsmode
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fsmode)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffc4
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ecx, %rdi          /* ARG0 = REG0:REG1 */
	movzlq %ebx, %rax          /* ... */
	shlq   $(32), %rdi            /* ... */
	orq    %rax, %rdi          /* ... */
	EXTERN(sys32_fsmode)
	call   sys32_fsmode
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi %rcx /* %rdx */
	.cfi_restore %rdx
	movq   %rax, %rdx
	shrq   $(32), %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fsmode)

/* syscall_slong_t ioctlf(fd_t fd, ioctl_t command, iomode_t mode, void *arg) */
.section .text.x86.asm32_syscall_int80.ioctlf
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ioctlf)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffca
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_ioctlf)
	call   sys32_ioctlf
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_ioctlf)

/* Check if a transaction is currently in progress
 * @return: 0 : No RTM operation in progress
 * @return: 1 : An RTM operation is currently in progress */
/* syscall_ulong_t rtm_test(void) */
.section .text.x86.asm32_syscall_int80.rtm_test
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rtm_test)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffcd
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_rtm_test)
	call   sys32_rtm_test
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_rtm_test)

/* Abort the current transaction  by having `sys_rtm_begin()' return  with
 * `RTM_ABORT_EXPLICIT | ((code << RTM_ABORT_CODE_S) & RTM_ABORT_CODE_M)'
 * If no transaction was in progress, behave as a no-op and return `-EOK'.
 * Otherwise,  this system call does not return normally, but returns from
 * the original `sys_rtm_begin()' */
/* errno_t rtm_abort(syscall_ulong_t code) */
.section .text.x86.asm32_syscall_int80.rtm_abort
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rtm_abort)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffce
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_rtm_abort)
	call   sys32_rtm_abort
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_rtm_abort)

/* End a transaction
 * If  the  transaction was  successful,  return normally  (by  returning `-EOK').
 * If    the   transaction   failed,   `sys_rtm_begin()'   returns   `RTM_ABORT_*'
 * If no transaction was in progress, an `E_ILLEGAL_OPERATION' exception is thrown */
/* errno_t rtm_end(void) */
.section .text.x86.asm32_syscall_int80.rtm_end
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rtm_end)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffcf
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_rtm_end)
	call   sys32_rtm_end
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_rtm_end)

/* Begin  an  RTM operation.  Note that  if  the arch-specific  RTM driver
 * wasn't already loaded into the kernel, it will be loaded automatically,
 * though any error that may happen during this will result in `RTM_NOSYS'
 * begin returned.
 * Note that while an RTM  operation is in progress,  only a very small  hand
 * full  of system calls are allowed to  be used. Attempting to use arbitrary
 * system calls will most likely  result in an `RTM_ABORT_FAILED' error,  and
 * attempting to access too much system memory in general will result in this
 * function returning  with  `RTM_ABORT_CAPACITY',  rather  than  succeeding.
 * The following is  a list  of system calls  which are  whitelisted for  use
 * during a transaction:
 *   - sys_rtm_begin:  Nested RTM operation
 *   - sys_rtm_end:    End an RTM operation
 *   - sys_rtm_abort:  Abort an RTM operation
 *   - sys_rtm_test:   Check if an RTM operation is in progress (always returns `1')
 * Anything else will most likely result in this system call returning `RTM_ABORT_FAILED'
 * @return: RTM_STARTED : RTM operation was started.
 * @return: RTM_NOSYS   : RTM isn't supposed because the RTM driver is missing, or cannot be loaded.
 * @return: RTM_ABORT_* : RTM operation failed (s.a. code from `<kos/rtm.h>') */
/* rtm_status_t rtm_begin(void) */
.section .text.x86.asm32_syscall_int80.rtm_begin
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rtm_begin)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffd0
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_rtm_begin)
	call   sys32_rtm_begin
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_rtm_begin)

/* errno_t ftime64(struct timebx32_64 *tp) */
.section .text.x86.asm32_syscall_int80.ftime64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ftime64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffdd
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_ftime64)
	call   sys32_ftime64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_ftime64)

/* @param: times: When NULL, set the current time */
/* errno_t utime64(char const *filename, struct utimbufx32_64 const *times) */
.section .text.x86.asm32_syscall_int80.utime64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_utime64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffe2
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_utime64)
	call   sys32_utime64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_utime64)

/* errno_t stime64(time64_t const *t) */
.section .text.x86.asm32_syscall_int80.stime64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_stime64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffe7
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_stime64)
	call   sys32_stime64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_stime64)

/* Construct   a   user-vio-fd  object   supporting  mmap(2),   with  actual
 * memory  accesses  being dispatched  by  adding them  as  pending requests
 * to an internal  queue that  should be read(2)  from by  a worker  thread,
 * which should then service those requests before responding by write(2)ing
 * the results of the operation back to the same fd.
 * HINT: The format of the structures that are read(2) and
 *       write(2)en can be found in `<libvio/userviofd.h>'
 * NOTE: Don't use this system call directly. Use `vio_create(3)'
 *       from `<libvio/vio.h>' instead.
 * @param: initial_size: The initial mmap(2)able size of the returned handle.
 *                       This  size may be  altered at a  later point in time
 *                       through use of `ftruncate(return)'
 * @param: flags:        Set of `0 | O_CLOEXEC | O_CLOFORK | O_NONBLOCK' */
/* fd_t userviofd(size_t initial_size, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.userviofd
INTERN_WEAK_FUNCTION(__x86_asm32_int80_userviofd)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffec
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_userviofd)
	call   sys32_userviofd
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_userviofd)

/* int64_t lseek64(fd_t fd, int64_t offset, syscall_ulong_t whence) */
.section .text.x86.asm32_syscall_int80.lseek64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_lseek64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffed
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rax          /* %rax = REG1:REG2 */
	movzlq %ecx, %r8           /* ... */
	shlq   $(32), %rax            /* ... */
	orq    %r8, %rax           /* ... */
	movzlq %esi, %rdx /* ARG2 = REG3 */
	movq   %rax, %rsi /* ARG1 = %rax */
	EXTERN(sys32_lseek64)
	call   sys32_lseek64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi %rcx /* %rdx */
	.cfi_restore %rdx
	movq   %rax, %rdx
	shrq   $(32), %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_lseek64)

/* Trigger a coredump of the calling process.
 * @param: curr_state:       The  state as is still valid after any possible unwinding has already been done
 *                           Note that this state does not necessarily point to the location that originally
 *                           caused the problem that escalated into a coredump, but is the last valid stack-
 *                           unwind location at which unwinding could no longer continue.
 *                           When `NULL', `orig_state' is used instead, and `traceback_vector' and `traceback_length' are ignored.
 * @param: orig_state:       The original CPU state at where the associated `reason' got triggered
 *                           When `NULL', `curr_state' is used instead, and `traceback_vector' and `traceback_length' are ignored.
 *                           When   `curr_state'   is   also   `NULL',   then   the   current   CPU   state   is   used   instead.
 * @param: traceback_vector: (potentially  incomplete)   vector  of   additional  program   pointers  that   were
 *                           traversed   when   the  stack   was   walked  from   `orig_state'   to  `curr_state'
 *                           Note that earlier  entries within this  vector are further  up the call-stack,  with
 *                           traceback_vector[0] being meant to be the call-site of the function of `orig_state'.
 *                           Note that when `traceback_length != 0 && traceback_vector[traceback_length-1] == ucpustate_getpc(curr_state)',
 *                           it  can  be  assumed  that  the  traceback is  complete  and  contains  all  traversed  instruction locations.
 *                           In   this   case,  a   traceback  displayed   to   a  human   should  not   include   the  text   location  at
 *                           `traceback_vector[traceback_length-1]',    since    that    location    would    also    be    printed    when
 *                           unwinding is completed for the purposes of displaying a traceback.
 * @param: traceback_length: The number of program counters stored within `traceback_vector'
 * @param: reason:           The reason that resulted in the coredump (or `NULL' to get the same behavior as `E_OK')
 *                           For certain `unwind_error' values, this can also  point to other things, but is  always
 *                           allowed to be `NULL' to indicate default/stub values.
 * @param: unwind_error:     The  unwind  error that  caused the  coredump,  or `UNWIND_SUCCESS'  if unwinding
 *                           was  never  actually  performed,  and   `reason'  is  actually  a   `siginfo_t *'
 *                           Ignored when `reason == NULL', in which case `UNWIND_SUCCESS' is assumed instead. */
/* errno_t coredump(struct ucpustate32 const *curr_state, struct ucpustate32 const *orig_state, __HYBRID_PTR32(void const) const *traceback_vector, size_t traceback_length, union coredump_info32 const *reason, unwind_errno_t unwind_error) */
.section .text.x86.asm32_syscall_int80.coredump
INTERN_WEAK_FUNCTION(__x86_asm32_int80_coredump)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffee
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %ebp, %r9 /* ARG5 = REG5 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_coredump)
	call   sys32_coredump
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_coredump)

/* Trigger a debugger trap `trapno', optionally extended with  `regs'
 * at either the system call return location, or at the given `state'
 * In the later case, this system call will by default return to  the
 * given  `state', though given the purpose of this system call being
 * to inform a connected debugger  of some breakable event,  allowing
 * it to do whatever it wishes before execution is resumed.
 * @param: reason:   When non-NULL, the reason for the debug trap (else: use `SIGTRAP:DEBUGTRAP_REASON_NONE')
 * @param: state:    When non-NULL, the CPU state where the trap should return to by default
 * @return: -EOK:    `state' was NULL and the trap returned successfully
 * @return: -ENOENT: No debugger is connected to the calling process/process-group/system */
/* errno_t debugtrap(struct ucpustate32 const *state, struct debugtrap_reason32 const *reason) */
.section .text.x86.asm32_syscall_int80.debugtrap
INTERN_WEAK_FUNCTION(__x86_asm32_int80_debugtrap)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffef
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	EXTERN(sys32_debugtrap)
	call   sys32_debugtrap
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_debugtrap)

/* Get the current exception handler mode for the calling thread.
 * @param: pmode:       When non-`NULL', store the current mode, which is encoded as:
 *                       - One of `EXCEPT_HANDLER_MODE_(DISABLED|ENABLED|SIGHAND)'
 *                       - Or'd with a set of `EXCEPT_HANDLER_FLAG_(ONESHOT|SETHANDLER|SETSTACK)'
 * @param: phandler:    When   non-`NULL',   store  the   address   of  the   user-space   exception  handler.
 *                      Note that when no handler has been set (`!(*pmode & EXCEPT_HANDLER_FLAG_SETHANDLER)'),
 *                      then this pointer is set to `NULL'.
 * @param: phandler_sp: When non-`NULL', store the starting address of the user-space exception handler stack.
 *                      Note that  when no  stack has  been set  (`!(*pmode & EXCEPT_HANDLER_FLAG_SETSTACK)'),
 *                      or when the stack was defined to re-use the previous stack,
 *                      then this pointer is set to `EXCEPT_HANDLER_SP_CURRENT'.
 * @return: 0 :         Success.
 * @return: -1:EFAULT:  One of the given pointers is non-`NULL' and faulty */
/* errno_t get_exception_handler(__ULONG32_TYPE__ *pmode, __except_handler32_t *phandler, __HYBRID_PTR32(void) *phandler_sp) */
.section .text.x86.asm32_syscall_int80.get_exception_handler
INTERN_WEAK_FUNCTION(__x86_asm32_int80_get_exception_handler)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffff0
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_get_exception_handler)
	call   sys32_get_exception_handler
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_get_exception_handler)

/* Set the exception handler mode for the calling thread.
 * Examples:
 *   - Set mode #3 from you `main()': `set_exception_handler(EXCEPT_HANDLER_MODE_SIGHAND, NULL, NULL)'
 *   - Set mode #4 (as done by libc): `set_exception_handler(EXCEPT_HANDLER_MODE_SIGHAND |
 *                                                           EXCEPT_HANDLER_FLAG_SETHANDLER,
 *                                                           &except_handler4, NULL)'
 * @param: mode:       One of `EXCEPT_HANDLER_MODE_*', optionally or'd with `EXCEPT_HANDLER_FLAG_*'
 * @param: handler:    When `EXCEPT_HANDLER_FLAG_SETHANDLER' is set, the address of the exception handler to use
 * @param: handler_sp: When `EXCEPT_HANDLER_FLAG_SETSTACK' is set, the address of the exception handler stack
 * @return: 0 :        Success.
 * @return: -1:EINVAL: The given `mode' is invalid */
/* errno_t set_exception_handler(syscall_ulong_t mode, except_handler_t handler, void *handler_sp) */
.section .text.x86.asm32_syscall_int80.set_exception_handler
INTERN_WEAK_FUNCTION(__x86_asm32_int80_set_exception_handler)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffff1
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_set_exception_handler)
	call   sys32_set_exception_handler
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_set_exception_handler)

/* Create and return a new tty terminal controller connected to the given keyboard and display
 * The  newly created  device automatically gets  assigned an arbitrary  device number, before
 * being made available under a file `/dev/${name}'  (or rather: as ${name} within the  devfs)
 * @param: reserved: Reserved set of flags (Must pass `0'; for future expansion) */
/* fd_t mktty(char const *name, fd_t keyboard, fd_t display, syscall_ulong_t rsvd) */
.section .text.x86.asm32_syscall_int80.mktty
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mktty)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffff2
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	movslq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movslq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_mktty)
	call   sys32_mktty
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_mktty)

/* int64_t time64(int64_t *timer) */
.section .text.x86.asm32_syscall_int80.time64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffff3
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_time64)
	call   sys32_time64
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi %rcx /* %rdx */
	.cfi_restore %rdx
	movq   %rax, %rdx
	shrq   $(32), %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_time64)

/* @param: flags: Set of `0 | AT_DOSPATH' */
/* errno_t fchdirat(fd_t dirfd, char const *path, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.fchdirat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fchdirat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffff4
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	EXTERN(sys32_fchdirat)
	call   sys32_fchdirat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_fchdirat)

/* Create a new pseudo-terminal driver and store handles to both the
 * master  and slave ends  of the connection  in the given pointers. */
/* errno_t openpty(fd_t *amaster, fd_t *aslave, char *name, struct termios const *termp, struct winsize const *winp) */
.section .text.x86.asm32_syscall_int80.openpty
INTERN_WEAK_FUNCTION(__x86_asm32_int80_openpty)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffff5
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_openpty)
	call   sys32_openpty
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_openpty)

/* >> rpc_schedule(2)
 * Schedule an RPC program to-be executed by some other thread. This  function
 * cannot guaranty that  the RPC  program is  always executed,  as the  target
 * thread terminate before the  conditions for the RPC  to be served are  ever
 * met. Note that these  conditions depend on the  given `mode'. Note that  on
 * multi-arch  platforms (such as  x86), the register numbers,  as well as the
 * address size used by `program' depend on the execution mode of `target_tid'
 * 
 * NOTE: Only a cancellation point when `RPC_JOIN_WAITFOR' is used!
 * 
 * @param: target_tid:      The TID of the targeted thread
 * @param: mode:            One of `RPC_SYNCMODE_*',  optionally or'd  with
 *                          one of `RPC_SYSRESTART_*', optionally or'd with
 *                          one of `RPC_PRIORITY_*',  optionally or'd  with
 *                          one of  `RPC_DOMAIN_*',  optionally  or'd  with
 *                          one of `RPC_JOIN_*'
 * @param: program:         The RPC program to execute (sequences of `RPC_OP_*')
 * @param: params:          RPC program parameters (for `RPC_OP_push_param')
 * @param: max_param_count: The max # of `params' used by `program'
 * 
 * @return: 0 :                Success
 * @throws: E_SEGFAULT:        Faulty pointers were given
 * @throws: E_INVALID_ARGUMENT:E_INVALID_ARGUMENT_CONTEXT_RPC_SCHEDULE_MODE:
 *                             The given `mode' is invalid.
 * @throws: E_INVALID_ARGUMENT:E_INVALID_ARGUMENT_CONTEXT_RPC_PROGRAM_INSTRUCTION:
 *                             The RPC program  contains illegal  instructions.
 *                             In this case, modifications made by instructions
 *                             encountered before the illegal one(s) will still
 *                             have  happened, meaning that the target thread's
 *                             state may have become inconsistent.
 * @throws: E_PROCESS_EXITED:  The target thread has already terminated, or
 *                             doesn't exist. Note  though that unless  the
 *                             thread  is  part  of your  own  process, are
 *                             still many reasons  outside of your  control
 *                             for why it  may terminate immediately  after
 *                             the RPC program finished. */
/* errno_t rpc_schedule(pid_t target_tid, syscall_ulong_t mode, void const *program, __HYBRID_PTR32(void const) const *params, size_t max_param_count) */
.section .text.x86.asm32_syscall_int80.rpc_schedule
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rpc_schedule)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffff7
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_rpc_schedule)
	call   sys32_rpc_schedule
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_rpc_schedule)

/* Returns  the  absolute   filesystem  path  for   the  specified   file
 * When `AT_SYMLINK_NOFOLLOW' is given, a final symlink is  dereferenced,
 * causing the pointed-to file location to be retrieved. - Otherwise, the
 * location of the link is printed instead.
 * You may pass `AT_READLINK_REQSIZE' to always have the function return
 * the   required   buffer   size,   rather   than   the   used    size.
 * @param: flags: Set of `0 | AT_ALTPATH | AT_SYMLINK_NOFOLLOW | AT_READLINK_REQSIZE | AT_DOSPATH' */
/* ssize_t frealpathat(fd_t dirfd, char const *filename, char *buf, size_t buflen, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.frealpathat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_frealpathat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffff8
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %edi, %r8 /* ARG4 = REG4 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_frealpathat)
	call   sys32_frealpathat
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_frealpathat)

/* >> detach(2)
 * Detach the descriptor of `PID' from the thread that
 * would have received a signal when it changes state,
 * as well as prevent the  thread from turning into  a
 * zombie once it dies.
 * For simplicity, think of it like this:
 *   - pthread_create()  -->  clone()
 *   - pthread_join()    -->  wait()
 *   - pthread_detach()  -->  detach()  // Linux's missing link, now implemented
 * A total of 4 special cases exists to alter the behavior of this function:
 *   - PID == 0 || PID == gettid():
 *     Detach the calling  thread from  the set of  running children  within
 *     its own process.  Note however  that when this  is done  by the  main
 *     thread of the process, gettid() will equal getpid(), and the behavior
 *     will be different.
 *   - PID == getpid():
 *     Detach the calling process from its parent, essentially daemonizing
 *     the  calling   process   the   same  way   a   double-fork   would:
 *     >> if (fork() == 0) {
 *     >> 	if (fork() == 0) {
 *     >> 		// This is a daemonized process
 *     >> 		// aka. the parent process no longer knows
 *     >> 		// about us, and also can't wait(2) on us.
 *     >> 		...
 *     >> 	}
 *     >> 	exit(0);
 *     >> }
 *     Same as:
 *     >> if (fork() == 0) {
 *     >> 	detach(0); // or `detach(getpid())', since 0 --> gettid() and gettid() == getpid()
 *     >> 	// This is a daemonized process
 *     >> 	// aka. the parent process no longer knows
 *     >> 	// about us, and also can't wait(2) on us.
 *     >> 	...
 *     >> }
 *   - PID == -1:
 *     Detach all child processes/threads  of the calling process,  essentially
 *     turning its chain of children into a clean slate that no longer contains
 *     any wait(2)able child threads or processes.
 *     If no waitable children existed, `ECHILD' is set; else `0' is returned.
 * The given `pid' must be:
 *   - A thread without the caller's process
 *   - A child process of the caller's process
 * NOTE: If a thread is created using clone() with `CLONE_DETACHED' set,
 *       it will behave effectively as though this function had  already
 *       be called.
 * @return: -ECHILD:         `PID' was equal to `-1', but no waitable children existed
 * @throw: E_PROCESS_EXITED: No such  thread/process exists,  or  the thread  isn't  isn't
 *                           a thread in your process, or a child process of your process. */
/* errno_t detach(pid_t pid) */
.section .text.x86.asm32_syscall_int80.detach
INTERN_WEAK_FUNCTION(__x86_asm32_int80_detach)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffff9
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_detach)
	call   sys32_detach
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_detach)

/* You may pass `AT_READLINK_REQSIZE' to always have the function return
 * the   required   buffer   size,   rather   than   the   used    size.
 * @param: flags: Set of `0 | AT_ALTPATH | AT_READLINK_REQSIZE | AT_DOSPATH' */
/* ssize_t frealpath4(fd_t fd, char *resolved, size_t buflen, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.frealpath4
INTERN_WEAK_FUNCTION(__x86_asm32_int80_frealpath4)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffffa
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_frealpath4)
	call   sys32_frealpath4
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_frealpath4)

/* Returns a bitset of all of the currently mounted dos-drives */
/* syscall_slong_t getdrives(void) */
.section .text.x86.asm32_syscall_int80.getdrives
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getdrives)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffffb
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	EXTERN(sys32_getdrives)
	call   sys32_getdrives
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_getdrives)

/* Write up to `bufsize' bytes from `buf' into `fd'
 * When `fd' has the `O_NONBLOCK' flag set, only write as much data as
 * possible at the time the call was made, and throw `E_WOULDBLOCK' if
 * no data could be written at the time.
 * @return: <= bufsize: The actual amount of written bytes
 * @return: 0         : No more data can be written */
/* ssize_t writef(fd_t fd, void const *buf, size_t bufsize, iomode_t mode) */
.section .text.x86.asm32_syscall_int80.writef
INTERN_WEAK_FUNCTION(__x86_asm32_int80_writef)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffffc
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_writef)
	call   sys32_writef
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_writef)

/* Read up to `bufsize' bytes from `fd' into `buf'
 * When  `fd' has the `O_NONBLOCK' flag set, only read as much data as was
 * available at the time the call was made, and throw `E_WOULDBLOCK' if no
 * data was available at the time.
 * @return: <= bufsize: The actual amount of read bytes
 * @return: 0         : EOF */
/* ssize_t readf(fd_t fd, void *buf, size_t bufsize, iomode_t mode) */
.section .text.x86.asm32_syscall_int80.readf
INTERN_WEAK_FUNCTION(__x86_asm32_int80_readf)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffffd
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	EXTERN(sys32_readf)
	call   sys32_readf
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	intr_exit
	.cfi_endproc
END(__x86_asm32_int80_readf)










/* errno_t restart_syscall(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_restart_syscall, __x86_asm32_int80_restart_syscall)

/* Terminate the calling thread (_NOT_ process!)
 * @param: exit_code: Thread exit code (as returned by `wait(2)') */
/* void exit(syscall_ulong_t exit_code) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_exit, __x86_asm32_int80_exit)

/* Clone the calling thread into a second process and return twice, once
 * in  the parent process where this function returns the (non-zero) PID
 * of  the forked child process, and a  second time in the child process
 * itself, where ZERO(0) is returned.
 * The child then usually proceeds by calling `exec(2)' to replace its
 * application image with  that of another  program that the  original
 * parent can then `wait(2)' for. (s.a. `vfork(2)')
 * @return: 0 : You're the new process that was created
 * @return: * : The `return' value is the pid of your new child process */
/* pid_t fork(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_fork, __x86_asm32_int80_fork)

/* Read up to `bufsize' bytes from `fd' into `buf'
 * When  `fd' has the `O_NONBLOCK' flag set, only read as much data as was
 * available at the time the call was made, and throw `E_WOULDBLOCK' if no
 * data was available at the time.
 * @return: <= bufsize: The actual amount of read bytes
 * @return: 0         : EOF */
/* ssize_t read(fd_t fd, void *buf, size_t bufsize) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_read, __x86_asm32_int80_read)

/* Write up to `bufsize' bytes from `buf' into `fd'
 * When `fd' has the `O_NONBLOCK' flag set, only write as much data as
 * possible at the time the call was made, and throw `E_WOULDBLOCK' if
 * no data could be written at the time.
 * @return: <= bufsize: The actual amount of written bytes
 * @return: 0         : No more data can be written */
/* ssize_t write(fd_t fd, void const *buf, size_t bufsize) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_write, __x86_asm32_int80_write)

/* Open  a  new  file  handle  to  the  file  specified  by `filename'
 * When  `oflags & O_CREAT',   then  `mode'   specifies  the   initial
 * file  access  permissions with  which  the file  should  be opened.
 * On KOS, the returned handle can be anything, but is usually one of:
 *   - HANDLE_TYPE_PATH:       When `O_PATH' was given
 *   - HANDLE_TYPE_FILEHANDLE: For `S_IFREG' regular files
 *   - HANDLE_TYPE_FIFOHANDLE: For `S_IFIFO' pipe files
 *   - HANDLE_TYPE_DIRHANDLE:  For `S_IFDIR' directories
 *   - HANDLE_TYPE_MFILE:      The actual filesystem object (including device files)
 *   - *:                      Certain filesystem names can literally return anything, such
 *                             as `/proc/self/fd/1234',  which  is  more  like  `dup(1234)' */
/* fd_t open(char const *filename, oflag_t oflags, mode_t mode) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_open, __x86_asm32_int80_open)

/* Close a given file descriptor/handle `fd' */
/* errno_t close(fd_t fd) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_close, __x86_asm32_int80_close)

/* Wait for a child process:
 *  - `pid < -1':  Wait for any child process whose process group ID is `-PID'
 *  - `pid == -1': Wait for any child process
 *  - `pid == 0':  Wait for any child process whose process group ID is that of the caller
 *  - `pid > 0':   Wait for the child whose process ID is equal to `PID'
 * @param: options: Set of `WNOHANG | WUNTRACED | WCONTINUED' (as a KOS extension, `WNOWAIT' is also accepted) */
/* pid_t waitpid(pid_t pid, int32_t *stat_loc, syscall_ulong_t options) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_waitpid, __x86_asm32_int80_waitpid)

/* fd_t creat(char const *filename, mode_t mode) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_creat, __x86_asm32_int80_creat)

/* errno_t link(char const *existing_file, char const *link_file) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_link, __x86_asm32_int80_link)

/* errno_t unlink(char const *filename) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_unlink, __x86_asm32_int80_unlink)

/* Replace the calling  process with  the application  image referred  to by  `path' /  `file'
 * and execute it's `main()' method, passing the given `argv', and setting `environ' to `envp' */
/* errno_t execve(char const *path, __HYBRID_PTR32(char const) const *argv, __HYBRID_PTR32(char const) const *envp) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_execve, __x86_asm32_int80_execve)

/* errno_t chdir(char const *path) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_chdir, __x86_asm32_int80_chdir)

/* int32_t time(int32_t *timer) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_time, __x86_asm32_int80_time)

/* errno_t mknod(char const *nodename, mode_t mode, dev_t dev) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_mknod, __x86_asm32_int80_mknod)

/* errno_t chmod(char const *filename, mode_t mode) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_chmod, __x86_asm32_int80_chmod)

/* errno_t lchown(char const *filename, uint16_t owner, uint16_t group) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_lchown, __x86_asm32_int80_lchown)

/* errno_t break(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_break, __x86_asm32_int80_break)

/* errno_t oldstat(char const *filename, struct linux_oldstat *statbuf) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_oldstat, __x86_asm32_int80_oldstat)

/* syscall_slong_t lseek(fd_t fd, syscall_slong_t offset, syscall_ulong_t whence) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_lseek, __x86_asm32_int80_lseek)

/* pid_t getpid(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getpid, __x86_asm32_int80_getpid)

/* errno_t mount(char const *special_file, char const *dir, char const *fstype, syscall_ulong_t mountflags, void const *data) */
.section .text.x86.asm32_syscall_sysenter.mount
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mount)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x15
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_mount)
	call   sys32_mount
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_mount)

/* errno_t umount(char const *special_file) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_umount, __x86_asm32_int80_umount)

/* >> setuid(2)
 * Set the UID of the calling thread (this is the so-called ~real~ UID)
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setuid(uint16_t uid) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_setuid, __x86_asm32_int80_setuid)

/* >> getuid(2)
 * @return: * : The UID of the calling thread (this is the so-called ~real~ UID) */
/* uint16_t getuid(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getuid, __x86_asm32_int80_getuid)

/* errno_t stime(time32_t const *t) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_stime, __x86_asm32_int80_stime)

/* syscall_slong_t ptrace(syscall_ulong_t request, pid_t pid, void *addr, void *data) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_ptrace, __x86_asm32_int80_ptrace)

/* syscall_ulong_t alarm(syscall_ulong_t seconds) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_alarm, __x86_asm32_int80_alarm)

/* errno_t oldfstat(fd_t fd, struct linux_oldstat *statbuf) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_oldfstat, __x86_asm32_int80_oldfstat)

/* Same as `select(0, NULL, NULL, NULL, NULL)' */
/* errno_t pause(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_pause, __x86_asm32_int80_pause)

/* @param: times: When NULL, set the current time */
/* errno_t utime(char const *filename, struct utimbufx32 const *times) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_utime, __x86_asm32_int80_utime)

/* errno_t stty(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_stty, __x86_asm32_int80_stty)

/* errno_t gtty(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_gtty, __x86_asm32_int80_gtty)

/* @param: type: Set of `R_OK|W_OK|X_OK' or `F_OK' */
/* errno_t access(char const *filename, syscall_ulong_t type) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_access, __x86_asm32_int80_access)

/* errno_t nice(syscall_slong_t inc) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_nice, __x86_asm32_int80_nice)

/* errno_t ftime(struct timebx32 *tp) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_ftime, __x86_asm32_int80_ftime)

/* errno_t sync(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_sync, __x86_asm32_int80_sync)

/* errno_t kill(pid_t pid, signo_t signo) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_kill, __x86_asm32_int80_kill)

/* errno_t rename(char const *oldname, char const *newname_or_path) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_rename, __x86_asm32_int80_rename)

/* errno_t mkdir(char const *pathname, mode_t mode) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_mkdir, __x86_asm32_int80_mkdir)

/* errno_t rmdir(char const *path) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_rmdir, __x86_asm32_int80_rmdir)

/* fd_t dup(fd_t fd) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_dup, __x86_asm32_int80_dup)

/* errno_t pipe(fd_t[2] pipedes) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_pipe, __x86_asm32_int80_pipe)

/* clock_t times(struct tmsx32 *buf) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_times, __x86_asm32_int80_times)

/* errno_t prof(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_prof, __x86_asm32_int80_prof)

/* errno_t brk(void *addr) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_brk, __x86_asm32_int80_brk)

/* >> setgid(2)
 * Set the GID of the calling thread (this is the so-called ~real~ GID)
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setgid(uint16_t gid) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_setgid, __x86_asm32_int80_setgid)

/* >> getgid(2)
 * @return: * : The GID of the calling thread (this is the so-called ~real~ GID) */
/* uint16_t getgid(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getgid, __x86_asm32_int80_getgid)

/* __sigactionx32_sa_handler_t signal(signo_t signo, __sigactionx32_sa_handler_t handler) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_signal, __x86_asm32_int80_signal)

/* >> geteuid(2)
 * @return: * : The   effective  UID  of  the  calling  thread.
 *              This is the one used for most permission checks */
/* uint16_t geteuid(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_geteuid, __x86_asm32_int80_geteuid)

/* >> getegid(2)
 * @return: * : The   effective  GID  of  the  calling  thread.
 *              This is the one used for most permission checks */
/* uint16_t getegid(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getegid, __x86_asm32_int80_getegid)

/* errno_t acct(char const *filename) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_acct, __x86_asm32_int80_acct)

/* errno_t umount2(char const *special_file, syscall_ulong_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_umount2, __x86_asm32_int80_umount2)

/* errno_t lock(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_lock, __x86_asm32_int80_lock)

/* syscall_slong_t ioctl(fd_t fd, ioctl_t command, void *arg) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_ioctl, __x86_asm32_int80_ioctl)

/* syscall_slong_t fcntl(fd_t fd, fcntl_t command, void *arg) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_fcntl, __x86_asm32_int80_fcntl)

/* errno_t mpx(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_mpx, __x86_asm32_int80_mpx)

/* errno_t setpgid(pid_t pid, pid_t pgid) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_setpgid, __x86_asm32_int80_setpgid)

/* errno_t ulimit(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_ulimit, __x86_asm32_int80_ulimit)

/* errno_t oldolduname(struct linux_oldolduname *name) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_oldolduname, __x86_asm32_int80_oldolduname)

/* mode_t umask(mode_t mode) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_umask, __x86_asm32_int80_umask)

/* errno_t chroot(char const *path) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_chroot, __x86_asm32_int80_chroot)

/* errno_t ustat(dev_t dev, struct ustat *ubuf) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_ustat, __x86_asm32_int80_ustat)

/* fd_t dup2(fd_t oldfd, fd_t newfd) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_dup2, __x86_asm32_int80_dup2)

/* pid_t getppid(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getppid, __x86_asm32_int80_getppid)

/* pid_t getpgrp(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getpgrp, __x86_asm32_int80_getpgrp)

/* pid_t setsid(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_setsid, __x86_asm32_int80_setsid)

/* errno_t sigaction(signo_t signo, struct __old_kernel_sigactionx32 const *act, struct __old_kernel_sigactionx32 *oact) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_sigaction, __x86_asm32_int80_sigaction)

/* uint32_t sgetmask(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_sgetmask, __x86_asm32_int80_sgetmask)

/* uint32_t ssetmask(uint32_t sigmask) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_ssetmask, __x86_asm32_int80_ssetmask)

/* >> setreuid(2)
 * Set the real and effective UID of the calling thread.
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setreuid(uint16_t ruid, uint16_t euid) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_setreuid, __x86_asm32_int80_setreuid)

/* >> setregid(2)
 * Set the real and effective GID of the calling thread.
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setregid(uint16_t rgid, uint16_t egid) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_setregid, __x86_asm32_int80_setregid)

/* >> sigsuspend(2), rt_sigsuspend(2)
 * Atomically save and  set the caller's  signal mask to  `set', then wait  for
 * one of the unmasked (iow: `!sigismember')-signals to arrive before restoring
 * the old signal mask.
 * @param: set: The set of signals on which to wait
 * @return: -1: [errno=EINTR] The signal handler for `signo' was executed. */
/* errno_t sigsuspend(struct __old_sigset_struct const *set) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_sigsuspend, __x86_asm32_int80_sigsuspend)

/* errno_t sigpending(struct __old_sigset_struct *set) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_sigpending, __x86_asm32_int80_sigpending)

/* errno_t sethostname(char const *name, size_t len) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_sethostname, __x86_asm32_int80_sethostname)

/* @param: resource: One of `RLIMIT_*' from <sys/resource.h> */
/* errno_t setrlimit(syscall_ulong_t resource, struct rlimitx32 const *rlimits) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_setrlimit, __x86_asm32_int80_setrlimit)

/* @param: resource: One of `RLIMIT_*' from <sys/resource.h> */
/* errno_t getrlimit(syscall_ulong_t resource, struct rlimitx32 *rlimits) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getrlimit, __x86_asm32_int80_getrlimit)

/* @param: who: One of `RUSAGE_SELF', `RUSAGE_CHILDREN' or `RUSAGE_THREAD' */
/* errno_t getrusage(syscall_slong_t who, struct rusagex32 *tv) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getrusage, __x86_asm32_int80_getrusage)

/* errno_t gettimeofday(struct timevalx32 *tv, struct timezone *tz) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_gettimeofday, __x86_asm32_int80_gettimeofday)

/* errno_t settimeofday(struct timevalx32 const *tv, struct timezone const *tz) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_settimeofday, __x86_asm32_int80_settimeofday)

/* @return: * :     [count == 0] The required number of groups
 * @return: * :     [count != 0] The number of groups that were actually returned
 * @throw: -EINVAL: [count != 0] There are more than `count' groups (NOTE: No exception is thrown for this case!) */
/* ssize_t getgroups(size_t count, uint16_t[] list) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getgroups, __x86_asm32_int80_getgroups)

/* errno_t setgroups(size_t count, uint16_t const *groups) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_setgroups, __x86_asm32_int80_setgroups)

/* ssize_t select(struct sel_arg_structx32 const *arg) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_select, __x86_asm32_int80_select)

/* errno_t symlink(char const *link_text, char const *target_path) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_symlink, __x86_asm32_int80_symlink)

/* errno_t oldlstat(char const *filename, struct linux_oldstat *statbuf) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_oldlstat, __x86_asm32_int80_oldlstat)

/* ssize_t readlink(char const *path, char *buf, size_t buflen) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_readlink, __x86_asm32_int80_readlink)

/* errno_t uselib(char const *library) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_uselib, __x86_asm32_int80_uselib)

/* @param: swapflags: Set of `SWAP_FLAG_*' */
/* errno_t swapon(char const *pathname, syscall_ulong_t swapflags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_swapon, __x86_asm32_int80_swapon)

/* @param: how: One of the `RB_*' constants from <sys/reboot.h> */
/* errno_t reboot(syscall_ulong_t how) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_reboot, __x86_asm32_int80_reboot)

/* Read exactly one directory entry from `fd'
 * Note that the linux version of this system call has one additional argument `count'.
 * However, within the  linux kernel implementation,  that argument is  unconditionally
 * ignored,  and the system call will _always_ read exactly 1 directory entry from `fd'
 * @return: 1 : Read on directory entry
 * @return: 0 : End-of-directory */
/* syscall_slong_t readdir(fd_t fd, struct old_linux_direntx32 *buf) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_readdir, __x86_asm32_int80_readdir)

/* @param: prot:  Either `PROT_NONE', or set of `PROT_EXEC | PROT_WRITE | PROT_READ | PROT_SEM | PROT_SHARED'
 * @param: flags: One of `MAP_SHARED', 'MAP_SHARED_VALIDATE' or `MAP_PRIVATE', optionally or'd
 *               with  a  set of  `MAP_ANONYMOUS  | MAP_FIXED  |  MAP_GROWSDOWN |  MAP_LOCKED |
 *               MAP_NONBLOCK  |  MAP_NORESERVE  |  MAP_POPULATE  |  MAP_STACK  |  MAP_SYNC   |
 *               MAP_UNINITIALIZED | MAP_DONT_MAP | MAP_FIXED_NOREPLACE | MAP_OFFSET64_POINTER' */
/* void *mmap(void *addr, size_t len, syscall_ulong_t prot, syscall_ulong_t flags, fd_t fd, syscall_ulong_t offset) */
.section .text.x86.asm32_syscall_sysenter.mmap
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mmap)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x5a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq 4(%ebp), %r9 /* ARG5 = 4(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_mmap)
	call   sys32_mmap
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_mmap)

/* errno_t munmap(void *addr, size_t len) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_munmap, __x86_asm32_int80_munmap)

/* errno_t truncate(char const *filename, syscall_ulong_t length) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_truncate, __x86_asm32_int80_truncate)

/* errno_t ftruncate(fd_t fd, syscall_ulong_t length) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_ftruncate, __x86_asm32_int80_ftruncate)

/* errno_t fchmod(fd_t fd, mode_t mode) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_fchmod, __x86_asm32_int80_fchmod)

/* errno_t fchown(fd_t fd, uint16_t owner, uint16_t group) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_fchown, __x86_asm32_int80_fchown)

/* @param: which: One of `PRIO_PROCESS', `PRIO_PGRP' or `PRIO_USER' */
/* syscall_slong_t getpriority(syscall_ulong_t which, id_t who) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getpriority, __x86_asm32_int80_getpriority)

/* @param: which: One of `PRIO_PROCESS', `PRIO_PGRP' or `PRIO_USER' */
/* errno_t setpriority(syscall_ulong_t which, id_t who, syscall_ulong_t value) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_setpriority, __x86_asm32_int80_setpriority)

/* errno_t profil(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_profil, __x86_asm32_int80_profil)

/* errno_t statfs(char const *file, struct statfsx32 *buf) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_statfs, __x86_asm32_int80_statfs)

/* errno_t fstatfs(fd_t file, struct statfsx32 *buf) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_fstatfs, __x86_asm32_int80_fstatfs)

/* errno_t ioperm(syscall_ulong_t from, syscall_ulong_t num, syscall_ulong_t turn_on) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_ioperm, __x86_asm32_int80_ioperm)

/* __LONG32_TYPE__ socketcall(__ULONG32_TYPE__ call, __ULONG32_TYPE__ *args) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_socketcall, __x86_asm32_int80_socketcall)

/* ssize_t syslog(syscall_ulong_t level, char const *str, size_t len) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_syslog, __x86_asm32_int80_syslog)

/* @param: which: One of `ITIMER_REAL', `ITIMER_VIRTUAL' or `ITIMER_PROF' */
/* errno_t setitimer(syscall_ulong_t which, struct __itimervalx32 const *newval, struct __itimervalx32 *oldval) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_setitimer, __x86_asm32_int80_setitimer)

/* @param: which: One of `ITIMER_REAL', `ITIMER_VIRTUAL' or `ITIMER_PROF' */
/* errno_t getitimer(syscall_ulong_t which, struct __itimervalx32 *curr_value) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getitimer, __x86_asm32_int80_getitimer)

/* errno_t stat(char const *filename, struct linux_statx32 *statbuf) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_stat, __x86_asm32_int80_stat)

/* errno_t lstat(char const *filename, struct linux_statx32 *statbuf) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_lstat, __x86_asm32_int80_lstat)

/* errno_t fstat(fd_t fd, struct linux_statx32 *statbuf) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_fstat, __x86_asm32_int80_fstat)

/* errno_t olduname(struct linux_olduname *name) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_olduname, __x86_asm32_int80_olduname)

/* errno_t iopl(syscall_ulong_t level) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_iopl, __x86_asm32_int80_iopl)

/* errno_t vhangup(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_vhangup, __x86_asm32_int80_vhangup)

/* errno_t idle(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_idle, __x86_asm32_int80_idle)

/* errno_t vm86old(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_vm86old, __x86_asm32_int80_vm86old)

/* Same as `waitpid(pid, STAT_LOC, OPTIONS)', though also fills in `USAGE' when non-NULL
 * @param: options: Set of `WNOHANG | WUNTRACED | WCONTINUED' (as a KOS extension, `WNOWAIT' is also accepted) */
/* pid_t wait4(pid_t pid, int32_t *stat_loc, syscall_ulong_t options, struct rusagex32 *usage) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_wait4, __x86_asm32_int80_wait4)

/* errno_t swapoff(char const *pathname) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_swapoff, __x86_asm32_int80_swapoff)

/* errno_t sysinfo(struct __sysinfox32 *info) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_sysinfo, __x86_asm32_int80_sysinfo)

/* errno_t ipc(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_ipc, __x86_asm32_int80_ipc)

/* Synchronize a file (including its descriptor which contains timestamps, and its size),
 * meaning  that  changes   to  its   data  and/or   descriptor  are   written  to   disk */
/* errno_t fsync(fd_t fd) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_fsync, __x86_asm32_int80_fsync)

/* void sigreturn(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_sigreturn, __x86_asm32_int80_sigreturn)

/* pid_t clone(syscall_ulong_t flags, void *child_stack, pid_t *ptid, uintptr_t newtls, pid_t *ctid) */
.section .text.x86.asm32_syscall_sysenter.clone
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_clone)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x78
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_clone)
	call   sys32_clone
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_clone)

/* errno_t setdomainname(char const *name, size_t len) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_setdomainname, __x86_asm32_int80_setdomainname)

/* errno_t uname(struct utsname *name) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_uname, __x86_asm32_int80_uname)

/* syscall_slong_t modify_ldt(syscall_ulong_t func, void *ptr, syscall_ulong_t bytecount) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_modify_ldt, __x86_asm32_int80_modify_ldt)

/* errno_t adjtimex(struct timex *ntx) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_adjtimex, __x86_asm32_int80_adjtimex)

/* @param: prot: Either `PROT_NONE', or set of `PROT_EXEC | PROT_WRITE | PROT_READ | PROT_SEM | PROT_SHARED' */
/* errno_t mprotect(void *addr, size_t len, syscall_ulong_t prot) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_mprotect, __x86_asm32_int80_mprotect)

/* @param: how: One of `SIG_BLOCK', `SIG_UNBLOCK' or `SIG_SETMASK' */
/* errno_t sigprocmask(syscall_ulong_t how, struct __old_sigset_struct const *set, struct __old_sigset_struct *oset) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_sigprocmask, __x86_asm32_int80_sigprocmask)

/* errno_t create_module(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_create_module, __x86_asm32_int80_create_module)

/* Load a  kernel  driver  from an  ELF  image  `module_image...+=len'
 * This system call exists for linux compatibility, and is implemented
 * as an alias for  `KSYSCTL_DRIVER_INSMOD:KSYSCTL_DRIVER_FORMAT_BLOB'
 * 
 * Note however that that is where linux compatibility ends. Since the
 * linux kernel does not implement any semblance of a stable ABI,  you
 * have to realize that on KOS, this system call can only load drivers
 * specifically built to run within the KOS kernel!
 * @param: uargs: The driver commandline */
/* errno_t init_module(void const *module_image, size_t len, char const *uargs) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_init_module, __x86_asm32_int80_init_module)

/* Try to unload a driver, given its `name'
 * This system call exists for linux compatibility, and is implemented
 * as an alias for  `KSYSCTL_DRIVER_DELMOD:KSYSCTL_DRIVER_FORMAT_FILE'
 * @param: name:  The name of the driver
 * @param: flags: Set of `O_NONBLOCK | O_TRUNC', where:
 *                - O_NONBLOCK: s.a. `KSYSCTL_DRIVER_DELMOD_FNONBLOCK'
 *                - O_TRUNC:    s.a. `KSYSCTL_DRIVER_DELMOD_FFORCE' */
/* errno_t delete_module(char const *name, oflag_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_delete_module, __x86_asm32_int80_delete_module)

/* errno_t get_kernel_syms(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_get_kernel_syms, __x86_asm32_int80_get_kernel_syms)

/* errno_t quotactl(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_quotactl, __x86_asm32_int80_quotactl)

/* pid_t getpgid(pid_t pid) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getpgid, __x86_asm32_int80_getpgid)

/* errno_t fchdir(fd_t fd) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_fchdir, __x86_asm32_int80_fchdir)

/* errno_t bdflush(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_bdflush, __x86_asm32_int80_bdflush)

/* errno_t sysfs(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_sysfs, __x86_asm32_int80_sysfs)

/* errno_t personality(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_personality, __x86_asm32_int80_personality)

/* errno_t afs_syscall(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_afs_syscall, __x86_asm32_int80_afs_syscall)

/* >> setfsuid(2)
 * Set the  user ID  for the  cred-context (s.a.  `CLONE_CRED') of  the
 * calling thread. The calling thread needs the `CAP_SETUID' privilege.
 * @return: 0:  Success.
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setfsuid(uint16_t uid) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_setfsuid, __x86_asm32_int80_setfsuid)

/* >> setfsgid(2)
 * Set the group  ID for  the cred-context (s.a.  `CLONE_CRED') of  the
 * calling thread. The calling thread needs the `CAP_SETGID' privilege.
 * @return: 0:  Success.
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setfsgid(uint16_t gid) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_setfsgid, __x86_asm32_int80_setfsgid)

/* errno_t _llseek(fd_t fd, int64_t offset, uint64_t *result, syscall_ulong_t whence) */
.section .text.x86.asm32_syscall_sysenter._llseek
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter__llseek)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x8c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq %edx, %rax          /* %rax = REG1:REG2 */
	movzlq %ecx, %r8           /* ... */
	shlq   $(32), %rax            /* ... */
	orq    %r8, %rax           /* ... */
	movzlq %esi, %rdx /* ARG2 = REG3 */
	movq   %rax, %rsi /* ARG1 = %rax */
	movzlq 0(%ebp), %rcx /* ARG3 = 0(%ebp) */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32__llseek)
	call   sys32__llseek
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter__llseek)

/* @return: * : The actual number of read entries
 * @return: 0 : End-of-directory */
/* ssize_t getdents(fd_t fd, struct linux_direntx32 *buf, size_t buflen) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getdents, __x86_asm32_int80_getdents)

/* ssize_t _newselect(size_t nfds, struct __fd_set_struct *readfds, struct __fd_set_struct *writefds, struct __fd_set_struct *exceptfds, struct timevalx32 *timeout) */
.section .text.x86.asm32_syscall_sysenter._newselect
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter__newselect)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x8e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32__newselect)
	call   sys32__newselect
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter__newselect)

/* errno_t flock(fd_t fd, syscall_ulong_t operation) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_flock, __x86_asm32_int80_flock)

/* errno_t msync(void *addr, size_t len, syscall_ulong_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_msync, __x86_asm32_int80_msync)

/* Same as `read(2)', but rather than specifying a single, continuous buffer,
 * read  data into `count'  separate buffers, though  still return the actual
 * number of read bytes.
 * When `fd' has the `O_NONBLOCK' flag set, only read as much data as was
 * available at  the time  the call  was made,  and throw  `E_WOULDBLOCK'
 * no data was available at the time.
 * @return: <= SUM(iov[*].iov_len): The actual amount of read bytes
 * @return: 0                     : EOF */
/* ssize_t readv(fd_t fd, struct iovecx32 const *iovec, size_t count) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_readv, __x86_asm32_int80_readv)

/* Same as `write(2)', but rather than specifying a single, continuous buffer,
 * write  data from `count'  separate buffers, though  still return the actual
 * number of written bytes.
 * When  `fd' has the  `O_NONBLOCK' flag set, only  write as much data
 * as possible at the time the call was made, and throw `E_WOULDBLOCK'
 * if no data could be written at the time.
 * @return: <= SUM(iov[*].iov_len): The actual amount of written bytes
 * @return: 0                     : No more data can be written */
/* ssize_t writev(fd_t fd, struct iovecx32 const *iovec, size_t count) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_writev, __x86_asm32_int80_writev)

/* pid_t getsid(pid_t pid) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getsid, __x86_asm32_int80_getsid)

/* Synchronize only the data of a file (not its descriptor which contains
 * timestamps,  and its size),  meaning that changes  are written to disk */
/* errno_t fdatasync(fd_t fd) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_fdatasync, __x86_asm32_int80_fdatasync)

/* errno_t _sysctl(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter__sysctl, __x86_asm32_int80__sysctl)

/* errno_t mlock(void const *addr, size_t len) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_mlock, __x86_asm32_int80_mlock)

/* errno_t munlock(void const *addr, size_t len) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_munlock, __x86_asm32_int80_munlock)

/* @param: flags: Set of `MCL_CURRENT | MCL_FUTURE | MCL_ONFAULT' */
/* errno_t mlockall(syscall_ulong_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_mlockall, __x86_asm32_int80_mlockall)

/* errno_t munlockall(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_munlockall, __x86_asm32_int80_munlockall)

/* errno_t sched_setparam(pid_t pid, struct sched_param const *param) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_sched_setparam, __x86_asm32_int80_sched_setparam)

/* errno_t sched_getparam(pid_t pid, struct sched_param *param) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_sched_getparam, __x86_asm32_int80_sched_getparam)

/* @param: policy: One of `SCHED_OTHER', `SCHED_FIFO', `SCHED_RR', `SCHED_BATCH',
 *                 `SCHED_IDLE',  optionally   or'd  with   `SCHED_RESET_ON_FORK' */
/* errno_t sched_setscheduler(pid_t pid, syscall_ulong_t policy, struct sched_param const *param) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_sched_setscheduler, __x86_asm32_int80_sched_setscheduler)

/* syscall_slong_t sched_getscheduler(pid_t pid) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_sched_getscheduler, __x86_asm32_int80_sched_getscheduler)

/* errno_t sched_yield(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_sched_yield, __x86_asm32_int80_sched_yield)

/* syscall_slong_t sched_get_priority_max(syscall_ulong_t algorithm) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_sched_get_priority_max, __x86_asm32_int80_sched_get_priority_max)

/* syscall_slong_t sched_get_priority_min(syscall_ulong_t algorithm) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_sched_get_priority_min, __x86_asm32_int80_sched_get_priority_min)

/* errno_t sched_rr_get_interval(pid_t pid, struct timespecx32 *ts) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_sched_rr_get_interval, __x86_asm32_int80_sched_rr_get_interval)

/* errno_t nanosleep(struct timespecx32 const *req, struct timespecx32 *rem) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_nanosleep, __x86_asm32_int80_nanosleep)

/* @param: flags: Set of `MREMAP_MAYMOVE | MREMAP_FIXED' */
/* void *mremap(void *addr, size_t old_len, size_t new_len, syscall_ulong_t flags, void *new_address) */
.section .text.x86.asm32_syscall_sysenter.mremap
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mremap)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xa3
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_mremap)
	call   sys32_mremap
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_mremap)

/* >> setresuid(2)
 * @return: 0 : Success
 * Set the real, effective, and saved UID of the calling thread.
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setresuid(uint16_t ruid, uint16_t euid, uint16_t suid) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_setresuid, __x86_asm32_int80_setresuid)

/* >> getresuid(2)
 * Get the real, effective, and saved UID of the calling thread.
 * @return: 0 : Success */
/* errno_t getresuid(uint16_t *ruid, uint16_t *euid, uint16_t *suid) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getresuid, __x86_asm32_int80_getresuid)

/* errno_t vm86(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_vm86, __x86_asm32_int80_vm86)

/* errno_t query_module(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_query_module, __x86_asm32_int80_query_module)

/* ssize_t poll(struct pollfd *fds, size_t nfds, syscall_slong_t timeout) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_poll, __x86_asm32_int80_poll)

/* errno_t nfsservctl(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_nfsservctl, __x86_asm32_int80_nfsservctl)

/* >> setresgid(2)
 * Set the real, effective, and saved GID of the calling thread.
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setresgid(uint16_t rgid, uint16_t egid, uint16_t sgid) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_setresgid, __x86_asm32_int80_setresgid)

/* >> getresgid(2)
 * Get the real, effective, and saved GID of the calling thread.
 * @return: 0 : Success */
/* errno_t getresgid(uint16_t *rgid, uint16_t *egid, uint16_t *sgid) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getresgid, __x86_asm32_int80_getresgid)

/* >> prctl(2)
 * System process control interface. (Linux compatible)
 * @param: command: One of `PR_*' (from <linux/prctl.h>)
 * @param: ... : Up  to 4 additional arguments (dependent on `command')
 *               Note that some control codes  require you to pass  `0'
 *               for  all seemingly "unused" arguments. In these cases,
 *               the documentation for that command includes the number
 *               of unused, but required trailing 0s in its comment.
 * @return: * :  Return value depends on `command' */
/* syscall_slong_t prctl(unsigned int command, syscall_ulong_t arg2, syscall_ulong_t arg3, syscall_ulong_t arg4, syscall_ulong_t arg5) */
.section .text.x86.asm32_syscall_sysenter.prctl
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_prctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xac
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_prctl)
	call   sys32_prctl
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_prctl)

/* void rt_sigreturn(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_rt_sigreturn, __x86_asm32_int80_rt_sigreturn)

/* errno_t rt_sigaction(signo_t signo, struct __kernel_sigactionx32 const *act, struct __kernel_sigactionx32 *oact, size_t sigsetsize) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_rt_sigaction, __x86_asm32_int80_rt_sigaction)

/* @param: how: One of `SIG_BLOCK', `SIG_UNBLOCK' or `SIG_SETMASK' */
/* errno_t rt_sigprocmask(syscall_ulong_t how, struct __sigset_struct const *set, struct __sigset_struct *oset, size_t sigsetsize) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_rt_sigprocmask, __x86_asm32_int80_rt_sigprocmask)

/* errno_t rt_sigpending(struct __sigset_struct *set, size_t sigsetsize) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_rt_sigpending, __x86_asm32_int80_rt_sigpending)

/* syscall_slong_t rt_sigtimedwait(struct __sigset_struct const *set, struct __siginfox32_struct *info, struct timespecx32 const *timeout, size_t sigsetsize) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_rt_sigtimedwait, __x86_asm32_int80_rt_sigtimedwait)

/* @param: usigno: The signal that should be sent
 * @param: uinfo:  [0..1] Additional signal information
 * @throw: E_INVALID_ARGUMENT_UNEXPECTED_COMMAND:E_INVALID_ARGUMENT_CONTEXT_SIGINFO_SIGNO: [...]
 * @throw: E_INVALID_ARGUMENT_BAD_VALUE:E_INVALID_ARGUMENT_CONTEXT_BAD_SIGNO:              [...]
 * @throw: E_INVALID_ARGUMENT_BAD_VALUE:E_INVALID_ARGUMENT_CONTEXT_RAISE_SIGINFO_BADCODE:  [...]
 * @throw: E_ILLEGAL_OPERATION:                                                            [...] */
/* errno_t rt_sigqueueinfo(pid_t pid, signo_t usigno, struct __siginfox32_struct const *uinfo) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_rt_sigqueueinfo, __x86_asm32_int80_rt_sigqueueinfo)

/* >> sigsuspend(2), rt_sigsuspend(2)
 * Atomically save and  set the caller's  signal mask to  `set', then wait  for
 * one of the unmasked (iow: `!sigismember')-signals to arrive before restoring
 * the old signal mask.
 * @param: set: The set of signals on which to wait
 * @return: -1: [errno=EINTR] The signal handler for `signo' was executed. */
/* errno_t rt_sigsuspend(struct __sigset_struct const *set, size_t sigsetsize) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_rt_sigsuspend, __x86_asm32_int80_rt_sigsuspend)

/* ssize_t pread64(fd_t fd, void *buf, size_t bufsize, uint64_t offset) */
.section .text.x86.asm32_syscall_sysenter.pread64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_pread64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xb4
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %rax       /* %rax = REG3:0(%ebp) */
	movzlq %esi, %r8           /* ... */
	shlq   $(32), %rax            /* ... */
	orq    %r8, %rax           /* ... */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movq   %rax, %rcx /* ARG3 = %rax */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_pread64)
	call   sys32_pread64
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_pread64)

/* ssize_t pwrite64(fd_t fd, void const *buf, size_t bufsize, uint64_t offset) */
.section .text.x86.asm32_syscall_sysenter.pwrite64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_pwrite64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xb5
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %rax       /* %rax = REG3:0(%ebp) */
	movzlq %esi, %r8           /* ... */
	shlq   $(32), %rax            /* ... */
	orq    %r8, %rax           /* ... */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movq   %rax, %rcx /* ARG3 = %rax */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_pwrite64)
	call   sys32_pwrite64
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_pwrite64)

/* errno_t chown(char const *filename, uint16_t owner, uint16_t group) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_chown, __x86_asm32_int80_chown)

/* ssize_t getcwd(char *buf, size_t size) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getcwd, __x86_asm32_int80_getcwd)

/* errno_t capget(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_capget, __x86_asm32_int80_capget)

/* errno_t capset(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_capset, __x86_asm32_int80_capset)

/* errno_t sigaltstack(struct __sigaltstackx32 const *ss, struct __sigaltstackx32 *oss) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_sigaltstack, __x86_asm32_int80_sigaltstack)

/* Read up to `num_bytes' from `infd', and write that data to `outfd'
 * Files must be opened with the relevant access permissions (same as
 * would be enforced by `read(2)' and `write(2)')
 * When `pin_offset != NULL', the pointed-to location is used to track
 * the read-position in `infd'. Note that in the event that writing to
 * this address faults, data may  have still been written to  `outfd',
 * so be sure to have this point to writable memory.
 * @param: outfd:      Output file descriptor
 * @param: infd:       Input file descriptor
 * @param: pin_offset: If non-NULL, position from which to start reading,
 *                     and updated to reflect  how much could be  copied.
 * @param: num_bytes:  The max number of bytes to transfer
 * @return: * :        The actual number of bytes transferred */
/* ssize_t sendfile(fd_t outfd, fd_t infd, __ULONG32_TYPE__ *pin_offset, size_t num_bytes) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_sendfile, __x86_asm32_int80_sendfile)

/* errno_t getpmsg(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getpmsg, __x86_asm32_int80_getpmsg)

/* errno_t putpmsg(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_putpmsg, __x86_asm32_int80_putpmsg)

/* Same as `fork(2)', but the child process may be executed within in the same VM
 * as the parent process, with the  parent process remaining suspended until  the
 * child process invokes one of the following system calls:
 *   - `exit(2)'       Terminate the child process
 *   - `exit_group(2)' Terminate the child process
 *   - `execve(2)'     Create a new VM that is populated with the specified process
 *                     image. The parent process will  only be resumed in case  the
 *                     new  program image could  be loaded successfully. Otherwise,
 *                     the call  to  `execve(2)'  returns normally  in  the  child.
 *                     Other functions from the exec()-family behave the same
 * 
 * Care  must be taken when using this system call, since you have to make sure that
 * the  child process doesn't clobber any part of its (shared) stack that may be re-
 * used once execution resumes in  the parent process. The  same also goes for  heap
 * functions,  but generally speaking:  you really shouldn't  do anything that isn't
 * reentrant after calling any one of the fork() functions (since anything but would
 * rely on underlying implementations making proper use of pthread_atfork(3),  which
 * is something that KOS intentionally doesn't do,  since I feel like doing so  only
 * adds unnecessary bloat to code that doesn't rely on this)
 * 
 * Additionally, this system call may be implemented as an alias for `fork(2)', in
 * which  case the parent process will not  actually get suspended until the child
 * process performs any of the actions above. */
/* pid_t vfork(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_vfork, __x86_asm32_int80_vfork)

/* errno_t ugetrlimit(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_ugetrlimit, __x86_asm32_int80_ugetrlimit)

/* void *mmap2(void *addr, size_t len, syscall_ulong_t prot, syscall_ulong_t flags, fd_t fd, syscall_ulong_t pgoffset) */
.section .text.x86.asm32_syscall_sysenter.mmap2
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mmap2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xc0
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq 4(%ebp), %r9 /* ARG5 = 4(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_mmap2)
	call   sys32_mmap2
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_mmap2)

/* errno_t truncate64(char const *filename, uint64_t length) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_truncate64, __x86_asm32_int80_truncate64)

/* errno_t ftruncate64(fd_t fd, uint64_t length) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_ftruncate64, __x86_asm32_int80_ftruncate64)

/* errno_t stat64(char const *filename, struct linux_statx32_64 *statbuf) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_stat64, __x86_asm32_int80_stat64)

/* errno_t lstat64(char const *filename, struct linux_statx32_64 *statbuf) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_lstat64, __x86_asm32_int80_lstat64)

/* errno_t fstat64(fd_t fd, struct linux_statx32_64 *statbuf) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_fstat64, __x86_asm32_int80_fstat64)

/* errno_t lchown32(char const *filename, uint32_t owner, uint32_t group) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_lchown32, __x86_asm32_int80_lchown32)

/* >> getuid(2)
 * @return: * : The UID of the calling thread (this is the so-called ~real~ UID) */
/* uint32_t getuid32(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getuid32, __x86_asm32_int80_getuid32)

/* >> getgid(2)
 * @return: * : The GID of the calling thread (this is the so-called ~real~ GID) */
/* uint32_t getgid32(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getgid32, __x86_asm32_int80_getgid32)

/* >> geteuid(2)
 * @return: * : The   effective  UID  of  the  calling  thread.
 *              This is the one used for most permission checks */
/* uint32_t geteuid32(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_geteuid32, __x86_asm32_int80_geteuid32)

/* >> getegid(2)
 * @return: * : The   effective  GID  of  the  calling  thread.
 *              This is the one used for most permission checks */
/* uint32_t getegid32(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getegid32, __x86_asm32_int80_getegid32)

/* >> setreuid(2)
 * Set the real and effective UID of the calling thread.
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setreuid32(uint32_t ruid, uint32_t euid) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_setreuid32, __x86_asm32_int80_setreuid32)

/* >> setregid(2)
 * Set the real and effective GID of the calling thread.
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setregid32(uint32_t rgid, uint32_t egid) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_setregid32, __x86_asm32_int80_setregid32)

/* @return: * :     [count == 0] The required number of groups
 * @return: * :     [count != 0] The number of groups that were actually returned
 * @throw: -EINVAL: [count != 0] There are more than `count' groups (NOTE: No exception is thrown for this case!) */
/* ssize_t getgroups32(size_t count, uint32_t[] list) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getgroups32, __x86_asm32_int80_getgroups32)

/* errno_t setgroups32(size_t count, uint32_t const *groups) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_setgroups32, __x86_asm32_int80_setgroups32)

/* errno_t fchown32(fd_t fd, uint32_t owner, uint32_t group) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_fchown32, __x86_asm32_int80_fchown32)

/* >> setresuid(2)
 * @return: 0 : Success
 * Set the real, effective, and saved UID of the calling thread.
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setresuid32(uint32_t ruid, uint32_t euid, uint32_t suid) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_setresuid32, __x86_asm32_int80_setresuid32)

/* >> getresuid(2)
 * Get the real, effective, and saved UID of the calling thread.
 * @return: 0 : Success */
/* errno_t getresuid32(uint32_t *ruid, uint32_t *euid, uint32_t *suid) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getresuid32, __x86_asm32_int80_getresuid32)

/* >> setresgid(2)
 * Set the real, effective, and saved GID of the calling thread.
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setresgid32(uint32_t rgid, uint32_t egid, uint32_t sgid) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_setresgid32, __x86_asm32_int80_setresgid32)

/* >> getresgid(2)
 * Get the real, effective, and saved GID of the calling thread.
 * @return: 0 : Success */
/* errno_t getresgid32(uint32_t *rgid, uint32_t *egid, uint32_t *sgid) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getresgid32, __x86_asm32_int80_getresgid32)

/* errno_t chown32(char const *filename, uint32_t owner, uint32_t group) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_chown32, __x86_asm32_int80_chown32)

/* >> setuid(2)
 * Set the UID of the calling thread (this is the so-called ~real~ UID)
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setuid32(uint32_t uid) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_setuid32, __x86_asm32_int80_setuid32)

/* >> setgid(2)
 * Set the GID of the calling thread (this is the so-called ~real~ GID)
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setgid32(uint32_t gid) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_setgid32, __x86_asm32_int80_setgid32)

/* >> setfsuid(2)
 * Set the  user ID  for the  cred-context (s.a.  `CLONE_CRED') of  the
 * calling thread. The calling thread needs the `CAP_SETUID' privilege.
 * @return: 0:  Success.
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setfsuid32(uint32_t uid) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_setfsuid32, __x86_asm32_int80_setfsuid32)

/* >> setfsgid(2)
 * Set the group  ID for  the cred-context (s.a.  `CLONE_CRED') of  the
 * calling thread. The calling thread needs the `CAP_SETGID' privilege.
 * @return: 0:  Success.
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setfsgid32(uint32_t gid) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_setfsgid32, __x86_asm32_int80_setfsgid32)

/* errno_t pivot_root(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_pivot_root, __x86_asm32_int80_pivot_root)

/* errno_t mincore(void *start, size_t len, uint8_t *vec) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_mincore, __x86_asm32_int80_mincore)

/* errno_t madvise(void *addr, size_t len, syscall_ulong_t advice) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_madvise, __x86_asm32_int80_madvise)

/* @return: * : The actual number of read entries
 * @return: 0 : End-of-directory */
/* ssize_t getdents64(fd_t fd, struct linux_dirent64 *buf, size_t buflen) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getdents64, __x86_asm32_int80_getdents64)

/* syscall_slong_t fcntl64(fd_t fd, fcntl_t command, void *arg) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_fcntl64, __x86_asm32_int80_fcntl64)

/* pid_t gettid(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_gettid, __x86_asm32_int80_gettid)

/* ssize_t readahead(fd_t fd, uint64_t offset, size_t count) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_readahead, __x86_asm32_int80_readahead)

/* @param: flags: One of `0', `XATTR_CREATE' or `XATTR_REPLACE' */
/* errno_t setxattr(char const *path, char const *name, void const *buf, size_t bufsize, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.setxattr
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_setxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xe2
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_setxattr)
	call   sys32_setxattr
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_setxattr)

/* @param: flags: One of `0', `XATTR_CREATE' or `XATTR_REPLACE' */
/* errno_t lsetxattr(char const *path, char const *name, void const *buf, size_t bufsize, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.lsetxattr
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_lsetxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xe3
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_lsetxattr)
	call   sys32_lsetxattr
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_lsetxattr)

/* @param: flags: One of `0', `XATTR_CREATE' or `XATTR_REPLACE' */
/* errno_t fsetxattr(fd_t fd, char const *name, void const *buf, size_t bufsize, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.fsetxattr
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fsetxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xe4
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_fsetxattr)
	call   sys32_fsetxattr
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_fsetxattr)

/* ssize_t getxattr(char const *path, char const *name, void *buf, size_t bufsize) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getxattr, __x86_asm32_int80_getxattr)

/* ssize_t lgetxattr(char const *path, char const *name, void *buf, size_t bufsize) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_lgetxattr, __x86_asm32_int80_lgetxattr)

/* ssize_t fgetxattr(fd_t fd, char const *name, void *buf, size_t bufsize) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_fgetxattr, __x86_asm32_int80_fgetxattr)

/* ssize_t listxattr(char const *path, char *listbuf, size_t listbufsize) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_listxattr, __x86_asm32_int80_listxattr)

/* ssize_t llistxattr(char const *path, char *listbuf, size_t listbufsize) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_llistxattr, __x86_asm32_int80_llistxattr)

/* ssize_t flistxattr(fd_t fd, char *listbuf, size_t listbufsize) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_flistxattr, __x86_asm32_int80_flistxattr)

/* errno_t removexattr(char const *path, char const *name) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_removexattr, __x86_asm32_int80_removexattr)

/* errno_t lremovexattr(char const *path, char const *name) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_lremovexattr, __x86_asm32_int80_lremovexattr)

/* errno_t fremovexattr(fd_t fd, char const *name) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_fremovexattr, __x86_asm32_int80_fremovexattr)

/* errno_t tkill(pid_t tid, signo_t signo) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_tkill, __x86_asm32_int80_tkill)

/* Read up to `num_bytes' from `infd', and write that data to `outfd'
 * Files must be opened with the relevant access permissions (same as
 * would be enforced by `read(2)' and `write(2)')
 * When `pin_offset != NULL', the pointed-to location is used to track
 * the read-position in `infd'. Note that in the event that writing to
 * this address faults, data may  have still been written to  `outfd',
 * so be sure to have this point to writable memory.
 * @param: outfd:      Output file descriptor
 * @param: infd:       Input file descriptor
 * @param: pin_offset: If non-NULL, position from which to start reading,
 *                     and updated to reflect  how much could be  copied.
 * @param: num_bytes:  The max number of bytes to transfer
 * @return: * :        The actual number of bytes transferred */
/* ssize_t sendfile64(fd_t outfd, fd_t infd, __ULONG64_TYPE__ *pin_offset, size_t num_bytes) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_sendfile64, __x86_asm32_int80_sendfile64)

/* @param: futex_op: One of `FUTEX_*' from <linux/futex.h> */
/* syscall_slong_t futex(uint32_t *uaddr, syscall_ulong_t futex_op, uint32_t val, struct timespecx32 const *timeout_or_val2, uint32_t *uaddr2, uint32_t val3) */
.section .text.x86.asm32_syscall_sysenter.futex
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_futex)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xf0
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq 4(%ebp), %r9 /* ARG5 = 4(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_futex)
	call   sys32_futex
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_futex)

/* errno_t sched_setaffinity(pid_t pid, size_t cpusetsize, struct __cpu_set_struct const *cpuset) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_sched_setaffinity, __x86_asm32_int80_sched_setaffinity)

/* errno_t sched_getaffinity(pid_t pid, size_t cpusetsize, struct __cpu_set_struct *cpuset) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_sched_getaffinity, __x86_asm32_int80_sched_getaffinity)

/* errno_t set_thread_area(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_set_thread_area, __x86_asm32_int80_set_thread_area)

/* errno_t get_thread_area(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_get_thread_area, __x86_asm32_int80_get_thread_area)

/* errno_t io_setup(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_io_setup, __x86_asm32_int80_io_setup)

/* errno_t io_destroy(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_io_destroy, __x86_asm32_int80_io_destroy)

/* errno_t io_getevents(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_io_getevents, __x86_asm32_int80_io_getevents)

/* errno_t io_submit(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_io_submit, __x86_asm32_int80_io_submit)

/* errno_t io_cancel(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_io_cancel, __x86_asm32_int80_io_cancel)

/* errno_t fadvise64(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_fadvise64, __x86_asm32_int80_fadvise64)

/* Terminate the calling process
 * @param: exit_code: Thread exit code (as returned by `wait(2)') */
/* void exit_group(syscall_ulong_t exit_code) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_exit_group, __x86_asm32_int80_exit_group)

/* errno_t lookup_dcookie(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_lookup_dcookie, __x86_asm32_int80_lookup_dcookie)

/* >> epoll_create(2)
 * Deprecated alias for `epoll_create1(0)' (the `size' argument is ignored)
 * @return: * : The newly created epoll control descriptor.
 * @return: -1: Error (s.a. `errno') */
/* fd_t epoll_create(syscall_ulong_t size) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_epoll_create, __x86_asm32_int80_epoll_create)

/* >> epoll_ctl(2)
 * Manipulate a given  epoll controller  `epfd', as previously  returned by  `epoll_create1(2)'
 * in order to register (`EPOLL_CTL_ADD'), remove (`EPOLL_CTL_DEL') or modify (`EPOLL_CTL_MOD')
 * the file descriptors being monitored
 * @param: op:       One of `EPOLL_CTL_ADD', `EPOLL_CTL_DEL' or `EPOLL_CTL_MOD'
 * @param: fd:       The file descriptor to add/remove/modify
 * @param: info:     The new configuration for `fd' (ignored when `op' is `EPOLL_CTL_DEL')
 * @return: 0 :      Success
 * @return: -EEXIST: [op=EPOLL_CTL_ADD] The given `fd' (and its kernel object) has already been registered
 * @return: -ENOENT: [op=EPOLL_CTL_MOD|EPOLL_CTL_DEL] The given `fd' (and its kernel object) aren't registered
 * @throw: E_ILLEGAL_REFERENCE_LOOP: The  given  `fd'  is  another  epoll  that either
 *                                   forms a loop with `epfd', or has too many nested.
 * @throw: E_INVALID_ARGUMENT_UNKNOWN_COMMAND:E_INVALID_ARGUMENT_CONTEXT_EPOLL_CTL_OP: [...] */
/* errno_t epoll_ctl(fd_t epfd, syscall_ulong_t op, fd_t fd, struct epoll_event *info) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_epoll_ctl, __x86_asm32_int80_epoll_ctl)

/* >> epoll_wait(2)
 * Wait until at least one of the conditions monitored by `epfd' to be met.
 * @param: epfd:      The epoll controller on which to wait.
 * @param: events:    A buffer where the kernel can store information on the
 *                    events that actually took place.
 * @param: maxevents: The # of events that can be stored in `events' (must be >= 1)
 * @param: timeout:   The max amount of time (in milliseconds) before  returning
 *                    in the case where no event occurred in the mean time. When
 *                    set to `-1', wait indefinitely
 * @return: >= 1:     The # of events that happened (written to the first `return'
 *                    items of `events')
 * @return: 0:        No events happened before `timeout' expired.
 * @return: -1:       Error (s.a. `errno') */
/* ssize_t epoll_wait(fd_t epfd, struct epoll_event *events, size_t maxevents, syscall_slong_t timeout) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_epoll_wait, __x86_asm32_int80_epoll_wait)

/* errno_t remap_file_pages(void *start, size_t size, syscall_ulong_t prot, size_t pgoff, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.remap_file_pages
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_remap_file_pages)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x101
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_remap_file_pages)
	call   sys32_remap_file_pages
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_remap_file_pages)

/* pid_t set_tid_address(pid_t *tidptr) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_set_tid_address, __x86_asm32_int80_set_tid_address)

/* errno_t timer_create(clockid_t clock_id, struct sigevent *evp, timer_t *timerid) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_timer_create, __x86_asm32_int80_timer_create)

/* @param: flags: Set of `0 | TIMER_ABSTIME' */
/* errno_t timer_settime(timer_t timerid, syscall_ulong_t flags, struct itimerspecx32 const *value, struct itimerspecx32 *ovalue) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_timer_settime, __x86_asm32_int80_timer_settime)

/* errno_t timer_gettime(timer_t timerid, struct itimerspecx32 *value) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_timer_gettime, __x86_asm32_int80_timer_gettime)

/* syscall_slong_t timer_getoverrun(timer_t timerid) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_timer_getoverrun, __x86_asm32_int80_timer_getoverrun)

/* errno_t timer_delete(timer_t timerid) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_timer_delete, __x86_asm32_int80_timer_delete)

/* errno_t clock_settime(clockid_t clock_id, struct timespecx32 const *tp) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_clock_settime, __x86_asm32_int80_clock_settime)

/* errno_t clock_gettime(clockid_t clock_id, struct timespecx32 *tp) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_clock_gettime, __x86_asm32_int80_clock_gettime)

/* errno_t clock_getres(clockid_t clock_id, struct timespecx32 *res) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_clock_getres, __x86_asm32_int80_clock_getres)

/* errno_t clock_nanosleep(clockid_t clock_id, syscall_ulong_t flags, struct timespecx32 const *requested_time, struct timespecx32 *remaining) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_clock_nanosleep, __x86_asm32_int80_clock_nanosleep)

/* errno_t statfs64(char const *file, struct statfsx32_64 *buf) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_statfs64, __x86_asm32_int80_statfs64)

/* errno_t fstatfs64(fd_t file, struct statfsx32_64 *buf) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_fstatfs64, __x86_asm32_int80_fstatfs64)

/* errno_t tgkill(pid_t pid, pid_t tid, signo_t signo) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_tgkill, __x86_asm32_int80_tgkill)

/* @param: times:    When NULL, set the current time
 * @param: times[0]: New access time
 * @param: times[1]: New last-modified time */
/* errno_t utimes(char const *filename, struct timevalx32 const[2] times) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_utimes, __x86_asm32_int80_utimes)

/* errno_t fadvise64_64(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_fadvise64_64, __x86_asm32_int80_fadvise64_64)

/* errno_t vserver(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_vserver, __x86_asm32_int80_vserver)

/* errno_t mbind(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_mbind, __x86_asm32_int80_mbind)

/* errno_t get_mempolicy(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_get_mempolicy, __x86_asm32_int80_get_mempolicy)

/* errno_t set_mempolicy(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_set_mempolicy, __x86_asm32_int80_set_mempolicy)

/* fd_t mq_open(char const *name, oflag_t oflags, mode_t mode) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_mq_open, __x86_asm32_int80_mq_open)

/* errno_t mq_unlink(char const *name) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_mq_unlink, __x86_asm32_int80_mq_unlink)

/* errno_t mq_timedsend(fd_t mqdes, char const *msg_ptr, size_t msg_len, uint32_t msg_prio, struct timespecx32 const *abs_timeout) */
.section .text.x86.asm32_syscall_sysenter.mq_timedsend
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mq_timedsend)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x117
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_mq_timedsend)
	call   sys32_mq_timedsend
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_mq_timedsend)

/* ssize_t mq_timedreceive(fd_t mqdes, char *msg_ptr, size_t msg_len, uint32_t *pmsg_prio, struct timespecx32 const *abs_timeout) */
.section .text.x86.asm32_syscall_sysenter.mq_timedreceive
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mq_timedreceive)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x118
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_mq_timedreceive)
	call   sys32_mq_timedreceive
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_mq_timedreceive)

/* errno_t mq_notify(fd_t mqdes, struct sigevent const *notification) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_mq_notify, __x86_asm32_int80_mq_notify)

/* errno_t mq_getsetattr(fd_t mqdes, struct mq_attr const *newattr, struct mq_attr *oldattr) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_mq_getsetattr, __x86_asm32_int80_mq_getsetattr)

/* errno_t kexec_load(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_kexec_load, __x86_asm32_int80_kexec_load)

/* @param: idtype:  One of `P_ALL', `P_PID', `P_PGID'
 * @param: options: At least one of `WEXITED', `WSTOPPED', `WCONTINUED', optionally or'd with `WNOHANG | WNOWAIT' */
/* errno_t waitid(syscall_ulong_t idtype, id_t id, struct __siginfox32_struct *infop, syscall_ulong_t options, struct rusagex32 *ru) */
.section .text.x86.asm32_syscall_sysenter.waitid
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_waitid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x11c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_waitid)
	call   sys32_waitid
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_waitid)

/* errno_t add_key(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_add_key, __x86_asm32_int80_add_key)

/* errno_t request_key(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_request_key, __x86_asm32_int80_request_key)

/* errno_t keyctl(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_keyctl, __x86_asm32_int80_keyctl)

/* NOTE: Linux calls `who' `which', and `id' `who' (refactored to prevent confusion)
 * @param: who: One of `IOPRIO_WHO_PROCESS', `IOPRIO_WHO_PGRP' or `IOPRIO_WHO_USER' */
/* errno_t ioprio_set(syscall_ulong_t who, syscall_ulong_t id, syscall_ulong_t ioprio) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_ioprio_set, __x86_asm32_int80_ioprio_set)

/* NOTE: Linux calls `who' `which', and `id' `who' (refactored to prevent confusion)
 * @param: who: One of `IOPRIO_WHO_PROCESS', `IOPRIO_WHO_PGRP' or `IOPRIO_WHO_USER' */
/* syscall_slong_t ioprio_get(syscall_ulong_t who, syscall_ulong_t id) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_ioprio_get, __x86_asm32_int80_ioprio_get)

/* fd_t inotify_init(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_inotify_init, __x86_asm32_int80_inotify_init)

/* @param: mask: Set of `IN_ALL_EVENTS | ...' */
/* int inotify_add_watch(fd_t notify_fd, char const *pathname, uint32_t mask) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_inotify_add_watch, __x86_asm32_int80_inotify_add_watch)

/* @param: wd: Watch fd (as returned by `inotify_add_watch{_at}') */
/* errno_t inotify_rm_watch(fd_t notify_fd, int wd) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_inotify_rm_watch, __x86_asm32_int80_inotify_rm_watch)

/* errno_t migrate_pages(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_migrate_pages, __x86_asm32_int80_migrate_pages)

/* Open  a  new  file  handle  to  the  file  specified  by `filename'
 * When  `oflags & O_CREAT',   then  `mode'   specifies  the   initial
 * file  access  permissions with  which  the file  should  be opened.
 * On KOS, the returned handle can be anything, but is usually one of:
 *   - HANDLE_TYPE_PATH:       When `O_PATH' was given
 *   - HANDLE_TYPE_FILEHANDLE: For `S_IFREG' regular files
 *   - HANDLE_TYPE_FIFOHANDLE: For `S_IFIFO' pipe files
 *   - HANDLE_TYPE_DIRHANDLE:  For `S_IFDIR' directories
 *   - HANDLE_TYPE_MFILE:      The actual filesystem object (including device files)
 *   - *:                      Certain filesystem names can literally return anything, such
 *                             as `/proc/self/fd/1234',  which  is  more  like  `dup(1234)' */
/* fd_t openat(fd_t dirfd, char const *filename, oflag_t oflags, mode_t mode) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_openat, __x86_asm32_int80_openat)

/* errno_t mkdirat(fd_t dirfd, char const *pathname, mode_t mode) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_mkdirat, __x86_asm32_int80_mkdirat)

/* errno_t mknodat(fd_t dirfd, char const *nodename, mode_t mode, dev_t dev) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_mknodat, __x86_asm32_int80_mknodat)

/* @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_DOSPATH' */
/* errno_t fchownat(fd_t dirfd, char const *filename, uid_t owner, gid_t group, atflag_t flags) */
.section .text.x86.asm32_syscall_sysenter.fchownat
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fchownat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x12a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_fchownat)
	call   sys32_fchownat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_fchownat)

/* errno_t futimesat(fd_t dirfd, char const *filename, struct timevalx32 const[2] times) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_futimesat, __x86_asm32_int80_futimesat)

/* @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_DOSPATH' */
/* errno_t fstatat64(fd_t dirfd, char const *filename, struct linux_statx32_64 *statbuf, atflag_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_fstatat64, __x86_asm32_int80_fstatat64)

/* @param: flags: Set of `0 | AT_REMOVEDIR | AT_REMOVEREG | AT_DOSPATH' */
/* errno_t unlinkat(fd_t dirfd, char const *name, atflag_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_unlinkat, __x86_asm32_int80_unlinkat)

/* errno_t renameat(fd_t oldfd, char const *oldname, fd_t newfd, char const *newname_or_path) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_renameat, __x86_asm32_int80_renameat)

/* @param: flags: Set of `0 | AT_EMPTY_PATH | AT_SYMLINK_FOLLOW | AT_DOSPATH' */
/* errno_t linkat(fd_t fromfd, char const *existing_file, fd_t tofd, char const *target_path, atflag_t flags) */
.section .text.x86.asm32_syscall_sysenter.linkat
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_linkat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x12f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movslq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_linkat)
	call   sys32_linkat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_linkat)

/* errno_t symlinkat(char const *link_text, fd_t tofd, char const *target_path) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_symlinkat, __x86_asm32_int80_symlinkat)

/* ssize_t readlinkat(fd_t dirfd, char const *path, char *buf, size_t buflen) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_readlinkat, __x86_asm32_int80_readlinkat)

/* @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_DOSPATH' */
/* errno_t fchmodat(fd_t dirfd, char const *filename, mode_t mode, atflag_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_fchmodat, __x86_asm32_int80_fchmodat)

/* @param: type: Set of `R_OK | W_OK | X_OK' or `F_OK' */
/* errno_t faccessat(fd_t dirfd, char const *filename, syscall_ulong_t type) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_faccessat, __x86_asm32_int80_faccessat)

/* ssize_t pselect6(size_t nfds, struct __fd_set_struct *readfds, struct __fd_set_struct *writefds, struct __fd_set_struct *exceptfds, struct timespecx32 const *timeout, struct __sigset_with_sizex32 const *sigmask_sigset_with_size) */
.section .text.x86.asm32_syscall_sysenter.pselect6
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_pselect6)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x134
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq 4(%ebp), %r9 /* ARG5 = 4(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_pselect6)
	call   sys32_pselect6
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_pselect6)

/* ssize_t ppoll(struct pollfd *fds, size_t nfds, struct timespecx32 const *timeout_ts, struct __sigset_struct const *sigmask, size_t sigsetsize) */
.section .text.x86.asm32_syscall_sysenter.ppoll
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_ppoll)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x135
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_ppoll)
	call   sys32_ppoll
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_ppoll)

/* param: what: Set of `CLONE_*' */
/* errno_t unshare(syscall_ulong_t what) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_unshare, __x86_asm32_int80_unshare)

/* errno_t set_robust_list(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_set_robust_list, __x86_asm32_int80_set_robust_list)

/* errno_t get_robust_list(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_get_robust_list, __x86_asm32_int80_get_robust_list)

/* @param: flags: Set of `SPLICE_F_MOVE | SPLICE_F_NONBLOCK | SPLICE_F_MORE | SPLICE_F_GIFT' */
/* ssize_t splice(fd_t fdin, uint64_t *offin, fd_t fdout, uint64_t *offout, size_t length, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.splice
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_splice)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x139
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq 4(%ebp), %r9 /* ARG5 = 4(%ebp) */
	movslq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_splice)
	call   sys32_splice
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_splice)

/* @param: flags: Set of `SYNC_FILE_RANGE_WAIT_BEFORE | SYNC_FILE_RANGE_WRITE | SYNC_FILE_RANGE_WAIT_AFTER' */
/* errno_t sync_file_range(fd_t fd, uint64_t offset, uint64_t count, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.sync_file_range
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sync_file_range)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x13a
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq %edx, %rax          /* %rax = REG1:REG2 */
	movzlq %ecx, %r8           /* ... */
	shlq   $(32), %rax            /* ... */
	orq    %r8, %rax           /* ... */
	movzlq 0(%ebp), %rdx       /* ARG2 = REG3:0(%ebp) */
	movzlq %esi, %r8           /* ... */
	shlq   $(32), %rdx            /* ... */
	orq    %r8, %rdx           /* ... */
	movq   %rax, %rsi /* ARG1 = %rax */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq 4(%ebp), %rcx /* ARG3 = 4(%ebp) */
	EXTERN(sys32_sync_file_range)
	call   sys32_sync_file_range
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_sync_file_range)

/* @param: flags: Set of `SPLICE_F_MOVE | SPLICE_F_NONBLOCK | SPLICE_F_MORE | SPLICE_F_GIFT' */
/* ssize_t tee(fd_t fdin, fd_t fdout, size_t length, syscall_ulong_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_tee, __x86_asm32_int80_tee)

/* @param: flags: Set of `SPLICE_F_MOVE | SPLICE_F_NONBLOCK | SPLICE_F_MORE | SPLICE_F_GIFT' */
/* ssize_t vmsplice(fd_t fdout, struct iovecx32 const *iov, size_t count, syscall_ulong_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_vmsplice, __x86_asm32_int80_vmsplice)

/* errno_t move_pages(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_move_pages, __x86_asm32_int80_move_pages)

/* errno_t getcpu(uint32_t *cpu, uint32_t *node, struct getcpu_cache *tcache) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getcpu, __x86_asm32_int80_getcpu)

/* >> epoll_pwait(2)
 * Same as `epoll_wait(2)', but change the calling thread's signal mask to `ss' while
 * waiting.  Wait until at least one of the conditions monitored by `epfd' to be met.
 * @param: epfd:      The epoll controller on which to wait.
 * @param: events:    A buffer where the kernel can store information on the
 *                    events that actually took place.
 * @param: maxevents: The # of events that can be stored in `events' (must be >= 1)
 * @param: timeout:   The max amount of time (in milliseconds) before  returning
 *                    in the case where no event occurred in the mean time. When
 *                    set to `-1', wait indefinitely
 * @param: ss:        The signal mask to apply while waiting for an event to happen.
 * @return: >= 1:     The # of events that happened (written to the first `return'
 *                    items of `events')
 * @return: 0:        No events happened before `timeout' expired.
 * @return: -1:       Error (s.a. `errno') */
/* ssize_t epoll_pwait(fd_t epfd, struct epoll_event *events, size_t maxevents, syscall_slong_t timeout, struct __sigset_struct const *ss, size_t sigsetsize) */
.section .text.x86.asm32_syscall_sysenter.epoll_pwait
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_epoll_pwait)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x13f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq 4(%ebp), %r9 /* ARG5 = 4(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movslq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_epoll_pwait)
	call   sys32_epoll_pwait
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_epoll_pwait)

/* @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_CHANGE_BTIME | AT_DOSPATH' */
/* errno_t utimensat(fd_t dirfd, char const *filename, struct timespecx32 const[2] times, atflag_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_utimensat, __x86_asm32_int80_utimensat)

/* Create a poll(2)-able file descriptor which can be used to wait for the
 * delivery of signals masked by `sigmask' to the waiting  thread/process. */
/* errno_t signalfd(fd_t fd, struct __sigset_struct const *sigmask, size_t sigmasksize) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_signalfd, __x86_asm32_int80_signalfd)

/* Return file descriptor for new interval timer source
 * @param: flags: Set of `0 | TFD_NONBLOCK | TFD_CLOEXEC | TFD_CLOFORK' */
/* fd_t timerfd_create(clockid_t clock_id, syscall_ulong_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_timerfd_create, __x86_asm32_int80_timerfd_create)

/* fd_t eventfd(syscall_ulong_t initval) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_eventfd, __x86_asm32_int80_eventfd)

/* @param: mode: Set of `0 | FALLOC_FL_KEEP_SIZE | FALLOC_FL_PUNCH_HOLE | FALLOC_FL_COLLAPSE_RANGE | FALLOC_FL_ZERO_RANGE' */
/* errno_t fallocate(fd_t fd, syscall_ulong_t mode, syscall_ulong_t offset, syscall_ulong_t length) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_fallocate, __x86_asm32_int80_fallocate)

/* Set next expiration time of interval timer source `timerfd' to `utmr'.
 * If `flags'  has the  `TFD_TIMER_ABSTIME' flag  set the  timeout  value
 * is absolute. Optionally return the old expiration time in `otmr'
 * @param: flags: Set of `0 | TFD_TIMER_ABSTIME' */
/* errno_t timerfd_settime(fd_t timerfd, syscall_ulong_t flags, struct itimerspecx32 const *utmr, struct itimerspecx32 *otmr) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_timerfd_settime, __x86_asm32_int80_timerfd_settime)

/* Return the next expiration time of UFD */
/* errno_t timerfd_gettime(fd_t timerfd, struct itimerspecx32 *otmr) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_timerfd_gettime, __x86_asm32_int80_timerfd_gettime)

/* Create a poll(2)-able file descriptor which can be used to wait for the
 * delivery of signals masked by `sigmask' to the waiting  thread/process.
 * @param: flags: Set of `0 | SFD_NONBLOCK | SFD_CLOEXEC | SFD_CLOFORK' */
/* errno_t signalfd4(fd_t fd, struct __sigset_struct const *sigmask, size_t sigmasksize, syscall_ulong_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_signalfd4, __x86_asm32_int80_signalfd4)

/* @param: flags: Set of `EFD_SEMAPHORE | EFD_NONBLOCK | EFD_CLOEXEC | EFD_CLOFORK' */
/* fd_t eventfd2(syscall_ulong_t initval, syscall_ulong_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_eventfd2, __x86_asm32_int80_eventfd2)

/* >> epoll_create1(2)
 * Create  a new epoll control descriptor which can be used for
 * monitoring of pollable events happening in registered files.
 * @param: flags: Set of `EPOLL_CLOEXEC | EPOLL_CLOFORK'
 * @return: * :   The newly created epoll control descriptor.
 * @throw: E_INVALID_ARGUMENT_UNKNOWN_FLAG:E_INVALID_ARGUMENT_CONTEXT_EPOLL_CREATE1_FLAGS: [...] */
/* fd_t epoll_create1(syscall_ulong_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_epoll_create1, __x86_asm32_int80_epoll_create1)

/* @param: flags:  Set of `O_CLOEXEC | O_CLOFORK' */
/* fd_t dup3(fd_t oldfd, fd_t newfd, oflag_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_dup3, __x86_asm32_int80_dup3)

/* errno_t pipe2(fd_t[2] pipedes, oflag_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_pipe2, __x86_asm32_int80_pipe2)

/* @param: flags: Set of `IN_NONBLOCK | IN_CLOEXEC | IN_CLOFORK' */
/* fd_t inotify_init1(syscall_ulong_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_inotify_init1, __x86_asm32_int80_inotify_init1)

/* Same as  `readv(2)', but  read data  from a  file at  a
 * specific `offset', rather than the current R/W position
 * @return: <= SUM(iov[*].iov_len): The actual amount of read bytes */
/* ssize_t preadv(fd_t fd, struct iovecx32 const *iovec, size_t count, uint64_t offset) */
.section .text.x86.asm32_syscall_sysenter.preadv
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_preadv)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x14d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %rax       /* %rax = REG3:0(%ebp) */
	movzlq %esi, %r8           /* ... */
	shlq   $(32), %rax            /* ... */
	orq    %r8, %rax           /* ... */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movq   %rax, %rcx /* ARG3 = %rax */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_preadv)
	call   sys32_preadv
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_preadv)

/* Same as  `writev(2)', but  write data  to a  file at  a
 * specific `offset', rather than the current R/W position
 * @return: <= SUM(iov[*].iov_len): The actual amount of written bytes */
/* ssize_t pwritev(fd_t fd, struct iovecx32 const *iovec, size_t count, uint64_t offset) */
.section .text.x86.asm32_syscall_sysenter.pwritev
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_pwritev)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x14e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %rax       /* %rax = REG3:0(%ebp) */
	movzlq %esi, %r8           /* ... */
	shlq   $(32), %rax            /* ... */
	orq    %r8, %rax           /* ... */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movq   %rax, %rcx /* ARG3 = %rax */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_pwritev)
	call   sys32_pwritev
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_pwritev)

/* @param: usigno: The signal that should be sent
 * @param: uinfo:  [0..1] Additional signal information
 * @throw: E_INVALID_ARGUMENT_UNEXPECTED_COMMAND:E_INVALID_ARGUMENT_CONTEXT_SIGINFO_SIGNO: [...]
 * @throw: E_INVALID_ARGUMENT_BAD_VALUE:E_INVALID_ARGUMENT_CONTEXT_BAD_SIGNO:              [...]
 * @throw: E_INVALID_ARGUMENT_BAD_VALUE:E_INVALID_ARGUMENT_CONTEXT_RAISE_SIGINFO_BADCODE:  [...]
 * @throw: E_ILLEGAL_OPERATION:                                                            [...] */
/* errno_t rt_tgsigqueueinfo(pid_t pid, pid_t tid, signo_t usigno, struct __siginfox32_struct const *uinfo) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_rt_tgsigqueueinfo, __x86_asm32_int80_rt_tgsigqueueinfo)

/* errno_t perf_event_open(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_perf_event_open, __x86_asm32_int80_perf_event_open)

/* Same as `recvmsg(2)', but may be used to receive many
 * messages  (datagrams)  with  a  single  system  call.
 * @param: msg_flags: Set of `MSG_CMSG_CLOEXEC | MSG_CMSG_CLOFORK |
 *                            MSG_DONTWAIT | MSG_ERRQUEUE | MSG_OOB |
 *                            MSG_PEEK  |  MSG_TRUNC |  MSG_WAITALL |
 *                            MSG_WAITFORONE'
 * @throw: Error (s.a. `recvmsg(2)')
 * @return: * : The # of datagrams successfully received. */
/* ssize_t recvmmsg(fd_t sockfd, struct mmsghdrx32 *vmessages, size_t vlen, syscall_ulong_t msg_flags, struct timespecx32 const *tmo) */
.section .text.x86.asm32_syscall_sysenter.recvmmsg
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_recvmmsg)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x151
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_recvmmsg)
	call   sys32_recvmmsg
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_recvmmsg)

/* errno_t fanotify_init(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_fanotify_init, __x86_asm32_int80_fanotify_init)

/* errno_t fanotify_mark(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_fanotify_mark, __x86_asm32_int80_fanotify_mark)

/* @param: resource: One of `RLIMIT_*' from <sys/resource.h> */
/* errno_t prlimit64(pid_t pid, syscall_ulong_t resource, struct rlimitx32_64 const *new_limit, struct rlimitx32_64 *old_limit) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_prlimit64, __x86_asm32_int80_prlimit64)

/* @param: flags: Set of `0 | AT_EMPTY_PATH | AT_SYMLINK_FOLLOW | AT_DOSPATH' */
/* errno_t name_to_handle_at(fd_t dirfd, char const *filename, struct file_handle *handle, int32_t *mnt_id, atflag_t flags) */
.section .text.x86.asm32_syscall_sysenter.name_to_handle_at
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_name_to_handle_at)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x155
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_name_to_handle_at)
	call   sys32_name_to_handle_at
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_name_to_handle_at)

/* fd_t open_by_handle_at(fd_t mountdirfd, struct file_handle const *handle, oflag_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_open_by_handle_at, __x86_asm32_int80_open_by_handle_at)

/* errno_t clock_adjtime(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_clock_adjtime, __x86_asm32_int80_clock_adjtime)

/* errno_t syncfs(fd_t fd) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_syncfs, __x86_asm32_int80_syncfs)

/* Same as `sendmsg(2)', but may be used to send many
 * messages (datagrams)  with a  single system  call.
 * @param: msg_flags: Set of `MSG_CONFIRM | MSG_DONTROUTE | MSG_DONTWAIT |
 *                            MSG_EOR | MSG_MORE | MSG_NOSIGNAL | MSG_OOB'
 * @throw: ... Same as `sendmsg(2)'
 * @return: * : The # of datagrams successfully sent. */
/* ssize_t sendmmsg(fd_t sockfd, struct mmsghdrx32 *vmessages, size_t vlen, syscall_ulong_t msg_flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_sendmmsg, __x86_asm32_int80_sendmmsg)

/* errno_t setns(fd_t fd, syscall_ulong_t nstype) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_setns, __x86_asm32_int80_setns)

/* Read memory from another process's VM
 * @param: flags: Must be `0'
 * @return: * :   The actual number of read bytes */
/* ssize_t process_vm_readv(pid_t pid, struct iovecx32 const *local_iov, size_t liovcnt, struct iovecx32 const *remote_iov, size_t riovcnt, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.process_vm_readv
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_process_vm_readv)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x15b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq 4(%ebp), %r9 /* ARG5 = 4(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_process_vm_readv)
	call   sys32_process_vm_readv
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_process_vm_readv)

/* Write memory to another process's VM
 * @param: flags: Must be `0'
 * @return: * :   The actual number of written bytes */
/* ssize_t process_vm_writev(pid_t pid, struct iovecx32 const *local_iov, size_t liovcnt, struct iovecx32 const *remote_iov, size_t riovcnt, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.process_vm_writev
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_process_vm_writev)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x15c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq 4(%ebp), %r9 /* ARG5 = 4(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_process_vm_writev)
	call   sys32_process_vm_writev
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_process_vm_writev)

/* @param: type: One of  `KCMP_FILE',  `KCMP_FILES',  `KCMP_FS',  `KCMP_IO',
 *               `KCMP_SIGHAND', `KCMP_SYSVSEM', `KCMP_VM', `KCMP_EPOLL_TFD' */
/* syscall_slong_t kcmp(pid_t pid1, pid_t pid2, syscall_ulong_t type, syscall_ulong_t idx1, syscall_ulong_t idx2) */
.section .text.x86.asm32_syscall_sysenter.kcmp
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_kcmp)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x15d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_kcmp)
	call   sys32_kcmp
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_kcmp)

/* Load a  kernel  driver  from an  ELF  image  `module_image...+=len'
 * This system call exists for linux compatibility, and is implemented
 * as an alias for  `KSYSCTL_DRIVER_INSMOD:KSYSCTL_DRIVER_FORMAT_FILE'
 * 
 * Note however that that is where linux compatibility ends. Since the
 * linux kernel does not implement any semblance of a stable ABI,  you
 * have to realize that on KOS, this system call can only load drivers
 * specifically built to run within the KOS kernel!
 * @param: uargs: The driver commandline */
/* errno_t finit_module(fd_t fd, char const *uargs, syscall_ulong_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_finit_module, __x86_asm32_int80_finit_module)

/* errno_t sched_setattr(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_sched_setattr, __x86_asm32_int80_sched_setattr)

/* errno_t sched_getattr(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_sched_getattr, __x86_asm32_int80_sched_getattr)

/* @param: flags: Set of `0 | AT_RENAME_NOREPLACE | AT_RENAME_EXCHANGE | AT_RENAME_WHITEOUT | AT_RENAME_MOVETODIR | AT_DOSPATH' */
/* errno_t renameat2(fd_t olddirfd, char const *oldpath, fd_t newdirfd, char const *newpath, atflag_t flags) */
.section .text.x86.asm32_syscall_sysenter.renameat2
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_renameat2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x161
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movslq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_renameat2)
	call   sys32_renameat2
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_renameat2)

/* errno_t seccomp(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_seccomp, __x86_asm32_int80_seccomp)

/* @param: flags: Set of `0 | GRND_RANDOM | GRND_NONBLOCK' */
/* ssize_t getrandom(void *buf, size_t num_bytes, syscall_ulong_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getrandom, __x86_asm32_int80_getrandom)

/* @param: flags: Set of `MFD_CLOEXEC | MFD_CLOFORK | MFD_ALLOW_SEALING | MFD_HUGETLB' */
/* fd_t memfd_create(char const *name, syscall_ulong_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_memfd_create, __x86_asm32_int80_memfd_create)

/* errno_t bpf(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_bpf, __x86_asm32_int80_bpf)

/* Replace the calling  process with  the application  image referred  to by  `path' /  `file'
 * and execute it's `main()' method, passing the given `argv', and setting `environ' to `envp'
 * @param: flags: Set of `0 | AT_EMPTY_PATH | AT_SYMLINK_NOFOLLOW | AT_DOSPATH' */
/* errno_t execveat(fd_t dirfd, char const *pathname, __HYBRID_PTR32(char const) const *argv, __HYBRID_PTR32(char const) const *envp, atflag_t flags) */
.section .text.x86.asm32_syscall_sysenter.execveat
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_execveat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x166
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_execveat)
	call   sys32_execveat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_execveat)

/* Create a new socket for the given domain/type/protocol triple.
 * @param: domain:   Socket address domain/family (one of `AF_*' from `<sys/socket.h>')
 * @param: type:     Socket type (one of `SOCK_*' from `<sys/socket.h>')
 *                   May optionally be or'd with `SOCK_CLOEXEC | SOCK_CLOFORK | SOCK_NONBLOCK'
 * @param: protocol: Socket protocol (`0' for automatic). Available socket protocols mainly
 *                   depend on the selected `domain', and may be further specialized by the
 *                   `type' argument.  for  example,  `AF_INET' takes  one  of  `IPPROTO_*'
 *                   >> socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
 *                   Also note that protocol IDs can be enumerated by `getprotoent(3)' from `<netdb.h>'
 * @return: * : A file descriptor for the newly created socket. */
/* fd_t socket(syscall_ulong_t domain, syscall_ulong_t type, syscall_ulong_t protocol) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_socket, __x86_asm32_int80_socket)

/* Create a new socket for the given domain/type/protocol triple.
 * @param: domain:   Socket address domain/family (one of `AF_*' from `<sys/socket.h>')
 * @param: type:     Socket type (one of `SOCK_*' from `<sys/socket.h>')
 *                   May optionally be or'd with `SOCK_CLOEXEC | SOCK_CLOFORK | SOCK_NONBLOCK'
 * @param: protocol: Socket protocol (`0' for automatic). Available socket protocols mainly
 *                   depend on the selected `domain', and may be further specialized by the
 *                   `type' argument.  for  example,  `AF_INET' takes  one  of  `IPPROTO_*'
 *                   >> socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
 *                   Also note that protocol IDs can be enumerated by `getprotoent(3)' from `<netdb.h>'
 * @return: * : A file descriptor for the newly created socket. */
/* errno_t socketpair(syscall_ulong_t domain, syscall_ulong_t type, syscall_ulong_t protocol, fd_t[2] fds) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_socketpair, __x86_asm32_int80_socketpair)

/* Bind the given socket `sockfd' to the specified local address.
 * @throw: E_NET_ADDRESS_IN_USE:E_NET_ADDRESS_IN_USE_CONTEXT_CONNECT
 * @throw: E_INVALID_ARGUMENT_UNEXPECTED_COMMAND:E_INVALID_ARGUMENT_CONTEXT_BIND_WRONG_ADDRESS_FAMILY
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_BIND_ALREADY_BOUND
 * @throw: E_NET_ADDRESS_NOT_AVAILABLE
 * @throw: E_BUFFER_TOO_SMALL   (`addr_len' is incorrect)
 * @return: 0 : Success */
/* errno_t bind(fd_t sockfd, struct sockaddr const *addr, socklen_t addr_len) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_bind, __x86_asm32_int80_bind)

/* Connect to the specified address.
 * If the given `sockfd' isn't connection-oriented, this will set the address
 * that  will implicitly be  used as destination  by `send(2)' and `write(2)'
 * @throw: E_NET_ADDRESS_IN_USE:E_NET_ADDRESS_IN_USE_CONTEXT_CONNECT
 * @throw: E_INVALID_ARGUMENT_UNEXPECTED_COMMAND:E_INVALID_ARGUMENT_CONTEXT_BIND_WRONG_ADDRESS_FAMILY
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_BIND_ALREADY_BOUND
 * @throw: E_NET_ADDRESS_NOT_AVAILABLE
 * @throw: E_NET_CONNECTION_REFUSED
 * @throw: E_BUFFER_TOO_SMALL   (addr_len is incorrect)
 * @return: 0 : Success */
/* errno_t connect(fd_t sockfd, struct sockaddr const *addr, socklen_t addr_len) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_connect, __x86_asm32_int80_connect)

/* Begin to listen for incoming client (aka. peer) connection requests.
 * @param: max_backlog: The max number of clients  pending to be accept(2)-ed,  before
 *                      the kernel will refuse to enqueue additional clients, and will
 *                      instead automatically refuse  any further  requests until  the
 *                      less than `max_backlog' clients are still pending.
 * @throw: E_NET_ADDRESS_IN_USE:E_NET_ADDRESS_IN_USE_CONTEXT_LISTEN
 * @throw: E_INVALID_HANDLE_NET_OPERATION:E_NET_OPERATION_LISTEN
 * @return: 0 : Success */
/* errno_t listen(fd_t sockfd, syscall_ulong_t max_backlog) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_listen, __x86_asm32_int80_listen)

/* Accept incoming client (aka. peer) connection requests.
 * @param: addr:       Peer address of the sender (or `NULL' when `addr_len' is `NULL')
 * @param: addr_len:   [NULL] Don't fill in the client's peer address
 *                     [in]   The amount of available memory starting at `addr'
 *                     [out]  The  amount  of required  memory for  the address.
 *                            This  may be  more than  was given,  in which case
 *                            the  address  was  truncated and  may  be invalid.
 *                            If this happens,  the caller  can still  determine
 *                            the correct address through use of `getpeername()'
 * @param: sock_flags: Set of `SOCK_NONBLOCK | SOCK_CLOEXEC | SOCK_CLOFORK'
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_ACCEPT_NOT_LISTENING
 * @throw: E_INVALID_HANDLE_NET_OPERATION:E_NET_OPERATION_ACCEPT
 * @throw: E_NET_CONNECTION_ABORT
 * @return: * : A file descriptor for the newly accept(2)-ed connection */
/* fd_t accept4(fd_t sockfd, struct sockaddr *addr, socklen_t *addr_len, syscall_ulong_t sock_flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_accept4, __x86_asm32_int80_accept4)

/* Get the value of the named socket option `level:optname' and store it in `optval'
 * @param: level:   One of `SOL_*' (e.g.: `SOL_SOCKET')
 * @param: optname: Dependent on `level'
 * @param: optval:  Buffer for where to write the value of the socket option.
 * @param: optlen:  [in]  The amount of available memory starting at `optval'
 *                  [out] The amount of required memory for the option value.
 *                        This may be more than was given, in which case
 *                        the  contents  of   `optval'  are   undefined.
 * @throw: E_INVALID_ARGUMENT_SOCKET_OPT:E_INVALID_ARGUMENT_CONTEXT_GETSOCKOPT
 * @return: 0 : Success */
/* errno_t getsockopt(fd_t sockfd, syscall_ulong_t level, syscall_ulong_t optname, void *optval, socklen_t *optlen) */
.section .text.x86.asm32_syscall_sysenter.getsockopt
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getsockopt)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x16d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_getsockopt)
	call   sys32_getsockopt
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_getsockopt)

/* Set the value of the named socket option `level:optname' from what is given in `optval'
 * @param: level:   One of `SOL_*' (e.g.: `SOL_SOCKET')
 * @param: optname: Dependent on `level'
 * @param: optval:  Buffer for where to write the value of the socket option.
 * @param: optlen:  The amount of available memory starting at `optval'
 * @throw: E_INVALID_ARGUMENT_SOCKET_OPT:E_INVALID_ARGUMENT_CONTEXT_SETSOCKOPT
 * @throw: E_BUFFER_TOO_SMALL  (The specified `optlen' is invalid for the given option)
 * @return: 0 : Success */
/* errno_t setsockopt(fd_t sockfd, syscall_ulong_t level, syscall_ulong_t optname, void const *optval, socklen_t optlen) */
.section .text.x86.asm32_syscall_sysenter.setsockopt
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_setsockopt)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x16e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_setsockopt)
	call   sys32_setsockopt
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_setsockopt)

/* Determine the local address (aka. name) for the given socket `sockfd'.
 * This  is usually the  same address as was  previously set by `bind(2)'
 * NOTE: Before the socket has actually be bound or connected, the exact
 *       address that is returned by this function is weakly  undefined.
 *       e.g.: For AF_INET, sin_addr=0.0.0.0, sin_port=0 is returned.
 * @param: addr:     [out] Buffer where to store the sock address.
 * @param: addr_len: [in]  The amount of available memory starting at `addr'
 *                   [out] The amount of required memory for the address.
 *                         This may be more than was given, in which case
 *                         the  address was truncated and may be invalid.
 * return: 0 : Success */
/* errno_t getsockname(fd_t sockfd, struct sockaddr *addr, socklen_t *addr_len) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getsockname, __x86_asm32_int80_getsockname)

/* Lookup the peer (remote) address of `sockfd' and store it in `*addr...+=*addr_len'
 * @param: addr:     [out] Buffer where to store the sock address.
 * @param: addr_len: [in]  The amount of available memory starting at `addr'
 *                   [out] The amount of required memory for the address.
 *                         This may be more than was given, in which case
 *                         the  address was truncated and may be invalid.
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_GETPEERNAME_NOT_CONNECTED
 * @return: 0 : Success */
/* errno_t getpeername(fd_t sockfd, struct sockaddr *addr, socklen_t *addr_len) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getpeername, __x86_asm32_int80_getpeername)

/* Send the contents of a given buffer over this socket to the specified address
 * @param: buf:       Buffer of data to send (with a length of `bufsize' bytes)
 * @param: bufsize:   Size of `buf' (in bytes)
 * @param: msg_flags: Set of `MSG_CONFIRM | MSG_DONTROUTE | MSG_DONTWAIT |
 *                            MSG_EOR | MSG_MORE | MSG_NOSIGNAL | MSG_OOB'
 * @param: addr:      Address where to send data (or NULL when `addr_len' is 0)
 * @param: addr_len:  Size of `addr', or `0' to have this behave as an alias
 *                    for            `send(sockfd, buf, bufsize, msg_flags)'
 * @throw: E_INVALID_ARGUMENT_UNEXPECTED_COMMAND:E_INVALID_ARGUMENT_CONTEXT_SENDTO_WRONG_ADDRESS_FAMILY
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_SEND_NOT_CONNECTED
 * @throw: E_NET_MESSAGE_TOO_LONG
 * @throw: E_NET_CONNECTION_RESET
 * @throw: E_NET_SHUTDOWN
 * @throw: E_BUFFER_TOO_SMALL  (`addr_len' is incorrect)
 * @return: * : [<= bufsize] The actual # of send bytes */
/* ssize_t sendto(fd_t sockfd, void const *buf, size_t bufsize, syscall_ulong_t msg_flags, struct sockaddr const *addr, socklen_t addr_len) */
.section .text.x86.asm32_syscall_sysenter.sendto
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sendto)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x171
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq 4(%ebp), %r9 /* ARG5 = 4(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_sendto)
	call   sys32_sendto
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_sendto)

/* Same as `send(2)' and `sendto(2)', but also allows for sending ancillary
 * data as well as  for data buffers  to be represented  by an IOV  vector.
 * @param: msg_flags: Set of `MSG_CONFIRM | MSG_DONTROUTE | MSG_DONTWAIT |
 *                            MSG_EOR | MSG_MORE | MSG_NOSIGNAL | MSG_OOB'
 * @throw: ... Same as for `send(2)' and `sendto(2)'
 * @return: * : [<= bufsize] The actual # of send payload bytes */
/* ssize_t sendmsg(fd_t sockfd, struct msghdrx32 const *message, syscall_ulong_t msg_flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_sendmsg, __x86_asm32_int80_sendmsg)

/* Receive data over this socket, and store the contents within the given buffer.
 * @param: buf:       Buffer to-be filled with up to `bufsize' bytes of received data
 * @param: bufsize:   Max # of bytes to receive
 * @param: msg_flags: Set of `MSG_DONTWAIT | MSG_ERRQUEUE | MSG_OOB |
 *                            MSG_PEEK | MSG_TRUNC | MSG_WAITALL'
 * @param: addr:      Peer address of the sender (or `NULL' when `addr_len' is `NULL')
 * @param: addr_len:  [NULL] behave as an alias for `recv(sockfd, buf, bufsize, msg_flags)'
 *                    [in]   The amount of available memory starting at `addr'
 *                    [out]  The amount of required memory for the address.
 *                           This may be more than was given, in which case
 *                           the address was truncated and may be invalid.
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_RECV_NOT_CONNECTED
 * @throw: E_NET_CONNECTION_REFUSED
 * @throw: E_WOULDBLOCK (`MSG_DONTWAIT' was given, and the operation would have blocked)
 * @return: * : [<= bufsize] The actual # of received bytes */
/* ssize_t recvfrom(fd_t sockfd, void *buf, size_t bufsize, syscall_ulong_t msg_flags, struct sockaddr *addr, socklen_t *addr_len) */
.section .text.x86.asm32_syscall_sysenter.recvfrom
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_recvfrom)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x173
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq 4(%ebp), %r9 /* ARG5 = 4(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_recvfrom)
	call   sys32_recvfrom
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_recvfrom)

/* Same as `recv(2)' and `recvfrom(2)', but also allows for receiving ancillary
 * data as  well as  for  data buffers  to be  represented  by an  IOV  vector.
 * @param: msg_flags: Set of `MSG_CMSG_CLOEXEC | MSG_CMSG_CLOFORK |
 *                            MSG_DONTWAIT | MSG_ERRQUEUE | MSG_OOB |
 *                            MSG_PEEK  |  MSG_TRUNC  |  MSG_WAITALL'
 * @throw: ... Same as for `recv(2)' and `recvfrom(2)'
 * @return: * : [<= bufsize] The actual # of received payload bytes */
/* ssize_t recvmsg(fd_t sockfd, struct msghdrx32 *message, syscall_ulong_t msg_flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_recvmsg, __x86_asm32_int80_recvmsg)

/* Disallow further reception of data (causing `recv(2)' to return `0' as soon
 * as  all currently queued  data has been  read), and/or further transmission
 * of data (causing `send(2)' to throw an `E_NET_SHUTDOWN' exception)
 * @param: how: One of `SHUT_RD', `SHUT_WR' or `SHUT_RDWR'
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_SHUTDOWN_NOT_CONNECTED
 * @return: 0 : Success */
/* errno_t shutdown(fd_t sockfd, syscall_ulong_t how) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_shutdown, __x86_asm32_int80_shutdown)

/* fd_t userfaultfd(syscall_ulong_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_userfaultfd, __x86_asm32_int80_userfaultfd)

/* errno_t membarrier(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_membarrier, __x86_asm32_int80_membarrier)

/* errno_t mlock2(void const *addr, size_t length, syscall_ulong_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_mlock2, __x86_asm32_int80_mlock2)

/* errno_t copy_file_range(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_copy_file_range, __x86_asm32_int80_copy_file_range)

/* errno_t preadv2(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_preadv2, __x86_asm32_int80_preadv2)

/* errno_t pwritev2(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_pwritev2, __x86_asm32_int80_pwritev2)

/* errno_t pkey_mprotect(void *addr, size_t len, syscall_ulong_t prot, syscall_ulong_t pkey) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_pkey_mprotect, __x86_asm32_int80_pkey_mprotect)

/* syscall_slong_t pkey_alloc(syscall_ulong_t flags, syscall_ulong_t access_rights) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_pkey_alloc, __x86_asm32_int80_pkey_alloc)

/* errno_t pkey_free(syscall_ulong_t key) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_pkey_free, __x86_asm32_int80_pkey_free)

/* errno_t statx(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_statx, __x86_asm32_int80_statx)

/* >> arch_prctl(2)
 * Arch-dependent system process control interface. (But don't go and
 * think that the  normal `prctl(2)'  doesn't feature  arch-dependent
 * commands  -- honestly, this syscall shouldn't exist if you ask me,
 * but it does on linux, and so it must also on KOS...)
 * @param: command: One of `ARCH_*' (from <asm/prctl.h>)
 * @param: addr: Either a `syscall_ulong_t' or `syscall_ulong_t *', depending on `command'
 * @return: * :  Return value depends on `command' */
/* syscall_slong_t arch_prctl(unsigned int command, uint32_t *addr) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_arch_prctl, __x86_asm32_int80_arch_prctl)

/* errno_t io_pgetevents(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_io_pgetevents, __x86_asm32_int80_io_pgetevents)

/* errno_t rseq(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_rseq, __x86_asm32_int80_rseq)

/* errno_t semget(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_semget, __x86_asm32_int80_semget)

/* errno_t semctl(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_semctl, __x86_asm32_int80_semctl)

/* errno_t shmget(key_t key, size_t size, syscall_ulong_t shmflg) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_shmget, __x86_asm32_int80_shmget)

/* errno_t shmctl(syscall_ulong_t shmid, syscall_ulong_t cmd, struct shmid_ds *buf) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_shmctl, __x86_asm32_int80_shmctl)

/* errno_t shmat(syscall_ulong_t shmid, void const *shmaddr, syscall_ulong_t shmflg) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_shmat, __x86_asm32_int80_shmat)

/* errno_t shmdt(void const *shmaddr) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_shmdt, __x86_asm32_int80_shmdt)

/* errno_t msgget(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_msgget, __x86_asm32_int80_msgget)

/* errno_t msgsnd(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_msgsnd, __x86_asm32_int80_msgsnd)

/* errno_t msgrcv(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_msgrcv, __x86_asm32_int80_msgrcv)

/* errno_t msgctl(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_msgctl, __x86_asm32_int80_msgctl)

/* errno_t clock_gettime64(clockid_t clock_id, struct timespecx32_64 *tp) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_clock_gettime64, __x86_asm32_int80_clock_gettime64)

/* errno_t clock_settime64(clockid_t clock_id, struct timespecx32_64 const *tp) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_clock_settime64, __x86_asm32_int80_clock_settime64)

/* errno_t clock_adjtime64(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_clock_adjtime64, __x86_asm32_int80_clock_adjtime64)

/* errno_t clock_getres_time64(clockid_t clock_id, struct timespecx32_64 *res) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_clock_getres_time64, __x86_asm32_int80_clock_getres_time64)

/* errno_t clock_nanosleep_time64(clockid_t clock_id, syscall_ulong_t flags, struct timespecx32_64 const *requested_time, struct timespecx32_64 *remaining) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_clock_nanosleep_time64, __x86_asm32_int80_clock_nanosleep_time64)

/* errno_t timer_gettime64(timer_t timerid, struct itimerspecx32_64 *value) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_timer_gettime64, __x86_asm32_int80_timer_gettime64)

/* @param: flags: Set of `0 | TIMER_ABSTIME' */
/* errno_t timer_settime64(timer_t timerid, syscall_ulong_t flags, struct itimerspecx32_64 const *value, struct itimerspecx32_64 *ovalue) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_timer_settime64, __x86_asm32_int80_timer_settime64)

/* Return the next expiration time of UFD */
/* errno_t timerfd_gettime64(fd_t timerfd, struct itimerspecx32_64 *otmr) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_timerfd_gettime64, __x86_asm32_int80_timerfd_gettime64)

/* Set next expiration time of interval timer source `timerfd' to `utmr'.
 * If `flags'  has the  `TFD_TIMER_ABSTIME' flag  set the  timeout  value
 * is absolute. Optionally return the old expiration time in `otmr'
 * @param: flags: Set of `0 | TFD_TIMER_ABSTIME' */
/* errno_t timerfd_settime64(fd_t timerfd, syscall_ulong_t flags, struct itimerspecx32_64 const *utmr, struct itimerspecx32_64 *otmr) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_timerfd_settime64, __x86_asm32_int80_timerfd_settime64)

/* @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_CHANGE_BTIME | AT_DOSPATH' */
/* errno_t utimensat_time64(fd_t dirfd, char const *filename, struct timespecx32_64 const[2] times, atflag_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_utimensat_time64, __x86_asm32_int80_utimensat_time64)

/* ssize_t pselect6_time64(size_t nfds, struct __fd_set_struct *readfds, struct __fd_set_struct *writefds, struct __fd_set_struct *exceptfds, struct timespecx32_64 const *timeout, struct __sigset_with_sizex32 const *sigmask_sigset_with_size) */
.section .text.x86.asm32_syscall_sysenter.pselect6_time64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_pselect6_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x19d
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq 4(%ebp), %r9 /* ARG5 = 4(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_pselect6_time64)
	call   sys32_pselect6_time64
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_pselect6_time64)

/* ssize_t ppoll_time64(struct pollfd *fds, size_t nfds, struct timespecx32_64 const *timeout_ts, struct __sigset_struct const *sigmask, size_t sigsetsize) */
.section .text.x86.asm32_syscall_sysenter.ppoll_time64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_ppoll_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x19e
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_ppoll_time64)
	call   sys32_ppoll_time64
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_ppoll_time64)

/* errno_t io_pgetevents_time64(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_io_pgetevents_time64, __x86_asm32_int80_io_pgetevents_time64)

/* Same as `recvmsg(2)', but may be used to receive many
 * messages  (datagrams)  with  a  single  system  call.
 * @param: msg_flags: Set of `MSG_CMSG_CLOEXEC | MSG_CMSG_CLOFORK |
 *                            MSG_DONTWAIT | MSG_ERRQUEUE | MSG_OOB |
 *                            MSG_PEEK  |  MSG_TRUNC |  MSG_WAITALL |
 *                            MSG_WAITFORONE'
 * @throw: Error (s.a. `recvmsg(2)')
 * @return: * : The # of datagrams successfully received. */
/* ssize_t recvmmsg_time64(fd_t sockfd, struct mmsghdrx32 *vmessages, size_t vlen, syscall_ulong_t msg_flags, struct timespecx32_64 const *tmo) */
.section .text.x86.asm32_syscall_sysenter.recvmmsg_time64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_recvmmsg_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1a1
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_recvmmsg_time64)
	call   sys32_recvmmsg_time64
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_recvmmsg_time64)

/* errno_t mq_timedsend_time64(fd_t mqdes, char const *msg_ptr, size_t msg_len, uint32_t msg_prio, struct timespecx32_64 const *abs_timeout) */
.section .text.x86.asm32_syscall_sysenter.mq_timedsend_time64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mq_timedsend_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1a2
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_mq_timedsend_time64)
	call   sys32_mq_timedsend_time64
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_mq_timedsend_time64)

/* ssize_t mq_timedreceive_time64(fd_t mqdes, char *msg_ptr, size_t msg_len, uint32_t *pmsg_prio, struct timespecx32_64 const *abs_timeout) */
.section .text.x86.asm32_syscall_sysenter.mq_timedreceive_time64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mq_timedreceive_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1a3
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_mq_timedreceive_time64)
	call   sys32_mq_timedreceive_time64
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_mq_timedreceive_time64)

/* errno_t semtimedop_time64(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_semtimedop_time64, __x86_asm32_int80_semtimedop_time64)

/* syscall_slong_t rt_sigtimedwait_time64(struct __sigset_struct const *set, struct __siginfox32_struct *info, struct timespecx32_64 const *timeout, size_t sigsetsize) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_rt_sigtimedwait_time64, __x86_asm32_int80_rt_sigtimedwait_time64)

/* @param: futex_op: One of `FUTEX_*' from <linux/futex.h> */
/* syscall_slong_t futex_time64(uint32_t *uaddr, syscall_ulong_t futex_op, uint32_t val, struct timespecx32_64 const *timeout_or_val2, uint32_t *uaddr2, uint32_t val3) */
.section .text.x86.asm32_syscall_sysenter.futex_time64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_futex_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1a6
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq 4(%ebp), %r9 /* ARG5 = 4(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_futex_time64)
	call   sys32_futex_time64
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_futex_time64)

/* errno_t sched_rr_get_interval_time64(pid_t pid, struct timespecx32_64 *ts) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_sched_rr_get_interval_time64, __x86_asm32_int80_sched_rr_get_interval_time64)

/* Send a signal to the process of a given pidfd
 * @param: pidfd:  A `HANDLE_TYPE_PIDFD'-handle
 * @param: usigno: The signal that should be sent
 * @param: uinfo:  [0..1] Additional signal information
 * @param: flags:  Must always be `0' (for now)
 * @throw: E_PROCESS_EXITED:                                                                  [...]
 * @throw: E_INVALID_ARGUMENT_RESERVED_ARGUMENT:E_INVALID_ARGUMENT_CONTEXT_PIDFD_GETFD_FLAGS: [...]
 * @throw: E_INVALID_ARGUMENT_UNEXPECTED_COMMAND:E_INVALID_ARGUMENT_CONTEXT_SIGINFO_SIGNO:    [...]
 * @throw: E_INVALID_ARGUMENT_BAD_VALUE:E_INVALID_ARGUMENT_CONTEXT_BAD_SIGNO:                 [...]
 * @throw: E_INVALID_ARGUMENT_BAD_VALUE:E_INVALID_ARGUMENT_CONTEXT_RAISE_SIGINFO_BADCODE:     [...]
 * @throw: E_INVALID_HANDLE_FILE:                                                             [...]
 * @throw: E_ILLEGAL_OPERATION:                                                               [...] */
/* errno_t pidfd_send_signal(fd_t pidfd, signo_t usigno, struct __siginfox32_struct const *uinfo, syscall_ulong_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_pidfd_send_signal, __x86_asm32_int80_pidfd_send_signal)

/* errno_t io_uring_setup(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_io_uring_setup, __x86_asm32_int80_io_uring_setup)

/* errno_t io_uring_enter(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_io_uring_enter, __x86_asm32_int80_io_uring_enter)

/* errno_t io_uring_register(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_io_uring_register, __x86_asm32_int80_io_uring_register)

/* errno_t open_tree(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_open_tree, __x86_asm32_int80_open_tree)

/* errno_t move_mount(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_move_mount, __x86_asm32_int80_move_mount)

/* errno_t fsopen(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_fsopen, __x86_asm32_int80_fsopen)

/* errno_t fsconfig(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_fsconfig, __x86_asm32_int80_fsconfig)

/* errno_t fsmount(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_fsmount, __x86_asm32_int80_fsmount)

/* errno_t fspick(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_fspick, __x86_asm32_int80_fspick)

/* Return a `HANDLE_TYPE_PIDFD' handle for the given `pid'
 * This system call exists for compatibility with linux, which does not  allow
 * this call to succeed when `pid' isn't a process leader (i.e. main() thread)
 * @param: flags: Must always be `0' (for now)
 * @return: * :   A handle for the process `pid'
 * @throw: E_PROCESS_EXITED:                                                                 [...]
 * @throw: E_INVALID_ARGUMENT_RESERVED_ARGUMENT:E_INVALID_ARGUMENT_CONTEXT_PIDFD_OPEN_FLAGS: [...]
 * @throw: E_BADALLOC_INSUFFICIENT_HANDLE_NUMBERS:                                           [...] */
/* fd_t pidfd_open(pid_t pid, syscall_ulong_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_pidfd_open, __x86_asm32_int80_pidfd_open)

/* syscall_slong_t clone3(struct clone_args *cl_args, size_t size) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_clone3, __x86_asm32_int80_clone3)

/* @param: flags: Set of `CLOSE_RANGE_*' from <linux/close_range.h> */
/* errno_t close_range(unsigned int minfd, unsigned int maxfd, unsigned int flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_close_range, __x86_asm32_int80_close_range)

/* errno_t openat2(int TODO_PROTOTYPE) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_openat2, __x86_asm32_int80_openat2)

/* Duplicate the  handle  of  a  foreign  process into  a  handle  for  the  caller.
 * This system call duplicates the functionality of `open("/proc/[pid]/fd/[fdno]")',
 * which may also be used to duplicate file handles from another process.
 * @param: pidfd: A `HANDLE_TYPE_PIDFD'-handle
 * @param: fd:    The FD-number of the handle to clone
 * @param: flags: Must always be `0' (for now)
 * @return: * :   The duplicated handle number
 * @throw: E_PROCESS_EXITED:                                                                  [...]
 * @throw: E_INVALID_ARGUMENT_RESERVED_ARGUMENT:E_INVALID_ARGUMENT_CONTEXT_PIDFD_GETFD_FLAGS: [...]
 * @throw: E_BADALLOC_INSUFFICIENT_HANDLE_NUMBERS:                                            [...]
 * @throw: E_INVALID_HANDLE_FILE:                                                             [...]
 * @throw: E_ILLEGAL_OPERATION:                                                               [...] */
/* fd_t pidfd_getfd(fd_t pidfd, fd_t foreign_fd, syscall_ulong_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_pidfd_getfd, __x86_asm32_int80_pidfd_getfd)

/* @param: type: Set of `R_OK | W_OK | X_OK' or `F_OK'
 * @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_EACCESS | AT_DOSPATH' */
/* errno_t faccessat2(fd_t dirfd, char const *filename, syscall_ulong_t type, atflag_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_faccessat2, __x86_asm32_int80_faccessat2)

/* Same as  `writev(2)', but  write data  to a  file at  a
 * specific `offset', rather than the current R/W position
 * @return: <= SUM(iov[*].iov_len): The actual amount of written bytes */
/* ssize_t pwritevf(fd_t fd, struct iovecx32 const *iovec, size_t count, uint64_t offset, iomode_t mode) */
.section .text.x86.asm32_syscall_sysenter.pwritevf
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_pwritevf)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xfffffeb2
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %rax       /* %rax = REG3:0(%ebp) */
	movzlq %esi, %r8           /* ... */
	shlq   $(32), %rax            /* ... */
	orq    %r8, %rax           /* ... */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movq   %rax, %rcx /* ARG3 = %rax */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq 4(%ebp), %r8 /* ARG4 = 4(%ebp) */
	EXTERN(sys32_pwritevf)
	call   sys32_pwritevf
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_pwritevf)

/* Same as  `readv(2)', but  read data  from a  file at  a
 * specific `offset', rather than the current R/W position
 * @return: <= SUM(iov[*].iov_len): The actual amount of read bytes */
/* ssize_t preadvf(fd_t fd, struct iovecx32 const *iovec, size_t count, uint64_t offset, iomode_t mode) */
.section .text.x86.asm32_syscall_sysenter.preadvf
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_preadvf)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xfffffeb3
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %rax       /* %rax = REG3:0(%ebp) */
	movzlq %esi, %r8           /* ... */
	shlq   $(32), %rax            /* ... */
	orq    %r8, %rax           /* ... */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movq   %rax, %rcx /* ARG3 = %rax */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq 4(%ebp), %r8 /* ARG4 = 4(%ebp) */
	EXTERN(sys32_preadvf)
	call   sys32_preadvf
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_preadvf)

/* errno_t fallocate64(fd_t fd, syscall_ulong_t mode, uint64_t offset, uint64_t length) */
.section .text.x86.asm32_syscall_sysenter.fallocate64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fallocate64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xfffffebc
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq %esi, %rdx          /* ARG2 = REG2:REG3 */
	movzlq %edx, %rax          /* ... */
	shlq   $(32), %rdx            /* ... */
	orq    %rax, %rdx          /* ... */
	movzlq 4(%ebp), %rax       /* %rax = 0(%ebp):4(%ebp) */
	movzlq 0(%ebp), %r8        /* ... */
	shlq   $(32), %rax            /* ... */
	orq    %r8, %rax           /* ... */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movq   %rax, %rcx /* ARG3 = %rax */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_fallocate64)
	call   sys32_fallocate64
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_fallocate64)

/* @param: flags: Set of `0 | AT_READLINK_REQSIZE | AT_DOSPATH' */
/* ssize_t freadlinkat(fd_t dirfd, char const *path, char *buf, size_t buflen, atflag_t flags) */
.section .text.x86.asm32_syscall_sysenter.freadlinkat
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_freadlinkat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xfffffecf
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_freadlinkat)
	call   sys32_freadlinkat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_freadlinkat)

/* @param: flags: Set of `0 | AT_DOSPATH' */
/* errno_t fsymlinkat(char const *link_text, fd_t tofd, char const *target_path, atflag_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_fsymlinkat, __x86_asm32_int80_fsymlinkat)

/* @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_DOSPATH' */
/* errno_t kfstatat(fd_t dirfd, char const *filename, struct __kos_stat *statbuf, atflag_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_kfstatat, __x86_asm32_int80_kfstatat)

/* errno_t futimesat64(fd_t dirfd, char const *filename, struct timevalx32_64 const[2] times) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_futimesat64, __x86_asm32_int80_futimesat64)

/* @param: flags: Set of `0 | AT_DOSPATH' */
/* errno_t fmknodat(fd_t dirfd, char const *nodename, mode_t mode, dev_t dev, atflag_t flags) */
.section .text.x86.asm32_syscall_sysenter.fmknodat
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fmknodat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xfffffed7
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_fmknodat)
	call   sys32_fmknodat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_fmknodat)

/* @param: flags: Set of `0 | AT_DOSPATH' */
/* errno_t fmkdirat(fd_t dirfd, char const *pathname, mode_t mode, atflag_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_fmkdirat, __x86_asm32_int80_fmkdirat)

/* @param: atflags: Set of `AT_SYMLINK_NOFOLLOW | AT_DOSPATH'
 * @param: mask:    Set of `IN_ALL_EVENTS | ...' */
/* int inotify_add_watch_at(fd_t notify_fd, fd_t dirfd, char const *pathname, atflag_t atflags, uint32_t mask) */
.section .text.x86.asm32_syscall_sysenter.inotify_add_watch_at
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_inotify_add_watch_at)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xfffffedc
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movslq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_inotify_add_watch_at)
	call   sys32_inotify_add_watch_at
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_inotify_add_watch_at)

/* @param: idtype:  One of `P_ALL', `P_PID', `P_PGID'
 * @param: options: At least one of `WEXITED', `WSTOPPED', `WCONTINUED', optionally or'd with `WNOHANG | WNOWAIT' */
/* errno_t waitid64(syscall_ulong_t idtype, id_t id, struct __siginfox32_struct *infop, syscall_ulong_t options, struct rusagex32_64 *ru) */
.section .text.x86.asm32_syscall_sysenter.waitid64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_waitid64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xfffffee4
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_waitid64)
	call   sys32_waitid64
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_waitid64)

/* @param: times:    When NULL, set the current time
 * @param: times[0]: New access time
 * @param: times[1]: New last-modified time */
/* errno_t utimes64(char const *filename, struct timevalx32_64 const[2] times) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_utimes64, __x86_asm32_int80_utimes64)

/* >> set_userprocmask_address(2)
 * Register the address of  the calling thread's userprocmask  controller.
 * This also  initializes `*ctl->pm_sigmask'  and `ctl->pm_pending',  such
 * that `*ctl->pm_sigmask' is filled with the current kernel-level  signal
 * mask, as would be returned by `sigprocmask(2)', while `ctl->pm_pending'
 * is filled in with the equivalent of `sigpending(2)'
 * Additionally,  the address  of `&ctl->pm_mytid'  is stored  as an override
 * for `set_tid_address(2)', and the kernel may read from `*ctl->pm_sigmask',
 * and write to `ctl->pm_pending' (using  atomic-or for the later) from  this
 * point forth.
 * NOTE: Before calling this function, the caller must:
 *       >> bzero(ctl, sizeof(struct userprocmask));
 *       >> ctl->pm_sigsize = sizeof(sigset_t);
 *       >> ctl->pm_sigmask = &initial_sigmask;
 *       Where the initial bzero() is needed to initialize potential
 *       additional,   arch-specific   fields    to   all    zeroes.
 * NOTE: This system call will then initialize:
 *       >> ctl->pm_mytid = gettid();
 *       >> sigprocmask(0, NULL, ctl->pm_sigmask);
 *       >> sigpending(&ctl->pm_pending);
 * NOTE: Passing `NULL' for `ctl' disables userprocmask-mode, though
 *       before this is done, the kernel will copy the  `pm_sigmask'
 *       of the previously set  controller into its internal  signal
 *       mask. (i.e. the one used outside of userprocmask-mode)
 * Note though  that  `pm_sigmask'  is ignored  for  `SIGKILL'  and  `SIGSTOP'
 * Note also  that  this  function replaces  `set_tid_address(2)',  such  that
 * it negates a  prior call  to said  function, while  a future  call to  said
 * function will once again disable userprocmask, same as passing `NULL' would */
/* errno_t set_userprocmask_address(struct userprocmask *ctl) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_set_userprocmask_address, __x86_asm32_int80_set_userprocmask_address)

/* >> lfutexexpr(2)
 * The lfutexexpr(2) system call can be used to specify arbitrarily complex
 * expressions that must atomically (in relation to other futex operations)
 * hold true before the scheduler will suspend the calling thread.
 * @param: futexaddr: The futex on which to wait
 * @param: base:      Base pointer added to the `fe_offset' fields of given expressions
 * @param: expr:      Vector of expressions for which to check, terminated by `LFUTEX_EXPREND'
 * @param: timeout:   Timeout for wait operations (s.a. `LFUTEX_WAIT_FLAG_TIMEOUT_*')
 *                    When `LFUTEX_FDBIT'  is  set,  this argument  must  be  `NULL'.
 * @param: flags:     Set of `LFUTEX_WAIT_FLAG_TIMEOUT_*' or `LFUTEX_FDBIT'
 * @return: * : The first  non-zero  return value  from  executing  all of  the  given  `expr'
 *              in order (s.a. the documentations of the individual `LFUTEX_WAIT_*'  functions
 *              to see their  possible return  values, which are  always `0'  when they  would
 *              perform a wait  operation, and usually  `1' otherwise) or  `0' if the  calling
 *              thread had to perform a wait operation, at which point this function returning
 *              that value means that you've once again been re-awoken.
 *              When `LFUTEX_FDBIT' is set, the return value is an `fd_t' for a futex fd that
 *              can be used to poll for the specified `exprv'. Note that in this case `exprv'
 *              is limited to `LFUTEXFD_DEFAULT_MAXEXPR' (`/proc/kos/futexfd-maxexpr')
 * @return: -1:EFAULT:    A faulty pointer was given
 * @return: -1:EINVAL:    One of the given commands is invalid, or `expr[0].fe_condition == LFUTEX_EXPREND'
 * @return: -1:EINTR:     A blocking futex-wait operation was interrupted
 * @return: -1:ETIMEDOUT: A blocking futex-wait operation has timed out */
/* errno_t lfutexexpr(uint32_t *futexaddr, void *base, struct lfutexexprx32 const *expr, struct timespecx32_64 const *timeout, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.lfutexexpr
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_lfutexexpr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xffffff0f
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_lfutexexpr)
	call   sys32_lfutexexpr
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_lfutexexpr)

/* >> lfutex(2)
 * Provide the bottom-most API for implementing user-space synchronization on KOS
 * @param: futex_op: One of:
 *    - LFUTEX_WAKE:                (lfutex_t *uaddr, LFUTEX_WAKE, size_t count)
 *    - LFUTEX_WAKEMASK:            (lfutex_t *uaddr, LFUTEX_WAKEMASK, size_t count, lfutex_t mask_and, lfutex_t mask_or)
 *    - LFUTEX_WAIT_WHILE:          (lfutex_t *uaddr, LFUTEX_WAIT_WHILE, lfutex_t value, struct timespec const *timeout)
 *    - LFUTEX_WAIT_UNTIL:          (lfutex_t *uaddr, LFUTEX_WAIT_UNTIL, lfutex_t value, struct timespec const *timeout)
 *    - LFUTEX_WAIT_WHILE_ABOVE:    (lfutex_t *uaddr, LFUTEX_WAIT_WHILE_ABOVE, lfutex_t value, struct timespec const *timeout)
 *    - LFUTEX_WAIT_WHILE_BELOW:    (lfutex_t *uaddr, LFUTEX_WAIT_WHILE_BELOW, lfutex_t value, struct timespec const *timeout)
 *    - LFUTEX_WAIT_WHILE_BITMASK:  (lfutex_t *uaddr, LFUTEX_WAIT_WHILE_BITMASK, lfutex_t bitmask, struct timespec const *timeout, lfutex_t setmask)
 *    - LFUTEX_WAIT_UNTIL_BITMASK:  (lfutex_t *uaddr, LFUTEX_WAIT_UNTIL_BITMASK, lfutex_t bitmask, struct timespec const *timeout, lfutex_t setmask)
 *    - LFUTEX_WAIT_WHILE_EX:       (lfutex_t *uaddr, LFUTEX_WAIT_WHILE_EX, void const *rhs, struct timespec const *timeout, size_t num_bytes)
 *    - LFUTEX_WAIT_UNTIL_EX:       (lfutex_t *uaddr, LFUTEX_WAIT_UNTIL_EX, void const *rhs, struct timespec const *timeout, size_t num_bytes)
 *    - LFUTEX_WAIT_WHILE_ABOVE_EX: (lfutex_t *uaddr, LFUTEX_WAIT_WHILE_ABOVE_EX, void const *rhs, struct timespec const *timeout, size_t num_bytes)
 *    - LFUTEX_WAIT_WHILE_BELOW_EX: (lfutex_t *uaddr, LFUTEX_WAIT_WHILE_BELOW_EX, void const *rhs, struct timespec const *timeout, size_t num_bytes)
 * @param: timeout: Timeout for wait operations (s.a. `LFUTEX_WAIT_FLAG_TIMEOUT_*')
 * @return: * : Depending on `futex_op'
 * @return: -1:EFAULT:    A faulty pointer was given
 * @throw:  E_INVALID_ARGUMENT: The given `futex_op' is invalid
 * @throw:  E_INTERRUPT:        A blocking futex-wait operation was interrupted
 * @return: -ETIMEDOUT:         A blocking futex-wait operation has timed out */
/* syscall_slong_t lfutex(uint32_t *uaddr, syscall_ulong_t futex_op, uint32_t val, struct timespecx32_64 const *timeout, uint32_t val2) */
.section .text.x86.asm32_syscall_sysenter.lfutex
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_lfutex)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xffffff10
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_lfutex)
	call   sys32_lfutex
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_lfutex)

/* @param: mode: One of `READDIR_DEFAULT', `READDIR_CONTINUE', `READDIR_PEEK' or `READDIR_MULTIPLE',
 *               optionally     or'd     with     any     of     `READDIR_SKIPREL | READDIR_WANTEOF' */
/* ssize_t kreaddirf(fd_t fd, struct dirent *buf, size_t bufsize, syscall_ulong_t mode, iomode_t iomode) */
.section .text.x86.asm32_syscall_sysenter.kreaddirf
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_kreaddirf)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xffffff23
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_kreaddirf)
	call   sys32_kreaddirf
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_kreaddirf)

/* @param: mode: One of `READDIR_DEFAULT', `READDIR_CONTINUE', `READDIR_PEEK' or `READDIR_MULTIPLE',
 *               optionally     or'd     with     any     of     `READDIR_SKIPREL | READDIR_WANTEOF' */
/* ssize_t kreaddir(fd_t fd, struct dirent *buf, size_t bufsize, syscall_ulong_t mode) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_kreaddir, __x86_asm32_int80_kreaddir)

/* errno_t kfstat(fd_t fd, struct __kos_stat *statbuf) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_kfstat, __x86_asm32_int80_kfstat)

/* errno_t klstat(char const *filename, struct __kos_stat *statbuf) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_klstat, __x86_asm32_int80_klstat)

/* errno_t kstat(char const *filename, struct __kos_stat *statbuf) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_kstat, __x86_asm32_int80_kstat)

/* ssize_t pwrite64f(fd_t fd, void const *buf, size_t bufsize, uint64_t offset, iomode_t mode) */
.section .text.x86.asm32_syscall_sysenter.pwrite64f
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_pwrite64f)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xffffff4b
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %rax       /* %rax = REG3:0(%ebp) */
	movzlq %esi, %r8           /* ... */
	shlq   $(32), %rax            /* ... */
	orq    %r8, %rax           /* ... */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movq   %rax, %rcx /* ARG3 = %rax */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq 4(%ebp), %r8 /* ARG4 = 4(%ebp) */
	EXTERN(sys32_pwrite64f)
	call   sys32_pwrite64f
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_pwrite64f)

/* ssize_t pread64f(fd_t fd, void *buf, size_t bufsize, uint64_t offset, iomode_t mode) */
.section .text.x86.asm32_syscall_sysenter.pread64f
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_pread64f)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xffffff4c
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %rax       /* %rax = REG3:0(%ebp) */
	movzlq %esi, %r8           /* ... */
	shlq   $(32), %rax            /* ... */
	orq    %r8, %rax           /* ... */
	movzlq %ecx, %rsi /* ARG1 = REG1 */
	movq   %rax, %rcx /* ARG3 = %rax */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	movzlq 4(%ebp), %r8 /* ARG4 = 4(%ebp) */
	EXTERN(sys32_pread64f)
	call   sys32_pread64f
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_pread64f)

/* Restore the specified register state when returning from a signal handler
 * Note that the order and locations of arguments taken by this system  call
 * are of great importance, as they must match what is encoded by the kernel
 * within `userexcept_callsignal()'
 * The order chosen is also important, as it is selected such that arguments
 * are only passed through registers  that are natively preserved by  signal
 * handler functions. */
/* void ksigreturn(struct fpustate32 const *restore_fpu, syscall_ulong_t unused1, syscall_ulong_t unused2, struct __sigset_with_sizex32 const *restore_sigmask, struct rpc_syscall_info32 const *sc_info, struct ucpustate32 const *restore_cpu) */
.section .text.x86.asm32_syscall_sysenter.ksigreturn
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_ksigreturn)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xffffff53
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq 4(%ebp), %r9 /* ARG5 = 4(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_ksigreturn)
	call   sys32_ksigreturn
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_ksigreturn)

/* errno_t nanosleep64(struct timespecx32_64 const *req, struct timespecx32_64 *rem) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_nanosleep64, __x86_asm32_int80_nanosleep64)

/* >> rpc_serve_sysret(2)
 * Very similar to `rpc_serve(2)', but with the addition that this one
 * will only serve RPCs that can be handled in `RPC_REASONCTX_SYSRET',
 * aka. `RPC_REASONCTX_ASYNC' contexts. Additionally, this system call
 * ignores the state of the  internal `TASK_FRPC' flag, and should  be
 * invoked  when  the calling  thread  makes use  of  the userprocmask
 * mechanism, and the  signal mask became  less restrictive while  the
 * `USERPROCMASK_FLAG_HASPENDING' flag was set.
 * 
 * When userprocmask is disabled, this system call is pretty much just
 * a no-op (semnatically speaking, it does nothing). But when enabled,
 * it is really only usable  in conjuction with the userprocmask.  The
 * exact usage can be seen in `chkuserprocmask(3)'.
 * 
 * @return: 0 : Always, unconditionally returned. */
/* errno_t rpc_serve_sysret(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_rpc_serve_sysret, __x86_asm32_int80_rpc_serve_sysret)

/* >> rpc_serve(2)
 * Check for pending signals and RPCs. This is a wrapper around the
 * kernel `task_serve()' function, which is always invoked before a
 * thread begins waiting for a blocking operation. All system calls
 * marked as cancellation  points probably  call `task_serve()'  at
 * some point.
 * Note that unlike (say) `pause(2)', this function doesn't  block,
 * and may be used to implement `pthread_testcancel(3)' (should KOS
 * RPCs be used to facility pthread cancellation points, as done by
 * KOS's builtin libc)
 * @return: 0:      Nothing was handled.
 * @return: -EINTR: RPCs (or posix signals) were handled. */
/* errno_t rpc_serve(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_rpc_serve, __x86_asm32_int80_rpc_serve)

/* syscall_slong_t ksysctl(ioctl_t command, void *arg) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_ksysctl, __x86_asm32_int80_ksysctl)

/* Same as `write(2)', but rather than specifying a single, continuous buffer,
 * write  data from `count'  separate buffers, though  still return the actual
 * number of written bytes.
 * When  `fd' has the  `O_NONBLOCK' flag set, only  write as much data
 * as possible at the time the call was made, and throw `E_WOULDBLOCK'
 * if no data could be written at the time.
 * @return: <= SUM(iov[*].iov_len): The actual amount of written bytes
 * @return: 0                     : No more data can be written */
/* ssize_t writevf(fd_t fd, struct iovecx32 const *iovec, size_t count, iomode_t mode) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_writevf, __x86_asm32_int80_writevf)

/* Same as `read(2)', but rather than specifying a single, continuous buffer,
 * read  data into `count'  separate buffers, though  still return the actual
 * number of read bytes.
 * When `fd' has the `O_NONBLOCK' flag set, only read as much data as was
 * available at  the time  the call  was made,  and throw  `E_WOULDBLOCK'
 * no data was available at the time.
 * @return: <= SUM(iov[*].iov_len): The actual amount of read bytes
 * @return: 0                     : EOF */
/* ssize_t readvf(fd_t fd, struct iovecx32 const *iovec, size_t count, iomode_t mode) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_readvf, __x86_asm32_int80_readvf)

/* ssize_t select64(size_t nfds, struct __fd_set_struct *readfds, struct __fd_set_struct *writefds, struct __fd_set_struct *exceptfds, struct timevalx32_64 *timeout) */
.section .text.x86.asm32_syscall_sysenter.select64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_select64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xffffff72
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_select64)
	call   sys32_select64
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_select64)

/* Same as `waitpid(pid, STAT_LOC, OPTIONS)', though also fills in `USAGE' when non-NULL
 * @param: options: Set of `WNOHANG | WUNTRACED | WCONTINUED' (as a KOS extension, `WNOWAIT' is also accepted) */
/* pid_t wait4_64(pid_t pid, int32_t *stat_loc, syscall_ulong_t options, struct rusagex32_64 *usage) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_wait4_64, __x86_asm32_int80_wait4_64)

/* @param: which: One of `ITIMER_REAL', `ITIMER_VIRTUAL' or `ITIMER_PROF' */
/* errno_t getitimer64(syscall_ulong_t which, struct __itimervalx32_64 *curr_value) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getitimer64, __x86_asm32_int80_getitimer64)

/* @param: which: One of `ITIMER_REAL', `ITIMER_VIRTUAL' or `ITIMER_PROF' */
/* errno_t setitimer64(syscall_ulong_t which, struct __itimervalx32_64 const *newval, struct __itimervalx32_64 *oldval) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_setitimer64, __x86_asm32_int80_setitimer64)

/* Map the segments of a given library into memory
 * @param: addr:  Hint address (ignored unless `MAP_FIXED' is passed)
 * @param: flags: Set of `MAP_FIXED | MAP_32BIT | MAP_GROWSDOWN |
 *                MAP_GROWSUP  |  MAP_LOCKED  |  MAP_NORESERVE  |
 *                MAP_POPULATE  |  MAP_NONBLOCK   |  MAP_SYNC   |
 *                MAP_FIXED_NOREPLACE | MAP_NOASLR'
 * @param: fd:    A handle for the library file being mapped (must be mmap(2)-able)
 * @param: hdrv:  Pointer  to  a vector  of `Elf32_Phdr'  or `Elf64_Phdr'
 *                (depending on the caller running in 32- or 64-bit mode)
 * @param: hdrc:  The number of program headers */
/* void *maplibrary(void *addr, syscall_ulong_t flags, fd_t fd, struct elf32_phdr const *hdrv, size_t hdrc) */
.section .text.x86.asm32_syscall_sysenter.maplibrary
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_maplibrary)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xffffffaa
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movslq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_maplibrary)
	call   sys32_maplibrary
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_maplibrary)

/* errno_t settimeofday64(struct timevalx32_64 const *tv, struct timezone const *tz) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_settimeofday64, __x86_asm32_int80_settimeofday64)

/* errno_t gettimeofday64(struct timevalx32_64 *tv, struct timezone *tz) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_gettimeofday64, __x86_asm32_int80_gettimeofday64)

/* @param: who: One of `RUSAGE_SELF', `RUSAGE_CHILDREN' or `RUSAGE_THREAD' */
/* errno_t getrusage64(syscall_slong_t who, struct rusagex32_64 *tv) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getrusage64, __x86_asm32_int80_getrusage64)

/* uint64_t fsmode(uint64_t mode) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_fsmode, __x86_asm32_int80_fsmode)

/* syscall_slong_t ioctlf(fd_t fd, ioctl_t command, iomode_t mode, void *arg) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_ioctlf, __x86_asm32_int80_ioctlf)

/* Check if a transaction is currently in progress
 * @return: 0 : No RTM operation in progress
 * @return: 1 : An RTM operation is currently in progress */
/* syscall_ulong_t rtm_test(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_rtm_test, __x86_asm32_int80_rtm_test)

/* Abort the current transaction  by having `sys_rtm_begin()' return  with
 * `RTM_ABORT_EXPLICIT | ((code << RTM_ABORT_CODE_S) & RTM_ABORT_CODE_M)'
 * If no transaction was in progress, behave as a no-op and return `-EOK'.
 * Otherwise,  this system call does not return normally, but returns from
 * the original `sys_rtm_begin()' */
/* errno_t rtm_abort(syscall_ulong_t code) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_rtm_abort, __x86_asm32_int80_rtm_abort)

/* End a transaction
 * If  the  transaction was  successful,  return normally  (by  returning `-EOK').
 * If    the   transaction   failed,   `sys_rtm_begin()'   returns   `RTM_ABORT_*'
 * If no transaction was in progress, an `E_ILLEGAL_OPERATION' exception is thrown */
/* errno_t rtm_end(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_rtm_end, __x86_asm32_int80_rtm_end)

/* Begin  an  RTM operation.  Note that  if  the arch-specific  RTM driver
 * wasn't already loaded into the kernel, it will be loaded automatically,
 * though any error that may happen during this will result in `RTM_NOSYS'
 * begin returned.
 * Note that while an RTM  operation is in progress,  only a very small  hand
 * full  of system calls are allowed to  be used. Attempting to use arbitrary
 * system calls will most likely  result in an `RTM_ABORT_FAILED' error,  and
 * attempting to access too much system memory in general will result in this
 * function returning  with  `RTM_ABORT_CAPACITY',  rather  than  succeeding.
 * The following is  a list  of system calls  which are  whitelisted for  use
 * during a transaction:
 *   - sys_rtm_begin:  Nested RTM operation
 *   - sys_rtm_end:    End an RTM operation
 *   - sys_rtm_abort:  Abort an RTM operation
 *   - sys_rtm_test:   Check if an RTM operation is in progress (always returns `1')
 * Anything else will most likely result in this system call returning `RTM_ABORT_FAILED'
 * @return: RTM_STARTED : RTM operation was started.
 * @return: RTM_NOSYS   : RTM isn't supposed because the RTM driver is missing, or cannot be loaded.
 * @return: RTM_ABORT_* : RTM operation failed (s.a. code from `<kos/rtm.h>') */
/* rtm_status_t rtm_begin(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_rtm_begin, __x86_asm32_int80_rtm_begin)

/* errno_t ftime64(struct timebx32_64 *tp) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_ftime64, __x86_asm32_int80_ftime64)

/* @param: times: When NULL, set the current time */
/* errno_t utime64(char const *filename, struct utimbufx32_64 const *times) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_utime64, __x86_asm32_int80_utime64)

/* errno_t stime64(time64_t const *t) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_stime64, __x86_asm32_int80_stime64)

/* Construct   a   user-vio-fd  object   supporting  mmap(2),   with  actual
 * memory  accesses  being dispatched  by  adding them  as  pending requests
 * to an internal  queue that  should be read(2)  from by  a worker  thread,
 * which should then service those requests before responding by write(2)ing
 * the results of the operation back to the same fd.
 * HINT: The format of the structures that are read(2) and
 *       write(2)en can be found in `<libvio/userviofd.h>'
 * NOTE: Don't use this system call directly. Use `vio_create(3)'
 *       from `<libvio/vio.h>' instead.
 * @param: initial_size: The initial mmap(2)able size of the returned handle.
 *                       This  size may be  altered at a  later point in time
 *                       through use of `ftruncate(return)'
 * @param: flags:        Set of `0 | O_CLOEXEC | O_CLOFORK | O_NONBLOCK' */
/* fd_t userviofd(size_t initial_size, syscall_ulong_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_userviofd, __x86_asm32_int80_userviofd)

/* int64_t lseek64(fd_t fd, int64_t offset, syscall_ulong_t whence) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_lseek64, __x86_asm32_int80_lseek64)

/* Trigger a coredump of the calling process.
 * @param: curr_state:       The  state as is still valid after any possible unwinding has already been done
 *                           Note that this state does not necessarily point to the location that originally
 *                           caused the problem that escalated into a coredump, but is the last valid stack-
 *                           unwind location at which unwinding could no longer continue.
 *                           When `NULL', `orig_state' is used instead, and `traceback_vector' and `traceback_length' are ignored.
 * @param: orig_state:       The original CPU state at where the associated `reason' got triggered
 *                           When `NULL', `curr_state' is used instead, and `traceback_vector' and `traceback_length' are ignored.
 *                           When   `curr_state'   is   also   `NULL',   then   the   current   CPU   state   is   used   instead.
 * @param: traceback_vector: (potentially  incomplete)   vector  of   additional  program   pointers  that   were
 *                           traversed   when   the  stack   was   walked  from   `orig_state'   to  `curr_state'
 *                           Note that earlier  entries within this  vector are further  up the call-stack,  with
 *                           traceback_vector[0] being meant to be the call-site of the function of `orig_state'.
 *                           Note that when `traceback_length != 0 && traceback_vector[traceback_length-1] == ucpustate_getpc(curr_state)',
 *                           it  can  be  assumed  that  the  traceback is  complete  and  contains  all  traversed  instruction locations.
 *                           In   this   case,  a   traceback  displayed   to   a  human   should  not   include   the  text   location  at
 *                           `traceback_vector[traceback_length-1]',    since    that    location    would    also    be    printed    when
 *                           unwinding is completed for the purposes of displaying a traceback.
 * @param: traceback_length: The number of program counters stored within `traceback_vector'
 * @param: reason:           The reason that resulted in the coredump (or `NULL' to get the same behavior as `E_OK')
 *                           For certain `unwind_error' values, this can also  point to other things, but is  always
 *                           allowed to be `NULL' to indicate default/stub values.
 * @param: unwind_error:     The  unwind  error that  caused the  coredump,  or `UNWIND_SUCCESS'  if unwinding
 *                           was  never  actually  performed,  and   `reason'  is  actually  a   `siginfo_t *'
 *                           Ignored when `reason == NULL', in which case `UNWIND_SUCCESS' is assumed instead. */
/* errno_t coredump(struct ucpustate32 const *curr_state, struct ucpustate32 const *orig_state, __HYBRID_PTR32(void const) const *traceback_vector, size_t traceback_length, union coredump_info32 const *reason, unwind_errno_t unwind_error) */
.section .text.x86.asm32_syscall_sysenter.coredump
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_coredump)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xffffffee
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq 4(%ebp), %r9 /* ARG5 = 4(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_coredump)
	call   sys32_coredump
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_coredump)

/* Trigger a debugger trap `trapno', optionally extended with  `regs'
 * at either the system call return location, or at the given `state'
 * In the later case, this system call will by default return to  the
 * given  `state', though given the purpose of this system call being
 * to inform a connected debugger  of some breakable event,  allowing
 * it to do whatever it wishes before execution is resumed.
 * @param: reason:   When non-NULL, the reason for the debug trap (else: use `SIGTRAP:DEBUGTRAP_REASON_NONE')
 * @param: state:    When non-NULL, the CPU state where the trap should return to by default
 * @return: -EOK:    `state' was NULL and the trap returned successfully
 * @return: -ENOENT: No debugger is connected to the calling process/process-group/system */
/* errno_t debugtrap(struct ucpustate32 const *state, struct debugtrap_reason32 const *reason) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_debugtrap, __x86_asm32_int80_debugtrap)

/* Get the current exception handler mode for the calling thread.
 * @param: pmode:       When non-`NULL', store the current mode, which is encoded as:
 *                       - One of `EXCEPT_HANDLER_MODE_(DISABLED|ENABLED|SIGHAND)'
 *                       - Or'd with a set of `EXCEPT_HANDLER_FLAG_(ONESHOT|SETHANDLER|SETSTACK)'
 * @param: phandler:    When   non-`NULL',   store  the   address   of  the   user-space   exception  handler.
 *                      Note that when no handler has been set (`!(*pmode & EXCEPT_HANDLER_FLAG_SETHANDLER)'),
 *                      then this pointer is set to `NULL'.
 * @param: phandler_sp: When non-`NULL', store the starting address of the user-space exception handler stack.
 *                      Note that  when no  stack has  been set  (`!(*pmode & EXCEPT_HANDLER_FLAG_SETSTACK)'),
 *                      or when the stack was defined to re-use the previous stack,
 *                      then this pointer is set to `EXCEPT_HANDLER_SP_CURRENT'.
 * @return: 0 :         Success.
 * @return: -1:EFAULT:  One of the given pointers is non-`NULL' and faulty */
/* errno_t get_exception_handler(__ULONG32_TYPE__ *pmode, __except_handler32_t *phandler, __HYBRID_PTR32(void) *phandler_sp) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_get_exception_handler, __x86_asm32_int80_get_exception_handler)

/* Set the exception handler mode for the calling thread.
 * Examples:
 *   - Set mode #3 from you `main()': `set_exception_handler(EXCEPT_HANDLER_MODE_SIGHAND, NULL, NULL)'
 *   - Set mode #4 (as done by libc): `set_exception_handler(EXCEPT_HANDLER_MODE_SIGHAND |
 *                                                           EXCEPT_HANDLER_FLAG_SETHANDLER,
 *                                                           &except_handler4, NULL)'
 * @param: mode:       One of `EXCEPT_HANDLER_MODE_*', optionally or'd with `EXCEPT_HANDLER_FLAG_*'
 * @param: handler:    When `EXCEPT_HANDLER_FLAG_SETHANDLER' is set, the address of the exception handler to use
 * @param: handler_sp: When `EXCEPT_HANDLER_FLAG_SETSTACK' is set, the address of the exception handler stack
 * @return: 0 :        Success.
 * @return: -1:EINVAL: The given `mode' is invalid */
/* errno_t set_exception_handler(syscall_ulong_t mode, except_handler_t handler, void *handler_sp) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_set_exception_handler, __x86_asm32_int80_set_exception_handler)

/* Create and return a new tty terminal controller connected to the given keyboard and display
 * The  newly created  device automatically gets  assigned an arbitrary  device number, before
 * being made available under a file `/dev/${name}'  (or rather: as ${name} within the  devfs)
 * @param: reserved: Reserved set of flags (Must pass `0'; for future expansion) */
/* fd_t mktty(char const *name, fd_t keyboard, fd_t display, syscall_ulong_t rsvd) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_mktty, __x86_asm32_int80_mktty)

/* int64_t time64(int64_t *timer) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_time64, __x86_asm32_int80_time64)

/* @param: flags: Set of `0 | AT_DOSPATH' */
/* errno_t fchdirat(fd_t dirfd, char const *path, atflag_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_fchdirat, __x86_asm32_int80_fchdirat)

/* Create a new pseudo-terminal driver and store handles to both the
 * master  and slave ends  of the connection  in the given pointers. */
/* errno_t openpty(fd_t *amaster, fd_t *aslave, char *name, struct termios const *termp, struct winsize const *winp) */
.section .text.x86.asm32_syscall_sysenter.openpty
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_openpty)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xfffffff5
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_openpty)
	call   sys32_openpty
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_openpty)

/* >> rpc_schedule(2)
 * Schedule an RPC program to-be executed by some other thread. This  function
 * cannot guaranty that  the RPC  program is  always executed,  as the  target
 * thread terminate before the  conditions for the RPC  to be served are  ever
 * met. Note that these  conditions depend on the  given `mode'. Note that  on
 * multi-arch  platforms (such as  x86), the register numbers,  as well as the
 * address size used by `program' depend on the execution mode of `target_tid'
 * 
 * NOTE: Only a cancellation point when `RPC_JOIN_WAITFOR' is used!
 * 
 * @param: target_tid:      The TID of the targeted thread
 * @param: mode:            One of `RPC_SYNCMODE_*',  optionally or'd  with
 *                          one of `RPC_SYSRESTART_*', optionally or'd with
 *                          one of `RPC_PRIORITY_*',  optionally or'd  with
 *                          one of  `RPC_DOMAIN_*',  optionally  or'd  with
 *                          one of `RPC_JOIN_*'
 * @param: program:         The RPC program to execute (sequences of `RPC_OP_*')
 * @param: params:          RPC program parameters (for `RPC_OP_push_param')
 * @param: max_param_count: The max # of `params' used by `program'
 * 
 * @return: 0 :                Success
 * @throws: E_SEGFAULT:        Faulty pointers were given
 * @throws: E_INVALID_ARGUMENT:E_INVALID_ARGUMENT_CONTEXT_RPC_SCHEDULE_MODE:
 *                             The given `mode' is invalid.
 * @throws: E_INVALID_ARGUMENT:E_INVALID_ARGUMENT_CONTEXT_RPC_PROGRAM_INSTRUCTION:
 *                             The RPC program  contains illegal  instructions.
 *                             In this case, modifications made by instructions
 *                             encountered before the illegal one(s) will still
 *                             have  happened, meaning that the target thread's
 *                             state may have become inconsistent.
 * @throws: E_PROCESS_EXITED:  The target thread has already terminated, or
 *                             doesn't exist. Note  though that unless  the
 *                             thread  is  part  of your  own  process, are
 *                             still many reasons  outside of your  control
 *                             for why it  may terminate immediately  after
 *                             the RPC program finished. */
/* errno_t rpc_schedule(pid_t target_tid, syscall_ulong_t mode, void const *program, __HYBRID_PTR32(void const) const *params, size_t max_param_count) */
.section .text.x86.asm32_syscall_sysenter.rpc_schedule
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_rpc_schedule)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xfffffff7
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movzlq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_rpc_schedule)
	call   sys32_rpc_schedule
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_rpc_schedule)

/* Returns  the  absolute   filesystem  path  for   the  specified   file
 * When `AT_SYMLINK_NOFOLLOW' is given, a final symlink is  dereferenced,
 * causing the pointed-to file location to be retrieved. - Otherwise, the
 * location of the link is printed instead.
 * You may pass `AT_READLINK_REQSIZE' to always have the function return
 * the   required   buffer   size,   rather   than   the   used    size.
 * @param: flags: Set of `0 | AT_ALTPATH | AT_SYMLINK_NOFOLLOW | AT_READLINK_REQSIZE | AT_DOSPATH' */
/* ssize_t frealpathat(fd_t dirfd, char const *filename, char *buf, size_t buflen, atflag_t flags) */
.section .text.x86.asm32_syscall_sysenter.frealpathat
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_frealpathat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xfffffff8
	.cfi_iret_signal_frame
	.cfi_def_cfa %rsp, 0
	pushq_cfi_r %rcx
	pushq_cfi_r %rdx
	pushq_cfi_r %rsi
	pushq_cfi_r %rdi
	pushq_cfi_r %r8
	pushq_cfi_r %r9
	pushq_cfi_r %r10
	pushq_cfi_r %r11
	movzlq 0(%ebp), %r8 /* ARG4 = 0(%ebp) */
	movzlq %edx, %rdx /* ARG2 = REG2 */
	movzlq %esi, %rsi /* ARG1 = REG3 */
	movzlq %ecx, %rcx /* ARG3 = REG1 */
	xchgq  %rcx, %rsi /* ARG1 = ARG3, ARG3 = ARG1 */
	movslq %ebx, %rdi /* ARG0 = REG0 */
	EXTERN(sys32_frealpathat)
	call   sys32_frealpathat
	popq_cfi_r %r11
	popq_cfi_r %r10
	popq_cfi_r %r9
	popq_cfi_r %r8
	popq_cfi_r %rdi
	popq_cfi_r %rsi
	popq_cfi_r %rdx
	popq_cfi_r %rcx
	X86_IRET_BUT_PREFER_SYSRET32
	.cfi_endproc
END(__x86_asm32_sysenter_frealpathat)

/* >> detach(2)
 * Detach the descriptor of `PID' from the thread that
 * would have received a signal when it changes state,
 * as well as prevent the  thread from turning into  a
 * zombie once it dies.
 * For simplicity, think of it like this:
 *   - pthread_create()  -->  clone()
 *   - pthread_join()    -->  wait()
 *   - pthread_detach()  -->  detach()  // Linux's missing link, now implemented
 * A total of 4 special cases exists to alter the behavior of this function:
 *   - PID == 0 || PID == gettid():
 *     Detach the calling  thread from  the set of  running children  within
 *     its own process.  Note however  that when this  is done  by the  main
 *     thread of the process, gettid() will equal getpid(), and the behavior
 *     will be different.
 *   - PID == getpid():
 *     Detach the calling process from its parent, essentially daemonizing
 *     the  calling   process   the   same  way   a   double-fork   would:
 *     >> if (fork() == 0) {
 *     >> 	if (fork() == 0) {
 *     >> 		// This is a daemonized process
 *     >> 		// aka. the parent process no longer knows
 *     >> 		// about us, and also can't wait(2) on us.
 *     >> 		...
 *     >> 	}
 *     >> 	exit(0);
 *     >> }
 *     Same as:
 *     >> if (fork() == 0) {
 *     >> 	detach(0); // or `detach(getpid())', since 0 --> gettid() and gettid() == getpid()
 *     >> 	// This is a daemonized process
 *     >> 	// aka. the parent process no longer knows
 *     >> 	// about us, and also can't wait(2) on us.
 *     >> 	...
 *     >> }
 *   - PID == -1:
 *     Detach all child processes/threads  of the calling process,  essentially
 *     turning its chain of children into a clean slate that no longer contains
 *     any wait(2)able child threads or processes.
 *     If no waitable children existed, `ECHILD' is set; else `0' is returned.
 * The given `pid' must be:
 *   - A thread without the caller's process
 *   - A child process of the caller's process
 * NOTE: If a thread is created using clone() with `CLONE_DETACHED' set,
 *       it will behave effectively as though this function had  already
 *       be called.
 * @return: -ECHILD:         `PID' was equal to `-1', but no waitable children existed
 * @throw: E_PROCESS_EXITED: No such  thread/process exists,  or  the thread  isn't  isn't
 *                           a thread in your process, or a child process of your process. */
/* errno_t detach(pid_t pid) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_detach, __x86_asm32_int80_detach)

/* You may pass `AT_READLINK_REQSIZE' to always have the function return
 * the   required   buffer   size,   rather   than   the   used    size.
 * @param: flags: Set of `0 | AT_ALTPATH | AT_READLINK_REQSIZE | AT_DOSPATH' */
/* ssize_t frealpath4(fd_t fd, char *resolved, size_t buflen, atflag_t flags) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_frealpath4, __x86_asm32_int80_frealpath4)

/* Returns a bitset of all of the currently mounted dos-drives */
/* syscall_slong_t getdrives(void) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_getdrives, __x86_asm32_int80_getdrives)

/* Write up to `bufsize' bytes from `buf' into `fd'
 * When `fd' has the `O_NONBLOCK' flag set, only write as much data as
 * possible at the time the call was made, and throw `E_WOULDBLOCK' if
 * no data could be written at the time.
 * @return: <= bufsize: The actual amount of written bytes
 * @return: 0         : No more data can be written */
/* ssize_t writef(fd_t fd, void const *buf, size_t bufsize, iomode_t mode) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_writef, __x86_asm32_int80_writef)

/* Read up to `bufsize' bytes from `fd' into `buf'
 * When  `fd' has the `O_NONBLOCK' flag set, only read as much data as was
 * available at the time the call was made, and throw `E_WOULDBLOCK' if no
 * data was available at the time.
 * @return: <= bufsize: The actual amount of read bytes
 * @return: 0         : EOF */
/* ssize_t readf(fd_t fd, void *buf, size_t bufsize, iomode_t mode) */
DEFINE_INTERN_WEAK_ALIAS(__x86_asm32_sysenter_readf, __x86_asm32_int80_readf)










/* errno_t restart_syscall(void) */
/* DEFINE_INTERN_ALIAS(__x86_asm32_sysrun32_restart_syscall, sys32_restart_syscall); */

/* Terminate the calling thread (_NOT_ process!)
 * @param: exit_code: Thread exit code (as returned by `wait(2)') */
/* void exit(syscall_ulong_t exit_code) */
.section .text.x86.asm32_syscall_sysrun32.exit
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_exit)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_exit)
	jmp    sys32_exit
	.cfi_endproc
END(__x86_asm32_sysrun32_exit)

/* Clone the calling thread into a second process and return twice, once
 * in  the parent process where this function returns the (non-zero) PID
 * of  the forked child process, and a  second time in the child process
 * itself, where ZERO(0) is returned.
 * The child then usually proceeds by calling `exec(2)' to replace its
 * application image with  that of another  program that the  original
 * parent can then `wait(2)' for. (s.a. `vfork(2)')
 * @return: 0 : You're the new process that was created
 * @return: * : The `return' value is the pid of your new child process */
/* pid_t fork(void) */
/* DEFINE_INTERN_ALIAS(__x86_asm32_sysrun32_fork, sys32_fork); */

/* Read up to `bufsize' bytes from `fd' into `buf'
 * When  `fd' has the `O_NONBLOCK' flag set, only read as much data as was
 * available at the time the call was made, and throw `E_WOULDBLOCK' if no
 * data was available at the time.
 * @return: <= bufsize: The actual amount of read bytes
 * @return: 0         : EOF */
/* ssize_t read(fd_t fd, void *buf, size_t bufsize) */
.section .text.x86.asm32_syscall_sysrun32.read
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_read)
	.cfi_startproc
	movzlq 16(%rdi), %rdx
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_read)
	jmp    sys32_read
	.cfi_endproc
END(__x86_asm32_sysrun32_read)

/* Write up to `bufsize' bytes from `buf' into `fd'
 * When `fd' has the `O_NONBLOCK' flag set, only write as much data as
 * possible at the time the call was made, and throw `E_WOULDBLOCK' if
 * no data could be written at the time.
 * @return: <= bufsize: The actual amount of written bytes
 * @return: 0         : No more data can be written */
/* ssize_t write(fd_t fd, void const *buf, size_t bufsize) */
.section .text.x86.asm32_syscall_sysrun32.write
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_write)
	.cfi_startproc
	movzlq 16(%rdi), %rdx
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_write)
	jmp    sys32_write
	.cfi_endproc
END(__x86_asm32_sysrun32_write)

/* Open  a  new  file  handle  to  the  file  specified  by `filename'
 * When  `oflags & O_CREAT',   then  `mode'   specifies  the   initial
 * file  access  permissions with  which  the file  should  be opened.
 * On KOS, the returned handle can be anything, but is usually one of:
 *   - HANDLE_TYPE_PATH:       When `O_PATH' was given
 *   - HANDLE_TYPE_FILEHANDLE: For `S_IFREG' regular files
 *   - HANDLE_TYPE_FIFOHANDLE: For `S_IFIFO' pipe files
 *   - HANDLE_TYPE_DIRHANDLE:  For `S_IFDIR' directories
 *   - HANDLE_TYPE_MFILE:      The actual filesystem object (including device files)
 *   - *:                      Certain filesystem names can literally return anything, such
 *                             as `/proc/self/fd/1234',  which  is  more  like  `dup(1234)' */
/* fd_t open(char const *filename, oflag_t oflags, mode_t mode) */
.section .text.x86.asm32_syscall_sysrun32.open
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_open)
	.cfi_startproc
	movzlq 16(%rdi), %rdx
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_open)
	jmp    sys32_open
	.cfi_endproc
END(__x86_asm32_sysrun32_open)

/* Close a given file descriptor/handle `fd' */
/* errno_t close(fd_t fd) */
.section .text.x86.asm32_syscall_sysrun32.close
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_close)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_close)
	jmp    sys32_close
	.cfi_endproc
END(__x86_asm32_sysrun32_close)

/* Wait for a child process:
 *  - `pid < -1':  Wait for any child process whose process group ID is `-PID'
 *  - `pid == -1': Wait for any child process
 *  - `pid == 0':  Wait for any child process whose process group ID is that of the caller
 *  - `pid > 0':   Wait for the child whose process ID is equal to `PID'
 * @param: options: Set of `WNOHANG | WUNTRACED | WCONTINUED' (as a KOS extension, `WNOWAIT' is also accepted) */
/* pid_t waitpid(pid_t pid, int32_t *stat_loc, syscall_ulong_t options) */
.section .text.x86.asm32_syscall_sysrun32.waitpid
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_waitpid)
	.cfi_startproc
	movzlq 16(%rdi), %rdx
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_waitpid)
	jmp    sys32_waitpid
	.cfi_endproc
END(__x86_asm32_sysrun32_waitpid)

/* fd_t creat(char const *filename, mode_t mode) */
.section .text.x86.asm32_syscall_sysrun32.creat
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_creat)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_creat)
	jmp    sys32_creat
	.cfi_endproc
END(__x86_asm32_sysrun32_creat)

/* errno_t link(char const *existing_file, char const *link_file) */
.section .text.x86.asm32_syscall_sysrun32.link
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_link)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_link)
	jmp    sys32_link
	.cfi_endproc
END(__x86_asm32_sysrun32_link)

/* errno_t unlink(char const *filename) */
.section .text.x86.asm32_syscall_sysrun32.unlink
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_unlink)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_unlink)
	jmp    sys32_unlink
	.cfi_endproc
END(__x86_asm32_sysrun32_unlink)

/* Replace the calling  process with  the application  image referred  to by  `path' /  `file'
 * and execute it's `main()' method, passing the given `argv', and setting `environ' to `envp' */
/* errno_t execve(char const *path, __HYBRID_PTR32(char const) const *argv, __HYBRID_PTR32(char const) const *envp) */
.section .text.x86.asm32_syscall_sysrun32.execve
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_execve)
	.cfi_startproc
	movzlq 16(%rdi), %rdx
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_execve)
	jmp    sys32_execve
	.cfi_endproc
END(__x86_asm32_sysrun32_execve)

/* errno_t chdir(char const *path) */
.section .text.x86.asm32_syscall_sysrun32.chdir
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_chdir)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_chdir)
	jmp    sys32_chdir
	.cfi_endproc
END(__x86_asm32_sysrun32_chdir)

/* int32_t time(int32_t *timer) */
.section .text.x86.asm32_syscall_sysrun32.time
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_time)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_time)
	jmp    sys32_time
	.cfi_endproc
END(__x86_asm32_sysrun32_time)

/* errno_t mknod(char const *nodename, mode_t mode, dev_t dev) */
.section .text.x86.asm32_syscall_sysrun32.mknod
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_mknod)
	.cfi_startproc
	movzlq 16(%rdi), %rdx
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_mknod)
	jmp    sys32_mknod
	.cfi_endproc
END(__x86_asm32_sysrun32_mknod)

/* errno_t chmod(char const *filename, mode_t mode) */
.section .text.x86.asm32_syscall_sysrun32.chmod
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_chmod)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_chmod)
	jmp    sys32_chmod
	.cfi_endproc
END(__x86_asm32_sysrun32_chmod)

/* errno_t lchown(char const *filename, uint16_t owner, uint16_t group) */
.section .text.x86.asm32_syscall_sysrun32.lchown
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_lchown)
	.cfi_startproc
	movzwq 16(%rdi), %rdx
	movzwq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_lchown)
	jmp    sys32_lchown
	.cfi_endproc
END(__x86_asm32_sysrun32_lchown)

/* errno_t break(void) */
/* DEFINE_INTERN_ALIAS(__x86_asm32_sysrun32_break, sys32_break); */

/* errno_t oldstat(char const *filename, struct linux_oldstat *statbuf) */
.section .text.x86.asm32_syscall_sysrun32.oldstat
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_oldstat)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_oldstat)
	jmp    sys32_oldstat
	.cfi_endproc
END(__x86_asm32_sysrun32_oldstat)

/* syscall_slong_t lseek(fd_t fd, syscall_slong_t offset, syscall_ulong_t whence) */
.section .text.x86.asm32_syscall_sysrun32.lseek
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_lseek)
	.cfi_startproc
	movzlq 16(%rdi), %rdx
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_lseek)
	jmp    sys32_lseek
	.cfi_endproc
END(__x86_asm32_sysrun32_lseek)

/* pid_t getpid(void) */
/* DEFINE_INTERN_ALIAS(__x86_asm32_sysrun32_getpid, sys32_getpid); */

/* errno_t mount(char const *special_file, char const *dir, char const *fstype, syscall_ulong_t mountflags, void const *data) */
.section .text.x86.asm32_syscall_sysrun32.mount
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_mount)
	.cfi_startproc
	movzlq 32(%rdi), %r8
	movzlq 24(%rdi), %rcx
	movzlq 16(%rdi), %rdx
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_mount)
	jmp    sys32_mount
	.cfi_endproc
END(__x86_asm32_sysrun32_mount)

/* errno_t umount(char const *special_file) */
.section .text.x86.asm32_syscall_sysrun32.umount
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_umount)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_umount)
	jmp    sys32_umount
	.cfi_endproc
END(__x86_asm32_sysrun32_umount)

/* >> setuid(2)
 * Set the UID of the calling thread (this is the so-called ~real~ UID)
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setuid(uint16_t uid) */
.section .text.x86.asm32_syscall_sysrun32.setuid
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_setuid)
	.cfi_startproc
	movzwq 0(%rdi), %rdi
	EXTERN(sys32_setuid)
	jmp    sys32_setuid
	.cfi_endproc
END(__x86_asm32_sysrun32_setuid)

/* >> getuid(2)
 * @return: * : The UID of the calling thread (this is the so-called ~real~ UID) */
/* uint16_t getuid(void) */
/* DEFINE_INTERN_ALIAS(__x86_asm32_sysrun32_getuid, sys32_getuid); */

/* errno_t stime(time32_t const *t) */
.section .text.x86.asm32_syscall_sysrun32.stime
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_stime)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_stime)
	jmp    sys32_stime
	.cfi_endproc
END(__x86_asm32_sysrun32_stime)

/* syscall_slong_t ptrace(syscall_ulong_t request, pid_t pid, void *addr, void *data) */
.section .text.x86.asm32_syscall_sysrun32.ptrace
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_ptrace)
	.cfi_startproc
	movzlq 24(%rdi), %rcx
	movzlq 16(%rdi), %rdx
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_ptrace)
	jmp    sys32_ptrace
	.cfi_endproc
END(__x86_asm32_sysrun32_ptrace)

/* syscall_ulong_t alarm(syscall_ulong_t seconds) */
.section .text.x86.asm32_syscall_sysrun32.alarm
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_alarm)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_alarm)
	jmp    sys32_alarm
	.cfi_endproc
END(__x86_asm32_sysrun32_alarm)

/* errno_t oldfstat(fd_t fd, struct linux_oldstat *statbuf) */
.section .text.x86.asm32_syscall_sysrun32.oldfstat
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_oldfstat)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_oldfstat)
	jmp    sys32_oldfstat
	.cfi_endproc
END(__x86_asm32_sysrun32_oldfstat)

/* Same as `select(0, NULL, NULL, NULL, NULL)' */
/* errno_t pause(void) */
/* DEFINE_INTERN_ALIAS(__x86_asm32_sysrun32_pause, sys32_pause); */

/* @param: times: When NULL, set the current time */
/* errno_t utime(char const *filename, struct utimbufx32 const *times) */
.section .text.x86.asm32_syscall_sysrun32.utime
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_utime)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_utime)
	jmp    sys32_utime
	.cfi_endproc
END(__x86_asm32_sysrun32_utime)

/* errno_t stty(void) */
/* DEFINE_INTERN_ALIAS(__x86_asm32_sysrun32_stty, sys32_stty); */

/* errno_t gtty(void) */
/* DEFINE_INTERN_ALIAS(__x86_asm32_sysrun32_gtty, sys32_gtty); */

/* @param: type: Set of `R_OK|W_OK|X_OK' or `F_OK' */
/* errno_t access(char const *filename, syscall_ulong_t type) */
.section .text.x86.asm32_syscall_sysrun32.access
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_access)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_access)
	jmp    sys32_access
	.cfi_endproc
END(__x86_asm32_sysrun32_access)

/* errno_t nice(syscall_slong_t inc) */
.section .text.x86.asm32_syscall_sysrun32.nice
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_nice)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_nice)
	jmp    sys32_nice
	.cfi_endproc
END(__x86_asm32_sysrun32_nice)

/* errno_t ftime(struct timebx32 *tp) */
.section .text.x86.asm32_syscall_sysrun32.ftime
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_ftime)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_ftime)
	jmp    sys32_ftime
	.cfi_endproc
END(__x86_asm32_sysrun32_ftime)

/* errno_t sync(void) */
/* DEFINE_INTERN_ALIAS(__x86_asm32_sysrun32_sync, sys32_sync); */

/* errno_t kill(pid_t pid, signo_t signo) */
.section .text.x86.asm32_syscall_sysrun32.kill
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_kill)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_kill)
	jmp    sys32_kill
	.cfi_endproc
END(__x86_asm32_sysrun32_kill)

/* errno_t rename(char const *oldname, char const *newname_or_path) */
.section .text.x86.asm32_syscall_sysrun32.rename
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_rename)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_rename)
	jmp    sys32_rename
	.cfi_endproc
END(__x86_asm32_sysrun32_rename)

/* errno_t mkdir(char const *pathname, mode_t mode) */
.section .text.x86.asm32_syscall_sysrun32.mkdir
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_mkdir)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_mkdir)
	jmp    sys32_mkdir
	.cfi_endproc
END(__x86_asm32_sysrun32_mkdir)

/* errno_t rmdir(char const *path) */
.section .text.x86.asm32_syscall_sysrun32.rmdir
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_rmdir)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_rmdir)
	jmp    sys32_rmdir
	.cfi_endproc
END(__x86_asm32_sysrun32_rmdir)

/* fd_t dup(fd_t fd) */
.section .text.x86.asm32_syscall_sysrun32.dup
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_dup)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_dup)
	jmp    sys32_dup
	.cfi_endproc
END(__x86_asm32_sysrun32_dup)

/* errno_t pipe(fd_t[2] pipedes) */
.section .text.x86.asm32_syscall_sysrun32.pipe
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_pipe)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_pipe)
	jmp    sys32_pipe
	.cfi_endproc
END(__x86_asm32_sysrun32_pipe)

/* clock_t times(struct tmsx32 *buf) */
.section .text.x86.asm32_syscall_sysrun32.times
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_times)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_times)
	jmp    sys32_times
	.cfi_endproc
END(__x86_asm32_sysrun32_times)

/* errno_t prof(void) */
/* DEFINE_INTERN_ALIAS(__x86_asm32_sysrun32_prof, sys32_prof); */

/* errno_t brk(void *addr) */
.section .text.x86.asm32_syscall_sysrun32.brk
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_brk)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_brk)
	jmp    sys32_brk
	.cfi_endproc
END(__x86_asm32_sysrun32_brk)

/* >> setgid(2)
 * Set the GID of the calling thread (this is the so-called ~real~ GID)
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setgid(uint16_t gid) */
.section .text.x86.asm32_syscall_sysrun32.setgid
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_setgid)
	.cfi_startproc
	movzwq 0(%rdi), %rdi
	EXTERN(sys32_setgid)
	jmp    sys32_setgid
	.cfi_endproc
END(__x86_asm32_sysrun32_setgid)

/* >> getgid(2)
 * @return: * : The GID of the calling thread (this is the so-called ~real~ GID) */
/* uint16_t getgid(void) */
/* DEFINE_INTERN_ALIAS(__x86_asm32_sysrun32_getgid, sys32_getgid); */

/* __sigactionx32_sa_handler_t signal(signo_t signo, __sigactionx32_sa_handler_t handler) */
.section .text.x86.asm32_syscall_sysrun32.signal
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_signal)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_signal)
	jmp    sys32_signal
	.cfi_endproc
END(__x86_asm32_sysrun32_signal)

/* >> geteuid(2)
 * @return: * : The   effective  UID  of  the  calling  thread.
 *              This is the one used for most permission checks */
/* uint16_t geteuid(void) */
/* DEFINE_INTERN_ALIAS(__x86_asm32_sysrun32_geteuid, sys32_geteuid); */

/* >> getegid(2)
 * @return: * : The   effective  GID  of  the  calling  thread.
 *              This is the one used for most permission checks */
/* uint16_t getegid(void) */
/* DEFINE_INTERN_ALIAS(__x86_asm32_sysrun32_getegid, sys32_getegid); */

/* errno_t acct(char const *filename) */
.section .text.x86.asm32_syscall_sysrun32.acct
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_acct)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_acct)
	jmp    sys32_acct
	.cfi_endproc
END(__x86_asm32_sysrun32_acct)

/* errno_t umount2(char const *special_file, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysrun32.umount2
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_umount2)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_umount2)
	jmp    sys32_umount2
	.cfi_endproc
END(__x86_asm32_sysrun32_umount2)

/* errno_t lock(void) */
/* DEFINE_INTERN_ALIAS(__x86_asm32_sysrun32_lock, sys32_lock); */

/* syscall_slong_t ioctl(fd_t fd, ioctl_t command, void *arg) */
.section .text.x86.asm32_syscall_sysrun32.ioctl
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_ioctl)
	.cfi_startproc
	movzlq 16(%rdi), %rdx
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_ioctl)
	jmp    sys32_ioctl
	.cfi_endproc
END(__x86_asm32_sysrun32_ioctl)

/* syscall_slong_t fcntl(fd_t fd, fcntl_t command, void *arg) */
.section .text.x86.asm32_syscall_sysrun32.fcntl
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_fcntl)
	.cfi_startproc
	movzlq 16(%rdi), %rdx
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_fcntl)
	jmp    sys32_fcntl
	.cfi_endproc
END(__x86_asm32_sysrun32_fcntl)

/* errno_t mpx(void) */
/* DEFINE_INTERN_ALIAS(__x86_asm32_sysrun32_mpx, sys32_mpx); */

/* errno_t setpgid(pid_t pid, pid_t pgid) */
.section .text.x86.asm32_syscall_sysrun32.setpgid
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_setpgid)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_setpgid)
	jmp    sys32_setpgid
	.cfi_endproc
END(__x86_asm32_sysrun32_setpgid)

/* errno_t ulimit(void) */
/* DEFINE_INTERN_ALIAS(__x86_asm32_sysrun32_ulimit, sys32_ulimit); */

/* errno_t oldolduname(struct linux_oldolduname *name) */
.section .text.x86.asm32_syscall_sysrun32.oldolduname
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_oldolduname)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_oldolduname)
	jmp    sys32_oldolduname
	.cfi_endproc
END(__x86_asm32_sysrun32_oldolduname)

/* mode_t umask(mode_t mode) */
.section .text.x86.asm32_syscall_sysrun32.umask
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_umask)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_umask)
	jmp    sys32_umask
	.cfi_endproc
END(__x86_asm32_sysrun32_umask)

/* errno_t chroot(char const *path) */
.section .text.x86.asm32_syscall_sysrun32.chroot
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_chroot)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_chroot)
	jmp    sys32_chroot
	.cfi_endproc
END(__x86_asm32_sysrun32_chroot)

/* errno_t ustat(dev_t dev, struct ustat *ubuf) */
.section .text.x86.asm32_syscall_sysrun32.ustat
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_ustat)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_ustat)
	jmp    sys32_ustat
	.cfi_endproc
END(__x86_asm32_sysrun32_ustat)

/* fd_t dup2(fd_t oldfd, fd_t newfd) */
.section .text.x86.asm32_syscall_sysrun32.dup2
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_dup2)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_dup2)
	jmp    sys32_dup2
	.cfi_endproc
END(__x86_asm32_sysrun32_dup2)

/* pid_t getppid(void) */
/* DEFINE_INTERN_ALIAS(__x86_asm32_sysrun32_getppid, sys32_getppid); */

/* pid_t getpgrp(void) */
/* DEFINE_INTERN_ALIAS(__x86_asm32_sysrun32_getpgrp, sys32_getpgrp); */

/* pid_t setsid(void) */
/* DEFINE_INTERN_ALIAS(__x86_asm32_sysrun32_setsid, sys32_setsid); */

/* errno_t sigaction(signo_t signo, struct __old_kernel_sigactionx32 const *act, struct __old_kernel_sigactionx32 *oact) */
.section .text.x86.asm32_syscall_sysrun32.sigaction
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_sigaction)
	.cfi_startproc
	movzlq 16(%rdi), %rdx
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_sigaction)
	jmp    sys32_sigaction
	.cfi_endproc
END(__x86_asm32_sysrun32_sigaction)

/* uint32_t sgetmask(void) */
/* DEFINE_INTERN_ALIAS(__x86_asm32_sysrun32_sgetmask, sys32_sgetmask); */

/* uint32_t ssetmask(uint32_t sigmask) */
.section .text.x86.asm32_syscall_sysrun32.ssetmask
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_ssetmask)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_ssetmask)
	jmp    sys32_ssetmask
	.cfi_endproc
END(__x86_asm32_sysrun32_ssetmask)

/* >> setreuid(2)
 * Set the real and effective UID of the calling thread.
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setreuid(uint16_t ruid, uint16_t euid) */
.section .text.x86.asm32_syscall_sysrun32.setreuid
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_setreuid)
	.cfi_startproc
	movzwq 8(%rdi), %rsi
	movzwq 0(%rdi), %rdi
	EXTERN(sys32_setreuid)
	jmp    sys32_setreuid
	.cfi_endproc
END(__x86_asm32_sysrun32_setreuid)

/* >> setregid(2)
 * Set the real and effective GID of the calling thread.
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setregid(uint16_t rgid, uint16_t egid) */
.section .text.x86.asm32_syscall_sysrun32.setregid
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_setregid)
	.cfi_startproc
	movzwq 8(%rdi), %rsi
	movzwq 0(%rdi), %rdi
	EXTERN(sys32_setregid)
	jmp    sys32_setregid
	.cfi_endproc
END(__x86_asm32_sysrun32_setregid)

/* >> sigsuspend(2), rt_sigsuspend(2)
 * Atomically save and  set the caller's  signal mask to  `set', then wait  for
 * one of the unmasked (iow: `!sigismember')-signals to arrive before restoring
 * the old signal mask.
 * @param: set: The set of signals on which to wait
 * @return: -1: [errno=EINTR] The signal handler for `signo' was executed. */
/* errno_t sigsuspend(struct __old_sigset_struct const *set) */
.section .text.x86.asm32_syscall_sysrun32.sigsuspend
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_sigsuspend)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_sigsuspend)
	jmp    sys32_sigsuspend
	.cfi_endproc
END(__x86_asm32_sysrun32_sigsuspend)

/* errno_t sigpending(struct __old_sigset_struct *set) */
.section .text.x86.asm32_syscall_sysrun32.sigpending
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_sigpending)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_sigpending)
	jmp    sys32_sigpending
	.cfi_endproc
END(__x86_asm32_sysrun32_sigpending)

/* errno_t sethostname(char const *name, size_t len) */
.section .text.x86.asm32_syscall_sysrun32.sethostname
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_sethostname)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_sethostname)
	jmp    sys32_sethostname
	.cfi_endproc
END(__x86_asm32_sysrun32_sethostname)

/* @param: resource: One of `RLIMIT_*' from <sys/resource.h> */
/* errno_t setrlimit(syscall_ulong_t resource, struct rlimitx32 const *rlimits) */
.section .text.x86.asm32_syscall_sysrun32.setrlimit
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_setrlimit)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_setrlimit)
	jmp    sys32_setrlimit
	.cfi_endproc
END(__x86_asm32_sysrun32_setrlimit)

/* @param: resource: One of `RLIMIT_*' from <sys/resource.h> */
/* errno_t getrlimit(syscall_ulong_t resource, struct rlimitx32 *rlimits) */
.section .text.x86.asm32_syscall_sysrun32.getrlimit
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_getrlimit)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_getrlimit)
	jmp    sys32_getrlimit
	.cfi_endproc
END(__x86_asm32_sysrun32_getrlimit)

/* @param: who: One of `RUSAGE_SELF', `RUSAGE_CHILDREN' or `RUSAGE_THREAD' */
/* errno_t getrusage(syscall_slong_t who, struct rusagex32 *tv) */
.section .text.x86.asm32_syscall_sysrun32.getrusage
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_getrusage)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_getrusage)
	jmp    sys32_getrusage
	.cfi_endproc
END(__x86_asm32_sysrun32_getrusage)

/* errno_t gettimeofday(struct timevalx32 *tv, struct timezone *tz) */
.section .text.x86.asm32_syscall_sysrun32.gettimeofday
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_gettimeofday)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_gettimeofday)
	jmp    sys32_gettimeofday
	.cfi_endproc
END(__x86_asm32_sysrun32_gettimeofday)

/* errno_t settimeofday(struct timevalx32 const *tv, struct timezone const *tz) */
.section .text.x86.asm32_syscall_sysrun32.settimeofday
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_settimeofday)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_settimeofday)
	jmp    sys32_settimeofday
	.cfi_endproc
END(__x86_asm32_sysrun32_settimeofday)

/* @return: * :     [count == 0] The required number of groups
 * @return: * :     [count != 0] The number of groups that were actually returned
 * @throw: -EINVAL: [count != 0] There are more than `count' groups (NOTE: No exception is thrown for this case!) */
/* ssize_t getgroups(size_t count, uint16_t[] list) */
.section .text.x86.asm32_syscall_sysrun32.getgroups
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_getgroups)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_getgroups)
	jmp    sys32_getgroups
	.cfi_endproc
END(__x86_asm32_sysrun32_getgroups)

/* errno_t setgroups(size_t count, uint16_t const *groups) */
.section .text.x86.asm32_syscall_sysrun32.setgroups
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_setgroups)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_setgroups)
	jmp    sys32_setgroups
	.cfi_endproc
END(__x86_asm32_sysrun32_setgroups)

/* ssize_t select(struct sel_arg_structx32 const *arg) */
.section .text.x86.asm32_syscall_sysrun32.select
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_select)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_select)
	jmp    sys32_select
	.cfi_endproc
END(__x86_asm32_sysrun32_select)

/* errno_t symlink(char const *link_text, char const *target_path) */
.section .text.x86.asm32_syscall_sysrun32.symlink
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_symlink)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_symlink)
	jmp    sys32_symlink
	.cfi_endproc
END(__x86_asm32_sysrun32_symlink)

/* errno_t oldlstat(char const *filename, struct linux_oldstat *statbuf) */
.section .text.x86.asm32_syscall_sysrun32.oldlstat
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_oldlstat)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_oldlstat)
	jmp    sys32_oldlstat
	.cfi_endproc
END(__x86_asm32_sysrun32_oldlstat)

/* ssize_t readlink(char const *path, char *buf, size_t buflen) */
.section .text.x86.asm32_syscall_sysrun32.readlink
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_readlink)
	.cfi_startproc
	movzlq 16(%rdi), %rdx
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_readlink)
	jmp    sys32_readlink
	.cfi_endproc
END(__x86_asm32_sysrun32_readlink)

/* errno_t uselib(char const *library) */
.section .text.x86.asm32_syscall_sysrun32.uselib
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_uselib)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_uselib)
	jmp    sys32_uselib
	.cfi_endproc
END(__x86_asm32_sysrun32_uselib)

/* @param: swapflags: Set of `SWAP_FLAG_*' */
/* errno_t swapon(char const *pathname, syscall_ulong_t swapflags) */
.section .text.x86.asm32_syscall_sysrun32.swapon
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_swapon)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_swapon)
	jmp    sys32_swapon
	.cfi_endproc
END(__x86_asm32_sysrun32_swapon)

/* @param: how: One of the `RB_*' constants from <sys/reboot.h> */
/* errno_t reboot(syscall_ulong_t how) */
.section .text.x86.asm32_syscall_sysrun32.reboot
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_reboot)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_reboot)
	jmp    sys32_reboot
	.cfi_endproc
END(__x86_asm32_sysrun32_reboot)

/* Read exactly one directory entry from `fd'
 * Note that the linux version of this system call has one additional argument `count'.
 * However, within the  linux kernel implementation,  that argument is  unconditionally
 * ignored,  and the system call will _always_ read exactly 1 directory entry from `fd'
 * @return: 1 : Read on directory entry
 * @return: 0 : End-of-directory */
/* syscall_slong_t readdir(fd_t fd, struct old_linux_direntx32 *buf) */
.section .text.x86.asm32_syscall_sysrun32.readdir
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_readdir)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_readdir)
	jmp    sys32_readdir
	.cfi_endproc
END(__x86_asm32_sysrun32_readdir)

/* @param: prot:  Either `PROT_NONE', or set of `PROT_EXEC | PROT_WRITE | PROT_READ | PROT_SEM | PROT_SHARED'
 * @param: flags: One of `MAP_SHARED', 'MAP_SHARED_VALIDATE' or `MAP_PRIVATE', optionally or'd
 *               with  a  set of  `MAP_ANONYMOUS  | MAP_FIXED  |  MAP_GROWSDOWN |  MAP_LOCKED |
 *               MAP_NONBLOCK  |  MAP_NORESERVE  |  MAP_POPULATE  |  MAP_STACK  |  MAP_SYNC   |
 *               MAP_UNINITIALIZED | MAP_DONT_MAP | MAP_FIXED_NOREPLACE | MAP_OFFSET64_POINTER' */
/* void *mmap(void *addr, size_t len, syscall_ulong_t prot, syscall_ulong_t flags, fd_t fd, syscall_ulong_t offset) */
.section .text.x86.asm32_syscall_sysrun32.mmap
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_mmap)
	.cfi_startproc
	movzlq 40(%rdi), %r9
	movzlq 32(%rdi), %r8
	movzlq 24(%rdi), %rcx
	movzlq 16(%rdi), %rdx
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_mmap)
	jmp    sys32_mmap
	.cfi_endproc
END(__x86_asm32_sysrun32_mmap)

/* errno_t munmap(void *addr, size_t len) */
.section .text.x86.asm32_syscall_sysrun32.munmap
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_munmap)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_munmap)
	jmp    sys32_munmap
	.cfi_endproc
END(__x86_asm32_sysrun32_munmap)

/* errno_t truncate(char const *filename, syscall_ulong_t length) */
.section .text.x86.asm32_syscall_sysrun32.truncate
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_truncate)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_truncate)
	jmp    sys32_truncate
	.cfi_endproc
END(__x86_asm32_sysrun32_truncate)

/* errno_t ftruncate(fd_t fd, syscall_ulong_t length) */
.section .text.x86.asm32_syscall_sysrun32.ftruncate
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_ftruncate)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_ftruncate)
	jmp    sys32_ftruncate
	.cfi_endproc
END(__x86_asm32_sysrun32_ftruncate)

/* errno_t fchmod(fd_t fd, mode_t mode) */
.section .text.x86.asm32_syscall_sysrun32.fchmod
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_fchmod)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_fchmod)
	jmp    sys32_fchmod
	.cfi_endproc
END(__x86_asm32_sysrun32_fchmod)

/* errno_t fchown(fd_t fd, uint16_t owner, uint16_t group) */
.section .text.x86.asm32_syscall_sysrun32.fchown
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_fchown)
	.cfi_startproc
	movzwq 16(%rdi), %rdx
	movzwq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_fchown)
	jmp    sys32_fchown
	.cfi_endproc
END(__x86_asm32_sysrun32_fchown)

/* @param: which: One of `PRIO_PROCESS', `PRIO_PGRP' or `PRIO_USER' */
/* syscall_slong_t getpriority(syscall_ulong_t which, id_t who) */
.section .text.x86.asm32_syscall_sysrun32.getpriority
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_getpriority)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_getpriority)
	jmp    sys32_getpriority
	.cfi_endproc
END(__x86_asm32_sysrun32_getpriority)

/* @param: which: One of `PRIO_PROCESS', `PRIO_PGRP' or `PRIO_USER' */
/* errno_t setpriority(syscall_ulong_t which, id_t who, syscall_ulong_t value) */
.section .text.x86.asm32_syscall_sysrun32.setpriority
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_setpriority)
	.cfi_startproc
	movzlq 16(%rdi), %rdx
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_setpriority)
	jmp    sys32_setpriority
	.cfi_endproc
END(__x86_asm32_sysrun32_setpriority)

/* errno_t profil(void) */
/* DEFINE_INTERN_ALIAS(__x86_asm32_sysrun32_profil, sys32_profil); */

/* errno_t statfs(char const *file, struct statfsx32 *buf) */
.section .text.x86.asm32_syscall_sysrun32.statfs
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_statfs)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_statfs)
	jmp    sys32_statfs
	.cfi_endproc
END(__x86_asm32_sysrun32_statfs)

/* errno_t fstatfs(fd_t file, struct statfsx32 *buf) */
.section .text.x86.asm32_syscall_sysrun32.fstatfs
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_fstatfs)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_fstatfs)
	jmp    sys32_fstatfs
	.cfi_endproc
END(__x86_asm32_sysrun32_fstatfs)

/* errno_t ioperm(syscall_ulong_t from, syscall_ulong_t num, syscall_ulong_t turn_on) */
.section .text.x86.asm32_syscall_sysrun32.ioperm
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_ioperm)
	.cfi_startproc
	movzlq 16(%rdi), %rdx
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_ioperm)
	jmp    sys32_ioperm
	.cfi_endproc
END(__x86_asm32_sysrun32_ioperm)

/* __LONG32_TYPE__ socketcall(__ULONG32_TYPE__ call, __ULONG32_TYPE__ *args) */
.section .text.x86.asm32_syscall_sysrun32.socketcall
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_socketcall)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_socketcall)
	jmp    sys32_socketcall
	.cfi_endproc
END(__x86_asm32_sysrun32_socketcall)

/* ssize_t syslog(syscall_ulong_t level, char const *str, size_t len) */
.section .text.x86.asm32_syscall_sysrun32.syslog
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_syslog)
	.cfi_startproc
	movzlq 16(%rdi), %rdx
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_syslog)
	jmp    sys32_syslog
	.cfi_endproc
END(__x86_asm32_sysrun32_syslog)

/* @param: which: One of `ITIMER_REAL', `ITIMER_VIRTUAL' or `ITIMER_PROF' */
/* errno_t setitimer(syscall_ulong_t which, struct __itimervalx32 const *newval, struct __itimervalx32 *oldval) */
.section .text.x86.asm32_syscall_sysrun32.setitimer
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_setitimer)
	.cfi_startproc
	movzlq 16(%rdi), %rdx
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_setitimer)
	jmp    sys32_setitimer
	.cfi_endproc
END(__x86_asm32_sysrun32_setitimer)

/* @param: which: One of `ITIMER_REAL', `ITIMER_VIRTUAL' or `ITIMER_PROF' */
/* errno_t getitimer(syscall_ulong_t which, struct __itimervalx32 *curr_value) */
.section .text.x86.asm32_syscall_sysrun32.getitimer
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_getitimer)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_getitimer)
	jmp    sys32_getitimer
	.cfi_endproc
END(__x86_asm32_sysrun32_getitimer)

/* errno_t stat(char const *filename, struct linux_statx32 *statbuf) */
.section .text.x86.asm32_syscall_sysrun32.stat
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_stat)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_stat)
	jmp    sys32_stat
	.cfi_endproc
END(__x86_asm32_sysrun32_stat)

/* errno_t lstat(char const *filename, struct linux_statx32 *statbuf) */
.section .text.x86.asm32_syscall_sysrun32.lstat
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_lstat)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_lstat)
	jmp    sys32_lstat
	.cfi_endproc
END(__x86_asm32_sysrun32_lstat)

/* errno_t fstat(fd_t fd, struct linux_statx32 *statbuf) */
.section .text.x86.asm32_syscall_sysrun32.fstat
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_fstat)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_fstat)
	jmp    sys32_fstat
	.cfi_endproc
END(__x86_asm32_sysrun32_fstat)

/* errno_t olduname(struct linux_olduname *name) */
.section .text.x86.asm32_syscall_sysrun32.olduname
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_olduname)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_olduname)
	jmp    sys32_olduname
	.cfi_endproc
END(__x86_asm32_sysrun32_olduname)

/* errno_t iopl(syscall_ulong_t level) */
.section .text.x86.asm32_syscall_sysrun32.iopl
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_iopl)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_iopl)
	jmp    sys32_iopl
	.cfi_endproc
END(__x86_asm32_sysrun32_iopl)

/* errno_t vhangup(void) */
/* DEFINE_INTERN_ALIAS(__x86_asm32_sysrun32_vhangup, sys32_vhangup); */

/* errno_t idle(void) */
/* DEFINE_INTERN_ALIAS(__x86_asm32_sysrun32_idle, sys32_idle); */

/* errno_t vm86old(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysrun32.vm86old
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_vm86old)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_vm86old)
	jmp    sys32_vm86old
	.cfi_endproc
END(__x86_asm32_sysrun32_vm86old)

/* Same as `waitpid(pid, STAT_LOC, OPTIONS)', though also fills in `USAGE' when non-NULL
 * @param: options: Set of `WNOHANG | WUNTRACED | WCONTINUED' (as a KOS extension, `WNOWAIT' is also accepted) */
/* pid_t wait4(pid_t pid, int32_t *stat_loc, syscall_ulong_t options, struct rusagex32 *usage) */
.section .text.x86.asm32_syscall_sysrun32.wait4
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_wait4)
	.cfi_startproc
	movzlq 24(%rdi), %rcx
	movzlq 16(%rdi), %rdx
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_wait4)
	jmp    sys32_wait4
	.cfi_endproc
END(__x86_asm32_sysrun32_wait4)

/* errno_t swapoff(char const *pathname) */
.section .text.x86.asm32_syscall_sysrun32.swapoff
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_swapoff)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_swapoff)
	jmp    sys32_swapoff
	.cfi_endproc
END(__x86_asm32_sysrun32_swapoff)

/* errno_t sysinfo(struct __sysinfox32 *info) */
.section .text.x86.asm32_syscall_sysrun32.sysinfo
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_sysinfo)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_sysinfo)
	jmp    sys32_sysinfo
	.cfi_endproc
END(__x86_asm32_sysrun32_sysinfo)

/* errno_t ipc(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysrun32.ipc
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_ipc)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_ipc)
	jmp    sys32_ipc
	.cfi_endproc
END(__x86_asm32_sysrun32_ipc)

/* Synchronize a file (including its descriptor which contains timestamps, and its size),
 * meaning  that  changes   to  its   data  and/or   descriptor  are   written  to   disk */
/* errno_t fsync(fd_t fd) */
.section .text.x86.asm32_syscall_sysrun32.fsync
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_fsync)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_fsync)
	jmp    sys32_fsync
	.cfi_endproc
END(__x86_asm32_sysrun32_fsync)

/* void sigreturn(void) */
/* DEFINE_INTERN_ALIAS(__x86_asm32_sysrun32_sigreturn, sys32_sigreturn); */

/* pid_t clone(syscall_ulong_t flags, void *child_stack, pid_t *ptid, uintptr_t newtls, pid_t *ctid) */
.section .text.x86.asm32_syscall_sysrun32.clone
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_clone)
	.cfi_startproc
	movzlq 32(%rdi), %r8
	movzlq 24(%rdi), %rcx
	movzlq 16(%rdi), %rdx
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_clone)
	jmp    sys32_clone
	.cfi_endproc
END(__x86_asm32_sysrun32_clone)

/* errno_t setdomainname(char const *name, size_t len) */
.section .text.x86.asm32_syscall_sysrun32.setdomainname
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_setdomainname)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_setdomainname)
	jmp    sys32_setdomainname
	.cfi_endproc
END(__x86_asm32_sysrun32_setdomainname)

/* errno_t uname(struct utsname *name) */
.section .text.x86.asm32_syscall_sysrun32.uname
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_uname)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_uname)
	jmp    sys32_uname
	.cfi_endproc
END(__x86_asm32_sysrun32_uname)

/* syscall_slong_t modify_ldt(syscall_ulong_t func, void *ptr, syscall_ulong_t bytecount) */
.section .text.x86.asm32_syscall_sysrun32.modify_ldt
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_modify_ldt)
	.cfi_startproc
	movzlq 16(%rdi), %rdx
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_modify_ldt)
	jmp    sys32_modify_ldt
	.cfi_endproc
END(__x86_asm32_sysrun32_modify_ldt)

/* errno_t adjtimex(struct timex *ntx) */
.section .text.x86.asm32_syscall_sysrun32.adjtimex
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_adjtimex)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_adjtimex)
	jmp    sys32_adjtimex
	.cfi_endproc
END(__x86_asm32_sysrun32_adjtimex)

/* @param: prot: Either `PROT_NONE', or set of `PROT_EXEC | PROT_WRITE | PROT_READ | PROT_SEM | PROT_SHARED' */
/* errno_t mprotect(void *addr, size_t len, syscall_ulong_t prot) */
.section .text.x86.asm32_syscall_sysrun32.mprotect
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_mprotect)
	.cfi_startproc
	movzlq 16(%rdi), %rdx
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_mprotect)
	jmp    sys32_mprotect
	.cfi_endproc
END(__x86_asm32_sysrun32_mprotect)

/* @param: how: One of `SIG_BLOCK', `SIG_UNBLOCK' or `SIG_SETMASK' */
/* errno_t sigprocmask(syscall_ulong_t how, struct __old_sigset_struct const *set, struct __old_sigset_struct *oset) */
.section .text.x86.asm32_syscall_sysrun32.sigprocmask
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_sigprocmask)
	.cfi_startproc
	movzlq 16(%rdi), %rdx
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_sigprocmask)
	jmp    sys32_sigprocmask
	.cfi_endproc
END(__x86_asm32_sysrun32_sigprocmask)

/* errno_t create_module(void) */
/* DEFINE_INTERN_ALIAS(__x86_asm32_sysrun32_create_module, sys32_create_module); */

/* Load a  kernel  driver  from an  ELF  image  `module_image...+=len'
 * This system call exists for linux compatibility, and is implemented
 * as an alias for  `KSYSCTL_DRIVER_INSMOD:KSYSCTL_DRIVER_FORMAT_BLOB'
 * 
 * Note however that that is where linux compatibility ends. Since the
 * linux kernel does not implement any semblance of a stable ABI,  you
 * have to realize that on KOS, this system call can only load drivers
 * specifically built to run within the KOS kernel!
 * @param: uargs: The driver commandline */
/* errno_t init_module(void const *module_image, size_t len, char const *uargs) */
.section .text.x86.asm32_syscall_sysrun32.init_module
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_init_module)
	.cfi_startproc
	movzlq 16(%rdi), %rdx
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_init_module)
	jmp    sys32_init_module
	.cfi_endproc
END(__x86_asm32_sysrun32_init_module)

/* Try to unload a driver, given its `name'
 * This system call exists for linux compatibility, and is implemented
 * as an alias for  `KSYSCTL_DRIVER_DELMOD:KSYSCTL_DRIVER_FORMAT_FILE'
 * @param: name:  The name of the driver
 * @param: flags: Set of `O_NONBLOCK | O_TRUNC', where:
 *                - O_NONBLOCK: s.a. `KSYSCTL_DRIVER_DELMOD_FNONBLOCK'
 *                - O_TRUNC:    s.a. `KSYSCTL_DRIVER_DELMOD_FFORCE' */
/* errno_t delete_module(char const *name, oflag_t flags) */
.section .text.x86.asm32_syscall_sysrun32.delete_module
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_delete_module)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_delete_module)
	jmp    sys32_delete_module
	.cfi_endproc
END(__x86_asm32_sysrun32_delete_module)

/* errno_t get_kernel_syms(void) */
/* DEFINE_INTERN_ALIAS(__x86_asm32_sysrun32_get_kernel_syms, sys32_get_kernel_syms); */

/* errno_t quotactl(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysrun32.quotactl
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_quotactl)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_quotactl)
	jmp    sys32_quotactl
	.cfi_endproc
END(__x86_asm32_sysrun32_quotactl)

/* pid_t getpgid(pid_t pid) */
.section .text.x86.asm32_syscall_sysrun32.getpgid
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_getpgid)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_getpgid)
	jmp    sys32_getpgid
	.cfi_endproc
END(__x86_asm32_sysrun32_getpgid)

/* errno_t fchdir(fd_t fd) */
.section .text.x86.asm32_syscall_sysrun32.fchdir
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_fchdir)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_fchdir)
	jmp    sys32_fchdir
	.cfi_endproc
END(__x86_asm32_sysrun32_fchdir)

/* errno_t bdflush(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysrun32.bdflush
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_bdflush)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_bdflush)
	jmp    sys32_bdflush
	.cfi_endproc
END(__x86_asm32_sysrun32_bdflush)

/* errno_t sysfs(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysrun32.sysfs
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_sysfs)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_sysfs)
	jmp    sys32_sysfs
	.cfi_endproc
END(__x86_asm32_sysrun32_sysfs)

/* errno_t personality(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysrun32.personality
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_personality)
	.cfi_startproc
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_personality)
	jmp    sys32_personality
	.cfi_endproc
END(__x86_asm32_sysrun32_personality)

/* errno_t afs_syscall(void) */
/* DEFINE_INTERN_ALIAS(__x86_asm32_sysrun32_afs_syscall, sys32_afs_syscall); */

/* >> setfsuid(2)
 * Set the  user ID  for the  cred-context (s.a.  `CLONE_CRED') of  the
 * calling thread. The calling thread needs the `CAP_SETUID' privilege.
 * @return: 0:  Success.
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setfsuid(uint16_t uid) */
.section .text.x86.asm32_syscall_sysrun32.setfsuid
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_setfsuid)
	.cfi_startproc
	movzwq 0(%rdi), %rdi
	EXTERN(sys32_setfsuid)
	jmp    sys32_setfsuid
	.cfi_endproc
END(__x86_asm32_sysrun32_setfsuid)

/* >> setfsgid(2)
 * Set the group  ID for  the cred-context (s.a.  `CLONE_CRED') of  the
 * calling thread. The calling thread needs the `CAP_SETGID' privilege.
 * @return: 0:  Success.
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setfsgid(uint16_t gid) */
.section .text.x86.asm32_syscall_sysrun32.setfsgid
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_setfsgid)
	.cfi_startproc
	movzwq 0(%rdi), %rdi
	EXTERN(sys32_setfsgid)
	jmp    sys32_setfsgid
	.cfi_endproc
END(__x86_asm32_sysrun32_setfsgid)

/* errno_t _llseek(fd_t fd, int64_t offset, uint64_t *result, syscall_ulong_t whence) */
.section .text.x86.asm32_syscall_sysrun32._llseek
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32__llseek)
	.cfi_startproc
	movzlq 32(%rdi), %rcx
	movzlq 24(%rdi), %rdx
	movzlq 16(%rdi), %rax
	movzlq 8(%rdi), %rsi
	shlq   $32, %rax
	orq    %rax, %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32__llseek)
	jmp    sys32__llseek
	.cfi_endproc
END(__x86_asm32_sysrun32__llseek)

/* @return: * : The actual number of read entries
 * @return: 0 : End-of-directory */
/* ssize_t getdents(fd_t fd, struct linux_direntx32 *buf, size_t buflen) */
.section .text.x86.asm32_syscall_sysrun32.getdents
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_getdents)
	.cfi_startproc
	movzlq 16(%rdi), %rdx
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_getdents)
	jmp    sys32_getdents
	.cfi_endproc
END(__x86_asm32_sysrun32_getdents)

/* ssize_t _newselect(size_t nfds, struct __fd_set_struct *readfds, struct __fd_set_struct *writefds, struct __fd_set_struct *exceptfds, struct timevalx32 *timeout) */
.section .text.x86.asm32_syscall_sysrun32._newselect
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32__newselect)
	.cfi_startproc
	movzlq 32(%rdi), %r8
	movzlq 24(%rdi), %rcx
	movzlq 16(%rdi), %rdx
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32__newselect)
	jmp    sys32__newselect
	.cfi_endproc
END(__x86_asm32_sysrun32__newselect)

/* errno_t flock(fd_t fd, syscall_ulong_t operation) */
.section .text.x86.asm32_syscall_sysrun32.flock
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_flock)
	.cfi_startproc
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rdi
	EXTERN(sys32_flock)
	jmp    sys32_flock
	.cfi_endproc
END(__x86_asm32_sysrun32_flock)

/* errno_t msync(void *addr, size_t len, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysrun32.msync
INTERN_WEAK_FUNCTION(__x86_asm32_sysrun32_msync)
	.cfi_startproc
	movzlq 16(%rdi), %rdx
	movzlq 8(%rdi), %rsi
	movzlq 0(%rdi), %rd