/* HASH CRC-32:0x7a439be4 */
/* Copyright (c) 2019-2024 Griefer@Work                                       *
 *                                                                            *
 * This software is provided 'as-is', without any express or implied          *
 * warranty. In no event will the authors be held liable for any damages      *
 * arising from the use of this software.                                     *
 *                                                                            *
 * Permission is granted to anyone to use this software for any purpose,      *
 * including commercial applications, and to alter it and redistribute it     *
 * freely, subject to the following restrictions:                             *
 *                                                                            *
 * 1. The origin of this software must not be misrepresented; you must not    *
 *    claim that you wrote the original software. If you use this software    *
 *    in a product, an acknowledgement (see the following) in the product     *
 *    documentation is required:                                              *
 *    Portions Copyright (c) 2019-2024 Griefer@Work                           *
 * 2. Altered source versions must be plainly marked as such, and must not be *
 *    misrepresented as being the original software.                          *
 * 3. This notice may not be removed or altered from any source distribution. *
 */
#ifndef GUARD_KERNEL_CORE_ARCH_I386_SYSCALL_WRAPPERS32_S
#define GUARD_KERNEL_CORE_ARCH_I386_SYSCALL_WRAPPERS32_S 1

#include <kernel/compiler.h>

#include <cfi.h>
#include <kos/kernel/x86/gdt.h>
#include <kos/kernel/paging.h>
#include <kernel/arch/syscall.h>

EXTERN(__asm32_bad_sysenter_extension)










/* errno_t restart_syscall(void) */
.section .text.x86.asm32_syscall_int80.restart_syscall
INTERN_WEAK_FUNCTION(__x86_asm32_int80_restart_syscall)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x0
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_restart_syscall)
	call   sys_restart_syscall
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_restart_syscall)

/* Terminate the calling thread (_NOT_ process!)
 * @param: exit_code: Thread exit code (as returned by `wait(2)') */
/* void exit(syscall_ulong_t exit_code) */
.section .text.x86.asm32_syscall_int80.exit
INTERN_WEAK_FUNCTION(__x86_asm32_int80_exit)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_exit)
	call   sys_exit
	.cfi_endproc
END(__x86_asm32_int80_exit)

/* Clone the calling thread into a second process and return twice, once
 * in  the parent process where this function returns the (non-zero) PID
 * of  the forked child process, and a  second time in the child process
 * itself, where ZERO(0) is returned.
 * The child then usually proceeds by calling `exec(2)' to replace its
 * application image with  that of another  program that the  original
 * parent can then `wait(2)' for. (s.a. `vfork(2)')
 * @return: 0 : You're the new process that was created
 * @return: * : The `return' value is the pid of your new child process */
/* pid_t fork(void) */
.section .text.x86.asm32_syscall_int80.fork
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fork)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x2
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_fork)
	call   sys_fork
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fork)

/* Read up to `bufsize' bytes from `fd' into `buf'
 * When  `fd' has the `O_NONBLOCK' flag set, only read as much data as was
 * available at the time the call was made, and throw `E_WOULDBLOCK' if no
 * data was available at the time.
 * @return: <= bufsize: The actual amount of read bytes
 * @return: 0         : EOF */
/* ssize_t read(fd_t fd, void *buf, size_t bufsize) */
.section .text.x86.asm32_syscall_int80.read
INTERN_WEAK_FUNCTION(__x86_asm32_int80_read)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x3
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_read)
	call   sys_read
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_read)

/* Write up to `bufsize' bytes from `buf' into `fd'
 * When `fd' has the `O_NONBLOCK' flag set, only write as much data as
 * possible at the time the call was made, and throw `E_WOULDBLOCK' if
 * no data could be written at the time.
 * @return: <= bufsize: The actual amount of written bytes
 * @return: 0         : No more data can be written */
/* ssize_t write(fd_t fd, void const *buf, size_t bufsize) */
.section .text.x86.asm32_syscall_int80.write
INTERN_WEAK_FUNCTION(__x86_asm32_int80_write)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x4
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_write)
	call   sys_write
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_write)

/* Open  a  new  file  handle  to  the  file  specified  by `filename'
 * When  `oflags & O_CREAT',   then  `mode'   specifies  the   initial
 * file  access  permissions with  which  the file  should  be opened.
 * On KOS, the returned handle can be anything, but is usually one of:
 *   - HANDLE_TYPE_PATH:       When `O_PATH' was given
 *   - HANDLE_TYPE_FILEHANDLE: For `S_IFREG' regular files
 *   - HANDLE_TYPE_FIFOHANDLE: For `S_IFIFO' pipe files
 *   - HANDLE_TYPE_DIRHANDLE:  For `S_IFDIR' directories
 *   - HANDLE_TYPE_MFILE:      The actual filesystem object (including device files)
 *   - *:                      Certain filesystem names can literally return anything, such
 *                             as `/proc/self/fd/1234',  which  is  more  like  `dup(1234)' */
/* fd_t open(char const *filename, oflag_t oflags, mode_t mode) */
.section .text.x86.asm32_syscall_int80.open
INTERN_WEAK_FUNCTION(__x86_asm32_int80_open)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x5
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_open)
	call   sys_open
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_open)

/* Close a given file descriptor/handle `fd' */
/* errno_t close(fd_t fd) */
.section .text.x86.asm32_syscall_int80.close
INTERN_WEAK_FUNCTION(__x86_asm32_int80_close)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x6
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_close)
	call   sys_close
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_close)

/* Wait for a child process:
 *  - `pid < -1':  Wait for any child process whose process group ID is `-PID'
 *  - `pid == -1': Wait for any child process
 *  - `pid == 0':  Wait for any child process whose process group ID is that of the caller
 *  - `pid > 0':   Wait for the child whose process ID is equal to `PID'
 * @param: options: Set of `WNOHANG | WUNTRACED | WCONTINUED' (as a KOS extension, `WNOWAIT' is also accepted) */
/* pid_t waitpid(pid_t pid, int32_t *stat_loc, syscall_ulong_t options) */
.section .text.x86.asm32_syscall_int80.waitpid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_waitpid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x7
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_waitpid)
	call   sys_waitpid
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_waitpid)

/* fd_t creat(char const *filename, mode_t mode) */
.section .text.x86.asm32_syscall_int80.creat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_creat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x8
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_creat)
	call   sys_creat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_creat)

/* errno_t link(char const *existing_file, char const *link_file) */
.section .text.x86.asm32_syscall_int80.link
INTERN_WEAK_FUNCTION(__x86_asm32_int80_link)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x9
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_link)
	call   sys_link
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_link)

/* errno_t unlink(char const *filename) */
.section .text.x86.asm32_syscall_int80.unlink
INTERN_WEAK_FUNCTION(__x86_asm32_int80_unlink)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xa
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_unlink)
	call   sys_unlink
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_unlink)

/* Replace the calling  process with  the application  image referred  to by  `path' /  `file'
 * and execute it's `main()' method, passing the given `argv', and setting `environ' to `envp' */
/* errno_t execve(char const *path, __HYBRID_PTR32(char const) const *argv, __HYBRID_PTR32(char const) const *envp) */
.section .text.x86.asm32_syscall_int80.execve
INTERN_WEAK_FUNCTION(__x86_asm32_int80_execve)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xb
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_execve)
	call   sys_execve
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_execve)

/* errno_t chdir(char const *path) */
.section .text.x86.asm32_syscall_int80.chdir
INTERN_WEAK_FUNCTION(__x86_asm32_int80_chdir)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xc
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_chdir)
	call   sys_chdir
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_chdir)

/* int32_t time(int32_t *timer) */
.section .text.x86.asm32_syscall_int80.time
INTERN_WEAK_FUNCTION(__x86_asm32_int80_time)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xd
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_time)
	call   sys_time
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_time)

/* errno_t mknod(char const *nodename, mode_t mode, dev_t dev) */
.section .text.x86.asm32_syscall_int80.mknod
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mknod)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xe
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mknod)
	call   sys_mknod
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_mknod)

/* errno_t chmod(char const *filename, mode_t mode) */
.section .text.x86.asm32_syscall_int80.chmod
INTERN_WEAK_FUNCTION(__x86_asm32_int80_chmod)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xf
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_chmod)
	call   sys_chmod
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_chmod)

/* errno_t lchown(char const *filename, uint16_t owner, uint16_t group) */
.section .text.x86.asm32_syscall_int80.lchown
INTERN_WEAK_FUNCTION(__x86_asm32_int80_lchown)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x10
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_lchown)
	call   sys_lchown
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_lchown)

/* errno_t break(void) */
.section .text.x86.asm32_syscall_int80.break
INTERN_WEAK_FUNCTION(__x86_asm32_int80_break)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x11
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_break)
	call   sys_break
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_break)

/* errno_t oldstat(char const *filename, struct linux_oldstat *statbuf) */
.section .text.x86.asm32_syscall_int80.oldstat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_oldstat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x12
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_oldstat)
	call   sys_oldstat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_oldstat)

/* syscall_slong_t lseek(fd_t fd, syscall_slong_t offset, syscall_ulong_t whence) */
.section .text.x86.asm32_syscall_int80.lseek
INTERN_WEAK_FUNCTION(__x86_asm32_int80_lseek)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x13
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_lseek)
	call   sys_lseek
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_lseek)

/* pid_t getpid(void) */
.section .text.x86.asm32_syscall_int80.getpid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getpid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x14
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_getpid)
	call   sys_getpid
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getpid)

/* errno_t mount(char const *special_file, char const *dir, char const *fstype, syscall_ulong_t mountflags, void const *data) */
.section .text.x86.asm32_syscall_int80.mount
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mount)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x15
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mount)
	call   sys_mount
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_mount)

/* errno_t umount(char const *special_file) */
.section .text.x86.asm32_syscall_int80.umount
INTERN_WEAK_FUNCTION(__x86_asm32_int80_umount)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x16
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_umount)
	call   sys_umount
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_umount)

/* >> setuid(2)
 * Set the UID of the calling thread (this is the so-called ~real~ UID)
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setuid(uint16_t uid) */
.section .text.x86.asm32_syscall_int80.setuid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setuid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x17
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setuid)
	call   sys_setuid
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_setuid)

/* >> getuid(2)
 * @return: * : The UID of the calling thread (this is the so-called ~real~ UID) */
/* uint16_t getuid(void) */
.section .text.x86.asm32_syscall_int80.getuid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getuid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x18
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_getuid)
	call   sys_getuid
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getuid)

/* errno_t stime(time32_t const *t) */
.section .text.x86.asm32_syscall_int80.stime
INTERN_WEAK_FUNCTION(__x86_asm32_int80_stime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x19
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_stime)
	call   sys_stime
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_stime)

/* syscall_slong_t ptrace(syscall_ulong_t request, pid_t pid, void *addr, void *data) */
.section .text.x86.asm32_syscall_int80.ptrace
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ptrace)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ptrace)
	call   sys_ptrace
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_ptrace)

/* syscall_ulong_t alarm(syscall_ulong_t seconds) */
.section .text.x86.asm32_syscall_int80.alarm
INTERN_WEAK_FUNCTION(__x86_asm32_int80_alarm)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_alarm)
	call   sys_alarm
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_alarm)

/* errno_t oldfstat(fd_t fd, struct linux_oldstat *statbuf) */
.section .text.x86.asm32_syscall_int80.oldfstat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_oldfstat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_oldfstat)
	call   sys_oldfstat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_oldfstat)

/* Same as `select(0, NULL, NULL, NULL, NULL)' */
/* errno_t pause(void) */
.section .text.x86.asm32_syscall_int80.pause
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pause)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_pause)
	call   sys_pause
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_pause)

/* @param: times: When NULL, set the current time */
/* errno_t utime(char const *filename, struct utimbufx32 const *times) */
.section .text.x86.asm32_syscall_int80.utime
INTERN_WEAK_FUNCTION(__x86_asm32_int80_utime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_utime)
	call   sys_utime
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_utime)

/* errno_t stty(void) */
.section .text.x86.asm32_syscall_int80.stty
INTERN_WEAK_FUNCTION(__x86_asm32_int80_stty)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_stty)
	call   sys_stty
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_stty)

/* errno_t gtty(void) */
.section .text.x86.asm32_syscall_int80.gtty
INTERN_WEAK_FUNCTION(__x86_asm32_int80_gtty)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x20
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_gtty)
	call   sys_gtty
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_gtty)

/* @param: type: Set of `R_OK|W_OK|X_OK' or `F_OK' */
/* errno_t access(char const *filename, syscall_ulong_t type) */
.section .text.x86.asm32_syscall_int80.access
INTERN_WEAK_FUNCTION(__x86_asm32_int80_access)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x21
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_access)
	call   sys_access
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_access)

/* errno_t nice(syscall_slong_t inc) */
.section .text.x86.asm32_syscall_int80.nice
INTERN_WEAK_FUNCTION(__x86_asm32_int80_nice)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x22
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_nice)
	call   sys_nice
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_nice)

/* errno_t ftime(struct timebx32 *tp) */
.section .text.x86.asm32_syscall_int80.ftime
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ftime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x23
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ftime)
	call   sys_ftime
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_ftime)

/* errno_t sync(void) */
.section .text.x86.asm32_syscall_int80.sync
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sync)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x24
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_sync)
	call   sys_sync
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_sync)

/* errno_t kill(pid_t pid, signo_t signo) */
.section .text.x86.asm32_syscall_int80.kill
INTERN_WEAK_FUNCTION(__x86_asm32_int80_kill)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x25
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_kill)
	call   sys_kill
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_kill)

/* errno_t rename(char const *oldname, char const *newname_or_path) */
.section .text.x86.asm32_syscall_int80.rename
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rename)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x26
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_rename)
	call   sys_rename
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_rename)

/* errno_t mkdir(char const *pathname, mode_t mode) */
.section .text.x86.asm32_syscall_int80.mkdir
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mkdir)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x27
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mkdir)
	call   sys_mkdir
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_mkdir)

/* errno_t rmdir(char const *path) */
.section .text.x86.asm32_syscall_int80.rmdir
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rmdir)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x28
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_rmdir)
	call   sys_rmdir
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_rmdir)

/* fd_t dup(fd_t fd) */
.section .text.x86.asm32_syscall_int80.dup
INTERN_WEAK_FUNCTION(__x86_asm32_int80_dup)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x29
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_dup)
	call   sys_dup
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_dup)

/* errno_t pipe(fd_t[2] pipedes) */
.section .text.x86.asm32_syscall_int80.pipe
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pipe)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x2a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pipe)
	call   sys_pipe
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_pipe)

/* clock_t times(struct tmsx32 *buf) */
.section .text.x86.asm32_syscall_int80.times
INTERN_WEAK_FUNCTION(__x86_asm32_int80_times)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x2b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_times)
	call   sys_times
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_times)

/* errno_t prof(void) */
.section .text.x86.asm32_syscall_int80.prof
INTERN_WEAK_FUNCTION(__x86_asm32_int80_prof)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x2c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_prof)
	call   sys_prof
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_prof)

/* errno_t brk(void *addr) */
.section .text.x86.asm32_syscall_int80.brk
INTERN_WEAK_FUNCTION(__x86_asm32_int80_brk)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x2d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_brk)
	call   sys_brk
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_brk)

/* >> setgid(2)
 * Set the GID of the calling thread (this is the so-called ~real~ GID)
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setgid(uint16_t gid) */
.section .text.x86.asm32_syscall_int80.setgid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setgid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x2e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setgid)
	call   sys_setgid
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_setgid)

/* >> getgid(2)
 * @return: * : The GID of the calling thread (this is the so-called ~real~ GID) */
/* uint16_t getgid(void) */
.section .text.x86.asm32_syscall_int80.getgid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getgid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x2f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_getgid)
	call   sys_getgid
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getgid)

/* __sigactionx32_sa_handler_t signal(signo_t signo, __sigactionx32_sa_handler_t handler) */
.section .text.x86.asm32_syscall_int80.signal
INTERN_WEAK_FUNCTION(__x86_asm32_int80_signal)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x30
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_signal)
	call   sys_signal
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_signal)

/* >> geteuid(2)
 * @return: * : The   effective  UID  of  the  calling  thread.
 *              This is the one used for most permission checks */
/* uint16_t geteuid(void) */
.section .text.x86.asm32_syscall_int80.geteuid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_geteuid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x31
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_geteuid)
	call   sys_geteuid
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_geteuid)

/* >> getegid(2)
 * @return: * : The   effective  GID  of  the  calling  thread.
 *              This is the one used for most permission checks */
/* uint16_t getegid(void) */
.section .text.x86.asm32_syscall_int80.getegid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getegid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x32
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_getegid)
	call   sys_getegid
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getegid)

/* errno_t acct(char const *filename) */
.section .text.x86.asm32_syscall_int80.acct
INTERN_WEAK_FUNCTION(__x86_asm32_int80_acct)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x33
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_acct)
	call   sys_acct
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_acct)

/* errno_t umount2(char const *special_file, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.umount2
INTERN_WEAK_FUNCTION(__x86_asm32_int80_umount2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x34
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_umount2)
	call   sys_umount2
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_umount2)

/* errno_t lock(void) */
.section .text.x86.asm32_syscall_int80.lock
INTERN_WEAK_FUNCTION(__x86_asm32_int80_lock)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x35
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_lock)
	call   sys_lock
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_lock)

/* syscall_slong_t ioctl(fd_t fd, ioctl_t command, void *arg) */
.section .text.x86.asm32_syscall_int80.ioctl
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ioctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x36
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ioctl)
	call   sys_ioctl
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_ioctl)

/* syscall_slong_t fcntl(fd_t fd, fcntl_t command, void *arg) */
.section .text.x86.asm32_syscall_int80.fcntl
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fcntl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x37
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fcntl)
	call   sys_fcntl
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fcntl)

/* errno_t mpx(void) */
.section .text.x86.asm32_syscall_int80.mpx
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mpx)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x38
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_mpx)
	call   sys_mpx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_mpx)

/* errno_t setpgid(pid_t pid, pid_t pgid) */
.section .text.x86.asm32_syscall_int80.setpgid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setpgid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x39
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setpgid)
	call   sys_setpgid
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_setpgid)

/* errno_t ulimit(void) */
.section .text.x86.asm32_syscall_int80.ulimit
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ulimit)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x3a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_ulimit)
	call   sys_ulimit
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_ulimit)

/* errno_t oldolduname(struct linux_oldolduname *name) */
.section .text.x86.asm32_syscall_int80.oldolduname
INTERN_WEAK_FUNCTION(__x86_asm32_int80_oldolduname)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x3b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_oldolduname)
	call   sys_oldolduname
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_oldolduname)

/* mode_t umask(mode_t mode) */
.section .text.x86.asm32_syscall_int80.umask
INTERN_WEAK_FUNCTION(__x86_asm32_int80_umask)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x3c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_umask)
	call   sys_umask
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_umask)

/* errno_t chroot(char const *path) */
.section .text.x86.asm32_syscall_int80.chroot
INTERN_WEAK_FUNCTION(__x86_asm32_int80_chroot)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x3d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_chroot)
	call   sys_chroot
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_chroot)

/* errno_t ustat(dev_t dev, struct ustat *ubuf) */
.section .text.x86.asm32_syscall_int80.ustat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ustat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x3e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ustat)
	call   sys_ustat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_ustat)

/* fd_t dup2(fd_t oldfd, fd_t newfd) */
.section .text.x86.asm32_syscall_int80.dup2
INTERN_WEAK_FUNCTION(__x86_asm32_int80_dup2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x3f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_dup2)
	call   sys_dup2
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_dup2)

/* pid_t getppid(void) */
.section .text.x86.asm32_syscall_int80.getppid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getppid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x40
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_getppid)
	call   sys_getppid
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getppid)

/* pid_t getpgrp(void) */
.section .text.x86.asm32_syscall_int80.getpgrp
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getpgrp)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x41
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_getpgrp)
	call   sys_getpgrp
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getpgrp)

/* pid_t setsid(void) */
.section .text.x86.asm32_syscall_int80.setsid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setsid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x42
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_setsid)
	call   sys_setsid
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_setsid)

/* errno_t sigaction(signo_t signo, struct __old_kernel_sigactionx32 const *act, struct __old_kernel_sigactionx32 *oact) */
.section .text.x86.asm32_syscall_int80.sigaction
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sigaction)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x43
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sigaction)
	call   sys_sigaction
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_sigaction)

/* uint32_t sgetmask(void) */
.section .text.x86.asm32_syscall_int80.sgetmask
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sgetmask)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x44
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_sgetmask)
	call   sys_sgetmask
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_sgetmask)

/* uint32_t ssetmask(uint32_t sigmask) */
.section .text.x86.asm32_syscall_int80.ssetmask
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ssetmask)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x45
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ssetmask)
	call   sys_ssetmask
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_ssetmask)

/* >> setreuid(2)
 * Set the real and effective UID of the calling thread.
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setreuid(uint16_t ruid, uint16_t euid) */
.section .text.x86.asm32_syscall_int80.setreuid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setreuid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x46
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setreuid)
	call   sys_setreuid
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_setreuid)

/* >> setregid(2)
 * Set the real and effective GID of the calling thread.
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setregid(uint16_t rgid, uint16_t egid) */
.section .text.x86.asm32_syscall_int80.setregid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setregid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x47
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setregid)
	call   sys_setregid
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_setregid)

/* >> sigsuspend(2), rt_sigsuspend(2)
 * Atomically save and  set the caller's  signal mask to  `set', then wait  for
 * one of the unmasked (iow: `!sigismember')-signals to arrive before restoring
 * the old signal mask.
 * @param: set: The set of signals on which to wait
 * @return: -1: [errno=EINTR] The signal handler for `signo' was executed. */
/* errno_t sigsuspend(struct __old_sigset_struct const *set) */
.section .text.x86.asm32_syscall_int80.sigsuspend
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sigsuspend)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x48
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sigsuspend)
	call   sys_sigsuspend
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_sigsuspend)

/* errno_t sigpending(struct __old_sigset_struct *set) */
.section .text.x86.asm32_syscall_int80.sigpending
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sigpending)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x49
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sigpending)
	call   sys_sigpending
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_sigpending)

/* errno_t sethostname(char const *name, size_t len) */
.section .text.x86.asm32_syscall_int80.sethostname
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sethostname)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x4a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sethostname)
	call   sys_sethostname
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_sethostname)

/* @param: resource: One of `RLIMIT_*' from <sys/resource.h> */
/* errno_t setrlimit(syscall_ulong_t resource, struct rlimitx32 const *rlimits) */
.section .text.x86.asm32_syscall_int80.setrlimit
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setrlimit)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x4b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setrlimit)
	call   sys_setrlimit
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_setrlimit)

/* @param: resource: One of `RLIMIT_*' from <sys/resource.h> */
/* errno_t getrlimit(syscall_ulong_t resource, struct rlimitx32 *rlimits) */
.section .text.x86.asm32_syscall_int80.getrlimit
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getrlimit)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x4c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getrlimit)
	call   sys_getrlimit
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getrlimit)

/* @param: who: One of `RUSAGE_SELF', `RUSAGE_CHILDREN' or `RUSAGE_THREAD' */
/* errno_t getrusage(syscall_slong_t who, struct rusagex32 *tv) */
.section .text.x86.asm32_syscall_int80.getrusage
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getrusage)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x4d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getrusage)
	call   sys_getrusage
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getrusage)

/* errno_t gettimeofday(struct timevalx32 *tv, struct timezone *tz) */
.section .text.x86.asm32_syscall_int80.gettimeofday
INTERN_WEAK_FUNCTION(__x86_asm32_int80_gettimeofday)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x4e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_gettimeofday)
	call   sys_gettimeofday
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_gettimeofday)

/* errno_t settimeofday(struct timevalx32 const *tv, struct timezone const *tz) */
.section .text.x86.asm32_syscall_int80.settimeofday
INTERN_WEAK_FUNCTION(__x86_asm32_int80_settimeofday)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x4f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_settimeofday)
	call   sys_settimeofday
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_settimeofday)

/* @return: * :     [count == 0] The required number of groups
 * @return: * :     [count != 0] The number of groups that were actually returned
 * @throw: -EINVAL: [count != 0] There are more than `count' groups (NOTE: No exception is thrown for this case!) */
/* ssize_t getgroups(size_t count, uint16_t[] list) */
.section .text.x86.asm32_syscall_int80.getgroups
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getgroups)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x50
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getgroups)
	call   sys_getgroups
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getgroups)

/* errno_t setgroups(size_t count, uint16_t const *groups) */
.section .text.x86.asm32_syscall_int80.setgroups
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setgroups)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x51
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setgroups)
	call   sys_setgroups
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_setgroups)

/* ssize_t select(struct sel_arg_structx32 const *arg) */
.section .text.x86.asm32_syscall_int80.select
INTERN_WEAK_FUNCTION(__x86_asm32_int80_select)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x52
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_select)
	call   sys_select
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_select)

/* errno_t symlink(char const *link_text, char const *target_path) */
.section .text.x86.asm32_syscall_int80.symlink
INTERN_WEAK_FUNCTION(__x86_asm32_int80_symlink)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x53
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_symlink)
	call   sys_symlink
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_symlink)

/* errno_t oldlstat(char const *filename, struct linux_oldstat *statbuf) */
.section .text.x86.asm32_syscall_int80.oldlstat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_oldlstat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x54
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_oldlstat)
	call   sys_oldlstat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_oldlstat)

/* ssize_t readlink(char const *path, char *buf, size_t buflen) */
.section .text.x86.asm32_syscall_int80.readlink
INTERN_WEAK_FUNCTION(__x86_asm32_int80_readlink)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x55
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_readlink)
	call   sys_readlink
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_readlink)

/* errno_t uselib(char const *library) */
.section .text.x86.asm32_syscall_int80.uselib
INTERN_WEAK_FUNCTION(__x86_asm32_int80_uselib)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x56
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_uselib)
	call   sys_uselib
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_uselib)

/* @param: swapflags: Set of `SWAP_FLAG_*' */
/* errno_t swapon(char const *pathname, syscall_ulong_t swapflags) */
.section .text.x86.asm32_syscall_int80.swapon
INTERN_WEAK_FUNCTION(__x86_asm32_int80_swapon)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x57
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_swapon)
	call   sys_swapon
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_swapon)

/* @param: how: One of the `RB_*' constants from <sys/reboot.h> */
/* errno_t reboot(syscall_ulong_t how) */
.section .text.x86.asm32_syscall_int80.reboot
INTERN_WEAK_FUNCTION(__x86_asm32_int80_reboot)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x58
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_reboot)
	call   sys_reboot
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_reboot)

/* Read exactly one directory entry from `fd'
 * Note that the linux version of this system call has one additional argument `count'.
 * However, within the  linux kernel implementation,  that argument is  unconditionally
 * ignored,  and the system call will _always_ read exactly 1 directory entry from `fd'
 * @return: 1 : Read on directory entry
 * @return: 0 : End-of-directory */
/* syscall_slong_t readdir(fd_t fd, struct old_linux_direntx32 *buf) */
.section .text.x86.asm32_syscall_int80.readdir
INTERN_WEAK_FUNCTION(__x86_asm32_int80_readdir)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x59
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_readdir)
	call   sys_readdir
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_readdir)

/* @param: prot:  Either `PROT_NONE', or set of `PROT_EXEC | PROT_WRITE | PROT_READ | PROT_SEM | PROT_SHARED'
 * @param: flags: One of `MAP_SHARED', 'MAP_SHARED_VALIDATE' or `MAP_PRIVATE', optionally or'd
 *               with  a  set of  `MAP_ANONYMOUS  | MAP_FIXED  |  MAP_GROWSDOWN |  MAP_LOCKED |
 *               MAP_NONBLOCK  |  MAP_NORESERVE  |  MAP_POPULATE  |  MAP_STACK  |  MAP_SYNC   |
 *               MAP_UNINITIALIZED | MAP_DONT_MAP | MAP_FIXED_NOREPLACE | MAP_OFFSET64_POINTER' */
/* void *mmap(void *addr, size_t len, syscall_ulong_t prot, syscall_ulong_t flags, fd_t fd, syscall_ulong_t offset) */
.section .text.x86.asm32_syscall_int80.mmap
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mmap)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x5a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ebp  /* Arg #5 */
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mmap)
	call   sys_mmap
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_mmap)

/* errno_t munmap(void *addr, size_t len) */
.section .text.x86.asm32_syscall_int80.munmap
INTERN_WEAK_FUNCTION(__x86_asm32_int80_munmap)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x5b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_munmap)
	call   sys_munmap
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_munmap)

/* errno_t truncate(char const *filename, syscall_ulong_t length) */
.section .text.x86.asm32_syscall_int80.truncate
INTERN_WEAK_FUNCTION(__x86_asm32_int80_truncate)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x5c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_truncate)
	call   sys_truncate
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_truncate)

/* errno_t ftruncate(fd_t fd, syscall_ulong_t length) */
.section .text.x86.asm32_syscall_int80.ftruncate
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ftruncate)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x5d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ftruncate)
	call   sys_ftruncate
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_ftruncate)

/* errno_t fchmod(fd_t fd, mode_t mode) */
.section .text.x86.asm32_syscall_int80.fchmod
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fchmod)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x5e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fchmod)
	call   sys_fchmod
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fchmod)

/* errno_t fchown(fd_t fd, uint16_t owner, uint16_t group) */
.section .text.x86.asm32_syscall_int80.fchown
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fchown)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x5f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fchown)
	call   sys_fchown
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fchown)

/* @param: which: One of `PRIO_PROCESS', `PRIO_PGRP' or `PRIO_USER' */
/* syscall_slong_t getpriority(syscall_ulong_t which, id_t who) */
.section .text.x86.asm32_syscall_int80.getpriority
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getpriority)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x60
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getpriority)
	call   sys_getpriority
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getpriority)

/* @param: which: One of `PRIO_PROCESS', `PRIO_PGRP' or `PRIO_USER' */
/* errno_t setpriority(syscall_ulong_t which, id_t who, syscall_ulong_t value) */
.section .text.x86.asm32_syscall_int80.setpriority
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setpriority)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x61
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setpriority)
	call   sys_setpriority
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_setpriority)

/* errno_t profil(void) */
.section .text.x86.asm32_syscall_int80.profil
INTERN_WEAK_FUNCTION(__x86_asm32_int80_profil)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x62
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_profil)
	call   sys_profil
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_profil)

/* errno_t statfs(char const *file, struct statfsx32 *buf) */
.section .text.x86.asm32_syscall_int80.statfs
INTERN_WEAK_FUNCTION(__x86_asm32_int80_statfs)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x63
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_statfs)
	call   sys_statfs
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_statfs)

/* errno_t fstatfs(fd_t file, struct statfsx32 *buf) */
.section .text.x86.asm32_syscall_int80.fstatfs
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fstatfs)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x64
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fstatfs)
	call   sys_fstatfs
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fstatfs)

/* errno_t ioperm(syscall_ulong_t from, syscall_ulong_t num, syscall_ulong_t turn_on) */
.section .text.x86.asm32_syscall_int80.ioperm
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ioperm)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x65
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ioperm)
	call   sys_ioperm
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_ioperm)

/* __LONG32_TYPE__ socketcall(__ULONG32_TYPE__ call, __ULONG32_TYPE__ *args) */
.section .text.x86.asm32_syscall_int80.socketcall
INTERN_WEAK_FUNCTION(__x86_asm32_int80_socketcall)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x66
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_socketcall)
	call   sys_socketcall
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_socketcall)

/* ssize_t syslog(syscall_ulong_t level, char const *str, size_t len) */
.section .text.x86.asm32_syscall_int80.syslog
INTERN_WEAK_FUNCTION(__x86_asm32_int80_syslog)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x67
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_syslog)
	call   sys_syslog
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_syslog)

/* @param: which: One of `ITIMER_REAL', `ITIMER_VIRTUAL' or `ITIMER_PROF' */
/* errno_t setitimer(syscall_ulong_t which, struct __itimervalx32 const *newval, struct __itimervalx32 *oldval) */
.section .text.x86.asm32_syscall_int80.setitimer
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setitimer)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x68
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setitimer)
	call   sys_setitimer
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_setitimer)

/* @param: which: One of `ITIMER_REAL', `ITIMER_VIRTUAL' or `ITIMER_PROF' */
/* errno_t getitimer(syscall_ulong_t which, struct __itimervalx32 *curr_value) */
.section .text.x86.asm32_syscall_int80.getitimer
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getitimer)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x69
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getitimer)
	call   sys_getitimer
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getitimer)

/* errno_t stat(char const *filename, struct linux_statx32 *statbuf) */
.section .text.x86.asm32_syscall_int80.stat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_stat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x6a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_stat)
	call   sys_stat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_stat)

/* errno_t lstat(char const *filename, struct linux_statx32 *statbuf) */
.section .text.x86.asm32_syscall_int80.lstat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_lstat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x6b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_lstat)
	call   sys_lstat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_lstat)

/* errno_t fstat(fd_t fd, struct linux_statx32 *statbuf) */
.section .text.x86.asm32_syscall_int80.fstat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fstat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x6c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fstat)
	call   sys_fstat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fstat)

/* errno_t olduname(struct linux_olduname *name) */
.section .text.x86.asm32_syscall_int80.olduname
INTERN_WEAK_FUNCTION(__x86_asm32_int80_olduname)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x6d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_olduname)
	call   sys_olduname
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_olduname)

/* errno_t iopl(syscall_ulong_t level) */
.section .text.x86.asm32_syscall_int80.iopl
INTERN_WEAK_FUNCTION(__x86_asm32_int80_iopl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x6e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_iopl)
	call   sys_iopl
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_iopl)

/* errno_t vhangup(void) */
.section .text.x86.asm32_syscall_int80.vhangup
INTERN_WEAK_FUNCTION(__x86_asm32_int80_vhangup)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x6f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_vhangup)
	call   sys_vhangup
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_vhangup)

/* errno_t idle(void) */
.section .text.x86.asm32_syscall_int80.idle
INTERN_WEAK_FUNCTION(__x86_asm32_int80_idle)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x70
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_idle)
	call   sys_idle
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_idle)

/* errno_t vm86old(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.vm86old
INTERN_WEAK_FUNCTION(__x86_asm32_int80_vm86old)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x71
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_vm86old)
	call   sys_vm86old
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_vm86old)

/* Same as `waitpid(pid, STAT_LOC, OPTIONS)', though also fills in `USAGE' when non-NULL
 * @param: options: Set of `WNOHANG | WUNTRACED | WCONTINUED' (as a KOS extension, `WNOWAIT' is also accepted) */
/* pid_t wait4(pid_t pid, int32_t *stat_loc, syscall_ulong_t options, struct rusagex32 *usage) */
.section .text.x86.asm32_syscall_int80.wait4
INTERN_WEAK_FUNCTION(__x86_asm32_int80_wait4)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x72
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_wait4)
	call   sys_wait4
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_wait4)

/* errno_t swapoff(char const *pathname) */
.section .text.x86.asm32_syscall_int80.swapoff
INTERN_WEAK_FUNCTION(__x86_asm32_int80_swapoff)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x73
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_swapoff)
	call   sys_swapoff
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_swapoff)

/* errno_t sysinfo(struct __sysinfox32 *info) */
.section .text.x86.asm32_syscall_int80.sysinfo
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sysinfo)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x74
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sysinfo)
	call   sys_sysinfo
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_sysinfo)

/* errno_t ipc(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.ipc
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ipc)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x75
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ipc)
	call   sys_ipc
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_ipc)

/* Synchronize a file (including its descriptor which contains timestamps, and its size),
 * meaning  that  changes   to  its   data  and/or   descriptor  are   written  to   disk */
/* errno_t fsync(fd_t fd) */
.section .text.x86.asm32_syscall_int80.fsync
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fsync)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x76
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fsync)
	call   sys_fsync
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fsync)

/* void sigreturn(void) */
.section .text.x86.asm32_syscall_int80.sigreturn
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sigreturn)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x77
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_sigreturn)
	call   sys_sigreturn
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_sigreturn)

/* pid_t clone(syscall_ulong_t flags, void *child_stack, pid_t *ptid, uintptr_t newtls, pid_t *ctid) */
.section .text.x86.asm32_syscall_int80.clone
INTERN_WEAK_FUNCTION(__x86_asm32_int80_clone)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x78
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_clone)
	call   sys_clone
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_clone)

/* errno_t setdomainname(char const *name, size_t len) */
.section .text.x86.asm32_syscall_int80.setdomainname
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setdomainname)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x79
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setdomainname)
	call   sys_setdomainname
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_setdomainname)

/* errno_t uname(struct utsname *name) */
.section .text.x86.asm32_syscall_int80.uname
INTERN_WEAK_FUNCTION(__x86_asm32_int80_uname)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x7a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_uname)
	call   sys_uname
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_uname)

/* syscall_slong_t modify_ldt(syscall_ulong_t func, void *ptr, syscall_ulong_t bytecount) */
.section .text.x86.asm32_syscall_int80.modify_ldt
INTERN_WEAK_FUNCTION(__x86_asm32_int80_modify_ldt)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x7b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_modify_ldt)
	call   sys_modify_ldt
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_modify_ldt)

/* errno_t adjtimex(struct timex *ntx) */
.section .text.x86.asm32_syscall_int80.adjtimex
INTERN_WEAK_FUNCTION(__x86_asm32_int80_adjtimex)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x7c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_adjtimex)
	call   sys_adjtimex
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_adjtimex)

/* @param: prot: Either `PROT_NONE', or set of `PROT_EXEC | PROT_WRITE | PROT_READ | PROT_SEM | PROT_SHARED' */
/* errno_t mprotect(void *addr, size_t len, syscall_ulong_t prot) */
.section .text.x86.asm32_syscall_int80.mprotect
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mprotect)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x7d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mprotect)
	call   sys_mprotect
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_mprotect)

/* @param: how: One of `SIG_BLOCK', `SIG_UNBLOCK' or `SIG_SETMASK' */
/* errno_t sigprocmask(syscall_ulong_t how, struct __old_sigset_struct const *set, struct __old_sigset_struct *oset) */
.section .text.x86.asm32_syscall_int80.sigprocmask
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sigprocmask)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x7e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sigprocmask)
	call   sys_sigprocmask
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_sigprocmask)

/* errno_t create_module(void) */
.section .text.x86.asm32_syscall_int80.create_module
INTERN_WEAK_FUNCTION(__x86_asm32_int80_create_module)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x7f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_create_module)
	call   sys_create_module
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_create_module)

/* Load a  kernel  driver  from an  ELF  image  `module_image...+=len'
 * This system call exists for linux compatibility, and is implemented
 * as an alias for  `KSYSCTL_DRIVER_INSMOD:KSYSCTL_DRIVER_FORMAT_BLOB'
 * 
 * Note however that that is where linux compatibility ends. Since the
 * linux kernel does not implement any semblance of a stable ABI,  you
 * have to realize that on KOS, this system call can only load drivers
 * specifically built to run within the KOS kernel!
 * @param: uargs: The driver commandline */
/* errno_t init_module(void const *module_image, size_t len, char const *uargs) */
.section .text.x86.asm32_syscall_int80.init_module
INTERN_WEAK_FUNCTION(__x86_asm32_int80_init_module)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x80
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_init_module)
	call   sys_init_module
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_init_module)

/* Try to unload a driver, given its `name'
 * This system call exists for linux compatibility, and is implemented
 * as an alias for  `KSYSCTL_DRIVER_DELMOD:KSYSCTL_DRIVER_FORMAT_FILE'
 * @param: name:  The name of the driver
 * @param: flags: Set of `O_NONBLOCK | O_TRUNC', where:
 *                - O_NONBLOCK: s.a. `KSYSCTL_DRIVER_DELMOD_FNONBLOCK'
 *                - O_TRUNC:    s.a. `KSYSCTL_DRIVER_DELMOD_FFORCE' */
/* errno_t delete_module(char const *name, oflag_t flags) */
.section .text.x86.asm32_syscall_int80.delete_module
INTERN_WEAK_FUNCTION(__x86_asm32_int80_delete_module)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x81
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_delete_module)
	call   sys_delete_module
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_delete_module)

/* errno_t get_kernel_syms(void) */
.section .text.x86.asm32_syscall_int80.get_kernel_syms
INTERN_WEAK_FUNCTION(__x86_asm32_int80_get_kernel_syms)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x82
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_get_kernel_syms)
	call   sys_get_kernel_syms
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_get_kernel_syms)

/* errno_t quotactl(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.quotactl
INTERN_WEAK_FUNCTION(__x86_asm32_int80_quotactl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x83
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_quotactl)
	call   sys_quotactl
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_quotactl)

/* pid_t getpgid(pid_t pid) */
.section .text.x86.asm32_syscall_int80.getpgid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getpgid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x84
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getpgid)
	call   sys_getpgid
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getpgid)

/* errno_t fchdir(fd_t fd) */
.section .text.x86.asm32_syscall_int80.fchdir
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fchdir)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x85
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fchdir)
	call   sys_fchdir
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fchdir)

/* errno_t bdflush(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.bdflush
INTERN_WEAK_FUNCTION(__x86_asm32_int80_bdflush)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x86
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_bdflush)
	call   sys_bdflush
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_bdflush)

/* errno_t sysfs(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.sysfs
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sysfs)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x87
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sysfs)
	call   sys_sysfs
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_sysfs)

/* errno_t personality(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.personality
INTERN_WEAK_FUNCTION(__x86_asm32_int80_personality)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x88
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_personality)
	call   sys_personality
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_personality)

/* errno_t afs_syscall(void) */
.section .text.x86.asm32_syscall_int80.afs_syscall
INTERN_WEAK_FUNCTION(__x86_asm32_int80_afs_syscall)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x89
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_afs_syscall)
	call   sys_afs_syscall
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_afs_syscall)

/* >> setfsuid(2)
 * Set the  user ID  for the  cred-context (s.a.  `CLONE_CRED') of  the
 * calling thread. The calling thread needs the `CAP_SETUID' privilege.
 * @return: 0:  Success.
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setfsuid(uint16_t uid) */
.section .text.x86.asm32_syscall_int80.setfsuid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setfsuid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x8a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setfsuid)
	call   sys_setfsuid
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_setfsuid)

/* >> setfsgid(2)
 * Set the group  ID for  the cred-context (s.a.  `CLONE_CRED') of  the
 * calling thread. The calling thread needs the `CAP_SETGID' privilege.
 * @return: 0:  Success.
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setfsgid(uint16_t gid) */
.section .text.x86.asm32_syscall_int80.setfsgid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setfsgid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x8b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setfsgid)
	call   sys_setfsgid
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_setfsgid)

/* errno_t _llseek(fd_t fd, int64_t offset, uint64_t *result, syscall_ulong_t whence) */
.section .text.x86.asm32_syscall_int80._llseek
INTERN_WEAK_FUNCTION(__x86_asm32_int80__llseek)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x8c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys__llseek)
	call   sys__llseek
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80__llseek)

/* @return: * : The actual number of read entries
 * @return: 0 : End-of-directory */
/* ssize_t getdents(fd_t fd, struct linux_direntx32 *buf, size_t buflen) */
.section .text.x86.asm32_syscall_int80.getdents
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getdents)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x8d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getdents)
	call   sys_getdents
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getdents)

/* ssize_t _newselect(size_t nfds, struct __fd_set_struct *readfds, struct __fd_set_struct *writefds, struct __fd_set_struct *exceptfds, struct timevalx32 *timeout) */
.section .text.x86.asm32_syscall_int80._newselect
INTERN_WEAK_FUNCTION(__x86_asm32_int80__newselect)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x8e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys__newselect)
	call   sys__newselect
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80__newselect)

/* errno_t flock(fd_t fd, syscall_ulong_t operation) */
.section .text.x86.asm32_syscall_int80.flock
INTERN_WEAK_FUNCTION(__x86_asm32_int80_flock)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x8f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_flock)
	call   sys_flock
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_flock)

/* errno_t msync(void *addr, size_t len, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.msync
INTERN_WEAK_FUNCTION(__x86_asm32_int80_msync)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x90
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_msync)
	call   sys_msync
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_msync)

/* Same as `read(2)', but rather than specifying a single, continuous buffer,
 * read  data into `count'  separate buffers, though  still return the actual
 * number of read bytes.
 * When `fd' has the `O_NONBLOCK' flag set, only read as much data as was
 * available at  the time  the call  was made,  and throw  `E_WOULDBLOCK'
 * no data was available at the time.
 * @return: <= SUM(iov[*].iov_len): The actual amount of read bytes
 * @return: 0                     : EOF */
/* ssize_t readv(fd_t fd, struct iovecx32 const *iovec, size_t count) */
.section .text.x86.asm32_syscall_int80.readv
INTERN_WEAK_FUNCTION(__x86_asm32_int80_readv)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x91
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_readv)
	call   sys_readv
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_readv)

/* Same as `write(2)', but rather than specifying a single, continuous buffer,
 * write  data from `count'  separate buffers, though  still return the actual
 * number of written bytes.
 * When  `fd' has the  `O_NONBLOCK' flag set, only  write as much data
 * as possible at the time the call was made, and throw `E_WOULDBLOCK'
 * if no data could be written at the time.
 * @return: <= SUM(iov[*].iov_len): The actual amount of written bytes
 * @return: 0                     : No more data can be written */
/* ssize_t writev(fd_t fd, struct iovecx32 const *iovec, size_t count) */
.section .text.x86.asm32_syscall_int80.writev
INTERN_WEAK_FUNCTION(__x86_asm32_int80_writev)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x92
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_writev)
	call   sys_writev
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_writev)

/* pid_t getsid(pid_t pid) */
.section .text.x86.asm32_syscall_int80.getsid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getsid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x93
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getsid)
	call   sys_getsid
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getsid)

/* Synchronize only the data of a file (not its descriptor which contains
 * timestamps,  and its size),  meaning that changes  are written to disk */
/* errno_t fdatasync(fd_t fd) */
.section .text.x86.asm32_syscall_int80.fdatasync
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fdatasync)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x94
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fdatasync)
	call   sys_fdatasync
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fdatasync)

/* errno_t _sysctl(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80._sysctl
INTERN_WEAK_FUNCTION(__x86_asm32_int80__sysctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x95
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys__sysctl)
	call   sys__sysctl
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80__sysctl)

/* errno_t mlock(void const *addr, size_t len) */
.section .text.x86.asm32_syscall_int80.mlock
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mlock)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x96
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mlock)
	call   sys_mlock
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_mlock)

/* errno_t munlock(void const *addr, size_t len) */
.section .text.x86.asm32_syscall_int80.munlock
INTERN_WEAK_FUNCTION(__x86_asm32_int80_munlock)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x97
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_munlock)
	call   sys_munlock
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_munlock)

/* @param: flags: Set of `MCL_CURRENT | MCL_FUTURE | MCL_ONFAULT' */
/* errno_t mlockall(syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.mlockall
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mlockall)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x98
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mlockall)
	call   sys_mlockall
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_mlockall)

/* errno_t munlockall(void) */
.section .text.x86.asm32_syscall_int80.munlockall
INTERN_WEAK_FUNCTION(__x86_asm32_int80_munlockall)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x99
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_munlockall)
	call   sys_munlockall
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_munlockall)

/* errno_t sched_setparam(pid_t pid, struct sched_param const *param) */
.section .text.x86.asm32_syscall_int80.sched_setparam
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sched_setparam)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x9a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sched_setparam)
	call   sys_sched_setparam
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_sched_setparam)

/* errno_t sched_getparam(pid_t pid, struct sched_param *param) */
.section .text.x86.asm32_syscall_int80.sched_getparam
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sched_getparam)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x9b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sched_getparam)
	call   sys_sched_getparam
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_sched_getparam)

/* @param: policy: One of `SCHED_OTHER', `SCHED_FIFO', `SCHED_RR', `SCHED_BATCH',
 *                 `SCHED_IDLE',  optionally   or'd  with   `SCHED_RESET_ON_FORK' */
/* errno_t sched_setscheduler(pid_t pid, syscall_ulong_t policy, struct sched_param const *param) */
.section .text.x86.asm32_syscall_int80.sched_setscheduler
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sched_setscheduler)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x9c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sched_setscheduler)
	call   sys_sched_setscheduler
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_sched_setscheduler)

/* syscall_slong_t sched_getscheduler(pid_t pid) */
.section .text.x86.asm32_syscall_int80.sched_getscheduler
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sched_getscheduler)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x9d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sched_getscheduler)
	call   sys_sched_getscheduler
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_sched_getscheduler)

/* errno_t sched_yield(void) */
.section .text.x86.asm32_syscall_int80.sched_yield
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sched_yield)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x9e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_sched_yield)
	call   sys_sched_yield
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_sched_yield)

/* syscall_slong_t sched_get_priority_max(syscall_ulong_t algorithm) */
.section .text.x86.asm32_syscall_int80.sched_get_priority_max
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sched_get_priority_max)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x9f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sched_get_priority_max)
	call   sys_sched_get_priority_max
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_sched_get_priority_max)

/* syscall_slong_t sched_get_priority_min(syscall_ulong_t algorithm) */
.section .text.x86.asm32_syscall_int80.sched_get_priority_min
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sched_get_priority_min)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xa0
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sched_get_priority_min)
	call   sys_sched_get_priority_min
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_sched_get_priority_min)

/* errno_t sched_rr_get_interval(pid_t pid, struct timespecx32 *ts) */
.section .text.x86.asm32_syscall_int80.sched_rr_get_interval
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sched_rr_get_interval)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xa1
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sched_rr_get_interval)
	call   sys_sched_rr_get_interval
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_sched_rr_get_interval)

/* errno_t nanosleep(struct timespecx32 const *req, struct timespecx32 *rem) */
.section .text.x86.asm32_syscall_int80.nanosleep
INTERN_WEAK_FUNCTION(__x86_asm32_int80_nanosleep)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xa2
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_nanosleep)
	call   sys_nanosleep
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_nanosleep)

/* @param: flags: Set of `MREMAP_MAYMOVE | MREMAP_FIXED' */
/* void *mremap(void *addr, size_t old_len, size_t new_len, syscall_ulong_t flags, void *new_address) */
.section .text.x86.asm32_syscall_int80.mremap
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mremap)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xa3
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mremap)
	call   sys_mremap
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_mremap)

/* >> setresuid(2)
 * @return: 0 : Success
 * Set the real, effective, and saved UID of the calling thread.
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setresuid(uint16_t ruid, uint16_t euid, uint16_t suid) */
.section .text.x86.asm32_syscall_int80.setresuid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setresuid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xa4
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setresuid)
	call   sys_setresuid
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_setresuid)

/* >> getresuid(2)
 * Get the real, effective, and saved UID of the calling thread.
 * @return: 0 : Success */
/* errno_t getresuid(uint16_t *ruid, uint16_t *euid, uint16_t *suid) */
.section .text.x86.asm32_syscall_int80.getresuid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getresuid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xa5
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getresuid)
	call   sys_getresuid
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getresuid)

/* errno_t vm86(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.vm86
INTERN_WEAK_FUNCTION(__x86_asm32_int80_vm86)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xa6
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_vm86)
	call   sys_vm86
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_vm86)

/* errno_t query_module(void) */
.section .text.x86.asm32_syscall_int80.query_module
INTERN_WEAK_FUNCTION(__x86_asm32_int80_query_module)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xa7
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_query_module)
	call   sys_query_module
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_query_module)

/* ssize_t poll(struct pollfd *fds, size_t nfds, syscall_slong_t timeout) */
.section .text.x86.asm32_syscall_int80.poll
INTERN_WEAK_FUNCTION(__x86_asm32_int80_poll)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xa8
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_poll)
	call   sys_poll
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_poll)

/* errno_t nfsservctl(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.nfsservctl
INTERN_WEAK_FUNCTION(__x86_asm32_int80_nfsservctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xa9
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_nfsservctl)
	call   sys_nfsservctl
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_nfsservctl)

/* >> setresgid(2)
 * Set the real, effective, and saved GID of the calling thread.
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setresgid(uint16_t rgid, uint16_t egid, uint16_t sgid) */
.section .text.x86.asm32_syscall_int80.setresgid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setresgid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xaa
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setresgid)
	call   sys_setresgid
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_setresgid)

/* >> getresgid(2)
 * Get the real, effective, and saved GID of the calling thread.
 * @return: 0 : Success */
/* errno_t getresgid(uint16_t *rgid, uint16_t *egid, uint16_t *sgid) */
.section .text.x86.asm32_syscall_int80.getresgid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getresgid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xab
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getresgid)
	call   sys_getresgid
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getresgid)

/* >> prctl(2)
 * System process control interface. (Linux compatible)
 * @param: command: One of `PR_*' (from <linux/prctl.h>)
 * @param: ... : Up  to 4 additional arguments (dependent on `command')
 *               Note that some control codes  require you to pass  `0'
 *               for  all seemingly "unused" arguments. In these cases,
 *               the documentation for that command includes the number
 *               of unused, but required trailing 0s in its comment.
 * @return: * :  Return value depends on `command' */
/* syscall_slong_t prctl(unsigned int command, syscall_ulong_t arg2, syscall_ulong_t arg3, syscall_ulong_t arg4, syscall_ulong_t arg5) */
.section .text.x86.asm32_syscall_int80.prctl
INTERN_WEAK_FUNCTION(__x86_asm32_int80_prctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xac
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_prctl)
	call   sys_prctl
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_prctl)

/* void rt_sigreturn(void) */
.section .text.x86.asm32_syscall_int80.rt_sigreturn
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rt_sigreturn)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xad
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_rt_sigreturn)
	call   sys_rt_sigreturn
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_rt_sigreturn)

/* errno_t rt_sigaction(signo_t signo, struct __kernel_sigactionx32 const *act, struct __kernel_sigactionx32 *oact, size_t sigsetsize) */
.section .text.x86.asm32_syscall_int80.rt_sigaction
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rt_sigaction)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xae
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_rt_sigaction)
	call   sys_rt_sigaction
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_rt_sigaction)

/* @param: how: One of `SIG_BLOCK', `SIG_UNBLOCK' or `SIG_SETMASK' */
/* errno_t rt_sigprocmask(syscall_ulong_t how, struct __sigset_struct const *set, struct __sigset_struct *oset, size_t sigsetsize) */
.section .text.x86.asm32_syscall_int80.rt_sigprocmask
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rt_sigprocmask)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xaf
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_rt_sigprocmask)
	call   sys_rt_sigprocmask
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_rt_sigprocmask)

/* errno_t rt_sigpending(struct __sigset_struct *set, size_t sigsetsize) */
.section .text.x86.asm32_syscall_int80.rt_sigpending
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rt_sigpending)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xb0
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_rt_sigpending)
	call   sys_rt_sigpending
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_rt_sigpending)

/* syscall_slong_t rt_sigtimedwait(struct __sigset_struct const *set, struct __siginfox32_struct *info, struct timespecx32 const *timeout, size_t sigsetsize) */
.section .text.x86.asm32_syscall_int80.rt_sigtimedwait
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rt_sigtimedwait)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xb1
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_rt_sigtimedwait)
	call   sys_rt_sigtimedwait
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_rt_sigtimedwait)

/* @param: usigno: The signal that should be sent
 * @param: uinfo:  [0..1] Additional signal information
 * @throw: E_INVALID_ARGUMENT_UNEXPECTED_COMMAND:E_INVALID_ARGUMENT_CONTEXT_SIGINFO_SIGNO: [...]
 * @throw: E_INVALID_ARGUMENT_BAD_VALUE:E_INVALID_ARGUMENT_CONTEXT_BAD_SIGNO:              [...]
 * @throw: E_INVALID_ARGUMENT_BAD_VALUE:E_INVALID_ARGUMENT_CONTEXT_RAISE_SIGINFO_BADCODE:  [...]
 * @throw: E_ILLEGAL_OPERATION:                                                            [...] */
/* errno_t rt_sigqueueinfo(pid_t pid, signo_t usigno, struct __siginfox32_struct const *uinfo) */
.section .text.x86.asm32_syscall_int80.rt_sigqueueinfo
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rt_sigqueueinfo)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xb2
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_rt_sigqueueinfo)
	call   sys_rt_sigqueueinfo
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_rt_sigqueueinfo)

/* >> sigsuspend(2), rt_sigsuspend(2)
 * Atomically save and  set the caller's  signal mask to  `set', then wait  for
 * one of the unmasked (iow: `!sigismember')-signals to arrive before restoring
 * the old signal mask.
 * @param: set: The set of signals on which to wait
 * @return: -1: [errno=EINTR] The signal handler for `signo' was executed. */
/* errno_t rt_sigsuspend(struct __sigset_struct const *set, size_t sigsetsize) */
.section .text.x86.asm32_syscall_int80.rt_sigsuspend
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rt_sigsuspend)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xb3
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_rt_sigsuspend)
	call   sys_rt_sigsuspend
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_rt_sigsuspend)

/* ssize_t pread64(fd_t fd, void *buf, size_t bufsize, uint64_t offset) */
.section .text.x86.asm32_syscall_int80.pread64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pread64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xb4
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pread64)
	call   sys_pread64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_pread64)

/* ssize_t pwrite64(fd_t fd, void const *buf, size_t bufsize, uint64_t offset) */
.section .text.x86.asm32_syscall_int80.pwrite64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pwrite64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xb5
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pwrite64)
	call   sys_pwrite64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_pwrite64)

/* errno_t chown(char const *filename, uint16_t owner, uint16_t group) */
.section .text.x86.asm32_syscall_int80.chown
INTERN_WEAK_FUNCTION(__x86_asm32_int80_chown)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xb6
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_chown)
	call   sys_chown
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_chown)

/* ssize_t getcwd(char *buf, size_t size) */
.section .text.x86.asm32_syscall_int80.getcwd
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getcwd)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xb7
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getcwd)
	call   sys_getcwd
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getcwd)

/* errno_t capget(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.capget
INTERN_WEAK_FUNCTION(__x86_asm32_int80_capget)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xb8
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_capget)
	call   sys_capget
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_capget)

/* errno_t capset(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.capset
INTERN_WEAK_FUNCTION(__x86_asm32_int80_capset)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xb9
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_capset)
	call   sys_capset
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_capset)

/* errno_t sigaltstack(struct __sigaltstackx32 const *ss, struct __sigaltstackx32 *oss) */
.section .text.x86.asm32_syscall_int80.sigaltstack
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sigaltstack)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xba
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sigaltstack)
	call   sys_sigaltstack
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_sigaltstack)

/* Read up to `num_bytes' from `infd', and write that data to `outfd'
 * Files must be opened with the relevant access permissions (same as
 * would be enforced by `read(2)' and `write(2)')
 * When `pin_offset != NULL', the pointed-to location is used to track
 * the read-position in `infd'. Note that in the event that writing to
 * this address faults, data may  have still been written to  `outfd',
 * so be sure to have this point to writable memory.
 * @param: outfd:      Output file descriptor
 * @param: infd:       Input file descriptor
 * @param: pin_offset: If non-NULL, position from which to start reading,
 *                     and updated to reflect  how much could be  copied.
 * @param: num_bytes:  The max number of bytes to transfer
 * @return: * :        The actual number of bytes transferred */
/* ssize_t sendfile(fd_t outfd, fd_t infd, __ULONG32_TYPE__ *pin_offset, size_t num_bytes) */
.section .text.x86.asm32_syscall_int80.sendfile
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sendfile)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xbb
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sendfile)
	call   sys_sendfile
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_sendfile)

/* errno_t getpmsg(void) */
.section .text.x86.asm32_syscall_int80.getpmsg
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getpmsg)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xbc
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_getpmsg)
	call   sys_getpmsg
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getpmsg)

/* errno_t putpmsg(void) */
.section .text.x86.asm32_syscall_int80.putpmsg
INTERN_WEAK_FUNCTION(__x86_asm32_int80_putpmsg)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xbd
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_putpmsg)
	call   sys_putpmsg
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_putpmsg)

/* Same as `fork(2)', but the child process may be executed within in the same VM
 * as the parent process, with the  parent process remaining suspended until  the
 * child process invokes one of the following system calls:
 *   - `exit(2)'       Terminate the child process
 *   - `exit_group(2)' Terminate the child process
 *   - `execve(2)'     Create a new VM that is populated with the specified process
 *                     image. The parent process will  only be resumed in case  the
 *                     new  program image could  be loaded successfully. Otherwise,
 *                     the call  to  `execve(2)'  returns normally  in  the  child.
 *                     Other functions from the exec()-family behave the same
 * 
 * Care  must be taken when using this system call, since you have to make sure that
 * the  child process doesn't clobber any part of its (shared) stack that may be re-
 * used once execution resumes in  the parent process. The  same also goes for  heap
 * functions,  but generally speaking:  you really shouldn't  do anything that isn't
 * reentrant after calling any one of the fork() functions (since anything but would
 * rely on underlying implementations making proper use of pthread_atfork(3),  which
 * is something that KOS intentionally doesn't do,  since I feel like doing so  only
 * adds unnecessary bloat to code that doesn't rely on this)
 * 
 * Additionally, this system call may be implemented as an alias for `fork(2)', in
 * which  case the parent process will not  actually get suspended until the child
 * process performs any of the actions above. */
/* pid_t vfork(void) */
.section .text.x86.asm32_syscall_int80.vfork
INTERN_WEAK_FUNCTION(__x86_asm32_int80_vfork)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xbe
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_vfork)
	call   sys_vfork
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_vfork)

/* errno_t ugetrlimit(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.ugetrlimit
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ugetrlimit)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xbf
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ugetrlimit)
	call   sys_ugetrlimit
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_ugetrlimit)

/* void *mmap2(void *addr, size_t len, syscall_ulong_t prot, syscall_ulong_t flags, fd_t fd, syscall_ulong_t pgoffset) */
.section .text.x86.asm32_syscall_int80.mmap2
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mmap2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xc0
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ebp  /* Arg #5 */
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mmap2)
	call   sys_mmap2
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_mmap2)

/* errno_t truncate64(char const *filename, uint64_t length) */
.section .text.x86.asm32_syscall_int80.truncate64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_truncate64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xc1
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_truncate64)
	call   sys_truncate64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_truncate64)

/* errno_t ftruncate64(fd_t fd, uint64_t length) */
.section .text.x86.asm32_syscall_int80.ftruncate64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ftruncate64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xc2
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ftruncate64)
	call   sys_ftruncate64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_ftruncate64)

/* errno_t stat64(char const *filename, struct linux_statx32_64 *statbuf) */
.section .text.x86.asm32_syscall_int80.stat64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_stat64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xc3
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_stat64)
	call   sys_stat64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_stat64)

/* errno_t lstat64(char const *filename, struct linux_statx32_64 *statbuf) */
.section .text.x86.asm32_syscall_int80.lstat64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_lstat64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xc4
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_lstat64)
	call   sys_lstat64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_lstat64)

/* errno_t fstat64(fd_t fd, struct linux_statx32_64 *statbuf) */
.section .text.x86.asm32_syscall_int80.fstat64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fstat64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xc5
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fstat64)
	call   sys_fstat64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fstat64)

/* errno_t lchown32(char const *filename, uint32_t owner, uint32_t group) */
.section .text.x86.asm32_syscall_int80.lchown32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_lchown32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xc6
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_lchown32)
	call   sys_lchown32
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_lchown32)

/* >> getuid(2)
 * @return: * : The UID of the calling thread (this is the so-called ~real~ UID) */
/* uint32_t getuid32(void) */
.section .text.x86.asm32_syscall_int80.getuid32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getuid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xc7
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_getuid32)
	call   sys_getuid32
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getuid32)

/* >> getgid(2)
 * @return: * : The GID of the calling thread (this is the so-called ~real~ GID) */
/* uint32_t getgid32(void) */
.section .text.x86.asm32_syscall_int80.getgid32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getgid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xc8
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_getgid32)
	call   sys_getgid32
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getgid32)

/* >> geteuid(2)
 * @return: * : The   effective  UID  of  the  calling  thread.
 *              This is the one used for most permission checks */
/* uint32_t geteuid32(void) */
.section .text.x86.asm32_syscall_int80.geteuid32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_geteuid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xc9
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_geteuid32)
	call   sys_geteuid32
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_geteuid32)

/* >> getegid(2)
 * @return: * : The   effective  GID  of  the  calling  thread.
 *              This is the one used for most permission checks */
/* uint32_t getegid32(void) */
.section .text.x86.asm32_syscall_int80.getegid32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getegid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xca
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_getegid32)
	call   sys_getegid32
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getegid32)

/* >> setreuid(2)
 * Set the real and effective UID of the calling thread.
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setreuid32(uint32_t ruid, uint32_t euid) */
.section .text.x86.asm32_syscall_int80.setreuid32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setreuid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xcb
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setreuid32)
	call   sys_setreuid32
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_setreuid32)

/* >> setregid(2)
 * Set the real and effective GID of the calling thread.
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setregid32(uint32_t rgid, uint32_t egid) */
.section .text.x86.asm32_syscall_int80.setregid32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setregid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xcc
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setregid32)
	call   sys_setregid32
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_setregid32)

/* @return: * :     [count == 0] The required number of groups
 * @return: * :     [count != 0] The number of groups that were actually returned
 * @throw: -EINVAL: [count != 0] There are more than `count' groups (NOTE: No exception is thrown for this case!) */
/* ssize_t getgroups32(size_t count, uint32_t[] list) */
.section .text.x86.asm32_syscall_int80.getgroups32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getgroups32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xcd
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getgroups32)
	call   sys_getgroups32
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getgroups32)

/* errno_t setgroups32(size_t count, uint32_t const *groups) */
.section .text.x86.asm32_syscall_int80.setgroups32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setgroups32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xce
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setgroups32)
	call   sys_setgroups32
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_setgroups32)

/* errno_t fchown32(fd_t fd, uint32_t owner, uint32_t group) */
.section .text.x86.asm32_syscall_int80.fchown32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fchown32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xcf
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fchown32)
	call   sys_fchown32
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fchown32)

/* >> setresuid(2)
 * @return: 0 : Success
 * Set the real, effective, and saved UID of the calling thread.
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setresuid32(uint32_t ruid, uint32_t euid, uint32_t suid) */
.section .text.x86.asm32_syscall_int80.setresuid32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setresuid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xd0
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setresuid32)
	call   sys_setresuid32
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_setresuid32)

/* >> getresuid(2)
 * Get the real, effective, and saved UID of the calling thread.
 * @return: 0 : Success */
/* errno_t getresuid32(uint32_t *ruid, uint32_t *euid, uint32_t *suid) */
.section .text.x86.asm32_syscall_int80.getresuid32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getresuid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xd1
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getresuid32)
	call   sys_getresuid32
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getresuid32)

/* >> setresgid(2)
 * Set the real, effective, and saved GID of the calling thread.
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setresgid32(uint32_t rgid, uint32_t egid, uint32_t sgid) */
.section .text.x86.asm32_syscall_int80.setresgid32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setresgid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xd2
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setresgid32)
	call   sys_setresgid32
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_setresgid32)

/* >> getresgid(2)
 * Get the real, effective, and saved GID of the calling thread.
 * @return: 0 : Success */
/* errno_t getresgid32(uint32_t *rgid, uint32_t *egid, uint32_t *sgid) */
.section .text.x86.asm32_syscall_int80.getresgid32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getresgid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xd3
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getresgid32)
	call   sys_getresgid32
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getresgid32)

/* errno_t chown32(char const *filename, uint32_t owner, uint32_t group) */
.section .text.x86.asm32_syscall_int80.chown32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_chown32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xd4
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_chown32)
	call   sys_chown32
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_chown32)

/* >> setuid(2)
 * Set the UID of the calling thread (this is the so-called ~real~ UID)
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setuid32(uint32_t uid) */
.section .text.x86.asm32_syscall_int80.setuid32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setuid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xd5
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setuid32)
	call   sys_setuid32
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_setuid32)

/* >> setgid(2)
 * Set the GID of the calling thread (this is the so-called ~real~ GID)
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setgid32(uint32_t gid) */
.section .text.x86.asm32_syscall_int80.setgid32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setgid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xd6
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setgid32)
	call   sys_setgid32
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_setgid32)

/* >> setfsuid(2)
 * Set the  user ID  for the  cred-context (s.a.  `CLONE_CRED') of  the
 * calling thread. The calling thread needs the `CAP_SETUID' privilege.
 * @return: 0:  Success.
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setfsuid32(uint32_t uid) */
.section .text.x86.asm32_syscall_int80.setfsuid32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setfsuid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xd7
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setfsuid32)
	call   sys_setfsuid32
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_setfsuid32)

/* >> setfsgid(2)
 * Set the group  ID for  the cred-context (s.a.  `CLONE_CRED') of  the
 * calling thread. The calling thread needs the `CAP_SETGID' privilege.
 * @return: 0:  Success.
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setfsgid32(uint32_t gid) */
.section .text.x86.asm32_syscall_int80.setfsgid32
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setfsgid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xd8
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setfsgid32)
	call   sys_setfsgid32
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_setfsgid32)

/* errno_t pivot_root(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.pivot_root
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pivot_root)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xd9
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pivot_root)
	call   sys_pivot_root
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_pivot_root)

/* errno_t mincore(void *start, size_t len, uint8_t *vec) */
.section .text.x86.asm32_syscall_int80.mincore
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mincore)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xda
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mincore)
	call   sys_mincore
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_mincore)

/* errno_t madvise(void *addr, size_t len, syscall_ulong_t advice) */
.section .text.x86.asm32_syscall_int80.madvise
INTERN_WEAK_FUNCTION(__x86_asm32_int80_madvise)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xdb
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_madvise)
	call   sys_madvise
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_madvise)

/* @return: * : The actual number of read entries
 * @return: 0 : End-of-directory */
/* ssize_t getdents64(fd_t fd, struct linux_dirent64 *buf, size_t buflen) */
.section .text.x86.asm32_syscall_int80.getdents64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getdents64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xdc
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getdents64)
	call   sys_getdents64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getdents64)

/* syscall_slong_t fcntl64(fd_t fd, fcntl_t command, void *arg) */
.section .text.x86.asm32_syscall_int80.fcntl64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fcntl64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xdd
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fcntl64)
	call   sys_fcntl64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fcntl64)

/* pid_t gettid(void) */
.section .text.x86.asm32_syscall_int80.gettid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_gettid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xe0
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_gettid)
	call   sys_gettid
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_gettid)

/* ssize_t readahead(fd_t fd, uint64_t offset, size_t count) */
.section .text.x86.asm32_syscall_int80.readahead
INTERN_WEAK_FUNCTION(__x86_asm32_int80_readahead)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xe1
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_readahead)
	call   sys_readahead
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_readahead)

/* @param: flags: One of `0', `XATTR_CREATE' or `XATTR_REPLACE' */
/* errno_t setxattr(char const *path, char const *name, void const *buf, size_t bufsize, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.setxattr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xe2
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setxattr)
	call   sys_setxattr
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_setxattr)

/* @param: flags: One of `0', `XATTR_CREATE' or `XATTR_REPLACE' */
/* errno_t lsetxattr(char const *path, char const *name, void const *buf, size_t bufsize, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.lsetxattr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_lsetxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xe3
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_lsetxattr)
	call   sys_lsetxattr
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_lsetxattr)

/* @param: flags: One of `0', `XATTR_CREATE' or `XATTR_REPLACE' */
/* errno_t fsetxattr(fd_t fd, char const *name, void const *buf, size_t bufsize, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.fsetxattr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fsetxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xe4
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fsetxattr)
	call   sys_fsetxattr
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fsetxattr)

/* ssize_t getxattr(char const *path, char const *name, void *buf, size_t bufsize) */
.section .text.x86.asm32_syscall_int80.getxattr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xe5
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getxattr)
	call   sys_getxattr
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getxattr)

/* ssize_t lgetxattr(char const *path, char const *name, void *buf, size_t bufsize) */
.section .text.x86.asm32_syscall_int80.lgetxattr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_lgetxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xe6
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_lgetxattr)
	call   sys_lgetxattr
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_lgetxattr)

/* ssize_t fgetxattr(fd_t fd, char const *name, void *buf, size_t bufsize) */
.section .text.x86.asm32_syscall_int80.fgetxattr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fgetxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xe7
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fgetxattr)
	call   sys_fgetxattr
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fgetxattr)

/* ssize_t listxattr(char const *path, char *listbuf, size_t listbufsize) */
.section .text.x86.asm32_syscall_int80.listxattr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_listxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xe8
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_listxattr)
	call   sys_listxattr
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_listxattr)

/* ssize_t llistxattr(char const *path, char *listbuf, size_t listbufsize) */
.section .text.x86.asm32_syscall_int80.llistxattr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_llistxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xe9
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_llistxattr)
	call   sys_llistxattr
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_llistxattr)

/* ssize_t flistxattr(fd_t fd, char *listbuf, size_t listbufsize) */
.section .text.x86.asm32_syscall_int80.flistxattr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_flistxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xea
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_flistxattr)
	call   sys_flistxattr
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_flistxattr)

/* errno_t removexattr(char const *path, char const *name) */
.section .text.x86.asm32_syscall_int80.removexattr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_removexattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xeb
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_removexattr)
	call   sys_removexattr
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_removexattr)

/* errno_t lremovexattr(char const *path, char const *name) */
.section .text.x86.asm32_syscall_int80.lremovexattr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_lremovexattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xec
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_lremovexattr)
	call   sys_lremovexattr
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_lremovexattr)

/* errno_t fremovexattr(fd_t fd, char const *name) */
.section .text.x86.asm32_syscall_int80.fremovexattr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fremovexattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xed
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fremovexattr)
	call   sys_fremovexattr
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fremovexattr)

/* errno_t tkill(pid_t tid, signo_t signo) */
.section .text.x86.asm32_syscall_int80.tkill
INTERN_WEAK_FUNCTION(__x86_asm32_int80_tkill)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xee
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_tkill)
	call   sys_tkill
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_tkill)

/* Read up to `num_bytes' from `infd', and write that data to `outfd'
 * Files must be opened with the relevant access permissions (same as
 * would be enforced by `read(2)' and `write(2)')
 * When `pin_offset != NULL', the pointed-to location is used to track
 * the read-position in `infd'. Note that in the event that writing to
 * this address faults, data may  have still been written to  `outfd',
 * so be sure to have this point to writable memory.
 * @param: outfd:      Output file descriptor
 * @param: infd:       Input file descriptor
 * @param: pin_offset: If non-NULL, position from which to start reading,
 *                     and updated to reflect  how much could be  copied.
 * @param: num_bytes:  The max number of bytes to transfer
 * @return: * :        The actual number of bytes transferred */
/* ssize_t sendfile64(fd_t outfd, fd_t infd, __ULONG64_TYPE__ *pin_offset, size_t num_bytes) */
.section .text.x86.asm32_syscall_int80.sendfile64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sendfile64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xef
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sendfile64)
	call   sys_sendfile64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_sendfile64)

/* @param: futex_op: One of `FUTEX_*' from <linux/futex.h> */
/* syscall_slong_t futex(uint32_t *uaddr, syscall_ulong_t futex_op, uint32_t val, struct timespecx32 const *timeout_or_val2, uint32_t *uaddr2, uint32_t val3) */
.section .text.x86.asm32_syscall_int80.futex
INTERN_WEAK_FUNCTION(__x86_asm32_int80_futex)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xf0
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ebp  /* Arg #5 */
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_futex)
	call   sys_futex
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_futex)

/* errno_t sched_setaffinity(pid_t pid, size_t cpusetsize, struct __cpu_set_struct const *cpuset) */
.section .text.x86.asm32_syscall_int80.sched_setaffinity
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sched_setaffinity)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xf1
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sched_setaffinity)
	call   sys_sched_setaffinity
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_sched_setaffinity)

/* errno_t sched_getaffinity(pid_t pid, size_t cpusetsize, struct __cpu_set_struct *cpuset) */
.section .text.x86.asm32_syscall_int80.sched_getaffinity
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sched_getaffinity)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xf2
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sched_getaffinity)
	call   sys_sched_getaffinity
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_sched_getaffinity)

/* errno_t set_thread_area(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.set_thread_area
INTERN_WEAK_FUNCTION(__x86_asm32_int80_set_thread_area)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xf3
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_set_thread_area)
	call   sys_set_thread_area
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_set_thread_area)

/* errno_t get_thread_area(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.get_thread_area
INTERN_WEAK_FUNCTION(__x86_asm32_int80_get_thread_area)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xf4
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_get_thread_area)
	call   sys_get_thread_area
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_get_thread_area)

/* errno_t io_setup(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.io_setup
INTERN_WEAK_FUNCTION(__x86_asm32_int80_io_setup)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xf5
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_io_setup)
	call   sys_io_setup
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_io_setup)

/* errno_t io_destroy(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.io_destroy
INTERN_WEAK_FUNCTION(__x86_asm32_int80_io_destroy)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xf6
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_io_destroy)
	call   sys_io_destroy
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_io_destroy)

/* errno_t io_getevents(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.io_getevents
INTERN_WEAK_FUNCTION(__x86_asm32_int80_io_getevents)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xf7
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_io_getevents)
	call   sys_io_getevents
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_io_getevents)

/* errno_t io_submit(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.io_submit
INTERN_WEAK_FUNCTION(__x86_asm32_int80_io_submit)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xf8
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_io_submit)
	call   sys_io_submit
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_io_submit)

/* errno_t io_cancel(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.io_cancel
INTERN_WEAK_FUNCTION(__x86_asm32_int80_io_cancel)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xf9
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_io_cancel)
	call   sys_io_cancel
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_io_cancel)

/* errno_t fadvise64(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.fadvise64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fadvise64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfa
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fadvise64)
	call   sys_fadvise64
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fadvise64)

/* Terminate the calling process
 * @param: exit_code: Thread exit code (as returned by `wait(2)') */
/* void exit_group(syscall_ulong_t exit_code) */
.section .text.x86.asm32_syscall_int80.exit_group
INTERN_WEAK_FUNCTION(__x86_asm32_int80_exit_group)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfc
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_exit_group)
	call   sys_exit_group
	.cfi_endproc
END(__x86_asm32_int80_exit_group)

/* errno_t lookup_dcookie(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.lookup_dcookie
INTERN_WEAK_FUNCTION(__x86_asm32_int80_lookup_dcookie)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfd
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_lookup_dcookie)
	call   sys_lookup_dcookie
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_lookup_dcookie)

/* >> epoll_create(2)
 * Deprecated alias for `epoll_create1(0)' (the `size' argument is ignored)
 * @return: * : The newly created epoll control descriptor.
 * @return: -1: Error (s.a. `errno') */
/* fd_t epoll_create(syscall_ulong_t size) */
.section .text.x86.asm32_syscall_int80.epoll_create
INTERN_WEAK_FUNCTION(__x86_asm32_int80_epoll_create)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfe
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_epoll_create)
	call   sys_epoll_create
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_epoll_create)

/* >> epoll_ctl(2)
 * Manipulate a given  epoll controller  `epfd', as previously  returned by  `epoll_create1(2)'
 * in order to register (`EPOLL_CTL_ADD'), remove (`EPOLL_CTL_DEL') or modify (`EPOLL_CTL_MOD')
 * the file descriptors being monitored
 * @param: op:       One of `EPOLL_CTL_ADD', `EPOLL_CTL_DEL' or `EPOLL_CTL_MOD'
 * @param: fd:       The file descriptor to add/remove/modify
 * @param: info:     The new configuration for `fd' (ignored when `op' is `EPOLL_CTL_DEL')
 * @return: 0 :      Success
 * @return: -EEXIST: [op=EPOLL_CTL_ADD] The given `fd' (and its kernel object) has already been registered
 * @return: -ENOENT: [op=EPOLL_CTL_MOD|EPOLL_CTL_DEL] The given `fd' (and its kernel object) aren't registered
 * @throw: E_ILLEGAL_REFERENCE_LOOP: The  given  `fd'  is  another  epoll  that either
 *                                   forms a loop with `epfd', or has too many nested.
 * @throw: E_INVALID_ARGUMENT_UNKNOWN_COMMAND:E_INVALID_ARGUMENT_CONTEXT_EPOLL_CTL_OP: [...] */
/* errno_t epoll_ctl(fd_t epfd, syscall_ulong_t op, fd_t fd, struct epoll_event *info) */
.section .text.x86.asm32_syscall_int80.epoll_ctl
INTERN_WEAK_FUNCTION(__x86_asm32_int80_epoll_ctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xff
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_epoll_ctl)
	call   sys_epoll_ctl
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_epoll_ctl)

/* >> epoll_wait(2)
 * Wait until at least one of the conditions monitored by `epfd' to be met.
 * @param: epfd:      The epoll controller on which to wait.
 * @param: events:    A buffer where the kernel can store information on the
 *                    events that actually took place.
 * @param: maxevents: The # of events that can be stored in `events' (must be >= 1)
 * @param: timeout:   The max amount of time (in milliseconds) before  returning
 *                    in the case where no event occurred in the mean time. When
 *                    set to `-1', wait indefinitely
 * @return: >= 1:     The # of events that happened (written to the first `return'
 *                    items of `events')
 * @return: 0:        No events happened before `timeout' expired.
 * @return: -1:       Error (s.a. `errno') */
/* ssize_t epoll_wait(fd_t epfd, struct epoll_event *events, size_t maxevents, syscall_slong_t timeout) */
.section .text.x86.asm32_syscall_int80.epoll_wait
INTERN_WEAK_FUNCTION(__x86_asm32_int80_epoll_wait)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x100
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_epoll_wait)
	call   sys_epoll_wait
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_epoll_wait)

/* errno_t remap_file_pages(void *start, size_t size, syscall_ulong_t prot, size_t pgoff, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.remap_file_pages
INTERN_WEAK_FUNCTION(__x86_asm32_int80_remap_file_pages)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x101
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_remap_file_pages)
	call   sys_remap_file_pages
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_remap_file_pages)

/* pid_t set_tid_address(pid_t *tidptr) */
.section .text.x86.asm32_syscall_int80.set_tid_address
INTERN_WEAK_FUNCTION(__x86_asm32_int80_set_tid_address)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x102
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_set_tid_address)
	call   sys_set_tid_address
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_set_tid_address)

/* errno_t timer_create(clockid_t clock_id, struct sigevent *evp, timer_t *timerid) */
.section .text.x86.asm32_syscall_int80.timer_create
INTERN_WEAK_FUNCTION(__x86_asm32_int80_timer_create)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x103
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_timer_create)
	call   sys_timer_create
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_timer_create)

/* @param: flags: Set of `0 | TIMER_ABSTIME' */
/* errno_t timer_settime(timer_t timerid, syscall_ulong_t flags, struct itimerspecx32 const *value, struct itimerspecx32 *ovalue) */
.section .text.x86.asm32_syscall_int80.timer_settime
INTERN_WEAK_FUNCTION(__x86_asm32_int80_timer_settime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x104
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_timer_settime)
	call   sys_timer_settime
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_timer_settime)

/* errno_t timer_gettime(timer_t timerid, struct itimerspecx32 *value) */
.section .text.x86.asm32_syscall_int80.timer_gettime
INTERN_WEAK_FUNCTION(__x86_asm32_int80_timer_gettime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x105
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_timer_gettime)
	call   sys_timer_gettime
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_timer_gettime)

/* syscall_slong_t timer_getoverrun(timer_t timerid) */
.section .text.x86.asm32_syscall_int80.timer_getoverrun
INTERN_WEAK_FUNCTION(__x86_asm32_int80_timer_getoverrun)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x106
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_timer_getoverrun)
	call   sys_timer_getoverrun
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_timer_getoverrun)

/* errno_t timer_delete(timer_t timerid) */
.section .text.x86.asm32_syscall_int80.timer_delete
INTERN_WEAK_FUNCTION(__x86_asm32_int80_timer_delete)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x107
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_timer_delete)
	call   sys_timer_delete
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_timer_delete)

/* errno_t clock_settime(clockid_t clock_id, struct timespecx32 const *tp) */
.section .text.x86.asm32_syscall_int80.clock_settime
INTERN_WEAK_FUNCTION(__x86_asm32_int80_clock_settime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x108
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_clock_settime)
	call   sys_clock_settime
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_clock_settime)

/* errno_t clock_gettime(clockid_t clock_id, struct timespecx32 *tp) */
.section .text.x86.asm32_syscall_int80.clock_gettime
INTERN_WEAK_FUNCTION(__x86_asm32_int80_clock_gettime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x109
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_clock_gettime)
	call   sys_clock_gettime
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_clock_gettime)

/* errno_t clock_getres(clockid_t clock_id, struct timespecx32 *res) */
.section .text.x86.asm32_syscall_int80.clock_getres
INTERN_WEAK_FUNCTION(__x86_asm32_int80_clock_getres)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x10a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_clock_getres)
	call   sys_clock_getres
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_clock_getres)

/* errno_t clock_nanosleep(clockid_t clock_id, syscall_ulong_t flags, struct timespecx32 const *requested_time, struct timespecx32 *remaining) */
.section .text.x86.asm32_syscall_int80.clock_nanosleep
INTERN_WEAK_FUNCTION(__x86_asm32_int80_clock_nanosleep)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x10b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_clock_nanosleep)
	call   sys_clock_nanosleep
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_clock_nanosleep)

/* errno_t statfs64(char const *file, struct statfsx32_64 *buf) */
.section .text.x86.asm32_syscall_int80.statfs64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_statfs64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x10c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_statfs64)
	call   sys_statfs64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_statfs64)

/* errno_t fstatfs64(fd_t file, struct statfsx32_64 *buf) */
.section .text.x86.asm32_syscall_int80.fstatfs64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fstatfs64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x10d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fstatfs64)
	call   sys_fstatfs64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fstatfs64)

/* errno_t tgkill(pid_t pid, pid_t tid, signo_t signo) */
.section .text.x86.asm32_syscall_int80.tgkill
INTERN_WEAK_FUNCTION(__x86_asm32_int80_tgkill)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x10e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_tgkill)
	call   sys_tgkill
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_tgkill)

/* @param: times:    When NULL, set the current time
 * @param: times[0]: New access time
 * @param: times[1]: New last-modified time */
/* errno_t utimes(char const *filename, struct timevalx32 const[2] times) */
.section .text.x86.asm32_syscall_int80.utimes
INTERN_WEAK_FUNCTION(__x86_asm32_int80_utimes)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x10f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_utimes)
	call   sys_utimes
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_utimes)

/* errno_t fadvise64_64(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.fadvise64_64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fadvise64_64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x110
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fadvise64_64)
	call   sys_fadvise64_64
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fadvise64_64)

/* errno_t vserver(void) */
.section .text.x86.asm32_syscall_int80.vserver
INTERN_WEAK_FUNCTION(__x86_asm32_int80_vserver)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x111
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_vserver)
	call   sys_vserver
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_vserver)

/* errno_t mbind(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.mbind
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mbind)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x112
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mbind)
	call   sys_mbind
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_mbind)

/* errno_t get_mempolicy(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.get_mempolicy
INTERN_WEAK_FUNCTION(__x86_asm32_int80_get_mempolicy)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x113
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_get_mempolicy)
	call   sys_get_mempolicy
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_get_mempolicy)

/* errno_t set_mempolicy(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.set_mempolicy
INTERN_WEAK_FUNCTION(__x86_asm32_int80_set_mempolicy)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x114
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_set_mempolicy)
	call   sys_set_mempolicy
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_set_mempolicy)

/* fd_t mq_open(char const *name, oflag_t oflags, mode_t mode) */
.section .text.x86.asm32_syscall_int80.mq_open
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mq_open)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x115
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mq_open)
	call   sys_mq_open
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_mq_open)

/* errno_t mq_unlink(char const *name) */
.section .text.x86.asm32_syscall_int80.mq_unlink
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mq_unlink)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x116
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mq_unlink)
	call   sys_mq_unlink
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_mq_unlink)

/* errno_t mq_timedsend(fd_t mqdes, char const *msg_ptr, size_t msg_len, uint32_t msg_prio, struct timespecx32 const *abs_timeout) */
.section .text.x86.asm32_syscall_int80.mq_timedsend
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mq_timedsend)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x117
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mq_timedsend)
	call   sys_mq_timedsend
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_mq_timedsend)

/* ssize_t mq_timedreceive(fd_t mqdes, char *msg_ptr, size_t msg_len, uint32_t *pmsg_prio, struct timespecx32 const *abs_timeout) */
.section .text.x86.asm32_syscall_int80.mq_timedreceive
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mq_timedreceive)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x118
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mq_timedreceive)
	call   sys_mq_timedreceive
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_mq_timedreceive)

/* errno_t mq_notify(fd_t mqdes, struct sigevent const *notification) */
.section .text.x86.asm32_syscall_int80.mq_notify
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mq_notify)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x119
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mq_notify)
	call   sys_mq_notify
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_mq_notify)

/* errno_t mq_getsetattr(fd_t mqdes, struct mq_attr const *newattr, struct mq_attr *oldattr) */
.section .text.x86.asm32_syscall_int80.mq_getsetattr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mq_getsetattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x11a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mq_getsetattr)
	call   sys_mq_getsetattr
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_mq_getsetattr)

/* errno_t kexec_load(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.kexec_load
INTERN_WEAK_FUNCTION(__x86_asm32_int80_kexec_load)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x11b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_kexec_load)
	call   sys_kexec_load
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_kexec_load)

/* @param: idtype:  One of `P_ALL', `P_PID', `P_PGID'
 * @param: options: At least one of `WEXITED', `WSTOPPED', `WCONTINUED', optionally or'd with `WNOHANG | WNOWAIT' */
/* errno_t waitid(syscall_ulong_t idtype, id_t id, struct __siginfox32_struct *infop, syscall_ulong_t options, struct rusagex32 *ru) */
.section .text.x86.asm32_syscall_int80.waitid
INTERN_WEAK_FUNCTION(__x86_asm32_int80_waitid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x11c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_waitid)
	call   sys_waitid
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_waitid)

/* errno_t add_key(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.add_key
INTERN_WEAK_FUNCTION(__x86_asm32_int80_add_key)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x11e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_add_key)
	call   sys_add_key
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_add_key)

/* errno_t request_key(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.request_key
INTERN_WEAK_FUNCTION(__x86_asm32_int80_request_key)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x11f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_request_key)
	call   sys_request_key
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_request_key)

/* errno_t keyctl(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.keyctl
INTERN_WEAK_FUNCTION(__x86_asm32_int80_keyctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x120
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_keyctl)
	call   sys_keyctl
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_keyctl)

/* NOTE: Linux calls `who' `which', and `id' `who' (refactored to prevent confusion)
 * @param: who: One of `IOPRIO_WHO_PROCESS', `IOPRIO_WHO_PGRP' or `IOPRIO_WHO_USER' */
/* errno_t ioprio_set(syscall_ulong_t who, syscall_ulong_t id, syscall_ulong_t ioprio) */
.section .text.x86.asm32_syscall_int80.ioprio_set
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ioprio_set)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x121
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ioprio_set)
	call   sys_ioprio_set
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_ioprio_set)

/* NOTE: Linux calls `who' `which', and `id' `who' (refactored to prevent confusion)
 * @param: who: One of `IOPRIO_WHO_PROCESS', `IOPRIO_WHO_PGRP' or `IOPRIO_WHO_USER' */
/* syscall_slong_t ioprio_get(syscall_ulong_t who, syscall_ulong_t id) */
.section .text.x86.asm32_syscall_int80.ioprio_get
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ioprio_get)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x122
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ioprio_get)
	call   sys_ioprio_get
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_ioprio_get)

/* fd_t inotify_init(void) */
.section .text.x86.asm32_syscall_int80.inotify_init
INTERN_WEAK_FUNCTION(__x86_asm32_int80_inotify_init)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x123
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_inotify_init)
	call   sys_inotify_init
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_inotify_init)

/* @param: mask: Set of `IN_ALL_EVENTS | ...' */
/* int inotify_add_watch(fd_t notify_fd, char const *pathname, uint32_t mask) */
.section .text.x86.asm32_syscall_int80.inotify_add_watch
INTERN_WEAK_FUNCTION(__x86_asm32_int80_inotify_add_watch)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x124
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_inotify_add_watch)
	call   sys_inotify_add_watch
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_inotify_add_watch)

/* @param: wd: Watch fd (as returned by `inotify_add_watch{_at}') */
/* errno_t inotify_rm_watch(fd_t notify_fd, int wd) */
.section .text.x86.asm32_syscall_int80.inotify_rm_watch
INTERN_WEAK_FUNCTION(__x86_asm32_int80_inotify_rm_watch)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x125
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_inotify_rm_watch)
	call   sys_inotify_rm_watch
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_inotify_rm_watch)

/* errno_t migrate_pages(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.migrate_pages
INTERN_WEAK_FUNCTION(__x86_asm32_int80_migrate_pages)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x126
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_migrate_pages)
	call   sys_migrate_pages
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_migrate_pages)

/* Open  a  new  file  handle  to  the  file  specified  by `filename'
 * When  `oflags & O_CREAT',   then  `mode'   specifies  the   initial
 * file  access  permissions with  which  the file  should  be opened.
 * On KOS, the returned handle can be anything, but is usually one of:
 *   - HANDLE_TYPE_PATH:       When `O_PATH' was given
 *   - HANDLE_TYPE_FILEHANDLE: For `S_IFREG' regular files
 *   - HANDLE_TYPE_FIFOHANDLE: For `S_IFIFO' pipe files
 *   - HANDLE_TYPE_DIRHANDLE:  For `S_IFDIR' directories
 *   - HANDLE_TYPE_MFILE:      The actual filesystem object (including device files)
 *   - *:                      Certain filesystem names can literally return anything, such
 *                             as `/proc/self/fd/1234',  which  is  more  like  `dup(1234)' */
/* fd_t openat(fd_t dirfd, char const *filename, oflag_t oflags, mode_t mode) */
.section .text.x86.asm32_syscall_int80.openat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_openat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x127
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_openat)
	call   sys_openat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_openat)

/* errno_t mkdirat(fd_t dirfd, char const *pathname, mode_t mode) */
.section .text.x86.asm32_syscall_int80.mkdirat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mkdirat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x128
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mkdirat)
	call   sys_mkdirat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_mkdirat)

/* errno_t mknodat(fd_t dirfd, char const *nodename, mode_t mode, dev_t dev) */
.section .text.x86.asm32_syscall_int80.mknodat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mknodat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x129
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mknodat)
	call   sys_mknodat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_mknodat)

/* @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_DOSPATH' */
/* errno_t fchownat(fd_t dirfd, char const *filename, uid_t owner, gid_t group, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.fchownat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fchownat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x12a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fchownat)
	call   sys_fchownat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fchownat)

/* errno_t futimesat(fd_t dirfd, char const *filename, struct timevalx32 const[2] times) */
.section .text.x86.asm32_syscall_int80.futimesat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_futimesat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x12b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_futimesat)
	call   sys_futimesat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_futimesat)

/* @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_DOSPATH' */
/* errno_t fstatat64(fd_t dirfd, char const *filename, struct linux_statx32_64 *statbuf, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.fstatat64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fstatat64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x12c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fstatat64)
	call   sys_fstatat64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fstatat64)

/* @param: flags: Set of `0 | AT_REMOVEDIR | AT_REMOVEREG | AT_DOSPATH' */
/* errno_t unlinkat(fd_t dirfd, char const *name, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.unlinkat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_unlinkat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x12d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_unlinkat)
	call   sys_unlinkat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_unlinkat)

/* errno_t renameat(fd_t oldfd, char const *oldname, fd_t newfd, char const *newname_or_path) */
.section .text.x86.asm32_syscall_int80.renameat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_renameat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x12e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_renameat)
	call   sys_renameat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_renameat)

/* @param: flags: Set of `0 | AT_EMPTY_PATH | AT_SYMLINK_FOLLOW | AT_DOSPATH' */
/* errno_t linkat(fd_t fromfd, char const *existing_file, fd_t tofd, char const *target_path, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.linkat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_linkat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x12f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_linkat)
	call   sys_linkat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_linkat)

/* errno_t symlinkat(char const *link_text, fd_t tofd, char const *target_path) */
.section .text.x86.asm32_syscall_int80.symlinkat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_symlinkat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x130
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_symlinkat)
	call   sys_symlinkat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_symlinkat)

/* ssize_t readlinkat(fd_t dirfd, char const *path, char *buf, size_t buflen) */
.section .text.x86.asm32_syscall_int80.readlinkat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_readlinkat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x131
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_readlinkat)
	call   sys_readlinkat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_readlinkat)

/* @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_DOSPATH' */
/* errno_t fchmodat(fd_t dirfd, char const *filename, mode_t mode, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.fchmodat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fchmodat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x132
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fchmodat)
	call   sys_fchmodat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fchmodat)

/* @param: type: Set of `R_OK | W_OK | X_OK' or `F_OK' */
/* errno_t faccessat(fd_t dirfd, char const *filename, syscall_ulong_t type) */
.section .text.x86.asm32_syscall_int80.faccessat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_faccessat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x133
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_faccessat)
	call   sys_faccessat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_faccessat)

/* ssize_t pselect6(size_t nfds, struct __fd_set_struct *readfds, struct __fd_set_struct *writefds, struct __fd_set_struct *exceptfds, struct timespecx32 const *timeout, struct __sigset_with_sizex32 const *sigmask_sigset_with_size) */
.section .text.x86.asm32_syscall_int80.pselect6
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pselect6)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x134
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ebp  /* Arg #5 */
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pselect6)
	call   sys_pselect6
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_pselect6)

/* ssize_t ppoll(struct pollfd *fds, size_t nfds, struct timespecx32 const *timeout_ts, struct __sigset_struct const *sigmask, size_t sigsetsize) */
.section .text.x86.asm32_syscall_int80.ppoll
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ppoll)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x135
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ppoll)
	call   sys_ppoll
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_ppoll)

/* param: what: Set of `CLONE_*' */
/* errno_t unshare(syscall_ulong_t what) */
.section .text.x86.asm32_syscall_int80.unshare
INTERN_WEAK_FUNCTION(__x86_asm32_int80_unshare)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x136
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_unshare)
	call   sys_unshare
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_unshare)

/* errno_t set_robust_list(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.set_robust_list
INTERN_WEAK_FUNCTION(__x86_asm32_int80_set_robust_list)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x137
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_set_robust_list)
	call   sys_set_robust_list
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_set_robust_list)

/* errno_t get_robust_list(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.get_robust_list
INTERN_WEAK_FUNCTION(__x86_asm32_int80_get_robust_list)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x138
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_get_robust_list)
	call   sys_get_robust_list
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_get_robust_list)

/* @param: flags: Set of `SPLICE_F_MOVE | SPLICE_F_NONBLOCK | SPLICE_F_MORE | SPLICE_F_GIFT' */
/* ssize_t splice(fd_t fdin, uint64_t *offin, fd_t fdout, uint64_t *offout, size_t length, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.splice
INTERN_WEAK_FUNCTION(__x86_asm32_int80_splice)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x139
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ebp  /* Arg #5 */
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_splice)
	call   sys_splice
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_splice)

/* @param: flags: Set of `SYNC_FILE_RANGE_WAIT_BEFORE | SYNC_FILE_RANGE_WRITE | SYNC_FILE_RANGE_WAIT_AFTER' */
/* errno_t sync_file_range(fd_t fd, uint64_t offset, uint64_t count, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.sync_file_range
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sync_file_range)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x13a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ebp  /* Arg #5 */
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sync_file_range)
	call   sys_sync_file_range
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_sync_file_range)

/* @param: flags: Set of `SPLICE_F_MOVE | SPLICE_F_NONBLOCK | SPLICE_F_MORE | SPLICE_F_GIFT' */
/* ssize_t tee(fd_t fdin, fd_t fdout, size_t length, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.tee
INTERN_WEAK_FUNCTION(__x86_asm32_int80_tee)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x13b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_tee)
	call   sys_tee
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_tee)

/* @param: flags: Set of `SPLICE_F_MOVE | SPLICE_F_NONBLOCK | SPLICE_F_MORE | SPLICE_F_GIFT' */
/* ssize_t vmsplice(fd_t fdout, struct iovecx32 const *iov, size_t count, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.vmsplice
INTERN_WEAK_FUNCTION(__x86_asm32_int80_vmsplice)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x13c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_vmsplice)
	call   sys_vmsplice
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_vmsplice)

/* errno_t move_pages(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.move_pages
INTERN_WEAK_FUNCTION(__x86_asm32_int80_move_pages)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x13d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_move_pages)
	call   sys_move_pages
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_move_pages)

/* errno_t getcpu(uint32_t *cpu, uint32_t *node, struct getcpu_cache *tcache) */
.section .text.x86.asm32_syscall_int80.getcpu
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getcpu)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x13e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getcpu)
	call   sys_getcpu
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getcpu)

/* >> epoll_pwait(2)
 * Same as `epoll_wait(2)', but change the calling thread's signal mask to `ss' while
 * waiting.  Wait until at least one of the conditions monitored by `epfd' to be met.
 * @param: epfd:      The epoll controller on which to wait.
 * @param: events:    A buffer where the kernel can store information on the
 *                    events that actually took place.
 * @param: maxevents: The # of events that can be stored in `events' (must be >= 1)
 * @param: timeout:   The max amount of time (in milliseconds) before  returning
 *                    in the case where no event occurred in the mean time. When
 *                    set to `-1', wait indefinitely
 * @param: ss:        The signal mask to apply while waiting for an event to happen.
 * @return: >= 1:     The # of events that happened (written to the first `return'
 *                    items of `events')
 * @return: 0:        No events happened before `timeout' expired.
 * @return: -1:       Error (s.a. `errno') */
/* ssize_t epoll_pwait(fd_t epfd, struct epoll_event *events, size_t maxevents, syscall_slong_t timeout, struct __sigset_struct const *ss, size_t sigsetsize) */
.section .text.x86.asm32_syscall_int80.epoll_pwait
INTERN_WEAK_FUNCTION(__x86_asm32_int80_epoll_pwait)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x13f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ebp  /* Arg #5 */
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_epoll_pwait)
	call   sys_epoll_pwait
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_epoll_pwait)

/* @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_CHANGE_BTIME | AT_DOSPATH' */
/* errno_t utimensat(fd_t dirfd, char const *filename, struct timespecx32 const[2] times, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.utimensat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_utimensat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x140
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_utimensat)
	call   sys_utimensat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_utimensat)

/* Create a poll(2)-able file descriptor which can be used to wait for the
 * delivery of signals masked by `sigmask' to the waiting  thread/process. */
/* errno_t signalfd(fd_t fd, struct __sigset_struct const *sigmask, size_t sigmasksize) */
.section .text.x86.asm32_syscall_int80.signalfd
INTERN_WEAK_FUNCTION(__x86_asm32_int80_signalfd)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x141
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_signalfd)
	call   sys_signalfd
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_signalfd)

/* Return file descriptor for new interval timer source
 * @param: flags: Set of `0 | TFD_NONBLOCK | TFD_CLOEXEC | TFD_CLOFORK' */
/* fd_t timerfd_create(clockid_t clock_id, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.timerfd_create
INTERN_WEAK_FUNCTION(__x86_asm32_int80_timerfd_create)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x142
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_timerfd_create)
	call   sys_timerfd_create
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_timerfd_create)

/* fd_t eventfd(syscall_ulong_t initval) */
.section .text.x86.asm32_syscall_int80.eventfd
INTERN_WEAK_FUNCTION(__x86_asm32_int80_eventfd)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x143
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_eventfd)
	call   sys_eventfd
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_eventfd)

/* @param: mode: Set of `0 | FALLOC_FL_KEEP_SIZE | FALLOC_FL_PUNCH_HOLE | FALLOC_FL_COLLAPSE_RANGE | FALLOC_FL_ZERO_RANGE' */
/* errno_t fallocate(fd_t fd, syscall_ulong_t mode, syscall_ulong_t offset, syscall_ulong_t length) */
.section .text.x86.asm32_syscall_int80.fallocate
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fallocate)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x144
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fallocate)
	call   sys_fallocate
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fallocate)

/* Set next expiration time of interval timer source `timerfd' to `utmr'.
 * If `flags'  has the  `TFD_TIMER_ABSTIME' flag  set the  timeout  value
 * is absolute. Optionally return the old expiration time in `otmr'
 * @param: flags: Set of `0 | TFD_TIMER_ABSTIME' */
/* errno_t timerfd_settime(fd_t timerfd, syscall_ulong_t flags, struct itimerspecx32 const *utmr, struct itimerspecx32 *otmr) */
.section .text.x86.asm32_syscall_int80.timerfd_settime
INTERN_WEAK_FUNCTION(__x86_asm32_int80_timerfd_settime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x145
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_timerfd_settime)
	call   sys_timerfd_settime
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_timerfd_settime)

/* Return the next expiration time of UFD */
/* errno_t timerfd_gettime(fd_t timerfd, struct itimerspecx32 *otmr) */
.section .text.x86.asm32_syscall_int80.timerfd_gettime
INTERN_WEAK_FUNCTION(__x86_asm32_int80_timerfd_gettime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x146
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_timerfd_gettime)
	call   sys_timerfd_gettime
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_timerfd_gettime)

/* Create a poll(2)-able file descriptor which can be used to wait for the
 * delivery of signals masked by `sigmask' to the waiting  thread/process.
 * @param: flags: Set of `0 | SFD_NONBLOCK | SFD_CLOEXEC | SFD_CLOFORK' */
/* errno_t signalfd4(fd_t fd, struct __sigset_struct const *sigmask, size_t sigmasksize, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.signalfd4
INTERN_WEAK_FUNCTION(__x86_asm32_int80_signalfd4)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x147
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_signalfd4)
	call   sys_signalfd4
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_signalfd4)

/* @param: flags: Set of `EFD_SEMAPHORE | EFD_NONBLOCK | EFD_CLOEXEC | EFD_CLOFORK' */
/* fd_t eventfd2(syscall_ulong_t initval, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.eventfd2
INTERN_WEAK_FUNCTION(__x86_asm32_int80_eventfd2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x148
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_eventfd2)
	call   sys_eventfd2
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_eventfd2)

/* >> epoll_create1(2)
 * Create  a new epoll control descriptor which can be used for
 * monitoring of pollable events happening in registered files.
 * @param: flags: Set of `EPOLL_CLOEXEC | EPOLL_CLOFORK'
 * @return: * :   The newly created epoll control descriptor.
 * @throw: E_INVALID_ARGUMENT_UNKNOWN_FLAG:E_INVALID_ARGUMENT_CONTEXT_EPOLL_CREATE1_FLAGS: [...] */
/* fd_t epoll_create1(syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.epoll_create1
INTERN_WEAK_FUNCTION(__x86_asm32_int80_epoll_create1)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x149
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_epoll_create1)
	call   sys_epoll_create1
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_epoll_create1)

/* @param: flags:  Set of `O_CLOEXEC | O_CLOFORK' */
/* fd_t dup3(fd_t oldfd, fd_t newfd, oflag_t flags) */
.section .text.x86.asm32_syscall_int80.dup3
INTERN_WEAK_FUNCTION(__x86_asm32_int80_dup3)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x14a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_dup3)
	call   sys_dup3
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_dup3)

/* errno_t pipe2(fd_t[2] pipedes, oflag_t flags) */
.section .text.x86.asm32_syscall_int80.pipe2
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pipe2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x14b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pipe2)
	call   sys_pipe2
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_pipe2)

/* @param: flags: Set of `IN_NONBLOCK | IN_CLOEXEC | IN_CLOFORK' */
/* fd_t inotify_init1(syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.inotify_init1
INTERN_WEAK_FUNCTION(__x86_asm32_int80_inotify_init1)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x14c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_inotify_init1)
	call   sys_inotify_init1
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_inotify_init1)

/* Same as  `readv(2)', but  read data  from a  file at  a
 * specific `offset', rather than the current R/W position
 * @return: <= SUM(iov[*].iov_len): The actual amount of read bytes */
/* ssize_t preadv(fd_t fd, struct iovecx32 const *iovec, size_t count, uint64_t offset) */
.section .text.x86.asm32_syscall_int80.preadv
INTERN_WEAK_FUNCTION(__x86_asm32_int80_preadv)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x14d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_preadv)
	call   sys_preadv
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_preadv)

/* Same as  `writev(2)', but  write data  to a  file at  a
 * specific `offset', rather than the current R/W position
 * @return: <= SUM(iov[*].iov_len): The actual amount of written bytes */
/* ssize_t pwritev(fd_t fd, struct iovecx32 const *iovec, size_t count, uint64_t offset) */
.section .text.x86.asm32_syscall_int80.pwritev
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pwritev)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x14e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pwritev)
	call   sys_pwritev
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_pwritev)

/* @param: usigno: The signal that should be sent
 * @param: uinfo:  [0..1] Additional signal information
 * @throw: E_INVALID_ARGUMENT_UNEXPECTED_COMMAND:E_INVALID_ARGUMENT_CONTEXT_SIGINFO_SIGNO: [...]
 * @throw: E_INVALID_ARGUMENT_BAD_VALUE:E_INVALID_ARGUMENT_CONTEXT_BAD_SIGNO:              [...]
 * @throw: E_INVALID_ARGUMENT_BAD_VALUE:E_INVALID_ARGUMENT_CONTEXT_RAISE_SIGINFO_BADCODE:  [...]
 * @throw: E_ILLEGAL_OPERATION:                                                            [...] */
/* errno_t rt_tgsigqueueinfo(pid_t pid, pid_t tid, signo_t usigno, struct __siginfox32_struct const *uinfo) */
.section .text.x86.asm32_syscall_int80.rt_tgsigqueueinfo
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rt_tgsigqueueinfo)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x14f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_rt_tgsigqueueinfo)
	call   sys_rt_tgsigqueueinfo
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_rt_tgsigqueueinfo)

/* errno_t perf_event_open(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.perf_event_open
INTERN_WEAK_FUNCTION(__x86_asm32_int80_perf_event_open)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x150
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_perf_event_open)
	call   sys_perf_event_open
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_perf_event_open)

/* Same as `recvmsg(2)', but may be used to receive many
 * messages  (datagrams)  with  a  single  system  call.
 * @param: msg_flags: Set of `MSG_CMSG_CLOEXEC | MSG_CMSG_CLOFORK |
 *                            MSG_DONTWAIT | MSG_ERRQUEUE | MSG_OOB |
 *                            MSG_PEEK  |  MSG_TRUNC |  MSG_WAITALL |
 *                            MSG_WAITFORONE'
 * @throw: Error (s.a. `recvmsg(2)')
 * @return: * : The # of datagrams successfully received. */
/* ssize_t recvmmsg(fd_t sockfd, struct mmsghdrx32 *vmessages, size_t vlen, syscall_ulong_t msg_flags, struct timespecx32 const *tmo) */
.section .text.x86.asm32_syscall_int80.recvmmsg
INTERN_WEAK_FUNCTION(__x86_asm32_int80_recvmmsg)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x151
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_recvmmsg)
	call   sys_recvmmsg
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_recvmmsg)

/* errno_t fanotify_init(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.fanotify_init
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fanotify_init)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x152
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fanotify_init)
	call   sys_fanotify_init
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fanotify_init)

/* errno_t fanotify_mark(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.fanotify_mark
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fanotify_mark)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x153
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fanotify_mark)
	call   sys_fanotify_mark
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fanotify_mark)

/* @param: resource: One of `RLIMIT_*' from <sys/resource.h> */
/* errno_t prlimit64(pid_t pid, syscall_ulong_t resource, struct rlimitx32_64 const *new_limit, struct rlimitx32_64 *old_limit) */
.section .text.x86.asm32_syscall_int80.prlimit64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_prlimit64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x154
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_prlimit64)
	call   sys_prlimit64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_prlimit64)

/* @param: flags: Set of `0 | AT_EMPTY_PATH | AT_SYMLINK_FOLLOW | AT_DOSPATH' */
/* errno_t name_to_handle_at(fd_t dirfd, char const *filename, struct file_handle *handle, int32_t *mnt_id, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.name_to_handle_at
INTERN_WEAK_FUNCTION(__x86_asm32_int80_name_to_handle_at)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x155
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_name_to_handle_at)
	call   sys_name_to_handle_at
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_name_to_handle_at)

/* fd_t open_by_handle_at(fd_t mountdirfd, struct file_handle const *handle, oflag_t flags) */
.section .text.x86.asm32_syscall_int80.open_by_handle_at
INTERN_WEAK_FUNCTION(__x86_asm32_int80_open_by_handle_at)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x156
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_open_by_handle_at)
	call   sys_open_by_handle_at
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_open_by_handle_at)

/* errno_t clock_adjtime(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.clock_adjtime
INTERN_WEAK_FUNCTION(__x86_asm32_int80_clock_adjtime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x157
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_clock_adjtime)
	call   sys_clock_adjtime
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_clock_adjtime)

/* errno_t syncfs(fd_t fd) */
.section .text.x86.asm32_syscall_int80.syncfs
INTERN_WEAK_FUNCTION(__x86_asm32_int80_syncfs)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x158
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_syncfs)
	call   sys_syncfs
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_syncfs)

/* Same as `sendmsg(2)', but may be used to send many
 * messages (datagrams)  with a  single system  call.
 * @param: msg_flags: Set of `MSG_CONFIRM | MSG_DONTROUTE | MSG_DONTWAIT |
 *                            MSG_EOR | MSG_MORE | MSG_NOSIGNAL | MSG_OOB'
 * @throw: ... Same as `sendmsg(2)'
 * @return: * : The # of datagrams successfully sent. */
/* ssize_t sendmmsg(fd_t sockfd, struct mmsghdrx32 *vmessages, size_t vlen, syscall_ulong_t msg_flags) */
.section .text.x86.asm32_syscall_int80.sendmmsg
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sendmmsg)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x159
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sendmmsg)
	call   sys_sendmmsg
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_sendmmsg)

/* errno_t setns(fd_t fd, syscall_ulong_t nstype) */
.section .text.x86.asm32_syscall_int80.setns
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setns)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x15a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setns)
	call   sys_setns
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_setns)

/* Read memory from another process's VM
 * @param: flags: Must be `0'
 * @return: * :   The actual number of read bytes */
/* ssize_t process_vm_readv(pid_t pid, struct iovecx32 const *local_iov, size_t liovcnt, struct iovecx32 const *remote_iov, size_t riovcnt, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.process_vm_readv
INTERN_WEAK_FUNCTION(__x86_asm32_int80_process_vm_readv)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x15b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ebp  /* Arg #5 */
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_process_vm_readv)
	call   sys_process_vm_readv
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_process_vm_readv)

/* Write memory to another process's VM
 * @param: flags: Must be `0'
 * @return: * :   The actual number of written bytes */
/* ssize_t process_vm_writev(pid_t pid, struct iovecx32 const *local_iov, size_t liovcnt, struct iovecx32 const *remote_iov, size_t riovcnt, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.process_vm_writev
INTERN_WEAK_FUNCTION(__x86_asm32_int80_process_vm_writev)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x15c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ebp  /* Arg #5 */
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_process_vm_writev)
	call   sys_process_vm_writev
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_process_vm_writev)

/* @param: type: One of  `KCMP_FILE',  `KCMP_FILES',  `KCMP_FS',  `KCMP_IO',
 *               `KCMP_SIGHAND', `KCMP_SYSVSEM', `KCMP_VM', `KCMP_EPOLL_TFD' */
/* syscall_slong_t kcmp(pid_t pid1, pid_t pid2, syscall_ulong_t type, syscall_ulong_t idx1, syscall_ulong_t idx2) */
.section .text.x86.asm32_syscall_int80.kcmp
INTERN_WEAK_FUNCTION(__x86_asm32_int80_kcmp)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x15d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_kcmp)
	call   sys_kcmp
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_kcmp)

/* Load a  kernel  driver  from an  ELF  image  `module_image...+=len'
 * This system call exists for linux compatibility, and is implemented
 * as an alias for  `KSYSCTL_DRIVER_INSMOD:KSYSCTL_DRIVER_FORMAT_FILE'
 * 
 * Note however that that is where linux compatibility ends. Since the
 * linux kernel does not implement any semblance of a stable ABI,  you
 * have to realize that on KOS, this system call can only load drivers
 * specifically built to run within the KOS kernel!
 * @param: uargs: The driver commandline */
/* errno_t finit_module(fd_t fd, char const *uargs, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.finit_module
INTERN_WEAK_FUNCTION(__x86_asm32_int80_finit_module)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x15e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_finit_module)
	call   sys_finit_module
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_finit_module)

/* errno_t sched_setattr(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.sched_setattr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sched_setattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x15f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sched_setattr)
	call   sys_sched_setattr
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_sched_setattr)

/* errno_t sched_getattr(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.sched_getattr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sched_getattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x160
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sched_getattr)
	call   sys_sched_getattr
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_sched_getattr)

/* @param: flags: Set of `0 | AT_RENAME_NOREPLACE | AT_RENAME_EXCHANGE | AT_RENAME_WHITEOUT | AT_RENAME_MOVETODIR | AT_DOSPATH' */
/* errno_t renameat2(fd_t olddirfd, char const *oldpath, fd_t newdirfd, char const *newpath, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.renameat2
INTERN_WEAK_FUNCTION(__x86_asm32_int80_renameat2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x161
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_renameat2)
	call   sys_renameat2
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_renameat2)

/* errno_t seccomp(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.seccomp
INTERN_WEAK_FUNCTION(__x86_asm32_int80_seccomp)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x162
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_seccomp)
	call   sys_seccomp
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_seccomp)

/* @param: flags: Set of `0 | GRND_RANDOM | GRND_NONBLOCK' */
/* ssize_t getrandom(void *buf, size_t num_bytes, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.getrandom
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getrandom)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x163
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getrandom)
	call   sys_getrandom
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getrandom)

/* @param: flags: Set of `MFD_CLOEXEC | MFD_CLOFORK | MFD_ALLOW_SEALING | MFD_HUGETLB' */
/* fd_t memfd_create(char const *name, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.memfd_create
INTERN_WEAK_FUNCTION(__x86_asm32_int80_memfd_create)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x164
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_memfd_create)
	call   sys_memfd_create
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_memfd_create)

/* errno_t bpf(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.bpf
INTERN_WEAK_FUNCTION(__x86_asm32_int80_bpf)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x165
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_bpf)
	call   sys_bpf
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_bpf)

/* Replace the calling  process with  the application  image referred  to by  `path' /  `file'
 * and execute it's `main()' method, passing the given `argv', and setting `environ' to `envp'
 * @param: flags: Set of `0 | AT_EMPTY_PATH | AT_SYMLINK_NOFOLLOW | AT_DOSPATH' */
/* errno_t execveat(fd_t dirfd, char const *pathname, __HYBRID_PTR32(char const) const *argv, __HYBRID_PTR32(char const) const *envp, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.execveat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_execveat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x166
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_execveat)
	call   sys_execveat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_execveat)

/* Create a new socket for the given domain/type/protocol triple.
 * @param: domain:   Socket address domain/family (one of `AF_*' from `<sys/socket.h>')
 * @param: type:     Socket type (one of `SOCK_*' from `<sys/socket.h>')
 *                   May optionally be or'd with `SOCK_CLOEXEC | SOCK_CLOFORK | SOCK_NONBLOCK'
 * @param: protocol: Socket protocol (`0' for automatic). Available socket protocols mainly
 *                   depend on the selected `domain', and may be further specialized by the
 *                   `type' argument.  for  example,  `AF_INET' takes  one  of  `IPPROTO_*'
 *                   >> socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
 *                   Also note that protocol IDs can be enumerated by `getprotoent(3)' from `<netdb.h>'
 * @return: * : A file descriptor for the newly created socket. */
/* fd_t socket(syscall_ulong_t domain, syscall_ulong_t type, syscall_ulong_t protocol) */
.section .text.x86.asm32_syscall_int80.socket
INTERN_WEAK_FUNCTION(__x86_asm32_int80_socket)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x167
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_socket)
	call   sys_socket
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_socket)

/* Create a new socket for the given domain/type/protocol triple.
 * @param: domain:   Socket address domain/family (one of `AF_*' from `<sys/socket.h>')
 * @param: type:     Socket type (one of `SOCK_*' from `<sys/socket.h>')
 *                   May optionally be or'd with `SOCK_CLOEXEC | SOCK_CLOFORK | SOCK_NONBLOCK'
 * @param: protocol: Socket protocol (`0' for automatic). Available socket protocols mainly
 *                   depend on the selected `domain', and may be further specialized by the
 *                   `type' argument.  for  example,  `AF_INET' takes  one  of  `IPPROTO_*'
 *                   >> socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
 *                   Also note that protocol IDs can be enumerated by `getprotoent(3)' from `<netdb.h>'
 * @return: * : A file descriptor for the newly created socket. */
/* errno_t socketpair(syscall_ulong_t domain, syscall_ulong_t type, syscall_ulong_t protocol, fd_t[2] fds) */
.section .text.x86.asm32_syscall_int80.socketpair
INTERN_WEAK_FUNCTION(__x86_asm32_int80_socketpair)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x168
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_socketpair)
	call   sys_socketpair
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_socketpair)

/* Bind the given socket `sockfd' to the specified local address.
 * @throw: E_NET_ADDRESS_IN_USE:E_NET_ADDRESS_IN_USE_CONTEXT_CONNECT
 * @throw: E_INVALID_ARGUMENT_UNEXPECTED_COMMAND:E_INVALID_ARGUMENT_CONTEXT_BIND_WRONG_ADDRESS_FAMILY
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_BIND_ALREADY_BOUND
 * @throw: E_NET_ADDRESS_NOT_AVAILABLE
 * @throw: E_BUFFER_TOO_SMALL   (`addr_len' is incorrect)
 * @return: 0 : Success */
/* errno_t bind(fd_t sockfd, struct sockaddr const *addr, socklen_t addr_len) */
.section .text.x86.asm32_syscall_int80.bind
INTERN_WEAK_FUNCTION(__x86_asm32_int80_bind)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x169
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_bind)
	call   sys_bind
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_bind)

/* Connect to the specified address.
 * If the given `sockfd' isn't connection-oriented, this will set the address
 * that  will implicitly be  used as destination  by `send(2)' and `write(2)'
 * @throw: E_NET_ADDRESS_IN_USE:E_NET_ADDRESS_IN_USE_CONTEXT_CONNECT
 * @throw: E_INVALID_ARGUMENT_UNEXPECTED_COMMAND:E_INVALID_ARGUMENT_CONTEXT_BIND_WRONG_ADDRESS_FAMILY
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_BIND_ALREADY_BOUND
 * @throw: E_NET_ADDRESS_NOT_AVAILABLE
 * @throw: E_NET_CONNECTION_REFUSED
 * @throw: E_BUFFER_TOO_SMALL   (addr_len is incorrect)
 * @return: 0 : Success */
/* errno_t connect(fd_t sockfd, struct sockaddr const *addr, socklen_t addr_len) */
.section .text.x86.asm32_syscall_int80.connect
INTERN_WEAK_FUNCTION(__x86_asm32_int80_connect)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x16a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_connect)
	call   sys_connect
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_connect)

/* Begin to listen for incoming client (aka. peer) connection requests.
 * @param: max_backlog: The max number of clients  pending to be accept(2)-ed,  before
 *                      the kernel will refuse to enqueue additional clients, and will
 *                      instead automatically refuse  any further  requests until  the
 *                      less than `max_backlog' clients are still pending.
 * @throw: E_NET_ADDRESS_IN_USE:E_NET_ADDRESS_IN_USE_CONTEXT_LISTEN
 * @throw: E_INVALID_HANDLE_NET_OPERATION:E_NET_OPERATION_LISTEN
 * @return: 0 : Success */
/* errno_t listen(fd_t sockfd, syscall_ulong_t max_backlog) */
.section .text.x86.asm32_syscall_int80.listen
INTERN_WEAK_FUNCTION(__x86_asm32_int80_listen)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x16b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_listen)
	call   sys_listen
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_listen)

/* Accept incoming client (aka. peer) connection requests.
 * @param: addr:       Peer address of the sender (or `NULL' when `addr_len' is `NULL')
 * @param: addr_len:   [NULL] Don't fill in the client's peer address
 *                     [in]   The amount of available memory starting at `addr'
 *                     [out]  The  amount  of required  memory for  the address.
 *                            This  may be  more than  was given,  in which case
 *                            the  address  was  truncated and  may  be invalid.
 *                            If this happens,  the caller  can still  determine
 *                            the correct address through use of `getpeername()'
 * @param: sock_flags: Set of `SOCK_NONBLOCK | SOCK_CLOEXEC | SOCK_CLOFORK'
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_ACCEPT_NOT_LISTENING
 * @throw: E_INVALID_HANDLE_NET_OPERATION:E_NET_OPERATION_ACCEPT
 * @throw: E_NET_CONNECTION_ABORT
 * @return: * : A file descriptor for the newly accept(2)-ed connection */
/* fd_t accept4(fd_t sockfd, struct sockaddr *addr, socklen_t *addr_len, syscall_ulong_t sock_flags) */
.section .text.x86.asm32_syscall_int80.accept4
INTERN_WEAK_FUNCTION(__x86_asm32_int80_accept4)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x16c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_accept4)
	call   sys_accept4
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_accept4)

/* Get the value of the named socket option `level:optname' and store it in `optval'
 * @param: level:   One of `SOL_*' (e.g.: `SOL_SOCKET')
 * @param: optname: Dependent on `level'
 * @param: optval:  Buffer for where to write the value of the socket option.
 * @param: optlen:  [in]  The amount of available memory starting at `optval'
 *                  [out] The amount of required memory for the option value.
 *                        This may be more than was given, in which case
 *                        the  contents  of   `optval'  are   undefined.
 * @throw: E_INVALID_ARGUMENT_SOCKET_OPT:E_INVALID_ARGUMENT_CONTEXT_GETSOCKOPT
 * @return: 0 : Success */
/* errno_t getsockopt(fd_t sockfd, syscall_ulong_t level, syscall_ulong_t optname, void *optval, socklen_t *optlen) */
.section .text.x86.asm32_syscall_int80.getsockopt
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getsockopt)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x16d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getsockopt)
	call   sys_getsockopt
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getsockopt)

/* Set the value of the named socket option `level:optname' from what is given in `optval'
 * @param: level:   One of `SOL_*' (e.g.: `SOL_SOCKET')
 * @param: optname: Dependent on `level'
 * @param: optval:  Buffer for where to write the value of the socket option.
 * @param: optlen:  The amount of available memory starting at `optval'
 * @throw: E_INVALID_ARGUMENT_SOCKET_OPT:E_INVALID_ARGUMENT_CONTEXT_SETSOCKOPT
 * @throw: E_BUFFER_TOO_SMALL  (The specified `optlen' is invalid for the given option)
 * @return: 0 : Success */
/* errno_t setsockopt(fd_t sockfd, syscall_ulong_t level, syscall_ulong_t optname, void const *optval, socklen_t optlen) */
.section .text.x86.asm32_syscall_int80.setsockopt
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setsockopt)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x16e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setsockopt)
	call   sys_setsockopt
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_setsockopt)

/* Determine the local address (aka. name) for the given socket `sockfd'.
 * This  is usually the  same address as was  previously set by `bind(2)'
 * NOTE: Before the socket has actually be bound or connected, the exact
 *       address that is returned by this function is weakly  undefined.
 *       e.g.: For AF_INET, sin_addr=0.0.0.0, sin_port=0 is returned.
 * @param: addr:     [out] Buffer where to store the sock address.
 * @param: addr_len: [in]  The amount of available memory starting at `addr'
 *                   [out] The amount of required memory for the address.
 *                         This may be more than was given, in which case
 *                         the  address was truncated and may be invalid.
 * return: 0 : Success */
/* errno_t getsockname(fd_t sockfd, struct sockaddr *addr, socklen_t *addr_len) */
.section .text.x86.asm32_syscall_int80.getsockname
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getsockname)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x16f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getsockname)
	call   sys_getsockname
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getsockname)

/* Lookup the peer (remote) address of `sockfd' and store it in `*addr...+=*addr_len'
 * @param: addr:     [out] Buffer where to store the sock address.
 * @param: addr_len: [in]  The amount of available memory starting at `addr'
 *                   [out] The amount of required memory for the address.
 *                         This may be more than was given, in which case
 *                         the  address was truncated and may be invalid.
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_GETPEERNAME_NOT_CONNECTED
 * @return: 0 : Success */
/* errno_t getpeername(fd_t sockfd, struct sockaddr *addr, socklen_t *addr_len) */
.section .text.x86.asm32_syscall_int80.getpeername
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getpeername)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x170
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getpeername)
	call   sys_getpeername
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getpeername)

/* Send the contents of a given buffer over this socket to the specified address
 * @param: buf:       Buffer of data to send (with a length of `bufsize' bytes)
 * @param: bufsize:   Size of `buf' (in bytes)
 * @param: msg_flags: Set of `MSG_CONFIRM | MSG_DONTROUTE | MSG_DONTWAIT |
 *                            MSG_EOR | MSG_MORE | MSG_NOSIGNAL | MSG_OOB'
 * @param: addr:      Address where to send data (or NULL when `addr_len' is 0)
 * @param: addr_len:  Size of `addr', or `0' to have this behave as an alias
 *                    for            `send(sockfd, buf, bufsize, msg_flags)'
 * @throw: E_INVALID_ARGUMENT_UNEXPECTED_COMMAND:E_INVALID_ARGUMENT_CONTEXT_SENDTO_WRONG_ADDRESS_FAMILY
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_SEND_NOT_CONNECTED
 * @throw: E_NET_MESSAGE_TOO_LONG
 * @throw: E_NET_CONNECTION_RESET
 * @throw: E_NET_SHUTDOWN
 * @throw: E_BUFFER_TOO_SMALL  (`addr_len' is incorrect)
 * @return: * : [<= bufsize] The actual # of send bytes */
/* ssize_t sendto(fd_t sockfd, void const *buf, size_t bufsize, syscall_ulong_t msg_flags, struct sockaddr const *addr, socklen_t addr_len) */
.section .text.x86.asm32_syscall_int80.sendto
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sendto)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x171
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ebp  /* Arg #5 */
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sendto)
	call   sys_sendto
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_sendto)

/* Same as `send(2)' and `sendto(2)', but also allows for sending ancillary
 * data as well as  for data buffers  to be represented  by an IOV  vector.
 * @param: msg_flags: Set of `MSG_CONFIRM | MSG_DONTROUTE | MSG_DONTWAIT |
 *                            MSG_EOR | MSG_MORE | MSG_NOSIGNAL | MSG_OOB'
 * @throw: ... Same as for `send(2)' and `sendto(2)'
 * @return: * : [<= bufsize] The actual # of send payload bytes */
/* ssize_t sendmsg(fd_t sockfd, struct msghdrx32 const *message, syscall_ulong_t msg_flags) */
.section .text.x86.asm32_syscall_int80.sendmsg
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sendmsg)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x172
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sendmsg)
	call   sys_sendmsg
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_sendmsg)

/* Receive data over this socket, and store the contents within the given buffer.
 * @param: buf:       Buffer to-be filled with up to `bufsize' bytes of received data
 * @param: bufsize:   Max # of bytes to receive
 * @param: msg_flags: Set of `MSG_DONTWAIT | MSG_ERRQUEUE | MSG_OOB |
 *                            MSG_PEEK | MSG_TRUNC | MSG_WAITALL'
 * @param: addr:      Peer address of the sender (or `NULL' when `addr_len' is `NULL')
 * @param: addr_len:  [NULL] behave as an alias for `recv(sockfd, buf, bufsize, msg_flags)'
 *                    [in]   The amount of available memory starting at `addr'
 *                    [out]  The amount of required memory for the address.
 *                           This may be more than was given, in which case
 *                           the address was truncated and may be invalid.
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_RECV_NOT_CONNECTED
 * @throw: E_NET_CONNECTION_REFUSED
 * @throw: E_WOULDBLOCK (`MSG_DONTWAIT' was given, and the operation would have blocked)
 * @return: * : [<= bufsize] The actual # of received bytes */
/* ssize_t recvfrom(fd_t sockfd, void *buf, size_t bufsize, syscall_ulong_t msg_flags, struct sockaddr *addr, socklen_t *addr_len) */
.section .text.x86.asm32_syscall_int80.recvfrom
INTERN_WEAK_FUNCTION(__x86_asm32_int80_recvfrom)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x173
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ebp  /* Arg #5 */
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_recvfrom)
	call   sys_recvfrom
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_recvfrom)

/* Same as `recv(2)' and `recvfrom(2)', but also allows for receiving ancillary
 * data as  well as  for  data buffers  to be  represented  by an  IOV  vector.
 * @param: msg_flags: Set of `MSG_CMSG_CLOEXEC | MSG_CMSG_CLOFORK |
 *                            MSG_DONTWAIT | MSG_ERRQUEUE | MSG_OOB |
 *                            MSG_PEEK  |  MSG_TRUNC  |  MSG_WAITALL'
 * @throw: ... Same as for `recv(2)' and `recvfrom(2)'
 * @return: * : [<= bufsize] The actual # of received payload bytes */
/* ssize_t recvmsg(fd_t sockfd, struct msghdrx32 *message, syscall_ulong_t msg_flags) */
.section .text.x86.asm32_syscall_int80.recvmsg
INTERN_WEAK_FUNCTION(__x86_asm32_int80_recvmsg)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x174
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_recvmsg)
	call   sys_recvmsg
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_recvmsg)

/* Disallow further reception of data (causing `recv(2)' to return `0' as soon
 * as  all currently queued  data has been  read), and/or further transmission
 * of data (causing `send(2)' to throw an `E_NET_SHUTDOWN' exception)
 * @param: how: One of `SHUT_RD', `SHUT_WR' or `SHUT_RDWR'
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_SHUTDOWN_NOT_CONNECTED
 * @return: 0 : Success */
/* errno_t shutdown(fd_t sockfd, syscall_ulong_t how) */
.section .text.x86.asm32_syscall_int80.shutdown
INTERN_WEAK_FUNCTION(__x86_asm32_int80_shutdown)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x175
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_shutdown)
	call   sys_shutdown
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_shutdown)

/* fd_t userfaultfd(syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.userfaultfd
INTERN_WEAK_FUNCTION(__x86_asm32_int80_userfaultfd)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x176
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_userfaultfd)
	call   sys_userfaultfd
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_userfaultfd)

/* errno_t membarrier(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.membarrier
INTERN_WEAK_FUNCTION(__x86_asm32_int80_membarrier)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x177
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_membarrier)
	call   sys_membarrier
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_membarrier)

/* errno_t mlock2(void const *addr, size_t length, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.mlock2
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mlock2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x178
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mlock2)
	call   sys_mlock2
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_mlock2)

/* errno_t copy_file_range(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.copy_file_range
INTERN_WEAK_FUNCTION(__x86_asm32_int80_copy_file_range)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x179
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_copy_file_range)
	call   sys_copy_file_range
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_copy_file_range)

/* errno_t preadv2(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.preadv2
INTERN_WEAK_FUNCTION(__x86_asm32_int80_preadv2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x17a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_preadv2)
	call   sys_preadv2
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_preadv2)

/* errno_t pwritev2(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.pwritev2
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pwritev2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x17b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pwritev2)
	call   sys_pwritev2
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_pwritev2)

/* errno_t pkey_mprotect(void *addr, size_t len, syscall_ulong_t prot, syscall_ulong_t pkey) */
.section .text.x86.asm32_syscall_int80.pkey_mprotect
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pkey_mprotect)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x17c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pkey_mprotect)
	call   sys_pkey_mprotect
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_pkey_mprotect)

/* syscall_slong_t pkey_alloc(syscall_ulong_t flags, syscall_ulong_t access_rights) */
.section .text.x86.asm32_syscall_int80.pkey_alloc
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pkey_alloc)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x17d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pkey_alloc)
	call   sys_pkey_alloc
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_pkey_alloc)

/* errno_t pkey_free(syscall_ulong_t key) */
.section .text.x86.asm32_syscall_int80.pkey_free
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pkey_free)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x17e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pkey_free)
	call   sys_pkey_free
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_pkey_free)

/* errno_t statx(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.statx
INTERN_WEAK_FUNCTION(__x86_asm32_int80_statx)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x17f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_statx)
	call   sys_statx
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_statx)

/* >> arch_prctl(2)
 * Arch-dependent system process control interface. (But don't go and
 * think that the  normal `prctl(2)'  doesn't feature  arch-dependent
 * commands  -- honestly, this syscall shouldn't exist if you ask me,
 * but it does on linux, and so it must also on KOS...)
 * @param: command: One of `ARCH_*' (from <asm/prctl.h>)
 * @param: addr: Either a `syscall_ulong_t' or `syscall_ulong_t *', depending on `command'
 * @return: * :  Return value depends on `command' */
/* syscall_slong_t arch_prctl(unsigned int command, uint32_t *addr) */
.section .text.x86.asm32_syscall_int80.arch_prctl
INTERN_WEAK_FUNCTION(__x86_asm32_int80_arch_prctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x180
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_arch_prctl)
	call   sys_arch_prctl
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_arch_prctl)

/* errno_t io_pgetevents(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.io_pgetevents
INTERN_WEAK_FUNCTION(__x86_asm32_int80_io_pgetevents)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x181
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_io_pgetevents)
	call   sys_io_pgetevents
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_io_pgetevents)

/* errno_t rseq(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.rseq
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rseq)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x182
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_rseq)
	call   sys_rseq
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_rseq)

/* errno_t semget(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.semget
INTERN_WEAK_FUNCTION(__x86_asm32_int80_semget)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x189
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_semget)
	call   sys_semget
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_semget)

/* errno_t semctl(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.semctl
INTERN_WEAK_FUNCTION(__x86_asm32_int80_semctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x18a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_semctl)
	call   sys_semctl
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_semctl)

/* errno_t shmget(key_t key, size_t size, syscall_ulong_t shmflg) */
.section .text.x86.asm32_syscall_int80.shmget
INTERN_WEAK_FUNCTION(__x86_asm32_int80_shmget)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x18b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_shmget)
	call   sys_shmget
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_shmget)

/* errno_t shmctl(syscall_ulong_t shmid, syscall_ulong_t cmd, struct shmid_ds *buf) */
.section .text.x86.asm32_syscall_int80.shmctl
INTERN_WEAK_FUNCTION(__x86_asm32_int80_shmctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x18c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_shmctl)
	call   sys_shmctl
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_shmctl)

/* errno_t shmat(syscall_ulong_t shmid, void const *shmaddr, syscall_ulong_t shmflg) */
.section .text.x86.asm32_syscall_int80.shmat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_shmat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x18d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_shmat)
	call   sys_shmat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_shmat)

/* errno_t shmdt(void const *shmaddr) */
.section .text.x86.asm32_syscall_int80.shmdt
INTERN_WEAK_FUNCTION(__x86_asm32_int80_shmdt)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x18e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_shmdt)
	call   sys_shmdt
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_shmdt)

/* errno_t msgget(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.msgget
INTERN_WEAK_FUNCTION(__x86_asm32_int80_msgget)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x18f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_msgget)
	call   sys_msgget
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_msgget)

/* errno_t msgsnd(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.msgsnd
INTERN_WEAK_FUNCTION(__x86_asm32_int80_msgsnd)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x190
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_msgsnd)
	call   sys_msgsnd
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_msgsnd)

/* errno_t msgrcv(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.msgrcv
INTERN_WEAK_FUNCTION(__x86_asm32_int80_msgrcv)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x191
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_msgrcv)
	call   sys_msgrcv
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_msgrcv)

/* errno_t msgctl(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.msgctl
INTERN_WEAK_FUNCTION(__x86_asm32_int80_msgctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x192
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_msgctl)
	call   sys_msgctl
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_msgctl)

/* errno_t clock_gettime64(clockid_t clock_id, struct timespecx32_64 *tp) */
.section .text.x86.asm32_syscall_int80.clock_gettime64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_clock_gettime64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x193
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_clock_gettime64)
	call   sys_clock_gettime64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_clock_gettime64)

/* errno_t clock_settime64(clockid_t clock_id, struct timespecx32_64 const *tp) */
.section .text.x86.asm32_syscall_int80.clock_settime64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_clock_settime64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x194
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_clock_settime64)
	call   sys_clock_settime64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_clock_settime64)

/* errno_t clock_adjtime64(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.clock_adjtime64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_clock_adjtime64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x195
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_clock_adjtime64)
	call   sys_clock_adjtime64
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_clock_adjtime64)

/* errno_t clock_getres_time64(clockid_t clock_id, struct timespecx32_64 *res) */
.section .text.x86.asm32_syscall_int80.clock_getres_time64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_clock_getres_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x196
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_clock_getres_time64)
	call   sys_clock_getres_time64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_clock_getres_time64)

/* errno_t clock_nanosleep_time64(clockid_t clock_id, syscall_ulong_t flags, struct timespecx32_64 const *requested_time, struct timespecx32_64 *remaining) */
.section .text.x86.asm32_syscall_int80.clock_nanosleep_time64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_clock_nanosleep_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x197
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_clock_nanosleep_time64)
	call   sys_clock_nanosleep_time64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_clock_nanosleep_time64)

/* errno_t timer_gettime64(timer_t timerid, struct itimerspecx32_64 *value) */
.section .text.x86.asm32_syscall_int80.timer_gettime64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_timer_gettime64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x198
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_timer_gettime64)
	call   sys_timer_gettime64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_timer_gettime64)

/* @param: flags: Set of `0 | TIMER_ABSTIME' */
/* errno_t timer_settime64(timer_t timerid, syscall_ulong_t flags, struct itimerspecx32_64 const *value, struct itimerspecx32_64 *ovalue) */
.section .text.x86.asm32_syscall_int80.timer_settime64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_timer_settime64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x199
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_timer_settime64)
	call   sys_timer_settime64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_timer_settime64)

/* Return the next expiration time of UFD */
/* errno_t timerfd_gettime64(fd_t timerfd, struct itimerspecx32_64 *otmr) */
.section .text.x86.asm32_syscall_int80.timerfd_gettime64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_timerfd_gettime64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x19a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_timerfd_gettime64)
	call   sys_timerfd_gettime64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_timerfd_gettime64)

/* Set next expiration time of interval timer source `timerfd' to `utmr'.
 * If `flags'  has the  `TFD_TIMER_ABSTIME' flag  set the  timeout  value
 * is absolute. Optionally return the old expiration time in `otmr'
 * @param: flags: Set of `0 | TFD_TIMER_ABSTIME' */
/* errno_t timerfd_settime64(fd_t timerfd, syscall_ulong_t flags, struct itimerspecx32_64 const *utmr, struct itimerspecx32_64 *otmr) */
.section .text.x86.asm32_syscall_int80.timerfd_settime64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_timerfd_settime64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x19b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_timerfd_settime64)
	call   sys_timerfd_settime64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_timerfd_settime64)

/* @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_CHANGE_BTIME | AT_DOSPATH' */
/* errno_t utimensat_time64(fd_t dirfd, char const *filename, struct timespecx32_64 const[2] times, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.utimensat_time64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_utimensat_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x19c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_utimensat_time64)
	call   sys_utimensat_time64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_utimensat_time64)

/* ssize_t pselect6_time64(size_t nfds, struct __fd_set_struct *readfds, struct __fd_set_struct *writefds, struct __fd_set_struct *exceptfds, struct timespecx32_64 const *timeout, struct __sigset_with_sizex32 const *sigmask_sigset_with_size) */
.section .text.x86.asm32_syscall_int80.pselect6_time64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pselect6_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x19d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ebp  /* Arg #5 */
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pselect6_time64)
	call   sys_pselect6_time64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_pselect6_time64)

/* ssize_t ppoll_time64(struct pollfd *fds, size_t nfds, struct timespecx32_64 const *timeout_ts, struct __sigset_struct const *sigmask, size_t sigsetsize) */
.section .text.x86.asm32_syscall_int80.ppoll_time64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ppoll_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x19e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ppoll_time64)
	call   sys_ppoll_time64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_ppoll_time64)

/* errno_t io_pgetevents_time64(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.io_pgetevents_time64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_io_pgetevents_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1a0
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_io_pgetevents_time64)
	call   sys_io_pgetevents_time64
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_io_pgetevents_time64)

/* Same as `recvmsg(2)', but may be used to receive many
 * messages  (datagrams)  with  a  single  system  call.
 * @param: msg_flags: Set of `MSG_CMSG_CLOEXEC | MSG_CMSG_CLOFORK |
 *                            MSG_DONTWAIT | MSG_ERRQUEUE | MSG_OOB |
 *                            MSG_PEEK  |  MSG_TRUNC |  MSG_WAITALL |
 *                            MSG_WAITFORONE'
 * @throw: Error (s.a. `recvmsg(2)')
 * @return: * : The # of datagrams successfully received. */
/* ssize_t recvmmsg_time64(fd_t sockfd, struct mmsghdrx32 *vmessages, size_t vlen, syscall_ulong_t msg_flags, struct timespecx32_64 const *tmo) */
.section .text.x86.asm32_syscall_int80.recvmmsg_time64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_recvmmsg_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1a1
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_recvmmsg_time64)
	call   sys_recvmmsg_time64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_recvmmsg_time64)

/* errno_t mq_timedsend_time64(fd_t mqdes, char const *msg_ptr, size_t msg_len, uint32_t msg_prio, struct timespecx32_64 const *abs_timeout) */
.section .text.x86.asm32_syscall_int80.mq_timedsend_time64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mq_timedsend_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1a2
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mq_timedsend_time64)
	call   sys_mq_timedsend_time64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_mq_timedsend_time64)

/* ssize_t mq_timedreceive_time64(fd_t mqdes, char *msg_ptr, size_t msg_len, uint32_t *pmsg_prio, struct timespecx32_64 const *abs_timeout) */
.section .text.x86.asm32_syscall_int80.mq_timedreceive_time64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mq_timedreceive_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1a3
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mq_timedreceive_time64)
	call   sys_mq_timedreceive_time64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_mq_timedreceive_time64)

/* errno_t semtimedop_time64(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.semtimedop_time64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_semtimedop_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1a4
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_semtimedop_time64)
	call   sys_semtimedop_time64
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_semtimedop_time64)

/* syscall_slong_t rt_sigtimedwait_time64(struct __sigset_struct const *set, struct __siginfox32_struct *info, struct timespecx32_64 const *timeout, size_t sigsetsize) */
.section .text.x86.asm32_syscall_int80.rt_sigtimedwait_time64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rt_sigtimedwait_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1a5
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_rt_sigtimedwait_time64)
	call   sys_rt_sigtimedwait_time64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_rt_sigtimedwait_time64)

/* @param: futex_op: One of `FUTEX_*' from <linux/futex.h> */
/* syscall_slong_t futex_time64(uint32_t *uaddr, syscall_ulong_t futex_op, uint32_t val, struct timespecx32_64 const *timeout_or_val2, uint32_t *uaddr2, uint32_t val3) */
.section .text.x86.asm32_syscall_int80.futex_time64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_futex_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1a6
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ebp  /* Arg #5 */
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_futex_time64)
	call   sys_futex_time64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_futex_time64)

/* errno_t sched_rr_get_interval_time64(pid_t pid, struct timespecx32_64 *ts) */
.section .text.x86.asm32_syscall_int80.sched_rr_get_interval_time64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_sched_rr_get_interval_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1a7
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sched_rr_get_interval_time64)
	call   sys_sched_rr_get_interval_time64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_sched_rr_get_interval_time64)

/* Send a signal to the process of a given pidfd
 * @param: pidfd:  A `HANDLE_TYPE_PIDFD'-handle
 * @param: usigno: The signal that should be sent
 * @param: uinfo:  [0..1] Additional signal information
 * @param: flags:  Must always be `0' (for now)
 * @throw: E_PROCESS_EXITED:                                                                  [...]
 * @throw: E_INVALID_ARGUMENT_RESERVED_ARGUMENT:E_INVALID_ARGUMENT_CONTEXT_PIDFD_GETFD_FLAGS: [...]
 * @throw: E_INVALID_ARGUMENT_UNEXPECTED_COMMAND:E_INVALID_ARGUMENT_CONTEXT_SIGINFO_SIGNO:    [...]
 * @throw: E_INVALID_ARGUMENT_BAD_VALUE:E_INVALID_ARGUMENT_CONTEXT_BAD_SIGNO:                 [...]
 * @throw: E_INVALID_ARGUMENT_BAD_VALUE:E_INVALID_ARGUMENT_CONTEXT_RAISE_SIGINFO_BADCODE:     [...]
 * @throw: E_INVALID_HANDLE_FILE:                                                             [...]
 * @throw: E_ILLEGAL_OPERATION:                                                               [...] */
/* errno_t pidfd_send_signal(fd_t pidfd, signo_t usigno, struct __siginfox32_struct const *uinfo, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.pidfd_send_signal
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pidfd_send_signal)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1a8
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pidfd_send_signal)
	call   sys_pidfd_send_signal
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_pidfd_send_signal)

/* errno_t io_uring_setup(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.io_uring_setup
INTERN_WEAK_FUNCTION(__x86_asm32_int80_io_uring_setup)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1a9
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_io_uring_setup)
	call   sys_io_uring_setup
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_io_uring_setup)

/* errno_t io_uring_enter(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.io_uring_enter
INTERN_WEAK_FUNCTION(__x86_asm32_int80_io_uring_enter)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1aa
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_io_uring_enter)
	call   sys_io_uring_enter
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_io_uring_enter)

/* errno_t io_uring_register(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.io_uring_register
INTERN_WEAK_FUNCTION(__x86_asm32_int80_io_uring_register)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1ab
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_io_uring_register)
	call   sys_io_uring_register
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_io_uring_register)

/* errno_t open_tree(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.open_tree
INTERN_WEAK_FUNCTION(__x86_asm32_int80_open_tree)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1ac
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_open_tree)
	call   sys_open_tree
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_open_tree)

/* errno_t move_mount(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.move_mount
INTERN_WEAK_FUNCTION(__x86_asm32_int80_move_mount)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1ad
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_move_mount)
	call   sys_move_mount
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_move_mount)

/* errno_t fsopen(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.fsopen
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fsopen)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1ae
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fsopen)
	call   sys_fsopen
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fsopen)

/* errno_t fsconfig(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.fsconfig
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fsconfig)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1af
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fsconfig)
	call   sys_fsconfig
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fsconfig)

/* errno_t fsmount(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.fsmount
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fsmount)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1b0
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fsmount)
	call   sys_fsmount
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fsmount)

/* errno_t fspick(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.fspick
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fspick)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1b1
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fspick)
	call   sys_fspick
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fspick)

/* Return a `HANDLE_TYPE_PIDFD' handle for the given `pid'
 * This system call exists for compatibility with linux, which does not  allow
 * this call to succeed when `pid' isn't a process leader (i.e. main() thread)
 * @param: flags: Must always be `0' (for now)
 * @return: * :   A handle for the process `pid'
 * @throw: E_PROCESS_EXITED:                                                                 [...]
 * @throw: E_INVALID_ARGUMENT_RESERVED_ARGUMENT:E_INVALID_ARGUMENT_CONTEXT_PIDFD_OPEN_FLAGS: [...]
 * @throw: E_BADALLOC_INSUFFICIENT_HANDLE_NUMBERS:                                           [...] */
/* fd_t pidfd_open(pid_t pid, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.pidfd_open
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pidfd_open)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1b2
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pidfd_open)
	call   sys_pidfd_open
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_pidfd_open)

/* syscall_slong_t clone3(struct clone_args *cl_args, size_t size) */
.section .text.x86.asm32_syscall_int80.clone3
INTERN_WEAK_FUNCTION(__x86_asm32_int80_clone3)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1b3
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_clone3)
	call   sys_clone3
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_clone3)

/* @param: flags: Set of `CLOSE_RANGE_*' from <linux/close_range.h> */
/* errno_t close_range(unsigned int minfd, unsigned int maxfd, unsigned int flags) */
.section .text.x86.asm32_syscall_int80.close_range
INTERN_WEAK_FUNCTION(__x86_asm32_int80_close_range)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1b4
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_close_range)
	call   sys_close_range
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_close_range)

/* errno_t openat2(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_int80.openat2
INTERN_WEAK_FUNCTION(__x86_asm32_int80_openat2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1b5
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_openat2)
	call   sys_openat2
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_openat2)

/* Duplicate the  handle  of  a  foreign  process into  a  handle  for  the  caller.
 * This system call duplicates the functionality of `open("/proc/[pid]/fd/[fdno]")',
 * which may also be used to duplicate file handles from another process.
 * @param: pidfd: A `HANDLE_TYPE_PIDFD'-handle
 * @param: fd:    The FD-number of the handle to clone
 * @param: flags: Must always be `0' (for now)
 * @return: * :   The duplicated handle number
 * @throw: E_PROCESS_EXITED:                                                                  [...]
 * @throw: E_INVALID_ARGUMENT_RESERVED_ARGUMENT:E_INVALID_ARGUMENT_CONTEXT_PIDFD_GETFD_FLAGS: [...]
 * @throw: E_BADALLOC_INSUFFICIENT_HANDLE_NUMBERS:                                            [...]
 * @throw: E_INVALID_HANDLE_FILE:                                                             [...]
 * @throw: E_ILLEGAL_OPERATION:                                                               [...] */
/* fd_t pidfd_getfd(fd_t pidfd, fd_t foreign_fd, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.pidfd_getfd
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pidfd_getfd)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1b6
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pidfd_getfd)
	call   sys_pidfd_getfd
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_pidfd_getfd)

/* @param: type: Set of `R_OK | W_OK | X_OK' or `F_OK'
 * @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_EACCESS | AT_DOSPATH' */
/* errno_t faccessat2(fd_t dirfd, char const *filename, syscall_ulong_t type, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.faccessat2
INTERN_WEAK_FUNCTION(__x86_asm32_int80_faccessat2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0x1b7
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_faccessat2)
	call   sys_faccessat2
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_faccessat2)

/* Same as  `writev(2)', but  write data  to a  file at  a
 * specific `offset', rather than the current R/W position
 * @return: <= SUM(iov[*].iov_len): The actual amount of written bytes */
/* ssize_t pwritevf(fd_t fd, struct iovecx32 const *iovec, size_t count, uint64_t offset, iomode_t mode) */
.section .text.x86.asm32_syscall_int80.pwritevf
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pwritevf)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffeb2
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ebp  /* Arg #5 */
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pwritevf)
	call   sys_pwritevf
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_pwritevf)

/* Same as  `readv(2)', but  read data  from a  file at  a
 * specific `offset', rather than the current R/W position
 * @return: <= SUM(iov[*].iov_len): The actual amount of read bytes */
/* ssize_t preadvf(fd_t fd, struct iovecx32 const *iovec, size_t count, uint64_t offset, iomode_t mode) */
.section .text.x86.asm32_syscall_int80.preadvf
INTERN_WEAK_FUNCTION(__x86_asm32_int80_preadvf)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffeb3
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ebp  /* Arg #5 */
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_preadvf)
	call   sys_preadvf
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_preadvf)

/* errno_t fallocate64(fd_t fd, syscall_ulong_t mode, uint64_t offset, uint64_t length) */
.section .text.x86.asm32_syscall_int80.fallocate64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fallocate64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffebc
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ebp  /* Arg #5 */
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fallocate64)
	call   sys_fallocate64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fallocate64)

/* @param: flags: Set of `0 | AT_READLINK_REQSIZE | AT_DOSPATH' */
/* ssize_t freadlinkat(fd_t dirfd, char const *path, char *buf, size_t buflen, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.freadlinkat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_freadlinkat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffecf
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_freadlinkat)
	call   sys_freadlinkat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_freadlinkat)

/* @param: flags: Set of `0 | AT_DOSPATH' */
/* errno_t fsymlinkat(char const *link_text, fd_t tofd, char const *target_path, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.fsymlinkat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fsymlinkat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffed0
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fsymlinkat)
	call   sys_fsymlinkat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fsymlinkat)

/* @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_DOSPATH' */
/* errno_t kfstatat(fd_t dirfd, char const *filename, struct __kos_stat *statbuf, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.kfstatat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_kfstatat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffed4
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_kfstatat)
	call   sys_kfstatat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_kfstatat)

/* errno_t futimesat64(fd_t dirfd, char const *filename, struct timevalx32_64 const[2] times) */
.section .text.x86.asm32_syscall_int80.futimesat64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_futimesat64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffed5
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_futimesat64)
	call   sys_futimesat64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_futimesat64)

/* @param: flags: Set of `0 | AT_DOSPATH' */
/* errno_t fmknodat(fd_t dirfd, char const *nodename, mode_t mode, dev_t dev, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.fmknodat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fmknodat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffed7
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fmknodat)
	call   sys_fmknodat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fmknodat)

/* @param: flags: Set of `0 | AT_DOSPATH' */
/* errno_t fmkdirat(fd_t dirfd, char const *pathname, mode_t mode, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.fmkdirat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fmkdirat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffed8
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fmkdirat)
	call   sys_fmkdirat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fmkdirat)

/* @param: atflags: Set of `AT_SYMLINK_NOFOLLOW | AT_DOSPATH'
 * @param: mask:    Set of `IN_ALL_EVENTS | ...' */
/* int inotify_add_watch_at(fd_t notify_fd, fd_t dirfd, char const *pathname, atflag_t atflags, uint32_t mask) */
.section .text.x86.asm32_syscall_int80.inotify_add_watch_at
INTERN_WEAK_FUNCTION(__x86_asm32_int80_inotify_add_watch_at)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffedc
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_inotify_add_watch_at)
	call   sys_inotify_add_watch_at
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_inotify_add_watch_at)

/* @param: idtype:  One of `P_ALL', `P_PID', `P_PGID'
 * @param: options: At least one of `WEXITED', `WSTOPPED', `WCONTINUED', optionally or'd with `WNOHANG | WNOWAIT' */
/* errno_t waitid64(syscall_ulong_t idtype, id_t id, struct __siginfox32_struct *infop, syscall_ulong_t options, struct rusagex32_64 *ru) */
.section .text.x86.asm32_syscall_int80.waitid64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_waitid64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffee4
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_waitid64)
	call   sys_waitid64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_waitid64)

/* @param: times:    When NULL, set the current time
 * @param: times[0]: New access time
 * @param: times[1]: New last-modified time */
/* errno_t utimes64(char const *filename, struct timevalx32_64 const[2] times) */
.section .text.x86.asm32_syscall_int80.utimes64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_utimes64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffef1
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_utimes64)
	call   sys_utimes64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_utimes64)

/* >> set_userprocmask_address(2)
 * Register the address of  the calling thread's userprocmask  controller.
 * This also  initializes `*ctl->pm_sigmask'  and `ctl->pm_pending',  such
 * that `*ctl->pm_sigmask' is filled with the current kernel-level  signal
 * mask, as would be returned by `sigprocmask(2)', while `ctl->pm_pending'
 * is filled in with the equivalent of `sigpending(2)'
 * Additionally,  the address  of `&ctl->pm_mytid'  is stored  as an override
 * for `set_tid_address(2)', and the kernel may read from `*ctl->pm_sigmask',
 * and write to `ctl->pm_pending' (using  atomic-or for the later) from  this
 * point forth.
 * NOTE: Before calling this function, the caller must:
 *       >> bzero(ctl, sizeof(struct userprocmask));
 *       >> ctl->pm_sigsize = sizeof(sigset_t);
 *       >> ctl->pm_sigmask = &initial_sigmask;
 *       Where the initial bzero() is needed to initialize potential
 *       additional,   arch-specific   fields    to   all    zeroes.
 * NOTE: This system call will then initialize:
 *       >> ctl->pm_mytid = gettid();
 *       >> sigprocmask(0, NULL, ctl->pm_sigmask);
 *       >> sigpending(&ctl->pm_pending);
 * NOTE: Passing `NULL' for `ctl' disables userprocmask-mode, though
 *       before this is done, the kernel will copy the  `pm_sigmask'
 *       of the previously set  controller into its internal  signal
 *       mask. (i.e. the one used outside of userprocmask-mode)
 * Note though  that  `pm_sigmask'  is ignored  for  `SIGKILL'  and  `SIGSTOP'
 * Note also  that  this  function replaces  `set_tid_address(2)',  such  that
 * it negates a  prior call  to said  function, while  a future  call to  said
 * function will once again disable userprocmask, same as passing `NULL' would */
/* errno_t set_userprocmask_address(struct userprocmask *ctl) */
.section .text.x86.asm32_syscall_int80.set_userprocmask_address
INTERN_WEAK_FUNCTION(__x86_asm32_int80_set_userprocmask_address)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffefe
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_set_userprocmask_address)
	call   sys_set_userprocmask_address
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_set_userprocmask_address)

/* >> lfutexexpr(2)
 * The lfutexexpr(2) system call can be used to specify arbitrarily complex
 * expressions that must atomically (in relation to other futex operations)
 * hold true before the scheduler will suspend the calling thread.
 * @param: futexaddr: The futex on which to wait
 * @param: base:      Base pointer added to the `fe_offset' fields of given expressions
 * @param: expr:      Vector of expressions for which to check, terminated by `LFUTEX_EXPREND'
 * @param: timeout:   Timeout for wait operations (s.a. `LFUTEX_WAIT_FLAG_TIMEOUT_*')
 *                    When `LFUTEX_FDBIT'  is  set,  this argument  must  be  `NULL'.
 * @param: flags:     Set of `LFUTEX_WAIT_FLAG_TIMEOUT_*' or `LFUTEX_FDBIT'
 * @return: * : The first  non-zero  return value  from  executing  all of  the  given  `expr'
 *              in order (s.a. the documentations of the individual `LFUTEX_WAIT_*'  functions
 *              to see their  possible return  values, which are  always `0'  when they  would
 *              perform a wait  operation, and usually  `1' otherwise) or  `0' if the  calling
 *              thread had to perform a wait operation, at which point this function returning
 *              that value means that you've once again been re-awoken.
 *              When `LFUTEX_FDBIT' is set, the return value is an `fd_t' for a futex fd that
 *              can be used to poll for the specified `exprv'. Note that in this case `exprv'
 *              is limited to `LFUTEXFD_DEFAULT_MAXEXPR' (`/proc/kos/futexfd-maxexpr')
 * @return: -1:EFAULT:    A faulty pointer was given
 * @return: -1:EINVAL:    One of the given commands is invalid, or `expr[0].fe_condition == LFUTEX_EXPREND'
 * @return: -1:EINTR:     A blocking futex-wait operation was interrupted
 * @return: -1:ETIMEDOUT: A blocking futex-wait operation has timed out */
/* errno_t lfutexexpr(uint32_t *futexaddr, void *base, struct lfutexexprx32 const *expr, struct timespecx32_64 const *timeout, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.lfutexexpr
INTERN_WEAK_FUNCTION(__x86_asm32_int80_lfutexexpr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff0f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_lfutexexpr)
	call   sys_lfutexexpr
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_lfutexexpr)

/* >> lfutex(2)
 * Provide the bottom-most API for implementing user-space synchronization on KOS
 * @param: futex_op: One of:
 *    - LFUTEX_WAKE:                (lfutex_t *uaddr, LFUTEX_WAKE, size_t count)
 *    - LFUTEX_WAKEMASK:            (lfutex_t *uaddr, LFUTEX_WAKEMASK, size_t count, lfutex_t mask_and, lfutex_t mask_or)
 *    - LFUTEX_WAIT_WHILE:          (lfutex_t *uaddr, LFUTEX_WAIT_WHILE, lfutex_t value, struct timespec const *timeout)
 *    - LFUTEX_WAIT_UNTIL:          (lfutex_t *uaddr, LFUTEX_WAIT_UNTIL, lfutex_t value, struct timespec const *timeout)
 *    - LFUTEX_WAIT_WHILE_ABOVE:    (lfutex_t *uaddr, LFUTEX_WAIT_WHILE_ABOVE, lfutex_t value, struct timespec const *timeout)
 *    - LFUTEX_WAIT_WHILE_BELOW:    (lfutex_t *uaddr, LFUTEX_WAIT_WHILE_BELOW, lfutex_t value, struct timespec const *timeout)
 *    - LFUTEX_WAIT_WHILE_BITMASK:  (lfutex_t *uaddr, LFUTEX_WAIT_WHILE_BITMASK, lfutex_t bitmask, struct timespec const *timeout, lfutex_t setmask)
 *    - LFUTEX_WAIT_UNTIL_BITMASK:  (lfutex_t *uaddr, LFUTEX_WAIT_UNTIL_BITMASK, lfutex_t bitmask, struct timespec const *timeout, lfutex_t setmask)
 *    - LFUTEX_WAIT_WHILE_EX:       (lfutex_t *uaddr, LFUTEX_WAIT_WHILE_EX, void const *rhs, struct timespec const *timeout, size_t num_bytes)
 *    - LFUTEX_WAIT_UNTIL_EX:       (lfutex_t *uaddr, LFUTEX_WAIT_UNTIL_EX, void const *rhs, struct timespec const *timeout, size_t num_bytes)
 *    - LFUTEX_WAIT_WHILE_ABOVE_EX: (lfutex_t *uaddr, LFUTEX_WAIT_WHILE_ABOVE_EX, void const *rhs, struct timespec const *timeout, size_t num_bytes)
 *    - LFUTEX_WAIT_WHILE_BELOW_EX: (lfutex_t *uaddr, LFUTEX_WAIT_WHILE_BELOW_EX, void const *rhs, struct timespec const *timeout, size_t num_bytes)
 * @param: timeout: Timeout for wait operations (s.a. `LFUTEX_WAIT_FLAG_TIMEOUT_*')
 * @return: * : Depending on `futex_op'
 * @return: -1:EFAULT:    A faulty pointer was given
 * @throw:  E_INVALID_ARGUMENT: The given `futex_op' is invalid
 * @throw:  E_INTERRUPT:        A blocking futex-wait operation was interrupted
 * @return: -ETIMEDOUT:         A blocking futex-wait operation has timed out */
/* syscall_slong_t lfutex(uint32_t *uaddr, syscall_ulong_t futex_op, uint32_t val, struct timespecx32_64 const *timeout, uint32_t val2) */
.section .text.x86.asm32_syscall_int80.lfutex
INTERN_WEAK_FUNCTION(__x86_asm32_int80_lfutex)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff10
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_lfutex)
	call   sys_lfutex
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_lfutex)

/* @param: mode: One of `READDIR_DEFAULT', `READDIR_CONTINUE', `READDIR_PEEK' or `READDIR_MULTIPLE',
 *               optionally     or'd     with     any     of     `READDIR_SKIPREL | READDIR_WANTEOF' */
/* ssize_t kreaddirf(fd_t fd, struct dirent *buf, size_t bufsize, syscall_ulong_t mode, iomode_t iomode) */
.section .text.x86.asm32_syscall_int80.kreaddirf
INTERN_WEAK_FUNCTION(__x86_asm32_int80_kreaddirf)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff23
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_kreaddirf)
	call   sys_kreaddirf
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_kreaddirf)

/* @param: mode: One of `READDIR_DEFAULT', `READDIR_CONTINUE', `READDIR_PEEK' or `READDIR_MULTIPLE',
 *               optionally     or'd     with     any     of     `READDIR_SKIPREL | READDIR_WANTEOF' */
/* ssize_t kreaddir(fd_t fd, struct dirent *buf, size_t bufsize, syscall_ulong_t mode) */
.section .text.x86.asm32_syscall_int80.kreaddir
INTERN_WEAK_FUNCTION(__x86_asm32_int80_kreaddir)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff24
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_kreaddir)
	call   sys_kreaddir
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_kreaddir)

/* errno_t kfstat(fd_t fd, struct __kos_stat *statbuf) */
.section .text.x86.asm32_syscall_int80.kfstat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_kfstat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff3b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_kfstat)
	call   sys_kfstat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_kfstat)

/* errno_t klstat(char const *filename, struct __kos_stat *statbuf) */
.section .text.x86.asm32_syscall_int80.klstat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_klstat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff3c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_klstat)
	call   sys_klstat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_klstat)

/* errno_t kstat(char const *filename, struct __kos_stat *statbuf) */
.section .text.x86.asm32_syscall_int80.kstat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_kstat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff3d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_kstat)
	call   sys_kstat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_kstat)

/* ssize_t pwrite64f(fd_t fd, void const *buf, size_t bufsize, uint64_t offset, iomode_t mode) */
.section .text.x86.asm32_syscall_int80.pwrite64f
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pwrite64f)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff4b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ebp  /* Arg #5 */
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pwrite64f)
	call   sys_pwrite64f
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_pwrite64f)

/* ssize_t pread64f(fd_t fd, void *buf, size_t bufsize, uint64_t offset, iomode_t mode) */
.section .text.x86.asm32_syscall_int80.pread64f
INTERN_WEAK_FUNCTION(__x86_asm32_int80_pread64f)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff4c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ebp  /* Arg #5 */
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pread64f)
	call   sys_pread64f
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_pread64f)

/* Restore the specified register state when returning from a signal handler
 * Note that the order and locations of arguments taken by this system  call
 * are of great importance, as they must match what is encoded by the kernel
 * within `userexcept_callsignal()'
 * The order chosen is also important, as it is selected such that arguments
 * are only passed through registers  that are natively preserved by  signal
 * handler functions. */
/* void ksigreturn(struct fpustate32 const *restore_fpu, syscall_ulong_t unused1, syscall_ulong_t unused2, struct __sigset_with_sizex32 const *restore_sigmask, struct rpc_syscall_info32 const *sc_info, struct ucpustate32 const *restore_cpu) */
.section .text.x86.asm32_syscall_int80.ksigreturn
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ksigreturn)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff53
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ebp  /* Arg #5 */
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ksigreturn)
	call   sys_ksigreturn
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_ksigreturn)

/* errno_t nanosleep64(struct timespecx32_64 const *req, struct timespecx32_64 *rem) */
.section .text.x86.asm32_syscall_int80.nanosleep64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_nanosleep64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff5e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_nanosleep64)
	call   sys_nanosleep64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_nanosleep64)

/* >> rpc_serve_sysret(2)
 * Very similar to `rpc_serve(2)', but with the addition that this one
 * will only serve RPCs that can be handled in `RPC_REASONCTX_SYSRET',
 * aka. `RPC_REASONCTX_ASYNC' contexts. Additionally, this system call
 * ignores the state of the  internal `TASK_FRPC' flag, and should  be
 * invoked  when  the calling  thread  makes use  of  the userprocmask
 * mechanism, and the  signal mask became  less restrictive while  the
 * `USERPROCMASK_FLAG_HASPENDING' flag was set.
 * 
 * When userprocmask is disabled, this system call is pretty much just
 * a no-op (semnatically speaking, it does nothing). But when enabled,
 * it is really only usable  in conjuction with the userprocmask.  The
 * exact usage can be seen in `chkuserprocmask(3)'.
 * 
 * @return: 0 : Always, unconditionally returned. */
/* errno_t rpc_serve_sysret(void) */
.section .text.x86.asm32_syscall_int80.rpc_serve_sysret
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rpc_serve_sysret)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff61
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_rpc_serve_sysret)
	call   sys_rpc_serve_sysret
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_rpc_serve_sysret)

/* >> rpc_serve(2)
 * Check for pending signals and RPCs. This is a wrapper around the
 * kernel `task_serve()' function, which is always invoked before a
 * thread begins waiting for a blocking operation. All system calls
 * marked as cancellation  points probably  call `task_serve()'  at
 * some point.
 * Note that unlike (say) `pause(2)', this function doesn't  block,
 * and may be used to implement `pthread_testcancel(3)' (should KOS
 * RPCs be used to facility pthread cancellation points, as done by
 * KOS's builtin libc)
 * @return: 0:      Nothing was handled.
 * @return: -EINTR: RPCs (or posix signals) were handled. */
/* errno_t rpc_serve(void) */
.section .text.x86.asm32_syscall_int80.rpc_serve
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rpc_serve)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff62
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_rpc_serve)
	call   sys_rpc_serve
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_rpc_serve)

/* syscall_slong_t ksysctl(ioctl_t command, void *arg) */
.section .text.x86.asm32_syscall_int80.ksysctl
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ksysctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff6b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ksysctl)
	call   sys_ksysctl
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_ksysctl)

/* Same as `write(2)', but rather than specifying a single, continuous buffer,
 * write  data from `count'  separate buffers, though  still return the actual
 * number of written bytes.
 * When  `fd' has the  `O_NONBLOCK' flag set, only  write as much data
 * as possible at the time the call was made, and throw `E_WOULDBLOCK'
 * if no data could be written at the time.
 * @return: <= SUM(iov[*].iov_len): The actual amount of written bytes
 * @return: 0                     : No more data can be written */
/* ssize_t writevf(fd_t fd, struct iovecx32 const *iovec, size_t count, iomode_t mode) */
.section .text.x86.asm32_syscall_int80.writevf
INTERN_WEAK_FUNCTION(__x86_asm32_int80_writevf)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff6e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_writevf)
	call   sys_writevf
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_writevf)

/* Same as `read(2)', but rather than specifying a single, continuous buffer,
 * read  data into `count'  separate buffers, though  still return the actual
 * number of read bytes.
 * When `fd' has the `O_NONBLOCK' flag set, only read as much data as was
 * available at  the time  the call  was made,  and throw  `E_WOULDBLOCK'
 * no data was available at the time.
 * @return: <= SUM(iov[*].iov_len): The actual amount of read bytes
 * @return: 0                     : EOF */
/* ssize_t readvf(fd_t fd, struct iovecx32 const *iovec, size_t count, iomode_t mode) */
.section .text.x86.asm32_syscall_int80.readvf
INTERN_WEAK_FUNCTION(__x86_asm32_int80_readvf)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff6f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_readvf)
	call   sys_readvf
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_readvf)

/* ssize_t select64(size_t nfds, struct __fd_set_struct *readfds, struct __fd_set_struct *writefds, struct __fd_set_struct *exceptfds, struct timevalx32_64 *timeout) */
.section .text.x86.asm32_syscall_int80.select64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_select64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff72
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_select64)
	call   sys_select64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_select64)

/* Same as `waitpid(pid, STAT_LOC, OPTIONS)', though also fills in `USAGE' when non-NULL
 * @param: options: Set of `WNOHANG | WUNTRACED | WCONTINUED' (as a KOS extension, `WNOWAIT' is also accepted) */
/* pid_t wait4_64(pid_t pid, int32_t *stat_loc, syscall_ulong_t options, struct rusagex32_64 *usage) */
.section .text.x86.asm32_syscall_int80.wait4_64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_wait4_64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff8e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_wait4_64)
	call   sys_wait4_64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_wait4_64)

/* @param: which: One of `ITIMER_REAL', `ITIMER_VIRTUAL' or `ITIMER_PROF' */
/* errno_t getitimer64(syscall_ulong_t which, struct __itimervalx32_64 *curr_value) */
.section .text.x86.asm32_syscall_int80.getitimer64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getitimer64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff97
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getitimer64)
	call   sys_getitimer64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getitimer64)

/* @param: which: One of `ITIMER_REAL', `ITIMER_VIRTUAL' or `ITIMER_PROF' */
/* errno_t setitimer64(syscall_ulong_t which, struct __itimervalx32_64 const *newval, struct __itimervalx32_64 *oldval) */
.section .text.x86.asm32_syscall_int80.setitimer64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_setitimer64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffff98
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setitimer64)
	call   sys_setitimer64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_setitimer64)

/* Map the segments of a given library into memory
 * @param: addr:  Hint address (ignored unless `MAP_FIXED' is passed)
 * @param: flags: Set of `MAP_FIXED | MAP_32BIT | MAP_GROWSDOWN |
 *                MAP_GROWSUP  |  MAP_LOCKED  |  MAP_NORESERVE  |
 *                MAP_POPULATE  |  MAP_NONBLOCK   |  MAP_SYNC   |
 *                MAP_FIXED_NOREPLACE | MAP_NOASLR'
 * @param: fd:    A handle for the library file being mapped (must be mmap(2)-able)
 * @param: hdrv:  Pointer  to  a vector  of `Elf32_Phdr'  or `Elf64_Phdr'
 *                (depending on the caller running in 32- or 64-bit mode)
 * @param: hdrc:  The number of program headers */
/* void *maplibrary(void *addr, syscall_ulong_t flags, fd_t fd, struct elf32_phdr const *hdrv, size_t hdrc) */
.section .text.x86.asm32_syscall_int80.maplibrary
INTERN_WEAK_FUNCTION(__x86_asm32_int80_maplibrary)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffaa
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_maplibrary)
	call   sys_maplibrary
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_maplibrary)

/* errno_t settimeofday64(struct timevalx32_64 const *tv, struct timezone const *tz) */
.section .text.x86.asm32_syscall_int80.settimeofday64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_settimeofday64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffb1
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_settimeofday64)
	call   sys_settimeofday64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_settimeofday64)

/* errno_t gettimeofday64(struct timevalx32_64 *tv, struct timezone *tz) */
.section .text.x86.asm32_syscall_int80.gettimeofday64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_gettimeofday64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffb2
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_gettimeofday64)
	call   sys_gettimeofday64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_gettimeofday64)

/* @param: who: One of `RUSAGE_SELF', `RUSAGE_CHILDREN' or `RUSAGE_THREAD' */
/* errno_t getrusage64(syscall_slong_t who, struct rusagex32_64 *tv) */
.section .text.x86.asm32_syscall_int80.getrusage64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getrusage64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffb3
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getrusage64)
	call   sys_getrusage64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getrusage64)

/* uint64_t fsmode(uint64_t mode) */
.section .text.x86.asm32_syscall_int80.fsmode
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fsmode)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffc4
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fsmode)
	call   sys_fsmode
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fsmode)

/* syscall_slong_t ioctlf(fd_t fd, ioctl_t command, iomode_t mode, void *arg) */
.section .text.x86.asm32_syscall_int80.ioctlf
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ioctlf)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffca
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ioctlf)
	call   sys_ioctlf
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_ioctlf)

/* Check if a transaction is currently in progress
 * @return: 0 : No RTM operation in progress
 * @return: 1 : An RTM operation is currently in progress */
/* syscall_ulong_t rtm_test(void) */
.section .text.x86.asm32_syscall_int80.rtm_test
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rtm_test)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffcd
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_rtm_test)
	call   sys_rtm_test
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_rtm_test)

/* Abort the current transaction  by having `sys_rtm_begin()' return  with
 * `RTM_ABORT_EXPLICIT | ((code << RTM_ABORT_CODE_S) & RTM_ABORT_CODE_M)'
 * If no transaction was in progress, behave as a no-op and return `-EOK'.
 * Otherwise,  this system call does not return normally, but returns from
 * the original `sys_rtm_begin()' */
/* errno_t rtm_abort(syscall_ulong_t code) */
.section .text.x86.asm32_syscall_int80.rtm_abort
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rtm_abort)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffce
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_rtm_abort)
	call   sys_rtm_abort
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_rtm_abort)

/* End a transaction
 * If  the  transaction was  successful,  return normally  (by  returning `-EOK').
 * If    the   transaction   failed,   `sys_rtm_begin()'   returns   `RTM_ABORT_*'
 * If no transaction was in progress, an `E_ILLEGAL_OPERATION' exception is thrown */
/* errno_t rtm_end(void) */
.section .text.x86.asm32_syscall_int80.rtm_end
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rtm_end)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffcf
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_rtm_end)
	call   sys_rtm_end
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_rtm_end)

/* Begin  an  RTM operation.  Note that  if  the arch-specific  RTM driver
 * wasn't already loaded into the kernel, it will be loaded automatically,
 * though any error that may happen during this will result in `RTM_NOSYS'
 * begin returned.
 * Note that while an RTM  operation is in progress,  only a very small  hand
 * full  of system calls are allowed to  be used. Attempting to use arbitrary
 * system calls will most likely  result in an `RTM_ABORT_FAILED' error,  and
 * attempting to access too much system memory in general will result in this
 * function returning  with  `RTM_ABORT_CAPACITY',  rather  than  succeeding.
 * The following is  a list  of system calls  which are  whitelisted for  use
 * during a transaction:
 *   - sys_rtm_begin:  Nested RTM operation
 *   - sys_rtm_end:    End an RTM operation
 *   - sys_rtm_abort:  Abort an RTM operation
 *   - sys_rtm_test:   Check if an RTM operation is in progress (always returns `1')
 * Anything else will most likely result in this system call returning `RTM_ABORT_FAILED'
 * @return: RTM_STARTED : RTM operation was started.
 * @return: RTM_NOSYS   : RTM isn't supposed because the RTM driver is missing, or cannot be loaded.
 * @return: RTM_ABORT_* : RTM operation failed (s.a. code from `<kos/rtm.h>') */
/* rtm_status_t rtm_begin(void) */
.section .text.x86.asm32_syscall_int80.rtm_begin
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rtm_begin)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffd0
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_rtm_begin)
	call   sys_rtm_begin
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_rtm_begin)

/* errno_t ftime64(struct timebx32_64 *tp) */
.section .text.x86.asm32_syscall_int80.ftime64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_ftime64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffdd
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ftime64)
	call   sys_ftime64
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_ftime64)

/* @param: times: When NULL, set the current time */
/* errno_t utime64(char const *filename, struct utimbufx32_64 const *times) */
.section .text.x86.asm32_syscall_int80.utime64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_utime64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffe2
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_utime64)
	call   sys_utime64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_utime64)

/* errno_t stime64(time64_t const *t) */
.section .text.x86.asm32_syscall_int80.stime64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_stime64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffe7
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_stime64)
	call   sys_stime64
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_stime64)

/* Construct   a   user-vio-fd  object   supporting  mmap(2),   with  actual
 * memory  accesses  being dispatched  by  adding them  as  pending requests
 * to an internal  queue that  should be read(2)  from by  a worker  thread,
 * which should then service those requests before responding by write(2)ing
 * the results of the operation back to the same fd.
 * HINT: The format of the structures that are read(2) and
 *       write(2)en can be found in `<libvio/userviofd.h>'
 * NOTE: Don't use this system call directly. Use `vio_create(3)'
 *       from `<libvio/vio.h>' instead.
 * @param: initial_size: The initial mmap(2)able size of the returned handle.
 *                       This  size may be  altered at a  later point in time
 *                       through use of `ftruncate(return)'
 * @param: flags:        Set of `0 | O_CLOEXEC | O_CLOFORK | O_NONBLOCK' */
/* fd_t userviofd(size_t initial_size, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_int80.userviofd
INTERN_WEAK_FUNCTION(__x86_asm32_int80_userviofd)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffec
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_userviofd)
	call   sys_userviofd
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_userviofd)

/* int64_t lseek64(fd_t fd, int64_t offset, syscall_ulong_t whence) */
.section .text.x86.asm32_syscall_int80.lseek64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_lseek64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffed
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_lseek64)
	call   sys_lseek64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_lseek64)

/* Trigger a coredump of the calling process.
 * @param: curr_state:       The  state as is still valid after any possible unwinding has already been done
 *                           Note that this state does not necessarily point to the location that originally
 *                           caused the problem that escalated into a coredump, but is the last valid stack-
 *                           unwind location at which unwinding could no longer continue.
 *                           When `NULL', `orig_state' is used instead, and `traceback_vector' and `traceback_length' are ignored.
 * @param: orig_state:       The original CPU state at where the associated `reason' got triggered
 *                           When `NULL', `curr_state' is used instead, and `traceback_vector' and `traceback_length' are ignored.
 *                           When   `curr_state'   is   also   `NULL',   then   the   current   CPU   state   is   used   instead.
 * @param: traceback_vector: (potentially  incomplete)   vector  of   additional  program   pointers  that   were
 *                           traversed   when   the  stack   was   walked  from   `orig_state'   to  `curr_state'
 *                           Note that earlier  entries within this  vector are further  up the call-stack,  with
 *                           traceback_vector[0] being meant to be the call-site of the function of `orig_state'.
 *                           Note that when `traceback_length != 0 && traceback_vector[traceback_length-1] == ucpustate_getpc(curr_state)',
 *                           it  can  be  assumed  that  the  traceback is  complete  and  contains  all  traversed  instruction locations.
 *                           In   this   case,  a   traceback  displayed   to   a  human   should  not   include   the  text   location  at
 *                           `traceback_vector[traceback_length-1]',    since    that    location    would    also    be    printed    when
 *                           unwinding is completed for the purposes of displaying a traceback.
 * @param: traceback_length: The number of program counters stored within `traceback_vector'
 * @param: reason:           The reason that resulted in the coredump (or `NULL' to get the same behavior as `E_OK')
 *                           For certain `unwind_error' values, this can also  point to other things, but is  always
 *                           allowed to be `NULL' to indicate default/stub values.
 * @param: unwind_error:     The  unwind  error that  caused the  coredump,  or `UNWIND_SUCCESS'  if unwinding
 *                           was  never  actually  performed,  and   `reason'  is  actually  a   `siginfo_t *'
 *                           Ignored when `reason == NULL', in which case `UNWIND_SUCCESS' is assumed instead. */
/* errno_t coredump(struct ucpustate32 const *curr_state, struct ucpustate32 const *orig_state, __HYBRID_PTR32(void const) const *traceback_vector, size_t traceback_length, union coredump_info32 const *reason, unwind_errno_t unwind_error) */
.section .text.x86.asm32_syscall_int80.coredump
INTERN_WEAK_FUNCTION(__x86_asm32_int80_coredump)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffee
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ebp  /* Arg #5 */
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_coredump)
	call   sys_coredump
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_coredump)

/* Trigger a debugger trap `trapno', optionally extended with  `regs'
 * at either the system call return location, or at the given `state'
 * In the later case, this system call will by default return to  the
 * given  `state', though given the purpose of this system call being
 * to inform a connected debugger  of some breakable event,  allowing
 * it to do whatever it wishes before execution is resumed.
 * @param: reason:   When non-NULL, the reason for the debug trap (else: use `SIGTRAP:DEBUGTRAP_REASON_NONE')
 * @param: state:    When non-NULL, the CPU state where the trap should return to by default
 * @return: -EOK:    `state' was NULL and the trap returned successfully
 * @return: -ENOENT: No debugger is connected to the calling process/process-group/system */
/* errno_t debugtrap(struct ucpustate32 const *state, struct debugtrap_reason32 const *reason) */
.section .text.x86.asm32_syscall_int80.debugtrap
INTERN_WEAK_FUNCTION(__x86_asm32_int80_debugtrap)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xffffffef
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_debugtrap)
	call   sys_debugtrap
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_debugtrap)

/* Get the current exception handler mode for the calling thread.
 * @param: pmode:       When non-`NULL', store the current mode, which is encoded as:
 *                       - One of `EXCEPT_HANDLER_MODE_(DISABLED|ENABLED|SIGHAND)'
 *                       - Or'd with a set of `EXCEPT_HANDLER_FLAG_(ONESHOT|SETHANDLER|SETSTACK)'
 * @param: phandler:    When   non-`NULL',   store  the   address   of  the   user-space   exception  handler.
 *                      Note that when no handler has been set (`!(*pmode & EXCEPT_HANDLER_FLAG_SETHANDLER)'),
 *                      then this pointer is set to `NULL'.
 * @param: phandler_sp: When non-`NULL', store the starting address of the user-space exception handler stack.
 *                      Note that  when no  stack has  been set  (`!(*pmode & EXCEPT_HANDLER_FLAG_SETSTACK)'),
 *                      or when the stack was defined to re-use the previous stack,
 *                      then this pointer is set to `EXCEPT_HANDLER_SP_CURRENT'.
 * @return: 0 :         Success.
 * @return: -1:EFAULT:  One of the given pointers is non-`NULL' and faulty */
/* errno_t get_exception_handler(__ULONG32_TYPE__ *pmode, __except_handler32_t *phandler, __HYBRID_PTR32(void) *phandler_sp) */
.section .text.x86.asm32_syscall_int80.get_exception_handler
INTERN_WEAK_FUNCTION(__x86_asm32_int80_get_exception_handler)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffff0
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_get_exception_handler)
	call   sys_get_exception_handler
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_get_exception_handler)

/* Set the exception handler mode for the calling thread.
 * Examples:
 *   - Set mode #3 from you `main()': `set_exception_handler(EXCEPT_HANDLER_MODE_SIGHAND, NULL, NULL)'
 *   - Set mode #4 (as done by libc): `set_exception_handler(EXCEPT_HANDLER_MODE_SIGHAND |
 *                                                           EXCEPT_HANDLER_FLAG_SETHANDLER,
 *                                                           &except_handler4, NULL)'
 * @param: mode:       One of `EXCEPT_HANDLER_MODE_*', optionally or'd with `EXCEPT_HANDLER_FLAG_*'
 * @param: handler:    When `EXCEPT_HANDLER_FLAG_SETHANDLER' is set, the address of the exception handler to use
 * @param: handler_sp: When `EXCEPT_HANDLER_FLAG_SETSTACK' is set, the address of the exception handler stack
 * @return: 0 :        Success.
 * @return: -1:EINVAL: The given `mode' is invalid */
/* errno_t set_exception_handler(syscall_ulong_t mode, except_handler_t handler, void *handler_sp) */
.section .text.x86.asm32_syscall_int80.set_exception_handler
INTERN_WEAK_FUNCTION(__x86_asm32_int80_set_exception_handler)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffff1
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_set_exception_handler)
	call   sys_set_exception_handler
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_set_exception_handler)

/* Create and return a new tty terminal controller connected to the given keyboard and display
 * The  newly created  device automatically gets  assigned an arbitrary  device number, before
 * being made available under a file `/dev/${name}'  (or rather: as ${name} within the  devfs)
 * @param: reserved: Reserved set of flags (Must pass `0'; for future expansion) */
/* fd_t mktty(char const *name, fd_t keyboard, fd_t display, syscall_ulong_t rsvd) */
.section .text.x86.asm32_syscall_int80.mktty
INTERN_WEAK_FUNCTION(__x86_asm32_int80_mktty)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffff2
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mktty)
	call   sys_mktty
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_mktty)

/* int64_t time64(int64_t *timer) */
.section .text.x86.asm32_syscall_int80.time64
INTERN_WEAK_FUNCTION(__x86_asm32_int80_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffff3
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_time64)
	call   sys_time64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_time64)

/* @param: flags: Set of `0 | AT_DOSPATH' */
/* errno_t fchdirat(fd_t dirfd, char const *path, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.fchdirat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_fchdirat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffff4
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fchdirat)
	call   sys_fchdirat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_fchdirat)

/* Create a new pseudo-terminal driver and store handles to both the
 * master  and slave ends  of the connection  in the given pointers. */
/* errno_t openpty(fd_t *amaster, fd_t *aslave, char *name, struct termios const *termp, struct winsize const *winp) */
.section .text.x86.asm32_syscall_int80.openpty
INTERN_WEAK_FUNCTION(__x86_asm32_int80_openpty)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffff5
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_openpty)
	call   sys_openpty
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_openpty)

/* >> rpc_schedule(2)
 * Schedule an RPC program to-be executed by some other thread. This  function
 * cannot guaranty that  the RPC  program is  always executed,  as the  target
 * thread terminate before the  conditions for the RPC  to be served are  ever
 * met. Note that these  conditions depend on the  given `mode'. Note that  on
 * multi-arch  platforms (such as  x86), the register numbers,  as well as the
 * address size used by `program' depend on the execution mode of `target_tid'
 * 
 * NOTE: Only a cancellation point when `RPC_JOIN_WAITFOR' is used!
 * 
 * @param: target_tid:      The TID of the targeted thread
 * @param: mode:            One of `RPC_SYNCMODE_*',  optionally or'd  with
 *                          one of `RPC_SYSRESTART_*', optionally or'd with
 *                          one of `RPC_PRIORITY_*',  optionally or'd  with
 *                          one of  `RPC_DOMAIN_*',  optionally  or'd  with
 *                          one of `RPC_JOIN_*'
 * @param: program:         The RPC program to execute (sequences of `RPC_OP_*')
 * @param: params:          RPC program parameters (for `RPC_OP_push_param')
 * @param: max_param_count: The max # of `params' used by `program'
 * 
 * @return: 0 :                Success
 * @throws: E_SEGFAULT:        Faulty pointers were given
 * @throws: E_INVALID_ARGUMENT:E_INVALID_ARGUMENT_CONTEXT_RPC_SCHEDULE_MODE:
 *                             The given `mode' is invalid.
 * @throws: E_INVALID_ARGUMENT:E_INVALID_ARGUMENT_CONTEXT_RPC_PROGRAM_INSTRUCTION:
 *                             The RPC program  contains illegal  instructions.
 *                             In this case, modifications made by instructions
 *                             encountered before the illegal one(s) will still
 *                             have  happened, meaning that the target thread's
 *                             state may have become inconsistent.
 * @throws: E_PROCESS_EXITED:  The target thread has already terminated, or
 *                             doesn't exist. Note  though that unless  the
 *                             thread  is  part  of your  own  process, are
 *                             still many reasons  outside of your  control
 *                             for why it  may terminate immediately  after
 *                             the RPC program finished. */
/* errno_t rpc_schedule(pid_t target_tid, syscall_ulong_t mode, void const *program, __HYBRID_PTR32(void const) const *params, size_t max_param_count) */
.section .text.x86.asm32_syscall_int80.rpc_schedule
INTERN_WEAK_FUNCTION(__x86_asm32_int80_rpc_schedule)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffff7
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_rpc_schedule)
	call   sys_rpc_schedule
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_rpc_schedule)

/* Returns  the  absolute   filesystem  path  for   the  specified   file
 * When `AT_SYMLINK_NOFOLLOW' is given, a final symlink is  dereferenced,
 * causing the pointed-to file location to be retrieved. - Otherwise, the
 * location of the link is printed instead.
 * You may pass `AT_READLINK_REQSIZE' to always have the function return
 * the   required   buffer   size,   rather   than   the   used    size.
 * @param: flags: Set of `0 | AT_ALTPATH | AT_SYMLINK_NOFOLLOW | AT_READLINK_REQSIZE | AT_DOSPATH' */
/* ssize_t frealpathat(fd_t dirfd, char const *filename, char *buf, size_t buflen, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.frealpathat
INTERN_WEAK_FUNCTION(__x86_asm32_int80_frealpathat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffff8
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edi  /* Arg #4 */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_frealpathat)
	call   sys_frealpathat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_frealpathat)

/* >> detach(2)
 * Detach the descriptor of `PID' from the thread that
 * would have received a signal when it changes state,
 * as well as prevent the  thread from turning into  a
 * zombie once it dies.
 * For simplicity, think of it like this:
 *   - pthread_create()  -->  clone()
 *   - pthread_join()    -->  wait()
 *   - pthread_detach()  -->  detach()  // Linux's missing link, now implemented
 * A total of 4 special cases exists to alter the behavior of this function:
 *   - PID == 0 || PID == gettid():
 *     Detach the calling  thread from  the set of  running children  within
 *     its own process.  Note however  that when this  is done  by the  main
 *     thread of the process, gettid() will equal getpid(), and the behavior
 *     will be different.
 *   - PID == getpid():
 *     Detach the calling process from its parent, essentially daemonizing
 *     the  calling   process   the   same  way   a   double-fork   would:
 *     >> if (fork() == 0) {
 *     >> 	if (fork() == 0) {
 *     >> 		// This is a daemonized process
 *     >> 		// aka. the parent process no longer knows
 *     >> 		// about us, and also can't wait(2) on us.
 *     >> 		...
 *     >> 	}
 *     >> 	exit(0);
 *     >> }
 *     Same as:
 *     >> if (fork() == 0) {
 *     >> 	detach(0); // or `detach(getpid())', since 0 --> gettid() and gettid() == getpid()
 *     >> 	// This is a daemonized process
 *     >> 	// aka. the parent process no longer knows
 *     >> 	// about us, and also can't wait(2) on us.
 *     >> 	...
 *     >> }
 *   - PID == -1:
 *     Detach all child processes/threads  of the calling process,  essentially
 *     turning its chain of children into a clean slate that no longer contains
 *     any wait(2)able child threads or processes.
 *     If no waitable children existed, `ECHILD' is set; else `0' is returned.
 * The given `pid' must be:
 *   - A thread without the caller's process
 *   - A child process of the caller's process
 * NOTE: If a thread is created using clone() with `CLONE_DETACHED' set,
 *       it will behave effectively as though this function had  already
 *       be called.
 * @return: -ECHILD:         `PID' was equal to `-1', but no waitable children existed
 * @throw: E_PROCESS_EXITED: No such  thread/process exists,  or  the thread  isn't  isn't
 *                           a thread in your process, or a child process of your process. */
/* errno_t detach(pid_t pid) */
.section .text.x86.asm32_syscall_int80.detach
INTERN_WEAK_FUNCTION(__x86_asm32_int80_detach)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffff9
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_detach)
	call   sys_detach
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_detach)

/* You may pass `AT_READLINK_REQSIZE' to always have the function return
 * the   required   buffer   size,   rather   than   the   used    size.
 * @param: flags: Set of `0 | AT_ALTPATH | AT_READLINK_REQSIZE | AT_DOSPATH' */
/* ssize_t frealpath4(fd_t fd, char *resolved, size_t buflen, atflag_t flags) */
.section .text.x86.asm32_syscall_int80.frealpath4
INTERN_WEAK_FUNCTION(__x86_asm32_int80_frealpath4)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffffa
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_frealpath4)
	call   sys_frealpath4
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_frealpath4)

/* Returns a bitset of all of the currently mounted dos-drives */
/* syscall_slong_t getdrives(void) */
.section .text.x86.asm32_syscall_int80.getdrives
INTERN_WEAK_FUNCTION(__x86_asm32_int80_getdrives)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffffb
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_getdrives)
	call   sys_getdrives
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_getdrives)

/* Write up to `bufsize' bytes from `buf' into `fd'
 * When `fd' has the `O_NONBLOCK' flag set, only write as much data as
 * possible at the time the call was made, and throw `E_WOULDBLOCK' if
 * no data could be written at the time.
 * @return: <= bufsize: The actual amount of written bytes
 * @return: 0         : No more data can be written */
/* ssize_t writef(fd_t fd, void const *buf, size_t bufsize, iomode_t mode) */
.section .text.x86.asm32_syscall_int80.writef
INTERN_WEAK_FUNCTION(__x86_asm32_int80_writef)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffffc
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_writef)
	call   sys_writef
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_writef)

/* Read up to `bufsize' bytes from `fd' into `buf'
 * When  `fd' has the `O_NONBLOCK' flag set, only read as much data as was
 * available at the time the call was made, and throw `E_WOULDBLOCK' if no
 * data was available at the time.
 * @return: <= bufsize: The actual amount of read bytes
 * @return: 0         : EOF */
/* ssize_t readf(fd_t fd, void *buf, size_t bufsize, iomode_t mode) */
.section .text.x86.asm32_syscall_int80.readf
INTERN_WEAK_FUNCTION(__x86_asm32_int80_readf)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_int80
	.cfi_lsda 0, 0xfffffffd
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_readf)
	call   sys_readf
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	iret
	.cfi_endproc
END(__x86_asm32_int80_readf)










/* errno_t restart_syscall(void) */
.section .text.x86.asm32_syscall_sysenter.restart_syscall
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_restart_syscall)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x0
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_restart_syscall)
	call   sys_restart_syscall
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_restart_syscall)

/* Terminate the calling thread (_NOT_ process!)
 * @param: exit_code: Thread exit code (as returned by `wait(2)') */
/* void exit(syscall_ulong_t exit_code) */
.section .text.x86.asm32_syscall_sysenter.exit
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_exit)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_exit)
	call   sys_exit
	.cfi_endproc
END(__x86_asm32_sysenter_exit)

/* Clone the calling thread into a second process and return twice, once
 * in  the parent process where this function returns the (non-zero) PID
 * of  the forked child process, and a  second time in the child process
 * itself, where ZERO(0) is returned.
 * The child then usually proceeds by calling `exec(2)' to replace its
 * application image with  that of another  program that the  original
 * parent can then `wait(2)' for. (s.a. `vfork(2)')
 * @return: 0 : You're the new process that was created
 * @return: * : The `return' value is the pid of your new child process */
/* pid_t fork(void) */
.section .text.x86.asm32_syscall_sysenter.fork
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fork)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x2
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_fork)
	call   sys_fork
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_fork)

/* Read up to `bufsize' bytes from `fd' into `buf'
 * When  `fd' has the `O_NONBLOCK' flag set, only read as much data as was
 * available at the time the call was made, and throw `E_WOULDBLOCK' if no
 * data was available at the time.
 * @return: <= bufsize: The actual amount of read bytes
 * @return: 0         : EOF */
/* ssize_t read(fd_t fd, void *buf, size_t bufsize) */
.section .text.x86.asm32_syscall_sysenter.read
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_read)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x3
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_read)
	call   sys_read
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_read)

/* Write up to `bufsize' bytes from `buf' into `fd'
 * When `fd' has the `O_NONBLOCK' flag set, only write as much data as
 * possible at the time the call was made, and throw `E_WOULDBLOCK' if
 * no data could be written at the time.
 * @return: <= bufsize: The actual amount of written bytes
 * @return: 0         : No more data can be written */
/* ssize_t write(fd_t fd, void const *buf, size_t bufsize) */
.section .text.x86.asm32_syscall_sysenter.write
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_write)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x4
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_write)
	call   sys_write
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_write)

/* Open  a  new  file  handle  to  the  file  specified  by `filename'
 * When  `oflags & O_CREAT',   then  `mode'   specifies  the   initial
 * file  access  permissions with  which  the file  should  be opened.
 * On KOS, the returned handle can be anything, but is usually one of:
 *   - HANDLE_TYPE_PATH:       When `O_PATH' was given
 *   - HANDLE_TYPE_FILEHANDLE: For `S_IFREG' regular files
 *   - HANDLE_TYPE_FIFOHANDLE: For `S_IFIFO' pipe files
 *   - HANDLE_TYPE_DIRHANDLE:  For `S_IFDIR' directories
 *   - HANDLE_TYPE_MFILE:      The actual filesystem object (including device files)
 *   - *:                      Certain filesystem names can literally return anything, such
 *                             as `/proc/self/fd/1234',  which  is  more  like  `dup(1234)' */
/* fd_t open(char const *filename, oflag_t oflags, mode_t mode) */
.section .text.x86.asm32_syscall_sysenter.open
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_open)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x5
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_open)
	call   sys_open
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_open)

/* Close a given file descriptor/handle `fd' */
/* errno_t close(fd_t fd) */
.section .text.x86.asm32_syscall_sysenter.close
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_close)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x6
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_close)
	call   sys_close
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_close)

/* Wait for a child process:
 *  - `pid < -1':  Wait for any child process whose process group ID is `-PID'
 *  - `pid == -1': Wait for any child process
 *  - `pid == 0':  Wait for any child process whose process group ID is that of the caller
 *  - `pid > 0':   Wait for the child whose process ID is equal to `PID'
 * @param: options: Set of `WNOHANG | WUNTRACED | WCONTINUED' (as a KOS extension, `WNOWAIT' is also accepted) */
/* pid_t waitpid(pid_t pid, int32_t *stat_loc, syscall_ulong_t options) */
.section .text.x86.asm32_syscall_sysenter.waitpid
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_waitpid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x7
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_waitpid)
	call   sys_waitpid
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_waitpid)

/* fd_t creat(char const *filename, mode_t mode) */
.section .text.x86.asm32_syscall_sysenter.creat
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_creat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x8
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_creat)
	call   sys_creat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_creat)

/* errno_t link(char const *existing_file, char const *link_file) */
.section .text.x86.asm32_syscall_sysenter.link
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_link)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x9
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_link)
	call   sys_link
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_link)

/* errno_t unlink(char const *filename) */
.section .text.x86.asm32_syscall_sysenter.unlink
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_unlink)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xa
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_unlink)
	call   sys_unlink
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_unlink)

/* Replace the calling  process with  the application  image referred  to by  `path' /  `file'
 * and execute it's `main()' method, passing the given `argv', and setting `environ' to `envp' */
/* errno_t execve(char const *path, __HYBRID_PTR32(char const) const *argv, __HYBRID_PTR32(char const) const *envp) */
.section .text.x86.asm32_syscall_sysenter.execve
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_execve)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xb
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_execve)
	call   sys_execve
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_execve)

/* errno_t chdir(char const *path) */
.section .text.x86.asm32_syscall_sysenter.chdir
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_chdir)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xc
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_chdir)
	call   sys_chdir
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_chdir)

/* int32_t time(int32_t *timer) */
.section .text.x86.asm32_syscall_sysenter.time
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_time)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xd
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_time)
	call   sys_time
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_time)

/* errno_t mknod(char const *nodename, mode_t mode, dev_t dev) */
.section .text.x86.asm32_syscall_sysenter.mknod
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mknod)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xe
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mknod)
	call   sys_mknod
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_mknod)

/* errno_t chmod(char const *filename, mode_t mode) */
.section .text.x86.asm32_syscall_sysenter.chmod
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_chmod)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xf
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_chmod)
	call   sys_chmod
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_chmod)

/* errno_t lchown(char const *filename, uint16_t owner, uint16_t group) */
.section .text.x86.asm32_syscall_sysenter.lchown
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_lchown)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x10
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_lchown)
	call   sys_lchown
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_lchown)

/* errno_t break(void) */
.section .text.x86.asm32_syscall_sysenter.break
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_break)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x11
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_break)
	call   sys_break
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_break)

/* errno_t oldstat(char const *filename, struct linux_oldstat *statbuf) */
.section .text.x86.asm32_syscall_sysenter.oldstat
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_oldstat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x12
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_oldstat)
	call   sys_oldstat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_oldstat)

/* syscall_slong_t lseek(fd_t fd, syscall_slong_t offset, syscall_ulong_t whence) */
.section .text.x86.asm32_syscall_sysenter.lseek
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_lseek)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x13
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_lseek)
	call   sys_lseek
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_lseek)

/* pid_t getpid(void) */
.section .text.x86.asm32_syscall_sysenter.getpid
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getpid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x14
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_getpid)
	call   sys_getpid
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getpid)

/* errno_t mount(char const *special_file, char const *dir, char const *fstype, syscall_ulong_t mountflags, void const *data) */
.section .text.x86.asm32_syscall_sysenter.mount
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mount)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x15
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mount)
	call   sys_mount
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_mount)

/* errno_t umount(char const *special_file) */
.section .text.x86.asm32_syscall_sysenter.umount
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_umount)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x16
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_umount)
	call   sys_umount
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_umount)

/* >> setuid(2)
 * Set the UID of the calling thread (this is the so-called ~real~ UID)
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setuid(uint16_t uid) */
.section .text.x86.asm32_syscall_sysenter.setuid
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_setuid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x17
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setuid)
	call   sys_setuid
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_setuid)

/* >> getuid(2)
 * @return: * : The UID of the calling thread (this is the so-called ~real~ UID) */
/* uint16_t getuid(void) */
.section .text.x86.asm32_syscall_sysenter.getuid
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getuid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x18
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_getuid)
	call   sys_getuid
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getuid)

/* errno_t stime(time32_t const *t) */
.section .text.x86.asm32_syscall_sysenter.stime
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_stime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x19
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_stime)
	call   sys_stime
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_stime)

/* syscall_slong_t ptrace(syscall_ulong_t request, pid_t pid, void *addr, void *data) */
.section .text.x86.asm32_syscall_sysenter.ptrace
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_ptrace)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ptrace)
	call   sys_ptrace
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_ptrace)

/* syscall_ulong_t alarm(syscall_ulong_t seconds) */
.section .text.x86.asm32_syscall_sysenter.alarm
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_alarm)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_alarm)
	call   sys_alarm
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_alarm)

/* errno_t oldfstat(fd_t fd, struct linux_oldstat *statbuf) */
.section .text.x86.asm32_syscall_sysenter.oldfstat
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_oldfstat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_oldfstat)
	call   sys_oldfstat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_oldfstat)

/* Same as `select(0, NULL, NULL, NULL, NULL)' */
/* errno_t pause(void) */
.section .text.x86.asm32_syscall_sysenter.pause
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_pause)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_pause)
	call   sys_pause
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_pause)

/* @param: times: When NULL, set the current time */
/* errno_t utime(char const *filename, struct utimbufx32 const *times) */
.section .text.x86.asm32_syscall_sysenter.utime
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_utime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_utime)
	call   sys_utime
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_utime)

/* errno_t stty(void) */
.section .text.x86.asm32_syscall_sysenter.stty
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_stty)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_stty)
	call   sys_stty
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_stty)

/* errno_t gtty(void) */
.section .text.x86.asm32_syscall_sysenter.gtty
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_gtty)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x20
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_gtty)
	call   sys_gtty
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_gtty)

/* @param: type: Set of `R_OK|W_OK|X_OK' or `F_OK' */
/* errno_t access(char const *filename, syscall_ulong_t type) */
.section .text.x86.asm32_syscall_sysenter.access
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_access)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x21
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_access)
	call   sys_access
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_access)

/* errno_t nice(syscall_slong_t inc) */
.section .text.x86.asm32_syscall_sysenter.nice
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_nice)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x22
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_nice)
	call   sys_nice
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_nice)

/* errno_t ftime(struct timebx32 *tp) */
.section .text.x86.asm32_syscall_sysenter.ftime
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_ftime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x23
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ftime)
	call   sys_ftime
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_ftime)

/* errno_t sync(void) */
.section .text.x86.asm32_syscall_sysenter.sync
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sync)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x24
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_sync)
	call   sys_sync
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_sync)

/* errno_t kill(pid_t pid, signo_t signo) */
.section .text.x86.asm32_syscall_sysenter.kill
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_kill)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x25
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_kill)
	call   sys_kill
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_kill)

/* errno_t rename(char const *oldname, char const *newname_or_path) */
.section .text.x86.asm32_syscall_sysenter.rename
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_rename)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x26
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_rename)
	call   sys_rename
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_rename)

/* errno_t mkdir(char const *pathname, mode_t mode) */
.section .text.x86.asm32_syscall_sysenter.mkdir
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mkdir)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x27
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mkdir)
	call   sys_mkdir
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_mkdir)

/* errno_t rmdir(char const *path) */
.section .text.x86.asm32_syscall_sysenter.rmdir
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_rmdir)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x28
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_rmdir)
	call   sys_rmdir
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_rmdir)

/* fd_t dup(fd_t fd) */
.section .text.x86.asm32_syscall_sysenter.dup
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_dup)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x29
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_dup)
	call   sys_dup
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_dup)

/* errno_t pipe(fd_t[2] pipedes) */
.section .text.x86.asm32_syscall_sysenter.pipe
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_pipe)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x2a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pipe)
	call   sys_pipe
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_pipe)

/* clock_t times(struct tmsx32 *buf) */
.section .text.x86.asm32_syscall_sysenter.times
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_times)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x2b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_times)
	call   sys_times
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_times)

/* errno_t prof(void) */
.section .text.x86.asm32_syscall_sysenter.prof
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_prof)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x2c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_prof)
	call   sys_prof
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_prof)

/* errno_t brk(void *addr) */
.section .text.x86.asm32_syscall_sysenter.brk
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_brk)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x2d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_brk)
	call   sys_brk
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_brk)

/* >> setgid(2)
 * Set the GID of the calling thread (this is the so-called ~real~ GID)
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setgid(uint16_t gid) */
.section .text.x86.asm32_syscall_sysenter.setgid
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_setgid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x2e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setgid)
	call   sys_setgid
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_setgid)

/* >> getgid(2)
 * @return: * : The GID of the calling thread (this is the so-called ~real~ GID) */
/* uint16_t getgid(void) */
.section .text.x86.asm32_syscall_sysenter.getgid
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getgid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x2f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_getgid)
	call   sys_getgid
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getgid)

/* __sigactionx32_sa_handler_t signal(signo_t signo, __sigactionx32_sa_handler_t handler) */
.section .text.x86.asm32_syscall_sysenter.signal
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_signal)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x30
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_signal)
	call   sys_signal
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_signal)

/* >> geteuid(2)
 * @return: * : The   effective  UID  of  the  calling  thread.
 *              This is the one used for most permission checks */
/* uint16_t geteuid(void) */
.section .text.x86.asm32_syscall_sysenter.geteuid
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_geteuid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x31
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_geteuid)
	call   sys_geteuid
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_geteuid)

/* >> getegid(2)
 * @return: * : The   effective  GID  of  the  calling  thread.
 *              This is the one used for most permission checks */
/* uint16_t getegid(void) */
.section .text.x86.asm32_syscall_sysenter.getegid
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getegid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x32
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_getegid)
	call   sys_getegid
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getegid)

/* errno_t acct(char const *filename) */
.section .text.x86.asm32_syscall_sysenter.acct
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_acct)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x33
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_acct)
	call   sys_acct
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_acct)

/* errno_t umount2(char const *special_file, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.umount2
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_umount2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x34
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_umount2)
	call   sys_umount2
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_umount2)

/* errno_t lock(void) */
.section .text.x86.asm32_syscall_sysenter.lock
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_lock)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x35
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_lock)
	call   sys_lock
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_lock)

/* syscall_slong_t ioctl(fd_t fd, ioctl_t command, void *arg) */
.section .text.x86.asm32_syscall_sysenter.ioctl
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_ioctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x36
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ioctl)
	call   sys_ioctl
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_ioctl)

/* syscall_slong_t fcntl(fd_t fd, fcntl_t command, void *arg) */
.section .text.x86.asm32_syscall_sysenter.fcntl
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fcntl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x37
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fcntl)
	call   sys_fcntl
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_fcntl)

/* errno_t mpx(void) */
.section .text.x86.asm32_syscall_sysenter.mpx
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mpx)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x38
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_mpx)
	call   sys_mpx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_mpx)

/* errno_t setpgid(pid_t pid, pid_t pgid) */
.section .text.x86.asm32_syscall_sysenter.setpgid
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_setpgid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x39
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setpgid)
	call   sys_setpgid
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_setpgid)

/* errno_t ulimit(void) */
.section .text.x86.asm32_syscall_sysenter.ulimit
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_ulimit)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x3a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_ulimit)
	call   sys_ulimit
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_ulimit)

/* errno_t oldolduname(struct linux_oldolduname *name) */
.section .text.x86.asm32_syscall_sysenter.oldolduname
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_oldolduname)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x3b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_oldolduname)
	call   sys_oldolduname
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_oldolduname)

/* mode_t umask(mode_t mode) */
.section .text.x86.asm32_syscall_sysenter.umask
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_umask)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x3c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_umask)
	call   sys_umask
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_umask)

/* errno_t chroot(char const *path) */
.section .text.x86.asm32_syscall_sysenter.chroot
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_chroot)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x3d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_chroot)
	call   sys_chroot
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_chroot)

/* errno_t ustat(dev_t dev, struct ustat *ubuf) */
.section .text.x86.asm32_syscall_sysenter.ustat
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_ustat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x3e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ustat)
	call   sys_ustat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_ustat)

/* fd_t dup2(fd_t oldfd, fd_t newfd) */
.section .text.x86.asm32_syscall_sysenter.dup2
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_dup2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x3f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_dup2)
	call   sys_dup2
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_dup2)

/* pid_t getppid(void) */
.section .text.x86.asm32_syscall_sysenter.getppid
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getppid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x40
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_getppid)
	call   sys_getppid
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getppid)

/* pid_t getpgrp(void) */
.section .text.x86.asm32_syscall_sysenter.getpgrp
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getpgrp)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x41
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_getpgrp)
	call   sys_getpgrp
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getpgrp)

/* pid_t setsid(void) */
.section .text.x86.asm32_syscall_sysenter.setsid
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_setsid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x42
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_setsid)
	call   sys_setsid
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_setsid)

/* errno_t sigaction(signo_t signo, struct __old_kernel_sigactionx32 const *act, struct __old_kernel_sigactionx32 *oact) */
.section .text.x86.asm32_syscall_sysenter.sigaction
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sigaction)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x43
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sigaction)
	call   sys_sigaction
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_sigaction)

/* uint32_t sgetmask(void) */
.section .text.x86.asm32_syscall_sysenter.sgetmask
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sgetmask)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x44
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_sgetmask)
	call   sys_sgetmask
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_sgetmask)

/* uint32_t ssetmask(uint32_t sigmask) */
.section .text.x86.asm32_syscall_sysenter.ssetmask
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_ssetmask)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x45
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ssetmask)
	call   sys_ssetmask
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_ssetmask)

/* >> setreuid(2)
 * Set the real and effective UID of the calling thread.
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setreuid(uint16_t ruid, uint16_t euid) */
.section .text.x86.asm32_syscall_sysenter.setreuid
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_setreuid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x46
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setreuid)
	call   sys_setreuid
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_setreuid)

/* >> setregid(2)
 * Set the real and effective GID of the calling thread.
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setregid(uint16_t rgid, uint16_t egid) */
.section .text.x86.asm32_syscall_sysenter.setregid
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_setregid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x47
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setregid)
	call   sys_setregid
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_setregid)

/* >> sigsuspend(2), rt_sigsuspend(2)
 * Atomically save and  set the caller's  signal mask to  `set', then wait  for
 * one of the unmasked (iow: `!sigismember')-signals to arrive before restoring
 * the old signal mask.
 * @param: set: The set of signals on which to wait
 * @return: -1: [errno=EINTR] The signal handler for `signo' was executed. */
/* errno_t sigsuspend(struct __old_sigset_struct const *set) */
.section .text.x86.asm32_syscall_sysenter.sigsuspend
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sigsuspend)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x48
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sigsuspend)
	call   sys_sigsuspend
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_sigsuspend)

/* errno_t sigpending(struct __old_sigset_struct *set) */
.section .text.x86.asm32_syscall_sysenter.sigpending
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sigpending)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x49
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sigpending)
	call   sys_sigpending
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_sigpending)

/* errno_t sethostname(char const *name, size_t len) */
.section .text.x86.asm32_syscall_sysenter.sethostname
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sethostname)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x4a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sethostname)
	call   sys_sethostname
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_sethostname)

/* @param: resource: One of `RLIMIT_*' from <sys/resource.h> */
/* errno_t setrlimit(syscall_ulong_t resource, struct rlimitx32 const *rlimits) */
.section .text.x86.asm32_syscall_sysenter.setrlimit
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_setrlimit)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x4b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setrlimit)
	call   sys_setrlimit
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_setrlimit)

/* @param: resource: One of `RLIMIT_*' from <sys/resource.h> */
/* errno_t getrlimit(syscall_ulong_t resource, struct rlimitx32 *rlimits) */
.section .text.x86.asm32_syscall_sysenter.getrlimit
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getrlimit)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x4c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getrlimit)
	call   sys_getrlimit
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getrlimit)

/* @param: who: One of `RUSAGE_SELF', `RUSAGE_CHILDREN' or `RUSAGE_THREAD' */
/* errno_t getrusage(syscall_slong_t who, struct rusagex32 *tv) */
.section .text.x86.asm32_syscall_sysenter.getrusage
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getrusage)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x4d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getrusage)
	call   sys_getrusage
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getrusage)

/* errno_t gettimeofday(struct timevalx32 *tv, struct timezone *tz) */
.section .text.x86.asm32_syscall_sysenter.gettimeofday
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_gettimeofday)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x4e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_gettimeofday)
	call   sys_gettimeofday
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_gettimeofday)

/* errno_t settimeofday(struct timevalx32 const *tv, struct timezone const *tz) */
.section .text.x86.asm32_syscall_sysenter.settimeofday
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_settimeofday)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x4f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_settimeofday)
	call   sys_settimeofday
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_settimeofday)

/* @return: * :     [count == 0] The required number of groups
 * @return: * :     [count != 0] The number of groups that were actually returned
 * @throw: -EINVAL: [count != 0] There are more than `count' groups (NOTE: No exception is thrown for this case!) */
/* ssize_t getgroups(size_t count, uint16_t[] list) */
.section .text.x86.asm32_syscall_sysenter.getgroups
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getgroups)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x50
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getgroups)
	call   sys_getgroups
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getgroups)

/* errno_t setgroups(size_t count, uint16_t const *groups) */
.section .text.x86.asm32_syscall_sysenter.setgroups
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_setgroups)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x51
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setgroups)
	call   sys_setgroups
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_setgroups)

/* ssize_t select(struct sel_arg_structx32 const *arg) */
.section .text.x86.asm32_syscall_sysenter.select
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_select)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x52
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_select)
	call   sys_select
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_select)

/* errno_t symlink(char const *link_text, char const *target_path) */
.section .text.x86.asm32_syscall_sysenter.symlink
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_symlink)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x53
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_symlink)
	call   sys_symlink
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_symlink)

/* errno_t oldlstat(char const *filename, struct linux_oldstat *statbuf) */
.section .text.x86.asm32_syscall_sysenter.oldlstat
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_oldlstat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x54
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_oldlstat)
	call   sys_oldlstat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_oldlstat)

/* ssize_t readlink(char const *path, char *buf, size_t buflen) */
.section .text.x86.asm32_syscall_sysenter.readlink
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_readlink)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x55
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_readlink)
	call   sys_readlink
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_readlink)

/* errno_t uselib(char const *library) */
.section .text.x86.asm32_syscall_sysenter.uselib
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_uselib)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x56
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_uselib)
	call   sys_uselib
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_uselib)

/* @param: swapflags: Set of `SWAP_FLAG_*' */
/* errno_t swapon(char const *pathname, syscall_ulong_t swapflags) */
.section .text.x86.asm32_syscall_sysenter.swapon
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_swapon)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x57
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_swapon)
	call   sys_swapon
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_swapon)

/* @param: how: One of the `RB_*' constants from <sys/reboot.h> */
/* errno_t reboot(syscall_ulong_t how) */
.section .text.x86.asm32_syscall_sysenter.reboot
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_reboot)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x58
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_reboot)
	call   sys_reboot
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_reboot)

/* Read exactly one directory entry from `fd'
 * Note that the linux version of this system call has one additional argument `count'.
 * However, within the  linux kernel implementation,  that argument is  unconditionally
 * ignored,  and the system call will _always_ read exactly 1 directory entry from `fd'
 * @return: 1 : Read on directory entry
 * @return: 0 : End-of-directory */
/* syscall_slong_t readdir(fd_t fd, struct old_linux_direntx32 *buf) */
.section .text.x86.asm32_syscall_sysenter.readdir
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_readdir)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x59
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_readdir)
	call   sys_readdir
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_readdir)

/* @param: prot:  Either `PROT_NONE', or set of `PROT_EXEC | PROT_WRITE | PROT_READ | PROT_SEM | PROT_SHARED'
 * @param: flags: One of `MAP_SHARED', 'MAP_SHARED_VALIDATE' or `MAP_PRIVATE', optionally or'd
 *               with  a  set of  `MAP_ANONYMOUS  | MAP_FIXED  |  MAP_GROWSDOWN |  MAP_LOCKED |
 *               MAP_NONBLOCK  |  MAP_NORESERVE  |  MAP_POPULATE  |  MAP_STACK  |  MAP_SYNC   |
 *               MAP_UNINITIALIZED | MAP_DONT_MAP | MAP_FIXED_NOREPLACE | MAP_OFFSET64_POINTER' */
/* void *mmap(void *addr, size_t len, syscall_ulong_t prot, syscall_ulong_t flags, fd_t fd, syscall_ulong_t offset) */
.section .text.x86.asm32_syscall_sysenter.mmap
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mmap)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x5a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   4(%ebp)  /* Arg #5 (WARNING: SEGFAULT!) */
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mmap)
	call   sys_mmap
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_mmap)

/* errno_t munmap(void *addr, size_t len) */
.section .text.x86.asm32_syscall_sysenter.munmap
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_munmap)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x5b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_munmap)
	call   sys_munmap
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_munmap)

/* errno_t truncate(char const *filename, syscall_ulong_t length) */
.section .text.x86.asm32_syscall_sysenter.truncate
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_truncate)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x5c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_truncate)
	call   sys_truncate
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_truncate)

/* errno_t ftruncate(fd_t fd, syscall_ulong_t length) */
.section .text.x86.asm32_syscall_sysenter.ftruncate
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_ftruncate)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x5d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ftruncate)
	call   sys_ftruncate
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_ftruncate)

/* errno_t fchmod(fd_t fd, mode_t mode) */
.section .text.x86.asm32_syscall_sysenter.fchmod
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fchmod)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x5e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fchmod)
	call   sys_fchmod
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_fchmod)

/* errno_t fchown(fd_t fd, uint16_t owner, uint16_t group) */
.section .text.x86.asm32_syscall_sysenter.fchown
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fchown)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x5f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fchown)
	call   sys_fchown
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_fchown)

/* @param: which: One of `PRIO_PROCESS', `PRIO_PGRP' or `PRIO_USER' */
/* syscall_slong_t getpriority(syscall_ulong_t which, id_t who) */
.section .text.x86.asm32_syscall_sysenter.getpriority
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getpriority)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x60
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getpriority)
	call   sys_getpriority
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getpriority)

/* @param: which: One of `PRIO_PROCESS', `PRIO_PGRP' or `PRIO_USER' */
/* errno_t setpriority(syscall_ulong_t which, id_t who, syscall_ulong_t value) */
.section .text.x86.asm32_syscall_sysenter.setpriority
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_setpriority)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x61
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setpriority)
	call   sys_setpriority
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_setpriority)

/* errno_t profil(void) */
.section .text.x86.asm32_syscall_sysenter.profil
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_profil)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x62
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_profil)
	call   sys_profil
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_profil)

/* errno_t statfs(char const *file, struct statfsx32 *buf) */
.section .text.x86.asm32_syscall_sysenter.statfs
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_statfs)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x63
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_statfs)
	call   sys_statfs
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_statfs)

/* errno_t fstatfs(fd_t file, struct statfsx32 *buf) */
.section .text.x86.asm32_syscall_sysenter.fstatfs
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fstatfs)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x64
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fstatfs)
	call   sys_fstatfs
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_fstatfs)

/* errno_t ioperm(syscall_ulong_t from, syscall_ulong_t num, syscall_ulong_t turn_on) */
.section .text.x86.asm32_syscall_sysenter.ioperm
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_ioperm)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x65
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ioperm)
	call   sys_ioperm
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_ioperm)

/* __LONG32_TYPE__ socketcall(__ULONG32_TYPE__ call, __ULONG32_TYPE__ *args) */
.section .text.x86.asm32_syscall_sysenter.socketcall
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_socketcall)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x66
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_socketcall)
	call   sys_socketcall
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_socketcall)

/* ssize_t syslog(syscall_ulong_t level, char const *str, size_t len) */
.section .text.x86.asm32_syscall_sysenter.syslog
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_syslog)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x67
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_syslog)
	call   sys_syslog
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_syslog)

/* @param: which: One of `ITIMER_REAL', `ITIMER_VIRTUAL' or `ITIMER_PROF' */
/* errno_t setitimer(syscall_ulong_t which, struct __itimervalx32 const *newval, struct __itimervalx32 *oldval) */
.section .text.x86.asm32_syscall_sysenter.setitimer
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_setitimer)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x68
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setitimer)
	call   sys_setitimer
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_setitimer)

/* @param: which: One of `ITIMER_REAL', `ITIMER_VIRTUAL' or `ITIMER_PROF' */
/* errno_t getitimer(syscall_ulong_t which, struct __itimervalx32 *curr_value) */
.section .text.x86.asm32_syscall_sysenter.getitimer
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getitimer)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x69
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getitimer)
	call   sys_getitimer
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getitimer)

/* errno_t stat(char const *filename, struct linux_statx32 *statbuf) */
.section .text.x86.asm32_syscall_sysenter.stat
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_stat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x6a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_stat)
	call   sys_stat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_stat)

/* errno_t lstat(char const *filename, struct linux_statx32 *statbuf) */
.section .text.x86.asm32_syscall_sysenter.lstat
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_lstat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x6b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_lstat)
	call   sys_lstat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_lstat)

/* errno_t fstat(fd_t fd, struct linux_statx32 *statbuf) */
.section .text.x86.asm32_syscall_sysenter.fstat
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fstat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x6c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fstat)
	call   sys_fstat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_fstat)

/* errno_t olduname(struct linux_olduname *name) */
.section .text.x86.asm32_syscall_sysenter.olduname
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_olduname)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x6d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_olduname)
	call   sys_olduname
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_olduname)

/* errno_t iopl(syscall_ulong_t level) */
.section .text.x86.asm32_syscall_sysenter.iopl
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_iopl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x6e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_iopl)
	call   sys_iopl
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_iopl)

/* errno_t vhangup(void) */
.section .text.x86.asm32_syscall_sysenter.vhangup
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_vhangup)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x6f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_vhangup)
	call   sys_vhangup
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_vhangup)

/* errno_t idle(void) */
.section .text.x86.asm32_syscall_sysenter.idle
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_idle)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x70
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_idle)
	call   sys_idle
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_idle)

/* errno_t vm86old(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.vm86old
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_vm86old)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x71
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_vm86old)
	call   sys_vm86old
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_vm86old)

/* Same as `waitpid(pid, STAT_LOC, OPTIONS)', though also fills in `USAGE' when non-NULL
 * @param: options: Set of `WNOHANG | WUNTRACED | WCONTINUED' (as a KOS extension, `WNOWAIT' is also accepted) */
/* pid_t wait4(pid_t pid, int32_t *stat_loc, syscall_ulong_t options, struct rusagex32 *usage) */
.section .text.x86.asm32_syscall_sysenter.wait4
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_wait4)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x72
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_wait4)
	call   sys_wait4
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_wait4)

/* errno_t swapoff(char const *pathname) */
.section .text.x86.asm32_syscall_sysenter.swapoff
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_swapoff)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x73
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_swapoff)
	call   sys_swapoff
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_swapoff)

/* errno_t sysinfo(struct __sysinfox32 *info) */
.section .text.x86.asm32_syscall_sysenter.sysinfo
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sysinfo)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x74
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sysinfo)
	call   sys_sysinfo
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_sysinfo)

/* errno_t ipc(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.ipc
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_ipc)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x75
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ipc)
	call   sys_ipc
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_ipc)

/* Synchronize a file (including its descriptor which contains timestamps, and its size),
 * meaning  that  changes   to  its   data  and/or   descriptor  are   written  to   disk */
/* errno_t fsync(fd_t fd) */
.section .text.x86.asm32_syscall_sysenter.fsync
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fsync)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x76
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fsync)
	call   sys_fsync
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_fsync)

/* void sigreturn(void) */
.section .text.x86.asm32_syscall_sysenter.sigreturn
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sigreturn)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x77
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_sigreturn)
	call   sys_sigreturn
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_sigreturn)

/* pid_t clone(syscall_ulong_t flags, void *child_stack, pid_t *ptid, uintptr_t newtls, pid_t *ctid) */
.section .text.x86.asm32_syscall_sysenter.clone
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_clone)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x78
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_clone)
	call   sys_clone
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_clone)

/* errno_t setdomainname(char const *name, size_t len) */
.section .text.x86.asm32_syscall_sysenter.setdomainname
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_setdomainname)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x79
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setdomainname)
	call   sys_setdomainname
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_setdomainname)

/* errno_t uname(struct utsname *name) */
.section .text.x86.asm32_syscall_sysenter.uname
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_uname)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x7a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_uname)
	call   sys_uname
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_uname)

/* syscall_slong_t modify_ldt(syscall_ulong_t func, void *ptr, syscall_ulong_t bytecount) */
.section .text.x86.asm32_syscall_sysenter.modify_ldt
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_modify_ldt)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x7b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_modify_ldt)
	call   sys_modify_ldt
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_modify_ldt)

/* errno_t adjtimex(struct timex *ntx) */
.section .text.x86.asm32_syscall_sysenter.adjtimex
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_adjtimex)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x7c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_adjtimex)
	call   sys_adjtimex
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_adjtimex)

/* @param: prot: Either `PROT_NONE', or set of `PROT_EXEC | PROT_WRITE | PROT_READ | PROT_SEM | PROT_SHARED' */
/* errno_t mprotect(void *addr, size_t len, syscall_ulong_t prot) */
.section .text.x86.asm32_syscall_sysenter.mprotect
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mprotect)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x7d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mprotect)
	call   sys_mprotect
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_mprotect)

/* @param: how: One of `SIG_BLOCK', `SIG_UNBLOCK' or `SIG_SETMASK' */
/* errno_t sigprocmask(syscall_ulong_t how, struct __old_sigset_struct const *set, struct __old_sigset_struct *oset) */
.section .text.x86.asm32_syscall_sysenter.sigprocmask
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sigprocmask)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x7e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sigprocmask)
	call   sys_sigprocmask
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_sigprocmask)

/* errno_t create_module(void) */
.section .text.x86.asm32_syscall_sysenter.create_module
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_create_module)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x7f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_create_module)
	call   sys_create_module
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_create_module)

/* Load a  kernel  driver  from an  ELF  image  `module_image...+=len'
 * This system call exists for linux compatibility, and is implemented
 * as an alias for  `KSYSCTL_DRIVER_INSMOD:KSYSCTL_DRIVER_FORMAT_BLOB'
 * 
 * Note however that that is where linux compatibility ends. Since the
 * linux kernel does not implement any semblance of a stable ABI,  you
 * have to realize that on KOS, this system call can only load drivers
 * specifically built to run within the KOS kernel!
 * @param: uargs: The driver commandline */
/* errno_t init_module(void const *module_image, size_t len, char const *uargs) */
.section .text.x86.asm32_syscall_sysenter.init_module
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_init_module)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x80
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_init_module)
	call   sys_init_module
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_init_module)

/* Try to unload a driver, given its `name'
 * This system call exists for linux compatibility, and is implemented
 * as an alias for  `KSYSCTL_DRIVER_DELMOD:KSYSCTL_DRIVER_FORMAT_FILE'
 * @param: name:  The name of the driver
 * @param: flags: Set of `O_NONBLOCK | O_TRUNC', where:
 *                - O_NONBLOCK: s.a. `KSYSCTL_DRIVER_DELMOD_FNONBLOCK'
 *                - O_TRUNC:    s.a. `KSYSCTL_DRIVER_DELMOD_FFORCE' */
/* errno_t delete_module(char const *name, oflag_t flags) */
.section .text.x86.asm32_syscall_sysenter.delete_module
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_delete_module)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x81
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_delete_module)
	call   sys_delete_module
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_delete_module)

/* errno_t get_kernel_syms(void) */
.section .text.x86.asm32_syscall_sysenter.get_kernel_syms
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_get_kernel_syms)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x82
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_get_kernel_syms)
	call   sys_get_kernel_syms
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_get_kernel_syms)

/* errno_t quotactl(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.quotactl
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_quotactl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x83
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_quotactl)
	call   sys_quotactl
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_quotactl)

/* pid_t getpgid(pid_t pid) */
.section .text.x86.asm32_syscall_sysenter.getpgid
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getpgid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x84
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getpgid)
	call   sys_getpgid
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getpgid)

/* errno_t fchdir(fd_t fd) */
.section .text.x86.asm32_syscall_sysenter.fchdir
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fchdir)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x85
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fchdir)
	call   sys_fchdir
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_fchdir)

/* errno_t bdflush(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.bdflush
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_bdflush)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x86
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_bdflush)
	call   sys_bdflush
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_bdflush)

/* errno_t sysfs(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.sysfs
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sysfs)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x87
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sysfs)
	call   sys_sysfs
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_sysfs)

/* errno_t personality(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.personality
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_personality)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x88
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_personality)
	call   sys_personality
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_personality)

/* errno_t afs_syscall(void) */
.section .text.x86.asm32_syscall_sysenter.afs_syscall
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_afs_syscall)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x89
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_afs_syscall)
	call   sys_afs_syscall
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_afs_syscall)

/* >> setfsuid(2)
 * Set the  user ID  for the  cred-context (s.a.  `CLONE_CRED') of  the
 * calling thread. The calling thread needs the `CAP_SETUID' privilege.
 * @return: 0:  Success.
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setfsuid(uint16_t uid) */
.section .text.x86.asm32_syscall_sysenter.setfsuid
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_setfsuid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x8a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setfsuid)
	call   sys_setfsuid
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_setfsuid)

/* >> setfsgid(2)
 * Set the group  ID for  the cred-context (s.a.  `CLONE_CRED') of  the
 * calling thread. The calling thread needs the `CAP_SETGID' privilege.
 * @return: 0:  Success.
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setfsgid(uint16_t gid) */
.section .text.x86.asm32_syscall_sysenter.setfsgid
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_setfsgid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x8b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setfsgid)
	call   sys_setfsgid
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_setfsgid)

/* errno_t _llseek(fd_t fd, int64_t offset, uint64_t *result, syscall_ulong_t whence) */
.section .text.x86.asm32_syscall_sysenter._llseek
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter__llseek)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x8c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys__llseek)
	call   sys__llseek
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter__llseek)

/* @return: * : The actual number of read entries
 * @return: 0 : End-of-directory */
/* ssize_t getdents(fd_t fd, struct linux_direntx32 *buf, size_t buflen) */
.section .text.x86.asm32_syscall_sysenter.getdents
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getdents)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x8d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getdents)
	call   sys_getdents
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getdents)

/* ssize_t _newselect(size_t nfds, struct __fd_set_struct *readfds, struct __fd_set_struct *writefds, struct __fd_set_struct *exceptfds, struct timevalx32 *timeout) */
.section .text.x86.asm32_syscall_sysenter._newselect
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter__newselect)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x8e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys__newselect)
	call   sys__newselect
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter__newselect)

/* errno_t flock(fd_t fd, syscall_ulong_t operation) */
.section .text.x86.asm32_syscall_sysenter.flock
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_flock)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x8f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_flock)
	call   sys_flock
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_flock)

/* errno_t msync(void *addr, size_t len, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.msync
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_msync)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x90
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_msync)
	call   sys_msync
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_msync)

/* Same as `read(2)', but rather than specifying a single, continuous buffer,
 * read  data into `count'  separate buffers, though  still return the actual
 * number of read bytes.
 * When `fd' has the `O_NONBLOCK' flag set, only read as much data as was
 * available at  the time  the call  was made,  and throw  `E_WOULDBLOCK'
 * no data was available at the time.
 * @return: <= SUM(iov[*].iov_len): The actual amount of read bytes
 * @return: 0                     : EOF */
/* ssize_t readv(fd_t fd, struct iovecx32 const *iovec, size_t count) */
.section .text.x86.asm32_syscall_sysenter.readv
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_readv)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x91
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_readv)
	call   sys_readv
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_readv)

/* Same as `write(2)', but rather than specifying a single, continuous buffer,
 * write  data from `count'  separate buffers, though  still return the actual
 * number of written bytes.
 * When  `fd' has the  `O_NONBLOCK' flag set, only  write as much data
 * as possible at the time the call was made, and throw `E_WOULDBLOCK'
 * if no data could be written at the time.
 * @return: <= SUM(iov[*].iov_len): The actual amount of written bytes
 * @return: 0                     : No more data can be written */
/* ssize_t writev(fd_t fd, struct iovecx32 const *iovec, size_t count) */
.section .text.x86.asm32_syscall_sysenter.writev
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_writev)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x92
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_writev)
	call   sys_writev
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_writev)

/* pid_t getsid(pid_t pid) */
.section .text.x86.asm32_syscall_sysenter.getsid
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getsid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x93
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getsid)
	call   sys_getsid
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getsid)

/* Synchronize only the data of a file (not its descriptor which contains
 * timestamps,  and its size),  meaning that changes  are written to disk */
/* errno_t fdatasync(fd_t fd) */
.section .text.x86.asm32_syscall_sysenter.fdatasync
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fdatasync)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x94
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fdatasync)
	call   sys_fdatasync
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_fdatasync)

/* errno_t _sysctl(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter._sysctl
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter__sysctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x95
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys__sysctl)
	call   sys__sysctl
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter__sysctl)

/* errno_t mlock(void const *addr, size_t len) */
.section .text.x86.asm32_syscall_sysenter.mlock
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mlock)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x96
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mlock)
	call   sys_mlock
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_mlock)

/* errno_t munlock(void const *addr, size_t len) */
.section .text.x86.asm32_syscall_sysenter.munlock
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_munlock)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x97
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_munlock)
	call   sys_munlock
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_munlock)

/* @param: flags: Set of `MCL_CURRENT | MCL_FUTURE | MCL_ONFAULT' */
/* errno_t mlockall(syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.mlockall
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mlockall)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x98
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mlockall)
	call   sys_mlockall
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_mlockall)

/* errno_t munlockall(void) */
.section .text.x86.asm32_syscall_sysenter.munlockall
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_munlockall)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x99
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_munlockall)
	call   sys_munlockall
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_munlockall)

/* errno_t sched_setparam(pid_t pid, struct sched_param const *param) */
.section .text.x86.asm32_syscall_sysenter.sched_setparam
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sched_setparam)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x9a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sched_setparam)
	call   sys_sched_setparam
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_sched_setparam)

/* errno_t sched_getparam(pid_t pid, struct sched_param *param) */
.section .text.x86.asm32_syscall_sysenter.sched_getparam
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sched_getparam)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x9b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sched_getparam)
	call   sys_sched_getparam
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_sched_getparam)

/* @param: policy: One of `SCHED_OTHER', `SCHED_FIFO', `SCHED_RR', `SCHED_BATCH',
 *                 `SCHED_IDLE',  optionally   or'd  with   `SCHED_RESET_ON_FORK' */
/* errno_t sched_setscheduler(pid_t pid, syscall_ulong_t policy, struct sched_param const *param) */
.section .text.x86.asm32_syscall_sysenter.sched_setscheduler
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sched_setscheduler)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x9c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sched_setscheduler)
	call   sys_sched_setscheduler
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_sched_setscheduler)

/* syscall_slong_t sched_getscheduler(pid_t pid) */
.section .text.x86.asm32_syscall_sysenter.sched_getscheduler
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sched_getscheduler)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x9d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sched_getscheduler)
	call   sys_sched_getscheduler
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_sched_getscheduler)

/* errno_t sched_yield(void) */
.section .text.x86.asm32_syscall_sysenter.sched_yield
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sched_yield)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x9e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_sched_yield)
	call   sys_sched_yield
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_sched_yield)

/* syscall_slong_t sched_get_priority_max(syscall_ulong_t algorithm) */
.section .text.x86.asm32_syscall_sysenter.sched_get_priority_max
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sched_get_priority_max)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x9f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sched_get_priority_max)
	call   sys_sched_get_priority_max
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_sched_get_priority_max)

/* syscall_slong_t sched_get_priority_min(syscall_ulong_t algorithm) */
.section .text.x86.asm32_syscall_sysenter.sched_get_priority_min
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sched_get_priority_min)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xa0
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sched_get_priority_min)
	call   sys_sched_get_priority_min
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_sched_get_priority_min)

/* errno_t sched_rr_get_interval(pid_t pid, struct timespecx32 *ts) */
.section .text.x86.asm32_syscall_sysenter.sched_rr_get_interval
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sched_rr_get_interval)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xa1
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sched_rr_get_interval)
	call   sys_sched_rr_get_interval
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_sched_rr_get_interval)

/* errno_t nanosleep(struct timespecx32 const *req, struct timespecx32 *rem) */
.section .text.x86.asm32_syscall_sysenter.nanosleep
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_nanosleep)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xa2
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_nanosleep)
	call   sys_nanosleep
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_nanosleep)

/* @param: flags: Set of `MREMAP_MAYMOVE | MREMAP_FIXED' */
/* void *mremap(void *addr, size_t old_len, size_t new_len, syscall_ulong_t flags, void *new_address) */
.section .text.x86.asm32_syscall_sysenter.mremap
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mremap)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xa3
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mremap)
	call   sys_mremap
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_mremap)

/* >> setresuid(2)
 * @return: 0 : Success
 * Set the real, effective, and saved UID of the calling thread.
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setresuid(uint16_t ruid, uint16_t euid, uint16_t suid) */
.section .text.x86.asm32_syscall_sysenter.setresuid
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_setresuid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xa4
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setresuid)
	call   sys_setresuid
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_setresuid)

/* >> getresuid(2)
 * Get the real, effective, and saved UID of the calling thread.
 * @return: 0 : Success */
/* errno_t getresuid(uint16_t *ruid, uint16_t *euid, uint16_t *suid) */
.section .text.x86.asm32_syscall_sysenter.getresuid
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getresuid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xa5
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getresuid)
	call   sys_getresuid
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getresuid)

/* errno_t vm86(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.vm86
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_vm86)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xa6
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_vm86)
	call   sys_vm86
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_vm86)

/* errno_t query_module(void) */
.section .text.x86.asm32_syscall_sysenter.query_module
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_query_module)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xa7
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_query_module)
	call   sys_query_module
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_query_module)

/* ssize_t poll(struct pollfd *fds, size_t nfds, syscall_slong_t timeout) */
.section .text.x86.asm32_syscall_sysenter.poll
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_poll)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xa8
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_poll)
	call   sys_poll
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_poll)

/* errno_t nfsservctl(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.nfsservctl
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_nfsservctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xa9
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_nfsservctl)
	call   sys_nfsservctl
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_nfsservctl)

/* >> setresgid(2)
 * Set the real, effective, and saved GID of the calling thread.
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setresgid(uint16_t rgid, uint16_t egid, uint16_t sgid) */
.section .text.x86.asm32_syscall_sysenter.setresgid
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_setresgid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xaa
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setresgid)
	call   sys_setresgid
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_setresgid)

/* >> getresgid(2)
 * Get the real, effective, and saved GID of the calling thread.
 * @return: 0 : Success */
/* errno_t getresgid(uint16_t *rgid, uint16_t *egid, uint16_t *sgid) */
.section .text.x86.asm32_syscall_sysenter.getresgid
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getresgid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xab
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getresgid)
	call   sys_getresgid
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getresgid)

/* >> prctl(2)
 * System process control interface. (Linux compatible)
 * @param: command: One of `PR_*' (from <linux/prctl.h>)
 * @param: ... : Up  to 4 additional arguments (dependent on `command')
 *               Note that some control codes  require you to pass  `0'
 *               for  all seemingly "unused" arguments. In these cases,
 *               the documentation for that command includes the number
 *               of unused, but required trailing 0s in its comment.
 * @return: * :  Return value depends on `command' */
/* syscall_slong_t prctl(unsigned int command, syscall_ulong_t arg2, syscall_ulong_t arg3, syscall_ulong_t arg4, syscall_ulong_t arg5) */
.section .text.x86.asm32_syscall_sysenter.prctl
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_prctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xac
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_prctl)
	call   sys_prctl
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_prctl)

/* void rt_sigreturn(void) */
.section .text.x86.asm32_syscall_sysenter.rt_sigreturn
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_rt_sigreturn)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xad
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_rt_sigreturn)
	call   sys_rt_sigreturn
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_rt_sigreturn)

/* errno_t rt_sigaction(signo_t signo, struct __kernel_sigactionx32 const *act, struct __kernel_sigactionx32 *oact, size_t sigsetsize) */
.section .text.x86.asm32_syscall_sysenter.rt_sigaction
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_rt_sigaction)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xae
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_rt_sigaction)
	call   sys_rt_sigaction
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_rt_sigaction)

/* @param: how: One of `SIG_BLOCK', `SIG_UNBLOCK' or `SIG_SETMASK' */
/* errno_t rt_sigprocmask(syscall_ulong_t how, struct __sigset_struct const *set, struct __sigset_struct *oset, size_t sigsetsize) */
.section .text.x86.asm32_syscall_sysenter.rt_sigprocmask
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_rt_sigprocmask)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xaf
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_rt_sigprocmask)
	call   sys_rt_sigprocmask
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_rt_sigprocmask)

/* errno_t rt_sigpending(struct __sigset_struct *set, size_t sigsetsize) */
.section .text.x86.asm32_syscall_sysenter.rt_sigpending
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_rt_sigpending)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xb0
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_rt_sigpending)
	call   sys_rt_sigpending
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_rt_sigpending)

/* syscall_slong_t rt_sigtimedwait(struct __sigset_struct const *set, struct __siginfox32_struct *info, struct timespecx32 const *timeout, size_t sigsetsize) */
.section .text.x86.asm32_syscall_sysenter.rt_sigtimedwait
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_rt_sigtimedwait)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xb1
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_rt_sigtimedwait)
	call   sys_rt_sigtimedwait
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_rt_sigtimedwait)

/* @param: usigno: The signal that should be sent
 * @param: uinfo:  [0..1] Additional signal information
 * @throw: E_INVALID_ARGUMENT_UNEXPECTED_COMMAND:E_INVALID_ARGUMENT_CONTEXT_SIGINFO_SIGNO: [...]
 * @throw: E_INVALID_ARGUMENT_BAD_VALUE:E_INVALID_ARGUMENT_CONTEXT_BAD_SIGNO:              [...]
 * @throw: E_INVALID_ARGUMENT_BAD_VALUE:E_INVALID_ARGUMENT_CONTEXT_RAISE_SIGINFO_BADCODE:  [...]
 * @throw: E_ILLEGAL_OPERATION:                                                            [...] */
/* errno_t rt_sigqueueinfo(pid_t pid, signo_t usigno, struct __siginfox32_struct const *uinfo) */
.section .text.x86.asm32_syscall_sysenter.rt_sigqueueinfo
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_rt_sigqueueinfo)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xb2
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_rt_sigqueueinfo)
	call   sys_rt_sigqueueinfo
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_rt_sigqueueinfo)

/* >> sigsuspend(2), rt_sigsuspend(2)
 * Atomically save and  set the caller's  signal mask to  `set', then wait  for
 * one of the unmasked (iow: `!sigismember')-signals to arrive before restoring
 * the old signal mask.
 * @param: set: The set of signals on which to wait
 * @return: -1: [errno=EINTR] The signal handler for `signo' was executed. */
/* errno_t rt_sigsuspend(struct __sigset_struct const *set, size_t sigsetsize) */
.section .text.x86.asm32_syscall_sysenter.rt_sigsuspend
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_rt_sigsuspend)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xb3
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_rt_sigsuspend)
	call   sys_rt_sigsuspend
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_rt_sigsuspend)

/* ssize_t pread64(fd_t fd, void *buf, size_t bufsize, uint64_t offset) */
.section .text.x86.asm32_syscall_sysenter.pread64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_pread64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xb4
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pread64)
	call   sys_pread64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_pread64)

/* ssize_t pwrite64(fd_t fd, void const *buf, size_t bufsize, uint64_t offset) */
.section .text.x86.asm32_syscall_sysenter.pwrite64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_pwrite64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xb5
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pwrite64)
	call   sys_pwrite64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_pwrite64)

/* errno_t chown(char const *filename, uint16_t owner, uint16_t group) */
.section .text.x86.asm32_syscall_sysenter.chown
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_chown)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xb6
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_chown)
	call   sys_chown
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_chown)

/* ssize_t getcwd(char *buf, size_t size) */
.section .text.x86.asm32_syscall_sysenter.getcwd
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getcwd)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xb7
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getcwd)
	call   sys_getcwd
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getcwd)

/* errno_t capget(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.capget
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_capget)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xb8
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_capget)
	call   sys_capget
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_capget)

/* errno_t capset(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.capset
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_capset)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xb9
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_capset)
	call   sys_capset
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_capset)

/* errno_t sigaltstack(struct __sigaltstackx32 const *ss, struct __sigaltstackx32 *oss) */
.section .text.x86.asm32_syscall_sysenter.sigaltstack
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sigaltstack)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xba
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sigaltstack)
	call   sys_sigaltstack
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_sigaltstack)

/* Read up to `num_bytes' from `infd', and write that data to `outfd'
 * Files must be opened with the relevant access permissions (same as
 * would be enforced by `read(2)' and `write(2)')
 * When `pin_offset != NULL', the pointed-to location is used to track
 * the read-position in `infd'. Note that in the event that writing to
 * this address faults, data may  have still been written to  `outfd',
 * so be sure to have this point to writable memory.
 * @param: outfd:      Output file descriptor
 * @param: infd:       Input file descriptor
 * @param: pin_offset: If non-NULL, position from which to start reading,
 *                     and updated to reflect  how much could be  copied.
 * @param: num_bytes:  The max number of bytes to transfer
 * @return: * :        The actual number of bytes transferred */
/* ssize_t sendfile(fd_t outfd, fd_t infd, __ULONG32_TYPE__ *pin_offset, size_t num_bytes) */
.section .text.x86.asm32_syscall_sysenter.sendfile
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sendfile)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xbb
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sendfile)
	call   sys_sendfile
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_sendfile)

/* errno_t getpmsg(void) */
.section .text.x86.asm32_syscall_sysenter.getpmsg
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getpmsg)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xbc
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_getpmsg)
	call   sys_getpmsg
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getpmsg)

/* errno_t putpmsg(void) */
.section .text.x86.asm32_syscall_sysenter.putpmsg
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_putpmsg)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xbd
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_putpmsg)
	call   sys_putpmsg
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_putpmsg)

/* Same as `fork(2)', but the child process may be executed within in the same VM
 * as the parent process, with the  parent process remaining suspended until  the
 * child process invokes one of the following system calls:
 *   - `exit(2)'       Terminate the child process
 *   - `exit_group(2)' Terminate the child process
 *   - `execve(2)'     Create a new VM that is populated with the specified process
 *                     image. The parent process will  only be resumed in case  the
 *                     new  program image could  be loaded successfully. Otherwise,
 *                     the call  to  `execve(2)'  returns normally  in  the  child.
 *                     Other functions from the exec()-family behave the same
 * 
 * Care  must be taken when using this system call, since you have to make sure that
 * the  child process doesn't clobber any part of its (shared) stack that may be re-
 * used once execution resumes in  the parent process. The  same also goes for  heap
 * functions,  but generally speaking:  you really shouldn't  do anything that isn't
 * reentrant after calling any one of the fork() functions (since anything but would
 * rely on underlying implementations making proper use of pthread_atfork(3),  which
 * is something that KOS intentionally doesn't do,  since I feel like doing so  only
 * adds unnecessary bloat to code that doesn't rely on this)
 * 
 * Additionally, this system call may be implemented as an alias for `fork(2)', in
 * which  case the parent process will not  actually get suspended until the child
 * process performs any of the actions above. */
/* pid_t vfork(void) */
.section .text.x86.asm32_syscall_sysenter.vfork
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_vfork)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xbe
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_vfork)
	call   sys_vfork
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_vfork)

/* errno_t ugetrlimit(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.ugetrlimit
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_ugetrlimit)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xbf
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ugetrlimit)
	call   sys_ugetrlimit
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_ugetrlimit)

/* void *mmap2(void *addr, size_t len, syscall_ulong_t prot, syscall_ulong_t flags, fd_t fd, syscall_ulong_t pgoffset) */
.section .text.x86.asm32_syscall_sysenter.mmap2
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mmap2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xc0
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   4(%ebp)  /* Arg #5 (WARNING: SEGFAULT!) */
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mmap2)
	call   sys_mmap2
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_mmap2)

/* errno_t truncate64(char const *filename, uint64_t length) */
.section .text.x86.asm32_syscall_sysenter.truncate64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_truncate64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xc1
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_truncate64)
	call   sys_truncate64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_truncate64)

/* errno_t ftruncate64(fd_t fd, uint64_t length) */
.section .text.x86.asm32_syscall_sysenter.ftruncate64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_ftruncate64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xc2
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ftruncate64)
	call   sys_ftruncate64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_ftruncate64)

/* errno_t stat64(char const *filename, struct linux_statx32_64 *statbuf) */
.section .text.x86.asm32_syscall_sysenter.stat64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_stat64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xc3
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_stat64)
	call   sys_stat64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_stat64)

/* errno_t lstat64(char const *filename, struct linux_statx32_64 *statbuf) */
.section .text.x86.asm32_syscall_sysenter.lstat64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_lstat64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xc4
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_lstat64)
	call   sys_lstat64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_lstat64)

/* errno_t fstat64(fd_t fd, struct linux_statx32_64 *statbuf) */
.section .text.x86.asm32_syscall_sysenter.fstat64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fstat64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xc5
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fstat64)
	call   sys_fstat64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_fstat64)

/* errno_t lchown32(char const *filename, uint32_t owner, uint32_t group) */
.section .text.x86.asm32_syscall_sysenter.lchown32
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_lchown32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xc6
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_lchown32)
	call   sys_lchown32
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_lchown32)

/* >> getuid(2)
 * @return: * : The UID of the calling thread (this is the so-called ~real~ UID) */
/* uint32_t getuid32(void) */
.section .text.x86.asm32_syscall_sysenter.getuid32
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getuid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xc7
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_getuid32)
	call   sys_getuid32
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getuid32)

/* >> getgid(2)
 * @return: * : The GID of the calling thread (this is the so-called ~real~ GID) */
/* uint32_t getgid32(void) */
.section .text.x86.asm32_syscall_sysenter.getgid32
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getgid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xc8
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_getgid32)
	call   sys_getgid32
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getgid32)

/* >> geteuid(2)
 * @return: * : The   effective  UID  of  the  calling  thread.
 *              This is the one used for most permission checks */
/* uint32_t geteuid32(void) */
.section .text.x86.asm32_syscall_sysenter.geteuid32
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_geteuid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xc9
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_geteuid32)
	call   sys_geteuid32
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_geteuid32)

/* >> getegid(2)
 * @return: * : The   effective  GID  of  the  calling  thread.
 *              This is the one used for most permission checks */
/* uint32_t getegid32(void) */
.section .text.x86.asm32_syscall_sysenter.getegid32
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getegid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xca
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_getegid32)
	call   sys_getegid32
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getegid32)

/* >> setreuid(2)
 * Set the real and effective UID of the calling thread.
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setreuid32(uint32_t ruid, uint32_t euid) */
.section .text.x86.asm32_syscall_sysenter.setreuid32
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_setreuid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xcb
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setreuid32)
	call   sys_setreuid32
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_setreuid32)

/* >> setregid(2)
 * Set the real and effective GID of the calling thread.
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setregid32(uint32_t rgid, uint32_t egid) */
.section .text.x86.asm32_syscall_sysenter.setregid32
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_setregid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xcc
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setregid32)
	call   sys_setregid32
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_setregid32)

/* @return: * :     [count == 0] The required number of groups
 * @return: * :     [count != 0] The number of groups that were actually returned
 * @throw: -EINVAL: [count != 0] There are more than `count' groups (NOTE: No exception is thrown for this case!) */
/* ssize_t getgroups32(size_t count, uint32_t[] list) */
.section .text.x86.asm32_syscall_sysenter.getgroups32
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getgroups32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xcd
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getgroups32)
	call   sys_getgroups32
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getgroups32)

/* errno_t setgroups32(size_t count, uint32_t const *groups) */
.section .text.x86.asm32_syscall_sysenter.setgroups32
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_setgroups32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xce
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setgroups32)
	call   sys_setgroups32
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_setgroups32)

/* errno_t fchown32(fd_t fd, uint32_t owner, uint32_t group) */
.section .text.x86.asm32_syscall_sysenter.fchown32
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fchown32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xcf
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fchown32)
	call   sys_fchown32
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_fchown32)

/* >> setresuid(2)
 * @return: 0 : Success
 * Set the real, effective, and saved UID of the calling thread.
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setresuid32(uint32_t ruid, uint32_t euid, uint32_t suid) */
.section .text.x86.asm32_syscall_sysenter.setresuid32
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_setresuid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xd0
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setresuid32)
	call   sys_setresuid32
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_setresuid32)

/* >> getresuid(2)
 * Get the real, effective, and saved UID of the calling thread.
 * @return: 0 : Success */
/* errno_t getresuid32(uint32_t *ruid, uint32_t *euid, uint32_t *suid) */
.section .text.x86.asm32_syscall_sysenter.getresuid32
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getresuid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xd1
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getresuid32)
	call   sys_getresuid32
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getresuid32)

/* >> setresgid(2)
 * Set the real, effective, and saved GID of the calling thread.
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setresgid32(uint32_t rgid, uint32_t egid, uint32_t sgid) */
.section .text.x86.asm32_syscall_sysenter.setresgid32
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_setresgid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xd2
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setresgid32)
	call   sys_setresgid32
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_setresgid32)

/* >> getresgid(2)
 * Get the real, effective, and saved GID of the calling thread.
 * @return: 0 : Success */
/* errno_t getresgid32(uint32_t *rgid, uint32_t *egid, uint32_t *sgid) */
.section .text.x86.asm32_syscall_sysenter.getresgid32
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getresgid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xd3
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getresgid32)
	call   sys_getresgid32
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getresgid32)

/* errno_t chown32(char const *filename, uint32_t owner, uint32_t group) */
.section .text.x86.asm32_syscall_sysenter.chown32
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_chown32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xd4
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_chown32)
	call   sys_chown32
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_chown32)

/* >> setuid(2)
 * Set the UID of the calling thread (this is the so-called ~real~ UID)
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setuid32(uint32_t uid) */
.section .text.x86.asm32_syscall_sysenter.setuid32
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_setuid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xd5
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setuid32)
	call   sys_setuid32
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_setuid32)

/* >> setgid(2)
 * Set the GID of the calling thread (this is the so-called ~real~ GID)
 * @return: 0 : Success
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setgid32(uint32_t gid) */
.section .text.x86.asm32_syscall_sysenter.setgid32
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_setgid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xd6
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setgid32)
	call   sys_setgid32
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_setgid32)

/* >> setfsuid(2)
 * Set the  user ID  for the  cred-context (s.a.  `CLONE_CRED') of  the
 * calling thread. The calling thread needs the `CAP_SETUID' privilege.
 * @return: 0:  Success.
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETUID: [...] */
/* errno_t setfsuid32(uint32_t uid) */
.section .text.x86.asm32_syscall_sysenter.setfsuid32
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_setfsuid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xd7
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setfsuid32)
	call   sys_setfsuid32
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_setfsuid32)

/* >> setfsgid(2)
 * Set the group  ID for  the cred-context (s.a.  `CLONE_CRED') of  the
 * calling thread. The calling thread needs the `CAP_SETGID' privilege.
 * @return: 0:  Success.
 * @throw: E_INSUFFICIENT_RIGHTS:CAP_SETGID: [...] */
/* errno_t setfsgid32(uint32_t gid) */
.section .text.x86.asm32_syscall_sysenter.setfsgid32
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_setfsgid32)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xd8
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setfsgid32)
	call   sys_setfsgid32
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_setfsgid32)

/* errno_t pivot_root(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.pivot_root
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_pivot_root)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xd9
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pivot_root)
	call   sys_pivot_root
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_pivot_root)

/* errno_t mincore(void *start, size_t len, uint8_t *vec) */
.section .text.x86.asm32_syscall_sysenter.mincore
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mincore)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xda
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mincore)
	call   sys_mincore
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_mincore)

/* errno_t madvise(void *addr, size_t len, syscall_ulong_t advice) */
.section .text.x86.asm32_syscall_sysenter.madvise
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_madvise)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xdb
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_madvise)
	call   sys_madvise
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_madvise)

/* @return: * : The actual number of read entries
 * @return: 0 : End-of-directory */
/* ssize_t getdents64(fd_t fd, struct linux_dirent64 *buf, size_t buflen) */
.section .text.x86.asm32_syscall_sysenter.getdents64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getdents64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xdc
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getdents64)
	call   sys_getdents64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getdents64)

/* syscall_slong_t fcntl64(fd_t fd, fcntl_t command, void *arg) */
.section .text.x86.asm32_syscall_sysenter.fcntl64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fcntl64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xdd
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fcntl64)
	call   sys_fcntl64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_fcntl64)

/* pid_t gettid(void) */
.section .text.x86.asm32_syscall_sysenter.gettid
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_gettid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xe0
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_gettid)
	call   sys_gettid
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_gettid)

/* ssize_t readahead(fd_t fd, uint64_t offset, size_t count) */
.section .text.x86.asm32_syscall_sysenter.readahead
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_readahead)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xe1
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_readahead)
	call   sys_readahead
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_readahead)

/* @param: flags: One of `0', `XATTR_CREATE' or `XATTR_REPLACE' */
/* errno_t setxattr(char const *path, char const *name, void const *buf, size_t bufsize, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.setxattr
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_setxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xe2
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setxattr)
	call   sys_setxattr
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_setxattr)

/* @param: flags: One of `0', `XATTR_CREATE' or `XATTR_REPLACE' */
/* errno_t lsetxattr(char const *path, char const *name, void const *buf, size_t bufsize, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.lsetxattr
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_lsetxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xe3
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_lsetxattr)
	call   sys_lsetxattr
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_lsetxattr)

/* @param: flags: One of `0', `XATTR_CREATE' or `XATTR_REPLACE' */
/* errno_t fsetxattr(fd_t fd, char const *name, void const *buf, size_t bufsize, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.fsetxattr
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fsetxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xe4
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fsetxattr)
	call   sys_fsetxattr
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_fsetxattr)

/* ssize_t getxattr(char const *path, char const *name, void *buf, size_t bufsize) */
.section .text.x86.asm32_syscall_sysenter.getxattr
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xe5
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getxattr)
	call   sys_getxattr
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getxattr)

/* ssize_t lgetxattr(char const *path, char const *name, void *buf, size_t bufsize) */
.section .text.x86.asm32_syscall_sysenter.lgetxattr
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_lgetxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xe6
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_lgetxattr)
	call   sys_lgetxattr
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_lgetxattr)

/* ssize_t fgetxattr(fd_t fd, char const *name, void *buf, size_t bufsize) */
.section .text.x86.asm32_syscall_sysenter.fgetxattr
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fgetxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xe7
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fgetxattr)
	call   sys_fgetxattr
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_fgetxattr)

/* ssize_t listxattr(char const *path, char *listbuf, size_t listbufsize) */
.section .text.x86.asm32_syscall_sysenter.listxattr
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_listxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xe8
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_listxattr)
	call   sys_listxattr
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_listxattr)

/* ssize_t llistxattr(char const *path, char *listbuf, size_t listbufsize) */
.section .text.x86.asm32_syscall_sysenter.llistxattr
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_llistxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xe9
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_llistxattr)
	call   sys_llistxattr
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_llistxattr)

/* ssize_t flistxattr(fd_t fd, char *listbuf, size_t listbufsize) */
.section .text.x86.asm32_syscall_sysenter.flistxattr
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_flistxattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xea
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_flistxattr)
	call   sys_flistxattr
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_flistxattr)

/* errno_t removexattr(char const *path, char const *name) */
.section .text.x86.asm32_syscall_sysenter.removexattr
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_removexattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xeb
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_removexattr)
	call   sys_removexattr
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_removexattr)

/* errno_t lremovexattr(char const *path, char const *name) */
.section .text.x86.asm32_syscall_sysenter.lremovexattr
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_lremovexattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xec
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_lremovexattr)
	call   sys_lremovexattr
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_lremovexattr)

/* errno_t fremovexattr(fd_t fd, char const *name) */
.section .text.x86.asm32_syscall_sysenter.fremovexattr
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fremovexattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xed
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fremovexattr)
	call   sys_fremovexattr
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_fremovexattr)

/* errno_t tkill(pid_t tid, signo_t signo) */
.section .text.x86.asm32_syscall_sysenter.tkill
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_tkill)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xee
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_tkill)
	call   sys_tkill
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_tkill)

/* Read up to `num_bytes' from `infd', and write that data to `outfd'
 * Files must be opened with the relevant access permissions (same as
 * would be enforced by `read(2)' and `write(2)')
 * When `pin_offset != NULL', the pointed-to location is used to track
 * the read-position in `infd'. Note that in the event that writing to
 * this address faults, data may  have still been written to  `outfd',
 * so be sure to have this point to writable memory.
 * @param: outfd:      Output file descriptor
 * @param: infd:       Input file descriptor
 * @param: pin_offset: If non-NULL, position from which to start reading,
 *                     and updated to reflect  how much could be  copied.
 * @param: num_bytes:  The max number of bytes to transfer
 * @return: * :        The actual number of bytes transferred */
/* ssize_t sendfile64(fd_t outfd, fd_t infd, __ULONG64_TYPE__ *pin_offset, size_t num_bytes) */
.section .text.x86.asm32_syscall_sysenter.sendfile64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sendfile64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xef
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sendfile64)
	call   sys_sendfile64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_sendfile64)

/* @param: futex_op: One of `FUTEX_*' from <linux/futex.h> */
/* syscall_slong_t futex(uint32_t *uaddr, syscall_ulong_t futex_op, uint32_t val, struct timespecx32 const *timeout_or_val2, uint32_t *uaddr2, uint32_t val3) */
.section .text.x86.asm32_syscall_sysenter.futex
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_futex)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xf0
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   4(%ebp)  /* Arg #5 (WARNING: SEGFAULT!) */
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_futex)
	call   sys_futex
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_futex)

/* errno_t sched_setaffinity(pid_t pid, size_t cpusetsize, struct __cpu_set_struct const *cpuset) */
.section .text.x86.asm32_syscall_sysenter.sched_setaffinity
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sched_setaffinity)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xf1
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sched_setaffinity)
	call   sys_sched_setaffinity
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_sched_setaffinity)

/* errno_t sched_getaffinity(pid_t pid, size_t cpusetsize, struct __cpu_set_struct *cpuset) */
.section .text.x86.asm32_syscall_sysenter.sched_getaffinity
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sched_getaffinity)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xf2
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sched_getaffinity)
	call   sys_sched_getaffinity
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_sched_getaffinity)

/* errno_t set_thread_area(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.set_thread_area
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_set_thread_area)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xf3
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_set_thread_area)
	call   sys_set_thread_area
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_set_thread_area)

/* errno_t get_thread_area(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.get_thread_area
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_get_thread_area)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xf4
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_get_thread_area)
	call   sys_get_thread_area
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_get_thread_area)

/* errno_t io_setup(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.io_setup
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_io_setup)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xf5
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_io_setup)
	call   sys_io_setup
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_io_setup)

/* errno_t io_destroy(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.io_destroy
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_io_destroy)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xf6
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_io_destroy)
	call   sys_io_destroy
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_io_destroy)

/* errno_t io_getevents(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.io_getevents
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_io_getevents)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xf7
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_io_getevents)
	call   sys_io_getevents
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_io_getevents)

/* errno_t io_submit(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.io_submit
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_io_submit)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xf8
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_io_submit)
	call   sys_io_submit
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_io_submit)

/* errno_t io_cancel(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.io_cancel
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_io_cancel)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xf9
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_io_cancel)
	call   sys_io_cancel
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_io_cancel)

/* errno_t fadvise64(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.fadvise64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fadvise64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xfa
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fadvise64)
	call   sys_fadvise64
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_fadvise64)

/* Terminate the calling process
 * @param: exit_code: Thread exit code (as returned by `wait(2)') */
/* void exit_group(syscall_ulong_t exit_code) */
.section .text.x86.asm32_syscall_sysenter.exit_group
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_exit_group)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xfc
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_exit_group)
	call   sys_exit_group
	.cfi_endproc
END(__x86_asm32_sysenter_exit_group)

/* errno_t lookup_dcookie(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.lookup_dcookie
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_lookup_dcookie)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xfd
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_lookup_dcookie)
	call   sys_lookup_dcookie
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_lookup_dcookie)

/* >> epoll_create(2)
 * Deprecated alias for `epoll_create1(0)' (the `size' argument is ignored)
 * @return: * : The newly created epoll control descriptor.
 * @return: -1: Error (s.a. `errno') */
/* fd_t epoll_create(syscall_ulong_t size) */
.section .text.x86.asm32_syscall_sysenter.epoll_create
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_epoll_create)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xfe
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_epoll_create)
	call   sys_epoll_create
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_epoll_create)

/* >> epoll_ctl(2)
 * Manipulate a given  epoll controller  `epfd', as previously  returned by  `epoll_create1(2)'
 * in order to register (`EPOLL_CTL_ADD'), remove (`EPOLL_CTL_DEL') or modify (`EPOLL_CTL_MOD')
 * the file descriptors being monitored
 * @param: op:       One of `EPOLL_CTL_ADD', `EPOLL_CTL_DEL' or `EPOLL_CTL_MOD'
 * @param: fd:       The file descriptor to add/remove/modify
 * @param: info:     The new configuration for `fd' (ignored when `op' is `EPOLL_CTL_DEL')
 * @return: 0 :      Success
 * @return: -EEXIST: [op=EPOLL_CTL_ADD] The given `fd' (and its kernel object) has already been registered
 * @return: -ENOENT: [op=EPOLL_CTL_MOD|EPOLL_CTL_DEL] The given `fd' (and its kernel object) aren't registered
 * @throw: E_ILLEGAL_REFERENCE_LOOP: The  given  `fd'  is  another  epoll  that either
 *                                   forms a loop with `epfd', or has too many nested.
 * @throw: E_INVALID_ARGUMENT_UNKNOWN_COMMAND:E_INVALID_ARGUMENT_CONTEXT_EPOLL_CTL_OP: [...] */
/* errno_t epoll_ctl(fd_t epfd, syscall_ulong_t op, fd_t fd, struct epoll_event *info) */
.section .text.x86.asm32_syscall_sysenter.epoll_ctl
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_epoll_ctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0xff
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_epoll_ctl)
	call   sys_epoll_ctl
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_epoll_ctl)

/* >> epoll_wait(2)
 * Wait until at least one of the conditions monitored by `epfd' to be met.
 * @param: epfd:      The epoll controller on which to wait.
 * @param: events:    A buffer where the kernel can store information on the
 *                    events that actually took place.
 * @param: maxevents: The # of events that can be stored in `events' (must be >= 1)
 * @param: timeout:   The max amount of time (in milliseconds) before  returning
 *                    in the case where no event occurred in the mean time. When
 *                    set to `-1', wait indefinitely
 * @return: >= 1:     The # of events that happened (written to the first `return'
 *                    items of `events')
 * @return: 0:        No events happened before `timeout' expired.
 * @return: -1:       Error (s.a. `errno') */
/* ssize_t epoll_wait(fd_t epfd, struct epoll_event *events, size_t maxevents, syscall_slong_t timeout) */
.section .text.x86.asm32_syscall_sysenter.epoll_wait
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_epoll_wait)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x100
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_epoll_wait)
	call   sys_epoll_wait
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_epoll_wait)

/* errno_t remap_file_pages(void *start, size_t size, syscall_ulong_t prot, size_t pgoff, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.remap_file_pages
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_remap_file_pages)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x101
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_remap_file_pages)
	call   sys_remap_file_pages
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_remap_file_pages)

/* pid_t set_tid_address(pid_t *tidptr) */
.section .text.x86.asm32_syscall_sysenter.set_tid_address
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_set_tid_address)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x102
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_set_tid_address)
	call   sys_set_tid_address
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_set_tid_address)

/* errno_t timer_create(clockid_t clock_id, struct sigevent *evp, timer_t *timerid) */
.section .text.x86.asm32_syscall_sysenter.timer_create
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_timer_create)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x103
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_timer_create)
	call   sys_timer_create
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_timer_create)

/* @param: flags: Set of `0 | TIMER_ABSTIME' */
/* errno_t timer_settime(timer_t timerid, syscall_ulong_t flags, struct itimerspecx32 const *value, struct itimerspecx32 *ovalue) */
.section .text.x86.asm32_syscall_sysenter.timer_settime
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_timer_settime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x104
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_timer_settime)
	call   sys_timer_settime
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_timer_settime)

/* errno_t timer_gettime(timer_t timerid, struct itimerspecx32 *value) */
.section .text.x86.asm32_syscall_sysenter.timer_gettime
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_timer_gettime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x105
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_timer_gettime)
	call   sys_timer_gettime
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_timer_gettime)

/* syscall_slong_t timer_getoverrun(timer_t timerid) */
.section .text.x86.asm32_syscall_sysenter.timer_getoverrun
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_timer_getoverrun)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x106
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_timer_getoverrun)
	call   sys_timer_getoverrun
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_timer_getoverrun)

/* errno_t timer_delete(timer_t timerid) */
.section .text.x86.asm32_syscall_sysenter.timer_delete
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_timer_delete)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x107
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_timer_delete)
	call   sys_timer_delete
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_timer_delete)

/* errno_t clock_settime(clockid_t clock_id, struct timespecx32 const *tp) */
.section .text.x86.asm32_syscall_sysenter.clock_settime
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_clock_settime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x108
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_clock_settime)
	call   sys_clock_settime
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_clock_settime)

/* errno_t clock_gettime(clockid_t clock_id, struct timespecx32 *tp) */
.section .text.x86.asm32_syscall_sysenter.clock_gettime
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_clock_gettime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x109
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_clock_gettime)
	call   sys_clock_gettime
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_clock_gettime)

/* errno_t clock_getres(clockid_t clock_id, struct timespecx32 *res) */
.section .text.x86.asm32_syscall_sysenter.clock_getres
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_clock_getres)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x10a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_clock_getres)
	call   sys_clock_getres
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_clock_getres)

/* errno_t clock_nanosleep(clockid_t clock_id, syscall_ulong_t flags, struct timespecx32 const *requested_time, struct timespecx32 *remaining) */
.section .text.x86.asm32_syscall_sysenter.clock_nanosleep
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_clock_nanosleep)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x10b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_clock_nanosleep)
	call   sys_clock_nanosleep
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_clock_nanosleep)

/* errno_t statfs64(char const *file, struct statfsx32_64 *buf) */
.section .text.x86.asm32_syscall_sysenter.statfs64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_statfs64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x10c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_statfs64)
	call   sys_statfs64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_statfs64)

/* errno_t fstatfs64(fd_t file, struct statfsx32_64 *buf) */
.section .text.x86.asm32_syscall_sysenter.fstatfs64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fstatfs64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x10d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fstatfs64)
	call   sys_fstatfs64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_fstatfs64)

/* errno_t tgkill(pid_t pid, pid_t tid, signo_t signo) */
.section .text.x86.asm32_syscall_sysenter.tgkill
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_tgkill)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x10e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_tgkill)
	call   sys_tgkill
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_tgkill)

/* @param: times:    When NULL, set the current time
 * @param: times[0]: New access time
 * @param: times[1]: New last-modified time */
/* errno_t utimes(char const *filename, struct timevalx32 const[2] times) */
.section .text.x86.asm32_syscall_sysenter.utimes
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_utimes)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x10f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_utimes)
	call   sys_utimes
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_utimes)

/* errno_t fadvise64_64(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.fadvise64_64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fadvise64_64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x110
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fadvise64_64)
	call   sys_fadvise64_64
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_fadvise64_64)

/* errno_t vserver(void) */
.section .text.x86.asm32_syscall_sysenter.vserver
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_vserver)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x111
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_vserver)
	call   sys_vserver
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_vserver)

/* errno_t mbind(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.mbind
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mbind)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x112
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mbind)
	call   sys_mbind
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_mbind)

/* errno_t get_mempolicy(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.get_mempolicy
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_get_mempolicy)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x113
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_get_mempolicy)
	call   sys_get_mempolicy
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_get_mempolicy)

/* errno_t set_mempolicy(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.set_mempolicy
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_set_mempolicy)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x114
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_set_mempolicy)
	call   sys_set_mempolicy
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_set_mempolicy)

/* fd_t mq_open(char const *name, oflag_t oflags, mode_t mode) */
.section .text.x86.asm32_syscall_sysenter.mq_open
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mq_open)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x115
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mq_open)
	call   sys_mq_open
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_mq_open)

/* errno_t mq_unlink(char const *name) */
.section .text.x86.asm32_syscall_sysenter.mq_unlink
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mq_unlink)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x116
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mq_unlink)
	call   sys_mq_unlink
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_mq_unlink)

/* errno_t mq_timedsend(fd_t mqdes, char const *msg_ptr, size_t msg_len, uint32_t msg_prio, struct timespecx32 const *abs_timeout) */
.section .text.x86.asm32_syscall_sysenter.mq_timedsend
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mq_timedsend)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x117
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mq_timedsend)
	call   sys_mq_timedsend
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_mq_timedsend)

/* ssize_t mq_timedreceive(fd_t mqdes, char *msg_ptr, size_t msg_len, uint32_t *pmsg_prio, struct timespecx32 const *abs_timeout) */
.section .text.x86.asm32_syscall_sysenter.mq_timedreceive
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mq_timedreceive)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x118
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mq_timedreceive)
	call   sys_mq_timedreceive
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_mq_timedreceive)

/* errno_t mq_notify(fd_t mqdes, struct sigevent const *notification) */
.section .text.x86.asm32_syscall_sysenter.mq_notify
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mq_notify)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x119
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mq_notify)
	call   sys_mq_notify
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_mq_notify)

/* errno_t mq_getsetattr(fd_t mqdes, struct mq_attr const *newattr, struct mq_attr *oldattr) */
.section .text.x86.asm32_syscall_sysenter.mq_getsetattr
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mq_getsetattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x11a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mq_getsetattr)
	call   sys_mq_getsetattr
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_mq_getsetattr)

/* errno_t kexec_load(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.kexec_load
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_kexec_load)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x11b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_kexec_load)
	call   sys_kexec_load
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_kexec_load)

/* @param: idtype:  One of `P_ALL', `P_PID', `P_PGID'
 * @param: options: At least one of `WEXITED', `WSTOPPED', `WCONTINUED', optionally or'd with `WNOHANG | WNOWAIT' */
/* errno_t waitid(syscall_ulong_t idtype, id_t id, struct __siginfox32_struct *infop, syscall_ulong_t options, struct rusagex32 *ru) */
.section .text.x86.asm32_syscall_sysenter.waitid
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_waitid)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x11c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_waitid)
	call   sys_waitid
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_waitid)

/* errno_t add_key(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.add_key
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_add_key)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x11e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_add_key)
	call   sys_add_key
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_add_key)

/* errno_t request_key(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.request_key
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_request_key)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x11f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_request_key)
	call   sys_request_key
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_request_key)

/* errno_t keyctl(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.keyctl
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_keyctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x120
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_keyctl)
	call   sys_keyctl
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_keyctl)

/* NOTE: Linux calls `who' `which', and `id' `who' (refactored to prevent confusion)
 * @param: who: One of `IOPRIO_WHO_PROCESS', `IOPRIO_WHO_PGRP' or `IOPRIO_WHO_USER' */
/* errno_t ioprio_set(syscall_ulong_t who, syscall_ulong_t id, syscall_ulong_t ioprio) */
.section .text.x86.asm32_syscall_sysenter.ioprio_set
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_ioprio_set)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x121
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ioprio_set)
	call   sys_ioprio_set
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_ioprio_set)

/* NOTE: Linux calls `who' `which', and `id' `who' (refactored to prevent confusion)
 * @param: who: One of `IOPRIO_WHO_PROCESS', `IOPRIO_WHO_PGRP' or `IOPRIO_WHO_USER' */
/* syscall_slong_t ioprio_get(syscall_ulong_t who, syscall_ulong_t id) */
.section .text.x86.asm32_syscall_sysenter.ioprio_get
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_ioprio_get)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x122
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ioprio_get)
	call   sys_ioprio_get
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_ioprio_get)

/* fd_t inotify_init(void) */
.section .text.x86.asm32_syscall_sysenter.inotify_init
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_inotify_init)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x123
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	EXTERN(sys_inotify_init)
	call   sys_inotify_init
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_inotify_init)

/* @param: mask: Set of `IN_ALL_EVENTS | ...' */
/* int inotify_add_watch(fd_t notify_fd, char const *pathname, uint32_t mask) */
.section .text.x86.asm32_syscall_sysenter.inotify_add_watch
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_inotify_add_watch)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x124
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_inotify_add_watch)
	call   sys_inotify_add_watch
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_inotify_add_watch)

/* @param: wd: Watch fd (as returned by `inotify_add_watch{_at}') */
/* errno_t inotify_rm_watch(fd_t notify_fd, int wd) */
.section .text.x86.asm32_syscall_sysenter.inotify_rm_watch
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_inotify_rm_watch)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x125
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_inotify_rm_watch)
	call   sys_inotify_rm_watch
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_inotify_rm_watch)

/* errno_t migrate_pages(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.migrate_pages
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_migrate_pages)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x126
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_migrate_pages)
	call   sys_migrate_pages
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_migrate_pages)

/* Open  a  new  file  handle  to  the  file  specified  by `filename'
 * When  `oflags & O_CREAT',   then  `mode'   specifies  the   initial
 * file  access  permissions with  which  the file  should  be opened.
 * On KOS, the returned handle can be anything, but is usually one of:
 *   - HANDLE_TYPE_PATH:       When `O_PATH' was given
 *   - HANDLE_TYPE_FILEHANDLE: For `S_IFREG' regular files
 *   - HANDLE_TYPE_FIFOHANDLE: For `S_IFIFO' pipe files
 *   - HANDLE_TYPE_DIRHANDLE:  For `S_IFDIR' directories
 *   - HANDLE_TYPE_MFILE:      The actual filesystem object (including device files)
 *   - *:                      Certain filesystem names can literally return anything, such
 *                             as `/proc/self/fd/1234',  which  is  more  like  `dup(1234)' */
/* fd_t openat(fd_t dirfd, char const *filename, oflag_t oflags, mode_t mode) */
.section .text.x86.asm32_syscall_sysenter.openat
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_openat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x127
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_openat)
	call   sys_openat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_openat)

/* errno_t mkdirat(fd_t dirfd, char const *pathname, mode_t mode) */
.section .text.x86.asm32_syscall_sysenter.mkdirat
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mkdirat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x128
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mkdirat)
	call   sys_mkdirat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_mkdirat)

/* errno_t mknodat(fd_t dirfd, char const *nodename, mode_t mode, dev_t dev) */
.section .text.x86.asm32_syscall_sysenter.mknodat
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mknodat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x129
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mknodat)
	call   sys_mknodat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_mknodat)

/* @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_DOSPATH' */
/* errno_t fchownat(fd_t dirfd, char const *filename, uid_t owner, gid_t group, atflag_t flags) */
.section .text.x86.asm32_syscall_sysenter.fchownat
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fchownat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x12a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fchownat)
	call   sys_fchownat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_fchownat)

/* errno_t futimesat(fd_t dirfd, char const *filename, struct timevalx32 const[2] times) */
.section .text.x86.asm32_syscall_sysenter.futimesat
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_futimesat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x12b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_futimesat)
	call   sys_futimesat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_futimesat)

/* @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_DOSPATH' */
/* errno_t fstatat64(fd_t dirfd, char const *filename, struct linux_statx32_64 *statbuf, atflag_t flags) */
.section .text.x86.asm32_syscall_sysenter.fstatat64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fstatat64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x12c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fstatat64)
	call   sys_fstatat64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_fstatat64)

/* @param: flags: Set of `0 | AT_REMOVEDIR | AT_REMOVEREG | AT_DOSPATH' */
/* errno_t unlinkat(fd_t dirfd, char const *name, atflag_t flags) */
.section .text.x86.asm32_syscall_sysenter.unlinkat
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_unlinkat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x12d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_unlinkat)
	call   sys_unlinkat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_unlinkat)

/* errno_t renameat(fd_t oldfd, char const *oldname, fd_t newfd, char const *newname_or_path) */
.section .text.x86.asm32_syscall_sysenter.renameat
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_renameat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x12e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_renameat)
	call   sys_renameat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_renameat)

/* @param: flags: Set of `0 | AT_EMPTY_PATH | AT_SYMLINK_FOLLOW | AT_DOSPATH' */
/* errno_t linkat(fd_t fromfd, char const *existing_file, fd_t tofd, char const *target_path, atflag_t flags) */
.section .text.x86.asm32_syscall_sysenter.linkat
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_linkat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x12f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_linkat)
	call   sys_linkat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_linkat)

/* errno_t symlinkat(char const *link_text, fd_t tofd, char const *target_path) */
.section .text.x86.asm32_syscall_sysenter.symlinkat
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_symlinkat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x130
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_symlinkat)
	call   sys_symlinkat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_symlinkat)

/* ssize_t readlinkat(fd_t dirfd, char const *path, char *buf, size_t buflen) */
.section .text.x86.asm32_syscall_sysenter.readlinkat
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_readlinkat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x131
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_readlinkat)
	call   sys_readlinkat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_readlinkat)

/* @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_DOSPATH' */
/* errno_t fchmodat(fd_t dirfd, char const *filename, mode_t mode, atflag_t flags) */
.section .text.x86.asm32_syscall_sysenter.fchmodat
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fchmodat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x132
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fchmodat)
	call   sys_fchmodat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_fchmodat)

/* @param: type: Set of `R_OK | W_OK | X_OK' or `F_OK' */
/* errno_t faccessat(fd_t dirfd, char const *filename, syscall_ulong_t type) */
.section .text.x86.asm32_syscall_sysenter.faccessat
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_faccessat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x133
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_faccessat)
	call   sys_faccessat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_faccessat)

/* ssize_t pselect6(size_t nfds, struct __fd_set_struct *readfds, struct __fd_set_struct *writefds, struct __fd_set_struct *exceptfds, struct timespecx32 const *timeout, struct __sigset_with_sizex32 const *sigmask_sigset_with_size) */
.section .text.x86.asm32_syscall_sysenter.pselect6
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_pselect6)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x134
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   4(%ebp)  /* Arg #5 (WARNING: SEGFAULT!) */
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pselect6)
	call   sys_pselect6
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_pselect6)

/* ssize_t ppoll(struct pollfd *fds, size_t nfds, struct timespecx32 const *timeout_ts, struct __sigset_struct const *sigmask, size_t sigsetsize) */
.section .text.x86.asm32_syscall_sysenter.ppoll
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_ppoll)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x135
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ppoll)
	call   sys_ppoll
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_ppoll)

/* param: what: Set of `CLONE_*' */
/* errno_t unshare(syscall_ulong_t what) */
.section .text.x86.asm32_syscall_sysenter.unshare
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_unshare)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x136
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_unshare)
	call   sys_unshare
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_unshare)

/* errno_t set_robust_list(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.set_robust_list
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_set_robust_list)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x137
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_set_robust_list)
	call   sys_set_robust_list
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_set_robust_list)

/* errno_t get_robust_list(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.get_robust_list
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_get_robust_list)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x138
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_get_robust_list)
	call   sys_get_robust_list
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_get_robust_list)

/* @param: flags: Set of `SPLICE_F_MOVE | SPLICE_F_NONBLOCK | SPLICE_F_MORE | SPLICE_F_GIFT' */
/* ssize_t splice(fd_t fdin, uint64_t *offin, fd_t fdout, uint64_t *offout, size_t length, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.splice
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_splice)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x139
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   4(%ebp)  /* Arg #5 (WARNING: SEGFAULT!) */
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_splice)
	call   sys_splice
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_splice)

/* @param: flags: Set of `SYNC_FILE_RANGE_WAIT_BEFORE | SYNC_FILE_RANGE_WRITE | SYNC_FILE_RANGE_WAIT_AFTER' */
/* errno_t sync_file_range(fd_t fd, uint64_t offset, uint64_t count, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.sync_file_range
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sync_file_range)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x13a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   4(%ebp)  /* Arg #5 (WARNING: SEGFAULT!) */
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sync_file_range)
	call   sys_sync_file_range
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_sync_file_range)

/* @param: flags: Set of `SPLICE_F_MOVE | SPLICE_F_NONBLOCK | SPLICE_F_MORE | SPLICE_F_GIFT' */
/* ssize_t tee(fd_t fdin, fd_t fdout, size_t length, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.tee
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_tee)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x13b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_tee)
	call   sys_tee
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_tee)

/* @param: flags: Set of `SPLICE_F_MOVE | SPLICE_F_NONBLOCK | SPLICE_F_MORE | SPLICE_F_GIFT' */
/* ssize_t vmsplice(fd_t fdout, struct iovecx32 const *iov, size_t count, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.vmsplice
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_vmsplice)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x13c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_vmsplice)
	call   sys_vmsplice
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_vmsplice)

/* errno_t move_pages(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.move_pages
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_move_pages)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x13d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_move_pages)
	call   sys_move_pages
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_move_pages)

/* errno_t getcpu(uint32_t *cpu, uint32_t *node, struct getcpu_cache *tcache) */
.section .text.x86.asm32_syscall_sysenter.getcpu
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getcpu)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x13e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getcpu)
	call   sys_getcpu
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getcpu)

/* >> epoll_pwait(2)
 * Same as `epoll_wait(2)', but change the calling thread's signal mask to `ss' while
 * waiting.  Wait until at least one of the conditions monitored by `epfd' to be met.
 * @param: epfd:      The epoll controller on which to wait.
 * @param: events:    A buffer where the kernel can store information on the
 *                    events that actually took place.
 * @param: maxevents: The # of events that can be stored in `events' (must be >= 1)
 * @param: timeout:   The max amount of time (in milliseconds) before  returning
 *                    in the case where no event occurred in the mean time. When
 *                    set to `-1', wait indefinitely
 * @param: ss:        The signal mask to apply while waiting for an event to happen.
 * @return: >= 1:     The # of events that happened (written to the first `return'
 *                    items of `events')
 * @return: 0:        No events happened before `timeout' expired.
 * @return: -1:       Error (s.a. `errno') */
/* ssize_t epoll_pwait(fd_t epfd, struct epoll_event *events, size_t maxevents, syscall_slong_t timeout, struct __sigset_struct const *ss, size_t sigsetsize) */
.section .text.x86.asm32_syscall_sysenter.epoll_pwait
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_epoll_pwait)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x13f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   4(%ebp)  /* Arg #5 (WARNING: SEGFAULT!) */
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_epoll_pwait)
	call   sys_epoll_pwait
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_epoll_pwait)

/* @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_CHANGE_BTIME | AT_DOSPATH' */
/* errno_t utimensat(fd_t dirfd, char const *filename, struct timespecx32 const[2] times, atflag_t flags) */
.section .text.x86.asm32_syscall_sysenter.utimensat
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_utimensat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x140
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_utimensat)
	call   sys_utimensat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_utimensat)

/* Create a poll(2)-able file descriptor which can be used to wait for the
 * delivery of signals masked by `sigmask' to the waiting  thread/process. */
/* errno_t signalfd(fd_t fd, struct __sigset_struct const *sigmask, size_t sigmasksize) */
.section .text.x86.asm32_syscall_sysenter.signalfd
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_signalfd)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x141
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_signalfd)
	call   sys_signalfd
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_signalfd)

/* Return file descriptor for new interval timer source
 * @param: flags: Set of `0 | TFD_NONBLOCK | TFD_CLOEXEC | TFD_CLOFORK' */
/* fd_t timerfd_create(clockid_t clock_id, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.timerfd_create
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_timerfd_create)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x142
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_timerfd_create)
	call   sys_timerfd_create
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_timerfd_create)

/* fd_t eventfd(syscall_ulong_t initval) */
.section .text.x86.asm32_syscall_sysenter.eventfd
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_eventfd)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x143
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_eventfd)
	call   sys_eventfd
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_eventfd)

/* @param: mode: Set of `0 | FALLOC_FL_KEEP_SIZE | FALLOC_FL_PUNCH_HOLE | FALLOC_FL_COLLAPSE_RANGE | FALLOC_FL_ZERO_RANGE' */
/* errno_t fallocate(fd_t fd, syscall_ulong_t mode, syscall_ulong_t offset, syscall_ulong_t length) */
.section .text.x86.asm32_syscall_sysenter.fallocate
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fallocate)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x144
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fallocate)
	call   sys_fallocate
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_fallocate)

/* Set next expiration time of interval timer source `timerfd' to `utmr'.
 * If `flags'  has the  `TFD_TIMER_ABSTIME' flag  set the  timeout  value
 * is absolute. Optionally return the old expiration time in `otmr'
 * @param: flags: Set of `0 | TFD_TIMER_ABSTIME' */
/* errno_t timerfd_settime(fd_t timerfd, syscall_ulong_t flags, struct itimerspecx32 const *utmr, struct itimerspecx32 *otmr) */
.section .text.x86.asm32_syscall_sysenter.timerfd_settime
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_timerfd_settime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x145
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_timerfd_settime)
	call   sys_timerfd_settime
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_timerfd_settime)

/* Return the next expiration time of UFD */
/* errno_t timerfd_gettime(fd_t timerfd, struct itimerspecx32 *otmr) */
.section .text.x86.asm32_syscall_sysenter.timerfd_gettime
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_timerfd_gettime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x146
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_timerfd_gettime)
	call   sys_timerfd_gettime
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_timerfd_gettime)

/* Create a poll(2)-able file descriptor which can be used to wait for the
 * delivery of signals masked by `sigmask' to the waiting  thread/process.
 * @param: flags: Set of `0 | SFD_NONBLOCK | SFD_CLOEXEC | SFD_CLOFORK' */
/* errno_t signalfd4(fd_t fd, struct __sigset_struct const *sigmask, size_t sigmasksize, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.signalfd4
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_signalfd4)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x147
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_signalfd4)
	call   sys_signalfd4
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_signalfd4)

/* @param: flags: Set of `EFD_SEMAPHORE | EFD_NONBLOCK | EFD_CLOEXEC | EFD_CLOFORK' */
/* fd_t eventfd2(syscall_ulong_t initval, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.eventfd2
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_eventfd2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x148
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_eventfd2)
	call   sys_eventfd2
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_eventfd2)

/* >> epoll_create1(2)
 * Create  a new epoll control descriptor which can be used for
 * monitoring of pollable events happening in registered files.
 * @param: flags: Set of `EPOLL_CLOEXEC | EPOLL_CLOFORK'
 * @return: * :   The newly created epoll control descriptor.
 * @throw: E_INVALID_ARGUMENT_UNKNOWN_FLAG:E_INVALID_ARGUMENT_CONTEXT_EPOLL_CREATE1_FLAGS: [...] */
/* fd_t epoll_create1(syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.epoll_create1
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_epoll_create1)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x149
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_epoll_create1)
	call   sys_epoll_create1
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_epoll_create1)

/* @param: flags:  Set of `O_CLOEXEC | O_CLOFORK' */
/* fd_t dup3(fd_t oldfd, fd_t newfd, oflag_t flags) */
.section .text.x86.asm32_syscall_sysenter.dup3
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_dup3)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x14a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_dup3)
	call   sys_dup3
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_dup3)

/* errno_t pipe2(fd_t[2] pipedes, oflag_t flags) */
.section .text.x86.asm32_syscall_sysenter.pipe2
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_pipe2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x14b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pipe2)
	call   sys_pipe2
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_pipe2)

/* @param: flags: Set of `IN_NONBLOCK | IN_CLOEXEC | IN_CLOFORK' */
/* fd_t inotify_init1(syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.inotify_init1
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_inotify_init1)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x14c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_inotify_init1)
	call   sys_inotify_init1
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_inotify_init1)

/* Same as  `readv(2)', but  read data  from a  file at  a
 * specific `offset', rather than the current R/W position
 * @return: <= SUM(iov[*].iov_len): The actual amount of read bytes */
/* ssize_t preadv(fd_t fd, struct iovecx32 const *iovec, size_t count, uint64_t offset) */
.section .text.x86.asm32_syscall_sysenter.preadv
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_preadv)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x14d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_preadv)
	call   sys_preadv
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_preadv)

/* Same as  `writev(2)', but  write data  to a  file at  a
 * specific `offset', rather than the current R/W position
 * @return: <= SUM(iov[*].iov_len): The actual amount of written bytes */
/* ssize_t pwritev(fd_t fd, struct iovecx32 const *iovec, size_t count, uint64_t offset) */
.section .text.x86.asm32_syscall_sysenter.pwritev
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_pwritev)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x14e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pwritev)
	call   sys_pwritev
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_pwritev)

/* @param: usigno: The signal that should be sent
 * @param: uinfo:  [0..1] Additional signal information
 * @throw: E_INVALID_ARGUMENT_UNEXPECTED_COMMAND:E_INVALID_ARGUMENT_CONTEXT_SIGINFO_SIGNO: [...]
 * @throw: E_INVALID_ARGUMENT_BAD_VALUE:E_INVALID_ARGUMENT_CONTEXT_BAD_SIGNO:              [...]
 * @throw: E_INVALID_ARGUMENT_BAD_VALUE:E_INVALID_ARGUMENT_CONTEXT_RAISE_SIGINFO_BADCODE:  [...]
 * @throw: E_ILLEGAL_OPERATION:                                                            [...] */
/* errno_t rt_tgsigqueueinfo(pid_t pid, pid_t tid, signo_t usigno, struct __siginfox32_struct const *uinfo) */
.section .text.x86.asm32_syscall_sysenter.rt_tgsigqueueinfo
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_rt_tgsigqueueinfo)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x14f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_rt_tgsigqueueinfo)
	call   sys_rt_tgsigqueueinfo
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_rt_tgsigqueueinfo)

/* errno_t perf_event_open(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.perf_event_open
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_perf_event_open)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x150
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_perf_event_open)
	call   sys_perf_event_open
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_perf_event_open)

/* Same as `recvmsg(2)', but may be used to receive many
 * messages  (datagrams)  with  a  single  system  call.
 * @param: msg_flags: Set of `MSG_CMSG_CLOEXEC | MSG_CMSG_CLOFORK |
 *                            MSG_DONTWAIT | MSG_ERRQUEUE | MSG_OOB |
 *                            MSG_PEEK  |  MSG_TRUNC |  MSG_WAITALL |
 *                            MSG_WAITFORONE'
 * @throw: Error (s.a. `recvmsg(2)')
 * @return: * : The # of datagrams successfully received. */
/* ssize_t recvmmsg(fd_t sockfd, struct mmsghdrx32 *vmessages, size_t vlen, syscall_ulong_t msg_flags, struct timespecx32 const *tmo) */
.section .text.x86.asm32_syscall_sysenter.recvmmsg
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_recvmmsg)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x151
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_recvmmsg)
	call   sys_recvmmsg
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_recvmmsg)

/* errno_t fanotify_init(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.fanotify_init
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fanotify_init)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x152
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fanotify_init)
	call   sys_fanotify_init
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_fanotify_init)

/* errno_t fanotify_mark(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.fanotify_mark
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fanotify_mark)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x153
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fanotify_mark)
	call   sys_fanotify_mark
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_fanotify_mark)

/* @param: resource: One of `RLIMIT_*' from <sys/resource.h> */
/* errno_t prlimit64(pid_t pid, syscall_ulong_t resource, struct rlimitx32_64 const *new_limit, struct rlimitx32_64 *old_limit) */
.section .text.x86.asm32_syscall_sysenter.prlimit64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_prlimit64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x154
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_prlimit64)
	call   sys_prlimit64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_prlimit64)

/* @param: flags: Set of `0 | AT_EMPTY_PATH | AT_SYMLINK_FOLLOW | AT_DOSPATH' */
/* errno_t name_to_handle_at(fd_t dirfd, char const *filename, struct file_handle *handle, int32_t *mnt_id, atflag_t flags) */
.section .text.x86.asm32_syscall_sysenter.name_to_handle_at
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_name_to_handle_at)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x155
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_name_to_handle_at)
	call   sys_name_to_handle_at
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_name_to_handle_at)

/* fd_t open_by_handle_at(fd_t mountdirfd, struct file_handle const *handle, oflag_t flags) */
.section .text.x86.asm32_syscall_sysenter.open_by_handle_at
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_open_by_handle_at)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x156
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_open_by_handle_at)
	call   sys_open_by_handle_at
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_open_by_handle_at)

/* errno_t clock_adjtime(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.clock_adjtime
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_clock_adjtime)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x157
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_clock_adjtime)
	call   sys_clock_adjtime
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_clock_adjtime)

/* errno_t syncfs(fd_t fd) */
.section .text.x86.asm32_syscall_sysenter.syncfs
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_syncfs)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x158
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_syncfs)
	call   sys_syncfs
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_syncfs)

/* Same as `sendmsg(2)', but may be used to send many
 * messages (datagrams)  with a  single system  call.
 * @param: msg_flags: Set of `MSG_CONFIRM | MSG_DONTROUTE | MSG_DONTWAIT |
 *                            MSG_EOR | MSG_MORE | MSG_NOSIGNAL | MSG_OOB'
 * @throw: ... Same as `sendmsg(2)'
 * @return: * : The # of datagrams successfully sent. */
/* ssize_t sendmmsg(fd_t sockfd, struct mmsghdrx32 *vmessages, size_t vlen, syscall_ulong_t msg_flags) */
.section .text.x86.asm32_syscall_sysenter.sendmmsg
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sendmmsg)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x159
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sendmmsg)
	call   sys_sendmmsg
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_sendmmsg)

/* errno_t setns(fd_t fd, syscall_ulong_t nstype) */
.section .text.x86.asm32_syscall_sysenter.setns
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_setns)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x15a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setns)
	call   sys_setns
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_setns)

/* Read memory from another process's VM
 * @param: flags: Must be `0'
 * @return: * :   The actual number of read bytes */
/* ssize_t process_vm_readv(pid_t pid, struct iovecx32 const *local_iov, size_t liovcnt, struct iovecx32 const *remote_iov, size_t riovcnt, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.process_vm_readv
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_process_vm_readv)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x15b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   4(%ebp)  /* Arg #5 (WARNING: SEGFAULT!) */
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_process_vm_readv)
	call   sys_process_vm_readv
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_process_vm_readv)

/* Write memory to another process's VM
 * @param: flags: Must be `0'
 * @return: * :   The actual number of written bytes */
/* ssize_t process_vm_writev(pid_t pid, struct iovecx32 const *local_iov, size_t liovcnt, struct iovecx32 const *remote_iov, size_t riovcnt, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.process_vm_writev
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_process_vm_writev)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x15c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   4(%ebp)  /* Arg #5 (WARNING: SEGFAULT!) */
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_process_vm_writev)
	call   sys_process_vm_writev
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_process_vm_writev)

/* @param: type: One of  `KCMP_FILE',  `KCMP_FILES',  `KCMP_FS',  `KCMP_IO',
 *               `KCMP_SIGHAND', `KCMP_SYSVSEM', `KCMP_VM', `KCMP_EPOLL_TFD' */
/* syscall_slong_t kcmp(pid_t pid1, pid_t pid2, syscall_ulong_t type, syscall_ulong_t idx1, syscall_ulong_t idx2) */
.section .text.x86.asm32_syscall_sysenter.kcmp
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_kcmp)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x15d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_kcmp)
	call   sys_kcmp
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_kcmp)

/* Load a  kernel  driver  from an  ELF  image  `module_image...+=len'
 * This system call exists for linux compatibility, and is implemented
 * as an alias for  `KSYSCTL_DRIVER_INSMOD:KSYSCTL_DRIVER_FORMAT_FILE'
 * 
 * Note however that that is where linux compatibility ends. Since the
 * linux kernel does not implement any semblance of a stable ABI,  you
 * have to realize that on KOS, this system call can only load drivers
 * specifically built to run within the KOS kernel!
 * @param: uargs: The driver commandline */
/* errno_t finit_module(fd_t fd, char const *uargs, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.finit_module
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_finit_module)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x15e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_finit_module)
	call   sys_finit_module
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_finit_module)

/* errno_t sched_setattr(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.sched_setattr
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sched_setattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x15f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sched_setattr)
	call   sys_sched_setattr
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_sched_setattr)

/* errno_t sched_getattr(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.sched_getattr
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sched_getattr)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x160
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sched_getattr)
	call   sys_sched_getattr
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_sched_getattr)

/* @param: flags: Set of `0 | AT_RENAME_NOREPLACE | AT_RENAME_EXCHANGE | AT_RENAME_WHITEOUT | AT_RENAME_MOVETODIR | AT_DOSPATH' */
/* errno_t renameat2(fd_t olddirfd, char const *oldpath, fd_t newdirfd, char const *newpath, atflag_t flags) */
.section .text.x86.asm32_syscall_sysenter.renameat2
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_renameat2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x161
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_renameat2)
	call   sys_renameat2
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_renameat2)

/* errno_t seccomp(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.seccomp
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_seccomp)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x162
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_seccomp)
	call   sys_seccomp
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_seccomp)

/* @param: flags: Set of `0 | GRND_RANDOM | GRND_NONBLOCK' */
/* ssize_t getrandom(void *buf, size_t num_bytes, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.getrandom
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getrandom)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x163
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getrandom)
	call   sys_getrandom
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getrandom)

/* @param: flags: Set of `MFD_CLOEXEC | MFD_CLOFORK | MFD_ALLOW_SEALING | MFD_HUGETLB' */
/* fd_t memfd_create(char const *name, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.memfd_create
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_memfd_create)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x164
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_memfd_create)
	call   sys_memfd_create
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_memfd_create)

/* errno_t bpf(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.bpf
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_bpf)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x165
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_bpf)
	call   sys_bpf
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_bpf)

/* Replace the calling  process with  the application  image referred  to by  `path' /  `file'
 * and execute it's `main()' method, passing the given `argv', and setting `environ' to `envp'
 * @param: flags: Set of `0 | AT_EMPTY_PATH | AT_SYMLINK_NOFOLLOW | AT_DOSPATH' */
/* errno_t execveat(fd_t dirfd, char const *pathname, __HYBRID_PTR32(char const) const *argv, __HYBRID_PTR32(char const) const *envp, atflag_t flags) */
.section .text.x86.asm32_syscall_sysenter.execveat
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_execveat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x166
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_execveat)
	call   sys_execveat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_execveat)

/* Create a new socket for the given domain/type/protocol triple.
 * @param: domain:   Socket address domain/family (one of `AF_*' from `<sys/socket.h>')
 * @param: type:     Socket type (one of `SOCK_*' from `<sys/socket.h>')
 *                   May optionally be or'd with `SOCK_CLOEXEC | SOCK_CLOFORK | SOCK_NONBLOCK'
 * @param: protocol: Socket protocol (`0' for automatic). Available socket protocols mainly
 *                   depend on the selected `domain', and may be further specialized by the
 *                   `type' argument.  for  example,  `AF_INET' takes  one  of  `IPPROTO_*'
 *                   >> socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
 *                   Also note that protocol IDs can be enumerated by `getprotoent(3)' from `<netdb.h>'
 * @return: * : A file descriptor for the newly created socket. */
/* fd_t socket(syscall_ulong_t domain, syscall_ulong_t type, syscall_ulong_t protocol) */
.section .text.x86.asm32_syscall_sysenter.socket
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_socket)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x167
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_socket)
	call   sys_socket
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_socket)

/* Create a new socket for the given domain/type/protocol triple.
 * @param: domain:   Socket address domain/family (one of `AF_*' from `<sys/socket.h>')
 * @param: type:     Socket type (one of `SOCK_*' from `<sys/socket.h>')
 *                   May optionally be or'd with `SOCK_CLOEXEC | SOCK_CLOFORK | SOCK_NONBLOCK'
 * @param: protocol: Socket protocol (`0' for automatic). Available socket protocols mainly
 *                   depend on the selected `domain', and may be further specialized by the
 *                   `type' argument.  for  example,  `AF_INET' takes  one  of  `IPPROTO_*'
 *                   >> socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
 *                   Also note that protocol IDs can be enumerated by `getprotoent(3)' from `<netdb.h>'
 * @return: * : A file descriptor for the newly created socket. */
/* errno_t socketpair(syscall_ulong_t domain, syscall_ulong_t type, syscall_ulong_t protocol, fd_t[2] fds) */
.section .text.x86.asm32_syscall_sysenter.socketpair
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_socketpair)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x168
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_socketpair)
	call   sys_socketpair
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_socketpair)

/* Bind the given socket `sockfd' to the specified local address.
 * @throw: E_NET_ADDRESS_IN_USE:E_NET_ADDRESS_IN_USE_CONTEXT_CONNECT
 * @throw: E_INVALID_ARGUMENT_UNEXPECTED_COMMAND:E_INVALID_ARGUMENT_CONTEXT_BIND_WRONG_ADDRESS_FAMILY
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_BIND_ALREADY_BOUND
 * @throw: E_NET_ADDRESS_NOT_AVAILABLE
 * @throw: E_BUFFER_TOO_SMALL   (`addr_len' is incorrect)
 * @return: 0 : Success */
/* errno_t bind(fd_t sockfd, struct sockaddr const *addr, socklen_t addr_len) */
.section .text.x86.asm32_syscall_sysenter.bind
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_bind)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x169
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_bind)
	call   sys_bind
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_bind)

/* Connect to the specified address.
 * If the given `sockfd' isn't connection-oriented, this will set the address
 * that  will implicitly be  used as destination  by `send(2)' and `write(2)'
 * @throw: E_NET_ADDRESS_IN_USE:E_NET_ADDRESS_IN_USE_CONTEXT_CONNECT
 * @throw: E_INVALID_ARGUMENT_UNEXPECTED_COMMAND:E_INVALID_ARGUMENT_CONTEXT_BIND_WRONG_ADDRESS_FAMILY
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_BIND_ALREADY_BOUND
 * @throw: E_NET_ADDRESS_NOT_AVAILABLE
 * @throw: E_NET_CONNECTION_REFUSED
 * @throw: E_BUFFER_TOO_SMALL   (addr_len is incorrect)
 * @return: 0 : Success */
/* errno_t connect(fd_t sockfd, struct sockaddr const *addr, socklen_t addr_len) */
.section .text.x86.asm32_syscall_sysenter.connect
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_connect)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x16a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_connect)
	call   sys_connect
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_connect)

/* Begin to listen for incoming client (aka. peer) connection requests.
 * @param: max_backlog: The max number of clients  pending to be accept(2)-ed,  before
 *                      the kernel will refuse to enqueue additional clients, and will
 *                      instead automatically refuse  any further  requests until  the
 *                      less than `max_backlog' clients are still pending.
 * @throw: E_NET_ADDRESS_IN_USE:E_NET_ADDRESS_IN_USE_CONTEXT_LISTEN
 * @throw: E_INVALID_HANDLE_NET_OPERATION:E_NET_OPERATION_LISTEN
 * @return: 0 : Success */
/* errno_t listen(fd_t sockfd, syscall_ulong_t max_backlog) */
.section .text.x86.asm32_syscall_sysenter.listen
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_listen)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x16b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_listen)
	call   sys_listen
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_listen)

/* Accept incoming client (aka. peer) connection requests.
 * @param: addr:       Peer address of the sender (or `NULL' when `addr_len' is `NULL')
 * @param: addr_len:   [NULL] Don't fill in the client's peer address
 *                     [in]   The amount of available memory starting at `addr'
 *                     [out]  The  amount  of required  memory for  the address.
 *                            This  may be  more than  was given,  in which case
 *                            the  address  was  truncated and  may  be invalid.
 *                            If this happens,  the caller  can still  determine
 *                            the correct address through use of `getpeername()'
 * @param: sock_flags: Set of `SOCK_NONBLOCK | SOCK_CLOEXEC | SOCK_CLOFORK'
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_ACCEPT_NOT_LISTENING
 * @throw: E_INVALID_HANDLE_NET_OPERATION:E_NET_OPERATION_ACCEPT
 * @throw: E_NET_CONNECTION_ABORT
 * @return: * : A file descriptor for the newly accept(2)-ed connection */
/* fd_t accept4(fd_t sockfd, struct sockaddr *addr, socklen_t *addr_len, syscall_ulong_t sock_flags) */
.section .text.x86.asm32_syscall_sysenter.accept4
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_accept4)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x16c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_accept4)
	call   sys_accept4
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_accept4)

/* Get the value of the named socket option `level:optname' and store it in `optval'
 * @param: level:   One of `SOL_*' (e.g.: `SOL_SOCKET')
 * @param: optname: Dependent on `level'
 * @param: optval:  Buffer for where to write the value of the socket option.
 * @param: optlen:  [in]  The amount of available memory starting at `optval'
 *                  [out] The amount of required memory for the option value.
 *                        This may be more than was given, in which case
 *                        the  contents  of   `optval'  are   undefined.
 * @throw: E_INVALID_ARGUMENT_SOCKET_OPT:E_INVALID_ARGUMENT_CONTEXT_GETSOCKOPT
 * @return: 0 : Success */
/* errno_t getsockopt(fd_t sockfd, syscall_ulong_t level, syscall_ulong_t optname, void *optval, socklen_t *optlen) */
.section .text.x86.asm32_syscall_sysenter.getsockopt
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getsockopt)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x16d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getsockopt)
	call   sys_getsockopt
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getsockopt)

/* Set the value of the named socket option `level:optname' from what is given in `optval'
 * @param: level:   One of `SOL_*' (e.g.: `SOL_SOCKET')
 * @param: optname: Dependent on `level'
 * @param: optval:  Buffer for where to write the value of the socket option.
 * @param: optlen:  The amount of available memory starting at `optval'
 * @throw: E_INVALID_ARGUMENT_SOCKET_OPT:E_INVALID_ARGUMENT_CONTEXT_SETSOCKOPT
 * @throw: E_BUFFER_TOO_SMALL  (The specified `optlen' is invalid for the given option)
 * @return: 0 : Success */
/* errno_t setsockopt(fd_t sockfd, syscall_ulong_t level, syscall_ulong_t optname, void const *optval, socklen_t optlen) */
.section .text.x86.asm32_syscall_sysenter.setsockopt
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_setsockopt)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x16e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_setsockopt)
	call   sys_setsockopt
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_setsockopt)

/* Determine the local address (aka. name) for the given socket `sockfd'.
 * This  is usually the  same address as was  previously set by `bind(2)'
 * NOTE: Before the socket has actually be bound or connected, the exact
 *       address that is returned by this function is weakly  undefined.
 *       e.g.: For AF_INET, sin_addr=0.0.0.0, sin_port=0 is returned.
 * @param: addr:     [out] Buffer where to store the sock address.
 * @param: addr_len: [in]  The amount of available memory starting at `addr'
 *                   [out] The amount of required memory for the address.
 *                         This may be more than was given, in which case
 *                         the  address was truncated and may be invalid.
 * return: 0 : Success */
/* errno_t getsockname(fd_t sockfd, struct sockaddr *addr, socklen_t *addr_len) */
.section .text.x86.asm32_syscall_sysenter.getsockname
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getsockname)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x16f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getsockname)
	call   sys_getsockname
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getsockname)

/* Lookup the peer (remote) address of `sockfd' and store it in `*addr...+=*addr_len'
 * @param: addr:     [out] Buffer where to store the sock address.
 * @param: addr_len: [in]  The amount of available memory starting at `addr'
 *                   [out] The amount of required memory for the address.
 *                         This may be more than was given, in which case
 *                         the  address was truncated and may be invalid.
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_GETPEERNAME_NOT_CONNECTED
 * @return: 0 : Success */
/* errno_t getpeername(fd_t sockfd, struct sockaddr *addr, socklen_t *addr_len) */
.section .text.x86.asm32_syscall_sysenter.getpeername
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_getpeername)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x170
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_getpeername)
	call   sys_getpeername
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_getpeername)

/* Send the contents of a given buffer over this socket to the specified address
 * @param: buf:       Buffer of data to send (with a length of `bufsize' bytes)
 * @param: bufsize:   Size of `buf' (in bytes)
 * @param: msg_flags: Set of `MSG_CONFIRM | MSG_DONTROUTE | MSG_DONTWAIT |
 *                            MSG_EOR | MSG_MORE | MSG_NOSIGNAL | MSG_OOB'
 * @param: addr:      Address where to send data (or NULL when `addr_len' is 0)
 * @param: addr_len:  Size of `addr', or `0' to have this behave as an alias
 *                    for            `send(sockfd, buf, bufsize, msg_flags)'
 * @throw: E_INVALID_ARGUMENT_UNEXPECTED_COMMAND:E_INVALID_ARGUMENT_CONTEXT_SENDTO_WRONG_ADDRESS_FAMILY
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_SEND_NOT_CONNECTED
 * @throw: E_NET_MESSAGE_TOO_LONG
 * @throw: E_NET_CONNECTION_RESET
 * @throw: E_NET_SHUTDOWN
 * @throw: E_BUFFER_TOO_SMALL  (`addr_len' is incorrect)
 * @return: * : [<= bufsize] The actual # of send bytes */
/* ssize_t sendto(fd_t sockfd, void const *buf, size_t bufsize, syscall_ulong_t msg_flags, struct sockaddr const *addr, socklen_t addr_len) */
.section .text.x86.asm32_syscall_sysenter.sendto
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sendto)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x171
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   4(%ebp)  /* Arg #5 (WARNING: SEGFAULT!) */
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sendto)
	call   sys_sendto
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_sendto)

/* Same as `send(2)' and `sendto(2)', but also allows for sending ancillary
 * data as well as  for data buffers  to be represented  by an IOV  vector.
 * @param: msg_flags: Set of `MSG_CONFIRM | MSG_DONTROUTE | MSG_DONTWAIT |
 *                            MSG_EOR | MSG_MORE | MSG_NOSIGNAL | MSG_OOB'
 * @throw: ... Same as for `send(2)' and `sendto(2)'
 * @return: * : [<= bufsize] The actual # of send payload bytes */
/* ssize_t sendmsg(fd_t sockfd, struct msghdrx32 const *message, syscall_ulong_t msg_flags) */
.section .text.x86.asm32_syscall_sysenter.sendmsg
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sendmsg)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x172
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sendmsg)
	call   sys_sendmsg
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_sendmsg)

/* Receive data over this socket, and store the contents within the given buffer.
 * @param: buf:       Buffer to-be filled with up to `bufsize' bytes of received data
 * @param: bufsize:   Max # of bytes to receive
 * @param: msg_flags: Set of `MSG_DONTWAIT | MSG_ERRQUEUE | MSG_OOB |
 *                            MSG_PEEK | MSG_TRUNC | MSG_WAITALL'
 * @param: addr:      Peer address of the sender (or `NULL' when `addr_len' is `NULL')
 * @param: addr_len:  [NULL] behave as an alias for `recv(sockfd, buf, bufsize, msg_flags)'
 *                    [in]   The amount of available memory starting at `addr'
 *                    [out]  The amount of required memory for the address.
 *                           This may be more than was given, in which case
 *                           the address was truncated and may be invalid.
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_RECV_NOT_CONNECTED
 * @throw: E_NET_CONNECTION_REFUSED
 * @throw: E_WOULDBLOCK (`MSG_DONTWAIT' was given, and the operation would have blocked)
 * @return: * : [<= bufsize] The actual # of received bytes */
/* ssize_t recvfrom(fd_t sockfd, void *buf, size_t bufsize, syscall_ulong_t msg_flags, struct sockaddr *addr, socklen_t *addr_len) */
.section .text.x86.asm32_syscall_sysenter.recvfrom
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_recvfrom)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x173
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   4(%ebp)  /* Arg #5 (WARNING: SEGFAULT!) */
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_recvfrom)
	call   sys_recvfrom
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_recvfrom)

/* Same as `recv(2)' and `recvfrom(2)', but also allows for receiving ancillary
 * data as  well as  for  data buffers  to be  represented  by an  IOV  vector.
 * @param: msg_flags: Set of `MSG_CMSG_CLOEXEC | MSG_CMSG_CLOFORK |
 *                            MSG_DONTWAIT | MSG_ERRQUEUE | MSG_OOB |
 *                            MSG_PEEK  |  MSG_TRUNC  |  MSG_WAITALL'
 * @throw: ... Same as for `recv(2)' and `recvfrom(2)'
 * @return: * : [<= bufsize] The actual # of received payload bytes */
/* ssize_t recvmsg(fd_t sockfd, struct msghdrx32 *message, syscall_ulong_t msg_flags) */
.section .text.x86.asm32_syscall_sysenter.recvmsg
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_recvmsg)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x174
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_recvmsg)
	call   sys_recvmsg
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_recvmsg)

/* Disallow further reception of data (causing `recv(2)' to return `0' as soon
 * as  all currently queued  data has been  read), and/or further transmission
 * of data (causing `send(2)' to throw an `E_NET_SHUTDOWN' exception)
 * @param: how: One of `SHUT_RD', `SHUT_WR' or `SHUT_RDWR'
 * @throw: E_ILLEGAL_BECAUSE_NOT_READY:E_ILLEGAL_OPERATION_CONTEXT_SOCKET_SHUTDOWN_NOT_CONNECTED
 * @return: 0 : Success */
/* errno_t shutdown(fd_t sockfd, syscall_ulong_t how) */
.section .text.x86.asm32_syscall_sysenter.shutdown
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_shutdown)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x175
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_shutdown)
	call   sys_shutdown
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_shutdown)

/* fd_t userfaultfd(syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.userfaultfd
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_userfaultfd)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x176
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_userfaultfd)
	call   sys_userfaultfd
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_userfaultfd)

/* errno_t membarrier(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.membarrier
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_membarrier)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x177
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_membarrier)
	call   sys_membarrier
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_membarrier)

/* errno_t mlock2(void const *addr, size_t length, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.mlock2
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mlock2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x178
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mlock2)
	call   sys_mlock2
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_mlock2)

/* errno_t copy_file_range(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.copy_file_range
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_copy_file_range)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x179
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_copy_file_range)
	call   sys_copy_file_range
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_copy_file_range)

/* errno_t preadv2(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.preadv2
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_preadv2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x17a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_preadv2)
	call   sys_preadv2
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_preadv2)

/* errno_t pwritev2(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.pwritev2
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_pwritev2)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x17b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pwritev2)
	call   sys_pwritev2
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_pwritev2)

/* errno_t pkey_mprotect(void *addr, size_t len, syscall_ulong_t prot, syscall_ulong_t pkey) */
.section .text.x86.asm32_syscall_sysenter.pkey_mprotect
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_pkey_mprotect)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x17c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pkey_mprotect)
	call   sys_pkey_mprotect
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_pkey_mprotect)

/* syscall_slong_t pkey_alloc(syscall_ulong_t flags, syscall_ulong_t access_rights) */
.section .text.x86.asm32_syscall_sysenter.pkey_alloc
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_pkey_alloc)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x17d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pkey_alloc)
	call   sys_pkey_alloc
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_pkey_alloc)

/* errno_t pkey_free(syscall_ulong_t key) */
.section .text.x86.asm32_syscall_sysenter.pkey_free
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_pkey_free)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x17e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pkey_free)
	call   sys_pkey_free
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_pkey_free)

/* errno_t statx(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.statx
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_statx)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x17f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_statx)
	call   sys_statx
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_statx)

/* >> arch_prctl(2)
 * Arch-dependent system process control interface. (But don't go and
 * think that the  normal `prctl(2)'  doesn't feature  arch-dependent
 * commands  -- honestly, this syscall shouldn't exist if you ask me,
 * but it does on linux, and so it must also on KOS...)
 * @param: command: One of `ARCH_*' (from <asm/prctl.h>)
 * @param: addr: Either a `syscall_ulong_t' or `syscall_ulong_t *', depending on `command'
 * @return: * :  Return value depends on `command' */
/* syscall_slong_t arch_prctl(unsigned int command, uint32_t *addr) */
.section .text.x86.asm32_syscall_sysenter.arch_prctl
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_arch_prctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x180
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_arch_prctl)
	call   sys_arch_prctl
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_arch_prctl)

/* errno_t io_pgetevents(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.io_pgetevents
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_io_pgetevents)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x181
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_io_pgetevents)
	call   sys_io_pgetevents
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_io_pgetevents)

/* errno_t rseq(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.rseq
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_rseq)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x182
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_rseq)
	call   sys_rseq
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_rseq)

/* errno_t semget(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.semget
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_semget)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x189
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_semget)
	call   sys_semget
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_semget)

/* errno_t semctl(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.semctl
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_semctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x18a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_semctl)
	call   sys_semctl
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_semctl)

/* errno_t shmget(key_t key, size_t size, syscall_ulong_t shmflg) */
.section .text.x86.asm32_syscall_sysenter.shmget
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_shmget)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x18b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_shmget)
	call   sys_shmget
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_shmget)

/* errno_t shmctl(syscall_ulong_t shmid, syscall_ulong_t cmd, struct shmid_ds *buf) */
.section .text.x86.asm32_syscall_sysenter.shmctl
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_shmctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x18c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_shmctl)
	call   sys_shmctl
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_shmctl)

/* errno_t shmat(syscall_ulong_t shmid, void const *shmaddr, syscall_ulong_t shmflg) */
.section .text.x86.asm32_syscall_sysenter.shmat
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_shmat)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x18d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_shmat)
	call   sys_shmat
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_shmat)

/* errno_t shmdt(void const *shmaddr) */
.section .text.x86.asm32_syscall_sysenter.shmdt
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_shmdt)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x18e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_shmdt)
	call   sys_shmdt
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_shmdt)

/* errno_t msgget(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.msgget
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_msgget)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x18f
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_msgget)
	call   sys_msgget
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_msgget)

/* errno_t msgsnd(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.msgsnd
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_msgsnd)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x190
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_msgsnd)
	call   sys_msgsnd
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_msgsnd)

/* errno_t msgrcv(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.msgrcv
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_msgrcv)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x191
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_msgrcv)
	call   sys_msgrcv
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_msgrcv)

/* errno_t msgctl(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.msgctl
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_msgctl)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x192
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_msgctl)
	call   sys_msgctl
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_msgctl)

/* errno_t clock_gettime64(clockid_t clock_id, struct timespecx32_64 *tp) */
.section .text.x86.asm32_syscall_sysenter.clock_gettime64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_clock_gettime64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x193
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_clock_gettime64)
	call   sys_clock_gettime64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_clock_gettime64)

/* errno_t clock_settime64(clockid_t clock_id, struct timespecx32_64 const *tp) */
.section .text.x86.asm32_syscall_sysenter.clock_settime64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_clock_settime64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x194
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_clock_settime64)
	call   sys_clock_settime64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_clock_settime64)

/* errno_t clock_adjtime64(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.clock_adjtime64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_clock_adjtime64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x195
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_clock_adjtime64)
	call   sys_clock_adjtime64
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_clock_adjtime64)

/* errno_t clock_getres_time64(clockid_t clock_id, struct timespecx32_64 *res) */
.section .text.x86.asm32_syscall_sysenter.clock_getres_time64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_clock_getres_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x196
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_clock_getres_time64)
	call   sys_clock_getres_time64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_clock_getres_time64)

/* errno_t clock_nanosleep_time64(clockid_t clock_id, syscall_ulong_t flags, struct timespecx32_64 const *requested_time, struct timespecx32_64 *remaining) */
.section .text.x86.asm32_syscall_sysenter.clock_nanosleep_time64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_clock_nanosleep_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x197
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_clock_nanosleep_time64)
	call   sys_clock_nanosleep_time64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_clock_nanosleep_time64)

/* errno_t timer_gettime64(timer_t timerid, struct itimerspecx32_64 *value) */
.section .text.x86.asm32_syscall_sysenter.timer_gettime64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_timer_gettime64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x198
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_timer_gettime64)
	call   sys_timer_gettime64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_timer_gettime64)

/* @param: flags: Set of `0 | TIMER_ABSTIME' */
/* errno_t timer_settime64(timer_t timerid, syscall_ulong_t flags, struct itimerspecx32_64 const *value, struct itimerspecx32_64 *ovalue) */
.section .text.x86.asm32_syscall_sysenter.timer_settime64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_timer_settime64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x199
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_timer_settime64)
	call   sys_timer_settime64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_timer_settime64)

/* Return the next expiration time of UFD */
/* errno_t timerfd_gettime64(fd_t timerfd, struct itimerspecx32_64 *otmr) */
.section .text.x86.asm32_syscall_sysenter.timerfd_gettime64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_timerfd_gettime64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x19a
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_timerfd_gettime64)
	call   sys_timerfd_gettime64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_timerfd_gettime64)

/* Set next expiration time of interval timer source `timerfd' to `utmr'.
 * If `flags'  has the  `TFD_TIMER_ABSTIME' flag  set the  timeout  value
 * is absolute. Optionally return the old expiration time in `otmr'
 * @param: flags: Set of `0 | TFD_TIMER_ABSTIME' */
/* errno_t timerfd_settime64(fd_t timerfd, syscall_ulong_t flags, struct itimerspecx32_64 const *utmr, struct itimerspecx32_64 *otmr) */
.section .text.x86.asm32_syscall_sysenter.timerfd_settime64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_timerfd_settime64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x19b
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_timerfd_settime64)
	call   sys_timerfd_settime64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_timerfd_settime64)

/* @param: flags: Set of `0 | AT_SYMLINK_NOFOLLOW | AT_CHANGE_BTIME | AT_DOSPATH' */
/* errno_t utimensat_time64(fd_t dirfd, char const *filename, struct timespecx32_64 const[2] times, atflag_t flags) */
.section .text.x86.asm32_syscall_sysenter.utimensat_time64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_utimensat_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x19c
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_utimensat_time64)
	call   sys_utimensat_time64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_utimensat_time64)

/* ssize_t pselect6_time64(size_t nfds, struct __fd_set_struct *readfds, struct __fd_set_struct *writefds, struct __fd_set_struct *exceptfds, struct timespecx32_64 const *timeout, struct __sigset_with_sizex32 const *sigmask_sigset_with_size) */
.section .text.x86.asm32_syscall_sysenter.pselect6_time64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_pselect6_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x19d
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   4(%ebp)  /* Arg #5 (WARNING: SEGFAULT!) */
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pselect6_time64)
	call   sys_pselect6_time64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_pselect6_time64)

/* ssize_t ppoll_time64(struct pollfd *fds, size_t nfds, struct timespecx32_64 const *timeout_ts, struct __sigset_struct const *sigmask, size_t sigsetsize) */
.section .text.x86.asm32_syscall_sysenter.ppoll_time64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_ppoll_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x19e
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_ppoll_time64)
	call   sys_ppoll_time64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_ppoll_time64)

/* errno_t io_pgetevents_time64(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.io_pgetevents_time64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_io_pgetevents_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1a0
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_io_pgetevents_time64)
	call   sys_io_pgetevents_time64
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_io_pgetevents_time64)

/* Same as `recvmsg(2)', but may be used to receive many
 * messages  (datagrams)  with  a  single  system  call.
 * @param: msg_flags: Set of `MSG_CMSG_CLOEXEC | MSG_CMSG_CLOFORK |
 *                            MSG_DONTWAIT | MSG_ERRQUEUE | MSG_OOB |
 *                            MSG_PEEK  |  MSG_TRUNC |  MSG_WAITALL |
 *                            MSG_WAITFORONE'
 * @throw: Error (s.a. `recvmsg(2)')
 * @return: * : The # of datagrams successfully received. */
/* ssize_t recvmmsg_time64(fd_t sockfd, struct mmsghdrx32 *vmessages, size_t vlen, syscall_ulong_t msg_flags, struct timespecx32_64 const *tmo) */
.section .text.x86.asm32_syscall_sysenter.recvmmsg_time64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_recvmmsg_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1a1
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_recvmmsg_time64)
	call   sys_recvmmsg_time64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_recvmmsg_time64)

/* errno_t mq_timedsend_time64(fd_t mqdes, char const *msg_ptr, size_t msg_len, uint32_t msg_prio, struct timespecx32_64 const *abs_timeout) */
.section .text.x86.asm32_syscall_sysenter.mq_timedsend_time64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mq_timedsend_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1a2
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mq_timedsend_time64)
	call   sys_mq_timedsend_time64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_mq_timedsend_time64)

/* ssize_t mq_timedreceive_time64(fd_t mqdes, char *msg_ptr, size_t msg_len, uint32_t *pmsg_prio, struct timespecx32_64 const *abs_timeout) */
.section .text.x86.asm32_syscall_sysenter.mq_timedreceive_time64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_mq_timedreceive_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1a3
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_mq_timedreceive_time64)
	call   sys_mq_timedreceive_time64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(8), %esp
	.cfi_adjust_cfa_offset -8
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_mq_timedreceive_time64)

/* errno_t semtimedop_time64(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.semtimedop_time64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_semtimedop_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1a4
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_semtimedop_time64)
	call   sys_semtimedop_time64
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_semtimedop_time64)

/* syscall_slong_t rt_sigtimedwait_time64(struct __sigset_struct const *set, struct __siginfox32_struct *info, struct timespecx32_64 const *timeout, size_t sigsetsize) */
.section .text.x86.asm32_syscall_sysenter.rt_sigtimedwait_time64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_rt_sigtimedwait_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1a5
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_rt_sigtimedwait_time64)
	call   sys_rt_sigtimedwait_time64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_rt_sigtimedwait_time64)

/* @param: futex_op: One of `FUTEX_*' from <linux/futex.h> */
/* syscall_slong_t futex_time64(uint32_t *uaddr, syscall_ulong_t futex_op, uint32_t val, struct timespecx32_64 const *timeout_or_val2, uint32_t *uaddr2, uint32_t val3) */
.section .text.x86.asm32_syscall_sysenter.futex_time64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_futex_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1a6
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	cmpl   $(KERNELSPACE_BASE), %ebp
	jae    __asm32_bad_sysenter_extension
	pushl_cfi   4(%ebp)  /* Arg #5 (WARNING: SEGFAULT!) */
	pushl_cfi   0(%ebp)  /* Arg #4 (WARNING: SEGFAULT!) */
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_futex_time64)
	call   sys_futex_time64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	addl   $(12), %esp
	.cfi_adjust_cfa_offset -12
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_futex_time64)

/* errno_t sched_rr_get_interval_time64(pid_t pid, struct timespecx32_64 *ts) */
.section .text.x86.asm32_syscall_sysenter.sched_rr_get_interval_time64
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_sched_rr_get_interval_time64)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1a7
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_sched_rr_get_interval_time64)
	call   sys_sched_rr_get_interval_time64
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_sched_rr_get_interval_time64)

/* Send a signal to the process of a given pidfd
 * @param: pidfd:  A `HANDLE_TYPE_PIDFD'-handle
 * @param: usigno: The signal that should be sent
 * @param: uinfo:  [0..1] Additional signal information
 * @param: flags:  Must always be `0' (for now)
 * @throw: E_PROCESS_EXITED:                                                                  [...]
 * @throw: E_INVALID_ARGUMENT_RESERVED_ARGUMENT:E_INVALID_ARGUMENT_CONTEXT_PIDFD_GETFD_FLAGS: [...]
 * @throw: E_INVALID_ARGUMENT_UNEXPECTED_COMMAND:E_INVALID_ARGUMENT_CONTEXT_SIGINFO_SIGNO:    [...]
 * @throw: E_INVALID_ARGUMENT_BAD_VALUE:E_INVALID_ARGUMENT_CONTEXT_BAD_SIGNO:                 [...]
 * @throw: E_INVALID_ARGUMENT_BAD_VALUE:E_INVALID_ARGUMENT_CONTEXT_RAISE_SIGINFO_BADCODE:     [...]
 * @throw: E_INVALID_HANDLE_FILE:                                                             [...]
 * @throw: E_ILLEGAL_OPERATION:                                                               [...] */
/* errno_t pidfd_send_signal(fd_t pidfd, signo_t usigno, struct __siginfox32_struct const *uinfo, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.pidfd_send_signal
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_pidfd_send_signal)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1a8
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %esi  /* Arg #3 */
	pushl_cfi_r %edx  /* Arg #2 */
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pidfd_send_signal)
	call   sys_pidfd_send_signal
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi_r %esi
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_pidfd_send_signal)

/* errno_t io_uring_setup(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.io_uring_setup
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_io_uring_setup)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1a9
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_io_uring_setup)
	call   sys_io_uring_setup
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_io_uring_setup)

/* errno_t io_uring_enter(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.io_uring_enter
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_io_uring_enter)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1aa
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_io_uring_enter)
	call   sys_io_uring_enter
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_io_uring_enter)

/* errno_t io_uring_register(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.io_uring_register
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_io_uring_register)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1ab
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_io_uring_register)
	call   sys_io_uring_register
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_io_uring_register)

/* errno_t open_tree(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.open_tree
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_open_tree)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1ac
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_open_tree)
	call   sys_open_tree
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_open_tree)

/* errno_t move_mount(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.move_mount
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_move_mount)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1ad
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_move_mount)
	call   sys_move_mount
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_move_mount)

/* errno_t fsopen(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.fsopen
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fsopen)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1ae
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fsopen)
	call   sys_fsopen
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_fsopen)

/* errno_t fsconfig(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.fsconfig
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fsconfig)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1af
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fsconfig)
	call   sys_fsconfig
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_fsconfig)

/* errno_t fsmount(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.fsmount
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fsmount)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1b0
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fsmount)
	call   sys_fsmount
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_fsmount)

/* errno_t fspick(int TODO_PROTOTYPE) */
.section .text.x86.asm32_syscall_sysenter.fspick
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_fspick)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1b1
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %ecx
	pushl_cfi_r %edx
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_fspick)
	call   sys_fspick
	popl_cfi_r %ebx
	popl_cfi_r %edx
	popl_cfi_r %ecx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_fspick)

/* Return a `HANDLE_TYPE_PIDFD' handle for the given `pid'
 * This system call exists for compatibility with linux, which does not  allow
 * this call to succeed when `pid' isn't a process leader (i.e. main() thread)
 * @param: flags: Must always be `0' (for now)
 * @return: * :   A handle for the process `pid'
 * @throw: E_PROCESS_EXITED:                                                                 [...]
 * @throw: E_INVALID_ARGUMENT_RESERVED_ARGUMENT:E_INVALID_ARGUMENT_CONTEXT_PIDFD_OPEN_FLAGS: [...]
 * @throw: E_BADALLOC_INSUFFICIENT_HANDLE_NUMBERS:                                           [...] */
/* fd_t pidfd_open(pid_t pid, syscall_ulong_t flags) */
.section .text.x86.asm32_syscall_sysenter.pidfd_open
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_pidfd_open)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1b2
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %ax, %es
	movw   $(SEGMENT_KERNEL_FSBASE), %ax
	movw   %ax, %fs
	pushl_cfi_r %edx
	pushl_cfi_r %ecx  /* Arg #1 */
	pushl_cfi_r %ebx  /* Arg #0 */
	EXTERN(sys_pidfd_open)
	call   sys_pidfd_open
	popl_cfi_r %ebx
	popl_cfi_r %ecx
	popl_cfi_r %edx
	popl_cfi %fs
	.cfi_restore_iret_fs
	popl_cfi %es
	.cfi_restore_iret_es
	popl_cfi %ds
	.cfi_restore_iret_ds
	X86_IRET_BUT_PREFER_SYSEXIT
	.cfi_endproc
END(__x86_asm32_sysenter_pidfd_open)

/* syscall_slong_t clone3(struct clone_args *cl_args, size_t size) */
.section .text.x86.asm32_syscall_sysenter.clone3
INTERN_WEAK_FUNCTION(__x86_asm32_sysenter_clone3)
	.cfi_startproc simple
	.cfi_personality 0, x86_syscall_personality_asm32_sysenter
	.cfi_lsda 0, 0x1b3
	.cfi_iret_signal_frame
	.cfi_def_cfa %esp, 0
	pushl_cfi %ds
	.cfi_restore_iret_ds_or_offset -4
	pushl_cfi %es
	.cfi_restore_iret_es_or_offset -8
	pushl_cfi %fs
	.cfi_restore_iret_fs_or_offset -12
	movw   $(SEGMENT_USER_DATA_RPL), %ax
	movw   %ax, %ds
	movw   %