/* Copyright (c) 2019-2024 Griefer@Work                                       *
 *                                                                            *
 * This software is provided 'as-is', without any express or implied          *
 * warranty. In no event will the authors be held liable for any damages      *
 * arising from the use of this software.                                     *
 *                                                                            *
 * Permission is granted to anyone to use this software for any purpose,      *
 * including commercial applications, and to alter it and redistribute it     *
 * freely, subject to the following restrictions:                             *
 *                                                                            *
 * 1. The origin of this software must not be misrepresented; you must not    *
 *    claim that you wrote the original software. If you use this software    *
 *    in a product, an acknowledgement (see the following) in the product     *
 *    documentation is required:                                              *
 *    Portions Copyright (c) 2019-2024 Griefer@Work                           *
 * 2. Altered source versions must be plainly marked as such, and must not be *
 *    misrepresented as being the original software.                          *
 * 3. This notice may not be removed or altered from any source distribution. *
 */
/* Disable warnings emit by some headers under certain circumstances. */
#define __NO_WARNINGS 1

/* Prevent `<regexp.h>' from defining `compile(3)' */
#define __DO_NOT_DEFINE_COMPILE

/* Detect errors resulting from missing imports. */
#ifdef __cplusplus
#define __COMPILER_HAVE_BUG_BLOATY_CXX_USING 0
#endif /* __cplusplus */


/* In order to  ensure that all  of our system  headers work nice  with each  other,
 * try to include every single one at the same time in the following configurations:
 *   - <nothing>
 *   - _EVERY_SOURCE
 *   - __cplusplus
 *   - __cplusplus, _EVERY_SOURCE
 *   - __CRT_FREESTANDING
 *   - __CRT_FREESTANDING, _EVERY_SOURCE
 *   - __CRT_FREESTANDING, __cplusplus
 *   - __CRT_FREESTANDING, __cplusplus, _EVERY_SOURCE
 *   - _ISOC_PURE_SOURCE
 *   - _ISOC_PURE_SOURCE, _EVERY_SOURCE
 *   - _ISOC_PURE_SOURCE, __cplusplus
 *   - _ISOC_PURE_SOURCE, __cplusplus, _EVERY_SOURCE
 *   - __KERNEL__
 *   - __KERNEL__, _EVERY_SOURCE
 *   - __KERNEL__, __cplusplus
 *   - __KERNEL__, __cplusplus, _EVERY_SOURCE
 *   - __CRT_FREESTANDING, __KERNEL__
 *   - __CRT_FREESTANDING, __KERNEL__, _EVERY_SOURCE
 *   - __CRT_FREESTANDING, __KERNEL__, __cplusplus
 *   - __CRT_FREESTANDING, __KERNEL__, __cplusplus, _EVERY_SOURCE
 *   - _ISOC_PURE_SOURCE, __KERNEL__
 *   - _ISOC_PURE_SOURCE, __KERNEL__, _EVERY_SOURCE
 *   - _ISOC_PURE_SOURCE, __KERNEL__, __cplusplus
 *   - _ISOC_PURE_SOURCE, __KERNEL__, __cplusplus, _EVERY_SOURCE
 * NOTE: The __KERNEL__ variants are achieved by include all *.c  files
 *       twice, once as part of the kernel core, and once again as part
 *       of /bin/system-test
 */

/*[[[deemon
import fs;
import * from deemon;

local badFiles = List({
	"__stdcxx.h",
	"hybrid/__atomic-gasm.h",
	"hybrid/__atomic-libatomic.h",
	"hybrid/__atomic-msvc.h",
	"hybrid/sequence/rbtree-abi.h",
	"hybrid/__pointer-cxx-impl.h",
	"asm/os/",
	"bits/os/",
	"compat/asm/os/",
	"compat/bits/os/",
	"arm-kos",
	"i386-kos",
	"libc/local",
	"libc/template",
	"c++",
	"compiler",
	"crt-features",
	"libdl/module.h",
	"kos/except/checker.h",
	"system-test/ctest.h",
	"nt/pshpack1.h",
	"nt/pshpack2.h",
	"nt/pshpack4.h",
	"nt/pshpack8.h",
	"nt/poppack.h",
});

// Include everything from the .gitignore
for (local l: File.open("../../../.gitignore", "r")) {
	l = l.strip();
	if (!l || l.startswith("#"))
		continue;
	l = l.strip("/");
	if (!l.startswith("kos/"))
		continue;
	l = l[4:].lstrip("/");
	if (!l.startswith("include/"))
		continue;
	l = l[8:].lstrip("/");
	badFiles.append(l);
}


global final INCLUDE_PATH = "../../include/";
function incdir(path) {
	for (local x: fs.dir(INCLUDE_PATH + path).sorted()) {
		if (x in ["__ice__"])
			continue;
		x = fs.joinpath(path, x).replace("\\", "/");
		if (x in badFiles)
			continue;
		if (fs.stat.isdir(INCLUDE_PATH + x)) {
			if ((path + "/") in badFiles)
				continue;
			incdir(x);
			continue;
		}
		if (!x.endswith(".h"))
			continue;
		print("#include <", x, ">");
	}
}
incdir("");

]]]*/
#include <ConcurrencySal.h>
#include <__crt.h>
#include <__stdinc.h>
#include <_ansi.h>
#include <_lfs_64.h>
#include <aio.h>
#include <aliases.h>
#include <alloc.h>
#include <alloca.h>
#include <ansidecl.h>
#include <ar.h>
#include <argp.h>
#include <argz.h>
#include <arpa/ftp.h>
#include <arpa/inet.h>
#include <arpa/nameser.h>
#include <arpa/nameser_compat.h>
#include <arpa/telnet.h>
#include <arpa/tftp.h>
#include <asm/__stdinc.h>
#include <asm/asmword.h>
#include <asm/auxvec.h>
#include <asm/bitsperlong.h>
#include <asm/byteorder.h>
#include <asm/cacheline.h>
#include <asm/cfi.h>
#include <asm/crt/aio.h>
#include <asm/crt/confname.h>
#include <asm/crt/float.h>
#include <asm/crt/fmtmsg.h>
#include <asm/crt/fp_type.h>
#include <asm/crt/getpassfd.h>
#include <asm/crt/glob.h>
#include <asm/crt/humanize_number.h>
#include <asm/crt/langinfo.h>
#include <asm/crt/limits.h>
#include <asm/crt/locale.h>
#include <asm/crt/malloc.h>
#include <asm/crt/math-exception.h>
#include <asm/crt/math-libc_version.h>
#include <asm/crt/netdb.h>
#include <asm/crt/posix_spawn.h>
#include <asm/crt/process.h>
#include <asm/crt/pthreadvalues.h>
#include <asm/crt/readpassphrase.h>
#include <asm/crt/regex.h>
#include <asm/crt/resolv.h>
#include <asm/crt/semaphore.h>
#include <asm/crt/stdio.h>
#include <asm/crt/stdio_ext.h>
#include <asm/crt/stdlib.h>
#include <asm/crt/threads.h>
#include <asm/crt/time.h>
#include <asm/crt/ttyent.h>
#include <asm/crt/ucontext.h>
#include <asm/crt/util.h>
#include <asm/crt/vis.h>
#include <asm/defsym.h>
#include <asm/errno-base.h>
#include <asm/errno.h>
#include <asm/farptr.h>
#include <asm/fcntl.h>
#include <asm/gas.h>
#include <asm/intrin-arith.h>
#include <asm/intrin-fpu.h>
#include <asm/intrin.h>
#include <asm/ioctl.h>
#include <asm/ioctls.h>
#include <asm/isa.h>
#include <asm/ls-syscalls.h>
#include <asm/mman.h>
#include <asm/nomem-arch.h>
#include <asm/nomem.h>
#include <asm/os/block.h>
#include <asm/os/clock.h>
#include <asm/os/dirent.h>
#include <asm/os/epoll.h>
#include <asm/os/errno.h>
#include <asm/os/eventfd.h>
#include <asm/os/fcntl.h>
#include <asm/os/fd_set.h>
#include <asm/os/features.h>
#include <asm/os/file-ioctls.h>
#include <asm/os/ipc.h>
#include <asm/os/itimer.h>
#include <asm/os/limits.h>
#include <asm/os/mkdev.h>
#include <asm/os/mman.h>
#include <asm/os/mount.h>
#include <asm/os/msq.h>
#include <asm/os/net-if.h>
#include <asm/os/oflags.h>
#include <asm/os/paths.h>
#include <asm/os/poll.h>
#include <asm/os/ptrace.h>
#include <asm/os/random.h>
#include <asm/os/reboot.h>
#include <asm/os/resource.h>
#include <asm/os/sched.h>
#include <asm/os/sem.h>
#include <asm/os/shm.h>
#include <asm/os/sigevent.h>
#include <asm/os/siginfo.h>
#include <asm/os/signal.h>
#include <asm/os/signalfd.h>
#include <asm/os/sigset.h>
#include <asm/os/sigstack.h>
#include <asm/os/socket-ioctls.h>
#include <asm/os/socket.h>
#include <asm/os/stat.h>
#include <asm/os/statvfs.h>
#include <asm/os/stdio.h>
#include <asm/os/stdlib.h>
#include <asm/os/stropts.h>
#include <asm/os/swap.h>
#include <asm/os/syslog.h>
#include <asm/os/termios.h>
#include <asm/os/timerfd.h>
#include <asm/os/timex.h>
#include <asm/os/tty.h>
#include <asm/os/ulimit.h>
#include <asm/os/utsname.h>
#include <asm/os/vfork.h>
#include <asm/os/vlimit.h>
#include <asm/os/wait.h>
#include <asm/os/xattr.h>
#include <asm/page.h>
#include <asm/pageid.h>
#include <asm/pagesize.h>
#include <asm/param.h>
#include <asm/pkey.h>
#include <asm/poll.h>
#include <asm/posix_types.h>
#include <asm/prctl.h>
#include <asm/redirect.h>
#include <asm/resource.h>
#include <asm/setup.h>
#include <asm/siginfo.h>
#include <asm/signal.h>
#include <asm/signed-shift.h>
#include <asm/socket.h>
#include <asm/sockios.h>
#include <asm/stat.h>
#include <asm/statfs.h>
#include <asm/swab.h>
#include <asm/syscalls-proto.h>
#include <asm/syscalls-trace.h>
#include <asm/syscalls-types.h>
#include <asm/syscalls.h>
#include <asm/termbits.h>
#include <asm/termios.h>
#include <asm/types.h>
#include <asm/ucontext.h>
#include <asm/unistd.h>
#include <asm-generic/auxvec.h>
#include <asm-generic/bitsperlong.h>
#include <asm-generic/errno-base.h>
#include <asm-generic/errno.h>
#include <asm-generic/fcntl.h>
#include <asm-generic/int-l64.h>
#include <asm-generic/int-ll64.h>
#include <asm-generic/ioctls.h>
#include <asm-generic/mman-common.h>
#include <asm-generic/mman.h>
#include <asm-generic/param.h>
#include <asm-generic/poll.h>
#include <asm-generic/posix_types.h>
#include <asm-generic/resource.h>
#include <asm-generic/setup.h>
#include <asm-generic/siginfo.h>
#include <asm-generic/signal-defs.h>
#include <asm-generic/signal.h>
#include <asm-generic/socket.h>
#include <asm-generic/sockios.h>
#include <asm-generic/stat.h>
#include <asm-generic/statfs.h>
#include <asm-generic/swab.h>
#include <asm-generic/termbits.h>
#include <asm-generic/termios.h>
#include <asm-generic/types.h>
#include <asm-generic/ucontext.h>
#include <assert.h>
#include <atomic.h>
#include <attr/asm/attributes.h>
#include <attr/asm/libattr.h>
#include <attr/attributes.h>
#include <attr/bits/attributes.h>
#include <attr/error_context.h>
#include <attr/libattr.h>
#include <attr/xattr.h>
#include <bits/crt/_diskfree_t.h>
#include <bits/crt/addrinfo.h>
#include <bits/crt/aiocb.h>
#include <bits/crt/aioinit.h>
#include <bits/crt/argp.h>
#include <bits/crt/complex.h>
#include <bits/crt/crypt_data.h>
#include <bits/crt/ctype.h>
#include <bits/crt/db/aliases.h>
#include <bits/crt/db/fstab.h>
#include <bits/crt/db/group.h>
#include <bits/crt/db/hostent.h>
#include <bits/crt/db/mntent.h>
#include <bits/crt/db/netdb.h>
#include <bits/crt/db/passwd.h>
#include <bits/crt/db/protoent.h>
#include <bits/crt/db/rpcent.h>
#include <bits/crt/db/servent.h>
#include <bits/crt/db/spwd.h>
#include <bits/crt/db/ttyent.h>
#include <bits/crt/db/utmp.h>
#include <bits/crt/db/utmpx.h>
#include <bits/crt/div.h>
#include <bits/crt/dlfcn.h>
#include <bits/crt/dos/_CrtMemState.h>
#include <bits/crt/dos/corecrt_startup.h>
#include <bits/crt/dyn-string.h>
#include <bits/crt/environments.h>
#include <bits/crt/fenv-inline.h>
#include <bits/crt/fenv.h>
#include <bits/crt/format-printer.h>
#include <bits/crt/fts.h>
#include <bits/crt/ftw.h>
#include <bits/crt/gaicb.h>
#include <bits/crt/getopt.h>
#include <bits/crt/glob.h>
#include <bits/crt/if_nameindex.h>
#include <bits/crt/ifaddr.h>
#include <bits/crt/ifaddrs.h>
#include <bits/crt/inttypes.h>
#include <bits/crt/io-file.h>
#include <bits/crt/lconv.h>
#include <bits/crt/locale.h>
#include <bits/crt/mallinfo.h>
#include <bits/crt/mapfile.h>
#include <bits/crt/math-vector.h>
#include <bits/crt/mathdef.h>
#include <bits/crt/mbstate.h>
#include <bits/crt/ntptimeval.h>
#include <bits/crt/objalloc.h>
#include <bits/crt/obstack.h>
#include <bits/crt/partition.h>
#include <bits/crt/posix_spawn.h>
#include <bits/crt/printf_info.h>
#include <bits/crt/pthreadtypes.h>
#include <bits/crt/pthreadtypesizes.h>
#include <bits/crt/random-data.h>
#include <bits/crt/regex.h>
#include <bits/crt/resolv.h>
#include <bits/crt/semaphore.h>
#include <bits/crt/setjmp.h>
#include <bits/crt/stdio.h>
#include <bits/crt/sys_errlist.h>
#include <bits/crt/threads.h>
#include <bits/crt/tm.h>
#include <bits/crt/uformat-printer.h>
#include <bits/crt/unicode.h>
#include <bits/crt/vtimes.h>
#include <bits/crt/wctype.h>
#include <bits/crt/wformat-printer.h>
#include <bits/crt/wordexp.h>
#include <bits/elf-types.h>
#include <bits/elf.h>
#include <bits/math-constants.h>
#include <bits/os/acct.h>
#include <bits/os/cmsghdr.h>
#include <bits/os/cpu_set.h>
#include <bits/os/dirent.h>
#include <bits/os/epoll.h>
#include <bits/os/f_owner_ex.h>
#include <bits/os/fd_set.h>
#include <bits/os/file_handle.h>
#include <bits/os/flock.h>
#include <bits/os/ifconf.h>
#include <bits/os/ifmap.h>
#include <bits/os/ifreq.h>
#include <bits/os/iovec.h>
#include <bits/os/ipc.h>
#include <bits/os/itimerspec.h>
#include <bits/os/itimerval.h>
#include <bits/os/linger.h>
#include <bits/os/mcontext.h>
#include <bits/os/mmsghdr.h>
#include <bits/os/mqueue.h>
#include <bits/os/msgbuf.h>
#include <bits/os/msghdr.h>
#include <bits/os/msq.h>
#include <bits/os/pollfd.h>
#include <bits/os/ptrace.h>
#include <bits/os/rlimit.h>
#include <bits/os/rusage-convert.h>
#include <bits/os/rusage.h>
#include <bits/os/sched.h>
#include <bits/os/sem.h>
#include <bits/os/sembuf.h>
#include <bits/os/shm.h>
#include <bits/os/sigaction.h>
#include <bits/os/sigcontext.h>
#include <bits/os/sigevent.h>
#include <bits/os/siginfo.h>
#include <bits/os/signalfd_siginfo.h>
#include <bits/os/sigset.h>
#include <bits/os/sigset_with_size.h>
#include <bits/os/sigstack.h>
#include <bits/os/sigval.h>
#include <bits/os/sockaddr-common.h>
#include <bits/os/sockaddr.h>
#include <bits/os/sockaddr_storage.h>
#include <bits/os/stat.h>
#include <bits/os/statfs-convert.h>
#include <bits/os/statfs.h>
#include <bits/os/statvfs.h>
#include <bits/os/stropts.h>
#include <bits/os/sysinfo.h>
#include <bits/os/termio.h>
#include <bits/os/termios.h>
#include <bits/os/termiox.h>
#include <bits/os/timeb.h>
#include <bits/os/timespec.h>
#include <bits/os/timeval.h>
#include <bits/os/timex.h>
#include <bits/os/tms.h>
#include <bits/os/ucontext.h>
#include <bits/os/ucred.h>
#include <bits/os/ustat.h>
#include <bits/os/utimbuf.h>
#include <bits/os/utsname.h>
#include <bits/os/wait.h>
#include <bits/os_defines.h>
#include <bits/posix_lim1.h>
#include <bits/posix_lim2.h>
#include <bits/posix_opt.h>
#include <bits/pthreadtypes.h>
#include <bits/sigset.h>
#include <bits/sockaddr.h>
#include <bits/std_abs.h>
#include <bits/syscalls.h>
#include <bits/timex.h>
#include <bits/types/FILE.h>
#include <bits/types/__FILE.h>
#include <bits/types/__fpos64_t.h>
#include <bits/types/__fpos_t.h>
#include <bits/types/__locale_t.h>
#include <bits/types/__mbstate_t.h>
#include <bits/types/__sigset_t.h>
#include <bits/types/__sigval_t.h>
#include <bits/types/clock_t.h>
#include <bits/types/clockid_t.h>
#include <bits/types/cookie_io_functions_t.h>
#include <bits/types/error_t.h>
#include <bits/types/locale_t.h>
#include <bits/types/mbstate_t.h>
#include <bits/types/sig_atomic_t.h>
#include <bits/types/sigevent_t.h>
#include <bits/types/siginfo_t.h>
#include <bits/types/sigset_t.h>
#include <bits/types/sigval_t.h>
#include <bits/types/stack_t.h>
#include <bits/types/struct_FILE.h>
#include <bits/types/struct_iovec.h>
#include <bits/types/struct_itimerspec.h>
#include <bits/types/struct_osockaddr.h>
#include <bits/types/struct_rusage.h>
#include <bits/types/struct_sched_param.h>
#include <bits/types/struct_sigstack.h>
#include <bits/types/struct_timespec.h>
#include <bits/types/struct_timeval.h>
#include <bits/types/struct_tm.h>
#include <bits/types/time_t.h>
#include <bits/types/timer_t.h>
#include <bits/types/wint_t.h>
#include <bits/types.h>
#include <bits/typesizes.h>
#include <bits/wchar.h>
#include <bits/wordsize.h>
#include <bits/xopen_lim.h>
#include <bitstring.h>
#include <bsd/bitstring.h>
#include <bsd/bsd.h>
#include <bsd/err.h>
#include <bsd/errno.h>
#include <bsd/getopt.h>
#include <bsd/grp.h>
#include <bsd/inttypes.h>
#include <bsd/libutil.h>
#include <bsd/pwd.h>
#include <bsd/readpassphrase.h>
#include <bsd/sgtty.h>
#include <bsd/signal.h>
#include <bsd/stdio.h>
#include <bsd/stdlib.h>
#include <bsd/string.h>
#include <bsd/stringlist.h>
#include <bsd/sys/bitstring.h>
#include <bsd/sys/cdefs.h>
#include <bsd/sys/endian.h>
#include <bsd/sys/param.h>
#include <bsd/sys/poll.h>
#include <bsd/sys/queue.h>
#include <bsd/sys/time.h>
#include <bsd/sys/ttychars.h>
#include <bsd/tzfile.h>
#include <bsd/unistd.h>
#include <bsd/vis.h>
#include <bsd/wchar.h>
#include <bstring.h>
#include <bytesex.h>
#include <byteswap.h>
#include <cfi.h>
#include <compat/bits/os/cmsghdr.h>
#include <compat/bits/os/flock.h>
#include <compat/bits/os/iovec.h>
#include <compat/bits/os/itimerspec.h>
#include <compat/bits/os/itimerval.h>
#include <compat/bits/os/mcontext.h>
#include <compat/bits/os/mmsghdr.h>
#include <compat/bits/os/msghdr.h>
#include <compat/bits/os/rlimit.h>
#include <compat/bits/os/rusage-convert.h>
#include <compat/bits/os/rusage.h>
#include <compat/bits/os/sigaction.h>
#include <compat/bits/os/sigevent.h>
#include <compat/bits/os/siginfo-convert.h>
#include <compat/bits/os/siginfo.h>
#include <compat/bits/os/sigset.h>
#include <compat/bits/os/sigset_with_size.h>
#include <compat/bits/os/sigstack.h>
#include <compat/bits/os/sigval.h>
#include <compat/bits/os/statfs-convert.h>
#include <compat/bits/os/statfs.h>
#include <compat/bits/os/sysinfo.h>
#include <compat/bits/os/timeb.h>
#include <compat/bits/os/timespec.h>
#include <compat/bits/os/timeval.h>
#include <compat/bits/os/tms.h>
#include <compat/bits/os/ucontext.h>
#include <compat/bits/os/utimbuf.h>
#include <compat/bits/types.h>
#include <compat/bits/typesizes.h>
#include <compat/bits/va_list-struct.h>
#include <compat/config.h>
#include <compat/kos/asm/futex.h>
#include <compat/kos/bits/coredump.h>
#include <compat/kos/bits/except-handler.h>
#include <compat/kos/bits/futex-expr.h>
#include <compat/kos/bits/syscall-info.h>
#include <compat/kos/compat/linux-dirent.h>
#include <compat/kos/compat/linux-olddirent.h>
#include <compat/kos/compat/linux-oldselect.h>
#include <compat/kos/compat/linux-stat.h>
#include <compat/kos/except-handler.h>
#include <compat/kos/exec/asm/elf.h>
#include <compat/kos/exec/asm/rtld.h>
#include <compat/kos/exec/bits/elf.h>
#include <compat/kos/exec/bits/peb.h>
#include <compat/kos/exec/elf.h>
#include <compat/kos/exec/peb.h>
#include <compat/kos/exec/rtld.h>
#include <compat/kos/futex.h>
#include <compat/kos/types.h>
#include <compat/linux/msdos_fs.h>
#include <compat/pointer.h>
#include <compat/signal.h>
#include <compat/sys/ucontext.h>
#include <complex.h>
#include <confname.h>
#include <confstr.h>
#include <conio.h>
#include <corecrt.h>
#include <corecrt_io.h>
#include <corecrt_malloc.h>
#include <corecrt_math.h>
#include <corecrt_math_defines.h>
#include <corecrt_memcpy_s.h>
#include <corecrt_memory.h>
#include <corecrt_search.h>
#include <corecrt_startup.h>
#include <corecrt_stdio_config.h>
#include <corecrt_wconio.h>
#include <corecrt_wctype.h>
#include <corecrt_wdirect.h>
#include <corecrt_wio.h>
#include <corecrt_wprocess.h>
#include <corecrt_wstdio.h>
#include <corecrt_wstdlib.h>
#include <corecrt_wstring.h>
#include <corecrt_wtime.h>
#include <cpio.h>
#include <crtdbg.h>
#include <crtdefs.h>
#include <crypt.h>
#include <cthreads.h>
#include <ctype.h>
#include <daemon.h>
#include <dir.h>
#include <direct.h>
#include <dirent.h>
#include <dlfcn.h>
#include <dos.h>
#include <dyn-string.h>
#include <elf.h>
#include <elf_abi.h>
#include <endian.h>
#include <envz.h>
#include <err.h>
#include <errno.h>
#include <error.h>
#include <execinfo.h>
#include <fastmath.h>
#include <fcntl.h>
#include <features.h>
#include <fenv.h>
#include <file.h>
#include <float.h>
#include <fmtmsg.h>
#include <fnmatch.h>
#include <format-printer.h>
#include <fpu_control.h>
#include <fstab.h>
#include <fts.h>
#include <ftw.h>
#include <getopt.h>
#include <getpagesize.h>
#include <glob.h>
#include <gnu/lib-names.h>
#include <gnu/libc-version.h>
#include <gnu/stubs.h>
#include <gnu-versions.h>
#include <gppconio.h>
#include <grp.h>
#include <huge_val.h>
#include <hw/bus/pci.h>
#include <hw/bus/serial.h>
#include <hw/disk/ata.h>
#include <hw/disk/part/efi.h>
#include <hw/disk/part/embr.h>
#include <hw/disk/part/mbr.h>
#include <hw/disk/scsi.h>
#include <hw/hid/ps2.h>
#include <hw/hid/usb-hid.h>
#include <hw/hid/usbkbd.h>
#include <hw/ic/apic.h>
#include <hw/ic/pic.h>
#include <hw/net/ne2k.h>
#include <hw/rtc/cmos.h>
#include <hw/timer/pit.h>
#include <hw/usb/class.h>
#include <hw/usb/hub.h>
#include <hw/usb/ohci.h>
#include <hw/usb/uhci.h>
#include <hw/usb/usb.h>
#include <hw/video/bochsvbe.h>
#include <hw/video/vga.h>
#include <hw/video/vgamodes.h>
#include <hybrid/__alloca.h>
#include <hybrid/__altint.h>
#include <hybrid/__asm.h>
#include <hybrid/__assembly.h>
#include <hybrid/__assert.h>
#include <hybrid/__atomic-complete.h>
#include <hybrid/__atomic-gasm-x86.h>
#include <hybrid/__atomic.h>
#include <hybrid/__bit.h>
#include <hybrid/__bitfield.h>
#include <hybrid/__bitset.h>
#include <hybrid/__byteswap.h>
#include <hybrid/__debug-alignment.h>
#include <hybrid/__minmax.h>
#include <hybrid/__overflow.h>
#include <hybrid/__pointer.h>
#include <hybrid/__rotate.h>
#include <hybrid/__string.h>
#include <hybrid/__unaligned.h>
#include <hybrid/__va_size.h>
#include <hybrid/__wordbits.h>
#include <hybrid/align.h>
#include <hybrid/alloca.h>
#include <hybrid/altint.h>
#include <hybrid/atomic.h>
#include <hybrid/bit.h>
#include <hybrid/bitset.h>
#include <hybrid/byteorder.h>
#include <hybrid/byteswap.h>
#include <hybrid/compiler.h>
#include <hybrid/debug-alignment.h>
#include <hybrid/floatcore.h>
#include <hybrid/host.h>
#include <hybrid/int128.h>
#include <hybrid/limitcore.h>
#include <hybrid/minmax.h>
#include <hybrid/overflow.h>
#include <hybrid/pointer.h>
#include <hybrid/pp/__bubble.h>
#include <hybrid/pp/__va_nargs.h>
#include <hybrid/pp/bubble.h>
#include <hybrid/sched/__gettid.h>
#include <hybrid/sched/__preemption.h>
#include <hybrid/sched/__yield.h>
#include <hybrid/sched/atomic-lock.h>
#include <hybrid/sched/atomic-once.h>
#include <hybrid/sched/atomic-owner-rwlock.h>
#include <hybrid/sched/atomic-rwlock.h>
#include <hybrid/sched/preemption.h>
#include <hybrid/sched/yield.h>
#include <hybrid/sequence/bitset.h>
#include <hybrid/sequence/bsearch.h>
#include <hybrid/sequence/list.h>
#include <hybrid/sequence/rbtree.h>
#include <hybrid/sequence/vector.h>
#include <hybrid/spcall.h>
#include <hybrid/sync/atomic-lock.h>
#include <hybrid/sync/atomic-once.h>
#include <hybrid/sync/atomic-owner-rwlock.h>
#include <hybrid/sync/atomic-rwlock.h>
#include <hybrid/typecore.h>
#include <hybrid/unaligned.h>
#include <hybrid/wordbits.h>
#include <iconv.h>
#include <ieee754.h>
#include <ieee854.h>
#include <ieeefp.h>
#include <ifaddrs.h>
#include <int128.h>
#include <intrin.h>
#include <inttypes.h>
#include <io.h>
#include <iso646.h>
#include <jmp_buf.h>
#include <kos/anno.h>
#include <kos/aref.h>
#include <kos/asm/futex.h>
#include <kos/asm/lockop.h>
#include <kos/asm/rpc-method.h>
#include <kos/asm/rpc.h>
#include <kos/asm/rtm.h>
#include <kos/asm/syscall.h>
#include <kos/bits/coredump.h>
#include <kos/bits/debugtrap.h>
#include <kos/bits/except-compiler.h>
#include <kos/bits/except-handler.h>
#include <kos/bits/except-register-state-helpers.h>
#include <kos/bits/except-register-state.h>
#include <kos/bits/except.h>
#include <kos/bits/exception_data.h>
#include <kos/bits/exception_info.h>
#include <kos/bits/exception_nest.h>
#include <kos/bits/fastexcept.h>
#include <kos/bits/futex-expr.h>
#include <kos/bits/lockop.h>
#include <kos/bits/nopf.h>
#include <kos/bits/rpc.h>
#include <kos/bits/rtm.h>
#include <kos/bits/shared-lock.h>
#include <kos/bits/shared-recursive-lock.h>
#include <kos/bits/shared-recursive-rwlock.h>
#include <kos/bits/shared-rwlock.h>
#include <kos/bits/syscall-info.h>
#include <kos/bits/thread.h>
#include <kos/bits/ukern-struct.h>
#include <kos/bits/ukern.h>
#include <kos/bits/userprocmask.h>
#include <kos/bits/uuid.h>
#include <kos/capability.h>
#include <kos/compat/linux-dirent.h>
#include <kos/compat/linux-dirent64.h>
#include <kos/compat/linux-olddirent.h>
#include <kos/compat/linux-oldselect.h>
#include <kos/compat/linux-stat-convert.h>
#include <kos/compat/linux-stat.h>
#include <kos/config/config.h>
#include <kos/config/configurations/OD.h>
#include <kos/config/configurations/OnD.h>
#include <kos/config/configurations/nOD.h>
#include <kos/config/configurations/nOnD.h>
#include <kos/config/toolchain.h>
#include <kos/coredump.h>
#include <kos/debugtrap.h>
#include <kos/dosfs.h>
#include <kos/except/asm/codes.h>
#include <kos/except/codes.h>
#include <kos/except/reason/fs.h>
#include <kos/except/reason/illop.h>
#include <kos/except/reason/inval.h>
#include <kos/except/reason/io.h>
#include <kos/except/reason/net.h>
#include <kos/except/reason/noexec.h>
#include <kos/except-handler.h>
#include <kos/except.h>
#include <kos/exec/asm/elf-rel.h>
#include <kos/exec/asm/elf.h>
#include <kos/exec/asm/lazybind.h>
#include <kos/exec/asm/rtld.h>
#include <kos/exec/bits/elf.h>
#include <kos/exec/bits/peb.h>
#include <kos/exec/elf-rel.h>
#include <kos/exec/elf.h>
#include <kos/exec/idata.h>
#include <kos/exec/ifunc.h>
#include <kos/exec/lazybind.h>
#include <kos/exec/module.h>
#include <kos/exec/pe.h>
#include <kos/exec/peb.h>
#include <kos/exec/rtld.h>
#include <kos/fcntl.h>
#include <kos/futex.h>
#include <kos/futexexpr.h>
#include <kos/hybrid/heap.h>
#include <kos/hybrid/sched-signal.h>
#include <kos/io.h>
#include <kos/ioctl/_openfd.h>
#include <kos/ioctl/fd.h>
#include <kos/ioctl/file.h>
#include <kos/ioctl/kbd.h>
#include <kos/ioctl/leaks.h>
#include <kos/ioctl/mod.h>
#include <kos/ioctl/mouse.h>
#include <kos/ioctl/pidfd.h>
#include <kos/ioctl/pipe.h>
#include <kos/ioctl/svga.h>
#include <kos/ioctl/tty.h>
#include <kos/ioctl/video.h>
#include <kos/kernel/asm/paging.h>
#include <kos/kernel/bits/cpu-state-asm.h>
#include <kos/kernel/bits/cpu-state-compat.h>
#include <kos/kernel/bits/cpu-state-helpers.h>
#include <kos/kernel/bits/cpu-state-helperscc.h>
#include <kos/kernel/bits/cpu-state-verify.h>
#include <kos/kernel/bits/cpu-state.h>
#include <kos/kernel/bits/fpu-state-helpers.h>
#include <kos/kernel/bits/fpu-state-helperscc.h>
#include <kos/kernel/bits/fpu-state.h>
#include <kos/kernel/bits/gdb-cpu-state.h>
#include <kos/kernel/cpu-state-asm.h>
#include <kos/kernel/cpu-state-compat.h>
#include <kos/kernel/cpu-state-helpers.h>
#include <kos/kernel/cpu-state-helperscc.h>
#include <kos/kernel/cpu-state-verify.h>
#include <kos/kernel/cpu-state.h>
#include <kos/kernel/fpu-state-helpers.h>
#include <kos/kernel/fpu-state-helperscc.h>
#include <kos/kernel/fpu-state.h>
#include <kos/kernel/gdb-cpu-state.h>
#include <kos/kernel/handle.h>
#include <kos/kernel/memory.h>
#include <kos/kernel/paging.h>
#include <kos/kernel/printk.h>
#include <kos/kernel/syscalls.h>
#include <kos/kernel/types.h>
#include <kos/keyboard.h>
#include <kos/ksysctl.h>
#include <kos/lockop.h>
#include <kos/malloc.h>
#include <kos/malloca.h>
#include <kos/net/printf.h>
#include <kos/nopf.h>
#include <kos/parts/malloca.h>
#include <kos/personality.h>
#include <kos/refcnt-nonatomic.h>
#include <kos/refcnt.h>
#include <kos/refptr.h>
#include <kos/rpc.h>
#include <kos/rtm.h>
#include <kos/sched/shared-lock.h>
#include <kos/sched/shared-recursive-lock.h>
#include <kos/sched/shared-recursive-rwlock.h>
#include <kos/sched/shared-rwlock.h>
#include <kos/sys/epoll.h>
#include <kos/sys/ioctl.h>
#include <kos/sys/mman.h>
#include <kos/sys/socket.h>
#include <kos/sys/stat.h>
#include <kos/syscalls.h>
#include <kos/thread.h>
#include <kos/types.h>
#include <kos/ukern.h>
#include <kos/unistd.h>
#include <kos/uuid.h>
#include <langinfo.h>
#include <lastlog.h>
#include <libansitty/ansitty.h>
#include <libansitty/api.h>
#include <libansitty/ctl.h>
#include <libbios86/api.h>
#include <libbios86/bios.h>
#include <libbuffer/api.h>
#include <libbuffer/linebuffer.h>
#include <libbuffer/packetbuffer.h>
#include <libbuffer/ringbuffer.h>
#include <libc/core/ctype.h>
#include <libc/core/errno.h>
#include <libc/core/error.h>
#include <libc/core/fenv.h>
#include <libc/core/format-printer.h>
#include <libc/core/kos.malloc.h>
#include <libc/core/malloc.h>
#include <libc/core/parts.uchar.string.h>
#include <libc/core/signal.h>
#include <libc/core/ssp.string.h>
#include <libc/core/stdlib.h>
#include <libc/core/string.h>
#include <libc/core/strings.h>
#include <libc/core/sys.auxv.h>
#include <libc/core/sys.signal.h>
#include <libc/core/unicode.h>
#include <libc/core/unistd.h>
#include <libc/ctype.h>
#include <libc/errno.h>
#include <libc/error.h>
#include <libc/fenv.h>
#include <libc/format-printer.h>
#include <libc/kos.malloc.h>
#include <libc/malloc.h>
#include <libc/parts.uchar.string.h>
#include <libc/signal.h>
#include <libc/ssp.string.h>
#include <libc/stdlib.h>
#include <libc/string.h>
#include <libc/strings.h>
#include <libc/sys.auxv.h>
#include <libc/sys.signal.h>
#include <libc/unicode.h>
#include <libc/unistd.h>
#include <libcmdline/api.h>
#include <libcmdline/decode.h>
#include <libcmdline/encode.h>
#include <libcpustate/api.h>
#include <libcpustate/apply.h>
#include <libcpustate/asm/features.h>
#include <libcpustate/asm/register.h>
#include <libcpustate/register.h>
#include <libdebuginfo/addr2line.h>
#include <libdebuginfo/api.h>
#include <libdebuginfo/cfi_entry.h>
#include <libdebuginfo/debug_aranges.h>
#include <libdebuginfo/debug_frame.h>
#include <libdebuginfo/debug_info.h>
#include <libdebuginfo/debug_line.h>
#include <libdebuginfo/dwarf.h>
#include <libdebuginfo/errno.h>
#include <libdebuginfo/repr.h>
#include <libdebuginfo/symtab.h>
#include <libdebuginfo/unwind.h>
#include <libdemangle/api.h>
#include <libdemangle/demangle.h>
#include <libdemangle/gcc.h>
#include <libdisasm/api.h>
#include <libdisasm/disassembler.h>
#include <libdisasm/format.h>
#include <libdl/api.h>
#include <libdl/asm/dlfcn.h>
#include <libdl/bits/dlfcn.h>
#include <libdl/extension.h>
#include <libdl/tls.h>
#include <libemu86/api.h>
#include <libemu86/eflags.h>
#include <libemu86/emu/push-pop-util.h>
#include <libemu86/emu/string-util.h>
#include <libemu86/emu86.h>
#include <libemu86/helpers.h>
#include <libgen.h>
#include <libgen86/api.h>
#include <libgen86/gen.h>
#include <libgen86/register.h>
#include <libiberty/ansidecl.h>
#include <libiberty/dyn-string.h>
#include <libiberty/libiberty.h>
#include <libiberty/objalloc.h>
#include <libiberty/partition.h>
#include <libiberty/sort.h>
#include <libiberty/timeval-utils.h>
#include <libiberty.h>
#include <libiconv/api.h>
#include <libiconv/codec.h>
#include <libiconv/iconv.h>
#include <libiconv/stdiconv.h>
#include <libiconv/transliterate.h>
#include <libinstrlen/api.h>
#include <libinstrlen/bits/instrlen.h>
#include <libinstrlen/instrlen.h>
#include <libintl.h>
#include <libio.h>
#include <libjson/api.h>
#include <libjson/generator.h>
#include <libjson/parser.h>
#include <libjson/writer.h>
#include <libkeymap/api.h>
#include <libkeymap/keymap.h>
#include <libm/acos.h>
#include <libm/acosh.h>
#include <libm/api.h>
#include <libm/asin.h>
#include <libm/asinh.h>
#include <libm/asm/_builtin.h>
#include <libm/asm/atan.h>
#include <libm/asm/atan2.h>
#include <libm/asm/builtin.h>
#include <libm/asm/ceil.h>
#include <libm/asm/exp.h>
#include <libm/asm/expm1.h>
#include <libm/asm/fabs.h>
#include <libm/asm/fcomp.h>
#include <libm/asm/floor.h>
#include <libm/asm/inf.h>
#include <libm/asm/lrint.h>
#include <libm/asm/lround.h>
#include <libm/asm/nan.h>
#include <libm/asm/rint.h>
#include <libm/asm/round.h>
#include <libm/asm/significand.h>
#include <libm/asm/sqrt.h>
#include <libm/asm/trunc.h>
#include <libm/atan.h>
#include <libm/atan2.h>
#include <libm/atanh.h>
#include <libm/cbrt.h>
#include <libm/ceil.h>
#include <libm/copysign.h>
#include <libm/cos.h>
#include <libm/cosh.h>
#include <libm/erf.h>
#include <libm/erfc.h>
#include <libm/exp.h>
#include <libm/exp2.h>
#include <libm/expm1.h>
#include <libm/fabs.h>
#include <libm/fcomp.h>
#include <libm/fdlibm.h>
#include <libm/finite.h>
#include <libm/floor.h>
#include <libm/fmod.h>
#include <libm/fpclassify.h>
#include <libm/frexp.h>
#include <libm/hypot.h>
#include <libm/ilogb.h>
#include <libm/inf.h>
#include <libm/iscanonical.h>
#include <libm/isinf.h>
#include <libm/isnan.h>
#include <libm/issignaling.h>
#include <libm/j0.h>
#include <libm/j1.h>
#include <libm/jn.h>
#include <libm/kernel_cos.h>
#include <libm/kernel_rem_pio2.h>
#include <libm/kernel_sin.h>
#include <libm/kernel_tan.h>
#include <libm/ldexp.h>
#include <libm/lgamma.h>
#include <libm/log.h>
#include <libm/log10.h>
#include <libm/log1p.h>
#include <libm/log2.h>
#include <libm/logb.h>
#include <libm/lrint.h>
#include <libm/lround.h>
#include <libm/matherr.h>
#include <libm/modf.h>
#include <libm/nan.h>
#include <libm/nextafter.h>
#include <libm/nexttoward.h>
#include <libm/nextup.h>
#include <libm/pone.h>
#include <libm/pow.h>
#include <libm/pzero.h>
#include <libm/rem_pio2.h>
#include <libm/remainder.h>
#include <libm/remquo.h>
#include <libm/rint.h>
#include <libm/round.h>
#include <libm/roundeven.h>
#include <libm/scalb.h>
#include <libm/scalbn.h>
#include <libm/signbit.h>
#include <libm/significand.h>
#include <libm/sin.h>
#include <libm/sincos.h>
#include <libm/sincos_table.h>
#include <libm/sinh.h>
#include <libm/sqrt.h>
#include <libm/tan.h>
#include <libm/tanh.h>
#include <libm/tgamma.h>
#include <libm/trunc.h>
#include <libm/y0.h>
#include <libm/y1.h>
#include <libm/yn.h>
#include <libpciaccess/api.h>
#include <libpciaccess/config.h>
#include <libpciaccess/paths.h>
#include <libpciaccess/pciaccess.h>
#include <libphys/api.h>
#include <libphys/phys.h>
#include <libregdump/api.h>
#include <libregdump/printer.h>
#include <libregdump/register.h>
#include <libregex/api.h>
#include <libregex/regcomp.h>
#include <libregex/regexec.h>
#include <libsctrace/api.h>
#include <libsctrace/repr-types.h>
#include <libsctrace/sctrace.h>
#include <libservice/api.h>
#include <libservice/client.h>
#include <libservice/server.h>
#include <libservice/types.h>
#include <libsvgadrv/api.h>
#include <libsvgadrv/chipset.h>
#include <libsvgadrv/chipsets/bochsvbe.h>
#include <libsvgadrv/chipsets/vesa.h>
#include <libsvgadrv/chipsets/vga.h>
#include <libsvgadrv/util/vgaio.h>
#include <libterm/api.h>
#include <libterm/termio.h>
#include <libunwind/api.h>
#include <libunwind/asm/features.h>
#include <libunwind/asm/isa.h>
#include <libunwind/cfi/arm.h>
#include <libunwind/cfi/i386.h>
#include <libunwind/cfi/x86_64.h>
#include <libunwind/cfi.h>
#include <libunwind/dwarf.h>
#include <libunwind/eh_frame.h>
#include <libunwind/errno.h>
#include <libunwind/except.h>
#include <libunwind/register.h>
#include <libunwind/unwind.h>
#include <libutil.h>
#include <libvideo/codec/api.h>
#include <libvideo/codec/codecs.h>
#include <libvideo/codec/format.h>
#include <libvideo/codec/palette.h>
#include <libvideo/codec/pixel.h>
#include <libvideo/gfx/api.h>
#include <libvideo/gfx/buffer.h>
#include <libvideo/gfx/font.h>
#include <libvideo/gfx/fonts/tlft.h>
#include <libvideo/gfx/gfx.h>
#include <libvideo/window/api.h>
#include <libvideo/window/window.h>
#include <libvio/access.h>
#include <libvio/api.h>
#include <libvio/userviofd.h>
#include <libvio/vio.h>
#include <libviocore/api.h>
#include <libviocore/bits/viocore.h>
#include <libviocore/viocore.h>
#include <libvm86/api.h>
#include <libvm86/emulator.h>
#include <libzlib/api.h>
#include <libzlib/error.h>
#include <libzlib/inflate.h>
#include <limits.h>
#include <link.h>
#include <linux/agpgart.h>
#include <linux/bits/posix_types.h>
#include <linux/byteorder/_common.h>
#include <linux/byteorder/big_endian.h>
#include <linux/byteorder/little_endian.h>
#include <linux/capability.h>
#include <linux/close_range.h>
#include <linux/fcntl.h>
#include <linux/fd.h>
#include <linux/fs.h>
#include <linux/futex.h>
#include <linux/hdreg.h>
#include <linux/if_arp.h>
#include <linux/if_ether.h>
#include <linux/if_fddi.h>
#include <linux/inotify.h>
#include <linux/ioctl.h>
#include <linux/kcmp.h>
#include <linux/kd.h>
#include <linux/kernel.h>
#include <linux/limits.h>
#include <linux/magic.h>
#include <linux/msdos_fs.h>
#include <linux/net.h>
#include <linux/param.h>
#include <linux/pci.h>
#include <linux/posix_types.h>
#include <linux/prctl.h>
#include <linux/socket.h>
#include <linux/sockios.h>
#include <linux/stddef.h>
#include <linux/swab.h>
#include <linux/sysinfo.h>
#include <linux/termios.h>
#include <linux/timerfd.h>
#include <linux/types.h>
#include <linux/unistd.h>
#include <linux/vt.h>
#include <linux/xattr.h>
#include <locale.h>
#include <lock-intern.h>
#include <machine/_default_types.h>
#include <machine/_endian.h>
#include <machine/_time.h>
#include <machine/_types.h>
#include <machine/ansi.h>
#include <machine/endian.h>
#include <machine/ieeefp.h>
#include <machine/malloc.h>
#include <machine/param.h>
#include <machine/setjmp-dj.h>
#include <machine/setjmp.h>
#include <machine/stdlib.h>
#include <machine/termios.h>
#include <machine/time.h>
#include <machine/types.h>
#include <machine-sp.h>
#include <malloc.h>
#include <malloc_np.h>
#include <malloca.h>
#include <math.h>
#include <mbctype.h>
#include <mbstring.h>
#include <mem.h>
#include <memory.h>
#include <minmax.h>
#include <mntent.h>
#include <monetary.h>
#include <mqueue.h>
#include <nan.h>
#include <ndir.h>
#include <net/bits/types.h>
#include <net/ethernet.h>
#include <net/if.h>
#include <net/if_arp.h>
#include <net/if_packet.h>
#include <netdb.h>
#include <netinet/bits/in.h>
#include <netinet/ether.h>
#include <netinet/icmp6.h>
#include <netinet/if_ether.h>
#include <netinet/if_fddi.h>
#include <netinet/if_tr.h>
#include <netinet/igmp.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/ip6.h>
#include <netinet/ip_icmp.h>
#include <netinet/ipport.h>
#include <netinet/ipproto.h>
#include <netinet/tcp.h>
#include <netinet/udp.h>
#include <netpacket/packet.h>
#include <new.h>
#include <newlib.h>
#include <nl_types.h>
#include <nt/__stdinc.h>
#include <nt/debugapi.h>
#include <nt/errhandlingapi.h>
#include <nt/fileapi.h>
#include <nt/guid.h>
#include <nt/handleapi.h>
#include <nt/heapapi.h>
#include <nt/interlockedapi.h>
#include <nt/libloaderapi.h>
#include <nt/memoryapi.h>
#include <nt/messages.h>
#include <nt/namedpipeapi.h>
#include <nt/pe.h>
#include <nt/processenv.h>
#include <nt/processthreadsapi.h>
#include <nt/profileapi.h>
#include <nt/startup.h>
#include <nt/stringapiset.h>
#include <nt/synchapi.h>
#include <nt/sysinfoapi.h>
#include <nt/tib.h>
#include <nt/timezoneapi.h>
#include <nt/types.h>
#include <nt/wincon.h>
#include <nt/winnls.h>
#include <objalloc.h>
#include <obstack.h>
#include <optimized/error.h>
#include <optimized/fenv.h>
#include <optimized/ssp.string.h>
#include <optimized/string.h>
#include <optimized/unistd.h>
#include <osfcn.h>
#include <partition.h>
#include <parts/assert-failed.h>
#include <parts/assert.h>
#include <parts/malloca.h>
#include <parts/printf-config.h>
#include <parts/redirect-exec.h>
#include <parts/timespec-cxx-support.h>
#include <parts/timeval-cxx-support.h>
#include <parts/uchar/direct.h>
#include <parts/uchar/fcntl.h>
#include <parts/uchar/format-printer.h>
#include <parts/uchar/inttypes.h>
#include <parts/uchar/io.h>
#include <parts/uchar/process.h>
#include <parts/uchar/stdio.h>
#include <parts/uchar/stdlib.h>
#include <parts/uchar/string.h>
#include <parts/uchar/sys/mman.h>
#include <parts/uchar/sys/stat.h>
#include <parts/uchar/time.h>
#include <parts/uchar/unistd.h>
#include <parts/uchar/utime.h>
#include <parts/uchar/wchar.h>
#include <parts/uchar/wctype.h>
#include <parts/waitmacros.h>
#include <parts/wchar/fcntl.h>
#include <parts/wchar/format-printer.h>
#include <parts/wchar/process.h>
#include <parts/wchar/stdio.h>
#include <parts/wchar/stdlib.h>
#include <parts/wchar/sys/stat.h>
#include <parts/wchar/unistd.h>
#include <parts/wchar/utime.h>
#include <paths.h>
#include <pciaccess.h>
#include <poll.h>
#include <printf.h>
#include <process.h>
#include <pthread.h>
#include <pthread_np.h>
#include <pty.h>
#include <pwd.h>
#include <random.h>
#include <re_comp.h>
#include <readpassphrase.h>
#include <regex.h>
#include <regexp.h>
#include <resolv.h>
#include <rpc/netdb.h>
#include <sal.h>
#include <sched.h>
#include <search.h>
#include <semaphore.h>
#include <setjmp.h>
#include <sgtty.h>
#include <shadow.h>
#include <share.h>
#include <siginfo.h>
#include <signal.h>
#include <sort.h>
#include <spawn.h>
#include <spin-lock.h>
#include <ssp/chk.h>
#include <ssp/ssp.h>
#include <ssp/string.h>
#include <stack_unwind.h>
#include <std.h>
#include <stdalign.h>
#include <stdarg.h>
#include <stdatomic.h>
#include <stdbool.h>
#include <stdc-predef.h>
#include <stddef.h>
#include <stdint.h>
#include <stdio.h>
#include <stdio_ext.h>
#include <stdlib.h>
#include <stdnoreturn.h>
#include <string.h>
#include <stringlist.h>
#include <strings.h>
#include <stropts.h>
#include <struct.h>
#include <symcat.h>
#include <sys/_default_fcntl.h>
#include <sys/_intsup.h>
#include <sys/_iovec.h>
#include <sys/_null.h>
#include <sys/_pthreadtypes.h>
#include <sys/_sigset.h>
#include <sys/_sockaddr_storage.h>
#include <sys/_stdarg.h>
#include <sys/_stdint.h>
#include <sys/_timespec.h>
#include <sys/_timeval.h>
#include <sys/_types.h>
#include <sys/acct.h>
#include <sys/aiocb.h>
#include <sys/ansi.h>
#include <sys/atomic.h>
#include <sys/auxv.h>
#include <sys/bitstring.h>
#include <sys/bitypes.h>
#include <sys/bsdtypes.h>
#include <sys/bswap.h>
#include <sys/byteorder.h>
#include <sys/capability.h>
#include <sys/cdefs.h>
#include <sys/common_ansi.h>
#include <sys/common_int_const.h>
#include <sys/common_int_fmtio.h>
#include <sys/common_int_limits.h>
#include <sys/common_int_mwgwtypes.h>
#include <sys/common_int_types.h>
#include <sys/common_limits.h>
#include <sys/common_wchar_limits.h>
#include <sys/config.h>
#include <sys/dir.h>
#include <sys/dirent.h>
#include <sys/elf.h>
#include <sys/elf_386.h>
#include <sys/elf_SPARC.h>
#include <sys/elf_amd64.h>
#include <sys/elf_notes.h>
#include <sys/elftypes.h>
#include <sys/endian.h>
#include <sys/epoll.h>
#include <sys/errno.h>
#include <sys/eventfd.h>
#include <sys/exec_elf.h>
#include <sys/fcntl.h>
#include <sys/fcntlcom.h>
#include <sys/feature_tests.h>
#include <sys/features.h>
#include <sys/featuretest.h>
#include <sys/file.h>
#include <sys/filio.h>
#include <sys/fsuid.h>
#include <sys/inotify.h>
#include <sys/int_const.h>
#include <sys/int_fmtio.h>
#include <sys/int_limits.h>
#include <sys/int_types.h>
#include <sys/inttypes.h>
#include <sys/io.h>
#include <sys/ioccom.h>
#include <sys/ioctl.h>
#include <sys/ipc.h>
#include <sys/isa_defs.h>
#include <sys/kd.h>
#include <sys/klog.h>
#include <sys/link.h>
#include <sys/loadavg.h>
#include <sys/mkdev.h>
#include <sys/mman.h>
#include <sys/mmio.h>
#include <sys/mount.h>
#include <sys/msg.h>
#include <sys/ndir.h>
#include <sys/null.h>
#include <sys/param.h>
#include <sys/pci.h>
#include <sys/perm.h>
#include <sys/poll.h>
#include <sys/prctl.h>
#include <sys/procfs.h>
#include <sys/profil.h>
#include <sys/ptrace.h>
#include <sys/queue.h>
#include <sys/random.h>
#include <sys/reboot.h>
#include <sys/resource.h>
#include <sys/sched.h>
#include <sys/select.h>
#include <sys/sem.h>
#include <sys/sendfile.h>
#include <sys/setjmp.h>
#include <sys/shm.h>
#include <sys/signal.h>
#include <sys/signalfd.h>
#include <sys/single_threaded.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <sys/sockio.h>
#include <sys/stat.h>
#include <sys/statfs.h>
#include <sys/statvfs.h>
#include <sys/stdarg.h>
#include <sys/stdbool.h>
#include <sys/stdint.h>
#include <sys/stdtypes.h>
#include <sys/stropts.h>
#include <sys/swap.h>
#include <sys/syscall-proto.h>
#include <sys/syscall.h>
#include <sys/sysinfo.h>
#include <sys/syslimits.h>
#include <sys/syslog.h>
#include <sys/sysmacros.h>
#include <sys/systeminfo.h>
#include <sys/termio.h>
#include <sys/termios.h>
#include <sys/termiox.h>
#include <sys/time.h>
#include <sys/timeb.h>
#include <sys/timerfd.h>
#include <sys/times.h>
#include <sys/timespec.h>
#include <sys/timex.h>
#include <sys/ttychars.h>
#include <sys/ttycom.h>
#include <sys/ttydefaults.h>
#include <sys/ttydev.h>
#include <sys/types.h>
#include <sys/ucontext.h>
#include <sys/uio.h>
#include <sys/un.h>
#include <sys/unistd.h>
#include <sys/user.h>
#include <sys/ustat.h>
#include <sys/utime.h>
#include <sys/utsname.h>
#include <sys/vfs.h>
#include <sys/vlimit.h>
#include <sys/vt.h>
#include <sys/vtimes.h>
#include <sys/wait.h>
#include <sys/xattr.h>
#include <syscall.h>
#include <sysexits.h>
#include <syslimits.h>
#include <syslog.h>
#include <system-test/api.h>
#include <tar.h>
#include <tchar.h>
#include <termio.h>
#include <termios.h>
#include <tgmath.h>
#include <thread.h>
#include <threads.h>
#include <time.h>
#include <timeval-utils.h>
#include <ttyent.h>
#include <uchar.h>
#include <ucontext.h>
#include <ulimit.h>
#include <unicode.h>
#include <unistd.h>
#include <unwind.h>
#include <ustat.h>
#include <util.h>
#include <utime.h>
#include <utmp.h>
#include <utmpx.h>
#include <vadefs.h>
#include <values.h>
#include <vcruntime.h>
#include <vcruntime_startup.h>
#include <vcruntime_string.h>
#include <vfork.h>
#include <vis.h>
#include <wait.h>
#include <waitflags.h>
#include <waitstatus.h>
#include <wchar.h>
#include <wctype.h>
#include <wordexp.h>
#include <xlocale.h>
//[[[end]]]


#ifdef __cplusplus
/* libstdc++ doesn't work in freestanding mode. */
#ifndef __CRT_FREESTANDING
/* libstdc++ headers don't work without GNU extensions... */
#ifdef _GNU_SOURCE
/* libstdc++ doesn't work in kernel-space:
 *  - missing functions that libstdc++ assumes to be there (locale, etc...)
 *  - The fact that most libc functions are defined as STDCALL,
 *    which   breaks  assigning  them  to  prototype  pointers. */
#ifndef __KERNEL__
#undef min
#undef max
#if 0 /* FIXME: Currently broken because libstdc++ tries to re-define memory_order */
#include <__stdcxx.h>
#include <atomic>
#include <cassert>
#include <cctype>
#include <cerrno>
#include <cfenv>
#include <cfloat>
#include <cinttypes>
#include <ciso646>
#include <climits>
#include <clocale>
#include <cmath>
#include <csetjmp>
#include <csignal>
#include <cstdalign>
#include <cstdarg>
#include <cstdbool>
#include <cstddef>
#include <cstdint>
#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <ctime>
#include <cuchar>
#include <cwchar>
#include <cwctype>
#include <exception>
#include <initializer_list>
#include <iterator>
#include <memory>
#include <mutex>
#include <new>
#include <type_traits>
#include <typeinfo>
#include <utility>
#endif
#endif /* !__KERNEL__ */
#endif /* _GNU_SOURCE */
#endif /* !__CRT_FREESTANDING */
#endif /* __cplusplus */
