/* HASH CRC-32:0x99c31526 */
/* Copyright (c) 2019-2024 Griefer@Work                                       *
 *                                                                            *
 * This software is provided 'as-is', without any express or implied          *
 * warranty. In no event will the authors be held liable for any damages      *
 * arising from the use of this software.                                     *
 *                                                                            *
 * Permission is granted to anyone to use this software for any purpose,      *
 * including commercial applications, and to alter it and redistribute it     *
 * freely, subject to the following restrictions:                             *
 *                                                                            *
 * 1. The origin of this software must not be misrepresented; you must not    *
 *    claim that you wrote the original software. If you use this software    *
 *    in a product, an acknowledgement (see the following) in the product     *
 *    documentation is required:                                              *
 *    Portions Copyright (c) 2019-2024 Griefer@Work                           *
 * 2. Altered source versions must be plainly marked as such, and must not be *
 *    misrepresented as being the original software.                          *
 * 3. This notice may not be removed or altered from any source distribution. *
 */
/* (>) Standard: ISO C89 (ANSI X3.159-1989) */
/* (>) Standard: POSIX.1 (Issue 1, IEEE Std 1003.1-1988) */
/* (#) Portability: Cygwin        (/newlib/libc/include/math.h) */
/* (#) Portability: DJGPP         (/include/math.h) */
/* (#) Portability: EMX kLIBC     (/libc/include/math.h) */
/* (#) Portability: GNU C Library (/math/math.h) */
/* (#) Portability: GNU Hurd      (/usr/include/math.h) */
/* (#) Portability: MSVC          (/include/math.h) */
/* (#) Portability: MinGW         (/mingw-w64-headers/crt/math.h) */
/* (#) Portability: NetBSD        (/include/math.h) */
/* (#) Portability: Newlib        (/newlib/libc/include/math.h) */
/* (#) Portability: OpenBSD       (/include/math.h) */
/* (#) Portability: OpenSolaris   (/usr/src/lib/libbc/inc/include/math.h) */
/* (#) Portability: Windows Kits  (/ucrt/math.h) */
/* (#) Portability: avr-libc      (/include/math.h) */
/* (#) Portability: diet libc     (/include/math.h) */
/* (#) Portability: libc4/5       (/include/math.h) */
/* (#) Portability: libc6         (/include/math.h) */
/* (#) Portability: musl libc     (/include/math.h) */
/* (#) Portability: uClibc        (/include/math.h) */
#ifndef _MATH_H
#define _MATH_H 1

#ifdef _CXX_STDONLY_CMATH
#ifdef __CXX_SYSTEM_HEADER
#undef _MATH_H /* Allow the C-header to be re-included to import all std::-symbols into the global namespace. */
#else /* __CXX_SYSTEM_HEADER */
/* Import all symbols into the global namespace when re-including "math.h" after "cmath" */
#ifndef __NO_FPU
#include <ieee754.h>
#if defined(__CRT_HAVE_acos) || defined(__CRT_HAVE___acos) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(acos)
#endif /* __CRT_HAVE_acos || __CRT_HAVE___acos || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_asin) || defined(__CRT_HAVE___asin) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(asin)
#endif /* __CRT_HAVE_asin || __CRT_HAVE___asin || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_atan) || defined(__CRT_HAVE___atan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(atan)
#endif /* __CRT_HAVE_atan || __CRT_HAVE___atan || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_atan2) || defined(__CRT_HAVE___atan2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(atan2)
#endif /* __CRT_HAVE_atan2 || __CRT_HAVE___atan2 || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_cos) || defined(__CRT_HAVE___cos) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(cos)
#endif /* __CRT_HAVE_cos || __CRT_HAVE___cos || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_sin) || defined(__CRT_HAVE___sin) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(sin)
#endif /* __CRT_HAVE_sin || __CRT_HAVE___sin || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_tan) || defined(__CRT_HAVE___tan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(tan)
#endif /* __CRT_HAVE_tan || __CRT_HAVE___tan || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_acosf) || defined(__CRT_HAVE___acosf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_acos) || defined(__CRT_HAVE___acos) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(acosf)
#endif /* __CRT_HAVE_acosf || __CRT_HAVE___acosf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_acos || __CRT_HAVE___acos || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_asinf) || defined(__CRT_HAVE___asinf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_asin) || defined(__CRT_HAVE___asin) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(asinf)
#endif /* __CRT_HAVE_asinf || __CRT_HAVE___asinf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_asin || __CRT_HAVE___asin || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_atanf) || defined(__CRT_HAVE___atanf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_atan) || defined(__CRT_HAVE___atan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(atanf)
#endif /* __CRT_HAVE_atanf || __CRT_HAVE___atanf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_atan || __CRT_HAVE___atan || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_atan2f) || defined(__CRT_HAVE___atan2f) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_atan2) || defined(__CRT_HAVE___atan2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(atan2f)
#endif /* __CRT_HAVE_atan2f || __CRT_HAVE___atan2f || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_atan2 || __CRT_HAVE___atan2 || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_cosf) || defined(__CRT_HAVE___cosf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_cos) || defined(__CRT_HAVE___cos) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(cosf)
#endif /* __CRT_HAVE_cosf || __CRT_HAVE___cosf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_cos || __CRT_HAVE___cos || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_sinf) || defined(__CRT_HAVE___sinf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_sin) || defined(__CRT_HAVE___sin) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(sinf)
#endif /* __CRT_HAVE_sinf || __CRT_HAVE___sinf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_sin || __CRT_HAVE___sin || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_tanf) || defined(__CRT_HAVE___tanf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_tan) || defined(__CRT_HAVE___tan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(tanf)
#endif /* __CRT_HAVE_tanf || __CRT_HAVE___tanf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_tan || __CRT_HAVE___tan || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#include <hybrid/typecore.h>
#if defined(__CRT_HAVE_acosl) || defined(__CRT_HAVE___acosl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_acos) || defined(__CRT_HAVE___acos) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(acosl)
#endif /* __CRT_HAVE_acosl || __CRT_HAVE___acosl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_acos || __CRT_HAVE___acos || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_asinl) || defined(__CRT_HAVE___asinl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_asin) || defined(__CRT_HAVE___asin) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(asinl)
#endif /* __CRT_HAVE_asinl || __CRT_HAVE___asinl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_asin || __CRT_HAVE___asin || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_atanl) || defined(__CRT_HAVE___atanl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_atan) || defined(__CRT_HAVE___atan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(atanl)
#endif /* __CRT_HAVE_atanl || __CRT_HAVE___atanl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_atan || __CRT_HAVE___atan || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_atan2l) || defined(__CRT_HAVE___atan2l) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_atan2) || defined(__CRT_HAVE___atan2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(atan2l)
#endif /* __CRT_HAVE_atan2l || __CRT_HAVE___atan2l || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_atan2 || __CRT_HAVE___atan2 || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_cosl) || defined(__CRT_HAVE___cosl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_cos) || defined(__CRT_HAVE___cos) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(cosl)
#endif /* __CRT_HAVE_cosl || __CRT_HAVE___cosl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_cos || __CRT_HAVE___cos || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_sinl) || defined(__CRT_HAVE___sinl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_sin) || defined(__CRT_HAVE___sin) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(sinl)
#endif /* __CRT_HAVE_sinl || __CRT_HAVE___sinl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_sin || __CRT_HAVE___sin || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_tanl) || defined(__CRT_HAVE___tanl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_tan) || defined(__CRT_HAVE___tan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(tanl)
#endif /* __CRT_HAVE_tanl || __CRT_HAVE___tanl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_tan || __CRT_HAVE___tan || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#if defined(__CRT_HAVE_cosh) || defined(__CRT_HAVE___cosh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(cosh)
#endif /* __CRT_HAVE_cosh || __CRT_HAVE___cosh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_sinh) || defined(__CRT_HAVE___sinh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(sinh)
#endif /* __CRT_HAVE_sinh || __CRT_HAVE___sinh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_tanh) || defined(__CRT_HAVE___tanh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(tanh)
#endif /* __CRT_HAVE_tanh || __CRT_HAVE___tanh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_coshf) || defined(__CRT_HAVE___coshf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_cosh) || defined(__CRT_HAVE___cosh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(coshf)
#endif /* __CRT_HAVE_coshf || __CRT_HAVE___coshf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_cosh || __CRT_HAVE___cosh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_sinhf) || defined(__CRT_HAVE___sinhf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_sinh) || defined(__CRT_HAVE___sinh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(sinhf)
#endif /* __CRT_HAVE_sinhf || __CRT_HAVE___sinhf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_sinh || __CRT_HAVE___sinh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_tanhf) || defined(__CRT_HAVE___tanhf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_tanh) || defined(__CRT_HAVE___tanh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(tanhf)
#endif /* __CRT_HAVE_tanhf || __CRT_HAVE___tanhf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_tanh || __CRT_HAVE___tanh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if defined(__CRT_HAVE_coshl) || defined(__CRT_HAVE___coshl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_cosh) || defined(__CRT_HAVE___cosh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(coshl)
#endif /* __CRT_HAVE_coshl || __CRT_HAVE___coshl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_cosh || __CRT_HAVE___cosh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_sinhl) || defined(__CRT_HAVE___sinhl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_sinh) || defined(__CRT_HAVE___sinh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(sinhl)
#endif /* __CRT_HAVE_sinhl || __CRT_HAVE___sinhl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_sinh || __CRT_HAVE___sinh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_tanhl) || defined(__CRT_HAVE___tanhl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_tanh) || defined(__CRT_HAVE___tanh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(tanhl)
#endif /* __CRT_HAVE_tanhl || __CRT_HAVE___tanhl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_tanh || __CRT_HAVE___tanh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#if defined(__USE_XOPEN_EXTENDED) || defined(__USE_ISOC99)
#if defined(__CRT_HAVE_acosh) || defined(__CRT_HAVE___acosh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(acosh)
#endif /* __CRT_HAVE_acosh || __CRT_HAVE___acosh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_asinh) || defined(__CRT_HAVE___asinh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(asinh)
#endif /* __CRT_HAVE_asinh || __CRT_HAVE___asinh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_atanh) || defined(__CRT_HAVE___atanh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(atanh)
#endif /* __CRT_HAVE_atanh || __CRT_HAVE___atanh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_acoshf) || defined(__CRT_HAVE___acoshf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_acosh) || defined(__CRT_HAVE___acosh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(acoshf)
#endif /* __CRT_HAVE_acoshf || __CRT_HAVE___acoshf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_acosh || __CRT_HAVE___acosh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_asinhf) || defined(__CRT_HAVE___asinhf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_asinh) || defined(__CRT_HAVE___asinh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(asinhf)
#endif /* __CRT_HAVE_asinhf || __CRT_HAVE___asinhf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_asinh || __CRT_HAVE___asinh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_atanhf) || defined(__CRT_HAVE___atanhf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_atanh) || defined(__CRT_HAVE___atanh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(atanhf)
#endif /* __CRT_HAVE_atanhf || __CRT_HAVE___atanhf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_atanh || __CRT_HAVE___atanh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if defined(__CRT_HAVE_acoshl) || defined(__CRT_HAVE___acoshl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_acosh) || defined(__CRT_HAVE___acosh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(acoshl)
#endif /* __CRT_HAVE_acoshl || __CRT_HAVE___acoshl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_acosh || __CRT_HAVE___acosh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_asinhl) || defined(__CRT_HAVE___asinhl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_asinh) || defined(__CRT_HAVE___asinh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(asinhl)
#endif /* __CRT_HAVE_asinhl || __CRT_HAVE___asinhl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_asinh || __CRT_HAVE___asinh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_atanhl) || defined(__CRT_HAVE___atanhl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_atanh) || defined(__CRT_HAVE___atanh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(atanhl)
#endif /* __CRT_HAVE_atanhl || __CRT_HAVE___atanhl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_atanh || __CRT_HAVE___atanh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_XOPEN_EXTENDED || __USE_ISOC99 */
#if defined(__CRT_HAVE_exp) || defined(__CRT_HAVE___exp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(exp)
#endif /* __CRT_HAVE_exp || __CRT_HAVE___exp || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_frexp) || defined(__CRT_HAVE___frexp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(frexp)
#endif /* __CRT_HAVE_frexp || __CRT_HAVE___frexp || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_ldexp) || defined(__CRT_HAVE___ldexp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(ldexp)
#endif /* __CRT_HAVE_ldexp || __CRT_HAVE___ldexp || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_log) || defined(__CRT_HAVE___log) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(log)
#endif /* __CRT_HAVE_log || __CRT_HAVE___log || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_log10) || defined(__CRT_HAVE___log10) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(log10)
#endif /* __CRT_HAVE_log10 || __CRT_HAVE___log10 || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_modf) || defined(__CRT_HAVE___modf) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(modf)
#endif /* __CRT_HAVE_modf || __CRT_HAVE___modf || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_expf) || defined(__CRT_HAVE___expf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_exp) || defined(__CRT_HAVE___exp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(expf)
#endif /* __CRT_HAVE_expf || __CRT_HAVE___expf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_exp || __CRT_HAVE___exp || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_frexpf) || defined(__CRT_HAVE___frexpf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_frexp) || defined(__CRT_HAVE___frexp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(frexpf)
#endif /* __CRT_HAVE_frexpf || __CRT_HAVE___frexpf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_frexp || __CRT_HAVE___frexp || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_ldexpf) || defined(__CRT_HAVE___ldexpf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_ldexp) || defined(__CRT_HAVE___ldexp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(ldexpf)
#endif /* __CRT_HAVE_ldexpf || __CRT_HAVE___ldexpf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_ldexp || __CRT_HAVE___ldexp || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_logf) || defined(__CRT_HAVE___logf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_log) || defined(__CRT_HAVE___log) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(logf)
#endif /* __CRT_HAVE_logf || __CRT_HAVE___logf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_log || __CRT_HAVE___log || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_log10f) || defined(__CRT_HAVE___log10f) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_log10) || defined(__CRT_HAVE___log10) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(log10f)
#endif /* __CRT_HAVE_log10f || __CRT_HAVE___log10f || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_log10 || __CRT_HAVE___log10 || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_modff) || defined(__CRT_HAVE___modff) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_modf) || defined(__CRT_HAVE___modf) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(modff)
#endif /* __CRT_HAVE_modff || __CRT_HAVE___modff || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_modf || __CRT_HAVE___modf || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if defined(__CRT_HAVE_expl) || defined(__CRT_HAVE___expl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_exp) || defined(__CRT_HAVE___exp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(expl)
#endif /* __CRT_HAVE_expl || __CRT_HAVE___expl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_exp || __CRT_HAVE___exp || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_frexpl) || defined(__CRT_HAVE___frexpl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_frexp) || defined(__CRT_HAVE___frexp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(frexpl)
#endif /* __CRT_HAVE_frexpl || __CRT_HAVE___frexpl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_frexp || __CRT_HAVE___frexp || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_ldexpl) || defined(__CRT_HAVE___ldexpl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_ldexp) || defined(__CRT_HAVE___ldexp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(ldexpl)
#endif /* __CRT_HAVE_ldexpl || __CRT_HAVE___ldexpl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_ldexp || __CRT_HAVE___ldexp || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_logl) || defined(__CRT_HAVE___logl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_log) || defined(__CRT_HAVE___log) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(logl)
#endif /* __CRT_HAVE_logl || __CRT_HAVE___logl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_log || __CRT_HAVE___log || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_log10l) || defined(__CRT_HAVE___log10l) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_log10) || defined(__CRT_HAVE___log10) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(log10l)
#endif /* __CRT_HAVE_log10l || __CRT_HAVE___log10l || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_log10 || __CRT_HAVE___log10 || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_modfl) || defined(__CRT_HAVE___modfl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_modf) || defined(__CRT_HAVE___modf) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(modfl)
#endif /* __CRT_HAVE_modfl || __CRT_HAVE___modfl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_modf || __CRT_HAVE___modf || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#if defined(__USE_XOPEN_EXTENDED) || defined(__USE_ISOC99)
#if defined(__CRT_HAVE_expm1) || defined(__CRT_HAVE___expm1) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(expm1)
#endif /* __CRT_HAVE_expm1 || __CRT_HAVE___expm1 || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_log1p) || defined(__CRT_HAVE___log1p) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(log1p)
#endif /* __CRT_HAVE_log1p || __CRT_HAVE___log1p || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_logb) || defined(__CRT_HAVE___logb) || defined(__CRT_HAVE__logb) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(logb)
#endif /* __CRT_HAVE_logb || __CRT_HAVE___logb || __CRT_HAVE__logb || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_expm1f) || defined(__CRT_HAVE___expm1f) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_expm1) || defined(__CRT_HAVE___expm1) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(expm1f)
#endif /* __CRT_HAVE_expm1f || __CRT_HAVE___expm1f || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_expm1 || __CRT_HAVE___expm1 || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_log1pf) || defined(__CRT_HAVE___log1pf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_log1p) || defined(__CRT_HAVE___log1p) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(log1pf)
#endif /* __CRT_HAVE_log1pf || __CRT_HAVE___log1pf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_log1p || __CRT_HAVE___log1p || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_logbf) || defined(__CRT_HAVE___logbf) || defined(__CRT_HAVE__logbf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_logb) || defined(__CRT_HAVE___logb) || defined(__CRT_HAVE__logb) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(logbf)
#endif /* __CRT_HAVE_logbf || __CRT_HAVE___logbf || __CRT_HAVE__logbf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_logb || __CRT_HAVE___logb || __CRT_HAVE__logb || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if defined(__CRT_HAVE_expm1l) || defined(__CRT_HAVE___expm1l) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_expm1) || defined(__CRT_HAVE___expm1) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(expm1l)
#endif /* __CRT_HAVE_expm1l || __CRT_HAVE___expm1l || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_expm1 || __CRT_HAVE___expm1 || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_log1pl) || defined(__CRT_HAVE___log1pl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_log1p) || defined(__CRT_HAVE___log1p) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(log1pl)
#endif /* __CRT_HAVE_log1pl || __CRT_HAVE___log1pl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_log1p || __CRT_HAVE___log1p || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_logbl) || defined(__CRT_HAVE___logbl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_logb) || defined(__CRT_HAVE___logb) || defined(__CRT_HAVE__logb) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(logbl)
#endif /* __CRT_HAVE_logbl || __CRT_HAVE___logbl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_logb || __CRT_HAVE___logb || __CRT_HAVE__logb || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_XOPEN_EXTENDED || __USE_ISOC99 */
#ifdef __USE_ISOC99
#if defined(__CRT_HAVE_exp2) || defined(__CRT_HAVE___exp2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(exp2)
#endif /* __CRT_HAVE_exp2 || __CRT_HAVE___exp2 || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_log2) || defined(__CRT_HAVE___log2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(log2)
#endif /* __CRT_HAVE_log2 || __CRT_HAVE___log2 || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_exp2f) || defined(__CRT_HAVE___exp2f) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_exp2) || defined(__CRT_HAVE___exp2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(exp2f)
#endif /* __CRT_HAVE_exp2f || __CRT_HAVE___exp2f || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_exp2 || __CRT_HAVE___exp2 || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_log2f) || defined(__CRT_HAVE___log2f) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_log2) || defined(__CRT_HAVE___log2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(log2f)
#endif /* __CRT_HAVE_log2f || __CRT_HAVE___log2f || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_log2 || __CRT_HAVE___log2 || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if defined(__CRT_HAVE_exp2l) || defined(__CRT_HAVE___exp2l) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_exp2) || defined(__CRT_HAVE___exp2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(exp2l)
#endif /* __CRT_HAVE_exp2l || __CRT_HAVE___exp2l || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_exp2 || __CRT_HAVE___exp2 || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_log2l) || defined(__CRT_HAVE___log2l) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_log2) || defined(__CRT_HAVE___log2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(log2l)
#endif /* __CRT_HAVE_log2l || __CRT_HAVE___log2l || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_log2 || __CRT_HAVE___log2 || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_ISOC99 */
#if defined(__CRT_HAVE_pow) || defined(__CRT_HAVE___pow) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(pow)
#endif /* __CRT_HAVE_pow || __CRT_HAVE___pow || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_sqrt) || defined(__CRT_HAVE___sqrt) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(sqrt)
#endif /* __CRT_HAVE_sqrt || __CRT_HAVE___sqrt || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_powf) || defined(__CRT_HAVE___powf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_pow) || defined(__CRT_HAVE___pow) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(powf)
#endif /* __CRT_HAVE_powf || __CRT_HAVE___powf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_pow || __CRT_HAVE___pow || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_sqrtf) || defined(__CRT_HAVE___sqrtf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_sqrt) || defined(__CRT_HAVE___sqrt) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(sqrtf)
#endif /* __CRT_HAVE_sqrtf || __CRT_HAVE___sqrtf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_sqrt || __CRT_HAVE___sqrt || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if defined(__CRT_HAVE_powl) || defined(__CRT_HAVE___powl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_pow) || defined(__CRT_HAVE___pow) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(powl)
#endif /* __CRT_HAVE_powl || __CRT_HAVE___powl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_pow || __CRT_HAVE___pow || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_sqrtl) || defined(__CRT_HAVE___sqrtl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_sqrt) || defined(__CRT_HAVE___sqrt) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(sqrtl)
#endif /* __CRT_HAVE_sqrtl || __CRT_HAVE___sqrtl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_sqrt || __CRT_HAVE___sqrt || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#if defined(__USE_XOPEN) || defined(__USE_ISOC99)
#if defined(__CRT_HAVE_hypot) || defined(__CRT_HAVE__hypot) || defined(__CRT_HAVE___hypot) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(hypot)
#endif /* __CRT_HAVE_hypot || __CRT_HAVE__hypot || __CRT_HAVE___hypot || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_hypotf) || defined(__CRT_HAVE__hypotf) || defined(__CRT_HAVE___hypotf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_hypot) || defined(__CRT_HAVE__hypot) || defined(__CRT_HAVE___hypot) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(hypotf)
#endif /* __CRT_HAVE_hypotf || __CRT_HAVE__hypotf || __CRT_HAVE___hypotf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_hypot || __CRT_HAVE__hypot || __CRT_HAVE___hypot || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if defined(__CRT_HAVE_hypotl) || defined(__CRT_HAVE___hypotl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_hypot) || defined(__CRT_HAVE__hypot) || defined(__CRT_HAVE___hypot) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(hypotl)
#endif /* __CRT_HAVE_hypotl || __CRT_HAVE___hypotl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_hypot || __CRT_HAVE__hypot || __CRT_HAVE___hypot || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_XOPEN || __USE_ISOC99 */
#if defined(__USE_XOPEN_EXTENDED) || defined(__USE_ISOC99)
#if defined(__CRT_HAVE_cbrt) || defined(__CRT_HAVE___cbrt) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(cbrt)
#endif /* __CRT_HAVE_cbrt || __CRT_HAVE___cbrt || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_cbrtf) || defined(__CRT_HAVE___cbrtf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_cbrt) || defined(__CRT_HAVE___cbrt) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(cbrtf)
#endif /* __CRT_HAVE_cbrtf || __CRT_HAVE___cbrtf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_cbrt || __CRT_HAVE___cbrt || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if defined(__CRT_HAVE_cbrtl) || defined(__CRT_HAVE___cbrtl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_cbrt) || defined(__CRT_HAVE___cbrt) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(cbrtl)
#endif /* __CRT_HAVE_cbrtl || __CRT_HAVE___cbrtl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_cbrt || __CRT_HAVE___cbrt || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_XOPEN_EXTENDED || __USE_ISOC99 */
__NAMESPACE_STD_USING(ceil)
__NAMESPACE_STD_USING(fabs)
__NAMESPACE_STD_USING(floor)
#if defined(__CRT_HAVE_fmod) || defined(__CRT_HAVE___fmod) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(fmod)
#endif /* __CRT_HAVE_fmod || __CRT_HAVE___fmod || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
__NAMESPACE_STD_USING(ceilf)
__NAMESPACE_STD_USING(fabsf)
__NAMESPACE_STD_USING(floorf)
#if defined(__CRT_HAVE_fmodf) || defined(__CRT_HAVE___fmodf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_fmod) || defined(__CRT_HAVE___fmod) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(fmodf)
#endif /* __CRT_HAVE_fmodf || __CRT_HAVE___fmodf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_fmod || __CRT_HAVE___fmod || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#ifdef __COMPILER_HAVE_LONGDOUBLE
__NAMESPACE_STD_USING(ceill)
__NAMESPACE_STD_USING(fabsl)
__NAMESPACE_STD_USING(floorl)
#if defined(__CRT_HAVE_fmodl) || defined(__CRT_HAVE___fmodl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_fmod) || defined(__CRT_HAVE___fmod) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(fmodl)
#endif /* __CRT_HAVE_fmodl || __CRT_HAVE___fmodl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_fmod || __CRT_HAVE___fmod || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#ifdef __USE_ISOC99
__NAMESPACE_STD_USING(copysign)
#if defined(__CRT_HAVE_nan) || defined(__CRT_HAVE___nan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(nan)
#endif /* __CRT_HAVE_nan || __CRT_HAVE___nan || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
__NAMESPACE_STD_USING(copysignf)
#if defined(__CRT_HAVE_nanf) || defined(__CRT_HAVE___nanf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_nan) || defined(__CRT_HAVE___nan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(nanf)
#endif /* __CRT_HAVE_nanf || __CRT_HAVE___nanf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_nan || __CRT_HAVE___nan || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#ifdef __COMPILER_HAVE_LONGDOUBLE
__NAMESPACE_STD_USING(copysignl)
#if defined(__CRT_HAVE_nanl) || defined(__CRT_HAVE___nanl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_nan) || defined(__CRT_HAVE___nan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(nanl)
#endif /* __CRT_HAVE_nanl || __CRT_HAVE___nanl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_nan || __CRT_HAVE___nan || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_ISOC99 */
#if defined(__USE_XOPEN) || defined(__USE_ISOC99)
#if defined(__CRT_HAVE_erf) || defined(__CRT_HAVE___erf) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(erf)
#endif /* __CRT_HAVE_erf || __CRT_HAVE___erf || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_erfc) || defined(__CRT_HAVE___erfc) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(erfc)
#endif /* __CRT_HAVE_erfc || __CRT_HAVE___erfc || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#include <libc/template/signgam.h>
#if defined(__CRT_HAVE_lgamma) || defined(__CRT_HAVE_gamma) || defined(__CRT_HAVE___lgamma) || defined(__CRT_HAVE___gamma) || (defined(__LOCAL_signgam) && (defined(__CRT_HAVE_lgamma_r) || defined(__CRT_HAVE___lgamma_r) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)))
__NAMESPACE_STD_USING(lgamma)
#endif /* __CRT_HAVE_lgamma || __CRT_HAVE_gamma || __CRT_HAVE___lgamma || __CRT_HAVE___gamma || (__LOCAL_signgam && (__CRT_HAVE_lgamma_r || __CRT_HAVE___lgamma_r || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)) */
#if defined(__CRT_HAVE_erff) || defined(__CRT_HAVE___erff) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_erf) || defined(__CRT_HAVE___erf) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(erff)
#endif /* __CRT_HAVE_erff || __CRT_HAVE___erff || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_erf || __CRT_HAVE___erf || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_erfcf) || defined(__CRT_HAVE___erfcf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_erfc) || defined(__CRT_HAVE___erfc) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(erfcf)
#endif /* __CRT_HAVE_erfcf || __CRT_HAVE___erfcf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_erfc || __CRT_HAVE___erfc || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_lgammaf) || defined(__CRT_HAVE_gammaf) || defined(__CRT_HAVE___lgammaf) || defined(__CRT_HAVE___gammaf) || (defined(__LOCAL_signgam) && (defined(__CRT_HAVE_lgammaf_r) || defined(__CRT_HAVE___lgammaf_r) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_lgamma_r) || defined(__CRT_HAVE___lgamma_r) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)))
__NAMESPACE_STD_USING(lgammaf)
#endif /* __CRT_HAVE_lgammaf || __CRT_HAVE_gammaf || __CRT_HAVE___lgammaf || __CRT_HAVE___gammaf || (__LOCAL_signgam && (__CRT_HAVE_lgammaf_r || __CRT_HAVE___lgammaf_r || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_lgamma_r || __CRT_HAVE___lgamma_r || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)) */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if defined(__CRT_HAVE_erfl) || defined(__CRT_HAVE___erfl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_erf) || defined(__CRT_HAVE___erf) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(erfl)
#endif /* __CRT_HAVE_erfl || __CRT_HAVE___erfl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_erf || __CRT_HAVE___erf || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_erfcl) || defined(__CRT_HAVE___erfcl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_erfc) || defined(__CRT_HAVE___erfc) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(erfcl)
#endif /* __CRT_HAVE_erfcl || __CRT_HAVE___erfcl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_erfc || __CRT_HAVE___erfc || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_lgammal) || defined(__CRT_HAVE_gammal) || defined(__CRT_HAVE___lgammal) || defined(__CRT_HAVE___gammal) || (defined(__LOCAL_signgam) && (defined(__CRT_HAVE_lgammal_r) || defined(__CRT_HAVE___lgammal_r) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_lgamma_r) || defined(__CRT_HAVE___lgamma_r) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)))
__NAMESPACE_STD_USING(lgammal)
#endif /* __CRT_HAVE_lgammal || __CRT_HAVE_gammal || __CRT_HAVE___lgammal || __CRT_HAVE___gammal || (__LOCAL_signgam && (__CRT_HAVE_lgammal_r || __CRT_HAVE___lgammal_r || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_lgamma_r || __CRT_HAVE___lgamma_r || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)) */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_XOPEN || __USE_ISOC99 */
#ifdef __USE_ISOC99
#if defined(__CRT_HAVE_tgamma) || defined(__CRT_HAVE___tgamma) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(tgamma)
#endif /* __CRT_HAVE_tgamma || __CRT_HAVE___tgamma || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_tgammaf) || defined(__CRT_HAVE___tgammaf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_tgamma) || defined(__CRT_HAVE___tgamma) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(tgammaf)
#endif /* __CRT_HAVE_tgammaf || __CRT_HAVE___tgammaf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_tgamma || __CRT_HAVE___tgamma || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if defined(__CRT_HAVE_tgammal) || defined(__CRT_HAVE___tgammal) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_tgamma) || defined(__CRT_HAVE___tgamma) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(tgammal)
#endif /* __CRT_HAVE_tgammal || __CRT_HAVE___tgammal || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_tgamma || __CRT_HAVE___tgamma || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_ISOC99 */
#if defined(__USE_XOPEN_EXTENDED) || defined(__USE_ISOC99)
#if defined(__CRT_HAVE_rint) || defined(__CRT_HAVE_nearbyint) || defined(__CRT_HAVE___rint) || defined(__CRT_HAVE___nearbyint) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(rint)
#endif /* __CRT_HAVE_rint || __CRT_HAVE_nearbyint || __CRT_HAVE___rint || __CRT_HAVE___nearbyint || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_nextafter) || defined(__CRT_HAVE_nexttoward) || defined(__CRT_HAVE___nextafter) || defined(__CRT_HAVE__nextafter) || defined(__CRT_HAVE___nexttoward) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(nextafter)
#endif /* __CRT_HAVE_nextafter || __CRT_HAVE_nexttoward || __CRT_HAVE___nextafter || __CRT_HAVE__nextafter || __CRT_HAVE___nexttoward || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_remainder) || defined(__CRT_HAVE_drem) || defined(__CRT_HAVE___remainder) || defined(__CRT_HAVE___drem) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(remainder)
#endif /* __CRT_HAVE_remainder || __CRT_HAVE_drem || __CRT_HAVE___remainder || __CRT_HAVE___drem || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_ilogb) || (defined(__CRT_HAVE_llogb) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__CRT_HAVE___ilogb) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(ilogb)
#endif /* __CRT_HAVE_ilogb || (__CRT_HAVE_llogb && __SIZEOF_INT__ == __SIZEOF_LONG__) || __CRT_HAVE___ilogb || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_rintf) || defined(__CRT_HAVE_nearbyintf) || defined(__CRT_HAVE___rintf) || defined(__CRT_HAVE___nearbyintf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_rint) || defined(__CRT_HAVE_nearbyint) || defined(__CRT_HAVE___rint) || defined(__CRT_HAVE___nearbyint) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(rintf)
#endif /* __CRT_HAVE_rintf || __CRT_HAVE_nearbyintf || __CRT_HAVE___rintf || __CRT_HAVE___nearbyintf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_rint || __CRT_HAVE_nearbyint || __CRT_HAVE___rint || __CRT_HAVE___nearbyint || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_nextafterf) || defined(__CRT_HAVE_nexttowardf) || defined(__CRT_HAVE___nextafterf) || defined(__CRT_HAVE___nexttowardf) || defined(__CRT_HAVE__nextafterf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_nextafter) || defined(__CRT_HAVE_nexttoward) || defined(__CRT_HAVE___nextafter) || defined(__CRT_HAVE__nextafter) || defined(__CRT_HAVE___nexttoward) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(nextafterf)
#endif /* __CRT_HAVE_nextafterf || __CRT_HAVE_nexttowardf || __CRT_HAVE___nextafterf || __CRT_HAVE___nexttowardf || __CRT_HAVE__nextafterf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_nextafter || __CRT_HAVE_nexttoward || __CRT_HAVE___nextafter || __CRT_HAVE__nextafter || __CRT_HAVE___nexttoward || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_remainderf) || defined(__CRT_HAVE_dremf) || defined(__CRT_HAVE___remainderf) || defined(__CRT_HAVE___dremf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_remainder) || defined(__CRT_HAVE_drem) || defined(__CRT_HAVE___remainder) || defined(__CRT_HAVE___drem) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(remainderf)
#endif /* __CRT_HAVE_remainderf || __CRT_HAVE_dremf || __CRT_HAVE___remainderf || __CRT_HAVE___dremf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_remainder || __CRT_HAVE_drem || __CRT_HAVE___remainder || __CRT_HAVE___drem || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_ilogbf) || (defined(__CRT_HAVE_llogbf) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__CRT_HAVE___ilogbf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_ilogb) || (defined(__CRT_HAVE_llogb) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__CRT_HAVE___ilogb) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(ilogbf)
#endif /* __CRT_HAVE_ilogbf || (__CRT_HAVE_llogbf && __SIZEOF_INT__ == __SIZEOF_LONG__) || __CRT_HAVE___ilogbf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __CRT_HAVE_ilogb || (__CRT_HAVE_llogb && __SIZEOF_INT__ == __SIZEOF_LONG__) || __CRT_HAVE___ilogb || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if defined(__CRT_HAVE_rintl) || defined(__CRT_HAVE_nearbyintl) || defined(__CRT_HAVE___rintl) || defined(__CRT_HAVE___nearbyintl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_rint) || defined(__CRT_HAVE_nearbyint) || defined(__CRT_HAVE___rint) || defined(__CRT_HAVE___nearbyint) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(rintl)
#endif /* __CRT_HAVE_rintl || __CRT_HAVE_nearbyintl || __CRT_HAVE___rintl || __CRT_HAVE___nearbyintl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_rint || __CRT_HAVE_nearbyint || __CRT_HAVE___rint || __CRT_HAVE___nearbyint || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_nextafterl) || defined(__CRT_HAVE_nexttowardl) || defined(__CRT_HAVE___nextafterl) || defined(__CRT_HAVE___nexttowardl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_nextafter) || defined(__CRT_HAVE_nexttoward) || defined(__CRT_HAVE___nextafter) || defined(__CRT_HAVE__nextafter) || defined(__CRT_HAVE___nexttoward) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(nextafterl)
#endif /* __CRT_HAVE_nextafterl || __CRT_HAVE_nexttowardl || __CRT_HAVE___nextafterl || __CRT_HAVE___nexttowardl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_nextafter || __CRT_HAVE_nexttoward || __CRT_HAVE___nextafter || __CRT_HAVE__nextafter || __CRT_HAVE___nexttoward || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_remainderl) || defined(__CRT_HAVE_dreml) || defined(__CRT_HAVE___remainderl) || defined(__CRT_HAVE___dreml) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_remainder) || defined(__CRT_HAVE_drem) || defined(__CRT_HAVE___remainder) || defined(__CRT_HAVE___drem) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(remainderl)
#endif /* __CRT_HAVE_remainderl || __CRT_HAVE_dreml || __CRT_HAVE___remainderl || __CRT_HAVE___dreml || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_remainder || __CRT_HAVE_drem || __CRT_HAVE___remainder || __CRT_HAVE___drem || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_ilogbl) || (defined(__CRT_HAVE_llogbl) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__CRT_HAVE___ilogbl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_ilogb) || (defined(__CRT_HAVE_llogb) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__CRT_HAVE___ilogb) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(ilogbl)
#endif /* __CRT_HAVE_ilogbl || (__CRT_HAVE_llogbl && __SIZEOF_INT__ == __SIZEOF_LONG__) || __CRT_HAVE___ilogbl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_ilogb || (__CRT_HAVE_llogb && __SIZEOF_INT__ == __SIZEOF_LONG__) || __CRT_HAVE___ilogb || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_XOPEN_EXTENDED || __USE_ISOC99 */
#ifdef __USE_ISOC99
#if defined(__CRT_HAVE_nextafterl) || defined(__CRT_HAVE_nexttowardl) || defined(__CRT_HAVE___nextafterl) || defined(__CRT_HAVE___nexttowardl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_nextafter) || defined(__CRT_HAVE_nexttoward) || defined(__CRT_HAVE___nextafter) || defined(__CRT_HAVE__nextafter) || defined(__CRT_HAVE___nexttoward) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(nexttoward)
#endif /* __CRT_HAVE_nextafterl || __CRT_HAVE_nexttowardl || __CRT_HAVE___nextafterl || __CRT_HAVE___nexttowardl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_nextafter || __CRT_HAVE_nexttoward || __CRT_HAVE___nextafter || __CRT_HAVE__nextafter || __CRT_HAVE___nexttoward || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_scalbn) || defined(__CRT_HAVE___scalbn) || (defined(__CRT_HAVE_scalbln) && __SIZEOF_INT__ == __SIZEOF_LONG__) || (defined(__CRT_HAVE___scalbln) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(scalbn)
#endif /* __CRT_HAVE_scalbn || __CRT_HAVE___scalbn || (__CRT_HAVE_scalbln && __SIZEOF_INT__ == __SIZEOF_LONG__) || (__CRT_HAVE___scalbln && __SIZEOF_INT__ == __SIZEOF_LONG__) || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_scalbln) || defined(__CRT_HAVE___scalbln) || (defined(__CRT_HAVE_scalbn) && __SIZEOF_INT__ == __SIZEOF_LONG__) || (defined(__CRT_HAVE___scalbn) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(scalbln)
#endif /* __CRT_HAVE_scalbln || __CRT_HAVE___scalbln || (__CRT_HAVE_scalbn && __SIZEOF_INT__ == __SIZEOF_LONG__) || (__CRT_HAVE___scalbn && __SIZEOF_INT__ == __SIZEOF_LONG__) || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_nearbyint) || defined(__CRT_HAVE___nearbyint) || defined(__CRT_HAVE_rint) || defined(__CRT_HAVE___rint) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(nearbyint)
#endif /* __CRT_HAVE_nearbyint || __CRT_HAVE___nearbyint || __CRT_HAVE_rint || __CRT_HAVE___rint || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
__NAMESPACE_STD_USING(round)
__NAMESPACE_STD_USING(trunc)
#if defined(__CRT_HAVE_remquo) || defined(__CRT_HAVE___remquo) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(remquo)
#endif /* __CRT_HAVE_remquo || __CRT_HAVE___remquo || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
__NAMESPACE_STD_USING(lrint)
__NAMESPACE_STD_USING(lround)
__NAMESPACE_STD_USING(fdim)
__NAMESPACE_STD_USING(fmax)
__NAMESPACE_STD_USING(fmin)
__NAMESPACE_STD_USING(fma)
#ifdef __COMPILER_HAVE_LONGLONG
__NAMESPACE_STD_USING(llrint)
__NAMESPACE_STD_USING(llround)
#endif /* __COMPILER_HAVE_LONGLONG */
#if defined(__CRT_HAVE_nexttowardf) || defined(__CRT_HAVE___nexttowardf) || ((defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__)) && defined(__IEEE854_LONG_DOUBLE_TYPE__)) || defined(__CRT_HAVE_nextafterl) || defined(__CRT_HAVE_nexttowardl) || defined(__CRT_HAVE___nextafterl) || defined(__CRT_HAVE___nexttowardl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_nextafter) || defined(__CRT_HAVE_nexttoward) || defined(__CRT_HAVE___nextafter) || defined(__CRT_HAVE__nextafter) || defined(__CRT_HAVE___nexttoward) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(nexttowardf)
#endif /* __CRT_HAVE_nexttowardf || __CRT_HAVE___nexttowardf || ((__IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE754_DOUBLE_TYPE_IS_FLOAT__) && __IEEE854_LONG_DOUBLE_TYPE__) || __CRT_HAVE_nextafterl || __CRT_HAVE_nexttowardl || __CRT_HAVE___nextafterl || __CRT_HAVE___nexttowardl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_nextafter || __CRT_HAVE_nexttoward || __CRT_HAVE___nextafter || __CRT_HAVE__nextafter || __CRT_HAVE___nexttoward || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_scalbnf) || defined(__CRT_HAVE___scalbnf) || (defined(__CRT_HAVE_scalblnf) && __SIZEOF_INT__ == __SIZEOF_LONG__) || (defined(__CRT_HAVE___scalblnf) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_scalbn) || defined(__CRT_HAVE___scalbn) || (defined(__CRT_HAVE_scalbln) && __SIZEOF_INT__ == __SIZEOF_LONG__) || (defined(__CRT_HAVE___scalbln) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(scalbnf)
#endif /* __CRT_HAVE_scalbnf || __CRT_HAVE___scalbnf || (__CRT_HAVE_scalblnf && __SIZEOF_INT__ == __SIZEOF_LONG__) || (__CRT_HAVE___scalblnf && __SIZEOF_INT__ == __SIZEOF_LONG__) || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_scalbn || __CRT_HAVE___scalbn || (__CRT_HAVE_scalbln && __SIZEOF_INT__ == __SIZEOF_LONG__) || (__CRT_HAVE___scalbln && __SIZEOF_INT__ == __SIZEOF_LONG__) || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_scalblnf) || defined(__CRT_HAVE___scalblnf) || (defined(__CRT_HAVE_scalbnf) && __SIZEOF_INT__ == __SIZEOF_LONG__) || (defined(__CRT_HAVE___scalbnf) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_scalbln) || defined(__CRT_HAVE___scalbln) || (defined(__CRT_HAVE_scalbn) && __SIZEOF_INT__ == __SIZEOF_LONG__) || (defined(__CRT_HAVE___scalbn) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(scalblnf)
#endif /* __CRT_HAVE_scalblnf || __CRT_HAVE___scalblnf || (__CRT_HAVE_scalbnf && __SIZEOF_INT__ == __SIZEOF_LONG__) || (__CRT_HAVE___scalbnf && __SIZEOF_INT__ == __SIZEOF_LONG__) || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_scalbln || __CRT_HAVE___scalbln || (__CRT_HAVE_scalbn && __SIZEOF_INT__ == __SIZEOF_LONG__) || (__CRT_HAVE___scalbn && __SIZEOF_INT__ == __SIZEOF_LONG__) || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_nearbyintf) || defined(__CRT_HAVE___nearbyintf) || defined(__CRT_HAVE_rintf) || defined(__CRT_HAVE___rintf) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__)
__NAMESPACE_STD_USING(nearbyintf)
#endif /* __CRT_HAVE_nearbyintf || __CRT_HAVE___nearbyintf || __CRT_HAVE_rintf || __CRT_HAVE___rintf || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ */
__NAMESPACE_STD_USING(roundf)
__NAMESPACE_STD_USING(truncf)
#if defined(__CRT_HAVE_remquof) || defined(__CRT_HAVE___remquof) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_remquo) || defined(__CRT_HAVE___remquo) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(remquof)
#endif /* __CRT_HAVE_remquof || __CRT_HAVE___remquof || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_remquo || __CRT_HAVE___remquo || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
__NAMESPACE_STD_USING(lrintf)
__NAMESPACE_STD_USING(lroundf)
__NAMESPACE_STD_USING(fdimf)
__NAMESPACE_STD_USING(fmaxf)
__NAMESPACE_STD_USING(fminf)
__NAMESPACE_STD_USING(fmaf)
#ifdef __COMPILER_HAVE_LONGLONG
__NAMESPACE_STD_USING(llrintf)
__NAMESPACE_STD_USING(llroundf)
#endif /* __COMPILER_HAVE_LONGLONG */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if defined(__CRT_HAVE_nextafterl) || defined(__CRT_HAVE_nexttowardl) || defined(__CRT_HAVE___nextafterl) || defined(__CRT_HAVE___nexttowardl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_nextafter) || defined(__CRT_HAVE_nexttoward) || defined(__CRT_HAVE___nextafter) || defined(__CRT_HAVE__nextafter) || defined(__CRT_HAVE___nexttoward) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(nexttowardl)
#endif /* __CRT_HAVE_nextafterl || __CRT_HAVE_nexttowardl || __CRT_HAVE___nextafterl || __CRT_HAVE___nexttowardl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_nextafter || __CRT_HAVE_nexttoward || __CRT_HAVE___nextafter || __CRT_HAVE__nextafter || __CRT_HAVE___nexttoward || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_scalbnl) || defined(__CRT_HAVE___scalbnl) || (defined(__CRT_HAVE_scalblnl) && __SIZEOF_INT__ == __SIZEOF_LONG__) || (defined(__CRT_HAVE___scalblnl) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_scalbn) || defined(__CRT_HAVE___scalbn) || (defined(__CRT_HAVE_scalbln) && __SIZEOF_INT__ == __SIZEOF_LONG__) || (defined(__CRT_HAVE___scalbln) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(scalbnl)
#endif /* __CRT_HAVE_scalbnl || __CRT_HAVE___scalbnl || (__CRT_HAVE_scalblnl && __SIZEOF_INT__ == __SIZEOF_LONG__) || (__CRT_HAVE___scalblnl && __SIZEOF_INT__ == __SIZEOF_LONG__) || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_scalbn || __CRT_HAVE___scalbn || (__CRT_HAVE_scalbln && __SIZEOF_INT__ == __SIZEOF_LONG__) || (__CRT_HAVE___scalbln && __SIZEOF_INT__ == __SIZEOF_LONG__) || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_scalblnl) || defined(__CRT_HAVE___scalblnl) || (defined(__CRT_HAVE_scalbnl) && __SIZEOF_INT__ == __SIZEOF_LONG__) || (defined(__CRT_HAVE___scalbnl) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_scalbln) || defined(__CRT_HAVE___scalbln) || (defined(__CRT_HAVE_scalbn) && __SIZEOF_INT__ == __SIZEOF_LONG__) || (defined(__CRT_HAVE___scalbn) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(scalblnl)
#endif /* __CRT_HAVE_scalblnl || __CRT_HAVE___scalblnl || (__CRT_HAVE_scalbnl && __SIZEOF_INT__ == __SIZEOF_LONG__) || (__CRT_HAVE___scalbnl && __SIZEOF_INT__ == __SIZEOF_LONG__) || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_scalbln || __CRT_HAVE___scalbln || (__CRT_HAVE_scalbn && __SIZEOF_INT__ == __SIZEOF_LONG__) || (__CRT_HAVE___scalbn && __SIZEOF_INT__ == __SIZEOF_LONG__) || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_nearbyintl) || defined(__CRT_HAVE___nearbyintl) || defined(__CRT_HAVE_rintl) || defined(__CRT_HAVE___rintl) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__)
__NAMESPACE_STD_USING(nearbyintl)
#endif /* __CRT_HAVE_nearbyintl || __CRT_HAVE___nearbyintl || __CRT_HAVE_rintl || __CRT_HAVE___rintl || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ */
__NAMESPACE_STD_USING(roundl)
__NAMESPACE_STD_USING(truncl)
#if defined(__CRT_HAVE_remquol) || defined(__CRT_HAVE___remquol) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_remquo) || defined(__CRT_HAVE___remquo) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(remquol)
#endif /* __CRT_HAVE_remquol || __CRT_HAVE___remquol || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_remquo || __CRT_HAVE___remquo || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
__NAMESPACE_STD_USING(lrintl)
__NAMESPACE_STD_USING(lroundl)
__NAMESPACE_STD_USING(fdiml)
__NAMESPACE_STD_USING(fmaxl)
__NAMESPACE_STD_USING(fminl)
__NAMESPACE_STD_USING(fmal)
#ifdef __COMPILER_HAVE_LONGLONG
__NAMESPACE_STD_USING(llrintl)
__NAMESPACE_STD_USING(llroundl)
#endif /* __COMPILER_HAVE_LONGLONG */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_ISOC99 */
#ifdef __std_fpclassify_defined
__NAMESPACE_STD_USING(fpclassify)
#endif /* __std_fpclassify_defined */
#ifdef __std_signbit_defined
__NAMESPACE_STD_USING(signbit)
#endif /* __std_signbit_defined */
#ifdef __std_isnormal_defined
__NAMESPACE_STD_USING(isnormal)
#endif /* __std_isnormal_defined */
#ifdef __std_isfinite_defined
__NAMESPACE_STD_USING(isfinite)
#endif /* __std_isfinite_defined */
#ifdef __std_isnan_defined
__NAMESPACE_STD_USING(isnan)
#endif /* __std_isnan_defined */
#ifdef __std_isinf_defined
__NAMESPACE_STD_USING(isinf)
#endif /* __std_isinf_defined */
#ifdef __std_isunordered_defined
__NAMESPACE_STD_USING(isunordered)
#endif /* __std_isunordered_defined */
#ifdef __std_isgreater_defined
__NAMESPACE_STD_USING(isgreater)
#endif /* __std_isgreater_defined */
#ifdef __std_isgreaterequal_defined
__NAMESPACE_STD_USING(isgreaterequal)
#endif /* __std_isgreaterequal_defined */
#ifdef __std_isless_defined
__NAMESPACE_STD_USING(isless)
#endif /* __std_isless_defined */
#ifdef __std_islessequal_defined
__NAMESPACE_STD_USING(islessequal)
#endif /* __std_islessequal_defined */
#ifdef __std_islessgreater_defined
__NAMESPACE_STD_USING(islessgreater)
#endif /* __std_islessgreater_defined */
#endif /* !__NO_FPU */
#undef _CXX_STDONLY_CMATH
#endif /* !__CXX_SYSTEM_HEADER */
#else /* _CXX_STDONLY_CMATH */
#include "__stdinc.h"
#include "__crt.h"

#ifdef __COMPILER_HAVE_PRAGMA_GCC_SYSTEM_HEADER
#pragma GCC system_header
#endif /* __COMPILER_HAVE_PRAGMA_GCC_SYSTEM_HEADER */

#ifndef __NO_FPU
#include <features.h>

#include <hybrid/typecore.h>
#include <hybrid/floatcore.h>

#include <bits/math-constants.h>
#include <bits/crt/math-vector.h>

#include <ieee754.h>

#ifdef __USE_ISOC99
#include <asm/crt/fp_type.h>  /* __FP_NAN, __FP_INFINITE, ... */
#include <libm/fcomp.h>
#endif /* __USE_ISOC99 */
#if defined(__USE_ISOC99) || defined(__USE_GNU) || defined(__STDC_WANT_IEC_60559_BFP_EXT__)
#include <bits/crt/mathdef.h> /* __FLT_EVAL_METHOD__, __FP_ILOGB0, __FP_ILOGBNAN */
#endif /* __USE_ISOC99 || __USE_GNU || __STDC_WANT_IEC_60559_BFP_EXT__ */

#ifdef __USE_MISC
#include <asm/crt/math-exception.h>
#include <asm/crt/math-libc_version.h>
#endif /* __USE_MISC */


/* Math constants (`_USE_MATH_DEFINES' is the DOS feature macro to expose these) */
#if defined(__USE_MISC) || defined(__USE_XOPEN) || defined(_USE_MATH_DEFINES)
#ifndef M_E
#define M_E        2.7182818284590452354  /* e */
#define M_LOG2E    1.4426950408889634074  /* log_2 e */
#define M_LOG10E   0.43429448190325182765 /* log_10 e */
#define M_LN2      0.69314718055994530942 /* log_e 2 */
#define M_LN10     2.30258509299404568402 /* log_e 10 */
#define M_PI       3.14159265358979323846 /* pi */
#define M_PI_2     1.57079632679489661923 /* pi/2 */
#define M_PI_4     0.78539816339744830962 /* pi/4 */
#define M_1_PI     0.31830988618379067154 /* 1/pi */
#define M_2_PI     0.63661977236758134308 /* 2/pi */
#define M_2_SQRTPI 1.12837916709551257390 /* 2/sqrt(pi) */
#define M_SQRT2    1.41421356237309504880 /* sqrt(2) */
#define M_SQRT1_2  0.70710678118654752440 /* 1/sqrt(2) */
#endif /* !M_E */
#endif /* __USE_MISC || __USE_XOPEN || _USE_MATH_DEFINES */

/* Math constants with long-double precision. */
#if defined(__USE_GNU) && defined(__COMPILER_HAVE_LONGDOUBLE)
#ifndef M_El
#define M_El        2.718281828459045235360287471352662498L /* e */
#define M_LOG2El    1.442695040888963407359924681001892137L /* log_2 e */
#define M_LOG10El   0.434294481903251827651128918916605082L /* log_10 e */
#define M_LN2l      0.693147180559945309417232121458176568L /* log_e 2 */
#define M_LN10l     2.302585092994045684017991454684364208L /* log_e 10 */
#define M_PIl       3.141592653589793238462643383279502884L /* pi */
#define M_PI_2l     1.570796326794896619231321691639751442L /* pi/2 */
#define M_PI_4l     0.785398163397448309615660845819875721L /* pi/4 */
#define M_1_PIl     0.318309886183790671537767526745028724L /* 1/pi */
#define M_2_PIl     0.636619772367581343075535053490057448L /* 2/pi */
#define M_2_SQRTPIl 1.128379167095512573896158903121545172L /* 2/sqrt(pi) */
#define M_SQRT2l    1.414213562373095048801688724209698079L /* sqrt(2) */
#define M_SQRT1_2l  0.707106781186547524400844362104849039L /* 1/sqrt(2) */
#endif /* !M_El */
#endif /* __USE_GNU && __COMPILER_HAVE_LONGDOUBLE */


#if !defined(HUGE_VAL) && defined(__HUGE_VAL)
#define HUGE_VAL __HUGE_VAL /* double HUGE_VAL; */
#endif /* !HUGE_VAL && __HUGE_VAL */

#ifdef __USE_ISOC99
#if !defined(HUGE_VALF) && defined(__HUGE_VALF)
#define HUGE_VALF __HUGE_VALF /* double HUGE_VALF; */
#endif /* !HUGE_VALF && __HUGE_VALF */

#if !defined(HUGE_VALL) && defined(__HUGE_VALL)
#define HUGE_VALL __HUGE_VALL /* double HUGE_VALL; */
#endif /* !HUGE_VALL && __HUGE_VALL */

#if !defined(INFINITY) && defined(__INFINITYF)
#define INFINITY __INFINITYF /* float INFINITY; */
#endif /* !INFINITY && __INFINITYF */

#if !defined(NAN) && defined(__NANF)
#define NAN __NANF /* float NAN; */
#endif /* !NAN && __NANF */

/* This value is returned by `ilogb(0)'. */
#ifdef __FP_ILOGB0
#define FP_ILOGB0 __FP_ILOGB0 /* int FP_ILOGB0; */
#endif /* __FP_ILOGB0 */

/* This value is returned by `ilogb(NAN)'. */
#ifdef __FP_ILOGBNAN
#define FP_ILOGBNAN __FP_ILOGBNAN /* int FP_ILOGBNAN; */
#endif /* __FP_ILOGBNAN */

/* Define if fma(x, y, z) is at least as ~fast~ as `x * y + z' */
#ifdef __FP_FAST_FMA
#define FP_FAST_FMA 1
#endif /* __FP_FAST_FMA */

/* Define if fmaf(x, y, z) is at least as ~fast~ as `x * y + z' */
#ifdef __FP_FAST_FMAF
#define FP_FAST_FMAF 1
#endif /* __FP_FAST_FMAF */

/* Define if fmal(x, y, z) is at least as ~fast~ as `x * y + z' */
#ifdef __FP_FAST_FMAL
#define FP_FAST_FMAL 1
#endif /* __FP_FAST_FMAL */

#endif /* __USE_ISOC99 */

#if defined(__USE_GNU) || defined(__STDC_WANT_IEC_60559_BFP_EXT__)
#if !defined(SNANF) && defined(__SNANF)
#define SNANF __SNANF
#endif /* !SNANF && __SNANF */
#if !defined(SNAN) && defined(__SNAN)
#define SNAN  __SNAN
#endif /* !SNAN && __SNAN */
#if !defined(SNANL) && defined(__SNANL)
#define SNANL __SNANL
#endif /* !SNANL && __SNANL */
/* TODO: Define `__FP_LOGB0_IS_MIN' in `<bits/crt/mathdef.h>' */
#ifdef __FP_LOGB0_IS_MIN
#define FP_LLOGB0 (-__LONG_MAX__ - 1)
#else /* __FP_LOGB0_IS_MIN */
#define FP_LLOGB0 (-__LONG_MAX__)
#endif /* !__FP_LOGB0_IS_MIN */
/* TODO: Define `__FP_LOGBNAN_IS_MIN' in `<bits/crt/mathdef.h>' */
#ifdef __FP_LOGBNAN_IS_MIN
#define FP_LLOGBNAN (-__LONG_MAX__ - 1)
#else /* __FP_LOGBNAN_IS_MIN */
#define FP_LLOGBNAN __LONG_MAX__
#endif /* !__FP_LOGBNAN_IS_MIN */

/* Possible values for `round' argument of `fromfp(3)' and friends. */
#define FP_INT_UPWARD            0
#define FP_INT_DOWNWARD          1
#define FP_INT_TOWARDZERO        2
#define FP_INT_TONEARESTFROMZERO 3
#define FP_INT_TONEAREST         4
#endif /* __USE_GNU || __STDC_WANT_IEC_60559_BFP_EXT__ */

#ifdef __CC__
__SYSDECL_BEGIN

__NAMESPACE_STD_BEGIN
#if __has_builtin(__builtin_acos) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_acos)
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,acos,(double __x),{ return __builtin_acos(__x); })
#elif defined(__CRT_HAVE_acos)
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,acos,(double __x),(__x))
#elif defined(__CRT_HAVE___acos)
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,acos,(double __x),__acos,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/acos.h>
__NAMESPACE_STD_BEGIN
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(acos, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL acos)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(acos))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_asin) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_asin)
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,asin,(double __x),{ return __builtin_asin(__x); })
#elif defined(__CRT_HAVE_asin)
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,asin,(double __x),(__x))
#elif defined(__CRT_HAVE___asin)
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,asin,(double __x),__asin,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/asin.h>
__NAMESPACE_STD_BEGIN
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(asin, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL asin)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(asin))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_atan) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_atan)
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,atan,(double __x),{ return __builtin_atan(__x); })
#elif defined(__CRT_HAVE_atan)
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,atan,(double __x),(__x))
#elif defined(__CRT_HAVE___atan)
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,atan,(double __x),__atan,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/atan.h>
__NAMESPACE_STD_BEGIN
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(atan, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL atan)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(atan))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_atan2) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_atan2)
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,atan2,(double __y, double __x),{ return __builtin_atan2(__y, __x); })
#elif defined(__CRT_HAVE_atan2)
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,atan2,(double __y, double __x),(__y,__x))
#elif defined(__CRT_HAVE___atan2)
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,atan2,(double __y, double __x),__atan2,(__y,__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/atan2.h>
__NAMESPACE_STD_BEGIN
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(atan2, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL atan2)(double __y, double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(atan2))(__y, __x); })
#endif /* ... */
#if __has_builtin(__builtin_cos) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_cos)
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__CEIDECLARE(__ATTR_WUNUSED __DECL_SIMD_cos,double,__NOTHROW,cos,(double __x),{ return __builtin_cos(__x); })
#elif defined(__CRT_HAVE_cos)
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__CDECLARE(__ATTR_WUNUSED __DECL_SIMD_cos,double,__NOTHROW,cos,(double __x),(__x))
#elif defined(__CRT_HAVE___cos)
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_cos,double,__NOTHROW,cos,(double __x),__cos,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/cos.h>
__NAMESPACE_STD_BEGIN
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(cos, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_cos double __NOTHROW(__LIBCCALL cos)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(cos))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_sin) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_sin)
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__CEIDECLARE(__ATTR_WUNUSED __DECL_SIMD_sin,double,__NOTHROW,sin,(double __x),{ return __builtin_sin(__x); })
#elif defined(__CRT_HAVE_sin)
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__CDECLARE(__ATTR_WUNUSED __DECL_SIMD_sin,double,__NOTHROW,sin,(double __x),(__x))
#elif defined(__CRT_HAVE___sin)
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_sin,double,__NOTHROW,sin,(double __x),__sin,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/sin.h>
__NAMESPACE_STD_BEGIN
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(sin, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_sin double __NOTHROW(__LIBCCALL sin)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(sin))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_tan) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_tan)
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,tan,(double __x),{ return __builtin_tan(__x); })
#elif defined(__CRT_HAVE_tan)
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,tan,(double __x),(__x))
#elif defined(__CRT_HAVE___tan)
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,tan,(double __x),__tan,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/tan.h>
__NAMESPACE_STD_BEGIN
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(tan, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL tan)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(tan))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_acosf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_acosf)
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,acosf,(float __x),{ return __builtin_acosf(__x); })
#elif defined(__CRT_HAVE_acosf)
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,acosf,(float __x),(__x))
#elif defined(__CRT_HAVE___acosf)
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,acosf,(float __x),__acosf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_acos) || defined(__CRT_HAVE___acos) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/acosf.h>
__NAMESPACE_STD_BEGIN
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(acosf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL acosf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(acosf))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_asinf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_asinf)
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,asinf,(float __x),{ return __builtin_asinf(__x); })
#elif defined(__CRT_HAVE_asinf)
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,asinf,(float __x),(__x))
#elif defined(__CRT_HAVE___asinf)
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,asinf,(float __x),__asinf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_asin) || defined(__CRT_HAVE___asin) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/asinf.h>
__NAMESPACE_STD_BEGIN
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(asinf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL asinf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(asinf))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_atanf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_atanf)
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,atanf,(float __x),{ return __builtin_atanf(__x); })
#elif defined(__CRT_HAVE_atanf)
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,atanf,(float __x),(__x))
#elif defined(__CRT_HAVE___atanf)
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,atanf,(float __x),__atanf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_atan) || defined(__CRT_HAVE___atan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/atanf.h>
__NAMESPACE_STD_BEGIN
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(atanf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL atanf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(atanf))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_atan2f) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_atan2f)
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,atan2f,(float __y, float __x),{ return __builtin_atan2f(__y, __x); })
#elif defined(__CRT_HAVE_atan2f)
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,atan2f,(float __y, float __x),(__y,__x))
#elif defined(__CRT_HAVE___atan2f)
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,atan2f,(float __y, float __x),__atan2f,(__y,__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_atan2) || defined(__CRT_HAVE___atan2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/atan2f.h>
__NAMESPACE_STD_BEGIN
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(atan2f, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL atan2f)(float __y, float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(atan2f))(__y, __x); })
#endif /* ... */
#if __has_builtin(__builtin_cosf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_cosf)
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__CEIDECLARE(__ATTR_WUNUSED __DECL_SIMD_cosf,float,__NOTHROW,cosf,(float __x),{ return __builtin_cosf(__x); })
#elif defined(__CRT_HAVE_cosf)
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__CDECLARE(__ATTR_WUNUSED __DECL_SIMD_cosf,float,__NOTHROW,cosf,(float __x),(__x))
#elif defined(__CRT_HAVE___cosf)
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_cosf,float,__NOTHROW,cosf,(float __x),__cosf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_cos) || defined(__CRT_HAVE___cos) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/cosf.h>
__NAMESPACE_STD_BEGIN
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(cosf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_cosf float __NOTHROW(__LIBCCALL cosf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(cosf))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_sinf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_sinf)
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__CEIDECLARE(__ATTR_WUNUSED __DECL_SIMD_sinf,float,__NOTHROW,sinf,(float __x),{ return __builtin_sinf(__x); })
#elif defined(__CRT_HAVE_sinf)
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__CDECLARE(__ATTR_WUNUSED __DECL_SIMD_sinf,float,__NOTHROW,sinf,(float __x),(__x))
#elif defined(__CRT_HAVE___sinf)
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_sinf,float,__NOTHROW,sinf,(float __x),__sinf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_sin) || defined(__CRT_HAVE___sin) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/sinf.h>
__NAMESPACE_STD_BEGIN
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(sinf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_sinf float __NOTHROW(__LIBCCALL sinf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(sinf))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_tanf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_tanf)
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,tanf,(float __x),{ return __builtin_tanf(__x); })
#elif defined(__CRT_HAVE_tanf)
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,tanf,(float __x),(__x))
#elif defined(__CRT_HAVE___tanf)
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,tanf,(float __x),__tanf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_tan) || defined(__CRT_HAVE___tan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/tanf.h>
__NAMESPACE_STD_BEGIN
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(tanf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL tanf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(tanf))(__x); })
#endif /* ... */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if __has_builtin(__builtin_acosl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_acosl)
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,acosl,(__LONGDOUBLE __x),{ return __builtin_acosl(__x); })
#elif defined(__CRT_HAVE_acosl)
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,acosl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___acosl)
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,acosl,(__LONGDOUBLE __x),__acosl,(__x))
#elif defined(__CRT_HAVE_acos) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,acosl,(__LONGDOUBLE __x),acos,(__x))
#elif defined(__CRT_HAVE___acos) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,acosl,(__LONGDOUBLE __x),__acos,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_acos) || defined(__CRT_HAVE___acos) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/acosl.h>
__NAMESPACE_STD_BEGIN
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(acosl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL acosl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(acosl))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_asinl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_asinl)
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,asinl,(__LONGDOUBLE __x),{ return __builtin_asinl(__x); })
#elif defined(__CRT_HAVE_asinl)
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,asinl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___asinl)
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,asinl,(__LONGDOUBLE __x),__asinl,(__x))
#elif defined(__CRT_HAVE_asin) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,asinl,(__LONGDOUBLE __x),asin,(__x))
#elif defined(__CRT_HAVE___asin) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,asinl,(__LONGDOUBLE __x),__asin,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_asin) || defined(__CRT_HAVE___asin) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/asinl.h>
__NAMESPACE_STD_BEGIN
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(asinl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL asinl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(asinl))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_atanl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_atanl)
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,atanl,(__LONGDOUBLE __x),{ return __builtin_atanl(__x); })
#elif defined(__CRT_HAVE_atanl)
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,atanl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___atanl)
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,atanl,(__LONGDOUBLE __x),__atanl,(__x))
#elif defined(__CRT_HAVE_atan) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,atanl,(__LONGDOUBLE __x),atan,(__x))
#elif defined(__CRT_HAVE___atan) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,atanl,(__LONGDOUBLE __x),__atan,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_atan) || defined(__CRT_HAVE___atan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/atanl.h>
__NAMESPACE_STD_BEGIN
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(atanl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL atanl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(atanl))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_atan2l) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_atan2l)
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,atan2l,(__LONGDOUBLE __y, __LONGDOUBLE __x),{ return __builtin_atan2l(__y, __x); })
#elif defined(__CRT_HAVE_atan2l)
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,atan2l,(__LONGDOUBLE __y, __LONGDOUBLE __x),(__y,__x))
#elif defined(__CRT_HAVE___atan2l)
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,atan2l,(__LONGDOUBLE __y, __LONGDOUBLE __x),__atan2l,(__y,__x))
#elif defined(__CRT_HAVE_atan2) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,atan2l,(__LONGDOUBLE __y, __LONGDOUBLE __x),atan2,(__y,__x))
#elif defined(__CRT_HAVE___atan2) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,atan2l,(__LONGDOUBLE __y, __LONGDOUBLE __x),__atan2,(__y,__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_atan2) || defined(__CRT_HAVE___atan2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/atan2l.h>
__NAMESPACE_STD_BEGIN
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(atan2l, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL atan2l)(__LONGDOUBLE __y, __LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(atan2l))(__y, __x); })
#endif /* ... */
#if __has_builtin(__builtin_cosl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_cosl)
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__CEIDECLARE(__ATTR_WUNUSED __DECL_SIMD_cosl,__LONGDOUBLE,__NOTHROW,cosl,(__LONGDOUBLE __x),{ return __builtin_cosl(__x); })
#elif defined(__CRT_HAVE_cosl)
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__CDECLARE(__ATTR_WUNUSED __DECL_SIMD_cosl,__LONGDOUBLE,__NOTHROW,cosl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___cosl)
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_cosl,__LONGDOUBLE,__NOTHROW,cosl,(__LONGDOUBLE __x),__cosl,(__x))
#elif defined(__CRT_HAVE_cos) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_cosl,__LONGDOUBLE,__NOTHROW,cosl,(__LONGDOUBLE __x),cos,(__x))
#elif defined(__CRT_HAVE___cos) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_cosl,__LONGDOUBLE,__NOTHROW,cosl,(__LONGDOUBLE __x),__cos,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_cos) || defined(__CRT_HAVE___cos) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/cosl.h>
__NAMESPACE_STD_BEGIN
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(cosl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_cosl __LONGDOUBLE __NOTHROW(__LIBCCALL cosl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(cosl))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_sinl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_sinl)
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__CEIDECLARE(__ATTR_WUNUSED __DECL_SIMD_sinl,__LONGDOUBLE,__NOTHROW,sinl,(__LONGDOUBLE __x),{ return __builtin_sinl(__x); })
#elif defined(__CRT_HAVE_sinl)
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__CDECLARE(__ATTR_WUNUSED __DECL_SIMD_sinl,__LONGDOUBLE,__NOTHROW,sinl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___sinl)
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_sinl,__LONGDOUBLE,__NOTHROW,sinl,(__LONGDOUBLE __x),__sinl,(__x))
#elif defined(__CRT_HAVE_sin) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_sinl,__LONGDOUBLE,__NOTHROW,sinl,(__LONGDOUBLE __x),sin,(__x))
#elif defined(__CRT_HAVE___sin) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_sinl,__LONGDOUBLE,__NOTHROW,sinl,(__LONGDOUBLE __x),__sin,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_sin) || defined(__CRT_HAVE___sin) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/sinl.h>
__NAMESPACE_STD_BEGIN
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(sinl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_sinl __LONGDOUBLE __NOTHROW(__LIBCCALL sinl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(sinl))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_tanl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_tanl)
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,tanl,(__LONGDOUBLE __x),{ return __builtin_tanl(__x); })
#elif defined(__CRT_HAVE_tanl)
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,tanl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___tanl)
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,tanl,(__LONGDOUBLE __x),__tanl,(__x))
#elif defined(__CRT_HAVE_tan) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,tanl,(__LONGDOUBLE __x),tan,(__x))
#elif defined(__CRT_HAVE___tan) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,tanl,(__LONGDOUBLE __x),__tan,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_tan) || defined(__CRT_HAVE___tan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/tanl.h>
__NAMESPACE_STD_BEGIN
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(tanl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL tanl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(tanl))(__x); })
#endif /* ... */
#endif /* __COMPILER_HAVE_LONGDOUBLE */

/* Hyperbolic functions. */
#if __has_builtin(__builtin_cosh) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_cosh)
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,cosh,(double __x),{ return __builtin_cosh(__x); })
#elif defined(__CRT_HAVE_cosh)
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,cosh,(double __x),(__x))
#elif defined(__CRT_HAVE___cosh)
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,cosh,(double __x),__cosh,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/cosh.h>
__NAMESPACE_STD_BEGIN
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(cosh, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL cosh)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(cosh))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_sinh) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_sinh)
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,sinh,(double __x),{ return __builtin_sinh(__x); })
#elif defined(__CRT_HAVE_sinh)
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,sinh,(double __x),(__x))
#elif defined(__CRT_HAVE___sinh)
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,sinh,(double __x),__sinh,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/sinh.h>
__NAMESPACE_STD_BEGIN
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(sinh, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL sinh)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(sinh))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_tanh) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_tanh)
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,tanh,(double __x),{ return __builtin_tanh(__x); })
#elif defined(__CRT_HAVE_tanh)
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,tanh,(double __x),(__x))
#elif defined(__CRT_HAVE___tanh)
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,tanh,(double __x),__tanh,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/tanh.h>
__NAMESPACE_STD_BEGIN
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(tanh, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL tanh)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(tanh))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_coshf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_coshf)
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,coshf,(float __x),{ return __builtin_coshf(__x); })
#elif defined(__CRT_HAVE_coshf)
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,coshf,(float __x),(__x))
#elif defined(__CRT_HAVE___coshf)
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,coshf,(float __x),__coshf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_cosh) || defined(__CRT_HAVE___cosh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/coshf.h>
__NAMESPACE_STD_BEGIN
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(coshf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL coshf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(coshf))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_sinhf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_sinhf)
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,sinhf,(float __x),{ return __builtin_sinhf(__x); })
#elif defined(__CRT_HAVE_sinhf)
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,sinhf,(float __x),(__x))
#elif defined(__CRT_HAVE___sinhf)
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,sinhf,(float __x),__sinhf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_sinh) || defined(__CRT_HAVE___sinh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/sinhf.h>
__NAMESPACE_STD_BEGIN
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(sinhf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL sinhf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(sinhf))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_tanhf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_tanhf)
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,tanhf,(float __x),{ return __builtin_tanhf(__x); })
#elif defined(__CRT_HAVE_tanhf)
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,tanhf,(float __x),(__x))
#elif defined(__CRT_HAVE___tanhf)
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,tanhf,(float __x),__tanhf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_tanh) || defined(__CRT_HAVE___tanh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/tanhf.h>
__NAMESPACE_STD_BEGIN
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(tanhf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL tanhf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(tanhf))(__x); })
#endif /* ... */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if __has_builtin(__builtin_coshl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_coshl)
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,coshl,(__LONGDOUBLE __x),{ return __builtin_coshl(__x); })
#elif defined(__CRT_HAVE_coshl)
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,coshl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___coshl)
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,coshl,(__LONGDOUBLE __x),__coshl,(__x))
#elif defined(__CRT_HAVE_cosh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,coshl,(__LONGDOUBLE __x),cosh,(__x))
#elif defined(__CRT_HAVE___cosh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,coshl,(__LONGDOUBLE __x),__cosh,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_cosh) || defined(__CRT_HAVE___cosh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/coshl.h>
__NAMESPACE_STD_BEGIN
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(coshl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL coshl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(coshl))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_sinhl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_sinhl)
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,sinhl,(__LONGDOUBLE __x),{ return __builtin_sinhl(__x); })
#elif defined(__CRT_HAVE_sinhl)
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,sinhl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___sinhl)
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,sinhl,(__LONGDOUBLE __x),__sinhl,(__x))
#elif defined(__CRT_HAVE_sinh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,sinhl,(__LONGDOUBLE __x),sinh,(__x))
#elif defined(__CRT_HAVE___sinh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,sinhl,(__LONGDOUBLE __x),__sinh,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_sinh) || defined(__CRT_HAVE___sinh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/sinhl.h>
__NAMESPACE_STD_BEGIN
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(sinhl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL sinhl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(sinhl))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_tanhl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_tanhl)
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,tanhl,(__LONGDOUBLE __x),{ return __builtin_tanhl(__x); })
#elif defined(__CRT_HAVE_tanhl)
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,tanhl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___tanhl)
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,tanhl,(__LONGDOUBLE __x),__tanhl,(__x))
#elif defined(__CRT_HAVE_tanh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,tanhl,(__LONGDOUBLE __x),tanh,(__x))
#elif defined(__CRT_HAVE___tanh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,tanhl,(__LONGDOUBLE __x),__tanh,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_tanh) || defined(__CRT_HAVE___tanh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/tanhl.h>
__NAMESPACE_STD_BEGIN
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(tanhl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL tanhl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(tanhl))(__x); })
#endif /* ... */
#endif /* __COMPILER_HAVE_LONGDOUBLE */

#if defined(__USE_XOPEN_EXTENDED) || defined(__USE_ISOC99)
#if __has_builtin(__builtin_acosh) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_acosh)
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,acosh,(double __x),{ return __builtin_acosh(__x); })
#elif defined(__CRT_HAVE_acosh)
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,acosh,(double __x),(__x))
#elif defined(__CRT_HAVE___acosh)
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,acosh,(double __x),__acosh,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/acosh.h>
__NAMESPACE_STD_BEGIN
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(acosh, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL acosh)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(acosh))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_asinh) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_asinh)
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,asinh,(double __x),{ return __builtin_asinh(__x); })
#elif defined(__CRT_HAVE_asinh)
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,asinh,(double __x),(__x))
#elif defined(__CRT_HAVE___asinh)
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,asinh,(double __x),__asinh,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/asinh.h>
__NAMESPACE_STD_BEGIN
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(asinh, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL asinh)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(asinh))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_atanh) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_atanh)
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,atanh,(double __x),{ return __builtin_atanh(__x); })
#elif defined(__CRT_HAVE_atanh)
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,atanh,(double __x),(__x))
#elif defined(__CRT_HAVE___atanh)
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,atanh,(double __x),__atanh,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/atanh.h>
__NAMESPACE_STD_BEGIN
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(atanh, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL atanh)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(atanh))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_acoshf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_acoshf)
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,acoshf,(float __x),{ return __builtin_acoshf(__x); })
#elif defined(__CRT_HAVE_acoshf)
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,acoshf,(float __x),(__x))
#elif defined(__CRT_HAVE___acoshf)
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,acoshf,(float __x),__acoshf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_acosh) || defined(__CRT_HAVE___acosh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/acoshf.h>
__NAMESPACE_STD_BEGIN
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(acoshf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL acoshf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(acoshf))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_asinhf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_asinhf)
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,asinhf,(float __x),{ return __builtin_asinhf(__x); })
#elif defined(__CRT_HAVE_asinhf)
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,asinhf,(float __x),(__x))
#elif defined(__CRT_HAVE___asinhf)
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,asinhf,(float __x),__asinhf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_asinh) || defined(__CRT_HAVE___asinh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/asinhf.h>
__NAMESPACE_STD_BEGIN
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(asinhf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL asinhf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(asinhf))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_atanhf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_atanhf)
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,atanhf,(float __x),{ return __builtin_atanhf(__x); })
#elif defined(__CRT_HAVE_atanhf)
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,atanhf,(float __x),(__x))
#elif defined(__CRT_HAVE___atanhf)
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,atanhf,(float __x),__atanhf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_atanh) || defined(__CRT_HAVE___atanh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/atanhf.h>
__NAMESPACE_STD_BEGIN
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(atanhf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL atanhf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(atanhf))(__x); })
#endif /* ... */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if __has_builtin(__builtin_acoshl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_acoshl)
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,acoshl,(__LONGDOUBLE __x),{ return __builtin_acoshl(__x); })
#elif defined(__CRT_HAVE_acoshl)
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,acoshl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___acoshl)
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,acoshl,(__LONGDOUBLE __x),__acoshl,(__x))
#elif defined(__CRT_HAVE_acosh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,acoshl,(__LONGDOUBLE __x),acosh,(__x))
#elif defined(__CRT_HAVE___acosh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,acoshl,(__LONGDOUBLE __x),__acosh,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_acosh) || defined(__CRT_HAVE___acosh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/acoshl.h>
__NAMESPACE_STD_BEGIN
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(acoshl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL acoshl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(acoshl))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_asinhl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_asinhl)
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,asinhl,(__LONGDOUBLE __x),{ return __builtin_asinhl(__x); })
#elif defined(__CRT_HAVE_asinhl)
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,asinhl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___asinhl)
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,asinhl,(__LONGDOUBLE __x),__asinhl,(__x))
#elif defined(__CRT_HAVE_asinh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,asinhl,(__LONGDOUBLE __x),asinh,(__x))
#elif defined(__CRT_HAVE___asinh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,asinhl,(__LONGDOUBLE __x),__asinh,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_asinh) || defined(__CRT_HAVE___asinh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/asinhl.h>
__NAMESPACE_STD_BEGIN
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(asinhl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL asinhl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(asinhl))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_atanhl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_atanhl)
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,atanhl,(__LONGDOUBLE __x),{ return __builtin_atanhl(__x); })
#elif defined(__CRT_HAVE_atanhl)
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,atanhl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___atanhl)
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,atanhl,(__LONGDOUBLE __x),__atanhl,(__x))
#elif defined(__CRT_HAVE_atanh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,atanhl,(__LONGDOUBLE __x),atanh,(__x))
#elif defined(__CRT_HAVE___atanh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,atanhl,(__LONGDOUBLE __x),__atanh,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_atanh) || defined(__CRT_HAVE___atanh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/atanhl.h>
__NAMESPACE_STD_BEGIN
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(atanhl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL atanhl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(atanhl))(__x); })
#endif /* ... */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_XOPEN_EXTENDED || __USE_ISOC99 */

/* Exponential and logarithmic functions. */
#if __has_builtin(__builtin_exp) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_exp)
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__CEIDECLARE(__ATTR_WUNUSED __DECL_SIMD_exp,double,__NOTHROW,exp,(double __x),{ return __builtin_exp(__x); })
#elif defined(__CRT_HAVE_exp)
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__CDECLARE(__ATTR_WUNUSED __DECL_SIMD_exp,double,__NOTHROW,exp,(double __x),(__x))
#elif defined(__CRT_HAVE___exp)
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_exp,double,__NOTHROW,exp,(double __x),__exp,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/exp.h>
__NAMESPACE_STD_BEGIN
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(exp, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_exp double __NOTHROW(__LIBCCALL exp)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(exp))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_frexp) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_frexp)
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__CEIDECLARE(__ATTR_OUT(2),double,__NOTHROW_NCX,frexp,(double __x, int *__pexponent),{ return __builtin_frexp(__x, __pexponent); })
#elif defined(__CRT_HAVE_frexp)
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__CDECLARE(__ATTR_OUT(2),double,__NOTHROW_NCX,frexp,(double __x, int *__pexponent),(__x,__pexponent))
#elif defined(__CRT_HAVE___frexp)
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__CREDIRECT(__ATTR_OUT(2),double,__NOTHROW_NCX,frexp,(double __x, int *__pexponent),__frexp,(__x,__pexponent))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/frexp.h>
__NAMESPACE_STD_BEGIN
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__NAMESPACE_LOCAL_USING_OR_IMPL(frexp, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_OUT(2) double __NOTHROW_NCX(__LIBCCALL frexp)(double __x, int *__pexponent) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(frexp))(__x, __pexponent); })
#endif /* ... */
#if __has_builtin(__builtin_ldexp) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_ldexp)
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,ldexp,(double __x, int __exponent),{ return __builtin_ldexp(__x, __exponent); })
#elif defined(__CRT_HAVE_ldexp)
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,ldexp,(double __x, int __exponent),(__x,__exponent))
#elif defined(__CRT_HAVE___ldexp)
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,ldexp,(double __x, int __exponent),__ldexp,(__x,__exponent))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/ldexp.h>
__NAMESPACE_STD_BEGIN
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__NAMESPACE_LOCAL_USING_OR_IMPL(ldexp, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL ldexp)(double __x, int __exponent) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(ldexp))(__x, __exponent); })
#endif /* ... */
#if __has_builtin(__builtin_log) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_log)
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__CEIDECLARE(__ATTR_WUNUSED __DECL_SIMD_log,double,__NOTHROW,log,(double __x),{ return __builtin_log(__x); })
#elif defined(__CRT_HAVE_log)
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__CDECLARE(__ATTR_WUNUSED __DECL_SIMD_log,double,__NOTHROW,log,(double __x),(__x))
#elif defined(__CRT_HAVE___log)
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_log,double,__NOTHROW,log,(double __x),__log,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/log.h>
__NAMESPACE_STD_BEGIN
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(log, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_log double __NOTHROW(__LIBCCALL log)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(log))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_log10) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_log10)
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,log10,(double __x),{ return __builtin_log10(__x); })
#elif defined(__CRT_HAVE_log10)
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,log10,(double __x),(__x))
#elif defined(__CRT_HAVE___log10)
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,log10,(double __x),__log10,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/log10.h>
__NAMESPACE_STD_BEGIN
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(log10, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL log10)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(log10))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_modf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_modf)
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__CEIDECLARE(__ATTR_WUNUSED __ATTR_OUT(2),double,__NOTHROW_NCX,modf,(double __x, double *__iptr),{ return __builtin_modf(__x, __iptr); })
#elif defined(__CRT_HAVE_modf)
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__CDECLARE(__ATTR_WUNUSED __ATTR_OUT(2),double,__NOTHROW_NCX,modf,(double __x, double *__iptr),(__x,__iptr))
#elif defined(__CRT_HAVE___modf)
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(2),double,__NOTHROW_NCX,modf,(double __x, double *__iptr),__modf,(__x,__iptr))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/modf.h>
__NAMESPACE_STD_BEGIN
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__NAMESPACE_LOCAL_USING_OR_IMPL(modf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __ATTR_OUT(2) double __NOTHROW_NCX(__LIBCCALL modf)(double __x, double *__iptr) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(modf))(__x, __iptr); })
#endif /* ... */
#if __has_builtin(__builtin_expf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_expf)
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__CEIDECLARE(__ATTR_WUNUSED __DECL_SIMD_expf,float,__NOTHROW,expf,(float __x),{ return __builtin_expf(__x); })
#elif defined(__CRT_HAVE_expf)
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__CDECLARE(__ATTR_WUNUSED __DECL_SIMD_expf,float,__NOTHROW,expf,(float __x),(__x))
#elif defined(__CRT_HAVE___expf)
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_expf,float,__NOTHROW,expf,(float __x),__expf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_exp) || defined(__CRT_HAVE___exp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/expf.h>
__NAMESPACE_STD_BEGIN
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(expf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_expf float __NOTHROW(__LIBCCALL expf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(expf))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_frexpf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_frexpf)
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__CEIDECLARE(__ATTR_OUT(2),float,__NOTHROW_NCX,frexpf,(float __x, int *__pexponent),{ return __builtin_frexpf(__x, __pexponent); })
#elif defined(__CRT_HAVE_frexpf)
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__CDECLARE(__ATTR_OUT(2),float,__NOTHROW_NCX,frexpf,(float __x, int *__pexponent),(__x,__pexponent))
#elif defined(__CRT_HAVE___frexpf)
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__CREDIRECT(__ATTR_OUT(2),float,__NOTHROW_NCX,frexpf,(float __x, int *__pexponent),__frexpf,(__x,__pexponent))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_frexp) || defined(__CRT_HAVE___frexp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/frexpf.h>
__NAMESPACE_STD_BEGIN
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__NAMESPACE_LOCAL_USING_OR_IMPL(frexpf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_OUT(2) float __NOTHROW_NCX(__LIBCCALL frexpf)(float __x, int *__pexponent) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(frexpf))(__x, __pexponent); })
#endif /* ... */
#if __has_builtin(__builtin_ldexpf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_ldexpf)
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,ldexpf,(float __x, int __exponent),{ return __builtin_ldexpf(__x, __exponent); })
#elif defined(__CRT_HAVE_ldexpf)
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,ldexpf,(float __x, int __exponent),(__x,__exponent))
#elif defined(__CRT_HAVE___ldexpf)
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,ldexpf,(float __x, int __exponent),__ldexpf,(__x,__exponent))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_ldexp) || defined(__CRT_HAVE___ldexp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/ldexpf.h>
__NAMESPACE_STD_BEGIN
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__NAMESPACE_LOCAL_USING_OR_IMPL(ldexpf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL ldexpf)(float __x, int __exponent) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(ldexpf))(__x, __exponent); })
#endif /* ... */
#if __has_builtin(__builtin_logf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_logf)
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__CEIDECLARE(__ATTR_WUNUSED __DECL_SIMD_logf,float,__NOTHROW,logf,(float __x),{ return __builtin_logf(__x); })
#elif defined(__CRT_HAVE_logf)
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__CDECLARE(__ATTR_WUNUSED __DECL_SIMD_logf,float,__NOTHROW,logf,(float __x),(__x))
#elif defined(__CRT_HAVE___logf)
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_logf,float,__NOTHROW,logf,(float __x),__logf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_log) || defined(__CRT_HAVE___log) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/logf.h>
__NAMESPACE_STD_BEGIN
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(logf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_logf float __NOTHROW(__LIBCCALL logf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(logf))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_log10f) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_log10f)
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,log10f,(float __x),{ return __builtin_log10f(__x); })
#elif defined(__CRT_HAVE_log10f)
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,log10f,(float __x),(__x))
#elif defined(__CRT_HAVE___log10f)
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,log10f,(float __x),__log10f,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_log10) || defined(__CRT_HAVE___log10) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/log10f.h>
__NAMESPACE_STD_BEGIN
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(log10f, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL log10f)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(log10f))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_modff) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_modff)
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__CEIDECLARE(__ATTR_WUNUSED __ATTR_OUT(2),float,__NOTHROW_NCX,modff,(float __x, float *__iptr),{ return __builtin_modff(__x, __iptr); })
#elif defined(__CRT_HAVE_modff)
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__CDECLARE(__ATTR_WUNUSED __ATTR_OUT(2),float,__NOTHROW_NCX,modff,(float __x, float *__iptr),(__x,__iptr))
#elif defined(__CRT_HAVE___modff)
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(2),float,__NOTHROW_NCX,modff,(float __x, float *__iptr),__modff,(__x,__iptr))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_modf) || defined(__CRT_HAVE___modf) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/modff.h>
__NAMESPACE_STD_BEGIN
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__NAMESPACE_LOCAL_USING_OR_IMPL(modff, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __ATTR_OUT(2) float __NOTHROW_NCX(__LIBCCALL modff)(float __x, float *__iptr) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(modff))(__x, __iptr); })
#endif /* ... */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if __has_builtin(__builtin_expl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_expl)
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__CEIDECLARE(__ATTR_WUNUSED __DECL_SIMD_expl,__LONGDOUBLE,__NOTHROW,expl,(__LONGDOUBLE __x),{ return __builtin_expl(__x); })
#elif defined(__CRT_HAVE_expl)
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__CDECLARE(__ATTR_WUNUSED __DECL_SIMD_expl,__LONGDOUBLE,__NOTHROW,expl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___expl)
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_expl,__LONGDOUBLE,__NOTHROW,expl,(__LONGDOUBLE __x),__expl,(__x))
#elif defined(__CRT_HAVE_exp) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_expl,__LONGDOUBLE,__NOTHROW,expl,(__LONGDOUBLE __x),exp,(__x))
#elif defined(__CRT_HAVE___exp) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_expl,__LONGDOUBLE,__NOTHROW,expl,(__LONGDOUBLE __x),__exp,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_exp) || defined(__CRT_HAVE___exp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/expl.h>
__NAMESPACE_STD_BEGIN
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(expl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_expl __LONGDOUBLE __NOTHROW(__LIBCCALL expl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(expl))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_frexpl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_frexpl)
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__CEIDECLARE(__ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,frexpl,(__LONGDOUBLE __x, int *__pexponent),{ return __builtin_frexpl(__x, __pexponent); })
#elif defined(__CRT_HAVE_frexpl)
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__CDECLARE(__ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,frexpl,(__LONGDOUBLE __x, int *__pexponent),(__x,__pexponent))
#elif defined(__CRT_HAVE___frexpl)
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__CREDIRECT(__ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,frexpl,(__LONGDOUBLE __x, int *__pexponent),__frexpl,(__x,__pexponent))
#elif defined(__CRT_HAVE_frexp) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__CREDIRECT(__ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,frexpl,(__LONGDOUBLE __x, int *__pexponent),frexp,(__x,__pexponent))
#elif defined(__CRT_HAVE___frexp) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__CREDIRECT(__ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,frexpl,(__LONGDOUBLE __x, int *__pexponent),__frexp,(__x,__pexponent))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_frexp) || defined(__CRT_HAVE___frexp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/frexpl.h>
__NAMESPACE_STD_BEGIN
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__NAMESPACE_LOCAL_USING_OR_IMPL(frexpl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_OUT(2) __LONGDOUBLE __NOTHROW_NCX(__LIBCCALL frexpl)(__LONGDOUBLE __x, int *__pexponent) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(frexpl))(__x, __pexponent); })
#endif /* ... */
#if __has_builtin(__builtin_ldexpl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_ldexpl)
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,ldexpl,(__LONGDOUBLE __x, int __exponent),{ return __builtin_ldexpl(__x, __exponent); })
#elif defined(__CRT_HAVE_ldexpl)
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,ldexpl,(__LONGDOUBLE __x, int __exponent),(__x,__exponent))
#elif defined(__CRT_HAVE___ldexpl)
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,ldexpl,(__LONGDOUBLE __x, int __exponent),__ldexpl,(__x,__exponent))
#elif defined(__CRT_HAVE_ldexp) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,ldexpl,(__LONGDOUBLE __x, int __exponent),ldexp,(__x,__exponent))
#elif defined(__CRT_HAVE___ldexp) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,ldexpl,(__LONGDOUBLE __x, int __exponent),__ldexp,(__x,__exponent))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_ldexp) || defined(__CRT_HAVE___ldexp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/ldexpl.h>
__NAMESPACE_STD_BEGIN
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__NAMESPACE_LOCAL_USING_OR_IMPL(ldexpl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL ldexpl)(__LONGDOUBLE __x, int __exponent) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(ldexpl))(__x, __exponent); })
#endif /* ... */
#if __has_builtin(__builtin_logl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_logl)
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__CEIDECLARE(__ATTR_WUNUSED __DECL_SIMD_logl,__LONGDOUBLE,__NOTHROW,logl,(__LONGDOUBLE __x),{ return __builtin_logl(__x); })
#elif defined(__CRT_HAVE_logl)
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__CDECLARE(__ATTR_WUNUSED __DECL_SIMD_logl,__LONGDOUBLE,__NOTHROW,logl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___logl)
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_logl,__LONGDOUBLE,__NOTHROW,logl,(__LONGDOUBLE __x),__logl,(__x))
#elif defined(__CRT_HAVE_log) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_logl,__LONGDOUBLE,__NOTHROW,logl,(__LONGDOUBLE __x),log,(__x))
#elif defined(__CRT_HAVE___log) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_logl,__LONGDOUBLE,__NOTHROW,logl,(__LONGDOUBLE __x),__log,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_log) || defined(__CRT_HAVE___log) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/logl.h>
__NAMESPACE_STD_BEGIN
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(logl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_logl __LONGDOUBLE __NOTHROW(__LIBCCALL logl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(logl))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_log10l) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_log10l)
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,log10l,(__LONGDOUBLE __x),{ return __builtin_log10l(__x); })
#elif defined(__CRT_HAVE_log10l)
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,log10l,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___log10l)
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,log10l,(__LONGDOUBLE __x),__log10l,(__x))
#elif defined(__CRT_HAVE_log10) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,log10l,(__LONGDOUBLE __x),log10,(__x))
#elif defined(__CRT_HAVE___log10) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,log10l,(__LONGDOUBLE __x),__log10,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_log10) || defined(__CRT_HAVE___log10) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/log10l.h>
__NAMESPACE_STD_BEGIN
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(log10l, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL log10l)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(log10l))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_modfl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_modfl)
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__CEIDECLARE(__ATTR_WUNUSED __ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,modfl,(__LONGDOUBLE __x, __LONGDOUBLE *__iptr),{ return __builtin_modfl(__x, __iptr); })
#elif defined(__CRT_HAVE_modfl)
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__CDECLARE(__ATTR_WUNUSED __ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,modfl,(__LONGDOUBLE __x, __LONGDOUBLE *__iptr),(__x,__iptr))
#elif defined(__CRT_HAVE___modfl)
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,modfl,(__LONGDOUBLE __x, __LONGDOUBLE *__iptr),__modfl,(__x,__iptr))
#elif defined(__CRT_HAVE_modf) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,modfl,(__LONGDOUBLE __x, __LONGDOUBLE *__iptr),modf,(__x,__iptr))
#elif defined(__CRT_HAVE___modf) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,modfl,(__LONGDOUBLE __x, __LONGDOUBLE *__iptr),__modf,(__x,__iptr))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_modf) || defined(__CRT_HAVE___modf) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/modfl.h>
__NAMESPACE_STD_BEGIN
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__NAMESPACE_LOCAL_USING_OR_IMPL(modfl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __ATTR_OUT(2) __LONGDOUBLE __NOTHROW_NCX(__LIBCCALL modfl)(__LONGDOUBLE __x, __LONGDOUBLE *__iptr) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(modfl))(__x, __iptr); })
#endif /* ... */
#endif /* __COMPILER_HAVE_LONGDOUBLE */

#if defined(__USE_XOPEN_EXTENDED) || defined(__USE_ISOC99)
#if __has_builtin(__builtin_expm1) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_expm1)
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,expm1,(double __x),{ return __builtin_expm1(__x); })
#elif defined(__CRT_HAVE_expm1)
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,expm1,(double __x),(__x))
#elif defined(__CRT_HAVE___expm1)
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,expm1,(double __x),__expm1,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/expm1.h>
__NAMESPACE_STD_BEGIN
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__NAMESPACE_LOCAL_USING_OR_IMPL(expm1, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL expm1)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(expm1))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_log1p) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_log1p)
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,log1p,(double __x),{ return __builtin_log1p(__x); })
#elif defined(__CRT_HAVE_log1p)
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,log1p,(double __x),(__x))
#elif defined(__CRT_HAVE___log1p)
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,log1p,(double __x),__log1p,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/log1p.h>
__NAMESPACE_STD_BEGIN
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__NAMESPACE_LOCAL_USING_OR_IMPL(log1p, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL log1p)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(log1p))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_logb) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_logb)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,logb,(double __x),{ return __builtin_logb(__x); })
#elif defined(__CRT_HAVE_logb)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,logb,(double __x),(__x))
#elif defined(__CRT_HAVE___logb)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,logb,(double __x),__logb,(__x))
#elif defined(__CRT_HAVE__logb)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,logb,(double __x),_logb,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/logb.h>
__NAMESPACE_STD_BEGIN
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(logb, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL logb)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(logb))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_expm1f) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_expm1f)
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,expm1f,(float __x),{ return __builtin_expm1f(__x); })
#elif defined(__CRT_HAVE_expm1f)
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,expm1f,(float __x),(__x))
#elif defined(__CRT_HAVE___expm1f)
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,expm1f,(float __x),__expm1f,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_expm1) || defined(__CRT_HAVE___expm1) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/expm1f.h>
__NAMESPACE_STD_BEGIN
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__NAMESPACE_LOCAL_USING_OR_IMPL(expm1f, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL expm1f)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(expm1f))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_log1pf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_log1pf)
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,log1pf,(float __x),{ return __builtin_log1pf(__x); })
#elif defined(__CRT_HAVE_log1pf)
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,log1pf,(float __x),(__x))
#elif defined(__CRT_HAVE___log1pf)
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,log1pf,(float __x),__log1pf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_log1p) || defined(__CRT_HAVE___log1p) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/log1pf.h>
__NAMESPACE_STD_BEGIN
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__NAMESPACE_LOCAL_USING_OR_IMPL(log1pf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL log1pf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(log1pf))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_logbf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_logbf)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,logbf,(float __x),{ return __builtin_logbf(__x); })
#elif defined(__CRT_HAVE_logbf)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,logbf,(float __x),(__x))
#elif defined(__CRT_HAVE___logbf)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,logbf,(float __x),__logbf,(__x))
#elif defined(__CRT_HAVE__logbf)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,logbf,(float __x),_logbf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_logb) || defined(__CRT_HAVE___logb) || defined(__CRT_HAVE__logb) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/logbf.h>
__NAMESPACE_STD_BEGIN
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(logbf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL logbf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(logbf))(__x); })
#endif /* ... */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if __has_builtin(__builtin_expm1l) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_expm1l)
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,expm1l,(__LONGDOUBLE __x),{ return __builtin_expm1l(__x); })
#elif defined(__CRT_HAVE_expm1l)
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,expm1l,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___expm1l)
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,expm1l,(__LONGDOUBLE __x),__expm1l,(__x))
#elif defined(__CRT_HAVE_expm1) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,expm1l,(__LONGDOUBLE __x),expm1,(__x))
#elif defined(__CRT_HAVE___expm1) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,expm1l,(__LONGDOUBLE __x),__expm1,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_expm1) || defined(__CRT_HAVE___expm1) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/expm1l.h>
__NAMESPACE_STD_BEGIN
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__NAMESPACE_LOCAL_USING_OR_IMPL(expm1l, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL expm1l)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(expm1l))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_log1pl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_log1pl)
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,log1pl,(__LONGDOUBLE __x),{ return __builtin_log1pl(__x); })
#elif defined(__CRT_HAVE_log1pl)
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,log1pl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___log1pl)
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,log1pl,(__LONGDOUBLE __x),__log1pl,(__x))
#elif defined(__CRT_HAVE_log1p) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,log1pl,(__LONGDOUBLE __x),log1p,(__x))
#elif defined(__CRT_HAVE___log1p) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,log1pl,(__LONGDOUBLE __x),__log1p,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_log1p) || defined(__CRT_HAVE___log1p) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/log1pl.h>
__NAMESPACE_STD_BEGIN
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__NAMESPACE_LOCAL_USING_OR_IMPL(log1pl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL log1pl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(log1pl))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_logbl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_logbl)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,logbl,(__LONGDOUBLE __x),{ return __builtin_logbl(__x); })
#elif defined(__CRT_HAVE_logbl)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,logbl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___logbl)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,logbl,(__LONGDOUBLE __x),__logbl,(__x))
#elif defined(__CRT_HAVE_logb) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,logbl,(__LONGDOUBLE __x),logb,(__x))
#elif defined(__CRT_HAVE___logb) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,logbl,(__LONGDOUBLE __x),__logb,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_logb) || defined(__CRT_HAVE___logb) || defined(__CRT_HAVE__logb) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/logbl.h>
__NAMESPACE_STD_BEGIN
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(logbl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL logbl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(logbl))(__x); })
#endif /* ... */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_XOPEN_EXTENDED || __USE_ISOC99 */

#ifdef __USE_ISOC99
#if __has_builtin(__builtin_exp2) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_exp2)
/* >> exp2f(3), exp2(3), exp2l(3)
 * Compute base-2 exponential of `x' */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,exp2,(double __x),{ return __builtin_exp2(__x); })
#elif defined(__CRT_HAVE_exp2)
/* >> exp2f(3), exp2(3), exp2l(3)
 * Compute base-2 exponential of `x' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,exp2,(double __x),(__x))
#elif defined(__CRT_HAVE___exp2)
/* >> exp2f(3), exp2(3), exp2l(3)
 * Compute base-2 exponential of `x' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,exp2,(double __x),__exp2,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/exp2.h>
__NAMESPACE_STD_BEGIN
/* >> exp2f(3), exp2(3), exp2l(3)
 * Compute base-2 exponential of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(exp2, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL exp2)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(exp2))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_log2) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_log2)
/* >> log2f(3), log2(3), log2l(3)
 * Compute base-2 logarithm of `x' */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,log2,(double __x),{ return __builtin_log2(__x); })
#elif defined(__CRT_HAVE_log2)
/* >> log2f(3), log2(3), log2l(3)
 * Compute base-2 logarithm of `x' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,log2,(double __x),(__x))
#elif defined(__CRT_HAVE___log2)
/* >> log2f(3), log2(3), log2l(3)
 * Compute base-2 logarithm of `x' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,log2,(double __x),__log2,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/log2.h>
__NAMESPACE_STD_BEGIN
/* >> log2f(3), log2(3), log2l(3)
 * Compute base-2 logarithm of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(log2, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL log2)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(log2))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_exp2f) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_exp2f)
/* >> exp2f(3), exp2(3), exp2l(3)
 * Compute base-2 exponential of `x' */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,exp2f,(float __x),{ return __builtin_exp2f(__x); })
#elif defined(__CRT_HAVE_exp2f)
/* >> exp2f(3), exp2(3), exp2l(3)
 * Compute base-2 exponential of `x' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,exp2f,(float __x),(__x))
#elif defined(__CRT_HAVE___exp2f)
/* >> exp2f(3), exp2(3), exp2l(3)
 * Compute base-2 exponential of `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,exp2f,(float __x),__exp2f,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_exp2) || defined(__CRT_HAVE___exp2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/exp2f.h>
__NAMESPACE_STD_BEGIN
/* >> exp2f(3), exp2(3), exp2l(3)
 * Compute base-2 exponential of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(exp2f, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL exp2f)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(exp2f))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_log2f) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_log2f)
/* >> log2f(3), log2(3), log2l(3)
 * Compute base-2 logarithm of `x' */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,log2f,(float __x),{ return __builtin_log2f(__x); })
#elif defined(__CRT_HAVE_log2f)
/* >> log2f(3), log2(3), log2l(3)
 * Compute base-2 logarithm of `x' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,log2f,(float __x),(__x))
#elif defined(__CRT_HAVE___log2f)
/* >> log2f(3), log2(3), log2l(3)
 * Compute base-2 logarithm of `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,log2f,(float __x),__log2f,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_log2) || defined(__CRT_HAVE___log2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/log2f.h>
__NAMESPACE_STD_BEGIN
/* >> log2f(3), log2(3), log2l(3)
 * Compute base-2 logarithm of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(log2f, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL log2f)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(log2f))(__x); })
#endif /* ... */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if __has_builtin(__builtin_exp2l) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_exp2l)
/* >> exp2f(3), exp2(3), exp2l(3)
 * Compute base-2 exponential of `x' */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,exp2l,(__LONGDOUBLE __x),{ return __builtin_exp2l(__x); })
#elif defined(__CRT_HAVE_exp2l)
/* >> exp2f(3), exp2(3), exp2l(3)
 * Compute base-2 exponential of `x' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,exp2l,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___exp2l)
/* >> exp2f(3), exp2(3), exp2l(3)
 * Compute base-2 exponential of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,exp2l,(__LONGDOUBLE __x),__exp2l,(__x))
#elif defined(__CRT_HAVE_exp2) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> exp2f(3), exp2(3), exp2l(3)
 * Compute base-2 exponential of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,exp2l,(__LONGDOUBLE __x),exp2,(__x))
#elif defined(__CRT_HAVE___exp2) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> exp2f(3), exp2(3), exp2l(3)
 * Compute base-2 exponential of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,exp2l,(__LONGDOUBLE __x),__exp2,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_exp2) || defined(__CRT_HAVE___exp2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/exp2l.h>
__NAMESPACE_STD_BEGIN
/* >> exp2f(3), exp2(3), exp2l(3)
 * Compute base-2 exponential of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(exp2l, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL exp2l)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(exp2l))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_log2l) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_log2l)
/* >> log2f(3), log2(3), log2l(3)
 * Compute base-2 logarithm of `x' */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,log2l,(__LONGDOUBLE __x),{ return __builtin_log2l(__x); })
#elif defined(__CRT_HAVE_log2l)
/* >> log2f(3), log2(3), log2l(3)
 * Compute base-2 logarithm of `x' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,log2l,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___log2l)
/* >> log2f(3), log2(3), log2l(3)
 * Compute base-2 logarithm of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,log2l,(__LONGDOUBLE __x),__log2l,(__x))
#elif defined(__CRT_HAVE_log2) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> log2f(3), log2(3), log2l(3)
 * Compute base-2 logarithm of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,log2l,(__LONGDOUBLE __x),log2,(__x))
#elif defined(__CRT_HAVE___log2) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> log2f(3), log2(3), log2l(3)
 * Compute base-2 logarithm of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,log2l,(__LONGDOUBLE __x),__log2,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_log2) || defined(__CRT_HAVE___log2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/log2l.h>
__NAMESPACE_STD_BEGIN
/* >> log2f(3), log2(3), log2l(3)
 * Compute base-2 logarithm of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(log2l, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL log2l)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(log2l))(__x); })
#endif /* ... */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_ISOC99 */

/* Power functions. */
#if __has_builtin(__builtin_pow) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_pow)
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__CEIDECLARE(__ATTR_WUNUSED __DECL_SIMD_pow,double,__NOTHROW,pow,(double __x, double __y),{ return __builtin_pow(__x, __y); })
#elif defined(__CRT_HAVE_pow)
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__CDECLARE(__ATTR_WUNUSED __DECL_SIMD_pow,double,__NOTHROW,pow,(double __x, double __y),(__x,__y))
#elif defined(__CRT_HAVE___pow)
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_pow,double,__NOTHROW,pow,(double __x, double __y),__pow,(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/pow.h>
__NAMESPACE_STD_BEGIN
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__NAMESPACE_LOCAL_USING_OR_IMPL(pow, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_pow double __NOTHROW(__LIBCCALL pow)(double __x, double __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(pow))(__x, __y); })
#endif /* ... */
#if __has_builtin(__builtin_sqrt) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_sqrt)
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,sqrt,(double __x),{ return __builtin_sqrt(__x); })
#elif defined(__CRT_HAVE_sqrt)
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,sqrt,(double __x),(__x))
#elif defined(__CRT_HAVE___sqrt)
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,sqrt,(double __x),__sqrt,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/sqrt.h>
__NAMESPACE_STD_BEGIN
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(sqrt, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL sqrt)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(sqrt))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_powf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_powf)
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__CEIDECLARE(__ATTR_WUNUSED __DECL_SIMD_powf,float,__NOTHROW,powf,(float __x, float __y),{ return __builtin_powf(__x, __y); })
#elif defined(__CRT_HAVE_powf)
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__CDECLARE(__ATTR_WUNUSED __DECL_SIMD_powf,float,__NOTHROW,powf,(float __x, float __y),(__x,__y))
#elif defined(__CRT_HAVE___powf)
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_powf,float,__NOTHROW,powf,(float __x, float __y),__powf,(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_pow) || defined(__CRT_HAVE___pow) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/powf.h>
__NAMESPACE_STD_BEGIN
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__NAMESPACE_LOCAL_USING_OR_IMPL(powf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_powf float __NOTHROW(__LIBCCALL powf)(float __x, float __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(powf))(__x, __y); })
#endif /* ... */
#if __has_builtin(__builtin_sqrtf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_sqrtf)
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,sqrtf,(float __x),{ return __builtin_sqrtf(__x); })
#elif defined(__CRT_HAVE_sqrtf)
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,sqrtf,(float __x),(__x))
#elif defined(__CRT_HAVE___sqrtf)
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,sqrtf,(float __x),__sqrtf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_sqrt) || defined(__CRT_HAVE___sqrt) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/sqrtf.h>
__NAMESPACE_STD_BEGIN
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(sqrtf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL sqrtf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(sqrtf))(__x); })
#endif /* ... */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if __has_builtin(__builtin_powl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_powl)
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__CEIDECLARE(__ATTR_WUNUSED __DECL_SIMD_powl,__LONGDOUBLE,__NOTHROW,powl,(__LONGDOUBLE __x, __LONGDOUBLE __y),{ return __builtin_powl(__x, __y); })
#elif defined(__CRT_HAVE_powl)
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__CDECLARE(__ATTR_WUNUSED __DECL_SIMD_powl,__LONGDOUBLE,__NOTHROW,powl,(__LONGDOUBLE __x, __LONGDOUBLE __y),(__x,__y))
#elif defined(__CRT_HAVE___powl)
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_powl,__LONGDOUBLE,__NOTHROW,powl,(__LONGDOUBLE __x, __LONGDOUBLE __y),__powl,(__x,__y))
#elif defined(__CRT_HAVE_pow) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_powl,__LONGDOUBLE,__NOTHROW,powl,(__LONGDOUBLE __x, __LONGDOUBLE __y),pow,(__x,__y))
#elif defined(__CRT_HAVE___pow) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_powl,__LONGDOUBLE,__NOTHROW,powl,(__LONGDOUBLE __x, __LONGDOUBLE __y),__pow,(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_pow) || defined(__CRT_HAVE___pow) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/powl.h>
__NAMESPACE_STD_BEGIN
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__NAMESPACE_LOCAL_USING_OR_IMPL(powl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_powl __LONGDOUBLE __NOTHROW(__LIBCCALL powl)(__LONGDOUBLE __x, __LONGDOUBLE __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(powl))(__x, __y); })
#endif /* ... */
#if __has_builtin(__builtin_sqrtl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_sqrtl)
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,sqrtl,(__LONGDOUBLE __x),{ return __builtin_sqrtl(__x); })
#elif defined(__CRT_HAVE_sqrtl)
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,sqrtl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___sqrtl)
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,sqrtl,(__LONGDOUBLE __x),__sqrtl,(__x))
#elif defined(__CRT_HAVE_sqrt) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,sqrtl,(__LONGDOUBLE __x),sqrt,(__x))
#elif defined(__CRT_HAVE___sqrt) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,sqrtl,(__LONGDOUBLE __x),__sqrt,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_sqrt) || defined(__CRT_HAVE___sqrt) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/sqrtl.h>
__NAMESPACE_STD_BEGIN
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(sqrtl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL sqrtl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(sqrtl))(__x); })
#endif /* ... */
#endif /* __COMPILER_HAVE_LONGDOUBLE */

#if defined(__USE_XOPEN) || defined(__USE_ISOC99)
#if __has_builtin(__builtin_hypot) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_hypot)
/* >> hypotf(3), hypot(3), hypotl(3)
 * Return `sqrt(x*x + y*y)' */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,hypot,(double __x, double __y),{ return __builtin_hypot(__x, __y); })
#elif defined(__CRT_HAVE_hypot)
/* >> hypotf(3), hypot(3), hypotl(3)
 * Return `sqrt(x*x + y*y)' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,hypot,(double __x, double __y),(__x,__y))
#elif defined(__CRT_HAVE__hypot)
/* >> hypotf(3), hypot(3), hypotl(3)
 * Return `sqrt(x*x + y*y)' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,hypot,(double __x, double __y),_hypot,(__x,__y))
#elif defined(__CRT_HAVE___hypot)
/* >> hypotf(3), hypot(3), hypotl(3)
 * Return `sqrt(x*x + y*y)' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,hypot,(double __x, double __y),__hypot,(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/hypot.h>
__NAMESPACE_STD_BEGIN
/* >> hypotf(3), hypot(3), hypotl(3)
 * Return `sqrt(x*x + y*y)' */
__NAMESPACE_LOCAL_USING_OR_IMPL(hypot, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL hypot)(double __x, double __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(hypot))(__x, __y); })
#endif /* ... */
#if __has_builtin(__builtin_hypotf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_hypotf)
/* >> hypotf(3), hypot(3), hypotl(3)
 * Return `sqrt(x*x + y*y)' */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,hypotf,(float __x, float __y),{ return __builtin_hypotf(__x, __y); })
#elif defined(__CRT_HAVE_hypotf)
/* >> hypotf(3), hypot(3), hypotl(3)
 * Return `sqrt(x*x + y*y)' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,hypotf,(float __x, float __y),(__x,__y))
#elif defined(__CRT_HAVE__hypotf)
/* >> hypotf(3), hypot(3), hypotl(3)
 * Return `sqrt(x*x + y*y)' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,hypotf,(float __x, float __y),_hypotf,(__x,__y))
#elif defined(__CRT_HAVE___hypotf)
/* >> hypotf(3), hypot(3), hypotl(3)
 * Return `sqrt(x*x + y*y)' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,hypotf,(float __x, float __y),__hypotf,(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_hypot) || defined(__CRT_HAVE__hypot) || defined(__CRT_HAVE___hypot) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/hypotf.h>
__NAMESPACE_STD_BEGIN
/* >> hypotf(3), hypot(3), hypotl(3)
 * Return `sqrt(x*x + y*y)' */
__NAMESPACE_LOCAL_USING_OR_IMPL(hypotf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL hypotf)(float __x, float __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(hypotf))(__x, __y); })
#endif /* ... */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if __has_builtin(__builtin_hypotl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_hypotl)
/* >> hypotf(3), hypot(3), hypotl(3)
 * Return `sqrt(x*x + y*y)' */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,hypotl,(__LONGDOUBLE __x, __LONGDOUBLE __y),{ return __builtin_hypotl(__x, __y); })
#elif defined(__CRT_HAVE_hypotl)
/* >> hypotf(3), hypot(3), hypotl(3)
 * Return `sqrt(x*x + y*y)' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,hypotl,(__LONGDOUBLE __x, __LONGDOUBLE __y),(__x,__y))
#elif defined(__CRT_HAVE___hypotl)
/* >> hypotf(3), hypot(3), hypotl(3)
 * Return `sqrt(x*x + y*y)' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,hypotl,(__LONGDOUBLE __x, __LONGDOUBLE __y),__hypotl,(__x,__y))
#elif defined(__CRT_HAVE_hypot) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> hypotf(3), hypot(3), hypotl(3)
 * Return `sqrt(x*x + y*y)' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,hypotl,(__LONGDOUBLE __x, __LONGDOUBLE __y),hypot,(__x,__y))
#elif defined(__CRT_HAVE___hypot) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> hypotf(3), hypot(3), hypotl(3)
 * Return `sqrt(x*x + y*y)' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,hypotl,(__LONGDOUBLE __x, __LONGDOUBLE __y),__hypot,(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_hypot) || defined(__CRT_HAVE__hypot) || defined(__CRT_HAVE___hypot) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/hypotl.h>
__NAMESPACE_STD_BEGIN
/* >> hypotf(3), hypot(3), hypotl(3)
 * Return `sqrt(x*x + y*y)' */
__NAMESPACE_LOCAL_USING_OR_IMPL(hypotl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL hypotl)(__LONGDOUBLE __x, __LONGDOUBLE __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(hypotl))(__x, __y); })
#endif /* ... */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_XOPEN || __USE_ISOC99 */

#if defined(__USE_XOPEN_EXTENDED) || defined(__USE_ISOC99)
#if __has_builtin(__builtin_cbrt) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_cbrt)
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,cbrt,(double __x),{ return __builtin_cbrt(__x); })
#elif defined(__CRT_HAVE_cbrt)
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,cbrt,(double __x),(__x))
#elif defined(__CRT_HAVE___cbrt)
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,cbrt,(double __x),__cbrt,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/cbrt.h>
__NAMESPACE_STD_BEGIN
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(cbrt, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL cbrt)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(cbrt))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_cbrtf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_cbrtf)
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,cbrtf,(float __x),{ return __builtin_cbrtf(__x); })
#elif defined(__CRT_HAVE_cbrtf)
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,cbrtf,(float __x),(__x))
#elif defined(__CRT_HAVE___cbrtf)
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,cbrtf,(float __x),__cbrtf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_cbrt) || defined(__CRT_HAVE___cbrt) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/cbrtf.h>
__NAMESPACE_STD_BEGIN
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(cbrtf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL cbrtf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(cbrtf))(__x); })
#endif /* ... */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if __has_builtin(__builtin_cbrtl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_cbrtl)
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,cbrtl,(__LONGDOUBLE __x),{ return __builtin_cbrtl(__x); })
#elif defined(__CRT_HAVE_cbrtl)
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,cbrtl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___cbrtl)
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,cbrtl,(__LONGDOUBLE __x),__cbrtl,(__x))
#elif defined(__CRT_HAVE_cbrt) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,cbrtl,(__LONGDOUBLE __x),cbrt,(__x))
#elif defined(__CRT_HAVE___cbrt) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,cbrtl,(__LONGDOUBLE __x),__cbrt,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_cbrt) || defined(__CRT_HAVE___cbrt) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/cbrtl.h>
__NAMESPACE_STD_BEGIN
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(cbrtl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL cbrtl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(cbrtl))(__x); })
#endif /* ... */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_XOPEN_EXTENDED || __USE_ISOC99 */

/* Nearest integer, absolute value, and remainder functions. */
#if __has_builtin(__builtin_ceil) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_ceil)
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,ceil,(double __x),{ return __builtin_ceil(__x); })
#elif defined(__CRT_HAVE_ceil)
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,ceil,(double __x),(__x))
#elif defined(__CRT_HAVE___ceil)
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,ceil,(double __x),__ceil,(__x))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/ceil.h>
__NAMESPACE_STD_BEGIN
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(ceil, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL ceil)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(ceil))(__x); })
#endif /* !... */
#if __has_builtin(__builtin_fabs) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fabs)
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,fabs,(double __x),{ return __builtin_fabs(__x); })
#elif defined(__CRT_HAVE_fabs)
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,fabs,(double __x),(__x))
#elif defined(__CRT_HAVE___fabs)
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,fabs,(double __x),__fabs,(__x))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/fabs.h>
__NAMESPACE_STD_BEGIN
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(fabs, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL fabs)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fabs))(__x); })
#endif /* !... */
#if __has_builtin(__builtin_floor) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_floor)
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,floor,(double __x),{ return __builtin_floor(__x); })
#elif defined(__CRT_HAVE_floor)
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,floor,(double __x),(__x))
#elif defined(__CRT_HAVE___floor)
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,floor,(double __x),__floor,(__x))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/floor.h>
__NAMESPACE_STD_BEGIN
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(floor, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL floor)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(floor))(__x); })
#endif /* !... */
#if __has_builtin(__builtin_fmod) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fmod)
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,fmod,(double __x, double __y),{ return __builtin_fmod(__x, __y); })
#elif defined(__CRT_HAVE_fmod)
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,fmod,(double __x, double __y),(__x,__y))
#elif defined(__CRT_HAVE___fmod)
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,fmod,(double __x, double __y),__fmod,(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/fmod.h>
__NAMESPACE_STD_BEGIN
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__NAMESPACE_LOCAL_USING_OR_IMPL(fmod, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL fmod)(double __x, double __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fmod))(__x, __y); })
#endif /* ... */
#if __has_builtin(__builtin_ceilf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_ceilf)
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,ceilf,(float __x),{ return __builtin_ceilf(__x); })
#elif defined(__CRT_HAVE_ceilf)
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,ceilf,(float __x),(__x))
#elif defined(__CRT_HAVE___ceilf)
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,ceilf,(float __x),__ceilf,(__x))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/ceilf.h>
__NAMESPACE_STD_BEGIN
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(ceilf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL ceilf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(ceilf))(__x); })
#endif /* !... */
#if __has_builtin(__builtin_fabsf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fabsf)
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,fabsf,(float __x),{ return __builtin_fabsf(__x); })
#elif defined(__CRT_HAVE_fabsf)
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,fabsf,(float __x),(__x))
#elif defined(__CRT_HAVE___fabsf)
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,fabsf,(float __x),__fabsf,(__x))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/fabsf.h>
__NAMESPACE_STD_BEGIN
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(fabsf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL fabsf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fabsf))(__x); })
#endif /* !... */
#if __has_builtin(__builtin_floorf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_floorf)
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,floorf,(float __x),{ return __builtin_floorf(__x); })
#elif defined(__CRT_HAVE_floorf)
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,floorf,(float __x),(__x))
#elif defined(__CRT_HAVE___floorf)
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,floorf,(float __x),__floorf,(__x))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/floorf.h>
__NAMESPACE_STD_BEGIN
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(floorf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL floorf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(floorf))(__x); })
#endif /* !... */
#if __has_builtin(__builtin_fmodf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fmodf)
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,fmodf,(float __x, float __y),{ return __builtin_fmodf(__x, __y); })
#elif defined(__CRT_HAVE_fmodf)
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,fmodf,(float __x, float __y),(__x,__y))
#elif defined(__CRT_HAVE___fmodf)
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,fmodf,(float __x, float __y),__fmodf,(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_fmod) || defined(__CRT_HAVE___fmod) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/fmodf.h>
__NAMESPACE_STD_BEGIN
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__NAMESPACE_LOCAL_USING_OR_IMPL(fmodf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL fmodf)(float __x, float __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fmodf))(__x, __y); })
#endif /* ... */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if __has_builtin(__builtin_ceill) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_ceill)
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,ceill,(__LONGDOUBLE __x),{ return __builtin_ceill(__x); })
#elif defined(__CRT_HAVE_ceill)
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,ceill,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___ceill)
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,ceill,(__LONGDOUBLE __x),__ceill,(__x))
#elif defined(__CRT_HAVE_ceil) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,ceill,(__LONGDOUBLE __x),ceil,(__x))
#elif defined(__CRT_HAVE___ceil) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,ceill,(__LONGDOUBLE __x),__ceil,(__x))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/ceill.h>
__NAMESPACE_STD_BEGIN
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(ceill, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL ceill)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(ceill))(__x); })
#endif /* !... */
#if __has_builtin(__builtin_fabsl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fabsl)
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fabsl,(__LONGDOUBLE __x),{ return __builtin_fabsl(__x); })
#elif defined(__CRT_HAVE_fabsl)
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fabsl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___fabsl)
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fabsl,(__LONGDOUBLE __x),__fabsl,(__x))
#elif defined(__CRT_HAVE_fabs) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fabsl,(__LONGDOUBLE __x),fabs,(__x))
#elif defined(__CRT_HAVE___fabs) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fabsl,(__LONGDOUBLE __x),__fabs,(__x))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/fabsl.h>
__NAMESPACE_STD_BEGIN
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(fabsl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL fabsl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fabsl))(__x); })
#endif /* !... */
#if __has_builtin(__builtin_floorl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_floorl)
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,floorl,(__LONGDOUBLE __x),{ return __builtin_floorl(__x); })
#elif defined(__CRT_HAVE_floorl)
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,floorl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___floorl)
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,floorl,(__LONGDOUBLE __x),__floorl,(__x))
#elif defined(__CRT_HAVE_floor) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,floorl,(__LONGDOUBLE __x),floor,(__x))
#elif defined(__CRT_HAVE___floor) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,floorl,(__LONGDOUBLE __x),__floor,(__x))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/floorl.h>
__NAMESPACE_STD_BEGIN
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(floorl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL floorl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(floorl))(__x); })
#endif /* !... */
#if __has_builtin(__builtin_fmodl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fmodl)
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fmodl,(__LONGDOUBLE __x, __LONGDOUBLE __y),{ return __builtin_fmodl(__x, __y); })
#elif defined(__CRT_HAVE_fmodl)
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fmodl,(__LONGDOUBLE __x, __LONGDOUBLE __y),(__x,__y))
#elif defined(__CRT_HAVE___fmodl)
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fmodl,(__LONGDOUBLE __x, __LONGDOUBLE __y),__fmodl,(__x,__y))
#elif defined(__CRT_HAVE_fmod) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fmodl,(__LONGDOUBLE __x, __LONGDOUBLE __y),fmod,(__x,__y))
#elif defined(__CRT_HAVE___fmod) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fmodl,(__LONGDOUBLE __x, __LONGDOUBLE __y),__fmod,(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_fmod) || defined(__CRT_HAVE___fmod) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/fmodl.h>
__NAMESPACE_STD_BEGIN
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__NAMESPACE_LOCAL_USING_OR_IMPL(fmodl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL fmodl)(__LONGDOUBLE __x, __LONGDOUBLE __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fmodl))(__x, __y); })
#endif /* ... */
#endif /* __COMPILER_HAVE_LONGDOUBLE */

#ifdef __USE_ISOC99
#if __has_builtin(__builtin_copysign) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_copysign)
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,copysign,(double __num, double __sign),{ return __builtin_copysign(__num, __sign); })
#elif defined(__CRT_HAVE_copysign)
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,copysign,(double __num, double __sign),(__num,__sign))
#elif defined(__CRT_HAVE___copysign)
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,copysign,(double __num, double __sign),__copysign,(__num,__sign))
#elif defined(__CRT_HAVE__copysign)
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,copysign,(double __num, double __sign),_copysign,(__num,__sign))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/copysign.h>
__NAMESPACE_STD_BEGIN
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__NAMESPACE_LOCAL_USING_OR_IMPL(copysign, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL copysign)(double __num, double __sign) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(copysign))(__num, __sign); })
#endif /* !... */
#if __has_builtin(__builtin_nan) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nan)
/* >> nanf(3), nan(3), nanl(3)
 * Return representation of qNaN for double type */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,nan,(char const *__tagb),{ return __builtin_nan(__tagb); })
#elif defined(__CRT_HAVE_nan)
/* >> nanf(3), nan(3), nanl(3)
 * Return representation of qNaN for double type */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,nan,(char const *__tagb),(__tagb))
#elif defined(__CRT_HAVE___nan)
/* >> nanf(3), nan(3), nanl(3)
 * Return representation of qNaN for double type */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,nan,(char const *__tagb),__nan,(__tagb))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/nan.h>
__NAMESPACE_STD_BEGIN
/* >> nanf(3), nan(3), nanl(3)
 * Return representation of qNaN for double type */
__NAMESPACE_LOCAL_USING_OR_IMPL(nan, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL nan)(char const *__tagb) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(nan))(__tagb); })
#endif /* ... */
#if __has_builtin(__builtin_copysignf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_copysignf)
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,copysignf,(float __num, float __sign),{ return __builtin_copysignf(__num, __sign); })
#elif defined(__CRT_HAVE_copysignf)
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,copysignf,(float __num, float __sign),(__num,__sign))
#elif defined(__CRT_HAVE__copysignf)
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,copysignf,(float __num, float __sign),_copysignf,(__num,__sign))
#elif defined(__CRT_HAVE___copysignf)
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,copysignf,(float __num, float __sign),__copysignf,(__num,__sign))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/copysignf.h>
__NAMESPACE_STD_BEGIN
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__NAMESPACE_LOCAL_USING_OR_IMPL(copysignf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL copysignf)(float __num, float __sign) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(copysignf))(__num, __sign); })
#endif /* !... */
#if __has_builtin(__builtin_nanf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nanf)
/* >> nanf(3), nan(3), nanl(3)
 * Return representation of qNaN for double type */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nanf,(char const *__tagb),{ return __builtin_nanf(__tagb); })
#elif defined(__CRT_HAVE_nanf)
/* >> nanf(3), nan(3), nanl(3)
 * Return representation of qNaN for double type */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nanf,(char const *__tagb),(__tagb))
#elif defined(__CRT_HAVE___nanf)
/* >> nanf(3), nan(3), nanl(3)
 * Return representation of qNaN for double type */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nanf,(char const *__tagb),__nanf,(__tagb))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_nan) || defined(__CRT_HAVE___nan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/nanf.h>
__NAMESPACE_STD_BEGIN
/* >> nanf(3), nan(3), nanl(3)
 * Return representation of qNaN for double type */
__NAMESPACE_LOCAL_USING_OR_IMPL(nanf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL nanf)(char const *__tagb) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(nanf))(__tagb); })
#endif /* ... */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if __has_builtin(__builtin_copysignl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_copysignl)
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,copysignl,(__LONGDOUBLE __num, __LONGDOUBLE __sign),{ return __builtin_copysignl(__num, __sign); })
#elif defined(__CRT_HAVE_copysignl)
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,copysignl,(__LONGDOUBLE __num, __LONGDOUBLE __sign),(__num,__sign))
#elif defined(__CRT_HAVE___copysignl)
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,copysignl,(__LONGDOUBLE __num, __LONGDOUBLE __sign),__copysignl,(__num,__sign))
#elif defined(__CRT_HAVE_copysign) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,copysignl,(__LONGDOUBLE __num, __LONGDOUBLE __sign),copysign,(__num,__sign))
#elif defined(__CRT_HAVE___copysign) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,copysignl,(__LONGDOUBLE __num, __LONGDOUBLE __sign),__copysign,(__num,__sign))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/copysignl.h>
__NAMESPACE_STD_BEGIN
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__NAMESPACE_LOCAL_USING_OR_IMPL(copysignl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL copysignl)(__LONGDOUBLE __num, __LONGDOUBLE __sign) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(copysignl))(__num, __sign); })
#endif /* !... */
#if __has_builtin(__builtin_nanl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nanl)
/* >> nanf(3), nan(3), nanl(3)
 * Return representation of qNaN for double type */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nanl,(char const *__tagb),{ return __builtin_nanl(__tagb); })
#elif defined(__CRT_HAVE_nanl)
/* >> nanf(3), nan(3), nanl(3)
 * Return representation of qNaN for double type */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nanl,(char const *__tagb),(__tagb))
#elif defined(__CRT_HAVE___nanl)
/* >> nanf(3), nan(3), nanl(3)
 * Return representation of qNaN for double type */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nanl,(char const *__tagb),__nanl,(__tagb))
#elif defined(__CRT_HAVE_nan) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> nanf(3), nan(3), nanl(3)
 * Return representation of qNaN for double type */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nanl,(char const *__tagb),nan,(__tagb))
#elif defined(__CRT_HAVE___nan) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> nanf(3), nan(3), nanl(3)
 * Return representation of qNaN for double type */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nanl,(char const *__tagb),__nan,(__tagb))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_nan) || defined(__CRT_HAVE___nan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/nanl.h>
__NAMESPACE_STD_BEGIN
/* >> nanf(3), nan(3), nanl(3)
 * Return representation of qNaN for double type */
__NAMESPACE_LOCAL_USING_OR_IMPL(nanl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL nanl)(char const *__tagb) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(nanl))(__tagb); })
#endif /* ... */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_ISOC99 */

/* Error and gamma functions. */
#if defined(__USE_XOPEN) || defined(__USE_ISOC99)
#if __has_builtin(__builtin_erf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_erf)
/* >> erff(3), erf(3), erfl(3) */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,erf,(double __x),{ return __builtin_erf(__x); })
#elif defined(__CRT_HAVE_erf)
/* >> erff(3), erf(3), erfl(3) */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,erf,(double __x),(__x))
#elif defined(__CRT_HAVE___erf)
/* >> erff(3), erf(3), erfl(3) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,erf,(double __x),__erf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/erf.h>
__NAMESPACE_STD_BEGIN
/* >> erff(3), erf(3), erfl(3) */
__NAMESPACE_LOCAL_USING_OR_IMPL(erf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL erf)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(erf))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_erfc) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_erfc)
/* >> erfcf(3), erfc(3), erfcl(3) */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,erfc,(double __x),{ return __builtin_erfc(__x); })
#elif defined(__CRT_HAVE_erfc)
/* >> erfcf(3), erfc(3), erfcl(3) */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,erfc,(double __x),(__x))
#elif defined(__CRT_HAVE___erfc)
/* >> erfcf(3), erfc(3), erfcl(3) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,erfc,(double __x),__erfc,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/erfc.h>
__NAMESPACE_STD_BEGIN
/* >> erfcf(3), erfc(3), erfcl(3) */
__NAMESPACE_LOCAL_USING_OR_IMPL(erfc, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL erfc)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(erfc))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_lgamma) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_lgamma)
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,lgamma,(double __x),{ return __builtin_lgamma(__x); })
#elif __has_builtin(__builtin_gamma) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_gamma)
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__CEIREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,lgamma,(double __x),gamma,{ return __builtin_gamma(__x); })
#elif defined(__CRT_HAVE_lgamma)
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,lgamma,(double __x),(__x))
#elif defined(__CRT_HAVE_gamma)
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,lgamma,(double __x),gamma,(__x))
#elif defined(__CRT_HAVE___lgamma)
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,lgamma,(double __x),__lgamma,(__x))
#elif defined(__CRT_HAVE___gamma)
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,lgamma,(double __x),__gamma,(__x))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/template/signgam.h>
__NAMESPACE_STD_BEGIN
#if defined(__LOCAL_signgam) && (defined(__CRT_HAVE_lgamma_r) || defined(__CRT_HAVE___lgamma_r) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__))
__NAMESPACE_STD_END
#include <libc/local/math/lgamma.h>
__NAMESPACE_STD_BEGIN
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__NAMESPACE_LOCAL_USING_OR_IMPL(lgamma, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL lgamma)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(lgamma))(__x); })
#endif /* __LOCAL_signgam && (__CRT_HAVE_lgamma_r || __CRT_HAVE___lgamma_r || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__) */
#endif /* !... */
#if __has_builtin(__builtin_erff) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_erff)
/* >> erff(3), erf(3), erfl(3) */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,erff,(float __x),{ return __builtin_erff(__x); })
#elif defined(__CRT_HAVE_erff)
/* >> erff(3), erf(3), erfl(3) */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,erff,(float __x),(__x))
#elif defined(__CRT_HAVE___erff)
/* >> erff(3), erf(3), erfl(3) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,erff,(float __x),__erff,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_erf) || defined(__CRT_HAVE___erf) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/erff.h>
__NAMESPACE_STD_BEGIN
/* >> erff(3), erf(3), erfl(3) */
__NAMESPACE_LOCAL_USING_OR_IMPL(erff, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL erff)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(erff))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_erfcf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_erfcf)
/* >> erfcf(3), erfc(3), erfcl(3) */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,erfcf,(float __x),{ return __builtin_erfcf(__x); })
#elif defined(__CRT_HAVE_erfcf)
/* >> erfcf(3), erfc(3), erfcl(3) */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,erfcf,(float __x),(__x))
#elif defined(__CRT_HAVE___erfcf)
/* >> erfcf(3), erfc(3), erfcl(3) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,erfcf,(float __x),__erfcf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_erfc) || defined(__CRT_HAVE___erfc) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/erfcf.h>
__NAMESPACE_STD_BEGIN
/* >> erfcf(3), erfc(3), erfcl(3) */
__NAMESPACE_LOCAL_USING_OR_IMPL(erfcf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL erfcf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(erfcf))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_lgammaf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_lgammaf)
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,lgammaf,(float __x),{ return __builtin_lgammaf(__x); })
#elif __has_builtin(__builtin_gammaf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_gammaf)
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,lgammaf,(float __x),gammaf,{ return __builtin_gammaf(__x); })
#elif defined(__CRT_HAVE_lgammaf)
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,lgammaf,(float __x),(__x))
#elif defined(__CRT_HAVE_gammaf)
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,lgammaf,(float __x),gammaf,(__x))
#elif defined(__CRT_HAVE___lgammaf)
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,lgammaf,(float __x),__lgammaf,(__x))
#elif defined(__CRT_HAVE___gammaf)
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,lgammaf,(float __x),__gammaf,(__x))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/template/signgam.h>
__NAMESPACE_STD_BEGIN
#if defined(__LOCAL_signgam) && (defined(__CRT_HAVE_lgammaf_r) || defined(__CRT_HAVE___lgammaf_r) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_lgamma_r) || defined(__CRT_HAVE___lgamma_r) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__))
__NAMESPACE_STD_END
#include <libc/local/math/lgammaf.h>
__NAMESPACE_STD_BEGIN
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__NAMESPACE_LOCAL_USING_OR_IMPL(lgammaf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL lgammaf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(lgammaf))(__x); })
#endif /* __LOCAL_signgam && (__CRT_HAVE_lgammaf_r || __CRT_HAVE___lgammaf_r || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_lgamma_r || __CRT_HAVE___lgamma_r || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__) */
#endif /* !... */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if __has_builtin(__builtin_erfl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_erfl)
/* >> erff(3), erf(3), erfl(3) */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,erfl,(__LONGDOUBLE __x),{ return __builtin_erfl(__x); })
#elif defined(__CRT_HAVE_erfl)
/* >> erff(3), erf(3), erfl(3) */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,erfl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___erfl)
/* >> erff(3), erf(3), erfl(3) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,erfl,(__LONGDOUBLE __x),__erfl,(__x))
#elif defined(__CRT_HAVE_erf) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> erff(3), erf(3), erfl(3) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,erfl,(__LONGDOUBLE __x),erf,(__x))
#elif defined(__CRT_HAVE___erf) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> erff(3), erf(3), erfl(3) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,erfl,(__LONGDOUBLE __x),__erf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_erf) || defined(__CRT_HAVE___erf) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/erfl.h>
__NAMESPACE_STD_BEGIN
/* >> erff(3), erf(3), erfl(3) */
__NAMESPACE_LOCAL_USING_OR_IMPL(erfl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL erfl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(erfl))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_erfcl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_erfcl)
/* >> erfcf(3), erfc(3), erfcl(3) */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,erfcl,(__LONGDOUBLE __x),{ return __builtin_erfcl(__x); })
#elif defined(__CRT_HAVE_erfcl)
/* >> erfcf(3), erfc(3), erfcl(3) */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,erfcl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___erfcl)
/* >> erfcf(3), erfc(3), erfcl(3) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,erfcl,(__LONGDOUBLE __x),__erfcl,(__x))
#elif defined(__CRT_HAVE_erfc) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> erfcf(3), erfc(3), erfcl(3) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,erfcl,(__LONGDOUBLE __x),erfc,(__x))
#elif defined(__CRT_HAVE___erfc) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> erfcf(3), erfc(3), erfcl(3) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,erfcl,(__LONGDOUBLE __x),__erfc,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_erfc) || defined(__CRT_HAVE___erfc) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/erfcl.h>
__NAMESPACE_STD_BEGIN
/* >> erfcf(3), erfc(3), erfcl(3) */
__NAMESPACE_LOCAL_USING_OR_IMPL(erfcl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL erfcl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(erfcl))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_lgammal) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_lgammal)
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,lgammal,(__LONGDOUBLE __x),{ return __builtin_lgammal(__x); })
#elif __has_builtin(__builtin_gammal) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_gammal)
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,lgammal,(__LONGDOUBLE __x),gammal,{ return __builtin_gammal(__x); })
#elif defined(__CRT_HAVE_lgammal)
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,lgammal,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE_gammal)
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,lgammal,(__LONGDOUBLE __x),gammal,(__x))
#elif defined(__CRT_HAVE___lgammal)
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,lgammal,(__LONGDOUBLE __x),__lgammal,(__x))
#elif defined(__CRT_HAVE___gammal)
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,lgammal,(__LONGDOUBLE __x),__gammal,(__x))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/template/signgam.h>
__NAMESPACE_STD_BEGIN
#if defined(__LOCAL_signgam) && (defined(__CRT_HAVE_lgammal_r) || defined(__CRT_HAVE___lgammal_r) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_lgamma_r) || defined(__CRT_HAVE___lgamma_r) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__))
__NAMESPACE_STD_END
#include <libc/local/math/lgammal.h>
__NAMESPACE_STD_BEGIN
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__NAMESPACE_LOCAL_USING_OR_IMPL(lgammal, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL lgammal)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(lgammal))(__x); })
#endif /* __LOCAL_signgam && (__CRT_HAVE_lgammal_r || __CRT_HAVE___lgammal_r || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_lgamma_r || __CRT_HAVE___lgamma_r || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__) */
#endif /* !... */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_XOPEN || __USE_ISOC99 */
#ifdef __USE_ISOC99
#if __has_builtin(__builtin_tgamma) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_tgamma)
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,tgamma,(double __x),{ return __builtin_tgamma(__x); })
#elif defined(__CRT_HAVE_tgamma)
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,tgamma,(double __x),(__x))
#elif defined(__CRT_HAVE___tgamma)
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,tgamma,(double __x),__tgamma,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/tgamma.h>
__NAMESPACE_STD_BEGIN
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__NAMESPACE_LOCAL_USING_OR_IMPL(tgamma, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL tgamma)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(tgamma))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_tgammaf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_tgammaf)
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,tgammaf,(float __x),{ return __builtin_tgammaf(__x); })
#elif defined(__CRT_HAVE_tgammaf)
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,tgammaf,(float __x),(__x))
#elif defined(__CRT_HAVE___tgammaf)
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,tgammaf,(float __x),__tgammaf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_tgamma) || defined(__CRT_HAVE___tgamma) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/tgammaf.h>
__NAMESPACE_STD_BEGIN
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__NAMESPACE_LOCAL_USING_OR_IMPL(tgammaf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL tgammaf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(tgammaf))(__x); })
#endif /* ... */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if __has_builtin(__builtin_tgammal) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_tgammal)
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,tgammal,(__LONGDOUBLE __x),{ return __builtin_tgammal(__x); })
#elif defined(__CRT_HAVE_tgammal)
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,tgammal,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___tgammal)
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,tgammal,(__LONGDOUBLE __x),__tgammal,(__x))
#elif defined(__CRT_HAVE_tgamma) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,tgammal,(__LONGDOUBLE __x),tgamma,(__x))
#elif defined(__CRT_HAVE___tgamma) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,tgammal,(__LONGDOUBLE __x),__tgamma,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_tgamma) || defined(__CRT_HAVE___tgamma) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/tgammal.h>
__NAMESPACE_STD_BEGIN
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__NAMESPACE_LOCAL_USING_OR_IMPL(tgammal, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL tgammal)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(tgammal))(__x); })
#endif /* ... */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_ISOC99 */

#if defined(__USE_XOPEN_EXTENDED) || defined(__USE_ISOC99)
#if __has_builtin(__builtin_rint) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_rint)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,rint,(double __x),{ return __builtin_rint(__x); })
#elif __has_builtin(__builtin_nearbyint) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nearbyint)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,rint,(double __x),nearbyint,{ return __builtin_nearbyint(__x); })
#elif defined(__CRT_HAVE_rint)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,rint,(double __x),(__x))
#elif defined(__CRT_HAVE_nearbyint)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,rint,(double __x),nearbyint,(__x))
#elif defined(__CRT_HAVE___rint)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,rint,(double __x),__rint,(__x))
#elif defined(__CRT_HAVE___nearbyint)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,rint,(double __x),__nearbyint,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/rint.h>
__NAMESPACE_STD_BEGIN
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__NAMESPACE_LOCAL_USING_OR_IMPL(rint, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL rint)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(rint))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_nextafter) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nextafter)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,nextafter,(double __x, double __y),{ return __builtin_nextafter(__x, __y); })
#elif __has_builtin(__builtin_nexttoward) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nexttoward)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,nextafter,(double __x, double __y),nexttoward,{ return __builtin_nexttoward(__x); })
#elif defined(__CRT_HAVE_nextafter)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,nextafter,(double __x, double __y),(__x,__y))
#elif defined(__CRT_HAVE_nexttoward)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,nextafter,(double __x, double __y),nexttoward,(__x,__y))
#elif defined(__CRT_HAVE___nextafter)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,nextafter,(double __x, double __y),__nextafter,(__x,__y))
#elif defined(__CRT_HAVE__nextafter)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,nextafter,(double __x, double __y),_nextafter,(__x,__y))
#elif defined(__CRT_HAVE___nexttoward)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,nextafter,(double __x, double __y),__nexttoward,(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/nextafter.h>
__NAMESPACE_STD_BEGIN
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__NAMESPACE_LOCAL_USING_OR_IMPL(nextafter, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL nextafter)(double __x, double __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(nextafter))(__x, __y); })
#endif /* ... */
#if __has_builtin(__builtin_remainder) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_remainder)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,remainder,(double __x, double __p),{ return __builtin_remainder(__x, __p); })
#elif __has_builtin(__builtin_drem) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_drem)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CEIREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,remainder,(double __x, double __p),drem,{ return __builtin_drem(__x, __p); })
#elif defined(__CRT_HAVE_remainder)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,remainder,(double __x, double __p),(__x,__p))
#elif defined(__CRT_HAVE_drem)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,remainder,(double __x, double __p),drem,(__x,__p))
#elif defined(__CRT_HAVE___remainder)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,remainder,(double __x, double __p),__remainder,(__x,__p))
#elif defined(__CRT_HAVE___drem)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,remainder,(double __x, double __p),__drem,(__x,__p))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/remainder.h>
__NAMESPACE_STD_BEGIN
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__NAMESPACE_LOCAL_USING_OR_IMPL(remainder, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL remainder)(double __x, double __p) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(remainder))(__x, __p); })
#endif /* ... */
#if __has_builtin(__builtin_ilogb) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_ilogb)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CEIDECLARE(__ATTR_WUNUSED,int,__NOTHROW,ilogb,(double __x),{ return __builtin_ilogb(__x); })
#elif defined(__CRT_HAVE_ilogb)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CDECLARE(__ATTR_WUNUSED,int,__NOTHROW,ilogb,(double __x),(__x))
#elif defined(__CRT_HAVE_llogb) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,ilogb,(double __x),llogb,(__x))
#elif defined(__CRT_HAVE___ilogb)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,ilogb,(double __x),__ilogb,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/ilogb.h>
__NAMESPACE_STD_BEGIN
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__NAMESPACE_LOCAL_USING_OR_IMPL(ilogb, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED int __NOTHROW(__LIBCCALL ilogb)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(ilogb))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_rintf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_rintf)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,rintf,(float __x),{ return __builtin_rintf(__x); })
#elif __has_builtin(__builtin_nearbyintf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nearbyintf)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,rintf,(float __x),nearbyintf,{ return __builtin_nearbyintf(__x); })
#elif defined(__CRT_HAVE_rintf)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,rintf,(float __x),(__x))
#elif defined(__CRT_HAVE_nearbyintf)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,rintf,(float __x),nearbyintf,(__x))
#elif defined(__CRT_HAVE___rintf)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,rintf,(float __x),__rintf,(__x))
#elif defined(__CRT_HAVE___nearbyintf)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,rintf,(float __x),__nearbyintf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_rint) || defined(__CRT_HAVE_nearbyint) || defined(__CRT_HAVE___rint) || defined(__CRT_HAVE___nearbyint) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/rintf.h>
__NAMESPACE_STD_BEGIN
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__NAMESPACE_LOCAL_USING_OR_IMPL(rintf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL rintf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(rintf))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_nextafterf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nextafterf)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nextafterf,(float __x, float __y),{ return __builtin_nextafterf(__x, __y); })
#elif __has_builtin(__builtin_nexttowardf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nexttowardf)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nextafterf,(float __x, float __y),nexttowardf,{ return __builtin_nexttowardf(__x); })
#elif defined(__CRT_HAVE_nextafterf)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nextafterf,(float __x, float __y),(__x,__y))
#elif defined(__CRT_HAVE_nexttowardf)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nextafterf,(float __x, float __y),nexttowardf,(__x,__y))
#elif defined(__CRT_HAVE___nextafterf)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nextafterf,(float __x, float __y),__nextafterf,(__x,__y))
#elif defined(__CRT_HAVE___nexttowardf)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nextafterf,(float __x, float __y),__nexttowardf,(__x,__y))
#elif defined(__CRT_HAVE__nextafterf)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nextafterf,(float __x, float __y),_nextafterf,(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_nextafter) || defined(__CRT_HAVE_nexttoward) || defined(__CRT_HAVE___nextafter) || defined(__CRT_HAVE__nextafter) || defined(__CRT_HAVE___nexttoward) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/nextafterf.h>
__NAMESPACE_STD_BEGIN
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__NAMESPACE_LOCAL_USING_OR_IMPL(nextafterf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL nextafterf)(float __x, float __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(nextafterf))(__x, __y); })
#endif /* ... */
#if __has_builtin(__builtin_remainderf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_remainderf)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,remainderf,(float __x, float __p),{ return __builtin_remainderf(__x, __p); })
#elif __has_builtin(__builtin_dremf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_dremf)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,remainderf,(float __x, float __p),dremf,{ return __builtin_dremf(__x, __p); })
#elif defined(__CRT_HAVE_remainderf)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,remainderf,(float __x, float __p),(__x,__p))
#elif defined(__CRT_HAVE_dremf)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,remainderf,(float __x, float __p),dremf,(__x,__p))
#elif defined(__CRT_HAVE___remainderf)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,remainderf,(float __x, float __p),__remainderf,(__x,__p))
#elif defined(__CRT_HAVE___dremf)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,remainderf,(float __x, float __p),__dremf,(__x,__p))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_remainder) || defined(__CRT_HAVE_drem) || defined(__CRT_HAVE___remainder) || defined(__CRT_HAVE___drem) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/remainderf.h>
__NAMESPACE_STD_BEGIN
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__NAMESPACE_LOCAL_USING_OR_IMPL(remainderf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL remainderf)(float __x, float __p) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(remainderf))(__x, __p); })
#endif /* ... */
#if __has_builtin(__builtin_ilogbf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_ilogbf)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CEIDECLARE(__ATTR_WUNUSED,int,__NOTHROW,ilogbf,(float __x),{ return __builtin_ilogbf(__x); })
#elif defined(__CRT_HAVE_ilogbf)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CDECLARE(__ATTR_WUNUSED,int,__NOTHROW,ilogbf,(float __x),(__x))
#elif defined(__CRT_HAVE_llogbf) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,ilogbf,(float __x),llogbf,(__x))
#elif defined(__CRT_HAVE___ilogbf)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,ilogbf,(float __x),__ilogbf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_ilogb) || (defined(__CRT_HAVE_llogb) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__CRT_HAVE___ilogb) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/ilogbf.h>
__NAMESPACE_STD_BEGIN
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__NAMESPACE_LOCAL_USING_OR_IMPL(ilogbf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED int __NOTHROW(__LIBCCALL ilogbf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(ilogbf))(__x); })
#endif /* ... */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if __has_builtin(__builtin_rintl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_rintl)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,rintl,(__LONGDOUBLE __x),{ return __builtin_rintl(__x); })
#elif __has_builtin(__builtin_nearbyintl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nearbyintl)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,rintl,(__LONGDOUBLE __x),nearbyintl,{ return __builtin_nearbyintl(__x); })
#elif defined(__CRT_HAVE_rintl)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,rintl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE_nearbyintl)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,rintl,(__LONGDOUBLE __x),nearbyintl,(__x))
#elif defined(__CRT_HAVE___rintl)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,rintl,(__LONGDOUBLE __x),__rintl,(__x))
#elif defined(__CRT_HAVE___nearbyintl)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,rintl,(__LONGDOUBLE __x),__nearbyintl,(__x))
#elif defined(__CRT_HAVE_rint) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,rintl,(__LONGDOUBLE __x),rint,(__x))
#elif defined(__CRT_HAVE_nearbyint) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,rintl,(__LONGDOUBLE __x),nearbyint,(__x))
#elif defined(__CRT_HAVE___rint) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,rintl,(__LONGDOUBLE __x),__rint,(__x))
#elif defined(__CRT_HAVE___nearbyint) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,rintl,(__LONGDOUBLE __x),__nearbyint,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_rint) || defined(__CRT_HAVE_nearbyint) || defined(__CRT_HAVE___rint) || defined(__CRT_HAVE___nearbyint) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/rintl.h>
__NAMESPACE_STD_BEGIN
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__NAMESPACE_LOCAL_USING_OR_IMPL(rintl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL rintl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(rintl))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_nextafterl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nextafterl)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nextafterl,(__LONGDOUBLE __x, __LONGDOUBLE __y),{ return __builtin_nextafterl(__x, __y); })
#elif __has_builtin(__builtin_nexttowardl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nexttowardl)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nextafterl,(__LONGDOUBLE __x, __LONGDOUBLE __y),nexttowardl,{ return __builtin_nexttowardl(__x); })
#elif defined(__CRT_HAVE_nextafterl)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nextafterl,(__LONGDOUBLE __x, __LONGDOUBLE __y),(__x,__y))
#elif defined(__CRT_HAVE_nexttowardl)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nextafterl,(__LONGDOUBLE __x, __LONGDOUBLE __y),nexttowardl,(__x,__y))
#elif defined(__CRT_HAVE___nextafterl)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nextafterl,(__LONGDOUBLE __x, __LONGDOUBLE __y),__nextafterl,(__x,__y))
#elif defined(__CRT_HAVE___nexttowardl)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nextafterl,(__LONGDOUBLE __x, __LONGDOUBLE __y),__nexttowardl,(__x,__y))
#elif defined(__CRT_HAVE_nextafter) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nextafterl,(__LONGDOUBLE __x, __LONGDOUBLE __y),nextafter,(__x,__y))
#elif defined(__CRT_HAVE_nexttoward) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nextafterl,(__LONGDOUBLE __x, __LONGDOUBLE __y),nexttoward,(__x,__y))
#elif defined(__CRT_HAVE___nextafter) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nextafterl,(__LONGDOUBLE __x, __LONGDOUBLE __y),__nextafter,(__x,__y))
#elif defined(__CRT_HAVE___nexttoward) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nextafterl,(__LONGDOUBLE __x, __LONGDOUBLE __y),__nexttoward,(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_nextafter) || defined(__CRT_HAVE_nexttoward) || defined(__CRT_HAVE___nextafter) || defined(__CRT_HAVE__nextafter) || defined(__CRT_HAVE___nexttoward) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/nextafterl.h>
__NAMESPACE_STD_BEGIN
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__NAMESPACE_LOCAL_USING_OR_IMPL(nextafterl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL nextafterl)(__LONGDOUBLE __x, __LONGDOUBLE __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(nextafterl))(__x, __y); })
#endif /* ... */
#if __has_builtin(__builtin_remainderl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_remainderl)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,remainderl,(__LONGDOUBLE __x, __LONGDOUBLE __p),{ return __builtin_remainderl(__x, __p); })
#elif __has_builtin(__builtin_dreml) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_dreml)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,remainderl,(__LONGDOUBLE __x, __LONGDOUBLE __p),dreml,{ return __builtin_dreml(__x, __p); })
#elif defined(__CRT_HAVE_remainderl)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,remainderl,(__LONGDOUBLE __x, __LONGDOUBLE __p),(__x,__p))
#elif defined(__CRT_HAVE_dreml)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,remainderl,(__LONGDOUBLE __x, __LONGDOUBLE __p),dreml,(__x,__p))
#elif defined(__CRT_HAVE___remainderl)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,remainderl,(__LONGDOUBLE __x, __LONGDOUBLE __p),__remainderl,(__x,__p))
#elif defined(__CRT_HAVE___dreml)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,remainderl,(__LONGDOUBLE __x, __LONGDOUBLE __p),__dreml,(__x,__p))
#elif defined(__CRT_HAVE_remainder) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,remainderl,(__LONGDOUBLE __x, __LONGDOUBLE __p),remainder,(__x,__p))
#elif defined(__CRT_HAVE_drem) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,remainderl,(__LONGDOUBLE __x, __LONGDOUBLE __p),drem,(__x,__p))
#elif defined(__CRT_HAVE___remainder) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,remainderl,(__LONGDOUBLE __x, __LONGDOUBLE __p),__remainder,(__x,__p))
#elif defined(__CRT_HAVE___drem) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,remainderl,(__LONGDOUBLE __x, __LONGDOUBLE __p),__drem,(__x,__p))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_remainder) || defined(__CRT_HAVE_drem) || defined(__CRT_HAVE___remainder) || defined(__CRT_HAVE___drem) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/remainderl.h>
__NAMESPACE_STD_BEGIN
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__NAMESPACE_LOCAL_USING_OR_IMPL(remainderl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL remainderl)(__LONGDOUBLE __x, __LONGDOUBLE __p) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(remainderl))(__x, __p); })
#endif /* ... */
#if __has_builtin(__builtin_ilogbl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_ilogbl)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CEIDECLARE(__ATTR_WUNUSED,int,__NOTHROW,ilogbl,(__LONGDOUBLE __x),{ return __builtin_ilogbl(__x); })
#elif defined(__CRT_HAVE_ilogbl)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CDECLARE(__ATTR_WUNUSED,int,__NOTHROW,ilogbl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE_llogb) && __SIZEOF_INT__ == __SIZEOF_LONG__ && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,ilogbl,(__LONGDOUBLE __x),llogb,(__x))
#elif defined(__CRT_HAVE_llogbl) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,ilogbl,(__LONGDOUBLE __x),llogbl,(__x))
#elif defined(__CRT_HAVE___ilogbl)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,ilogbl,(__LONGDOUBLE __x),__ilogbl,(__x))
#elif defined(__CRT_HAVE_ilogb) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,ilogbl,(__LONGDOUBLE __x),ilogb,(__x))
#elif defined(__CRT_HAVE___ilogb) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,ilogbl,(__LONGDOUBLE __x),__ilogb,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_ilogb) || (defined(__CRT_HAVE_llogb) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__CRT_HAVE___ilogb) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/ilogbl.h>
__NAMESPACE_STD_BEGIN
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__NAMESPACE_LOCAL_USING_OR_IMPL(ilogbl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED int __NOTHROW(__LIBCCALL ilogbl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(ilogbl))(__x); })
#endif /* ... */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_XOPEN_EXTENDED || __USE_ISOC99 */

#ifdef __USE_ISOC99
#if __has_builtin(__builtin_nexttoward) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nexttoward)
/* >> nexttowardf(3), nexttoward(3), nexttowardl(3) */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,nexttoward,(double __x, __LONGDOUBLE __y),{ return __builtin_nexttoward(__x, __y); })
#elif defined(__CRT_HAVE_nexttoward)
/* >> nexttowardf(3), nexttoward(3), nexttowardl(3) */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,nexttoward,(double __x, __LONGDOUBLE __y),(__x,__y))
#elif defined(__CRT_HAVE___nexttoward)
/* >> nexttowardf(3), nexttoward(3), nexttowardl(3) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,nexttoward,(double __x, __LONGDOUBLE __y),__nexttoward,(__x,__y))
#elif defined(__CRT_HAVE_nextafterl) || defined(__CRT_HAVE_nexttowardl) || defined(__CRT_HAVE___nextafterl) || defined(__CRT_HAVE___nexttowardl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_nextafter) || defined(__CRT_HAVE___nextafter) || defined(__CRT_HAVE__nextafter) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/nexttoward.h>
__NAMESPACE_STD_BEGIN
/* >> nexttowardf(3), nexttoward(3), nexttowardl(3) */
__NAMESPACE_LOCAL_USING_OR_IMPL(nexttoward, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL nexttoward)(double __x, __LONGDOUBLE __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(nexttoward))(__x, __y); })
#endif /* ... */
#if __has_builtin(__builtin_scalbn) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_scalbn)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,scalbn,(double __x, int __n),{ return __builtin_scalbn(__x, __n); })
#elif defined(__CRT_HAVE_scalbn)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,scalbn,(double __x, int __n),(__x,__n))
#elif defined(__CRT_HAVE___scalbn)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,scalbn,(double __x, int __n),__scalbn,(__x,__n))
#elif defined(__CRT_HAVE_scalbln) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,scalbn,(double __x, int __n),scalbln,(__x,__n))
#elif defined(__CRT_HAVE___scalbln) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,scalbn,(double __x, int __n),__scalbln,(__x,__n))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/scalbn.h>
__NAMESPACE_STD_BEGIN
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__NAMESPACE_LOCAL_USING_OR_IMPL(scalbn, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL scalbn)(double __x, int __n) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(scalbn))(__x, __n); })
#endif /* ... */
#if __has_builtin(__builtin_scalbln) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_scalbln)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,scalbln,(double __x, long int __n),{ return __builtin_scalbln(__x, __n); })
#elif defined(__CRT_HAVE_scalbln)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,scalbln,(double __x, long int __n),(__x,__n))
#elif defined(__CRT_HAVE___scalbln)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,scalbln,(double __x, long int __n),__scalbln,(__x,__n))
#elif defined(__CRT_HAVE_scalbn) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,scalbln,(double __x, long int __n),scalbn,(__x,__n))
#elif defined(__CRT_HAVE___scalbn) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,scalbln,(double __x, long int __n),__scalbn,(__x,__n))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/scalbln.h>
__NAMESPACE_STD_BEGIN
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__NAMESPACE_LOCAL_USING_OR_IMPL(scalbln, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL scalbln)(double __x, long int __n) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(scalbln))(__x, __n); })
#endif /* ... */
#if __has_builtin(__builtin_nearbyint) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nearbyint)
/* >> nearbyintf(3), nearbyint(3), nearbyintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode
 * This function is similar to `rint()', but does not tend to produce wrong results (so use this one) */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,nearbyint,(double __x),{ return __builtin_nearbyint(__x); })
#elif defined(__CRT_HAVE_nearbyint)
/* >> nearbyintf(3), nearbyint(3), nearbyintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode
 * This function is similar to `rint()', but does not tend to produce wrong results (so use this one) */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,nearbyint,(double __x),(__x))
#elif defined(__CRT_HAVE___nearbyint)
/* >> nearbyintf(3), nearbyint(3), nearbyintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode
 * This function is similar to `rint()', but does not tend to produce wrong results (so use this one) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,nearbyint,(double __x),__nearbyint,(__x))
#elif defined(__CRT_HAVE_rint)
/* >> nearbyintf(3), nearbyint(3), nearbyintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode
 * This function is similar to `rint()', but does not tend to produce wrong results (so use this one) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,nearbyint,(double __x),rint,(__x))
#elif defined(__CRT_HAVE___rint)
/* >> nearbyintf(3), nearbyint(3), nearbyintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode
 * This function is similar to `rint()', but does not tend to produce wrong results (so use this one) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,nearbyint,(double __x),__rint,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/rint.h>
__NAMESPACE_STD_BEGIN
/* >> nearbyintf(3), nearbyint(3), nearbyintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode
 * This function is similar to `rint()', but does not tend to produce wrong results (so use this one) */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL nearbyint)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(rint))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_round) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_round)
/* >> roundf(3), round(3), roundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,round,(double __x),{ return __builtin_round(__x); })
#elif defined(__CRT_HAVE_round)
/* >> roundf(3), round(3), roundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,round,(double __x),(__x))
#elif defined(__CRT_HAVE___round)
/* >> roundf(3), round(3), roundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,round,(double __x),__round,(__x))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/round.h>
__NAMESPACE_STD_BEGIN
/* >> roundf(3), round(3), roundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__NAMESPACE_LOCAL_USING_OR_IMPL(round, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL round)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(round))(__x); })
#endif /* !... */
#if __has_builtin(__builtin_trunc) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_trunc)
/* >> truncf(3), trunc(3), truncl(3)
 * Round `x' to the integral value in floating-point
 * format   nearest  but  not  larger  in  magnitude */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,trunc,(double __x),{ return __builtin_trunc(__x); })
#elif defined(__CRT_HAVE_trunc)
/* >> truncf(3), trunc(3), truncl(3)
 * Round `x' to the integral value in floating-point
 * format   nearest  but  not  larger  in  magnitude */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,trunc,(double __x),(__x))
#elif defined(__CRT_HAVE___trunc)
/* >> truncf(3), trunc(3), truncl(3)
 * Round `x' to the integral value in floating-point
 * format   nearest  but  not  larger  in  magnitude */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,trunc,(double __x),__trunc,(__x))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/trunc.h>
__NAMESPACE_STD_BEGIN
/* >> truncf(3), trunc(3), truncl(3)
 * Round `x' to the integral value in floating-point
 * format   nearest  but  not  larger  in  magnitude */
__NAMESPACE_LOCAL_USING_OR_IMPL(trunc, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL trunc)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(trunc))(__x); })
#endif /* !... */
#if __has_builtin(__builtin_remquo) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_remquo)
/* >> remquof(3), remquo(3), remquol(3)
 * Compute remainder of `x' and `p' and put in `*pquo' a value with
 * sign of x/p and magnitude  congruent `mod 2^n' to the  magnitude
 * of the integral quotient x/p, with n >= 3 */
__CEIDECLARE(__ATTR_WUNUSED __ATTR_OUT(3),double,__NOTHROW,remquo,(double __x, double __p, int *__pquo),{ return __builtin_remquo(__x, __p, __pquo); })
#elif defined(__CRT_HAVE_remquo)
/* >> remquof(3), remquo(3), remquol(3)
 * Compute remainder of `x' and `p' and put in `*pquo' a value with
 * sign of x/p and magnitude  congruent `mod 2^n' to the  magnitude
 * of the integral quotient x/p, with n >= 3 */
__CDECLARE(__ATTR_WUNUSED __ATTR_OUT(3),double,__NOTHROW,remquo,(double __x, double __p, int *__pquo),(__x,__p,__pquo))
#elif defined(__CRT_HAVE___remquo)
/* >> remquof(3), remquo(3), remquol(3)
 * Compute remainder of `x' and `p' and put in `*pquo' a value with
 * sign of x/p and magnitude  congruent `mod 2^n' to the  magnitude
 * of the integral quotient x/p, with n >= 3 */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(3),double,__NOTHROW,remquo,(double __x, double __p, int *__pquo),__remquo,(__x,__p,__pquo))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/remquo.h>
__NAMESPACE_STD_BEGIN
/* >> remquof(3), remquo(3), remquol(3)
 * Compute remainder of `x' and `p' and put in `*pquo' a value with
 * sign of x/p and magnitude  congruent `mod 2^n' to the  magnitude
 * of the integral quotient x/p, with n >= 3 */
__NAMESPACE_LOCAL_USING_OR_IMPL(remquo, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __ATTR_OUT(3) double __NOTHROW(__LIBCCALL remquo)(double __x, double __p, int *__pquo) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(remquo))(__x, __p, __pquo); })
#endif /* ... */
#if __has_builtin(__builtin_lrint) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_lrint)
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrint,(double __x),{ return __builtin_lrint(__x); })
#elif defined(__CRT_HAVE_lrint)
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrint,(double __x),(__x))
#elif defined(__CRT_HAVE___lrint)
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrint,(double __x),__lrint,(__x))
#elif defined(__CRT_HAVE_llrint) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrint,(double __x),llrint,(__x))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/lrint.h>
__NAMESPACE_STD_BEGIN
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__NAMESPACE_LOCAL_USING_OR_IMPL(lrint, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED long int __NOTHROW(__LIBCCALL lrint)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(lrint))(__x); })
#endif /* !... */
#if __has_builtin(__builtin_lround) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_lround)
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lround,(double __x),{ return __builtin_lround(__x); })
#elif defined(__CRT_HAVE_lround)
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lround,(double __x),(__x))
#elif defined(__CRT_HAVE___lround)
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lround,(double __x),__lround,(__x))
#elif defined(__CRT_HAVE_llround) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lround,(double __x),llround,(__x))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/lround.h>
__NAMESPACE_STD_BEGIN
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__NAMESPACE_LOCAL_USING_OR_IMPL(lround, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED long int __NOTHROW(__LIBCCALL lround)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(lround))(__x); })
#endif /* !... */
#if __has_builtin(__builtin_fdim) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fdim)
/* >> fdimf(3), fdim(3), fdiml(3)
 * Return positive difference between `x' and `y' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,fdim,(double __x, double __y),{ return __builtin_fdim(__x, __y); })
#elif defined(__CRT_HAVE_fdim)
/* >> fdimf(3), fdim(3), fdiml(3)
 * Return positive difference between `x' and `y' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,fdim,(double __x, double __y),(__x,__y))
#elif defined(__CRT_HAVE___fdim)
/* >> fdimf(3), fdim(3), fdiml(3)
 * Return positive difference between `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,fdim,(double __x, double __y),__fdim,(__x,__y))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/fdim.h>
__NAMESPACE_STD_BEGIN
/* >> fdimf(3), fdim(3), fdiml(3)
 * Return positive difference between `x' and `y' */
__NAMESPACE_LOCAL_USING_OR_IMPL(fdim, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL fdim)(double __x, double __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fdim))(__x, __y); })
#endif /* !... */
#if __has_builtin(__builtin_fmax) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fmax)
/* >> fmaxf(3), fmax(3), fmaxl(3)
 * Return maximum numeric value from `x' and `y' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,fmax,(double __x, double __y),{ return __builtin_fmax(__x, __y); })
#elif defined(__CRT_HAVE_fmax)
/* >> fmaxf(3), fmax(3), fmaxl(3)
 * Return maximum numeric value from `x' and `y' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,fmax,(double __x, double __y),(__x,__y))
#elif defined(__CRT_HAVE___fmax)
/* >> fmaxf(3), fmax(3), fmaxl(3)
 * Return maximum numeric value from `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,fmax,(double __x, double __y),__fmax,(__x,__y))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/fmax.h>
__NAMESPACE_STD_BEGIN
/* >> fmaxf(3), fmax(3), fmaxl(3)
 * Return maximum numeric value from `x' and `y' */
__NAMESPACE_LOCAL_USING_OR_IMPL(fmax, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL fmax)(double __x, double __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fmax))(__x, __y); })
#endif /* !... */
#if __has_builtin(__builtin_fmin) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fmin)
/* >> fminf(3), fmin(3), fminl(3)
 * Return minimum numeric value from `x' and `y' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,fmin,(double __x, double __y),{ return __builtin_fmin(__x, __y); })
#elif defined(__CRT_HAVE_fmin)
/* >> fminf(3), fmin(3), fminl(3)
 * Return minimum numeric value from `x' and `y' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,fmin,(double __x, double __y),(__x,__y))
#elif defined(__CRT_HAVE___fmin)
/* >> fminf(3), fmin(3), fminl(3)
 * Return minimum numeric value from `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,fmin,(double __x, double __y),__fmin,(__x,__y))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/fmin.h>
__NAMESPACE_STD_BEGIN
/* >> fminf(3), fmin(3), fminl(3)
 * Return minimum numeric value from `x' and `y' */
__NAMESPACE_LOCAL_USING_OR_IMPL(fmin, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL fmin)(double __x, double __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fmin))(__x, __y); })
#endif /* !... */
#if __has_builtin(__builtin_fma) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fma)
/* >> fmaf(3), fma(3), fmal(3)
 * Multiply-add function computed as a ternary operation */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,fma,(double __x, double __y, double __z),{ return __builtin_fma(__x, __y, __z); })
#elif defined(__CRT_HAVE_fma)
/* >> fmaf(3), fma(3), fmal(3)
 * Multiply-add function computed as a ternary operation */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,fma,(double __x, double __y, double __z),(__x,__y,__z))
#elif defined(__CRT_HAVE___fma)
/* >> fmaf(3), fma(3), fmal(3)
 * Multiply-add function computed as a ternary operation */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,fma,(double __x, double __y, double __z),__fma,(__x,__y,__z))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/fma.h>
__NAMESPACE_STD_BEGIN
/* >> fmaf(3), fma(3), fmal(3)
 * Multiply-add function computed as a ternary operation */
__NAMESPACE_LOCAL_USING_OR_IMPL(fma, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL fma)(double __x, double __y, double __z) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fma))(__x, __y, __z); })
#endif /* !... */
#ifdef __COMPILER_HAVE_LONGLONG
#if __has_builtin(__builtin_llrint) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_llrint)
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrint,(double __x),{ return __builtin_llrint(__x); })
#elif defined(__CRT_HAVE_llrint)
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrint,(double __x),(__x))
#elif defined(__CRT_HAVE___llrint)
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrint,(double __x),__llrint,(__x))
#elif defined(__CRT_HAVE_lrint) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrint,(double __x),lrint,(__x))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/llrint.h>
__NAMESPACE_STD_BEGIN
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__NAMESPACE_LOCAL_USING_OR_IMPL(llrint, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGLONG __NOTHROW(__LIBCCALL llrint)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(llrint))(__x); })
#endif /* !... */
#if __has_builtin(__builtin_llround) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_llround)
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llround,(double __x),{ return __builtin_llround(__x); })
#elif defined(__CRT_HAVE_llround)
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llround,(double __x),(__x))
#elif defined(__CRT_HAVE___llround)
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llround,(double __x),__llround,(__x))
#elif defined(__CRT_HAVE_lround) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llround,(double __x),lround,(__x))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/llround.h>
__NAMESPACE_STD_BEGIN
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__NAMESPACE_LOCAL_USING_OR_IMPL(llround, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGLONG __NOTHROW(__LIBCCALL llround)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(llround))(__x); })
#endif /* !... */
#endif /* __COMPILER_HAVE_LONGLONG */
#if __has_builtin(__builtin_nexttowardf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nexttowardf)
/* >> nexttowardf(3), nexttoward(3), nexttowardl(3) */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nexttowardf,(float __x, __LONGDOUBLE __y),{ return __builtin_nexttowardf(__x, __y); })
#elif defined(__CRT_HAVE_nexttowardf)
/* >> nexttowardf(3), nexttoward(3), nexttowardl(3) */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nexttowardf,(float __x, __LONGDOUBLE __y),(__x,__y))
#elif defined(__CRT_HAVE___nexttowardf)
/* >> nexttowardf(3), nexttoward(3), nexttowardl(3) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nexttowardf,(float __x, __LONGDOUBLE __y),__nexttowardf,(__x,__y))
#elif ((defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__)) && defined(__IEEE854_LONG_DOUBLE_TYPE__)) || defined(__CRT_HAVE_nextafterl) || defined(__CRT_HAVE_nexttowardl) || defined(__CRT_HAVE___nextafterl) || defined(__CRT_HAVE___nexttowardl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_nextafter) || defined(__CRT_HAVE_nexttoward) || defined(__CRT_HAVE___nextafter) || defined(__CRT_HAVE__nextafter) || defined(__CRT_HAVE___nexttoward) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/nexttowardf.h>
__NAMESPACE_STD_BEGIN
/* >> nexttowardf(3), nexttoward(3), nexttowardl(3) */
__NAMESPACE_LOCAL_USING_OR_IMPL(nexttowardf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL nexttowardf)(float __x, __LONGDOUBLE __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(nexttowardf))(__x, __y); })
#endif /* ... */
#if __has_builtin(__builtin_scalbnf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_scalbnf)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,scalbnf,(float __x, int __n),{ return __builtin_scalbnf(__x, __n); })
#elif defined(__CRT_HAVE_scalbnf)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,scalbnf,(float __x, int __n),(__x,__n))
#elif defined(__CRT_HAVE___scalbnf)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,scalbnf,(float __x, int __n),__scalbnf,(__x,__n))
#elif defined(__CRT_HAVE_scalblnf) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,scalbnf,(float __x, int __n),scalblnf,(__x,__n))
#elif defined(__CRT_HAVE___scalblnf) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,scalbnf,(float __x, int __n),__scalblnf,(__x,__n))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_scalbn) || defined(__CRT_HAVE___scalbn) || (defined(__CRT_HAVE_scalbln) && __SIZEOF_INT__ == __SIZEOF_LONG__) || (defined(__CRT_HAVE___scalbln) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/scalbnf.h>
__NAMESPACE_STD_BEGIN
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__NAMESPACE_LOCAL_USING_OR_IMPL(scalbnf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL scalbnf)(float __x, int __n) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(scalbnf))(__x, __n); })
#endif /* ... */
#if __has_builtin(__builtin_scalblnf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_scalblnf)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,scalblnf,(float __x, long int __n),{ return __builtin_scalblnf(__x, __n); })
#elif defined(__CRT_HAVE_scalblnf)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,scalblnf,(float __x, long int __n),(__x,__n))
#elif defined(__CRT_HAVE___scalblnf)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,scalblnf,(float __x, long int __n),__scalblnf,(__x,__n))
#elif defined(__CRT_HAVE_scalbnf) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,scalblnf,(float __x, long int __n),scalbnf,(__x,__n))
#elif defined(__CRT_HAVE___scalbnf) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,scalblnf,(float __x, long int __n),__scalbnf,(__x,__n))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_scalbln) || defined(__CRT_HAVE___scalbln) || (defined(__CRT_HAVE_scalbn) && __SIZEOF_INT__ == __SIZEOF_LONG__) || (defined(__CRT_HAVE___scalbn) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/scalblnf.h>
__NAMESPACE_STD_BEGIN
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__NAMESPACE_LOCAL_USING_OR_IMPL(scalblnf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL scalblnf)(float __x, long int __n) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(scalblnf))(__x, __n); })
#endif /* ... */
#if __has_builtin(__builtin_nearbyintf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nearbyintf)
/* >> nearbyintf(3), nearbyint(3), nearbyintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode
 * This function is similar to `rint()', but does not tend to produce wrong results (so use this one) */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nearbyintf,(float __x),{ return __builtin_nearbyintf(__x); })
#elif defined(__CRT_HAVE_nearbyintf)
/* >> nearbyintf(3), nearbyint(3), nearbyintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode
 * This function is similar to `rint()', but does not tend to produce wrong results (so use this one) */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nearbyintf,(float __x),(__x))
#elif defined(__CRT_HAVE___nearbyintf)
/* >> nearbyintf(3), nearbyint(3), nearbyintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode
 * This function is similar to `rint()', but does not tend to produce wrong results (so use this one) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nearbyintf,(float __x),__nearbyintf,(__x))
#elif defined(__CRT_HAVE_rintf)
/* >> nearbyintf(3), nearbyint(3), nearbyintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode
 * This function is similar to `rint()', but does not tend to produce wrong results (so use this one) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nearbyintf,(float __x),rintf,(__x))
#elif defined(__CRT_HAVE___rintf)
/* >> nearbyintf(3), nearbyint(3), nearbyintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode
 * This function is similar to `rint()', but does not tend to produce wrong results (so use this one) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nearbyintf,(float __x),__rintf,(__x))
#elif defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__)
__NAMESPACE_STD_END
#include <libc/local/math/rintf.h>
__NAMESPACE_STD_BEGIN
/* >> nearbyintf(3), nearbyint(3), nearbyintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode
 * This function is similar to `rint()', but does not tend to produce wrong results (so use this one) */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL nearbyintf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(rintf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_roundf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_roundf)
/* >> roundf(3), round(3), roundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,roundf,(float __x),{ return __builtin_roundf(__x); })
#elif defined(__CRT_HAVE_roundf)
/* >> roundf(3), round(3), roundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,roundf,(float __x),(__x))
#elif defined(__CRT_HAVE___roundf)
/* >> roundf(3), round(3), roundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,roundf,(float __x),__roundf,(__x))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/roundf.h>
__NAMESPACE_STD_BEGIN
/* >> roundf(3), round(3), roundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__NAMESPACE_LOCAL_USING_OR_IMPL(roundf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL roundf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(roundf))(__x); })
#endif /* !... */
#if __has_builtin(__builtin_truncf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_truncf)
/* >> truncf(3), trunc(3), truncl(3)
 * Round `x' to the integral value in floating-point
 * format   nearest  but  not  larger  in  magnitude */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,truncf,(float __x),{ return __builtin_truncf(__x); })
#elif defined(__CRT_HAVE_truncf)
/* >> truncf(3), trunc(3), truncl(3)
 * Round `x' to the integral value in floating-point
 * format   nearest  but  not  larger  in  magnitude */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,truncf,(float __x),(__x))
#elif defined(__CRT_HAVE___truncf)
/* >> truncf(3), trunc(3), truncl(3)
 * Round `x' to the integral value in floating-point
 * format   nearest  but  not  larger  in  magnitude */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,truncf,(float __x),__truncf,(__x))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/truncf.h>
__NAMESPACE_STD_BEGIN
/* >> truncf(3), trunc(3), truncl(3)
 * Round `x' to the integral value in floating-point
 * format   nearest  but  not  larger  in  magnitude */
__NAMESPACE_LOCAL_USING_OR_IMPL(truncf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL truncf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(truncf))(__x); })
#endif /* !... */
#if __has_builtin(__builtin_remquof) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_remquof)
/* >> remquof(3), remquo(3), remquol(3)
 * Compute remainder of `x' and `p' and put in `*pquo' a value with
 * sign of x/p and magnitude  congruent `mod 2^n' to the  magnitude
 * of the integral quotient x/p, with n >= 3 */
__CEIDECLARE(__ATTR_WUNUSED __ATTR_OUT(3),float,__NOTHROW,remquof,(float __x, float __p, int *__pquo),{ return __builtin_remquof(__x, __p, __pquo); })
#elif defined(__CRT_HAVE_remquof)
/* >> remquof(3), remquo(3), remquol(3)
 * Compute remainder of `x' and `p' and put in `*pquo' a value with
 * sign of x/p and magnitude  congruent `mod 2^n' to the  magnitude
 * of the integral quotient x/p, with n >= 3 */
__CDECLARE(__ATTR_WUNUSED __ATTR_OUT(3),float,__NOTHROW,remquof,(float __x, float __p, int *__pquo),(__x,__p,__pquo))
#elif defined(__CRT_HAVE___remquof)
/* >> remquof(3), remquo(3), remquol(3)
 * Compute remainder of `x' and `p' and put in `*pquo' a value with
 * sign of x/p and magnitude  congruent `mod 2^n' to the  magnitude
 * of the integral quotient x/p, with n >= 3 */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(3),float,__NOTHROW,remquof,(float __x, float __p, int *__pquo),__remquof,(__x,__p,__pquo))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_remquo) || defined(__CRT_HAVE___remquo) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/remquof.h>
__NAMESPACE_STD_BEGIN
/* >> remquof(3), remquo(3), remquol(3)
 * Compute remainder of `x' and `p' and put in `*pquo' a value with
 * sign of x/p and magnitude  congruent `mod 2^n' to the  magnitude
 * of the integral quotient x/p, with n >= 3 */
__NAMESPACE_LOCAL_USING_OR_IMPL(remquof, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __ATTR_OUT(3) float __NOTHROW(__LIBCCALL remquof)(float __x, float __p, int *__pquo) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(remquof))(__x, __p, __pquo); })
#endif /* ... */
#if __has_builtin(__builtin_lrintf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_lrintf)
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrintf,(float __x),{ return __builtin_lrintf(__x); })
#elif defined(__CRT_HAVE_lrintf)
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrintf,(float __x),(__x))
#elif defined(__CRT_HAVE___lrintf)
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrintf,(float __x),__lrintf,(__x))
#elif defined(__CRT_HAVE_llrintf) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrintf,(float __x),llrintf,(__x))
#elif defined(__CRT_HAVE___llrintf) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrintf,(float __x),__llrintf,(__x))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/lrintf.h>
__NAMESPACE_STD_BEGIN
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__NAMESPACE_LOCAL_USING_OR_IMPL(lrintf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED long int __NOTHROW(__LIBCCALL lrintf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(lrintf))(__x); })
#endif /* !... */
#if __has_builtin(__builtin_lroundf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_lroundf)
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lroundf,(float __x),{ return __builtin_lroundf(__x); })
#elif defined(__CRT_HAVE_lroundf)
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lroundf,(float __x),(__x))
#elif defined(__CRT_HAVE___lroundf)
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lroundf,(float __x),__lroundf,(__x))
#elif defined(__CRT_HAVE_llroundf) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lroundf,(float __x),llroundf,(__x))
#elif defined(__CRT_HAVE___llroundf) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lroundf,(float __x),__llroundf,(__x))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/lroundf.h>
__NAMESPACE_STD_BEGIN
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__NAMESPACE_LOCAL_USING_OR_IMPL(lroundf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED long int __NOTHROW(__LIBCCALL lroundf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(lroundf))(__x); })
#endif /* !... */
#if __has_builtin(__builtin_fdimf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fdimf)
/* >> fdimf(3), fdim(3), fdiml(3)
 * Return positive difference between `x' and `y' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,fdimf,(float __x, float __y),{ return __builtin_fdimf(__x, __y); })
#elif defined(__CRT_HAVE_fdimf)
/* >> fdimf(3), fdim(3), fdiml(3)
 * Return positive difference between `x' and `y' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,fdimf,(float __x, float __y),(__x,__y))
#elif defined(__CRT_HAVE___fdimf)
/* >> fdimf(3), fdim(3), fdiml(3)
 * Return positive difference between `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,fdimf,(float __x, float __y),__fdimf,(__x,__y))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/fdimf.h>
__NAMESPACE_STD_BEGIN
/* >> fdimf(3), fdim(3), fdiml(3)
 * Return positive difference between `x' and `y' */
__NAMESPACE_LOCAL_USING_OR_IMPL(fdimf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL fdimf)(float __x, float __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fdimf))(__x, __y); })
#endif /* !... */
#if __has_builtin(__builtin_fmaxf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fmaxf)
/* >> fmaxf(3), fmax(3), fmaxl(3)
 * Return maximum numeric value from `x' and `y' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,fmaxf,(float __x, float __y),{ return __builtin_fmaxf(__x, __y); })
#elif defined(__CRT_HAVE_fmaxf)
/* >> fmaxf(3), fmax(3), fmaxl(3)
 * Return maximum numeric value from `x' and `y' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,fmaxf,(float __x, float __y),(__x,__y))
#elif defined(__CRT_HAVE___fmaxf)
/* >> fmaxf(3), fmax(3), fmaxl(3)
 * Return maximum numeric value from `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,fmaxf,(float __x, float __y),__fmaxf,(__x,__y))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/fmaxf.h>
__NAMESPACE_STD_BEGIN
/* >> fmaxf(3), fmax(3), fmaxl(3)
 * Return maximum numeric value from `x' and `y' */
__NAMESPACE_LOCAL_USING_OR_IMPL(fmaxf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL fmaxf)(float __x, float __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fmaxf))(__x, __y); })
#endif /* !... */
#if __has_builtin(__builtin_fminf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fminf)
/* >> fminf(3), fmin(3), fminl(3)
 * Return minimum numeric value from `x' and `y' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,fminf,(float __x, float __y),{ return __builtin_fminf(__x, __y); })
#elif defined(__CRT_HAVE_fminf)
/* >> fminf(3), fmin(3), fminl(3)
 * Return minimum numeric value from `x' and `y' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,fminf,(float __x, float __y),(__x,__y))
#elif defined(__CRT_HAVE___fminf)
/* >> fminf(3), fmin(3), fminl(3)
 * Return minimum numeric value from `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,fminf,(float __x, float __y),__fminf,(__x,__y))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/fminf.h>
__NAMESPACE_STD_BEGIN
/* >> fminf(3), fmin(3), fminl(3)
 * Return minimum numeric value from `x' and `y' */
__NAMESPACE_LOCAL_USING_OR_IMPL(fminf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL fminf)(float __x, float __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fminf))(__x, __y); })
#endif /* !... */
#if __has_builtin(__builtin_fmaf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fmaf)
/* >> fmaf(3), fma(3), fmal(3)
 * Multiply-add function computed as a ternary operation */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,fmaf,(float __x, float __y, float __z),{ return __builtin_fmaf(__x, __y, __z); })
#elif defined(__CRT_HAVE_fmaf)
/* >> fmaf(3), fma(3), fmal(3)
 * Multiply-add function computed as a ternary operation */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,fmaf,(float __x, float __y, float __z),(__x,__y,__z))
#elif defined(__CRT_HAVE___fmaf)
/* >> fmaf(3), fma(3), fmal(3)
 * Multiply-add function computed as a ternary operation */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,fmaf,(float __x, float __y, float __z),__fmaf,(__x,__y,__z))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/fmaf.h>
__NAMESPACE_STD_BEGIN
/* >> fmaf(3), fma(3), fmal(3)
 * Multiply-add function computed as a ternary operation */
__NAMESPACE_LOCAL_USING_OR_IMPL(fmaf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL fmaf)(float __x, float __y, float __z) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fmaf))(__x, __y, __z); })
#endif /* !... */
#ifdef __COMPILER_HAVE_LONGLONG
#if __has_builtin(__builtin_llrintf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_llrintf)
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrintf,(float __x),{ return __builtin_llrintf(__x); })
#elif defined(__CRT_HAVE_llrintf)
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrintf,(float __x),(__x))
#elif defined(__CRT_HAVE___llrintf)
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrintf,(float __x),__llrintf,(__x))
#elif defined(__CRT_HAVE_lrintf) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrintf,(float __x),lrintf,(__x))
#elif defined(__CRT_HAVE___lrintf) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrintf,(float __x),__lrintf,(__x))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/llrintf.h>
__NAMESPACE_STD_BEGIN
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__NAMESPACE_LOCAL_USING_OR_IMPL(llrintf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGLONG __NOTHROW(__LIBCCALL llrintf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(llrintf))(__x); })
#endif /* !... */
#if __has_builtin(__builtin_llroundf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_llroundf)
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llroundf,(float __x),{ return __builtin_llroundf(__x); })
#elif defined(__CRT_HAVE_llroundf)
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llroundf,(float __x),(__x))
#elif defined(__CRT_HAVE___llroundf)
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llroundf,(float __x),__llroundf,(__x))
#elif defined(__CRT_HAVE_lroundf) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llroundf,(float __x),lroundf,(__x))
#elif defined(__CRT_HAVE___lroundf) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llroundf,(float __x),__lroundf,(__x))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/llroundf.h>
__NAMESPACE_STD_BEGIN
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__NAMESPACE_LOCAL_USING_OR_IMPL(llroundf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGLONG __NOTHROW(__LIBCCALL llroundf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(llroundf))(__x); })
#endif /* !... */
#endif /* __COMPILER_HAVE_LONGLONG */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if __has_builtin(__builtin_nextafterl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nextafterl)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nexttowardl,(__LONGDOUBLE __x, __LONGDOUBLE __y),nextafterl,{ return __builtin_nextafterl(__x, __y); })
#elif __has_builtin(__builtin_nexttowardl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nexttowardl)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nexttowardl,(__LONGDOUBLE __x, __LONGDOUBLE __y),{ return __builtin_nexttowardl(__x); })
#elif defined(__CRT_HAVE_nextafterl)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nexttowardl,(__LONGDOUBLE __x, __LONGDOUBLE __y),nextafterl,(__x,__y))
#elif defined(__CRT_HAVE_nexttowardl)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nexttowardl,(__LONGDOUBLE __x, __LONGDOUBLE __y),(__x,__y))
#elif defined(__CRT_HAVE___nextafterl)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nexttowardl,(__LONGDOUBLE __x, __LONGDOUBLE __y),__nextafterl,(__x,__y))
#elif defined(__CRT_HAVE___nexttowardl)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nexttowardl,(__LONGDOUBLE __x, __LONGDOUBLE __y),__nexttowardl,(__x,__y))
#elif defined(__CRT_HAVE_nextafter) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nexttowardl,(__LONGDOUBLE __x, __LONGDOUBLE __y),nextafter,(__x,__y))
#elif defined(__CRT_HAVE_nexttoward) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nexttowardl,(__LONGDOUBLE __x, __LONGDOUBLE __y),nexttoward,(__x,__y))
#elif defined(__CRT_HAVE___nextafter) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nexttowardl,(__LONGDOUBLE __x, __LONGDOUBLE __y),__nextafter,(__x,__y))
#elif defined(__CRT_HAVE___nexttoward) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nexttowardl,(__LONGDOUBLE __x, __LONGDOUBLE __y),__nexttoward,(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_nextafter) || defined(__CRT_HAVE_nexttoward) || defined(__CRT_HAVE___nextafter) || defined(__CRT_HAVE__nextafter) || defined(__CRT_HAVE___nexttoward) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/nextafterl.h>
__NAMESPACE_STD_BEGIN
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL nexttowardl)(__LONGDOUBLE __x, __LONGDOUBLE __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(nextafterl))(__x, __y); }
#endif /* ... */
#if __has_builtin(__builtin_scalbnl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_scalbnl)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbnl,(__LONGDOUBLE __x, int __n),{ return __builtin_scalbnl(__x, __n); })
#elif defined(__CRT_HAVE_scalbnl)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbnl,(__LONGDOUBLE __x, int __n),(__x,__n))
#elif defined(__CRT_HAVE___scalbnl)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbnl,(__LONGDOUBLE __x, int __n),__scalbnl,(__x,__n))
#elif defined(__CRT_HAVE_scalbln) && __SIZEOF_INT__ == __SIZEOF_LONG__ && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbnl,(__LONGDOUBLE __x, int __n),scalbln,(__x,__n))
#elif defined(__CRT_HAVE___scalbln) && __SIZEOF_INT__ == __SIZEOF_LONG__ && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbnl,(__LONGDOUBLE __x, int __n),__scalbln,(__x,__n))
#elif defined(__CRT_HAVE_scalblnl) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbnl,(__LONGDOUBLE __x, int __n),scalblnl,(__x,__n))
#elif defined(__CRT_HAVE___scalblnl) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbnl,(__LONGDOUBLE __x, int __n),__scalblnl,(__x,__n))
#elif defined(__CRT_HAVE_scalbn) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbnl,(__LONGDOUBLE __x, int __n),scalbn,(__x,__n))
#elif defined(__CRT_HAVE___scalbn) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbnl,(__LONGDOUBLE __x, int __n),__scalbn,(__x,__n))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_scalbn) || defined(__CRT_HAVE___scalbn) || (defined(__CRT_HAVE_scalbln) && __SIZEOF_INT__ == __SIZEOF_LONG__) || (defined(__CRT_HAVE___scalbln) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/scalbnl.h>
__NAMESPACE_STD_BEGIN
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__NAMESPACE_LOCAL_USING_OR_IMPL(scalbnl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL scalbnl)(__LONGDOUBLE __x, int __n) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(scalbnl))(__x, __n); })
#endif /* ... */
#if __has_builtin(__builtin_scalblnl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_scalblnl)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalblnl,(__LONGDOUBLE __x, long int __n),{ return __builtin_scalblnl(__x, __n); })
#elif defined(__CRT_HAVE_scalblnl)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalblnl,(__LONGDOUBLE __x, long int __n),(__x,__n))
#elif defined(__CRT_HAVE___scalblnl)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalblnl,(__LONGDOUBLE __x, long int __n),__scalblnl,(__x,__n))
#elif defined(__CRT_HAVE_scalbn) && __SIZEOF_INT__ == __SIZEOF_LONG__ && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalblnl,(__LONGDOUBLE __x, long int __n),scalbn,(__x,__n))
#elif defined(__CRT_HAVE_scalbnl) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalblnl,(__LONGDOUBLE __x, long int __n),scalbnl,(__x,__n))
#elif defined(__CRT_HAVE___scalbn) && __SIZEOF_INT__ == __SIZEOF_LONG__ && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalblnl,(__LONGDOUBLE __x, long int __n),__scalbn,(__x,__n))
#elif defined(__CRT_HAVE___scalbnl) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalblnl,(__LONGDOUBLE __x, long int __n),__scalbnl,(__x,__n))
#elif defined(__CRT_HAVE_scalbln) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalblnl,(__LONGDOUBLE __x, long int __n),scalbln,(__x,__n))
#elif defined(__CRT_HAVE___scalbln) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalblnl,(__LONGDOUBLE __x, long int __n),__scalbln,(__x,__n))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_scalbln) || defined(__CRT_HAVE___scalbln) || (defined(__CRT_HAVE_scalbn) && __SIZEOF_INT__ == __SIZEOF_LONG__) || (defined(__CRT_HAVE___scalbn) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/scalblnl.h>
__NAMESPACE_STD_BEGIN
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__NAMESPACE_LOCAL_USING_OR_IMPL(scalblnl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL scalblnl)(__LONGDOUBLE __x, long int __n) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(scalblnl))(__x, __n); })
#endif /* ... */
#if __has_builtin(__builtin_nearbyintl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nearbyintl)
/* >> nearbyintf(3), nearbyint(3), nearbyintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode
 * This function is similar to `rint()', but does not tend to produce wrong results (so use this one) */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nearbyintl,(__LONGDOUBLE __x),{ return __builtin_nearbyintl(__x); })
#elif defined(__CRT_HAVE_nearbyintl)
/* >> nearbyintf(3), nearbyint(3), nearbyintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode
 * This function is similar to `rint()', but does not tend to produce wrong results (so use this one) */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nearbyintl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___nearbyintl)
/* >> nearbyintf(3), nearbyint(3), nearbyintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode
 * This function is similar to `rint()', but does not tend to produce wrong results (so use this one) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nearbyintl,(__LONGDOUBLE __x),__nearbyintl,(__x))
#elif defined(__CRT_HAVE_rintl)
/* >> nearbyintf(3), nearbyint(3), nearbyintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode
 * This function is similar to `rint()', but does not tend to produce wrong results (so use this one) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nearbyintl,(__LONGDOUBLE __x),rintl,(__x))
#elif defined(__CRT_HAVE___rintl)
/* >> nearbyintf(3), nearbyint(3), nearbyintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode
 * This function is similar to `rint()', but does not tend to produce wrong results (so use this one) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nearbyintl,(__LONGDOUBLE __x),__rintl,(__x))
#elif defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/rintl.h>
__NAMESPACE_STD_BEGIN
/* >> nearbyintf(3), nearbyint(3), nearbyintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode
 * This function is similar to `rint()', but does not tend to produce wrong results (so use this one) */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL nearbyintl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(rintl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_roundl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_roundl)
/* >> roundf(3), round(3), roundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,roundl,(__LONGDOUBLE __x),{ return __builtin_roundl(__x); })
#elif defined(__CRT_HAVE_roundl)
/* >> roundf(3), round(3), roundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,roundl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___roundl)
/* >> roundf(3), round(3), roundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,roundl,(__LONGDOUBLE __x),__roundl,(__x))
#elif defined(__CRT_HAVE_round) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> roundf(3), round(3), roundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,roundl,(__LONGDOUBLE __x),round,(__x))
#elif defined(__CRT_HAVE___round) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> roundf(3), round(3), roundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,roundl,(__LONGDOUBLE __x),__round,(__x))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/roundl.h>
__NAMESPACE_STD_BEGIN
/* >> roundf(3), round(3), roundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__NAMESPACE_LOCAL_USING_OR_IMPL(roundl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL roundl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(roundl))(__x); })
#endif /* !... */
#if __has_builtin(__builtin_truncl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_truncl)
/* >> truncf(3), trunc(3), truncl(3)
 * Round `x' to the integral value in floating-point
 * format   nearest  but  not  larger  in  magnitude */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,truncl,(__LONGDOUBLE __x),{ return __builtin_truncl(__x); })
#elif defined(__CRT_HAVE_truncl)
/* >> truncf(3), trunc(3), truncl(3)
 * Round `x' to the integral value in floating-point
 * format   nearest  but  not  larger  in  magnitude */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,truncl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___truncl)
/* >> truncf(3), trunc(3), truncl(3)
 * Round `x' to the integral value in floating-point
 * format   nearest  but  not  larger  in  magnitude */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,truncl,(__LONGDOUBLE __x),__truncl,(__x))
#elif defined(__CRT_HAVE_trunc) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> truncf(3), trunc(3), truncl(3)
 * Round `x' to the integral value in floating-point
 * format   nearest  but  not  larger  in  magnitude */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,truncl,(__LONGDOUBLE __x),trunc,(__x))
#elif defined(__CRT_HAVE___trunc) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> truncf(3), trunc(3), truncl(3)
 * Round `x' to the integral value in floating-point
 * format   nearest  but  not  larger  in  magnitude */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,truncl,(__LONGDOUBLE __x),__trunc,(__x))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/truncl.h>
__NAMESPACE_STD_BEGIN
/* >> truncf(3), trunc(3), truncl(3)
 * Round `x' to the integral value in floating-point
 * format   nearest  but  not  larger  in  magnitude */
__NAMESPACE_LOCAL_USING_OR_IMPL(truncl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL truncl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(truncl))(__x); })
#endif /* !... */
#if __has_builtin(__builtin_remquol) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_remquol)
/* >> remquof(3), remquo(3), remquol(3)
 * Compute remainder of `x' and `p' and put in `*pquo' a value with
 * sign of x/p and magnitude  congruent `mod 2^n' to the  magnitude
 * of the integral quotient x/p, with n >= 3 */
__CEIDECLARE(__ATTR_WUNUSED __ATTR_OUT(3),__LONGDOUBLE,__NOTHROW,remquol,(__LONGDOUBLE __x, __LONGDOUBLE __p, int *__pquo),{ return __builtin_remquol(__x, __p, __pquo); })
#elif defined(__CRT_HAVE_remquol)
/* >> remquof(3), remquo(3), remquol(3)
 * Compute remainder of `x' and `p' and put in `*pquo' a value with
 * sign of x/p and magnitude  congruent `mod 2^n' to the  magnitude
 * of the integral quotient x/p, with n >= 3 */
__CDECLARE(__ATTR_WUNUSED __ATTR_OUT(3),__LONGDOUBLE,__NOTHROW,remquol,(__LONGDOUBLE __x, __LONGDOUBLE __p, int *__pquo),(__x,__p,__pquo))
#elif defined(__CRT_HAVE___remquol)
/* >> remquof(3), remquo(3), remquol(3)
 * Compute remainder of `x' and `p' and put in `*pquo' a value with
 * sign of x/p and magnitude  congruent `mod 2^n' to the  magnitude
 * of the integral quotient x/p, with n >= 3 */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(3),__LONGDOUBLE,__NOTHROW,remquol,(__LONGDOUBLE __x, __LONGDOUBLE __p, int *__pquo),__remquol,(__x,__p,__pquo))
#elif defined(__CRT_HAVE_remquo) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> remquof(3), remquo(3), remquol(3)
 * Compute remainder of `x' and `p' and put in `*pquo' a value with
 * sign of x/p and magnitude  congruent `mod 2^n' to the  magnitude
 * of the integral quotient x/p, with n >= 3 */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(3),__LONGDOUBLE,__NOTHROW,remquol,(__LONGDOUBLE __x, __LONGDOUBLE __p, int *__pquo),remquo,(__x,__p,__pquo))
#elif defined(__CRT_HAVE___remquo) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> remquof(3), remquo(3), remquol(3)
 * Compute remainder of `x' and `p' and put in `*pquo' a value with
 * sign of x/p and magnitude  congruent `mod 2^n' to the  magnitude
 * of the integral quotient x/p, with n >= 3 */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(3),__LONGDOUBLE,__NOTHROW,remquol,(__LONGDOUBLE __x, __LONGDOUBLE __p, int *__pquo),__remquo,(__x,__p,__pquo))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_remquo) || defined(__CRT_HAVE___remquo) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_END
#include <libc/local/math/remquol.h>
__NAMESPACE_STD_BEGIN
/* >> remquof(3), remquo(3), remquol(3)
 * Compute remainder of `x' and `p' and put in `*pquo' a value with
 * sign of x/p and magnitude  congruent `mod 2^n' to the  magnitude
 * of the integral quotient x/p, with n >= 3 */
__NAMESPACE_LOCAL_USING_OR_IMPL(remquol, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __ATTR_OUT(3) __LONGDOUBLE __NOTHROW(__LIBCCALL remquol)(__LONGDOUBLE __x, __LONGDOUBLE __p, int *__pquo) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(remquol))(__x, __p, __pquo); })
#endif /* ... */
#if __has_builtin(__builtin_lrintl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_lrintl)
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrintl,(__LONGDOUBLE __x),{ return __builtin_lrintl(__x); })
#elif defined(__CRT_HAVE_lrintl)
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrintl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___lrintl)
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrintl,(__LONGDOUBLE __x),__lrintl,(__x))
#elif defined(__CRT_HAVE_llrint) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__ && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrintl,(__LONGDOUBLE __x),llrint,(__x))
#elif defined(__CRT_HAVE___llrint) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__ && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrintl,(__LONGDOUBLE __x),__llrint,(__x))
#elif defined(__CRT_HAVE_llrintl) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrintl,(__LONGDOUBLE __x),llrintl,(__x))
#elif defined(__CRT_HAVE___llrintl) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrintl,(__LONGDOUBLE __x),__llrintl,(__x))
#elif defined(__CRT_HAVE_remquo) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrintl,(__LONGDOUBLE __x),remquo,(__x))
#elif defined(__CRT_HAVE___lrint) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrintl,(__LONGDOUBLE __x),__lrint,(__x))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/lrintl.h>
__NAMESPACE_STD_BEGIN
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__NAMESPACE_LOCAL_USING_OR_IMPL(lrintl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED long int __NOTHROW(__LIBCCALL lrintl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(lrintl))(__x); })
#endif /* !... */
#if __has_builtin(__builtin_lroundl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_lroundl)
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lroundl,(__LONGDOUBLE __x),{ return __builtin_lroundl(__x); })
#elif defined(__CRT_HAVE_lroundl)
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lroundl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___lroundl)
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lroundl,(__LONGDOUBLE __x),__lroundl,(__x))
#elif defined(__CRT_HAVE_llroundl) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lroundl,(__LONGDOUBLE __x),llroundl,(__x))
#elif defined(__CRT_HAVE___llroundl) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lroundl,(__LONGDOUBLE __x),__llroundl,(__x))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/lroundl.h>
__NAMESPACE_STD_BEGIN
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__NAMESPACE_LOCAL_USING_OR_IMPL(lroundl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED long int __NOTHROW(__LIBCCALL lroundl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(lroundl))(__x); })
#endif /* !... */
#if __has_builtin(__builtin_fdiml) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fdiml)
/* >> fdimf(3), fdim(3), fdiml(3)
 * Return positive difference between `x' and `y' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fdiml,(__LONGDOUBLE __x, __LONGDOUBLE __y),{ return __builtin_fdiml(__x, __y); })
#elif defined(__CRT_HAVE_fdiml)
/* >> fdimf(3), fdim(3), fdiml(3)
 * Return positive difference between `x' and `y' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fdiml,(__LONGDOUBLE __x, __LONGDOUBLE __y),(__x,__y))
#elif defined(__CRT_HAVE___fdiml)
/* >> fdimf(3), fdim(3), fdiml(3)
 * Return positive difference between `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fdiml,(__LONGDOUBLE __x, __LONGDOUBLE __y),__fdiml,(__x,__y))
#elif defined(__CRT_HAVE_fdim) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> fdimf(3), fdim(3), fdiml(3)
 * Return positive difference between `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fdiml,(__LONGDOUBLE __x, __LONGDOUBLE __y),fdim,(__x,__y))
#elif defined(__CRT_HAVE___fdim) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> fdimf(3), fdim(3), fdiml(3)
 * Return positive difference between `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fdiml,(__LONGDOUBLE __x, __LONGDOUBLE __y),__fdim,(__x,__y))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/fdiml.h>
__NAMESPACE_STD_BEGIN
/* >> fdimf(3), fdim(3), fdiml(3)
 * Return positive difference between `x' and `y' */
__NAMESPACE_LOCAL_USING_OR_IMPL(fdiml, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL fdiml)(__LONGDOUBLE __x, __LONGDOUBLE __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fdiml))(__x, __y); })
#endif /* !... */
#if __has_builtin(__builtin_fmaxl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fmaxl)
/* >> fmaxf(3), fmax(3), fmaxl(3)
 * Return maximum numeric value from `x' and `y' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fmaxl,(__LONGDOUBLE __x, __LONGDOUBLE __y),{ return __builtin_fmaxl(__x, __y); })
#elif defined(__CRT_HAVE_fmaxl)
/* >> fmaxf(3), fmax(3), fmaxl(3)
 * Return maximum numeric value from `x' and `y' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fmaxl,(__LONGDOUBLE __x, __LONGDOUBLE __y),(__x,__y))
#elif defined(__CRT_HAVE___fmaxl)
/* >> fmaxf(3), fmax(3), fmaxl(3)
 * Return maximum numeric value from `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fmaxl,(__LONGDOUBLE __x, __LONGDOUBLE __y),__fmaxl,(__x,__y))
#elif defined(__CRT_HAVE_fmax) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> fmaxf(3), fmax(3), fmaxl(3)
 * Return maximum numeric value from `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fmaxl,(__LONGDOUBLE __x, __LONGDOUBLE __y),fmax,(__x,__y))
#elif defined(__CRT_HAVE___fmax) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> fmaxf(3), fmax(3), fmaxl(3)
 * Return maximum numeric value from `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fmaxl,(__LONGDOUBLE __x, __LONGDOUBLE __y),__fmax,(__x,__y))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/fmaxl.h>
__NAMESPACE_STD_BEGIN
/* >> fmaxf(3), fmax(3), fmaxl(3)
 * Return maximum numeric value from `x' and `y' */
__NAMESPACE_LOCAL_USING_OR_IMPL(fmaxl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL fmaxl)(__LONGDOUBLE __x, __LONGDOUBLE __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fmaxl))(__x, __y); })
#endif /* !... */
#if __has_builtin(__builtin_fminl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fminl)
/* >> fminf(3), fmin(3), fminl(3)
 * Return minimum numeric value from `x' and `y' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fminl,(__LONGDOUBLE __x, __LONGDOUBLE __y),{ return __builtin_fminl(__x, __y); })
#elif defined(__CRT_HAVE_fminl)
/* >> fminf(3), fmin(3), fminl(3)
 * Return minimum numeric value from `x' and `y' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fminl,(__LONGDOUBLE __x, __LONGDOUBLE __y),(__x,__y))
#elif defined(__CRT_HAVE___fminl)
/* >> fminf(3), fmin(3), fminl(3)
 * Return minimum numeric value from `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fminl,(__LONGDOUBLE __x, __LONGDOUBLE __y),__fminl,(__x,__y))
#elif defined(__CRT_HAVE_fmin) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> fminf(3), fmin(3), fminl(3)
 * Return minimum numeric value from `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fminl,(__LONGDOUBLE __x, __LONGDOUBLE __y),fmin,(__x,__y))
#elif defined(__CRT_HAVE___fmin) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> fminf(3), fmin(3), fminl(3)
 * Return minimum numeric value from `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fminl,(__LONGDOUBLE __x, __LONGDOUBLE __y),__fmin,(__x,__y))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/fminl.h>
__NAMESPACE_STD_BEGIN
/* >> fminf(3), fmin(3), fminl(3)
 * Return minimum numeric value from `x' and `y' */
__NAMESPACE_LOCAL_USING_OR_IMPL(fminl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL fminl)(__LONGDOUBLE __x, __LONGDOUBLE __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fminl))(__x, __y); })
#endif /* !... */
#if __has_builtin(__builtin_fmal) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fmal)
/* >> fmaf(3), fma(3), fmal(3)
 * Multiply-add function computed as a ternary operation */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fmal,(__LONGDOUBLE __x, __LONGDOUBLE __y, __LONGDOUBLE __z),{ return __builtin_fmal(__x, __y, __z); })
#elif defined(__CRT_HAVE_fmal)
/* >> fmaf(3), fma(3), fmal(3)
 * Multiply-add function computed as a ternary operation */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fmal,(__LONGDOUBLE __x, __LONGDOUBLE __y, __LONGDOUBLE __z),(__x,__y,__z))
#elif defined(__CRT_HAVE___fmal)
/* >> fmaf(3), fma(3), fmal(3)
 * Multiply-add function computed as a ternary operation */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fmal,(__LONGDOUBLE __x, __LONGDOUBLE __y, __LONGDOUBLE __z),__fmal,(__x,__y,__z))
#elif defined(__CRT_HAVE_fma) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> fmaf(3), fma(3), fmal(3)
 * Multiply-add function computed as a ternary operation */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fmal,(__LONGDOUBLE __x, __LONGDOUBLE __y, __LONGDOUBLE __z),fma,(__x,__y,__z))
#elif defined(__CRT_HAVE___fma) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> fmaf(3), fma(3), fmal(3)
 * Multiply-add function computed as a ternary operation */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fmal,(__LONGDOUBLE __x, __LONGDOUBLE __y, __LONGDOUBLE __z),__fma,(__x,__y,__z))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/fmal.h>
__NAMESPACE_STD_BEGIN
/* >> fmaf(3), fma(3), fmal(3)
 * Multiply-add function computed as a ternary operation */
__NAMESPACE_LOCAL_USING_OR_IMPL(fmal, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL fmal)(__LONGDOUBLE __x, __LONGDOUBLE __y, __LONGDOUBLE __z) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fmal))(__x, __y, __z); })
#endif /* !... */
#ifdef __COMPILER_HAVE_LONGLONG
#if __has_builtin(__builtin_llrintl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_llrintl)
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrintl,(__LONGDOUBLE __x),{ return __builtin_llrintl(__x); })
#elif defined(__CRT_HAVE_llrintl)
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrintl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___llrintl)
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrintl,(__LONGDOUBLE __x),__llrintl,(__x))
#elif defined(__CRT_HAVE_lrint) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__ && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrintl,(__LONGDOUBLE __x),lrint,(__x))
#elif defined(__CRT_HAVE_lrintl) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrintl,(__LONGDOUBLE __x),lrintl,(__x))
#elif defined(__CRT_HAVE___lrint) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__ && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrintl,(__LONGDOUBLE __x),__lrint,(__x))
#elif defined(__CRT_HAVE___lrintl) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrintl,(__LONGDOUBLE __x),__lrintl,(__x))
#elif defined(__CRT_HAVE_llrint) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrintl,(__LONGDOUBLE __x),llrint,(__x))
#elif defined(__CRT_HAVE___llrint) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrintl,(__LONGDOUBLE __x),__llrint,(__x))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/llrintl.h>
__NAMESPACE_STD_BEGIN
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__NAMESPACE_LOCAL_USING_OR_IMPL(llrintl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGLONG __NOTHROW(__LIBCCALL llrintl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(llrintl))(__x); })
#endif /* !... */
#if __has_builtin(__builtin_llroundl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_llroundl)
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llroundl,(__LONGDOUBLE __x),{ return __builtin_llroundl(__x); })
#elif defined(__CRT_HAVE_llroundl)
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llroundl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___llroundl)
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llroundl,(__LONGDOUBLE __x),__llroundl,(__x))
#elif defined(__CRT_HAVE_lround) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__ && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llroundl,(__LONGDOUBLE __x),lround,(__x))
#elif defined(__CRT_HAVE_lroundl) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llroundl,(__LONGDOUBLE __x),lroundl,(__x))
#elif defined(__CRT_HAVE___lround) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__ && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llroundl,(__LONGDOUBLE __x),__lround,(__x))
#elif defined(__CRT_HAVE___lroundl) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llroundl,(__LONGDOUBLE __x),__lroundl,(__x))
#elif defined(__CRT_HAVE_llround) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llroundl,(__LONGDOUBLE __x),llround,(__x))
#elif defined(__CRT_HAVE___llround) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llroundl,(__LONGDOUBLE __x),__llround,(__x))
#else /* ... */
__NAMESPACE_STD_END
#include <libc/local/math/llroundl.h>
__NAMESPACE_STD_BEGIN
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__NAMESPACE_LOCAL_USING_OR_IMPL(llroundl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGLONG __NOTHROW(__LIBCCALL llroundl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(llroundl))(__x); })
#endif /* !... */
#endif /* __COMPILER_HAVE_LONGLONG */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_ISOC99 */
#if defined(__cplusplus) && defined(__CORRECT_ISO_CPP_MATH_H_PROTO)
extern "C++" {
#if __has_builtin(__builtin_acosf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_acosf)
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,acos,(float __x),acosf,{ return __builtin_acosf(__x); })
#elif defined(__CRT_HAVE_acosf)
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,acos,(float __x),acosf,(__x))
#elif defined(__CRT_HAVE___acosf)
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,acos,(float __x),__acosf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_acos) || defined(__CRT_HAVE___acos) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/acosf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL acos)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(acosf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_asinf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_asinf)
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,asin,(float __x),asinf,{ return __builtin_asinf(__x); })
#elif defined(__CRT_HAVE_asinf)
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,asin,(float __x),asinf,(__x))
#elif defined(__CRT_HAVE___asinf)
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,asin,(float __x),__asinf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_asin) || defined(__CRT_HAVE___asin) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/asinf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL asin)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(asinf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_atanf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_atanf)
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,atan,(float __x),atanf,{ return __builtin_atanf(__x); })
#elif defined(__CRT_HAVE_atanf)
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,atan,(float __x),atanf,(__x))
#elif defined(__CRT_HAVE___atanf)
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,atan,(float __x),__atanf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_atan) || defined(__CRT_HAVE___atan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/atanf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL atan)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(atanf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_atan2f) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_atan2f)
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,atan2,(float __y, float __x),atan2f,{ return __builtin_atan2f(__y, __x); })
#elif defined(__CRT_HAVE_atan2f)
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,atan2,(float __y, float __x),atan2f,(__y,__x))
#elif defined(__CRT_HAVE___atan2f)
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,atan2,(float __y, float __x),__atan2f,(__y,__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_atan2) || defined(__CRT_HAVE___atan2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/atan2f.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL atan2)(float __y, float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(atan2f))(__y, __x); }
#endif /* ... */
#if __has_builtin(__builtin_cosf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_cosf)
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__CEIREDIRECT(__ATTR_WUNUSED __DECL_SIMD_cosf,float,__NOTHROW,cos,(float __x),cosf,{ return __builtin_cosf(__x); })
#elif defined(__CRT_HAVE_cosf)
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_cosf,float,__NOTHROW,cos,(float __x),cosf,(__x))
#elif defined(__CRT_HAVE___cosf)
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_cosf,float,__NOTHROW,cos,(float __x),__cosf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_cos) || defined(__CRT_HAVE___cos) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/cosf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_cosf float __NOTHROW(__LIBCCALL cos)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(cosf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_sinf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_sinf)
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__CEIREDIRECT(__ATTR_WUNUSED __DECL_SIMD_sinf,float,__NOTHROW,sin,(float __x),sinf,{ return __builtin_sinf(__x); })
#elif defined(__CRT_HAVE_sinf)
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_sinf,float,__NOTHROW,sin,(float __x),sinf,(__x))
#elif defined(__CRT_HAVE___sinf)
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_sinf,float,__NOTHROW,sin,(float __x),__sinf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_sin) || defined(__CRT_HAVE___sin) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/sinf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_sinf float __NOTHROW(__LIBCCALL sin)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(sinf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_tanf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_tanf)
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,tan,(float __x),tanf,{ return __builtin_tanf(__x); })
#elif defined(__CRT_HAVE_tanf)
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,tan,(float __x),tanf,(__x))
#elif defined(__CRT_HAVE___tanf)
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,tan,(float __x),__tanf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_tan) || defined(__CRT_HAVE___tan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/tanf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL tan)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(tanf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_coshf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_coshf)
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,cosh,(float __x),coshf,{ return __builtin_coshf(__x); })
#elif defined(__CRT_HAVE_coshf)
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,cosh,(float __x),coshf,(__x))
#elif defined(__CRT_HAVE___coshf)
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,cosh,(float __x),__coshf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_cosh) || defined(__CRT_HAVE___cosh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/coshf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL cosh)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(coshf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_sinhf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_sinhf)
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,sinh,(float __x),sinhf,{ return __builtin_sinhf(__x); })
#elif defined(__CRT_HAVE_sinhf)
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,sinh,(float __x),sinhf,(__x))
#elif defined(__CRT_HAVE___sinhf)
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,sinh,(float __x),__sinhf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_sinh) || defined(__CRT_HAVE___sinh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/sinhf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL sinh)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(sinhf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_tanhf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_tanhf)
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,tanh,(float __x),tanhf,{ return __builtin_tanhf(__x); })
#elif defined(__CRT_HAVE_tanhf)
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,tanh,(float __x),tanhf,(__x))
#elif defined(__CRT_HAVE___tanhf)
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,tanh,(float __x),__tanhf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_tanh) || defined(__CRT_HAVE___tanh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/tanhf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL tanh)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(tanhf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_expf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_expf)
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__CEIREDIRECT(__ATTR_WUNUSED __DECL_SIMD_expf,float,__NOTHROW,exp,(float __x),expf,{ return __builtin_expf(__x); })
#elif defined(__CRT_HAVE_expf)
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_expf,float,__NOTHROW,exp,(float __x),expf,(__x))
#elif defined(__CRT_HAVE___expf)
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_expf,float,__NOTHROW,exp,(float __x),__expf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_exp) || defined(__CRT_HAVE___exp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/expf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_expf float __NOTHROW(__LIBCCALL exp)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(expf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_frexpf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_frexpf)
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__CEIREDIRECT(__ATTR_OUT(2),float,__NOTHROW_NCX,frexp,(float __x, int *__pexponent),frexpf,{ return __builtin_frexpf(__x, __pexponent); })
#elif defined(__CRT_HAVE_frexpf)
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__CREDIRECT(__ATTR_OUT(2),float,__NOTHROW_NCX,frexp,(float __x, int *__pexponent),frexpf,(__x,__pexponent))
#elif defined(__CRT_HAVE___frexpf)
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__CREDIRECT(__ATTR_OUT(2),float,__NOTHROW_NCX,frexp,(float __x, int *__pexponent),__frexpf,(__x,__pexponent))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_frexp) || defined(__CRT_HAVE___frexp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/frexpf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_OUT(2) float __NOTHROW_NCX(__LIBCCALL frexp)(float __x, int *__pexponent) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(frexpf))(__x, __pexponent); }
#endif /* ... */
#if __has_builtin(__builtin_ldexpf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_ldexpf)
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,ldexp,(float __x, int __exponent),ldexpf,{ return __builtin_ldexpf(__x, __exponent); })
#elif defined(__CRT_HAVE_ldexpf)
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,ldexp,(float __x, int __exponent),ldexpf,(__x,__exponent))
#elif defined(__CRT_HAVE___ldexpf)
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,ldexp,(float __x, int __exponent),__ldexpf,(__x,__exponent))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_ldexp) || defined(__CRT_HAVE___ldexp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/ldexpf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL ldexp)(float __x, int __exponent) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(ldexpf))(__x, __exponent); }
#endif /* ... */
#if __has_builtin(__builtin_logf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_logf)
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__CEIREDIRECT(__ATTR_WUNUSED __DECL_SIMD_logf,float,__NOTHROW,log,(float __x),logf,{ return __builtin_logf(__x); })
#elif defined(__CRT_HAVE_logf)
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_logf,float,__NOTHROW,log,(float __x),logf,(__x))
#elif defined(__CRT_HAVE___logf)
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_logf,float,__NOTHROW,log,(float __x),__logf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_log) || defined(__CRT_HAVE___log) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/logf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_logf float __NOTHROW(__LIBCCALL log)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(logf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_log10f) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_log10f)
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,log10,(float __x),log10f,{ return __builtin_log10f(__x); })
#elif defined(__CRT_HAVE_log10f)
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,log10,(float __x),log10f,(__x))
#elif defined(__CRT_HAVE___log10f)
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,log10,(float __x),__log10f,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_log10) || defined(__CRT_HAVE___log10) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/log10f.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL log10)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(log10f))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_modff) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_modff)
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__CEIREDIRECT(__ATTR_WUNUSED __ATTR_OUT(2),float,__NOTHROW_NCX,modf,(float __x, float *__iptr),modff,{ return __builtin_modff(__x, __iptr); })
#elif defined(__CRT_HAVE_modff)
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(2),float,__NOTHROW_NCX,modf,(float __x, float *__iptr),modff,(__x,__iptr))
#elif defined(__CRT_HAVE___modff)
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(2),float,__NOTHROW_NCX,modf,(float __x, float *__iptr),__modff,(__x,__iptr))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_modf) || defined(__CRT_HAVE___modf) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/modff.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __ATTR_OUT(2) float __NOTHROW_NCX(__LIBCCALL modf)(float __x, float *__iptr) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(modff))(__x, __iptr); }
#endif /* ... */
#if __has_builtin(__builtin_powf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_powf)
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__CEIREDIRECT(__ATTR_WUNUSED __DECL_SIMD_powf,float,__NOTHROW,pow,(float __x, float __y),powf,{ return __builtin_powf(__x, __y); })
#elif defined(__CRT_HAVE_powf)
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_powf,float,__NOTHROW,pow,(float __x, float __y),powf,(__x,__y))
#elif defined(__CRT_HAVE___powf)
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_powf,float,__NOTHROW,pow,(float __x, float __y),__powf,(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_pow) || defined(__CRT_HAVE___pow) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/powf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_powf float __NOTHROW(__LIBCCALL pow)(float __x, float __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(powf))(__x, __y); }
#endif /* ... */
#if __has_builtin(__builtin_sqrtf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_sqrtf)
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,sqrt,(float __x),sqrtf,{ return __builtin_sqrtf(__x); })
#elif defined(__CRT_HAVE_sqrtf)
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,sqrt,(float __x),sqrtf,(__x))
#elif defined(__CRT_HAVE___sqrtf)
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,sqrt,(float __x),__sqrtf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_sqrt) || defined(__CRT_HAVE___sqrt) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/sqrtf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL sqrt)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(sqrtf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_ceilf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_ceilf)
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,ceil,(float __x),ceilf,{ return __builtin_ceilf(__x); })
#elif defined(__CRT_HAVE_ceilf)
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,ceil,(float __x),ceilf,(__x))
#elif defined(__CRT_HAVE___ceilf)
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,ceil,(float __x),__ceilf,(__x))
#else /* ... */
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/ceilf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL ceil)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(ceilf))(__x); }
#endif /* !... */
#if __has_builtin(__builtin_fabsf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fabsf)
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,fabs,(float __x),fabsf,{ return __builtin_fabsf(__x); })
#elif defined(__CRT_HAVE_fabsf)
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,fabs,(float __x),fabsf,(__x))
#elif defined(__CRT_HAVE___fabsf)
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,fabs,(float __x),__fabsf,(__x))
#else /* ... */
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/fabsf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL fabs)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fabsf))(__x); }
#endif /* !... */
#if __has_builtin(__builtin_floorf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_floorf)
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,floor,(float __x),floorf,{ return __builtin_floorf(__x); })
#elif defined(__CRT_HAVE_floorf)
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,floor,(float __x),floorf,(__x))
#elif defined(__CRT_HAVE___floorf)
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,floor,(float __x),__floorf,(__x))
#else /* ... */
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/floorf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL floor)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(floorf))(__x); }
#endif /* !... */
#if __has_builtin(__builtin_fmodf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fmodf)
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,fmod,(float __x, float __y),fmodf,{ return __builtin_fmodf(__x, __y); })
#elif defined(__CRT_HAVE_fmodf)
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,fmod,(float __x, float __y),fmodf,(__x,__y))
#elif defined(__CRT_HAVE___fmodf)
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,fmod,(float __x, float __y),__fmodf,(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_fmod) || defined(__CRT_HAVE___fmod) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/fmodf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL fmod)(float __x, float __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fmodf))(__x, __y); }
#endif /* ... */
} /* extern "C++" */
#ifdef __COMPILER_HAVE_LONGDOUBLE
extern "C++" {
#if __has_builtin(__builtin_acosl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_acosl)
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,acos,(__LONGDOUBLE __x),acosl,{ return __builtin_acosl(__x); })
#elif defined(__CRT_HAVE_acosl)
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,acos,(__LONGDOUBLE __x),acosl,(__x))
#elif defined(__CRT_HAVE___acosl)
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,acos,(__LONGDOUBLE __x),__acosl,(__x))
#elif defined(__CRT_HAVE_acos) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,acos,(__LONGDOUBLE __x),acos,(__x))
#elif defined(__CRT_HAVE___acos) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,acos,(__LONGDOUBLE __x),__acos,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_acos) || defined(__CRT_HAVE___acos) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/acosl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL acos)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(acosl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_asinl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_asinl)
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,asin,(__LONGDOUBLE __x),asinl,{ return __builtin_asinl(__x); })
#elif defined(__CRT_HAVE_asinl)
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,asin,(__LONGDOUBLE __x),asinl,(__x))
#elif defined(__CRT_HAVE___asinl)
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,asin,(__LONGDOUBLE __x),__asinl,(__x))
#elif defined(__CRT_HAVE_asin) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,asin,(__LONGDOUBLE __x),asin,(__x))
#elif defined(__CRT_HAVE___asin) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,asin,(__LONGDOUBLE __x),__asin,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_asin) || defined(__CRT_HAVE___asin) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/asinl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL asin)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(asinl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_atanl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_atanl)
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,atan,(__LONGDOUBLE __x),atanl,{ return __builtin_atanl(__x); })
#elif defined(__CRT_HAVE_atanl)
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,atan,(__LONGDOUBLE __x),atanl,(__x))
#elif defined(__CRT_HAVE___atanl)
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,atan,(__LONGDOUBLE __x),__atanl,(__x))
#elif defined(__CRT_HAVE_atan) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,atan,(__LONGDOUBLE __x),atan,(__x))
#elif defined(__CRT_HAVE___atan) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,atan,(__LONGDOUBLE __x),__atan,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_atan) || defined(__CRT_HAVE___atan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/atanl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL atan)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(atanl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_atan2l) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_atan2l)
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,atan2,(__LONGDOUBLE __y, __LONGDOUBLE __x),atan2l,{ return __builtin_atan2l(__y, __x); })
#elif defined(__CRT_HAVE_atan2l)
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,atan2,(__LONGDOUBLE __y, __LONGDOUBLE __x),atan2l,(__y,__x))
#elif defined(__CRT_HAVE___atan2l)
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,atan2,(__LONGDOUBLE __y, __LONGDOUBLE __x),__atan2l,(__y,__x))
#elif defined(__CRT_HAVE_atan2) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,atan2,(__LONGDOUBLE __y, __LONGDOUBLE __x),atan2,(__y,__x))
#elif defined(__CRT_HAVE___atan2) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,atan2,(__LONGDOUBLE __y, __LONGDOUBLE __x),__atan2,(__y,__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_atan2) || defined(__CRT_HAVE___atan2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/atan2l.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL atan2)(__LONGDOUBLE __y, __LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(atan2l))(__y, __x); }
#endif /* ... */
#if __has_builtin(__builtin_cosl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_cosl)
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__CEIREDIRECT(__ATTR_WUNUSED __DECL_SIMD_cosl,__LONGDOUBLE,__NOTHROW,cos,(__LONGDOUBLE __x),cosl,{ return __builtin_cosl(__x); })
#elif defined(__CRT_HAVE_cosl)
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_cosl,__LONGDOUBLE,__NOTHROW,cos,(__LONGDOUBLE __x),cosl,(__x))
#elif defined(__CRT_HAVE___cosl)
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_cosl,__LONGDOUBLE,__NOTHROW,cos,(__LONGDOUBLE __x),__cosl,(__x))
#elif defined(__CRT_HAVE_cos) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_cosl,__LONGDOUBLE,__NOTHROW,cos,(__LONGDOUBLE __x),cos,(__x))
#elif defined(__CRT_HAVE___cos) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_cosl,__LONGDOUBLE,__NOTHROW,cos,(__LONGDOUBLE __x),__cos,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_cos) || defined(__CRT_HAVE___cos) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/cosl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_cosl __LONGDOUBLE __NOTHROW(__LIBCCALL cos)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(cosl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_sinl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_sinl)
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__CEIREDIRECT(__ATTR_WUNUSED __DECL_SIMD_sinl,__LONGDOUBLE,__NOTHROW,sin,(__LONGDOUBLE __x),sinl,{ return __builtin_sinl(__x); })
#elif defined(__CRT_HAVE_sinl)
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_sinl,__LONGDOUBLE,__NOTHROW,sin,(__LONGDOUBLE __x),sinl,(__x))
#elif defined(__CRT_HAVE___sinl)
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_sinl,__LONGDOUBLE,__NOTHROW,sin,(__LONGDOUBLE __x),__sinl,(__x))
#elif defined(__CRT_HAVE_sin) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_sinl,__LONGDOUBLE,__NOTHROW,sin,(__LONGDOUBLE __x),sin,(__x))
#elif defined(__CRT_HAVE___sin) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_sinl,__LONGDOUBLE,__NOTHROW,sin,(__LONGDOUBLE __x),__sin,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_sin) || defined(__CRT_HAVE___sin) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/sinl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_sinl __LONGDOUBLE __NOTHROW(__LIBCCALL sin)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(sinl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_tanl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_tanl)
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,tan,(__LONGDOUBLE __x),tanl,{ return __builtin_tanl(__x); })
#elif defined(__CRT_HAVE_tanl)
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,tan,(__LONGDOUBLE __x),tanl,(__x))
#elif defined(__CRT_HAVE___tanl)
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,tan,(__LONGDOUBLE __x),__tanl,(__x))
#elif defined(__CRT_HAVE_tan) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,tan,(__LONGDOUBLE __x),tan,(__x))
#elif defined(__CRT_HAVE___tan) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,tan,(__LONGDOUBLE __x),__tan,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_tan) || defined(__CRT_HAVE___tan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/tanl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL tan)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(tanl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_coshl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_coshl)
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,cosh,(__LONGDOUBLE __x),coshl,{ return __builtin_coshl(__x); })
#elif defined(__CRT_HAVE_coshl)
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,cosh,(__LONGDOUBLE __x),coshl,(__x))
#elif defined(__CRT_HAVE___coshl)
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,cosh,(__LONGDOUBLE __x),__coshl,(__x))
#elif defined(__CRT_HAVE_cosh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,cosh,(__LONGDOUBLE __x),cosh,(__x))
#elif defined(__CRT_HAVE___cosh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,cosh,(__LONGDOUBLE __x),__cosh,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_cosh) || defined(__CRT_HAVE___cosh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/coshl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL cosh)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(coshl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_sinhl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_sinhl)
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,sinh,(__LONGDOUBLE __x),sinhl,{ return __builtin_sinhl(__x); })
#elif defined(__CRT_HAVE_sinhl)
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,sinh,(__LONGDOUBLE __x),sinhl,(__x))
#elif defined(__CRT_HAVE___sinhl)
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,sinh,(__LONGDOUBLE __x),__sinhl,(__x))
#elif defined(__CRT_HAVE_sinh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,sinh,(__LONGDOUBLE __x),sinh,(__x))
#elif defined(__CRT_HAVE___sinh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,sinh,(__LONGDOUBLE __x),__sinh,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_sinh) || defined(__CRT_HAVE___sinh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/sinhl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL sinh)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(sinhl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_tanhl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_tanhl)
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,tanh,(__LONGDOUBLE __x),tanhl,{ return __builtin_tanhl(__x); })
#elif defined(__CRT_HAVE_tanhl)
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,tanh,(__LONGDOUBLE __x),tanhl,(__x))
#elif defined(__CRT_HAVE___tanhl)
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,tanh,(__LONGDOUBLE __x),__tanhl,(__x))
#elif defined(__CRT_HAVE_tanh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,tanh,(__LONGDOUBLE __x),tanh,(__x))
#elif defined(__CRT_HAVE___tanh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,tanh,(__LONGDOUBLE __x),__tanh,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_tanh) || defined(__CRT_HAVE___tanh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/tanhl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL tanh)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(tanhl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_expl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_expl)
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__CEIREDIRECT(__ATTR_WUNUSED __DECL_SIMD_expl,__LONGDOUBLE,__NOTHROW,exp,(__LONGDOUBLE __x),expl,{ return __builtin_expl(__x); })
#elif defined(__CRT_HAVE_expl)
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_expl,__LONGDOUBLE,__NOTHROW,exp,(__LONGDOUBLE __x),expl,(__x))
#elif defined(__CRT_HAVE___expl)
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_expl,__LONGDOUBLE,__NOTHROW,exp,(__LONGDOUBLE __x),__expl,(__x))
#elif defined(__CRT_HAVE_exp) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_expl,__LONGDOUBLE,__NOTHROW,exp,(__LONGDOUBLE __x),exp,(__x))
#elif defined(__CRT_HAVE___exp) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_expl,__LONGDOUBLE,__NOTHROW,exp,(__LONGDOUBLE __x),__exp,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_exp) || defined(__CRT_HAVE___exp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/expl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_expl __LONGDOUBLE __NOTHROW(__LIBCCALL exp)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(expl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_frexpl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_frexpl)
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__CEIREDIRECT(__ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,frexp,(__LONGDOUBLE __x, int *__pexponent),frexpl,{ return __builtin_frexpl(__x, __pexponent); })
#elif defined(__CRT_HAVE_frexpl)
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__CREDIRECT(__ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,frexp,(__LONGDOUBLE __x, int *__pexponent),frexpl,(__x,__pexponent))
#elif defined(__CRT_HAVE___frexpl)
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__CREDIRECT(__ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,frexp,(__LONGDOUBLE __x, int *__pexponent),__frexpl,(__x,__pexponent))
#elif defined(__CRT_HAVE_frexp) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__CREDIRECT(__ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,frexp,(__LONGDOUBLE __x, int *__pexponent),frexp,(__x,__pexponent))
#elif defined(__CRT_HAVE___frexp) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__CREDIRECT(__ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,frexp,(__LONGDOUBLE __x, int *__pexponent),__frexp,(__x,__pexponent))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_frexp) || defined(__CRT_HAVE___frexp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/frexpl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_OUT(2) __LONGDOUBLE __NOTHROW_NCX(__LIBCCALL frexp)(__LONGDOUBLE __x, int *__pexponent) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(frexpl))(__x, __pexponent); }
#endif /* ... */
#if __has_builtin(__builtin_ldexpl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_ldexpl)
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,ldexp,(__LONGDOUBLE __x, int __exponent),ldexpl,{ return __builtin_ldexpl(__x, __exponent); })
#elif defined(__CRT_HAVE_ldexpl)
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,ldexp,(__LONGDOUBLE __x, int __exponent),ldexpl,(__x,__exponent))
#elif defined(__CRT_HAVE___ldexpl)
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,ldexp,(__LONGDOUBLE __x, int __exponent),__ldexpl,(__x,__exponent))
#elif defined(__CRT_HAVE_ldexp) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,ldexp,(__LONGDOUBLE __x, int __exponent),ldexp,(__x,__exponent))
#elif defined(__CRT_HAVE___ldexp) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,ldexp,(__LONGDOUBLE __x, int __exponent),__ldexp,(__x,__exponent))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_ldexp) || defined(__CRT_HAVE___ldexp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/ldexpl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL ldexp)(__LONGDOUBLE __x, int __exponent) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(ldexpl))(__x, __exponent); }
#endif /* ... */
#if __has_builtin(__builtin_logl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_logl)
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__CEIREDIRECT(__ATTR_WUNUSED __DECL_SIMD_logl,__LONGDOUBLE,__NOTHROW,log,(__LONGDOUBLE __x),logl,{ return __builtin_logl(__x); })
#elif defined(__CRT_HAVE_logl)
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_logl,__LONGDOUBLE,__NOTHROW,log,(__LONGDOUBLE __x),logl,(__x))
#elif defined(__CRT_HAVE___logl)
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_logl,__LONGDOUBLE,__NOTHROW,log,(__LONGDOUBLE __x),__logl,(__x))
#elif defined(__CRT_HAVE_log) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_logl,__LONGDOUBLE,__NOTHROW,log,(__LONGDOUBLE __x),log,(__x))
#elif defined(__CRT_HAVE___log) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_logl,__LONGDOUBLE,__NOTHROW,log,(__LONGDOUBLE __x),__log,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_log) || defined(__CRT_HAVE___log) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/logl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_logl __LONGDOUBLE __NOTHROW(__LIBCCALL log)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(logl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_log10l) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_log10l)
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,log10,(__LONGDOUBLE __x),log10l,{ return __builtin_log10l(__x); })
#elif defined(__CRT_HAVE_log10l)
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,log10,(__LONGDOUBLE __x),log10l,(__x))
#elif defined(__CRT_HAVE___log10l)
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,log10,(__LONGDOUBLE __x),__log10l,(__x))
#elif defined(__CRT_HAVE_log10) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,log10,(__LONGDOUBLE __x),log10,(__x))
#elif defined(__CRT_HAVE___log10) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,log10,(__LONGDOUBLE __x),__log10,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_log10) || defined(__CRT_HAVE___log10) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/log10l.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL log10)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(log10l))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_modfl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_modfl)
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__CEIREDIRECT(__ATTR_WUNUSED __ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,modf,(__LONGDOUBLE __x, __LONGDOUBLE *__iptr),modfl,{ return __builtin_modfl(__x, __iptr); })
#elif defined(__CRT_HAVE_modfl)
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,modf,(__LONGDOUBLE __x, __LONGDOUBLE *__iptr),modfl,(__x,__iptr))
#elif defined(__CRT_HAVE___modfl)
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,modf,(__LONGDOUBLE __x, __LONGDOUBLE *__iptr),__modfl,(__x,__iptr))
#elif defined(__CRT_HAVE_modf) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,modf,(__LONGDOUBLE __x, __LONGDOUBLE *__iptr),modf,(__x,__iptr))
#elif defined(__CRT_HAVE___modf) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,modf,(__LONGDOUBLE __x, __LONGDOUBLE *__iptr),__modf,(__x,__iptr))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_modf) || defined(__CRT_HAVE___modf) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/modfl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __ATTR_OUT(2) __LONGDOUBLE __NOTHROW_NCX(__LIBCCALL modf)(__LONGDOUBLE __x, __LONGDOUBLE *__iptr) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(modfl))(__x, __iptr); }
#endif /* ... */
#if __has_builtin(__builtin_powl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_powl)
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__CEIREDIRECT(__ATTR_WUNUSED __DECL_SIMD_powl,__LONGDOUBLE,__NOTHROW,pow,(__LONGDOUBLE __x, __LONGDOUBLE __y),powl,{ return __builtin_powl(__x, __y); })
#elif defined(__CRT_HAVE_powl)
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_powl,__LONGDOUBLE,__NOTHROW,pow,(__LONGDOUBLE __x, __LONGDOUBLE __y),powl,(__x,__y))
#elif defined(__CRT_HAVE___powl)
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_powl,__LONGDOUBLE,__NOTHROW,pow,(__LONGDOUBLE __x, __LONGDOUBLE __y),__powl,(__x,__y))
#elif defined(__CRT_HAVE_pow) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_powl,__LONGDOUBLE,__NOTHROW,pow,(__LONGDOUBLE __x, __LONGDOUBLE __y),pow,(__x,__y))
#elif defined(__CRT_HAVE___pow) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_powl,__LONGDOUBLE,__NOTHROW,pow,(__LONGDOUBLE __x, __LONGDOUBLE __y),__pow,(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_pow) || defined(__CRT_HAVE___pow) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/powl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_powl __LONGDOUBLE __NOTHROW(__LIBCCALL pow)(__LONGDOUBLE __x, __LONGDOUBLE __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(powl))(__x, __y); }
#endif /* ... */
#if __has_builtin(__builtin_sqrtl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_sqrtl)
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,sqrt,(__LONGDOUBLE __x),sqrtl,{ return __builtin_sqrtl(__x); })
#elif defined(__CRT_HAVE_sqrtl)
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,sqrt,(__LONGDOUBLE __x),sqrtl,(__x))
#elif defined(__CRT_HAVE___sqrtl)
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,sqrt,(__LONGDOUBLE __x),__sqrtl,(__x))
#elif defined(__CRT_HAVE_sqrt) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,sqrt,(__LONGDOUBLE __x),sqrt,(__x))
#elif defined(__CRT_HAVE___sqrt) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,sqrt,(__LONGDOUBLE __x),__sqrt,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_sqrt) || defined(__CRT_HAVE___sqrt) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/sqrtl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL sqrt)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(sqrtl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_ceill) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_ceill)
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,ceil,(__LONGDOUBLE __x),ceill,{ return __builtin_ceill(__x); })
#elif defined(__CRT_HAVE_ceill)
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,ceil,(__LONGDOUBLE __x),ceill,(__x))
#elif defined(__CRT_HAVE___ceill)
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,ceil,(__LONGDOUBLE __x),__ceill,(__x))
#elif defined(__CRT_HAVE_ceil) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,ceil,(__LONGDOUBLE __x),ceil,(__x))
#elif defined(__CRT_HAVE___ceil) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,ceil,(__LONGDOUBLE __x),__ceil,(__x))
#else /* ... */
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/ceill.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL ceil)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(ceill))(__x); }
#endif /* !... */
#if __has_builtin(__builtin_fabsl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fabsl)
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fabs,(__LONGDOUBLE __x),fabsl,{ return __builtin_fabsl(__x); })
#elif defined(__CRT_HAVE_fabsl)
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fabs,(__LONGDOUBLE __x),fabsl,(__x))
#elif defined(__CRT_HAVE___fabsl)
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fabs,(__LONGDOUBLE __x),__fabsl,(__x))
#elif defined(__CRT_HAVE_fabs) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fabs,(__LONGDOUBLE __x),fabs,(__x))
#elif defined(__CRT_HAVE___fabs) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fabs,(__LONGDOUBLE __x),__fabs,(__x))
#else /* ... */
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/fabsl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL fabs)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fabsl))(__x); }
#endif /* !... */
#if __has_builtin(__builtin_floorl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_floorl)
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,floor,(__LONGDOUBLE __x),floorl,{ return __builtin_floorl(__x); })
#elif defined(__CRT_HAVE_floorl)
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,floor,(__LONGDOUBLE __x),floorl,(__x))
#elif defined(__CRT_HAVE___floorl)
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,floor,(__LONGDOUBLE __x),__floorl,(__x))
#elif defined(__CRT_HAVE_floor) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,floor,(__LONGDOUBLE __x),floor,(__x))
#elif defined(__CRT_HAVE___floor) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,floor,(__LONGDOUBLE __x),__floor,(__x))
#else /* ... */
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/floorl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL floor)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(floorl))(__x); }
#endif /* !... */
#if __has_builtin(__builtin_fmodl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fmodl)
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fmod,(__LONGDOUBLE __x, __LONGDOUBLE __y),fmodl,{ return __builtin_fmodl(__x, __y); })
#elif defined(__CRT_HAVE_fmodl)
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fmod,(__LONGDOUBLE __x, __LONGDOUBLE __y),fmodl,(__x,__y))
#elif defined(__CRT_HAVE___fmodl)
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fmod,(__LONGDOUBLE __x, __LONGDOUBLE __y),__fmodl,(__x,__y))
#elif defined(__CRT_HAVE_fmod) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fmod,(__LONGDOUBLE __x, __LONGDOUBLE __y),fmod,(__x,__y))
#elif defined(__CRT_HAVE___fmod) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fmod,(__LONGDOUBLE __x, __LONGDOUBLE __y),__fmod,(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_fmod) || defined(__CRT_HAVE___fmod) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/fmodl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL fmod)(__LONGDOUBLE __x, __LONGDOUBLE __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fmodl))(__x, __y); }
#endif /* ... */
} /* extern "C++" */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#if defined(__USE_XOPEN_EXTENDED) || defined(__USE_ISOC99)
extern "C++" {
#if __has_builtin(__builtin_acoshf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_acoshf)
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,acosh,(float __x),acoshf,{ return __builtin_acoshf(__x); })
#elif defined(__CRT_HAVE_acoshf)
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,acosh,(float __x),acoshf,(__x))
#elif defined(__CRT_HAVE___acoshf)
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,acosh,(float __x),__acoshf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_acosh) || defined(__CRT_HAVE___acosh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/acoshf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL acosh)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(acoshf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_asinhf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_asinhf)
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,asinh,(float __x),asinhf,{ return __builtin_asinhf(__x); })
#elif defined(__CRT_HAVE_asinhf)
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,asinh,(float __x),asinhf,(__x))
#elif defined(__CRT_HAVE___asinhf)
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,asinh,(float __x),__asinhf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_asinh) || defined(__CRT_HAVE___asinh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/asinhf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL asinh)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(asinhf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_atanhf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_atanhf)
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,atanh,(float __x),atanhf,{ return __builtin_atanhf(__x); })
#elif defined(__CRT_HAVE_atanhf)
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,atanh,(float __x),atanhf,(__x))
#elif defined(__CRT_HAVE___atanhf)
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,atanh,(float __x),__atanhf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_atanh) || defined(__CRT_HAVE___atanh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/atanhf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL atanh)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(atanhf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_expm1f) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_expm1f)
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,expm1,(float __x),expm1f,{ return __builtin_expm1f(__x); })
#elif defined(__CRT_HAVE_expm1f)
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,expm1,(float __x),expm1f,(__x))
#elif defined(__CRT_HAVE___expm1f)
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,expm1,(float __x),__expm1f,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_expm1) || defined(__CRT_HAVE___expm1) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/expm1f.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL expm1)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(expm1f))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_log1pf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_log1pf)
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,log1p,(float __x),log1pf,{ return __builtin_log1pf(__x); })
#elif defined(__CRT_HAVE_log1pf)
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,log1p,(float __x),log1pf,(__x))
#elif defined(__CRT_HAVE___log1pf)
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,log1p,(float __x),__log1pf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_log1p) || defined(__CRT_HAVE___log1p) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/log1pf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL log1p)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(log1pf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_logbf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_logbf)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,logb,(float __x),logbf,{ return __builtin_logbf(__x); })
#elif defined(__CRT_HAVE_logbf)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,logb,(float __x),logbf,(__x))
#elif defined(__CRT_HAVE___logbf)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,logb,(float __x),__logbf,(__x))
#elif defined(__CRT_HAVE__logbf)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,logb,(float __x),_logbf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_logb) || defined(__CRT_HAVE___logb) || defined(__CRT_HAVE__logb) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/logbf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL logb)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(logbf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_cbrtf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_cbrtf)
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,cbrt,(float __x),cbrtf,{ return __builtin_cbrtf(__x); })
#elif defined(__CRT_HAVE_cbrtf)
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,cbrt,(float __x),cbrtf,(__x))
#elif defined(__CRT_HAVE___cbrtf)
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,cbrt,(float __x),__cbrtf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_cbrt) || defined(__CRT_HAVE___cbrt) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/cbrtf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL cbrt)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(cbrtf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_rintf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_rintf)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,rint,(float __x),rintf,{ return __builtin_rintf(__x); })
#elif __has_builtin(__builtin_nearbyintf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nearbyintf)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,rint,(float __x),nearbyintf,{ return __builtin_nearbyintf(__x); })
#elif defined(__CRT_HAVE_rintf)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,rint,(float __x),rintf,(__x))
#elif defined(__CRT_HAVE_nearbyintf)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,rint,(float __x),nearbyintf,(__x))
#elif defined(__CRT_HAVE___rintf)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,rint,(float __x),__rintf,(__x))
#elif defined(__CRT_HAVE___nearbyintf)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,rint,(float __x),__nearbyintf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_rint) || defined(__CRT_HAVE_nearbyint) || defined(__CRT_HAVE___rint) || defined(__CRT_HAVE___nearbyint) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/rintf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL rint)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(rintf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_nextafterf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nextafterf)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nextafter,(float __x, float __y),nextafterf,{ return __builtin_nextafterf(__x, __y); })
#elif __has_builtin(__builtin_nexttowardf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nexttowardf)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nextafter,(float __x, float __y),nexttowardf,{ return __builtin_nexttowardf(__x); })
#elif defined(__CRT_HAVE_nextafterf)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nextafter,(float __x, float __y),nextafterf,(__x,__y))
#elif defined(__CRT_HAVE_nexttowardf)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nextafter,(float __x, float __y),nexttowardf,(__x,__y))
#elif defined(__CRT_HAVE___nextafterf)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nextafter,(float __x, float __y),__nextafterf,(__x,__y))
#elif defined(__CRT_HAVE___nexttowardf)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nextafter,(float __x, float __y),__nexttowardf,(__x,__y))
#elif defined(__CRT_HAVE__nextafterf)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nextafter,(float __x, float __y),_nextafterf,(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_nextafter) || defined(__CRT_HAVE_nexttoward) || defined(__CRT_HAVE___nextafter) || defined(__CRT_HAVE__nextafter) || defined(__CRT_HAVE___nexttoward) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/nextafterf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL nextafter)(float __x, float __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(nextafterf))(__x, __y); }
#endif /* ... */
#if __has_builtin(__builtin_remainderf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_remainderf)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,remainder,(float __x, float __p),remainderf,{ return __builtin_remainderf(__x, __p); })
#elif __has_builtin(__builtin_dremf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_dremf)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,remainder,(float __x, float __p),dremf,{ return __builtin_dremf(__x, __p); })
#elif defined(__CRT_HAVE_remainderf)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,remainder,(float __x, float __p),remainderf,(__x,__p))
#elif defined(__CRT_HAVE_dremf)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,remainder,(float __x, float __p),dremf,(__x,__p))
#elif defined(__CRT_HAVE___remainderf)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,remainder,(float __x, float __p),__remainderf,(__x,__p))
#elif defined(__CRT_HAVE___dremf)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,remainder,(float __x, float __p),__dremf,(__x,__p))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_remainder) || defined(__CRT_HAVE_drem) || defined(__CRT_HAVE___remainder) || defined(__CRT_HAVE___drem) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/remainderf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL remainder)(float __x, float __p) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(remainderf))(__x, __p); }
#endif /* ... */
#if __has_builtin(__builtin_ilogbf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_ilogbf)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CEIREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,ilogb,(float __x),ilogbf,{ return __builtin_ilogbf(__x); })
#elif defined(__CRT_HAVE_ilogbf)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,ilogb,(float __x),ilogbf,(__x))
#elif defined(__CRT_HAVE_llogbf) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,ilogb,(float __x),llogbf,(__x))
#elif defined(__CRT_HAVE___ilogbf)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,ilogb,(float __x),__ilogbf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_ilogb) || (defined(__CRT_HAVE_llogb) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__CRT_HAVE___ilogb) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/ilogbf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED int __NOTHROW(__LIBCCALL ilogb)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(ilogbf))(__x); }
#endif /* ... */
} /* extern "C++" */
#ifdef __COMPILER_HAVE_LONGDOUBLE
extern "C++" {
#if __has_builtin(__builtin_acoshl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_acoshl)
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,acosh,(__LONGDOUBLE __x),acoshl,{ return __builtin_acoshl(__x); })
#elif defined(__CRT_HAVE_acoshl)
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,acosh,(__LONGDOUBLE __x),acoshl,(__x))
#elif defined(__CRT_HAVE___acoshl)
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,acosh,(__LONGDOUBLE __x),__acoshl,(__x))
#elif defined(__CRT_HAVE_acosh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,acosh,(__LONGDOUBLE __x),acosh,(__x))
#elif defined(__CRT_HAVE___acosh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,acosh,(__LONGDOUBLE __x),__acosh,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_acosh) || defined(__CRT_HAVE___acosh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/acoshl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL acosh)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(acoshl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_asinhl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_asinhl)
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,asinh,(__LONGDOUBLE __x),asinhl,{ return __builtin_asinhl(__x); })
#elif defined(__CRT_HAVE_asinhl)
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,asinh,(__LONGDOUBLE __x),asinhl,(__x))
#elif defined(__CRT_HAVE___asinhl)
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,asinh,(__LONGDOUBLE __x),__asinhl,(__x))
#elif defined(__CRT_HAVE_asinh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,asinh,(__LONGDOUBLE __x),asinh,(__x))
#elif defined(__CRT_HAVE___asinh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,asinh,(__LONGDOUBLE __x),__asinh,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_asinh) || defined(__CRT_HAVE___asinh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/asinhl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL asinh)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(asinhl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_atanhl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_atanhl)
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,atanh,(__LONGDOUBLE __x),atanhl,{ return __builtin_atanhl(__x); })
#elif defined(__CRT_HAVE_atanhl)
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,atanh,(__LONGDOUBLE __x),atanhl,(__x))
#elif defined(__CRT_HAVE___atanhl)
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,atanh,(__LONGDOUBLE __x),__atanhl,(__x))
#elif defined(__CRT_HAVE_atanh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,atanh,(__LONGDOUBLE __x),atanh,(__x))
#elif defined(__CRT_HAVE___atanh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,atanh,(__LONGDOUBLE __x),__atanh,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_atanh) || defined(__CRT_HAVE___atanh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/atanhl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL atanh)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(atanhl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_expm1l) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_expm1l)
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,expm1,(__LONGDOUBLE __x),expm1l,{ return __builtin_expm1l(__x); })
#elif defined(__CRT_HAVE_expm1l)
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,expm1,(__LONGDOUBLE __x),expm1l,(__x))
#elif defined(__CRT_HAVE___expm1l)
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,expm1,(__LONGDOUBLE __x),__expm1l,(__x))
#elif defined(__CRT_HAVE_expm1) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,expm1,(__LONGDOUBLE __x),expm1,(__x))
#elif defined(__CRT_HAVE___expm1) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,expm1,(__LONGDOUBLE __x),__expm1,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_expm1) || defined(__CRT_HAVE___expm1) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/expm1l.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL expm1)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(expm1l))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_log1pl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_log1pl)
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,log1p,(__LONGDOUBLE __x),log1pl,{ return __builtin_log1pl(__x); })
#elif defined(__CRT_HAVE_log1pl)
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,log1p,(__LONGDOUBLE __x),log1pl,(__x))
#elif defined(__CRT_HAVE___log1pl)
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,log1p,(__LONGDOUBLE __x),__log1pl,(__x))
#elif defined(__CRT_HAVE_log1p) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,log1p,(__LONGDOUBLE __x),log1p,(__x))
#elif defined(__CRT_HAVE___log1p) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,log1p,(__LONGDOUBLE __x),__log1p,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_log1p) || defined(__CRT_HAVE___log1p) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/log1pl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL log1p)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(log1pl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_logbl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_logbl)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,logb,(__LONGDOUBLE __x),logbl,{ return __builtin_logbl(__x); })
#elif defined(__CRT_HAVE_logbl)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,logb,(__LONGDOUBLE __x),logbl,(__x))
#elif defined(__CRT_HAVE___logbl)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,logb,(__LONGDOUBLE __x),__logbl,(__x))
#elif defined(__CRT_HAVE_logb) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,logb,(__LONGDOUBLE __x),logb,(__x))
#elif defined(__CRT_HAVE___logb) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,logb,(__LONGDOUBLE __x),__logb,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_logb) || defined(__CRT_HAVE___logb) || defined(__CRT_HAVE__logb) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/logbl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL logb)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(logbl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_cbrtl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_cbrtl)
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,cbrt,(__LONGDOUBLE __x),cbrtl,{ return __builtin_cbrtl(__x); })
#elif defined(__CRT_HAVE_cbrtl)
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,cbrt,(__LONGDOUBLE __x),cbrtl,(__x))
#elif defined(__CRT_HAVE___cbrtl)
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,cbrt,(__LONGDOUBLE __x),__cbrtl,(__x))
#elif defined(__CRT_HAVE_cbrt) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,cbrt,(__LONGDOUBLE __x),cbrt,(__x))
#elif defined(__CRT_HAVE___cbrt) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,cbrt,(__LONGDOUBLE __x),__cbrt,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_cbrt) || defined(__CRT_HAVE___cbrt) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/cbrtl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL cbrt)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(cbrtl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_rintl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_rintl)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,rint,(__LONGDOUBLE __x),rintl,{ return __builtin_rintl(__x); })
#elif __has_builtin(__builtin_nearbyintl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nearbyintl)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,rint,(__LONGDOUBLE __x),nearbyintl,{ return __builtin_nearbyintl(__x); })
#elif defined(__CRT_HAVE_rintl)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,rint,(__LONGDOUBLE __x),rintl,(__x))
#elif defined(__CRT_HAVE_nearbyintl)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,rint,(__LONGDOUBLE __x),nearbyintl,(__x))
#elif defined(__CRT_HAVE___rintl)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,rint,(__LONGDOUBLE __x),__rintl,(__x))
#elif defined(__CRT_HAVE___nearbyintl)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,rint,(__LONGDOUBLE __x),__nearbyintl,(__x))
#elif defined(__CRT_HAVE_rint) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,rint,(__LONGDOUBLE __x),rint,(__x))
#elif defined(__CRT_HAVE_nearbyint) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,rint,(__LONGDOUBLE __x),nearbyint,(__x))
#elif defined(__CRT_HAVE___rint) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,rint,(__LONGDOUBLE __x),__rint,(__x))
#elif defined(__CRT_HAVE___nearbyint) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,rint,(__LONGDOUBLE __x),__nearbyint,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_rint) || defined(__CRT_HAVE_nearbyint) || defined(__CRT_HAVE___rint) || defined(__CRT_HAVE___nearbyint) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/rintl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL rint)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(rintl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_nextafterl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nextafterl)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nextafter,(__LONGDOUBLE __x, __LONGDOUBLE __y),nextafterl,{ return __builtin_nextafterl(__x, __y); })
#elif __has_builtin(__builtin_nexttowardl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nexttowardl)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nextafter,(__LONGDOUBLE __x, __LONGDOUBLE __y),nexttowardl,{ return __builtin_nexttowardl(__x); })
#elif defined(__CRT_HAVE_nextafterl)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nextafter,(__LONGDOUBLE __x, __LONGDOUBLE __y),nextafterl,(__x,__y))
#elif defined(__CRT_HAVE_nexttowardl)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nextafter,(__LONGDOUBLE __x, __LONGDOUBLE __y),nexttowardl,(__x,__y))
#elif defined(__CRT_HAVE___nextafterl)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nextafter,(__LONGDOUBLE __x, __LONGDOUBLE __y),__nextafterl,(__x,__y))
#elif defined(__CRT_HAVE___nexttowardl)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nextafter,(__LONGDOUBLE __x, __LONGDOUBLE __y),__nexttowardl,(__x,__y))
#elif defined(__CRT_HAVE_nextafter) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nextafter,(__LONGDOUBLE __x, __LONGDOUBLE __y),nextafter,(__x,__y))
#elif defined(__CRT_HAVE_nexttoward) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nextafter,(__LONGDOUBLE __x, __LONGDOUBLE __y),nexttoward,(__x,__y))
#elif defined(__CRT_HAVE___nextafter) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nextafter,(__LONGDOUBLE __x, __LONGDOUBLE __y),__nextafter,(__x,__y))
#elif defined(__CRT_HAVE___nexttoward) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nextafter,(__LONGDOUBLE __x, __LONGDOUBLE __y),__nexttoward,(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_nextafter) || defined(__CRT_HAVE_nexttoward) || defined(__CRT_HAVE___nextafter) || defined(__CRT_HAVE__nextafter) || defined(__CRT_HAVE___nexttoward) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/nextafterl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL nextafter)(__LONGDOUBLE __x, __LONGDOUBLE __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(nextafterl))(__x, __y); }
#endif /* ... */
#if __has_builtin(__builtin_remainderl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_remainderl)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,remainder,(__LONGDOUBLE __x, __LONGDOUBLE __p),remainderl,{ return __builtin_remainderl(__x, __p); })
#elif __has_builtin(__builtin_dreml) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_dreml)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,remainder,(__LONGDOUBLE __x, __LONGDOUBLE __p),dreml,{ return __builtin_dreml(__x, __p); })
#elif defined(__CRT_HAVE_remainderl)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,remainder,(__LONGDOUBLE __x, __LONGDOUBLE __p),remainderl,(__x,__p))
#elif defined(__CRT_HAVE_dreml)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,remainder,(__LONGDOUBLE __x, __LONGDOUBLE __p),dreml,(__x,__p))
#elif defined(__CRT_HAVE___remainderl)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,remainder,(__LONGDOUBLE __x, __LONGDOUBLE __p),__remainderl,(__x,__p))
#elif defined(__CRT_HAVE___dreml)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,remainder,(__LONGDOUBLE __x, __LONGDOUBLE __p),__dreml,(__x,__p))
#elif defined(__CRT_HAVE_remainder) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,remainder,(__LONGDOUBLE __x, __LONGDOUBLE __p),remainder,(__x,__p))
#elif defined(__CRT_HAVE_drem) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,remainder,(__LONGDOUBLE __x, __LONGDOUBLE __p),drem,(__x,__p))
#elif defined(__CRT_HAVE___remainder) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,remainder,(__LONGDOUBLE __x, __LONGDOUBLE __p),__remainder,(__x,__p))
#elif defined(__CRT_HAVE___drem) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,remainder,(__LONGDOUBLE __x, __LONGDOUBLE __p),__drem,(__x,__p))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_remainder) || defined(__CRT_HAVE_drem) || defined(__CRT_HAVE___remainder) || defined(__CRT_HAVE___drem) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/remainderl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL remainder)(__LONGDOUBLE __x, __LONGDOUBLE __p) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(remainderl))(__x, __p); }
#endif /* ... */
#if __has_builtin(__builtin_ilogbl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_ilogbl)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CEIREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,ilogb,(__LONGDOUBLE __x),ilogbl,{ return __builtin_ilogbl(__x); })
#elif defined(__CRT_HAVE_ilogbl)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,ilogb,(__LONGDOUBLE __x),ilogbl,(__x))
#elif defined(__CRT_HAVE_llogb) && __SIZEOF_INT__ == __SIZEOF_LONG__ && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,ilogb,(__LONGDOUBLE __x),llogb,(__x))
#elif defined(__CRT_HAVE_llogbl) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,ilogb,(__LONGDOUBLE __x),llogbl,(__x))
#elif defined(__CRT_HAVE___ilogbl)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,ilogb,(__LONGDOUBLE __x),__ilogbl,(__x))
#elif defined(__CRT_HAVE_ilogb) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,ilogb,(__LONGDOUBLE __x),ilogb,(__x))
#elif defined(__CRT_HAVE___ilogb) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,ilogb,(__LONGDOUBLE __x),__ilogb,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_ilogb) || (defined(__CRT_HAVE_llogb) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__CRT_HAVE___ilogb) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/ilogbl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED int __NOTHROW(__LIBCCALL ilogb)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(ilogbl))(__x); }
#endif /* ... */
} /* extern "C++" */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_XOPEN_EXTENDED || __USE_ISOC99 */
#ifdef __USE_ISOC99
extern "C++" {
#if __has_builtin(__builtin_exp2f) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_exp2f)
/* >> exp2f(3), exp2(3), exp2l(3)
 * Compute base-2 exponential of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,exp2,(float __x),exp2f,{ return __builtin_exp2f(__x); })
#elif defined(__CRT_HAVE_exp2f)
/* >> exp2f(3), exp2(3), exp2l(3)
 * Compute base-2 exponential of `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,exp2,(float __x),exp2f,(__x))
#elif defined(__CRT_HAVE___exp2f)
/* >> exp2f(3), exp2(3), exp2l(3)
 * Compute base-2 exponential of `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,exp2,(float __x),__exp2f,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_exp2) || defined(__CRT_HAVE___exp2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/exp2f.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> exp2f(3), exp2(3), exp2l(3)
 * Compute base-2 exponential of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL exp2)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(exp2f))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_log2f) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_log2f)
/* >> log2f(3), log2(3), log2l(3)
 * Compute base-2 logarithm of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,log2,(float __x),log2f,{ return __builtin_log2f(__x); })
#elif defined(__CRT_HAVE_log2f)
/* >> log2f(3), log2(3), log2l(3)
 * Compute base-2 logarithm of `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,log2,(float __x),log2f,(__x))
#elif defined(__CRT_HAVE___log2f)
/* >> log2f(3), log2(3), log2l(3)
 * Compute base-2 logarithm of `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,log2,(float __x),__log2f,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_log2) || defined(__CRT_HAVE___log2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/log2f.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> log2f(3), log2(3), log2l(3)
 * Compute base-2 logarithm of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL log2)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(log2f))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_copysignf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_copysignf)
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,copysign,(float __num, float __sign),copysignf,{ return __builtin_copysignf(__num, __sign); })
#elif defined(__CRT_HAVE_copysignf)
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,copysign,(float __num, float __sign),copysignf,(__num,__sign))
#elif defined(__CRT_HAVE__copysignf)
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,copysign,(float __num, float __sign),_copysignf,(__num,__sign))
#elif defined(__CRT_HAVE___copysignf)
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,copysign,(float __num, float __sign),__copysignf,(__num,__sign))
#else /* ... */
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/copysignf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL copysign)(float __num, float __sign) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(copysignf))(__num, __sign); }
#endif /* !... */
#if __has_builtin(__builtin_tgammaf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_tgammaf)
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,tgamma,(float __x),tgammaf,{ return __builtin_tgammaf(__x); })
#elif defined(__CRT_HAVE_tgammaf)
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,tgamma,(float __x),tgammaf,(__x))
#elif defined(__CRT_HAVE___tgammaf)
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,tgamma,(float __x),__tgammaf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_tgamma) || defined(__CRT_HAVE___tgamma) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/tgammaf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL tgamma)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(tgammaf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_nexttowardf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nexttowardf)
/* >> nexttowardf(3), nexttoward(3), nexttowardl(3) */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nexttoward,(float __x, __LONGDOUBLE __y),nexttowardf,{ return __builtin_nexttowardf(__x, __y); })
#elif defined(__CRT_HAVE_nexttowardf)
/* >> nexttowardf(3), nexttoward(3), nexttowardl(3) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nexttoward,(float __x, __LONGDOUBLE __y),nexttowardf,(__x,__y))
#elif defined(__CRT_HAVE___nexttowardf)
/* >> nexttowardf(3), nexttoward(3), nexttowardl(3) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nexttoward,(float __x, __LONGDOUBLE __y),__nexttowardf,(__x,__y))
#elif ((defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__)) && defined(__IEEE854_LONG_DOUBLE_TYPE__)) || defined(__CRT_HAVE_nextafterl) || defined(__CRT_HAVE_nexttowardl) || defined(__CRT_HAVE___nextafterl) || defined(__CRT_HAVE___nexttowardl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_nextafter) || defined(__CRT_HAVE_nexttoward) || defined(__CRT_HAVE___nextafter) || defined(__CRT_HAVE__nextafter) || defined(__CRT_HAVE___nexttoward) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/nexttowardf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> nexttowardf(3), nexttoward(3), nexttowardl(3) */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL nexttoward)(float __x, __LONGDOUBLE __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(nexttowardf))(__x, __y); }
#endif /* ... */
#if __has_builtin(__builtin_scalbnf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_scalbnf)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,scalbn,(float __x, int __n),scalbnf,{ return __builtin_scalbnf(__x, __n); })
#elif defined(__CRT_HAVE_scalbnf)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,scalbn,(float __x, int __n),scalbnf,(__x,__n))
#elif defined(__CRT_HAVE___scalbnf)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,scalbn,(float __x, int __n),__scalbnf,(__x,__n))
#elif defined(__CRT_HAVE_scalblnf) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,scalbn,(float __x, int __n),scalblnf,(__x,__n))
#elif defined(__CRT_HAVE___scalblnf) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,scalbn,(float __x, int __n),__scalblnf,(__x,__n))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_scalbn) || defined(__CRT_HAVE___scalbn) || (defined(__CRT_HAVE_scalbln) && __SIZEOF_INT__ == __SIZEOF_LONG__) || (defined(__CRT_HAVE___scalbln) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/scalbnf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL scalbn)(float __x, int __n) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(scalbnf))(__x, __n); }
#endif /* ... */
#if __has_builtin(__builtin_scalblnf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_scalblnf)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,scalbln,(float __x, long int __n),scalblnf,{ return __builtin_scalblnf(__x, __n); })
#elif defined(__CRT_HAVE_scalblnf)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,scalbln,(float __x, long int __n),scalblnf,(__x,__n))
#elif defined(__CRT_HAVE___scalblnf)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,scalbln,(float __x, long int __n),__scalblnf,(__x,__n))
#elif defined(__CRT_HAVE_scalbnf) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,scalbln,(float __x, long int __n),scalbnf,(__x,__n))
#elif defined(__CRT_HAVE___scalbnf) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,scalbln,(float __x, long int __n),__scalbnf,(__x,__n))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_scalbln) || defined(__CRT_HAVE___scalbln) || (defined(__CRT_HAVE_scalbn) && __SIZEOF_INT__ == __SIZEOF_LONG__) || (defined(__CRT_HAVE___scalbn) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/scalblnf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL scalbln)(float __x, long int __n) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(scalblnf))(__x, __n); }
#endif /* ... */
#if __has_builtin(__builtin_rintf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_rintf)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nearbyint,(float __x),rintf,{ return __builtin_rintf(__x); })
#elif __has_builtin(__builtin_nearbyintf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nearbyintf)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nearbyint,(float __x),nearbyintf,{ return __builtin_nearbyintf(__x); })
#elif defined(__CRT_HAVE_rintf)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nearbyint,(float __x),rintf,(__x))
#elif defined(__CRT_HAVE_nearbyintf)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nearbyint,(float __x),nearbyintf,(__x))
#elif defined(__CRT_HAVE___rintf)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nearbyint,(float __x),__rintf,(__x))
#elif defined(__CRT_HAVE___nearbyintf)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,nearbyint,(float __x),__nearbyintf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_rint) || defined(__CRT_HAVE_nearbyint) || defined(__CRT_HAVE___rint) || defined(__CRT_HAVE___nearbyint) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/rintf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL nearbyint)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(rintf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_roundf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_roundf)
/* >> roundf(3), round(3), roundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,round,(float __x),roundf,{ return __builtin_roundf(__x); })
#elif defined(__CRT_HAVE_roundf)
/* >> roundf(3), round(3), roundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,round,(float __x),roundf,(__x))
#elif defined(__CRT_HAVE___roundf)
/* >> roundf(3), round(3), roundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,round,(float __x),__roundf,(__x))
#else /* ... */
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/roundf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> roundf(3), round(3), roundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL round)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(roundf))(__x); }
#endif /* !... */
#if __has_builtin(__builtin_truncf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_truncf)
/* >> truncf(3), trunc(3), truncl(3)
 * Round `x' to the integral value in floating-point
 * format   nearest  but  not  larger  in  magnitude */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,trunc,(float __x),truncf,{ return __builtin_truncf(__x); })
#elif defined(__CRT_HAVE_truncf)
/* >> truncf(3), trunc(3), truncl(3)
 * Round `x' to the integral value in floating-point
 * format   nearest  but  not  larger  in  magnitude */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,trunc,(float __x),truncf,(__x))
#elif defined(__CRT_HAVE___truncf)
/* >> truncf(3), trunc(3), truncl(3)
 * Round `x' to the integral value in floating-point
 * format   nearest  but  not  larger  in  magnitude */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,trunc,(float __x),__truncf,(__x))
#else /* ... */
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/truncf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> truncf(3), trunc(3), truncl(3)
 * Round `x' to the integral value in floating-point
 * format   nearest  but  not  larger  in  magnitude */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL trunc)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(truncf))(__x); }
#endif /* !... */
#if __has_builtin(__builtin_remquof) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_remquof)
/* >> remquof(3), remquo(3), remquol(3)
 * Compute remainder of `x' and `p' and put in `*pquo' a value with
 * sign of x/p and magnitude  congruent `mod 2^n' to the  magnitude
 * of the integral quotient x/p, with n >= 3 */
__CEIREDIRECT(__ATTR_WUNUSED __ATTR_OUT(3),float,__NOTHROW,remquo,(float __x, float __p, int *__pquo),remquof,{ return __builtin_remquof(__x, __p, __pquo); })
#elif defined(__CRT_HAVE_remquof)
/* >> remquof(3), remquo(3), remquol(3)
 * Compute remainder of `x' and `p' and put in `*pquo' a value with
 * sign of x/p and magnitude  congruent `mod 2^n' to the  magnitude
 * of the integral quotient x/p, with n >= 3 */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(3),float,__NOTHROW,remquo,(float __x, float __p, int *__pquo),remquof,(__x,__p,__pquo))
#elif defined(__CRT_HAVE___remquof)
/* >> remquof(3), remquo(3), remquol(3)
 * Compute remainder of `x' and `p' and put in `*pquo' a value with
 * sign of x/p and magnitude  congruent `mod 2^n' to the  magnitude
 * of the integral quotient x/p, with n >= 3 */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(3),float,__NOTHROW,remquo,(float __x, float __p, int *__pquo),__remquof,(__x,__p,__pquo))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_remquo) || defined(__CRT_HAVE___remquo) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/remquof.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> remquof(3), remquo(3), remquol(3)
 * Compute remainder of `x' and `p' and put in `*pquo' a value with
 * sign of x/p and magnitude  congruent `mod 2^n' to the  magnitude
 * of the integral quotient x/p, with n >= 3 */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __ATTR_OUT(3) float __NOTHROW(__LIBCCALL remquo)(float __x, float __p, int *__pquo) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(remquof))(__x, __p, __pquo); }
#endif /* ... */
#if __has_builtin(__builtin_lrintf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_lrintf)
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrint,(float __x),lrintf,{ return __builtin_lrintf(__x); })
#elif defined(__CRT_HAVE_lrintf)
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrint,(float __x),lrintf,(__x))
#elif defined(__CRT_HAVE___lrintf)
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrint,(float __x),__lrintf,(__x))
#elif defined(__CRT_HAVE_llrintf) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrint,(float __x),llrintf,(__x))
#elif defined(__CRT_HAVE___llrintf) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrint,(float __x),__llrintf,(__x))
#else /* ... */
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/lrintf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED long int __NOTHROW(__LIBCCALL lrint)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(lrintf))(__x); }
#endif /* !... */
#if __has_builtin(__builtin_lroundf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_lroundf)
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lround,(float __x),lroundf,{ return __builtin_lroundf(__x); })
#elif defined(__CRT_HAVE_lroundf)
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lround,(float __x),lroundf,(__x))
#elif defined(__CRT_HAVE___lroundf)
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lround,(float __x),__lroundf,(__x))
#elif defined(__CRT_HAVE_llroundf) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lround,(float __x),llroundf,(__x))
#elif defined(__CRT_HAVE___llroundf) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lround,(float __x),__llroundf,(__x))
#else /* ... */
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/lroundf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED long int __NOTHROW(__LIBCCALL lround)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(lroundf))(__x); }
#endif /* !... */
#if __has_builtin(__builtin_fdimf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fdimf)
/* >> fdimf(3), fdim(3), fdiml(3)
 * Return positive difference between `x' and `y' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,fdim,(float __x, float __y),fdimf,{ return __builtin_fdimf(__x, __y); })
#elif defined(__CRT_HAVE_fdimf)
/* >> fdimf(3), fdim(3), fdiml(3)
 * Return positive difference between `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,fdim,(float __x, float __y),fdimf,(__x,__y))
#elif defined(__CRT_HAVE___fdimf)
/* >> fdimf(3), fdim(3), fdiml(3)
 * Return positive difference between `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,fdim,(float __x, float __y),__fdimf,(__x,__y))
#else /* ... */
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/fdimf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> fdimf(3), fdim(3), fdiml(3)
 * Return positive difference between `x' and `y' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL fdim)(float __x, float __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fdimf))(__x, __y); }
#endif /* !... */
#if __has_builtin(__builtin_fmaxf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fmaxf)
/* >> fmaxf(3), fmax(3), fmaxl(3)
 * Return maximum numeric value from `x' and `y' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,fmax,(float __x, float __y),fmaxf,{ return __builtin_fmaxf(__x, __y); })
#elif defined(__CRT_HAVE_fmaxf)
/* >> fmaxf(3), fmax(3), fmaxl(3)
 * Return maximum numeric value from `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,fmax,(float __x, float __y),fmaxf,(__x,__y))
#elif defined(__CRT_HAVE___fmaxf)
/* >> fmaxf(3), fmax(3), fmaxl(3)
 * Return maximum numeric value from `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,fmax,(float __x, float __y),__fmaxf,(__x,__y))
#else /* ... */
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/fmaxf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> fmaxf(3), fmax(3), fmaxl(3)
 * Return maximum numeric value from `x' and `y' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL fmax)(float __x, float __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fmaxf))(__x, __y); }
#endif /* !... */
#if __has_builtin(__builtin_fminf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fminf)
/* >> fminf(3), fmin(3), fminl(3)
 * Return minimum numeric value from `x' and `y' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,fmin,(float __x, float __y),fminf,{ return __builtin_fminf(__x, __y); })
#elif defined(__CRT_HAVE_fminf)
/* >> fminf(3), fmin(3), fminl(3)
 * Return minimum numeric value from `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,fmin,(float __x, float __y),fminf,(__x,__y))
#elif defined(__CRT_HAVE___fminf)
/* >> fminf(3), fmin(3), fminl(3)
 * Return minimum numeric value from `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,fmin,(float __x, float __y),__fminf,(__x,__y))
#else /* ... */
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/fminf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> fminf(3), fmin(3), fminl(3)
 * Return minimum numeric value from `x' and `y' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL fmin)(float __x, float __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fminf))(__x, __y); }
#endif /* !... */
#if __has_builtin(__builtin_fmaf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fmaf)
/* >> fmaf(3), fma(3), fmal(3)
 * Multiply-add function computed as a ternary operation */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,fma,(float __x, float __y, float __z),fmaf,{ return __builtin_fmaf(__x, __y, __z); })
#elif defined(__CRT_HAVE_fmaf)
/* >> fmaf(3), fma(3), fmal(3)
 * Multiply-add function computed as a ternary operation */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,fma,(float __x, float __y, float __z),fmaf,(__x,__y,__z))
#elif defined(__CRT_HAVE___fmaf)
/* >> fmaf(3), fma(3), fmal(3)
 * Multiply-add function computed as a ternary operation */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,fma,(float __x, float __y, float __z),__fmaf,(__x,__y,__z))
#else /* ... */
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/fmaf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> fmaf(3), fma(3), fmal(3)
 * Multiply-add function computed as a ternary operation */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL fma)(float __x, float __y, float __z) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fmaf))(__x, __y, __z); }
#endif /* !... */
} /* extern "C++" */
#ifdef __COMPILER_HAVE_LONGLONG
extern "C++" {
#if __has_builtin(__builtin_llrintf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_llrintf)
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrint,(float __x),llrintf,{ return __builtin_llrintf(__x); })
#elif defined(__CRT_HAVE_llrintf)
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrint,(float __x),llrintf,(__x))
#elif defined(__CRT_HAVE___llrintf)
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrint,(float __x),__llrintf,(__x))
#elif defined(__CRT_HAVE_lrintf) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrint,(float __x),lrintf,(__x))
#elif defined(__CRT_HAVE___lrintf) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrint,(float __x),__lrintf,(__x))
#else /* ... */
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/llrintf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGLONG __NOTHROW(__LIBCCALL llrint)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(llrintf))(__x); }
#endif /* !... */
#if __has_builtin(__builtin_llroundf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_llroundf)
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llround,(float __x),llroundf,{ return __builtin_llroundf(__x); })
#elif defined(__CRT_HAVE_llroundf)
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llround,(float __x),llroundf,(__x))
#elif defined(__CRT_HAVE___llroundf)
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llround,(float __x),__llroundf,(__x))
#elif defined(__CRT_HAVE_lroundf) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llround,(float __x),lroundf,(__x))
#elif defined(__CRT_HAVE___lroundf) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llround,(float __x),__lroundf,(__x))
#else /* ... */
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/llroundf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGLONG __NOTHROW(__LIBCCALL llround)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(llroundf))(__x); }
#endif /* !... */
} /* extern "C++" */
#endif /* __COMPILER_HAVE_LONGLONG */
#ifdef __COMPILER_HAVE_LONGDOUBLE
extern "C++" {
#if __has_builtin(__builtin_exp2l) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_exp2l)
/* >> exp2f(3), exp2(3), exp2l(3)
 * Compute base-2 exponential of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,exp2,(__LONGDOUBLE __x),exp2l,{ return __builtin_exp2l(__x); })
#elif defined(__CRT_HAVE_exp2l)
/* >> exp2f(3), exp2(3), exp2l(3)
 * Compute base-2 exponential of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,exp2,(__LONGDOUBLE __x),exp2l,(__x))
#elif defined(__CRT_HAVE___exp2l)
/* >> exp2f(3), exp2(3), exp2l(3)
 * Compute base-2 exponential of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,exp2,(__LONGDOUBLE __x),__exp2l,(__x))
#elif defined(__CRT_HAVE_exp2) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> exp2f(3), exp2(3), exp2l(3)
 * Compute base-2 exponential of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,exp2,(__LONGDOUBLE __x),exp2,(__x))
#elif defined(__CRT_HAVE___exp2) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> exp2f(3), exp2(3), exp2l(3)
 * Compute base-2 exponential of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,exp2,(__LONGDOUBLE __x),__exp2,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_exp2) || defined(__CRT_HAVE___exp2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/exp2l.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> exp2f(3), exp2(3), exp2l(3)
 * Compute base-2 exponential of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL exp2)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(exp2l))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_log2l) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_log2l)
/* >> log2f(3), log2(3), log2l(3)
 * Compute base-2 logarithm of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,log2,(__LONGDOUBLE __x),log2l,{ return __builtin_log2l(__x); })
#elif defined(__CRT_HAVE_log2l)
/* >> log2f(3), log2(3), log2l(3)
 * Compute base-2 logarithm of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,log2,(__LONGDOUBLE __x),log2l,(__x))
#elif defined(__CRT_HAVE___log2l)
/* >> log2f(3), log2(3), log2l(3)
 * Compute base-2 logarithm of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,log2,(__LONGDOUBLE __x),__log2l,(__x))
#elif defined(__CRT_HAVE_log2) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> log2f(3), log2(3), log2l(3)
 * Compute base-2 logarithm of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,log2,(__LONGDOUBLE __x),log2,(__x))
#elif defined(__CRT_HAVE___log2) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> log2f(3), log2(3), log2l(3)
 * Compute base-2 logarithm of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,log2,(__LONGDOUBLE __x),__log2,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_log2) || defined(__CRT_HAVE___log2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/log2l.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> log2f(3), log2(3), log2l(3)
 * Compute base-2 logarithm of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL log2)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(log2l))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_copysignl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_copysignl)
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,copysign,(__LONGDOUBLE __num, __LONGDOUBLE __sign),copysignl,{ return __builtin_copysignl(__num, __sign); })
#elif defined(__CRT_HAVE_copysignl)
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,copysign,(__LONGDOUBLE __num, __LONGDOUBLE __sign),copysignl,(__num,__sign))
#elif defined(__CRT_HAVE___copysignl)
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,copysign,(__LONGDOUBLE __num, __LONGDOUBLE __sign),__copysignl,(__num,__sign))
#elif defined(__CRT_HAVE_copysign) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,copysign,(__LONGDOUBLE __num, __LONGDOUBLE __sign),copysign,(__num,__sign))
#elif defined(__CRT_HAVE___copysign) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,copysign,(__LONGDOUBLE __num, __LONGDOUBLE __sign),__copysign,(__num,__sign))
#else /* ... */
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/copysignl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL copysign)(__LONGDOUBLE __num, __LONGDOUBLE __sign) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(copysignl))(__num, __sign); }
#endif /* !... */
#if __has_builtin(__builtin_tgammal) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_tgammal)
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,tgamma,(__LONGDOUBLE __x),tgammal,{ return __builtin_tgammal(__x); })
#elif defined(__CRT_HAVE_tgammal)
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,tgamma,(__LONGDOUBLE __x),tgammal,(__x))
#elif defined(__CRT_HAVE___tgammal)
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,tgamma,(__LONGDOUBLE __x),__tgammal,(__x))
#elif defined(__CRT_HAVE_tgamma) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,tgamma,(__LONGDOUBLE __x),tgamma,(__x))
#elif defined(__CRT_HAVE___tgamma) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,tgamma,(__LONGDOUBLE __x),__tgamma,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_tgamma) || defined(__CRT_HAVE___tgamma) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/tgammal.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL tgamma)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(tgammal))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_nextafterl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nextafterl)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nexttoward,(__LONGDOUBLE __x, __LONGDOUBLE __y),nextafterl,{ return __builtin_nextafterl(__x, __y); })
#elif __has_builtin(__builtin_nexttowardl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nexttowardl)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nexttoward,(__LONGDOUBLE __x, __LONGDOUBLE __y),nexttowardl,{ return __builtin_nexttowardl(__x); })
#elif defined(__CRT_HAVE_nextafterl)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nexttoward,(__LONGDOUBLE __x, __LONGDOUBLE __y),nextafterl,(__x,__y))
#elif defined(__CRT_HAVE_nexttowardl)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nexttoward,(__LONGDOUBLE __x, __LONGDOUBLE __y),nexttowardl,(__x,__y))
#elif defined(__CRT_HAVE___nextafterl)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nexttoward,(__LONGDOUBLE __x, __LONGDOUBLE __y),__nextafterl,(__x,__y))
#elif defined(__CRT_HAVE___nexttowardl)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nexttoward,(__LONGDOUBLE __x, __LONGDOUBLE __y),__nexttowardl,(__x,__y))
#elif defined(__CRT_HAVE_nextafter) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nexttoward,(__LONGDOUBLE __x, __LONGDOUBLE __y),nextafter,(__x,__y))
#elif defined(__CRT_HAVE_nexttoward) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nexttoward,(__LONGDOUBLE __x, __LONGDOUBLE __y),nexttoward,(__x,__y))
#elif defined(__CRT_HAVE___nextafter) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nexttoward,(__LONGDOUBLE __x, __LONGDOUBLE __y),__nextafter,(__x,__y))
#elif defined(__CRT_HAVE___nexttoward) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nexttoward,(__LONGDOUBLE __x, __LONGDOUBLE __y),__nexttoward,(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_nextafter) || defined(__CRT_HAVE_nexttoward) || defined(__CRT_HAVE___nextafter) || defined(__CRT_HAVE__nextafter) || defined(__CRT_HAVE___nexttoward) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/nextafterl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL nexttoward)(__LONGDOUBLE __x, __LONGDOUBLE __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(nextafterl))(__x, __y); }
#endif /* ... */
#if __has_builtin(__builtin_scalbnl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_scalbnl)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbn,(__LONGDOUBLE __x, int __n),scalbnl,{ return __builtin_scalbnl(__x, __n); })
#elif defined(__CRT_HAVE_scalbnl)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbn,(__LONGDOUBLE __x, int __n),scalbnl,(__x,__n))
#elif defined(__CRT_HAVE___scalbnl)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbn,(__LONGDOUBLE __x, int __n),__scalbnl,(__x,__n))
#elif defined(__CRT_HAVE_scalbln) && __SIZEOF_INT__ == __SIZEOF_LONG__ && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbn,(__LONGDOUBLE __x, int __n),scalbln,(__x,__n))
#elif defined(__CRT_HAVE___scalbln) && __SIZEOF_INT__ == __SIZEOF_LONG__ && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbn,(__LONGDOUBLE __x, int __n),__scalbln,(__x,__n))
#elif defined(__CRT_HAVE_scalblnl) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbn,(__LONGDOUBLE __x, int __n),scalblnl,(__x,__n))
#elif defined(__CRT_HAVE___scalblnl) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbn,(__LONGDOUBLE __x, int __n),__scalblnl,(__x,__n))
#elif defined(__CRT_HAVE_scalbn) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbn,(__LONGDOUBLE __x, int __n),scalbn,(__x,__n))
#elif defined(__CRT_HAVE___scalbn) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbn,(__LONGDOUBLE __x, int __n),__scalbn,(__x,__n))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_scalbn) || defined(__CRT_HAVE___scalbn) || (defined(__CRT_HAVE_scalbln) && __SIZEOF_INT__ == __SIZEOF_LONG__) || (defined(__CRT_HAVE___scalbln) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/scalbnl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL scalbn)(__LONGDOUBLE __x, int __n) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(scalbnl))(__x, __n); }
#endif /* ... */
#if __has_builtin(__builtin_scalblnl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_scalblnl)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbln,(__LONGDOUBLE __x, long int __n),scalblnl,{ return __builtin_scalblnl(__x, __n); })
#elif defined(__CRT_HAVE_scalblnl)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbln,(__LONGDOUBLE __x, long int __n),scalblnl,(__x,__n))
#elif defined(__CRT_HAVE___scalblnl)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbln,(__LONGDOUBLE __x, long int __n),__scalblnl,(__x,__n))
#elif defined(__CRT_HAVE_scalbn) && __SIZEOF_INT__ == __SIZEOF_LONG__ && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbln,(__LONGDOUBLE __x, long int __n),scalbn,(__x,__n))
#elif defined(__CRT_HAVE_scalbnl) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbln,(__LONGDOUBLE __x, long int __n),scalbnl,(__x,__n))
#elif defined(__CRT_HAVE___scalbn) && __SIZEOF_INT__ == __SIZEOF_LONG__ && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbln,(__LONGDOUBLE __x, long int __n),__scalbn,(__x,__n))
#elif defined(__CRT_HAVE___scalbnl) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbln,(__LONGDOUBLE __x, long int __n),__scalbnl,(__x,__n))
#elif defined(__CRT_HAVE_scalbln) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbln,(__LONGDOUBLE __x, long int __n),scalbln,(__x,__n))
#elif defined(__CRT_HAVE___scalbln) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbln,(__LONGDOUBLE __x, long int __n),__scalbln,(__x,__n))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_scalbln) || defined(__CRT_HAVE___scalbln) || (defined(__CRT_HAVE_scalbn) && __SIZEOF_INT__ == __SIZEOF_LONG__) || (defined(__CRT_HAVE___scalbn) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/scalblnl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL scalbln)(__LONGDOUBLE __x, long int __n) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(scalblnl))(__x, __n); }
#endif /* ... */
#if __has_builtin(__builtin_rintl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_rintl)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nearbyint,(__LONGDOUBLE __x),rintl,{ return __builtin_rintl(__x); })
#elif __has_builtin(__builtin_nearbyintl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nearbyintl)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nearbyint,(__LONGDOUBLE __x),nearbyintl,{ return __builtin_nearbyintl(__x); })
#elif defined(__CRT_HAVE_rintl)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nearbyint,(__LONGDOUBLE __x),rintl,(__x))
#elif defined(__CRT_HAVE_nearbyintl)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nearbyint,(__LONGDOUBLE __x),nearbyintl,(__x))
#elif defined(__CRT_HAVE___rintl)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nearbyint,(__LONGDOUBLE __x),__rintl,(__x))
#elif defined(__CRT_HAVE___nearbyintl)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nearbyint,(__LONGDOUBLE __x),__nearbyintl,(__x))
#elif defined(__CRT_HAVE_rint) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nearbyint,(__LONGDOUBLE __x),rint,(__x))
#elif defined(__CRT_HAVE_nearbyint) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nearbyint,(__LONGDOUBLE __x),nearbyint,(__x))
#elif defined(__CRT_HAVE___rint) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nearbyint,(__LONGDOUBLE __x),__rint,(__x))
#elif defined(__CRT_HAVE___nearbyint) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,nearbyint,(__LONGDOUBLE __x),__nearbyint,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_rint) || defined(__CRT_HAVE_nearbyint) || defined(__CRT_HAVE___rint) || defined(__CRT_HAVE___nearbyint) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/rintl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL nearbyint)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(rintl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_roundl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_roundl)
/* >> roundf(3), round(3), roundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,round,(__LONGDOUBLE __x),roundl,{ return __builtin_roundl(__x); })
#elif defined(__CRT_HAVE_roundl)
/* >> roundf(3), round(3), roundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,round,(__LONGDOUBLE __x),roundl,(__x))
#elif defined(__CRT_HAVE___roundl)
/* >> roundf(3), round(3), roundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,round,(__LONGDOUBLE __x),__roundl,(__x))
#elif defined(__CRT_HAVE_round) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> roundf(3), round(3), roundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,round,(__LONGDOUBLE __x),round,(__x))
#elif defined(__CRT_HAVE___round) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> roundf(3), round(3), roundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,round,(__LONGDOUBLE __x),__round,(__x))
#else /* ... */
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/roundl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> roundf(3), round(3), roundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL round)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(roundl))(__x); }
#endif /* !... */
#if __has_builtin(__builtin_truncl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_truncl)
/* >> truncf(3), trunc(3), truncl(3)
 * Round `x' to the integral value in floating-point
 * format   nearest  but  not  larger  in  magnitude */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,trunc,(__LONGDOUBLE __x),truncl,{ return __builtin_truncl(__x); })
#elif defined(__CRT_HAVE_truncl)
/* >> truncf(3), trunc(3), truncl(3)
 * Round `x' to the integral value in floating-point
 * format   nearest  but  not  larger  in  magnitude */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,trunc,(__LONGDOUBLE __x),truncl,(__x))
#elif defined(__CRT_HAVE___truncl)
/* >> truncf(3), trunc(3), truncl(3)
 * Round `x' to the integral value in floating-point
 * format   nearest  but  not  larger  in  magnitude */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,trunc,(__LONGDOUBLE __x),__truncl,(__x))
#elif defined(__CRT_HAVE_trunc) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> truncf(3), trunc(3), truncl(3)
 * Round `x' to the integral value in floating-point
 * format   nearest  but  not  larger  in  magnitude */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,trunc,(__LONGDOUBLE __x),trunc,(__x))
#elif defined(__CRT_HAVE___trunc) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> truncf(3), trunc(3), truncl(3)
 * Round `x' to the integral value in floating-point
 * format   nearest  but  not  larger  in  magnitude */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,trunc,(__LONGDOUBLE __x),__trunc,(__x))
#else /* ... */
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/truncl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> truncf(3), trunc(3), truncl(3)
 * Round `x' to the integral value in floating-point
 * format   nearest  but  not  larger  in  magnitude */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL trunc)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(truncl))(__x); }
#endif /* !... */
#if __has_builtin(__builtin_remquol) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_remquol)
/* >> remquof(3), remquo(3), remquol(3)
 * Compute remainder of `x' and `p' and put in `*pquo' a value with
 * sign of x/p and magnitude  congruent `mod 2^n' to the  magnitude
 * of the integral quotient x/p, with n >= 3 */
__CEIREDIRECT(__ATTR_WUNUSED __ATTR_OUT(3),__LONGDOUBLE,__NOTHROW,remquo,(__LONGDOUBLE __x, __LONGDOUBLE __p, int *__pquo),remquol,{ return __builtin_remquol(__x, __p, __pquo); })
#elif defined(__CRT_HAVE_remquol)
/* >> remquof(3), remquo(3), remquol(3)
 * Compute remainder of `x' and `p' and put in `*pquo' a value with
 * sign of x/p and magnitude  congruent `mod 2^n' to the  magnitude
 * of the integral quotient x/p, with n >= 3 */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(3),__LONGDOUBLE,__NOTHROW,remquo,(__LONGDOUBLE __x, __LONGDOUBLE __p, int *__pquo),remquol,(__x,__p,__pquo))
#elif defined(__CRT_HAVE___remquol)
/* >> remquof(3), remquo(3), remquol(3)
 * Compute remainder of `x' and `p' and put in `*pquo' a value with
 * sign of x/p and magnitude  congruent `mod 2^n' to the  magnitude
 * of the integral quotient x/p, with n >= 3 */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(3),__LONGDOUBLE,__NOTHROW,remquo,(__LONGDOUBLE __x, __LONGDOUBLE __p, int *__pquo),__remquol,(__x,__p,__pquo))
#elif defined(__CRT_HAVE_remquo) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> remquof(3), remquo(3), remquol(3)
 * Compute remainder of `x' and `p' and put in `*pquo' a value with
 * sign of x/p and magnitude  congruent `mod 2^n' to the  magnitude
 * of the integral quotient x/p, with n >= 3 */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(3),__LONGDOUBLE,__NOTHROW,remquo,(__LONGDOUBLE __x, __LONGDOUBLE __p, int *__pquo),remquo,(__x,__p,__pquo))
#elif defined(__CRT_HAVE___remquo) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> remquof(3), remquo(3), remquol(3)
 * Compute remainder of `x' and `p' and put in `*pquo' a value with
 * sign of x/p and magnitude  congruent `mod 2^n' to the  magnitude
 * of the integral quotient x/p, with n >= 3 */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(3),__LONGDOUBLE,__NOTHROW,remquo,(__LONGDOUBLE __x, __LONGDOUBLE __p, int *__pquo),__remquo,(__x,__p,__pquo))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_remquo) || defined(__CRT_HAVE___remquo) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/remquol.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> remquof(3), remquo(3), remquol(3)
 * Compute remainder of `x' and `p' and put in `*pquo' a value with
 * sign of x/p and magnitude  congruent `mod 2^n' to the  magnitude
 * of the integral quotient x/p, with n >= 3 */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __ATTR_OUT(3) __LONGDOUBLE __NOTHROW(__LIBCCALL remquo)(__LONGDOUBLE __x, __LONGDOUBLE __p, int *__pquo) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(remquol))(__x, __p, __pquo); }
#endif /* ... */
#if __has_builtin(__builtin_lrintl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_lrintl)
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrint,(__LONGDOUBLE __x),lrintl,{ return __builtin_lrintl(__x); })
#elif defined(__CRT_HAVE_lrintl)
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrint,(__LONGDOUBLE __x),lrintl,(__x))
#elif defined(__CRT_HAVE___lrintl)
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrint,(__LONGDOUBLE __x),__lrintl,(__x))
#elif defined(__CRT_HAVE_llrint) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__ && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrint,(__LONGDOUBLE __x),llrint,(__x))
#elif defined(__CRT_HAVE___llrint) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__ && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrint,(__LONGDOUBLE __x),__llrint,(__x))
#elif defined(__CRT_HAVE_llrintl) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrint,(__LONGDOUBLE __x),llrintl,(__x))
#elif defined(__CRT_HAVE___llrintl) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrint,(__LONGDOUBLE __x),__llrintl,(__x))
#elif defined(__CRT_HAVE_remquo) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrint,(__LONGDOUBLE __x),remquo,(__x))
#elif defined(__CRT_HAVE___lrint) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lrint,(__LONGDOUBLE __x),__lrint,(__x))
#else /* ... */
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/lrintl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED long int __NOTHROW(__LIBCCALL lrint)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(lrintl))(__x); }
#endif /* !... */
#if __has_builtin(__builtin_lroundl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_lroundl)
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lround,(__LONGDOUBLE __x),lroundl,{ return __builtin_lroundl(__x); })
#elif defined(__CRT_HAVE_lroundl)
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lround,(__LONGDOUBLE __x),lroundl,(__x))
#elif defined(__CRT_HAVE___lroundl)
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lround,(__LONGDOUBLE __x),__lroundl,(__x))
#elif defined(__CRT_HAVE_llroundl) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lround,(__LONGDOUBLE __x),llroundl,(__x))
#elif defined(__CRT_HAVE___llroundl) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,lround,(__LONGDOUBLE __x),__llroundl,(__x))
#else /* ... */
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/lroundl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED long int __NOTHROW(__LIBCCALL lround)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(lroundl))(__x); }
#endif /* !... */
#if __has_builtin(__builtin_fdiml) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fdiml)
/* >> fdimf(3), fdim(3), fdiml(3)
 * Return positive difference between `x' and `y' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fdim,(__LONGDOUBLE __x, __LONGDOUBLE __y),fdiml,{ return __builtin_fdiml(__x, __y); })
#elif defined(__CRT_HAVE_fdiml)
/* >> fdimf(3), fdim(3), fdiml(3)
 * Return positive difference between `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fdim,(__LONGDOUBLE __x, __LONGDOUBLE __y),fdiml,(__x,__y))
#elif defined(__CRT_HAVE___fdiml)
/* >> fdimf(3), fdim(3), fdiml(3)
 * Return positive difference between `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fdim,(__LONGDOUBLE __x, __LONGDOUBLE __y),__fdiml,(__x,__y))
#elif defined(__CRT_HAVE_fdim) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> fdimf(3), fdim(3), fdiml(3)
 * Return positive difference between `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fdim,(__LONGDOUBLE __x, __LONGDOUBLE __y),fdim,(__x,__y))
#elif defined(__CRT_HAVE___fdim) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> fdimf(3), fdim(3), fdiml(3)
 * Return positive difference between `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fdim,(__LONGDOUBLE __x, __LONGDOUBLE __y),__fdim,(__x,__y))
#else /* ... */
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/fdiml.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> fdimf(3), fdim(3), fdiml(3)
 * Return positive difference between `x' and `y' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL fdim)(__LONGDOUBLE __x, __LONGDOUBLE __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fdiml))(__x, __y); }
#endif /* !... */
#if __has_builtin(__builtin_fmaxl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fmaxl)
/* >> fmaxf(3), fmax(3), fmaxl(3)
 * Return maximum numeric value from `x' and `y' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fmax,(__LONGDOUBLE __x, __LONGDOUBLE __y),fmaxl,{ return __builtin_fmaxl(__x, __y); })
#elif defined(__CRT_HAVE_fmaxl)
/* >> fmaxf(3), fmax(3), fmaxl(3)
 * Return maximum numeric value from `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fmax,(__LONGDOUBLE __x, __LONGDOUBLE __y),fmaxl,(__x,__y))
#elif defined(__CRT_HAVE___fmaxl)
/* >> fmaxf(3), fmax(3), fmaxl(3)
 * Return maximum numeric value from `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fmax,(__LONGDOUBLE __x, __LONGDOUBLE __y),__fmaxl,(__x,__y))
#elif defined(__CRT_HAVE_fmax) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> fmaxf(3), fmax(3), fmaxl(3)
 * Return maximum numeric value from `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fmax,(__LONGDOUBLE __x, __LONGDOUBLE __y),fmax,(__x,__y))
#elif defined(__CRT_HAVE___fmax) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> fmaxf(3), fmax(3), fmaxl(3)
 * Return maximum numeric value from `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fmax,(__LONGDOUBLE __x, __LONGDOUBLE __y),__fmax,(__x,__y))
#else /* ... */
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/fmaxl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> fmaxf(3), fmax(3), fmaxl(3)
 * Return maximum numeric value from `x' and `y' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL fmax)(__LONGDOUBLE __x, __LONGDOUBLE __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fmaxl))(__x, __y); }
#endif /* !... */
#if __has_builtin(__builtin_fminl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fminl)
/* >> fminf(3), fmin(3), fminl(3)
 * Return minimum numeric value from `x' and `y' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fmin,(__LONGDOUBLE __x, __LONGDOUBLE __y),fminl,{ return __builtin_fminl(__x, __y); })
#elif defined(__CRT_HAVE_fminl)
/* >> fminf(3), fmin(3), fminl(3)
 * Return minimum numeric value from `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fmin,(__LONGDOUBLE __x, __LONGDOUBLE __y),fminl,(__x,__y))
#elif defined(__CRT_HAVE___fminl)
/* >> fminf(3), fmin(3), fminl(3)
 * Return minimum numeric value from `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fmin,(__LONGDOUBLE __x, __LONGDOUBLE __y),__fminl,(__x,__y))
#elif defined(__CRT_HAVE_fmin) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> fminf(3), fmin(3), fminl(3)
 * Return minimum numeric value from `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fmin,(__LONGDOUBLE __x, __LONGDOUBLE __y),fmin,(__x,__y))
#elif defined(__CRT_HAVE___fmin) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> fminf(3), fmin(3), fminl(3)
 * Return minimum numeric value from `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fmin,(__LONGDOUBLE __x, __LONGDOUBLE __y),__fmin,(__x,__y))
#else /* ... */
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/fminl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> fminf(3), fmin(3), fminl(3)
 * Return minimum numeric value from `x' and `y' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL fmin)(__LONGDOUBLE __x, __LONGDOUBLE __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fminl))(__x, __y); }
#endif /* !... */
#if __has_builtin(__builtin_fmal) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fmal)
/* >> fmaf(3), fma(3), fmal(3)
 * Multiply-add function computed as a ternary operation */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fma,(__LONGDOUBLE __x, __LONGDOUBLE __y, __LONGDOUBLE __z),fmal,{ return __builtin_fmal(__x, __y, __z); })
#elif defined(__CRT_HAVE_fmal)
/* >> fmaf(3), fma(3), fmal(3)
 * Multiply-add function computed as a ternary operation */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fma,(__LONGDOUBLE __x, __LONGDOUBLE __y, __LONGDOUBLE __z),fmal,(__x,__y,__z))
#elif defined(__CRT_HAVE___fmal)
/* >> fmaf(3), fma(3), fmal(3)
 * Multiply-add function computed as a ternary operation */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fma,(__LONGDOUBLE __x, __LONGDOUBLE __y, __LONGDOUBLE __z),__fmal,(__x,__y,__z))
#elif defined(__CRT_HAVE_fma) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> fmaf(3), fma(3), fmal(3)
 * Multiply-add function computed as a ternary operation */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fma,(__LONGDOUBLE __x, __LONGDOUBLE __y, __LONGDOUBLE __z),fma,(__x,__y,__z))
#elif defined(__CRT_HAVE___fma) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> fmaf(3), fma(3), fmal(3)
 * Multiply-add function computed as a ternary operation */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,fma,(__LONGDOUBLE __x, __LONGDOUBLE __y, __LONGDOUBLE __z),__fma,(__x,__y,__z))
#else /* ... */
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/fmal.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> fmaf(3), fma(3), fmal(3)
 * Multiply-add function computed as a ternary operation */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL fma)(__LONGDOUBLE __x, __LONGDOUBLE __y, __LONGDOUBLE __z) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fmal))(__x, __y, __z); }
#endif /* !... */
} /* extern "C++" */
#ifdef __COMPILER_HAVE_LONGLONG
extern "C++" {
#if __has_builtin(__builtin_llrintl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_llrintl)
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrint,(__LONGDOUBLE __x),llrintl,{ return __builtin_llrintl(__x); })
#elif defined(__CRT_HAVE_llrintl)
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrint,(__LONGDOUBLE __x),llrintl,(__x))
#elif defined(__CRT_HAVE___llrintl)
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrint,(__LONGDOUBLE __x),__llrintl,(__x))
#elif defined(__CRT_HAVE_lrint) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__ && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrint,(__LONGDOUBLE __x),lrint,(__x))
#elif defined(__CRT_HAVE_lrintl) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrint,(__LONGDOUBLE __x),lrintl,(__x))
#elif defined(__CRT_HAVE___lrint) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__ && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrint,(__LONGDOUBLE __x),__lrint,(__x))
#elif defined(__CRT_HAVE___lrintl) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrint,(__LONGDOUBLE __x),__lrintl,(__x))
#elif defined(__CRT_HAVE_llrint) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrint,(__LONGDOUBLE __x),llrint,(__x))
#elif defined(__CRT_HAVE___llrint) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llrint,(__LONGDOUBLE __x),__llrint,(__x))
#else /* ... */
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/llrintl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> llrintf(3), llrint(3), llrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGLONG __NOTHROW(__LIBCCALL llrint)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(llrintl))(__x); }
#endif /* !... */
#if __has_builtin(__builtin_llroundl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_llroundl)
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llround,(__LONGDOUBLE __x),llroundl,{ return __builtin_llroundl(__x); })
#elif defined(__CRT_HAVE_llroundl)
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llround,(__LONGDOUBLE __x),llroundl,(__x))
#elif defined(__CRT_HAVE___llroundl)
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llround,(__LONGDOUBLE __x),__llroundl,(__x))
#elif defined(__CRT_HAVE_lround) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__ && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llround,(__LONGDOUBLE __x),lround,(__x))
#elif defined(__CRT_HAVE_lroundl) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llround,(__LONGDOUBLE __x),lroundl,(__x))
#elif defined(__CRT_HAVE___lround) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__ && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llround,(__LONGDOUBLE __x),__lround,(__x))
#elif defined(__CRT_HAVE___lroundl) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llround,(__LONGDOUBLE __x),__lroundl,(__x))
#elif defined(__CRT_HAVE_llround) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llround,(__LONGDOUBLE __x),llround,(__x))
#elif defined(__CRT_HAVE___llround) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGLONG,__NOTHROW,llround,(__LONGDOUBLE __x),__llround,(__x))
#else /* ... */
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/llroundl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> llroundf(3), llround(3), llroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGLONG __NOTHROW(__LIBCCALL llround)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(llroundl))(__x); }
#endif /* !... */
} /* extern "C++" */
#endif /* __COMPILER_HAVE_LONGLONG */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_ISOC99 */
#if defined(__USE_XOPEN) || defined(__USE_ISOC99)
extern "C++" {
#if __has_builtin(__builtin_hypotf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_hypotf)
/* >> hypotf(3), hypot(3), hypotl(3)
 * Return `sqrt(x*x + y*y)' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,hypot,(float __x, float __y),hypotf,{ return __builtin_hypotf(__x, __y); })
#elif defined(__CRT_HAVE_hypotf)
/* >> hypotf(3), hypot(3), hypotl(3)
 * Return `sqrt(x*x + y*y)' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,hypot,(float __x, float __y),hypotf,(__x,__y))
#elif defined(__CRT_HAVE__hypotf)
/* >> hypotf(3), hypot(3), hypotl(3)
 * Return `sqrt(x*x + y*y)' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,hypot,(float __x, float __y),_hypotf,(__x,__y))
#elif defined(__CRT_HAVE___hypotf)
/* >> hypotf(3), hypot(3), hypotl(3)
 * Return `sqrt(x*x + y*y)' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,hypot,(float __x, float __y),__hypotf,(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_hypot) || defined(__CRT_HAVE__hypot) || defined(__CRT_HAVE___hypot) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/hypotf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> hypotf(3), hypot(3), hypotl(3)
 * Return `sqrt(x*x + y*y)' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL hypot)(float __x, float __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(hypotf))(__x, __y); }
#endif /* ... */
#if __has_builtin(__builtin_erff) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_erff)
/* >> erff(3), erf(3), erfl(3) */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,erf,(float __x),erff,{ return __builtin_erff(__x); })
#elif defined(__CRT_HAVE_erff)
/* >> erff(3), erf(3), erfl(3) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,erf,(float __x),erff,(__x))
#elif defined(__CRT_HAVE___erff)
/* >> erff(3), erf(3), erfl(3) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,erf,(float __x),__erff,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_erf) || defined(__CRT_HAVE___erf) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/erff.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> erff(3), erf(3), erfl(3) */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL erf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(erff))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_erfcf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_erfcf)
/* >> erfcf(3), erfc(3), erfcl(3) */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,erfc,(float __x),erfcf,{ return __builtin_erfcf(__x); })
#elif defined(__CRT_HAVE_erfcf)
/* >> erfcf(3), erfc(3), erfcl(3) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,erfc,(float __x),erfcf,(__x))
#elif defined(__CRT_HAVE___erfcf)
/* >> erfcf(3), erfc(3), erfcl(3) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,erfc,(float __x),__erfcf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_erfc) || defined(__CRT_HAVE___erfc) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/erfcf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> erfcf(3), erfc(3), erfcl(3) */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL erfc)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(erfcf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_lgammaf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_lgammaf)
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,lgamma,(float __x),lgammaf,{ return __builtin_lgammaf(__x); })
#elif __has_builtin(__builtin_gammaf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_gammaf)
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,lgamma,(float __x),gammaf,{ return __builtin_gammaf(__x); })
#elif defined(__CRT_HAVE_lgammaf)
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,lgamma,(float __x),lgammaf,(__x))
#elif defined(__CRT_HAVE_gammaf)
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,lgamma,(float __x),gammaf,(__x))
#elif defined(__CRT_HAVE___lgammaf)
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,lgamma,(float __x),__lgammaf,(__x))
#elif defined(__CRT_HAVE___gammaf)
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,lgamma,(float __x),__gammaf,(__x))
#else /* ... */
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/template/signgam.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
#if defined(__LOCAL_signgam) && (defined(__CRT_HAVE_lgammaf_r) || defined(__CRT_HAVE___lgammaf_r) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_lgamma_r) || defined(__CRT_HAVE___lgamma_r) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__))
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/lgammaf.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL lgamma)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(lgammaf))(__x); }
#endif /* __LOCAL_signgam && (__CRT_HAVE_lgammaf_r || __CRT_HAVE___lgammaf_r || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_lgamma_r || __CRT_HAVE___lgamma_r || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__) */
#endif /* !... */
} /* extern "C++" */
#ifdef __COMPILER_HAVE_LONGDOUBLE
extern "C++" {
#if __has_builtin(__builtin_hypotl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_hypotl)
/* >> hypotf(3), hypot(3), hypotl(3)
 * Return `sqrt(x*x + y*y)' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,hypot,(__LONGDOUBLE __x, __LONGDOUBLE __y),hypotl,{ return __builtin_hypotl(__x, __y); })
#elif defined(__CRT_HAVE_hypotl)
/* >> hypotf(3), hypot(3), hypotl(3)
 * Return `sqrt(x*x + y*y)' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,hypot,(__LONGDOUBLE __x, __LONGDOUBLE __y),hypotl,(__x,__y))
#elif defined(__CRT_HAVE___hypotl)
/* >> hypotf(3), hypot(3), hypotl(3)
 * Return `sqrt(x*x + y*y)' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,hypot,(__LONGDOUBLE __x, __LONGDOUBLE __y),__hypotl,(__x,__y))
#elif defined(__CRT_HAVE_hypot) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> hypotf(3), hypot(3), hypotl(3)
 * Return `sqrt(x*x + y*y)' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,hypot,(__LONGDOUBLE __x, __LONGDOUBLE __y),hypot,(__x,__y))
#elif defined(__CRT_HAVE___hypot) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> hypotf(3), hypot(3), hypotl(3)
 * Return `sqrt(x*x + y*y)' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,hypot,(__LONGDOUBLE __x, __LONGDOUBLE __y),__hypot,(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_hypot) || defined(__CRT_HAVE__hypot) || defined(__CRT_HAVE___hypot) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/hypotl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> hypotf(3), hypot(3), hypotl(3)
 * Return `sqrt(x*x + y*y)' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL hypot)(__LONGDOUBLE __x, __LONGDOUBLE __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(hypotl))(__x, __y); }
#endif /* ... */
#if __has_builtin(__builtin_erfl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_erfl)
/* >> erff(3), erf(3), erfl(3) */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,erf,(__LONGDOUBLE __x),erfl,{ return __builtin_erfl(__x); })
#elif defined(__CRT_HAVE_erfl)
/* >> erff(3), erf(3), erfl(3) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,erf,(__LONGDOUBLE __x),erfl,(__x))
#elif defined(__CRT_HAVE___erfl)
/* >> erff(3), erf(3), erfl(3) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,erf,(__LONGDOUBLE __x),__erfl,(__x))
#elif defined(__CRT_HAVE_erf) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> erff(3), erf(3), erfl(3) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,erf,(__LONGDOUBLE __x),erf,(__x))
#elif defined(__CRT_HAVE___erf) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> erff(3), erf(3), erfl(3) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,erf,(__LONGDOUBLE __x),__erf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_erf) || defined(__CRT_HAVE___erf) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/erfl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> erff(3), erf(3), erfl(3) */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL erf)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(erfl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_erfcl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_erfcl)
/* >> erfcf(3), erfc(3), erfcl(3) */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,erfc,(__LONGDOUBLE __x),erfcl,{ return __builtin_erfcl(__x); })
#elif defined(__CRT_HAVE_erfcl)
/* >> erfcf(3), erfc(3), erfcl(3) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,erfc,(__LONGDOUBLE __x),erfcl,(__x))
#elif defined(__CRT_HAVE___erfcl)
/* >> erfcf(3), erfc(3), erfcl(3) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,erfc,(__LONGDOUBLE __x),__erfcl,(__x))
#elif defined(__CRT_HAVE_erfc) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> erfcf(3), erfc(3), erfcl(3) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,erfc,(__LONGDOUBLE __x),erfc,(__x))
#elif defined(__CRT_HAVE___erfc) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> erfcf(3), erfc(3), erfcl(3) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,erfc,(__LONGDOUBLE __x),__erfc,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_erfc) || defined(__CRT_HAVE___erfc) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/erfcl.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> erfcf(3), erfc(3), erfcl(3) */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL erfc)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(erfcl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_lgammal) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_lgammal)
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,lgamma,(__LONGDOUBLE __x),lgammal,{ return __builtin_lgammal(__x); })
#elif __has_builtin(__builtin_gammal) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_gammal)
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,lgamma,(__LONGDOUBLE __x),gammal,{ return __builtin_gammal(__x); })
#elif defined(__CRT_HAVE_lgammal)
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,lgamma,(__LONGDOUBLE __x),lgammal,(__x))
#elif defined(__CRT_HAVE_gammal)
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,lgamma,(__LONGDOUBLE __x),gammal,(__x))
#elif defined(__CRT_HAVE___lgammal)
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,lgamma,(__LONGDOUBLE __x),__lgammal,(__x))
#elif defined(__CRT_HAVE___gammal)
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,lgamma,(__LONGDOUBLE __x),__gammal,(__x))
#else /* ... */
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/template/signgam.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
#if defined(__LOCAL_signgam) && (defined(__CRT_HAVE_lgammal_r) || defined(__CRT_HAVE___lgammal_r) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_lgamma_r) || defined(__CRT_HAVE___lgamma_r) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__))
} /* extern "C++" */
__NAMESPACE_STD_END
#include <libc/local/math/lgammal.h>
__NAMESPACE_STD_BEGIN
extern "C++" {
/* >> lgammaf(3), lgamma(3), lgammal(3) */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL lgamma)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(lgammal))(__x); }
#endif /* __LOCAL_signgam && (__CRT_HAVE_lgammal_r || __CRT_HAVE___lgammal_r || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_lgamma_r || __CRT_HAVE___lgamma_r || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__) */
#endif /* !... */
} /* extern "C++" */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_XOPEN || __USE_ISOC99 */
#endif /* __cplusplus && __CORRECT_ISO_CPP_MATH_H_PROTO */
__NAMESPACE_STD_END
#ifndef __CXX_SYSTEM_HEADER
#if defined(__CRT_HAVE_acos) || defined(__CRT_HAVE___acos) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(acos)
#endif /* __CRT_HAVE_acos || __CRT_HAVE___acos || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_asin) || defined(__CRT_HAVE___asin) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(asin)
#endif /* __CRT_HAVE_asin || __CRT_HAVE___asin || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_atan) || defined(__CRT_HAVE___atan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(atan)
#endif /* __CRT_HAVE_atan || __CRT_HAVE___atan || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_atan2) || defined(__CRT_HAVE___atan2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(atan2)
#endif /* __CRT_HAVE_atan2 || __CRT_HAVE___atan2 || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_cos) || defined(__CRT_HAVE___cos) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(cos)
#endif /* __CRT_HAVE_cos || __CRT_HAVE___cos || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_sin) || defined(__CRT_HAVE___sin) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(sin)
#endif /* __CRT_HAVE_sin || __CRT_HAVE___sin || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_tan) || defined(__CRT_HAVE___tan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(tan)
#endif /* __CRT_HAVE_tan || __CRT_HAVE___tan || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_acosf) || defined(__CRT_HAVE___acosf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_acos) || defined(__CRT_HAVE___acos) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(acosf)
#endif /* __CRT_HAVE_acosf || __CRT_HAVE___acosf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_acos || __CRT_HAVE___acos || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_asinf) || defined(__CRT_HAVE___asinf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_asin) || defined(__CRT_HAVE___asin) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(asinf)
#endif /* __CRT_HAVE_asinf || __CRT_HAVE___asinf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_asin || __CRT_HAVE___asin || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_atanf) || defined(__CRT_HAVE___atanf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_atan) || defined(__CRT_HAVE___atan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(atanf)
#endif /* __CRT_HAVE_atanf || __CRT_HAVE___atanf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_atan || __CRT_HAVE___atan || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_atan2f) || defined(__CRT_HAVE___atan2f) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_atan2) || defined(__CRT_HAVE___atan2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(atan2f)
#endif /* __CRT_HAVE_atan2f || __CRT_HAVE___atan2f || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_atan2 || __CRT_HAVE___atan2 || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_cosf) || defined(__CRT_HAVE___cosf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_cos) || defined(__CRT_HAVE___cos) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(cosf)
#endif /* __CRT_HAVE_cosf || __CRT_HAVE___cosf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_cos || __CRT_HAVE___cos || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_sinf) || defined(__CRT_HAVE___sinf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_sin) || defined(__CRT_HAVE___sin) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(sinf)
#endif /* __CRT_HAVE_sinf || __CRT_HAVE___sinf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_sin || __CRT_HAVE___sin || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_tanf) || defined(__CRT_HAVE___tanf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_tan) || defined(__CRT_HAVE___tan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(tanf)
#endif /* __CRT_HAVE_tanf || __CRT_HAVE___tanf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_tan || __CRT_HAVE___tan || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* !__CXX_SYSTEM_HEADER */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#ifndef __CXX_SYSTEM_HEADER
#if defined(__CRT_HAVE_acosl) || defined(__CRT_HAVE___acosl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_acos) || defined(__CRT_HAVE___acos) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(acosl)
#endif /* __CRT_HAVE_acosl || __CRT_HAVE___acosl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_acos || __CRT_HAVE___acos || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_asinl) || defined(__CRT_HAVE___asinl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_asin) || defined(__CRT_HAVE___asin) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(asinl)
#endif /* __CRT_HAVE_asinl || __CRT_HAVE___asinl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_asin || __CRT_HAVE___asin || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_atanl) || defined(__CRT_HAVE___atanl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_atan) || defined(__CRT_HAVE___atan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(atanl)
#endif /* __CRT_HAVE_atanl || __CRT_HAVE___atanl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_atan || __CRT_HAVE___atan || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_atan2l) || defined(__CRT_HAVE___atan2l) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_atan2) || defined(__CRT_HAVE___atan2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(atan2l)
#endif /* __CRT_HAVE_atan2l || __CRT_HAVE___atan2l || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_atan2 || __CRT_HAVE___atan2 || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_cosl) || defined(__CRT_HAVE___cosl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_cos) || defined(__CRT_HAVE___cos) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(cosl)
#endif /* __CRT_HAVE_cosl || __CRT_HAVE___cosl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_cos || __CRT_HAVE___cos || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_sinl) || defined(__CRT_HAVE___sinl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_sin) || defined(__CRT_HAVE___sin) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(sinl)
#endif /* __CRT_HAVE_sinl || __CRT_HAVE___sinl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_sin || __CRT_HAVE___sin || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_tanl) || defined(__CRT_HAVE___tanl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_tan) || defined(__CRT_HAVE___tan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(tanl)
#endif /* __CRT_HAVE_tanl || __CRT_HAVE___tanl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_tan || __CRT_HAVE___tan || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* !__CXX_SYSTEM_HEADER */
#endif /* __COMPILER_HAVE_LONGDOUBLE */

/* Hyperbolic functions. */
#ifndef __CXX_SYSTEM_HEADER
#if defined(__CRT_HAVE_cosh) || defined(__CRT_HAVE___cosh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(cosh)
#endif /* __CRT_HAVE_cosh || __CRT_HAVE___cosh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_sinh) || defined(__CRT_HAVE___sinh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(sinh)
#endif /* __CRT_HAVE_sinh || __CRT_HAVE___sinh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_tanh) || defined(__CRT_HAVE___tanh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(tanh)
#endif /* __CRT_HAVE_tanh || __CRT_HAVE___tanh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_coshf) || defined(__CRT_HAVE___coshf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_cosh) || defined(__CRT_HAVE___cosh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(coshf)
#endif /* __CRT_HAVE_coshf || __CRT_HAVE___coshf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_cosh || __CRT_HAVE___cosh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_sinhf) || defined(__CRT_HAVE___sinhf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_sinh) || defined(__CRT_HAVE___sinh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(sinhf)
#endif /* __CRT_HAVE_sinhf || __CRT_HAVE___sinhf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_sinh || __CRT_HAVE___sinh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_tanhf) || defined(__CRT_HAVE___tanhf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_tanh) || defined(__CRT_HAVE___tanh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(tanhf)
#endif /* __CRT_HAVE_tanhf || __CRT_HAVE___tanhf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_tanh || __CRT_HAVE___tanh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* !__CXX_SYSTEM_HEADER */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#ifndef __CXX_SYSTEM_HEADER
#if defined(__CRT_HAVE_coshl) || defined(__CRT_HAVE___coshl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_cosh) || defined(__CRT_HAVE___cosh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(coshl)
#endif /* __CRT_HAVE_coshl || __CRT_HAVE___coshl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_cosh || __CRT_HAVE___cosh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_sinhl) || defined(__CRT_HAVE___sinhl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_sinh) || defined(__CRT_HAVE___sinh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(sinhl)
#endif /* __CRT_HAVE_sinhl || __CRT_HAVE___sinhl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_sinh || __CRT_HAVE___sinh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_tanhl) || defined(__CRT_HAVE___tanhl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_tanh) || defined(__CRT_HAVE___tanh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(tanhl)
#endif /* __CRT_HAVE_tanhl || __CRT_HAVE___tanhl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_tanh || __CRT_HAVE___tanh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* !__CXX_SYSTEM_HEADER */
#endif /* __COMPILER_HAVE_LONGDOUBLE */

#if defined(__USE_XOPEN_EXTENDED) || defined(__USE_ISOC99)
#ifndef __CXX_SYSTEM_HEADER
#if defined(__CRT_HAVE_acosh) || defined(__CRT_HAVE___acosh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(acosh)
#endif /* __CRT_HAVE_acosh || __CRT_HAVE___acosh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_asinh) || defined(__CRT_HAVE___asinh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(asinh)
#endif /* __CRT_HAVE_asinh || __CRT_HAVE___asinh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_atanh) || defined(__CRT_HAVE___atanh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(atanh)
#endif /* __CRT_HAVE_atanh || __CRT_HAVE___atanh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_acoshf) || defined(__CRT_HAVE___acoshf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_acosh) || defined(__CRT_HAVE___acosh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(acoshf)
#endif /* __CRT_HAVE_acoshf || __CRT_HAVE___acoshf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_acosh || __CRT_HAVE___acosh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_asinhf) || defined(__CRT_HAVE___asinhf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_asinh) || defined(__CRT_HAVE___asinh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(asinhf)
#endif /* __CRT_HAVE_asinhf || __CRT_HAVE___asinhf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_asinh || __CRT_HAVE___asinh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_atanhf) || defined(__CRT_HAVE___atanhf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_atanh) || defined(__CRT_HAVE___atanh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(atanhf)
#endif /* __CRT_HAVE_atanhf || __CRT_HAVE___atanhf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_atanh || __CRT_HAVE___atanh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* !__CXX_SYSTEM_HEADER */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#ifndef __CXX_SYSTEM_HEADER
#if defined(__CRT_HAVE_acoshl) || defined(__CRT_HAVE___acoshl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_acosh) || defined(__CRT_HAVE___acosh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(acoshl)
#endif /* __CRT_HAVE_acoshl || __CRT_HAVE___acoshl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_acosh || __CRT_HAVE___acosh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_asinhl) || defined(__CRT_HAVE___asinhl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_asinh) || defined(__CRT_HAVE___asinh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(asinhl)
#endif /* __CRT_HAVE_asinhl || __CRT_HAVE___asinhl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_asinh || __CRT_HAVE___asinh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_atanhl) || defined(__CRT_HAVE___atanhl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_atanh) || defined(__CRT_HAVE___atanh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(atanhl)
#endif /* __CRT_HAVE_atanhl || __CRT_HAVE___atanhl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_atanh || __CRT_HAVE___atanh || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* !__CXX_SYSTEM_HEADER */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_XOPEN_EXTENDED || __USE_ISOC99 */

/* Exponential and logarithmic functions. */
#ifndef __CXX_SYSTEM_HEADER
#if defined(__CRT_HAVE_exp) || defined(__CRT_HAVE___exp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(exp)
#endif /* __CRT_HAVE_exp || __CRT_HAVE___exp || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_frexp) || defined(__CRT_HAVE___frexp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(frexp)
#endif /* __CRT_HAVE_frexp || __CRT_HAVE___frexp || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_ldexp) || defined(__CRT_HAVE___ldexp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(ldexp)
#endif /* __CRT_HAVE_ldexp || __CRT_HAVE___ldexp || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_log) || defined(__CRT_HAVE___log) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(log)
#endif /* __CRT_HAVE_log || __CRT_HAVE___log || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_log10) || defined(__CRT_HAVE___log10) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(log10)
#endif /* __CRT_HAVE_log10 || __CRT_HAVE___log10 || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_modf) || defined(__CRT_HAVE___modf) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(modf)
#endif /* __CRT_HAVE_modf || __CRT_HAVE___modf || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_expf) || defined(__CRT_HAVE___expf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_exp) || defined(__CRT_HAVE___exp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(expf)
#endif /* __CRT_HAVE_expf || __CRT_HAVE___expf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_exp || __CRT_HAVE___exp || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_frexpf) || defined(__CRT_HAVE___frexpf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_frexp) || defined(__CRT_HAVE___frexp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(frexpf)
#endif /* __CRT_HAVE_frexpf || __CRT_HAVE___frexpf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_frexp || __CRT_HAVE___frexp || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_ldexpf) || defined(__CRT_HAVE___ldexpf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_ldexp) || defined(__CRT_HAVE___ldexp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(ldexpf)
#endif /* __CRT_HAVE_ldexpf || __CRT_HAVE___ldexpf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_ldexp || __CRT_HAVE___ldexp || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_logf) || defined(__CRT_HAVE___logf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_log) || defined(__CRT_HAVE___log) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(logf)
#endif /* __CRT_HAVE_logf || __CRT_HAVE___logf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_log || __CRT_HAVE___log || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_log10f) || defined(__CRT_HAVE___log10f) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_log10) || defined(__CRT_HAVE___log10) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(log10f)
#endif /* __CRT_HAVE_log10f || __CRT_HAVE___log10f || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_log10 || __CRT_HAVE___log10 || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_modff) || defined(__CRT_HAVE___modff) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_modf) || defined(__CRT_HAVE___modf) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(modff)
#endif /* __CRT_HAVE_modff || __CRT_HAVE___modff || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_modf || __CRT_HAVE___modf || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* !__CXX_SYSTEM_HEADER */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#ifndef __CXX_SYSTEM_HEADER
#if defined(__CRT_HAVE_expl) || defined(__CRT_HAVE___expl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_exp) || defined(__CRT_HAVE___exp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(expl)
#endif /* __CRT_HAVE_expl || __CRT_HAVE___expl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_exp || __CRT_HAVE___exp || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_frexpl) || defined(__CRT_HAVE___frexpl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_frexp) || defined(__CRT_HAVE___frexp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(frexpl)
#endif /* __CRT_HAVE_frexpl || __CRT_HAVE___frexpl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_frexp || __CRT_HAVE___frexp || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_ldexpl) || defined(__CRT_HAVE___ldexpl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_ldexp) || defined(__CRT_HAVE___ldexp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(ldexpl)
#endif /* __CRT_HAVE_ldexpl || __CRT_HAVE___ldexpl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_ldexp || __CRT_HAVE___ldexp || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_logl) || defined(__CRT_HAVE___logl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_log) || defined(__CRT_HAVE___log) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(logl)
#endif /* __CRT_HAVE_logl || __CRT_HAVE___logl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_log || __CRT_HAVE___log || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_log10l) || defined(__CRT_HAVE___log10l) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_log10) || defined(__CRT_HAVE___log10) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(log10l)
#endif /* __CRT_HAVE_log10l || __CRT_HAVE___log10l || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_log10 || __CRT_HAVE___log10 || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_modfl) || defined(__CRT_HAVE___modfl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_modf) || defined(__CRT_HAVE___modf) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(modfl)
#endif /* __CRT_HAVE_modfl || __CRT_HAVE___modfl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_modf || __CRT_HAVE___modf || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* !__CXX_SYSTEM_HEADER */
#endif /* __COMPILER_HAVE_LONGDOUBLE */

#if defined(__USE_XOPEN_EXTENDED) || defined(__USE_ISOC99)
#ifndef __CXX_SYSTEM_HEADER
#if defined(__CRT_HAVE_expm1) || defined(__CRT_HAVE___expm1) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(expm1)
#endif /* __CRT_HAVE_expm1 || __CRT_HAVE___expm1 || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_log1p) || defined(__CRT_HAVE___log1p) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(log1p)
#endif /* __CRT_HAVE_log1p || __CRT_HAVE___log1p || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_logb) || defined(__CRT_HAVE___logb) || defined(__CRT_HAVE__logb) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(logb)
#endif /* __CRT_HAVE_logb || __CRT_HAVE___logb || __CRT_HAVE__logb || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_expm1f) || defined(__CRT_HAVE___expm1f) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_expm1) || defined(__CRT_HAVE___expm1) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(expm1f)
#endif /* __CRT_HAVE_expm1f || __CRT_HAVE___expm1f || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_expm1 || __CRT_HAVE___expm1 || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_log1pf) || defined(__CRT_HAVE___log1pf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_log1p) || defined(__CRT_HAVE___log1p) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(log1pf)
#endif /* __CRT_HAVE_log1pf || __CRT_HAVE___log1pf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_log1p || __CRT_HAVE___log1p || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_logbf) || defined(__CRT_HAVE___logbf) || defined(__CRT_HAVE__logbf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_logb) || defined(__CRT_HAVE___logb) || defined(__CRT_HAVE__logb) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(logbf)
#endif /* __CRT_HAVE_logbf || __CRT_HAVE___logbf || __CRT_HAVE__logbf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_logb || __CRT_HAVE___logb || __CRT_HAVE__logb || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* !__CXX_SYSTEM_HEADER */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#ifndef __CXX_SYSTEM_HEADER
#if defined(__CRT_HAVE_expm1l) || defined(__CRT_HAVE___expm1l) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_expm1) || defined(__CRT_HAVE___expm1) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(expm1l)
#endif /* __CRT_HAVE_expm1l || __CRT_HAVE___expm1l || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_expm1 || __CRT_HAVE___expm1 || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_log1pl) || defined(__CRT_HAVE___log1pl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_log1p) || defined(__CRT_HAVE___log1p) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(log1pl)
#endif /* __CRT_HAVE_log1pl || __CRT_HAVE___log1pl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_log1p || __CRT_HAVE___log1p || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_logbl) || defined(__CRT_HAVE___logbl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_logb) || defined(__CRT_HAVE___logb) || defined(__CRT_HAVE__logb) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(logbl)
#endif /* __CRT_HAVE_logbl || __CRT_HAVE___logbl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_logb || __CRT_HAVE___logb || __CRT_HAVE__logb || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* !__CXX_SYSTEM_HEADER */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_XOPEN_EXTENDED || __USE_ISOC99 */

#ifdef __USE_ISOC99
#ifndef __CXX_SYSTEM_HEADER
#if defined(__CRT_HAVE_exp2) || defined(__CRT_HAVE___exp2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(exp2)
#endif /* __CRT_HAVE_exp2 || __CRT_HAVE___exp2 || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_log2) || defined(__CRT_HAVE___log2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(log2)
#endif /* __CRT_HAVE_log2 || __CRT_HAVE___log2 || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_exp2f) || defined(__CRT_HAVE___exp2f) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_exp2) || defined(__CRT_HAVE___exp2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(exp2f)
#endif /* __CRT_HAVE_exp2f || __CRT_HAVE___exp2f || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_exp2 || __CRT_HAVE___exp2 || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_log2f) || defined(__CRT_HAVE___log2f) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_log2) || defined(__CRT_HAVE___log2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(log2f)
#endif /* __CRT_HAVE_log2f || __CRT_HAVE___log2f || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_log2 || __CRT_HAVE___log2 || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* !__CXX_SYSTEM_HEADER */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#ifndef __CXX_SYSTEM_HEADER
#if defined(__CRT_HAVE_exp2l) || defined(__CRT_HAVE___exp2l) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_exp2) || defined(__CRT_HAVE___exp2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(exp2l)
#endif /* __CRT_HAVE_exp2l || __CRT_HAVE___exp2l || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_exp2 || __CRT_HAVE___exp2 || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_log2l) || defined(__CRT_HAVE___log2l) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_log2) || defined(__CRT_HAVE___log2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(log2l)
#endif /* __CRT_HAVE_log2l || __CRT_HAVE___log2l || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_log2 || __CRT_HAVE___log2 || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* !__CXX_SYSTEM_HEADER */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_ISOC99 */

/* Power functions. */
#ifndef __CXX_SYSTEM_HEADER
#if defined(__CRT_HAVE_pow) || defined(__CRT_HAVE___pow) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(pow)
#endif /* __CRT_HAVE_pow || __CRT_HAVE___pow || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_sqrt) || defined(__CRT_HAVE___sqrt) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(sqrt)
#endif /* __CRT_HAVE_sqrt || __CRT_HAVE___sqrt || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_powf) || defined(__CRT_HAVE___powf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_pow) || defined(__CRT_HAVE___pow) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(powf)
#endif /* __CRT_HAVE_powf || __CRT_HAVE___powf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_pow || __CRT_HAVE___pow || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_sqrtf) || defined(__CRT_HAVE___sqrtf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_sqrt) || defined(__CRT_HAVE___sqrt) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(sqrtf)
#endif /* __CRT_HAVE_sqrtf || __CRT_HAVE___sqrtf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_sqrt || __CRT_HAVE___sqrt || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* !__CXX_SYSTEM_HEADER */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#ifndef __CXX_SYSTEM_HEADER
#if defined(__CRT_HAVE_powl) || defined(__CRT_HAVE___powl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_pow) || defined(__CRT_HAVE___pow) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(powl)
#endif /* __CRT_HAVE_powl || __CRT_HAVE___powl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_pow || __CRT_HAVE___pow || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_sqrtl) || defined(__CRT_HAVE___sqrtl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_sqrt) || defined(__CRT_HAVE___sqrt) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(sqrtl)
#endif /* __CRT_HAVE_sqrtl || __CRT_HAVE___sqrtl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_sqrt || __CRT_HAVE___sqrt || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* !__CXX_SYSTEM_HEADER */
#endif /* __COMPILER_HAVE_LONGDOUBLE */

#if defined(__USE_XOPEN) || defined(__USE_ISOC99)
#ifndef __CXX_SYSTEM_HEADER
#if defined(__CRT_HAVE_hypot) || defined(__CRT_HAVE__hypot) || defined(__CRT_HAVE___hypot) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(hypot)
#endif /* __CRT_HAVE_hypot || __CRT_HAVE__hypot || __CRT_HAVE___hypot || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_hypotf) || defined(__CRT_HAVE__hypotf) || defined(__CRT_HAVE___hypotf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_hypot) || defined(__CRT_HAVE__hypot) || defined(__CRT_HAVE___hypot) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(hypotf)
#endif /* __CRT_HAVE_hypotf || __CRT_HAVE__hypotf || __CRT_HAVE___hypotf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_hypot || __CRT_HAVE__hypot || __CRT_HAVE___hypot || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* !__CXX_SYSTEM_HEADER */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#ifndef __CXX_SYSTEM_HEADER
#if defined(__CRT_HAVE_hypotl) || defined(__CRT_HAVE___hypotl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_hypot) || defined(__CRT_HAVE__hypot) || defined(__CRT_HAVE___hypot) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(hypotl)
#endif /* __CRT_HAVE_hypotl || __CRT_HAVE___hypotl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_hypot || __CRT_HAVE__hypot || __CRT_HAVE___hypot || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* !__CXX_SYSTEM_HEADER */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_XOPEN || __USE_ISOC99 */

#if defined(__USE_XOPEN_EXTENDED) || defined(__USE_ISOC99)
#ifndef __CXX_SYSTEM_HEADER
#if defined(__CRT_HAVE_cbrt) || defined(__CRT_HAVE___cbrt) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(cbrt)
#endif /* __CRT_HAVE_cbrt || __CRT_HAVE___cbrt || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_cbrtf) || defined(__CRT_HAVE___cbrtf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_cbrt) || defined(__CRT_HAVE___cbrt) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(cbrtf)
#endif /* __CRT_HAVE_cbrtf || __CRT_HAVE___cbrtf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_cbrt || __CRT_HAVE___cbrt || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* !__CXX_SYSTEM_HEADER */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#ifndef __CXX_SYSTEM_HEADER
#if defined(__CRT_HAVE_cbrtl) || defined(__CRT_HAVE___cbrtl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_cbrt) || defined(__CRT_HAVE___cbrt) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(cbrtl)
#endif /* __CRT_HAVE_cbrtl || __CRT_HAVE___cbrtl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_cbrt || __CRT_HAVE___cbrt || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* !__CXX_SYSTEM_HEADER */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_XOPEN_EXTENDED || __USE_ISOC99 */

/* Nearest integer, absolute value, and remainder functions. */
#ifndef __CXX_SYSTEM_HEADER
__NAMESPACE_STD_USING(ceil)
__NAMESPACE_STD_USING(fabs)
__NAMESPACE_STD_USING(floor)
#if defined(__CRT_HAVE_fmod) || defined(__CRT_HAVE___fmod) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(fmod)
#endif /* __CRT_HAVE_fmod || __CRT_HAVE___fmod || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
__NAMESPACE_STD_USING(ceilf)
__NAMESPACE_STD_USING(fabsf)
__NAMESPACE_STD_USING(floorf)
#if defined(__CRT_HAVE_fmodf) || defined(__CRT_HAVE___fmodf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_fmod) || defined(__CRT_HAVE___fmod) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(fmodf)
#endif /* __CRT_HAVE_fmodf || __CRT_HAVE___fmodf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_fmod || __CRT_HAVE___fmod || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* !__CXX_SYSTEM_HEADER */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#ifndef __CXX_SYSTEM_HEADER
__NAMESPACE_STD_USING(ceill)
__NAMESPACE_STD_USING(fabsl)
__NAMESPACE_STD_USING(floorl)
#if defined(__CRT_HAVE_fmodl) || defined(__CRT_HAVE___fmodl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_fmod) || defined(__CRT_HAVE___fmod) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(fmodl)
#endif /* __CRT_HAVE_fmodl || __CRT_HAVE___fmodl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_fmod || __CRT_HAVE___fmod || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* !__CXX_SYSTEM_HEADER */
#endif /* __COMPILER_HAVE_LONGDOUBLE */

#ifdef __USE_ISOC99
#ifndef __CXX_SYSTEM_HEADER
__NAMESPACE_STD_USING(copysign)
#if defined(__CRT_HAVE_nan) || defined(__CRT_HAVE___nan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(nan)
#endif /* __CRT_HAVE_nan || __CRT_HAVE___nan || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
__NAMESPACE_STD_USING(copysignf)
#if defined(__CRT_HAVE_nanf) || defined(__CRT_HAVE___nanf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_nan) || defined(__CRT_HAVE___nan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(nanf)
#endif /* __CRT_HAVE_nanf || __CRT_HAVE___nanf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_nan || __CRT_HAVE___nan || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* !__CXX_SYSTEM_HEADER */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#ifndef __CXX_SYSTEM_HEADER
__NAMESPACE_STD_USING(copysignl)
#if defined(__CRT_HAVE_nanl) || defined(__CRT_HAVE___nanl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_nan) || defined(__CRT_HAVE___nan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(nanl)
#endif /* __CRT_HAVE_nanl || __CRT_HAVE___nanl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_nan || __CRT_HAVE___nan || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* !__CXX_SYSTEM_HEADER */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_ISOC99 */

/* Error and gamma functions. */
#if defined(__USE_XOPEN) || defined(__USE_ISOC99)
#ifndef __CXX_SYSTEM_HEADER
#if defined(__CRT_HAVE_erf) || defined(__CRT_HAVE___erf) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(erf)
#endif /* __CRT_HAVE_erf || __CRT_HAVE___erf || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_erfc) || defined(__CRT_HAVE___erfc) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(erfc)
#endif /* __CRT_HAVE_erfc || __CRT_HAVE___erfc || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#include <libc/template/signgam.h>
#if defined(__CRT_HAVE_lgamma) || defined(__CRT_HAVE_gamma) || defined(__CRT_HAVE___lgamma) || defined(__CRT_HAVE___gamma) || (defined(__LOCAL_signgam) && (defined(__CRT_HAVE_lgamma_r) || defined(__CRT_HAVE___lgamma_r) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)))
__NAMESPACE_STD_USING(lgamma)
#endif /* __CRT_HAVE_lgamma || __CRT_HAVE_gamma || __CRT_HAVE___lgamma || __CRT_HAVE___gamma || (__LOCAL_signgam && (__CRT_HAVE_lgamma_r || __CRT_HAVE___lgamma_r || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)) */
#if defined(__CRT_HAVE_erff) || defined(__CRT_HAVE___erff) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_erf) || defined(__CRT_HAVE___erf) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(erff)
#endif /* __CRT_HAVE_erff || __CRT_HAVE___erff || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_erf || __CRT_HAVE___erf || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_erfcf) || defined(__CRT_HAVE___erfcf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_erfc) || defined(__CRT_HAVE___erfc) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(erfcf)
#endif /* __CRT_HAVE_erfcf || __CRT_HAVE___erfcf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_erfc || __CRT_HAVE___erfc || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_lgammaf) || defined(__CRT_HAVE_gammaf) || defined(__CRT_HAVE___lgammaf) || defined(__CRT_HAVE___gammaf) || (defined(__LOCAL_signgam) && (defined(__CRT_HAVE_lgammaf_r) || defined(__CRT_HAVE___lgammaf_r) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_lgamma_r) || defined(__CRT_HAVE___lgamma_r) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)))
__NAMESPACE_STD_USING(lgammaf)
#endif /* __CRT_HAVE_lgammaf || __CRT_HAVE_gammaf || __CRT_HAVE___lgammaf || __CRT_HAVE___gammaf || (__LOCAL_signgam && (__CRT_HAVE_lgammaf_r || __CRT_HAVE___lgammaf_r || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_lgamma_r || __CRT_HAVE___lgamma_r || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)) */
#endif /* !__CXX_SYSTEM_HEADER */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#ifndef __CXX_SYSTEM_HEADER
#if defined(__CRT_HAVE_erfl) || defined(__CRT_HAVE___erfl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_erf) || defined(__CRT_HAVE___erf) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(erfl)
#endif /* __CRT_HAVE_erfl || __CRT_HAVE___erfl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_erf || __CRT_HAVE___erf || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_erfcl) || defined(__CRT_HAVE___erfcl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_erfc) || defined(__CRT_HAVE___erfc) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(erfcl)
#endif /* __CRT_HAVE_erfcl || __CRT_HAVE___erfcl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_erfc || __CRT_HAVE___erfc || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_lgammal) || defined(__CRT_HAVE_gammal) || defined(__CRT_HAVE___lgammal) || defined(__CRT_HAVE___gammal) || (defined(__LOCAL_signgam) && (defined(__CRT_HAVE_lgammal_r) || defined(__CRT_HAVE___lgammal_r) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_lgamma_r) || defined(__CRT_HAVE___lgamma_r) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)))
__NAMESPACE_STD_USING(lgammal)
#endif /* __CRT_HAVE_lgammal || __CRT_HAVE_gammal || __CRT_HAVE___lgammal || __CRT_HAVE___gammal || (__LOCAL_signgam && (__CRT_HAVE_lgammal_r || __CRT_HAVE___lgammal_r || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_lgamma_r || __CRT_HAVE___lgamma_r || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)) */
#endif /* !__CXX_SYSTEM_HEADER */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_XOPEN || __USE_ISOC99 */
#ifdef __USE_ISOC99
#ifndef __CXX_SYSTEM_HEADER
#if defined(__CRT_HAVE_tgamma) || defined(__CRT_HAVE___tgamma) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(tgamma)
#endif /* __CRT_HAVE_tgamma || __CRT_HAVE___tgamma || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_tgammaf) || defined(__CRT_HAVE___tgammaf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_tgamma) || defined(__CRT_HAVE___tgamma) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(tgammaf)
#endif /* __CRT_HAVE_tgammaf || __CRT_HAVE___tgammaf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_tgamma || __CRT_HAVE___tgamma || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* !__CXX_SYSTEM_HEADER */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#ifndef __CXX_SYSTEM_HEADER
#if defined(__CRT_HAVE_tgammal) || defined(__CRT_HAVE___tgammal) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_tgamma) || defined(__CRT_HAVE___tgamma) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(tgammal)
#endif /* __CRT_HAVE_tgammal || __CRT_HAVE___tgammal || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_tgamma || __CRT_HAVE___tgamma || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#endif /* !__CXX_SYSTEM_HEADER */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_ISOC99 */

#if defined(__USE_XOPEN_EXTENDED) || defined(__USE_ISOC99)
#ifndef __CXX_SYSTEM_HEADER
#if defined(__CRT_HAVE_rint) || defined(__CRT_HAVE_nearbyint) || defined(__CRT_HAVE___rint) || defined(__CRT_HAVE___nearbyint) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(rint)
#endif /* __CRT_HAVE_rint || __CRT_HAVE_nearbyint || __CRT_HAVE___rint || __CRT_HAVE___nearbyint || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_nextafter) || defined(__CRT_HAVE_nexttoward) || defined(__CRT_HAVE___nextafter) || defined(__CRT_HAVE__nextafter) || defined(__CRT_HAVE___nexttoward) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(nextafter)
#endif /* __CRT_HAVE_nextafter || __CRT_HAVE_nexttoward || __CRT_HAVE___nextafter || __CRT_HAVE__nextafter || __CRT_HAVE___nexttoward || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_remainder) || defined(__CRT_HAVE_drem) || defined(__CRT_HAVE___remainder) || defined(__CRT_HAVE___drem) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(remainder)
#endif /* __CRT_HAVE_remainder || __CRT_HAVE_drem || __CRT_HAVE___remainder || __CRT_HAVE___drem || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_ilogb) || (defined(__CRT_HAVE_llogb) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__CRT_HAVE___ilogb) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(ilogb)
#endif /* __CRT_HAVE_ilogb || (__CRT_HAVE_llogb && __SIZEOF_INT__ == __SIZEOF_LONG__) || __CRT_HAVE___ilogb || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_rintf) || defined(__CRT_HAVE_nearbyintf) || defined(__CRT_HAVE___rintf) || defined(__CRT_HAVE___nearbyintf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_rint) || defined(__CRT_HAVE_nearbyint) || defined(__CRT_HAVE___rint) || defined(__CRT_HAVE___nearbyint) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(rintf)
#endif /* __CRT_HAVE_rintf || __CRT_HAVE_nearbyintf || __CRT_HAVE___rintf || __CRT_HAVE___nearbyintf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_rint || __CRT_HAVE_nearbyint || __CRT_HAVE___rint || __CRT_HAVE___nearbyint || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_nextafterf) || defined(__CRT_HAVE_nexttowardf) || defined(__CRT_HAVE___nextafterf) || defined(__CRT_HAVE___nexttowardf) || defined(__CRT_HAVE__nextafterf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_nextafter) || defined(__CRT_HAVE_nexttoward) || defined(__CRT_HAVE___nextafter) || defined(__CRT_HAVE__nextafter) || defined(__CRT_HAVE___nexttoward) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(nextafterf)
#endif /* __CRT_HAVE_nextafterf || __CRT_HAVE_nexttowardf || __CRT_HAVE___nextafterf || __CRT_HAVE___nexttowardf || __CRT_HAVE__nextafterf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_nextafter || __CRT_HAVE_nexttoward || __CRT_HAVE___nextafter || __CRT_HAVE__nextafter || __CRT_HAVE___nexttoward || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_remainderf) || defined(__CRT_HAVE_dremf) || defined(__CRT_HAVE___remainderf) || defined(__CRT_HAVE___dremf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_remainder) || defined(__CRT_HAVE_drem) || defined(__CRT_HAVE___remainder) || defined(__CRT_HAVE___drem) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(remainderf)
#endif /* __CRT_HAVE_remainderf || __CRT_HAVE_dremf || __CRT_HAVE___remainderf || __CRT_HAVE___dremf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_remainder || __CRT_HAVE_drem || __CRT_HAVE___remainder || __CRT_HAVE___drem || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_ilogbf) || (defined(__CRT_HAVE_llogbf) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__CRT_HAVE___ilogbf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_ilogb) || (defined(__CRT_HAVE_llogb) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__CRT_HAVE___ilogb) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(ilogbf)
#endif /* __CRT_HAVE_ilogbf || (__CRT_HAVE_llogbf && __SIZEOF_INT__ == __SIZEOF_LONG__) || __CRT_HAVE___ilogbf || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __CRT_HAVE_ilogb || (__CRT_HAVE_llogb && __SIZEOF_INT__ == __SIZEOF_LONG__) || __CRT_HAVE___ilogb || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ */
#endif /* !__CXX_SYSTEM_HEADER */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#ifndef __CXX_SYSTEM_HEADER
#if defined(__CRT_HAVE_rintl) || defined(__CRT_HAVE_nearbyintl) || defined(__CRT_HAVE___rintl) || defined(__CRT_HAVE___nearbyintl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_rint) || defined(__CRT_HAVE_nearbyint) || defined(__CRT_HAVE___rint) || defined(__CRT_HAVE___nearbyint) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(rintl)
#endif /* __CRT_HAVE_rintl || __CRT_HAVE_nearbyintl || __CRT_HAVE___rintl || __CRT_HAVE___nearbyintl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_rint || __CRT_HAVE_nearbyint || __CRT_HAVE___rint || __CRT_HAVE___nearbyint || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_nextafterl) || defined(__CRT_HAVE_nexttowardl) || defined(__CRT_HAVE___nextafterl) || defined(__CRT_HAVE___nexttowardl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_nextafter) || defined(__CRT_HAVE_nexttoward) || defined(__CRT_HAVE___nextafter) || defined(__CRT_HAVE__nextafter) || defined(__CRT_HAVE___nexttoward) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(nextafterl)
#endif /* __CRT_HAVE_nextafterl || __CRT_HAVE_nexttowardl || __CRT_HAVE___nextafterl || __CRT_HAVE___nexttowardl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_nextafter || __CRT_HAVE_nexttoward || __CRT_HAVE___nextafter || __CRT_HAVE__nextafter || __CRT_HAVE___nexttoward || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_remainderl) || defined(__CRT_HAVE_dreml) || defined(__CRT_HAVE___remainderl) || defined(__CRT_HAVE___dreml) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_remainder) || defined(__CRT_HAVE_drem) || defined(__CRT_HAVE___remainder) || defined(__CRT_HAVE___drem) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(remainderl)
#endif /* __CRT_HAVE_remainderl || __CRT_HAVE_dreml || __CRT_HAVE___remainderl || __CRT_HAVE___dreml || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_remainder || __CRT_HAVE_drem || __CRT_HAVE___remainder || __CRT_HAVE___drem || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_ilogbl) || (defined(__CRT_HAVE_llogbl) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__CRT_HAVE___ilogbl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_ilogb) || (defined(__CRT_HAVE_llogb) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__CRT_HAVE___ilogb) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(ilogbl)
#endif /* __CRT_HAVE_ilogbl || (__CRT_HAVE_llogbl && __SIZEOF_INT__ == __SIZEOF_LONG__) || __CRT_HAVE___ilogbl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_ilogb || (__CRT_HAVE_llogb && __SIZEOF_INT__ == __SIZEOF_LONG__) || __CRT_HAVE___ilogb || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ */
#endif /* !__CXX_SYSTEM_HEADER */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_XOPEN_EXTENDED || __USE_ISOC99 */

#ifdef __USE_ISOC99
#ifndef __CXX_SYSTEM_HEADER
#if defined(__CRT_HAVE_nextafterl) || defined(__CRT_HAVE_nexttowardl) || defined(__CRT_HAVE___nextafterl) || defined(__CRT_HAVE___nexttowardl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_nextafter) || defined(__CRT_HAVE_nexttoward) || defined(__CRT_HAVE___nextafter) || defined(__CRT_HAVE__nextafter) || defined(__CRT_HAVE___nexttoward) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(nexttoward)
#endif /* __CRT_HAVE_nextafterl || __CRT_HAVE_nexttowardl || __CRT_HAVE___nextafterl || __CRT_HAVE___nexttowardl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_nextafter || __CRT_HAVE_nexttoward || __CRT_HAVE___nextafter || __CRT_HAVE__nextafter || __CRT_HAVE___nexttoward || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_scalbn) || defined(__CRT_HAVE___scalbn) || (defined(__CRT_HAVE_scalbln) && __SIZEOF_INT__ == __SIZEOF_LONG__) || (defined(__CRT_HAVE___scalbln) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(scalbn)
#endif /* __CRT_HAVE_scalbn || __CRT_HAVE___scalbn || (__CRT_HAVE_scalbln && __SIZEOF_INT__ == __SIZEOF_LONG__) || (__CRT_HAVE___scalbln && __SIZEOF_INT__ == __SIZEOF_LONG__) || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_scalbln) || defined(__CRT_HAVE___scalbln) || (defined(__CRT_HAVE_scalbn) && __SIZEOF_INT__ == __SIZEOF_LONG__) || (defined(__CRT_HAVE___scalbn) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(scalbln)
#endif /* __CRT_HAVE_scalbln || __CRT_HAVE___scalbln || (__CRT_HAVE_scalbn && __SIZEOF_INT__ == __SIZEOF_LONG__) || (__CRT_HAVE___scalbn && __SIZEOF_INT__ == __SIZEOF_LONG__) || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_nearbyint) || defined(__CRT_HAVE___nearbyint) || defined(__CRT_HAVE_rint) || defined(__CRT_HAVE___rint) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(nearbyint)
#endif /* __CRT_HAVE_nearbyint || __CRT_HAVE___nearbyint || __CRT_HAVE_rint || __CRT_HAVE___rint || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
__NAMESPACE_STD_USING(round)
__NAMESPACE_STD_USING(trunc)
#if defined(__CRT_HAVE_remquo) || defined(__CRT_HAVE___remquo) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(remquo)
#endif /* __CRT_HAVE_remquo || __CRT_HAVE___remquo || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
__NAMESPACE_STD_USING(lrint)
__NAMESPACE_STD_USING(lround)
__NAMESPACE_STD_USING(fdim)
__NAMESPACE_STD_USING(fmax)
__NAMESPACE_STD_USING(fmin)
__NAMESPACE_STD_USING(fma)
#endif /* !__CXX_SYSTEM_HEADER */
#ifdef __COMPILER_HAVE_LONGLONG
#ifndef __CXX_SYSTEM_HEADER
__NAMESPACE_STD_USING(llrint)
__NAMESPACE_STD_USING(llround)
#endif /* !__CXX_SYSTEM_HEADER */
#endif /* __COMPILER_HAVE_LONGLONG */
#ifndef __CXX_SYSTEM_HEADER
#if defined(__CRT_HAVE_nexttowardf) || defined(__CRT_HAVE___nexttowardf) || ((defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__)) && defined(__IEEE854_LONG_DOUBLE_TYPE__)) || defined(__CRT_HAVE_nextafterl) || defined(__CRT_HAVE_nexttowardl) || defined(__CRT_HAVE___nextafterl) || defined(__CRT_HAVE___nexttowardl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_nextafter) || defined(__CRT_HAVE_nexttoward) || defined(__CRT_HAVE___nextafter) || defined(__CRT_HAVE__nextafter) || defined(__CRT_HAVE___nexttoward) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(nexttowardf)
#endif /* __CRT_HAVE_nexttowardf || __CRT_HAVE___nexttowardf || ((__IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE754_DOUBLE_TYPE_IS_FLOAT__) && __IEEE854_LONG_DOUBLE_TYPE__) || __CRT_HAVE_nextafterl || __CRT_HAVE_nexttowardl || __CRT_HAVE___nextafterl || __CRT_HAVE___nexttowardl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_nextafter || __CRT_HAVE_nexttoward || __CRT_HAVE___nextafter || __CRT_HAVE__nextafter || __CRT_HAVE___nexttoward || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_scalbnf) || defined(__CRT_HAVE___scalbnf) || (defined(__CRT_HAVE_scalblnf) && __SIZEOF_INT__ == __SIZEOF_LONG__) || (defined(__CRT_HAVE___scalblnf) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_scalbn) || defined(__CRT_HAVE___scalbn) || (defined(__CRT_HAVE_scalbln) && __SIZEOF_INT__ == __SIZEOF_LONG__) || (defined(__CRT_HAVE___scalbln) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(scalbnf)
#endif /* __CRT_HAVE_scalbnf || __CRT_HAVE___scalbnf || (__CRT_HAVE_scalblnf && __SIZEOF_INT__ == __SIZEOF_LONG__) || (__CRT_HAVE___scalblnf && __SIZEOF_INT__ == __SIZEOF_LONG__) || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_scalbn || __CRT_HAVE___scalbn || (__CRT_HAVE_scalbln && __SIZEOF_INT__ == __SIZEOF_LONG__) || (__CRT_HAVE___scalbln && __SIZEOF_INT__ == __SIZEOF_LONG__) || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_scalblnf) || defined(__CRT_HAVE___scalblnf) || (defined(__CRT_HAVE_scalbnf) && __SIZEOF_INT__ == __SIZEOF_LONG__) || (defined(__CRT_HAVE___scalbnf) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_scalbln) || defined(__CRT_HAVE___scalbln) || (defined(__CRT_HAVE_scalbn) && __SIZEOF_INT__ == __SIZEOF_LONG__) || (defined(__CRT_HAVE___scalbn) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(scalblnf)
#endif /* __CRT_HAVE_scalblnf || __CRT_HAVE___scalblnf || (__CRT_HAVE_scalbnf && __SIZEOF_INT__ == __SIZEOF_LONG__) || (__CRT_HAVE___scalbnf && __SIZEOF_INT__ == __SIZEOF_LONG__) || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_scalbln || __CRT_HAVE___scalbln || (__CRT_HAVE_scalbn && __SIZEOF_INT__ == __SIZEOF_LONG__) || (__CRT_HAVE___scalbn && __SIZEOF_INT__ == __SIZEOF_LONG__) || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_nearbyintf) || defined(__CRT_HAVE___nearbyintf) || defined(__CRT_HAVE_rintf) || defined(__CRT_HAVE___rintf) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__)
__NAMESPACE_STD_USING(nearbyintf)
#endif /* __CRT_HAVE_nearbyintf || __CRT_HAVE___nearbyintf || __CRT_HAVE_rintf || __CRT_HAVE___rintf || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ */
__NAMESPACE_STD_USING(roundf)
__NAMESPACE_STD_USING(truncf)
#if defined(__CRT_HAVE_remquof) || defined(__CRT_HAVE___remquof) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_remquo) || defined(__CRT_HAVE___remquo) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(remquof)
#endif /* __CRT_HAVE_remquof || __CRT_HAVE___remquof || __IEEE754_DOUBLE_TYPE_IS_FLOAT__ || __IEEE754_FLOAT_TYPE_IS_FLOAT__ || __IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__ || __CRT_HAVE_remquo || __CRT_HAVE___remquo || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
__NAMESPACE_STD_USING(lrintf)
__NAMESPACE_STD_USING(lroundf)
__NAMESPACE_STD_USING(fdimf)
__NAMESPACE_STD_USING(fmaxf)
__NAMESPACE_STD_USING(fminf)
__NAMESPACE_STD_USING(fmaf)
#endif /* !__CXX_SYSTEM_HEADER */
#ifdef __COMPILER_HAVE_LONGLONG
#ifndef __CXX_SYSTEM_HEADER
__NAMESPACE_STD_USING(llrintf)
__NAMESPACE_STD_USING(llroundf)
#endif /* !__CXX_SYSTEM_HEADER */
#endif /* __COMPILER_HAVE_LONGLONG */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#ifndef __CXX_SYSTEM_HEADER
#if defined(__CRT_HAVE_nextafterl) || defined(__CRT_HAVE_nexttowardl) || defined(__CRT_HAVE___nextafterl) || defined(__CRT_HAVE___nexttowardl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_nextafter) || defined(__CRT_HAVE_nexttoward) || defined(__CRT_HAVE___nextafter) || defined(__CRT_HAVE__nextafter) || defined(__CRT_HAVE___nexttoward) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(nexttowardl)
#endif /* __CRT_HAVE_nextafterl || __CRT_HAVE_nexttowardl || __CRT_HAVE___nextafterl || __CRT_HAVE___nexttowardl || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_nextafter || __CRT_HAVE_nexttoward || __CRT_HAVE___nextafter || __CRT_HAVE__nextafter || __CRT_HAVE___nexttoward || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_scalbnl) || defined(__CRT_HAVE___scalbnl) || (defined(__CRT_HAVE_scalblnl) && __SIZEOF_INT__ == __SIZEOF_LONG__) || (defined(__CRT_HAVE___scalblnl) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_scalbn) || defined(__CRT_HAVE___scalbn) || (defined(__CRT_HAVE_scalbln) && __SIZEOF_INT__ == __SIZEOF_LONG__) || (defined(__CRT_HAVE___scalbln) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(scalbnl)
#endif /* __CRT_HAVE_scalbnl || __CRT_HAVE___scalbnl || (__CRT_HAVE_scalblnl && __SIZEOF_INT__ == __SIZEOF_LONG__) || (__CRT_HAVE___scalblnl && __SIZEOF_INT__ == __SIZEOF_LONG__) || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_scalbn || __CRT_HAVE___scalbn || (__CRT_HAVE_scalbln && __SIZEOF_INT__ == __SIZEOF_LONG__) || (__CRT_HAVE___scalbln && __SIZEOF_INT__ == __SIZEOF_LONG__) || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_scalblnl) || defined(__CRT_HAVE___scalblnl) || (defined(__CRT_HAVE_scalbnl) && __SIZEOF_INT__ == __SIZEOF_LONG__) || (defined(__CRT_HAVE___scalbnl) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_scalbln) || defined(__CRT_HAVE___scalbln) || (defined(__CRT_HAVE_scalbn) && __SIZEOF_INT__ == __SIZEOF_LONG__) || (defined(__CRT_HAVE___scalbn) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(scalblnl)
#endif /* __CRT_HAVE_scalblnl || __CRT_HAVE___scalblnl || (__CRT_HAVE_scalbnl && __SIZEOF_INT__ == __SIZEOF_LONG__) || (__CRT_HAVE___scalbnl && __SIZEOF_INT__ == __SIZEOF_LONG__) || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_scalbln || __CRT_HAVE___scalbln || (__CRT_HAVE_scalbn && __SIZEOF_INT__ == __SIZEOF_LONG__) || (__CRT_HAVE___scalbn && __SIZEOF_INT__ == __SIZEOF_LONG__) || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
#if defined(__CRT_HAVE_nearbyintl) || defined(__CRT_HAVE___nearbyintl) || defined(__CRT_HAVE_rintl) || defined(__CRT_HAVE___rintl) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__)
__NAMESPACE_STD_USING(nearbyintl)
#endif /* __CRT_HAVE_nearbyintl || __CRT_HAVE___nearbyintl || __CRT_HAVE_rintl || __CRT_HAVE___rintl || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ */
__NAMESPACE_STD_USING(roundl)
__NAMESPACE_STD_USING(truncl)
#if defined(__CRT_HAVE_remquol) || defined(__CRT_HAVE___remquol) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_remquo) || defined(__CRT_HAVE___remquo) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
__NAMESPACE_STD_USING(remquol)
#endif /* __CRT_HAVE_remquol || __CRT_HAVE___remquol || __IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__ || __CRT_HAVE_remquo || __CRT_HAVE___remquo || __IEEE754_DOUBLE_TYPE_IS_DOUBLE__ || __IEEE754_FLOAT_TYPE_IS_DOUBLE__ || __IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__ */
__NAMESPACE_STD_USING(lrintl)
__NAMESPACE_STD_USING(lroundl)
__NAMESPACE_STD_USING(fdiml)
__NAMESPACE_STD_USING(fmaxl)
__NAMESPACE_STD_USING(fminl)
__NAMESPACE_STD_USING(fmal)
#endif /* !__CXX_SYSTEM_HEADER */
#ifdef __COMPILER_HAVE_LONGLONG
#ifndef __CXX_SYSTEM_HEADER
__NAMESPACE_STD_USING(llrintl)
__NAMESPACE_STD_USING(llroundl)
#endif /* !__CXX_SYSTEM_HEADER */
#endif /* __COMPILER_HAVE_LONGLONG */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_ISOC99 */

#ifdef __USE_GNU
#if __has_builtin(__builtin_sincos) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_sincos)
/* >> sincosf(3), sincos(3), sincosl(3)
 * Calculate both sine (*psinx) and cosine (*pcosx) of `x' */
__CEIDECLARE(__DECL_SIMD_sincos __ATTR_OUT(2) __ATTR_OUT(3),void,__NOTHROW,sincos,(double __x, double *__psinx, double *__pcosx),{ __builtin_sincos(__x, __psinx, __pcosx); })
#elif defined(__CRT_HAVE_sincos)
/* >> sincosf(3), sincos(3), sincosl(3)
 * Calculate both sine (*psinx) and cosine (*pcosx) of `x' */
__CDECLARE_VOID(__DECL_SIMD_sincos __ATTR_OUT(2) __ATTR_OUT(3),__NOTHROW,sincos,(double __x, double *__psinx, double *__pcosx),(__x,__psinx,__pcosx))
#elif defined(__CRT_HAVE___sincos)
/* >> sincosf(3), sincos(3), sincosl(3)
 * Calculate both sine (*psinx) and cosine (*pcosx) of `x' */
__CREDIRECT_VOID(__DECL_SIMD_sincos __ATTR_OUT(2) __ATTR_OUT(3),__NOTHROW,sincos,(double __x, double *__psinx, double *__pcosx),__sincos,(__x,__psinx,__pcosx))
#elif ((defined(__CRT_HAVE_sin) || defined(__CRT_HAVE___sin)) && (defined(__CRT_HAVE_cos) || defined(__CRT_HAVE___cos))) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/sincos.h>
/* >> sincosf(3), sincos(3), sincosl(3)
 * Calculate both sine (*psinx) and cosine (*pcosx) of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(sincos, __FORCELOCAL __ATTR_ARTIFICIAL __DECL_SIMD_sincos __ATTR_OUT(2) __ATTR_OUT(3) void __NOTHROW(__LIBCCALL sincos)(double __x, double *__psinx, double *__pcosx) { (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(sincos))(__x, __psinx, __pcosx); })
#endif /* ... */
#if __has_builtin(__builtin_exp10) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_exp10)
/* >> exp10f(3), exp10(3), exp10l(3)
 * A function missing in all standards: compute exponent to base ten */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,exp10,(double __x),{ return __builtin_exp10(__x); })
#elif defined(__CRT_HAVE_exp10)
/* >> exp10f(3), exp10(3), exp10l(3)
 * A function missing in all standards: compute exponent to base ten */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,exp10,(double __x),(__x))
#elif defined(__CRT_HAVE___exp10)
/* >> exp10f(3), exp10(3), exp10l(3)
 * A function missing in all standards: compute exponent to base ten */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,exp10,(double __x),__exp10,(__x))
#elif defined(__CRT_HAVE_exp) || defined(__CRT_HAVE___exp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/exp10.h>
/* >> exp10f(3), exp10(3), exp10l(3)
 * A function missing in all standards: compute exponent to base ten */
__NAMESPACE_LOCAL_USING_OR_IMPL(exp10, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL exp10)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(exp10))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_pow10) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_pow10)
/* >> pow10f(3), pow10(3), pow10l(3)
 * Another  name  occasionally  used */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,pow10,(double __x),{ return __builtin_pow10(__x); })
#elif defined(__CRT_HAVE_pow10)
/* >> pow10f(3), pow10(3), pow10l(3)
 * Another  name  occasionally  used */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,pow10,(double __x),(__x))
#elif defined(__CRT_HAVE___pow10)
/* >> pow10f(3), pow10(3), pow10l(3)
 * Another  name  occasionally  used */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,pow10,(double __x),__pow10,(__x))
#elif defined(__CRT_HAVE_pow) || defined(__CRT_HAVE___pow) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/pow10.h>
/* >> pow10f(3), pow10(3), pow10l(3)
 * Another  name  occasionally  used */
__NAMESPACE_LOCAL_USING_OR_IMPL(pow10, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL pow10)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(pow10))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_sincosf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_sincosf)
/* >> sincosf(3), sincos(3), sincosl(3)
 * Calculate both sine (*psinx) and cosine (*pcosx) of `x' */
__CEIDECLARE(__DECL_SIMD_sincosf __ATTR_OUT(2) __ATTR_OUT(3),void,__NOTHROW,sincosf,(float __x, float *__psinx, float *__pcosx),{ __builtin_sincosf(__x, __psinx, __pcosx); })
#elif defined(__CRT_HAVE_sincosf)
/* >> sincosf(3), sincos(3), sincosl(3)
 * Calculate both sine (*psinx) and cosine (*pcosx) of `x' */
__CDECLARE_VOID(__DECL_SIMD_sincosf __ATTR_OUT(2) __ATTR_OUT(3),__NOTHROW,sincosf,(float __x, float *__psinx, float *__pcosx),(__x,__psinx,__pcosx))
#elif defined(__CRT_HAVE___sincosf)
/* >> sincosf(3), sincos(3), sincosl(3)
 * Calculate both sine (*psinx) and cosine (*pcosx) of `x' */
__CREDIRECT_VOID(__DECL_SIMD_sincosf __ATTR_OUT(2) __ATTR_OUT(3),__NOTHROW,sincosf,(float __x, float *__psinx, float *__pcosx),__sincosf,(__x,__psinx,__pcosx))
#elif defined(__CRT_HAVE_sincos) || defined(__CRT_HAVE___sincos) || ((defined(__CRT_HAVE_sin) || defined(__CRT_HAVE___sin)) && (defined(__CRT_HAVE_cos) || defined(__CRT_HAVE___cos))) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__) || ((defined(__CRT_HAVE_sinf) || defined(__CRT_HAVE___sinf) || defined(__CRT_HAVE_sin) || defined(__CRT_HAVE___sin)) && (defined(__CRT_HAVE_cosf) || defined(__CRT_HAVE___cosf) || defined(__CRT_HAVE_cos) || defined(__CRT_HAVE___cos))) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__)
#include <libc/local/math/sincosf.h>
/* >> sincosf(3), sincos(3), sincosl(3)
 * Calculate both sine (*psinx) and cosine (*pcosx) of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(sincosf, __FORCELOCAL __ATTR_ARTIFICIAL __DECL_SIMD_sincosf __ATTR_OUT(2) __ATTR_OUT(3) void __NOTHROW(__LIBCCALL sincosf)(float __x, float *__psinx, float *__pcosx) { (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(sincosf))(__x, __psinx, __pcosx); })
#endif /* ... */
#if __has_builtin(__builtin_exp10f) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_exp10f)
/* >> exp10f(3), exp10(3), exp10l(3)
 * A function missing in all standards: compute exponent to base ten */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,exp10f,(float __x),{ return __builtin_exp10f(__x); })
#elif defined(__CRT_HAVE_exp10f)
/* >> exp10f(3), exp10(3), exp10l(3)
 * A function missing in all standards: compute exponent to base ten */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,exp10f,(float __x),(__x))
#elif defined(__CRT_HAVE___exp10f)
/* >> exp10f(3), exp10(3), exp10l(3)
 * A function missing in all standards: compute exponent to base ten */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,exp10f,(float __x),__exp10f,(__x))
#elif defined(__CRT_HAVE_exp) || defined(__CRT_HAVE___exp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/exp10f.h>
/* >> exp10f(3), exp10(3), exp10l(3)
 * A function missing in all standards: compute exponent to base ten */
__NAMESPACE_LOCAL_USING_OR_IMPL(exp10f, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL exp10f)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(exp10f))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_pow10f) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_pow10f)
/* >> pow10f(3), pow10(3), pow10l(3)
 * Another  name  occasionally  used */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,pow10f,(float __x),{ return __builtin_pow10f(__x); })
#elif defined(__CRT_HAVE_pow10f)
/* >> pow10f(3), pow10(3), pow10l(3)
 * Another  name  occasionally  used */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,pow10f,(float __x),(__x))
#elif defined(__CRT_HAVE___pow10f)
/* >> pow10f(3), pow10(3), pow10l(3)
 * Another  name  occasionally  used */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,pow10f,(float __x),__pow10f,(__x))
#elif defined(__CRT_HAVE_powf) || defined(__CRT_HAVE___powf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_pow10) || defined(__CRT_HAVE___pow10) || defined(__CRT_HAVE_pow) || defined(__CRT_HAVE___pow) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/pow10f.h>
/* >> pow10f(3), pow10(3), pow10l(3)
 * Another  name  occasionally  used */
__NAMESPACE_LOCAL_USING_OR_IMPL(pow10f, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL pow10f)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(pow10f))(__x); })
#endif /* ... */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if __has_builtin(__builtin_sincosl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_sincosl)
/* >> sincosf(3), sincos(3), sincosl(3)
 * Calculate both sine (*psinx) and cosine (*pcosx) of `x' */
__CEIDECLARE(__DECL_SIMD_sincosl __ATTR_OUT(2) __ATTR_OUT(3),void,__NOTHROW,sincosl,(__LONGDOUBLE __x, __LONGDOUBLE *__psinx, __LONGDOUBLE *__pcosx),{ __builtin_sincosl(__x, __psinx, __pcosx); })
#elif defined(__CRT_HAVE_sincosl)
/* >> sincosf(3), sincos(3), sincosl(3)
 * Calculate both sine (*psinx) and cosine (*pcosx) of `x' */
__CDECLARE_VOID(__DECL_SIMD_sincosl __ATTR_OUT(2) __ATTR_OUT(3),__NOTHROW,sincosl,(__LONGDOUBLE __x, __LONGDOUBLE *__psinx, __LONGDOUBLE *__pcosx),(__x,__psinx,__pcosx))
#elif defined(__CRT_HAVE___sincosl)
/* >> sincosf(3), sincos(3), sincosl(3)
 * Calculate both sine (*psinx) and cosine (*pcosx) of `x' */
__CREDIRECT_VOID(__DECL_SIMD_sincosl __ATTR_OUT(2) __ATTR_OUT(3),__NOTHROW,sincosl,(__LONGDOUBLE __x, __LONGDOUBLE *__psinx, __LONGDOUBLE *__pcosx),__sincosl,(__x,__psinx,__pcosx))
#elif defined(__CRT_HAVE___sincos) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> sincosf(3), sincos(3), sincosl(3)
 * Calculate both sine (*psinx) and cosine (*pcosx) of `x' */
__CREDIRECT_VOID(__DECL_SIMD_sincosl __ATTR_OUT(2) __ATTR_OUT(3),__NOTHROW,sincosl,(__LONGDOUBLE __x, __LONGDOUBLE *__psinx, __LONGDOUBLE *__pcosx),__sincos,(__x,__psinx,__pcosx))
#elif defined(__CRT_HAVE_sincos) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> sincosf(3), sincos(3), sincosl(3)
 * Calculate both sine (*psinx) and cosine (*pcosx) of `x' */
__CREDIRECT_VOID(__DECL_SIMD_sincosl __ATTR_OUT(2) __ATTR_OUT(3),__NOTHROW,sincosl,(__LONGDOUBLE __x, __LONGDOUBLE *__psinx, __LONGDOUBLE *__pcosx),sincos,(__x,__psinx,__pcosx))
#elif defined(__CRT_HAVE_sincos) || defined(__CRT_HAVE___sincos) || ((defined(__CRT_HAVE_sin) || defined(__CRT_HAVE___sin)) && (defined(__CRT_HAVE_cos) || defined(__CRT_HAVE___cos))) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__) || ((defined(__CRT_HAVE_sinl) || defined(__CRT_HAVE___sinl) || defined(__CRT_HAVE_sin) || defined(__CRT_HAVE___sin)) && (defined(__CRT_HAVE_cosl) || defined(__CRT_HAVE___cosl) || defined(__CRT_HAVE_cos) || defined(__CRT_HAVE___cos))) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__)
#include <libc/local/math/sincosl.h>
/* >> sincosf(3), sincos(3), sincosl(3)
 * Calculate both sine (*psinx) and cosine (*pcosx) of `x' */
__NAMESPACE_LOCAL_USING_OR_IMPL(sincosl, __FORCELOCAL __ATTR_ARTIFICIAL __DECL_SIMD_sincosl __ATTR_OUT(2) __ATTR_OUT(3) void __NOTHROW(__LIBCCALL sincosl)(__LONGDOUBLE __x, __LONGDOUBLE *__psinx, __LONGDOUBLE *__pcosx) { (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(sincosl))(__x, __psinx, __pcosx); })
#endif /* ... */
#if __has_builtin(__builtin_exp10l) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_exp10l)
/* >> exp10f(3), exp10(3), exp10l(3)
 * A function missing in all standards: compute exponent to base ten */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,exp10l,(__LONGDOUBLE __x),{ return __builtin_exp10l(__x); })
#elif defined(__CRT_HAVE_exp10l)
/* >> exp10f(3), exp10(3), exp10l(3)
 * A function missing in all standards: compute exponent to base ten */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,exp10l,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___exp10l)
/* >> exp10f(3), exp10(3), exp10l(3)
 * A function missing in all standards: compute exponent to base ten */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,exp10l,(__LONGDOUBLE __x),__exp10l,(__x))
#elif defined(__CRT_HAVE_expl) || defined(__CRT_HAVE___expl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_exp) || defined(__CRT_HAVE___exp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/exp10l.h>
/* >> exp10f(3), exp10(3), exp10l(3)
 * A function missing in all standards: compute exponent to base ten */
__NAMESPACE_LOCAL_USING_OR_IMPL(exp10l, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL exp10l)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(exp10l))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_pow10l) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_pow10l)
/* >> pow10f(3), pow10(3), pow10l(3)
 * Another  name  occasionally  used */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,pow10l,(__LONGDOUBLE __x),{ return __builtin_pow10l(__x); })
#elif defined(__CRT_HAVE_pow10l)
/* >> pow10f(3), pow10(3), pow10l(3)
 * Another  name  occasionally  used */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,pow10l,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___pow10l)
/* >> pow10f(3), pow10(3), pow10l(3)
 * Another  name  occasionally  used */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,pow10l,(__LONGDOUBLE __x),__pow10l,(__x))
#elif defined(__CRT_HAVE_pow10) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> pow10f(3), pow10(3), pow10l(3)
 * Another  name  occasionally  used */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,pow10l,(__LONGDOUBLE __x),pow10,(__x))
#elif defined(__CRT_HAVE___pow10) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> pow10f(3), pow10(3), pow10l(3)
 * Another  name  occasionally  used */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,pow10l,(__LONGDOUBLE __x),__pow10,(__x))
#elif defined(__CRT_HAVE_powl) || defined(__CRT_HAVE___powl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_pow10) || defined(__CRT_HAVE___pow10) || defined(__CRT_HAVE_pow) || defined(__CRT_HAVE___pow) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/pow10l.h>
/* >> pow10f(3), pow10(3), pow10l(3)
 * Another  name  occasionally  used */
__NAMESPACE_LOCAL_USING_OR_IMPL(pow10l, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL pow10l)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(pow10l))(__x); })
#endif /* ... */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_GNU */

#ifdef __USE_MISC
#if !defined(__cplusplus) || !defined(__CORRECT_ISO_CPP11_MATH_H_PROTO_FP) /* isinf conflicts with C++11. */
#if __has_builtin(__builtin_isinf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_isinf)
/* >> isinff(3), isinf(3), isinfl(3)
 * Return 0 if `value' is finite or NaN, +1 if it is +Infinity, -1 if it is -Infinity */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,isinf,(double __x),{ return __builtin_isinf(__x); })
#elif defined(__CRT_HAVE_isinf)
/* >> isinff(3), isinf(3), isinfl(3)
 * Return 0 if `value' is finite or NaN, +1 if it is +Infinity, -1 if it is -Infinity */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,isinf,(double __x),(__x))
#elif defined(__CRT_HAVE___isinf)
/* >> isinff(3), isinf(3), isinfl(3)
 * Return 0 if `value' is finite or NaN, +1 if it is +Infinity, -1 if it is -Infinity */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,isinf,(double __x),__isinf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__) || defined(__INFINITY) || defined(__HUGE_VAL)
#include <libc/local/math/isinf.h>
/* >> isinff(3), isinf(3), isinfl(3)
 * Return 0 if `value' is finite or NaN, +1 if it is +Infinity, -1 if it is -Infinity */
__NAMESPACE_LOCAL_USING_OR_IMPL(isinf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED int __NOTHROW(__LIBCCALL isinf)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(isinf))(__x); })
#endif /* ... */
#endif /* !__cplusplus || !__CORRECT_ISO_CPP11_MATH_H_PROTO_FP */
#if __has_builtin(__builtin_isinff) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_isinff)
/* >> isinff(3), isinf(3), isinfl(3)
 * Return 0 if `value' is finite or NaN, +1 if it is +Infinity, -1 if it is -Infinity */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,isinff,(float __x),{ return __builtin_isinff(__x); })
#elif defined(__CRT_HAVE_isinff)
/* >> isinff(3), isinf(3), isinfl(3)
 * Return 0 if `value' is finite or NaN, +1 if it is +Infinity, -1 if it is -Infinity */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,isinff,(float __x),(__x))
#elif defined(__CRT_HAVE___isinff)
/* >> isinff(3), isinf(3), isinfl(3)
 * Return 0 if `value' is finite or NaN, +1 if it is +Infinity, -1 if it is -Infinity */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,isinff,(float __x),__isinff,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__INFINITYF) || defined(__HUGE_VALF) || defined(__CRT_HAVE_isinf) || defined(__CRT_HAVE___isinf) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__) || defined(__INFINITY) || defined(__HUGE_VAL)
#include <libc/local/math/isinff.h>
/* >> isinff(3), isinf(3), isinfl(3)
 * Return 0 if `value' is finite or NaN, +1 if it is +Infinity, -1 if it is -Infinity */
__NAMESPACE_LOCAL_USING_OR_IMPL(isinff, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED int __NOTHROW(__LIBCCALL isinff)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(isinff))(__x); })
#endif /* ... */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if __has_builtin(__builtin_isinfl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_isinfl)
/* >> isinff(3), isinf(3), isinfl(3)
 * Return 0 if `value' is finite or NaN, +1 if it is +Infinity, -1 if it is -Infinity */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,isinfl,(__LONGDOUBLE __x),{ return __builtin_isinfl(__x); })
#elif defined(__CRT_HAVE_isinfl)
/* >> isinff(3), isinf(3), isinfl(3)
 * Return 0 if `value' is finite or NaN, +1 if it is +Infinity, -1 if it is -Infinity */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,isinfl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___isinfl)
/* >> isinff(3), isinf(3), isinfl(3)
 * Return 0 if `value' is finite or NaN, +1 if it is +Infinity, -1 if it is -Infinity */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,isinfl,(__LONGDOUBLE __x),__isinfl,(__x))
#elif defined(__CRT_HAVE_isinf) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> isinff(3), isinf(3), isinfl(3)
 * Return 0 if `value' is finite or NaN, +1 if it is +Infinity, -1 if it is -Infinity */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,isinfl,(__LONGDOUBLE __x),isinf,(__x))
#elif defined(__CRT_HAVE___isinf) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> isinff(3), isinf(3), isinfl(3)
 * Return 0 if `value' is finite or NaN, +1 if it is +Infinity, -1 if it is -Infinity */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,isinfl,(__LONGDOUBLE __x),__isinf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__INFINITYL) || defined(__HUGE_VALL) || defined(__CRT_HAVE_isinf) || defined(__CRT_HAVE___isinf) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__) || defined(__INFINITY) || defined(__HUGE_VAL)
#include <libc/local/math/isinfl.h>
/* >> isinff(3), isinf(3), isinfl(3)
 * Return 0 if `value' is finite or NaN, +1 if it is +Infinity, -1 if it is -Infinity */
__NAMESPACE_LOCAL_USING_OR_IMPL(isinfl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED int __NOTHROW(__LIBCCALL isinfl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(isinfl))(__x); })
#endif /* ... */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#if __has_builtin(__builtin_finite) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_finite)
/* >> finitef(3), finite(3), finitel(3)
 * Return nonzero if `value' is finite and not NaN */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,finite,(double __x),{ return __builtin_finite(__x); })
#elif defined(__CRT_HAVE_finite)
/* >> finitef(3), finite(3), finitel(3)
 * Return nonzero if `value' is finite and not NaN */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,finite,(double __x),(__x))
#elif defined(__CRT_HAVE___finite)
/* >> finitef(3), finite(3), finitel(3)
 * Return nonzero if `value' is finite and not NaN */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,finite,(double __x),__finite,(__x))
#elif defined(__CRT_HAVE__finite)
/* >> finitef(3), finite(3), finitel(3)
 * Return nonzero if `value' is finite and not NaN */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,finite,(double __x),_finite,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__) || ((defined(__CRT_HAVE_isinf) || defined(__CRT_HAVE___isinf) || defined(__INFINITY) || defined(__HUGE_VAL)) && (defined(__CRT_HAVE_isnan) || defined(__CRT_HAVE__isnan) || defined(__CRT_HAVE___isnan)))
#include <libc/local/math/finite.h>
/* >> finitef(3), finite(3), finitel(3)
 * Return nonzero if `value' is finite and not NaN */
__NAMESPACE_LOCAL_USING_OR_IMPL(finite, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED int __NOTHROW(__LIBCCALL finite)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(finite))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_remainder) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_remainder)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CEIREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,drem,(double __x, double __p),remainder,{ return __builtin_remainder(__x, __p); })
#elif __has_builtin(__builtin_drem) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_drem)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,drem,(double __x, double __p),{ return __builtin_drem(__x, __p); })
#elif defined(__CRT_HAVE_remainder)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,drem,(double __x, double __p),remainder,(__x,__p))
#elif defined(__CRT_HAVE_drem)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,drem,(double __x, double __p),(__x,__p))
#elif defined(__CRT_HAVE___remainder)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,drem,(double __x, double __p),__remainder,(__x,__p))
#elif defined(__CRT_HAVE___drem)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,drem,(double __x, double __p),__drem,(__x,__p))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/remainder.h>
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL drem)(double __x, double __p) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(remainder))(__x, __p); }
#endif /* ... */
#if __has_builtin(__builtin_significand) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_significand)
/* >> significandf(3), significand(3), significandl(3)
 * Return the fractional part of `x' after dividing out `ilogb(x)' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,significand,(double __x),{ return __builtin_significand(__x); })
#elif defined(__CRT_HAVE_significand)
/* >> significandf(3), significand(3), significandl(3)
 * Return the fractional part of `x' after dividing out `ilogb(x)' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,significand,(double __x),(__x))
#elif defined(__CRT_HAVE___significand)
/* >> significandf(3), significand(3), significandl(3)
 * Return the fractional part of `x' after dividing out `ilogb(x)' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,significand,(double __x),__significand,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/significand.h>
/* >> significandf(3), significand(3), significandl(3)
 * Return the fractional part of `x' after dividing out `ilogb(x)' */
__NAMESPACE_LOCAL_USING_OR_IMPL(significand, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL significand)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(significand))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_finitef) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_finitef)
/* >> finitef(3), finite(3), finitel(3)
 * Return nonzero if `value' is finite and not NaN */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,finitef,(float __x),{ return __builtin_finitef(__x); })
#elif defined(__CRT_HAVE_finitef)
/* >> finitef(3), finite(3), finitel(3)
 * Return nonzero if `value' is finite and not NaN */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,finitef,(float __x),(__x))
#elif defined(__CRT_HAVE___finitef)
/* >> finitef(3), finite(3), finitel(3)
 * Return nonzero if `value' is finite and not NaN */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,finitef,(float __x),__finitef,(__x))
#elif defined(__CRT_HAVE__finitef)
/* >> finitef(3), finite(3), finitel(3)
 * Return nonzero if `value' is finite and not NaN */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,finitef,(float __x),_finitef,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || ((defined(__CRT_HAVE_isinff) || defined(__CRT_HAVE___isinff) || defined(__INFINITYF) || defined(__HUGE_VALF) || defined(__CRT_HAVE_isinf) || defined(__CRT_HAVE___isinf) || defined(__INFINITY) || defined(__HUGE_VAL)) && (defined(__CRT_HAVE_isnanf) || defined(__CRT_HAVE___isnanf) || defined(__CRT_HAVE__isnanf) || defined(__CRT_HAVE_isnan) || defined(__CRT_HAVE__isnan) || defined(__CRT_HAVE___isnan))) || defined(__CRT_HAVE_finite) || defined(__CRT_HAVE___finite) || defined(__CRT_HAVE__finite) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__) || ((defined(__CRT_HAVE_isinf) || defined(__CRT_HAVE___isinf) || defined(__INFINITY) || defined(__HUGE_VAL)) && (defined(__CRT_HAVE_isnan) || defined(__CRT_HAVE__isnan) || defined(__CRT_HAVE___isnan)))
#include <libc/local/math/finitef.h>
/* >> finitef(3), finite(3), finitel(3)
 * Return nonzero if `value' is finite and not NaN */
__NAMESPACE_LOCAL_USING_OR_IMPL(finitef, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED int __NOTHROW(__LIBCCALL finitef)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(finitef))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_remainderf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_remainderf)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,dremf,(float __x, float __p),remainderf,{ return __builtin_remainderf(__x, __p); })
#elif __has_builtin(__builtin_dremf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_dremf)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,dremf,(float __x, float __p),{ return __builtin_dremf(__x, __p); })
#elif defined(__CRT_HAVE_remainderf)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,dremf,(float __x, float __p),remainderf,(__x,__p))
#elif defined(__CRT_HAVE_dremf)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,dremf,(float __x, float __p),(__x,__p))
#elif defined(__CRT_HAVE___remainderf)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,dremf,(float __x, float __p),__remainderf,(__x,__p))
#elif defined(__CRT_HAVE___dremf)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,dremf,(float __x, float __p),__dremf,(__x,__p))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_remainder) || defined(__CRT_HAVE_drem) || defined(__CRT_HAVE___remainder) || defined(__CRT_HAVE___drem) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/remainderf.h>
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL dremf)(float __x, float __p) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(remainderf))(__x, __p); }
#endif /* ... */
#if __has_builtin(__builtin_significandf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_significandf)
/* >> significandf(3), significand(3), significandl(3)
 * Return the fractional part of `x' after dividing out `ilogb(x)' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,significandf,(float __x),{ return __builtin_significandf(__x); })
#elif defined(__CRT_HAVE_significandf)
/* >> significandf(3), significand(3), significandl(3)
 * Return the fractional part of `x' after dividing out `ilogb(x)' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,significandf,(float __x),(__x))
#elif defined(__CRT_HAVE___significandf)
/* >> significandf(3), significand(3), significandl(3)
 * Return the fractional part of `x' after dividing out `ilogb(x)' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,significandf,(float __x),__significandf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_significand) || defined(__CRT_HAVE___significand) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/significandf.h>
/* >> significandf(3), significand(3), significandl(3)
 * Return the fractional part of `x' after dividing out `ilogb(x)' */
__NAMESPACE_LOCAL_USING_OR_IMPL(significandf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL significandf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(significandf))(__x); })
#endif /* ... */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if __has_builtin(__builtin_finitel) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_finitel)
/* >> finitef(3), finite(3), finitel(3)
 * Return nonzero if `value' is finite and not NaN */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,finitel,(__LONGDOUBLE __x),{ return __builtin_finitel(__x); })
#elif defined(__CRT_HAVE_finitel)
/* >> finitef(3), finite(3), finitel(3)
 * Return nonzero if `value' is finite and not NaN */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,finitel,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___finitel)
/* >> finitef(3), finite(3), finitel(3)
 * Return nonzero if `value' is finite and not NaN */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,finitel,(__LONGDOUBLE __x),__finitel,(__x))
#elif defined(__CRT_HAVE_finite) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> finitef(3), finite(3), finitel(3)
 * Return nonzero if `value' is finite and not NaN */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,finitel,(__LONGDOUBLE __x),finite,(__x))
#elif defined(__CRT_HAVE___finite) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> finitef(3), finite(3), finitel(3)
 * Return nonzero if `value' is finite and not NaN */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,finitel,(__LONGDOUBLE __x),__finite,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || ((defined(__CRT_HAVE_isinfl) || defined(__CRT_HAVE___isinfl) || defined(__INFINITYL) || defined(__HUGE_VALL) || defined(__CRT_HAVE_isinf) || defined(__CRT_HAVE___isinf) || defined(__INFINITY) || defined(__HUGE_VAL)) && (defined(__CRT_HAVE_isnanl) || defined(__CRT_HAVE___isnanl) || defined(__CRT_HAVE_isnan) || defined(__CRT_HAVE__isnan) || defined(__CRT_HAVE___isnan))) || defined(__CRT_HAVE_finite) || defined(__CRT_HAVE___finite) || defined(__CRT_HAVE__finite) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__) || ((defined(__CRT_HAVE_isinf) || defined(__CRT_HAVE___isinf) || defined(__INFINITY) || defined(__HUGE_VAL)) && (defined(__CRT_HAVE_isnan) || defined(__CRT_HAVE__isnan) || defined(__CRT_HAVE___isnan)))
#include <libc/local/math/finitel.h>
/* >> finitef(3), finite(3), finitel(3)
 * Return nonzero if `value' is finite and not NaN */
__NAMESPACE_LOCAL_USING_OR_IMPL(finitel, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED int __NOTHROW(__LIBCCALL finitel)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(finitel))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_remainderl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_remainderl)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,dreml,(__LONGDOUBLE __x, __LONGDOUBLE __p),remainderl,{ return __builtin_remainderl(__x, __p); })
#elif __has_builtin(__builtin_dreml) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_dreml)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,dreml,(__LONGDOUBLE __x, __LONGDOUBLE __p),{ return __builtin_dreml(__x, __p); })
#elif defined(__CRT_HAVE_remainderl)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,dreml,(__LONGDOUBLE __x, __LONGDOUBLE __p),remainderl,(__x,__p))
#elif defined(__CRT_HAVE_dreml)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,dreml,(__LONGDOUBLE __x, __LONGDOUBLE __p),(__x,__p))
#elif defined(__CRT_HAVE___remainderl)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,dreml,(__LONGDOUBLE __x, __LONGDOUBLE __p),__remainderl,(__x,__p))
#elif defined(__CRT_HAVE___dreml)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,dreml,(__LONGDOUBLE __x, __LONGDOUBLE __p),__dreml,(__x,__p))
#elif defined(__CRT_HAVE_remainder) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,dreml,(__LONGDOUBLE __x, __LONGDOUBLE __p),remainder,(__x,__p))
#elif defined(__CRT_HAVE_drem) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,dreml,(__LONGDOUBLE __x, __LONGDOUBLE __p),drem,(__x,__p))
#elif defined(__CRT_HAVE___remainder) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,dreml,(__LONGDOUBLE __x, __LONGDOUBLE __p),__remainder,(__x,__p))
#elif defined(__CRT_HAVE___drem) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,dreml,(__LONGDOUBLE __x, __LONGDOUBLE __p),__drem,(__x,__p))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_remainder) || defined(__CRT_HAVE_drem) || defined(__CRT_HAVE___remainder) || defined(__CRT_HAVE___drem) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/remainderl.h>
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL dreml)(__LONGDOUBLE __x, __LONGDOUBLE __p) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(remainderl))(__x, __p); }
#endif /* ... */
#if __has_builtin(__builtin_significandl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_significandl)
/* >> significandf(3), significand(3), significandl(3)
 * Return the fractional part of `x' after dividing out `ilogb(x)' */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,significandl,(__LONGDOUBLE __x),{ return __builtin_significandl(__x); })
#elif defined(__CRT_HAVE_significandl)
/* >> significandf(3), significand(3), significandl(3)
 * Return the fractional part of `x' after dividing out `ilogb(x)' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,significandl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___significandl)
/* >> significandf(3), significand(3), significandl(3)
 * Return the fractional part of `x' after dividing out `ilogb(x)' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,significandl,(__LONGDOUBLE __x),__significandl,(__x))
#elif defined(__CRT_HAVE_significand) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> significandf(3), significand(3), significandl(3)
 * Return the fractional part of `x' after dividing out `ilogb(x)' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,significandl,(__LONGDOUBLE __x),significand,(__x))
#elif defined(__CRT_HAVE___significand) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> significandf(3), significand(3), significandl(3)
 * Return the fractional part of `x' after dividing out `ilogb(x)' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,significandl,(__LONGDOUBLE __x),__significand,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_significand) || defined(__CRT_HAVE___significand) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/significandl.h>
/* >> significandf(3), significand(3), significandl(3)
 * Return the fractional part of `x' after dividing out `ilogb(x)' */
__NAMESPACE_LOCAL_USING_OR_IMPL(significandl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL significandl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(significandl))(__x); })
#endif /* ... */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_MISC */

#if defined(__USE_MISC) || (defined(__USE_XOPEN) && !defined(__USE_XOPEN2K))
#if !defined(__cplusplus) || !defined(__CORRECT_ISO_CPP11_MATH_H_PROTO_FP) /* isnan conflicts with C++11. */
#if __has_builtin(__builtin_isnan) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_isnan)
/* >> isnanf(3), isnan(3), isnanl(3)
 * Return nonzero if `value' is not a number */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,isnan,(double __x),{ return __builtin_isnan(__x); })
#elif defined(__CRT_HAVE_isnan)
/* >> isnanf(3), isnan(3), isnanl(3)
 * Return nonzero if `value' is not a number */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,isnan,(double __x),(__x))
#elif defined(__CRT_HAVE__isnan)
/* >> isnanf(3), isnan(3), isnanl(3)
 * Return nonzero if `value' is not a number */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,isnan,(double __x),_isnan,(__x))
#elif defined(__CRT_HAVE___isnan)
/* >> isnanf(3), isnan(3), isnanl(3)
 * Return nonzero if `value' is not a number */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,isnan,(double __x),__isnan,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/isnan.h>
/* >> isnanf(3), isnan(3), isnanl(3)
 * Return nonzero if `value' is not a number */
__NAMESPACE_LOCAL_USING_OR_IMPL(isnan, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED int __NOTHROW(__LIBCCALL isnan)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(isnan))(__x); })
#endif /* ... */
#endif /* !cplusplus || !__CORRECT_ISO_CPP11_MATH_H_PROTO_FP */
#if __has_builtin(__builtin_isnanf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_isnanf)
/* >> isnanf(3), isnan(3), isnanl(3)
 * Return nonzero if `value' is not a number */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,isnanf,(float __x),{ return __builtin_isnanf(__x); })
#elif defined(__CRT_HAVE_isnanf)
/* >> isnanf(3), isnan(3), isnanl(3)
 * Return nonzero if `value' is not a number */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,isnanf,(float __x),(__x))
#elif defined(__CRT_HAVE___isnanf)
/* >> isnanf(3), isnan(3), isnanl(3)
 * Return nonzero if `value' is not a number */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,isnanf,(float __x),__isnanf,(__x))
#elif defined(__CRT_HAVE__isnanf)
/* >> isnanf(3), isnan(3), isnanl(3)
 * Return nonzero if `value' is not a number */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,isnanf,(float __x),_isnanf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_isnan) || defined(__CRT_HAVE__isnan) || defined(__CRT_HAVE___isnan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/isnanf.h>
/* >> isnanf(3), isnan(3), isnanl(3)
 * Return nonzero if `value' is not a number */
__NAMESPACE_LOCAL_USING_OR_IMPL(isnanf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED int __NOTHROW(__LIBCCALL isnanf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(isnanf))(__x); })
#endif /* ... */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if __has_builtin(__builtin_isnanl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_isnanl)
/* >> isnanf(3), isnan(3), isnanl(3)
 * Return nonzero if `value' is not a number */
__CEIDECLARE(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,isnanl,(__LONGDOUBLE __x),{ return __builtin_isnanl(__x); })
#elif defined(__CRT_HAVE_isnanl)
/* >> isnanf(3), isnan(3), isnanl(3)
 * Return nonzero if `value' is not a number */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,isnanl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___isnanl)
/* >> isnanf(3), isnan(3), isnanl(3)
 * Return nonzero if `value' is not a number */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,isnanl,(__LONGDOUBLE __x),__isnanl,(__x))
#elif defined(__CRT_HAVE_isnan) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> isnanf(3), isnan(3), isnanl(3)
 * Return nonzero if `value' is not a number */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,isnanl,(__LONGDOUBLE __x),isnan,(__x))
#elif defined(__CRT_HAVE___isnan) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> isnanf(3), isnan(3), isnanl(3)
 * Return nonzero if `value' is not a number */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,int,__NOTHROW,isnanl,(__LONGDOUBLE __x),__isnan,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_isnan) || defined(__CRT_HAVE__isnan) || defined(__CRT_HAVE___isnan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/isnanl.h>
/* >> isnanf(3), isnan(3), isnanl(3)
 * Return nonzero if `value' is not a number */
__NAMESPACE_LOCAL_USING_OR_IMPL(isnanl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED int __NOTHROW(__LIBCCALL isnanl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(isnanl))(__x); })
#endif /* ... */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_MISC || (__USE_XOPEN && !__USE_XOPEN2K) */

/* Bessel functions. */
#if defined(__USE_MISC) || defined(__USE_XOPEN)
#if __has_builtin(__builtin_j0) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_j0)
/* >> j0f(3), j0(3), j0l(3) */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,j0,(double __x),{ return __builtin_j0(__x); })
#elif defined(__CRT_HAVE_j0)
/* >> j0f(3), j0(3), j0l(3) */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,j0,(double __x),(__x))
#elif defined(__CRT_HAVE__j0)
/* >> j0f(3), j0(3), j0l(3) */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,j0,(double __x),_j0,(__x))
#elif defined(__CRT_HAVE___j0)
/* >> j0f(3), j0(3), j0l(3) */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,j0,(double __x),__j0,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/j0.h>
/* >> j0f(3), j0(3), j0l(3) */
__NAMESPACE_LOCAL_USING_OR_IMPL(j0, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL j0)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(j0))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_j1) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_j1)
/* >> j1f(3), j1(3), j1l(3) */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,j1,(double __x),{ return __builtin_j1(__x); })
#elif defined(__CRT_HAVE_j1)
/* >> j1f(3), j1(3), j1l(3) */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,j1,(double __x),(__x))
#elif defined(__CRT_HAVE__j1)
/* >> j1f(3), j1(3), j1l(3) */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,j1,(double __x),_j1,(__x))
#elif defined(__CRT_HAVE___j1)
/* >> j1f(3), j1(3), j1l(3) */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,j1,(double __x),__j1,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/j1.h>
/* >> j1f(3), j1(3), j1l(3) */
__NAMESPACE_LOCAL_USING_OR_IMPL(j1, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL j1)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(j1))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_jn) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_jn)
/* >> jnf(3), jn(3), jnl(3) */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,jn,(int __n, double __x),{ return __builtin_jn(__n, __x); })
#elif defined(__CRT_HAVE_jn)
/* >> jnf(3), jn(3), jnl(3) */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,jn,(int __n, double __x),(__n,__x))
#elif defined(__CRT_HAVE__jn)
/* >> jnf(3), jn(3), jnl(3) */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,jn,(int __n, double __x),_jn,(__n,__x))
#elif defined(__CRT_HAVE___jn)
/* >> jnf(3), jn(3), jnl(3) */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,jn,(int __n, double __x),__jn,(__n,__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/jn.h>
/* >> jnf(3), jn(3), jnl(3) */
__NAMESPACE_LOCAL_USING_OR_IMPL(jn, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL jn)(int __n, double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(jn))(__n, __x); })
#endif /* ... */
#if __has_builtin(__builtin_y0) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_y0)
/* >> y0f(3), y0(3), y0l(3) */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,y0,(double __x),{ return __builtin_y0(__x); })
#elif defined(__CRT_HAVE_y0)
/* >> y0f(3), y0(3), y0l(3) */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,y0,(double __x),(__x))
#elif defined(__CRT_HAVE__y0)
/* >> y0f(3), y0(3), y0l(3) */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,y0,(double __x),_y0,(__x))
#elif defined(__CRT_HAVE___y0)
/* >> y0f(3), y0(3), y0l(3) */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,y0,(double __x),__y0,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/y0.h>
/* >> y0f(3), y0(3), y0l(3) */
__NAMESPACE_LOCAL_USING_OR_IMPL(y0, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL y0)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(y0))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_y1) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_y1)
/* >> y1f(3), y1(3), y1l(3) */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,y1,(double __x),{ return __builtin_y1(__x); })
#elif defined(__CRT_HAVE_y1)
/* >> y1f(3), y1(3), y1l(3) */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,y1,(double __x),(__x))
#elif defined(__CRT_HAVE__y1)
/* >> y1f(3), y1(3), y1l(3) */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,y1,(double __x),_y1,(__x))
#elif defined(__CRT_HAVE___y1)
/* >> y1f(3), y1(3), y1l(3) */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,y1,(double __x),__y1,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/y1.h>
/* >> y1f(3), y1(3), y1l(3) */
__NAMESPACE_LOCAL_USING_OR_IMPL(y1, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL y1)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(y1))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_yn) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_yn)
/* >> ynf(3), yn(3), ynl(3) */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,yn,(int __n, double __x),{ return __builtin_yn(__n, __x); })
#elif defined(__CRT_HAVE_yn)
/* >> ynf(3), yn(3), ynl(3) */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,yn,(int __n, double __x),(__n,__x))
#elif defined(__CRT_HAVE__yn)
/* >> ynf(3), yn(3), ynl(3) */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,yn,(int __n, double __x),_yn,(__n,__x))
#elif defined(__CRT_HAVE___yn)
/* >> ynf(3), yn(3), ynl(3) */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,yn,(int __n, double __x),__yn,(__n,__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/yn.h>
/* >> ynf(3), yn(3), ynl(3) */
__NAMESPACE_LOCAL_USING_OR_IMPL(yn, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL yn)(int __n, double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(yn))(__n, __x); })
#endif /* ... */
#endif /* __USE_MISC || __USE_XOPEN */
#ifdef __USE_MISC
#if __has_builtin(__builtin_j0f) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_j0f)
/* >> j0f(3), j0(3), j0l(3) */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,j0f,(float __x),{ return __builtin_j0f(__x); })
#elif defined(__CRT_HAVE_j0f)
/* >> j0f(3), j0(3), j0l(3) */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,j0f,(float __x),(__x))
#elif defined(__CRT_HAVE___j0f)
/* >> j0f(3), j0(3), j0l(3) */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,j0f,(float __x),__j0f,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_j0) || defined(__CRT_HAVE__j0) || defined(__CRT_HAVE___j0) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/j0f.h>
/* >> j0f(3), j0(3), j0l(3) */
__NAMESPACE_LOCAL_USING_OR_IMPL(j0f, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL j0f)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(j0f))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_j1f) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_j1f)
/* >> j1f(3), j1(3), j1l(3) */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,j1f,(float __x),{ return __builtin_j1f(__x); })
#elif defined(__CRT_HAVE_j1f)
/* >> j1f(3), j1(3), j1l(3) */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,j1f,(float __x),(__x))
#elif defined(__CRT_HAVE___j1f)
/* >> j1f(3), j1(3), j1l(3) */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,j1f,(float __x),__j1f,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_j1) || defined(__CRT_HAVE__j1) || defined(__CRT_HAVE___j1) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/j1f.h>
/* >> j1f(3), j1(3), j1l(3) */
__NAMESPACE_LOCAL_USING_OR_IMPL(j1f, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL j1f)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(j1f))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_jnf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_jnf)
/* >> jnf(3), jn(3), jnl(3) */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,jnf,(int __n, float __x),{ return __builtin_jnf(__n, __x); })
#elif defined(__CRT_HAVE_jnf)
/* >> jnf(3), jn(3), jnl(3) */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,jnf,(int __n, float __x),(__n,__x))
#elif defined(__CRT_HAVE___jnf)
/* >> jnf(3), jn(3), jnl(3) */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,jnf,(int __n, float __x),__jnf,(__n,__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_jn) || defined(__CRT_HAVE__jn) || defined(__CRT_HAVE___jn) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/jnf.h>
/* >> jnf(3), jn(3), jnl(3) */
__NAMESPACE_LOCAL_USING_OR_IMPL(jnf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL jnf)(int __n, float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(jnf))(__n, __x); })
#endif /* ... */
#if __has_builtin(__builtin_y0f) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_y0f)
/* >> y0f(3), y0(3), y0l(3) */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,y0f,(float __x),{ return __builtin_y0f(__x); })
#elif defined(__CRT_HAVE_y0f)
/* >> y0f(3), y0(3), y0l(3) */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,y0f,(float __x),(__x))
#elif defined(__CRT_HAVE___y0f)
/* >> y0f(3), y0(3), y0l(3) */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,y0f,(float __x),__y0f,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_y0) || defined(__CRT_HAVE__y0) || defined(__CRT_HAVE___y0) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/y0f.h>
/* >> y0f(3), y0(3), y0l(3) */
__NAMESPACE_LOCAL_USING_OR_IMPL(y0f, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL y0f)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(y0f))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_y1f) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_y1f)
/* >> y1f(3), y1(3), y1l(3) */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,y1f,(float __x),{ return __builtin_y1f(__x); })
#elif defined(__CRT_HAVE_y1f)
/* >> y1f(3), y1(3), y1l(3) */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,y1f,(float __x),(__x))
#elif defined(__CRT_HAVE___y1f)
/* >> y1f(3), y1(3), y1l(3) */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,y1f,(float __x),__y1f,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_y1) || defined(__CRT_HAVE__y1) || defined(__CRT_HAVE___y1) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/y1f.h>
/* >> y1f(3), y1(3), y1l(3) */
__NAMESPACE_LOCAL_USING_OR_IMPL(y1f, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL y1f)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(y1f))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_ynf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_ynf)
/* >> ynf(3), yn(3), ynl(3) */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,ynf,(int __n, float __x),{ return __builtin_ynf(__n, __x); })
#elif defined(__CRT_HAVE_ynf)
/* >> ynf(3), yn(3), ynl(3) */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,ynf,(int __n, float __x),(__n,__x))
#elif defined(__CRT_HAVE___ynf)
/* >> ynf(3), yn(3), ynl(3) */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,ynf,(int __n, float __x),__ynf,(__n,__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_yn) || defined(__CRT_HAVE__yn) || defined(__CRT_HAVE___yn) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/ynf.h>
/* >> ynf(3), yn(3), ynl(3) */
__NAMESPACE_LOCAL_USING_OR_IMPL(ynf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL ynf)(int __n, float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(ynf))(__n, __x); })
#endif /* ... */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if __has_builtin(__builtin_j0l) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_j0l)
/* >> j0f(3), j0(3), j0l(3) */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,j0l,(__LONGDOUBLE __x),{ return __builtin_j0l(__x); })
#elif defined(__CRT_HAVE_j0l)
/* >> j0f(3), j0(3), j0l(3) */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,j0l,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___j0l)
/* >> j0f(3), j0(3), j0l(3) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,j0l,(__LONGDOUBLE __x),__j0l,(__x))
#elif defined(__CRT_HAVE_j0) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> j0f(3), j0(3), j0l(3) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,j0l,(__LONGDOUBLE __x),j0,(__x))
#elif defined(__CRT_HAVE___j0) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> j0f(3), j0(3), j0l(3) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,j0l,(__LONGDOUBLE __x),__j0,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_j0) || defined(__CRT_HAVE__j0) || defined(__CRT_HAVE___j0) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/j0l.h>
/* >> j0f(3), j0(3), j0l(3) */
__NAMESPACE_LOCAL_USING_OR_IMPL(j0l, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL j0l)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(j0l))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_j1l) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_j1l)
/* >> j1f(3), j1(3), j1l(3) */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,j1l,(__LONGDOUBLE __x),{ return __builtin_j1l(__x); })
#elif defined(__CRT_HAVE_j1l)
/* >> j1f(3), j1(3), j1l(3) */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,j1l,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___j1l)
/* >> j1f(3), j1(3), j1l(3) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,j1l,(__LONGDOUBLE __x),__j1l,(__x))
#elif defined(__CRT_HAVE_j1) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> j1f(3), j1(3), j1l(3) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,j1l,(__LONGDOUBLE __x),j1,(__x))
#elif defined(__CRT_HAVE___j1) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> j1f(3), j1(3), j1l(3) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,j1l,(__LONGDOUBLE __x),__j1,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_j1) || defined(__CRT_HAVE__j1) || defined(__CRT_HAVE___j1) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/j1l.h>
/* >> j1f(3), j1(3), j1l(3) */
__NAMESPACE_LOCAL_USING_OR_IMPL(j1l, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL j1l)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(j1l))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_jnl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_jnl)
/* >> jnf(3), jn(3), jnl(3) */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,jnl,(int __n, __LONGDOUBLE __x),{ return __builtin_jnl(__n, __x); })
#elif defined(__CRT_HAVE_jnl)
/* >> jnf(3), jn(3), jnl(3) */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,jnl,(int __n, __LONGDOUBLE __x),(__n,__x))
#elif defined(__CRT_HAVE___jnl)
/* >> jnf(3), jn(3), jnl(3) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,jnl,(int __n, __LONGDOUBLE __x),__jnl,(__n,__x))
#elif defined(__CRT_HAVE_jn) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> jnf(3), jn(3), jnl(3) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,jnl,(int __n, __LONGDOUBLE __x),jn,(__n,__x))
#elif defined(__CRT_HAVE___jn) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> jnf(3), jn(3), jnl(3) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,jnl,(int __n, __LONGDOUBLE __x),__jn,(__n,__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_jn) || defined(__CRT_HAVE__jn) || defined(__CRT_HAVE___jn) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/jnl.h>
/* >> jnf(3), jn(3), jnl(3) */
__NAMESPACE_LOCAL_USING_OR_IMPL(jnl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL jnl)(int __n, __LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(jnl))(__n, __x); })
#endif /* ... */
#if __has_builtin(__builtin_y0l) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_y0l)
/* >> y0f(3), y0(3), y0l(3) */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,y0l,(__LONGDOUBLE __x),{ return __builtin_y0l(__x); })
#elif defined(__CRT_HAVE_y0l)
/* >> y0f(3), y0(3), y0l(3) */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,y0l,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___y0l)
/* >> y0f(3), y0(3), y0l(3) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,y0l,(__LONGDOUBLE __x),__y0l,(__x))
#elif defined(__CRT_HAVE_y0) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> y0f(3), y0(3), y0l(3) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,y0l,(__LONGDOUBLE __x),y0,(__x))
#elif defined(__CRT_HAVE___y0) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> y0f(3), y0(3), y0l(3) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,y0l,(__LONGDOUBLE __x),__y0,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_y0) || defined(__CRT_HAVE__y0) || defined(__CRT_HAVE___y0) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/y0l.h>
/* >> y0f(3), y0(3), y0l(3) */
__NAMESPACE_LOCAL_USING_OR_IMPL(y0l, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL y0l)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(y0l))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_y1l) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_y1l)
/* >> y1f(3), y1(3), y1l(3) */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,y1l,(__LONGDOUBLE __x),{ return __builtin_y1l(__x); })
#elif defined(__CRT_HAVE_y1l)
/* >> y1f(3), y1(3), y1l(3) */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,y1l,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___y1l)
/* >> y1f(3), y1(3), y1l(3) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,y1l,(__LONGDOUBLE __x),__y1l,(__x))
#elif defined(__CRT_HAVE_y1) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> y1f(3), y1(3), y1l(3) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,y1l,(__LONGDOUBLE __x),y1,(__x))
#elif defined(__CRT_HAVE___y1) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> y1f(3), y1(3), y1l(3) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,y1l,(__LONGDOUBLE __x),__y1,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_y1) || defined(__CRT_HAVE__y1) || defined(__CRT_HAVE___y1) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/y1l.h>
/* >> y1f(3), y1(3), y1l(3) */
__NAMESPACE_LOCAL_USING_OR_IMPL(y1l, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL y1l)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(y1l))(__x); })
#endif /* ... */
#if __has_builtin(__builtin_ynl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_ynl)
/* >> ynf(3), yn(3), ynl(3) */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,ynl,(int __n, __LONGDOUBLE __x),{ return __builtin_ynl(__n, __x); })
#elif defined(__CRT_HAVE_ynl)
/* >> ynf(3), yn(3), ynl(3) */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,ynl,(int __n, __LONGDOUBLE __x),(__n,__x))
#elif defined(__CRT_HAVE___ynl)
/* >> ynf(3), yn(3), ynl(3) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,ynl,(int __n, __LONGDOUBLE __x),__ynl,(__n,__x))
#elif defined(__CRT_HAVE_yn) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> ynf(3), yn(3), ynl(3) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,ynl,(int __n, __LONGDOUBLE __x),yn,(__n,__x))
#elif defined(__CRT_HAVE___yn) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> ynf(3), yn(3), ynl(3) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,ynl,(int __n, __LONGDOUBLE __x),__yn,(__n,__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_yn) || defined(__CRT_HAVE__yn) || defined(__CRT_HAVE___yn) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/ynl.h>
/* >> ynf(3), yn(3), ynl(3) */
__NAMESPACE_LOCAL_USING_OR_IMPL(ynl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL ynl)(int __n, __LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(ynl))(__n, __x); })
#endif /* ... */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_MISC */

#if defined(__USE_MISC) || (defined(__USE_XOPEN) && !defined(__USE_XOPEN2K))
#if __has_builtin(__builtin_lgamma) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_lgamma)
/* Obsolete export_alias for `lgamma' */
__CEIREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,gamma,(double __x),lgamma,{ return __builtin_lgamma(__x); })
#elif __has_builtin(__builtin_gamma) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_gamma)
/* Obsolete export_alias for `lgamma' */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,gamma,(double __x),{ return __builtin_gamma(__x); })
#elif defined(__CRT_HAVE_lgamma)
/* Obsolete export_alias for `lgamma' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,gamma,(double __x),lgamma,(__x))
#elif defined(__CRT_HAVE_gamma)
/* Obsolete export_alias for `lgamma' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,gamma,(double __x),(__x))
#elif defined(__CRT_HAVE___lgamma)
/* Obsolete export_alias for `lgamma' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,gamma,(double __x),__lgamma,(__x))
#elif defined(__CRT_HAVE___gamma)
/* Obsolete export_alias for `lgamma' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,gamma,(double __x),__gamma,(__x))
#elif defined(__LOCAL_signgam) && (defined(__CRT_HAVE_lgamma_r) || defined(__CRT_HAVE___lgamma_r) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__))
#include <libc/local/math/lgamma.h>
/* Obsolete export_alias for `lgamma' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL gamma)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(lgamma))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_lgammaf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_lgammaf)
/* Obsolete export_alias for `lgammaf' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,gammaf,(float __x),lgammaf,{ return __builtin_lgammaf(__x); })
#elif __has_builtin(__builtin_gammaf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_gammaf)
/* Obsolete export_alias for `lgammaf' */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,gammaf,(float __x),{ return __builtin_gammaf(__x); })
#elif defined(__CRT_HAVE_lgammaf)
/* Obsolete export_alias for `lgammaf' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,gammaf,(float __x),lgammaf,(__x))
#elif defined(__CRT_HAVE_gammaf)
/* Obsolete export_alias for `lgammaf' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,gammaf,(float __x),(__x))
#elif defined(__CRT_HAVE___lgammaf)
/* Obsolete export_alias for `lgammaf' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,gammaf,(float __x),__lgammaf,(__x))
#elif defined(__CRT_HAVE___gammaf)
/* Obsolete export_alias for `lgammaf' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,gammaf,(float __x),__gammaf,(__x))
#elif defined(__LOCAL_signgam) && (defined(__CRT_HAVE_lgammaf_r) || defined(__CRT_HAVE___lgammaf_r) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_lgamma_r) || defined(__CRT_HAVE___lgamma_r) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__))
#include <libc/local/math/lgammaf.h>
/* Obsolete export_alias for `lgammaf' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL gammaf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(lgammaf))(__x); }
#endif /* ... */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if __has_builtin(__builtin_lgammal) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_lgammal)
/* Obsolete export_alias for `lgammal' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,gammal,(__LONGDOUBLE __x),lgammal,{ return __builtin_lgammal(__x); })
#elif __has_builtin(__builtin_gammal) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_gammal)
/* Obsolete export_alias for `lgammal' */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,gammal,(__LONGDOUBLE __x),{ return __builtin_gammal(__x); })
#elif defined(__CRT_HAVE_lgammal)
/* Obsolete export_alias for `lgammal' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,gammal,(__LONGDOUBLE __x),lgammal,(__x))
#elif defined(__CRT_HAVE_gammal)
/* Obsolete export_alias for `lgammal' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,gammal,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___lgammal)
/* Obsolete export_alias for `lgammal' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,gammal,(__LONGDOUBLE __x),__lgammal,(__x))
#elif defined(__CRT_HAVE___gammal)
/* Obsolete export_alias for `lgammal' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,gammal,(__LONGDOUBLE __x),__gammal,(__x))
#elif defined(__LOCAL_signgam) && (defined(__CRT_HAVE_lgammal_r) || defined(__CRT_HAVE___lgammal_r) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_lgamma_r) || defined(__CRT_HAVE___lgamma_r) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__))
#include <libc/local/math/lgammal.h>
/* Obsolete export_alias for `lgammal' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL gammal)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(lgammal))(__x); }
#endif /* ... */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_MISC || (__USE_XOPEN && !__USE_XOPEN2K) */
#ifdef __USE_MISC
#if __has_builtin(__builtin_lgamma_r) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_lgamma_r)
/* >> lgammaf_r(3), lgamma_r(3), lgammal_r(3)
 * Reentrant    version    of     `lgamma(3)' */
__CEIDECLARE(__ATTR_WUNUSED __ATTR_OUT(2),double,__NOTHROW_NCX,lgamma_r,(double __x, int *__signgamp),{ return __builtin_lgamma_r(__x, __signgamp); })
#elif defined(__CRT_HAVE_lgamma_r)
/* >> lgammaf_r(3), lgamma_r(3), lgammal_r(3)
 * Reentrant    version    of     `lgamma(3)' */
__CDECLARE(__ATTR_WUNUSED __ATTR_OUT(2),double,__NOTHROW_NCX,lgamma_r,(double __x, int *__signgamp),(__x,__signgamp))
#elif defined(__CRT_HAVE___lgamma_r)
/* >> lgammaf_r(3), lgamma_r(3), lgammal_r(3)
 * Reentrant    version    of     `lgamma(3)' */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(2),double,__NOTHROW_NCX,lgamma_r,(double __x, int *__signgamp),__lgamma_r,(__x,__signgamp))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/lgamma_r.h>
/* >> lgammaf_r(3), lgamma_r(3), lgammal_r(3)
 * Reentrant    version    of     `lgamma(3)' */
__NAMESPACE_LOCAL_USING_OR_IMPL(lgamma_r, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __ATTR_OUT(2) double __NOTHROW_NCX(__LIBCCALL lgamma_r)(double __x, int *__signgamp) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(lgamma_r))(__x, __signgamp); })
#endif /* ... */
#if __has_builtin(__builtin_lgammaf_r) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_lgammaf_r)
/* >> lgammaf_r(3), lgamma_r(3), lgammal_r(3)
 * Reentrant    version    of     `lgamma(3)' */
__CEIDECLARE(__ATTR_WUNUSED __ATTR_OUT(2),float,__NOTHROW_NCX,lgammaf_r,(float __x, int *__signgamp),{ return __builtin_lgammaf_r(__x, __signgamp); })
#elif defined(__CRT_HAVE_lgammaf_r)
/* >> lgammaf_r(3), lgamma_r(3), lgammal_r(3)
 * Reentrant    version    of     `lgamma(3)' */
__CDECLARE(__ATTR_WUNUSED __ATTR_OUT(2),float,__NOTHROW_NCX,lgammaf_r,(float __x, int *__signgamp),(__x,__signgamp))
#elif defined(__CRT_HAVE___lgammaf_r)
/* >> lgammaf_r(3), lgamma_r(3), lgammal_r(3)
 * Reentrant    version    of     `lgamma(3)' */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(2),float,__NOTHROW_NCX,lgammaf_r,(float __x, int *__signgamp),__lgammaf_r,(__x,__signgamp))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_lgamma_r) || defined(__CRT_HAVE___lgamma_r) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/lgammaf_r.h>
/* >> lgammaf_r(3), lgamma_r(3), lgammal_r(3)
 * Reentrant    version    of     `lgamma(3)' */
__NAMESPACE_LOCAL_USING_OR_IMPL(lgammaf_r, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __ATTR_OUT(2) float __NOTHROW_NCX(__LIBCCALL lgammaf_r)(float __x, int *__signgamp) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(lgammaf_r))(__x, __signgamp); })
#endif /* ... */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if __has_builtin(__builtin_lgammal_r) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_lgammal_r)
/* >> lgammaf_r(3), lgamma_r(3), lgammal_r(3)
 * Reentrant    version    of     `lgamma(3)' */
__CEIDECLARE(__ATTR_WUNUSED __ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,lgammal_r,(__LONGDOUBLE __x, int *__signgamp),{ return __builtin_lgammal_r(__x, __signgamp); })
#elif defined(__CRT_HAVE_lgammal_r)
/* >> lgammaf_r(3), lgamma_r(3), lgammal_r(3)
 * Reentrant    version    of     `lgamma(3)' */
__CDECLARE(__ATTR_WUNUSED __ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,lgammal_r,(__LONGDOUBLE __x, int *__signgamp),(__x,__signgamp))
#elif defined(__CRT_HAVE___lgammal_r)
/* >> lgammaf_r(3), lgamma_r(3), lgammal_r(3)
 * Reentrant    version    of     `lgamma(3)' */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,lgammal_r,(__LONGDOUBLE __x, int *__signgamp),__lgammal_r,(__x,__signgamp))
#elif defined(__CRT_HAVE_lgamma_r) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> lgammaf_r(3), lgamma_r(3), lgammal_r(3)
 * Reentrant    version    of     `lgamma(3)' */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,lgammal_r,(__LONGDOUBLE __x, int *__signgamp),lgamma_r,(__x,__signgamp))
#elif defined(__CRT_HAVE___lgamma_r) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> lgammaf_r(3), lgamma_r(3), lgammal_r(3)
 * Reentrant    version    of     `lgamma(3)' */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,lgammal_r,(__LONGDOUBLE __x, int *__signgamp),__lgamma_r,(__x,__signgamp))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_lgamma_r) || defined(__CRT_HAVE___lgamma_r) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/lgammal_r.h>
/* >> lgammaf_r(3), lgamma_r(3), lgammal_r(3)
 * Reentrant    version    of     `lgamma(3)' */
__NAMESPACE_LOCAL_USING_OR_IMPL(lgammal_r, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __ATTR_OUT(2) __LONGDOUBLE __NOTHROW_NCX(__LIBCCALL lgammal_r)(__LONGDOUBLE __x, int *__signgamp) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(lgammal_r))(__x, __signgamp); })
#endif /* ... */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_MISC */

#if defined(__USE_MISC) || (defined(__USE_XOPEN_EXTENDED) && !defined(__USE_XOPEN2K8))
#if __has_builtin(__builtin_scalb) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_scalb)
/* >> scalbf(3), scalb(3), scalbl(3)
 * Return `x' times (2 to the Nth power) */
__CEIDECLARE(__ATTR_WUNUSED,double,__NOTHROW,scalb,(double __x, double __fn),{ return __builtin_scalb(__x, __fn); })
#elif defined(__CRT_HAVE_scalb)
/* >> scalbf(3), scalb(3), scalbl(3)
 * Return `x' times (2 to the Nth power) */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,scalb,(double __x, double __fn),(__x,__fn))
#elif defined(__CRT_HAVE__scalb)
/* >> scalbf(3), scalb(3), scalbl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,scalb,(double __x, double __fn),_scalb,(__x,__fn))
#elif defined(__CRT_HAVE___scalb)
/* >> scalbf(3), scalb(3), scalbl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,scalb,(double __x, double __fn),__scalb,(__x,__fn))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/scalb.h>
/* >> scalbf(3), scalb(3), scalbl(3)
 * Return `x' times (2 to the Nth power) */
__NAMESPACE_LOCAL_USING_OR_IMPL(scalb, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL scalb)(double __x, double __fn) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(scalb))(__x, __fn); })
#endif /* ... */
#endif /* __USE_MISC || (__USE_XOPEN_EXTENDED && !__USE_XOPEN2K8) */
#ifdef __USE_MISC
#if __has_builtin(__builtin_scalbf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_scalbf)
/* >> scalbf(3), scalb(3), scalbl(3)
 * Return `x' times (2 to the Nth power) */
__CEIDECLARE(__ATTR_WUNUSED,float,__NOTHROW,scalbf,(float __x, float __fn),{ return __builtin_scalbf(__x, __fn); })
#elif defined(__CRT_HAVE_scalbf)
/* >> scalbf(3), scalb(3), scalbl(3)
 * Return `x' times (2 to the Nth power) */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,scalbf,(float __x, float __fn),(__x,__fn))
#elif defined(__CRT_HAVE__scalbf)
/* >> scalbf(3), scalb(3), scalbl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,scalbf,(float __x, float __fn),_scalbf,(__x,__fn))
#elif defined(__CRT_HAVE___scalbf)
/* >> scalbf(3), scalb(3), scalbl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,scalbf,(float __x, float __fn),__scalbf,(__x,__fn))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_scalb) || defined(__CRT_HAVE__scalb) || defined(__CRT_HAVE___scalb) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/scalbf.h>
/* >> scalbf(3), scalb(3), scalbl(3)
 * Return `x' times (2 to the Nth power) */
__NAMESPACE_LOCAL_USING_OR_IMPL(scalbf, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL scalbf)(float __x, float __fn) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(scalbf))(__x, __fn); })
#endif /* ... */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if __has_builtin(__builtin_scalbl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_scalbl)
/* >> scalbf(3), scalb(3), scalbl(3)
 * Return `x' times (2 to the Nth power) */
__CEIDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbl,(__LONGDOUBLE __x, __LONGDOUBLE __fn),{ return __builtin_scalbl(__x, __fn); })
#elif defined(__CRT_HAVE_scalbl)
/* >> scalbf(3), scalb(3), scalbl(3)
 * Return `x' times (2 to the Nth power) */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbl,(__LONGDOUBLE __x, __LONGDOUBLE __fn),(__x,__fn))
#elif defined(__CRT_HAVE___scalbl)
/* >> scalbf(3), scalb(3), scalbl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbl,(__LONGDOUBLE __x, __LONGDOUBLE __fn),__scalbl,(__x,__fn))
#elif defined(__CRT_HAVE_scalb) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> scalbf(3), scalb(3), scalbl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbl,(__LONGDOUBLE __x, __LONGDOUBLE __fn),scalb,(__x,__fn))
#elif defined(__CRT_HAVE___scalb) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> scalbf(3), scalb(3), scalbl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,scalbl,(__LONGDOUBLE __x, __LONGDOUBLE __fn),__scalb,(__x,__fn))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_scalb) || defined(__CRT_HAVE__scalb) || defined(__CRT_HAVE___scalb) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/scalbl.h>
/* >> scalbf(3), scalb(3), scalbl(3)
 * Return `x' times (2 to the Nth power) */
__NAMESPACE_LOCAL_USING_OR_IMPL(scalbl, __FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL scalbl)(__LONGDOUBLE __x, __LONGDOUBLE __fn) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(scalbl))(__x, __fn); })
#endif /* ... */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_MISC */


/************************************************************************/
/* Glibc __aliases                                                      */
/************************************************************************/
#ifdef __USE_GLIBC_BLOAT
#if __has_builtin(__builtin_acos) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_acos)
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__acos,(double __x),acos,{ return __builtin_acos(__x); })
#elif defined(__CRT_HAVE_acos)
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__acos,(double __x),acos,(__x))
#elif defined(__CRT_HAVE___acos)
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,__acos,(double __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/acos.h>
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __acos)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(acos))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_asin) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_asin)
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__asin,(double __x),asin,{ return __builtin_asin(__x); })
#elif defined(__CRT_HAVE_asin)
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__asin,(double __x),asin,(__x))
#elif defined(__CRT_HAVE___asin)
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,__asin,(double __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/asin.h>
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __asin)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(asin))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_atan) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_atan)
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__atan,(double __x),atan,{ return __builtin_atan(__x); })
#elif defined(__CRT_HAVE_atan)
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__atan,(double __x),atan,(__x))
#elif defined(__CRT_HAVE___atan)
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,__atan,(double __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/atan.h>
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __atan)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(atan))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_atan2) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_atan2)
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__CEIREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__atan2,(double __y, double __x),atan2,{ return __builtin_atan2(__y, __x); })
#elif defined(__CRT_HAVE_atan2)
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__atan2,(double __y, double __x),atan2,(__y,__x))
#elif defined(__CRT_HAVE___atan2)
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,__atan2,(double __y, double __x),(__y,__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/atan2.h>
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __atan2)(double __y, double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(atan2))(__y, __x); }
#endif /* ... */
#if __has_builtin(__builtin_cos) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_cos)
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__CEIREDIRECT(__ATTR_WUNUSED __DECL_SIMD_cos,double,__NOTHROW,__cos,(double __x),cos,{ return __builtin_cos(__x); })
#elif defined(__CRT_HAVE_cos)
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_cos,double,__NOTHROW,__cos,(double __x),cos,(__x))
#elif defined(__CRT_HAVE___cos)
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__CDECLARE(__ATTR_WUNUSED __DECL_SIMD_cos,double,__NOTHROW,__cos,(double __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/cos.h>
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_cos double __NOTHROW(__LIBCCALL __cos)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(cos))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_sin) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_sin)
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__CEIREDIRECT(__ATTR_WUNUSED __DECL_SIMD_sin,double,__NOTHROW,__sin,(double __x),sin,{ return __builtin_sin(__x); })
#elif defined(__CRT_HAVE_sin)
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_sin,double,__NOTHROW,__sin,(double __x),sin,(__x))
#elif defined(__CRT_HAVE___sin)
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__CDECLARE(__ATTR_WUNUSED __DECL_SIMD_sin,double,__NOTHROW,__sin,(double __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/sin.h>
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_sin double __NOTHROW(__LIBCCALL __sin)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(sin))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_tan) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_tan)
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__tan,(double __x),tan,{ return __builtin_tan(__x); })
#elif defined(__CRT_HAVE_tan)
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__tan,(double __x),tan,(__x))
#elif defined(__CRT_HAVE___tan)
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,__tan,(double __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/tan.h>
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __tan)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(tan))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_cosh) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_cosh)
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__CEIREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__cosh,(double __x),cosh,{ return __builtin_cosh(__x); })
#elif defined(__CRT_HAVE_cosh)
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__cosh,(double __x),cosh,(__x))
#elif defined(__CRT_HAVE___cosh)
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,__cosh,(double __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/cosh.h>
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __cosh)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(cosh))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_sinh) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_sinh)
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__sinh,(double __x),sinh,{ return __builtin_sinh(__x); })
#elif defined(__CRT_HAVE_sinh)
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__sinh,(double __x),sinh,(__x))
#elif defined(__CRT_HAVE___sinh)
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,__sinh,(double __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/sinh.h>
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __sinh)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(sinh))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_tanh) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_tanh)
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__tanh,(double __x),tanh,{ return __builtin_tanh(__x); })
#elif defined(__CRT_HAVE_tanh)
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__tanh,(double __x),tanh,(__x))
#elif defined(__CRT_HAVE___tanh)
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__tanh,(double __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/tanh.h>
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __tanh)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(tanh))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_exp) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_exp)
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__CEIREDIRECT(__ATTR_WUNUSED __DECL_SIMD_exp,double,__NOTHROW,__exp,(double __x),exp,{ return __builtin_exp(__x); })
#elif defined(__CRT_HAVE_exp)
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_exp,double,__NOTHROW,__exp,(double __x),exp,(__x))
#elif defined(__CRT_HAVE___exp)
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__CDECLARE(__ATTR_WUNUSED __DECL_SIMD_exp,double,__NOTHROW,__exp,(double __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/exp.h>
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_exp double __NOTHROW(__LIBCCALL __exp)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(exp))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_frexp) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_frexp)
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__CEIREDIRECT(__ATTR_OUT(2),double,__NOTHROW_NCX,__frexp,(double __x, int *__pexponent),frexp,{ return __builtin_frexp(__x, __pexponent); })
#elif defined(__CRT_HAVE_frexp)
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__CREDIRECT(__ATTR_OUT(2),double,__NOTHROW_NCX,__frexp,(double __x, int *__pexponent),frexp,(__x,__pexponent))
#elif defined(__CRT_HAVE___frexp)
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__CDECLARE(__ATTR_OUT(2),double,__NOTHROW_NCX,__frexp,(double __x, int *__pexponent),(__x,__pexponent))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/frexp.h>
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_OUT(2) double __NOTHROW_NCX(__LIBCCALL __frexp)(double __x, int *__pexponent) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(frexp))(__x, __pexponent); }
#endif /* ... */
#if __has_builtin(__builtin_ldexp) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_ldexp)
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__CEIREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__ldexp,(double __x, int __exponent),ldexp,{ return __builtin_ldexp(__x, __exponent); })
#elif defined(__CRT_HAVE_ldexp)
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__ldexp,(double __x, int __exponent),ldexp,(__x,__exponent))
#elif defined(__CRT_HAVE___ldexp)
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,__ldexp,(double __x, int __exponent),(__x,__exponent))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/ldexp.h>
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __ldexp)(double __x, int __exponent) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(ldexp))(__x, __exponent); }
#endif /* ... */
#if __has_builtin(__builtin_log) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_log)
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__CEIREDIRECT(__ATTR_WUNUSED __DECL_SIMD_log,double,__NOTHROW,__log,(double __x),log,{ return __builtin_log(__x); })
#elif defined(__CRT_HAVE_log)
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_log,double,__NOTHROW,__log,(double __x),log,(__x))
#elif defined(__CRT_HAVE___log)
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__CDECLARE(__ATTR_WUNUSED __DECL_SIMD_log,double,__NOTHROW,__log,(double __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/log.h>
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_log double __NOTHROW(__LIBCCALL __log)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(log))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_log10) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_log10)
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__CEIREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__log10,(double __x),log10,{ return __builtin_log10(__x); })
#elif defined(__CRT_HAVE_log10)
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__log10,(double __x),log10,(__x))
#elif defined(__CRT_HAVE___log10)
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,__log10,(double __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/log10.h>
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __log10)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(log10))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_pow) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_pow)
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__CEIREDIRECT(__ATTR_WUNUSED __DECL_SIMD_pow,double,__NOTHROW,__pow,(double __x, double __y),pow,{ return __builtin_pow(__x, __y); })
#elif defined(__CRT_HAVE_pow)
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_pow,double,__NOTHROW,__pow,(double __x, double __y),pow,(__x,__y))
#elif defined(__CRT_HAVE___pow)
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__CDECLARE(__ATTR_WUNUSED __DECL_SIMD_pow,double,__NOTHROW,__pow,(double __x, double __y),(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/pow.h>
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_pow double __NOTHROW(__LIBCCALL __pow)(double __x, double __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(pow))(__x, __y); }
#endif /* ... */
#if __has_builtin(__builtin_sqrt) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_sqrt)
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__CEIREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__sqrt,(double __x),sqrt,{ return __builtin_sqrt(__x); })
#elif defined(__CRT_HAVE_sqrt)
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__sqrt,(double __x),sqrt,(__x))
#elif defined(__CRT_HAVE___sqrt)
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,__sqrt,(double __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/sqrt.h>
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __sqrt)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(sqrt))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_ceil) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_ceil)
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__ceil,(double __x),ceil,{ return __builtin_ceil(__x); })
#elif defined(__CRT_HAVE_ceil)
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__ceil,(double __x),ceil,(__x))
#elif defined(__CRT_HAVE___ceil)
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__ceil,(double __x),(__x))
#else /* ... */
#include <libc/local/math/ceil.h>
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __ceil)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(ceil))(__x); }
#endif /* !... */
#if __has_builtin(__builtin_fabs) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fabs)
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__fabs,(double __x),fabs,{ return __builtin_fabs(__x); })
#elif defined(__CRT_HAVE_fabs)
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__fabs,(double __x),fabs,(__x))
#elif defined(__CRT_HAVE___fabs)
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__fabs,(double __x),(__x))
#else /* ... */
#include <libc/local/math/fabs.h>
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __fabs)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fabs))(__x); }
#endif /* !... */
#if __has_builtin(__builtin_floor) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_floor)
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__floor,(double __x),floor,{ return __builtin_floor(__x); })
#elif defined(__CRT_HAVE_floor)
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__floor,(double __x),floor,(__x))
#elif defined(__CRT_HAVE___floor)
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__floor,(double __x),(__x))
#else /* ... */
#include <libc/local/math/floor.h>
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __floor)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(floor))(__x); }
#endif /* !... */
#if __has_builtin(__builtin_fmod) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fmod)
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__CEIREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__fmod,(double __x, double __y),fmod,{ return __builtin_fmod(__x, __y); })
#elif defined(__CRT_HAVE_fmod)
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__fmod,(double __x, double __y),fmod,(__x,__y))
#elif defined(__CRT_HAVE___fmod)
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,__fmod,(double __x, double __y),(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/fmod.h>
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __fmod)(double __x, double __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fmod))(__x, __y); }
#endif /* ... */
#if __has_builtin(__builtin_modf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_modf)
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__CEIREDIRECT(__ATTR_WUNUSED __ATTR_OUT(2),double,__NOTHROW_NCX,__modf,(double __x, double *__iptr),modf,{ return __builtin_modf(__x, __iptr); })
#elif defined(__CRT_HAVE_modf)
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(2),double,__NOTHROW_NCX,__modf,(double __x, double *__iptr),modf,(__x,__iptr))
#elif defined(__CRT_HAVE___modf)
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__CDECLARE(__ATTR_WUNUSED __ATTR_OUT(2),double,__NOTHROW_NCX,__modf,(double __x, double *__iptr),(__x,__iptr))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/modf.h>
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __ATTR_OUT(2) double __NOTHROW_NCX(__LIBCCALL __modf)(double __x, double *__iptr) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(modf))(__x, __iptr); }
#endif /* ... */
#if __has_builtin(__builtin_acosf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_acosf)
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__acosf,(float __x),acosf,{ return __builtin_acosf(__x); })
#elif defined(__CRT_HAVE_acosf)
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__acosf,(float __x),acosf,(__x))
#elif defined(__CRT_HAVE___acosf)
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,__acosf,(float __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_acos) || defined(__CRT_HAVE___acos) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/acosf.h>
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL __acosf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(acosf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_asinf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_asinf)
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__asinf,(float __x),asinf,{ return __builtin_asinf(__x); })
#elif defined(__CRT_HAVE_asinf)
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__asinf,(float __x),asinf,(__x))
#elif defined(__CRT_HAVE___asinf)
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,__asinf,(float __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_asin) || defined(__CRT_HAVE___asin) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/asinf.h>
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL __asinf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(asinf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_atanf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_atanf)
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__atanf,(float __x),atanf,{ return __builtin_atanf(__x); })
#elif defined(__CRT_HAVE_atanf)
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__atanf,(float __x),atanf,(__x))
#elif defined(__CRT_HAVE___atanf)
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,__atanf,(float __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_atan) || defined(__CRT_HAVE___atan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/atanf.h>
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL __atanf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(atanf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_atan2f) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_atan2f)
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__atan2f,(float __y, float __x),atan2f,{ return __builtin_atan2f(__y, __x); })
#elif defined(__CRT_HAVE_atan2f)
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__atan2f,(float __y, float __x),atan2f,(__y,__x))
#elif defined(__CRT_HAVE___atan2f)
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,__atan2f,(float __y, float __x),(__y,__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_atan2) || defined(__CRT_HAVE___atan2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/atan2f.h>
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL __atan2f)(float __y, float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(atan2f))(__y, __x); }
#endif /* ... */
#if __has_builtin(__builtin_cosf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_cosf)
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__CEIREDIRECT(__ATTR_WUNUSED __DECL_SIMD_cosf,float,__NOTHROW,__cosf,(float __x),cosf,{ return __builtin_cosf(__x); })
#elif defined(__CRT_HAVE_cosf)
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_cosf,float,__NOTHROW,__cosf,(float __x),cosf,(__x))
#elif defined(__CRT_HAVE___cosf)
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__CDECLARE(__ATTR_WUNUSED __DECL_SIMD_cosf,float,__NOTHROW,__cosf,(float __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_cos) || defined(__CRT_HAVE___cos) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/cosf.h>
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_cosf float __NOTHROW(__LIBCCALL __cosf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(cosf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_sinf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_sinf)
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__CEIREDIRECT(__ATTR_WUNUSED __DECL_SIMD_sinf,float,__NOTHROW,__sinf,(float __x),sinf,{ return __builtin_sinf(__x); })
#elif defined(__CRT_HAVE_sinf)
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_sinf,float,__NOTHROW,__sinf,(float __x),sinf,(__x))
#elif defined(__CRT_HAVE___sinf)
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__CDECLARE(__ATTR_WUNUSED __DECL_SIMD_sinf,float,__NOTHROW,__sinf,(float __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_sin) || defined(__CRT_HAVE___sin) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/sinf.h>
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_sinf float __NOTHROW(__LIBCCALL __sinf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(sinf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_tanf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_tanf)
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__tanf,(float __x),tanf,{ return __builtin_tanf(__x); })
#elif defined(__CRT_HAVE_tanf)
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__tanf,(float __x),tanf,(__x))
#elif defined(__CRT_HAVE___tanf)
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,__tanf,(float __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_tan) || defined(__CRT_HAVE___tan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/tanf.h>
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL __tanf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(tanf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_coshf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_coshf)
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__coshf,(float __x),coshf,{ return __builtin_coshf(__x); })
#elif defined(__CRT_HAVE_coshf)
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__coshf,(float __x),coshf,(__x))
#elif defined(__CRT_HAVE___coshf)
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,__coshf,(float __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_cosh) || defined(__CRT_HAVE___cosh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/coshf.h>
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL __coshf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(coshf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_sinhf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_sinhf)
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__sinhf,(float __x),sinhf,{ return __builtin_sinhf(__x); })
#elif defined(__CRT_HAVE_sinhf)
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__sinhf,(float __x),sinhf,(__x))
#elif defined(__CRT_HAVE___sinhf)
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,__sinhf,(float __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_sinh) || defined(__CRT_HAVE___sinh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/sinhf.h>
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL __sinhf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(sinhf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_tanhf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_tanhf)
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__tanhf,(float __x),tanhf,{ return __builtin_tanhf(__x); })
#elif defined(__CRT_HAVE_tanhf)
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__tanhf,(float __x),tanhf,(__x))
#elif defined(__CRT_HAVE___tanhf)
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__tanhf,(float __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_tanh) || defined(__CRT_HAVE___tanh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/tanhf.h>
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL __tanhf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(tanhf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_expf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_expf)
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__CEIREDIRECT(__ATTR_WUNUSED __DECL_SIMD_expf,float,__NOTHROW,__expf,(float __x),expf,{ return __builtin_expf(__x); })
#elif defined(__CRT_HAVE_expf)
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_expf,float,__NOTHROW,__expf,(float __x),expf,(__x))
#elif defined(__CRT_HAVE___expf)
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__CDECLARE(__ATTR_WUNUSED __DECL_SIMD_expf,float,__NOTHROW,__expf,(float __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_exp) || defined(__CRT_HAVE___exp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/expf.h>
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_expf float __NOTHROW(__LIBCCALL __expf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(expf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_frexpf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_frexpf)
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__CEIREDIRECT(__ATTR_OUT(2),float,__NOTHROW_NCX,__frexpf,(float __x, int *__pexponent),frexpf,{ return __builtin_frexpf(__x, __pexponent); })
#elif defined(__CRT_HAVE_frexpf)
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__CREDIRECT(__ATTR_OUT(2),float,__NOTHROW_NCX,__frexpf,(float __x, int *__pexponent),frexpf,(__x,__pexponent))
#elif defined(__CRT_HAVE___frexpf)
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__CDECLARE(__ATTR_OUT(2),float,__NOTHROW_NCX,__frexpf,(float __x, int *__pexponent),(__x,__pexponent))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_frexp) || defined(__CRT_HAVE___frexp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/frexpf.h>
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_OUT(2) float __NOTHROW_NCX(__LIBCCALL __frexpf)(float __x, int *__pexponent) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(frexpf))(__x, __pexponent); }
#endif /* ... */
#if __has_builtin(__builtin_ldexpf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_ldexpf)
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__ldexpf,(float __x, int __exponent),ldexpf,{ return __builtin_ldexpf(__x, __exponent); })
#elif defined(__CRT_HAVE_ldexpf)
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__ldexpf,(float __x, int __exponent),ldexpf,(__x,__exponent))
#elif defined(__CRT_HAVE___ldexpf)
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,__ldexpf,(float __x, int __exponent),(__x,__exponent))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_ldexp) || defined(__CRT_HAVE___ldexp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/ldexpf.h>
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL __ldexpf)(float __x, int __exponent) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(ldexpf))(__x, __exponent); }
#endif /* ... */
#if __has_builtin(__builtin_logf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_logf)
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__CEIREDIRECT(__ATTR_WUNUSED __DECL_SIMD_logf,float,__NOTHROW,__logf,(float __x),logf,{ return __builtin_logf(__x); })
#elif defined(__CRT_HAVE_logf)
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_logf,float,__NOTHROW,__logf,(float __x),logf,(__x))
#elif defined(__CRT_HAVE___logf)
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__CDECLARE(__ATTR_WUNUSED __DECL_SIMD_logf,float,__NOTHROW,__logf,(float __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_log) || defined(__CRT_HAVE___log) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/logf.h>
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_logf float __NOTHROW(__LIBCCALL __logf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(logf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_log10f) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_log10f)
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__log10f,(float __x),log10f,{ return __builtin_log10f(__x); })
#elif defined(__CRT_HAVE_log10f)
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__log10f,(float __x),log10f,(__x))
#elif defined(__CRT_HAVE___log10f)
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,__log10f,(float __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_log10) || defined(__CRT_HAVE___log10) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/log10f.h>
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL __log10f)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(log10f))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_modff) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_modff)
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__CEIREDIRECT(__ATTR_WUNUSED __ATTR_OUT(2),float,__NOTHROW_NCX,__modff,(float __x, float *__iptr),modff,{ return __builtin_modff(__x, __iptr); })
#elif defined(__CRT_HAVE_modff)
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(2),float,__NOTHROW_NCX,__modff,(float __x, float *__iptr),modff,(__x,__iptr))
#elif defined(__CRT_HAVE___modff)
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__CDECLARE(__ATTR_WUNUSED __ATTR_OUT(2),float,__NOTHROW_NCX,__modff,(float __x, float *__iptr),(__x,__iptr))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_modf) || defined(__CRT_HAVE___modf) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/modff.h>
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __ATTR_OUT(2) float __NOTHROW_NCX(__LIBCCALL __modff)(float __x, float *__iptr) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(modff))(__x, __iptr); }
#endif /* ... */
#if __has_builtin(__builtin_powf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_powf)
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__CEIREDIRECT(__ATTR_WUNUSED __DECL_SIMD_powf,float,__NOTHROW,__powf,(float __x, float __y),powf,{ return __builtin_powf(__x, __y); })
#elif defined(__CRT_HAVE_powf)
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_powf,float,__NOTHROW,__powf,(float __x, float __y),powf,(__x,__y))
#elif defined(__CRT_HAVE___powf)
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__CDECLARE(__ATTR_WUNUSED __DECL_SIMD_powf,float,__NOTHROW,__powf,(float __x, float __y),(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_pow) || defined(__CRT_HAVE___pow) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/powf.h>
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_powf float __NOTHROW(__LIBCCALL __powf)(float __x, float __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(powf))(__x, __y); }
#endif /* ... */
#if __has_builtin(__builtin_sqrtf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_sqrtf)
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__sqrtf,(float __x),sqrtf,{ return __builtin_sqrtf(__x); })
#elif defined(__CRT_HAVE_sqrtf)
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__sqrtf,(float __x),sqrtf,(__x))
#elif defined(__CRT_HAVE___sqrtf)
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,__sqrtf,(float __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_sqrt) || defined(__CRT_HAVE___sqrt) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/sqrtf.h>
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL __sqrtf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(sqrtf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_ceilf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_ceilf)
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__ceilf,(float __x),ceilf,{ return __builtin_ceilf(__x); })
#elif defined(__CRT_HAVE_ceilf)
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__ceilf,(float __x),ceilf,(__x))
#elif defined(__CRT_HAVE___ceilf)
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__ceilf,(float __x),(__x))
#else /* ... */
#include <libc/local/math/ceilf.h>
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL __ceilf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(ceilf))(__x); }
#endif /* !... */
#if __has_builtin(__builtin_fabsf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fabsf)
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__fabsf,(float __x),fabsf,{ return __builtin_fabsf(__x); })
#elif defined(__CRT_HAVE_fabsf)
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__fabsf,(float __x),fabsf,(__x))
#elif defined(__CRT_HAVE___fabsf)
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__fabsf,(float __x),(__x))
#else /* ... */
#include <libc/local/math/fabsf.h>
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL __fabsf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fabsf))(__x); }
#endif /* !... */
#if __has_builtin(__builtin_floorf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_floorf)
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__floorf,(float __x),floorf,{ return __builtin_floorf(__x); })
#elif defined(__CRT_HAVE_floorf)
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__floorf,(float __x),floorf,(__x))
#elif defined(__CRT_HAVE___floorf)
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__floorf,(float __x),(__x))
#else /* ... */
#include <libc/local/math/floorf.h>
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL __floorf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(floorf))(__x); }
#endif /* !... */
#if __has_builtin(__builtin_fmodf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fmodf)
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__fmodf,(float __x, float __y),fmodf,{ return __builtin_fmodf(__x, __y); })
#elif defined(__CRT_HAVE_fmodf)
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__fmodf,(float __x, float __y),fmodf,(__x,__y))
#elif defined(__CRT_HAVE___fmodf)
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,__fmodf,(float __x, float __y),(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_fmod) || defined(__CRT_HAVE___fmod) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/fmodf.h>
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL __fmodf)(float __x, float __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fmodf))(__x, __y); }
#endif /* ... */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if __has_builtin(__builtin_acosl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_acosl)
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__acosl,(__LONGDOUBLE __x),acosl,{ return __builtin_acosl(__x); })
#elif defined(__CRT_HAVE_acosl)
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__acosl,(__LONGDOUBLE __x),acosl,(__x))
#elif defined(__CRT_HAVE___acosl)
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__acosl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE_acos) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__acosl,(__LONGDOUBLE __x),acos,(__x))
#elif defined(__CRT_HAVE___acos) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__acosl,(__LONGDOUBLE __x),__acos,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_acos) || defined(__CRT_HAVE___acos) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/acosl.h>
/* >> acosf(3), acos(3), acosl(3)
 * Arc cosine of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL __acosl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(acosl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_asinl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_asinl)
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__asinl,(__LONGDOUBLE __x),asinl,{ return __builtin_asinl(__x); })
#elif defined(__CRT_HAVE_asinl)
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__asinl,(__LONGDOUBLE __x),asinl,(__x))
#elif defined(__CRT_HAVE___asinl)
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__asinl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE_asin) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__asinl,(__LONGDOUBLE __x),asin,(__x))
#elif defined(__CRT_HAVE___asin) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__asinl,(__LONGDOUBLE __x),__asin,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_asin) || defined(__CRT_HAVE___asin) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/asinl.h>
/* >> asinf(3), asin(3), asinl(3)
 * Arc sine of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL __asinl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(asinl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_atanl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_atanl)
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__atanl,(__LONGDOUBLE __x),atanl,{ return __builtin_atanl(__x); })
#elif defined(__CRT_HAVE_atanl)
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__atanl,(__LONGDOUBLE __x),atanl,(__x))
#elif defined(__CRT_HAVE___atanl)
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__atanl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE_atan) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__atanl,(__LONGDOUBLE __x),atan,(__x))
#elif defined(__CRT_HAVE___atan) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__atanl,(__LONGDOUBLE __x),__atan,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_atan) || defined(__CRT_HAVE___atan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/atanl.h>
/* >> atanf(3), atan(3), atanl(3)
 * Arc tangent of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL __atanl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(atanl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_atan2l) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_atan2l)
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__atan2l,(__LONGDOUBLE __y, __LONGDOUBLE __x),atan2l,{ return __builtin_atan2l(__y, __x); })
#elif defined(__CRT_HAVE_atan2l)
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__atan2l,(__LONGDOUBLE __y, __LONGDOUBLE __x),atan2l,(__y,__x))
#elif defined(__CRT_HAVE___atan2l)
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__atan2l,(__LONGDOUBLE __y, __LONGDOUBLE __x),(__y,__x))
#elif defined(__CRT_HAVE_atan2) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__atan2l,(__LONGDOUBLE __y, __LONGDOUBLE __x),atan2,(__y,__x))
#elif defined(__CRT_HAVE___atan2) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__atan2l,(__LONGDOUBLE __y, __LONGDOUBLE __x),__atan2,(__y,__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_atan2) || defined(__CRT_HAVE___atan2) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/atan2l.h>
/* >> atan2f(3), atan2(3), atan2l(3)
 * Arc tangent of `y / x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL __atan2l)(__LONGDOUBLE __y, __LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(atan2l))(__y, __x); }
#endif /* ... */
#if __has_builtin(__builtin_cosl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_cosl)
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__CEIREDIRECT(__ATTR_WUNUSED __DECL_SIMD_cosl,__LONGDOUBLE,__NOTHROW,__cosl,(__LONGDOUBLE __x),cosl,{ return __builtin_cosl(__x); })
#elif defined(__CRT_HAVE_cosl)
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_cosl,__LONGDOUBLE,__NOTHROW,__cosl,(__LONGDOUBLE __x),cosl,(__x))
#elif defined(__CRT_HAVE___cosl)
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__CDECLARE(__ATTR_WUNUSED __DECL_SIMD_cosl,__LONGDOUBLE,__NOTHROW,__cosl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE_cos) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_cosl,__LONGDOUBLE,__NOTHROW,__cosl,(__LONGDOUBLE __x),cos,(__x))
#elif defined(__CRT_HAVE___cos) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_cosl,__LONGDOUBLE,__NOTHROW,__cosl,(__LONGDOUBLE __x),__cos,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_cos) || defined(__CRT_HAVE___cos) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/cosl.h>
/* >> cosf(3), cos(3), cosl(3)
 * Cosine of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_cosl __LONGDOUBLE __NOTHROW(__LIBCCALL __cosl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(cosl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_sinl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_sinl)
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__CEIREDIRECT(__ATTR_WUNUSED __DECL_SIMD_sinl,__LONGDOUBLE,__NOTHROW,__sinl,(__LONGDOUBLE __x),sinl,{ return __builtin_sinl(__x); })
#elif defined(__CRT_HAVE_sinl)
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_sinl,__LONGDOUBLE,__NOTHROW,__sinl,(__LONGDOUBLE __x),sinl,(__x))
#elif defined(__CRT_HAVE___sinl)
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__CDECLARE(__ATTR_WUNUSED __DECL_SIMD_sinl,__LONGDOUBLE,__NOTHROW,__sinl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE_sin) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_sinl,__LONGDOUBLE,__NOTHROW,__sinl,(__LONGDOUBLE __x),sin,(__x))
#elif defined(__CRT_HAVE___sin) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_sinl,__LONGDOUBLE,__NOTHROW,__sinl,(__LONGDOUBLE __x),__sin,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_sin) || defined(__CRT_HAVE___sin) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/sinl.h>
/* >> sinf(3), sin(3), sinl(3)
 * Sine of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_sinl __LONGDOUBLE __NOTHROW(__LIBCCALL __sinl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(sinl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_tanl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_tanl)
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__tanl,(__LONGDOUBLE __x),tanl,{ return __builtin_tanl(__x); })
#elif defined(__CRT_HAVE_tanl)
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__tanl,(__LONGDOUBLE __x),tanl,(__x))
#elif defined(__CRT_HAVE___tanl)
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__tanl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE_tan) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__tanl,(__LONGDOUBLE __x),tan,(__x))
#elif defined(__CRT_HAVE___tan) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__tanl,(__LONGDOUBLE __x),__tan,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_tan) || defined(__CRT_HAVE___tan) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/tanl.h>
/* >> tanf(3), tan(3), tanl(3)
 * Tangent of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL __tanl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(tanl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_coshl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_coshl)
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__coshl,(__LONGDOUBLE __x),coshl,{ return __builtin_coshl(__x); })
#elif defined(__CRT_HAVE_coshl)
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__coshl,(__LONGDOUBLE __x),coshl,(__x))
#elif defined(__CRT_HAVE___coshl)
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__coshl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE_cosh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__coshl,(__LONGDOUBLE __x),cosh,(__x))
#elif defined(__CRT_HAVE___cosh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__coshl,(__LONGDOUBLE __x),__cosh,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_cosh) || defined(__CRT_HAVE___cosh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/coshl.h>
/* >> coshf(3), cosh(3), coshl(3)
 * Hyperbolic   cosine   of   `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL __coshl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(coshl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_sinhl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_sinhl)
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__sinhl,(__LONGDOUBLE __x),sinhl,{ return __builtin_sinhl(__x); })
#elif defined(__CRT_HAVE_sinhl)
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__sinhl,(__LONGDOUBLE __x),sinhl,(__x))
#elif defined(__CRT_HAVE___sinhl)
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__sinhl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE_sinh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__sinhl,(__LONGDOUBLE __x),sinh,(__x))
#elif defined(__CRT_HAVE___sinh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__sinhl,(__LONGDOUBLE __x),__sinh,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_sinh) || defined(__CRT_HAVE___sinh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/sinhl.h>
/* >> sinhf(3), sinh(3), sinhl(3)
 * Hyperbolic sine of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL __sinhl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(sinhl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_tanhl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_tanhl)
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__tanhl,(__LONGDOUBLE __x),tanhl,{ return __builtin_tanhl(__x); })
#elif defined(__CRT_HAVE_tanhl)
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__tanhl,(__LONGDOUBLE __x),tanhl,(__x))
#elif defined(__CRT_HAVE___tanhl)
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__tanhl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE_tanh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__tanhl,(__LONGDOUBLE __x),tanh,(__x))
#elif defined(__CRT_HAVE___tanh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__tanhl,(__LONGDOUBLE __x),__tanh,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_tanh) || defined(__CRT_HAVE___tanh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/tanhl.h>
/* >> tanhf(3), tanh(3), tanhl(3)
 * Hyperbolic   tangent   of  `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL __tanhl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(tanhl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_expl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_expl)
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__CEIREDIRECT(__ATTR_WUNUSED __DECL_SIMD_expl,__LONGDOUBLE,__NOTHROW,__expl,(__LONGDOUBLE __x),expl,{ return __builtin_expl(__x); })
#elif defined(__CRT_HAVE_expl)
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_expl,__LONGDOUBLE,__NOTHROW,__expl,(__LONGDOUBLE __x),expl,(__x))
#elif defined(__CRT_HAVE___expl)
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__CDECLARE(__ATTR_WUNUSED __DECL_SIMD_expl,__LONGDOUBLE,__NOTHROW,__expl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE_exp) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_expl,__LONGDOUBLE,__NOTHROW,__expl,(__LONGDOUBLE __x),exp,(__x))
#elif defined(__CRT_HAVE___exp) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_expl,__LONGDOUBLE,__NOTHROW,__expl,(__LONGDOUBLE __x),__exp,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_exp) || defined(__CRT_HAVE___exp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/expl.h>
/* >> expf(3), exp(3), expl(3)
 * Exponential function of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_expl __LONGDOUBLE __NOTHROW(__LIBCCALL __expl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(expl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_frexpl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_frexpl)
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__CEIREDIRECT(__ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,__frexpl,(__LONGDOUBLE __x, int *__pexponent),frexpl,{ return __builtin_frexpl(__x, __pexponent); })
#elif defined(__CRT_HAVE_frexpl)
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__CREDIRECT(__ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,__frexpl,(__LONGDOUBLE __x, int *__pexponent),frexpl,(__x,__pexponent))
#elif defined(__CRT_HAVE___frexpl)
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__CDECLARE(__ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,__frexpl,(__LONGDOUBLE __x, int *__pexponent),(__x,__pexponent))
#elif defined(__CRT_HAVE_frexp) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__CREDIRECT(__ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,__frexpl,(__LONGDOUBLE __x, int *__pexponent),frexp,(__x,__pexponent))
#elif defined(__CRT_HAVE___frexp) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__CREDIRECT(__ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,__frexpl,(__LONGDOUBLE __x, int *__pexponent),__frexp,(__x,__pexponent))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_frexp) || defined(__CRT_HAVE___frexp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/frexpl.h>
/* >> frexpf(3), frexp(3), frexpl(3)
 * Break `value' into a normalized fraction and an integral power of 2 */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_OUT(2) __LONGDOUBLE __NOTHROW_NCX(__LIBCCALL __frexpl)(__LONGDOUBLE __x, int *__pexponent) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(frexpl))(__x, __pexponent); }
#endif /* ... */
#if __has_builtin(__builtin_ldexpl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_ldexpl)
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__ldexpl,(__LONGDOUBLE __x, int __exponent),ldexpl,{ return __builtin_ldexpl(__x, __exponent); })
#elif defined(__CRT_HAVE_ldexpl)
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__ldexpl,(__LONGDOUBLE __x, int __exponent),ldexpl,(__x,__exponent))
#elif defined(__CRT_HAVE___ldexpl)
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__ldexpl,(__LONGDOUBLE __x, int __exponent),(__x,__exponent))
#elif defined(__CRT_HAVE_ldexp) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__ldexpl,(__LONGDOUBLE __x, int __exponent),ldexp,(__x,__exponent))
#elif defined(__CRT_HAVE___ldexp) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__ldexpl,(__LONGDOUBLE __x, int __exponent),__ldexp,(__x,__exponent))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_ldexp) || defined(__CRT_HAVE___ldexp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/ldexpl.h>
/* >> ldexpf(3), ldexp(3), ldexpl(3)
 * `x' times (two to the `exponent' power) */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL __ldexpl)(__LONGDOUBLE __x, int __exponent) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(ldexpl))(__x, __exponent); }
#endif /* ... */
#if __has_builtin(__builtin_logl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_logl)
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__CEIREDIRECT(__ATTR_WUNUSED __DECL_SIMD_logl,__LONGDOUBLE,__NOTHROW,__logl,(__LONGDOUBLE __x),logl,{ return __builtin_logl(__x); })
#elif defined(__CRT_HAVE_logl)
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_logl,__LONGDOUBLE,__NOTHROW,__logl,(__LONGDOUBLE __x),logl,(__x))
#elif defined(__CRT_HAVE___logl)
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__CDECLARE(__ATTR_WUNUSED __DECL_SIMD_logl,__LONGDOUBLE,__NOTHROW,__logl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE_log) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_logl,__LONGDOUBLE,__NOTHROW,__logl,(__LONGDOUBLE __x),log,(__x))
#elif defined(__CRT_HAVE___log) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_logl,__LONGDOUBLE,__NOTHROW,__logl,(__LONGDOUBLE __x),__log,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_log) || defined(__CRT_HAVE___log) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/logl.h>
/* >> logf(3), log(3), logl(3)
 * Natural  logarithm  of  `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_logl __LONGDOUBLE __NOTHROW(__LIBCCALL __logl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(logl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_log10l) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_log10l)
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__log10l,(__LONGDOUBLE __x),log10l,{ return __builtin_log10l(__x); })
#elif defined(__CRT_HAVE_log10l)
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__log10l,(__LONGDOUBLE __x),log10l,(__x))
#elif defined(__CRT_HAVE___log10l)
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__log10l,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE_log10) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__log10l,(__LONGDOUBLE __x),log10,(__x))
#elif defined(__CRT_HAVE___log10) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__log10l,(__LONGDOUBLE __x),__log10,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_log10) || defined(__CRT_HAVE___log10) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/log10l.h>
/* >> log10f(3), log10(3), log10l(3)
 * Base-ten    logarithm    of   `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL __log10l)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(log10l))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_modfl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_modfl)
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__CEIREDIRECT(__ATTR_WUNUSED __ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,__modfl,(__LONGDOUBLE __x, __LONGDOUBLE *__iptr),modfl,{ return __builtin_modfl(__x, __iptr); })
#elif defined(__CRT_HAVE_modfl)
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,__modfl,(__LONGDOUBLE __x, __LONGDOUBLE *__iptr),modfl,(__x,__iptr))
#elif defined(__CRT_HAVE___modfl)
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__CDECLARE(__ATTR_WUNUSED __ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,__modfl,(__LONGDOUBLE __x, __LONGDOUBLE *__iptr),(__x,__iptr))
#elif defined(__CRT_HAVE_modf) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,__modfl,(__LONGDOUBLE __x, __LONGDOUBLE *__iptr),modf,(__x,__iptr))
#elif defined(__CRT_HAVE___modf) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(2),__LONGDOUBLE,__NOTHROW_NCX,__modfl,(__LONGDOUBLE __x, __LONGDOUBLE *__iptr),__modf,(__x,__iptr))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_modf) || defined(__CRT_HAVE___modf) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/modfl.h>
/* >> modff(3), modf(3), modfl(3)
 * Break `value' into integral and fractional parts */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __ATTR_OUT(2) __LONGDOUBLE __NOTHROW_NCX(__LIBCCALL __modfl)(__LONGDOUBLE __x, __LONGDOUBLE *__iptr) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(modfl))(__x, __iptr); }
#endif /* ... */
#if __has_builtin(__builtin_powl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_powl)
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__CEIREDIRECT(__ATTR_WUNUSED __DECL_SIMD_powl,__LONGDOUBLE,__NOTHROW,__powl,(__LONGDOUBLE __x, __LONGDOUBLE __y),powl,{ return __builtin_powl(__x, __y); })
#elif defined(__CRT_HAVE_powl)
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_powl,__LONGDOUBLE,__NOTHROW,__powl,(__LONGDOUBLE __x, __LONGDOUBLE __y),powl,(__x,__y))
#elif defined(__CRT_HAVE___powl)
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__CDECLARE(__ATTR_WUNUSED __DECL_SIMD_powl,__LONGDOUBLE,__NOTHROW,__powl,(__LONGDOUBLE __x, __LONGDOUBLE __y),(__x,__y))
#elif defined(__CRT_HAVE_pow) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_powl,__LONGDOUBLE,__NOTHROW,__powl,(__LONGDOUBLE __x, __LONGDOUBLE __y),pow,(__x,__y))
#elif defined(__CRT_HAVE___pow) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__CREDIRECT(__ATTR_WUNUSED __DECL_SIMD_powl,__LONGDOUBLE,__NOTHROW,__powl,(__LONGDOUBLE __x, __LONGDOUBLE __y),__pow,(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_pow) || defined(__CRT_HAVE___pow) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/powl.h>
/* >> powf(3), pow(3), powl(3)
 * Return `x' to the `y' power */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __DECL_SIMD_powl __LONGDOUBLE __NOTHROW(__LIBCCALL __powl)(__LONGDOUBLE __x, __LONGDOUBLE __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(powl))(__x, __y); }
#endif /* ... */
#if __has_builtin(__builtin_sqrtl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_sqrtl)
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__sqrtl,(__LONGDOUBLE __x),sqrtl,{ return __builtin_sqrtl(__x); })
#elif defined(__CRT_HAVE_sqrtl)
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__sqrtl,(__LONGDOUBLE __x),sqrtl,(__x))
#elif defined(__CRT_HAVE___sqrtl)
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__sqrtl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE_sqrt) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__sqrtl,(__LONGDOUBLE __x),sqrt,(__x))
#elif defined(__CRT_HAVE___sqrt) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__sqrtl,(__LONGDOUBLE __x),__sqrt,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_sqrt) || defined(__CRT_HAVE___sqrt) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/sqrtl.h>
/* >> sqrtf(3), sqrt(3), sqrtl(3)
 * Return the square root of  `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL __sqrtl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(sqrtl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_ceill) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_ceill)
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__ceill,(__LONGDOUBLE __x),ceill,{ return __builtin_ceill(__x); })
#elif defined(__CRT_HAVE_ceill)
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__ceill,(__LONGDOUBLE __x),ceill,(__x))
#elif defined(__CRT_HAVE___ceill)
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__ceill,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE_ceil) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__ceill,(__LONGDOUBLE __x),ceil,(__x))
#elif defined(__CRT_HAVE___ceil) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__ceill,(__LONGDOUBLE __x),__ceil,(__x))
#else /* ... */
#include <libc/local/math/ceill.h>
/* >> ceilf(3), ceil(3), ceill(3)
 * Smallest integral value not less than `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL __ceill)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(ceill))(__x); }
#endif /* !... */
#if __has_builtin(__builtin_fabsl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fabsl)
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__fabsl,(__LONGDOUBLE __x),fabsl,{ return __builtin_fabsl(__x); })
#elif defined(__CRT_HAVE_fabsl)
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__fabsl,(__LONGDOUBLE __x),fabsl,(__x))
#elif defined(__CRT_HAVE___fabsl)
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__fabsl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE_fabs) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__fabsl,(__LONGDOUBLE __x),fabs,(__x))
#elif defined(__CRT_HAVE___fabs) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__fabsl,(__LONGDOUBLE __x),__fabs,(__x))
#else /* ... */
#include <libc/local/math/fabsl.h>
/* >> fabsf(3), fabs(3), fabsl(3)
 * Absolute value of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL __fabsl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fabsl))(__x); }
#endif /* !... */
#if __has_builtin(__builtin_floorl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_floorl)
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__floorl,(__LONGDOUBLE __x),floorl,{ return __builtin_floorl(__x); })
#elif defined(__CRT_HAVE_floorl)
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__floorl,(__LONGDOUBLE __x),floorl,(__x))
#elif defined(__CRT_HAVE___floorl)
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__floorl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE_floor) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__floorl,(__LONGDOUBLE __x),floor,(__x))
#elif defined(__CRT_HAVE___floor) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__floorl,(__LONGDOUBLE __x),__floor,(__x))
#else /* ... */
#include <libc/local/math/floorl.h>
/* >> floorf(3), floor(3), floorl(3)
 * Largest integer not greater than `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL __floorl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(floorl))(__x); }
#endif /* !... */
#if __has_builtin(__builtin_fmodl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fmodl)
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__fmodl,(__LONGDOUBLE __x, __LONGDOUBLE __y),fmodl,{ return __builtin_fmodl(__x, __y); })
#elif defined(__CRT_HAVE_fmodl)
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__fmodl,(__LONGDOUBLE __x, __LONGDOUBLE __y),fmodl,(__x,__y))
#elif defined(__CRT_HAVE___fmodl)
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__fmodl,(__LONGDOUBLE __x, __LONGDOUBLE __y),(__x,__y))
#elif defined(__CRT_HAVE_fmod) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__fmodl,(__LONGDOUBLE __x, __LONGDOUBLE __y),fmod,(__x,__y))
#elif defined(__CRT_HAVE___fmod) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__fmodl,(__LONGDOUBLE __x, __LONGDOUBLE __y),__fmod,(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_fmod) || defined(__CRT_HAVE___fmod) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/fmodl.h>
/* >> fmodf(3), fmod(3), fmodl(3)
 * Floating-point modulo remainder of `x / y' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL __fmodl)(__LONGDOUBLE __x, __LONGDOUBLE __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fmodl))(__x, __y); }
#endif /* ... */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#ifdef __USE_GNU
#if __has_builtin(__builtin_sincos) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_sincos)
/* >> sincosf(3), sincos(3), sincosl(3)
 * Calculate both sine (*psinx) and cosine (*pcosx) of `x' */
__CEIREDIRECT(__DECL_SIMD_sincos __ATTR_OUT(2) __ATTR_OUT(3),void,__NOTHROW,__sincos,(double __x, double *__psinx, double *__pcosx),sincos,{ __builtin_sincos(__x, __psinx, __pcosx); })
#elif defined(__CRT_HAVE_sincos)
/* >> sincosf(3), sincos(3), sincosl(3)
 * Calculate both sine (*psinx) and cosine (*pcosx) of `x' */
__CREDIRECT_VOID(__DECL_SIMD_sincos __ATTR_OUT(2) __ATTR_OUT(3),__NOTHROW,__sincos,(double __x, double *__psinx, double *__pcosx),sincos,(__x,__psinx,__pcosx))
#elif defined(__CRT_HAVE___sincos)
/* >> sincosf(3), sincos(3), sincosl(3)
 * Calculate both sine (*psinx) and cosine (*pcosx) of `x' */
__CDECLARE_VOID(__DECL_SIMD_sincos __ATTR_OUT(2) __ATTR_OUT(3),__NOTHROW,__sincos,(double __x, double *__psinx, double *__pcosx),(__x,__psinx,__pcosx))
#elif ((defined(__CRT_HAVE_sin) || defined(__CRT_HAVE___sin)) && (defined(__CRT_HAVE_cos) || defined(__CRT_HAVE___cos))) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/sincos.h>
/* >> sincosf(3), sincos(3), sincosl(3)
 * Calculate both sine (*psinx) and cosine (*pcosx) of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __DECL_SIMD_sincos __ATTR_OUT(2) __ATTR_OUT(3) void __NOTHROW(__LIBCCALL __sincos)(double __x, double *__psinx, double *__pcosx) { (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(sincos))(__x, __psinx, __pcosx); }
#endif /* ... */
#if __has_builtin(__builtin_exp10) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_exp10)
/* >> exp10f(3), exp10(3), exp10l(3)
 * A function missing in all standards: compute exponent to base ten */
__CEIREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__exp10,(double __x),exp10,{ return __builtin_exp10(__x); })
#elif defined(__CRT_HAVE_exp10)
/* >> exp10f(3), exp10(3), exp10l(3)
 * A function missing in all standards: compute exponent to base ten */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__exp10,(double __x),exp10,(__x))
#elif defined(__CRT_HAVE___exp10)
/* >> exp10f(3), exp10(3), exp10l(3)
 * A function missing in all standards: compute exponent to base ten */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,__exp10,(double __x),(__x))
#elif defined(__CRT_HAVE_exp) || defined(__CRT_HAVE___exp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/exp10.h>
/* >> exp10f(3), exp10(3), exp10l(3)
 * A function missing in all standards: compute exponent to base ten */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __exp10)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(exp10))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_pow10) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_pow10)
/* >> pow10f(3), pow10(3), pow10l(3)
 * Another  name  occasionally  used */
__CEIREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__pow10,(double __x),pow10,{ return __builtin_pow10(__x); })
#elif defined(__CRT_HAVE_pow10)
/* >> pow10f(3), pow10(3), pow10l(3)
 * Another  name  occasionally  used */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__pow10,(double __x),pow10,(__x))
#elif defined(__CRT_HAVE___pow10)
/* >> pow10f(3), pow10(3), pow10l(3)
 * Another  name  occasionally  used */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,__pow10,(double __x),(__x))
#elif defined(__CRT_HAVE_pow) || defined(__CRT_HAVE___pow) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/pow10.h>
/* >> pow10f(3), pow10(3), pow10l(3)
 * Another  name  occasionally  used */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __pow10)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(pow10))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_sincosf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_sincosf)
/* >> sincosf(3), sincos(3), sincosl(3)
 * Calculate both sine (*psinx) and cosine (*pcosx) of `x' */
__CEIREDIRECT(__DECL_SIMD_sincosf __ATTR_OUT(2) __ATTR_OUT(3),void,__NOTHROW,__sincosf,(float __x, float *__psinx, float *__pcosx),sincosf,{ __builtin_sincosf(__x, __psinx, __pcosx); })
#elif defined(__CRT_HAVE_sincosf)
/* >> sincosf(3), sincos(3), sincosl(3)
 * Calculate both sine (*psinx) and cosine (*pcosx) of `x' */
__CREDIRECT_VOID(__DECL_SIMD_sincosf __ATTR_OUT(2) __ATTR_OUT(3),__NOTHROW,__sincosf,(float __x, float *__psinx, float *__pcosx),sincosf,(__x,__psinx,__pcosx))
#elif defined(__CRT_HAVE___sincosf)
/* >> sincosf(3), sincos(3), sincosl(3)
 * Calculate both sine (*psinx) and cosine (*pcosx) of `x' */
__CDECLARE_VOID(__DECL_SIMD_sincosf __ATTR_OUT(2) __ATTR_OUT(3),__NOTHROW,__sincosf,(float __x, float *__psinx, float *__pcosx),(__x,__psinx,__pcosx))
#elif defined(__CRT_HAVE_sincos) || defined(__CRT_HAVE___sincos) || ((defined(__CRT_HAVE_sin) || defined(__CRT_HAVE___sin)) && (defined(__CRT_HAVE_cos) || defined(__CRT_HAVE___cos))) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__) || ((defined(__CRT_HAVE_sinf) || defined(__CRT_HAVE___sinf) || defined(__CRT_HAVE_sin) || defined(__CRT_HAVE___sin)) && (defined(__CRT_HAVE_cosf) || defined(__CRT_HAVE___cosf) || defined(__CRT_HAVE_cos) || defined(__CRT_HAVE___cos))) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__)
#include <libc/local/math/sincosf.h>
/* >> sincosf(3), sincos(3), sincosl(3)
 * Calculate both sine (*psinx) and cosine (*pcosx) of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __DECL_SIMD_sincosf __ATTR_OUT(2) __ATTR_OUT(3) void __NOTHROW(__LIBCCALL __sincosf)(float __x, float *__psinx, float *__pcosx) { (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(sincosf))(__x, __psinx, __pcosx); }
#endif /* ... */
#if __has_builtin(__builtin_exp10f) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_exp10f)
/* >> exp10f(3), exp10(3), exp10l(3)
 * A function missing in all standards: compute exponent to base ten */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__exp10f,(float __x),exp10f,{ return __builtin_exp10f(__x); })
#elif defined(__CRT_HAVE_exp10f)
/* >> exp10f(3), exp10(3), exp10l(3)
 * A function missing in all standards: compute exponent to base ten */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__exp10f,(float __x),exp10f,(__x))
#elif defined(__CRT_HAVE___exp10f)
/* >> exp10f(3), exp10(3), exp10l(3)
 * A function missing in all standards: compute exponent to base ten */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,__exp10f,(float __x),(__x))
#elif defined(__CRT_HAVE_exp) || defined(__CRT_HAVE___exp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/exp10f.h>
/* >> exp10f(3), exp10(3), exp10l(3)
 * A function missing in all standards: compute exponent to base ten */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL __exp10f)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(exp10f))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_pow10f) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_pow10f)
/* >> pow10f(3), pow10(3), pow10l(3)
 * Another  name  occasionally  used */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__pow10f,(float __x),pow10f,{ return __builtin_pow10f(__x); })
#elif defined(__CRT_HAVE_pow10f)
/* >> pow10f(3), pow10(3), pow10l(3)
 * Another  name  occasionally  used */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__pow10f,(float __x),pow10f,(__x))
#elif defined(__CRT_HAVE___pow10f)
/* >> pow10f(3), pow10(3), pow10l(3)
 * Another  name  occasionally  used */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,__pow10f,(float __x),(__x))
#elif defined(__CRT_HAVE_powf) || defined(__CRT_HAVE___powf) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_pow10) || defined(__CRT_HAVE___pow10) || defined(__CRT_HAVE_pow) || defined(__CRT_HAVE___pow) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/pow10f.h>
/* >> pow10f(3), pow10(3), pow10l(3)
 * Another  name  occasionally  used */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL __pow10f)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(pow10f))(__x); }
#endif /* ... */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if __has_builtin(__builtin_sincosl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_sincosl)
/* >> sincosf(3), sincos(3), sincosl(3)
 * Calculate both sine (*psinx) and cosine (*pcosx) of `x' */
__CEIREDIRECT(__DECL_SIMD_sincosl __ATTR_OUT(2) __ATTR_OUT(3),void,__NOTHROW,__sincosl,(__LONGDOUBLE __x, __LONGDOUBLE *__psinx, __LONGDOUBLE *__pcosx),sincosl,{ __builtin_sincosl(__x, __psinx, __pcosx); })
#elif defined(__CRT_HAVE_sincosl)
/* >> sincosf(3), sincos(3), sincosl(3)
 * Calculate both sine (*psinx) and cosine (*pcosx) of `x' */
__CREDIRECT_VOID(__DECL_SIMD_sincosl __ATTR_OUT(2) __ATTR_OUT(3),__NOTHROW,__sincosl,(__LONGDOUBLE __x, __LONGDOUBLE *__psinx, __LONGDOUBLE *__pcosx),sincosl,(__x,__psinx,__pcosx))
#elif defined(__CRT_HAVE___sincosl)
/* >> sincosf(3), sincos(3), sincosl(3)
 * Calculate both sine (*psinx) and cosine (*pcosx) of `x' */
__CDECLARE_VOID(__DECL_SIMD_sincosl __ATTR_OUT(2) __ATTR_OUT(3),__NOTHROW,__sincosl,(__LONGDOUBLE __x, __LONGDOUBLE *__psinx, __LONGDOUBLE *__pcosx),(__x,__psinx,__pcosx))
#elif defined(__CRT_HAVE___sincos) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> sincosf(3), sincos(3), sincosl(3)
 * Calculate both sine (*psinx) and cosine (*pcosx) of `x' */
__CREDIRECT_VOID(__DECL_SIMD_sincosl __ATTR_OUT(2) __ATTR_OUT(3),__NOTHROW,__sincosl,(__LONGDOUBLE __x, __LONGDOUBLE *__psinx, __LONGDOUBLE *__pcosx),__sincos,(__x,__psinx,__pcosx))
#elif defined(__CRT_HAVE_sincos) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> sincosf(3), sincos(3), sincosl(3)
 * Calculate both sine (*psinx) and cosine (*pcosx) of `x' */
__CREDIRECT_VOID(__DECL_SIMD_sincosl __ATTR_OUT(2) __ATTR_OUT(3),__NOTHROW,__sincosl,(__LONGDOUBLE __x, __LONGDOUBLE *__psinx, __LONGDOUBLE *__pcosx),sincos,(__x,__psinx,__pcosx))
#elif defined(__CRT_HAVE_sincos) || defined(__CRT_HAVE___sincos) || ((defined(__CRT_HAVE_sin) || defined(__CRT_HAVE___sin)) && (defined(__CRT_HAVE_cos) || defined(__CRT_HAVE___cos))) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__) || ((defined(__CRT_HAVE_sinl) || defined(__CRT_HAVE___sinl) || defined(__CRT_HAVE_sin) || defined(__CRT_HAVE___sin)) && (defined(__CRT_HAVE_cosl) || defined(__CRT_HAVE___cosl) || defined(__CRT_HAVE_cos) || defined(__CRT_HAVE___cos))) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__)
#include <libc/local/math/sincosl.h>
/* >> sincosf(3), sincos(3), sincosl(3)
 * Calculate both sine (*psinx) and cosine (*pcosx) of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __DECL_SIMD_sincosl __ATTR_OUT(2) __ATTR_OUT(3) void __NOTHROW(__LIBCCALL __sincosl)(__LONGDOUBLE __x, __LONGDOUBLE *__psinx, __LONGDOUBLE *__pcosx) { (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(sincosl))(__x, __psinx, __pcosx); }
#endif /* ... */
#if __has_builtin(__builtin_exp10l) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_exp10l)
/* >> exp10f(3), exp10(3), exp10l(3)
 * A function missing in all standards: compute exponent to base ten */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__exp10l,(__LONGDOUBLE __x),exp10l,{ return __builtin_exp10l(__x); })
#elif defined(__CRT_HAVE_exp10l)
/* >> exp10f(3), exp10(3), exp10l(3)
 * A function missing in all standards: compute exponent to base ten */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__exp10l,(__LONGDOUBLE __x),exp10l,(__x))
#elif defined(__CRT_HAVE___exp10l)
/* >> exp10f(3), exp10(3), exp10l(3)
 * A function missing in all standards: compute exponent to base ten */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__exp10l,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE_expl) || defined(__CRT_HAVE___expl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_exp) || defined(__CRT_HAVE___exp) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/exp10l.h>
/* >> exp10f(3), exp10(3), exp10l(3)
 * A function missing in all standards: compute exponent to base ten */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL __exp10l)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(exp10l))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_pow10l) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_pow10l)
/* >> pow10f(3), pow10(3), pow10l(3)
 * Another  name  occasionally  used */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__pow10l,(__LONGDOUBLE __x),pow10l,{ return __builtin_pow10l(__x); })
#elif defined(__CRT_HAVE_pow10l)
/* >> pow10f(3), pow10(3), pow10l(3)
 * Another  name  occasionally  used */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__pow10l,(__LONGDOUBLE __x),pow10l,(__x))
#elif defined(__CRT_HAVE___pow10l)
/* >> pow10f(3), pow10(3), pow10l(3)
 * Another  name  occasionally  used */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__pow10l,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE_pow10) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> pow10f(3), pow10(3), pow10l(3)
 * Another  name  occasionally  used */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__pow10l,(__LONGDOUBLE __x),pow10,(__x))
#elif defined(__CRT_HAVE___pow10) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> pow10f(3), pow10(3), pow10l(3)
 * Another  name  occasionally  used */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__pow10l,(__LONGDOUBLE __x),__pow10,(__x))
#elif defined(__CRT_HAVE_powl) || defined(__CRT_HAVE___powl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_pow10) || defined(__CRT_HAVE___pow10) || defined(__CRT_HAVE_pow) || defined(__CRT_HAVE___pow) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/pow10l.h>
/* >> pow10f(3), pow10(3), pow10l(3)
 * Another  name  occasionally  used */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL __pow10l)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(pow10l))(__x); }
#endif /* ... */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_GNU */
#if defined(__USE_XOPEN_EXTENDED) || defined(__USE_ISOC99)
#if __has_builtin(__builtin_acosh) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_acosh)
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__CEIREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__acosh,(double __x),acosh,{ return __builtin_acosh(__x); })
#elif defined(__CRT_HAVE_acosh)
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__acosh,(double __x),acosh,(__x))
#elif defined(__CRT_HAVE___acosh)
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,__acosh,(double __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/acosh.h>
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __acosh)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(acosh))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_asinh) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_asinh)
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__asinh,(double __x),asinh,{ return __builtin_asinh(__x); })
#elif defined(__CRT_HAVE_asinh)
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__asinh,(double __x),asinh,(__x))
#elif defined(__CRT_HAVE___asinh)
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__asinh,(double __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/asinh.h>
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __asinh)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(asinh))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_atanh) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_atanh)
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__CEIREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__atanh,(double __x),atanh,{ return __builtin_atanh(__x); })
#elif defined(__CRT_HAVE_atanh)
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__atanh,(double __x),atanh,(__x))
#elif defined(__CRT_HAVE___atanh)
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,__atanh,(double __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/atanh.h>
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __atanh)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(atanh))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_expm1) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_expm1)
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__CEIREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__expm1,(double __x),expm1,{ return __builtin_expm1(__x); })
#elif defined(__CRT_HAVE_expm1)
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__expm1,(double __x),expm1,(__x))
#elif defined(__CRT_HAVE___expm1)
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,__expm1,(double __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/expm1.h>
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __expm1)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(expm1))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_log1p) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_log1p)
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__CEIREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__log1p,(double __x),log1p,{ return __builtin_log1p(__x); })
#elif defined(__CRT_HAVE_log1p)
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__log1p,(double __x),log1p,(__x))
#elif defined(__CRT_HAVE___log1p)
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,__log1p,(double __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/log1p.h>
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __log1p)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(log1p))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_logb) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_logb)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__logb,(double __x),logb,{ return __builtin_logb(__x); })
#elif defined(__CRT_HAVE_logb)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__logb,(double __x),logb,(__x))
#elif defined(__CRT_HAVE___logb)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__logb,(double __x),(__x))
#elif defined(__CRT_HAVE__logb)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__logb,(double __x),_logb,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/logb.h>
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __logb)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(logb))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_cbrt) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_cbrt)
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__cbrt,(double __x),cbrt,{ return __builtin_cbrt(__x); })
#elif defined(__CRT_HAVE_cbrt)
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__cbrt,(double __x),cbrt,(__x))
#elif defined(__CRT_HAVE___cbrt)
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__cbrt,(double __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/cbrt.h>
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __cbrt)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(cbrt))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_rint) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_rint)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__rint,(double __x),rint,{ return __builtin_rint(__x); })
#elif __has_builtin(__builtin_nearbyint) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nearbyint)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__rint,(double __x),nearbyint,{ return __builtin_nearbyint(__x); })
#elif defined(__CRT_HAVE_rint)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__rint,(double __x),rint,(__x))
#elif defined(__CRT_HAVE_nearbyint)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__rint,(double __x),nearbyint,(__x))
#elif defined(__CRT_HAVE___rint)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__rint,(double __x),(__x))
#elif defined(__CRT_HAVE___nearbyint)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__rint,(double __x),__nearbyint,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/rint.h>
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __rint)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(rint))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_nextafter) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nextafter)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__nextafter,(double __x, double __y),nextafter,{ return __builtin_nextafter(__x, __y); })
#elif __has_builtin(__builtin_nexttoward) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nexttoward)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__nextafter,(double __x, double __y),nexttoward,{ return __builtin_nexttoward(__x); })
#elif defined(__CRT_HAVE_nextafter)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__nextafter,(double __x, double __y),nextafter,(__x,__y))
#elif defined(__CRT_HAVE_nexttoward)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__nextafter,(double __x, double __y),nexttoward,(__x,__y))
#elif defined(__CRT_HAVE___nextafter)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__nextafter,(double __x, double __y),(__x,__y))
#elif defined(__CRT_HAVE__nextafter)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__nextafter,(double __x, double __y),_nextafter,(__x,__y))
#elif defined(__CRT_HAVE___nexttoward)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__nextafter,(double __x, double __y),__nexttoward,(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/nextafter.h>
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __nextafter)(double __x, double __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(nextafter))(__x, __y); }
#endif /* ... */
#if __has_builtin(__builtin_remainder) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_remainder)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CEIREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__remainder,(double __x, double __p),remainder,{ return __builtin_remainder(__x, __p); })
#elif __has_builtin(__builtin_drem) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_drem)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CEIREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__remainder,(double __x, double __p),drem,{ return __builtin_drem(__x, __p); })
#elif defined(__CRT_HAVE_remainder)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__remainder,(double __x, double __p),remainder,(__x,__p))
#elif defined(__CRT_HAVE_drem)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__remainder,(double __x, double __p),drem,(__x,__p))
#elif defined(__CRT_HAVE___remainder)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,__remainder,(double __x, double __p),(__x,__p))
#elif defined(__CRT_HAVE___drem)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__remainder,(double __x, double __p),__drem,(__x,__p))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/remainder.h>
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __remainder)(double __x, double __p) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(remainder))(__x, __p); }
#endif /* ... */
#if __has_builtin(__builtin_ilogb) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_ilogb)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CEIREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,__ilogb,(double __x),ilogb,{ return __builtin_ilogb(__x); })
#elif defined(__CRT_HAVE_ilogb)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,__ilogb,(double __x),ilogb,(__x))
#elif defined(__CRT_HAVE_llogb) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,__ilogb,(double __x),llogb,(__x))
#elif defined(__CRT_HAVE___ilogb)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CDECLARE(__ATTR_WUNUSED,int,__NOTHROW,__ilogb,(double __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__)
#include <libc/local/math/ilogb.h>
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED int __NOTHROW(__LIBCCALL __ilogb)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(ilogb))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_acoshf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_acoshf)
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__acoshf,(float __x),acoshf,{ return __builtin_acoshf(__x); })
#elif defined(__CRT_HAVE_acoshf)
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__acoshf,(float __x),acoshf,(__x))
#elif defined(__CRT_HAVE___acoshf)
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,__acoshf,(float __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_acosh) || defined(__CRT_HAVE___acosh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/acoshf.h>
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL __acoshf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(acoshf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_asinhf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_asinhf)
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__asinhf,(float __x),asinhf,{ return __builtin_asinhf(__x); })
#elif defined(__CRT_HAVE_asinhf)
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__asinhf,(float __x),asinhf,(__x))
#elif defined(__CRT_HAVE___asinhf)
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__asinhf,(float __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_asinh) || defined(__CRT_HAVE___asinh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/asinhf.h>
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL __asinhf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(asinhf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_atanhf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_atanhf)
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__atanhf,(float __x),atanhf,{ return __builtin_atanhf(__x); })
#elif defined(__CRT_HAVE_atanhf)
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__atanhf,(float __x),atanhf,(__x))
#elif defined(__CRT_HAVE___atanhf)
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,__atanhf,(float __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_atanh) || defined(__CRT_HAVE___atanh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/atanhf.h>
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL __atanhf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(atanhf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_expm1f) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_expm1f)
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__expm1f,(float __x),expm1f,{ return __builtin_expm1f(__x); })
#elif defined(__CRT_HAVE_expm1f)
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__expm1f,(float __x),expm1f,(__x))
#elif defined(__CRT_HAVE___expm1f)
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,__expm1f,(float __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_expm1) || defined(__CRT_HAVE___expm1) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/expm1f.h>
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL __expm1f)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(expm1f))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_log1pf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_log1pf)
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__log1pf,(float __x),log1pf,{ return __builtin_log1pf(__x); })
#elif defined(__CRT_HAVE_log1pf)
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__log1pf,(float __x),log1pf,(__x))
#elif defined(__CRT_HAVE___log1pf)
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,__log1pf,(float __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_log1p) || defined(__CRT_HAVE___log1p) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/log1pf.h>
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL __log1pf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(log1pf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_logbf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_logbf)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__logbf,(float __x),logbf,{ return __builtin_logbf(__x); })
#elif defined(__CRT_HAVE_logbf)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__logbf,(float __x),logbf,(__x))
#elif defined(__CRT_HAVE___logbf)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__logbf,(float __x),(__x))
#elif defined(__CRT_HAVE__logbf)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__logbf,(float __x),_logbf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_logb) || defined(__CRT_HAVE___logb) || defined(__CRT_HAVE__logb) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/logbf.h>
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL __logbf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(logbf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_cbrtf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_cbrtf)
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__cbrtf,(float __x),cbrtf,{ return __builtin_cbrtf(__x); })
#elif defined(__CRT_HAVE_cbrtf)
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__cbrtf,(float __x),cbrtf,(__x))
#elif defined(__CRT_HAVE___cbrtf)
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__cbrtf,(float __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_cbrt) || defined(__CRT_HAVE___cbrt) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/cbrtf.h>
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL __cbrtf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(cbrtf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_rintf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_rintf)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__rintf,(float __x),rintf,{ return __builtin_rintf(__x); })
#elif __has_builtin(__builtin_nearbyintf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nearbyintf)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__rintf,(float __x),nearbyintf,{ return __builtin_nearbyintf(__x); })
#elif defined(__CRT_HAVE_rintf)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__rintf,(float __x),rintf,(__x))
#elif defined(__CRT_HAVE_nearbyintf)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__rintf,(float __x),nearbyintf,(__x))
#elif defined(__CRT_HAVE___rintf)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__rintf,(float __x),(__x))
#elif defined(__CRT_HAVE___nearbyintf)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__rintf,(float __x),__nearbyintf,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_rint) || defined(__CRT_HAVE_nearbyint) || defined(__CRT_HAVE___rint) || defined(__CRT_HAVE___nearbyint) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/rintf.h>
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL __rintf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(rintf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_nextafterf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nextafterf)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__nextafterf,(float __x, float __y),nextafterf,{ return __builtin_nextafterf(__x, __y); })
#elif __has_builtin(__builtin_nexttowardf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nexttowardf)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__nextafterf,(float __x, float __y),nexttowardf,{ return __builtin_nexttowardf(__x); })
#elif defined(__CRT_HAVE_nextafterf)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__nextafterf,(float __x, float __y),nextafterf,(__x,__y))
#elif defined(__CRT_HAVE_nexttowardf)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__nextafterf,(float __x, float __y),nexttowardf,(__x,__y))
#elif defined(__CRT_HAVE___nextafterf)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__nextafterf,(float __x, float __y),(__x,__y))
#elif defined(__CRT_HAVE___nexttowardf)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__nextafterf,(float __x, float __y),__nexttowardf,(__x,__y))
#elif defined(__CRT_HAVE__nextafterf)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__nextafterf,(float __x, float __y),_nextafterf,(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_nextafter) || defined(__CRT_HAVE_nexttoward) || defined(__CRT_HAVE___nextafter) || defined(__CRT_HAVE__nextafter) || defined(__CRT_HAVE___nexttoward) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/nextafterf.h>
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL __nextafterf)(float __x, float __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(nextafterf))(__x, __y); }
#endif /* ... */
#if __has_builtin(__builtin_remainderf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_remainderf)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__remainderf,(float __x, float __p),remainderf,{ return __builtin_remainderf(__x, __p); })
#elif __has_builtin(__builtin_dremf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_dremf)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__remainderf,(float __x, float __p),dremf,{ return __builtin_dremf(__x, __p); })
#elif defined(__CRT_HAVE_remainderf)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__remainderf,(float __x, float __p),remainderf,(__x,__p))
#elif defined(__CRT_HAVE_dremf)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__remainderf,(float __x, float __p),dremf,(__x,__p))
#elif defined(__CRT_HAVE___remainderf)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,__remainderf,(float __x, float __p),(__x,__p))
#elif defined(__CRT_HAVE___dremf)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__remainderf,(float __x, float __p),__dremf,(__x,__p))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_remainder) || defined(__CRT_HAVE_drem) || defined(__CRT_HAVE___remainder) || defined(__CRT_HAVE___drem) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/remainderf.h>
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL __remainderf)(float __x, float __p) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(remainderf))(__x, __p); }
#endif /* ... */
#if __has_builtin(__builtin_ilogbf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_ilogbf)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CEIREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,__ilogbf,(float __x),ilogbf,{ return __builtin_ilogbf(__x); })
#elif defined(__CRT_HAVE_ilogbf)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,__ilogbf,(float __x),ilogbf,(__x))
#elif defined(__CRT_HAVE_llogbf) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,__ilogbf,(float __x),llogbf,(__x))
#elif defined(__CRT_HAVE___ilogbf)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CDECLARE(__ATTR_WUNUSED,int,__NOTHROW,__ilogbf,(float __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_ilogb) || (defined(__CRT_HAVE_llogb) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__CRT_HAVE___ilogb) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__)
#include <libc/local/math/ilogbf.h>
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED int __NOTHROW(__LIBCCALL __ilogbf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(ilogbf))(__x); }
#endif /* ... */
#ifdef __COMPILER_HAVE_LONGDOUBLE
#if __has_builtin(__builtin_acoshl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_acoshl)
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__acoshl,(__LONGDOUBLE __x),acoshl,{ return __builtin_acoshl(__x); })
#elif defined(__CRT_HAVE_acoshl)
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__acoshl,(__LONGDOUBLE __x),acoshl,(__x))
#elif defined(__CRT_HAVE___acoshl)
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__acoshl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE_acosh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__acoshl,(__LONGDOUBLE __x),acosh,(__x))
#elif defined(__CRT_HAVE___acosh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__acoshl,(__LONGDOUBLE __x),__acosh,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_acosh) || defined(__CRT_HAVE___acosh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/acoshl.h>
/* >> acoshf(3), acosh(3), acoshl(3)
 * Hyperbolic  arc  cosine  of   `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL __acoshl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(acoshl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_asinhl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_asinhl)
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__asinhl,(__LONGDOUBLE __x),asinhl,{ return __builtin_asinhl(__x); })
#elif defined(__CRT_HAVE_asinhl)
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__asinhl,(__LONGDOUBLE __x),asinhl,(__x))
#elif defined(__CRT_HAVE___asinhl)
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__asinhl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE_asinh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__asinhl,(__LONGDOUBLE __x),asinh,(__x))
#elif defined(__CRT_HAVE___asinh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__asinhl,(__LONGDOUBLE __x),__asinh,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_asinh) || defined(__CRT_HAVE___asinh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/asinhl.h>
/* >> asinhf(3), asinh(3), asinhl(3)
 * Hyperbolic  arc   sine   of   `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL __asinhl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(asinhl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_atanhl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_atanhl)
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__atanhl,(__LONGDOUBLE __x),atanhl,{ return __builtin_atanhl(__x); })
#elif defined(__CRT_HAVE_atanhl)
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__atanhl,(__LONGDOUBLE __x),atanhl,(__x))
#elif defined(__CRT_HAVE___atanhl)
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__atanhl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE_atanh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__atanhl,(__LONGDOUBLE __x),atanh,(__x))
#elif defined(__CRT_HAVE___atanh) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__atanhl,(__LONGDOUBLE __x),__atanh,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_atanh) || defined(__CRT_HAVE___atanh) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/atanhl.h>
/* >> atanhf(3), atanh(3), atanhl(3)
 * Hyperbolic  arc  tangent  of  `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL __atanhl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(atanhl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_expm1l) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_expm1l)
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__expm1l,(__LONGDOUBLE __x),expm1l,{ return __builtin_expm1l(__x); })
#elif defined(__CRT_HAVE_expm1l)
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__expm1l,(__LONGDOUBLE __x),expm1l,(__x))
#elif defined(__CRT_HAVE___expm1l)
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__expm1l,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE_expm1) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__expm1l,(__LONGDOUBLE __x),expm1,(__x))
#elif defined(__CRT_HAVE___expm1) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__expm1l,(__LONGDOUBLE __x),__expm1,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_expm1) || defined(__CRT_HAVE___expm1) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/expm1l.h>
/* >> expm1f(3), expm1(3), expm1l(3)
 * Return `exp(x) - 1' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL __expm1l)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(expm1l))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_log1pl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_log1pl)
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__log1pl,(__LONGDOUBLE __x),log1pl,{ return __builtin_log1pl(__x); })
#elif defined(__CRT_HAVE_log1pl)
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__log1pl,(__LONGDOUBLE __x),log1pl,(__x))
#elif defined(__CRT_HAVE___log1pl)
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__log1pl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE_log1p) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__log1pl,(__LONGDOUBLE __x),log1p,(__x))
#elif defined(__CRT_HAVE___log1p) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__log1pl,(__LONGDOUBLE __x),__log1p,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_log1p) || defined(__CRT_HAVE___log1p) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/log1pl.h>
/* >> log1pf(3), log1p(3), log1pl(3)
 * Return `log(1 + x)' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL __log1pl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(log1pl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_logbl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_logbl)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__logbl,(__LONGDOUBLE __x),logbl,{ return __builtin_logbl(__x); })
#elif defined(__CRT_HAVE_logbl)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__logbl,(__LONGDOUBLE __x),logbl,(__x))
#elif defined(__CRT_HAVE___logbl)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__logbl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE_logb) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__logbl,(__LONGDOUBLE __x),logb,(__x))
#elif defined(__CRT_HAVE___logb) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__logbl,(__LONGDOUBLE __x),__logb,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_logb) || defined(__CRT_HAVE___logb) || defined(__CRT_HAVE__logb) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/logbl.h>
/* >> logbf(3), logb(3), logbl(3)
 * Return the base 2 signed integral exponent of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL __logbl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(logbl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_cbrtl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_cbrtl)
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__cbrtl,(__LONGDOUBLE __x),cbrtl,{ return __builtin_cbrtl(__x); })
#elif defined(__CRT_HAVE_cbrtl)
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__cbrtl,(__LONGDOUBLE __x),cbrtl,(__x))
#elif defined(__CRT_HAVE___cbrtl)
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__cbrtl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE_cbrt) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__cbrtl,(__LONGDOUBLE __x),cbrt,(__x))
#elif defined(__CRT_HAVE___cbrt) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__cbrtl,(__LONGDOUBLE __x),__cbrt,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_cbrt) || defined(__CRT_HAVE___cbrt) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/cbrtl.h>
/* >> cbrtf(3), cbrt(3), cbrtl(3)
 * Return  the  cube root  of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL __cbrtl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(cbrtl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_rintl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_rintl)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__rintl,(__LONGDOUBLE __x),rintl,{ return __builtin_rintl(__x); })
#elif __has_builtin(__builtin_nearbyintl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nearbyintl)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__rintl,(__LONGDOUBLE __x),nearbyintl,{ return __builtin_nearbyintl(__x); })
#elif defined(__CRT_HAVE_rintl)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__rintl,(__LONGDOUBLE __x),rintl,(__x))
#elif defined(__CRT_HAVE_nearbyintl)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__rintl,(__LONGDOUBLE __x),nearbyintl,(__x))
#elif defined(__CRT_HAVE___rintl)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__rintl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE___nearbyintl)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__rintl,(__LONGDOUBLE __x),__nearbyintl,(__x))
#elif defined(__CRT_HAVE_rint) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__rintl,(__LONGDOUBLE __x),rint,(__x))
#elif defined(__CRT_HAVE_nearbyint) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__rintl,(__LONGDOUBLE __x),nearbyint,(__x))
#elif defined(__CRT_HAVE___rint) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__rintl,(__LONGDOUBLE __x),__rint,(__x))
#elif defined(__CRT_HAVE___nearbyint) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__rintl,(__LONGDOUBLE __x),__nearbyint,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_rint) || defined(__CRT_HAVE_nearbyint) || defined(__CRT_HAVE___rint) || defined(__CRT_HAVE___nearbyint) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/rintl.h>
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL __rintl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(rintl))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_nextafterl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nextafterl)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__nextafterl,(__LONGDOUBLE __x, __LONGDOUBLE __y),nextafterl,{ return __builtin_nextafterl(__x, __y); })
#elif __has_builtin(__builtin_nexttowardl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nexttowardl)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__nextafterl,(__LONGDOUBLE __x, __LONGDOUBLE __y),nexttowardl,{ return __builtin_nexttowardl(__x); })
#elif defined(__CRT_HAVE_nextafterl)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__nextafterl,(__LONGDOUBLE __x, __LONGDOUBLE __y),nextafterl,(__x,__y))
#elif defined(__CRT_HAVE_nexttowardl)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__nextafterl,(__LONGDOUBLE __x, __LONGDOUBLE __y),nexttowardl,(__x,__y))
#elif defined(__CRT_HAVE___nextafterl)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__nextafterl,(__LONGDOUBLE __x, __LONGDOUBLE __y),(__x,__y))
#elif defined(__CRT_HAVE___nexttowardl)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__nextafterl,(__LONGDOUBLE __x, __LONGDOUBLE __y),__nexttowardl,(__x,__y))
#elif defined(__CRT_HAVE_nextafter) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__nextafterl,(__LONGDOUBLE __x, __LONGDOUBLE __y),nextafter,(__x,__y))
#elif defined(__CRT_HAVE_nexttoward) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__nextafterl,(__LONGDOUBLE __x, __LONGDOUBLE __y),nexttoward,(__x,__y))
#elif defined(__CRT_HAVE___nextafter) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__nextafterl,(__LONGDOUBLE __x, __LONGDOUBLE __y),__nextafter,(__x,__y))
#elif defined(__CRT_HAVE___nexttoward) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__nextafterl,(__LONGDOUBLE __x, __LONGDOUBLE __y),__nexttoward,(__x,__y))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_nextafter) || defined(__CRT_HAVE_nexttoward) || defined(__CRT_HAVE___nextafter) || defined(__CRT_HAVE__nextafter) || defined(__CRT_HAVE___nexttoward) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/nextafterl.h>
/* >> nextafterf(3), nextafter(3), nextafterl(3)
 * Return `x + epsilon' if `x < y', and `x - epsilon' if `x > y' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL __nextafterl)(__LONGDOUBLE __x, __LONGDOUBLE __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(nextafterl))(__x, __y); }
#endif /* ... */
#if __has_builtin(__builtin_remainderl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_remainderl)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__remainderl,(__LONGDOUBLE __x, __LONGDOUBLE __p),remainderl,{ return __builtin_remainderl(__x, __p); })
#elif __has_builtin(__builtin_dreml) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_dreml)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CEIREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__remainderl,(__LONGDOUBLE __x, __LONGDOUBLE __p),dreml,{ return __builtin_dreml(__x, __p); })
#elif defined(__CRT_HAVE_remainderl)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__remainderl,(__LONGDOUBLE __x, __LONGDOUBLE __p),remainderl,(__x,__p))
#elif defined(__CRT_HAVE_dreml)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__remainderl,(__LONGDOUBLE __x, __LONGDOUBLE __p),dreml,(__x,__p))
#elif defined(__CRT_HAVE___remainderl)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CDECLARE(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__remainderl,(__LONGDOUBLE __x, __LONGDOUBLE __p),(__x,__p))
#elif defined(__CRT_HAVE___dreml)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__remainderl,(__LONGDOUBLE __x, __LONGDOUBLE __p),__dreml,(__x,__p))
#elif defined(__CRT_HAVE_remainder) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__remainderl,(__LONGDOUBLE __x, __LONGDOUBLE __p),remainder,(__x,__p))
#elif defined(__CRT_HAVE_drem) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__remainderl,(__LONGDOUBLE __x, __LONGDOUBLE __p),drem,(__x,__p))
#elif defined(__CRT_HAVE___remainder) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__remainderl,(__LONGDOUBLE __x, __LONGDOUBLE __p),__remainder,(__x,__p))
#elif defined(__CRT_HAVE___drem) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__CREDIRECT(__ATTR_WUNUSED,__LONGDOUBLE,__NOTHROW,__remainderl,(__LONGDOUBLE __x, __LONGDOUBLE __p),__drem,(__x,__p))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_remainder) || defined(__CRT_HAVE_drem) || defined(__CRT_HAVE___remainder) || defined(__CRT_HAVE___drem) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/remainderl.h>
/* >> remainderf(3), remainder(3), remainderl(3)
 * Return the remainder of integer division `x / p' with infinite precision */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __LONGDOUBLE __NOTHROW(__LIBCCALL __remainderl)(__LONGDOUBLE __x, __LONGDOUBLE __p) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(remainderl))(__x, __p); }
#endif /* ... */
#if __has_builtin(__builtin_ilogbl) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_ilogbl)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CEIREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,__ilogbl,(__LONGDOUBLE __x),ilogbl,{ return __builtin_ilogbl(__x); })
#elif defined(__CRT_HAVE_ilogbl)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,__ilogbl,(__LONGDOUBLE __x),ilogbl,(__x))
#elif defined(__CRT_HAVE_llogb) && __SIZEOF_INT__ == __SIZEOF_LONG__ && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,__ilogbl,(__LONGDOUBLE __x),llogb,(__x))
#elif defined(__CRT_HAVE_llogbl) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,__ilogbl,(__LONGDOUBLE __x),llogbl,(__x))
#elif defined(__CRT_HAVE___ilogbl)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CDECLARE(__ATTR_WUNUSED,int,__NOTHROW,__ilogbl,(__LONGDOUBLE __x),(__x))
#elif defined(__CRT_HAVE_ilogb) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,__ilogbl,(__LONGDOUBLE __x),ilogb,(__x))
#elif defined(__CRT_HAVE___ilogb) && defined(__ARCH_LONG_DOUBLE_IS_DOUBLE)
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__CREDIRECT(__ATTR_WUNUSED,int,__NOTHROW,__ilogbl,(__LONGDOUBLE __x),__ilogb,(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_ilogb) || (defined(__CRT_HAVE_llogb) && __SIZEOF_INT__ == __SIZEOF_LONG__) || defined(__CRT_HAVE___ilogb) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__)
#include <libc/local/math/ilogbl.h>
/* >> ilogbf(3), ilogb(3), ilogbl(3)
 * Return the binary exponent of `x', which must be nonzero */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED int __NOTHROW(__LIBCCALL __ilogbl)(__LONGDOUBLE __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(ilogbl))(__x); }
#endif /* ... */
#endif /* __COMPILER_HAVE_LONGDOUBLE */
#endif /* __USE_XOPEN_EXTENDED || __USE_ISOC99 */
#ifdef __USE_ISOC99
#if __has_builtin(__builtin_tgamma) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_tgamma)
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__CEIREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__tgamma,(double __x),tgamma,{ return __builtin_tgamma(__x); })
#elif defined(__CRT_HAVE_tgamma)
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__tgamma,(double __x),tgamma,(__x))
#elif defined(__CRT_HAVE___tgamma)
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,__tgamma,(double __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/tgamma.h>
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __tgamma)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(tgamma))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_nexttoward) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nexttoward)
/* >> nexttowardf(3), nexttoward(3), nexttowardl(3) */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__nexttoward,(double __x, __LONGDOUBLE __y),nexttoward,{ return __builtin_nexttoward(__x, __y); })
#elif defined(__CRT_HAVE_nexttoward)
/* >> nexttowardf(3), nexttoward(3), nexttowardl(3) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__nexttoward,(double __x, __LONGDOUBLE __y),nexttoward,(__x,__y))
#elif defined(__CRT_HAVE___nexttoward)
/* >> nexttowardf(3), nexttoward(3), nexttowardl(3) */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__nexttoward,(double __x, __LONGDOUBLE __y),(__x,__y))
#elif defined(__CRT_HAVE_nextafterl) || defined(__CRT_HAVE_nexttowardl) || defined(__CRT_HAVE___nextafterl) || defined(__CRT_HAVE___nexttowardl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_nextafter) || defined(__CRT_HAVE___nextafter) || defined(__CRT_HAVE__nextafter) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/nexttoward.h>
/* >> nexttowardf(3), nexttoward(3), nexttowardl(3) */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __nexttoward)(double __x, __LONGDOUBLE __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(nexttoward))(__x, __y); }
#endif /* ... */
#if __has_builtin(__builtin_scalbn) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_scalbn)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__scalbn,(double __x, int __n),scalbn,{ return __builtin_scalbn(__x, __n); })
#elif defined(__CRT_HAVE_scalbn)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__scalbn,(double __x, int __n),scalbn,(__x,__n))
#elif defined(__CRT_HAVE___scalbn)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__scalbn,(double __x, int __n),(__x,__n))
#elif defined(__CRT_HAVE_scalbln) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__scalbn,(double __x, int __n),scalbln,(__x,__n))
#elif defined(__CRT_HAVE___scalbln) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__scalbn,(double __x, int __n),__scalbln,(__x,__n))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/scalbn.h>
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __scalbn)(double __x, int __n) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(scalbn))(__x, __n); }
#endif /* ... */
#if __has_builtin(__builtin_scalbln) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_scalbln)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__scalbln,(double __x, long int __n),scalbln,{ return __builtin_scalbln(__x, __n); })
#elif defined(__CRT_HAVE_scalbln)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__scalbln,(double __x, long int __n),scalbln,(__x,__n))
#elif defined(__CRT_HAVE___scalbln)
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__scalbln,(double __x, long int __n),(__x,__n))
#elif defined(__CRT_HAVE_scalbn) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__scalbln,(double __x, long int __n),scalbn,(__x,__n))
#elif defined(__CRT_HAVE___scalbn) && __SIZEOF_INT__ == __SIZEOF_LONG__
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__scalbln,(double __x, long int __n),__scalbn,(__x,__n))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/scalbln.h>
/* >> scalbnf(3), scalbn(3), scalbnl(3), scalblnf(3), scalbln(3), scalblnl(3)
 * Return `x' times (2 to the Nth power) */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __scalbln)(double __x, long int __n) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(scalbln))(__x, __n); }
#endif /* ... */
#if __has_builtin(__builtin_rint) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_rint)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__nearbyint,(double __x),rint,{ return __builtin_rint(__x); })
#elif __has_builtin(__builtin_nearbyint) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nearbyint)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__nearbyint,(double __x),nearbyint,{ return __builtin_nearbyint(__x); })
#elif defined(__CRT_HAVE_rint)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__nearbyint,(double __x),rint,(__x))
#elif defined(__CRT_HAVE_nearbyint)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__nearbyint,(double __x),nearbyint,(__x))
#elif defined(__CRT_HAVE___rint)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__nearbyint,(double __x),__rint,(__x))
#elif defined(__CRT_HAVE___nearbyint)
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__nearbyint,(double __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/rint.h>
/* >> rintf(3), rint(3), rintl(3)
 * Return the integer nearest `x' in the direction of the prevailing rounding mode */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __nearbyint)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(rint))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_round) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_round)
/* >> roundf(3), round(3), roundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__round,(double __x),round,{ return __builtin_round(__x); })
#elif defined(__CRT_HAVE_round)
/* >> roundf(3), round(3), roundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__round,(double __x),round,(__x))
#elif defined(__CRT_HAVE___round)
/* >> roundf(3), round(3), roundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__round,(double __x),(__x))
#else /* ... */
#include <libc/local/math/round.h>
/* >> roundf(3), round(3), roundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __round)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(round))(__x); }
#endif /* !... */
#if __has_builtin(__builtin_trunc) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_trunc)
/* >> truncf(3), trunc(3), truncl(3)
 * Round `x' to the integral value in floating-point
 * format   nearest  but  not  larger  in  magnitude */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__trunc,(double __x),trunc,{ return __builtin_trunc(__x); })
#elif defined(__CRT_HAVE_trunc)
/* >> truncf(3), trunc(3), truncl(3)
 * Round `x' to the integral value in floating-point
 * format   nearest  but  not  larger  in  magnitude */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__trunc,(double __x),trunc,(__x))
#elif defined(__CRT_HAVE___trunc)
/* >> truncf(3), trunc(3), truncl(3)
 * Round `x' to the integral value in floating-point
 * format   nearest  but  not  larger  in  magnitude */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__trunc,(double __x),(__x))
#else /* ... */
#include <libc/local/math/trunc.h>
/* >> truncf(3), trunc(3), truncl(3)
 * Round `x' to the integral value in floating-point
 * format   nearest  but  not  larger  in  magnitude */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __trunc)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(trunc))(__x); }
#endif /* !... */
#if __has_builtin(__builtin_remquo) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_remquo)
/* >> remquof(3), remquo(3), remquol(3)
 * Compute remainder of `x' and `p' and put in `*pquo' a value with
 * sign of x/p and magnitude  congruent `mod 2^n' to the  magnitude
 * of the integral quotient x/p, with n >= 3 */
__CEIREDIRECT(__ATTR_WUNUSED __ATTR_OUT(3),double,__NOTHROW,__remquo,(double __x, double __p, int *__pquo),remquo,{ return __builtin_remquo(__x, __p, __pquo); })
#elif defined(__CRT_HAVE_remquo)
/* >> remquof(3), remquo(3), remquol(3)
 * Compute remainder of `x' and `p' and put in `*pquo' a value with
 * sign of x/p and magnitude  congruent `mod 2^n' to the  magnitude
 * of the integral quotient x/p, with n >= 3 */
__CREDIRECT(__ATTR_WUNUSED __ATTR_OUT(3),double,__NOTHROW,__remquo,(double __x, double __p, int *__pquo),remquo,(__x,__p,__pquo))
#elif defined(__CRT_HAVE___remquo)
/* >> remquof(3), remquo(3), remquol(3)
 * Compute remainder of `x' and `p' and put in `*pquo' a value with
 * sign of x/p and magnitude  congruent `mod 2^n' to the  magnitude
 * of the integral quotient x/p, with n >= 3 */
__CDECLARE(__ATTR_WUNUSED __ATTR_OUT(3),double,__NOTHROW,__remquo,(double __x, double __p, int *__pquo),(__x,__p,__pquo))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/remquo.h>
/* >> remquof(3), remquo(3), remquol(3)
 * Compute remainder of `x' and `p' and put in `*pquo' a value with
 * sign of x/p and magnitude  congruent `mod 2^n' to the  magnitude
 * of the integral quotient x/p, with n >= 3 */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED __ATTR_OUT(3) double __NOTHROW(__LIBCCALL __remquo)(double __x, double __p, int *__pquo) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(remquo))(__x, __p, __pquo); }
#endif /* ... */
#if __has_builtin(__builtin_lrint) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_lrint)
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,__lrint,(double __x),lrint,{ return __builtin_lrint(__x); })
#elif defined(__CRT_HAVE_lrint)
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,__lrint,(double __x),lrint,(__x))
#elif defined(__CRT_HAVE___lrint)
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,__lrint,(double __x),(__x))
#elif defined(__CRT_HAVE_llrint) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,__lrint,(double __x),llrint,(__x))
#else /* ... */
#include <libc/local/math/lrint.h>
/* >> lrintf(3), lrint(3), lrintl(3)
 * Round `x' to nearest integral value according to current rounding direction */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED long int __NOTHROW(__LIBCCALL __lrint)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(lrint))(__x); }
#endif /* !... */
#if __has_builtin(__builtin_lround) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_lround)
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,__lround,(double __x),lround,{ return __builtin_lround(__x); })
#elif defined(__CRT_HAVE_lround)
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,__lround,(double __x),lround,(__x))
#elif defined(__CRT_HAVE___lround)
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,__lround,(double __x),(__x))
#elif defined(__CRT_HAVE_llround) && __SIZEOF_LONG__ == __SIZEOF_LONG_LONG__
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,long int,__NOTHROW,__lround,(double __x),llround,(__x))
#else /* ... */
#include <libc/local/math/lround.h>
/* >> lroundf(3), lround(3), lroundl(3)
 * Round `x' to nearest integral value, rounding halfway cases away from zero */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED long int __NOTHROW(__LIBCCALL __lround)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(lround))(__x); }
#endif /* !... */
#if __has_builtin(__builtin_fdim) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fdim)
/* >> fdimf(3), fdim(3), fdiml(3)
 * Return positive difference between `x' and `y' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__fdim,(double __x, double __y),fdim,{ return __builtin_fdim(__x, __y); })
#elif defined(__CRT_HAVE_fdim)
/* >> fdimf(3), fdim(3), fdiml(3)
 * Return positive difference between `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__fdim,(double __x, double __y),fdim,(__x,__y))
#elif defined(__CRT_HAVE___fdim)
/* >> fdimf(3), fdim(3), fdiml(3)
 * Return positive difference between `x' and `y' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__fdim,(double __x, double __y),(__x,__y))
#else /* ... */
#include <libc/local/math/fdim.h>
/* >> fdimf(3), fdim(3), fdiml(3)
 * Return positive difference between `x' and `y' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __fdim)(double __x, double __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fdim))(__x, __y); }
#endif /* !... */
#if __has_builtin(__builtin_fmax) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fmax)
/* >> fmaxf(3), fmax(3), fmaxl(3)
 * Return maximum numeric value from `x' and `y' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__fmax,(double __x, double __y),fmax,{ return __builtin_fmax(__x, __y); })
#elif defined(__CRT_HAVE_fmax)
/* >> fmaxf(3), fmax(3), fmaxl(3)
 * Return maximum numeric value from `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__fmax,(double __x, double __y),fmax,(__x,__y))
#elif defined(__CRT_HAVE___fmax)
/* >> fmaxf(3), fmax(3), fmaxl(3)
 * Return maximum numeric value from `x' and `y' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__fmax,(double __x, double __y),(__x,__y))
#else /* ... */
#include <libc/local/math/fmax.h>
/* >> fmaxf(3), fmax(3), fmaxl(3)
 * Return maximum numeric value from `x' and `y' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __fmax)(double __x, double __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fmax))(__x, __y); }
#endif /* !... */
#if __has_builtin(__builtin_fmin) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fmin)
/* >> fminf(3), fmin(3), fminl(3)
 * Return minimum numeric value from `x' and `y' */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__fmin,(double __x, double __y),fmin,{ return __builtin_fmin(__x, __y); })
#elif defined(__CRT_HAVE_fmin)
/* >> fminf(3), fmin(3), fminl(3)
 * Return minimum numeric value from `x' and `y' */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__fmin,(double __x, double __y),fmin,(__x,__y))
#elif defined(__CRT_HAVE___fmin)
/* >> fminf(3), fmin(3), fminl(3)
 * Return minimum numeric value from `x' and `y' */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__fmin,(double __x, double __y),(__x,__y))
#else /* ... */
#include <libc/local/math/fmin.h>
/* >> fminf(3), fmin(3), fminl(3)
 * Return minimum numeric value from `x' and `y' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __fmin)(double __x, double __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fmin))(__x, __y); }
#endif /* !... */
#if __has_builtin(__builtin_fma) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_fma)
/* >> fmaf(3), fma(3), fmal(3)
 * Multiply-add function computed as a ternary operation */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__fma,(double __x, double __y, double __z),fma,{ return __builtin_fma(__x, __y, __z); })
#elif defined(__CRT_HAVE_fma)
/* >> fmaf(3), fma(3), fmal(3)
 * Multiply-add function computed as a ternary operation */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__fma,(double __x, double __y, double __z),fma,(__x,__y,__z))
#elif defined(__CRT_HAVE___fma)
/* >> fmaf(3), fma(3), fmal(3)
 * Multiply-add function computed as a ternary operation */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__fma,(double __x, double __y, double __z),(__x,__y,__z))
#else /* ... */
#include <libc/local/math/fma.h>
/* >> fmaf(3), fma(3), fmal(3)
 * Multiply-add function computed as a ternary operation */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __fma)(double __x, double __y, double __z) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(fma))(__x, __y, __z); }
#endif /* !... */
#if __has_builtin(__builtin_exp2) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_exp2)
/* >> exp2f(3), exp2(3), exp2l(3)
 * Compute base-2 exponential of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__exp2,(double __x),exp2,{ return __builtin_exp2(__x); })
#elif defined(__CRT_HAVE_exp2)
/* >> exp2f(3), exp2(3), exp2l(3)
 * Compute base-2 exponential of `x' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__exp2,(double __x),exp2,(__x))
#elif defined(__CRT_HAVE___exp2)
/* >> exp2f(3), exp2(3), exp2l(3)
 * Compute base-2 exponential of `x' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,__exp2,(double __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/exp2.h>
/* >> exp2f(3), exp2(3), exp2l(3)
 * Compute base-2 exponential of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __exp2)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(exp2))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_log2) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_log2)
/* >> log2f(3), log2(3), log2l(3)
 * Compute base-2 logarithm of `x' */
__CEIREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__log2,(double __x),log2,{ return __builtin_log2(__x); })
#elif defined(__CRT_HAVE_log2)
/* >> log2f(3), log2(3), log2l(3)
 * Compute base-2 logarithm of `x' */
__CREDIRECT(__ATTR_WUNUSED,double,__NOTHROW,__log2,(double __x),log2,(__x))
#elif defined(__CRT_HAVE___log2)
/* >> log2f(3), log2(3), log2l(3)
 * Compute base-2 logarithm of `x' */
__CDECLARE(__ATTR_WUNUSED,double,__NOTHROW,__log2,(double __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/log2.h>
/* >> log2f(3), log2(3), log2l(3)
 * Compute base-2 logarithm of `x' */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __log2)(double __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(log2))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_copysign) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_copysign)
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__copysign,(double __num, double __sign),copysign,{ return __builtin_copysign(__num, __sign); })
#elif defined(__CRT_HAVE_copysign)
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__copysign,(double __num, double __sign),copysign,(__num,__sign))
#elif defined(__CRT_HAVE___copysign)
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__copysign,(double __num, double __sign),(__num,__sign))
#elif defined(__CRT_HAVE__copysign)
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__copysign,(double __num, double __sign),_copysign,(__num,__sign))
#else /* ... */
#include <libc/local/math/copysign.h>
/* >> copysignf(3), copysign(3), copysignl(3)
 * Return `x' with its signed changed to `y's */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __copysign)(double __num, double __sign) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(copysign))(__num, __sign); }
#endif /* !... */
#if __has_builtin(__builtin_nan) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nan)
/* >> nanf(3), nan(3), nanl(3)
 * Return representation of qNaN for double type */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__nan,(char const *__tagb),nan,{ return __builtin_nan(__tagb); })
#elif defined(__CRT_HAVE_nan)
/* >> nanf(3), nan(3), nanl(3)
 * Return representation of qNaN for double type */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__nan,(char const *__tagb),nan,(__tagb))
#elif defined(__CRT_HAVE___nan)
/* >> nanf(3), nan(3), nanl(3)
 * Return representation of qNaN for double type */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,double,__NOTHROW,__nan,(char const *__tagb),(__tagb))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/nan.h>
/* >> nanf(3), nan(3), nanl(3)
 * Return representation of qNaN for double type */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED double __NOTHROW(__LIBCCALL __nan)(char const *__tagb) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(nan))(__tagb); }
#endif /* ... */
#if __has_builtin(__builtin_tgammaf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_tgammaf)
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__CEIREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__tgammaf,(float __x),tgammaf,{ return __builtin_tgammaf(__x); })
#elif defined(__CRT_HAVE_tgammaf)
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__CREDIRECT(__ATTR_WUNUSED,float,__NOTHROW,__tgammaf,(float __x),tgammaf,(__x))
#elif defined(__CRT_HAVE___tgammaf)
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__CDECLARE(__ATTR_WUNUSED,float,__NOTHROW,__tgammaf,(float __x),(__x))
#elif defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__) || defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_FLOAT__) || defined(__CRT_HAVE_tgamma) || defined(__CRT_HAVE___tgamma) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/tgammaf.h>
/* >> tgammaf(3), tgamma(3), tgammal(3)
 * True gamma function */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_WUNUSED float __NOTHROW(__LIBCCALL __tgammaf)(float __x) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(tgammaf))(__x); }
#endif /* ... */
#if __has_builtin(__builtin_nexttowardf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_nexttowardf)
/* >> nexttowardf(3), nexttoward(3), nexttowardl(3) */
__CEIREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__nexttowardf,(float __x, __LONGDOUBLE __y),nexttowardf,{ return __builtin_nexttowardf(__x, __y); })
#elif defined(__CRT_HAVE_nexttowardf)
/* >> nexttowardf(3), nexttoward(3), nexttowardl(3) */
__CREDIRECT(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__nexttowardf,(float __x, __LONGDOUBLE __y),nexttowardf,(__x,__y))
#elif defined(__CRT_HAVE___nexttowardf)
/* >> nexttowardf(3), nexttoward(3), nexttowardl(3) */
__CDECLARE(__ATTR_CONST __ATTR_WUNUSED,float,__NOTHROW,__nexttowardf,(float __x, __LONGDOUBLE __y),(__x,__y))
#elif ((defined(__IEEE754_FLOAT_TYPE_IS_FLOAT__) || defined(__IEEE754_DOUBLE_TYPE_IS_FLOAT__)) && defined(__IEEE854_LONG_DOUBLE_TYPE__)) || defined(__CRT_HAVE_nextafterl) || defined(__CRT_HAVE_nexttowardl) || defined(__CRT_HAVE___nextafterl) || defined(__CRT_HAVE___nexttowardl) || defined(__IEEE754_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_LONG_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_LONG_DOUBLE__) || defined(__CRT_HAVE_nextafter) || defined(__CRT_HAVE_nexttoward) || defined(__CRT_HAVE___nextafter) || defined(__CRT_HAVE__nextafter) || defined(__CRT_HAVE___nexttoward) || defined(__IEEE754_DOUBLE_TYPE_IS_DOUBLE__) || defined(__IEEE754_FLOAT_TYPE_IS_DOUBLE__) || defined(__IEEE854_LONG_DOUBLE_TYPE_IS_DOUBLE__)
#include <libc/local/math/nexttowardf.h>
/* >> nexttowardf(3), nexttoward(3), nexttowardl(3) */
__FORCELOCAL __ATTR_ARTIFICIAL __ATTR_CONST __ATTR_WUNUSED float __NOTHROW(__LIBCCALL __nexttowardf)(float __x, __LONGDOUBLE __y) { return (__NAMESPACE_LOCAL_SYM __LIBC_LOCAL_NAME(nexttowardf))(__x, __y); }
#endif /* ... */
#if __has_builtin(__builtin_scalbnf) && defined(__LIBC_BIND_CRTBUILTINS) && defined(__CRT_HAVE_scalbn