/* Copyright (c) 2019-2024 Griefer@Work                                       *
 *                                                                            *
 * This software is provided 'as-is', without any express or implied          *
 * warranty. In no event will the authors be held liable for any damages      *
 * arising from the use of this software.                                     *
 *                                                                            *
 * Permission is granted to anyone to use this software for any purpose,      *
 * including commercial applications, and to alter it and redistribute it     *
 * freely, subject to the following restrictions:                             *
 *                                                                            *
 * 1. The origin of this software must not be misrepresented; you must not    *
 *    claim that you wrote the original software. If you use this software    *
 *    in a product, an acknowledgement (see the following) in the product     *
 *    documentation is required:                                              *
 *    Portions Copyright (c) 2019-2024 Griefer@Work                           *
 * 2. Altered source versions must be plainly marked as such, and must not be *
 *    misrepresented as being the original software.                          *
 * 3. This notice may not be removed or altered from any source distribution. *
 */

#include <hybrid/host.h> /* For `__x86_64__' */

/*
 * Select Glibc version.
 *
 * Glibc version:
 *     20000: /lib/libc-2.0.so
 *     20004: /lib/libc-2.0.4.so
 *     20103: /lib/libc-2.1.3.so
 *     20205: /lib/libc-2.2.5.so
 *     20302: /lib/libc-2.3.2.so
 *     20305: /lib/libc-2.3.5.so
 *     20306: /lib/libc-2.3.6.so
 *     20400: /lib/libc-2.4.so
 *     20500: /lib/libc-2.5.so
 *     20601: /lib/libc-2.6.1.so
 *     20700: /lib/libc-2.7.so
 *     20890: /lib/libc-2.8.90.so
 *     20900: /lib/libc-2.9.so
 *     21001: /lib/libc-2.10.1.so
 *     21100: /lib/libc-2.11.so
 *     21200: /lib/libc-2.12.so
 *     21290: /lib/libc-2.12.90.so
 *     21390: /lib/libc-2.13.90.so
 *     21500: /lib/libc-2.15.so
 *     21600: /lib/libc-2.16.so
 *     21700: /lib/libc-2.17.so
 *     21800: /lib/libc-2.18.so
 *     21900: /lib/libc-2.19.so
 *     22000: /lib/libc-2.20.so
 *     22100: /lib/libc-2.21.so
 *     22200: /lib/libc-2.22.so
 *     22300: /lib/libc-2.23.so
 *     22400: /lib/libc-2.24.so
 *     22600: /lib/libc-2.26.so
 *     22700: /lib/libc-2.27.so
 *     22800: /lib/libc-2.28.so
 *     22900: /lib/libc-2.29.so
 *     23000: /lib/libc-2.30.so
 *     23100: /lib/libc-2.31.so
 *     23200: /lib/libc-2.32.so
 *     23300: /lib/libc-2.33.so
 *     23400: /lib/libc-2.34.so
 *     23500: /lib/libc-2.35.so
 *     23600: /lib/libc-2.36.so
 *     23700: /lib/libc-2.37.so
 *     23800: /lib/libc-2.38.so
 */
#ifndef __GNU_LIBRARY__
#define __GNU_LIBRARY__ 6
#endif /* !__GNU_LIBRARY__ */
#if __GNU_LIBRARY__ < 6
#error "Pre-ELF versions of Glibc aren't supported"
#endif /* __GNU_LIBRARY__ < 6 */
#ifndef __GLIBC__
#define __GLIBC__       2
#define __GLIBC_MINOR__ 38
#define __GLIBC_PATCH__ 0
#else /* !__GLIBC__ */
#ifndef __GLIBC_MINOR__
#define __GLIBC_MINOR__ 0
#endif /* !__GLIBC_MINOR__ */
#ifndef __GLIBC_PATCH__
#define __GLIBC_PATCH__ 0
#endif /* !__GLIBC_PATCH__ */
#endif /* __GLIBC__ */
#ifndef __GLIBC_VERSION__
#define __GLIBC_VERSION__ (__GLIBC__ * 10000 + __GLIBC_MINOR__ * 100 + __GLIBC_PATCH__)
#endif /* !__GLIBC_VERSION__ */

/************************************************************************/
#define __CRT_HAVE__IO_adjust_column
#define __CRT_HAVE__IO_default_doallocate
#define __CRT_HAVE__IO_default_finish
#define __CRT_HAVE__IO_default_pbackfail
#define __CRT_HAVE__IO_default_uflow
#define __CRT_HAVE__IO_default_xsgetn
#define __CRT_HAVE__IO_default_xsputn
#define __CRT_HAVE__IO_do_write
#define __CRT_HAVE__IO_doallocbuf
#define __CRT_HAVE__IO_fclose
#define __CRT_HAVE__IO_fdopen
#define __CRT_HAVE__IO_feof
#define __CRT_HAVE__IO_ferror
#define __CRT_HAVE__IO_fflush
#define __CRT_HAVE__IO_fgetpos
#define __CRT_HAVE__IO_fgets
#define __CRT_HAVE__IO_file_attach
#define __CRT_HAVE__IO_file_close
#define __CRT_HAVE__IO_file_close_it
#define __CRT_HAVE__IO_file_doallocate
#define __CRT_HAVE__IO_file_finish
#define __CRT_HAVE__IO_file_fopen
#define __CRT_HAVE__IO_file_init
#define __CRT_HAVE__IO_file_jumps
#define __CRT_HAVE__IO_file_overflow
#define __CRT_HAVE__IO_file_read
#define __CRT_HAVE__IO_file_seek
#define __CRT_HAVE__IO_file_seekoff
#define __CRT_HAVE__IO_file_setbuf
#define __CRT_HAVE__IO_file_stat
#define __CRT_HAVE__IO_file_sync
#define __CRT_HAVE__IO_file_underflow
#define __CRT_HAVE__IO_file_write
#define __CRT_HAVE__IO_file_xsputn
#define __CRT_HAVE__IO_flockfile
#define __CRT_HAVE__IO_flush_all
#define __CRT_HAVE__IO_flush_all_linebuffered
#define __CRT_HAVE__IO_fopen
#define __CRT_HAVE__IO_fprintf
#define __CRT_HAVE__IO_fputs
#define __CRT_HAVE__IO_fread
#define __CRT_HAVE__IO_free_backup_area
#define __CRT_HAVE__IO_fsetpos
#define __CRT_HAVE__IO_ftell
#define __CRT_HAVE__IO_ftrylockfile
#define __CRT_HAVE__IO_funlockfile
#define __CRT_HAVE__IO_fwrite
#define __CRT_HAVE__IO_getc
#define __CRT_HAVE__IO_getline
#define __CRT_HAVE__IO_gets
#define __CRT_HAVE__IO_init
#define __CRT_HAVE__IO_init_marker
#define __CRT_HAVE__IO_link_in
#define __CRT_HAVE__IO_list_all
#define __CRT_HAVE__IO_marker_delta
#define __CRT_HAVE__IO_marker_difference
#define __CRT_HAVE__IO_padn
#define __CRT_HAVE__IO_peekc_locked
#define __CRT_HAVE__IO_popen
#define __CRT_HAVE__IO_printf
#define __CRT_HAVE__IO_proc_close
#define __CRT_HAVE__IO_proc_open
#define __CRT_HAVE__IO_putc
#define __CRT_HAVE__IO_puts
#define __CRT_HAVE__IO_remove_marker
#define __CRT_HAVE__IO_seekmark
#define __CRT_HAVE__IO_seekoff
#define __CRT_HAVE__IO_seekpos
#define __CRT_HAVE__IO_setb
#define __CRT_HAVE__IO_setbuffer
#define __CRT_HAVE__IO_setvbuf
#define __CRT_HAVE__IO_sgetn
#define __CRT_HAVE__IO_sprintf
#define __CRT_HAVE__IO_sputbackc
#define __CRT_HAVE__IO_sscanf
#define __CRT_HAVE__IO_str_init_readonly
#define __CRT_HAVE__IO_str_init_static
#define __CRT_HAVE__IO_str_overflow
#define __CRT_HAVE__IO_str_pbackfail
#define __CRT_HAVE__IO_str_seekoff
#define __CRT_HAVE__IO_str_underflow
#define __CRT_HAVE__IO_sungetc
#define __CRT_HAVE__IO_switch_to_get_mode
#define __CRT_HAVE__IO_un_link
#define __CRT_HAVE__IO_ungetc
#define __CRT_HAVE__IO_unsave_markers
#define __CRT_HAVE__IO_vfprintf
#define __CRT_HAVE__IO_vfscanf
#define __CRT_HAVE__IO_vsprintf
#define __CRT_HAVE__LIB_VERSION
#define __CRT_HAVE___adjtimex
#define __CRT_HAVE___argz_count
#define __CRT_HAVE___argz_next
#define __CRT_HAVE___argz_stringify
#define __CRT_HAVE___assert_fail
#define __CRT_HAVE___assert_perror_fail
#define __CRT_HAVE___check_rhosts_file
#define __CRT_HAVE___clone
#define __CRT_HAVE___close
#define __CRT_HAVE___connect
#define __CRT_HAVE___ctype32_b
#define __CRT_HAVE___ctype_b
#define __CRT_HAVE___ctype_get_mb_cur_max
#define __CRT_HAVE___ctype_tolower
#define __CRT_HAVE___ctype_toupper
#define __CRT_HAVE___curbrk
#define __CRT_HAVE___daylight
#define __CRT_HAVE___dcgettext
#define __CRT_HAVE___default_morecore
#define __CRT_HAVE___dgettext
#define __CRT_HAVE___dup2
#define __CRT_HAVE___environ
#define __CRT_HAVE___errno_location
#define __CRT_HAVE___fcntl
#define __CRT_HAVE___finite
#define __CRT_HAVE___finitef
#define __CRT_HAVE___finitel
#define __CRT_HAVE___fork
#define __CRT_HAVE___fpu_control
#define __CRT_HAVE___free_hook
#define __CRT_HAVE___fxstat
#define __CRT_HAVE___getdelim
#define __CRT_HAVE___getpagesize
#define __CRT_HAVE___getpgid
#define __CRT_HAVE___getpid
#define __CRT_HAVE___gettimeofday
#define __CRT_HAVE___gmon_start__
#define __CRT_HAVE___gmtime_r
#define __CRT_HAVE___h_errno_location
#define __CRT_HAVE___internal_endnetgrent
#define __CRT_HAVE___internal_getnetgrent_r
#define __CRT_HAVE___internal_setnetgrent
#define __CRT_HAVE___isinf
#define __CRT_HAVE___isinff
#define __CRT_HAVE___isinfl
#define __CRT_HAVE___isnan
#define __CRT_HAVE___isnanf
#define __CRT_HAVE___isnanl
#define __CRT_HAVE___iswctype
#define __CRT_HAVE___ivaliduser
#define __CRT_HAVE___libc_calloc
#define __CRT_HAVE___libc_enable_secure
#define __CRT_HAVE___libc_free
#define __CRT_HAVE___libc_init_first
#define __CRT_HAVE___libc_mallinfo
#define __CRT_HAVE___libc_malloc
#define __CRT_HAVE___libc_mallopt
#define __CRT_HAVE___libc_memalign
#define __CRT_HAVE___libc_pvalloc
#define __CRT_HAVE___libc_realloc
#define __CRT_HAVE___libc_system
#define __CRT_HAVE___libc_valloc
#define __CRT_HAVE___lseek
#define __CRT_HAVE___lxstat
#define __CRT_HAVE___malloc_hook
#define __CRT_HAVE___malloc_initialize_hook
#define __CRT_HAVE___mbrlen
#define __CRT_HAVE___memalign_hook
#define __CRT_HAVE___nss_configure_lookup
#define __CRT_HAVE___nss_database_lookup
#define __CRT_HAVE___nss_group_lookup
#define __CRT_HAVE___nss_hosts_lookup
#define __CRT_HAVE___nss_next
#define __CRT_HAVE___nss_passwd_lookup
#define __CRT_HAVE___open
#define __CRT_HAVE___open_catalog
#define __CRT_HAVE___overflow
#define __CRT_HAVE___pipe
#define __CRT_HAVE___printf_fp
#define __CRT_HAVE___profile_frequency
#define __CRT_HAVE___progname
#define __CRT_HAVE___progname_full
#define __CRT_HAVE___pthread_getspecific
#define __CRT_HAVE___pthread_key_create
#define __CRT_HAVE___pthread_setspecific
#define __CRT_HAVE___rcmd_errstr
#define __CRT_HAVE___read
#define __CRT_HAVE___realloc_hook
#define __CRT_HAVE___res_randomid
#define __CRT_HAVE___sbrk
#define __CRT_HAVE___sched_get_priority_max
#define __CRT_HAVE___sched_get_priority_min
#define __CRT_HAVE___sched_getparam
#define __CRT_HAVE___sched_getscheduler
#define __CRT_HAVE___sched_setscheduler
#define __CRT_HAVE___sched_yield
#define __CRT_HAVE___secure_getenv
#define __CRT_HAVE___select
#define __CRT_HAVE___send
#define __CRT_HAVE___setpgid
#define __CRT_HAVE___sigaction
#define __CRT_HAVE___sigaddset
#define __CRT_HAVE___sigdelset
#define __CRT_HAVE___sigismember
#define __CRT_HAVE___sigpause
#define __CRT_HAVE___sigsetjmp
#define __CRT_HAVE___sigsuspend
#define __CRT_HAVE___stpcpy
#define __CRT_HAVE___stpncpy
#define __CRT_HAVE___strcasecmp
#define __CRT_HAVE___strdup
#define __CRT_HAVE___strerror_r
#define __CRT_HAVE___strtod_internal
#define __CRT_HAVE___strtof_internal
#define __CRT_HAVE___strtol_internal
#define __CRT_HAVE___strtold_internal
#define __CRT_HAVE___strtoul_internal
#define __CRT_HAVE___sysv_signal
#define __CRT_HAVE___timezone
#define __CRT_HAVE___tzname
#define __CRT_HAVE___uflow
#define __CRT_HAVE___underflow
#define __CRT_HAVE___vfork
#define __CRT_HAVE___vfscanf
#define __CRT_HAVE___vsnprintf
#define __CRT_HAVE___vsscanf
#define __CRT_HAVE___wait
#define __CRT_HAVE___waitpid
#define __CRT_HAVE___wcstod_internal
#define __CRT_HAVE___wcstof_internal
#define __CRT_HAVE___wcstol_internal
#define __CRT_HAVE___wcstold_internal
#define __CRT_HAVE___wcstoul_internal
#define __CRT_HAVE___write
#define __CRT_HAVE___xmknod
#define __CRT_HAVE___xstat
#define __CRT_HAVE__authenticate
#define __CRT_HAVE__dl_debug_state
#define __CRT_HAVE__environ
#define __CRT_HAVE__exit
#define __CRT_HAVE__itoa_lower_digits
#define __CRT_HAVE__libc_intl_domainname
#define __CRT_HAVE__longjmp
#define __CRT_HAVE__mcleanup
#define __CRT_HAVE__mcount
#define __CRT_HAVE__nl_default_dirname
#define __CRT_HAVE__nl_domain_bindings
#define __CRT_HAVE__nl_msg_cat_cntr
#define __CRT_HAVE__nss_files_parse_grent
#define __CRT_HAVE__nss_files_parse_pwent
#define __CRT_HAVE__nss_files_parse_spent
#define __CRT_HAVE__null_auth
#define __CRT_HAVE__obstack
#define __CRT_HAVE__obstack_allocated_p
#define __CRT_HAVE__obstack_begin
#define __CRT_HAVE__obstack_begin_1
#define __CRT_HAVE__obstack_free
#define __CRT_HAVE__obstack_memory_used
#define __CRT_HAVE__obstack_newchunk
#define __CRT_HAVE__r_debug
#define __CRT_HAVE__res
#define __CRT_HAVE__rpc_dtablesize
#define __CRT_HAVE__seterr_reply
#define __CRT_HAVE__setjmp
#define __CRT_HAVE__sys_errlist
#define __CRT_HAVE__sys_nerr
#define __CRT_HAVE__sys_siglist
#define __CRT_HAVE__tolower
#define __CRT_HAVE__toupper
#define __CRT_HAVE_a64l
#define __CRT_HAVE_abort
#define __CRT_HAVE_abs
#define __CRT_HAVE_accept
#define __CRT_HAVE_access
#define __CRT_HAVE_acct
#define __CRT_HAVE_acos
#define __CRT_HAVE_acosf
#define __CRT_HAVE_acosh
#define __CRT_HAVE_acoshf
#define __CRT_HAVE_acoshl
#define __CRT_HAVE_acosl
#define __CRT_HAVE_addmntent
#define __CRT_HAVE_adjtime
#define __CRT_HAVE_adjtimex
#define __CRT_HAVE_advance
#define __CRT_HAVE_alarm
#define __CRT_HAVE_alphasort
#define __CRT_HAVE_argz_add
#define __CRT_HAVE_argz_append
#define __CRT_HAVE_argz_count
#define __CRT_HAVE_argz_create
#define __CRT_HAVE_argz_create_sep
#define __CRT_HAVE_argz_delete
#define __CRT_HAVE_argz_extract
#define __CRT_HAVE_argz_insert
#define __CRT_HAVE_argz_next
#define __CRT_HAVE_argz_stringify
#define __CRT_HAVE_asctime
#define __CRT_HAVE_asctime_r
#define __CRT_HAVE_asin
#define __CRT_HAVE_asinf
#define __CRT_HAVE_asinh
#define __CRT_HAVE_asinhf
#define __CRT_HAVE_asinhl
#define __CRT_HAVE_asinl
#define __CRT_HAVE_asprintf
#define __CRT_HAVE_atan
#define __CRT_HAVE_atan2
#define __CRT_HAVE_atan2f
#define __CRT_HAVE_atan2l
#define __CRT_HAVE_atanf
#define __CRT_HAVE_atanh
#define __CRT_HAVE_atanhf
#define __CRT_HAVE_atanhl
#define __CRT_HAVE_atanl
#define __CRT_HAVE_atof
#define __CRT_HAVE_atoi
#define __CRT_HAVE_atol
#define __CRT_HAVE_authnone_create
#define __CRT_HAVE_authunix_create
#define __CRT_HAVE_authunix_create_default
#define __CRT_HAVE_basename
#define __CRT_HAVE_bcmp
#define __CRT_HAVE_bcopy
#define __CRT_HAVE_bdflush
#define __CRT_HAVE_bind
#define __CRT_HAVE_bindresvport
#define __CRT_HAVE_bindtextdomain
#define __CRT_HAVE_brk
#define __CRT_HAVE_bsd_signal
#define __CRT_HAVE_bsearch
#define __CRT_HAVE_btowc
#define __CRT_HAVE_bzero
#define __CRT_HAVE_cabs
#define __CRT_HAVE_cabsf
#define __CRT_HAVE_cabsl
#define __CRT_HAVE_calloc
#define __CRT_HAVE_callrpc
#define __CRT_HAVE_canonicalize_file_name
#define __CRT_HAVE_catclose
#define __CRT_HAVE_catgets
#define __CRT_HAVE_catopen
#define __CRT_HAVE_cbrt
#define __CRT_HAVE_cbrtf
#define __CRT_HAVE_cbrtl
#define __CRT_HAVE_ceil
#define __CRT_HAVE_ceilf
#define __CRT_HAVE_ceill
#define __CRT_HAVE_cfgetispeed
#define __CRT_HAVE_cfgetospeed
#define __CRT_HAVE_cfmakeraw
#define __CRT_HAVE_cfree
#define __CRT_HAVE_cfsetispeed
#define __CRT_HAVE_cfsetospeed
#define __CRT_HAVE_cfsetspeed
#define __CRT_HAVE_chdir
#define __CRT_HAVE_chflags
#define __CRT_HAVE_chmod
#define __CRT_HAVE_chown
#define __CRT_HAVE_chroot
#define __CRT_HAVE_clearenv
#define __CRT_HAVE_clearerr
#define __CRT_HAVE_clearerr_unlocked
#define __CRT_HAVE_clnt_broadcast
#define __CRT_HAVE_clnt_create
#define __CRT_HAVE_clnt_pcreateerror
#define __CRT_HAVE_clnt_perrno
#define __CRT_HAVE_clnt_perror
#define __CRT_HAVE_clnt_spcreateerror
#define __CRT_HAVE_clnt_sperrno
#define __CRT_HAVE_clnt_sperror
#define __CRT_HAVE_clntraw_create
#define __CRT_HAVE_clnttcp_create
#define __CRT_HAVE_clntudp_bufcreate
#define __CRT_HAVE_clntudp_create
#define __CRT_HAVE_clock
#define __CRT_HAVE_clone
#define __CRT_HAVE_close
#define __CRT_HAVE_closedir
#define __CRT_HAVE_closelog
#define __CRT_HAVE_confstr
#define __CRT_HAVE_connect
#define __CRT_HAVE_copysign
#define __CRT_HAVE_copysignf
#define __CRT_HAVE_copysignl
#define __CRT_HAVE_cos
#define __CRT_HAVE_cosf
#define __CRT_HAVE_cosh
#define __CRT_HAVE_coshf
#define __CRT_HAVE_coshl
#define __CRT_HAVE_cosl
#define __CRT_HAVE_creat
#define __CRT_HAVE_create_module
#define __CRT_HAVE_ctermid
#define __CRT_HAVE_ctime
#define __CRT_HAVE_ctime_r
#define __CRT_HAVE_cuserid
#define __CRT_HAVE_daemon
#define __CRT_HAVE_daylight
#define __CRT_HAVE_dcgettext
#define __CRT_HAVE_delete_module
#define __CRT_HAVE_dgettext
#define __CRT_HAVE_difftime
#define __CRT_HAVE_dirfd
#define __CRT_HAVE_dirname
#define __CRT_HAVE_div
#define __CRT_HAVE_dladdr
#define __CRT_HAVE_dlclose
#define __CRT_HAVE_dlerror
#define __CRT_HAVE_dlopen
#define __CRT_HAVE_dlsym
#define __CRT_HAVE_dprintf
#define __CRT_HAVE_drand48
#define __CRT_HAVE_drand48_r
#define __CRT_HAVE_drem
#define __CRT_HAVE_dremf
#define __CRT_HAVE_dreml
#define __CRT_HAVE_dup
#define __CRT_HAVE_dup2
#define __CRT_HAVE_dysize
#define __CRT_HAVE_ecvt
#define __CRT_HAVE_ecvt_r
#define __CRT_HAVE_endaliasent
#define __CRT_HAVE_endfsent
#define __CRT_HAVE_endgrent
#define __CRT_HAVE_endhostent
#define __CRT_HAVE_endmntent
#define __CRT_HAVE_endnetent
#define __CRT_HAVE_endnetgrent
#define __CRT_HAVE_endprotoent
#define __CRT_HAVE_endpwent
#define __CRT_HAVE_endrpcent
#define __CRT_HAVE_endservent
#define __CRT_HAVE_endspent
#define __CRT_HAVE_endttyent
#define __CRT_HAVE_endusershell
#define __CRT_HAVE_endutent
#define __CRT_HAVE_environ
#define __CRT_HAVE_envz_add
#define __CRT_HAVE_envz_entry
#define __CRT_HAVE_envz_get
#define __CRT_HAVE_envz_merge
#define __CRT_HAVE_envz_remove
#define __CRT_HAVE_envz_strip
#define __CRT_HAVE_erand48
#define __CRT_HAVE_erand48_r
#define __CRT_HAVE_erf
#define __CRT_HAVE_erfc
#define __CRT_HAVE_erfcf
#define __CRT_HAVE_erff
#define __CRT_HAVE_erfl
#define __CRT_HAVE_err
#define __CRT_HAVE_errno
#define __CRT_HAVE_error
#define __CRT_HAVE_error_at_line
#define __CRT_HAVE_error_message_count
#define __CRT_HAVE_error_one_per_line
#define __CRT_HAVE_error_print_progname
#define __CRT_HAVE_errx
#define __CRT_HAVE_ether_aton
#define __CRT_HAVE_ether_aton_r
#define __CRT_HAVE_ether_hostton
#define __CRT_HAVE_ether_line
#define __CRT_HAVE_ether_ntoa
#define __CRT_HAVE_ether_ntoa_r
#define __CRT_HAVE_ether_ntohost
#define __CRT_HAVE_euidaccess
#define __CRT_HAVE_execl
#define __CRT_HAVE_execle
#define __CRT_HAVE_execlp
#define __CRT_HAVE_execv
#define __CRT_HAVE_execve
#define __CRT_HAVE_execvp
#define __CRT_HAVE_exit
#define __CRT_HAVE_exp
#define __CRT_HAVE_expf
#define __CRT_HAVE_expl
#define __CRT_HAVE_expm1
#define __CRT_HAVE_expm1f
#define __CRT_HAVE_expm1l
#define __CRT_HAVE_fabs
#define __CRT_HAVE_fabsf
#define __CRT_HAVE_fabsl
#define __CRT_HAVE_fchdir
#define __CRT_HAVE_fchflags
#define __CRT_HAVE_fchmod
#define __CRT_HAVE_fchown
#define __CRT_HAVE_fclose
#define __CRT_HAVE_fcloseall
#define __CRT_HAVE_fcntl
#define __CRT_HAVE_fcvt
#define __CRT_HAVE_fcvt_r
#define __CRT_HAVE_fdatasync
#define __CRT_HAVE_fdopen
#define __CRT_HAVE_feof
#define __CRT_HAVE_feof_unlocked
#define __CRT_HAVE_ferror
#define __CRT_HAVE_ferror_unlocked
#define __CRT_HAVE_fexecve
#define __CRT_HAVE_fflush
#define __CRT_HAVE_fflush_unlocked
#define __CRT_HAVE_ffs
#define __CRT_HAVE_fgetc
#define __CRT_HAVE_fgetgrent
#define __CRT_HAVE_fgetgrent_r
#define __CRT_HAVE_fgetpos
#define __CRT_HAVE_fgetpwent
#define __CRT_HAVE_fgetpwent_r
#define __CRT_HAVE_fgets
#define __CRT_HAVE_fgetspent
#define __CRT_HAVE_fgetspent_r
#define __CRT_HAVE_fileno
#define __CRT_HAVE_fileno_unlocked
#define __CRT_HAVE_finite
#define __CRT_HAVE_finitef
#define __CRT_HAVE_finitel
#define __CRT_HAVE_flock
#define __CRT_HAVE_flockfile
#define __CRT_HAVE_floor
#define __CRT_HAVE_floorf
#define __CRT_HAVE_floorl
#define __CRT_HAVE_fmod
#define __CRT_HAVE_fmodf
#define __CRT_HAVE_fmodl
#define __CRT_HAVE_fnmatch
#define __CRT_HAVE_fopen
#define __CRT_HAVE_fopencookie
#define __CRT_HAVE_fork
#define __CRT_HAVE_forkpty
#define __CRT_HAVE_fpathconf
#define __CRT_HAVE_fprintf
#define __CRT_HAVE_fputc
#define __CRT_HAVE_fputc_unlocked
#define __CRT_HAVE_fputs
#define __CRT_HAVE_fread
#define __CRT_HAVE_free
#define __CRT_HAVE_freeaddrinfo
#define __CRT_HAVE_freopen
#define __CRT_HAVE_frexp
#define __CRT_HAVE_frexpf
#define __CRT_HAVE_frexpl
#define __CRT_HAVE_fscanf
#define __CRT_HAVE_fseek
#define __CRT_HAVE_fsetpos
#define __CRT_HAVE_fstatfs
#define __CRT_HAVE_fsync
#define __CRT_HAVE_ftell
#define __CRT_HAVE_ftime
#define __CRT_HAVE_ftok
#define __CRT_HAVE_ftruncate
#define __CRT_HAVE_ftrylockfile
#define __CRT_HAVE_fts_children
#define __CRT_HAVE_fts_close
#define __CRT_HAVE_fts_open
#define __CRT_HAVE_fts_read
#define __CRT_HAVE_fts_set
#define __CRT_HAVE_ftw
#define __CRT_HAVE_funlockfile
#define __CRT_HAVE_fwrite
#define __CRT_HAVE_gamma
#define __CRT_HAVE_gammaf
#define __CRT_HAVE_gammal
#define __CRT_HAVE_gcvt
#define __CRT_HAVE_get_avphys_pages
#define __CRT_HAVE_get_current_dir_name
#define __CRT_HAVE_get_kernel_syms
#define __CRT_HAVE_get_myaddress
#define __CRT_HAVE_get_nprocs
#define __CRT_HAVE_get_nprocs_conf
#define __CRT_HAVE_get_phys_pages
#define __CRT_HAVE_getaddrinfo
#define __CRT_HAVE_getaliasbyname
#define __CRT_HAVE_getaliasbyname_r
#define __CRT_HAVE_getaliasent
#define __CRT_HAVE_getaliasent_r
#define __CRT_HAVE_getc
#define __CRT_HAVE_getc_unlocked
#define __CRT_HAVE_getchar
#define __CRT_HAVE_getchar_unlocked
#define __CRT_HAVE_getcwd
#define __CRT_HAVE_getdelim
#define __CRT_HAVE_getdirentries
#define __CRT_HAVE_getdomainname
#define __CRT_HAVE_getdtablesize
#define __CRT_HAVE_getegid
#define __CRT_HAVE_getenv
#define __CRT_HAVE_geteuid
#define __CRT_HAVE_getfsent
#define __CRT_HAVE_getfsfile
#define __CRT_HAVE_getfsspec
#define __CRT_HAVE_getgid
#define __CRT_HAVE_getgrent
#define __CRT_HAVE_getgrent_r
#define __CRT_HAVE_getgrgid
#define __CRT_HAVE_getgrgid_r
#define __CRT_HAVE_getgrnam
#define __CRT_HAVE_getgrnam_r
#define __CRT_HAVE_getgroups
#define __CRT_HAVE_gethostbyaddr
#define __CRT_HAVE_gethostbyaddr_r
#define __CRT_HAVE_gethostbyname
#define __CRT_HAVE_gethostbyname2
#define __CRT_HAVE_gethostbyname2_r
#define __CRT_HAVE_gethostbyname_r
#define __CRT_HAVE_gethostent
#define __CRT_HAVE_gethostent_r
#define __CRT_HAVE_gethostid
#define __CRT_HAVE_gethostname
#define __CRT_HAVE_getitimer
#define __CRT_HAVE_getline
#define __CRT_HAVE_getlogin
#define __CRT_HAVE_getlogin_r
#define __CRT_HAVE_getmntent
#define __CRT_HAVE_getmntent_r
#define __CRT_HAVE_getnetbyaddr
#define __CRT_HAVE_getnetbyaddr_r
#define __CRT_HAVE_getnetbyname
#define __CRT_HAVE_getnetbyname_r
#define __CRT_HAVE_getnetent
#define __CRT_HAVE_getnetent_r
#define __CRT_HAVE_getnetgrent
#define __CRT_HAVE_getnetgrent_r
#define __CRT_HAVE_getopt
#define __CRT_HAVE_getopt_long
#define __CRT_HAVE_getopt_long_only
#define __CRT_HAVE_getpagesize
#define __CRT_HAVE_getpass
#define __CRT_HAVE_getpeername
#define __CRT_HAVE_getpgid
#define __CRT_HAVE_getpgrp
#define __CRT_HAVE_getpid
#define __CRT_HAVE_getppid
#define __CRT_HAVE_getpriority
#define __CRT_HAVE_getprotobyname
#define __CRT_HAVE_getprotobyname_r
#define __CRT_HAVE_getprotobynumber
#define __CRT_HAVE_getprotobynumber_r
#define __CRT_HAVE_getprotoent
#define __CRT_HAVE_getprotoent_r
#define __CRT_HAVE_getpublickey
#define __CRT_HAVE_getpw
#define __CRT_HAVE_getpwent
#define __CRT_HAVE_getpwent_r
#define __CRT_HAVE_getpwnam
#define __CRT_HAVE_getpwnam_r
#define __CRT_HAVE_getpwuid
#define __CRT_HAVE_getpwuid_r
#define __CRT_HAVE_getrlimit
#define __CRT_HAVE_getrpcbyname
#define __CRT_HAVE_getrpcbyname_r
#define __CRT_HAVE_getrpcbynumber
#define __CRT_HAVE_getrpcbynumber_r
#define __CRT_HAVE_getrpcent
#define __CRT_HAVE_getrpcent_r
#define __CRT_HAVE_getrpcport
#define __CRT_HAVE_getrusage
#define __CRT_HAVE_gets
#define __CRT_HAVE_getsecretkey
#define __CRT_HAVE_getservbyname
#define __CRT_HAVE_getservbyname_r
#define __CRT_HAVE_getservbyport
#define __CRT_HAVE_getservbyport_r
#define __CRT_HAVE_getservent
#define __CRT_HAVE_getservent_r
#define __CRT_HAVE_getsid
#define __CRT_HAVE_getsockname
#define __CRT_HAVE_getsockopt
#define __CRT_HAVE_getspent
#define __CRT_HAVE_getspent_r
#define __CRT_HAVE_getspnam
#define __CRT_HAVE_getspnam_r
#define __CRT_HAVE_getsubopt
#define __CRT_HAVE_gettext
#define __CRT_HAVE_gettimeofday
#define __CRT_HAVE_getttyent
#define __CRT_HAVE_getttynam
#define __CRT_HAVE_getuid
#define __CRT_HAVE_getusershell
#define __CRT_HAVE_getutent
#define __CRT_HAVE_getutent_r
#define __CRT_HAVE_getutid
#define __CRT_HAVE_getutid_r
#define __CRT_HAVE_getutline
#define __CRT_HAVE_getutline_r
#define __CRT_HAVE_getw
#define __CRT_HAVE_getwd
#define __CRT_HAVE_glob
#define __CRT_HAVE_globfree
#define __CRT_HAVE_gmtime
#define __CRT_HAVE_gmtime_r
#define __CRT_HAVE_group_member
#define __CRT_HAVE_gsignal
#define __CRT_HAVE_gtty
#define __CRT_HAVE_h_errlist
#define __CRT_HAVE_h_nerr
#define __CRT_HAVE_hasmntopt
#define __CRT_HAVE_hcreate
#define __CRT_HAVE_hcreate_r
#define __CRT_HAVE_hdestroy
#define __CRT_HAVE_hdestroy_r
#define __CRT_HAVE_herror
#define __CRT_HAVE_hsearch
#define __CRT_HAVE_hsearch_r
#define __CRT_HAVE_hstrerror
#define __CRT_HAVE_htonl
#define __CRT_HAVE_htons
#define __CRT_HAVE_hypot
#define __CRT_HAVE_hypotf
#define __CRT_HAVE_hypotl
#define __CRT_HAVE_ilogb
#define __CRT_HAVE_ilogbf
#define __CRT_HAVE_ilogbl
#define __CRT_HAVE_index
#define __CRT_HAVE_inet_addr
#define __CRT_HAVE_inet_aton
#define __CRT_HAVE_inet_lnaof
#define __CRT_HAVE_inet_makeaddr
#define __CRT_HAVE_inet_netof
#define __CRT_HAVE_inet_network
#define __CRT_HAVE_inet_nsap_addr
#define __CRT_HAVE_inet_nsap_ntoa
#define __CRT_HAVE_inet_ntoa
#define __CRT_HAVE_inet_ntop
#define __CRT_HAVE_inet_pton
#define __CRT_HAVE_init_module
#define __CRT_HAVE_initgroups
#define __CRT_HAVE_initstate
#define __CRT_HAVE_initstate_r
#define __CRT_HAVE_innetgr
#define __CRT_HAVE_insque
#define __CRT_HAVE_ioctl
#define __CRT_HAVE_ioperm
#define __CRT_HAVE_iopl
#define __CRT_HAVE_iruserok
#define __CRT_HAVE_isalnum
#define __CRT_HAVE_isalpha
#define __CRT_HAVE_isascii
#define __CRT_HAVE_isatty
#define __CRT_HAVE_isblank
#define __CRT_HAVE_iscntrl
#define __CRT_HAVE_isdigit
#define __CRT_HAVE_isfdtype
#define __CRT_HAVE_isgraph
#define __CRT_HAVE_isinf
#define __CRT_HAVE_isinff
#define __CRT_HAVE_isinfl
#define __CRT_HAVE_islower
#define __CRT_HAVE_isnan
#define __CRT_HAVE_isnanf
#define __CRT_HAVE_isnanl
#define __CRT_HAVE_isprint
#define __CRT_HAVE_ispunct
#define __CRT_HAVE_isspace
#define __CRT_HAVE_isupper
#define __CRT_HAVE_iswalnum
#define __CRT_HAVE_iswalpha
#define __CRT_HAVE_iswcntrl
#define __CRT_HAVE_iswctype
#define __CRT_HAVE_iswdigit
#define __CRT_HAVE_iswgraph
#define __CRT_HAVE_iswlower
#define __CRT_HAVE_iswprint
#define __CRT_HAVE_iswpunct
#define __CRT_HAVE_iswspace
#define __CRT_HAVE_iswupper
#define __CRT_HAVE_iswxdigit
#define __CRT_HAVE_isxdigit
#define __CRT_HAVE_j0
#define __CRT_HAVE_j0f
#define __CRT_HAVE_j0l
#define __CRT_HAVE_j1
#define __CRT_HAVE_j1f
#define __CRT_HAVE_j1l
#define __CRT_HAVE_jn
#define __CRT_HAVE_jnf
#define __CRT_HAVE_jnl
#define __CRT_HAVE_jrand48
#define __CRT_HAVE_jrand48_r
#define __CRT_HAVE_kill
#define __CRT_HAVE_killpg
#define __CRT_HAVE_klogctl
#define __CRT_HAVE_l64a
#define __CRT_HAVE_labs
#define __CRT_HAVE_lchown
#define __CRT_HAVE_lckpwdf
#define __CRT_HAVE_lcong48
#define __CRT_HAVE_lcong48_r
#define __CRT_HAVE_ldexp
#define __CRT_HAVE_ldexpf
#define __CRT_HAVE_ldexpl
#define __CRT_HAVE_ldiv
#define __CRT_HAVE_lfind
#define __CRT_HAVE_lgamma
#define __CRT_HAVE_lgamma_r
#define __CRT_HAVE_lgammaf
#define __CRT_HAVE_lgammaf_r
#define __CRT_HAVE_lgammal
#define __CRT_HAVE_lgammal_r
#define __CRT_HAVE_link
#define __CRT_HAVE_listen
#define __CRT_HAVE_llabs
#define __CRT_HAVE_lldiv
#define __CRT_HAVE_llseek
#define __CRT_HAVE_loc1
#define __CRT_HAVE_loc2
#define __CRT_HAVE_localeconv
#define __CRT_HAVE_localtime
#define __CRT_HAVE_localtime_r
#define __CRT_HAVE_lockf
#define __CRT_HAVE_locs
#define __CRT_HAVE_log
#define __CRT_HAVE_log10
#define __CRT_HAVE_log10f
#define __CRT_HAVE_log10l
#define __CRT_HAVE_log1p
#define __CRT_HAVE_log1pf
#define __CRT_HAVE_log1pl
#define __CRT_HAVE_logb
#define __CRT_HAVE_logbf
#define __CRT_HAVE_logbl
#define __CRT_HAVE_logf
#define __CRT_HAVE_login
#define __CRT_HAVE_login_tty
#define __CRT_HAVE_logl
#define __CRT_HAVE_logout
#define __CRT_HAVE_logwtmp
#define __CRT_HAVE_longjmp
#define __CRT_HAVE_lrand48
#define __CRT_HAVE_lrand48_r
#define __CRT_HAVE_lsearch
#define __CRT_HAVE_lseek
#define __CRT_HAVE_madvise
#define __CRT_HAVE_mallinfo
#define __CRT_HAVE_malloc
#define __CRT_HAVE_malloc_stats
#define __CRT_HAVE_malloc_trim
#define __CRT_HAVE_malloc_usable_size
#define __CRT_HAVE_mallopt
#define __CRT_HAVE_mallwatch
#define __CRT_HAVE_matherr
#define __CRT_HAVE_mblen
#define __CRT_HAVE_mbrlen
#define __CRT_HAVE_mbrtowc
#define __CRT_HAVE_mbsinit
#define __CRT_HAVE_mbsnrtowcs
#define __CRT_HAVE_mbsrtowcs
#define __CRT_HAVE_mbstowcs
#define __CRT_HAVE_mbtowc
#define __CRT_HAVE_mcheck
#define __CRT_HAVE_mcount
#define __CRT_HAVE_memalign
#define __CRT_HAVE_memccpy
#define __CRT_HAVE_memchr
#define __CRT_HAVE_memcmp
#define __CRT_HAVE_memcpy
#define __CRT_HAVE_memfrob
#define __CRT_HAVE_memmem
#define __CRT_HAVE_memmove
#define __CRT_HAVE_memset
#define __CRT_HAVE_mkdir
#define __CRT_HAVE_mkfifo
#define __CRT_HAVE_mkstemp
#define __CRT_HAVE_mktemp
#define __CRT_HAVE_mktime
#define __CRT_HAVE_mlock
#define __CRT_HAVE_mlockall
#define __CRT_HAVE_mmap
#define __CRT_HAVE_modf
#define __CRT_HAVE_modff
#define __CRT_HAVE_modfl
#define __CRT_HAVE_monstartup
#define __CRT_HAVE_mount
#define __CRT_HAVE_mprobe
#define __CRT_HAVE_mprotect
#define __CRT_HAVE_mrand48
#define __CRT_HAVE_mrand48_r
#define __CRT_HAVE_mremap
#define __CRT_HAVE_msgctl
#define __CRT_HAVE_msgget
#define __CRT_HAVE_msgrcv
#define __CRT_HAVE_msgsnd
#define __CRT_HAVE_msync
#define __CRT_HAVE_mtrace
#define __CRT_HAVE_munlock
#define __CRT_HAVE_munlockall
#define __CRT_HAVE_munmap
#define __CRT_HAVE_muntrace
#define __CRT_HAVE_nanosleep
#define __CRT_HAVE_nextafter
#define __CRT_HAVE_nextafterf
#define __CRT_HAVE_nextafterl
#define __CRT_HAVE_nice
#define __CRT_HAVE_nl_langinfo
#define __CRT_HAVE_nrand48
#define __CRT_HAVE_nrand48_r
#define __CRT_HAVE_ntohl
#define __CRT_HAVE_ntohs
#define __CRT_HAVE_obstack_alloc_failed_handler
#define __CRT_HAVE_obstack_exit_failure
#define __CRT_HAVE_obstack_free
#define __CRT_HAVE_obstack_printf
#define __CRT_HAVE_obstack_vprintf
#define __CRT_HAVE_on_exit
#define __CRT_HAVE_open
#define __CRT_HAVE_open_memstream
#define __CRT_HAVE_opendir
#define __CRT_HAVE_openlog
#define __CRT_HAVE_openpty
#define __CRT_HAVE_optarg
#define __CRT_HAVE_opterr
#define __CRT_HAVE_optind
#define __CRT_HAVE_optopt
#define __CRT_HAVE_parse_printf_format
#define __CRT_HAVE_pathconf
#define __CRT_HAVE_pause
#define __CRT_HAVE_pclose
#define __CRT_HAVE_perror
#define __CRT_HAVE_personality
#define __CRT_HAVE_pipe
#define __CRT_HAVE_pmap_getmaps
#define __CRT_HAVE_pmap_getport
#define __CRT_HAVE_pmap_rmtcall
#define __CRT_HAVE_pmap_set
#define __CRT_HAVE_pmap_unset
#define __CRT_HAVE_poll
#define __CRT_HAVE_popen
#define __CRT_HAVE_pow
#define __CRT_HAVE_powf
#define __CRT_HAVE_powl
#define __CRT_HAVE_printf
#define __CRT_HAVE_profil
#define __CRT_HAVE_program_invocation_name
#define __CRT_HAVE_program_invocation_short_name
#define __CRT_HAVE_pselect
#define __CRT_HAVE_psignal
#define __CRT_HAVE_pthread_attr_destroy
#define __CRT_HAVE_pthread_attr_getdetachstate
#define __CRT_HAVE_pthread_attr_getinheritsched
#define __CRT_HAVE_pthread_attr_getschedparam
#define __CRT_HAVE_pthread_attr_getschedpolicy
#define __CRT_HAVE_pthread_attr_getscope
#define __CRT_HAVE_pthread_attr_init
#define __CRT_HAVE_pthread_attr_setdetachstate
#define __CRT_HAVE_pthread_attr_setinheritsched
#define __CRT_HAVE_pthread_attr_setschedparam
#define __CRT_HAVE_pthread_attr_setschedpolicy
#define __CRT_HAVE_pthread_attr_setscope
#define __CRT_HAVE_pthread_cond_broadcast
#define __CRT_HAVE_pthread_cond_destroy
#define __CRT_HAVE_pthread_cond_init
#define __CRT_HAVE_pthread_cond_signal
#define __CRT_HAVE_pthread_cond_wait
#define __CRT_HAVE_pthread_condattr_destroy
#define __CRT_HAVE_pthread_condattr_init
#define __CRT_HAVE_pthread_equal
#define __CRT_HAVE_pthread_exit
#define __CRT_HAVE_pthread_getschedparam
#define __CRT_HAVE_pthread_mutex_destroy
#define __CRT_HAVE_pthread_mutex_init
#define __CRT_HAVE_pthread_mutex_lock
#define __CRT_HAVE_pthread_mutex_unlock
#define __CRT_HAVE_pthread_self
#define __CRT_HAVE_pthread_setcancelstate
#define __CRT_HAVE_pthread_setcanceltype
#define __CRT_HAVE_pthread_setschedparam
#define __CRT_HAVE_ptrace
#define __CRT_HAVE_putc
#define __CRT_HAVE_putc_unlocked
#define __CRT_HAVE_putchar
#define __CRT_HAVE_putchar_unlocked
#define __CRT_HAVE_putenv
#define __CRT_HAVE_putpwent
#define __CRT_HAVE_puts
#define __CRT_HAVE_putspent
#define __CRT_HAVE_pututline
#define __CRT_HAVE_putw
#define __CRT_HAVE_pvalloc
#define __CRT_HAVE_qecvt
#define __CRT_HAVE_qecvt_r
#define __CRT_HAVE_qfcvt
#define __CRT_HAVE_qfcvt_r
#define __CRT_HAVE_qgcvt
#define __CRT_HAVE_qsort
#define __CRT_HAVE_raise
#define __CRT_HAVE_rand
#define __CRT_HAVE_rand_r
#define __CRT_HAVE_random
#define __CRT_HAVE_random_r
#define __CRT_HAVE_rcmd
#define __CRT_HAVE_re_comp
#define __CRT_HAVE_re_compile_fastmap
#define __CRT_HAVE_re_compile_pattern
#define __CRT_HAVE_re_exec
#define __CRT_HAVE_re_match
#define __CRT_HAVE_re_match_2
#define __CRT_HAVE_re_max_failures
#define __CRT_HAVE_re_search
#define __CRT_HAVE_re_search_2
#define __CRT_HAVE_re_set_registers
#define __CRT_HAVE_re_set_syntax
#define __CRT_HAVE_re_syntax_options
#define __CRT_HAVE_read
#define __CRT_HAVE_readdir
#define __CRT_HAVE_readdir_r
#define __CRT_HAVE_readlink
#define __CRT_HAVE_readv
#define __CRT_HAVE_realloc
#define __CRT_HAVE_realpath
#define __CRT_HAVE_reboot
#define __CRT_HAVE_recv
#define __CRT_HAVE_recvfrom
#define __CRT_HAVE_recvmsg
#define __CRT_HAVE_regcomp
#define __CRT_HAVE_regerror
#define __CRT_HAVE_regexec
#define __CRT_HAVE_regfree
#define __CRT_HAVE_register_printf_function
#define __CRT_HAVE_registerrpc
#define __CRT_HAVE_remainder
#define __CRT_HAVE_remainderf
#define __CRT_HAVE_remainderl
#define __CRT_HAVE_remove
#define __CRT_HAVE_remque
#define __CRT_HAVE_rename
#define __CRT_HAVE_revoke
#define __CRT_HAVE_rewind
#define __CRT_HAVE_rewinddir
#define __CRT_HAVE_rexec
#define __CRT_HAVE_rexecoptions
#define __CRT_HAVE_rindex
#define __CRT_HAVE_rint
#define __CRT_HAVE_rintf
#define __CRT_HAVE_rintl
#define __CRT_HAVE_rmdir
#define __CRT_HAVE_rpc_createerr
#define __CRT_HAVE_rpmatch
#define __CRT_HAVE_rresvport
#define __CRT_HAVE_ruserok
#define __CRT_HAVE_ruserpass
#define __CRT_HAVE_sbrk
#define __CRT_HAVE_scalb
#define __CRT_HAVE_scalbf
#define __CRT_HAVE_scalbl
#define __CRT_HAVE_scalbn
#define __CRT_HAVE_scalbnf
#define __CRT_HAVE_scalbnl
#define __CRT_HAVE_scandir
#define __CRT_HAVE_scanf
#define __CRT_HAVE_sched_get_priority_max
#define __CRT_HAVE_sched_get_priority_min
#define __CRT_HAVE_sched_getparam
#define __CRT_HAVE_sched_getscheduler
#define __CRT_HAVE_sched_rr_get_interval
#define __CRT_HAVE_sched_setparam
#define __CRT_HAVE_sched_setscheduler
#define __CRT_HAVE_sched_yield
#define __CRT_HAVE_seed48
#define __CRT_HAVE_seed48_r
#define __CRT_HAVE_seekdir
#define __CRT_HAVE_select
#define __CRT_HAVE_semctl
#define __CRT_HAVE_semget
#define __CRT_HAVE_semop
#define __CRT_HAVE_send
#define __CRT_HAVE_sendmsg
#define __CRT_HAVE_sendto
#define __CRT_HAVE_setaliasent
#define __CRT_HAVE_setbuf
#define __CRT_HAVE_setbuffer
#define __CRT_HAVE_setdomainname
#define __CRT_HAVE_setegid
#define __CRT_HAVE_setenv
#define __CRT_HAVE_seteuid
#define __CRT_HAVE_setfsent
#define __CRT_HAVE_setfsgid
#define __CRT_HAVE_setfsuid
#define __CRT_HAVE_setgid
#define __CRT_HAVE_setgrent
#define __CRT_HAVE_setgroups
#define __CRT_HAVE_sethostent
#define __CRT_HAVE_sethostid
#define __CRT_HAVE_sethostname
#define __CRT_HAVE_setitimer
#define __CRT_HAVE_setjmp
#define __CRT_HAVE_setlinebuf
#define __CRT_HAVE_setlocale
#define __CRT_HAVE_setlogin
#define __CRT_HAVE_setlogmask
#define __CRT_HAVE_setmntent
#define __CRT_HAVE_setnetent
#define __CRT_HAVE_setnetgrent
#define __CRT_HAVE_setpgid
#define __CRT_HAVE_setpgrp
#define __CRT_HAVE_setpriority
#define __CRT_HAVE_setprotoent
#define __CRT_HAVE_setpwent
#define __CRT_HAVE_setregid
#define __CRT_HAVE_setreuid
#define __CRT_HAVE_setrlimit
#define __CRT_HAVE_setrpcent
#define __CRT_HAVE_setservent
#define __CRT_HAVE_setsid
#define __CRT_HAVE_setsockopt
#define __CRT_HAVE_setspent
#define __CRT_HAVE_setstate
#define __CRT_HAVE_setstate_r
#define __CRT_HAVE_settimeofday
#define __CRT_HAVE_setttyent
#define __CRT_HAVE_setuid
#define __CRT_HAVE_setusershell
#define __CRT_HAVE_setutent
#define __CRT_HAVE_setvbuf
#define __CRT_HAVE_sgetspent
#define __CRT_HAVE_sgetspent_r
#define __CRT_HAVE_shmat
#define __CRT_HAVE_shmctl
#define __CRT_HAVE_shmdt
#define __CRT_HAVE_shmget
#define __CRT_HAVE_shutdown
#define __CRT_HAVE_sigaction
#define __CRT_HAVE_sigaddset
#define __CRT_HAVE_sigaltstack
#define __CRT_HAVE_sigblock
#define __CRT_HAVE_sigdelset
#define __CRT_HAVE_sigemptyset
#define __CRT_HAVE_sigfillset
#define __CRT_HAVE_siggetmask
#define __CRT_HAVE_siginterrupt
#define __CRT_HAVE_sigismember
#define __CRT_HAVE_siglongjmp
#define __CRT_HAVE_signal
#define __CRT_HAVE_signgam
#define __CRT_HAVE_significand
#define __CRT_HAVE_significandf
#define __CRT_HAVE_significandl
#define __CRT_HAVE_sigpause
#define __CRT_HAVE_sigpending
#define __CRT_HAVE_sigprocmask
#define __CRT_HAVE_sigreturn
#define __CRT_HAVE_sigsetmask
#define __CRT_HAVE_sigstack
#define __CRT_HAVE_sigsuspend
#define __CRT_HAVE_sigvec
#define __CRT_HAVE_sigwait
#define __CRT_HAVE_sin
#define __CRT_HAVE_sinf
#define __CRT_HAVE_sinh
#define __CRT_HAVE_sinhf
#define __CRT_HAVE_sinhl
#define __CRT_HAVE_sinl
#define __CRT_HAVE_sleep
#define __CRT_HAVE_snprintf
#define __CRT_HAVE_socket
#define __CRT_HAVE_socketpair
#define __CRT_HAVE_sprintf
#define __CRT_HAVE_sqrt
#define __CRT_HAVE_sqrtf
#define __CRT_HAVE_sqrtl
#define __CRT_HAVE_srand
#define __CRT_HAVE_srand48
#define __CRT_HAVE_srand48_r
#define __CRT_HAVE_srandom
#define __CRT_HAVE_srandom_r
#define __CRT_HAVE_sscanf
#define __CRT_HAVE_ssignal
#define __CRT_HAVE_sstk
#define __CRT_HAVE_statfs
#define __CRT_HAVE_stderr
#define __CRT_HAVE_stdin
#define __CRT_HAVE_stdout
#define __CRT_HAVE_step
#define __CRT_HAVE_stime
#define __CRT_HAVE_stpcpy
#define __CRT_HAVE_stpncpy
#define __CRT_HAVE_strcasecmp
#define __CRT_HAVE_strcat
#define __CRT_HAVE_strchr
#define __CRT_HAVE_strcmp
#define __CRT_HAVE_strcoll
#define __CRT_HAVE_strcpy
#define __CRT_HAVE_strcspn
#define __CRT_HAVE_strdup
#define __CRT_HAVE_strerror
#define __CRT_HAVE_strerror_r
#define __CRT_HAVE_strfmon
#define __CRT_HAVE_strfry
#define __CRT_HAVE_strftime
#define __CRT_HAVE_strlen
#define __CRT_HAVE_strncasecmp
#define __CRT_HAVE_strncat
#define __CRT_HAVE_strncmp
#define __CRT_HAVE_strncpy
#define __CRT_HAVE_strndup
#define __CRT_HAVE_strnlen
#define __CRT_HAVE_strpbrk
#define __CRT_HAVE_strptime
#define __CRT_HAVE_strrchr
#define __CRT_HAVE_strsep
#define __CRT_HAVE_strsignal
#define __CRT_HAVE_strspn
#define __CRT_HAVE_strstr
#define __CRT_HAVE_strtod
#define __CRT_HAVE_strtof
#define __CRT_HAVE_strtok
#define __CRT_HAVE_strtok_r
#define __CRT_HAVE_strtol
#define __CRT_HAVE_strtold
#define __CRT_HAVE_strtoll
#define __CRT_HAVE_strtoq
#define __CRT_HAVE_strtoul
#define __CRT_HAVE_strtoull
#define __CRT_HAVE_strtouq
#define __CRT_HAVE_strxfrm
#define __CRT_HAVE_stty
#define __CRT_HAVE_svc_fdset
#define __CRT_HAVE_svc_getreq
#define __CRT_HAVE_svc_getreqset
#define __CRT_HAVE_svc_register
#define __CRT_HAVE_svc_run
#define __CRT_HAVE_svc_sendreply
#define __CRT_HAVE_svc_unregister
#define __CRT_HAVE_svcerr_auth
#define __CRT_HAVE_svcerr_decode
#define __CRT_HAVE_svcerr_noproc
#define __CRT_HAVE_svcerr_noprog
#define __CRT_HAVE_svcerr_progvers
#define __CRT_HAVE_svcerr_systemerr
#define __CRT_HAVE_svcerr_weakauth
#define __CRT_HAVE_svcfd_create
#define __CRT_HAVE_svcraw_create
#define __CRT_HAVE_svctcp_create
#define __CRT_HAVE_svcudp_bufcreate
#define __CRT_HAVE_svcudp_create
#define __CRT_HAVE_svcudp_enablecache
#define __CRT_HAVE_swab
#define __CRT_HAVE_swapoff
#define __CRT_HAVE_swapon
#define __CRT_HAVE_symlink
#define __CRT_HAVE_sync
#define __CRT_HAVE_sys_errlist
#define __CRT_HAVE_sys_nerr
#define __CRT_HAVE_sys_sigabbrev
#define __CRT_HAVE_sys_siglist
#define __CRT_HAVE_syscall
#define __CRT_HAVE_sysconf
#define __CRT_HAVE_sysctl
#define __CRT_HAVE_sysinfo
#define __CRT_HAVE_syslog
#define __CRT_HAVE_system
#define __CRT_HAVE_tan
#define __CRT_HAVE_tanf
#define __CRT_HAVE_tanh
#define __CRT_HAVE_tanhf
#define __CRT_HAVE_tanhl
#define __CRT_HAVE_tanl
#define __CRT_HAVE_tcdrain
#define __CRT_HAVE_tcflow
#define __CRT_HAVE_tcflush
#define __CRT_HAVE_tcgetattr
#define __CRT_HAVE_tcgetpgrp
#define __CRT_HAVE_tcsendbreak
#define __CRT_HAVE_tcsetattr
#define __CRT_HAVE_tcsetpgrp
#define __CRT_HAVE_tdelete
#define __CRT_HAVE_telldir
#define __CRT_HAVE_tempnam
#define __CRT_HAVE_textdomain
#define __CRT_HAVE_tfind
#define __CRT_HAVE_time
#define __CRT_HAVE_timegm
#define __CRT_HAVE_timelocal
#define __CRT_HAVE_times
#define __CRT_HAVE_timezone
#define __CRT_HAVE_tmpfile
#define __CRT_HAVE_tmpnam
#define __CRT_HAVE_tmpnam_r
#define __CRT_HAVE_toascii
#define __CRT_HAVE_tolower
#define __CRT_HAVE_toupper
#define __CRT_HAVE_towctrans
#define __CRT_HAVE_towlower
#define __CRT_HAVE_towupper
#define __CRT_HAVE_tr_break
#define __CRT_HAVE_truncate
#define __CRT_HAVE_tsearch
#define __CRT_HAVE_ttyname
#define __CRT_HAVE_ttyname_r
#define __CRT_HAVE_ttyslot
#define __CRT_HAVE_twalk
#define __CRT_HAVE_tzname
#define __CRT_HAVE_tzset
#define __CRT_HAVE_ualarm
#define __CRT_HAVE_ulckpwdf
#define __CRT_HAVE_ulimit
#define __CRT_HAVE_umask
#define __CRT_HAVE_umount
#define __CRT_HAVE_uname
#define __CRT_HAVE_ungetc
#define __CRT_HAVE_unlink
#define __CRT_HAVE_unsetenv
#define __CRT_HAVE_uselib
#define __CRT_HAVE_usleep
#define __CRT_HAVE_ustat
#define __CRT_HAVE_utime
#define __CRT_HAVE_utimes
#define __CRT_HAVE_utmpname
#define __CRT_HAVE_valloc
#define __CRT_HAVE_vasprintf
#define __CRT_HAVE_vdprintf
#define __CRT_HAVE_verr
#define __CRT_HAVE_verrx
#define __CRT_HAVE_vfork
#define __CRT_HAVE_vfprintf
#define __CRT_HAVE_vfscanf
#define __CRT_HAVE_vhangup
#define __CRT_HAVE_vlimit
#define __CRT_HAVE_vprintf
#define __CRT_HAVE_vscanf
#define __CRT_HAVE_vsnprintf
#define __CRT_HAVE_vsprintf
#define __CRT_HAVE_vsscanf
#define __CRT_HAVE_vsyslog
#define __CRT_HAVE_vtimes
#define __CRT_HAVE_vwarn
#define __CRT_HAVE_vwarnx
#define __CRT_HAVE_wait
#define __CRT_HAVE_wait3
#define __CRT_HAVE_wait4
#define __CRT_HAVE_waitpid
#define __CRT_HAVE_warn
#define __CRT_HAVE_warnx
#define __CRT_HAVE_wcpcpy
#define __CRT_HAVE_wcpncpy
#define __CRT_HAVE_wcrtomb
#define __CRT_HAVE_wcscat
#define __CRT_HAVE_wcschr
#define __CRT_HAVE_wcscmp
#define __CRT_HAVE_wcscoll
#define __CRT_HAVE_wcscpy
#define __CRT_HAVE_wcscspn
#define __CRT_HAVE_wcsdup
#define __CRT_HAVE_wcslen
#define __CRT_HAVE_wcsncat
#define __CRT_HAVE_wcsncmp
#define __CRT_HAVE_wcsncpy
#define __CRT_HAVE_wcsnrtombs
#define __CRT_HAVE_wcspbrk
#define __CRT_HAVE_wcsrchr
#define __CRT_HAVE_wcsrtombs
#define __CRT_HAVE_wcsspn
#define __CRT_HAVE_wcsstr
#define __CRT_HAVE_wcstod
#define __CRT_HAVE_wcstof
#define __CRT_HAVE_wcstok
#define __CRT_HAVE_wcstol
#define __CRT_HAVE_wcstold
#define __CRT_HAVE_wcstombs
#define __CRT_HAVE_wcstoq
#define __CRT_HAVE_wcstoul
#define __CRT_HAVE_wcstouq
#define __CRT_HAVE_wcswidth
#define __CRT_HAVE_wcsxfrm
#define __CRT_HAVE_wctob
#define __CRT_HAVE_wctomb
#define __CRT_HAVE_wctrans
#define __CRT_HAVE_wctype
#define __CRT_HAVE_wcwidth
#define __CRT_HAVE_wmemchr
#define __CRT_HAVE_wmemcmp
#define __CRT_HAVE_wmemcpy
#define __CRT_HAVE_wmemmove
#define __CRT_HAVE_wmemset
#define __CRT_HAVE_write
#define __CRT_HAVE_writev
#define __CRT_HAVE_xdr_accepted_reply
#define __CRT_HAVE_xdr_array
#define __CRT_HAVE_xdr_authunix_parms
#define __CRT_HAVE_xdr_bool
#define __CRT_HAVE_xdr_bytes
#define __CRT_HAVE_xdr_callhdr
#define __CRT_HAVE_xdr_callmsg
#define __CRT_HAVE_xdr_char
#define __CRT_HAVE_xdr_des_block
#define __CRT_HAVE_xdr_double
#define __CRT_HAVE_xdr_enum
#define __CRT_HAVE_xdr_float
#define __CRT_HAVE_xdr_free
#define __CRT_HAVE_xdr_int
#define __CRT_HAVE_xdr_long
#define __CRT_HAVE_xdr_netobj
#define __CRT_HAVE_xdr_opaque
#define __CRT_HAVE_xdr_opaque_auth
#define __CRT_HAVE_xdr_pmap
#define __CRT_HAVE_xdr_pmaplist
#define __CRT_HAVE_xdr_pointer
#define __CRT_HAVE_xdr_reference
#define __CRT_HAVE_xdr_rejected_reply
#define __CRT_HAVE_xdr_replymsg
#define __CRT_HAVE_xdr_rmtcall_args
#define __CRT_HAVE_xdr_rmtcallres
#define __CRT_HAVE_xdr_short
#define __CRT_HAVE_xdr_string
#define __CRT_HAVE_xdr_u_char
#define __CRT_HAVE_xdr_u_int
#define __CRT_HAVE_xdr_u_long
#define __CRT_HAVE_xdr_u_short
#define __CRT_HAVE_xdr_union
#define __CRT_HAVE_xdr_vector
#define __CRT_HAVE_xdr_void
#define __CRT_HAVE_xdr_wrapstring
#define __CRT_HAVE_xdrmem_create
#define __CRT_HAVE_xdrrec_create
#define __CRT_HAVE_xdrrec_endofrecord
#define __CRT_HAVE_xdrrec_eof
#define __CRT_HAVE_xdrrec_skiprecord
#define __CRT_HAVE_xdrstdio_create
#define __CRT_HAVE_xprt_register
#define __CRT_HAVE_xprt_unregister
#define __CRT_HAVE_y0
#define __CRT_HAVE_y0f
#define __CRT_HAVE_y0l
#define __CRT_HAVE_y1
#define __CRT_HAVE_y1f
#define __CRT_HAVE_y1l
#define __CRT_HAVE_yn
#define __CRT_HAVE_ynf
#define __CRT_HAVE_ynl
#ifndef __x86_64__
#define __CRT_HAVE__IO_stderr_
#define __CRT_HAVE__IO_stdin_
#define __CRT_HAVE__IO_stdout_
#define __CRT_HAVE____brk_addr
#define __CRT_HAVE___divdi3
#define __CRT_HAVE___moddi3
#define __CRT_HAVE___strtoq_internal
#define __CRT_HAVE___strtouq_internal
#define __CRT_HAVE___udivdi3
#define __CRT_HAVE___umoddi3
#define __CRT_HAVE_atexit
#define __CRT_HAVE_res_init
#define __CRT_HAVE_vm86
#endif /* !__x86_64__ */
#if !defined(__x86_64__) && ((__GLIBC_VERSION__ >= 20302 && __GLIBC_VERSION__ <= 20900) || __GLIBC_VERSION__ == 21900 || __GLIBC_VERSION__ == 22100 || (__GLIBC_VERSION__ >= 22300 && __GLIBC_VERSION__ <= 22600))
#define __CRT_HAVE___cmpdi2
#define __CRT_HAVE___fixunsdfdi
#define __CRT_HAVE___fixunsxfdi
#define __CRT_HAVE___floatdidf
#define __CRT_HAVE___ucmpdi2
#endif /* !__x86_64__ && ((__GLIBC_VERSION__ >= 20302 && __GLIBC_VERSION__ <= 20900) || __GLIBC_VERSION__ == 21900 || __GLIBC_VERSION__ == 22100 || (__GLIBC_VERSION__ >= 22300 && __GLIBC_VERSION__ <= 22600)) */
#if !defined(__x86_64__) && ((__GLIBC_VERSION__ >= 21290 && __GLIBC_VERSION__ <= 21800) || __GLIBC_VERSION__ == 22000 || __GLIBC_VERSION__ == 22200 || __GLIBC_VERSION__ >= 22600)
#define __CRT_HAVE___uname
#endif /* !__x86_64__ && ((__GLIBC_VERSION__ >= 21290 && __GLIBC_VERSION__ <= 21800) || __GLIBC_VERSION__ == 22000 || __GLIBC_VERSION__ == 22200 || __GLIBC_VERSION__ >= 22600) */
#if !defined(__x86_64__) && __GLIBC_VERSION__ >= 20103
#define __CRT_HAVE__IO_stdin_used
#define __CRT_HAVE___deregister_frame
#define __CRT_HAVE___deregister_frame_info
#define __CRT_HAVE___frame_state_for
#define __CRT_HAVE___memcpy_c
#define __CRT_HAVE___memset_cc
#define __CRT_HAVE___memset_cg
#define __CRT_HAVE___memset_gg
#define __CRT_HAVE___register_frame
#define __CRT_HAVE___register_frame_info
#define __CRT_HAVE___register_frame_info_table
#define __CRT_HAVE___register_frame_table
#define __CRT_HAVE___strchr_c
#define __CRT_HAVE___strchr_g
#define __CRT_HAVE___strchrnul_c
#define __CRT_HAVE___strchrnul_g
#endif /* !__x86_64__ && __GLIBC_VERSION__ >= 20103 */
#if !defined(__x86_64__) && __GLIBC_VERSION__ >= 20205
#define __CRT_HAVE__Unwind_Find_FDE
#define __CRT_HAVE___deregister_frame_info_bases
#define __CRT_HAVE___register_frame_info_bases
#define __CRT_HAVE___register_frame_info_table_bases
#endif /* !__x86_64__ && __GLIBC_VERSION__ >= 20205 */
#if !defined(__x86_64__) && __GLIBC_VERSION__ >= 20302
#define __CRT_HAVE____tls_get_addr
#define __CRT_HAVE___memcpy_by2
#define __CRT_HAVE___memcpy_by4
#define __CRT_HAVE___memcpy_g
#define __CRT_HAVE___mempcpy_by2
#define __CRT_HAVE___mempcpy_by4
#define __CRT_HAVE___mempcpy_byn
#define __CRT_HAVE___memset_ccn_by2
#define __CRT_HAVE___memset_ccn_by4
#define __CRT_HAVE___memset_gcn_by2
#define __CRT_HAVE___memset_gcn_by4
#define __CRT_HAVE___stpcpy_g
#define __CRT_HAVE___strcat_c
#define __CRT_HAVE___strcat_g
#define __CRT_HAVE___strcmp_gg
#define __CRT_HAVE___strcpy_g
#define __CRT_HAVE___strcspn_cg
#define __CRT_HAVE___strcspn_g
#define __CRT_HAVE___strlen_g
#define __CRT_HAVE___strncat_g
#define __CRT_HAVE___strncmp_g
#define __CRT_HAVE___strncpy_by2
#define __CRT_HAVE___strncpy_by4
#define __CRT_HAVE___strncpy_byn
#define __CRT_HAVE___strncpy_gg
#define __CRT_HAVE___strpbrk_cg
#define __CRT_HAVE___strpbrk_g
#define __CRT_HAVE___strrchr_c
#define __CRT_HAVE___strrchr_g
#define __CRT_HAVE___strspn_cg
#define __CRT_HAVE___strspn_g
#define __CRT_HAVE___strstr_cg
#define __CRT_HAVE___strstr_g
#endif /* !__x86_64__ && __GLIBC_VERSION__ >= 20302 */
#if !defined(__x86_64__) && __GLIBC_VERSION__ >= 23200
#define __CRT_HAVE___clock_gettime64
#endif /* !__x86_64__ && __GLIBC_VERSION__ >= 23200 */
#if !defined(__x86_64__) && __GLIBC_VERSION__ >= 23400
#define __CRT_HAVE____adjtimex64
#define __CRT_HAVE___adjtime64
#define __CRT_HAVE___aio_suspend_time64
#define __CRT_HAVE___clock_adjtime64
#define __CRT_HAVE___clock_getres64
#define __CRT_HAVE___clock_nanosleep_time64
#define __CRT_HAVE___clock_settime64
#define __CRT_HAVE___cnd_timedwait64
#define __CRT_HAVE___ctime64
#define __CRT_HAVE___ctime64_r
#define __CRT_HAVE___difftime64
#define __CRT_HAVE___fcntl_time64
#define __CRT_HAVE___fstat64_time64
#define __CRT_HAVE___fstatat64_time64
#define __CRT_HAVE___fts64_children_time64
#define __CRT_HAVE___fts64_close_time64
#define __CRT_HAVE___fts64_open_time64
#define __CRT_HAVE___fts64_read_time64
#define __CRT_HAVE___fts64_set_time64
#define __CRT_HAVE___ftw64_time64
#define __CRT_HAVE___futimens64
#define __CRT_HAVE___futimes64
#define __CRT_HAVE___futimesat64
#define __CRT_HAVE___gai_suspend_time64
#define __CRT_HAVE___getitimer64
#define __CRT_HAVE___getrusage64
#define __CRT_HAVE___getsockopt64
#define __CRT_HAVE___gettimeofday64
#define __CRT_HAVE___glob64_time64
#define __CRT_HAVE___globfree64_time64
#define __CRT_HAVE___gmtime64
#define __CRT_HAVE___gmtime64_r
#define __CRT_HAVE___ioctl_time64
#define __CRT_HAVE___localtime64
#define __CRT_HAVE___localtime64_r
#define __CRT_HAVE___lstat64_time64
#define __CRT_HAVE___lutimes64
#define __CRT_HAVE___mktime64
#define __CRT_HAVE___mq_timedreceive_time64
#define __CRT_HAVE___mq_timedsend_time64
#define __CRT_HAVE___msgctl64
#define __CRT_HAVE___mtx_timedlock64
#define __CRT_HAVE___nanosleep64
#define __CRT_HAVE___nftw64_time64
#define __CRT_HAVE___ntp_gettime64
#define __CRT_HAVE___ntp_gettimex64
#define __CRT_HAVE___ppoll64
#define __CRT_HAVE___prctl_time64
#define __CRT_HAVE___pselect64
#define __CRT_HAVE___pthread_clockjoin_np64
#define __CRT_HAVE___pthread_cond_clockwait64
#define __CRT_HAVE___pthread_cond_timedwait64
#define __CRT_HAVE___pthread_mutex_clocklock64
#define __CRT_HAVE___pthread_mutex_timedlock64
#define __CRT_HAVE___pthread_rwlock_clockrdlock64
#define __CRT_HAVE___pthread_rwlock_clockwrlock64
#define __CRT_HAVE___pthread_rwlock_timedrdlock64
#define __CRT_HAVE___pthread_rwlock_timedwrlock64
#define __CRT_HAVE___pthread_timedjoin_np64
#define __CRT_HAVE___recvmmsg64
#define __CRT_HAVE___recvmsg64
#define __CRT_HAVE___sched_rr_get_interval64
#define __CRT_HAVE___select64
#define __CRT_HAVE___sem_clockwait64
#define __CRT_HAVE___sem_timedwait64
#define __CRT_HAVE___semctl64
#define __CRT_HAVE___semtimedop64
#define __CRT_HAVE___sendmmsg64
#define __CRT_HAVE___sendmsg64
#define __CRT_HAVE___setitimer64
#define __CRT_HAVE___setsockopt64
#define __CRT_HAVE___settimeofday64
#define __CRT_HAVE___shmctl64
#define __CRT_HAVE___sigtimedwait64
#define __CRT_HAVE___stat64_time64
#define __CRT_HAVE___thrd_sleep64
#define __CRT_HAVE___time64
#define __CRT_HAVE___timegm64
#define __CRT_HAVE___timer_gettime64
#define __CRT_HAVE___timer_settime64
#define __CRT_HAVE___timerfd_gettime64
#define __CRT_HAVE___timerfd_settime64
#define __CRT_HAVE___timespec_get64
#define __CRT_HAVE___timespec_getres64
#define __CRT_HAVE___utime64
#define __CRT_HAVE___utimensat64
#define __CRT_HAVE___utimes64
#define __CRT_HAVE___wait3_time64
#define __CRT_HAVE___wait4_time64
#define __CRT_HAVE__thread_db_register32_thread_area
#define __CRT_HAVE__thread_db_register64_thread_area
#endif /* !__x86_64__ && __GLIBC_VERSION__ >= 23400 */
#if !defined(__x86_64__) && __GLIBC_VERSION__ >= 23500
#define __CRT_HAVE___epoll_pwait2_time64
#endif /* !__x86_64__ && __GLIBC_VERSION__ >= 23500 */
#if !defined(__x86_64__) && __GLIBC_VERSION__ >= 23700
#define __CRT_HAVE___ppoll64_chk
#endif /* !__x86_64__ && __GLIBC_VERSION__ >= 23700 */
#if defined(_REENTRANT) ? (__GLIBC_VERSION__ >= 20302 && __GLIBC_VERSION__ <= 22900) : (__GLIBC_VERSION__ >= 20302 && __GLIBC_VERSION__ <= 20890)
#define __CRT_HAVE___pthread_clock_gettime
#define __CRT_HAVE___pthread_clock_settime
#endif /* _REENTRANT ? (__GLIBC_VERSION__ >= 20302 && __GLIBC_VERSION__ <= 22900) : (__GLIBC_VERSION__ >= 20302 && __GLIBC_VERSION__ <= 20890) */
#if defined(_REENTRANT) ? __GLIBC_VERSION__ <= 20205 : (__GLIBC_VERSION__ >= 20103 && __GLIBC_VERSION__ <= 20205)
#define __CRT_HAVE___pthread_kill_other_threads_np
#endif /* _REENTRANT ? __GLIBC_VERSION__ <= 20205 : (__GLIBC_VERSION__ >= 20103 && __GLIBC_VERSION__ <= 20205) */
#if defined(_REENTRANT) ? __GLIBC_VERSION__ >= 20103 : ((__GLIBC_VERSION__ >= 20103 && __GLIBC_VERSION__ <= 20205) || __GLIBC_VERSION__ >= 23400)
#define __CRT_HAVE___pthread_mutexattr_settype
#endif /* _REENTRANT ? __GLIBC_VERSION__ >= 20103 : ((__GLIBC_VERSION__ >= 20103 && __GLIBC_VERSION__ <= 20205) || __GLIBC_VERSION__ >= 23400) */
#if defined(_REENTRANT) ? __GLIBC_VERSION__ >= 20103 : __GLIBC_VERSION__ >= 20302
#define __CRT_HAVE_pthread_attr_setstacksize
#endif /* _REENTRANT ? __GLIBC_VERSION__ >= 20103 : __GLIBC_VERSION__ >= 20302 */
#if defined(_REENTRANT) ? __GLIBC_VERSION__ >= 20103 : __GLIBC_VERSION__ >= 23400
#define __CRT_HAVE_pthread_attr_getguardsize
#define __CRT_HAVE_pthread_attr_getstackaddr
#define __CRT_HAVE_pthread_attr_getstacksize
#define __CRT_HAVE_pthread_attr_setguardsize
#define __CRT_HAVE_pthread_attr_setstackaddr
#define __CRT_HAVE_pthread_getconcurrency
#define __CRT_HAVE_pthread_mutexattr_gettype
#define __CRT_HAVE_pthread_mutexattr_settype
#define __CRT_HAVE_pthread_rwlock_destroy
#define __CRT_HAVE_pthread_rwlock_init
#define __CRT_HAVE_pthread_rwlock_rdlock
#define __CRT_HAVE_pthread_rwlock_tryrdlock
#define __CRT_HAVE_pthread_rwlock_trywrlock
#define __CRT_HAVE_pthread_rwlock_unlock
#define __CRT_HAVE_pthread_rwlock_wrlock
#define __CRT_HAVE_pthread_rwlockattr_destroy
#define __CRT_HAVE_pthread_rwlockattr_getkind_np
#define __CRT_HAVE_pthread_rwlockattr_getpshared
#define __CRT_HAVE_pthread_rwlockattr_init
#define __CRT_HAVE_pthread_rwlockattr_setkind_np
#define __CRT_HAVE_pthread_rwlockattr_setpshared
#define __CRT_HAVE_pthread_setconcurrency
#define __CRT_HAVE_sem_close
#define __CRT_HAVE_sem_open
#define __CRT_HAVE_sem_unlink
#endif /* _REENTRANT ? __GLIBC_VERSION__ >= 20103 : __GLIBC_VERSION__ >= 23400 */
#if defined(_REENTRANT) ? __GLIBC_VERSION__ >= 20205 : ((__GLIBC_VERSION__ >= 20305 && __GLIBC_VERSION__ <= 22100) || __GLIBC_VERSION__ >= 23400)
#define __CRT_HAVE_pthread_barrier_init
#define __CRT_HAVE_pthread_barrier_wait
#endif /* _REENTRANT ? __GLIBC_VERSION__ >= 20205 : ((__GLIBC_VERSION__ >= 20305 && __GLIBC_VERSION__ <= 22100) || __GLIBC_VERSION__ >= 23400) */
#if defined(_REENTRANT) ? __GLIBC_VERSION__ >= 20205 : (__GLIBC_VERSION__ == 20205 || __GLIBC_VERSION__ >= 23400)
#define __CRT_HAVE___pthread_rwlock_rdlock
#define __CRT_HAVE___pthread_rwlock_unlock
#define __CRT_HAVE___pthread_rwlock_wrlock
#endif /* _REENTRANT ? __GLIBC_VERSION__ >= 20205 : (__GLIBC_VERSION__ == 20205 || __GLIBC_VERSION__ >= 23400) */
#if defined(_REENTRANT) ? __GLIBC_VERSION__ >= 20205 : __GLIBC_VERSION__ >= 23200
#define __CRT_HAVE_pthread_getattr_np
#endif /* _REENTRANT ? __GLIBC_VERSION__ >= 20205 : __GLIBC_VERSION__ >= 23200 */
#if defined(_REENTRANT) ? __GLIBC_VERSION__ >= 20205 : __GLIBC_VERSION__ >= 23400
#define __CRT_HAVE___pthread_rwlock_destroy
#define __CRT_HAVE___pthread_rwlock_init
#define __CRT_HAVE___pthread_rwlock_tryrdlock
#define __CRT_HAVE___pthread_rwlock_trywrlock
#define __CRT_HAVE_pthread_attr_getstack
#define __CRT_HAVE_pthread_attr_setstack
#define __CRT_HAVE_pthread_barrier_destroy
#define __CRT_HAVE_pthread_barrierattr_destroy
#define __CRT_HAVE_pthread_barrierattr_init
#define __CRT_HAVE_pthread_barrierattr_setpshared
#define __CRT_HAVE_pthread_condattr_getpshared
#define __CRT_HAVE_pthread_condattr_setpshared
#define __CRT_HAVE_pthread_getcpuclockid
#define __CRT_HAVE_pthread_mutex_timedlock
#define __CRT_HAVE_pthread_mutexattr_getpshared
#define __CRT_HAVE_pthread_mutexattr_setpshared
#define __CRT_HAVE_pthread_rwlock_timedrdlock
#define __CRT_HAVE_pthread_rwlock_timedwrlock
#define __CRT_HAVE_pthread_spin_destroy
#define __CRT_HAVE_pthread_spin_init
#define __CRT_HAVE_pthread_spin_lock
#define __CRT_HAVE_pthread_spin_trylock
#define __CRT_HAVE_pthread_spin_unlock
#define __CRT_HAVE_pthread_yield
#define __CRT_HAVE_sem_timedwait
#endif /* _REENTRANT ? __GLIBC_VERSION__ >= 20205 : __GLIBC_VERSION__ >= 23400 */
#if defined(_REENTRANT) ? __GLIBC_VERSION__ >= 20302 : __GLIBC_VERSION__ >= 23200
#define __CRT_HAVE_pthread_attr_setaffinity_np
#define __CRT_HAVE_pthread_getaffinity_np
#endif /* _REENTRANT ? __GLIBC_VERSION__ >= 20302 : __GLIBC_VERSION__ >= 23200 */
#if defined(_REENTRANT) ? __GLIBC_VERSION__ >= 20302 : __GLIBC_VERSION__ >= 23400
#define __CRT_HAVE___pthread_cleanup_routine
#define __CRT_HAVE___pthread_register_cancel_defer
#define __CRT_HAVE___pthread_unregister_cancel_restore
#define __CRT_HAVE_pthread_attr_getaffinity_np
#define __CRT_HAVE_pthread_barrierattr_getpshared
#define __CRT_HAVE_pthread_condattr_getclock
#define __CRT_HAVE_pthread_condattr_setclock
#define __CRT_HAVE_pthread_setaffinity_np
#define __CRT_HAVE_pthread_timedjoin_np
#define __CRT_HAVE_pthread_tryjoin_np
#endif /* _REENTRANT ? __GLIBC_VERSION__ >= 20302 : __GLIBC_VERSION__ >= 23400 */
#if defined(_REENTRANT) ? __GLIBC_VERSION__ >= 20305 : __GLIBC_VERSION__ >= 23400
#define __CRT_HAVE_pthread_setschedprio
#endif /* _REENTRANT ? __GLIBC_VERSION__ >= 20305 : __GLIBC_VERSION__ >= 23400 */
#if defined(_REENTRANT) ? __GLIBC_VERSION__ >= 20400 : __GLIBC_VERSION__ >= 23400
#define __CRT_HAVE_pthread_mutex_consistent_np
#define __CRT_HAVE_pthread_mutex_getprioceiling
#define __CRT_HAVE_pthread_mutex_setprioceiling
#define __CRT_HAVE_pthread_mutexattr_getprioceiling
#define __CRT_HAVE_pthread_mutexattr_getprotocol
#define __CRT_HAVE_pthread_mutexattr_getrobust_np
#define __CRT_HAVE_pthread_mutexattr_setprioceiling
#define __CRT_HAVE_pthread_mutexattr_setprotocol
#define __CRT_HAVE_pthread_mutexattr_setrobust_np
#endif /* _REENTRANT ? __GLIBC_VERSION__ >= 20400 : __GLIBC_VERSION__ >= 23400 */
#if defined(_REENTRANT) ? __GLIBC_VERSION__ >= 21100 : __GLIBC_VERSION__ >= 23400
#define __CRT_HAVE_pthread_sigqueue
#endif /* _REENTRANT ? __GLIBC_VERSION__ >= 21100 : __GLIBC_VERSION__ >= 23400 */
#if defined(_REENTRANT) ? __GLIBC_VERSION__ >= 21200 : __GLIBC_VERSION__ >= 23400
#define __CRT_HAVE_pthread_getname_np
#define __CRT_HAVE_pthread_mutex_consistent
#define __CRT_HAVE_pthread_mutexattr_getrobust
#define __CRT_HAVE_pthread_mutexattr_setrobust
#define __CRT_HAVE_pthread_setname_np
#endif /* _REENTRANT ? __GLIBC_VERSION__ >= 21200 : __GLIBC_VERSION__ >= 23400 */
#if defined(_REENTRANT) ? __GLIBC_VERSION__ >= 21800 : __GLIBC_VERSION__ >= 23400
#define __CRT_HAVE_pthread_getattr_default_np
#define __CRT_HAVE_pthread_setattr_default_np
#endif /* _REENTRANT ? __GLIBC_VERSION__ >= 21800 : __GLIBC_VERSION__ >= 23400 */
#if defined(_REENTRANT) ? __GLIBC_VERSION__ >= 22800 : __GLIBC_VERSION__ >= 23400
#define __CRT_HAVE_call_once
#define __CRT_HAVE_cnd_broadcast
#define __CRT_HAVE_cnd_destroy
#define __CRT_HAVE_cnd_init
#define __CRT_HAVE_cnd_signal
#define __CRT_HAVE_cnd_timedwait
#define __CRT_HAVE_cnd_wait
#define __CRT_HAVE_mtx_destroy
#define __CRT_HAVE_mtx_init
#define __CRT_HAVE_mtx_lock
#define __CRT_HAVE_mtx_timedlock
#define __CRT_HAVE_mtx_trylock
#define __CRT_HAVE_mtx_unlock
#define __CRT_HAVE_thrd_create
#define __CRT_HAVE_thrd_detach
#define __CRT_HAVE_thrd_exit
#define __CRT_HAVE_thrd_join
#define __CRT_HAVE_tss_create
#define __CRT_HAVE_tss_delete
#define __CRT_HAVE_tss_get
#define __CRT_HAVE_tss_set
#endif /* _REENTRANT ? __GLIBC_VERSION__ >= 22800 : __GLIBC_VERSION__ >= 23400 */
#if defined(_REENTRANT) ? __GLIBC_VERSION__ >= 23000 : __GLIBC_VERSION__ >= 23400
#define __CRT_HAVE_pthread_cond_clockwait
#define __CRT_HAVE_pthread_mutex_clocklock
#define __CRT_HAVE_pthread_rwlock_clockrdlock
#define __CRT_HAVE_pthread_rwlock_clockwrlock
#define __CRT_HAVE_sem_clockwait
#endif /* _REENTRANT ? __GLIBC_VERSION__ >= 23000 : __GLIBC_VERSION__ >= 23400 */
#if defined(_REENTRANT) ? __GLIBC_VERSION__ >= 23100 : __GLIBC_VERSION__ >= 23400
#define __CRT_HAVE_pthread_clockjoin_np
#endif /* _REENTRANT ? __GLIBC_VERSION__ >= 23100 : __GLIBC_VERSION__ >= 23400 */
#if defined(__x86_64__) ? defined(_REENTRANT) ? __GLIBC_VERSION__ >= 20302 : (__GLIBC_VERSION__ == 20305 || __GLIBC_VERSION__ >= 23400) : defined(_REENTRANT) ? __GLIBC_VERSION__ >= 20302 : __GLIBC_VERSION__ >= 23400
#define __CRT_HAVE___pthread_register_cancel
#define __CRT_HAVE___pthread_unregister_cancel
#define __CRT_HAVE___pthread_unwind_next
#endif /* __x86_64__ ? _REENTRANT ? __GLIBC_VERSION__ >= 20302 : (__GLIBC_VERSION__ == 20305 || __GLIBC_VERSION__ >= 23400) : _REENTRANT ? __GLIBC_VERSION__ >= 20302 : __GLIBC_VERSION__ >= 23400 */
#if defined(__x86_64__) ? (__GLIBC_VERSION__ >= 20103 && __GLIBC_VERSION__ <= 20302) : __GLIBC_VERSION__ >= 20103
#define __CRT_HAVE___modify_ldt
#endif /* __x86_64__ ? (__GLIBC_VERSION__ >= 20103 && __GLIBC_VERSION__ <= 20302) : __GLIBC_VERSION__ >= 20103 */
#if defined(__x86_64__) ? (__GLIBC_VERSION__ >= 21100 && __GLIBC_VERSION__ <= 23200) : (__GLIBC_VERSION__ >= 21200 && __GLIBC_VERSION__ <= 23200)
#define __CRT_HAVE___get_cpu_features
#endif /* __x86_64__ ? (__GLIBC_VERSION__ >= 21100 && __GLIBC_VERSION__ <= 23200) : (__GLIBC_VERSION__ >= 21200 && __GLIBC_VERSION__ <= 23200) */
#if defined(__x86_64__) ? (defined(_REENTRANT) && __GLIBC_VERSION__ >= 23100) : (defined(_REENTRANT) && __GLIBC_VERSION__ >= 23000)
#define __CRT_HAVE___libpthread_version_placeholder
#endif /* __x86_64__ ? (_REENTRANT && __GLIBC_VERSION__ >= 23100) : (_REENTRANT && __GLIBC_VERSION__ >= 23000) */
#if defined(__x86_64__) ? __GLIBC_VERSION__ <= 20004 : (__GLIBC_VERSION__ <= 20004 || __GLIBC_VERSION__ >= 20205)
#define __CRT_HAVE___expl
#define __CRT_HAVE___expm1l
#endif /* __x86_64__ ? __GLIBC_VERSION__ <= 20004 : (__GLIBC_VERSION__ <= 20004 || __GLIBC_VERSION__ >= 20205) */
#if defined(__x86_64__) ? __GLIBC_VERSION__ >= 21001 : __GLIBC_VERSION__ >= 21100
#define __CRT_HAVE_fallocate64
#endif /* __x86_64__ ? __GLIBC_VERSION__ >= 21001 : __GLIBC_VERSION__ >= 21100 */
#if defined(__x86_64__) ? __GLIBC_VERSION__ >= 22600 : __GLIBC_VERSION__ >= 20302
#define __CRT_HAVE___libc_msgrcv
#define __CRT_HAVE___libc_msgsnd
#endif /* __x86_64__ ? __GLIBC_VERSION__ >= 22600 : __GLIBC_VERSION__ >= 20302 */
#if defined(__x86_64__) ? __GLIBC_VERSION__ >= 23200 : (__GLIBC_VERSION__ == 22700 || __GLIBC_VERSION__ >= 23100)
#define __CRT_HAVE___gconv_create_spec
#define __CRT_HAVE___gconv_open
#endif /* __x86_64__ ? __GLIBC_VERSION__ >= 23200 : (__GLIBC_VERSION__ == 22700 || __GLIBC_VERSION__ >= 23100) */
#if defined(__x86_64__) ? __GLIBC_VERSION__ >= 23300 : (__GLIBC_VERSION__ == 22700 || __GLIBC_VERSION__ == 23100 || __GLIBC_VERSION__ >= 23300)
#define __CRT_HAVE___gconv_destroy_spec
#endif /* __x86_64__ ? __GLIBC_VERSION__ >= 23300 : (__GLIBC_VERSION__ == 22700 || __GLIBC_VERSION__ == 23100 || __GLIBC_VERSION__ >= 23300) */
#if __GLIBC_VERSION__ >= 20004 && __GLIBC_VERSION__ <= 23300
#define __CRT_HAVE_malloc_get_state
#define __CRT_HAVE_malloc_set_state
#endif /* __GLIBC_VERSION__ >= 20004 && __GLIBC_VERSION__ <= 23300 */
#if __GLIBC_VERSION__ >= 20103 && __GLIBC_VERSION__ <= 20205
#define __CRT_HAVE___gconv_alias_db
#define __CRT_HAVE___gconv_modules_db
#define __CRT_HAVE___libc_internal_tsd_get
#define __CRT_HAVE___libc_internal_tsd_set
#define __CRT_HAVE___pthread_atfork
#define __CRT_HAVE__dl_check_all_versions
#define __CRT_HAVE__dl_debug_fd
#define __CRT_HAVE__dl_fpu_control
#define __CRT_HAVE__dl_initial_searchlist
#define __CRT_HAVE__dl_lazy
#define __CRT_HAVE__dl_loaded
#define __CRT_HAVE__dl_main_searchlist
#define __CRT_HAVE__dl_origin_path
#define __CRT_HAVE__dl_platformlen
#define __CRT_HAVE__dl_profile
#define __CRT_HAVE__dl_profile_map
#define __CRT_HAVE__dl_profile_output
#define __CRT_HAVE__h_errno
#endif /* __GLIBC_VERSION__ >= 20103 && __GLIBC_VERSION__ <= 20205 */
#if __GLIBC_VERSION__ >= 20103 && __GLIBC_VERSION__ <= 20302
#define __CRT_HAVE___libc_accept
#define __CRT_HAVE___libc_connect
#define __CRT_HAVE___libc_lseek64
#define __CRT_HAVE___libc_open64
#define __CRT_HAVE___libc_pread64
#define __CRT_HAVE___libc_pwrite64
#define __CRT_HAVE___libc_recv
#define __CRT_HAVE___libc_recvfrom
#define __CRT_HAVE___libc_recvmsg
#define __CRT_HAVE___libc_send
#define __CRT_HAVE___libc_sendmsg
#define __CRT_HAVE___libc_sendto
#define __CRT_HAVE__argp_unlock_xxx
#define __CRT_HAVE__dl_dst_count
#define __CRT_HAVE__dl_dst_substitute
#define __CRT_HAVE__dl_lookup_versioned_symbol
#define __CRT_HAVE__dl_lookup_versioned_symbol_skip
#define __CRT_HAVE__dl_start_profile
#define __CRT_HAVE__dl_unload_cache
#endif /* __GLIBC_VERSION__ >= 20103 && __GLIBC_VERSION__ <= 20302 */
#if (__GLIBC_VERSION__ >= 20103 && __GLIBC_VERSION__ <= 20302) || __GLIBC_VERSION__ >= 22200
#define __CRT_HAVE___libc_pread
#endif /* (__GLIBC_VERSION__ >= 20103 && __GLIBC_VERSION__ <= 20302) || __GLIBC_VERSION__ >= 22200 */
#if __GLIBC_VERSION__ >= 20103 && __GLIBC_VERSION__ <= 23000
#define __CRT_HAVE_encrypt
#define __CRT_HAVE_encrypt_r
#define __CRT_HAVE_fcrypt
#define __CRT_HAVE_setkey
#define __CRT_HAVE_setkey_r
#endif /* __GLIBC_VERSION__ >= 20103 && __GLIBC_VERSION__ <= 23000 */
#if __GLIBC_VERSION__ >= 20103 && __GLIBC_VERSION__ <= 23300
#define __CRT_HAVE___libc_longjmp
#define __CRT_HAVE___libc_siglongjmp
#define __CRT_HAVE__dl_addr
#endif /* __GLIBC_VERSION__ >= 20103 && __GLIBC_VERSION__ <= 23300 */
#if __GLIBC_VERSION__ >= 20205 && __GLIBC_VERSION__ <= 20302
#define __CRT_HAVE__dl_check_map_versions
#define __CRT_HAVE__dl_debug_printf
#define __CRT_HAVE__dl_init
#endif /* __GLIBC_VERSION__ >= 20205 && __GLIBC_VERSION__ <= 20302 */
#if (__GLIBC_VERSION__ >= 20205 && __GLIBC_VERSION__ <= 20302) || __GLIBC_VERSION__ >= 23400
#define __CRT_HAVE___libc_sigaction
#endif /* (__GLIBC_VERSION__ >= 20205 && __GLIBC_VERSION__ <= 20302) || __GLIBC_VERSION__ >= 23400 */
#if __GLIBC_VERSION__ >= 20205 && __GLIBC_VERSION__ <= 20306
#define __CRT_HAVE__dl_out_of_memory
#endif /* __GLIBC_VERSION__ >= 20205 && __GLIBC_VERSION__ <= 20306 */
#if __GLIBC_VERSION__ >= 20205 && __GLIBC_VERSION__ <= 23300
#define __CRT_HAVE___gai_sigqueue
#define __CRT_HAVE__dl_sym
#define __CRT_HAVE__dl_vsym
#endif /* __GLIBC_VERSION__ >= 20205 && __GLIBC_VERSION__ <= 23300 */
#if __GLIBC_VERSION__ >= 20302 && __GLIBC_VERSION__ <= 22400
#define __CRT_HAVE___libc_dl_error_tsd
#define __CRT_HAVE__dl_tls_setup
#endif /* __GLIBC_VERSION__ >= 20302 && __GLIBC_VERSION__ <= 22400 */
#if __GLIBC_VERSION__ >= 20302 && __GLIBC_VERSION__ <= 22600
#define __CRT_HAVE__Jv_RegisterClasses
#endif /* __GLIBC_VERSION__ >= 20302 && __GLIBC_VERSION__ <= 22600 */
#if __GLIBC_VERSION__ >= 20302 && __GLIBC_VERSION__ <= 23300
#define __CRT_HAVE___libc_allocate_rtsig_private
#define __CRT_HAVE___libc_current_sigrtmax_private
#define __CRT_HAVE___libc_current_sigrtmin_private
#define __CRT_HAVE___libc_dlclose
#define __CRT_HAVE___libc_dlopen_mode
#define __CRT_HAVE___libc_dlsym
#define __CRT_HAVE___libc_pthread_init
#define __CRT_HAVE___libc_thread_freeres
#define __CRT_HAVE___pthread_unwind
#define __CRT_HAVE__dl_open_hook
#endif /* __GLIBC_VERSION__ >= 20302 && __GLIBC_VERSION__ <= 23300 */
#if __GLIBC_VERSION__ >= 20305 && __GLIBC_VERSION__ <= 22400
#define __CRT_HAVE___res_maybe_init
#endif /* __GLIBC_VERSION__ >= 20305 && __GLIBC_VERSION__ <= 22400 */
#if __GLIBC_VERSION__ >= 20305 && __GLIBC_VERSION__ <= 23300
#define __CRT_HAVE__dl_make_stack_executable
#define __CRT_HAVE__dlfcn_hook
#endif /* __GLIBC_VERSION__ >= 20305 && __GLIBC_VERSION__ <= 23300 */
#if __GLIBC_VERSION__ >= 20400 && __GLIBC_VERSION__ <= 20700
#define __CRT_HAVE__dl_tls_get_addr_soft
#endif /* __GLIBC_VERSION__ >= 20400 && __GLIBC_VERSION__ <= 20700 */
#if (__GLIBC_VERSION__ >= 21001 && __GLIBC_VERSION__ <= 21800) || __GLIBC_VERSION__ == 22000 || __GLIBC_VERSION__ == 22200
#define __CRT_HAVE_NSSLOWHASH_Begin
#define __CRT_HAVE_NSSLOWHASH_Destroy
#define __CRT_HAVE_NSSLOWHASH_End
#define __CRT_HAVE_NSSLOWHASH_NewContext
#define __CRT_HAVE_NSSLOWHASH_Update
#define __CRT_HAVE_NSSLOW_Init
#define __CRT_HAVE_NSSLOW_Shutdown
#endif /* (__GLIBC_VERSION__ >= 21001 && __GLIBC_VERSION__ <= 21800) || __GLIBC_VERSION__ == 22000 || __GLIBC_VERSION__ == 22200 */
#if __GLIBC_VERSION__ >= 21700 && __GLIBC_VERSION__ <= 23000
#define __CRT_HAVE___clock_getcpuclockid
#define __CRT_HAVE___clock_getres
#define __CRT_HAVE___clock_nanosleep
#define __CRT_HAVE___clock_settime
#endif /* __GLIBC_VERSION__ >= 21700 && __GLIBC_VERSION__ <= 23000 */
#if __GLIBC_VERSION__ >= 22000 && __GLIBC_VERSION__ <= 22900
#define __CRT_HAVE___libc_vfork
#endif /* __GLIBC_VERSION__ >= 22000 && __GLIBC_VERSION__ <= 22900 */
#if __GLIBC_VERSION__ >= 22100 && __GLIBC_VERSION__ <= 23300
#define __CRT_HAVE___shm_directory
#endif /* __GLIBC_VERSION__ >= 22100 && __GLIBC_VERSION__ <= 23300 */
#if __GLIBC_VERSION__ >= 22200 && __GLIBC_VERSION__ <= 23300
#define __CRT_HAVE___pthread_barrier_init
#define __CRT_HAVE___pthread_barrier_wait
#endif /* __GLIBC_VERSION__ >= 22200 && __GLIBC_VERSION__ <= 23300 */
#if __GLIBC_VERSION__ >= 22700 && __GLIBC_VERSION__ <= 23300
#define __CRT_HAVE___libc_dlvsym
#define __CRT_HAVE__dl_open_hook2
#endif /* __GLIBC_VERSION__ >= 22700 && __GLIBC_VERSION__ <= 23300 */
#if __GLIBC_VERSION__ >= 22800 && __GLIBC_VERSION__ <= 23000
#define __CRT_HAVE___nanosleep_nocancel
#define __CRT_HAVE___pause_nocancel
#endif /* __GLIBC_VERSION__ >= 22800 && __GLIBC_VERSION__ <= 23000 */
#if __GLIBC_VERSION__ >= 22800 && __GLIBC_VERSION__ <= 23100
#define __CRT_HAVE___libc_readline_unlocked
#endif /* __GLIBC_VERSION__ >= 22800 && __GLIBC_VERSION__ <= 23100 */
#if __GLIBC_VERSION__ >= 22800 && __GLIBC_VERSION__ <= 23300
#define __CRT_HAVE___libdl_freeres
#define __CRT_HAVE___libpthread_freeres
#endif /* __GLIBC_VERSION__ >= 22800 && __GLIBC_VERSION__ <= 23300 */
#if __GLIBC_VERSION__ >= 23000 && __GLIBC_VERSION__ <= 23300
#define __CRT_HAVE___nss_database_lookup2
#endif /* __GLIBC_VERSION__ >= 23000 && __GLIBC_VERSION__ <= 23300 */
#if __GLIBC_VERSION__ >= 23200 && __GLIBC_VERSION__ <= 23300
#define __CRT_HAVE___pthread_attr_copy
#define __CRT_HAVE___pthread_attr_destroy
#define __CRT_HAVE___pthread_attr_init
#define __CRT_HAVE___pthread_attr_setaffinity_np
#define __CRT_HAVE___pthread_attr_setsigmask_internal
#define __CRT_HAVE___pthread_cond_destroy
#define __CRT_HAVE___pthread_cond_init
#endif /* __GLIBC_VERSION__ >= 23200 && __GLIBC_VERSION__ <= 23300 */
#if __GLIBC_VERSION__ >= 23300 && __GLIBC_VERSION__ <= 23600
#define __CRT_HAVE___libc_scratch_buffer_dupfree
#endif /* __GLIBC_VERSION__ >= 23300 && __GLIBC_VERSION__ <= 23600 */
#if defined(_REENTRANT) && __GLIBC_VERSION__ >= 20302 && __GLIBC_VERSION__ <= 23300
#define __CRT_HAVE___pthread_initialize_minimal
#endif /* _REENTRANT && __GLIBC_VERSION__ >= 20302 && __GLIBC_VERSION__ <= 23300 */
#if defined(_REENTRANT) && __GLIBC_VERSION__ <= 20004
#define __CRT_HAVE___flockfile
#define __CRT_HAVE___fresetlockfiles
#define __CRT_HAVE___ftrylockfile
#define __CRT_HAVE___funlockfile
#define __CRT_HAVE___pthread_destroy_specifics
#define __CRT_HAVE___pthread_exit_code
#define __CRT_HAVE___pthread_exit_requested
#define __CRT_HAVE___pthread_initial_thread
#define __CRT_HAVE___pthread_initial_thread_bos
#define __CRT_HAVE___pthread_main_thread
#define __CRT_HAVE___pthread_manager
#define __CRT_HAVE___pthread_manager_reader
#define __CRT_HAVE___pthread_manager_request
#define __CRT_HAVE___pthread_manager_sighandler
#define __CRT_HAVE___pthread_manager_thread
#define __CRT_HAVE___pthread_manager_thread_bos
#define __CRT_HAVE___pthread_manager_thread_tos
#define __CRT_HAVE___pthread_mutexattr_getkind_np
#define __CRT_HAVE___pthread_perform_cleanup
#define __CRT_HAVE___pthread_reset_main_thread
#define __CRT_HAVE___pthread_sighandler
#endif /* _REENTRANT && __GLIBC_VERSION__ <= 20004 */
#if defined(_REENTRANT) && __GLIBC_VERSION__ == 20004
#define __CRT_HAVE___pthread_handles
#endif /* _REENTRANT && __GLIBC_VERSION__ == 20004 */
#if defined(_REENTRANT) && __GLIBC_VERSION__ == 20302
#define __CRT_HAVE___pthread_cleanup_upto
#endif /* _REENTRANT && __GLIBC_VERSION__ == 20302 */
#if defined(_REENTRANT) || __GLIBC_VERSION__ <= 20004 || __GLIBC_VERSION__ >= 23400
#define __CRT_HAVE_pthread_mutexattr_getkind_np
#define __CRT_HAVE_pthread_mutexattr_setkind_np
#endif /* _REENTRANT || __GLIBC_VERSION__ <= 20004 || __GLIBC_VERSION__ >= 23400 */
#if defined(_REENTRANT) || __GLIBC_VERSION__ <= 20205 || __GLIBC_VERSION__ >= 23400
#define __CRT_HAVE___pthread_mutex_destroy
#define __CRT_HAVE___pthread_mutex_init
#define __CRT_HAVE___pthread_mutex_trylock
#define __CRT_HAVE___pthread_mutexattr_destroy
#define __CRT_HAVE___pthread_mutexattr_init
#define __CRT_HAVE__pthread_cleanup_pop_restore
#define __CRT_HAVE__pthread_cleanup_push_defer
#endif /* _REENTRANT || __GLIBC_VERSION__ <= 20205 || __GLIBC_VERSION__ >= 23400 */
#if defined(_REENTRANT) || __GLIBC_VERSION__ <= 23000 || __GLIBC_VERSION__ >= 23400
#define __CRT_HAVE___pthread_mutex_lock
#define __CRT_HAVE___pthread_mutex_unlock
#endif /* _REENTRANT || __GLIBC_VERSION__ <= 23000 || __GLIBC_VERSION__ >= 23400 */
#if defined(_REENTRANT) || __GLIBC_VERSION__ == 20103 || __GLIBC_VERSION__ >= 23400
#define __CRT_HAVE_pthread_getspecific
#define __CRT_HAVE_pthread_key_create
#define __CRT_HAVE_pthread_key_delete
#define __CRT_HAVE_pthread_setspecific
#endif /* _REENTRANT || __GLIBC_VERSION__ == 20103 || __GLIBC_VERSION__ >= 23400 */
#if defined(_REENTRANT) || __GLIBC_VERSION__ == 20205 || __GLIBC_VERSION__ >= 23400
#define __CRT_HAVE__pthread_cleanup_pop
#define __CRT_HAVE__pthread_cleanup_push
#define __CRT_HAVE_pthread_atfork
#endif /* _REENTRANT || __GLIBC_VERSION__ == 20205 || __GLIBC_VERSION__ >= 23400 */
#if defined(_REENTRANT) || __GLIBC_VERSION__ >= 20103
#define __CRT_HAVE_pthread_cond_timedwait
#define __CRT_HAVE_pthread_create
#define __CRT_HAVE_pthread_once
#endif /* _REENTRANT || __GLIBC_VERSION__ >= 20103 */
#if defined(_REENTRANT) || __GLIBC_VERSION__ >= 20305
#define __CRT_HAVE_pthread_cancel
#define __CRT_HAVE_pthread_detach
#define __CRT_HAVE_pthread_sigmask
#endif /* _REENTRANT || __GLIBC_VERSION__ >= 20305 */
#if defined(_REENTRANT) || __GLIBC_VERSION__ >= 23400
#define __CRT_HAVE_pthread_join
#define __CRT_HAVE_pthread_kill
#define __CRT_HAVE_pthread_kill_other_threads_np
#define __CRT_HAVE_pthread_mutex_trylock
#define __CRT_HAVE_pthread_mutexattr_destroy
#define __CRT_HAVE_pthread_mutexattr_init
#define __CRT_HAVE_pthread_testcancel
#define __CRT_HAVE_sem_destroy
#define __CRT_HAVE_sem_getvalue
#define __CRT_HAVE_sem_init
#define __CRT_HAVE_sem_post
#define __CRT_HAVE_sem_trywait
#define __CRT_HAVE_sem_wait
#endif /* _REENTRANT || __GLIBC_VERSION__ >= 23400 */
#if defined(__x86_64__) && __GLIBC_VERSION__ >= 20700 && __GLIBC_VERSION__ <= 22100
#define __CRT_HAVE___vdso_clock_gettime
#endif /* __x86_64__ && __GLIBC_VERSION__ >= 20700 && __GLIBC_VERSION__ <= 22100 */
#if defined(__x86_64__) && __GLIBC_VERSION__ >= 23400
#define __CRT_HAVE__thread_db_const_thread_area
#endif /* __x86_64__ && __GLIBC_VERSION__ >= 23400 */
#if __GLIBC_VERSION__ <= 20000
#define __CRT_HAVE___eh_pc
#define __CRT_HAVE___empty
#define __CRT_HAVE___find_first_exception_table_match
#define __CRT_HAVE___malloc_initialized
#define __CRT_HAVE___register_exceptions
#define __CRT_HAVE___throw
#define __CRT_HAVE___throw_type_match
#define __CRT_HAVE___unwind_function
#define __CRT_HAVE_malloc_check_init
#endif /* __GLIBC_VERSION__ <= 20000 */
#if __GLIBC_VERSION__ <= 20004
#define __CRT_HAVE__IO_cleanup
#define __CRT_HAVE__IO_default_read
#define __CRT_HAVE__IO_default_seek
#define __CRT_HAVE__IO_default_seekoff
#define __CRT_HAVE__IO_default_seekpos
#define __CRT_HAVE__IO_default_setbuf
#define __CRT_HAVE__IO_default_stat
#define __CRT_HAVE__IO_default_sync
#define __CRT_HAVE__IO_default_underflow
#define __CRT_HAVE__IO_default_write
#define __CRT_HAVE__IO_get_column
#define __CRT_HAVE__IO_getdelim
#define __CRT_HAVE__IO_least_marker
#define __CRT_HAVE__IO_nobackup_pbackfail
#define __CRT_HAVE__IO_obstack_printf
#define __CRT_HAVE__IO_obstack_vprintf
#define __CRT_HAVE__IO_proc_jumps
#define __CRT_HAVE__IO_set_column
#define __CRT_HAVE__IO_str_count
#define __CRT_HAVE__IO_str_finish
#define __CRT_HAVE__IO_str_jumps
#define __CRT_HAVE__IO_switch_to_backup_area
#define __CRT_HAVE__IO_switch_to_main_get_area
#define __CRT_HAVE__IO_sync
#define __CRT_HAVE__IO_unbuffer_all
#define __CRT_HAVE__IO_vasprintf
#define __CRT_HAVE__IO_vdprintf
#define __CRT_HAVE__IO_vscanf
#define __CRT_HAVE__IO_vsnprintf
#define __CRT_HAVE__IO_vsscanf
#define __CRT_HAVE___accept
#define __CRT_HAVE___access
#define __CRT_HAVE___acos
#define __CRT_HAVE___acosf
#define __CRT_HAVE___acosh
#define __CRT_HAVE___acoshf
#define __CRT_HAVE___acoshl
#define __CRT_HAVE___acosl
#define __CRT_HAVE___addmntent
#define __CRT_HAVE___adjtime
#define __CRT_HAVE___advance
#define __CRT_HAVE___argz_add
#define __CRT_HAVE___argz_add_sep
#define __CRT_HAVE___argz_append
#define __CRT_HAVE___argz_create
#define __CRT_HAVE___argz_create_sep
#define __CRT_HAVE___argz_extract
#define __CRT_HAVE___argz_insert
#define __CRT_HAVE___asctime_r
#define __CRT_HAVE___asin
#define __CRT_HAVE___asinf
#define __CRT_HAVE___asinh
#define __CRT_HAVE___asinhf
#define __CRT_HAVE___asinhl
#define __CRT_HAVE___asinl
#define __CRT_HAVE___assert_program_name
#define __CRT_HAVE___atan
#define __CRT_HAVE___atan2
#define __CRT_HAVE___atan2f
#define __CRT_HAVE___atan2l
#define __CRT_HAVE___atanf
#define __CRT_HAVE___atanh
#define __CRT_HAVE___atanhf
#define __CRT_HAVE___atanhl
#define __CRT_HAVE___atanl
#define __CRT_HAVE___bb_exit_func
#define __CRT_HAVE___bb_head
#define __CRT_HAVE___bb_init_func
#define __CRT_HAVE___bind
#define __CRT_HAVE___bindtextdomain
#define __CRT_HAVE___brk
#define __CRT_HAVE___bsd_signal
#define __CRT_HAVE___bss_start
#define __CRT_HAVE___cabs
#define __CRT_HAVE___cabsf
#define __CRT_HAVE___cabsl
#define __CRT_HAVE___calloc
#define __CRT_HAVE___cbrt
#define __CRT_HAVE___cbrtf
#define __CRT_HAVE___cbrtl
#define __CRT_HAVE___ceil
#define __CRT_HAVE___ceilf
#define __CRT_HAVE___ceill
#define __CRT_HAVE___cfree
#define __CRT_HAVE___chdir
#define __CRT_HAVE___chmod
#define __CRT_HAVE___closedir
#define __CRT_HAVE___clz_tab
#define __CRT_HAVE___collate_element_values
#define __CRT_HAVE___collate_extra
#define __CRT_HAVE___collate_table
#define __CRT_HAVE___copysign
#define __CRT_HAVE___copysignf
#define __CRT_HAVE___copysignl
#define __CRT_HAVE___cos
#define __CRT_HAVE___cosf
#define __CRT_HAVE___cosh
#define __CRT_HAVE___coshf
#define __CRT_HAVE___coshl
#define __CRT_HAVE___cosl
#define __CRT_HAVE___ctype_get_codeset_name
#define __CRT_HAVE___ctype_names
#define __CRT_HAVE___ctype_width
#define __CRT_HAVE___default_sigpause
#define __CRT_HAVE___drand48_iterate
#define __CRT_HAVE___drem
#define __CRT_HAVE___dremf
#define __CRT_HAVE___dreml
#define __CRT_HAVE___dup
#define __CRT_HAVE___endutent
#define __CRT_HAVE___erf
#define __CRT_HAVE___erfc
#define __CRT_HAVE___erfcf
#define __CRT_HAVE___erff
#define __CRT_HAVE___erfl
#define __CRT_HAVE___execve
#define __CRT_HAVE___exit_funcs
#define __CRT_HAVE___exp
#define __CRT_HAVE___expf
#define __CRT_HAVE___expm1
#define __CRT_HAVE___expm1f
#define __CRT_HAVE___fabs
#define __CRT_HAVE___fabsf
#define __CRT_HAVE___fabsl
#define __CRT_HAVE___fchmod
#define __CRT_HAVE___fchown
#define __CRT_HAVE___fcloseall
#define __CRT_HAVE___fgetgrent_r
#define __CRT_HAVE___fgetpwent_r
#define __CRT_HAVE___fgetspent_r
#define __CRT_HAVE___flock
#define __CRT_HAVE___floor
#define __CRT_HAVE___floorf
#define __CRT_HAVE___floorl
#define __CRT_HAVE___fmod
#define __CRT_HAVE___fmodf
#define __CRT_HAVE___fmodl
#define __CRT_HAVE___fpathconf
#define __CRT_HAVE___free
#define __CRT_HAVE___frexp
#define __CRT_HAVE___frexpf
#define __CRT_HAVE___frexpl
#define __CRT_HAVE___fstatfs
#define __CRT_HAVE___gamma
#define __CRT_HAVE___gamma_r
#define __CRT_HAVE___gammaf
#define __CRT_HAVE___gammaf_r
#define __CRT_HAVE___gammal
#define __CRT_HAVE___gammal_r
#define __CRT_HAVE___get_avphys_pages
#define __CRT_HAVE___get_nprocs
#define __CRT_HAVE___get_nprocs_conf
#define __CRT_HAVE___get_phys_pages
#define __CRT_HAVE___getaliasbyname_r
#define __CRT_HAVE___getaliasent_r
#define __CRT_HAVE___getcwd
#define __CRT_HAVE___getdents
#define __CRT_HAVE___getdirentries
#define __CRT_HAVE___getdtablesize
#define __CRT_HAVE___getegid
#define __CRT_HAVE___geteuid
#define __CRT_HAVE___getgid
#define __CRT_HAVE___getgrent_r
#define __CRT_HAVE___getgrgid_r
#define __CRT_HAVE___getgrnam_r
#define __CRT_HAVE___getgroups
#define __CRT_HAVE___gethostbyaddr_r
#define __CRT_HAVE___gethostbyname2_r
#define __CRT_HAVE___gethostbyname_r
#define __CRT_HAVE___gethostent_r
#define __CRT_HAVE___gethostname
#define __CRT_HAVE___getitimer
#define __CRT_HAVE___getline
#define __CRT_HAVE___getnetbyaddr_r
#define __CRT_HAVE___getnetbyname_r
#define __CRT_HAVE___getnetent_r
#define __CRT_HAVE___getnetgrent_r
#define __CRT_HAVE___getopt_initialized
#define __CRT_HAVE___getpeername
#define __CRT_HAVE___getppid
#define __CRT_HAVE___getprotobyname_r
#define __CRT_HAVE___getprotobynumber_r
#define __CRT_HAVE___getprotoent_r
#define __CRT_HAVE___getpw
#define __CRT_HAVE___getpwent_r
#define __CRT_HAVE___getpwnam_r
#define __CRT_HAVE___getpwuid_r
#define __CRT_HAVE___getrpcbyname_r
#define __CRT_HAVE___getrpcbynumber_r
#define __CRT_HAVE___getrpcent_r
#define __CRT_HAVE___getrusage
#define __CRT_HAVE___getservbyname_r
#define __CRT_HAVE___getservbyport_r
#define __CRT_HAVE___getservent_r
#define __CRT_HAVE___getsockname
#define __CRT_HAVE___getsockopt
#define __CRT_HAVE___getspent_r
#define __CRT_HAVE___getspnam_r
#define __CRT_HAVE___gettext
#define __CRT_HAVE___getuid
#define __CRT_HAVE___getutent_r
#define __CRT_HAVE___getutid_r
#define __CRT_HAVE___getutline_r
#define __CRT_HAVE___group_member
#define __CRT_HAVE___guess_grouping
#define __CRT_HAVE___hasmntopt
#define __CRT_HAVE___hypot
#define __CRT_HAVE___hypotf
#define __CRT_HAVE___hypotl
#define __CRT_HAVE___ieee754_acos
#define __CRT_HAVE___ieee754_acosf
#define __CRT_HAVE___ieee754_acosh
#define __CRT_HAVE___ieee754_acoshf
#define __CRT_HAVE___ieee754_acoshl
#define __CRT_HAVE___ieee754_acosl
#define __CRT_HAVE___ieee754_asin
#define __CRT_HAVE___ieee754_asinf
#define __CRT_HAVE___ieee754_asinl
#define __CRT_HAVE___ieee754_atan2
#define __CRT_HAVE___ieee754_atan2f
#define __CRT_HAVE___ieee754_atan2l
#define __CRT_HAVE___ieee754_atanh
#define __CRT_HAVE___ieee754_atanhf
#define __CRT_HAVE___ieee754_atanhl
#define __CRT_HAVE___ieee754_cosh
#define __CRT_HAVE___ieee754_coshf
#define __CRT_HAVE___ieee754_coshl
#define __CRT_HAVE___ieee754_exp
#define __CRT_HAVE___ieee754_expf
#define __CRT_HAVE___ieee754_expl
#define __CRT_HAVE___ieee754_fmod
#define __CRT_HAVE___ieee754_fmodf
#define __CRT_HAVE___ieee754_fmodl
#define __CRT_HAVE___ieee754_hypot
#define __CRT_HAVE___ieee754_hypotf
#define __CRT_HAVE___ieee754_hypotl
#define __CRT_HAVE___ieee754_j0
#define __CRT_HAVE___ieee754_j0f
#define __CRT_HAVE___ieee754_j0l
#define __CRT_HAVE___ieee754_j1
#define __CRT_HAVE___ieee754_j1f
#define __CRT_HAVE___ieee754_j1l
#define __CRT_HAVE___ieee754_jn
#define __CRT_HAVE___ieee754_jnf
#define __CRT_HAVE___ieee754_jnl
#define __CRT_HAVE___ieee754_lgamma_r
#define __CRT_HAVE___ieee754_lgammaf_r
#define __CRT_HAVE___ieee754_lgammal_r
#define __CRT_HAVE___ieee754_log
#define __CRT_HAVE___ieee754_log10
#define __CRT_HAVE___ieee754_log10f
#define __CRT_HAVE___ieee754_log10l
#define __CRT_HAVE___ieee754_logf
#define __CRT_HAVE___ieee754_logl
#define __CRT_HAVE___ieee754_pow
#define __CRT_HAVE___ieee754_powf
#define __CRT_HAVE___ieee754_powl
#define __CRT_HAVE___ieee754_rem_pio2
#define __CRT_HAVE___ieee754_rem_pio2f
#define __CRT_HAVE___ieee754_rem_pio2l
#define __CRT_HAVE___ieee754_remainder
#define __CRT_HAVE___ieee754_remainderf
#define __CRT_HAVE___ieee754_remainderl
#define __CRT_HAVE___ieee754_scalb
#define __CRT_HAVE___ieee754_scalbf
#define __CRT_HAVE___ieee754_scalbl
#define __CRT_HAVE___ieee754_sinh
#define __CRT_HAVE___ieee754_sinhf
#define __CRT_HAVE___ieee754_sinhl
#define __CRT_HAVE___ieee754_sqrt
#define __CRT_HAVE___ieee754_sqrtf
#define __CRT_HAVE___ieee754_sqrtl
#define __CRT_HAVE___ieee754_y0
#define __CRT_HAVE___ieee754_y0f
#define __CRT_HAVE___ieee754_y0l
#define __CRT_HAVE___ieee754_y1
#define __CRT_HAVE___ieee754_y1f
#define __CRT_HAVE___ieee754_y1l
#define __CRT_HAVE___ieee754_yn
#define __CRT_HAVE___ieee754_ynf
#define __CRT_HAVE___ieee754_ynl
#define __CRT_HAVE___ilogb
#define __CRT_HAVE___ilogbf
#define __CRT_HAVE___ilogbl
#define __CRT_HAVE___initstate
#define __CRT_HAVE___initstate_r
#define __CRT_HAVE___internal_flockfile
#define __CRT_HAVE___internal_ftrylockfile
#define __CRT_HAVE___internal_funlockfile
#define __CRT_HAVE___invoke_dynamic_linker__
#define __CRT_HAVE___ioctl
#define __CRT_HAVE___ipc
#define __CRT_HAVE___isatty
#define __CRT_HAVE___j0
#define __CRT_HAVE___j0f
#define __CRT_HAVE___j0l
#define __CRT_HAVE___j1
#define __CRT_HAVE___j1f
#define __CRT_HAVE___j1l
#define __CRT_HAVE___jn
#define __CRT_HAVE___jnf
#define __CRT_HAVE___jnl
#define __CRT_HAVE___kernel_cos
#define __CRT_HAVE___kernel_cosf
#define __CRT_HAVE___kernel_cosl
#define __CRT_HAVE___kernel_rem_pio2
#define __CRT_HAVE___kernel_rem_pio2f
#define __CRT_HAVE___kernel_rem_pio2l
#define __CRT_HAVE___kernel_sin
#define __CRT_HAVE___kernel_sinf
#define __CRT_HAVE___kernel_sinl
#define __CRT_HAVE___kernel_standard
#define __CRT_HAVE___kernel_tan
#define __CRT_HAVE___kernel_tanf
#define __CRT_HAVE___kernel_tanl
#define __CRT_HAVE___kill
#define __CRT_HAVE___lchown
#define __CRT_HAVE___lckpwdf
#define __CRT_HAVE___ldexp
#define __CRT_HAVE___ldexpf
#define __CRT_HAVE___ldexpl
#define __CRT_HAVE___lgamma
#define __CRT_HAVE___lgamma_r
#define __CRT_HAVE___lgammaf
#define __CRT_HAVE___lgammaf_r
#define __CRT_HAVE___lgammal
#define __CRT_HAVE___lgammal_r
#define __CRT_HAVE___libc_argc
#define __CRT_HAVE___libc_argv
#define __CRT_HAVE___libc_drand48_data
#define __CRT_HAVE___libc_global_ctors
#define __CRT_HAVE___libc_init
#define __CRT_HAVE___libc_main
#define __CRT_HAVE___libc_multiple_libcs
#define __CRT_HAVE___libc_print_version
#define __CRT_HAVE___libc_release
#define __CRT_HAVE___libc_setlocale_lock
#define __CRT_HAVE___libc_utmp_db_functions
#define __CRT_HAVE___libc_utmp_file_functions
#define __CRT_HAVE___libc_utmp_jump_table
#define __CRT_HAVE___libc_utmp_lock
#define __CRT_HAVE___libc_version
#define __CRT_HAVE___link
#define __CRT_HAVE___listen
#define __CRT_HAVE___localtime_r
#define __CRT_HAVE___log
#define __CRT_HAVE___log10
#define __CRT_HAVE___log10f
#define __CRT_HAVE___log10l
#define __CRT_HAVE___log1p
#define __CRT_HAVE___log1pf
#define __CRT_HAVE___log1pl
#define __CRT_HAVE___logb
#define __CRT_HAVE___logbf
#define __CRT_HAVE___logbl
#define __CRT_HAVE___logf
#define __CRT_HAVE___logl
#define __CRT_HAVE___longjmp
#define __CRT_HAVE___mallinfo
#define __CRT_HAVE___malloc
#define __CRT_HAVE___malloc_stats
#define __CRT_HAVE___malloc_trim
#define __CRT_HAVE___malloc_usable_size
#define __CRT_HAVE___mallopt
#define __CRT_HAVE___matherr
#define __CRT_HAVE___mbsnrtowcs
#define __CRT_HAVE___mbsrtowcs
#define __CRT_HAVE___memalign
#define __CRT_HAVE___memccpy
#define __CRT_HAVE___mkdir
#define __CRT_HAVE___mktime_internal
#define __CRT_HAVE___mlock
#define __CRT_HAVE___mlockall
#define __CRT_HAVE___modf
#define __CRT_HAVE___modff
#define __CRT_HAVE___modfl
#define __CRT_HAVE___mon_yday
#define __CRT_HAVE___mount
#define __CRT_HAVE___mpn_add
#define __CRT_HAVE___mpn_add_1
#define __CRT_HAVE___mpn_add_n
#define __CRT_HAVE___mpn_addmul_1
#define __CRT_HAVE___mpn_cmp
#define __CRT_HAVE___mpn_construct_double
#define __CRT_HAVE___mpn_construct_float
#define __CRT_HAVE___mpn_construct_long_double
#define __CRT_HAVE___mpn_divmod_1
#define __CRT_HAVE___mpn_divrem
#define __CRT_HAVE___mpn_extract_double
#define __CRT_HAVE___mpn_extract_long_double
#define __CRT_HAVE___mpn_impn_mul_n
#define __CRT_HAVE___mpn_impn_mul_n_basecase
#define __CRT_HAVE___mpn_impn_sqr_n
#define __CRT_HAVE___mpn_impn_sqr_n_basecase
#define __CRT_HAVE___mpn_lshift
#define __CRT_HAVE___mpn_mod_1
#define __CRT_HAVE___mpn_mul
#define __CRT_HAVE___mpn_mul_1
#define __CRT_HAVE___mpn_mul_n
#define __CRT_HAVE___mpn_rshift
#define __CRT_HAVE___mpn_sub
#define __CRT_HAVE___mpn_sub_1
#define __CRT_HAVE___mpn_sub_n
#define __CRT_HAVE___mpn_submul_1
#define __CRT_HAVE___mremap
#define __CRT_HAVE___munlock
#define __CRT_HAVE___munlockall
#define __CRT_HAVE___new_exitfn
#define __CRT_HAVE___nextafter
#define __CRT_HAVE___nextafterf
#define __CRT_HAVE___nextafterl
#define __CRT_HAVE___no_r_state
#define __CRT_HAVE___nss_aliases_database
#define __CRT_HAVE___nss_aliases_lookup
#define __CRT_HAVE___nss_ethers_database
#define __CRT_HAVE___nss_ethers_lookup
#define __CRT_HAVE___nss_group_database
#define __CRT_HAVE___nss_hosts_database
#define __CRT_HAVE___nss_netgroup_database
#define __CRT_HAVE___nss_netgroup_lookup
#define __CRT_HAVE___nss_networks_database
#define __CRT_HAVE___nss_networks_lookup
#define __CRT_HAVE___nss_passwd_database
#define __CRT_HAVE___nss_protocols_database
#define __CRT_HAVE___nss_protocols_lookup
#define __CRT_HAVE___nss_publickey_database
#define __CRT_HAVE___nss_publickey_lookup
#define __CRT_HAVE___nss_rpc_database
#define __CRT_HAVE___nss_rpc_lookup
#define __CRT_HAVE___nss_services_database
#define __CRT_HAVE___nss_shadow_database
#define __CRT_HAVE___nss_shadow_lookup
#define __CRT_HAVE___offtime
#define __CRT_HAVE___opendir
#define __CRT_HAVE___pathconf
#define __CRT_HAVE___personality
#define __CRT_HAVE___pow
#define __CRT_HAVE___powf
#define __CRT_HAVE___powl
#define __CRT_HAVE___printf_arginfo_table
#define __CRT_HAVE___printf_function_table
#define __CRT_HAVE___pthread_mutexattr_setkind_np
#define __CRT_HAVE___pthread_return_0
#define __CRT_HAVE___pthread_return_1
#define __CRT_HAVE___pthread_return_void
#define __CRT_HAVE___pututline
#define __CRT_HAVE___pvalloc
#define __CRT_HAVE___random
#define __CRT_HAVE___random_r
#define __CRT_HAVE___readdir
#define __CRT_HAVE___readdir_r
#define __CRT_HAVE___readlink
#define __CRT_HAVE___realloc
#define __CRT_HAVE___recvfrom
#define __CRT_HAVE___recvmsg
#define __CRT_HAVE___register_printf_function
#define __CRT_HAVE___remainder
#define __CRT_HAVE___remainderf
#define __CRT_HAVE___remainderl
#define __CRT_HAVE___rint
#define __CRT_HAVE___rintf
#define __CRT_HAVE___rintl
#define __CRT_HAVE___rmdir
#define __CRT_HAVE___scalb
#define __CRT_HAVE___scalbf
#define __CRT_HAVE___scalbl
#define __CRT_HAVE___scalbn
#define __CRT_HAVE___scalbnf
#define __CRT_HAVE___scalbnl
#define __CRT_HAVE___sched_rr_get_interval
#define __CRT_HAVE___sched_setparam
#define __CRT_HAVE___sendmsg
#define __CRT_HAVE___sendto
#define __CRT_HAVE___setfpucw
#define __CRT_HAVE___setgid
#define __CRT_HAVE___setitimer
#define __CRT_HAVE___setjmp
#define __CRT_HAVE___setregid
#define __CRT_HAVE___setreuid
#define __CRT_HAVE___setsid
#define __CRT_HAVE___setsockopt
#define __CRT_HAVE___setstate
#define __CRT_HAVE___setstate_r
#define __CRT_HAVE___settimeofday
#define __CRT_HAVE___setuid
#define __CRT_HAVE___setutent
#define __CRT_HAVE___sgetspent_r
#define __CRT_HAVE___shutdown
#define __CRT_HAVE___sigblock
#define __CRT_HAVE___sigjmp_save
#define __CRT_HAVE___significand
#define __CRT_HAVE___significandf
#define __CRT_HAVE___significandl
#define __CRT_HAVE___sigprocmask
#define __CRT_HAVE___sigreturn
#define __CRT_HAVE___sigsetmask
#define __CRT_HAVE___sigvec
#define __CRT_HAVE___sin
#define __CRT_HAVE___sinf
#define __CRT_HAVE___sinh
#define __CRT_HAVE___sinhf
#define __CRT_HAVE___sinhl
#define __CRT_HAVE___sinl
#define __CRT_HAVE___socketpair
#define __CRT_HAVE___sqrt
#define __CRT_HAVE___sqrtf
#define __CRT_HAVE___sqrtl
#define __CRT_HAVE___srandom
#define __CRT_HAVE___srandom_r
#define __CRT_HAVE___start___libc_atexit
#define __CRT_HAVE___start___libc_subinit
#define __CRT_HAVE___stdio_gen_tempname
#define __CRT_HAVE___step
#define __CRT_HAVE___stop___libc_atexit
#define __CRT_HAVE___stop___libc_subinit
#define __CRT_HAVE___strncasecmp
#define __CRT_HAVE___strsep
#define __CRT_HAVE___symlink
#define __CRT_HAVE___sys_llseek
#define __CRT_HAVE___syscall__sysctl
#define __CRT_HAVE___syscall_fstat
#define __CRT_HAVE___syscall_getgroups
#define __CRT_HAVE___syscall_getpriority
#define __CRT_HAVE___syscall_lstat
#define __CRT_HAVE___syscall_mknod
#define __CRT_HAVE___syscall_ptrace
#define __CRT_HAVE___syscall_reboot
#define __CRT_HAVE___syscall_setgroups
#define __CRT_HAVE___syscall_sigsuspend
#define __CRT_HAVE___syscall_stat
#define __CRT_HAVE___syscall_ustat
#define __CRT_HAVE___tan
#define __CRT_HAVE___tanf
#define __CRT_HAVE___tanh
#define __CRT_HAVE___tanhf
#define __CRT_HAVE___tanhl
#define __CRT_HAVE___tanl
#define __CRT_HAVE___tcgetattr
#define __CRT_HAVE___textdomain
#define __CRT_HAVE___times
#define __CRT_HAVE___ttyname
#define __CRT_HAVE___ttyname_r
#define __CRT_HAVE___tz_compute
#define __CRT_HAVE___tzfile_compute
#define __CRT_HAVE___tzfile_default
#define __CRT_HAVE___tzfile_read
#define __CRT_HAVE___tzname_cur_max
#define __CRT_HAVE___tzname_max
#define __CRT_HAVE___tzset
#define __CRT_HAVE___tzset_internal
#define __CRT_HAVE___tzset_lock
#define __CRT_HAVE___ulckpwdf
#define __CRT_HAVE___ulimit
#define __CRT_HAVE___umask
#define __CRT_HAVE___umount
#define __CRT_HAVE___unlink
#define __CRT_HAVE___use_tzfile
#define __CRT_HAVE___utimes
#define __CRT_HAVE___utmpname
#define __CRT_HAVE___valloc
#define __CRT_HAVE___vm86
#define __CRT_HAVE___wait3
#define __CRT_HAVE___wait4
#define __CRT_HAVE___wcpcpy
#define __CRT_HAVE___wcpncpy
#define __CRT_HAVE___wcrtomb
#define __CRT_HAVE___wcsnrtombs
#define __CRT_HAVE___wcsrtombs
#define __CRT_HAVE___wcstoq_internal
#define __CRT_HAVE___wcstouq_internal
#define __CRT_HAVE___y0
#define __CRT_HAVE___y0f
#define __CRT_HAVE___y0l
#define __CRT_HAVE___y1
#define __CRT_HAVE___y1f
#define __CRT_HAVE___y1l
#define __CRT_HAVE___yn
#define __CRT_HAVE___ynf
#define __CRT_HAVE___ynl
#define __CRT_HAVE__cleanup
#define __CRT_HAVE__dl_argc
#define __CRT_HAVE__dl_default_scope
#define __CRT_HAVE__dl_fini
#define __CRT_HAVE__dl_global_scope_end
#define __CRT_HAVE__dl_load_cache_lookup
#define __CRT_HAVE__dl_map_object_from_fd
#define __CRT_HAVE__dl_new_object
#define __CRT_HAVE__dl_object_relocation_scope
#define __CRT_HAVE__dl_receive_error
#define __CRT_HAVE__dl_rpath
#define __CRT_HAVE__dl_rtld_map
#define __CRT_HAVE__dl_runtime_resolve
#define __CRT_HAVE__dl_setup_hash
#define __CRT_HAVE__dl_skip_args
#define __CRT_HAVE__dl_start
#define __CRT_HAVE__dl_start_user
#define __CRT_HAVE__dl_symbol_value
#define __CRT_HAVE__dl_sysdep_error
#define __CRT_HAVE__dl_sysdep_fatal
#define __CRT_HAVE__dl_sysdep_message
#define __CRT_HAVE__dl_sysdep_read_whole_file
#define __CRT_HAVE__dl_sysdep_start_cleanup
#define __CRT_HAVE__dlerror_run
#define __CRT_HAVE__edata
#define __CRT_HAVE__end
#define __CRT_HAVE__etext
#define __CRT_HAVE__fini
#define __CRT_HAVE__fpioconst_pow10
#define __CRT_HAVE__fxstat
#define __CRT_HAVE__getopt_internal
#define __CRT_HAVE__gmonparam
#define __CRT_HAVE__init
#define __CRT_HAVE__itoa
#define __CRT_HAVE__longjmp_unwind
#define __CRT_HAVE__lxstat
#define __CRT_HAVE__mtrace_file
#define __CRT_HAVE__mtrace_line
#define __CRT_HAVE__nl_C
#define __CRT_HAVE__nl_C_LC_COLLATE
#define __CRT_HAVE__nl_C_LC_COLLATE_symbol_classes
#define __CRT_HAVE__nl_C_LC_COLLATE_symbol_hash
#define __CRT_HAVE__nl_C_LC_COLLATE_symbol_strings
#define __CRT_HAVE__nl_C_LC_CTYPE
#define __CRT_HAVE__nl_C_LC_CTYPE_class
#define __CRT_HAVE__nl_C_LC_CTYPE_class32
#define __CRT_HAVE__nl_C_LC_CTYPE_names
#define __CRT_HAVE__nl_C_LC_CTYPE_tolower
#define __CRT_HAVE__nl_C_LC_CTYPE_toupper
#define __CRT_HAVE__nl_C_LC_CTYPE_width
#define __CRT_HAVE__nl_C_LC_MESSAGES
#define __CRT_HAVE__nl_C_LC_MONETARY
#define __CRT_HAVE__nl_C_LC_NUMERIC
#define __CRT_HAVE__nl_C_LC_TIME
#define __CRT_HAVE__nl_C_name
#define __CRT_HAVE__nl_category_name_sizes
#define __CRT_HAVE__nl_category_names
#define __CRT_HAVE__nl_current_LC_MESSAGES
#define __CRT_HAVE__nl_current_LC_MONETARY
#define __CRT_HAVE__nl_current_LC_NUMERIC
#define __CRT_HAVE__nl_current_LC_TIME
#define __CRT_HAVE__nl_current_default_domain
#define __CRT_HAVE__nl_default_default_domain
#define __CRT_HAVE__nl_expand_alias
#define __CRT_HAVE__nl_explode_name
#define __CRT_HAVE__nl_find_domain
#define __CRT_HAVE__nl_find_locale
#define __CRT_HAVE__nl_get_alt_digit
#define __CRT_HAVE__nl_get_era_entry
#define __CRT_HAVE__nl_load_domain
#define __CRT_HAVE__nl_load_locale
#define __CRT_HAVE__nl_make_l10nflist
#define __CRT_HAVE__nl_normalize_codeset
#define __CRT_HAVE__nl_postload_collate
#define __CRT_HAVE__nl_postload_ctype
#define __CRT_HAVE__nl_postload_time
#define __CRT_HAVE__quicksort
#define __CRT_HAVE__sigintr
#define __CRT_HAVE__start
#define __CRT_HAVE__strerror_internal
#define __CRT_HAVE__svcauth_null
#define __CRT_HAVE__svcauth_short
#define __CRT_HAVE__svcauth_unix
#define __CRT_HAVE__sys_sigabbrev
#define __CRT_HAVE__tmbuf
#define __CRT_HAVE__wordcopy_bwd_aligned
#define __CRT_HAVE__wordcopy_bwd_dest_aligned
#define __CRT_HAVE__wordcopy_fwd_aligned
#define __CRT_HAVE__wordcopy_fwd_dest_aligned
#define __CRT_HAVE__xmknod
#define __CRT_HAVE__xstat
#define __CRT_HAVE_clearerr_locked
#define __CRT_HAVE_feof_locked
#define __CRT_HAVE_ferror_locked
#define __CRT_HAVE_fflush_locked
#define __CRT_HAVE_fileno_locked
#define __CRT_HAVE_fputc_locked
#define __CRT_HAVE_gamma_r
#define __CRT_HAVE_gammaf_r
#define __CRT_HAVE_gammal_r
#define __CRT_HAVE_getc_locked
#define __CRT_HAVE_getchar_locked
#define __CRT_HAVE_md5_buffer
#define __CRT_HAVE_md5_crypt
#define __CRT_HAVE_md5_crypt_r
#define __CRT_HAVE_md5_finish_ctx
#define __CRT_HAVE_md5_init_ctx
#define __CRT_HAVE_md5_process_block
#define __CRT_HAVE_md5_process_bytes
#define __CRT_HAVE_md5_read_ctx
#define __CRT_HAVE_md5_stream
#define __CRT_HAVE_profil_counter
#define __CRT_HAVE_putc_locked
#define __CRT_HAVE_putchar_locked
#endif /* __GLIBC_VERSION__ <= 20004 */
#if __GLIBC_VERSION__ <= 20004 || (__GLIBC_VERSION__ >= 20601 && __GLIBC_VERSION__ <= 20700)
#define __CRT_HAVE___nss_services_lookup
#endif /* __GLIBC_VERSION__ <= 20004 || (__GLIBC_VERSION__ >= 20601 && __GLIBC_VERSION__ <= 20700) */
#if __GLIBC_VERSION__ <= 20004 || (__GLIBC_VERSION__ >= 21290 && __GLIBC_VERSION__ <= 21800) || __GLIBC_VERSION__ >= 22000
#define __CRT_HAVE___getrlimit
#endif /* __GLIBC_VERSION__ <= 20004 || (__GLIBC_VERSION__ >= 21290 && __GLIBC_VERSION__ <= 21800) || __GLIBC_VERSION__ >= 22000 */
#if __GLIBC_VERSION__ <= 20004 || __GLIBC_VERSION__ == 20205
#define __CRT_HAVE__dl_pagesize
#endif /* __GLIBC_VERSION__ <= 20004 || __GLIBC_VERSION__ == 20205 */
#if __GLIBC_VERSION__ <= 20004 || __GLIBC_VERSION__ == 20302
#define __CRT_HAVE___pselect
#define __CRT_HAVE___sigwait
#endif /* __GLIBC_VERSION__ <= 20004 || __GLIBC_VERSION__ == 20302 */
#if __GLIBC_VERSION__ <= 20004 || __GLIBC_VERSION__ >= 20205
#define __CRT_HAVE___endmntent
#define __CRT_HAVE___getmntent_r
#define __CRT_HAVE___mbrtowc
#define __CRT_HAVE___setmntent
#define __CRT_HAVE___statfs
#define __CRT_HAVE___strndup
#define __CRT_HAVE___sysconf
#define __CRT_HAVE__dl_argv
#define __CRT_HAVE_moncontrol
#endif /* __GLIBC_VERSION__ <= 20004 || __GLIBC_VERSION__ >= 20205 */
#if __GLIBC_VERSION__ <= 20004 || __GLIBC_VERSION__ >= 20302
#define __CRT_HAVE___libc_fatal
#define __CRT_HAVE___nanosleep
#endif /* __GLIBC_VERSION__ <= 20004 || __GLIBC_VERSION__ >= 20302 */
#if __GLIBC_VERSION__ <= 20004 || __GLIBC_VERSION__ >= 21500
#define __CRT_HAVE___nss_lookup
#endif /* __GLIBC_VERSION__ <= 20004 || __GLIBC_VERSION__ >= 21500 */
#if __GLIBC_VERSION__ <= 20004 || __GLIBC_VERSION__ >= 22200
#define __CRT_HAVE___recv
#define __CRT_HAVE___socket
#define __CRT_HAVE___tdelete
#define __CRT_HAVE___tfind
#define __CRT_HAVE___tsearch
#define __CRT_HAVE___twalk
#endif /* __GLIBC_VERSION__ <= 20004 || __GLIBC_VERSION__ >= 22200 */
#if __GLIBC_VERSION__ <= 20004 || __GLIBC_VERSION__ >= 22600
#define __CRT_HAVE___mmap
#define __CRT_HAVE___mprotect
#define __CRT_HAVE___munmap
#define __CRT_HAVE___snprintf
#endif /* __GLIBC_VERSION__ <= 20004 || __GLIBC_VERSION__ >= 22600 */
#if __GLIBC_VERSION__ <= 20103
#define __CRT_HAVE___collate_element_hash
#define __CRT_HAVE___collate_element_strings
#define __CRT_HAVE___collate_symbol_classes
#define __CRT_HAVE___collate_symbol_hash
#define __CRT_HAVE___collate_symbol_strings
#define __CRT_HAVE__dl_init_next
#endif /* __GLIBC_VERSION__ <= 20103 */
#if __GLIBC_VERSION__ <= 20205
#define __CRT_HAVE___chown
#define __CRT_HAVE___pthread_initialize
#define __CRT_HAVE__dl_debug_initialize
#define __CRT_HAVE__dl_global_scope
#define __CRT_HAVE__dl_global_scope_alloc
#define __CRT_HAVE__dl_sysdep_start
#define __CRT_HAVE__errno
#define __CRT_HAVE__nl_current_LC_COLLATE
#define __CRT_HAVE__nl_current_LC_CTYPE
#endif /* __GLIBC_VERSION__ <= 20205 */
#if __GLIBC_VERSION__ <= 20302
#define __CRT_HAVE___libc_close
#define __CRT_HAVE___libc_fcntl
#define __CRT_HAVE___libc_fsync
#define __CRT_HAVE___libc_lseek
#define __CRT_HAVE___libc_msync
#define __CRT_HAVE___libc_nanosleep
#define __CRT_HAVE___libc_open
#define __CRT_HAVE___libc_pause
#define __CRT_HAVE___libc_read
#define __CRT_HAVE___libc_tcdrain
#define __CRT_HAVE___libc_wait
#define __CRT_HAVE___libc_waitpid
#define __CRT_HAVE___libc_write
#define __CRT_HAVE___on_exit
#define __CRT_HAVE__dl_lookup_symbol
#define __CRT_HAVE__dl_lookup_symbol_skip
#define __CRT_HAVE__dl_map_object
#define __CRT_HAVE__dl_map_object_deps
#define __CRT_HAVE__dl_relocate_object
#define __CRT_HAVE__itoa_upper_digits
#endif /* __GLIBC_VERSION__ <= 20302 */
#if __GLIBC_VERSION__ <= 20302 || (__GLIBC_VERSION__ >= 22600 && __GLIBC_VERSION__ <= 23600)
#define __CRT_HAVE__dl_catch_error
#endif /* __GLIBC_VERSION__ <= 20302 || (__GLIBC_VERSION__ >= 22600 && __GLIBC_VERSION__ <= 23600) */
#if __GLIBC_VERSION__ <= 20302 || __GLIBC_VERSION__ >= 22600
#define __CRT_HAVE__dl_signal_error
#endif /* __GLIBC_VERSION__ <= 20302 || __GLIBC_VERSION__ >= 22600 */
#if __GLIBC_VERSION__ <= 20306
#define __CRT_HAVE__dl_close
#define __CRT_HAVE__dl_open
#endif /* __GLIBC_VERSION__ <= 20306 */
#if __GLIBC_VERSION__ <= 22100
#define __CRT_HAVE_h_errno
#endif /* __GLIBC_VERSION__ <= 22100 */
#if __GLIBC_VERSION__ <= 23000
#define __CRT_HAVE_crypt
#define __CRT_HAVE_crypt_r
#endif /* __GLIBC_VERSION__ <= 23000 */
#if __GLIBC_VERSION__ <= 23200
#define __CRT_HAVE__dl_starting_up
#endif /* __GLIBC_VERSION__ <= 23200 */
#if __GLIBC_VERSION__ == 20004
#define __CRT_HAVE___clearenv
#define __CRT_HAVE___error
#define __CRT_HAVE___error_at_line
#define __CRT_HAVE___euidaccess
#define __CRT_HAVE___getopt_clean_environment
#define __CRT_HAVE___getopt_nonoption_flags
#define __CRT_HAVE___glob_pattern_p
#define __CRT_HAVE___libc_malloc_initialized
#define __CRT_HAVE___libc_pid
#define __CRT_HAVE___malloc_check_init
#define __CRT_HAVE___malloc_get_state
#define __CRT_HAVE___malloc_set_state
#define __CRT_HAVE___mcount_internal
#define __CRT_HAVE___nss_shlib_revision
#define __CRT_HAVE___readv
#define __CRT_HAVE___syscall_poll
#define __CRT_HAVE___syscall_readv
#define __CRT_HAVE___syscall_writev
#define __CRT_HAVE___writev
#endif /* __GLIBC_VERSION__ == 20004 */
#if __GLIBC_VERSION__ == 20103
#define __CRT_HAVE__dl_debug_impcalls
#define __CRT_HAVE__dl_debug_message
#endif /* __GLIBC_VERSION__ == 20103 */
#if __GLIBC_VERSION__ == 20205
#define __CRT_HAVE__IO_wdefault_setbuf
#define __CRT_HAVE__IO_wfile_setbuf
#define __CRT_HAVE___dcngettext
#define __CRT_HAVE___dso_handle
#define __CRT_HAVE___gconv_cache
#define __CRT_HAVE___rpc_thread_destroy
#define __CRT_HAVE__dl_all_dirs
#define __CRT_HAVE__dl_clktck
#define __CRT_HAVE__dl_debug_mask
#define __CRT_HAVE__dl_init_all_dirs
#define __CRT_HAVE__dl_load_lock
#define __CRT_HAVE__dl_nloaded
#endif /* __GLIBC_VERSION__ == 20205 */
#if __GLIBC_VERSION__ == 20205 || __GLIBC_VERSION__ >= 23000
#define __CRT_HAVE_getdents64
#endif /* __GLIBC_VERSION__ == 20205 || __GLIBC_VERSION__ >= 23000 */
#if __GLIBC_VERSION__ == 20302
#define __CRT_HAVE___libc_readv
#define __CRT_HAVE___libc_writev
#define __CRT_HAVE___sigwaitinfo
#define __CRT_HAVE___waitid
#define __CRT_HAVE__dl_get_origin
#define __CRT_HAVE__dl_tls_symaddr
#endif /* __GLIBC_VERSION__ == 20302 */
#if __GLIBC_VERSION__ == 20302 || __GLIBC_VERSION__ >= 22700
#define __CRT_HAVE___sigtimedwait
#endif /* __GLIBC_VERSION__ == 20302 || __GLIBC_VERSION__ >= 22700 */
#if __GLIBC_VERSION__ == 21700 || __GLIBC_VERSION__ >= 22200
#define __CRT_HAVE___h_errno
#define __CRT_HAVE___libc_scratch_buffer_grow
#define __CRT_HAVE___libc_scratch_buffer_grow_preserve
#define __CRT_HAVE___libc_scratch_buffer_set_array_size
#endif /* __GLIBC_VERSION__ == 21700 || __GLIBC_VERSION__ >= 22200 */
#if __GLIBC_VERSION__ == 21700 || __GLIBC_VERSION__ >= 22300
#define __CRT_HAVE___netlink_assert_response
#define __CRT_HAVE___strtod_nan
#define __CRT_HAVE___strtof_nan
#define __CRT_HAVE___strtold_nan
#endif /* __GLIBC_VERSION__ == 21700 || __GLIBC_VERSION__ >= 22300 */
#if __GLIBC_VERSION__ == 21700 || __GLIBC_VERSION__ >= 22400
#define __CRT_HAVE___copy_grp
#define __CRT_HAVE___merge_grp
#endif /* __GLIBC_VERSION__ == 21700 || __GLIBC_VERSION__ >= 22400 */
#if __GLIBC_VERSION__ == 21700 || __GLIBC_VERSION__ >= 22600
#define __CRT_HAVE___inet6_scopeid_pton
#define __CRT_HAVE___inet_pton_length
#define __CRT_HAVE___libc_alloc_buffer_alloc_array
#define __CRT_HAVE___libc_alloc_buffer_allocate
#define __CRT_HAVE___libc_alloc_buffer_copy_bytes
#define __CRT_HAVE___libc_alloc_buffer_copy_string
#define __CRT_HAVE___libc_alloc_buffer_create_failure
#define __CRT_HAVE___libc_dynarray_at_failure
#define __CRT_HAVE___libc_dynarray_emplace_enlarge
#define __CRT_HAVE___libc_dynarray_finalize
#define __CRT_HAVE___libc_dynarray_resize
#define __CRT_HAVE___libc_dynarray_resize_clear
#define __CRT_HAVE___resolv_context_get
#define __CRT_HAVE___resolv_context_get_override
#define __CRT_HAVE___resolv_context_get_preinit
#define __CRT_HAVE___resolv_context_put
#endif /* __GLIBC_VERSION__ == 21700 || __GLIBC_VERSION__ >= 22600 */
#if __GLIBC_VERSION__ == 21700 || __GLIBC_VERSION__ >= 22900
#define __CRT_HAVE___inet_aton_exact
#endif /* __GLIBC_VERSION__ == 21700 || __GLIBC_VERSION__ >= 22900 */
#if __GLIBC_VERSION__ == 23300
#define __CRT_HAVE___futex_abstimed_wait64
#define __CRT_HAVE___futex_abstimed_wait_cancelable64
#endif /* __GLIBC_VERSION__ == 23300 */
#if __GLIBC_VERSION__ >= 20004
#define __CRT_HAVE___after_morecore_hook
#define __CRT_HAVE___cmsg_nxthdr
#define __CRT_HAVE___morecore
#define __CRT_HAVE_atoll
#define __CRT_HAVE_getresuid
#define __CRT_HAVE_glob_pattern_p
#define __CRT_HAVE_nfsservctl
#define __CRT_HAVE_query_module
#define __CRT_HAVE_setresuid
#define __CRT_HAVE_sigandset
#define __CRT_HAVE_sigisemptyset
#define __CRT_HAVE_sigorset
#define __CRT_HAVE_svc_exit
#define __CRT_HAVE_updwtmp
#endif /* __GLIBC_VERSION__ >= 20004 */
#if __GLIBC_VERSION__ >= 20103
#define __CRT_HAVE__Exit
#define __CRT_HAVE__IO_2_1_stderr_
#define __CRT_HAVE__IO_2_1_stdin_
#define __CRT_HAVE__IO_2_1_stdout_
#define __CRT_HAVE__IO_file_open
#define __CRT_HAVE__IO_getline_info
#define __CRT_HAVE___asprintf
#define __CRT_HAVE___backtrace
#define __CRT_HAVE___backtrace_symbols
#define __CRT_HAVE___backtrace_symbols_fd
#define __CRT_HAVE___bsd_getpgrp
#define __CRT_HAVE___bzero
#define __CRT_HAVE___clog10
#define __CRT_HAVE___clog10f
#define __CRT_HAVE___clog10l
#define __CRT_HAVE___cxa_atexit
#define __CRT_HAVE___cxa_finalize
#define __CRT_HAVE___duplocale
#define __CRT_HAVE___ffs
#define __CRT_HAVE___fpclassify
#define __CRT_HAVE___fpclassifyf
#define __CRT_HAVE___fpclassifyl
#define __CRT_HAVE___freelocale
#define __CRT_HAVE___fxstat64
#define __CRT_HAVE___isalnum_l
#define __CRT_HAVE___isalpha_l
#define __CRT_HAVE___isascii_l
#define __CRT_HAVE___isblank_l
#define __CRT_HAVE___iscntrl_l
#define __CRT_HAVE___isdigit_l
#define __CRT_HAVE___isgraph_l
#define __CRT_HAVE___islower_l
#define __CRT_HAVE___isprint_l
#define __CRT_HAVE___ispunct_l
#define __CRT_HAVE___isspace_l
#define __CRT_HAVE___isupper_l
#define __CRT_HAVE___iswalnum_l
#define __CRT_HAVE___iswalpha_l
#define __CRT_HAVE___iswblank_l
#define __CRT_HAVE___iswcntrl_l
#define __CRT_HAVE___iswctype_l
#define __CRT_HAVE___iswdigit_l
#define __CRT_HAVE___iswgraph_l
#define __CRT_HAVE___iswlower_l
#define __CRT_HAVE___iswprint_l
#define __CRT_HAVE___iswpunct_l
#define __CRT_HAVE___iswspace_l
#define __CRT_HAVE___iswupper_l
#define __CRT_HAVE___iswxdigit_l
#define __CRT_HAVE___isxdigit_l
#define __CRT_HAVE___key_decryptsession_pk_LOCAL
#define __CRT_HAVE___key_encryptsession_pk_LOCAL
#define __CRT_HAVE___key_gendes_LOCAL
#define __CRT_HAVE___libc_allocate_rtsig
#define __CRT_HAVE___libc_current_sigrtmax
#define __CRT_HAVE___libc_current_sigrtmin
#define __CRT_HAVE___libc_fork
#define __CRT_HAVE___libc_freeres
#define __CRT_HAVE___libc_pwrite
#define __CRT_HAVE___libc_sa_len
#define __CRT_HAVE___libc_stack_end
#define __CRT_HAVE___libc_start_main
#define __CRT_HAVE___lxstat64
#define __CRT_HAVE___mempcpy
#define __CRT_HAVE___mempcpy_small
#define __CRT_HAVE___monstartup
#define __CRT_HAVE___newlocale
#define __CRT_HAVE___poll
#define __CRT_HAVE___pread64
#define __CRT_HAVE___pthread_once
#define __CRT_HAVE___pwrite64
#define __CRT_HAVE___rawmemchr
#define __CRT_HAVE___signbit
#define __CRT_HAVE___signbitf
#define __CRT_HAVE___signbitl
#define __CRT_HAVE___stpcpy_small
#define __CRT_HAVE___strcasecmp_l
#define __CRT_HAVE___strcasestr
#define __CRT_HAVE___strcoll_l
#define __CRT_HAVE___strfmon_l
#define __CRT_HAVE___strncasecmp_l
#define __CRT_HAVE___strsep_1c
#define __CRT_HAVE___strsep_2c
#define __CRT_HAVE___strsep_3c
#define __CRT_HAVE___strsep_g
#define __CRT_HAVE___strtod_l
#define __CRT_HAVE___strtof_l
#define __CRT_HAVE___strtok_r
#define __CRT_HAVE___strtok_r_1c
#define __CRT_HAVE___strtol_l
#define __CRT_HAVE___strtold_l
#define __CRT_HAVE___strtoll_internal
#define __CRT_HAVE___strtoll_l
#define __CRT_HAVE___strtoul_l
#define __CRT_HAVE___strtoull_internal
#define __CRT_HAVE___strtoull_l
#define __CRT_HAVE___strverscmp
#define __CRT_HAVE___strxfrm_l
#define __CRT_HAVE___toascii_l
#define __CRT_HAVE___tolower_l
#define __CRT_HAVE___toupper_l
#define __CRT_HAVE___towctrans
#define __CRT_HAVE___towctrans_l
#define __CRT_HAVE___towlower_l
#define __CRT_HAVE___towupper_l
#define __CRT_HAVE___wcscasecmp_l
#define __CRT_HAVE___wcscoll_l
#define __CRT_HAVE___wcsncasecmp_l
#define __CRT_HAVE___wcstod_l
#define __CRT_HAVE___wcstof_l
#define __CRT_HAVE___wcstol_l
#define __CRT_HAVE___wcstold_l
#define __CRT_HAVE___wcstoll_internal
#define __CRT_HAVE___wcstoll_l
#define __CRT_HAVE___wcstoul_l
#define __CRT_HAVE___wcstoull_internal
#define __CRT_HAVE___wcstoull_l
#define __CRT_HAVE___wcsxfrm_l
#define __CRT_HAVE___wctype_l
#define __CRT_HAVE___xpg_basename
#define __CRT_HAVE___xstat64
#define __CRT_HAVE__dl_mcount
#define __CRT_HAVE__dl_mcount_wrapper
#define __CRT_HAVE__dl_mcount_wrapper_check
#define __CRT_HAVE_addseverity
#define __CRT_HAVE_aio_cancel
#define __CRT_HAVE_aio_cancel64
#define __CRT_HAVE_aio_error
#define __CRT_HAVE_aio_error64
#define __CRT_HAVE_aio_fsync
#define __CRT_HAVE_aio_fsync64
#define __CRT_HAVE_aio_init
#define __CRT_HAVE_aio_read
#define __CRT_HAVE_aio_read64
#define __CRT_HAVE_aio_return
#define __CRT_HAVE_aio_return64
#define __CRT_HAVE_aio_suspend
#define __CRT_HAVE_aio_suspend64
#define __CRT_HAVE_aio_write
#define __CRT_HAVE_aio_write64
#define __CRT_HAVE_alphasort64
#define __CRT_HAVE_argp_err_exit_status
#define __CRT_HAVE_argp_error
#define __CRT_HAVE_argp_failure
#define __CRT_HAVE_argp_help
#define __CRT_HAVE_argp_parse
#define __CRT_HAVE_argp_program_bug_address
#define __CRT_HAVE_argp_program_version
#define __CRT_HAVE_argp_program_version_hook
#define __CRT_HAVE_argp_state_help
#define __CRT_HAVE_argp_usage
#define __CRT_HAVE_argz_add_sep
#define __CRT_HAVE_argz_replace
#define __CRT_HAVE_authdes_create
#define __CRT_HAVE_authdes_getucred
#define __CRT_HAVE_authdes_pk_create
#define __CRT_HAVE_backtrace
#define __CRT_HAVE_backtrace_symbols
#define __CRT_HAVE_backtrace_symbols_fd
#define __CRT_HAVE_cacos
#define __CRT_HAVE_cacosf
#define __CRT_HAVE_cacosh
#define __CRT_HAVE_cacoshf
#define __CRT_HAVE_cacoshl
#define __CRT_HAVE_cacosl
#define __CRT_HAVE_capget
#define __CRT_HAVE_capset
#define __CRT_HAVE_carg
#define __CRT_HAVE_cargf
#define __CRT_HAVE_cargl
#define __CRT_HAVE_casin
#define __CRT_HAVE_casinf
#define __CRT_HAVE_casinh
#define __CRT_HAVE_casinhf
#define __CRT_HAVE_casinhl
#define __CRT_HAVE_casinl
#define __CRT_HAVE_catan
#define __CRT_HAVE_catanf
#define __CRT_HAVE_catanh
#define __CRT_HAVE_catanhf
#define __CRT_HAVE_catanhl
#define __CRT_HAVE_catanl
#define __CRT_HAVE_cbc_crypt
#define __CRT_HAVE_ccos
#define __CRT_HAVE_ccosf
#define __CRT_HAVE_ccosh
#define __CRT_HAVE_ccoshf
#define __CRT_HAVE_ccoshl
#define __CRT_HAVE_ccosl
#define __CRT_HAVE_cexp
#define __CRT_HAVE_cexpf
#define __CRT_HAVE_cexpl
#define __CRT_HAVE_cimag
#define __CRT_HAVE_cimagf
#define __CRT_HAVE_cimagl
#define __CRT_HAVE_clntunix_create
#define __CRT_HAVE_clog
#define __CRT_HAVE_clog10
#define __CRT_HAVE_clog10f
#define __CRT_HAVE_clog10l
#define __CRT_HAVE_clogf
#define __CRT_HAVE_clogl
#define __CRT_HAVE_conj
#define __CRT_HAVE_conjf
#define __CRT_HAVE_conjl
#define __CRT_HAVE_cpow
#define __CRT_HAVE_cpowf
#define __CRT_HAVE_cpowl
#define __CRT_HAVE_cproj
#define __CRT_HAVE_cprojf
#define __CRT_HAVE_cprojl
#define __CRT_HAVE_creal
#define __CRT_HAVE_crealf
#define __CRT_HAVE_creall
#define __CRT_HAVE_creat64
#define __CRT_HAVE_csin
#define __CRT_HAVE_csinf
#define __CRT_HAVE_csinh
#define __CRT_HAVE_csinhf
#define __CRT_HAVE_csinhl
#define __CRT_HAVE_csinl
#define __CRT_HAVE_csqrt
#define __CRT_HAVE_csqrtf
#define __CRT_HAVE_csqrtl
#define __CRT_HAVE_ctan
#define __CRT_HAVE_ctanf
#define __CRT_HAVE_ctanh
#define __CRT_HAVE_ctanhf
#define __CRT_HAVE_ctanhl
#define __CRT_HAVE_ctanl
#define __CRT_HAVE_des_setparity
#define __CRT_HAVE_dlvsym
#define __CRT_HAVE_ecb_crypt
#define __CRT_HAVE_endutxent
#define __CRT_HAVE_erfcl
#define __CRT_HAVE_exp10
#define __CRT_HAVE_exp10f
#define __CRT_HAVE_exp10l
#define __CRT_HAVE_exp2
#define __CRT_HAVE_exp2f
#define __CRT_HAVE_exp2l
#define __CRT_HAVE_fattach
#define __CRT_HAVE_fdetach
#define __CRT_HAVE_fdim
#define __CRT_HAVE_fdimf
#define __CRT_HAVE_fdiml
#define __CRT_HAVE_feclearexcept
#define __CRT_HAVE_fegetenv
#define __CRT_HAVE_fegetexceptflag
#define __CRT_HAVE_fegetround
#define __CRT_HAVE_feholdexcept
#define __CRT_HAVE_feraiseexcept
#define __CRT_HAVE_fesetenv
#define __CRT_HAVE_fesetexceptflag
#define __CRT_HAVE_fesetround
#define __CRT_HAVE_fetestexcept
#define __CRT_HAVE_feupdateenv
#define __CRT_HAVE_ffsl
#define __CRT_HAVE_ffsll
#define __CRT_HAVE_fgetc_unlocked
#define __CRT_HAVE_fgetpos64
#define __CRT_HAVE_fgets_unlocked
#define __CRT_HAVE_fma
#define __CRT_HAVE_fmaf
#define __CRT_HAVE_fmal
#define __CRT_HAVE_fmax
#define __CRT_HAVE_fmaxf
#define __CRT_HAVE_fmaxl
#define __CRT_HAVE_fmin
#define __CRT_HAVE_fminf
#define __CRT_HAVE_fminl
#define __CRT_HAVE_fmtmsg
#define __CRT_HAVE_fopen64
#define __CRT_HAVE_fputs_unlocked
#define __CRT_HAVE_fread_unlocked
#define __CRT_HAVE_freopen64
#define __CRT_HAVE_fseeko
#define __CRT_HAVE_fseeko64
#define __CRT_HAVE_fsetpos64
#define __CRT_HAVE_fstatfs64
#define __CRT_HAVE_fstatvfs
#define __CRT_HAVE_fstatvfs64
#define __CRT_HAVE_ftello
#define __CRT_HAVE_ftello64
#define __CRT_HAVE_ftruncate64
#define __CRT_HAVE_ftw64
#define __CRT_HAVE_fwrite_unlocked
#define __CRT_HAVE_gai_strerror
#define __CRT_HAVE_getcontext
#define __CRT_HAVE_getdate
#define __CRT_HAVE_getdate_err
#define __CRT_HAVE_getdate_r
#define __CRT_HAVE_getmsg
#define __CRT_HAVE_getnameinfo
#define __CRT_HAVE_getnetname
#define __CRT_HAVE_getpmsg
#define __CRT_HAVE_getpt
#define __CRT_HAVE_getresgid
#define __CRT_HAVE_getrlimit64
#define __CRT_HAVE_getutmp
#define __CRT_HAVE_getutmpx
#define __CRT_HAVE_getutxent
#define __CRT_HAVE_getutxid
#define __CRT_HAVE_getutxline
#define __CRT_HAVE_glob64
#define __CRT_HAVE_globfree64
#define __CRT_HAVE_gnu_get_libc_release
#define __CRT_HAVE_gnu_get_libc_version
#define __CRT_HAVE_grantpt
#define __CRT_HAVE_host2netname
#define __CRT_HAVE_iconv
#define __CRT_HAVE_iconv_close
#define __CRT_HAVE_iconv_open
#define __CRT_HAVE_if_freenameindex
#define __CRT_HAVE_if_indextoname
#define __CRT_HAVE_if_nameindex
#define __CRT_HAVE_if_nametoindex
#define __CRT_HAVE_imaxabs
#define __CRT_HAVE_imaxdiv
#define __CRT_HAVE_in6addr_any
#define __CRT_HAVE_in6addr_loopback
#define __CRT_HAVE_isastream
#define __CRT_HAVE_iswblank
#define __CRT_HAVE_key_decryptsession
#define __CRT_HAVE_key_decryptsession_pk
#define __CRT_HAVE_key_encryptsession
#define __CRT_HAVE_key_encryptsession_pk
#define __CRT_HAVE_key_gendes
#define __CRT_HAVE_key_get_conv
#define __CRT_HAVE_key_secretkey_is_set
#define __CRT_HAVE_key_setnet
#define __CRT_HAVE_key_setsecret
#define __CRT_HAVE_lio_listio
#define __CRT_HAVE_lio_listio64
#define __CRT_HAVE_llrint
#define __CRT_HAVE_llrintf
#define __CRT_HAVE_llrintl
#define __CRT_HAVE_llround
#define __CRT_HAVE_llroundf
#define __CRT_HAVE_llroundl
#define __CRT_HAVE_lockf64
#define __CRT_HAVE_log2
#define __CRT_HAVE_log2f
#define __CRT_HAVE_log2l
#define __CRT_HAVE_lrint
#define __CRT_HAVE_lrintf
#define __CRT_HAVE_lrintl
#define __CRT_HAVE_lround
#define __CRT_HAVE_lroundf
#define __CRT_HAVE_lroundl
#define __CRT_HAVE_lseek64
#define __CRT_HAVE_makecontext
#define __CRT_HAVE_mempcpy
#define __CRT_HAVE_mmap64
#define __CRT_HAVE_modify_ldt
#define __CRT_HAVE_nan
#define __CRT_HAVE_nanf
#define __CRT_HAVE_nanl
#define __CRT_HAVE_nearbyint
#define __CRT_HAVE_nearbyintf
#define __CRT_HAVE_nearbyintl
#define __CRT_HAVE_netname2host
#define __CRT_HAVE_netname2user
#define __CRT_HAVE_nexttoward
#define __CRT_HAVE_nexttowardf
#define __CRT_HAVE_nexttowardl
#define __CRT_HAVE_nftw
#define __CRT_HAVE_nftw64
#define __CRT_HAVE_ntp_adjtime
#define __CRT_HAVE_ntp_gettime
#define __CRT_HAVE_open64
#define __CRT_HAVE_passwd2des
#define __CRT_HAVE_pow10
#define __CRT_HAVE_pow10f
#define __CRT_HAVE_pow10l
#define __CRT_HAVE_prctl
#define __CRT_HAVE_pread
#define __CRT_HAVE_pread64
#define __CRT_HAVE_printf_size
#define __CRT_HAVE_printf_size_info
#define __CRT_HAVE_ptsname
#define __CRT_HAVE_ptsname_r
#define __CRT_HAVE_putgrent
#define __CRT_HAVE_putmsg
#define __CRT_HAVE_putpmsg
#define __CRT_HAVE_pututxline
#define __CRT_HAVE_pwrite
#define __CRT_HAVE_pwrite64
#define __CRT_HAVE_quotactl
#define __CRT_HAVE_rawmemchr
#define __CRT_HAVE_readdir64
#define __CRT_HAVE_readdir64_r
#define __CRT_HAVE_remquo
#define __CRT_HAVE_remquof
#define __CRT_HAVE_remquol
#define __CRT_HAVE_round
#define __CRT_HAVE_roundf
#define __CRT_HAVE_roundl
#define __CRT_HAVE_rtime
#define __CRT_HAVE_scalbln
#define __CRT_HAVE_scalblnf
#define __CRT_HAVE_scalblnl
#define __CRT_HAVE_scandir64
#define __CRT_HAVE_sendfile
#define __CRT_HAVE_setcontext
#define __CRT_HAVE_setresgid
#define __CRT_HAVE_setrlimit64
#define __CRT_HAVE_setutxent
#define __CRT_HAVE_sighold
#define __CRT_HAVE_sigignore
#define __CRT_HAVE_sigqueue
#define __CRT_HAVE_sigrelse
#define __CRT_HAVE_sigset
#define __CRT_HAVE_sigtimedwait
#define __CRT_HAVE_sigwaitinfo
#define __CRT_HAVE_sincos
#define __CRT_HAVE_sincosf
#define __CRT_HAVE_sincosl
#define __CRT_HAVE_statfs64
#define __CRT_HAVE_statvfs
#define __CRT_HAVE_statvfs64
#define __CRT_HAVE_strcasestr
#define __CRT_HAVE_strchrnul
#define __CRT_HAVE_strtoimax
#define __CRT_HAVE_strtoumax
#define __CRT_HAVE_strverscmp
#define __CRT_HAVE_svcauthdes_stats
#define __CRT_HAVE_svcunix_create
#define __CRT_HAVE_svcunixfd_create
#define __CRT_HAVE_swapcontext
#define __CRT_HAVE_sysv_signal
#define __CRT_HAVE_tcgetsid
#define __CRT_HAVE_tdestroy
#define __CRT_HAVE_tgamma
#define __CRT_HAVE_tgammaf
#define __CRT_HAVE_tgammal
#define __CRT_HAVE_tmpfile64
#define __CRT_HAVE_trunc
#define __CRT_HAVE_truncate64
#define __CRT_HAVE_truncf
#define __CRT_HAVE_truncl
#define __CRT_HAVE_umount2
#define __CRT_HAVE_unlockpt
#define __CRT_HAVE_updwtmpx
#define __CRT_HAVE_user2netname
#define __CRT_HAVE_utmpxname
#define __CRT_HAVE_versionsort
#define __CRT_HAVE_versionsort64
#define __CRT_HAVE_waitid
#define __CRT_HAVE_wcscasecmp
#define __CRT_HAVE_wcsncasecmp
#define __CRT_HAVE_wcsnlen
#define __CRT_HAVE_wcstoimax
#define __CRT_HAVE_wcstoll
#define __CRT_HAVE_wcstoull
#define __CRT_HAVE_wcstoumax
#define __CRT_HAVE_wcswcs
#define __CRT_HAVE_wordexp
#define __CRT_HAVE_wordfree
#define __CRT_HAVE_xdecrypt
#define __CRT_HAVE_xdr_authdes_cred
#define __CRT_HAVE_xdr_authdes_verf
#define __CRT_HAVE_xdr_cryptkeyarg
#define __CRT_HAVE_xdr_cryptkeyarg2
#define __CRT_HAVE_xdr_cryptkeyres
#define __CRT_HAVE_xdr_getcredres
#define __CRT_HAVE_xdr_hyper
#define __CRT_HAVE_xdr_int16_t
#define __CRT_HAVE_xdr_int32_t
#define __CRT_HAVE_xdr_int64_t
#define __CRT_HAVE_xdr_int8_t
#define __CRT_HAVE_xdr_key_netstarg
#define __CRT_HAVE_xdr_key_netstres
#define __CRT_HAVE_xdr_keybuf
#define __CRT_HAVE_xdr_keystatus
#define __CRT_HAVE_xdr_longlong_t
#define __CRT_HAVE_xdr_netnamestr
#define __CRT_HAVE_xdr_sizeof
#define __CRT_HAVE_xdr_u_hyper
#define __CRT_HAVE_xdr_u_longlong_t
#define __CRT_HAVE_xdr_uint16_t
#define __CRT_HAVE_xdr_uint32_t
#define __CRT_HAVE_xdr_uint64_t
#define __CRT_HAVE_xdr_uint8_t
#define __CRT_HAVE_xdr_unixcred
#define __CRT_HAVE_xencrypt
#endif /* __GLIBC_VERSION__ >= 20103 */
#if __GLIBC_VERSION__ >= 20205
#define __CRT_HAVE__IO_adjust_wcolumn
#define __CRT_HAVE__IO_fgetpos64
#define __CRT_HAVE__IO_free_wbackup_area
#define __CRT_HAVE__IO_fsetpos64
#define __CRT_HAVE__IO_init_wmarker
#define __CRT_HAVE__IO_iter_begin
#define __CRT_HAVE__IO_iter_end
#define __CRT_HAVE__IO_iter_file
#define __CRT_HAVE__IO_iter_next
#define __CRT_HAVE__IO_least_wmarker
#define __CRT_HAVE__IO_list_lock
#define __CRT_HAVE__IO_list_resetlock
#define __CRT_HAVE__IO_list_unlock
#define __CRT_HAVE__IO_seekwmark
#define __CRT_HAVE__IO_sputbackwc
#define __CRT_HAVE__IO_sungetwc
#define __CRT_HAVE__IO_switch_to_main_wget_area
#define __CRT_HAVE__IO_switch_to_wbackup_area
#define __CRT_HAVE__IO_switch_to_wget_mode
#define __CRT_HAVE__IO_unsave_wmarkers
#define __CRT_HAVE__IO_wdefault_doallocate
#define __CRT_HAVE__IO_wdefault_finish
#define __CRT_HAVE__IO_wdefault_pbackfail
#define __CRT_HAVE__IO_wdefault_uflow
#define __CRT_HAVE__IO_wdefault_xsgetn
#define __CRT_HAVE__IO_wdefault_xsputn
#define __CRT_HAVE__IO_wdo_write
#define __CRT_HAVE__IO_wdoallocbuf
#define __CRT_HAVE__IO_wfile_jumps
#define __CRT_HAVE__IO_wfile_overflow
#define __CRT_HAVE__IO_wfile_seekoff
#define __CRT_HAVE__IO_wfile_sync
#define __CRT_HAVE__IO_wfile_underflow
#define __CRT_HAVE__IO_wfile_xsputn
#define __CRT_HAVE__IO_wmarker_delta
#define __CRT_HAVE__IO_wsetb
#define __CRT_HAVE___assert
#define __CRT_HAVE___ctype32_tolower
#define __CRT_HAVE___ctype32_toupper
#define __CRT_HAVE___cyg_profile_func_enter
#define __CRT_HAVE___cyg_profile_func_exit
#define __CRT_HAVE___fbufsize
#define __CRT_HAVE___flbf
#define __CRT_HAVE___fpending
#define __CRT_HAVE___fpurge
#define __CRT_HAVE___freadable
#define __CRT_HAVE___freading
#define __CRT_HAVE___fsetlocking
#define __CRT_HAVE___fwritable
#define __CRT_HAVE___fwriting
#define __CRT_HAVE___nl_langinfo_l
#define __CRT_HAVE___nss_hostname_digits_dots
#define __CRT_HAVE___open64
#define __CRT_HAVE___res_init
#define __CRT_HAVE___res_nclose
#define __CRT_HAVE___res_ninit
#define __CRT_HAVE___res_state
#define __CRT_HAVE___rpc_thread_createerr
#define __CRT_HAVE___rpc_thread_svc_fdset
#define __CRT_HAVE___rpc_thread_svc_max_pollfd
#define __CRT_HAVE___rpc_thread_svc_pollfd
#define __CRT_HAVE___strcpy_small
#define __CRT_HAVE___strcspn_c1
#define __CRT_HAVE___strcspn_c2
#define __CRT_HAVE___strcspn_c3
#define __CRT_HAVE___strpbrk_c2
#define __CRT_HAVE___strpbrk_c3
#define __CRT_HAVE___strspn_c1
#define __CRT_HAVE___strspn_c2
#define __CRT_HAVE___strspn_c3
#define __CRT_HAVE___sysctl
#define __CRT_HAVE___wctrans_l
#define __CRT_HAVE___woverflow
#define __CRT_HAVE___wuflow
#define __CRT_HAVE___wunderflow
#define __CRT_HAVE___xpg_sigpause
#define __CRT_HAVE__flushlbf
#define __CRT_HAVE__res_hconf
#define __CRT_HAVE_bind_textdomain_codeset
#define __CRT_HAVE_clock_getcpuclockid
#define __CRT_HAVE_clock_getres
#define __CRT_HAVE_clock_gettime
#define __CRT_HAVE_clock_nanosleep
#define __CRT_HAVE_clock_settime
#define __CRT_HAVE_dcngettext
#define __CRT_HAVE_dl_iterate_phdr
#define __CRT_HAVE_dngettext
#define __CRT_HAVE_fedisableexcept
#define __CRT_HAVE_feenableexcept
#define __CRT_HAVE_fegetexcept
#define __CRT_HAVE_fgetwc
#define __CRT_HAVE_fgetwc_unlocked
#define __CRT_HAVE_fgetws
#define __CRT_HAVE_fgetws_unlocked
#define __CRT_HAVE_fmemopen
#define __CRT_HAVE_fputwc
#define __CRT_HAVE_fputwc_unlocked
#define __CRT_HAVE_fputws
#define __CRT_HAVE_fputws_unlocked
#define __CRT_HAVE_fwide
#define __CRT_HAVE_fwprintf
#define __CRT_HAVE_fwscanf
#define __CRT_HAVE_getdirentries64
#define __CRT_HAVE_getgrouplist
#define __CRT_HAVE_getloadavg
#define __CRT_HAVE_getwc
#define __CRT_HAVE_getwc_unlocked
#define __CRT_HAVE_getwchar
#define __CRT_HAVE_getwchar_unlocked
#define __CRT_HAVE_iruserok_af
#define __CRT_HAVE_mcheck_check_all
#define __CRT_HAVE_mcheck_pedantic
#define __CRT_HAVE_memrchr
#define __CRT_HAVE_mincore
#define __CRT_HAVE_mkdtemp
#define __CRT_HAVE_mkstemp64
#define __CRT_HAVE_ngettext
#define __CRT_HAVE_pivot_root
#define __CRT_HAVE_posix_fadvise
#define __CRT_HAVE_posix_fadvise64
#define __CRT_HAVE_posix_fallocate
#define __CRT_HAVE_posix_fallocate64
#define __CRT_HAVE_posix_madvise
#define __CRT_HAVE_posix_memalign
#define __CRT_HAVE_posix_openpt
#define __CRT_HAVE_posix_spawn
#define __CRT_HAVE_posix_spawn_file_actions_addclose
#define __CRT_HAVE_posix_spawn_file_actions_adddup2
#define __CRT_HAVE_posix_spawn_file_actions_addopen
#define __CRT_HAVE_posix_spawn_file_actions_destroy
#define __CRT_HAVE_posix_spawn_file_actions_init
#define __CRT_HAVE_posix_spawnattr_destroy
#define __CRT_HAVE_posix_spawnattr_getflags
#define __CRT_HAVE_posix_spawnattr_getpgroup
#define __CRT_HAVE_posix_spawnattr_getschedparam
#define __CRT_HAVE_posix_spawnattr_getschedpolicy
#define __CRT_HAVE_posix_spawnattr_getsigdefault
#define __CRT_HAVE_posix_spawnattr_getsigmask
#define __CRT_HAVE_posix_spawnattr_init
#define __CRT_HAVE_posix_spawnattr_setflags
#define __CRT_HAVE_posix_spawnattr_setpgroup
#define __CRT_HAVE_posix_spawnattr_setschedparam
#define __CRT_HAVE_posix_spawnattr_setschedpolicy
#define __CRT_HAVE_posix_spawnattr_setsigdefault
#define __CRT_HAVE_posix_spawnattr_setsigmask
#define __CRT_HAVE_posix_spawnp
#define __CRT_HAVE_putwc
#define __CRT_HAVE_putwc_unlocked
#define __CRT_HAVE_putwchar
#define __CRT_HAVE_putwchar_unlocked
#define __CRT_HAVE_rcmd_af
#define __CRT_HAVE_rexec_af
#define __CRT_HAVE_rresvport_af
#define __CRT_HAVE_ruserok_af
#define __CRT_HAVE_shm_open
#define __CRT_HAVE_shm_unlink
#define __CRT_HAVE_sockatmark
#define __CRT_HAVE_sprofil
#define __CRT_HAVE_svc_getreq_common
#define __CRT_HAVE_svc_getreq_poll
#define __CRT_HAVE_svc_max_pollfd
#define __CRT_HAVE_svc_pollfd
#define __CRT_HAVE_swprintf
#define __CRT_HAVE_swscanf
#define __CRT_HAVE_timer_create
#define __CRT_HAVE_timer_delete
#define __CRT_HAVE_timer_getoverrun
#define __CRT_HAVE_timer_gettime
#define __CRT_HAVE_timer_settime
#define __CRT_HAVE_ungetwc
#define __CRT_HAVE_vfwprintf
#define __CRT_HAVE_vfwscanf
#define __CRT_HAVE_vswprintf
#define __CRT_HAVE_vswscanf
#define __CRT_HAVE_vwprintf
#define __CRT_HAVE_vwscanf
#define __CRT_HAVE_wcschrnul
#define __CRT_HAVE_wcsftime
#define __CRT_HAVE_wmempcpy
#define __CRT_HAVE_wprintf
#define __CRT_HAVE_wscanf
#endif /* __GLIBC_VERSION__ >= 20205 */
#if __GLIBC_VERSION__ >= 20302
#define __CRT_HAVE___ctype_b_loc
#define __CRT_HAVE___ctype_tolower_loc
#define __CRT_HAVE___ctype_toupper_loc
#define __CRT_HAVE___gconv_get_alias_db
#define __CRT_HAVE___gconv_get_cache
#define __CRT_HAVE___gconv_get_modules_db
#define __CRT_HAVE___isctype
#define __CRT_HAVE___nss_disable_nscd
#define __CRT_HAVE___nss_lookup_function
#define __CRT_HAVE___register_atfork
#define __CRT_HAVE___resp
#define __CRT_HAVE___strftime_l
#define __CRT_HAVE___tls_get_addr
#define __CRT_HAVE___uselocale
#define __CRT_HAVE___wcsftime_l
#define __CRT_HAVE__dl_allocate_tls
#define __CRT_HAVE__dl_allocate_tls_init
#define __CRT_HAVE__dl_deallocate_tls
#define __CRT_HAVE__dl_get_tls_static_info
#define __CRT_HAVE__dl_rtld_di_serinfo
#define __CRT_HAVE__rtld_global
#define __CRT_HAVE_dladdr1
#define __CRT_HAVE_dlinfo
#define __CRT_HAVE_duplocale
#define __CRT_HAVE_epoll_create
#define __CRT_HAVE_epoll_ctl
#define __CRT_HAVE_epoll_wait
#define __CRT_HAVE_fgetxattr
#define __CRT_HAVE_flistxattr
#define __CRT_HAVE_freeifaddrs
#define __CRT_HAVE_freelocale
#define __CRT_HAVE_fremovexattr
#define __CRT_HAVE_fsetxattr
#define __CRT_HAVE_futimes
#define __CRT_HAVE_getifaddrs
#define __CRT_HAVE_getxattr
#define __CRT_HAVE_inet6_option_alloc
#define __CRT_HAVE_inet6_option_append
#define __CRT_HAVE_inet6_option_find
#define __CRT_HAVE_inet6_option_init
#define __CRT_HAVE_inet6_option_next
#define __CRT_HAVE_inet6_option_space
#define __CRT_HAVE_isalnum_l
#define __CRT_HAVE_isalpha_l
#define __CRT_HAVE_isblank_l
#define __CRT_HAVE_iscntrl_l
#define __CRT_HAVE_isctype
#define __CRT_HAVE_isdigit_l
#define __CRT_HAVE_isgraph_l
#define __CRT_HAVE_islower_l
#define __CRT_HAVE_isprint_l
#define __CRT_HAVE_ispunct_l
#define __CRT_HAVE_isspace_l
#define __CRT_HAVE_isupper_l
#define __CRT_HAVE_iswalnum_l
#define __CRT_HAVE_iswalpha_l
#define __CRT_HAVE_iswblank_l
#define __CRT_HAVE_iswcntrl_l
#define __CRT_HAVE_iswctype_l
#define __CRT_HAVE_iswdigit_l
#define __CRT_HAVE_iswgraph_l
#define __CRT_HAVE_iswlower_l
#define __CRT_HAVE_iswprint_l
#define __CRT_HAVE_iswpunct_l
#define __CRT_HAVE_iswspace_l
#define __CRT_HAVE_iswupper_l
#define __CRT_HAVE_iswxdigit_l
#define __CRT_HAVE_isxdigit_l
#define __CRT_HAVE_lchmod
#define __CRT_HAVE_lgetxattr
#define __CRT_HAVE_listxattr
#define __CRT_HAVE_llistxattr
#define __CRT_HAVE_lremovexattr
#define __CRT_HAVE_lsetxattr
#define __CRT_HAVE_lutimes
#define __CRT_HAVE_newlocale
#define __CRT_HAVE_nl_langinfo_l
#define __CRT_HAVE_readahead
#define __CRT_HAVE_remap_file_pages
#define __CRT_HAVE_removexattr
#define __CRT_HAVE_sched_getaffinity
#define __CRT_HAVE_sched_setaffinity
#define __CRT_HAVE_semtimedop
#define __CRT_HAVE_sendfile64
#define __CRT_HAVE_setxattr
#define __CRT_HAVE_strcasecmp_l
#define __CRT_HAVE_strcoll_l
#define __CRT_HAVE_strfmon_l
#define __CRT_HAVE_strftime_l
#define __CRT_HAVE_strncasecmp_l
#define __CRT_HAVE_strptime_l
#define __CRT_HAVE_strtod_l
#define __CRT_HAVE_strtof_l
#define __CRT_HAVE_strtol_l
#define __CRT_HAVE_strtold_l
#define __CRT_HAVE_strtoll_l
#define __CRT_HAVE_strtoul_l
#define __CRT_HAVE_strtoull_l
#define __CRT_HAVE_strxfrm_l
#define __CRT_HAVE_tolower_l
#define __CRT_HAVE_toupper_l
#define __CRT_HAVE_towctrans_l
#define __CRT_HAVE_towlower_l
#define __CRT_HAVE_towupper_l
#define __CRT_HAVE_uselocale
#define __CRT_HAVE_wcscasecmp_l
#define __CRT_HAVE_wcscoll_l
#define __CRT_HAVE_wcsftime_l
#define __CRT_HAVE_wcsncasecmp_l
#define __CRT_HAVE_wcstod_l
#define __CRT_HAVE_wcstof_l
#define __CRT_HAVE_wcstol_l
#define __CRT_HAVE_wcstold_l
#define __CRT_HAVE_wcstoll_l
#define __CRT_HAVE_wcstoul_l
#define __CRT_HAVE_wcstoull_l
#define __CRT_HAVE_wcsxfrm_l
#define __CRT_HAVE_wctrans_l
#define __CRT_HAVE_wctype_l
#endif /* __GLIBC_VERSION__ >= 20302 */
#if __GLIBC_VERSION__ >= 20305
#define __CRT_HAVE___chk_fail
#define __CRT_HAVE___fprintf_chk
#define __CRT_HAVE___gets_chk
#define __CRT_HAVE___memcpy_chk
#define __CRT_HAVE___memmove_chk
#define __CRT_HAVE___mempcpy_chk
#define __CRT_HAVE___memset_chk
#define __CRT_HAVE___printf_chk
#define __CRT_HAVE___snprintf_chk
#define __CRT_HAVE___sprintf_chk
#define __CRT_HAVE___stpcpy_chk
#define __CRT_HAVE___strcat_chk
#define __CRT_HAVE___strcpy_chk
#define __CRT_HAVE___strncat_chk
#define __CRT_HAVE___strncpy_chk
#define __CRT_HAVE___vfprintf_chk
#define __CRT_HAVE___vprintf_chk
#define __CRT_HAVE___vsnprintf_chk
#define __CRT_HAVE___vsprintf_chk
#define __CRT_HAVE___xpg_strerror_r
#define __CRT_HAVE__rtld_global_ro
#define __CRT_HAVE_dlmopen
#define __CRT_HAVE_getipv4sourcefilter
#define __CRT_HAVE_getsourcefilter
#define __CRT_HAVE_gnu_dev_major
#define __CRT_HAVE_gnu_dev_makedev
#define __CRT_HAVE_gnu_dev_minor
#define __CRT_HAVE_mq_close
#define __CRT_HAVE_mq_getattr
#define __CRT_HAVE_mq_notify
#define __CRT_HAVE_mq_open
#define __CRT_HAVE_mq_receive
#define __CRT_HAVE_mq_send
#define __CRT_HAVE_mq_setattr
#define __CRT_HAVE_mq_timedreceive
#define __CRT_HAVE_mq_timedsend
#define __CRT_HAVE_mq_unlink
#define __CRT_HAVE_setipv4sourcefilter
#define __CRT_HAVE_setsourcefilter
#define __CRT_HAVE_xdr_quad_t
#define __CRT_HAVE_xdr_u_quad_t
#endif /* __GLIBC_VERSION__ >= 20305 */
#if __GLIBC_VERSION__ >= 20400
#define __CRT_HAVE___confstr_chk
#define __CRT_HAVE___fgets_chk
#define __CRT_HAVE___fgets_unlocked_chk
#define __CRT_HAVE___fgetws_chk
#define __CRT_HAVE___fgetws_unlocked_chk
#define __CRT_HAVE___fwprintf_chk
#define __CRT_HAVE___fxstatat
#define __CRT_HAVE___fxstatat64
#define __CRT_HAVE___getcwd_chk
#define __CRT_HAVE___getdomainname_chk
#define __CRT_HAVE___getgroups_chk
#define __CRT_HAVE___gethostname_chk
#define __CRT_HAVE___getlogin_r_chk
#define __CRT_HAVE___getwd_chk
#define __CRT_HAVE___mbsnrtowcs_chk
#define __CRT_HAVE___mbsrtowcs_chk
#define __CRT_HAVE___mbstowcs_chk
#define __CRT_HAVE___pread64_chk
#define __CRT_HAVE___pread_chk
#define __CRT_HAVE___ptsname_r_chk
#define __CRT_HAVE___read_chk
#define __CRT_HAVE___readlink_chk
#define __CRT_HAVE___realpath_chk
#define __CRT_HAVE___recv_chk
#define __CRT_HAVE___recvfrom_chk
#define __CRT_HAVE___res_iclose
#define __CRT_HAVE___stack_chk_fail
#define __CRT_HAVE___stpncpy_chk
#define __CRT_HAVE___swprintf_chk
#define __CRT_HAVE___syslog_chk
#define __CRT_HAVE___ttyname_r_chk
#define __CRT_HAVE___vfwprintf_chk
#define __CRT_HAVE___vswprintf_chk
#define __CRT_HAVE___vsyslog_chk
#define __CRT_HAVE___vwprintf_chk
#define __CRT_HAVE___wcpcpy_chk
#define __CRT_HAVE___wcpncpy_chk
#define __CRT_HAVE___wcrtomb_chk
#define __CRT_HAVE___wcscat_chk
#define __CRT_HAVE___wcscpy_chk
#define __CRT_HAVE___wcsncat_chk
#define __CRT_HAVE___wcsncpy_chk
#define __CRT_HAVE___wcsnrtombs_chk
#define __CRT_HAVE___wcsrtombs_chk
#define __CRT_HAVE___wcstombs_chk
#define __CRT_HAVE___wctomb_chk
#define __CRT_HAVE___wmemcpy_chk
#define __CRT_HAVE___wmemmove_chk
#define __CRT_HAVE___wmempcpy_chk
#define __CRT_HAVE___wmemset_chk
#define __CRT_HAVE___wprintf_chk
#define __CRT_HAVE___xmknodat
#define __CRT_HAVE_eaccess
#define __CRT_HAVE_faccessat
#define __CRT_HAVE_fchmodat
#define __CRT_HAVE_fchownat
#define __CRT_HAVE_fdopendir
#define __CRT_HAVE_futimesat
#define __CRT_HAVE_inotify_add_watch
#define __CRT_HAVE_inotify_init
#define __CRT_HAVE_inotify_rm_watch
#define __CRT_HAVE_linkat
#define __CRT_HAVE_mkdirat
#define __CRT_HAVE_mkfifoat
#define __CRT_HAVE_open_wmemstream
#define __CRT_HAVE_openat
#define __CRT_HAVE_openat64
#define __CRT_HAVE_ppoll
#define __CRT_HAVE_readlinkat
#define __CRT_HAVE_renameat
#define __CRT_HAVE_symlinkat
#define __CRT_HAVE_unlinkat
#define __CRT_HAVE_unshare
#endif /* __GLIBC_VERSION__ >= 20400 */
#if __GLIBC_VERSION__ >= 20500
#define __CRT_HAVE___readlinkat_chk
#define __CRT_HAVE_inet6_opt_append
#define __CRT_HAVE_inet6_opt_find
#define __CRT_HAVE_inet6_opt_finish
#define __CRT_HAVE_inet6_opt_get_val
#define __CRT_HAVE_inet6_opt_init
#define __CRT_HAVE_inet6_opt_next
#define __CRT_HAVE_inet6_opt_set_val
#define __CRT_HAVE_inet6_rth_add
#define __CRT_HAVE_inet6_rth_getaddr
#define __CRT_HAVE_inet6_rth_init
#define __CRT_HAVE_inet6_rth_reverse
#define __CRT_HAVE_inet6_rth_segments
#define __CRT_HAVE_inet6_rth_space
#define __CRT_HAVE_splice
#define __CRT_HAVE_tee
#define __CRT_HAVE_vmsplice
#endif /* __GLIBC_VERSION__ >= 20500 */
#if __GLIBC_VERSION__ >= 20601
#define __CRT_HAVE___sched_cpucount
#define __CRT_HAVE_epoll_pwait
#define __CRT_HAVE_futimens
#define __CRT_HAVE_sched_getcpu
#define __CRT_HAVE_strerror_l
#define __CRT_HAVE_sync_file_range
#define __CRT_HAVE_utimensat
#endif /* __GLIBC_VERSION__ >= 20601 */
#if __GLIBC_VERSION__ >= 20700
#define __CRT_HAVE___fortify_fail
#define __CRT_HAVE___fread_chk
#define __CRT_HAVE___fread_unlocked_chk
#define __CRT_HAVE___isoc99_fscanf
#define __CRT_HAVE___isoc99_fwscanf
#define __CRT_HAVE___isoc99_scanf
#define __CRT_HAVE___isoc99_sscanf
#define __CRT_HAVE___isoc99_swscanf
#define __CRT_HAVE___isoc99_vfscanf
#define __CRT_HAVE___isoc99_vfwscanf
#define __CRT_HAVE___isoc99_vscanf
#define __CRT_HAVE___isoc99_vsscanf
#define __CRT_HAVE___isoc99_vswscanf
#define __CRT_HAVE___isoc99_vwscanf
#define __CRT_HAVE___isoc99_wscanf
#define __CRT_HAVE___mq_open_2
#define __CRT_HAVE___open64_2
#define __CRT_HAVE___open_2
#define __CRT_HAVE___openat64_2
#define __CRT_HAVE___openat_2
#define __CRT_HAVE___sched_cpualloc
#define __CRT_HAVE___sched_cpufree
#define __CRT_HAVE_eventfd
#define __CRT_HAVE_eventfd_read
#define __CRT_HAVE_eventfd_write
#define __CRT_HAVE_mkostemp
#define __CRT_HAVE_mkostemp64
#define __CRT_HAVE_signalfd
#endif /* __GLIBC_VERSION__ >= 20700 */
#if __GLIBC_VERSION__ >= 20890
#define __CRT_HAVE___asprintf_chk
#define __CRT_HAVE___dprintf_chk
#define __CRT_HAVE___nss_group_lookup2
#define __CRT_HAVE___nss_hosts_lookup2
#define __CRT_HAVE___nss_next2
#define __CRT_HAVE___nss_passwd_lookup2
#define __CRT_HAVE___nss_services_lookup2
#define __CRT_HAVE___obstack_printf_chk
#define __CRT_HAVE___obstack_vprintf_chk
#define __CRT_HAVE___vasprintf_chk
#define __CRT_HAVE___vdprintf_chk
#define __CRT_HAVE_qsort_r
#define __CRT_HAVE_timerfd_create
#define __CRT_HAVE_timerfd_gettime
#define __CRT_HAVE_timerfd_settime
#endif /* __GLIBC_VERSION__ >= 20890 */
#if __GLIBC_VERSION__ >= 20900
#define __CRT_HAVE___libc_clntudp_bufcreate
#define __CRT_HAVE_dup3
#define __CRT_HAVE_epoll_create1
#define __CRT_HAVE_inotify_init1
#define __CRT_HAVE_pipe2
#endif /* __GLIBC_VERSION__ >= 20900 */
#if __GLIBC_VERSION__ >= 21001
#define __CRT_HAVE___cxa_at_quick_exit
#define __CRT_HAVE___posix_getopt
#define __CRT_HAVE__nss_files_parse_sgent
#define __CRT_HAVE_accept4
#define __CRT_HAVE_endsgent
#define __CRT_HAVE_fallocate
#define __CRT_HAVE_fgetsgent
#define __CRT_HAVE_fgetsgent_r
#define __CRT_HAVE_getsgent
#define __CRT_HAVE_getsgent_r
#define __CRT_HAVE_getsgnam
#define __CRT_HAVE_getsgnam_r
#define __CRT_HAVE_malloc_info
#define __CRT_HAVE_preadv
#define __CRT_HAVE_preadv64
#define __CRT_HAVE_psiginfo
#define __CRT_HAVE_putsgent
#define __CRT_HAVE_pwritev
#define __CRT_HAVE_pwritev64
#define __CRT_HAVE_quick_exit
#define __CRT_HAVE_register_printf_modifier
#define __CRT_HAVE_register_printf_specifier
#define __CRT_HAVE_register_printf_type
#define __CRT_HAVE_setsgent
#define __CRT_HAVE_sgetsgent
#define __CRT_HAVE_sgetsgent_r
#endif /* __GLIBC_VERSION__ >= 21001 */
#if __GLIBC_VERSION__ >= 21100
#define __CRT_HAVE___abort_msg
#define __CRT_HAVE___longjmp_chk
#define __CRT_HAVE_execvpe
#define __CRT_HAVE_mkostemps
#define __CRT_HAVE_mkostemps64
#define __CRT_HAVE_mkstemps
#define __CRT_HAVE_mkstemps64
#endif /* __GLIBC_VERSION__ >= 21100 */
#if __GLIBC_VERSION__ >= 21200
#define __CRT_HAVE_ntp_gettimex
#define __CRT_HAVE_recvmmsg
#endif /* __GLIBC_VERSION__ >= 21200 */
#if __GLIBC_VERSION__ >= 21290
#define __CRT_HAVE___fentry__
#define __CRT_HAVE___libc_rpc_getport
#define __CRT_HAVE_fanotify_init
#define __CRT_HAVE_fanotify_mark
#define __CRT_HAVE_prlimit
#define __CRT_HAVE_prlimit64
#endif /* __GLIBC_VERSION__ >= 21290 */
#if __GLIBC_VERSION__ >= 21390
#define __CRT_HAVE___libc_alloca_cutoff
#define __CRT_HAVE_clock_adjtime
#define __CRT_HAVE_name_to_handle_at
#define __CRT_HAVE_open_by_handle_at
#define __CRT_HAVE_syncfs
#endif /* __GLIBC_VERSION__ >= 21390 */
#if __GLIBC_VERSION__ >= 21500
#define __CRT_HAVE__ITM_deregisterTMCloneTable
#define __CRT_HAVE__ITM_registerTMCloneTable
#define __CRT_HAVE___acos_finite
#define __CRT_HAVE___acosf_finite
#define __CRT_HAVE___acosh_finite
#define __CRT_HAVE___acoshf_finite
#define __CRT_HAVE___acoshl_finite
#define __CRT_HAVE___acosl_finite
#define __CRT_HAVE___asin_finite
#define __CRT_HAVE___asinf_finite
#define __CRT_HAVE___asinl_finite
#define __CRT_HAVE___atan2_finite
#define __CRT_HAVE___atan2f_finite
#define __CRT_HAVE___atan2l_finite
#define __CRT_HAVE___atanh_finite
#define __CRT_HAVE___atanhf_finite
#define __CRT_HAVE___atanhl_finite
#define __CRT_HAVE___cosh_finite
#define __CRT_HAVE___coshf_finite
#define __CRT_HAVE___coshl_finite
#define __CRT_HAVE___ctype_init
#define __CRT_HAVE___exp10_finite
#define __CRT_HAVE___exp10f_finite
#define __CRT_HAVE___exp10l_finite
#define __CRT_HAVE___exp2_finite
#define __CRT_HAVE___exp2f_finite
#define __CRT_HAVE___exp2l_finite
#define __CRT_HAVE___exp_finite
#define __CRT_HAVE___expf_finite
#define __CRT_HAVE___expl_finite
#define __CRT_HAVE___fdelt_chk
#define __CRT_HAVE___fdelt_warn
#define __CRT_HAVE___fmod_finite
#define __CRT_HAVE___fmodf_finite
#define __CRT_HAVE___fmodl_finite
#define __CRT_HAVE___gamma_r_finite
#define __CRT_HAVE___gammaf_r_finite
#define __CRT_HAVE___gammal_r_finite
#define __CRT_HAVE___hypot_finite
#define __CRT_HAVE___hypotf_finite
#define __CRT_HAVE___hypotl_finite
#define __CRT_HAVE___j0_finite
#define __CRT_HAVE___j0f_finite
#define __CRT_HAVE___j0l_finite
#define __CRT_HAVE___j1_finite
#define __CRT_HAVE___j1f_finite
#define __CRT_HAVE___j1l_finite
#define __CRT_HAVE___jn_finite
#define __CRT_HAVE___jnf_finite
#define __CRT_HAVE___jnl_finite
#define __CRT_HAVE___lgamma_r_finite
#define __CRT_HAVE___lgammaf_r_finite
#define __CRT_HAVE___lgammal_r_finite
#define __CRT_HAVE___log10_finite
#define __CRT_HAVE___log10f_finite
#define __CRT_HAVE___log10l_finite
#define __CRT_HAVE___log2_finite
#define __CRT_HAVE___log2f_finite
#define __CRT_HAVE___log2l_finite
#define __CRT_HAVE___log_finite
#define __CRT_HAVE___logf_finite
#define __CRT_HAVE___logl_finite
#define __CRT_HAVE___pow_finite
#define __CRT_HAVE___powf_finite
#define __CRT_HAVE___powl_finite
#define __CRT_HAVE___pthread_get_minstack
#define __CRT_HAVE___remainder_finite
#define __CRT_HAVE___remainderf_finite
#define __CRT_HAVE___remainderl_finite
#define __CRT_HAVE___scalb_finite
#define __CRT_HAVE___scalbf_finite
#define __CRT_HAVE___scalbl_finite
#define __CRT_HAVE___sinh_finite
#define __CRT_HAVE___sinhf_finite
#define __CRT_HAVE___sinhl_finite
#define __CRT_HAVE___sqrt_finite
#define __CRT_HAVE___sqrtf_finite
#define __CRT_HAVE___sqrtl_finite
#define __CRT_HAVE___y0_finite
#define __CRT_HAVE___y0f_finite
#define __CRT_HAVE___y0l_finite
#define __CRT_HAVE___y1_finite
#define __CRT_HAVE___y1f_finite
#define __CRT_HAVE___y1l_finite
#define __CRT_HAVE___yn_finite
#define __CRT_HAVE___ynf_finite
#define __CRT_HAVE___ynl_finite
#define __CRT_HAVE_process_vm_readv
#define __CRT_HAVE_process_vm_writev
#define __CRT_HAVE_scandirat
#define __CRT_HAVE_scandirat64
#define __CRT_HAVE_sendmmsg
#define __CRT_HAVE_setns
#endif /* __GLIBC_VERSION__ >= 21500 */
#if __GLIBC_VERSION__ >= 21600
#define __CRT_HAVE___getauxval
#define __CRT_HAVE___poll_chk
#define __CRT_HAVE___ppoll_chk
#define __CRT_HAVE_aligned_alloc
#define __CRT_HAVE_c16rtomb
#define __CRT_HAVE_c32rtomb
#define __CRT_HAVE_getauxval
#define __CRT_HAVE_mbrtoc16
#define __CRT_HAVE_mbrtoc32
#define __CRT_HAVE_timespec_get
#endif /* __GLIBC_VERSION__ >= 21600 */
#if __GLIBC_VERSION__ >= 21700
#define __CRT_HAVE___clock_gettime
#define __CRT_HAVE___libc_ifunc_impl_list
#define __CRT_HAVE___libc_secure_getenv
#define __CRT_HAVE___madvise
#define __CRT_HAVE___mktemp
#define __CRT_HAVE___sendmmsg
#define __CRT_HAVE_secure_getenv
#endif /* __GLIBC_VERSION__ >= 21700 */
#if __GLIBC_VERSION__ >= 21800
#define __CRT_HAVE___call_tls_dtors
#define __CRT_HAVE___cxa_thread_atexit_impl
#define __CRT_HAVE___issignaling
#define __CRT_HAVE___issignalingf
#define __CRT_HAVE___issignalingl
#define __CRT_HAVE__dl_find_dso_for_object
#endif /* __GLIBC_VERSION__ >= 21800 */
#if __GLIBC_VERSION__ >= 22100
#define __CRT_HAVE___gconv_transliterate
#endif /* __GLIBC_VERSION__ >= 22100 */
#if __GLIBC_VERSION__ >= 22300
#define __CRT_HAVE___signgam
#define __CRT_HAVE_fts64_children
#define __CRT_HAVE_fts64_close
#define __CRT_HAVE_fts64_open
#define __CRT_HAVE_fts64_read
#define __CRT_HAVE_fts64_set
#endif /* __GLIBC_VERSION__ >= 22300 */
#if __GLIBC_VERSION__ >= 22400
#define __CRT_HAVE_nextdown
#define __CRT_HAVE_nextdownf
#define __CRT_HAVE_nextdownl
#define __CRT_HAVE_nextup
#define __CRT_HAVE_nextupf
#define __CRT_HAVE_nextupl
#endif /* __GLIBC_VERSION__ >= 22400 */
#if __GLIBC_VERSION__ >= 22600
#define __CRT_HAVE__IO_enable_locks
#define __CRT_HAVE___acosf128_finite
#define __CRT_HAVE___acoshf128_finite
#define __CRT_HAVE___asinf128_finite
#define __CRT_HAVE___atan2f128_finite
#define __CRT_HAVE___atanhf128_finite
#define __CRT_HAVE___coshf128_finite
#define __CRT_HAVE___exp10f128_finite
#define __CRT_HAVE___exp2f128_finite
#define __CRT_HAVE___expf128_finite
#define __CRT_HAVE___explicit_bzero_chk
#define __CRT_HAVE___finitef128
#define __CRT_HAVE___fmodf128_finite
#define __CRT_HAVE___fpclassifyf128
#define __CRT_HAVE___gammaf128_r_finite
#define __CRT_HAVE___hypotf128_finite
#define __CRT_HAVE___iscanonicall
#define __CRT_HAVE___iseqsig
#define __CRT_HAVE___iseqsigf
#define __CRT_HAVE___iseqsigf128
#define __CRT_HAVE___iseqsigl
#define __CRT_HAVE___isinff128
#define __CRT_HAVE___isnanf128
#define __CRT_HAVE___issignalingf128
#define __CRT_HAVE___j0f128_finite
#define __CRT_HAVE___j1f128_finite
#define __CRT_HAVE___jnf128_finite
#define __CRT_HAVE___lgammaf128_r_finite
#define __CRT_HAVE___libc_reallocarray
#define __CRT_HAVE___log10f128_finite
#define __CRT_HAVE___log2f128_finite
#define __CRT_HAVE___logf128_finite
#define __CRT_HAVE___powf128_finite
#define __CRT_HAVE___remainderf128_finite
#define __CRT_HAVE___signbitf128
#define __CRT_HAVE___sinhf128_finite
#define __CRT_HAVE___sqrtf128_finite
#define __CRT_HAVE___strtof128_internal
#define __CRT_HAVE___strtof128_nan
#define __CRT_HAVE___tunable_get_val
#define __CRT_HAVE___wcstof128_internal
#define __CRT_HAVE___y0f128_finite
#define __CRT_HAVE___y1f128_finite
#define __CRT_HAVE___ynf128_finite
#define __CRT_HAVE_acosf128
#define __CRT_HAVE_acoshf128
#define __CRT_HAVE_asinf128
#define __CRT_HAVE_asinhf128
#define __CRT_HAVE_atan2f128
#define __CRT_HAVE_atanf128
#define __CRT_HAVE_atanhf128
#define __CRT_HAVE_cabsf128
#define __CRT_HAVE_cacosf128
#define __CRT_HAVE_cacoshf128
#define __CRT_HAVE_canonicalize
#define __CRT_HAVE_canonicalizef
#define __CRT_HAVE_canonicalizef128
#define __CRT_HAVE_canonicalizel
#define __CRT_HAVE_cargf128
#define __CRT_HAVE_casinf128
#define __CRT_HAVE_casinhf128
#define __CRT_HAVE_catanf128
#define __CRT_HAVE_catanhf128
#define __CRT_HAVE_cbrtf128
#define __CRT_HAVE_ccosf128
#define __CRT_HAVE_ccoshf128
#define __CRT_HAVE_ceilf128
#define __CRT_HAVE_cexpf128
#define __CRT_HAVE_cimagf128
#define __CRT_HAVE_clog10f128
#define __CRT_HAVE_clogf128
#define __CRT_HAVE_conjf128
#define __CRT_HAVE_copysignf128
#define __CRT_HAVE_cosf128
#define __CRT_HAVE_coshf128
#define __CRT_HAVE_cpowf128
#define __CRT_HAVE_cprojf128
#define __CRT_HAVE_crealf128
#define __CRT_HAVE_csinf128
#define __CRT_HAVE_csinhf128
#define __CRT_HAVE_csqrtf128
#define __CRT_HAVE_ctanf128
#define __CRT_HAVE_ctanhf128
#define __CRT_HAVE_erfcf128
#define __CRT_HAVE_erff128
#define __CRT_HAVE_exp10f128
#define __CRT_HAVE_exp2f128
#define __CRT_HAVE_expf128
#define __CRT_HAVE_explicit_bzero
#define __CRT_HAVE_expm1f128
#define __CRT_HAVE_fabsf128
#define __CRT_HAVE_fdimf128
#define __CRT_HAVE_fegetmode
#define __CRT_HAVE_fesetexcept
#define __CRT_HAVE_fesetmode
#define __CRT_HAVE_fetestexceptflag
#define __CRT_HAVE_floorf128
#define __CRT_HAVE_fmaf128
#define __CRT_HAVE_fmaxf128
#define __CRT_HAVE_fmaxmag
#define __CRT_HAVE_fmaxmagf
#define __CRT_HAVE_fmaxmagf128
#define __CRT_HAVE_fmaxmagl
#define __CRT_HAVE_fminf128
#define __CRT_HAVE_fminmag
#define __CRT_HAVE_fminmagf
#define __CRT_HAVE_fminmagf128
#define __CRT_HAVE_fminmagl
#define __CRT_HAVE_fmodf128
#define __CRT_HAVE_frexpf128
#define __CRT_HAVE_fromfp
#define __CRT_HAVE_fromfpf
#define __CRT_HAVE_fromfpf128
#define __CRT_HAVE_fromfpl
#define __CRT_HAVE_fromfpx
#define __CRT_HAVE_fromfpxf
#define __CRT_HAVE_fromfpxf128
#define __CRT_HAVE_fromfpxl
#define __CRT_HAVE_getentropy
#define __CRT_HAVE_getpayload
#define __CRT_HAVE_getpayloadf
#define __CRT_HAVE_getpayloadf128
#define __CRT_HAVE_getpayloadl
#define __CRT_HAVE_getrandom
#define __CRT_HAVE_hypotf128
#define __CRT_HAVE_ilogbf128
#define __CRT_HAVE_j0f128
#define __CRT_HAVE_j1f128
#define __CRT_HAVE_jnf128
#define __CRT_HAVE_ldexpf128
#define __CRT_HAVE_lgammaf128
#define __CRT_HAVE_lgammaf128_r
#define __CRT_HAVE_llogb
#define __CRT_HAVE_llogbf
#define __CRT_HAVE_llogbf128
#define __CRT_HAVE_llogbl
#define __CRT_HAVE_llrintf128
#define __CRT_HAVE_llroundf128
#define __CRT_HAVE_log10f128
#define __CRT_HAVE_log1pf128
#define __CRT_HAVE_log2f128
#define __CRT_HAVE_logbf128
#define __CRT_HAVE_logf128
#define __CRT_HAVE_lrintf128
#define __CRT_HAVE_lroundf128
#define __CRT_HAVE_modff128
#define __CRT_HAVE_nanf128
#define __CRT_HAVE_nearbyintf128
#define __CRT_HAVE_nextafterf128
#define __CRT_HAVE_nextdownf128
#define __CRT_HAVE_nextupf128
#define __CRT_HAVE_powf128
#define __CRT_HAVE_preadv2
#define __CRT_HAVE_preadv64v2
#define __CRT_HAVE_pwritev2
#define __CRT_HAVE_pwritev64v2
#define __CRT_HAVE_reallocarray
#define __CRT_HAVE_remainderf128
#define __CRT_HAVE_remquof128
#define __CRT_HAVE_rintf128
#define __CRT_HAVE_roundeven
#define __CRT_HAVE_roundevenf
#define __CRT_HAVE_roundevenf128
#define __CRT_HAVE_roundevenl
#define __CRT_HAVE_roundf128
#define __CRT_HAVE_scalblnf128
#define __CRT_HAVE_scalbnf128
#define __CRT_HAVE_setpayload
#define __CRT_HAVE_setpayloadf
#define __CRT_HAVE_setpayloadf128
#define __CRT_HAVE_setpayloadl
#define __CRT_HAVE_setpayloadsig
#define __CRT_HAVE_setpayloadsigf
#define __CRT_HAVE_setpayloadsigf128
#define __CRT_HAVE_setpayloadsigl
#define __CRT_HAVE_sincosf128
#define __CRT_HAVE_sinf128
#define __CRT_HAVE_sinhf128
#define __CRT_HAVE_sqrtf128
#define __CRT_HAVE_strfromd
#define __CRT_HAVE_strfromf
#define __CRT_HAVE_strfromf128
#define __CRT_HAVE_strfroml
#define __CRT_HAVE_strtof128
#define __CRT_HAVE_strtof128_l
#define __CRT_HAVE_tanf128
#define __CRT_HAVE_tanhf128
#define __CRT_HAVE_tgammaf128
#define __CRT_HAVE_totalorder
#define __CRT_HAVE_totalorderf
#define __CRT_HAVE_totalorderf128
#define __CRT_HAVE_totalorderl
#define __CRT_HAVE_totalordermag
#define __CRT_HAVE_totalordermagf
#define __CRT_HAVE_totalordermagf128
#define __CRT_HAVE_totalordermagl
#define __CRT_HAVE_truncf128
#define __CRT_HAVE_ufromfp
#define __CRT_HAVE_ufromfpf
#define __CRT_HAVE_ufromfpf128
#define __CRT_HAVE_ufromfpl
#define __CRT_HAVE_ufromfpx
#define __CRT_HAVE_ufromfpxf
#define __CRT_HAVE_ufromfpxf128
#define __CRT_HAVE_ufromfpxl
#define __CRT_HAVE_wcstof128
#define __CRT_HAVE_wcstof128_l
#define __CRT_HAVE_y0f128
#define __CRT_HAVE_y1f128
#define __CRT_HAVE_ynf128
#endif /* __GLIBC_VERSION__ >= 22600 */
#if __GLIBC_VERSION__ >= 22700
#define __CRT_HAVE___close_nocancel
#define __CRT_HAVE___nss_hash
#define __CRT_HAVE___open_nocancel
#define __CRT_HAVE___read_nocancel
#define __CRT_HAVE__dl_catch_exception
#define __CRT_HAVE__dl_exception_create
#define __CRT_HAVE__dl_exception_create_format
#define __CRT_HAVE__dl_exception_free
#define __CRT_HAVE__dl_signal_exception
#define __CRT_HAVE_acosf32
#define __CRT_HAVE_acosf32x
#define __CRT_HAVE_acosf64
#define __CRT_HAVE_acosf64x
#define __CRT_HAVE_acoshf32
#define __CRT_HAVE_acoshf32x
#define __CRT_HAVE_acoshf64
#define __CRT_HAVE_acoshf64x
#define __CRT_HAVE_asinf32
#define __CRT_HAVE_asinf32x
#define __CRT_HAVE_asinf64
#define __CRT_HAVE_asinf64x
#define __CRT_HAVE_asinhf32
#define __CRT_HAVE_asinhf32x
#define __CRT_HAVE_asinhf64
#define __CRT_HAVE_asinhf64x
#define __CRT_HAVE_atan2f32
#define __CRT_HAVE_atan2f32x
#define __CRT_HAVE_atan2f64
#define __CRT_HAVE_atan2f64x
#define __CRT_HAVE_atanf32
#define __CRT_HAVE_atanf32x
#define __CRT_HAVE_atanf64
#define __CRT_HAVE_atanf64x
#define __CRT_HAVE_atanhf32
#define __CRT_HAVE_atanhf32x
#define __CRT_HAVE_atanhf64
#define __CRT_HAVE_atanhf64x
#define __CRT_HAVE_cabsf32
#define __CRT_HAVE_cabsf32x
#define __CRT_HAVE_cabsf64
#define __CRT_HAVE_cabsf64x
#define __CRT_HAVE_cacosf32
#define __CRT_HAVE_cacosf32x
#define __CRT_HAVE_cacosf64
#define __CRT_HAVE_cacosf64x
#define __CRT_HAVE_cacoshf32
#define __CRT_HAVE_cacoshf32x
#define __CRT_HAVE_cacoshf64
#define __CRT_HAVE_cacoshf64x
#define __CRT_HAVE_canonicalizef32
#define __CRT_HAVE_canonicalizef32x
#define __CRT_HAVE_canonicalizef64
#define __CRT_HAVE_canonicalizef64x
#define __CRT_HAVE_cargf32
#define __CRT_HAVE_cargf32x
#define __CRT_HAVE_cargf64
#define __CRT_HAVE_cargf64x
#define __CRT_HAVE_casinf32
#define __CRT_HAVE_casinf32x
#define __CRT_HAVE_casinf64
#define __CRT_HAVE_casinf64x
#define __CRT_HAVE_casinhf32
#define __CRT_HAVE_casinhf32x
#define __CRT_HAVE_casinhf64
#define __CRT_HAVE_casinhf64x
#define __CRT_HAVE_catanf32
#define __CRT_HAVE_catanf32x
#define __CRT_HAVE_catanf64
#define __CRT_HAVE_catanf64x
#define __CRT_HAVE_catanhf32
#define __CRT_HAVE_catanhf32x
#define __CRT_HAVE_catanhf64
#define __CRT_HAVE_catanhf64x
#define __CRT_HAVE_cbrtf32
#define __CRT_HAVE_cbrtf32x
#define __CRT_HAVE_cbrtf64
#define __CRT_HAVE_cbrtf64x
#define __CRT_HAVE_ccosf32
#define __CRT_HAVE_ccosf32x
#define __CRT_HAVE_ccosf64
#define __CRT_HAVE_ccosf64x
#define __CRT_HAVE_ccoshf32
#define __CRT_HAVE_ccoshf32x
#define __CRT_HAVE_ccoshf64
#define __CRT_HAVE_ccoshf64x
#define __CRT_HAVE_ceilf32
#define __CRT_HAVE_ceilf32x
#define __CRT_HAVE_ceilf64
#define __CRT_HAVE_ceilf64x
#define __CRT_HAVE_cexpf32
#define __CRT_HAVE_cexpf32x
#define __CRT_HAVE_cexpf64
#define __CRT_HAVE_cexpf64x
#define __CRT_HAVE_cimagf32
#define __CRT_HAVE_cimagf32x
#define __CRT_HAVE_cimagf64
#define __CRT_HAVE_cimagf64x
#define __CRT_HAVE_clog10f32
#define __CRT_HAVE_clog10f32x
#define __CRT_HAVE_clog10f64
#define __CRT_HAVE_clog10f64x
#define __CRT_HAVE_clogf32
#define __CRT_HAVE_clogf32x
#define __CRT_HAVE_clogf64
#define __CRT_HAVE_clogf64x
#define __CRT_HAVE_conjf32
#define __CRT_HAVE_conjf32x
#define __CRT_HAVE_conjf64
#define __CRT_HAVE_conjf64x
#define __CRT_HAVE_copy_file_range
#define __CRT_HAVE_copysignf32
#define __CRT_HAVE_copysignf32x
#define __CRT_HAVE_copysignf64
#define __CRT_HAVE_copysignf64x
#define __CRT_HAVE_cosf32
#define __CRT_HAVE_cosf32x
#define __CRT_HAVE_cosf64
#define __CRT_HAVE_cosf64x
#define __CRT_HAVE_coshf32
#define __CRT_HAVE_coshf32x
#define __CRT_HAVE_coshf64
#define __CRT_HAVE_coshf64x
#define __CRT_HAVE_cpowf32
#define __CRT_HAVE_cpowf32x
#define __CRT_HAVE_cpowf64
#define __CRT_HAVE_cpowf64x
#define __CRT_HAVE_cprojf32
#define __CRT_HAVE_cprojf32x
#define __CRT_HAVE_cprojf64
#define __CRT_HAVE_cprojf64x
#define __CRT_HAVE_crealf32
#define __CRT_HAVE_crealf32x
#define __CRT_HAVE_crealf64
#define __CRT_HAVE_crealf64x
#define __CRT_HAVE_csinf32
#define __CRT_HAVE_csinf32x
#define __CRT_HAVE_csinf64
#define __CRT_HAVE_csinf64x
#define __CRT_HAVE_csinhf32
#define __CRT_HAVE_csinhf32x
#define __CRT_HAVE_csinhf64
#define __CRT_HAVE_csinhf64x
#define __CRT_HAVE_csqrtf32
#define __CRT_HAVE_csqrtf32x
#define __CRT_HAVE_csqrtf64
#define __CRT_HAVE_csqrtf64x
#define __CRT_HAVE_ctanf32
#define __CRT_HAVE_ctanf32x
#define __CRT_HAVE_ctanf64
#define __CRT_HAVE_ctanf64x
#define __CRT_HAVE_ctanhf32
#define __CRT_HAVE_ctanhf32x
#define __CRT_HAVE_ctanhf64
#define __CRT_HAVE_ctanhf64x
#define __CRT_HAVE_erfcf32
#define __CRT_HAVE_erfcf32x
#define __CRT_HAVE_erfcf64
#define __CRT_HAVE_erfcf64x
#define __CRT_HAVE_erff32
#define __CRT_HAVE_erff32x
#define __CRT_HAVE_erff64
#define __CRT_HAVE_erff64x
#define __CRT_HAVE_exp10f32
#define __CRT_HAVE_exp10f32x
#define __CRT_HAVE_exp10f64
#define __CRT_HAVE_exp10f64x
#define __CRT_HAVE_exp2f32
#define __CRT_HAVE_exp2f32x
#define __CRT_HAVE_exp2f64
#define __CRT_HAVE_exp2f64x
#define __CRT_HAVE_expf32
#define __CRT_HAVE_expf32x
#define __CRT_HAVE_expf64
#define __CRT_HAVE_expf64x
#define __CRT_HAVE_expm1f32
#define __CRT_HAVE_expm1f32x
#define __CRT_HAVE_expm1f64
#define __CRT_HAVE_expm1f64x
#define __CRT_HAVE_fabsf32
#define __CRT_HAVE_fabsf32x
#define __CRT_HAVE_fabsf64
#define __CRT_HAVE_fabsf64x
#define __CRT_HAVE_fdimf32
#define __CRT_HAVE_fdimf32x
#define __CRT_HAVE_fdimf64
#define __CRT_HAVE_fdimf64x
#define __CRT_HAVE_floorf32
#define __CRT_HAVE_floorf32x
#define __CRT_HAVE_floorf64
#define __CRT_HAVE_floorf64x
#define __CRT_HAVE_fmaf32
#define __CRT_HAVE_fmaf32x
#define __CRT_HAVE_fmaf64
#define __CRT_HAVE_fmaf64x
#define __CRT_HAVE_fmaxf32
#define __CRT_HAVE_fmaxf32x
#define __CRT_HAVE_fmaxf64
#define __CRT_HAVE_fmaxf64x
#define __CRT_HAVE_fmaxmagf32
#define __CRT_HAVE_fmaxmagf32x
#define __CRT_HAVE_fmaxmagf64
#define __CRT_HAVE_fmaxmagf64x
#define __CRT_HAVE_fminf32
#define __CRT_HAVE_fminf32x
#define __CRT_HAVE_fminf64
#define __CRT_HAVE_fminf64x
#define __CRT_HAVE_fminmagf32
#define __CRT_HAVE_fminmagf32x
#define __CRT_HAVE_fminmagf64
#define __CRT_HAVE_fminmagf64x
#define __CRT_HAVE_fmodf32
#define __CRT_HAVE_fmodf32x
#define __CRT_HAVE_fmodf64
#define __CRT_HAVE_fmodf64x
#define __CRT_HAVE_frexpf32
#define __CRT_HAVE_frexpf32x
#define __CRT_HAVE_frexpf64
#define __CRT_HAVE_frexpf64x
#define __CRT_HAVE_fromfpf32
#define __CRT_HAVE_fromfpf32x
#define __CRT_HAVE_fromfpf64
#define __CRT_HAVE_fromfpf64x
#define __CRT_HAVE_fromfpxf32
#define __CRT_HAVE_fromfpxf32x
#define __CRT_HAVE_fromfpxf64
#define __CRT_HAVE_fromfpxf64x
#define __CRT_HAVE_getpayloadf32
#define __CRT_HAVE_getpayloadf32x
#define __CRT_HAVE_getpayloadf64
#define __CRT_HAVE_getpayloadf64x
#define __CRT_HAVE_hypotf32
#define __CRT_HAVE_hypotf32x
#define __CRT_HAVE_hypotf64
#define __CRT_HAVE_hypotf64x
#define __CRT_HAVE_ilogbf32
#define __CRT_HAVE_ilogbf32x
#define __CRT_HAVE_ilogbf64
#define __CRT_HAVE_ilogbf64x
#define __CRT_HAVE_j0f32
#define __CRT_HAVE_j0f32x
#define __CRT_HAVE_j0f64
#define __CRT_HAVE_j0f64x
#define __CRT_HAVE_j1f32
#define __CRT_HAVE_j1f32x
#define __CRT_HAVE_j1f64
#define __CRT_HAVE_j1f64x
#define __CRT_HAVE_jnf32
#define __CRT_HAVE_jnf32x
#define __CRT_HAVE_jnf64
#define __CRT_HAVE_jnf64x
#define __CRT_HAVE_ldexpf32
#define __CRT_HAVE_ldexpf32x
#define __CRT_HAVE_ldexpf64
#define __CRT_HAVE_ldexpf64x
#define __CRT_HAVE_lgammaf32
#define __CRT_HAVE_lgammaf32_r
#define __CRT_HAVE_lgammaf32x
#define __CRT_HAVE_lgammaf32x_r
#define __CRT_HAVE_lgammaf64
#define __CRT_HAVE_lgammaf64_r
#define __CRT_HAVE_lgammaf64x
#define __CRT_HAVE_lgammaf64x_r
#define __CRT_HAVE_llogbf32
#define __CRT_HAVE_llogbf32x
#define __CRT_HAVE_llogbf64
#define __CRT_HAVE_llogbf64x
#define __CRT_HAVE_llrintf32
#define __CRT_HAVE_llrintf32x
#define __CRT_HAVE_llrintf64
#define __CRT_HAVE_llrintf64x
#define __CRT_HAVE_llroundf32
#define __CRT_HAVE_llroundf32x
#define __CRT_HAVE_llroundf64
#define __CRT_HAVE_llroundf64x
#define __CRT_HAVE_log10f32
#define __CRT_HAVE_log10f32x
#define __CRT_HAVE_log10f64
#define __CRT_HAVE_log10f64x
#define __CRT_HAVE_log1pf32
#define __CRT_HAVE_log1pf32x
#define __CRT_HAVE_log1pf64
#define __CRT_HAVE_log1pf64x
#define __CRT_HAVE_log2f32
#define __CRT_HAVE_log2f32x
#define __CRT_HAVE_log2f64
#define __CRT_HAVE_log2f64x
#define __CRT_HAVE_logbf32
#define __CRT_HAVE_logbf32x
#define __CRT_HAVE_logbf64
#define __CRT_HAVE_logbf64x
#define __CRT_HAVE_logf32
#define __CRT_HAVE_logf32x
#define __CRT_HAVE_logf64
#define __CRT_HAVE_logf64x
#define __CRT_HAVE_lrintf32
#define __CRT_HAVE_lrintf32x
#define __CRT_HAVE_lrintf64
#define __CRT_HAVE_lrintf64x
#define __CRT_HAVE_lroundf32
#define __CRT_HAVE_lroundf32x
#define __CRT_HAVE_lroundf64
#define __CRT_HAVE_lroundf64x
#define __CRT_HAVE_memfd_create
#define __CRT_HAVE_mlock2
#define __CRT_HAVE_modff32
#define __CRT_HAVE_modff32x
#define __CRT_HAVE_modff64
#define __CRT_HAVE_modff64x
#define __CRT_HAVE_nanf32
#define __CRT_HAVE_nanf32x
#define __CRT_HAVE_nanf64
#define __CRT_HAVE_nanf64x
#define __CRT_HAVE_nearbyintf32
#define __CRT_HAVE_nearbyintf32x
#define __CRT_HAVE_nearbyintf64
#define __CRT_HAVE_nearbyintf64x
#define __CRT_HAVE_nextafterf32
#define __CRT_HAVE_nextafterf32x
#define __CRT_HAVE_nextafterf64
#define __CRT_HAVE_nextafterf64x
#define __CRT_HAVE_nextdownf32
#define __CRT_HAVE_nextdownf32x
#define __CRT_HAVE_nextdownf64
#define __CRT_HAVE_nextdownf64x
#define __CRT_HAVE_nextupf32
#define __CRT_HAVE_nextupf32x
#define __CRT_HAVE_nextupf64
#define __CRT_HAVE_nextupf64x
#define __CRT_HAVE_pkey_alloc
#define __CRT_HAVE_pkey_free
#define __CRT_HAVE_pkey_get
#define __CRT_HAVE_pkey_mprotect
#define __CRT_HAVE_pkey_set
#define __CRT_HAVE_powf32
#define __CRT_HAVE_powf32x
#define __CRT_HAVE_powf64
#define __CRT_HAVE_powf64x
#define __CRT_HAVE_remainderf32
#define __CRT_HAVE_remainderf32x
#define __CRT_HAVE_remainderf64
#define __CRT_HAVE_remainderf64x
#define __CRT_HAVE_remquof32
#define __CRT_HAVE_remquof32x
#define __CRT_HAVE_remquof64
#define __CRT_HAVE_remquof64x
#define __CRT_HAVE_rintf32
#define __CRT_HAVE_rintf32x
#define __CRT_HAVE_rintf64
#define __CRT_HAVE_rintf64x
#define __CRT_HAVE_roundevenf32
#define __CRT_HAVE_roundevenf32x
#define __CRT_HAVE_roundevenf64
#define __CRT_HAVE_roundevenf64x
#define __CRT_HAVE_roundf32
#define __CRT_HAVE_roundf32x
#define __CRT_HAVE_roundf64
#define __CRT_HAVE_roundf64x
#define __CRT_HAVE_scalblnf32
#define __CRT_HAVE_scalblnf32x
#define __CRT_HAVE_scalblnf64
#define __CRT_HAVE_scalblnf64x
#define __CRT_HAVE_scalbnf32
#define __CRT_HAVE_scalbnf32x
#define __CRT_HAVE_scalbnf64
#define __CRT_HAVE_scalbnf64x
#define __CRT_HAVE_setpayloadf32
#define __CRT_HAVE_setpayloadf32x
#define __CRT_HAVE_setpayloadf64
#define __CRT_HAVE_setpayloadf64x
#define __CRT_HAVE_setpayloadsigf32
#define __CRT_HAVE_setpayloadsigf32x
#define __CRT_HAVE_setpayloadsigf64
#define __CRT_HAVE_setpayloadsigf64x
#define __CRT_HAVE_sincosf32
#define __CRT_HAVE_sincosf32x
#define __CRT_HAVE_sincosf64
#define __CRT_HAVE_sincosf64x
#define __CRT_HAVE_sinf32
#define __CRT_HAVE_sinf32x
#define __CRT_HAVE_sinf64
#define __CRT_HAVE_sinf64x
#define __CRT_HAVE_sinhf32
#define __CRT_HAVE_sinhf32x
#define __CRT_HAVE_sinhf64
#define __CRT_HAVE_sinhf64x
#define __CRT_HAVE_sqrtf32
#define __CRT_HAVE_sqrtf32x
#define __CRT_HAVE_sqrtf64
#define __CRT_HAVE_sqrtf64x
#define __CRT_HAVE_strfromf32
#define __CRT_HAVE_strfromf32x
#define __CRT_HAVE_strfromf64
#define __CRT_HAVE_strfromf64x
#define __CRT_HAVE_strtof32
#define __CRT_HAVE_strtof32_l
#define __CRT_HAVE_strtof32x
#define __CRT_HAVE_strtof32x_l
#define __CRT_HAVE_strtof64
#define __CRT_HAVE_strtof64_l
#define __CRT_HAVE_strtof64x
#define __CRT_HAVE_strtof64x_l
#define __CRT_HAVE_tanf32
#define __CRT_HAVE_tanf32x
#define __CRT_HAVE_tanf64
#define __CRT_HAVE_tanf64x
#define __CRT_HAVE_tanhf32
#define __CRT_HAVE_tanhf32x
#define __CRT_HAVE_tanhf64
#define __CRT_HAVE_tanhf64x
#define __CRT_HAVE_tgammaf32
#define __CRT_HAVE_tgammaf32x
#define __CRT_HAVE_tgammaf64
#define __CRT_HAVE_tgammaf64x
#define __CRT_HAVE_totalorderf32
#define __CRT_HAVE_totalorderf32x
#define __CRT_HAVE_totalorderf64
#define __CRT_HAVE_totalorderf64x
#define __CRT_HAVE_totalordermagf32
#define __CRT_HAVE_totalordermagf32x
#define __CRT_HAVE_totalordermagf64
#define __CRT_HAVE_totalordermagf64x
#define __CRT_HAVE_truncf32
#define __CRT_HAVE_truncf32x
#define __CRT_HAVE_truncf64
#define __CRT_HAVE_truncf64x
#define __CRT_HAVE_ufromfpf32
#define __CRT_HAVE_ufromfpf32x
#define __CRT_HAVE_ufromfpf64
#define __CRT_HAVE_ufromfpf64x
#define __CRT_HAVE_ufromfpxf32
#define __CRT_HAVE_ufromfpxf32x
#define __CRT_HAVE_ufromfpxf64
#define __CRT_HAVE_ufromfpxf64x
#define __CRT_HAVE_wcstof32
#define __CRT_HAVE_wcstof32_l
#define __CRT_HAVE_wcstof32x
#define __CRT_HAVE_wcstof32x_l
#define __CRT_HAVE_wcstof64
#define __CRT_HAVE_wcstof64_l
#define __CRT_HAVE_wcstof64x
#define __CRT_HAVE_wcstof64x_l
#define __CRT_HAVE_y0f32
#define __CRT_HAVE_y0f32x
#define __CRT_HAVE_y0f64
#define __CRT_HAVE_y0f64x
#define __CRT_HAVE_y1f32
#define __CRT_HAVE_y1f32x
#define __CRT_HAVE_y1f64
#define __CRT_HAVE_y1f64x
#define __CRT_HAVE_ynf32
#define __CRT_HAVE_ynf32x
#define __CRT_HAVE_ynf64
#define __CRT_HAVE_ynf64x
#endif /* __GLIBC_VERSION__ >= 22700 */
#if __GLIBC_VERSION__ >= 22800
#define __CRT_HAVE___fseeko64
#define __CRT_HAVE___ftello64
#define __CRT_HAVE___idna_from_dns_encoding
#define __CRT_HAVE___idna_to_dns_encoding
#define __CRT_HAVE___libc_allocate_once_slow
#define __CRT_HAVE___libc_fcntl64
#define __CRT_HAVE___open64_nocancel
#define __CRT_HAVE___write_nocancel
#define __CRT_HAVE_daddl
#define __CRT_HAVE_ddivl
#define __CRT_HAVE_dmull
#define __CRT_HAVE_dsubl
#define __CRT_HAVE_f32addf128
#define __CRT_HAVE_f32addf32x
#define __CRT_HAVE_f32addf64
#define __CRT_HAVE_f32addf64x
#define __CRT_HAVE_f32divf128
#define __CRT_HAVE_f32divf32x
#define __CRT_HAVE_f32divf64
#define __CRT_HAVE_f32divf64x
#define __CRT_HAVE_f32mulf128
#define __CRT_HAVE_f32mulf32x
#define __CRT_HAVE_f32mulf64
#define __CRT_HAVE_f32mulf64x
#define __CRT_HAVE_f32subf128
#define __CRT_HAVE_f32subf32x
#define __CRT_HAVE_f32subf64
#define __CRT_HAVE_f32subf64x
#define __CRT_HAVE_f32xaddf128
#define __CRT_HAVE_f32xaddf64
#define __CRT_HAVE_f32xaddf64x
#define __CRT_HAVE_f32xdivf128
#define __CRT_HAVE_f32xdivf64
#define __CRT_HAVE_f32xdivf64x
#define __CRT_HAVE_f32xmulf128
#define __CRT_HAVE_f32xmulf64
#define __CRT_HAVE_f32xmulf64x
#define __CRT_HAVE_f32xsubf128
#define __CRT_HAVE_f32xsubf64
#define __CRT_HAVE_f32xsubf64x
#define __CRT_HAVE_f64addf128
#define __CRT_HAVE_f64addf64x
#define __CRT_HAVE_f64divf128
#define __CRT_HAVE_f64divf64x
#define __CRT_HAVE_f64mulf128
#define __CRT_HAVE_f64mulf64x
#define __CRT_HAVE_f64subf128
#define __CRT_HAVE_f64subf64x
#define __CRT_HAVE_f64xaddf128
#define __CRT_HAVE_f64xdivf128
#define __CRT_HAVE_f64xmulf128
#define __CRT_HAVE_f64xsubf128
#define __CRT_HAVE_fadd
#define __CRT_HAVE_faddl
#define __CRT_HAVE_fcntl64
#define __CRT_HAVE_fdiv
#define __CRT_HAVE_fdivl
#define __CRT_HAVE_fmul
#define __CRT_HAVE_fmull
#define __CRT_HAVE_fsub
#define __CRT_HAVE_fsubl
#define __CRT_HAVE_renameat2
#define __CRT_HAVE_statx
#define __CRT_HAVE_thrd_current
#define __CRT_HAVE_thrd_equal
#define __CRT_HAVE_thrd_sleep
#define __CRT_HAVE_thrd_yield
#endif /* __GLIBC_VERSION__ >= 22800 */
#if __GLIBC_VERSION__ >= 22900
#define __CRT_HAVE_getcpu
#define __CRT_HAVE_posix_spawn_file_actions_addchdir_np
#define __CRT_HAVE_posix_spawn_file_actions_addfchdir_np
#endif /* __GLIBC_VERSION__ >= 22900 */
#if __GLIBC_VERSION__ >= 23000
#define __CRT_HAVE___twalk_r
#define __CRT_HAVE_gettid
#define __CRT_HAVE_tgkill
#define __CRT_HAVE_twalk_r
#endif /* __GLIBC_VERSION__ >= 23000 */
#if __GLIBC_VERSION__ >= 23100
#define __CRT_HAVE___pread64_nocancel
#endif /* __GLIBC_VERSION__ >= 23100 */
#if __GLIBC_VERSION__ >= 23200
#define __CRT_HAVE___file_change_detection_for_fp
#define __CRT_HAVE___file_change_detection_for_path
#define __CRT_HAVE___file_change_detection_for_stat
#define __CRT_HAVE___file_is_unchanged
#define __CRT_HAVE___libc_early_init
#define __CRT_HAVE___libc_single_threaded
#define __CRT_HAVE___nss_files_fopen
#define __CRT_HAVE___nss_parse_line_result
#define __CRT_HAVE___nss_readline
#define __CRT_HAVE__dl_fatal_printf
#define __CRT_HAVE_pthread_attr_getsigmask_np
#define __CRT_HAVE_pthread_attr_setsigmask_np
#define __CRT_HAVE_sigabbrev_np
#define __CRT_HAVE_sigdescr_np
#define __CRT_HAVE_strerrordesc_np
#define __CRT_HAVE_strerrorname_np
#endif /* __GLIBC_VERSION__ >= 23200 */
#if __GLIBC_VERSION__ >= 23300
#define __CRT_HAVE___fstat64
#define __CRT_HAVE___x86_get_cpuid_feature_leaf
#define __CRT_HAVE__dl_x86_get_cpu_features
#define __CRT_HAVE_fstat
#define __CRT_HAVE_fstat64
#define __CRT_HAVE_fstatat
#define __CRT_HAVE_fstatat64
#define __CRT_HAVE_lstat
#define __CRT_HAVE_lstat64
#define __CRT_HAVE_mallinfo2
#define __CRT_HAVE_mknod
#define __CRT_HAVE_mknodat
#define __CRT_HAVE_stat
#define __CRT_HAVE_stat64
#endif /* __GLIBC_VERSION__ >= 23300 */
#if __GLIBC_VERSION__ >= 23400
#define __CRT_HAVE__Fork
#define __CRT_HAVE___dn_comp
#define __CRT_HAVE___dn_expand
#define __CRT_HAVE___dn_skipname
#define __CRT_HAVE___libc_dlerror_result
#define __CRT_HAVE___libc_dn_expand
#define __CRT_HAVE___libc_dn_skipname
#define __CRT_HAVE___libc_ns_makecanon
#define __CRT_HAVE___libc_ns_samename
#define __CRT_HAVE___libc_res_dnok
#define __CRT_HAVE___libc_res_hnok
#define __CRT_HAVE___libc_res_nameinquery
#define __CRT_HAVE___libc_res_queriesmatch
#define __CRT_HAVE___libc_unwind_link_get
#define __CRT_HAVE___libdl_version_placeholder
#define __CRT_HAVE___librt_version_placeholder
#define __CRT_HAVE___libutil_version_placeholder
#define __CRT_HAVE___lll_lock_wait_private
#define __CRT_HAVE___lll_lock_wake_private
#define __CRT_HAVE___nptl_change_stack_perm
#define __CRT_HAVE___nptl_create_event
#define __CRT_HAVE___nptl_death_event
#define __CRT_HAVE___nptl_initial_report_events
#define __CRT_HAVE___nptl_last_event
#define __CRT_HAVE___nptl_nthreads
#define __CRT_HAVE___nptl_rtld_global
#define __CRT_HAVE___nptl_threads_events
#define __CRT_HAVE___nptl_version
#define __CRT_HAVE___ns_name_compress
#define __CRT_HAVE___ns_name_ntop
#define __CRT_HAVE___ns_name_pack
#define __CRT_HAVE___ns_name_pton
#define __CRT_HAVE___ns_name_skip
#define __CRT_HAVE___ns_name_uncompress
#define __CRT_HAVE___ns_name_unpack
#define __CRT_HAVE___nss_database_get
#define __CRT_HAVE___nss_files_data_endent
#define __CRT_HAVE___nss_files_data_open
#define __CRT_HAVE___nss_files_data_put
#define __CRT_HAVE___nss_files_data_setent
#define __CRT_HAVE___pthread_keys
#define __CRT_HAVE___res_context_hostalias
#define __CRT_HAVE___res_context_mkquery
#define __CRT_HAVE___res_context_query
#define __CRT_HAVE___res_context_search
#define __CRT_HAVE___res_context_send
#define __CRT_HAVE___res_dnok
#define __CRT_HAVE___res_get_nsaddr
#define __CRT_HAVE___res_hnok
#define __CRT_HAVE___res_mailok
#define __CRT_HAVE___res_mkquery
#define __CRT_HAVE___res_nmkquery
#define __CRT_HAVE___res_nopt
#define __CRT_HAVE___res_nquery
#define __CRT_HAVE___res_nquerydomain
#define __CRT_HAVE___res_nsearch
#define __CRT_HAVE___res_nsend
#define __CRT_HAVE___res_ownok
#define __CRT_HAVE___res_query
#define __CRT_HAVE___res_querydomain
#define __CRT_HAVE___res_search
#define __CRT_HAVE___res_send
#define __CRT_HAVE___shm_get_name
#define __CRT_HAVE__nss_dns_getcanonname_r
#define __CRT_HAVE__nss_dns_gethostbyaddr2_r
#define __CRT_HAVE__nss_dns_gethostbyaddr_r
#define __CRT_HAVE__nss_dns_gethostbyname2_r
#define __CRT_HAVE__nss_dns_gethostbyname3_r
#define __CRT_HAVE__nss_dns_gethostbyname4_r
#define __CRT_HAVE__nss_dns_gethostbyname_r
#define __CRT_HAVE__nss_dns_getnetbyaddr_r
#define __CRT_HAVE__nss_dns_getnetbyname_r
#define __CRT_HAVE__nss_files_endaliasent
#define __CRT_HAVE__nss_files_endetherent
#define __CRT_HAVE__nss_files_endgrent
#define __CRT_HAVE__nss_files_endhostent
#define __CRT_HAVE__nss_files_endnetent
#define __CRT_HAVE__nss_files_endnetgrent
#define __CRT_HAVE__nss_files_endprotoent
#define __CRT_HAVE__nss_files_endpwent
#define __CRT_HAVE__nss_files_endrpcent
#define __CRT_HAVE__nss_files_endservent
#define __CRT_HAVE__nss_files_endsgent
#define __CRT_HAVE__nss_files_endspent
#define __CRT_HAVE__nss_files_getaliasbyname_r
#define __CRT_HAVE__nss_files_getaliasent_r
#define __CRT_HAVE__nss_files_getetherent_r
#define __CRT_HAVE__nss_files_getgrent_r
#define __CRT_HAVE__nss_files_getgrgid_r
#define __CRT_HAVE__nss_files_getgrnam_r
#define __CRT_HAVE__nss_files_gethostbyaddr_r
#define __CRT_HAVE__nss_files_gethostbyname2_r
#define __CRT_HAVE__nss_files_gethostbyname3_r
#define __CRT_HAVE__nss_files_gethostbyname4_r
#define __CRT_HAVE__nss_files_gethostbyname_r
#define __CRT_HAVE__nss_files_gethostent_r
#define __CRT_HAVE__nss_files_gethostton_r
#define __CRT_HAVE__nss_files_getnetbyaddr_r
#define __CRT_HAVE__nss_files_getnetbyname_r
#define __CRT_HAVE__nss_files_getnetent_r
#define __CRT_HAVE__nss_files_getnetgrent_r
#define __CRT_HAVE__nss_files_getntohost_r
#define __CRT_HAVE__nss_files_getprotobyname_r
#define __CRT_HAVE__nss_files_getprotobynumber_r
#define __CRT_HAVE__nss_files_getprotoent_r
#define __CRT_HAVE__nss_files_getpwent_r
#define __CRT_HAVE__nss_files_getpwnam_r
#define __CRT_HAVE__nss_files_getpwuid_r
#define __CRT_HAVE__nss_files_getrpcbyname_r
#define __CRT_HAVE__nss_files_getrpcbynumber_r
#define __CRT_HAVE__nss_files_getrpcent_r
#define __CRT_HAVE__nss_files_getservbyname_r
#define __CRT_HAVE__nss_files_getservbyport_r
#define __CRT_HAVE__nss_files_getservent_r
#define __CRT_HAVE__nss_files_getsgent_r
#define __CRT_HAVE__nss_files_getsgnam_r
#define __CRT_HAVE__nss_files_getspent_r
#define __CRT_HAVE__nss_files_getspnam_r
#define __CRT_HAVE__nss_files_init
#define __CRT_HAVE__nss_files_initgroups_dyn
#define __CRT_HAVE__nss_files_parse_etherent
#define __CRT_HAVE__nss_files_parse_netent
#define __CRT_HAVE__nss_files_parse_protoent
#define __CRT_HAVE__nss_files_parse_rpcent
#define __CRT_HAVE__nss_files_parse_servent
#define __CRT_HAVE__nss_files_setaliasent
#define __CRT_HAVE__nss_files_setetherent
#define __CRT_HAVE__nss_files_setgrent
#define __CRT_HAVE__nss_files_sethostent
#define __CRT_HAVE__nss_files_setnetent
#define __CRT_HAVE__nss_files_setnetgrent
#define __CRT_HAVE__nss_files_setprotoent
#define __CRT_HAVE__nss_files_setpwent
#define __CRT_HAVE__nss_files_setrpcent
#define __CRT_HAVE__nss_files_setservent
#define __CRT_HAVE__nss_files_setsgent
#define __CRT_HAVE__nss_files_setspent
#define __CRT_HAVE__nss_netgroup_parseline
#define __CRT_HAVE__thread_db___nptl_last_event
#define __CRT_HAVE__thread_db___nptl_nthreads
#define __CRT_HAVE__thread_db___nptl_rtld_global
#define __CRT_HAVE__thread_db___pthread_keys
#define __CRT_HAVE__thread_db_dtv_dtv
#define __CRT_HAVE__thread_db_dtv_slotinfo_gen
#define __CRT_HAVE__thread_db_dtv_slotinfo_list_len
#define __CRT_HAVE__thread_db_dtv_slotinfo_list_next
#define __CRT_HAVE__thread_db_dtv_slotinfo_list_slotinfo
#define __CRT_HAVE__thread_db_dtv_slotinfo_map
#define __CRT_HAVE__thread_db_dtv_t_counter
#define __CRT_HAVE__thread_db_dtv_t_pointer_val
#define __CRT_HAVE__thread_db_link_map_l_tls_modid
#define __CRT_HAVE__thread_db_link_map_l_tls_offset
#define __CRT_HAVE__thread_db_list_t_next
#define __CRT_HAVE__thread_db_list_t_prev
#define __CRT_HAVE__thread_db_pthread_cancelhandling
#define __CRT_HAVE__thread_db_pthread_dtvp
#define __CRT_HAVE__thread_db_pthread_eventbuf
#define __CRT_HAVE__thread_db_pthread_eventbuf_eventmask
#define __CRT_HAVE__thread_db_pthread_eventbuf_eventmask_event_bits
#define __CRT_HAVE__thread_db_pthread_key_data_data
#define __CRT_HAVE__thread_db_pthread_key_data_level2_data
#define __CRT_HAVE__thread_db_pthread_key_data_seq
#define __CRT_HAVE__thread_db_pthread_key_struct_destr
#define __CRT_HAVE__thread_db_pthread_key_struct_seq
#define __CRT_HAVE__thread_db_pthread_list
#define __CRT_HAVE__thread_db_pthread_nextevent
#define __CRT_HAVE__thread_db_pthread_report_events
#define __CRT_HAVE__thread_db_pthread_schedparam_sched_priority
#define __CRT_HAVE__thread_db_pthread_schedpolicy
#define __CRT_HAVE__thread_db_pthread_specific
#define __CRT_HAVE__thread_db_pthread_start_routine
#define __CRT_HAVE__thread_db_pthread_tid
#define __CRT_HAVE__thread_db_rtld_global__dl_stack_used
#define __CRT_HAVE__thread_db_rtld_global__dl_stack_user
#define __CRT_HAVE__thread_db_rtld_global__dl_tls_dtv_slotinfo_list
#define __CRT_HAVE__thread_db_sizeof_dtv_slotinfo
#define __CRT_HAVE__thread_db_sizeof_dtv_slotinfo_list
#define __CRT_HAVE__thread_db_sizeof_list_t
#define __CRT_HAVE__thread_db_sizeof_pthread
#define __CRT_HAVE__thread_db_sizeof_pthread_key_data
#define __CRT_HAVE__thread_db_sizeof_pthread_key_data_level2
#define __CRT_HAVE__thread_db_sizeof_pthread_key_struct
#define __CRT_HAVE__thread_db_sizeof_td_eventbuf_t
#define __CRT_HAVE__thread_db_sizeof_td_thr_events_t
#define __CRT_HAVE__thread_db_td_eventbuf_t_eventdata
#define __CRT_HAVE__thread_db_td_eventbuf_t_eventnum
#define __CRT_HAVE__thread_db_td_thr_events_t_event_bits
#define __CRT_HAVE_close_range
#define __CRT_HAVE_closefrom
#define __CRT_HAVE_dn_comp
#define __CRT_HAVE_dn_expand
#define __CRT_HAVE_dn_skipname
#define __CRT_HAVE_execveat
#define __CRT_HAVE_gai_cancel
#define __CRT_HAVE_gai_error
#define __CRT_HAVE_gai_suspend
#define __CRT_HAVE_getaddrinfo_a
#define __CRT_HAVE_ns_name_compress
#define __CRT_HAVE_ns_name_ntop
#define __CRT_HAVE_ns_name_pack
#define __CRT_HAVE_ns_name_pton
#define __CRT_HAVE_ns_name_skip
#define __CRT_HAVE_ns_name_uncompress
#define __CRT_HAVE_ns_name_unpack
#define __CRT_HAVE_posix_spawn_file_actions_addclosefrom_np
#define __CRT_HAVE_res_dnok
#define __CRT_HAVE_res_hnok
#define __CRT_HAVE_res_mailok
#define __CRT_HAVE_res_mkquery
#define __CRT_HAVE_res_nmkquery
#define __CRT_HAVE_res_nquery
#define __CRT_HAVE_res_nquerydomain
#define __CRT_HAVE_res_nsearch
#define __CRT_HAVE_res_nsend
#define __CRT_HAVE_res_ownok
#define __CRT_HAVE_res_query
#define __CRT_HAVE_res_querydomain
#define __CRT_HAVE_res_search
#define __CRT_HAVE_res_send
#define __CRT_HAVE_timespec_getres
#endif /* __GLIBC_VERSION__ >= 23400 */
#if __GLIBC_VERSION__ >= 23500
#define __CRT_HAVE___memcmpeq
#define __CRT_HAVE___rseq_flags
#define __CRT_HAVE___rseq_offset
#define __CRT_HAVE___rseq_size
#define __CRT_HAVE___rtld_version_placeholder
#define __CRT_HAVE__dl_audit_preinit
#define __CRT_HAVE__dl_audit_symbind_alt
#define __CRT_HAVE__dl_find_object
#define __CRT_HAVE_dfmal
#define __CRT_HAVE_dsqrtl
#define __CRT_HAVE_epoll_pwait2
#define __CRT_HAVE_f32fmaf128
#define __CRT_HAVE_f32fmaf32x
#define __CRT_HAVE_f32fmaf64
#define __CRT_HAVE_f32fmaf64x
#define __CRT_HAVE_f32sqrtf128
#define __CRT_HAVE_f32sqrtf32x
#define __CRT_HAVE_f32sqrtf64
#define __CRT_HAVE_f32sqrtf64x
#define __CRT_HAVE_f32xfmaf128
#define __CRT_HAVE_f32xfmaf64
#define __CRT_HAVE_f32xfmaf64x
#define __CRT_HAVE_f32xsqrtf128
#define __CRT_HAVE_f32xsqrtf64
#define __CRT_HAVE_f32xsqrtf64x
#define __CRT_HAVE_f64fmaf128
#define __CRT_HAVE_f64fmaf64x
#define __CRT_HAVE_f64sqrtf128
#define __CRT_HAVE_f64sqrtf64x
#define __CRT_HAVE_f64xfmaf128
#define __CRT_HAVE_f64xsqrtf128
#define __CRT_HAVE_ffma
#define __CRT_HAVE_ffmal
#define __CRT_HAVE_fmaximum
#define __CRT_HAVE_fmaximum_mag
#define __CRT_HAVE_fmaximum_mag_num
#define __CRT_HAVE_fmaximum_mag_numf
#define __CRT_HAVE_fmaximum_mag_numf128
#define __CRT_HAVE_fmaximum_mag_numf32
#define __CRT_HAVE_fmaximum_mag_numf32x
#define __CRT_HAVE_fmaximum_mag_numf64
#define __CRT_HAVE_fmaximum_mag_numf64x
#define __CRT_HAVE_fmaximum_mag_numl
#define __CRT_HAVE_fmaximum_magf
#define __CRT_HAVE_fmaximum_magf128
#define __CRT_HAVE_fmaximum_magf32
#define __CRT_HAVE_fmaximum_magf32x
#define __CRT_HAVE_fmaximum_magf64
#define __CRT_HAVE_fmaximum_magf64x
#define __CRT_HAVE_fmaximum_magl
#define __CRT_HAVE_fmaximum_num
#define __CRT_HAVE_fmaximum_numf
#define __CRT_HAVE_fmaximum_numf128
#define __CRT_HAVE_fmaximum_numf32
#define __CRT_HAVE_fmaximum_numf32x
#define __CRT_HAVE_fmaximum_numf64
#define __CRT_HAVE_fmaximum_numf64x
#define __CRT_HAVE_fmaximum_numl
#define __CRT_HAVE_fmaximumf
#define __CRT_HAVE_fmaximumf128
#define __CRT_HAVE_fmaximumf32
#define __CRT_HAVE_fmaximumf32x
#define __CRT_HAVE_fmaximumf64
#define __CRT_HAVE_fmaximumf64x
#define __CRT_HAVE_fmaximuml
#define __CRT_HAVE_fminimum
#define __CRT_HAVE_fminimum_mag
#define __CRT_HAVE_fminimum_mag_num
#define __CRT_HAVE_fminimum_mag_numf
#define __CRT_HAVE_fminimum_mag_numf128
#define __CRT_HAVE_fminimum_mag_numf32
#define __CRT_HAVE_fminimum_mag_numf32x
#define __CRT_HAVE_fminimum_mag_numf64
#define __CRT_HAVE_fminimum_mag_numf64x
#define __CRT_HAVE_fminimum_mag_numl
#define __CRT_HAVE_fminimum_magf
#define __CRT_HAVE_fminimum_magf128
#define __CRT_HAVE_fminimum_magf32
#define __CRT_HAVE_fminimum_magf32x
#define __CRT_HAVE_fminimum_magf64
#define __CRT_HAVE_fminimum_magf64x
#define __CRT_HAVE_fminimum_magl
#define __CRT_HAVE_fminimum_num
#define __CRT_HAVE_fminimum_numf
#define __CRT_HAVE_fminimum_numf128
#define __CRT_HAVE_fminimum_numf32
#define __CRT_HAVE_fminimum_numf32x
#define __CRT_HAVE_fminimum_numf64
#define __CRT_HAVE_fminimum_numf64x
#define __CRT_HAVE_fminimum_numl
#define __CRT_HAVE_fminimumf
#define __CRT_HAVE_fminimumf128
#define __CRT_HAVE_fminimumf32
#define __CRT_HAVE_fminimumf32x
#define __CRT_HAVE_fminimumf64
#define __CRT_HAVE_fminimumf64x
#define __CRT_HAVE_fminimuml
#define __CRT_HAVE_fsqrt
#define __CRT_HAVE_fsqrtl
#define __CRT_HAVE_posix_spawn_file_actions_addtcsetpgrp_np
#endif /* __GLIBC_VERSION__ >= 23500 */
#if __GLIBC_VERSION__ >= 23600
#define __CRT_HAVE_arc4random
#define __CRT_HAVE_arc4random_buf
#define __CRT_HAVE_arc4random_uniform
#define __CRT_HAVE_c8rtomb
#define __CRT_HAVE_fsconfig
#define __CRT_HAVE_fsmount
#define __CRT_HAVE_fsopen
#define __CRT_HAVE_fspick
#define __CRT_HAVE_mbrtoc8
#define __CRT_HAVE_mount_setattr
#define __CRT_HAVE_move_mount
#define __CRT_HAVE_open_tree
#define __CRT_HAVE_pidfd_getfd
#define __CRT_HAVE_pidfd_open
#define __CRT_HAVE_pidfd_send_signal
#define __CRT_HAVE_process_madvise
#define __CRT_HAVE_process_mrelease
#endif /* __GLIBC_VERSION__ >= 23600 */
#if __GLIBC_VERSION__ >= 23800
#define __CRT_HAVE___isoc23_fscanf
#define __CRT_HAVE___isoc23_fwscanf
#define __CRT_HAVE___isoc23_scanf
#define __CRT_HAVE___isoc23_sscanf
#define __CRT_HAVE___isoc23_strtoimax
#define __CRT_HAVE___isoc23_strtol
#define __CRT_HAVE___isoc23_strtol_l
#define __CRT_HAVE___isoc23_strtoll
#define __CRT_HAVE___isoc23_strtoll_l
#define __CRT_HAVE___isoc23_strtoul
#define __CRT_HAVE___isoc23_strtoul_l
#define __CRT_HAVE___isoc23_strtoull
#define __CRT_HAVE___isoc23_strtoull_l
#define __CRT_HAVE___isoc23_strtoumax
#define __CRT_HAVE___isoc23_swscanf
#define __CRT_HAVE___isoc23_vfscanf
#define __CRT_HAVE___isoc23_vfwscanf
#define __CRT_HAVE___isoc23_vscanf
#define __CRT_HAVE___isoc23_vsscanf
#define __CRT_HAVE___isoc23_vswscanf
#define __CRT_HAVE___isoc23_vwscanf
#define __CRT_HAVE___isoc23_wcstoimax
#define __CRT_HAVE___isoc23_wcstol
#define __CRT_HAVE___isoc23_wcstol_l
#define __CRT_HAVE___isoc23_wcstoll
#define __CRT_HAVE___isoc23_wcstoll_l
#define __CRT_HAVE___isoc23_wcstoul
#define __CRT_HAVE___isoc23_wcstoul_l
#define __CRT_HAVE___isoc23_wcstoull
#define __CRT_HAVE___isoc23_wcstoull_l
#define __CRT_HAVE___isoc23_wcstoumax
#define __CRT_HAVE___isoc23_wscanf
#define __CRT_HAVE___strlcat_chk
#define __CRT_HAVE___strlcpy_chk
#define __CRT_HAVE___wcslcat_chk
#define __CRT_HAVE___wcslcpy_chk
#define __CRT_HAVE_strlcat
#define __CRT_HAVE_strlcpy
#define __CRT_HAVE_wcslcat
#define __CRT_HAVE_wcslcpy
#endif /* __GLIBC_VERSION__ >= 23800 */
#ifdef __x86_64__
#define __CRT_HAVE___arch_prctl
#define __CRT_HAVE_arch_prctl
#endif /* __x86_64__ */
