/* Copyright (c) 2019-2024 Griefer@Work                                       *
 *                                                                            *
 * This software is provided 'as-is', without any express or implied          *
 * warranty. In no event will the authors be held liable for any damages      *
 * arising from the use of this software.                                     *
 *                                                                            *
 * Permission is granted to anyone to use this software for any purpose,      *
 * including commercial applications, and to alter it and redistribute it     *
 * freely, subject to the following restrictions:                             *
 *                                                                            *
 * 1. The origin of this software must not be misrepresented; you must not    *
 *    claim that you wrote the original software. If you use this software    *
 *    in a product, an acknowledgement (see the following) in the product     *
 *    documentation is required:                                              *
 *    Portions Copyright (c) 2019-2024 Griefer@Work                           *
 * 2. Altered source versions must be plainly marked as such, and must not be *
 *    misrepresented as being the original software.                          *
 * 3. This notice may not be removed or altered from any source distribution. *
 */

#ifndef __has_builtin
#define __has_builtin(x) __GCC_PRIVATE_IS_DEFINED(__GCC_HAS_BUILTIN_##x)
#ifndef __GCC_PRIVATE_IS_DEFINED
#define __GCC_PRIVATE_ARG_PLACEHOLDER_ ,
#define __GCC_PRIVATE_TAKE_SECOND_ARG_IMPL(x, val, ...) val
#define __GCC_PRIVATE_TAKE_SECOND_ARG(x) __GCC_PRIVATE_TAKE_SECOND_ARG_IMPL x
#define __GCC_PRIVATE_IS_DEFINED3(x) __GCC_PRIVATE_TAKE_SECOND_ARG((x 1, 0))
#define __GCC_PRIVATE_IS_DEFINED2(x) __GCC_PRIVATE_IS_DEFINED3(__GCC_PRIVATE_ARG_PLACEHOLDER_##x)
#define __GCC_PRIVATE_IS_DEFINED(x) __GCC_PRIVATE_IS_DEFINED2(x)
#endif /* !__GCC_PRIVATE_IS_DEFINED */
#ifndef __GNUC_MINOR__
#define __GNUC_MINOR__ 0
#endif /* !__GNUC_MINOR__ */
#ifndef __GNUC_PATCH__
#ifdef __GNUC_PATCHLEVEL__
#define __GNUC_PATCH__ __GNUC_PATCHLEVEL__
#else /* __GNUC_PATCHLEVEL__ */
#define __GNUC_PATCH__ 0
#endif /* !__GNUC_PATCHLEVEL__ */
#endif /* !__GNUC_PATCH__ */
#ifndef __GCC_VERSION_NUM
#define __GCC_VERSION_NUM (__GNUC__ * 10000 + __GNUC_MINOR__ * 100 + __GNUC_PATCH__)
#endif /* !__GCC_VERSION_NUM */

#if __GCC_VERSION_NUM >= 29700
#define __GCC_HAS_BUILTIN___builtin_alloca
#define __GCC_HAS_BUILTIN___builtin_abs
#define __GCC_HAS_BUILTIN___builtin_fabs
#define __GCC_HAS_BUILTIN___builtin_labs
#define __GCC_HAS_BUILTIN___builtin_llabs
#define __GCC_HAS_BUILTIN___builtin_ffs
#define __GCC_HAS_BUILTIN___builtin_div
#define __GCC_HAS_BUILTIN___builtin_ldiv
#define __GCC_HAS_BUILTIN___builtin_ffloor
#define __GCC_HAS_BUILTIN___builtin_fceil
#define __GCC_HAS_BUILTIN___builtin_fmod
#define __GCC_HAS_BUILTIN___builtin_frem
#define __GCC_HAS_BUILTIN___builtin_memcpy
#define __GCC_HAS_BUILTIN___builtin_memcmp
#define __GCC_HAS_BUILTIN___builtin_memset
#define __GCC_HAS_BUILTIN___builtin_bzero
#define __GCC_HAS_BUILTIN___builtin_bcmp
#define __GCC_HAS_BUILTIN___builtin_strcpy
#define __GCC_HAS_BUILTIN___builtin_strcmp
#define __GCC_HAS_BUILTIN___builtin_strlen
#define __GCC_HAS_BUILTIN___builtin_fsqrt
#define __GCC_HAS_BUILTIN___builtin_sin
#define __GCC_HAS_BUILTIN___builtin_cos
#define __GCC_HAS_BUILTIN___builtin_getexp
#define __GCC_HAS_BUILTIN___builtin_getman
#define __GCC_HAS_BUILTIN___builtin_saveregs
#define __GCC_HAS_BUILTIN___builtin_classify_type
#define __GCC_HAS_BUILTIN___builtin_next_arg
#define __GCC_HAS_BUILTIN___builtin_args_info
#define __GCC_HAS_BUILTIN___builtin_constant_p
#define __GCC_HAS_BUILTIN___builtin_frame_address
#define __GCC_HAS_BUILTIN___builtin_return_address
#define __GCC_HAS_BUILTIN___builtin_aggregate_incoming_address
#define __GCC_HAS_BUILTIN___builtin_apply_args
#define __GCC_HAS_BUILTIN___builtin_apply
#define __GCC_HAS_BUILTIN___builtin_return
#define __GCC_HAS_BUILTIN___builtin_setjmp
#define __GCC_HAS_BUILTIN___builtin_longjmp
#define __GCC_HAS_BUILTIN___builtin_trap
#define __GCC_HAS_BUILTIN___builtin_putchar
#define __GCC_HAS_BUILTIN___builtin_puts
#define __GCC_HAS_BUILTIN___builtin_printf
#define __GCC_HAS_BUILTIN___builtin_fputc
#define __GCC_HAS_BUILTIN___builtin_fputs
#define __GCC_HAS_BUILTIN___builtin_fwrite
#define __GCC_HAS_BUILTIN___builtin_isgreater
#define __GCC_HAS_BUILTIN___builtin_isgreaterequal
#define __GCC_HAS_BUILTIN___builtin_isless
#define __GCC_HAS_BUILTIN___builtin_islessequal
#define __GCC_HAS_BUILTIN___builtin_islessgreater
#define __GCC_HAS_BUILTIN___builtin_isunordered
#define __GCC_HAS_BUILTIN___builtin_unwind_init
#define __GCC_HAS_BUILTIN___builtin_dwarf_cfa
#define __GCC_HAS_BUILTIN___builtin_dwarf_fp_regnum
#define __GCC_HAS_BUILTIN___builtin_init_dwarf_reg_sizes
#define __GCC_HAS_BUILTIN___builtin_frob_return_addr
#define __GCC_HAS_BUILTIN___builtin_extract_return_addr
#define __GCC_HAS_BUILTIN___builtin_eh_return
#define __GCC_HAS_BUILTIN___builtin_varargs_start
#define __GCC_HAS_BUILTIN___builtin_stdarg_start
#define __GCC_HAS_BUILTIN___builtin_va_end
#define __GCC_HAS_BUILTIN___builtin_va_copy
#define __GCC_HAS_BUILTIN___builtin_expect
#define __GCC_HAS_BUILTIN___builtin_new
#define __GCC_HAS_BUILTIN___builtin_vec_new
#define __GCC_HAS_BUILTIN___builtin_delete
#define __GCC_HAS_BUILTIN___builtin_vec_delete
#endif /* __GCC_VERSION_NUM >= 29700 */

#if __GCC_VERSION_NUM >= 30100
#undef __GCC_HAS_BUILTIN___builtin_labs
#undef __GCC_HAS_BUILTIN___builtin_llabs
#define __GCC_HAS_BUILTIN___builtin_conj
#define __GCC_HAS_BUILTIN___builtin_creal
#define __GCC_HAS_BUILTIN___builtin_cimag
#define __GCC_HAS_BUILTIN___builtin_index
#define __GCC_HAS_BUILTIN___builtin_rindex
#define __GCC_HAS_BUILTIN___builtin_strcat
#define __GCC_HAS_BUILTIN___builtin_strncat
#define __GCC_HAS_BUILTIN___builtin_strncpy
#define __GCC_HAS_BUILTIN___builtin_strncmp
#define __GCC_HAS_BUILTIN___builtin_strstr
#define __GCC_HAS_BUILTIN___builtin_strpbrk
#define __GCC_HAS_BUILTIN___builtin_strspn
#define __GCC_HAS_BUILTIN___builtin_strcspn
#define __GCC_HAS_BUILTIN___builtin_strchr
#define __GCC_HAS_BUILTIN___builtin_strrchr
#define __GCC_HAS_BUILTIN___builtin_fprintf
#endif /* __GCC_VERSION_NUM >= 30100 */

#if __GCC_VERSION_NUM >= 30200
#undef __GCC_HAS_BUILTIN___builtin_div
#undef __GCC_HAS_BUILTIN___builtin_ldiv
#undef __GCC_HAS_BUILTIN___builtin_ffloor
#undef __GCC_HAS_BUILTIN___builtin_fceil
#undef __GCC_HAS_BUILTIN___builtin_fmod
#undef __GCC_HAS_BUILTIN___builtin_frem
#undef __GCC_HAS_BUILTIN___builtin_fsqrt
#undef __GCC_HAS_BUILTIN___builtin_getexp
#undef __GCC_HAS_BUILTIN___builtin_getman
#undef __GCC_HAS_BUILTIN___builtin_init_dwarf_reg_sizes
#undef __GCC_HAS_BUILTIN___builtin_new
#undef __GCC_HAS_BUILTIN___builtin_vec_new
#undef __GCC_HAS_BUILTIN___builtin_delete
#undef __GCC_HAS_BUILTIN___builtin_vec_delete
#define __GCC_HAS_BUILTIN___builtin_labs
#define __GCC_HAS_BUILTIN___builtin_fabsf
#define __GCC_HAS_BUILTIN___builtin_fabsl
#define __GCC_HAS_BUILTIN___builtin_llabs
#define __GCC_HAS_BUILTIN___builtin_imaxabs
#define __GCC_HAS_BUILTIN___builtin_conjf
#define __GCC_HAS_BUILTIN___builtin_conjl
#define __GCC_HAS_BUILTIN___builtin_crealf
#define __GCC_HAS_BUILTIN___builtin_creall
#define __GCC_HAS_BUILTIN___builtin_cimagf
#define __GCC_HAS_BUILTIN___builtin_cimagl
#define __GCC_HAS_BUILTIN___builtin_sqrt
#define __GCC_HAS_BUILTIN___builtin_sqrtf
#define __GCC_HAS_BUILTIN___builtin_sinf
#define __GCC_HAS_BUILTIN___builtin_cosf
#define __GCC_HAS_BUILTIN___builtin_sqrtl
#define __GCC_HAS_BUILTIN___builtin_sinl
#define __GCC_HAS_BUILTIN___builtin_cosl
#define __GCC_HAS_BUILTIN___builtin_prefetch
#define __GCC_HAS_BUILTIN___builtin_putchar_unlocked
#define __GCC_HAS_BUILTIN___builtin_puts_unlocked
#define __GCC_HAS_BUILTIN___builtin_printf_unlocked
#define __GCC_HAS_BUILTIN___builtin_fputc_unlocked
#define __GCC_HAS_BUILTIN___builtin_fputs_unlocked
#define __GCC_HAS_BUILTIN___builtin_fwrite_unlocked
#define __GCC_HAS_BUILTIN___builtin_fprintf_unlocked
#define __GCC_HAS_BUILTIN___builtin_init_dwarf_reg_size_table
#define __GCC_HAS_BUILTIN___builtin_eh_return_data_regno
#endif /* __GCC_VERSION_NUM >= 30200 */

#if __GCC_VERSION_NUM >= 30300
#undef __GCC_HAS_BUILTIN___builtin_varargs_start
#define __GCC_HAS_BUILTIN___builtin_va_start
#define __GCC_HAS_BUILTIN___builtin_abort
#define __GCC_HAS_BUILTIN___builtin_exit
#define __GCC_HAS_BUILTIN___builtin__exit
#define __GCC_HAS_BUILTIN___builtin__Exit
#endif /* __GCC_VERSION_NUM >= 30300 */

#if __GCC_VERSION_NUM >= 30400
#define __GCC_HAS_BUILTIN___builtin_floor
#define __GCC_HAS_BUILTIN___builtin_floorf
#define __GCC_HAS_BUILTIN___builtin_floorl
#define __GCC_HAS_BUILTIN___builtin_ceil
#define __GCC_HAS_BUILTIN___builtin_ceilf
#define __GCC_HAS_BUILTIN___builtin_ceill
#define __GCC_HAS_BUILTIN___builtin_round
#define __GCC_HAS_BUILTIN___builtin_roundf
#define __GCC_HAS_BUILTIN___builtin_roundl
#define __GCC_HAS_BUILTIN___builtin_trunc
#define __GCC_HAS_BUILTIN___builtin_truncf
#define __GCC_HAS_BUILTIN___builtin_truncl
#define __GCC_HAS_BUILTIN___builtin_nearbyint
#define __GCC_HAS_BUILTIN___builtin_nearbyintf
#define __GCC_HAS_BUILTIN___builtin_nearbyintl
#define __GCC_HAS_BUILTIN___builtin_exp
#define __GCC_HAS_BUILTIN___builtin_log
#define __GCC_HAS_BUILTIN___builtin_expf
#define __GCC_HAS_BUILTIN___builtin_logf
#define __GCC_HAS_BUILTIN___builtin_expl
#define __GCC_HAS_BUILTIN___builtin_logl
#define __GCC_HAS_BUILTIN___builtin_inf
#define __GCC_HAS_BUILTIN___builtin_inff
#define __GCC_HAS_BUILTIN___builtin_infl
#define __GCC_HAS_BUILTIN___builtin_huge_val
#define __GCC_HAS_BUILTIN___builtin_huge_valf
#define __GCC_HAS_BUILTIN___builtin_huge_vall
#define __GCC_HAS_BUILTIN___builtin_nan
#define __GCC_HAS_BUILTIN___builtin_nanf
#define __GCC_HAS_BUILTIN___builtin_nanl
#define __GCC_HAS_BUILTIN___builtin_nans
#define __GCC_HAS_BUILTIN___builtin_nansf
#define __GCC_HAS_BUILTIN___builtin_nansl
#endif /* __GCC_VERSION_NUM >= 30400 */

#if __GCC_VERSION_NUM >= 30500
#undef __GCC_HAS_BUILTIN___builtin_dwarf_fp_regnum
#define __GCC_HAS_BUILTIN___builtin_acos
#define __GCC_HAS_BUILTIN___builtin_acosf
#define __GCC_HAS_BUILTIN___builtin_acosh
#define __GCC_HAS_BUILTIN___builtin_acoshf
#define __GCC_HAS_BUILTIN___builtin_acoshl
#define __GCC_HAS_BUILTIN___builtin_acosl
#define __GCC_HAS_BUILTIN___builtin_asin
#define __GCC_HAS_BUILTIN___builtin_asinf
#define __GCC_HAS_BUILTIN___builtin_asinh
#define __GCC_HAS_BUILTIN___builtin_asinhf
#define __GCC_HAS_BUILTIN___builtin_asinhl
#define __GCC_HAS_BUILTIN___builtin_asinl
#define __GCC_HAS_BUILTIN___builtin_atan
#define __GCC_HAS_BUILTIN___builtin_atan2
#define __GCC_HAS_BUILTIN___builtin_atan2f
#define __GCC_HAS_BUILTIN___builtin_atan2l
#define __GCC_HAS_BUILTIN___builtin_atanf
#define __GCC_HAS_BUILTIN___builtin_atanh
#define __GCC_HAS_BUILTIN___builtin_atanhf
#define __GCC_HAS_BUILTIN___builtin_atanhl
#define __GCC_HAS_BUILTIN___builtin_atanl
#define __GCC_HAS_BUILTIN___builtin_cbrt
#define __GCC_HAS_BUILTIN___builtin_cbrtf
#define __GCC_HAS_BUILTIN___builtin_cbrtl
#define __GCC_HAS_BUILTIN___builtin_copysign
#define __GCC_HAS_BUILTIN___builtin_copysignf
#define __GCC_HAS_BUILTIN___builtin_copysignl
#define __GCC_HAS_BUILTIN___builtin_cosh
#define __GCC_HAS_BUILTIN___builtin_coshf
#define __GCC_HAS_BUILTIN___builtin_coshl
#define __GCC_HAS_BUILTIN___builtin_drem
#define __GCC_HAS_BUILTIN___builtin_dremf
#define __GCC_HAS_BUILTIN___builtin_dreml
#define __GCC_HAS_BUILTIN___builtin_erf
#define __GCC_HAS_BUILTIN___builtin_erfc
#define __GCC_HAS_BUILTIN___builtin_erfcf
#define __GCC_HAS_BUILTIN___builtin_erfcl
#define __GCC_HAS_BUILTIN___builtin_erff
#define __GCC_HAS_BUILTIN___builtin_erfl
#define __GCC_HAS_BUILTIN___builtin_exp10
#define __GCC_HAS_BUILTIN___builtin_exp10f
#define __GCC_HAS_BUILTIN___builtin_exp10l
#define __GCC_HAS_BUILTIN___builtin_exp2
#define __GCC_HAS_BUILTIN___builtin_exp2f
#define __GCC_HAS_BUILTIN___builtin_exp2l
#define __GCC_HAS_BUILTIN___builtin_expm1
#define __GCC_HAS_BUILTIN___builtin_expm1f
#define __GCC_HAS_BUILTIN___builtin_expm1l
#define __GCC_HAS_BUILTIN___builtin_fdim
#define __GCC_HAS_BUILTIN___builtin_fdimf
#define __GCC_HAS_BUILTIN___builtin_fdiml
#define __GCC_HAS_BUILTIN___builtin_fma
#define __GCC_HAS_BUILTIN___builtin_fmaf
#define __GCC_HAS_BUILTIN___builtin_fmal
#define __GCC_HAS_BUILTIN___builtin_fmax
#define __GCC_HAS_BUILTIN___builtin_fmaxf
#define __GCC_HAS_BUILTIN___builtin_fmaxl
#define __GCC_HAS_BUILTIN___builtin_fmin
#define __GCC_HAS_BUILTIN___builtin_fminf
#define __GCC_HAS_BUILTIN___builtin_fminl
#define __GCC_HAS_BUILTIN___builtin_fmod
#define __GCC_HAS_BUILTIN___builtin_fmodf
#define __GCC_HAS_BUILTIN___builtin_fmodl
#define __GCC_HAS_BUILTIN___builtin_frexp
#define __GCC_HAS_BUILTIN___builtin_frexpf
#define __GCC_HAS_BUILTIN___builtin_frexpl
#define __GCC_HAS_BUILTIN___builtin_gamma
#define __GCC_HAS_BUILTIN___builtin_gammaf
#define __GCC_HAS_BUILTIN___builtin_gammal
#define __GCC_HAS_BUILTIN___builtin_hypot
#define __GCC_HAS_BUILTIN___builtin_hypotf
#define __GCC_HAS_BUILTIN___builtin_hypotl
#define __GCC_HAS_BUILTIN___builtin_ilogb
#define __GCC_HAS_BUILTIN___builtin_ilogbf
#define __GCC_HAS_BUILTIN___builtin_ilogbl
#define __GCC_HAS_BUILTIN___builtin_j0
#define __GCC_HAS_BUILTIN___builtin_j0f
#define __GCC_HAS_BUILTIN___builtin_j0l
#define __GCC_HAS_BUILTIN___builtin_j1
#define __GCC_HAS_BUILTIN___builtin_j1f
#define __GCC_HAS_BUILTIN___builtin_j1l
#define __GCC_HAS_BUILTIN___builtin_jn
#define __GCC_HAS_BUILTIN___builtin_jnf
#define __GCC_HAS_BUILTIN___builtin_jnl
#define __GCC_HAS_BUILTIN___builtin_ldexp
#define __GCC_HAS_BUILTIN___builtin_ldexpf
#define __GCC_HAS_BUILTIN___builtin_ldexpl
#define __GCC_HAS_BUILTIN___builtin_lgamma
#define __GCC_HAS_BUILTIN___builtin_lgammaf
#define __GCC_HAS_BUILTIN___builtin_lgammal
#define __GCC_HAS_BUILTIN___builtin_llrint
#define __GCC_HAS_BUILTIN___builtin_llrintf
#define __GCC_HAS_BUILTIN___builtin_llrintl
#define __GCC_HAS_BUILTIN___builtin_llround
#define __GCC_HAS_BUILTIN___builtin_llroundf
#define __GCC_HAS_BUILTIN___builtin_llroundl
#define __GCC_HAS_BUILTIN___builtin_log10
#define __GCC_HAS_BUILTIN___builtin_log10f
#define __GCC_HAS_BUILTIN___builtin_log10l
#define __GCC_HAS_BUILTIN___builtin_log1p
#define __GCC_HAS_BUILTIN___builtin_log1pf
#define __GCC_HAS_BUILTIN___builtin_log1pl
#define __GCC_HAS_BUILTIN___builtin_log2
#define __GCC_HAS_BUILTIN___builtin_log2f
#define __GCC_HAS_BUILTIN___builtin_log2l
#define __GCC_HAS_BUILTIN___builtin_logb
#define __GCC_HAS_BUILTIN___builtin_logbf
#define __GCC_HAS_BUILTIN___builtin_logbl
#define __GCC_HAS_BUILTIN___builtin_lrint
#define __GCC_HAS_BUILTIN___builtin_lrintf
#define __GCC_HAS_BUILTIN___builtin_lrintl
#define __GCC_HAS_BUILTIN___builtin_lround
#define __GCC_HAS_BUILTIN___builtin_lroundf
#define __GCC_HAS_BUILTIN___builtin_lroundl
#define __GCC_HAS_BUILTIN___builtin_modf
#define __GCC_HAS_BUILTIN___builtin_modff
#define __GCC_HAS_BUILTIN___builtin_modfl
#define __GCC_HAS_BUILTIN___builtin_nextafter
#define __GCC_HAS_BUILTIN___builtin_nextafterf
#define __GCC_HAS_BUILTIN___builtin_nextafterl
#define __GCC_HAS_BUILTIN___builtin_nexttoward
#define __GCC_HAS_BUILTIN___builtin_nexttowardf
#define __GCC_HAS_BUILTIN___builtin_nexttowardl
#define __GCC_HAS_BUILTIN___builtin_pow
#define __GCC_HAS_BUILTIN___builtin_pow10
#define __GCC_HAS_BUILTIN___builtin_pow10f
#define __GCC_HAS_BUILTIN___builtin_pow10l
#define __GCC_HAS_BUILTIN___builtin_powf
#define __GCC_HAS_BUILTIN___builtin_powl
#define __GCC_HAS_BUILTIN___builtin_remainder
#define __GCC_HAS_BUILTIN___builtin_remainderf
#define __GCC_HAS_BUILTIN___builtin_remainderl
#define __GCC_HAS_BUILTIN___builtin_remquo
#define __GCC_HAS_BUILTIN___builtin_remquof
#define __GCC_HAS_BUILTIN___builtin_remquol
#define __GCC_HAS_BUILTIN___builtin_rint
#define __GCC_HAS_BUILTIN___builtin_rintf
#define __GCC_HAS_BUILTIN___builtin_rintl
#define __GCC_HAS_BUILTIN___builtin_scalb
#define __GCC_HAS_BUILTIN___builtin_scalbf
#define __GCC_HAS_BUILTIN___builtin_scalbl
#define __GCC_HAS_BUILTIN___builtin_scalbln
#define __GCC_HAS_BUILTIN___builtin_scalblnf
#define __GCC_HAS_BUILTIN___builtin_scalblnl
#define __GCC_HAS_BUILTIN___builtin_scalbn
#define __GCC_HAS_BUILTIN___builtin_scalbnf
#define __GCC_HAS_BUILTIN___builtin_scalbnl
#define __GCC_HAS_BUILTIN___builtin_significand
#define __GCC_HAS_BUILTIN___builtin_significandf
#define __GCC_HAS_BUILTIN___builtin_significandl
#define __GCC_HAS_BUILTIN___builtin_sincos
#define __GCC_HAS_BUILTIN___builtin_sincosf
#define __GCC_HAS_BUILTIN___builtin_sincosl
#define __GCC_HAS_BUILTIN___builtin_sinh
#define __GCC_HAS_BUILTIN___builtin_sinhf
#define __GCC_HAS_BUILTIN___builtin_sinhl
#define __GCC_HAS_BUILTIN___builtin_tan
#define __GCC_HAS_BUILTIN___builtin_tanf
#define __GCC_HAS_BUILTIN___builtin_tanh
#define __GCC_HAS_BUILTIN___builtin_tanhf
#define __GCC_HAS_BUILTIN___builtin_tanhl
#define __GCC_HAS_BUILTIN___builtin_tanl
#define __GCC_HAS_BUILTIN___builtin_tgamma
#define __GCC_HAS_BUILTIN___builtin_tgammaf
#define __GCC_HAS_BUILTIN___builtin_tgammal
#define __GCC_HAS_BUILTIN___builtin_y0
#define __GCC_HAS_BUILTIN___builtin_y0f
#define __GCC_HAS_BUILTIN___builtin_y0l
#define __GCC_HAS_BUILTIN___builtin_y1
#define __GCC_HAS_BUILTIN___builtin_y1f
#define __GCC_HAS_BUILTIN___builtin_y1l
#define __GCC_HAS_BUILTIN___builtin_yn
#define __GCC_HAS_BUILTIN___builtin_ynf
#define __GCC_HAS_BUILTIN___builtin_ynl
#define __GCC_HAS_BUILTIN___builtin_cabs
#define __GCC_HAS_BUILTIN___builtin_cabsf
#define __GCC_HAS_BUILTIN___builtin_cabsl
#define __GCC_HAS_BUILTIN___builtin_cacos
#define __GCC_HAS_BUILTIN___builtin_cacosf
#define __GCC_HAS_BUILTIN___builtin_cacosh
#define __GCC_HAS_BUILTIN___builtin_cacoshf
#define __GCC_HAS_BUILTIN___builtin_cacoshl
#define __GCC_HAS_BUILTIN___builtin_cacosl
#define __GCC_HAS_BUILTIN___builtin_carg
#define __GCC_HAS_BUILTIN___builtin_cargf
#define __GCC_HAS_BUILTIN___builtin_cargl
#define __GCC_HAS_BUILTIN___builtin_casin
#define __GCC_HAS_BUILTIN___builtin_casinf
#define __GCC_HAS_BUILTIN___builtin_casinh
#define __GCC_HAS_BUILTIN___builtin_casinhf
#define __GCC_HAS_BUILTIN___builtin_casinhl
#define __GCC_HAS_BUILTIN___builtin_casinl
#define __GCC_HAS_BUILTIN___builtin_catan
#define __GCC_HAS_BUILTIN___builtin_catanf
#define __GCC_HAS_BUILTIN___builtin_catanh
#define __GCC_HAS_BUILTIN___builtin_catanhf
#define __GCC_HAS_BUILTIN___builtin_catanhl
#define __GCC_HAS_BUILTIN___builtin_catanl
#define __GCC_HAS_BUILTIN___builtin_ccos
#define __GCC_HAS_BUILTIN___builtin_ccosf
#define __GCC_HAS_BUILTIN___builtin_ccosh
#define __GCC_HAS_BUILTIN___builtin_ccoshf
#define __GCC_HAS_BUILTIN___builtin_ccoshl
#define __GCC_HAS_BUILTIN___builtin_ccosl
#define __GCC_HAS_BUILTIN___builtin_cexp
#define __GCC_HAS_BUILTIN___builtin_cexpf
#define __GCC_HAS_BUILTIN___builtin_cexpl
#define __GCC_HAS_BUILTIN___builtin_cpow
#define __GCC_HAS_BUILTIN___builtin_cpowf
#define __GCC_HAS_BUILTIN___builtin_cpowl
#define __GCC_HAS_BUILTIN___builtin_cproj
#define __GCC_HAS_BUILTIN___builtin_cprojf
#define __GCC_HAS_BUILTIN___builtin_cprojl
#define __GCC_HAS_BUILTIN___builtin_csin
#define __GCC_HAS_BUILTIN___builtin_csinf
#define __GCC_HAS_BUILTIN___builtin_csinh
#define __GCC_HAS_BUILTIN___builtin_csinhf
#define __GCC_HAS_BUILTIN___builtin_csinhl
#define __GCC_HAS_BUILTIN___builtin_csinl
#define __GCC_HAS_BUILTIN___builtin_csqrt
#define __GCC_HAS_BUILTIN___builtin_csqrtf
#define __GCC_HAS_BUILTIN___builtin_csqrtl
#define __GCC_HAS_BUILTIN___builtin_ctan
#define __GCC_HAS_BUILTIN___builtin_ctanf
#define __GCC_HAS_BUILTIN___builtin_ctanh
#define __GCC_HAS_BUILTIN___builtin_ctanhf
#define __GCC_HAS_BUILTIN___builtin_ctanhl
#define __GCC_HAS_BUILTIN___builtin_ctanl
#define __GCC_HAS_BUILTIN___builtin_bcopy
#define __GCC_HAS_BUILTIN___builtin_ffsl
#define __GCC_HAS_BUILTIN___builtin_ffsll
#define __GCC_HAS_BUILTIN___builtin_memmove
#define __GCC_HAS_BUILTIN___builtin_mempcpy
#define __GCC_HAS_BUILTIN___builtin_stpcpy
#define __GCC_HAS_BUILTIN___builtin_strdup
#define __GCC_HAS_BUILTIN___builtin_fscanf
#define __GCC_HAS_BUILTIN___builtin_scanf
#define __GCC_HAS_BUILTIN___builtin_snprintf
#define __GCC_HAS_BUILTIN___builtin_sprintf
#define __GCC_HAS_BUILTIN___builtin_sscanf
#define __GCC_HAS_BUILTIN___builtin_vfprintf
#define __GCC_HAS_BUILTIN___builtin_vfscanf
#define __GCC_HAS_BUILTIN___builtin_vprintf
#define __GCC_HAS_BUILTIN___builtin_vscanf
#define __GCC_HAS_BUILTIN___builtin_vsnprintf
#define __GCC_HAS_BUILTIN___builtin_vsprintf
#define __GCC_HAS_BUILTIN___builtin_vsscanf
#define __GCC_HAS_BUILTIN___builtin_calloc
#define __GCC_HAS_BUILTIN___builtin_clz
#define __GCC_HAS_BUILTIN___builtin_clzl
#define __GCC_HAS_BUILTIN___builtin_clzll
#define __GCC_HAS_BUILTIN___builtin_ctz
#define __GCC_HAS_BUILTIN___builtin_ctzl
#define __GCC_HAS_BUILTIN___builtin_ctzll
#define __GCC_HAS_BUILTIN___builtin_dcgettext
#define __GCC_HAS_BUILTIN___builtin_dgettext
#define __GCC_HAS_BUILTIN___builtin_dwarf_sp_column
#define __GCC_HAS_BUILTIN___builtin_gettext
#define __GCC_HAS_BUILTIN___builtin_malloc
#define __GCC_HAS_BUILTIN___builtin_parity
#define __GCC_HAS_BUILTIN___builtin_parityl
#define __GCC_HAS_BUILTIN___builtin_parityll
#define __GCC_HAS_BUILTIN___builtin_popcount
#define __GCC_HAS_BUILTIN___builtin_popcountl
#define __GCC_HAS_BUILTIN___builtin_popcountll
#define __GCC_HAS_BUILTIN___builtin_strfmon
#define __GCC_HAS_BUILTIN___builtin_strftime
#endif /* __GCC_VERSION_NUM >= 30500 */

#if __GCC_VERSION_NUM >= 40000
#define __GCC_HAS_BUILTIN___builtin_signbit
#define __GCC_HAS_BUILTIN___builtin_signbitf
#define __GCC_HAS_BUILTIN___builtin_signbitl
#define __GCC_HAS_BUILTIN___builtin_isalnum
#define __GCC_HAS_BUILTIN___builtin_isalpha
#define __GCC_HAS_BUILTIN___builtin_isascii
#define __GCC_HAS_BUILTIN___builtin_isblank
#define __GCC_HAS_BUILTIN___builtin_iscntrl
#define __GCC_HAS_BUILTIN___builtin_isdigit
#define __GCC_HAS_BUILTIN___builtin_isgraph
#define __GCC_HAS_BUILTIN___builtin_islower
#define __GCC_HAS_BUILTIN___builtin_isprint
#define __GCC_HAS_BUILTIN___builtin_ispunct
#define __GCC_HAS_BUILTIN___builtin_isspace
#define __GCC_HAS_BUILTIN___builtin_isupper
#define __GCC_HAS_BUILTIN___builtin_isxdigit
#define __GCC_HAS_BUILTIN___builtin_toascii
#define __GCC_HAS_BUILTIN___builtin_tolower
#define __GCC_HAS_BUILTIN___builtin_toupper
#define __GCC_HAS_BUILTIN___builtin_iswalnum
#define __GCC_HAS_BUILTIN___builtin_iswalpha
#define __GCC_HAS_BUILTIN___builtin_iswblank
#define __GCC_HAS_BUILTIN___builtin_iswcntrl
#define __GCC_HAS_BUILTIN___builtin_iswdigit
#define __GCC_HAS_BUILTIN___builtin_iswgraph
#define __GCC_HAS_BUILTIN___builtin_iswlower
#define __GCC_HAS_BUILTIN___builtin_iswprint
#define __GCC_HAS_BUILTIN___builtin_iswpunct
#define __GCC_HAS_BUILTIN___builtin_iswspace
#define __GCC_HAS_BUILTIN___builtin_iswupper
#define __GCC_HAS_BUILTIN___builtin_iswxdigit
#define __GCC_HAS_BUILTIN___builtin_towlower
#define __GCC_HAS_BUILTIN___builtin_towupper
#define __GCC_HAS_BUILTIN___builtin_clzimax
#define __GCC_HAS_BUILTIN___builtin_ctzimax
#define __GCC_HAS_BUILTIN___builtin_execl
#define __GCC_HAS_BUILTIN___builtin_execlp
#define __GCC_HAS_BUILTIN___builtin_execle
#define __GCC_HAS_BUILTIN___builtin_execv
#define __GCC_HAS_BUILTIN___builtin_execvp
#define __GCC_HAS_BUILTIN___builtin_execve
#define __GCC_HAS_BUILTIN___builtin_extend_pointer
#define __GCC_HAS_BUILTIN___builtin_ffsimax
#define __GCC_HAS_BUILTIN___builtin_fork
#define __GCC_HAS_BUILTIN___builtin_finite
#define __GCC_HAS_BUILTIN___builtin_finitef
#define __GCC_HAS_BUILTIN___builtin_finitel
#define __GCC_HAS_BUILTIN___builtin_isinf
#define __GCC_HAS_BUILTIN___builtin_isinff
#define __GCC_HAS_BUILTIN___builtin_isinfl
#define __GCC_HAS_BUILTIN___builtin_isnan
#define __GCC_HAS_BUILTIN___builtin_isnanf
#define __GCC_HAS_BUILTIN___builtin_isnanl
#define __GCC_HAS_BUILTIN___builtin_parityimax
#define __GCC_HAS_BUILTIN___builtin_popcountimax
#define __GCC_HAS_BUILTIN___builtin_stack_save
#define __GCC_HAS_BUILTIN___builtin_stack_restore
#define __GCC_HAS_BUILTIN___builtin_update_setjmp_buf
#define __GCC_HAS_BUILTIN___builtin_init_trampoline
#define __GCC_HAS_BUILTIN___builtin_adjust_trampoline
#define __GCC_HAS_BUILTIN___builtin_nonlocal_goto
#define __GCC_HAS_BUILTIN___builtin_profile_func_enter
#define __GCC_HAS_BUILTIN___builtin_profile_func_exit
#endif /* __GCC_VERSION_NUM >= 40000 */

#if __GCC_VERSION_NUM >= 40100
#undef __GCC_HAS_BUILTIN___builtin_profile_func_enter
#undef __GCC_HAS_BUILTIN___builtin_profile_func_exit
#define __GCC_HAS_BUILTIN___builtin_powi
#define __GCC_HAS_BUILTIN___builtin_powif
#define __GCC_HAS_BUILTIN___builtin_powil
#define __GCC_HAS_BUILTIN_profile_func_enter
#define __GCC_HAS_BUILTIN_profile_func_exit
#endif /* __GCC_VERSION_NUM >= 40100 */

#if __GCC_VERSION_NUM >= 40200
#define __GCC_HAS_BUILTIN___builtin_lceil
#define __GCC_HAS_BUILTIN___builtin_lceilf
#define __GCC_HAS_BUILTIN___builtin_lceill
#define __GCC_HAS_BUILTIN___builtin_lfloor
#define __GCC_HAS_BUILTIN___builtin_lfloorf
#define __GCC_HAS_BUILTIN___builtin_lfloorl
#define __GCC_HAS_BUILTIN___builtin_llceil
#define __GCC_HAS_BUILTIN___builtin_llceilf
#define __GCC_HAS_BUILTIN___builtin_llceill
#define __GCC_HAS_BUILTIN___builtin_llfloor
#define __GCC_HAS_BUILTIN___builtin_llfloorf
#define __GCC_HAS_BUILTIN___builtin_llfloorl
#define __GCC_HAS_BUILTIN___builtin_clog
#define __GCC_HAS_BUILTIN___builtin_clogf
#define __GCC_HAS_BUILTIN___builtin_clogl
#define __GCC_HAS_BUILTIN___builtin_clog10
#define __GCC_HAS_BUILTIN___builtin_clog10f
#define __GCC_HAS_BUILTIN___builtin_clog10l
#define __GCC_HAS_BUILTIN___builtin_stpncpy
#define __GCC_HAS_BUILTIN___builtin_strcasecmp
#define __GCC_HAS_BUILTIN___builtin_strndup
#define __GCC_HAS_BUILTIN___builtin_strncasecmp
#define __GCC_HAS_BUILTIN___builtin_object_size
#define __GCC_HAS_BUILTIN___builtin___memcpy_chk
#define __GCC_HAS_BUILTIN___builtin___memmove_chk
#define __GCC_HAS_BUILTIN___builtin___mempcpy_chk
#define __GCC_HAS_BUILTIN___builtin___memset_chk
#define __GCC_HAS_BUILTIN___builtin___stpcpy_chk
#define __GCC_HAS_BUILTIN___builtin___strcat_chk
#define __GCC_HAS_BUILTIN___builtin___strcpy_chk
#define __GCC_HAS_BUILTIN___builtin___strncat_chk
#define __GCC_HAS_BUILTIN___builtin___strncpy_chk
#define __GCC_HAS_BUILTIN___builtin___snprintf_chk
#define __GCC_HAS_BUILTIN___builtin___sprintf_chk
#define __GCC_HAS_BUILTIN___builtin___vsnprintf_chk
#define __GCC_HAS_BUILTIN___builtin___vsprintf_chk
#define __GCC_HAS_BUILTIN___builtin___fprintf_chk
#define __GCC_HAS_BUILTIN___builtin___printf_chk
#define __GCC_HAS_BUILTIN___builtin___vfprintf_chk
#define __GCC_HAS_BUILTIN___builtin___vprintf_chk
#define __GCC_HAS_BUILTIN___sync_fetch_and_add
#define __GCC_HAS_BUILTIN___sync_fetch_and_add_1
#define __GCC_HAS_BUILTIN___sync_fetch_and_add_2
#define __GCC_HAS_BUILTIN___sync_fetch_and_add_4
#define __GCC_HAS_BUILTIN___sync_fetch_and_add_8
#define __GCC_HAS_BUILTIN___sync_fetch_and_sub
#define __GCC_HAS_BUILTIN___sync_fetch_and_sub_1
#define __GCC_HAS_BUILTIN___sync_fetch_and_sub_2
#define __GCC_HAS_BUILTIN___sync_fetch_and_sub_4
#define __GCC_HAS_BUILTIN___sync_fetch_and_sub_8
#define __GCC_HAS_BUILTIN___sync_fetch_and_or
#define __GCC_HAS_BUILTIN___sync_fetch_and_or_1
#define __GCC_HAS_BUILTIN___sync_fetch_and_or_2
#define __GCC_HAS_BUILTIN___sync_fetch_and_or_4
#define __GCC_HAS_BUILTIN___sync_fetch_and_or_8
#define __GCC_HAS_BUILTIN___sync_fetch_and_and
#define __GCC_HAS_BUILTIN___sync_fetch_and_and_1
#define __GCC_HAS_BUILTIN___sync_fetch_and_and_2
#define __GCC_HAS_BUILTIN___sync_fetch_and_and_4
#define __GCC_HAS_BUILTIN___sync_fetch_and_and_8
#define __GCC_HAS_BUILTIN___sync_fetch_and_xor
#define __GCC_HAS_BUILTIN___sync_fetch_and_xor_1
#define __GCC_HAS_BUILTIN___sync_fetch_and_xor_2
#define __GCC_HAS_BUILTIN___sync_fetch_and_xor_4
#define __GCC_HAS_BUILTIN___sync_fetch_and_xor_8
#define __GCC_HAS_BUILTIN___sync_fetch_and_nand
#define __GCC_HAS_BUILTIN___sync_fetch_and_nand_1
#define __GCC_HAS_BUILTIN___sync_fetch_and_nand_2
#define __GCC_HAS_BUILTIN___sync_fetch_and_nand_4
#define __GCC_HAS_BUILTIN___sync_fetch_and_nand_8
#define __GCC_HAS_BUILTIN___sync_add_and_fetch
#define __GCC_HAS_BUILTIN___sync_add_and_fetch_1
#define __GCC_HAS_BUILTIN___sync_add_and_fetch_2
#define __GCC_HAS_BUILTIN___sync_add_and_fetch_4
#define __GCC_HAS_BUILTIN___sync_add_and_fetch_8
#define __GCC_HAS_BUILTIN___sync_sub_and_fetch
#define __GCC_HAS_BUILTIN___sync_sub_and_fetch_1
#define __GCC_HAS_BUILTIN___sync_sub_and_fetch_2
#define __GCC_HAS_BUILTIN___sync_sub_and_fetch_4
#define __GCC_HAS_BUILTIN___sync_sub_and_fetch_8
#define __GCC_HAS_BUILTIN___sync_or_and_fetch
#define __GCC_HAS_BUILTIN___sync_or_and_fetch_1
#define __GCC_HAS_BUILTIN___sync_or_and_fetch_2
#define __GCC_HAS_BUILTIN___sync_or_and_fetch_4
#define __GCC_HAS_BUILTIN___sync_or_and_fetch_8
#define __GCC_HAS_BUILTIN___sync_and_and_fetch
#define __GCC_HAS_BUILTIN___sync_and_and_fetch_1
#define __GCC_HAS_BUILTIN___sync_and_and_fetch_2
#define __GCC_HAS_BUILTIN___sync_and_and_fetch_4
#define __GCC_HAS_BUILTIN___sync_and_and_fetch_8
#define __GCC_HAS_BUILTIN___sync_xor_and_fetch
#define __GCC_HAS_BUILTIN___sync_xor_and_fetch_1
#define __GCC_HAS_BUILTIN___sync_xor_and_fetch_2
#define __GCC_HAS_BUILTIN___sync_xor_and_fetch_4
#define __GCC_HAS_BUILTIN___sync_xor_and_fetch_8
#define __GCC_HAS_BUILTIN___sync_nand_and_fetch
#define __GCC_HAS_BUILTIN___sync_nand_and_fetch_1
#define __GCC_HAS_BUILTIN___sync_nand_and_fetch_2
#define __GCC_HAS_BUILTIN___sync_nand_and_fetch_4
#define __GCC_HAS_BUILTIN___sync_nand_and_fetch_8
#define __GCC_HAS_BUILTIN___sync_bool_compare_and_swap
#define __GCC_HAS_BUILTIN___sync_bool_compare_and_swap_1
#define __GCC_HAS_BUILTIN___sync_bool_compare_and_swap_2
#define __GCC_HAS_BUILTIN___sync_bool_compare_and_swap_4
#define __GCC_HAS_BUILTIN___sync_bool_compare_and_swap_8
#define __GCC_HAS_BUILTIN___sync_val_compare_and_swap
#define __GCC_HAS_BUILTIN___sync_val_compare_and_swap_1
#define __GCC_HAS_BUILTIN___sync_val_compare_and_swap_2
#define __GCC_HAS_BUILTIN___sync_val_compare_and_swap_4
#define __GCC_HAS_BUILTIN___sync_val_compare_and_swap_8
#define __GCC_HAS_BUILTIN___sync_lock_test_and_set
#define __GCC_HAS_BUILTIN___sync_lock_test_and_set_1
#define __GCC_HAS_BUILTIN___sync_lock_test_and_set_2
#define __GCC_HAS_BUILTIN___sync_lock_test_and_set_4
#define __GCC_HAS_BUILTIN___sync_lock_test_and_set_8
#define __GCC_HAS_BUILTIN___sync_lock_release
#define __GCC_HAS_BUILTIN___sync_lock_release_1
#define __GCC_HAS_BUILTIN___sync_lock_release_2
#define __GCC_HAS_BUILTIN___sync_lock_release_4
#define __GCC_HAS_BUILTIN___sync_lock_release_8
#define __GCC_HAS_BUILTIN___sync_synchronize
#endif /* __GCC_VERSION_NUM >= 40200 */

#if __GCC_VERSION_NUM >= 40300
#define __GCC_HAS_BUILTIN___builtin_infd32
#define __GCC_HAS_BUILTIN___builtin_infd64
#define __GCC_HAS_BUILTIN___builtin_infd128
#define __GCC_HAS_BUILTIN___builtin_nand32
#define __GCC_HAS_BUILTIN___builtin_nand64
#define __GCC_HAS_BUILTIN___builtin_nand128
#define __GCC_HAS_BUILTIN___builtin_putc
#define __GCC_HAS_BUILTIN___builtin_putc_unlocked
#define __GCC_HAS_BUILTIN___builtin_finited32
#define __GCC_HAS_BUILTIN___builtin_finited64
#define __GCC_HAS_BUILTIN___builtin_finited128
#define __GCC_HAS_BUILTIN___builtin_isinfd32
#define __GCC_HAS_BUILTIN___builtin_isinfd64
#define __GCC_HAS_BUILTIN___builtin_isinfd128
#define __GCC_HAS_BUILTIN___builtin_isnand32
#define __GCC_HAS_BUILTIN___builtin_isnand64
#define __GCC_HAS_BUILTIN___builtin_isnand128
#define __GCC_HAS_BUILTIN___builtin_setjmp_setup
#define __GCC_HAS_BUILTIN___builtin_setjmp_dispatcher
#define __GCC_HAS_BUILTIN___builtin_setjmp_receiver
#define __GCC_HAS_BUILTIN___sync_fetch_and_add_16
#define __GCC_HAS_BUILTIN___sync_fetch_and_sub_16
#define __GCC_HAS_BUILTIN___sync_fetch_and_or_16
#define __GCC_HAS_BUILTIN___sync_fetch_and_and_16
#define __GCC_HAS_BUILTIN___sync_fetch_and_xor_16
#define __GCC_HAS_BUILTIN___sync_fetch_and_nand_16
#define __GCC_HAS_BUILTIN___sync_add_and_fetch_16
#define __GCC_HAS_BUILTIN___sync_sub_and_fetch_16
#define __GCC_HAS_BUILTIN___sync_or_and_fetch_16
#define __GCC_HAS_BUILTIN___sync_and_and_fetch_16
#define __GCC_HAS_BUILTIN___sync_xor_and_fetch_16
#define __GCC_HAS_BUILTIN___sync_nand_and_fetch_16
#define __GCC_HAS_BUILTIN___sync_bool_compare_and_swap_16
#define __GCC_HAS_BUILTIN___sync_val_compare_and_swap_16
#define __GCC_HAS_BUILTIN___sync_lock_test_and_set_16
#define __GCC_HAS_BUILTIN___sync_lock_release_16
#endif /* __GCC_VERSION_NUM >= 40300 */

#if __GCC_VERSION_NUM >= 40400
#define __GCC_HAS_BUILTIN___builtin_gamma_r
#define __GCC_HAS_BUILTIN___builtin_gammaf_r
#define __GCC_HAS_BUILTIN___builtin_gammal_r
#define __GCC_HAS_BUILTIN___builtin_lgamma_r
#define __GCC_HAS_BUILTIN___builtin_lgammaf_r
#define __GCC_HAS_BUILTIN___builtin_lgammal_r
#define __GCC_HAS_BUILTIN___builtin_signbitd32
#define __GCC_HAS_BUILTIN___builtin_signbitd64
#define __GCC_HAS_BUILTIN___builtin_signbitd128
#define __GCC_HAS_BUILTIN___builtin_cexpi
#define __GCC_HAS_BUILTIN___builtin_cexpif
#define __GCC_HAS_BUILTIN___builtin_cexpil
#define __GCC_HAS_BUILTIN___builtin_memchr
#define __GCC_HAS_BUILTIN___builtin_bswap32
#define __GCC_HAS_BUILTIN___builtin_bswap64
#define __GCC_HAS_BUILTIN___builtin___clear_cache
#define __GCC_HAS_BUILTIN___builtin_free
#define __GCC_HAS_BUILTIN___builtin_isfinite
#define __GCC_HAS_BUILTIN___builtin_isnormal
#define __GCC_HAS_BUILTIN___builtin_realloc
#define __GCC_HAS_BUILTIN___builtin_va_arg_pack
#define __GCC_HAS_BUILTIN___builtin_va_arg_pack_len
#define __GCC_HAS_BUILTIN___builtin___emutls_get_address
#define __GCC_HAS_BUILTIN___builtin___emutls_register_common
#endif /* __GCC_VERSION_NUM >= 40400 */

#if __GCC_VERSION_NUM >= 40500
#undef __GCC_HAS_BUILTIN___builtin_stdarg_start
#undef __GCC_HAS_BUILTIN___builtin___emutls_get_address
#undef __GCC_HAS_BUILTIN___builtin___emutls_register_common
#define __GCC_HAS_BUILTIN___builtin_fpclassify
#define __GCC_HAS_BUILTIN___builtin_isinf_sign
#endif /* __GCC_VERSION_NUM >= 40500 */

#if __GCC_VERSION_NUM >= 40600
#define __GCC_HAS_BUILTIN___builtin_unreachable
#define __GCC_HAS_BUILTIN___builtin_unwind_resume
#define __GCC_HAS_BUILTIN___builtin_eh_pointer
#define __GCC_HAS_BUILTIN___builtin_eh_filter
#define __GCC_HAS_BUILTIN___builtin_eh_copy_values
#endif /* __GCC_VERSION_NUM >= 40600 */

#if __GCC_VERSION_NUM >= 40700
#undef __GCC_HAS_BUILTIN___builtin_args_info
#undef __GCC_HAS_BUILTIN_profile_func_enter
#undef __GCC_HAS_BUILTIN_profile_func_exit
#define __GCC_HAS_BUILTIN___cyg_profile_func_enter
#define __GCC_HAS_BUILTIN___cyg_profile_func_exit
#endif /* __GCC_VERSION_NUM >= 40700 */

#if __GCC_VERSION_NUM >= 40800
#define __GCC_HAS_BUILTIN___builtin_iceil
#define __GCC_HAS_BUILTIN___builtin_iceilf
#define __GCC_HAS_BUILTIN___builtin_iceill
#define __GCC_HAS_BUILTIN___builtin_ifloor
#define __GCC_HAS_BUILTIN___builtin_ifloorf
#define __GCC_HAS_BUILTIN___builtin_ifloorl
#define __GCC_HAS_BUILTIN___builtin_irint
#define __GCC_HAS_BUILTIN___builtin_irintf
#define __GCC_HAS_BUILTIN___builtin_irintl
#define __GCC_HAS_BUILTIN___builtin_iround
#define __GCC_HAS_BUILTIN___builtin_iroundf
#define __GCC_HAS_BUILTIN___builtin_iroundl
#define __GCC_HAS_BUILTIN___builtin_clrsb
#define __GCC_HAS_BUILTIN___builtin_clrsbimax
#define __GCC_HAS_BUILTIN___builtin_clrsbl
#define __GCC_HAS_BUILTIN___builtin_clrsbll
#define __GCC_HAS_BUILTIN___builtin_assume_aligned
#define __GCC_HAS_BUILTIN___builtin_init_heap_trampoline
#define __GCC_HAS_BUILTIN___builtin_alloca_with_align
#define __GCC_HAS_BUILTIN___builtin___stpncpy_chk
#define __GCC_HAS_BUILTIN___atomic_test_and_set
#define __GCC_HAS_BUILTIN___atomic_clear
#define __GCC_HAS_BUILTIN___atomic_exchange
#define __GCC_HAS_BUILTIN___atomic_exchange_n
#define __GCC_HAS_BUILTIN___atomic_exchange_1
#define __GCC_HAS_BUILTIN___atomic_exchange_2
#define __GCC_HAS_BUILTIN___atomic_exchange_4
#define __GCC_HAS_BUILTIN___atomic_exchange_8
#define __GCC_HAS_BUILTIN___atomic_exchange_16
#define __GCC_HAS_BUILTIN___atomic_load
#define __GCC_HAS_BUILTIN___atomic_load_n
#define __GCC_HAS_BUILTIN___atomic_load_1
#define __GCC_HAS_BUILTIN___atomic_load_2
#define __GCC_HAS_BUILTIN___atomic_load_4
#define __GCC_HAS_BUILTIN___atomic_load_8
#define __GCC_HAS_BUILTIN___atomic_load_16
#define __GCC_HAS_BUILTIN___atomic_compare_exchange
#define __GCC_HAS_BUILTIN___atomic_compare_exchange_n
#define __GCC_HAS_BUILTIN___atomic_compare_exchange_1
#define __GCC_HAS_BUILTIN___atomic_compare_exchange_2
#define __GCC_HAS_BUILTIN___atomic_compare_exchange_4
#define __GCC_HAS_BUILTIN___atomic_compare_exchange_8
#define __GCC_HAS_BUILTIN___atomic_compare_exchange_16
#define __GCC_HAS_BUILTIN___atomic_store
#define __GCC_HAS_BUILTIN___atomic_store_n
#define __GCC_HAS_BUILTIN___atomic_store_1
#define __GCC_HAS_BUILTIN___atomic_store_2
#define __GCC_HAS_BUILTIN___atomic_store_4
#define __GCC_HAS_BUILTIN___atomic_store_8
#define __GCC_HAS_BUILTIN___atomic_store_16
#define __GCC_HAS_BUILTIN___atomic_add_fetch
#define __GCC_HAS_BUILTIN___atomic_add_fetch_1
#define __GCC_HAS_BUILTIN___atomic_add_fetch_2
#define __GCC_HAS_BUILTIN___atomic_add_fetch_4
#define __GCC_HAS_BUILTIN___atomic_add_fetch_8
#define __GCC_HAS_BUILTIN___atomic_add_fetch_16
#define __GCC_HAS_BUILTIN___atomic_sub_fetch
#define __GCC_HAS_BUILTIN___atomic_sub_fetch_1
#define __GCC_HAS_BUILTIN___atomic_sub_fetch_2
#define __GCC_HAS_BUILTIN___atomic_sub_fetch_4
#define __GCC_HAS_BUILTIN___atomic_sub_fetch_8
#define __GCC_HAS_BUILTIN___atomic_sub_fetch_16
#define __GCC_HAS_BUILTIN___atomic_and_fetch
#define __GCC_HAS_BUILTIN___atomic_and_fetch_1
#define __GCC_HAS_BUILTIN___atomic_and_fetch_2
#define __GCC_HAS_BUILTIN___atomic_and_fetch_4
#define __GCC_HAS_BUILTIN___atomic_and_fetch_8
#define __GCC_HAS_BUILTIN___atomic_and_fetch_16
#define __GCC_HAS_BUILTIN___atomic_nand_fetch
#define __GCC_HAS_BUILTIN___atomic_nand_fetch_1
#define __GCC_HAS_BUILTIN___atomic_nand_fetch_2
#define __GCC_HAS_BUILTIN___atomic_nand_fetch_4
#define __GCC_HAS_BUILTIN___atomic_nand_fetch_8
#define __GCC_HAS_BUILTIN___atomic_nand_fetch_16
#define __GCC_HAS_BUILTIN___atomic_xor_fetch
#define __GCC_HAS_BUILTIN___atomic_xor_fetch_1
#define __GCC_HAS_BUILTIN___atomic_xor_fetch_2
#define __GCC_HAS_BUILTIN___atomic_xor_fetch_4
#define __GCC_HAS_BUILTIN___atomic_xor_fetch_8
#define __GCC_HAS_BUILTIN___atomic_xor_fetch_16
#define __GCC_HAS_BUILTIN___atomic_or_fetch
#define __GCC_HAS_BUILTIN___atomic_or_fetch_1
#define __GCC_HAS_BUILTIN___atomic_or_fetch_2
#define __GCC_HAS_BUILTIN___atomic_or_fetch_4
#define __GCC_HAS_BUILTIN___atomic_or_fetch_8
#define __GCC_HAS_BUILTIN___atomic_or_fetch_16
#define __GCC_HAS_BUILTIN___atomic_fetch_add
#define __GCC_HAS_BUILTIN___atomic_fetch_add_1
#define __GCC_HAS_BUILTIN___atomic_fetch_add_2
#define __GCC_HAS_BUILTIN___atomic_fetch_add_4
#define __GCC_HAS_BUILTIN___atomic_fetch_add_8
#define __GCC_HAS_BUILTIN___atomic_fetch_add_16
#define __GCC_HAS_BUILTIN___atomic_fetch_sub
#define __GCC_HAS_BUILTIN___atomic_fetch_sub_1
#define __GCC_HAS_BUILTIN___atomic_fetch_sub_2
#define __GCC_HAS_BUILTIN___atomic_fetch_sub_4
#define __GCC_HAS_BUILTIN___atomic_fetch_sub_8
#define __GCC_HAS_BUILTIN___atomic_fetch_sub_16
#define __GCC_HAS_BUILTIN___atomic_fetch_and
#define __GCC_HAS_BUILTIN___atomic_fetch_and_1
#define __GCC_HAS_BUILTIN___atomic_fetch_and_2
#define __GCC_HAS_BUILTIN___atomic_fetch_and_4
#define __GCC_HAS_BUILTIN___atomic_fetch_and_8
#define __GCC_HAS_BUILTIN___atomic_fetch_and_16
#define __GCC_HAS_BUILTIN___atomic_fetch_nand
#define __GCC_HAS_BUILTIN___atomic_fetch_nand_1
#define __GCC_HAS_BUILTIN___atomic_fetch_nand_2
#define __GCC_HAS_BUILTIN___atomic_fetch_nand_4
#define __GCC_HAS_BUILTIN___atomic_fetch_nand_8
#define __GCC_HAS_BUILTIN___atomic_fetch_nand_16
#define __GCC_HAS_BUILTIN___atomic_fetch_xor
#define __GCC_HAS_BUILTIN___atomic_fetch_xor_1
#define __GCC_HAS_BUILTIN___atomic_fetch_xor_2
#define __GCC_HAS_BUILTIN___atomic_fetch_xor_4
#define __GCC_HAS_BUILTIN___atomic_fetch_xor_8
#define __GCC_HAS_BUILTIN___atomic_fetch_xor_16
#define __GCC_HAS_BUILTIN___atomic_fetch_or
#define __GCC_HAS_BUILTIN___atomic_fetch_or_1
#define __GCC_HAS_BUILTIN___atomic_fetch_or_2
#define __GCC_HAS_BUILTIN___atomic_fetch_or_4
#define __GCC_HAS_BUILTIN___atomic_fetch_or_8
#define __GCC_HAS_BUILTIN___atomic_fetch_or_16
#define __GCC_HAS_BUILTIN___atomic_always_lock_free
#define __GCC_HAS_BUILTIN___atomic_is_lock_free
#define __GCC_HAS_BUILTIN___atomic_thread_fence
#define __GCC_HAS_BUILTIN___atomic_signal_fence
#ifdef __cpp_transactional_memory
#define __GCC_HAS_BUILTIN___builtin__ITM_beginTransaction
#define __GCC_HAS_BUILTIN___builtin__ITM_commitTransaction
#define __GCC_HAS_BUILTIN___builtin__ITM_commitTransactionEH
#define __GCC_HAS_BUILTIN___builtin__ITM_abortTransaction
#define __GCC_HAS_BUILTIN___builtin__ITM_changeTransactionMode
#define __GCC_HAS_BUILTIN___builtin__ITM_memcpyRtWt
#define __GCC_HAS_BUILTIN___builtin__ITM_memmoveRtWt
#define __GCC_HAS_BUILTIN___builtin__ITM_memsetW
#define __GCC_HAS_BUILTIN___builtin__ITM_getTMCloneOrIrrevocable
#define __GCC_HAS_BUILTIN___builtin__ITM_getTMCloneSafe
#define __GCC_HAS_BUILTIN___builtin__ITM_malloc
#define __GCC_HAS_BUILTIN___builtin__ITM_calloc
#define __GCC_HAS_BUILTIN___builtin__ITM_free
#define __GCC_HAS_BUILTIN___builtin__ITM_LU1
#define __GCC_HAS_BUILTIN___builtin__ITM_LU2
#define __GCC_HAS_BUILTIN___builtin__ITM_LU4
#define __GCC_HAS_BUILTIN___builtin__ITM_LU8
#define __GCC_HAS_BUILTIN___builtin__ITM_LF
#define __GCC_HAS_BUILTIN___builtin__ITM_LD
#define __GCC_HAS_BUILTIN___builtin__ITM_LE
#define __GCC_HAS_BUILTIN___builtin__ITM_LB
#define __GCC_HAS_BUILTIN___builtin__ITM_WU1
#define __GCC_HAS_BUILTIN___builtin__ITM_WaRU1
#define __GCC_HAS_BUILTIN___builtin__ITM_WaWU1
#define __GCC_HAS_BUILTIN___builtin__ITM_WU2
#define __GCC_HAS_BUILTIN___builtin__ITM_WaRU2
#define __GCC_HAS_BUILTIN___builtin__ITM_WaWU2
#define __GCC_HAS_BUILTIN___builtin__ITM_WU4
#define __GCC_HAS_BUILTIN___builtin__ITM_WaRU4
#define __GCC_HAS_BUILTIN___builtin__ITM_WaWU4
#define __GCC_HAS_BUILTIN___builtin__ITM_WU8
#define __GCC_HAS_BUILTIN___builtin__ITM_WaRU8
#define __GCC_HAS_BUILTIN___builtin__ITM_WaWU8
#define __GCC_HAS_BUILTIN___builtin__ITM_WF
#define __GCC_HAS_BUILTIN___builtin__ITM_WaRF
#define __GCC_HAS_BUILTIN___builtin__ITM_WaWF
#define __GCC_HAS_BUILTIN___builtin__ITM_WD
#define __GCC_HAS_BUILTIN___builtin__ITM_WaRD
#define __GCC_HAS_BUILTIN___builtin__ITM_WaWD
#define __GCC_HAS_BUILTIN___builtin__ITM_WE
#define __GCC_HAS_BUILTIN___builtin__ITM_WaRE
#define __GCC_HAS_BUILTIN___builtin__ITM_WaWE
#define __GCC_HAS_BUILTIN___builtin__ITM_RU1
#define __GCC_HAS_BUILTIN___builtin__ITM_RaRU1
#define __GCC_HAS_BUILTIN___builtin__ITM_RaWU1
#define __GCC_HAS_BUILTIN___builtin__ITM_RfWU1
#define __GCC_HAS_BUILTIN___builtin__ITM_RU2
#define __GCC_HAS_BUILTIN___builtin__ITM_RaRU2
#define __GCC_HAS_BUILTIN___builtin__ITM_RaWU2
#define __GCC_HAS_BUILTIN___builtin__ITM_RfWU2
#define __GCC_HAS_BUILTIN___builtin__ITM_RU4
#define __GCC_HAS_BUILTIN___builtin__ITM_RaRU4
#define __GCC_HAS_BUILTIN___builtin__ITM_RaWU4
#define __GCC_HAS_BUILTIN___builtin__ITM_RfWU4
#define __GCC_HAS_BUILTIN___builtin__ITM_RU8
#define __GCC_HAS_BUILTIN___builtin__ITM_RaRU8
#define __GCC_HAS_BUILTIN___builtin__ITM_RaWU8
#define __GCC_HAS_BUILTIN___builtin__ITM_RfWU8
#define __GCC_HAS_BUILTIN___builtin__ITM_RF
#define __GCC_HAS_BUILTIN___builtin__ITM_RaRF
#define __GCC_HAS_BUILTIN___builtin__ITM_RaWF
#define __GCC_HAS_BUILTIN___builtin__ITM_RfWF
#define __GCC_HAS_BUILTIN___builtin__ITM_RD
#define __GCC_HAS_BUILTIN___builtin__ITM_RaRD
#define __GCC_HAS_BUILTIN___builtin__ITM_RaWD
#define __GCC_HAS_BUILTIN___builtin__ITM_RfWD
#define __GCC_HAS_BUILTIN___builtin__ITM_RE
#define __GCC_HAS_BUILTIN___builtin__ITM_RaRE
#define __GCC_HAS_BUILTIN___builtin__ITM_RaWE
#define __GCC_HAS_BUILTIN___builtin__ITM_RfWE
#endif /* __cpp_transactional_memory */
#endif /* __GCC_VERSION_NUM >= 40800 */

#if __GCC_VERSION_NUM >= 40900
#define __GCC_HAS_BUILTIN___builtin_bswap16
#define __GCC_HAS_BUILTIN___builtin_FILE
#define __GCC_HAS_BUILTIN___builtin_FUNCTION
#define __GCC_HAS_BUILTIN___builtin_LINE
#endif /* __GCC_VERSION_NUM >= 40900 */

#if __GCC_VERSION_NUM >= 41000
#undef __GCC_HAS_BUILTIN___builtin_setjmp_dispatcher
#define __GCC_HAS_BUILTIN___builtin_fabsd32
#define __GCC_HAS_BUILTIN___builtin_fabsd64
#define __GCC_HAS_BUILTIN___builtin_fabsd128
#define __GCC_HAS_BUILTIN___builtin_posix_memalign
#define __GCC_HAS_BUILTIN___atomic_feraiseexcept
#define __GCC_HAS_BUILTIN___cilkrts_enter_frame_1
#define __GCC_HAS_BUILTIN___cilkrts_enter_frame_fast_1
#define __GCC_HAS_BUILTIN___cilkrts_detach
#define __GCC_HAS_BUILTIN___cilkrts_rethrow
#define __GCC_HAS_BUILTIN___cilkrts_synched
#define __GCC_HAS_BUILTIN___cilkrts_sync
#define __GCC_HAS_BUILTIN___cilkrts_leave_frame
#define __GCC_HAS_BUILTIN___cilkrts_pop_frame
#define __GCC_HAS_BUILTIN___cilkrts_save_fp_ctrl_state
#endif /* __GCC_VERSION_NUM >= 41000 */

#if __GCC_VERSION_NUM >= 50000
#define __GCC_HAS_BUILTIN___builtin_aligned_alloc
#endif /* __GCC_VERSION_NUM >= 50000 */

#if __GCC_VERSION_NUM >= 60000
#define __GCC_HAS_BUILTIN___builtin_add_overflow
#define __GCC_HAS_BUILTIN___builtin_sub_overflow
#define __GCC_HAS_BUILTIN___builtin_mul_overflow
#define __GCC_HAS_BUILTIN___builtin_sadd_overflow
#define __GCC_HAS_BUILTIN___builtin_saddl_overflow
#define __GCC_HAS_BUILTIN___builtin_saddll_overflow
#define __GCC_HAS_BUILTIN___builtin_ssub_overflow
#define __GCC_HAS_BUILTIN___builtin_ssubl_overflow
#define __GCC_HAS_BUILTIN___builtin_ssubll_overflow
#define __GCC_HAS_BUILTIN___builtin_smul_overflow
#define __GCC_HAS_BUILTIN___builtin_smull_overflow
#define __GCC_HAS_BUILTIN___builtin_smulll_overflow
#define __GCC_HAS_BUILTIN___builtin_uadd_overflow
#define __GCC_HAS_BUILTIN___builtin_uaddl_overflow
#define __GCC_HAS_BUILTIN___builtin_uaddll_overflow
#define __GCC_HAS_BUILTIN___builtin_usub_overflow
#define __GCC_HAS_BUILTIN___builtin_usubl_overflow
#define __GCC_HAS_BUILTIN___builtin_usubll_overflow
#define __GCC_HAS_BUILTIN___builtin_umul_overflow
#define __GCC_HAS_BUILTIN___builtin_umull_overflow
#define __GCC_HAS_BUILTIN___builtin_umulll_overflow
#ifdef _OPENACC
#define __GCC_HAS_BUILTIN___builtin_acc_get_device_type
#define __GCC_HAS_BUILTIN___builtin_GOACC_data_start
#define __GCC_HAS_BUILTIN___builtin_GOACC_data_end
#define __GCC_HAS_BUILTIN___builtin_GOACC_enter_exit_data
#define __GCC_HAS_BUILTIN___builtin_GOACC_parallel
#define __GCC_HAS_BUILTIN___builtin_GOACC_update
#define __GCC_HAS_BUILTIN___builtin_GOACC_wait
#define __GCC_HAS_BUILTIN___builtin_GOACC_get_thread_num
#define __GCC_HAS_BUILTIN___builtin_GOACC_get_num_threads
#endif /* _OPENACC */
#define __GCC_HAS_BUILTIN___builtin_acc_on_device
#define __GCC_HAS_BUILTIN___cilkrts_cilk_for_32
#define __GCC_HAS_BUILTIN___cilkrts_cilk_for_64
#define __GCC_HAS_BUILTIN___chkp_intersect
#define __GCC_HAS_BUILTIN___chkp_sizeof
#define __GCC_HAS_BUILTIN___chkp_narrow
#define __GCC_HAS_BUILTIN___builtin___chkp_bndcl
#define __GCC_HAS_BUILTIN___builtin___chkp_bndcu
#define __GCC_HAS_BUILTIN___builtin___chkp_bndstx
#define __GCC_HAS_BUILTIN___builtin___chkp_bndldx
#define __GCC_HAS_BUILTIN___builtin___chkp_bndret
#define __GCC_HAS_BUILTIN___builtin___chkp_bndmk
#define __GCC_HAS_BUILTIN___builtin___chkp_extract_lower
#define __GCC_HAS_BUILTIN___builtin___chkp_extract_upper
#define __GCC_HAS_BUILTIN___builtin___bnd_set_ptr_bounds
#define __GCC_HAS_BUILTIN___builtin___bnd_init_ptr_bounds
#define __GCC_HAS_BUILTIN___builtin___bnd_null_ptr_bounds
#define __GCC_HAS_BUILTIN___builtin___bnd_copy_ptr_bounds
#define __GCC_HAS_BUILTIN___builtin___bnd_narrow_ptr_bounds
#define __GCC_HAS_BUILTIN___builtin___bnd_store_ptr_bounds
#define __GCC_HAS_BUILTIN___builtin___bnd_chk_ptr_lbounds
#define __GCC_HAS_BUILTIN___builtin___bnd_chk_ptr_ubounds
#define __GCC_HAS_BUILTIN___builtin___bnd_chk_ptr_bounds
#define __GCC_HAS_BUILTIN___builtin___bnd_get_ptr_lbound
#define __GCC_HAS_BUILTIN___builtin___bnd_get_ptr_ubound
#define __GCC_HAS_BUILTIN___builtin_chkp_memcpy_nobnd
#define __GCC_HAS_BUILTIN___builtin_chkp_memcpy_nochk
#define __GCC_HAS_BUILTIN___builtin_chkp_memcpy_nobnd_nochk
#define __GCC_HAS_BUILTIN___builtin_chkp_memmove_nobnd
#define __GCC_HAS_BUILTIN___builtin_chkp_memmove_nochk
#define __GCC_HAS_BUILTIN___builtin_chkp_memmove_nobnd_nochk
#define __GCC_HAS_BUILTIN___builtin_chkp_mempcpy_nobnd
#define __GCC_HAS_BUILTIN___builtin_chkp_mempcpy_nochk
#define __GCC_HAS_BUILTIN___builtin_chkp_mempcpy_nobnd_nochk
#define __GCC_HAS_BUILTIN___builtin_chkp_memset_nobnd
#define __GCC_HAS_BUILTIN___builtin_chkp_memset_nochk
#define __GCC_HAS_BUILTIN___builtin_chkp_memset_nobnd_nochk
#endif /* __GCC_VERSION_NUM >= 60000 */

#if __GCC_VERSION_NUM >= 70000
#undef __GCC_HAS_BUILTIN___builtin_GOACC_parallel
#undef __GCC_HAS_BUILTIN___builtin_GOACC_get_thread_num
#undef __GCC_HAS_BUILTIN___builtin_GOACC_get_num_threads
#ifdef _OPENACC
#define __GCC_HAS_BUILTIN___builtin_GOACC_parallel_keyed
#define __GCC_HAS_BUILTIN___builtin_GOACC_declare
#endif /* _OPENACC */
#ifdef __cpp_transactional_memory
#define __GCC_HAS_BUILTIN___builtin__ITM_memcpyRnWt
#define __GCC_HAS_BUILTIN___builtin__ITM_memcpyRtWn
#endif /* __cpp_transactional_memory */
#endif /* __GCC_VERSION_NUM >= 70000 */

#if __GCC_VERSION_NUM >= 70001
#define __GCC_HAS_BUILTIN___builtin_copysignf16
#define __GCC_HAS_BUILTIN___builtin_copysignf32
#define __GCC_HAS_BUILTIN___builtin_copysignf64
#define __GCC_HAS_BUILTIN___builtin_copysignf128
#define __GCC_HAS_BUILTIN___builtin_copysignf32x
#define __GCC_HAS_BUILTIN___builtin_copysignf64x
#define __GCC_HAS_BUILTIN___builtin_copysignf128x
#define __GCC_HAS_BUILTIN___builtin_fabsf16
#define __GCC_HAS_BUILTIN___builtin_fabsf32
#define __GCC_HAS_BUILTIN___builtin_fabsf64
#define __GCC_HAS_BUILTIN___builtin_fabsf128
#define __GCC_HAS_BUILTIN___builtin_fabsf32x
#define __GCC_HAS_BUILTIN___builtin_fabsf64x
#define __GCC_HAS_BUILTIN___builtin_fabsf128x
#define __GCC_HAS_BUILTIN___builtin_huge_valf16
#define __GCC_HAS_BUILTIN___builtin_huge_valf32
#define __GCC_HAS_BUILTIN___builtin_huge_valf64
#define __GCC_HAS_BUILTIN___builtin_huge_valf128
#define __GCC_HAS_BUILTIN___builtin_huge_valf32x
#define __GCC_HAS_BUILTIN___builtin_huge_valf64x
#define __GCC_HAS_BUILTIN___builtin_huge_valf128x
#define __GCC_HAS_BUILTIN___builtin_inff16
#define __GCC_HAS_BUILTIN___builtin_inff32
#define __GCC_HAS_BUILTIN___builtin_inff64
#define __GCC_HAS_BUILTIN___builtin_inff128
#define __GCC_HAS_BUILTIN___builtin_inff32x
#define __GCC_HAS_BUILTIN___builtin_inff64x
#define __GCC_HAS_BUILTIN___builtin_inff128x
#define __GCC_HAS_BUILTIN___builtin_nanf16
#define __GCC_HAS_BUILTIN___builtin_nanf32
#define __GCC_HAS_BUILTIN___builtin_nanf64
#define __GCC_HAS_BUILTIN___builtin_nanf128
#define __GCC_HAS_BUILTIN___builtin_nanf32x
#define __GCC_HAS_BUILTIN___builtin_nanf64x
#define __GCC_HAS_BUILTIN___builtin_nanf128x
#define __GCC_HAS_BUILTIN___builtin_nansf16
#define __GCC_HAS_BUILTIN___builtin_nansf32
#define __GCC_HAS_BUILTIN___builtin_nansf64
#define __GCC_HAS_BUILTIN___builtin_nansf128
#define __GCC_HAS_BUILTIN___builtin_nansf32x
#define __GCC_HAS_BUILTIN___builtin_nansf64x
#define __GCC_HAS_BUILTIN___builtin_nansf128x
#define __GCC_HAS_BUILTIN___builtin_add_overflow_p
#define __GCC_HAS_BUILTIN___builtin_sub_overflow_p
#define __GCC_HAS_BUILTIN___builtin_mul_overflow_p
#define __GCC_HAS_BUILTIN___builtin_init_descriptor
#define __GCC_HAS_BUILTIN___builtin_adjust_descriptor
#define __GCC_HAS_BUILTIN___builtin_memcmp_eq
#endif /* __GCC_VERSION_NUM >= 70001 */

#if __GCC_VERSION_NUM >= 80001
#undef __GCC_HAS_BUILTIN___cilkrts_enter_frame_1
#undef __GCC_HAS_BUILTIN___cilkrts_enter_frame_fast_1
#undef __GCC_HAS_BUILTIN___cilkrts_detach
#undef __GCC_HAS_BUILTIN___cilkrts_rethrow
#undef __GCC_HAS_BUILTIN___cilkrts_synched
#undef __GCC_HAS_BUILTIN___cilkrts_sync
#undef __GCC_HAS_BUILTIN___cilkrts_leave_frame
#undef __GCC_HAS_BUILTIN___cilkrts_pop_frame
#undef __GCC_HAS_BUILTIN___cilkrts_save_fp_ctrl_state
#undef __GCC_HAS_BUILTIN___cilkrts_cilk_for_32
#undef __GCC_HAS_BUILTIN___cilkrts_cilk_for_64
#define __GCC_HAS_BUILTIN___builtin_ceilf16
#define __GCC_HAS_BUILTIN___builtin_ceilf32
#define __GCC_HAS_BUILTIN___builtin_ceilf64
#define __GCC_HAS_BUILTIN___builtin_ceilf128
#define __GCC_HAS_BUILTIN___builtin_ceilf32x
#define __GCC_HAS_BUILTIN___builtin_ceilf64x
#define __GCC_HAS_BUILTIN___builtin_ceilf128x
#define __GCC_HAS_BUILTIN___builtin_feclearexcept
#define __GCC_HAS_BUILTIN___builtin_fegetenv
#define __GCC_HAS_BUILTIN___builtin_fegetexceptflag
#define __GCC_HAS_BUILTIN___builtin_fegetround
#define __GCC_HAS_BUILTIN___builtin_feholdexcept
#define __GCC_HAS_BUILTIN___builtin_feraiseexcept
#define __GCC_HAS_BUILTIN___builtin_fesetenv
#define __GCC_HAS_BUILTIN___builtin_fesetexceptflag
#define __GCC_HAS_BUILTIN___builtin_fesetround
#define __GCC_HAS_BUILTIN___builtin_fetestexcept
#define __GCC_HAS_BUILTIN___builtin_feupdateenv
#define __GCC_HAS_BUILTIN___builtin_floorf16
#define __GCC_HAS_BUILTIN___builtin_floorf32
#define __GCC_HAS_BUILTIN___builtin_floorf64
#define __GCC_HAS_BUILTIN___builtin_floorf128
#define __GCC_HAS_BUILTIN___builtin_floorf32x
#define __GCC_HAS_BUILTIN___builtin_floorf64x
#define __GCC_HAS_BUILTIN___builtin_floorf128x
#define __GCC_HAS_BUILTIN___builtin_fmaf16
#define __GCC_HAS_BUILTIN___builtin_fmaf32
#define __GCC_HAS_BUILTIN___builtin_fmaf64
#define __GCC_HAS_BUILTIN___builtin_fmaf128
#define __GCC_HAS_BUILTIN___builtin_fmaf32x
#define __GCC_HAS_BUILTIN___builtin_fmaf64x
#define __GCC_HAS_BUILTIN___builtin_fmaf128x
#define __GCC_HAS_BUILTIN___builtin_fmaxf16
#define __GCC_HAS_BUILTIN___builtin_fmaxf32
#define __GCC_HAS_BUILTIN___builtin_fmaxf64
#define __GCC_HAS_BUILTIN___builtin_fmaxf128
#define __GCC_HAS_BUILTIN___builtin_fmaxf32x
#define __GCC_HAS_BUILTIN___builtin_fmaxf64x
#define __GCC_HAS_BUILTIN___builtin_fmaxf128x
#define __GCC_HAS_BUILTIN___builtin_fminf16
#define __GCC_HAS_BUILTIN___builtin_fminf32
#define __GCC_HAS_BUILTIN___builtin_fminf64
#define __GCC_HAS_BUILTIN___builtin_fminf128
#define __GCC_HAS_BUILTIN___builtin_fminf32x
#define __GCC_HAS_BUILTIN___builtin_fminf64x
#define __GCC_HAS_BUILTIN___builtin_fminf128x
#define __GCC_HAS_BUILTIN___builtin_nearbyintf16
#define __GCC_HAS_BUILTIN___builtin_nearbyintf32
#define __GCC_HAS_BUILTIN___builtin_nearbyintf64
#define __GCC_HAS_BUILTIN___builtin_nearbyintf128
#define __GCC_HAS_BUILTIN___builtin_nearbyintf32x
#define __GCC_HAS_BUILTIN___builtin_nearbyintf64x
#define __GCC_HAS_BUILTIN___builtin_nearbyintf128x
#define __GCC_HAS_BUILTIN___builtin_rintf16
#define __GCC_HAS_BUILTIN___builtin_rintf32
#define __GCC_HAS_BUILTIN___builtin_rintf64
#define __GCC_HAS_BUILTIN___builtin_rintf128
#define __GCC_HAS_BUILTIN___builtin_rintf32x
#define __GCC_HAS_BUILTIN___builtin_rintf64x
#define __GCC_HAS_BUILTIN___builtin_rintf128x
#define __GCC_HAS_BUILTIN___builtin_roundf16
#define __GCC_HAS_BUILTIN___builtin_roundf32
#define __GCC_HAS_BUILTIN___builtin_roundf64
#define __GCC_HAS_BUILTIN___builtin_roundf128
#define __GCC_HAS_BUILTIN___builtin_roundf32x
#define __GCC_HAS_BUILTIN___builtin_roundf64x
#define __GCC_HAS_BUILTIN___builtin_roundf128x
#define __GCC_HAS_BUILTIN___builtin_sqrtf16
#define __GCC_HAS_BUILTIN___builtin_sqrtf32
#define __GCC_HAS_BUILTIN___builtin_sqrtf64
#define __GCC_HAS_BUILTIN___builtin_sqrtf128
#define __GCC_HAS_BUILTIN___builtin_sqrtf32x
#define __GCC_HAS_BUILTIN___builtin_sqrtf64x
#define __GCC_HAS_BUILTIN___builtin_sqrtf128x
#define __GCC_HAS_BUILTIN___builtin_truncf16
#define __GCC_HAS_BUILTIN___builtin_truncf32
#define __GCC_HAS_BUILTIN___builtin_truncf64
#define __GCC_HAS_BUILTIN___builtin_truncf128
#define __GCC_HAS_BUILTIN___builtin_truncf32x
#define __GCC_HAS_BUILTIN___builtin_truncf64x
#define __GCC_HAS_BUILTIN___builtin_truncf128x
#define __GCC_HAS_BUILTIN___builtin_alloca_with_align_and_max
#if defined(_OPENACC) || defined(_OPENMP)
#define __GCC_HAS_BUILTIN___builtin_omp_get_thread_num
#define __GCC_HAS_BUILTIN___builtin_omp_get_num_threads
#define __GCC_HAS_BUILTIN___builtin_omp_get_team_num
#define __GCC_HAS_BUILTIN___builtin_omp_get_num_teams
#define __GCC_HAS_BUILTIN___builtin_GOMP_atomic_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_atomic_end
#define __GCC_HAS_BUILTIN___builtin_GOMP_barrier
#define __GCC_HAS_BUILTIN___builtin_GOMP_barrier_cancel
#define __GCC_HAS_BUILTIN___builtin_GOMP_taskwait
#define __GCC_HAS_BUILTIN___builtin_GOMP_taskyield
#define __GCC_HAS_BUILTIN___builtin_GOMP_taskgroup_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_taskgroup_end
#define __GCC_HAS_BUILTIN___builtin_GOMP_cancel
#define __GCC_HAS_BUILTIN___builtin_GOMP_cancellation_point
#define __GCC_HAS_BUILTIN___builtin_GOMP_critical_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_critical_end
#define __GCC_HAS_BUILTIN___builtin_GOMP_critical_name_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_critical_name_end
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_static_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_dynamic_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_guided_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_runtime_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_nonmonotonic_dynamic_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_nonmonotonic_guided_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ordered_static_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ordered_dynamic_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ordered_guided_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ordered_runtime_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_doacross_static_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_doacross_dynamic_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_doacross_guided_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_doacross_runtime_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_static_next
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_dynamic_next
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_guided_next
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_runtime_next
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_nonmonotonic_dynamic_next
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_nonmonotonic_guided_next
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ordered_static_next
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ordered_dynamic_next
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ordered_guided_next
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ordered_runtime_next
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_static_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_dynamic_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_guided_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_runtime_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_nonmonotonic_dynamic_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_nonmonotonic_guided_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_ordered_static_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_ordered_dynamic_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_ordered_guided_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_ordered_runtime_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_doacross_static_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_doacross_dynamic_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_doacross_guided_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_doacross_runtime_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_static_next
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_dynamic_next
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_guided_next
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_runtime_next
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_nonmonotonic_dynamic_next
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_nonmonotonic_guided_next
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_ordered_static_next
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_ordered_dynamic_next
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_ordered_guided_next
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_ordered_runtime_next
#define __GCC_HAS_BUILTIN___builtin_GOMP_parallel_loop_static
#define __GCC_HAS_BUILTIN___builtin_GOMP_parallel_loop_dynamic
#define __GCC_HAS_BUILTIN___builtin_GOMP_parallel_loop_guided
#define __GCC_HAS_BUILTIN___builtin_GOMP_parallel_loop_runtime
#define __GCC_HAS_BUILTIN___builtin_GOMP_parallel_loop_nonmonotonic_dynamic
#define __GCC_HAS_BUILTIN___builtin_GOMP_parallel_loop_nonmonotonic_guided
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_end
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_end_cancel
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_end_nowait
#define __GCC_HAS_BUILTIN___builtin_GOMP_ordered_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_ordered_end
#define __GCC_HAS_BUILTIN___builtin_GOMP_doacross_post
#define __GCC_HAS_BUILTIN___builtin_GOMP_doacross_wait
#define __GCC_HAS_BUILTIN___builtin_GOMP_doacross_ull_post
#define __GCC_HAS_BUILTIN___builtin_GOMP_doacross_ull_wait
#define __GCC_HAS_BUILTIN___builtin_GOMP_parallel
#define __GCC_HAS_BUILTIN___builtin_GOMP_task
#define __GCC_HAS_BUILTIN___builtin_GOMP_taskloop
#define __GCC_HAS_BUILTIN___builtin_GOMP_taskloop_ull
#define __GCC_HAS_BUILTIN___builtin_GOMP_sections_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_sections_next
#define __GCC_HAS_BUILTIN___builtin_GOMP_parallel_sections
#define __GCC_HAS_BUILTIN___builtin_GOMP_sections_end
#define __GCC_HAS_BUILTIN___builtin_GOMP_sections_end_cancel
#define __GCC_HAS_BUILTIN___builtin_GOMP_sections_end_nowait
#define __GCC_HAS_BUILTIN___builtin_GOMP_single_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_single_copy_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_single_copy_end
#define __GCC_HAS_BUILTIN___builtin_GOMP_offload_register_ver
#define __GCC_HAS_BUILTIN___builtin_GOMP_offload_unregister_ver
#define __GCC_HAS_BUILTIN___builtin_GOMP_target_ext
#define __GCC_HAS_BUILTIN___builtin_GOMP_target_data_ext
#define __GCC_HAS_BUILTIN___builtin_GOMP_target_end_data
#define __GCC_HAS_BUILTIN___builtin_GOMP_target_update_ext
#define __GCC_HAS_BUILTIN___builtin_GOMP_target_enter_exit_data
#define __GCC_HAS_BUILTIN___builtin_GOMP_teams
#endif /* defined(_OPENACC) || defined(_OPENMP) */
#endif /* __GCC_VERSION_NUM >= 80001 */

#if __GCC_VERSION_NUM >= 90001
#undef __GCC_HAS_BUILTIN___chkp_intersect
#undef __GCC_HAS_BUILTIN___chkp_sizeof
#undef __GCC_HAS_BUILTIN___chkp_narrow
#undef __GCC_HAS_BUILTIN___builtin___chkp_bndcl
#undef __GCC_HAS_BUILTIN___builtin___chkp_bndcu
#undef __GCC_HAS_BUILTIN___builtin___chkp_bndstx
#undef __GCC_HAS_BUILTIN___builtin___chkp_bndldx
#undef __GCC_HAS_BUILTIN___builtin___chkp_bndret
#undef __GCC_HAS_BUILTIN___builtin___chkp_bndmk
#undef __GCC_HAS_BUILTIN___builtin___chkp_extract_lower
#undef __GCC_HAS_BUILTIN___builtin___chkp_extract_upper
#undef __GCC_HAS_BUILTIN___builtin___bnd_set_ptr_bounds
#undef __GCC_HAS_BUILTIN___builtin___bnd_init_ptr_bounds
#undef __GCC_HAS_BUILTIN___builtin___bnd_null_ptr_bounds
#undef __GCC_HAS_BUILTIN___builtin___bnd_copy_ptr_bounds
#undef __GCC_HAS_BUILTIN___builtin___bnd_narrow_ptr_bounds
#undef __GCC_HAS_BUILTIN___builtin___bnd_store_ptr_bounds
#undef __GCC_HAS_BUILTIN___builtin___bnd_chk_ptr_lbounds
#undef __GCC_HAS_BUILTIN___builtin___bnd_chk_ptr_ubounds
#undef __GCC_HAS_BUILTIN___builtin___bnd_chk_ptr_bounds
#undef __GCC_HAS_BUILTIN___builtin___bnd_get_ptr_lbound
#undef __GCC_HAS_BUILTIN___builtin___bnd_get_ptr_ubound
#undef __GCC_HAS_BUILTIN___builtin_chkp_memcpy_nobnd
#undef __GCC_HAS_BUILTIN___builtin_chkp_memcpy_nochk
#undef __GCC_HAS_BUILTIN___builtin_chkp_memcpy_nobnd_nochk
#undef __GCC_HAS_BUILTIN___builtin_chkp_memmove_nobnd
#undef __GCC_HAS_BUILTIN___builtin_chkp_memmove_nochk
#undef __GCC_HAS_BUILTIN___builtin_chkp_memmove_nobnd_nochk
#undef __GCC_HAS_BUILTIN___builtin_chkp_mempcpy_nobnd
#undef __GCC_HAS_BUILTIN___builtin_chkp_mempcpy_nochk
#undef __GCC_HAS_BUILTIN___builtin_chkp_mempcpy_nobnd_nochk
#undef __GCC_HAS_BUILTIN___builtin_chkp_memset_nobnd
#undef __GCC_HAS_BUILTIN___builtin_chkp_memset_nochk
#undef __GCC_HAS_BUILTIN___builtin_chkp_memset_nobnd_nochk
#define __GCC_HAS_BUILTIN___builtin_strnlen
#define __GCC_HAS_BUILTIN___builtin_expect_with_probability
#define __GCC_HAS_BUILTIN___builtin_strcmp_eq
#define __GCC_HAS_BUILTIN___builtin_strncmp_eq
#define __GCC_HAS_BUILTIN___builtin_speculation_safe_value
#define __GCC_HAS_BUILTIN___builtin_speculation_safe_value_ptr
#define __GCC_HAS_BUILTIN___builtin_speculation_safe_value_1
#define __GCC_HAS_BUILTIN___builtin_speculation_safe_value_2
#define __GCC_HAS_BUILTIN___builtin_speculation_safe_value_4
#define __GCC_HAS_BUILTIN___builtin_speculation_safe_value_8
#define __GCC_HAS_BUILTIN___builtin_speculation_safe_value_16
#ifdef _OPENACC
#define __GCC_HAS_BUILTIN___builtin_goacc_parlevel_id
#define __GCC_HAS_BUILTIN___builtin_goacc_parlevel_size
#endif /* _OPENACC */
#if defined(_OPENACC) || defined(_OPENMP)
#define __GCC_HAS_BUILTIN___builtin_GOMP_taskwait_depend
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_nonmonotonic_runtime_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_maybe_nonmonotonic_runtime_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ordered_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_doacross_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_nonmonotonic_runtime_next
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_maybe_nonmonotonic_runtime_next
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_nonmonotonic_runtime_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_maybe_nonmonotonic_runtime_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_ordered_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_doacross_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_nonmonotonic_runtime_next
#define __GCC_HAS_BUILTIN___builtin_GOMP_loop_ull_maybe_nonmonotonic_runtime_next
#define __GCC_HAS_BUILTIN___builtin_GOMP_parallel_loop_nonmonotonic_runtime
#define __GCC_HAS_BUILTIN___builtin_GOMP_parallel_loop_maybe_nonmonotonic_runtime
#define __GCC_HAS_BUILTIN___builtin_GOMP_parallel_reductions
#define __GCC_HAS_BUILTIN___builtin_GOMP_sections2_start
#define __GCC_HAS_BUILTIN___builtin_GOMP_teams_reg
#define __GCC_HAS_BUILTIN___builtin_GOMP_taskgroup_reduction_register
#define __GCC_HAS_BUILTIN___builtin_GOMP_taskgroup_reduction_unregister
#define __GCC_HAS_BUILTIN___builtin_GOMP_task_reduction_remap
#define __GCC_HAS_BUILTIN___builtin_GOMP_workshare_task_reduction_unregister
#endif /* defined(_OPENACC) || defined(_OPENMP) */
#endif /* __GCC_VERSION_NUM >= 90001 */
#endif /* !__has_builtin */
