/* HASH CRC-32:0x7bee785e */
/* Copyright (c) 2019-2024 Griefer@Work                                       *
 *                                                                            *
 * This software is provided 'as-is', without any express or implied          *
 * warranty. In no event will the authors be held liable for any damages      *
 * arising from the use of this software.                                     *
 *                                                                            *
 * Permission is granted to anyone to use this software for any purpose,      *
 * including commercial applications, and to alter it and redistribute it     *
 * freely, subject to the following restrictions:                             *
 *                                                                            *
 * 1. The origin of this software must not be misrepresented; you must not    *
 *    claim that you wrote the original software. If you use this software    *
 *    in a product, an acknowledgement (see the following) in the product     *
 *    documentation is required:                                              *
 *    Portions Copyright (c) 2019-2024 Griefer@Work                           *
 * 2. Altered source versions must be plainly marked as such, and must not be *
 *    misrepresented as being the original software.                          *
 * 3. This notice may not be removed or altered from any source distribution. *
 */
/* (#) Portability: GNU C Library (/bits/posix_opt.h) */
/* (#) Portability: mintlib       (/include/bits/posix_opt.h) */
#ifndef _BITS_POSIX_OPT_H
#define _BITS_POSIX_OPT_H 1

#include <__stdinc.h>
#include <__crt.h>

#ifdef __COMPILER_HAVE_PRAGMA_GCC_SYSTEM_HEADER
#pragma GCC system_header
#endif /* __COMPILER_HAVE_PRAGMA_GCC_SYSTEM_HEADER */


/* NOTE: This file must _always_ be kept for Glibc compatibility! */

#include <features.h>
#include <asm/os/termios.h> /* __VDISABLE */

#ifndef __VDISABLE
#define __VDISABLE '\0'
#endif /* !__VDISABLE */

#include <asm/os/tty.h>
#include <bits/types.h>
#if (defined(__CRT_HAVE_setpgid) || defined(__CRT_HAVE___setpgid) || defined(__CRT_HAVE___libc_setpgid)) && (defined(__CRT_HAVE_tcdrain) || ((defined(__CRT_HAVE_ioctl) || defined(__CRT_HAVE___ioctl) || defined(__CRT_HAVE___libc_ioctl) || defined(__CRT_HAVE___ioctl_time64)) && defined(__TCSBRK))) && (defined(__CRT_HAVE_tcflush) || ((defined(__CRT_HAVE_ioctl) || defined(__CRT_HAVE___ioctl) || defined(__CRT_HAVE___libc_ioctl) || defined(__CRT_HAVE___ioctl_time64)) && defined(__TCFLSH))) && (defined(__CRT_HAVE_tcgetpgrp) || ((defined(__CRT_HAVE_ioctl) || defined(__CRT_HAVE___ioctl) || defined(__CRT_HAVE___libc_ioctl) || defined(__CRT_HAVE___ioctl_time64)) && defined(__TIOCGPGRP))) && (defined(__CRT_HAVE_tcsendbreak) || ((defined(__CRT_HAVE_ioctl) || defined(__CRT_HAVE___ioctl) || defined(__CRT_HAVE___libc_ioctl) || defined(__CRT_HAVE___ioctl_time64)) && defined(__TCSBRKP))) && (defined(__CRT_HAVE_tcsetattr) || defined(__CRT_HAVE_ioctl) || defined(__CRT_HAVE___ioctl) || defined(__CRT_HAVE___libc_ioctl) || defined(__CRT_HAVE___ioctl_time64)) && (defined(__CRT_HAVE_tcsetpgrp) || ((defined(__CRT_HAVE_ioctl) || defined(__CRT_HAVE___ioctl) || defined(__CRT_HAVE___libc_ioctl) || defined(__CRT_HAVE___ioctl_time64)) && defined(__TIOCSPGRP)))
#define _POSIX_JOB_CONTROL                   1 /* Job control is supported. */
#endif /* (__CRT_HAVE_setpgid || __CRT_HAVE___setpgid || __CRT_HAVE___libc_setpgid) && (__CRT_HAVE_tcdrain || ((__CRT_HAVE_ioctl || __CRT_HAVE___ioctl || __CRT_HAVE___libc_ioctl || __CRT_HAVE___ioctl_time64) && __TCSBRK)) && (__CRT_HAVE_tcflush || ((__CRT_HAVE_ioctl || __CRT_HAVE___ioctl || __CRT_HAVE___libc_ioctl || __CRT_HAVE___ioctl_time64) && __TCFLSH)) && (__CRT_HAVE_tcgetpgrp || ((__CRT_HAVE_ioctl || __CRT_HAVE___ioctl || __CRT_HAVE___libc_ioctl || __CRT_HAVE___ioctl_time64) && __TIOCGPGRP)) && (__CRT_HAVE_tcsendbreak || ((__CRT_HAVE_ioctl || __CRT_HAVE___ioctl || __CRT_HAVE___libc_ioctl || __CRT_HAVE___ioctl_time64) && __TCSBRKP)) && (__CRT_HAVE_tcsetattr || __CRT_HAVE_ioctl || __CRT_HAVE___ioctl || __CRT_HAVE___libc_ioctl || __CRT_HAVE___ioctl_time64) && (__CRT_HAVE_tcsetpgrp || ((__CRT_HAVE_ioctl || __CRT_HAVE___ioctl || __CRT_HAVE___libc_ioctl || __CRT_HAVE___ioctl_time64) && __TIOCSPGRP)) */
#if (defined(__CRT_HAVE_geteuid) || defined(__CRT_HAVE___geteuid) || defined(__CRT_HAVE___libc_geteuid) || defined(__CRT_HAVE_getresuid)) && (defined(__CRT_HAVE_getegid) || defined(__CRT_HAVE___getegid) || defined(__CRT_HAVE___libc_getegid) || defined(__CRT_HAVE_getresgid)) && (defined(__CRT_HAVE_getgid) || defined(__CRT_HAVE___getgid) || defined(__CRT_HAVE___libc_getgid) || defined(__CRT_HAVE_getresgid)) && (defined(__CRT_HAVE_getuid) || defined(__CRT_HAVE___getuid) || defined(__CRT_HAVE___libc_getuid) || defined(__CRT_HAVE_getresuid)) && (defined(__CRT_HAVE_seteuid) || defined(__CRT_HAVE_setreuid) || defined(__CRT_HAVE___setreuid) || defined(__CRT_HAVE___libc_setreuid) || defined(__CRT_HAVE_setresuid)) && (defined(__CRT_HAVE_setegid) || defined(__CRT_HAVE_setregid) || defined(__CRT_HAVE___setregid) || defined(__CRT_HAVE___libc_setregid) || defined(__CRT_HAVE_setresgid)) && (defined(__CRT_HAVE_setgid) || defined(__CRT_HAVE___setgid) || defined(__CRT_HAVE___libc_setgid) || defined(__CRT_HAVE_setreuid) || defined(__CRT_HAVE___setreuid) || defined(__CRT_HAVE___libc_setreuid) || defined(__CRT_HAVE_setresuid)) && (defined(__CRT_HAVE_setuid) || defined(__CRT_HAVE___setuid) || defined(__CRT_HAVE___libc_setuid) || defined(__CRT_HAVE_setreuid) || defined(__CRT_HAVE___setreuid) || defined(__CRT_HAVE___libc_setreuid) || defined(__CRT_HAVE_setresuid))
#define _POSIX_SAVED_IDS                     1 /* Processes have a saved set-user-ID and a saved set-group-ID. */
#endif /* (__CRT_HAVE_geteuid || __CRT_HAVE___geteuid || __CRT_HAVE___libc_geteuid || __CRT_HAVE_getresuid) && (__CRT_HAVE_getegid || __CRT_HAVE___getegid || __CRT_HAVE___libc_getegid || __CRT_HAVE_getresgid) && (__CRT_HAVE_getgid || __CRT_HAVE___getgid || __CRT_HAVE___libc_getgid || __CRT_HAVE_getresgid) && (__CRT_HAVE_getuid || __CRT_HAVE___getuid || __CRT_HAVE___libc_getuid || __CRT_HAVE_getresuid) && (__CRT_HAVE_seteuid || __CRT_HAVE_setreuid || __CRT_HAVE___setreuid || __CRT_HAVE___libc_setreuid || __CRT_HAVE_setresuid) && (__CRT_HAVE_setegid || __CRT_HAVE_setregid || __CRT_HAVE___setregid || __CRT_HAVE___libc_setregid || __CRT_HAVE_setresgid) && (__CRT_HAVE_setgid || __CRT_HAVE___setgid || __CRT_HAVE___libc_setgid || __CRT_HAVE_setreuid || __CRT_HAVE___setreuid || __CRT_HAVE___libc_setreuid || __CRT_HAVE_setresuid) && (__CRT_HAVE_setuid || __CRT_HAVE___setuid || __CRT_HAVE___libc_setuid || __CRT_HAVE_setreuid || __CRT_HAVE___setreuid || __CRT_HAVE___libc_setreuid || __CRT_HAVE_setresuid) */
#if (defined(__CRT_HAVE_sched_getparam) || defined(__CRT_HAVE___sched_getparam) || defined(__CRT_HAVE___libc_sched_getparam)) && (defined(__CRT_HAVE_sched_setparam) || defined(__CRT_HAVE___sched_setparam) || defined(__CRT_HAVE___libc_sched_setparam)) && (defined(__CRT_HAVE_sched_get_priority_max) || defined(__CRT_HAVE___sched_get_priority_max) || defined(__CRT_HAVE___libc_sched_get_priority_max)) && (defined(__CRT_HAVE_sched_get_priority_min) || defined(__CRT_HAVE___sched_get_priority_min) || defined(__CRT_HAVE___libc_sched_get_priority_min)) && (defined(__CRT_HAVE_sched_getscheduler) || defined(__CRT_HAVE___sched_getscheduler) || defined(__CRT_HAVE___libc_sched_getscheduler)) && (defined(__CRT_HAVE_sched_setscheduler) || defined(__CRT_HAVE___sched_setscheduler) || defined(__CRT_HAVE___libc_sched_setscheduler)) && (defined(__CRT_HAVE_sched_rr_get_interval64) || defined(__CRT_HAVE___sched_rr_get_interval64) || defined(__CRT_HAVE_sched_rr_get_interval) || defined(__CRT_HAVE___sched_rr_get_interval) || defined(__CRT_HAVE___libc_sched_rr_get_interval))
#define _POSIX_PRIORITY_SCHEDULING           200809L /* Priority scheduling is supported. */
#endif /* (__CRT_HAVE_sched_getparam || __CRT_HAVE___sched_getparam || __CRT_HAVE___libc_sched_getparam) && (__CRT_HAVE_sched_setparam || __CRT_HAVE___sched_setparam || __CRT_HAVE___libc_sched_setparam) && (__CRT_HAVE_sched_get_priority_max || __CRT_HAVE___sched_get_priority_max || __CRT_HAVE___libc_sched_get_priority_max) && (__CRT_HAVE_sched_get_priority_min || __CRT_HAVE___sched_get_priority_min || __CRT_HAVE___libc_sched_get_priority_min) && (__CRT_HAVE_sched_getscheduler || __CRT_HAVE___sched_getscheduler || __CRT_HAVE___libc_sched_getscheduler) && (__CRT_HAVE_sched_setscheduler || __CRT_HAVE___sched_setscheduler || __CRT_HAVE___libc_sched_setscheduler) && (__CRT_HAVE_sched_rr_get_interval64 || __CRT_HAVE___sched_rr_get_interval64 || __CRT_HAVE_sched_rr_get_interval || __CRT_HAVE___sched_rr_get_interval || __CRT_HAVE___libc_sched_rr_get_interval) */
#define _POSIX_FSYNC                         200809L /* The fsync function is present. */
#define _POSIX_SYNCHRONIZED_IO               200809L /* Synchronizing file data is supported. */
#if (defined(__CRT_HAVE_mmap64) || defined(__CRT_HAVE_mmap) || defined(__CRT_HAVE___mmap)) && (defined(__CRT_HAVE_msync) || defined(__CRT_HAVE___msync) || defined(__CRT_HAVE___libc_msync)) && (defined(__CRT_HAVE_munmap) || defined(__CRT_HAVE___munmap) || defined(__CRT_HAVE___libc_munmap))
#define _POSIX_MAPPED_FILES                  200809L /* Mapping of files to memory is supported. */
#endif /* (__CRT_HAVE_mmap64 || __CRT_HAVE_mmap || __CRT_HAVE___mmap) && (__CRT_HAVE_msync || __CRT_HAVE___msync || __CRT_HAVE___libc_msync) && (__CRT_HAVE_munmap || __CRT_HAVE___munmap || __CRT_HAVE___libc_munmap) */
#if (defined(__CRT_HAVE_mlockall) || defined(__CRT_HAVE___mlockall) || defined(__CRT_HAVE___libc_mlockall)) && (defined(__CRT_HAVE_munlockall) || defined(__CRT_HAVE___munlockall) || defined(__CRT_HAVE___libc_munlockall))
#define _POSIX_MEMLOCK                       200809L /* Locking of all memory is supported. */
#endif /* (__CRT_HAVE_mlockall || __CRT_HAVE___mlockall || __CRT_HAVE___libc_mlockall) && (__CRT_HAVE_munlockall || __CRT_HAVE___munlockall || __CRT_HAVE___libc_munlockall) */
#if (defined(__CRT_HAVE_mlock) || defined(__CRT_HAVE___mlock) || defined(__CRT_HAVE___libc_mlock)) && (defined(__CRT_HAVE_munlock) || defined(__CRT_HAVE___munlock) || defined(__CRT_HAVE___libc_munlock))
#define _POSIX_MEMLOCK_RANGE                 200809L /* Locking of ranges of memory is supported. */
#endif /* (__CRT_HAVE_mlock || __CRT_HAVE___mlock || __CRT_HAVE___libc_mlock) && (__CRT_HAVE_munlock || __CRT_HAVE___munlock || __CRT_HAVE___libc_munlock) */
#if defined(__CRT_HAVE_mprotect) || defined(__CRT_HAVE___mprotect) || defined(__CRT_HAVE___libc_mprotect)
#define _POSIX_MEMORY_PROTECTION             200809L /* Setting of memory protections is supported. */
#endif /* __CRT_HAVE_mprotect || __CRT_HAVE___mprotect || __CRT_HAVE___libc_mprotect */
#define _POSIX_CHOWN_RESTRICTED              0       /* Some filesystems allow all users to change file ownership. */
#ifndef _POSIX_VDISABLE
#define _POSIX_VDISABLE                      __VDISABLE /* `c_cc' member of `struct termios' structure can be disabled by using the value _POSIX_VDISABLE. */
#endif /* !_POSIX_VDISABLE */
#define _POSIX_NO_TRUNC                      1       /* Filenames are not silently truncated. */
#if 0
#define _XOPEN_REALTIME                      1       /* X/Open realtime support is available. */
#define _XOPEN_REALTIME_THREADS              1       /* X/Open thread realtime support is available. */
#endif
#define _XOPEN_SHM                           1       /* XPG4.2 shared memory is supported. */
#if defined(__CRT_HAVE_pthread_self) || defined(__CRT_HAVE_thrd_current) || defined(__CRT_HAVE_thr_self) || defined(__CRT_HAVE_cthread_self)
#define _POSIX_THREADS                       200809L /* Tell we have POSIX threads. */
#endif /* __CRT_HAVE_pthread_self || __CRT_HAVE_thrd_current || __CRT_HAVE_thr_self || __CRT_HAVE_cthread_self */
#define _POSIX_REENTRANT_FUNCTIONS           1       /* We have the reentrant functions described in POSIX. */
#include <bits/os/dirent.h>
#include <libc/template/stdstreams.h>
#if ((defined(__CRT_HAVE_readdirk_r) && defined(__CRT_KOS) && (!defined(__USE_FILE_OFFSET64) || defined(_DIRENT_MATCHES_DIRENT64))) || (defined(__CRT_HAVE_readdirk64_r) && defined(__CRT_KOS) && (defined(__USE_FILE_OFFSET64) || defined(_DIRENT_MATCHES_DIRENT64))) || (defined(__CRT_HAVE_readdir_r) && !defined(__CRT_KOS) && (!defined(__USE_FILE_OFFSET64) || defined(_DIRENT_MATCHES_DIRENT64))) || (defined(__CRT_HAVE___libc_readdir_r) && !defined(__CRT_KOS) && (!defined(__USE_FILE_OFFSET64) || defined(_DIRENT_MATCHES_DIRENT64))) || (defined(__CRT_HAVE_readdir64_r) && !defined(__CRT_KOS) && (defined(__USE_FILE_OFFSET64) || defined(_DIRENT_MATCHES_DIRENT64)))) && defined(__CRT_HAVE_getgrgid_r) && defined(__CRT_HAVE_getgrnam_r) && defined(__CRT_HAVE_getpwnam_r) && defined(__CRT_HAVE_getpwuid_r) && (defined(__CRT_HAVE_flockfile) || defined(__CRT_HAVE__lock_file) || defined(__CRT_HAVE__IO_flockfile)) && (defined(__CRT_HAVE_ftrylockfile) || defined(__CRT_HAVE__IO_ftrylockfile)) && (defined(__CRT_HAVE_funlockfile) || defined(__CRT_HAVE__unlock_file) || defined(__CRT_HAVE__IO_funlockfile)) && (defined(__CRT_HAVE_fgetc_unlocked) || defined(__CRT_HAVE_getc_unlocked) || defined(__CRT_HAVE__getc_nolock) || defined(__CRT_HAVE__fgetc_nolock) || (defined(__CRT_HAVE_getc) && (!defined(__CRT_DOS) || (!defined(__CRT_HAVE__filbuf) && !defined(__CRT_HAVE___uflow) && !defined(__CRT_HAVE___underflow) && !defined(__CRT_HAVE___srget)))) || (defined(__CRT_HAVE_fgetc) && (!defined(__CRT_DOS) || (!defined(__CRT_HAVE__filbuf) && !defined(__CRT_HAVE___uflow) && !defined(__CRT_HAVE___underflow) && !defined(__CRT_HAVE___srget)))) || (defined(__CRT_HAVE__IO_getc) && (!defined(__CRT_DOS) || (!defined(__CRT_HAVE__filbuf) && !defined(__CRT_HAVE___uflow) && !defined(__CRT_HAVE___underflow) && !defined(__CRT_HAVE___srget)))) || (defined(__CRT_DOS) && (defined(__CRT_HAVE__filbuf) || defined(__CRT_HAVE___uflow) || defined(__CRT_HAVE___underflow) || defined(__CRT_HAVE___srget))) || defined(__CRT_HAVE_fread) || defined(__CRT_HAVE__IO_fread) || defined(__CRT_HAVE_fread_unlocked) || defined(__CRT_HAVE__fread_nolock)) && (defined(__CRT_HAVE_getchar_unlocked) || defined(__LOCAL_stdin)) && (defined(__CRT_HAVE_putc_unlocked) || defined(__CRT_HAVE_fputc_unlocked) || defined(__CRT_HAVE__putc_nolock) || defined(__CRT_HAVE__fputc_nolock) || (defined(__CRT_HAVE_putc) && (!defined(__CRT_DOS) || (!defined(__CRT_HAVE__flsbuf) && !defined(__CRT_HAVE___swbuf)))) || (defined(__CRT_HAVE_fputc) && (!defined(__CRT_DOS) || (!defined(__CRT_HAVE__flsbuf) && !defined(__CRT_HAVE___swbuf)))) || (defined(__CRT_HAVE__IO_putc) && (!defined(__CRT_DOS) || (!defined(__CRT_HAVE__flsbuf) && !defined(__CRT_HAVE___swbuf)))) || (defined(__CRT_DOS) && (defined(__CRT_HAVE__flsbuf) || defined(__CRT_HAVE___swbuf))) || defined(__CRT_HAVE_fwrite) || defined(__CRT_HAVE__IO_fwrite) || defined(__CRT_HAVE_fwrite_s) || defined(__CRT_HAVE_fwrite_unlocked) || defined(__CRT_HAVE__fwrite_nolock)) && (defined(__CRT_HAVE_putchar_unlocked) || defined(__LOCAL_stdout))
#define _POSIX_THREAD_SAFE_FUNCTIONS         200809L
#endif /* ((__CRT_HAVE_readdirk_r && __CRT_KOS && (!__USE_FILE_OFFSET64 || _DIRENT_MATCHES_DIRENT64)) || (__CRT_HAVE_readdirk64_r && __CRT_KOS && (__USE_FILE_OFFSET64 || _DIRENT_MATCHES_DIRENT64)) || (__CRT_HAVE_readdir_r && !__CRT_KOS && (!__USE_FILE_OFFSET64 || _DIRENT_MATCHES_DIRENT64)) || (__CRT_HAVE___libc_readdir_r && !__CRT_KOS && (!__USE_FILE_OFFSET64 || _DIRENT_MATCHES_DIRENT64)) || (__CRT_HAVE_readdir64_r && !__CRT_KOS && (__USE_FILE_OFFSET64 || _DIRENT_MATCHES_DIRENT64))) && __CRT_HAVE_getgrgid_r && __CRT_HAVE_getgrnam_r && __CRT_HAVE_getpwnam_r && __CRT_HAVE_getpwuid_r && (__CRT_HAVE_flockfile || __CRT_HAVE__lock_file || __CRT_HAVE__IO_flockfile) && (__CRT_HAVE_ftrylockfile || __CRT_HAVE__IO_ftrylockfile) && (__CRT_HAVE_funlockfile || __CRT_HAVE__unlock_file || __CRT_HAVE__IO_funlockfile) && (__CRT_HAVE_fgetc_unlocked || __CRT_HAVE_getc_unlocked || __CRT_HAVE__getc_nolock || __CRT_HAVE__fgetc_nolock || (__CRT_HAVE_getc && (!__CRT_DOS || (!__CRT_HAVE__filbuf && !__CRT_HAVE___uflow && !__CRT_HAVE___underflow && !__CRT_HAVE___srget))) || (__CRT_HAVE_fgetc && (!__CRT_DOS || (!__CRT_HAVE__filbuf && !__CRT_HAVE___uflow && !__CRT_HAVE___underflow && !__CRT_HAVE___srget))) || (__CRT_HAVE__IO_getc && (!__CRT_DOS || (!__CRT_HAVE__filbuf && !__CRT_HAVE___uflow && !__CRT_HAVE___underflow && !__CRT_HAVE___srget))) || (__CRT_DOS && (__CRT_HAVE__filbuf || __CRT_HAVE___uflow || __CRT_HAVE___underflow || __CRT_HAVE___srget)) || __CRT_HAVE_fread || __CRT_HAVE__IO_fread || __CRT_HAVE_fread_unlocked || __CRT_HAVE__fread_nolock) && (__CRT_HAVE_getchar_unlocked || __LOCAL_stdin) && (__CRT_HAVE_putc_unlocked || __CRT_HAVE_fputc_unlocked || __CRT_HAVE__putc_nolock || __CRT_HAVE__fputc_nolock || (__CRT_HAVE_putc && (!__CRT_DOS || (!__CRT_HAVE__flsbuf && !__CRT_HAVE___swbuf))) || (__CRT_HAVE_fputc && (!__CRT_DOS || (!__CRT_HAVE__flsbuf && !__CRT_HAVE___swbuf))) || (__CRT_HAVE__IO_putc && (!__CRT_DOS || (!__CRT_HAVE__flsbuf && !__CRT_HAVE___swbuf))) || (__CRT_DOS && (__CRT_HAVE__flsbuf || __CRT_HAVE___swbuf)) || __CRT_HAVE_fwrite || __CRT_HAVE__IO_fwrite || __CRT_HAVE_fwrite_s || __CRT_HAVE_fwrite_unlocked || __CRT_HAVE__fwrite_nolock) && (__CRT_HAVE_putchar_unlocked || __LOCAL_stdout) */
#if defined(__CRT_HAVE_pthread_attr_getinheritsched) && defined(__CRT_HAVE_pthread_attr_getschedpolicy) && defined(__CRT_HAVE_pthread_attr_getscope) && defined(__CRT_HAVE_pthread_attr_setinheritsched) && defined(__CRT_HAVE_pthread_attr_setschedpolicy) && defined(__CRT_HAVE_pthread_attr_setscope) && defined(__CRT_HAVE_pthread_getschedparam) && defined(__CRT_HAVE_pthread_setschedparam) && defined(__CRT_HAVE_pthread_setschedprio)
#define _POSIX_THREAD_PRIORITY_SCHEDULING    200809L /* We provide priority scheduling for threads. */
#endif /* __CRT_HAVE_pthread_attr_getinheritsched && __CRT_HAVE_pthread_attr_getschedpolicy && __CRT_HAVE_pthread_attr_getscope && __CRT_HAVE_pthread_attr_setinheritsched && __CRT_HAVE_pthread_attr_setschedpolicy && __CRT_HAVE_pthread_attr_setscope && __CRT_HAVE_pthread_getschedparam && __CRT_HAVE_pthread_setschedparam && __CRT_HAVE_pthread_setschedprio */
#if (defined(__CRT_HAVE_pthread_attr_getstack) || (defined(__CRT_HAVE_pthread_attr_getstackaddr) && defined(__CRT_HAVE_pthread_attr_getstacksize))) && (defined(__CRT_HAVE_pthread_attr_getstackaddr) || defined(__CRT_HAVE_pthread_attr_getstack)) && (defined(__CRT_HAVE_pthread_attr_setstack) || (defined(__CRT_HAVE_pthread_attr_setstackaddr) && defined(__CRT_HAVE_pthread_attr_setstacksize))) && (defined(__CRT_HAVE_pthread_attr_setstackaddr) || defined(__CRT_HAVE_pthread_attr_setstack))
#define _POSIX_THREAD_ATTR_STACKADDR         200809L /* We support user-defined stacks. */
#endif /* (__CRT_HAVE_pthread_attr_getstack || (__CRT_HAVE_pthread_attr_getstackaddr && __CRT_HAVE_pthread_attr_getstacksize)) && (__CRT_HAVE_pthread_attr_getstackaddr || __CRT_HAVE_pthread_attr_getstack) && (__CRT_HAVE_pthread_attr_setstack || (__CRT_HAVE_pthread_attr_setstackaddr && __CRT_HAVE_pthread_attr_setstacksize)) && (__CRT_HAVE_pthread_attr_setstackaddr || __CRT_HAVE_pthread_attr_setstack) */
#if (defined(__CRT_HAVE_pthread_attr_getstack) || (defined(__CRT_HAVE_pthread_attr_getstackaddr) && defined(__CRT_HAVE_pthread_attr_getstacksize))) && (defined(__CRT_HAVE_pthread_attr_getstacksize) || defined(__CRT_HAVE_pthread_attr_getstack)) && (defined(__CRT_HAVE_pthread_attr_setstack) || (defined(__CRT_HAVE_pthread_attr_setstackaddr) && defined(__CRT_HAVE_pthread_attr_setstacksize))) && (defined(__CRT_HAVE_pthread_attr_setstacksize) || defined(__CRT_HAVE_pthread_attr_setstack))
#define _POSIX_THREAD_ATTR_STACKSIZE         200809L /* We support user-defined stack sizes. */
#endif /* (__CRT_HAVE_pthread_attr_getstack || (__CRT_HAVE_pthread_attr_getstackaddr && __CRT_HAVE_pthread_attr_getstacksize)) && (__CRT_HAVE_pthread_attr_getstacksize || __CRT_HAVE_pthread_attr_getstack) && (__CRT_HAVE_pthread_attr_setstack || (__CRT_HAVE_pthread_attr_setstackaddr && __CRT_HAVE_pthread_attr_setstacksize)) && (__CRT_HAVE_pthread_attr_setstacksize || __CRT_HAVE_pthread_attr_setstack) */
#if defined(__CRT_HAVE_pthread_mutexattr_getprotocol) && defined(__CRT_HAVE_pthread_mutexattr_setprotocol)
#define _POSIX_THREAD_PRIO_INHERIT           200809L /* We support priority inheritance. */
#endif /* __CRT_HAVE_pthread_mutexattr_getprotocol && __CRT_HAVE_pthread_mutexattr_setprotocol */
#if defined(__CRT_HAVE_pthread_mutex_getprioceiling) && defined(__CRT_HAVE_pthread_mutex_setprioceiling) && defined(__CRT_HAVE_pthread_mutexattr_getprioceiling) && defined(__CRT_HAVE_pthread_mutexattr_getprotocol) && defined(__CRT_HAVE_pthread_mutexattr_setprioceiling) && defined(__CRT_HAVE_pthread_mutexattr_setprotocol)
#define _POSIX_THREAD_PRIO_PROTECT           200809L /* We support priority protection, though only for non-robust mutexes. */
#endif /* __CRT_HAVE_pthread_mutex_getprioceiling && __CRT_HAVE_pthread_mutex_setprioceiling && __CRT_HAVE_pthread_mutexattr_getprioceiling && __CRT_HAVE_pthread_mutexattr_getprotocol && __CRT_HAVE_pthread_mutexattr_setprioceiling && __CRT_HAVE_pthread_mutexattr_setprotocol */
#ifdef __USE_XOPEN2K8
#define _POSIX_THREAD_ROBUST_PRIO_INHERIT    200809L /* We support priority inheritance for robust mutexes. */
#define _POSIX_THREAD_ROBUST_PRIO_PROTECT    (-1)    /* We do not support priority protection for robust mutexes. */
#endif /* __USE_XOPEN2K8 */
#if defined(__CRT_HAVE_sem_close) && defined(__CRT_HAVE_sem_destroy) && defined(__CRT_HAVE_sem_getvalue) && defined(__CRT_HAVE_sem_init) && defined(__CRT_HAVE_sem_open) && defined(__CRT_HAVE_sem_post) && defined(__CRT_HAVE_sem_trywait) && defined(__CRT_HAVE_sem_unlink) && defined(__CRT_HAVE_sem_wait)
#define _POSIX_SEMAPHORES                    200809L /* We support POSIX.1b semaphores. */
#endif /* __CRT_HAVE_sem_close && __CRT_HAVE_sem_destroy && __CRT_HAVE_sem_getvalue && __CRT_HAVE_sem_init && __CRT_HAVE_sem_open && __CRT_HAVE_sem_post && __CRT_HAVE_sem_trywait && __CRT_HAVE_sem_unlink && __CRT_HAVE_sem_wait */
#if defined(__CRT_HAVE_sigqueue) && (defined(__CRT_HAVE_sigtimedwait64) || defined(__CRT_HAVE___sigtimedwait64) || defined(__CRT_HAVE_sigtimedwait) || defined(__CRT_HAVE___sigtimedwait)) && (defined(__CRT_HAVE_sigwaitinfo) || defined(__CRT_HAVE___sigwaitinfo))
#define _POSIX_REALTIME_SIGNALS              200809L /* Real-time signals are supported. */
#endif /* __CRT_HAVE_sigqueue && (__CRT_HAVE_sigtimedwait64 || __CRT_HAVE___sigtimedwait64 || __CRT_HAVE_sigtimedwait || __CRT_HAVE___sigtimedwait) && (__CRT_HAVE_sigwaitinfo || __CRT_HAVE___sigwaitinfo) */
#if ((defined(__CRT_HAVE_aio_cancel) && (!defined(__USE_FILE_OFFSET64) || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__)) || (defined(__CRT_HAVE_aio_cancel64) && (defined(__USE_FILE_OFFSET64) || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__))) && ((defined(__CRT_HAVE_aio_error) && (!defined(__USE_FILE_OFFSET64) || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__)) || (defined(__CRT_HAVE_aio_error64) && (defined(__USE_FILE_OFFSET64) || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__))) && ((defined(__CRT_HAVE_aio_fsync) && (!defined(__USE_FILE_OFFSET64) || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__)) || (defined(__CRT_HAVE_aio_fsync64) && (defined(__USE_FILE_OFFSET64) || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__))) && ((defined(__CRT_HAVE_aio_read) && (!defined(__USE_FILE_OFFSET64) || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__)) || (defined(__CRT_HAVE_aio_read64) && (defined(__USE_FILE_OFFSET64) || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__))) && ((defined(__CRT_HAVE_aio_return) && (!defined(__USE_FILE_OFFSET64) || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__)) || (defined(__CRT_HAVE_aio_return64) && (defined(__USE_FILE_OFFSET64) || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__))) && ((defined(__CRT_HAVE_aio_suspendt64) && (!defined(__USE_FILE_OFFSET64) || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__)) || (defined(__CRT_HAVE___aio_suspend_time64) && (!defined(__USE_FILE_OFFSET64) || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__)) || (defined(__CRT_HAVE_aio_suspend64t64) && (defined(__USE_FILE_OFFSET64) || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__)) || (defined(__CRT_HAVE___aio_suspend64_time64) && (defined(__USE_FILE_OFFSET64) || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__)) || (defined(__CRT_HAVE_aio_suspend) && (!defined(__USE_FILE_OFFSET64) || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__)) || (defined(__CRT_HAVE_aio_suspend64) && (defined(__USE_FILE_OFFSET64) || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__))) && ((defined(__CRT_HAVE_aio_write) && (!defined(__USE_FILE_OFFSET64) || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__)) || (defined(__CRT_HAVE_aio_write64) && (defined(__USE_FILE_OFFSET64) || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__))) && ((defined(__CRT_HAVE_lio_listio) && (!defined(__USE_FILE_OFFSET64) || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__)) || (defined(__CRT_HAVE_lio_listio64) && (defined(__USE_FILE_OFFSET64) || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__)))
#define _POSIX_ASYNCHRONOUS_IO               200809L /* We support asynchronous I/O. */
#define _POSIX_ASYNC_IO                      1
#define _LFS_ASYNCHRONOUS_IO                 1       /* Alternative name for Unix98. */
#define _POSIX_PRIORITIZED_IO                200809L /* Support for prioritization is also available. */
#endif /* ((__CRT_HAVE_aio_cancel && (!__USE_FILE_OFFSET64 || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__)) || (__CRT_HAVE_aio_cancel64 && (__USE_FILE_OFFSET64 || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__))) && ((__CRT_HAVE_aio_error && (!__USE_FILE_OFFSET64 || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__)) || (__CRT_HAVE_aio_error64 && (__USE_FILE_OFFSET64 || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__))) && ((__CRT_HAVE_aio_fsync && (!__USE_FILE_OFFSET64 || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__)) || (__CRT_HAVE_aio_fsync64 && (__USE_FILE_OFFSET64 || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__))) && ((__CRT_HAVE_aio_read && (!__USE_FILE_OFFSET64 || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__)) || (__CRT_HAVE_aio_read64 && (__USE_FILE_OFFSET64 || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__))) && ((__CRT_HAVE_aio_return && (!__USE_FILE_OFFSET64 || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__)) || (__CRT_HAVE_aio_return64 && (__USE_FILE_OFFSET64 || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__))) && ((__CRT_HAVE_aio_suspendt64 && (!__USE_FILE_OFFSET64 || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__)) || (__CRT_HAVE___aio_suspend_time64 && (!__USE_FILE_OFFSET64 || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__)) || (__CRT_HAVE_aio_suspend64t64 && (__USE_FILE_OFFSET64 || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__)) || (__CRT_HAVE___aio_suspend64_time64 && (__USE_FILE_OFFSET64 || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__)) || (__CRT_HAVE_aio_suspend && (!__USE_FILE_OFFSET64 || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__)) || (__CRT_HAVE_aio_suspend64 && (__USE_FILE_OFFSET64 || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__))) && ((__CRT_HAVE_aio_write && (!__USE_FILE_OFFSET64 || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__)) || (__CRT_HAVE_aio_write64 && (__USE_FILE_OFFSET64 || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__))) && ((__CRT_HAVE_lio_listio && (!__USE_FILE_OFFSET64 || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__)) || (__CRT_HAVE_lio_listio64 && (__USE_FILE_OFFSET64 || __SIZEOF_OFF32_T__ == __SIZEOF_OFF64_T__))) */
#include <asm/os/oflags.h>
#if defined(__CRT_HAVE_open64) || defined(__CRT_HAVE___open64) || defined(__CRT_HAVE_open) || defined(__CRT_HAVE__open) || defined(__CRT_HAVE___open) || defined(__CRT_HAVE___libc_open)
#ifdef _LFS_ASYNCHRONOUS_IO
#define _LFS64_ASYNCHRONOUS_IO               1       /* The LFS support in asynchronous I/O is also available. */
#endif /* _LFS_ASYNCHRONOUS_IO */
#define _LFS_LARGEFILE                       1       /* The rest of the LFS is also available. */
#define _LFS64_LARGEFILE                     1
#endif /* __CRT_HAVE_open64 || __CRT_HAVE___open64 || __CRT_HAVE_open || __CRT_HAVE__open || __CRT_HAVE___open || __CRT_HAVE___libc_open */
#if (defined(__CRT_HAVE_fopen) && (!defined(__O_LARGEFILE) || !__O_LARGEFILE)) || defined(__CRT_HAVE_fopen64)
#define _LFS64_STDIO                         1
#endif /* (__CRT_HAVE_fopen && (!__O_LARGEFILE || !__O_LARGEFILE)) || __CRT_HAVE_fopen64 */
#include <asm/os/fcntl.h>
#if (defined(__CRT_HAVE_mmap64) || defined(__CRT_HAVE_mmap) || defined(__CRT_HAVE___mmap)) && (defined(__CRT_HAVE_munmap) || defined(__CRT_HAVE___munmap) || defined(__CRT_HAVE___libc_munmap)) && (defined(__CRT_HAVE_shm_open) || defined(__CRT_HAVE_open64) || defined(__CRT_HAVE___open64) || defined(__CRT_HAVE_open) || defined(__CRT_HAVE__open) || defined(__CRT_HAVE___open) || defined(__CRT_HAVE___libc_open) || (defined(__AT_FDCWD) && (defined(__CRT_HAVE_openat64) || defined(__CRT_HAVE_openat)))) && (defined(__CRT_HAVE_shm_unlink) || defined(__CRT_HAVE_unlink) || defined(__CRT_HAVE__unlink) || defined(__CRT_HAVE___unlink) || defined(__CRT_HAVE___libc_unlink) || (defined(__AT_FDCWD) && defined(__CRT_HAVE_unlinkat)))
#define _POSIX_SHARED_MEMORY_OBJECTS         200809L /* POSIX shared memory objects are implemented. */
#endif /* (__CRT_HAVE_mmap64 || __CRT_HAVE_mmap || __CRT_HAVE___mmap) && (__CRT_HAVE_munmap || __CRT_HAVE___munmap || __CRT_HAVE___libc_munmap) && (__CRT_HAVE_shm_open || __CRT_HAVE_open64 || __CRT_HAVE___open64 || __CRT_HAVE_open || __CRT_HAVE__open || __CRT_HAVE___open || __CRT_HAVE___libc_open || (__AT_FDCWD && (__CRT_HAVE_openat64 || __CRT_HAVE_openat))) && (__CRT_HAVE_shm_unlink || __CRT_HAVE_unlink || __CRT_HAVE__unlink || __CRT_HAVE___unlink || __CRT_HAVE___libc_unlink || (__AT_FDCWD && __CRT_HAVE_unlinkat)) */
#if defined(__CRT_HAVE_clock_getcpuclockid) || defined(__CRT_HAVE___clock_getcpuclockid)
#define _POSIX_CPUTIME                       0       /* CPU-time clocks support needs to be checked at runtime. */
#endif /* __CRT_HAVE_clock_getcpuclockid || __CRT_HAVE___clock_getcpuclockid */
#ifdef __CRT_HAVE_pthread_getcpuclockid
#define _POSIX_THREAD_CPUTIME                0       /* Clock support in threads must be also checked at runtime. */
#endif /* __CRT_HAVE_pthread_getcpuclockid */
#if defined(__CRT_HAVE_regcomp) && defined(__CRT_HAVE_regexec) && (defined(__CRT_HAVE_regfree) || ((defined(__CRT_HAVE_free) || defined(__CRT_HAVE_cfree) || defined(__CRT_HAVE___libc_free)) && defined(__CRT_KOS)))
#define _POSIX_REGEXP                        1       /* We provides regular expression handling. */
#endif /* __CRT_HAVE_regcomp && __CRT_HAVE_regexec && (__CRT_HAVE_regfree || ((__CRT_HAVE_free || __CRT_HAVE_cfree || __CRT_HAVE___libc_free) && __CRT_KOS)) */
#if (defined(__CRT_HAVE_pthread_rwlock_destroy) || defined(__CRT_HAVE___pthread_rwlock_destroy)) && (defined(__CRT_HAVE_pthread_rwlock_init) || defined(__CRT_HAVE___pthread_rwlock_init)) && (defined(__CRT_HAVE_pthread_rwlock_rdlock) || defined(__CRT_HAVE___pthread_rwlock_rdlock)) && (defined(__CRT_HAVE_pthread_rwlock_tryrdlock) || defined(__CRT_HAVE___pthread_rwlock_tryrdlock)) && (defined(__CRT_HAVE_pthread_rwlock_trywrlock) || defined(__CRT_HAVE___pthread_rwlock_trywrlock)) && (defined(__CRT_HAVE_pthread_rwlock_unlock) || defined(__CRT_HAVE___pthread_rwlock_unlock)) && (defined(__CRT_HAVE_pthread_rwlock_wrlock) || defined(__CRT_HAVE___pthread_rwlock_wrlock)) && defined(__CRT_HAVE_pthread_rwlockattr_destroy) && defined(__CRT_HAVE_pthread_rwlockattr_init)
#define _POSIX_READER_WRITER_LOCKS           200809L /* Reader/Writer locks are available. */
#endif /* (__CRT_HAVE_pthread_rwlock_destroy || __CRT_HAVE___pthread_rwlock_destroy) && (__CRT_HAVE_pthread_rwlock_init || __CRT_HAVE___pthread_rwlock_init) && (__CRT_HAVE_pthread_rwlock_rdlock || __CRT_HAVE___pthread_rwlock_rdlock) && (__CRT_HAVE_pthread_rwlock_tryrdlock || __CRT_HAVE___pthread_rwlock_tryrdlock) && (__CRT_HAVE_pthread_rwlock_trywrlock || __CRT_HAVE___pthread_rwlock_trywrlock) && (__CRT_HAVE_pthread_rwlock_unlock || __CRT_HAVE___pthread_rwlock_unlock) && (__CRT_HAVE_pthread_rwlock_wrlock || __CRT_HAVE___pthread_rwlock_wrlock) && __CRT_HAVE_pthread_rwlockattr_destroy && __CRT_HAVE_pthread_rwlockattr_init */
#include <libc/template/environ.h>
#if defined(__CRT_HAVE_system) || defined(__CRT_HAVE___libc_system) || ((defined(__CRT_HAVE_shexec) || defined(__CRT_HAVE_execl) || defined(__CRT_HAVE__execl) || defined(__CRT_HAVE_execv) || defined(__CRT_HAVE__execv) || ((defined(__CRT_HAVE_execve) || defined(__CRT_HAVE__execve) || defined(__CRT_HAVE___execve) || defined(__CRT_HAVE___libc_execve)) && defined(__LOCAL_environ))) && (defined(__CRT_HAVE__Exit) || defined(__CRT_HAVE__exit) || defined(__CRT_HAVE_quick_exit) || defined(__CRT_HAVE_exit)) && (defined(__CRT_HAVE_waitpid) || defined(__CRT_HAVE___waitpid)) && (defined(__CRT_HAVE_vfork) || defined(__CRT_HAVE___vfork) || defined(__CRT_HAVE___libc_vfork) || defined(__CRT_HAVE_fork) || defined(__CRT_HAVE___fork) || defined(__CRT_HAVE___libc_fork)))
#define _POSIX_SHELL                         1       /* We have a POSIX shell. */
#endif /* __CRT_HAVE_system || __CRT_HAVE___libc_system || ((__CRT_HAVE_shexec || __CRT_HAVE_execl || __CRT_HAVE__execl || __CRT_HAVE_execv || __CRT_HAVE__execv || ((__CRT_HAVE_execve || __CRT_HAVE__execve || __CRT_HAVE___execve || __CRT_HAVE___libc_execve) && __LOCAL_environ)) && (__CRT_HAVE__Exit || __CRT_HAVE__exit || __CRT_HAVE_quick_exit || __CRT_HAVE_exit) && (__CRT_HAVE_waitpid || __CRT_HAVE___waitpid) && (__CRT_HAVE_vfork || __CRT_HAVE___vfork || __CRT_HAVE___libc_vfork || __CRT_HAVE_fork || __CRT_HAVE___fork || __CRT_HAVE___libc_fork)) */
#if ((defined(__CRT_HAVE_____mq_timedreceive_time64) && (defined(__USE_TIME_BITS64) || __SIZEOF_TIME32_T__ == __SIZEOF_TIME64_T__)) || defined(__CRT_HAVE_mq_timedreceive64) || defined(__CRT_HAVE___mq_timedreceive_time64) || defined(__CRT_HAVE_mq_timedreceive)) && (defined(__CRT_HAVE_mq_timedsend64) || defined(__CRT_HAVE___mq_timedsend_time64) || defined(__CRT_HAVE_mq_timedsend)) && (defined(__CRT_HAVE_pthread_mutex_timedlock64) || defined(__CRT_HAVE___pthread_mutex_timedlock64) || defined(__CRT_HAVE_pthread_mutex_timedlock)) && (defined(__CRT_HAVE_pthread_rwlock_timedrdlock64) || defined(__CRT_HAVE___pthread_rwlock_timedrdlock64) || defined(__CRT_HAVE_pthread_rwlock_timedrdlock)) && (defined(__CRT_HAVE_pthread_rwlock_timedwrlock64) || defined(__CRT_HAVE___pthread_rwlock_timedwrlock64) || defined(__CRT_HAVE_pthread_rwlock_timedwrlock)) && (defined(__CRT_HAVE_sem_timedwait64) || defined(__CRT_HAVE___sem_timedwait64) || defined(__CRT_HAVE_sem_timedwait))
#define _POSIX_TIMEOUTS                      200809L /* We support the Timeouts option. */
#endif /* ((__CRT_HAVE_____mq_timedreceive_time64 && (__USE_TIME_BITS64 || __SIZEOF_TIME32_T__ == __SIZEOF_TIME64_T__)) || __CRT_HAVE_mq_timedreceive64 || __CRT_HAVE___mq_timedreceive_time64 || __CRT_HAVE_mq_timedreceive) && (__CRT_HAVE_mq_timedsend64 || __CRT_HAVE___mq_timedsend_time64 || __CRT_HAVE_mq_timedsend) && (__CRT_HAVE_pthread_mutex_timedlock64 || __CRT_HAVE___pthread_mutex_timedlock64 || __CRT_HAVE_pthread_mutex_timedlock) && (__CRT_HAVE_pthread_rwlock_timedrdlock64 || __CRT_HAVE___pthread_rwlock_timedrdlock64 || __CRT_HAVE_pthread_rwlock_timedrdlock) && (__CRT_HAVE_pthread_rwlock_timedwrlock64 || __CRT_HAVE___pthread_rwlock_timedwrlock64 || __CRT_HAVE_pthread_rwlock_timedwrlock) && (__CRT_HAVE_sem_timedwait64 || __CRT_HAVE___sem_timedwait64 || __CRT_HAVE_sem_timedwait) */
#define _POSIX_SPIN_LOCKS                    200809L /* We support spinlocks. */
#include <asm/crt/posix_spawn.h>
#include <asm/os/vfork.h>
#include <asm/os/features.h>
#include <hybrid/__alloca.h>
#if (defined(__CRT_HAVE_posix_spawn) || ((defined(__CRT_HAVE_open64) || defined(__CRT_HAVE___open64) || defined(__CRT_HAVE_open) || defined(__CRT_HAVE__open) || defined(__CRT_HAVE___open) || defined(__CRT_HAVE___libc_open) || (defined(__AT_FDCWD) && (defined(__CRT_HAVE_openat64) || defined(__CRT_HAVE_openat)))) && (defined(__CRT_HAVE_posix_fspawn_np) || (defined(__POSIX_SPAWN_USE_KOS) && ((defined(__ARCH_HAVE_SHARED_VM_VFORK) && (defined(__CRT_HAVE_vfork) || defined(__CRT_HAVE___vfork) || defined(__CRT_HAVE___libc_vfork))) || ((defined(__CRT_HAVE_fork) || defined(__CRT_HAVE___fork) || defined(__CRT_HAVE___libc_fork)) && (defined(__CRT_HAVE_pipe2) || defined(__CRT_HAVE_pipe) || defined(__CRT_HAVE___pipe) || defined(__CRT_HAVE___libc_pipe) || defined(__CRT_HAVE__pipe)) && defined(__O_CLOEXEC) && (defined(__CRT_HAVE_read) || defined(__CRT_HAVE__read) || defined(__CRT_HAVE___read) || defined(__CRT_HAVE___libc_read)) && (defined(__CRT_HAVE_write) || defined(__CRT_HAVE__write) || defined(__CRT_HAVE___write) || defined(__CRT_HAVE___libc_write)) && (defined(__CRT_HAVE_close) || defined(__CRT_HAVE__close) || defined(__CRT_HAVE___close) || defined(__CRT_HAVE___libc_close)))) && defined(__CRT_HAVE_fexecve) && (defined(__CRT_HAVE_waitpid) || defined(__CRT_HAVE___waitpid)))))) && (defined(__CRT_HAVE_posix_spawnp) || ((defined(__CRT_HAVE_getenv) || defined(__LOCAL_environ)) && defined(__hybrid_alloca))) && (defined(__CRT_HAVE_posix_spawn_file_actions_addclose) || (defined(__POSIX_SPAWN_USE_KOS) && (defined(__CRT_HAVE_realloc) || defined(__CRT_HAVE___libc_realloc)))) && (defined(__CRT_HAVE_posix_spawn_file_actions_adddup2) || (defined(__POSIX_SPAWN_USE_KOS) && (defined(__CRT_HAVE_realloc) || defined(__CRT_HAVE___libc_realloc)))) && (defined(__CRT_HAVE_posix_spawn_file_actions_addopen) || (defined(__POSIX_SPAWN_USE_KOS) && (defined(__CRT_HAVE_realloc) || defined(__CRT_HAVE___libc_realloc)))) && (defined(__CRT_HAVE_posix_spawn_file_actions_destroy) || defined(__POSIX_SPAWN_USE_KOS)) && (defined(__CRT_HAVE_posix_spawnattr_getsigdefault) || defined(__POSIX_SPAWN_USE_KOS)) && (defined(__CRT_HAVE_posix_spawnattr_getflags) || defined(__POSIX_SPAWN_USE_KOS)) && (defined(__CRT_HAVE_posix_spawnattr_getpgroup) || defined(__POSIX_SPAWN_USE_KOS)) && (defined(__CRT_HAVE_posix_spawnattr_getsigmask) || defined(__POSIX_SPAWN_USE_KOS)) && (defined(__CRT_HAVE_posix_spawnattr_setsigdefault) || defined(__POSIX_SPAWN_USE_KOS)) && (defined(__CRT_HAVE_posix_spawnattr_setflags) || defined(__POSIX_SPAWN_USE_KOS)) && (defined(__CRT_HAVE_posix_spawnattr_setpgroup) || defined(__POSIX_SPAWN_USE_KOS)) && (defined(__CRT_HAVE_posix_spawnattr_setsigmask) || defined(__POSIX_SPAWN_USE_KOS))
#define _POSIX_SPAWN                         200809L /* The `spawn' function family is supported. */
#endif /* (__CRT_HAVE_posix_spawn || ((__CRT_HAVE_open64 || __CRT_HAVE___open64 || __CRT_HAVE_open || __CRT_HAVE__open || __CRT_HAVE___open || __CRT_HAVE___libc_open || (__AT_FDCWD && (__CRT_HAVE_openat64 || __CRT_HAVE_openat))) && (__CRT_HAVE_posix_fspawn_np || (__POSIX_SPAWN_USE_KOS && ((__ARCH_HAVE_SHARED_VM_VFORK && (__CRT_HAVE_vfork || __CRT_HAVE___vfork || __CRT_HAVE___libc_vfork)) || ((__CRT_HAVE_fork || __CRT_HAVE___fork || __CRT_HAVE___libc_fork) && (__CRT_HAVE_pipe2 || __CRT_HAVE_pipe || __CRT_HAVE___pipe || __CRT_HAVE___libc_pipe || __CRT_HAVE__pipe) && __O_CLOEXEC && (__CRT_HAVE_read || __CRT_HAVE__read || __CRT_HAVE___read || __CRT_HAVE___libc_read) && (__CRT_HAVE_write || __CRT_HAVE__write || __CRT_HAVE___write || __CRT_HAVE___libc_write) && (__CRT_HAVE_close || __CRT_HAVE__close || __CRT_HAVE___close || __CRT_HAVE___libc_close))) && __CRT_HAVE_fexecve && (__CRT_HAVE_waitpid || __CRT_HAVE___waitpid))))) && (__CRT_HAVE_posix_spawnp || ((__CRT_HAVE_getenv || __LOCAL_environ) && __hybrid_alloca)) && (__CRT_HAVE_posix_spawn_file_actions_addclose || (__POSIX_SPAWN_USE_KOS && (__CRT_HAVE_realloc || __CRT_HAVE___libc_realloc))) && (__CRT_HAVE_posix_spawn_file_actions_adddup2 || (__POSIX_SPAWN_USE_KOS && (__CRT_HAVE_realloc || __CRT_HAVE___libc_realloc))) && (__CRT_HAVE_posix_spawn_file_actions_addopen || (__POSIX_SPAWN_USE_KOS && (__CRT_HAVE_realloc || __CRT_HAVE___libc_realloc))) && (__CRT_HAVE_posix_spawn_file_actions_destroy || __POSIX_SPAWN_USE_KOS) && (__CRT_HAVE_posix_spawnattr_getsigdefault || __POSIX_SPAWN_USE_KOS) && (__CRT_HAVE_posix_spawnattr_getflags || __POSIX_SPAWN_USE_KOS) && (__CRT_HAVE_posix_spawnattr_getpgroup || __POSIX_SPAWN_USE_KOS) && (__CRT_HAVE_posix_spawnattr_getsigmask || __POSIX_SPAWN_USE_KOS) && (__CRT_HAVE_posix_spawnattr_setsigdefault || __POSIX_SPAWN_USE_KOS) && (__CRT_HAVE_posix_spawnattr_setflags || __POSIX_SPAWN_USE_KOS) && (__CRT_HAVE_posix_spawnattr_setpgroup || __POSIX_SPAWN_USE_KOS) && (__CRT_HAVE_posix_spawnattr_setsigmask || __POSIX_SPAWN_USE_KOS) */
#if defined(__CRT_HAVE_timer_create) && defined(__CRT_HAVE_timer_delete) && (defined(__CRT_HAVE_timer_gettime64) || defined(__CRT_HAVE___timer_gettime64) || defined(__CRT_HAVE_timer_gettime)) && defined(__CRT_HAVE_timer_getoverrun) && (defined(__CRT_HAVE_timer_settime64) || defined(__CRT_HAVE___timer_settime64) || defined(__CRT_HAVE_timer_settime))
#define _POSIX_TIMERS                        200809L /* We have POSIX timers. */
#endif /* __CRT_HAVE_timer_create && __CRT_HAVE_timer_delete && (__CRT_HAVE_timer_gettime64 || __CRT_HAVE___timer_gettime64 || __CRT_HAVE_timer_gettime) && __CRT_HAVE_timer_getoverrun && (__CRT_HAVE_timer_settime64 || __CRT_HAVE___timer_settime64 || __CRT_HAVE_timer_settime) */
#if defined(__CRT_HAVE_pthread_barrier_destroy) && (defined(__CRT_HAVE_pthread_barrier_init) || defined(__CRT_HAVE___pthread_barrier_init)) && (defined(__CRT_HAVE_pthread_barrier_wait) || defined(__CRT_HAVE___pthread_barrier_wait)) && defined(__CRT_HAVE_pthread_barrierattr_destroy) && defined(__CRT_HAVE_pthread_barrierattr_init)
#define _POSIX_BARRIERS                      200809L /* The barrier functions are available. */
#endif /* __CRT_HAVE_pthread_barrier_destroy && (__CRT_HAVE_pthread_barrier_init || __CRT_HAVE___pthread_barrier_init) && (__CRT_HAVE_pthread_barrier_wait || __CRT_HAVE___pthread_barrier_wait) && __CRT_HAVE_pthread_barrierattr_destroy && __CRT_HAVE_pthread_barrierattr_init */
#if defined(__CRT_HAVE_mq_close) && defined(__CRT_HAVE_mq_getattr) && defined(__CRT_HAVE_mq_notify) && defined(__CRT_HAVE_mq_open) && defined(__CRT_HAVE_mq_receive) && defined(__CRT_HAVE_mq_send) && defined(__CRT_HAVE_mq_setattr) && defined(__CRT_HAVE_mq_unlink)
#define _POSIX_MESSAGE_PASSING               200809L /* POSIX message queues are available. */
#endif /* __CRT_HAVE_mq_close && __CRT_HAVE_mq_getattr && __CRT_HAVE_mq_notify && __CRT_HAVE_mq_open && __CRT_HAVE_mq_receive && __CRT_HAVE_mq_send && __CRT_HAVE_mq_setattr && __CRT_HAVE_mq_unlink */
#if defined(__CRT_HAVE_pthread_barrierattr_getpshared) && defined(__CRT_HAVE_pthread_barrierattr_setpshared) && defined(__CRT_HAVE_pthread_condattr_getpshared) && defined(__CRT_HAVE_pthread_condattr_setpshared) && defined(__CRT_HAVE_pthread_mutexattr_getpshared) && defined(__CRT_HAVE_pthread_mutexattr_setpshared) && defined(__CRT_HAVE_pthread_rwlockattr_getpshared) && defined(__CRT_HAVE_pthread_rwlockattr_setpshared)
#define _POSIX_THREAD_PROCESS_SHARED         200809L /* Thread process-shared synchronization is supported. */
#endif /* __CRT_HAVE_pthread_barrierattr_getpshared && __CRT_HAVE_pthread_barrierattr_setpshared && __CRT_HAVE_pthread_condattr_getpshared && __CRT_HAVE_pthread_condattr_setpshared && __CRT_HAVE_pthread_mutexattr_getpshared && __CRT_HAVE_pthread_mutexattr_setpshared && __CRT_HAVE_pthread_rwlockattr_getpshared && __CRT_HAVE_pthread_rwlockattr_setpshared */
#define _POSIX_MONOTONIC_CLOCK               0       /* The monotonic clock might be available. */
#if defined(__CRT_HAVE_pthread_condattr_getclock) && defined(__CRT_HAVE_pthread_condattr_setclock) && (defined(__CRT_HAVE_clock_nanosleep64) || defined(__CRT_HAVE___clock_nanosleep_time64) || defined(__CRT_HAVE_clock_nanosleep) || defined(__CRT_HAVE___clock_nanosleep))
#define _POSIX_CLOCK_SELECTION               200809L /* The clock selection interfaces are available. */
#endif /* __CRT_HAVE_pthread_condattr_getclock && __CRT_HAVE_pthread_condattr_setclock && (__CRT_HAVE_clock_nanosleep64 || __CRT_HAVE___clock_nanosleep_time64 || __CRT_HAVE_clock_nanosleep || __CRT_HAVE___clock_nanosleep) */
#if defined(__CRT_HAVE_memalign) || defined(__CRT_HAVE_aligned_alloc) || defined(__CRT_HAVE___libc_memalign) || defined(__CRT_HAVE_posix_memalign)
#define _POSIX_ADVISORY_INFO                 200809L /* Advisory information interfaces are available. */
#endif /* __CRT_HAVE_memalign || __CRT_HAVE_aligned_alloc || __CRT_HAVE___libc_memalign || __CRT_HAVE_posix_memalign */
#define _POSIX_IPV6                          200809L /* IPv6 support is available. */
#define _POSIX_RAW_SOCKETS                   200809L /* Raw socket support is available. */
#if defined(__CRT_HAVE_isatty) || defined(__CRT_HAVE__isatty) || defined(__CRT_HAVE___isatty) || defined(__CRT_HAVE_tcgetattr) || defined(__CRT_HAVE___tcgetattr) || ((defined(__CRT_HAVE_ioctl) || defined(__CRT_HAVE___ioctl) || defined(__CRT_HAVE___libc_ioctl) || defined(__CRT_HAVE___ioctl_time64)) && defined(__TCGETA))
#define _POSIX2_CHAR_TERM                    200809L /* We have at least one terminal. */
#endif /* __CRT_HAVE_isatty || __CRT_HAVE__isatty || __CRT_HAVE___isatty || __CRT_HAVE_tcgetattr || __CRT_HAVE___tcgetattr || ((__CRT_HAVE_ioctl || __CRT_HAVE___ioctl || __CRT_HAVE___libc_ioctl || __CRT_HAVE___ioctl_time64) && __TCGETA) */
#define _POSIX_SPORADIC_SERVER               (-1)    /* Neither process nor thread sporadic server interfaces is available. */
#define _POSIX_THREAD_SPORADIC_SERVER        (-1)    /* Neither process nor thread sporadic server interfaces is available. */
#define _POSIX_TRACE                         (-1)    /* trace.h is not available. */
#define _POSIX_TRACE_EVENT_FILTER            (-1)
#define _POSIX_TRACE_INHERIT                 (-1)
#define _POSIX_TRACE_LOG                     (-1)
#define _POSIX_TYPED_MEMORY_OBJECTS          (-1)    /* Typed memory objects are not available. */
#if defined(__CRT_HAVE_crypt) && defined(__CRT_HAVE_encrypt) && defined(__CRT_HAVE_setkey)
#define _XOPEN_CRYPT 1
#endif /* __CRT_HAVE_crypt && __CRT_HAVE_encrypt && __CRT_HAVE_setkey */
#if defined(__CRT_HAVE_catclose) && defined(__CRT_HAVE_catgets) && defined(__CRT_HAVE_catopen) && defined(__CRT_HAVE_setlocale)
#define _XOPEN_ENH_I18N 1
#endif /* __CRT_HAVE_catclose && __CRT_HAVE_catgets && __CRT_HAVE_catopen && __CRT_HAVE_setlocale */
#include <bits/os/stat.h>
#if (defined(__CRT_HAVE__ftime32_s) || defined(__CRT_HAVE__ftime64_s) || defined(__CRT_HAVE__ftime32) || defined(__CRT_HAVE__ftime) || defined(__CRT_HAVE__ftime64) || defined(__CRT_HAVE_ftime) || defined(__CRT_HAVE_ftime64)) && (defined(__CRT_HAVE_getwd) || defined(__CRT_HAVE_getcwd) || defined(__CRT_HAVE__getcwd)) && (defined(__CRT_HAVE_mktemp) || defined(__CRT_HAVE__mktemp) || defined(__CRT_HAVE___mktemp) || defined(__CRT_HAVE_open64) || defined(__CRT_HAVE___open64) || defined(__CRT_HAVE_open) || defined(__CRT_HAVE__open) || defined(__CRT_HAVE___open) || defined(__CRT_HAVE___libc_open) || (defined(__AT_FDCWD) && (defined(__CRT_HAVE_openat64) || defined(__CRT_HAVE_openat))) || (defined(__AT_FDCWD) && ((defined(__CRT_HAVE_kfstatat) && defined(__CRT_KOS_PRIMARY)) || (defined(__CRT_HAVE_kfstatat64) && defined(__CRT_KOS_PRIMARY)) || defined(__CRT_HAVE_fstatat) || defined(__CRT_HAVE_fstatat64) || defined(__CRT_HAVE___fstatat64_time64))) || (defined(__CRT_HAVE_kstat) && defined(__CRT_KOS_PRIMARY)) || (defined(__CRT_HAVE_kstat64) && defined(__CRT_KOS_PRIMARY)) || defined(__CRT_HAVE_stat) || defined(__CRT_HAVE_stat64) || defined(__CRT_HAVE___stat64_time64) || defined(__CRT_HAVE__stat) || defined(__CRT_HAVE__stat32) || defined(__CRT_HAVE__stati64) || defined(__CRT_HAVE__stat32i64) || defined(__CRT_HAVE__stat64) || defined(__CRT_HAVE__stat64i32)) && (defined(__CRT_HAVE_utimes64) || defined(__CRT_HAVE___utimes64) || defined(__CRT_HAVE_utimes) || defined(__CRT_HAVE___utimes))
#define _XOPEN_LEGACY 1
#endif /* (__CRT_HAVE__ftime32_s || __CRT_HAVE__ftime64_s || __CRT_HAVE__ftime32 || __CRT_HAVE__ftime || __CRT_HAVE__ftime64 || __CRT_HAVE_ftime || __CRT_HAVE_ftime64) && (__CRT_HAVE_getwd || __CRT_HAVE_getcwd || __CRT_HAVE__getcwd) && (__CRT_HAVE_mktemp || __CRT_HAVE__mktemp || __CRT_HAVE___mktemp || __CRT_HAVE_open64 || __CRT_HAVE___open64 || __CRT_HAVE_open || __CRT_HAVE__open || __CRT_HAVE___open || __CRT_HAVE___libc_open || (__AT_FDCWD && (__CRT_HAVE_openat64 || __CRT_HAVE_openat)) || (__AT_FDCWD && ((__CRT_HAVE_kfstatat && __CRT_KOS_PRIMARY) || (__CRT_HAVE_kfstatat64 && __CRT_KOS_PRIMARY) || __CRT_HAVE_fstatat || __CRT_HAVE_fstatat64 || __CRT_HAVE___fstatat64_time64)) || (__CRT_HAVE_kstat && __CRT_KOS_PRIMARY) || (__CRT_HAVE_kstat64 && __CRT_KOS_PRIMARY) || __CRT_HAVE_stat || __CRT_HAVE_stat64 || __CRT_HAVE___stat64_time64 || __CRT_HAVE__stat || __CRT_HAVE__stat32 || __CRT_HAVE__stati64 || __CRT_HAVE__stat32i64 || __CRT_HAVE__stat64 || __CRT_HAVE__stat64i32) && (__CRT_HAVE_utimes64 || __CRT_HAVE___utimes64 || __CRT_HAVE_utimes || __CRT_HAVE___utimes) */
#if defined(__CRT_HAVE_isastream) && defined(__CRT_HAVE_getmsg) && defined(__CRT_HAVE_getpmsg) && (defined(__CRT_HAVE_ioctl) || defined(__CRT_HAVE___ioctl) || defined(__CRT_HAVE___libc_ioctl) || defined(__CRT_HAVE___ioctl_time64)) && defined(__CRT_HAVE_putmsg) && defined(__CRT_HAVE_putpmsg) && defined(__CRT_HAVE_fattach) && defined(__CRT_HAVE_fdetach)
#define _XOPEN_STREAMS 1
#endif /* __CRT_HAVE_isastream && __CRT_HAVE_getmsg && __CRT_HAVE_getpmsg && (__CRT_HAVE_ioctl || __CRT_HAVE___ioctl || __CRT_HAVE___libc_ioctl || __CRT_HAVE___ioctl_time64) && __CRT_HAVE_putmsg && __CRT_HAVE_putpmsg && __CRT_HAVE_fattach && __CRT_HAVE_fdetach */
#endif /* !_BITS_POSIX_OPT_H */
