/* Copyright (c) 2019-2024 Griefer@Work                                       *
 *                                                                            *
 * This software is provided 'as-is', without any express or implied          *
 * warranty. In no event will the authors be held liable for any damages      *
 * arising from the use of this software.                                     *
 *                                                                            *
 * Permission is granted to anyone to use this software for any purpose,      *
 * including commercial applications, and to alter it and redistribute it     *
 * freely, subject to the following restrictions:                             *
 *                                                                            *
 * 1. The origin of this software must not be misrepresented; you must not    *
 *    claim that you wrote the original software. If you use this software    *
 *    in a product, an acknowledgement (see the following) in the product     *
 *    documentation is required:                                              *
 *    Portions Copyright (c) 2019-2024 Griefer@Work                           *
 * 2. Altered source versions must be plainly marked as such, and must not be *
 *    misrepresented as being the original software.                          *
 * 3. This notice may not be removed or altered from any source distribution. *
 */
#ifndef _BITS_CRT_VTIMES_H
#define _BITS_CRT_VTIMES_H 1

#include <__crt.h>

#include <bits/types.h>

/* Granularity of `struct vtimes::vm_utime' and `struct vtimes::vm_stime' */
#define __VTIMES_UNITS_PER_SECOND 60

#ifdef __CC__
__DECL_BEGIN

struct vtimes {
	int          vm_utime;  /* User time (in seconds*VTIMES_UNITS_PER_SECOND) */
	int          vm_stime;  /* System time (in seconds*VTIMES_UNITS_PER_SECOND) */
	unsigned int vm_idsrss; /* [== rusage::ru_idrss + rusage::ru_isrss] */
	unsigned int vm_ixrss;  /* Not filled in (so don't use) */
	int          vm_maxrss; /* Not filled in (so don't use) */
	int          vm_majflt; /* [== rusage::ru_majflt] */
	int          vm_minflt; /* [== rusage::ru_minflt] */
	int          vm_nswap;  /* [== rusage::ru_nswap] */
	int          vm_inblk;  /* [== rusage::ru_inblock] */
	int          vm_oublk;  /* [== rusage::ru_oublock] */
};

__DECL_END
#endif /* __CC__ */

#endif /* !_BITS_CRT_VTIMES_H */
