/* HASH CRC-32:0xc8e98a2c */
/* Copyright (c) 2019-2024 Griefer@Work                                       *
 *                                                                            *
 * This software is provided 'as-is', without any express or implied          *
 * warranty. In no event will the authors be held liable for any damages      *
 * arising from the use of this software.                                     *
 *                                                                            *
 * Permission is granted to anyone to use this software for any purpose,      *
 * including commercial applications, and to alter it and redistribute it     *
 * freely, subject to the following restrictions:                             *
 *                                                                            *
 * 1. The origin of this software must not be misrepresented; you must not    *
 *    claim that you wrote the original software. If you use this software    *
 *    in a product, an acknowledgement (see the following) in the product     *
 *    documentation is required:                                              *
 *    Portions Copyright (c) 2019-2024 Griefer@Work                           *
 * 2. Altered source versions must be plainly marked as such, and must not be *
 *    misrepresented as being the original software.                          *
 * 3. This notice may not be removed or altered from any source distribution. *
 */

/* Enumerate known system calls by name */
#ifndef __SYSCALL
#define __SYSCALL(name) /* nothing */
#endif /* !__SYSCALL */

/* Enumerate unused system calls IDs */
#ifndef __SYSCALL_UNUSED
#define __SYSCALL_UNUSED(sysno) /* nothing */
#endif /* !__SYSCALL_UNUSED */

/* Enumerate used system calls */
#ifndef __TSYSCALL
#define __TSYSCALL(table_id, name, table_index, table_index_without_unused_leading) __SYSCALL(name)
#endif /* !__TSYSCALL */

/* Enumerate unused system calls */
#ifndef __TSYSCALL_UNUSED
#define __TSYSCALL_UNUSED(table_id, sysno, table_index, table_index_without_unused_leading) __SYSCALL_UNUSED(sysno)
#endif /* !__TSYSCALL_UNUSED */

/* Enumerate unused system calls at the start of a table */
#ifndef __TSYSCALL_UNUSED_LEADING
#define __TSYSCALL_UNUSED_LEADING(table_id, sysno, table_index) __SYSCALL_UNUSED(sysno)
#endif /* !__TSYSCALL_UNUSED_LEADING */

/* Enumerate unused system calls at the end of a table */
#ifndef __TSYSCALL_UNUSED_TRAILING
#define __TSYSCALL_UNUSED_TRAILING(table_id, sysno, table_index, table_index_without_unused_leading, index_in_unused_trailing) __SYSCALL_UNUSED(sysno)
#endif /* !__TSYSCALL_UNUSED_TRAILING */

/* Invoked at the start of a system call table */
#ifndef __TSYSCALL_TABLE_BEGIN
#define __TSYSCALL_TABLE_BEGIN(table_id, minsysno, maxsysno, sysnocnt, minsysno_without_unused_leading, maxsysno_without_unused_trailing, sysnocnt_without_unused_surrounding) /* nothing */
#endif /* !__TSYSCALL_TABLE_BEGIN */

/* Invoked at the end of a system call table */
#ifndef __TSYSCALL_TABLE_END
#define __TSYSCALL_TABLE_END(table_id, minsysno, maxsysno, sysnocnt, minsysno_without_unused_leading, maxsysno_without_unused_trailing, sysnocnt_without_unused_surrounding) /* nothing */
#endif /* !__TSYSCALL_TABLE_END */

/* Enumerate used system calls in the 1st system call */
#ifndef __TSYSCALL0
#define __TSYSCALL0(name, index, index_without_unused_leading) __TSYSCALL(0, name, index, index_without_unused_leading)
#endif /* !__TSYSCALL0 */

/* Enumerate unused system calls in the middle of the 1st system call table*/
#ifndef __TSYSCALL0_UNUSED
#define __TSYSCALL0_UNUSED(sysno, index, index_without_unused_leading) __TSYSCALL_UNUSED(0, sysno, index, index_without_unused_leading)
#endif /* !__TSYSCALL0_UNUSED */

/* Enumerate unused system calls at the start of the 1st system call table */
#ifndef __TSYSCALL0_UNUSED_LEADING
#define __TSYSCALL0_UNUSED_LEADING(sysno, index) __TSYSCALL_UNUSED_LEADING(0, sysno, index)
#endif /* !__TSYSCALL0_UNUSED_LEADING */

/* Enumerate unused system calls at the end of the 1st system call table */
#ifndef __TSYSCALL0_UNUSED_TRAILING
#define __TSYSCALL0_UNUSED_TRAILING(sysno, index, index_without_unused_leading, index_in_unused_trailing) __TSYSCALL_UNUSED_TRAILING(0, sysno, index, index_without_unused_leading, index_in_unused_trailing)
#endif /* !__TSYSCALL0_UNUSED_TRAILING */

/* Invoked at the start of the 1st system call table */
#ifndef __TSYSCALL0_TABLE_BEGIN
#define __TSYSCALL0_TABLE_BEGIN(minsysno, maxsysno, sysnocnt, minsysno_without_unused_leading, maxsysno_without_unused_trailing, sysnocnt_without_unused_surrounding) \
	__TSYSCALL_TABLE_BEGIN(0, minsysno, maxsysno, sysnocnt, minsysno_without_unused_leading, maxsysno_without_unused_trailing, sysnocnt_without_unused_surrounding)
#endif /* !__TSYSCALL0_TABLE_BEGIN */

/* Invoked at the end of the 1st system call table */
#ifndef __TSYSCALL0_TABLE_END
#define __TSYSCALL0_TABLE_END(minsysno, maxsysno, sysnocnt, minsysno_without_unused_leading, maxsysno_without_unused_trailing, sysnocnt_without_unused_surrounding) \
	__TSYSCALL_TABLE_END(0, minsysno, maxsysno, sysnocnt, minsysno_without_unused_leading, maxsysno_without_unused_trailing, sysnocnt_without_unused_surrounding)
#endif /* !__TSYSCALL0_TABLE_END */

/************************************************************************/
/* Contents of the 1st table                                            */
/************************************************************************/
__TSYSCALL0_TABLE_BEGIN(0x0, 0x437, 0x438, 0x0, 0x437, 0x438)
__TSYSCALL0(io_setup, 0x0, 0x0)
__TSYSCALL0(io_destroy, 0x1, 0x1)
__TSYSCALL0(io_submit, 0x2, 0x2)
__TSYSCALL0(io_cancel, 0x3, 0x3)
__TSYSCALL0(io_getevents, 0x4, 0x4)
__TSYSCALL0(setxattr, 0x5, 0x5)
__TSYSCALL0(lsetxattr, 0x6, 0x6)
__TSYSCALL0(fsetxattr, 0x7, 0x7)
__TSYSCALL0(getxattr, 0x8, 0x8)
__TSYSCALL0(lgetxattr, 0x9, 0x9)
__TSYSCALL0(fgetxattr, 0xa, 0xa)
__TSYSCALL0(listxattr, 0xb, 0xb)
__TSYSCALL0(llistxattr, 0xc, 0xc)
__TSYSCALL0(flistxattr, 0xd, 0xd)
__TSYSCALL0(removexattr, 0xe, 0xe)
__TSYSCALL0(lremovexattr, 0xf, 0xf)
__TSYSCALL0(fremovexattr, 0x10, 0x10)
__TSYSCALL0(getcwd, 0x11, 0x11)
__TSYSCALL0(lookup_dcookie, 0x12, 0x12)
__TSYSCALL0(eventfd2, 0x13, 0x13)
__TSYSCALL0(epoll_create1, 0x14, 0x14)
__TSYSCALL0(epoll_ctl, 0x15, 0x15)
__TSYSCALL0(epoll_pwait, 0x16, 0x16)
__TSYSCALL0(dup, 0x17, 0x17)
__TSYSCALL0(dup3, 0x18, 0x18)
__TSYSCALL0_UNUSED(0x19, 0x19, 0x19)
__TSYSCALL0(inotify_init1, 0x1a, 0x1a)
__TSYSCALL0(inotify_add_watch, 0x1b, 0x1b)
__TSYSCALL0(inotify_rm_watch, 0x1c, 0x1c)
__TSYSCALL0(ioctl, 0x1d, 0x1d)
__TSYSCALL0(ioprio_set, 0x1e, 0x1e)
__TSYSCALL0(ioprio_get, 0x1f, 0x1f)
__TSYSCALL0(flock, 0x20, 0x20)
__TSYSCALL0(mknodat, 0x21, 0x21)
__TSYSCALL0(mkdirat, 0x22, 0x22)
__TSYSCALL0(unlinkat, 0x23, 0x23)
__TSYSCALL0(symlinkat, 0x24, 0x24)
__TSYSCALL0(linkat, 0x25, 0x25)
__TSYSCALL0(renameat, 0x26, 0x26)
__TSYSCALL0(umount2, 0x27, 0x27)
__TSYSCALL0(mount, 0x28, 0x28)
__TSYSCALL0(pivot_root, 0x29, 0x29)
__TSYSCALL0(nfsservctl, 0x2a, 0x2a)
__TSYSCALL0_UNUSED(0x2b, 0x2b, 0x2b)
__TSYSCALL0_UNUSED(0x2c, 0x2c, 0x2c)
__TSYSCALL0_UNUSED(0x2d, 0x2d, 0x2d)
__TSYSCALL0_UNUSED(0x2e, 0x2e, 0x2e)
__TSYSCALL0(fallocate, 0x2f, 0x2f)
__TSYSCALL0(faccessat, 0x30, 0x30)
__TSYSCALL0(chdir, 0x31, 0x31)
__TSYSCALL0(fchdir, 0x32, 0x32)
__TSYSCALL0(chroot, 0x33, 0x33)
__TSYSCALL0(fchmod, 0x34, 0x34)
__TSYSCALL0(fchmodat, 0x35, 0x35)
__TSYSCALL0(fchownat, 0x36, 0x36)
__TSYSCALL0(fchown, 0x37, 0x37)
__TSYSCALL0(openat, 0x38, 0x38)
__TSYSCALL0(close, 0x39, 0x39)
__TSYSCALL0(vhangup, 0x3a, 0x3a)
__TSYSCALL0(pipe2, 0x3b, 0x3b)
__TSYSCALL0(quotactl, 0x3c, 0x3c)
__TSYSCALL0(getdents64, 0x3d, 0x3d)
__TSYSCALL0_UNUSED(0x3e, 0x3e, 0x3e)
__TSYSCALL0(read, 0x3f, 0x3f)
__TSYSCALL0(write, 0x40, 0x40)
__TSYSCALL0(readv, 0x41, 0x41)
__TSYSCALL0(writev, 0x42, 0x42)
__TSYSCALL0(pread64, 0x43, 0x43)
__TSYSCALL0(pwrite64, 0x44, 0x44)
__TSYSCALL0(preadv, 0x45, 0x45)
__TSYSCALL0(pwritev, 0x46, 0x46)
__TSYSCALL0_UNUSED(0x47, 0x47, 0x47)
__TSYSCALL0(pselect6, 0x48, 0x48)
__TSYSCALL0(ppoll, 0x49, 0x49)
__TSYSCALL0(signalfd4, 0x4a, 0x4a)
__TSYSCALL0(vmsplice, 0x4b, 0x4b)
__TSYSCALL0(splice, 0x4c, 0x4c)
__TSYSCALL0(tee, 0x4d, 0x4d)
__TSYSCALL0(readlinkat, 0x4e, 0x4e)
__TSYSCALL0_UNUSED(0x4f, 0x4f, 0x4f)
__TSYSCALL0_UNUSED(0x50, 0x50, 0x50)
__TSYSCALL0(sync, 0x51, 0x51)
__TSYSCALL0(fsync, 0x52, 0x52)
__TSYSCALL0(fdatasync, 0x53, 0x53)
__TSYSCALL0(sync_file_range, 0x54, 0x54)
__TSYSCALL0(timerfd_create, 0x55, 0x55)
__TSYSCALL0(timerfd_settime, 0x56, 0x56)
__TSYSCALL0(timerfd_gettime, 0x57, 0x57)
__TSYSCALL0(utimensat, 0x58, 0x58)
__TSYSCALL0(acct, 0x59, 0x59)
__TSYSCALL0(capget, 0x5a, 0x5a)
__TSYSCALL0(capset, 0x5b, 0x5b)
__TSYSCALL0(personality, 0x5c, 0x5c)
__TSYSCALL0(exit, 0x5d, 0x5d)
__TSYSCALL0(exit_group, 0x5e, 0x5e)
__TSYSCALL0(waitid, 0x5f, 0x5f)
__TSYSCALL0(set_tid_address, 0x60, 0x60)
__TSYSCALL0(unshare, 0x61, 0x61)
__TSYSCALL0(futex, 0x62, 0x62)
__TSYSCALL0(set_robust_list, 0x63, 0x63)
__TSYSCALL0(get_robust_list, 0x64, 0x64)
__TSYSCALL0(nanosleep, 0x65, 0x65)
__TSYSCALL0(getitimer, 0x66, 0x66)
__TSYSCALL0(setitimer, 0x67, 0x67)
__TSYSCALL0(kexec_load, 0x68, 0x68)
__TSYSCALL0(init_module, 0x69, 0x69)
__TSYSCALL0(delete_module, 0x6a, 0x6a)
__TSYSCALL0(timer_create, 0x6b, 0x6b)
__TSYSCALL0(timer_gettime, 0x6c, 0x6c)
__TSYSCALL0(timer_getoverrun, 0x6d, 0x6d)
__TSYSCALL0(timer_settime, 0x6e, 0x6e)
__TSYSCALL0(timer_delete, 0x6f, 0x6f)
__TSYSCALL0(clock_settime, 0x70, 0x70)
__TSYSCALL0(clock_gettime, 0x71, 0x71)
__TSYSCALL0(clock_getres, 0x72, 0x72)
__TSYSCALL0(clock_nanosleep, 0x73, 0x73)
__TSYSCALL0(syslog, 0x74, 0x74)
__TSYSCALL0(ptrace, 0x75, 0x75)
__TSYSCALL0(sched_setparam, 0x76, 0x76)
__TSYSCALL0(sched_setscheduler, 0x77, 0x77)
__TSYSCALL0(sched_getscheduler, 0x78, 0x78)
__TSYSCALL0(sched_getparam, 0x79, 0x79)
__TSYSCALL0(sched_setaffinity, 0x7a, 0x7a)
__TSYSCALL0(sched_getaffinity, 0x7b, 0x7b)
__TSYSCALL0(sched_yield, 0x7c, 0x7c)
__TSYSCALL0(sched_get_priority_max, 0x7d, 0x7d)
__TSYSCALL0(sched_get_priority_min, 0x7e, 0x7e)
__TSYSCALL0(sched_rr_get_interval, 0x7f, 0x7f)
__TSYSCALL0(restart_syscall, 0x80, 0x80)
__TSYSCALL0(kill, 0x81, 0x81)
__TSYSCALL0(tkill, 0x82, 0x82)
__TSYSCALL0(tgkill, 0x83, 0x83)
__TSYSCALL0(sigaltstack, 0x84, 0x84)
__TSYSCALL0(rt_sigsuspend, 0x85, 0x85)
__TSYSCALL0(rt_sigaction, 0x86, 0x86)
__TSYSCALL0(rt_sigprocmask, 0x87, 0x87)
__TSYSCALL0(rt_sigpending, 0x88, 0x88)
__TSYSCALL0(rt_sigtimedwait, 0x89, 0x89)
__TSYSCALL0(rt_sigqueueinfo, 0x8a, 0x8a)
__TSYSCALL0(rt_sigreturn, 0x8b, 0x8b)
__TSYSCALL0(setpriority, 0x8c, 0x8c)
__TSYSCALL0(getpriority, 0x8d, 0x8d)
__TSYSCALL0(reboot, 0x8e, 0x8e)
__TSYSCALL0(setregid, 0x8f, 0x8f)
__TSYSCALL0(setgid, 0x90, 0x90)
__TSYSCALL0(setreuid, 0x91, 0x91)
__TSYSCALL0(setuid, 0x92, 0x92)
__TSYSCALL0(setresuid, 0x93, 0x93)
__TSYSCALL0(getresuid, 0x94, 0x94)
__TSYSCALL0(setresgid, 0x95, 0x95)
__TSYSCALL0(getresgid, 0x96, 0x96)
__TSYSCALL0(setfsuid, 0x97, 0x97)
__TSYSCALL0(setfsgid, 0x98, 0x98)
__TSYSCALL0(times, 0x99, 0x99)
__TSYSCALL0(setpgid, 0x9a, 0x9a)
__TSYSCALL0(getpgid, 0x9b, 0x9b)
__TSYSCALL0(getsid, 0x9c, 0x9c)
__TSYSCALL0(setsid, 0x9d, 0x9d)
__TSYSCALL0(getgroups, 0x9e, 0x9e)
__TSYSCALL0(setgroups, 0x9f, 0x9f)
__TSYSCALL0(uname, 0xa0, 0xa0)
__TSYSCALL0(sethostname, 0xa1, 0xa1)
__TSYSCALL0(setdomainname, 0xa2, 0xa2)
__TSYSCALL0(getrlimit, 0xa3, 0xa3)
__TSYSCALL0(setrlimit, 0xa4, 0xa4)
__TSYSCALL0(getrusage, 0xa5, 0xa5)
__TSYSCALL0(umask, 0xa6, 0xa6)
__TSYSCALL0(prctl, 0xa7, 0xa7)
__TSYSCALL0(getcpu, 0xa8, 0xa8)
__TSYSCALL0(gettimeofday, 0xa9, 0xa9)
__TSYSCALL0(settimeofday, 0xaa, 0xaa)
__TSYSCALL0(adjtimex, 0xab, 0xab)
__TSYSCALL0(getpid, 0xac, 0xac)
__TSYSCALL0(getppid, 0xad, 0xad)
__TSYSCALL0(getuid, 0xae, 0xae)
__TSYSCALL0(geteuid, 0xaf, 0xaf)
__TSYSCALL0(getgid, 0xb0, 0xb0)
__TSYSCALL0(getegid, 0xb1, 0xb1)
__TSYSCALL0(gettid, 0xb2, 0xb2)
__TSYSCALL0(sysinfo, 0xb3, 0xb3)
__TSYSCALL0(mq_open, 0xb4, 0xb4)
__TSYSCALL0(mq_unlink, 0xb5, 0xb5)
__TSYSCALL0(mq_timedsend, 0xb6, 0xb6)
__TSYSCALL0(mq_timedreceive, 0xb7, 0xb7)
__TSYSCALL0(mq_notify, 0xb8, 0xb8)
__TSYSCALL0(mq_getsetattr, 0xb9, 0xb9)
__TSYSCALL0(msgget, 0xba, 0xba)
__TSYSCALL0(msgctl, 0xbb, 0xbb)
__TSYSCALL0(msgrcv, 0xbc, 0xbc)
__TSYSCALL0(msgsnd, 0xbd, 0xbd)
__TSYSCALL0(semget, 0xbe, 0xbe)
__TSYSCALL0(semctl, 0xbf, 0xbf)
__TSYSCALL0(semtimedop, 0xc0, 0xc0)
__TSYSCALL0(semop, 0xc1, 0xc1)
__TSYSCALL0(shmget, 0xc2, 0xc2)
__TSYSCALL0(shmctl, 0xc3, 0xc3)
__TSYSCALL0(shmat, 0xc4, 0xc4)
__TSYSCALL0(shmdt, 0xc5, 0xc5)
__TSYSCALL0(socket, 0xc6, 0xc6)
__TSYSCALL0(socketpair, 0xc7, 0xc7)
__TSYSCALL0(bind, 0xc8, 0xc8)
__TSYSCALL0(listen, 0xc9, 0xc9)
__TSYSCALL0(accept, 0xca, 0xca)
__TSYSCALL0(connect, 0xcb, 0xcb)
__TSYSCALL0(getsockname, 0xcc, 0xcc)
__TSYSCALL0(getpeername, 0xcd, 0xcd)
__TSYSCALL0(sendto, 0xce, 0xce)
__TSYSCALL0(recvfrom, 0xcf, 0xcf)
__TSYSCALL0(setsockopt, 0xd0, 0xd0)
__TSYSCALL0(getsockopt, 0xd1, 0xd1)
__TSYSCALL0(shutdown, 0xd2, 0xd2)
__TSYSCALL0(sendmsg, 0xd3, 0xd3)
__TSYSCALL0(recvmsg, 0xd4, 0xd4)
__TSYSCALL0(readahead, 0xd5, 0xd5)
__TSYSCALL0(brk, 0xd6, 0xd6)
__TSYSCALL0(munmap, 0xd7, 0xd7)
__TSYSCALL0(mremap, 0xd8, 0xd8)
__TSYSCALL0(add_key, 0xd9, 0xd9)
__TSYSCALL0(request_key, 0xda, 0xda)
__TSYSCALL0(keyctl, 0xdb, 0xdb)
__TSYSCALL0(clone, 0xdc, 0xdc)
__TSYSCALL0(execve, 0xdd, 0xdd)
__TSYSCALL0_UNUSED(0xde, 0xde, 0xde)
__TSYSCALL0_UNUSED(0xdf, 0xdf, 0xdf)
__TSYSCALL0(swapon, 0xe0, 0xe0)
__TSYSCALL0(swapoff, 0xe1, 0xe1)
__TSYSCALL0(mprotect, 0xe2, 0xe2)
__TSYSCALL0(msync, 0xe3, 0xe3)
__TSYSCALL0(mlock, 0xe4, 0xe4)
__TSYSCALL0(munlock, 0xe5, 0xe5)
__TSYSCALL0(mlockall, 0xe6, 0xe6)
__TSYSCALL0(munlockall, 0xe7, 0xe7)
__TSYSCALL0(mincore, 0xe8, 0xe8)
__TSYSCALL0(madvise, 0xe9, 0xe9)
__TSYSCALL0(remap_file_pages, 0xea, 0xea)
__TSYSCALL0(mbind, 0xeb, 0xeb)
__TSYSCALL0(get_mempolicy, 0xec, 0xec)
__TSYSCALL0(set_mempolicy, 0xed, 0xed)
__TSYSCALL0(migrate_pages, 0xee, 0xee)
__TSYSCALL0(move_pages, 0xef, 0xef)
__TSYSCALL0(rt_tgsigqueueinfo, 0xf0, 0xf0)
__TSYSCALL0(perf_event_open, 0xf1, 0xf1)
__TSYSCALL0(accept4, 0xf2, 0xf2)
__TSYSCALL0(recvmmsg, 0xf3, 0xf3)
__TSYSCALL0_UNUSED(0xf4, 0xf4, 0xf4)
__TSYSCALL0_UNUSED(0xf5, 0xf5, 0xf5)
__TSYSCALL0_UNUSED(0xf6, 0xf6, 0xf6)
__TSYSCALL0_UNUSED(0xf7, 0xf7, 0xf7)
__TSYSCALL0_UNUSED(0xf8, 0xf8, 0xf8)
__TSYSCALL0_UNUSED(0xf9, 0xf9, 0xf9)
__TSYSCALL0_UNUSED(0xfa, 0xfa, 0xfa)
__TSYSCALL0_UNUSED(0xfb, 0xfb, 0xfb)
__TSYSCALL0_UNUSED(0xfc, 0xfc, 0xfc)
__TSYSCALL0_UNUSED(0xfd, 0xfd, 0xfd)
__TSYSCALL0_UNUSED(0xfe, 0xfe, 0xfe)
__TSYSCALL0_UNUSED(0xff, 0xff, 0xff)
__TSYSCALL0_UNUSED(0x100, 0x100, 0x100)
__TSYSCALL0_UNUSED(0x101, 0x101, 0x101)
__TSYSCALL0_UNUSED(0x102, 0x102, 0x102)
__TSYSCALL0_UNUSED(0x103, 0x103, 0x103)
__TSYSCALL0(wait4, 0x104, 0x104)
__TSYSCALL0(prlimit64, 0x105, 0x105)
__TSYSCALL0(fanotify_init, 0x106, 0x106)
__TSYSCALL0(fanotify_mark, 0x107, 0x107)
__TSYSCALL0(name_to_handle_at, 0x108, 0x108)
__TSYSCALL0(open_by_handle_at, 0x109, 0x109)
__TSYSCALL0(clock_adjtime, 0x10a, 0x10a)
__TSYSCALL0(syncfs, 0x10b, 0x10b)
__TSYSCALL0(setns, 0x10c, 0x10c)
__TSYSCALL0(sendmmsg, 0x10d, 0x10d)
__TSYSCALL0(process_vm_readv, 0x10e, 0x10e)
__TSYSCALL0(process_vm_writev, 0x10f, 0x10f)
__TSYSCALL0(kcmp, 0x110, 0x110)
__TSYSCALL0(finit_module, 0x111, 0x111)
__TSYSCALL0(sched_setattr, 0x112, 0x112)
__TSYSCALL0(sched_getattr, 0x113, 0x113)
__TSYSCALL0(renameat2, 0x114, 0x114)
__TSYSCALL0(seccomp, 0x115, 0x115)
__TSYSCALL0(getrandom, 0x116, 0x116)
__TSYSCALL0(memfd_create, 0x117, 0x117)
__TSYSCALL0(bpf, 0x118, 0x118)
__TSYSCALL0(execveat, 0x119, 0x119)
__TSYSCALL0(userfaultfd, 0x11a, 0x11a)
__TSYSCALL0(membarrier, 0x11b, 0x11b)
__TSYSCALL0(mlock2, 0x11c, 0x11c)
__TSYSCALL0_UNUSED(0x11d, 0x11d, 0x11d)
__TSYSCALL0_UNUSED(0x11e, 0x11e, 0x11e)
__TSYSCALL0_UNUSED(0x11f, 0x11f, 0x11f)
__TSYSCALL0_UNUSED(0x120, 0x120, 0x120)
__TSYSCALL0_UNUSED(0x121, 0x121, 0x121)
__TSYSCALL0_UNUSED(0x122, 0x122, 0x122)
__TSYSCALL0_UNUSED(0x123, 0x123, 0x123)
__TSYSCALL0_UNUSED(0x124, 0x124, 0x124)
__TSYSCALL0_UNUSED(0x125, 0x125, 0x125)
__TSYSCALL0_UNUSED(0x126, 0x126, 0x126)
__TSYSCALL0_UNUSED(0x127, 0x127, 0x127)
__TSYSCALL0_UNUSED(0x128, 0x128, 0x128)
__TSYSCALL0_UNUSED(0x129, 0x129, 0x129)
__TSYSCALL0_UNUSED(0x12a, 0x12a, 0x12a)
__TSYSCALL0_UNUSED(0x12b, 0x12b, 0x12b)
__TSYSCALL0_UNUSED(0x12c, 0x12c, 0x12c)
__TSYSCALL0_UNUSED(0x12d, 0x12d, 0x12d)
__TSYSCALL0_UNUSED(0x12e, 0x12e, 0x12e)
__TSYSCALL0_UNUSED(0x12f, 0x12f, 0x12f)
__TSYSCALL0_UNUSED(0x130, 0x130, 0x130)
__TSYSCALL0_UNUSED(0x131, 0x131, 0x131)
__TSYSCALL0_UNUSED(0x132, 0x132, 0x132)
__TSYSCALL0_UNUSED(0x133, 0x133, 0x133)
__TSYSCALL0_UNUSED(0x134, 0x134, 0x134)
__TSYSCALL0_UNUSED(0x135, 0x135, 0x135)
__TSYSCALL0_UNUSED(0x136, 0x136, 0x136)
__TSYSCALL0_UNUSED(0x137, 0x137, 0x137)
__TSYSCALL0_UNUSED(0x138, 0x138, 0x138)
__TSYSCALL0_UNUSED(0x139, 0x139, 0x139)
__TSYSCALL0_UNUSED(0x13a, 0x13a, 0x13a)
__TSYSCALL0_UNUSED(0x13b, 0x13b, 0x13b)
__TSYSCALL0_UNUSED(0x13c, 0x13c, 0x13c)
__TSYSCALL0_UNUSED(0x13d, 0x13d, 0x13d)
__TSYSCALL0_UNUSED(0x13e, 0x13e, 0x13e)
__TSYSCALL0_UNUSED(0x13f, 0x13f, 0x13f)
__TSYSCALL0_UNUSED(0x140, 0x140, 0x140)
__TSYSCALL0_UNUSED(0x141, 0x141, 0x141)
__TSYSCALL0_UNUSED(0x142, 0x142, 0x142)
__TSYSCALL0_UNUSED(0x143, 0x143, 0x143)
__TSYSCALL0_UNUSED(0x144, 0x144, 0x144)
__TSYSCALL0_UNUSED(0x145, 0x145, 0x145)
__TSYSCALL0_UNUSED(0x146, 0x146, 0x146)
__TSYSCALL0_UNUSED(0x147, 0x147, 0x147)
__TSYSCALL0_UNUSED(0x148, 0x148, 0x148)
__TSYSCALL0_UNUSED(0x149, 0x149, 0x149)
__TSYSCALL0_UNUSED(0x14a, 0x14a, 0x14a)
__TSYSCALL0_UNUSED(0x14b, 0x14b, 0x14b)
__TSYSCALL0_UNUSED(0x14c, 0x14c, 0x14c)
__TSYSCALL0_UNUSED(0x14d, 0x14d, 0x14d)
__TSYSCALL0_UNUSED(0x14e, 0x14e, 0x14e)
__TSYSCALL0_UNUSED(0x14f, 0x14f, 0x14f)
__TSYSCALL0_UNUSED(0x150, 0x150, 0x150)
__TSYSCALL0_UNUSED(0x151, 0x151, 0x151)
__TSYSCALL0_UNUSED(0x152, 0x152, 0x152)
__TSYSCALL0_UNUSED(0x153, 0x153, 0x153)
__TSYSCALL0_UNUSED(0x154, 0x154, 0x154)
__TSYSCALL0_UNUSED(0x155, 0x155, 0x155)
__TSYSCALL0_UNUSED(0x156, 0x156, 0x156)
__TSYSCALL0_UNUSED(0x157, 0x157, 0x157)
__TSYSCALL0_UNUSED(0x158, 0x158, 0x158)
__TSYSCALL0_UNUSED(0x159, 0x159, 0x159)
__TSYSCALL0_UNUSED(0x15a, 0x15a, 0x15a)
__TSYSCALL0_UNUSED(0x15b, 0x15b, 0x15b)
__TSYSCALL0_UNUSED(0x15c, 0x15c, 0x15c)
__TSYSCALL0_UNUSED(0x15d, 0x15d, 0x15d)
__TSYSCALL0_UNUSED(0x15e, 0x15e, 0x15e)
__TSYSCALL0_UNUSED(0x15f, 0x15f, 0x15f)
__TSYSCALL0_UNUSED(0x160, 0x160, 0x160)
__TSYSCALL0_UNUSED(0x161, 0x161, 0x161)
__TSYSCALL0_UNUSED(0x162, 0x162, 0x162)
__TSYSCALL0_UNUSED(0x163, 0x163, 0x163)
__TSYSCALL0_UNUSED(0x164, 0x164, 0x164)
__TSYSCALL0_UNUSED(0x165, 0x165, 0x165)
__TSYSCALL0_UNUSED(0x166, 0x166, 0x166)
__TSYSCALL0_UNUSED(0x167, 0x167, 0x167)
__TSYSCALL0_UNUSED(0x168, 0x168, 0x168)
__TSYSCALL0_UNUSED(0x169, 0x169, 0x169)
__TSYSCALL0_UNUSED(0x16a, 0x16a, 0x16a)
__TSYSCALL0_UNUSED(0x16b, 0x16b, 0x16b)
__TSYSCALL0_UNUSED(0x16c, 0x16c, 0x16c)
__TSYSCALL0_UNUSED(0x16d, 0x16d, 0x16d)
__TSYSCALL0_UNUSED(0x16e, 0x16e, 0x16e)
__TSYSCALL0_UNUSED(0x16f, 0x16f, 0x16f)
__TSYSCALL0_UNUSED(0x170, 0x170, 0x170)
__TSYSCALL0_UNUSED(0x171, 0x171, 0x171)
__TSYSCALL0_UNUSED(0x172, 0x172, 0x172)
__TSYSCALL0_UNUSED(0x173, 0x173, 0x173)
__TSYSCALL0_UNUSED(0x174, 0x174, 0x174)
__TSYSCALL0_UNUSED(0x175, 0x175, 0x175)
__TSYSCALL0_UNUSED(0x176, 0x176, 0x176)
__TSYSCALL0_UNUSED(0x177, 0x177, 0x177)
__TSYSCALL0_UNUSED(0x178, 0x178, 0x178)
__TSYSCALL0_UNUSED(0x179, 0x179, 0x179)
__TSYSCALL0_UNUSED(0x17a, 0x17a, 0x17a)
__TSYSCALL0_UNUSED(0x17b, 0x17b, 0x17b)
__TSYSCALL0_UNUSED(0x17c, 0x17c, 0x17c)
__TSYSCALL0_UNUSED(0x17d, 0x17d, 0x17d)
__TSYSCALL0_UNUSED(0x17e, 0x17e, 0x17e)
__TSYSCALL0_UNUSED(0x17f, 0x17f, 0x17f)
__TSYSCALL0_UNUSED(0x180, 0x180, 0x180)
__TSYSCALL0_UNUSED(0x181, 0x181, 0x181)
__TSYSCALL0_UNUSED(0x182, 0x182, 0x182)
__TSYSCALL0_UNUSED(0x183, 0x183, 0x183)
__TSYSCALL0_UNUSED(0x184, 0x184, 0x184)
__TSYSCALL0_UNUSED(0x185, 0x185, 0x185)
__TSYSCALL0_UNUSED(0x186, 0x186, 0x186)
__TSYSCALL0_UNUSED(0x187, 0x187, 0x187)
__TSYSCALL0_UNUSED(0x188, 0x188, 0x188)
__TSYSCALL0_UNUSED(0x189, 0x189, 0x189)
__TSYSCALL0_UNUSED(0x18a, 0x18a, 0x18a)
__TSYSCALL0_UNUSED(0x18b, 0x18b, 0x18b)
__TSYSCALL0_UNUSED(0x18c, 0x18c, 0x18c)
__TSYSCALL0_UNUSED(0x18d, 0x18d, 0x18d)
__TSYSCALL0_UNUSED(0x18e, 0x18e, 0x18e)
__TSYSCALL0_UNUSED(0x18f, 0x18f, 0x18f)
__TSYSCALL0_UNUSED(0x190, 0x190, 0x190)
__TSYSCALL0_UNUSED(0x191, 0x191, 0x191)
__TSYSCALL0_UNUSED(0x192, 0x192, 0x192)
__TSYSCALL0_UNUSED(0x193, 0x193, 0x193)
__TSYSCALL0_UNUSED(0x194, 0x194, 0x194)
__TSYSCALL0_UNUSED(0x195, 0x195, 0x195)
__TSYSCALL0_UNUSED(0x196, 0x196, 0x196)
__TSYSCALL0_UNUSED(0x197, 0x197, 0x197)
__TSYSCALL0_UNUSED(0x198, 0x198, 0x198)
__TSYSCALL0_UNUSED(0x199, 0x199, 0x199)
__TSYSCALL0_UNUSED(0x19a, 0x19a, 0x19a)
__TSYSCALL0_UNUSED(0x19b, 0x19b, 0x19b)
__TSYSCALL0_UNUSED(0x19c, 0x19c, 0x19c)
__TSYSCALL0_UNUSED(0x19d, 0x19d, 0x19d)
__TSYSCALL0_UNUSED(0x19e, 0x19e, 0x19e)
__TSYSCALL0_UNUSED(0x19f, 0x19f, 0x19f)
__TSYSCALL0_UNUSED(0x1a0, 0x1a0, 0x1a0)
__TSYSCALL0_UNUSED(0x1a1, 0x1a1, 0x1a1)
__TSYSCALL0_UNUSED(0x1a2, 0x1a2, 0x1a2)
__TSYSCALL0_UNUSED(0x1a3, 0x1a3, 0x1a3)
__TSYSCALL0_UNUSED(0x1a4, 0x1a4, 0x1a4)
__TSYSCALL0_UNUSED(0x1a5, 0x1a5, 0x1a5)
__TSYSCALL0_UNUSED(0x1a6, 0x1a6, 0x1a6)
__TSYSCALL0_UNUSED(0x1a7, 0x1a7, 0x1a7)
__TSYSCALL0_UNUSED(0x1a8, 0x1a8, 0x1a8)
__TSYSCALL0_UNUSED(0x1a9, 0x1a9, 0x1a9)
__TSYSCALL0_UNUSED(0x1aa, 0x1aa, 0x1aa)
__TSYSCALL0_UNUSED(0x1ab, 0x1ab, 0x1ab)
__TSYSCALL0_UNUSED(0x1ac, 0x1ac, 0x1ac)
__TSYSCALL0_UNUSED(0x1ad, 0x1ad, 0x1ad)
__TSYSCALL0_UNUSED(0x1ae, 0x1ae, 0x1ae)
__TSYSCALL0_UNUSED(0x1af, 0x1af, 0x1af)
__TSYSCALL0_UNUSED(0x1b0, 0x1b0, 0x1b0)
__TSYSCALL0_UNUSED(0x1b1, 0x1b1, 0x1b1)
__TSYSCALL0_UNUSED(0x1b2, 0x1b2, 0x1b2)
__TSYSCALL0_UNUSED(0x1b3, 0x1b3, 0x1b3)
__TSYSCALL0_UNUSED(0x1b4, 0x1b4, 0x1b4)
__TSYSCALL0_UNUSED(0x1b5, 0x1b5, 0x1b5)
__TSYSCALL0_UNUSED(0x1b6, 0x1b6, 0x1b6)
__TSYSCALL0_UNUSED(0x1b7, 0x1b7, 0x1b7)
__TSYSCALL0_UNUSED(0x1b8, 0x1b8, 0x1b8)
__TSYSCALL0_UNUSED(0x1b9, 0x1b9, 0x1b9)
__TSYSCALL0_UNUSED(0x1ba, 0x1ba, 0x1ba)
__TSYSCALL0_UNUSED(0x1bb, 0x1bb, 0x1bb)
__TSYSCALL0_UNUSED(0x1bc, 0x1bc, 0x1bc)
__TSYSCALL0_UNUSED(0x1bd, 0x1bd, 0x1bd)
__TSYSCALL0_UNUSED(0x1be, 0x1be, 0x1be)
__TSYSCALL0_UNUSED(0x1bf, 0x1bf, 0x1bf)
__TSYSCALL0_UNUSED(0x1c0, 0x1c0, 0x1c0)
__TSYSCALL0_UNUSED(0x1c1, 0x1c1, 0x1c1)
__TSYSCALL0_UNUSED(0x1c2, 0x1c2, 0x1c2)
__TSYSCALL0_UNUSED(0x1c3, 0x1c3, 0x1c3)
__TSYSCALL0_UNUSED(0x1c4, 0x1c4, 0x1c4)
__TSYSCALL0_UNUSED(0x1c5, 0x1c5, 0x1c5)
__TSYSCALL0_UNUSED(0x1c6, 0x1c6, 0x1c6)
__TSYSCALL0_UNUSED(0x1c7, 0x1c7, 0x1c7)
__TSYSCALL0_UNUSED(0x1c8, 0x1c8, 0x1c8)
__TSYSCALL0_UNUSED(0x1c9, 0x1c9, 0x1c9)
__TSYSCALL0_UNUSED(0x1ca, 0x1ca, 0x1ca)
__TSYSCALL0_UNUSED(0x1cb, 0x1cb, 0x1cb)
__TSYSCALL0_UNUSED(0x1cc, 0x1cc, 0x1cc)
__TSYSCALL0_UNUSED(0x1cd, 0x1cd, 0x1cd)
__TSYSCALL0_UNUSED(0x1ce, 0x1ce, 0x1ce)
__TSYSCALL0_UNUSED(0x1cf, 0x1cf, 0x1cf)
__TSYSCALL0_UNUSED(0x1d0, 0x1d0, 0x1d0)
__TSYSCALL0_UNUSED(0x1d1, 0x1d1, 0x1d1)
__TSYSCALL0_UNUSED(0x1d2, 0x1d2, 0x1d2)
__TSYSCALL0_UNUSED(0x1d3, 0x1d3, 0x1d3)
__TSYSCALL0_UNUSED(0x1d4, 0x1d4, 0x1d4)
__TSYSCALL0_UNUSED(0x1d5, 0x1d5, 0x1d5)
__TSYSCALL0_UNUSED(0x1d6, 0x1d6, 0x1d6)
__TSYSCALL0_UNUSED(0x1d7, 0x1d7, 0x1d7)
__TSYSCALL0_UNUSED(0x1d8, 0x1d8, 0x1d8)
__TSYSCALL0_UNUSED(0x1d9, 0x1d9, 0x1d9)
__TSYSCALL0_UNUSED(0x1da, 0x1da, 0x1da)
__TSYSCALL0_UNUSED(0x1db, 0x1db, 0x1db)
__TSYSCALL0_UNUSED(0x1dc, 0x1dc, 0x1dc)
__TSYSCALL0_UNUSED(0x1dd, 0x1dd, 0x1dd)
__TSYSCALL0_UNUSED(0x1de, 0x1de, 0x1de)
__TSYSCALL0_UNUSED(0x1df, 0x1df, 0x1df)
__TSYSCALL0_UNUSED(0x1e0, 0x1e0, 0x1e0)
__TSYSCALL0_UNUSED(0x1e1, 0x1e1, 0x1e1)
__TSYSCALL0_UNUSED(0x1e2, 0x1e2, 0x1e2)
__TSYSCALL0_UNUSED(0x1e3, 0x1e3, 0x1e3)
__TSYSCALL0_UNUSED(0x1e4, 0x1e4, 0x1e4)
__TSYSCALL0_UNUSED(0x1e5, 0x1e5, 0x1e5)
__TSYSCALL0_UNUSED(0x1e6, 0x1e6, 0x1e6)
__TSYSCALL0_UNUSED(0x1e7, 0x1e7, 0x1e7)
__TSYSCALL0_UNUSED(0x1e8, 0x1e8, 0x1e8)
__TSYSCALL0_UNUSED(0x1e9, 0x1e9, 0x1e9)
__TSYSCALL0_UNUSED(0x1ea, 0x1ea, 0x1ea)
__TSYSCALL0_UNUSED(0x1eb, 0x1eb, 0x1eb)
__TSYSCALL0_UNUSED(0x1ec, 0x1ec, 0x1ec)
__TSYSCALL0_UNUSED(0x1ed, 0x1ed, 0x1ed)
__TSYSCALL0_UNUSED(0x1ee, 0x1ee, 0x1ee)
__TSYSCALL0_UNUSED(0x1ef, 0x1ef, 0x1ef)
__TSYSCALL0_UNUSED(0x1f0, 0x1f0, 0x1f0)
__TSYSCALL0_UNUSED(0x1f1, 0x1f1, 0x1f1)
__TSYSCALL0_UNUSED(0x1f2, 0x1f2, 0x1f2)
__TSYSCALL0_UNUSED(0x1f3, 0x1f3, 0x1f3)
__TSYSCALL0_UNUSED(0x1f4, 0x1f4, 0x1f4)
__TSYSCALL0_UNUSED(0x1f5, 0x1f5, 0x1f5)
__TSYSCALL0_UNUSED(0x1f6, 0x1f6, 0x1f6)
__TSYSCALL0_UNUSED(0x1f7, 0x1f7, 0x1f7)
__TSYSCALL0_UNUSED(0x1f8, 0x1f8, 0x1f8)
__TSYSCALL0_UNUSED(0x1f9, 0x1f9, 0x1f9)
__TSYSCALL0_UNUSED(0x1fa, 0x1fa, 0x1fa)
__TSYSCALL0_UNUSED(0x1fb, 0x1fb, 0x1fb)
__TSYSCALL0_UNUSED(0x1fc, 0x1fc, 0x1fc)
__TSYSCALL0_UNUSED(0x1fd, 0x1fd, 0x1fd)
__TSYSCALL0_UNUSED(0x1fe, 0x1fe, 0x1fe)
__TSYSCALL0_UNUSED(0x1ff, 0x1ff, 0x1ff)
__TSYSCALL0_UNUSED(0x200, 0x200, 0x200)
__TSYSCALL0_UNUSED(0x201, 0x201, 0x201)
__TSYSCALL0_UNUSED(0x202, 0x202, 0x202)
__TSYSCALL0_UNUSED(0x203, 0x203, 0x203)
__TSYSCALL0_UNUSED(0x204, 0x204, 0x204)
__TSYSCALL0_UNUSED(0x205, 0x205, 0x205)
__TSYSCALL0_UNUSED(0x206, 0x206, 0x206)
__TSYSCALL0_UNUSED(0x207, 0x207, 0x207)
__TSYSCALL0_UNUSED(0x208, 0x208, 0x208)
__TSYSCALL0_UNUSED(0x209, 0x209, 0x209)
__TSYSCALL0_UNUSED(0x20a, 0x20a, 0x20a)
__TSYSCALL0_UNUSED(0x20b, 0x20b, 0x20b)
__TSYSCALL0_UNUSED(0x20c, 0x20c, 0x20c)
__TSYSCALL0_UNUSED(0x20d, 0x20d, 0x20d)
__TSYSCALL0_UNUSED(0x20e, 0x20e, 0x20e)
__TSYSCALL0_UNUSED(0x20f, 0x20f, 0x20f)
__TSYSCALL0_UNUSED(0x210, 0x210, 0x210)
__TSYSCALL0_UNUSED(0x211, 0x211, 0x211)
__TSYSCALL0_UNUSED(0x212, 0x212, 0x212)
__TSYSCALL0_UNUSED(0x213, 0x213, 0x213)
__TSYSCALL0_UNUSED(0x214, 0x214, 0x214)
__TSYSCALL0_UNUSED(0x215, 0x215, 0x215)
__TSYSCALL0_UNUSED(0x216, 0x216, 0x216)
__TSYSCALL0_UNUSED(0x217, 0x217, 0x217)
__TSYSCALL0_UNUSED(0x218, 0x218, 0x218)
__TSYSCALL0_UNUSED(0x219, 0x219, 0x219)
__TSYSCALL0_UNUSED(0x21a, 0x21a, 0x21a)
__TSYSCALL0_UNUSED(0x21b, 0x21b, 0x21b)
__TSYSCALL0_UNUSED(0x21c, 0x21c, 0x21c)
__TSYSCALL0_UNUSED(0x21d, 0x21d, 0x21d)
__TSYSCALL0_UNUSED(0x21e, 0x21e, 0x21e)
__TSYSCALL0_UNUSED(0x21f, 0x21f, 0x21f)
__TSYSCALL0_UNUSED(0x220, 0x220, 0x220)
__TSYSCALL0_UNUSED(0x221, 0x221, 0x221)
__TSYSCALL0_UNUSED(0x222, 0x222, 0x222)
__TSYSCALL0_UNUSED(0x223, 0x223, 0x223)
__TSYSCALL0_UNUSED(0x224, 0x224, 0x224)
__TSYSCALL0_UNUSED(0x225, 0x225, 0x225)
__TSYSCALL0_UNUSED(0x226, 0x226, 0x226)
__TSYSCALL0_UNUSED(0x227, 0x227, 0x227)
__TSYSCALL0_UNUSED(0x228, 0x228, 0x228)
__TSYSCALL0_UNUSED(0x229, 0x229, 0x229)
__TSYSCALL0_UNUSED(0x22a, 0x22a, 0x22a)
__TSYSCALL0_UNUSED(0x22b, 0x22b, 0x22b)
__TSYSCALL0_UNUSED(0x22c, 0x22c, 0x22c)
__TSYSCALL0_UNUSED(0x22d, 0x22d, 0x22d)
__TSYSCALL0_UNUSED(0x22e, 0x22e, 0x22e)
__TSYSCALL0_UNUSED(0x22f, 0x22f, 0x22f)
__TSYSCALL0_UNUSED(0x230, 0x230, 0x230)
__TSYSCALL0_UNUSED(0x231, 0x231, 0x231)
__TSYSCALL0_UNUSED(0x232, 0x232, 0x232)
__TSYSCALL0_UNUSED(0x233, 0x233, 0x233)
__TSYSCALL0_UNUSED(0x234, 0x234, 0x234)
__TSYSCALL0_UNUSED(0x235, 0x235, 0x235)
__TSYSCALL0_UNUSED(0x236, 0x236, 0x236)
__TSYSCALL0_UNUSED(0x237, 0x237, 0x237)
__TSYSCALL0_UNUSED(0x238, 0x238, 0x238)
__TSYSCALL0_UNUSED(0x239, 0x239, 0x239)
__TSYSCALL0_UNUSED(0x23a, 0x23a, 0x23a)
__TSYSCALL0_UNUSED(0x23b, 0x23b, 0x23b)
__TSYSCALL0_UNUSED(0x23c, 0x23c, 0x23c)
__TSYSCALL0_UNUSED(0x23d, 0x23d, 0x23d)
__TSYSCALL0_UNUSED(0x23e, 0x23e, 0x23e)
__TSYSCALL0_UNUSED(0x23f, 0x23f, 0x23f)
__TSYSCALL0_UNUSED(0x240, 0x240, 0x240)
__TSYSCALL0_UNUSED(0x241, 0x241, 0x241)
__TSYSCALL0_UNUSED(0x242, 0x242, 0x242)
__TSYSCALL0_UNUSED(0x243, 0x243, 0x243)
__TSYSCALL0_UNUSED(0x244, 0x244, 0x244)
__TSYSCALL0_UNUSED(0x245, 0x245, 0x245)
__TSYSCALL0_UNUSED(0x246, 0x246, 0x246)
__TSYSCALL0_UNUSED(0x247, 0x247, 0x247)
__TSYSCALL0_UNUSED(0x248, 0x248, 0x248)
__TSYSCALL0_UNUSED(0x249, 0x249, 0x249)
__TSYSCALL0_UNUSED(0x24a, 0x24a, 0x24a)
__TSYSCALL0_UNUSED(0x24b, 0x24b, 0x24b)
__TSYSCALL0_UNUSED(0x24c, 0x24c, 0x24c)
__TSYSCALL0_UNUSED(0x24d, 0x24d, 0x24d)
__TSYSCALL0_UNUSED(0x24e, 0x24e, 0x24e)
__TSYSCALL0_UNUSED(0x24f, 0x24f, 0x24f)
__TSYSCALL0_UNUSED(0x250, 0x250, 0x250)
__TSYSCALL0_UNUSED(0x251, 0x251, 0x251)
__TSYSCALL0_UNUSED(0x252, 0x252, 0x252)
__TSYSCALL0_UNUSED(0x253, 0x253, 0x253)
__TSYSCALL0_UNUSED(0x254, 0x254, 0x254)
__TSYSCALL0_UNUSED(0x255, 0x255, 0x255)
__TSYSCALL0_UNUSED(0x256, 0x256, 0x256)
__TSYSCALL0_UNUSED(0x257, 0x257, 0x257)
__TSYSCALL0_UNUSED(0x258, 0x258, 0x258)
__TSYSCALL0_UNUSED(0x259, 0x259, 0x259)
__TSYSCALL0_UNUSED(0x25a, 0x25a, 0x25a)
__TSYSCALL0_UNUSED(0x25b, 0x25b, 0x25b)
__TSYSCALL0_UNUSED(0x25c, 0x25c, 0x25c)
__TSYSCALL0_UNUSED(0x25d, 0x25d, 0x25d)
__TSYSCALL0_UNUSED(0x25e, 0x25e, 0x25e)
__TSYSCALL0_UNUSED(0x25f, 0x25f, 0x25f)
__TSYSCALL0_UNUSED(0x260, 0x260, 0x260)
__TSYSCALL0_UNUSED(0x261, 0x261, 0x261)
__TSYSCALL0_UNUSED(0x262, 0x262, 0x262)
__TSYSCALL0_UNUSED(0x263, 0x263, 0x263)
__TSYSCALL0_UNUSED(0x264, 0x264, 0x264)
__TSYSCALL0_UNUSED(0x265, 0x265, 0x265)
__TSYSCALL0_UNUSED(0x266, 0x266, 0x266)
__TSYSCALL0_UNUSED(0x267, 0x267, 0x267)
__TSYSCALL0_UNUSED(0x268, 0x268, 0x268)
__TSYSCALL0_UNUSED(0x269, 0x269, 0x269)
__TSYSCALL0_UNUSED(0x26a, 0x26a, 0x26a)
__TSYSCALL0_UNUSED(0x26b, 0x26b, 0x26b)
__TSYSCALL0_UNUSED(0x26c, 0x26c, 0x26c)
__TSYSCALL0_UNUSED(0x26d, 0x26d, 0x26d)
__TSYSCALL0_UNUSED(0x26e, 0x26e, 0x26e)
__TSYSCALL0_UNUSED(0x26f, 0x26f, 0x26f)
__TSYSCALL0_UNUSED(0x270, 0x270, 0x270)
__TSYSCALL0_UNUSED(0x271, 0x271, 0x271)
__TSYSCALL0_UNUSED(0x272, 0x272, 0x272)
__TSYSCALL0_UNUSED(0x273, 0x273, 0x273)
__TSYSCALL0_UNUSED(0x274, 0x274, 0x274)
__TSYSCALL0_UNUSED(0x275, 0x275, 0x275)
__TSYSCALL0_UNUSED(0x276, 0x276, 0x276)
__TSYSCALL0_UNUSED(0x277, 0x277, 0x277)
__TSYSCALL0_UNUSED(0x278, 0x278, 0x278)
__TSYSCALL0_UNUSED(0x279, 0x279, 0x279)
__TSYSCALL0_UNUSED(0x27a, 0x27a, 0x27a)
__TSYSCALL0_UNUSED(0x27b, 0x27b, 0x27b)
__TSYSCALL0_UNUSED(0x27c, 0x27c, 0x27c)
__TSYSCALL0_UNUSED(0x27d, 0x27d, 0x27d)
__TSYSCALL0_UNUSED(0x27e, 0x27e, 0x27e)
__TSYSCALL0_UNUSED(0x27f, 0x27f, 0x27f)
__TSYSCALL0_UNUSED(0x280, 0x280, 0x280)
__TSYSCALL0_UNUSED(0x281, 0x281, 0x281)
__TSYSCALL0_UNUSED(0x282, 0x282, 0x282)
__TSYSCALL0_UNUSED(0x283, 0x283, 0x283)
__TSYSCALL0_UNUSED(0x284, 0x284, 0x284)
__TSYSCALL0_UNUSED(0x285, 0x285, 0x285)
__TSYSCALL0_UNUSED(0x286, 0x286, 0x286)
__TSYSCALL0_UNUSED(0x287, 0x287, 0x287)
__TSYSCALL0_UNUSED(0x288, 0x288, 0x288)
__TSYSCALL0_UNUSED(0x289, 0x289, 0x289)
__TSYSCALL0_UNUSED(0x28a, 0x28a, 0x28a)
__TSYSCALL0_UNUSED(0x28b, 0x28b, 0x28b)
__TSYSCALL0_UNUSED(0x28c, 0x28c, 0x28c)
__TSYSCALL0_UNUSED(0x28d, 0x28d, 0x28d)
__TSYSCALL0_UNUSED(0x28e, 0x28e, 0x28e)
__TSYSCALL0_UNUSED(0x28f, 0x28f, 0x28f)
__TSYSCALL0_UNUSED(0x290, 0x290, 0x290)
__TSYSCALL0_UNUSED(0x291, 0x291, 0x291)
__TSYSCALL0_UNUSED(0x292, 0x292, 0x292)
__TSYSCALL0_UNUSED(0x293, 0x293, 0x293)
__TSYSCALL0_UNUSED(0x294, 0x294, 0x294)
__TSYSCALL0_UNUSED(0x295, 0x295, 0x295)
__TSYSCALL0_UNUSED(0x296, 0x296, 0x296)
__TSYSCALL0_UNUSED(0x297, 0x297, 0x297)
__TSYSCALL0_UNUSED(0x298, 0x298, 0x298)
__TSYSCALL0_UNUSED(0x299, 0x299, 0x299)
__TSYSCALL0_UNUSED(0x29a, 0x29a, 0x29a)
__TSYSCALL0_UNUSED(0x29b, 0x29b, 0x29b)
__TSYSCALL0_UNUSED(0x29c, 0x29c, 0x29c)
__TSYSCALL0_UNUSED(0x29d, 0x29d, 0x29d)
__TSYSCALL0_UNUSED(0x29e, 0x29e, 0x29e)
__TSYSCALL0_UNUSED(0x29f, 0x29f, 0x29f)
__TSYSCALL0_UNUSED(0x2a0, 0x2a0, 0x2a0)
__TSYSCALL0_UNUSED(0x2a1, 0x2a1, 0x2a1)
__TSYSCALL0_UNUSED(0x2a2, 0x2a2, 0x2a2)
__TSYSCALL0_UNUSED(0x2a3, 0x2a3, 0x2a3)
__TSYSCALL0_UNUSED(0x2a4, 0x2a4, 0x2a4)
__TSYSCALL0_UNUSED(0x2a5, 0x2a5, 0x2a5)
__TSYSCALL0_UNUSED(0x2a6, 0x2a6, 0x2a6)
__TSYSCALL0_UNUSED(0x2a7, 0x2a7, 0x2a7)
__TSYSCALL0_UNUSED(0x2a8, 0x2a8, 0x2a8)
__TSYSCALL0_UNUSED(0x2a9, 0x2a9, 0x2a9)
__TSYSCALL0_UNUSED(0x2aa, 0x2aa, 0x2aa)
__TSYSCALL0_UNUSED(0x2ab, 0x2ab, 0x2ab)
__TSYSCALL0_UNUSED(0x2ac, 0x2ac, 0x2ac)
__TSYSCALL0_UNUSED(0x2ad, 0x2ad, 0x2ad)
__TSYSCALL0_UNUSED(0x2ae, 0x2ae, 0x2ae)
__TSYSCALL0_UNUSED(0x2af, 0x2af, 0x2af)
__TSYSCALL0_UNUSED(0x2b0, 0x2b0, 0x2b0)
__TSYSCALL0_UNUSED(0x2b1, 0x2b1, 0x2b1)
__TSYSCALL0_UNUSED(0x2b2, 0x2b2, 0x2b2)
__TSYSCALL0_UNUSED(0x2b3, 0x2b3, 0x2b3)
__TSYSCALL0_UNUSED(0x2b4, 0x2b4, 0x2b4)
__TSYSCALL0_UNUSED(0x2b5, 0x2b5, 0x2b5)
__TSYSCALL0_UNUSED(0x2b6, 0x2b6, 0x2b6)
__TSYSCALL0_UNUSED(0x2b7, 0x2b7, 0x2b7)
__TSYSCALL0_UNUSED(0x2b8, 0x2b8, 0x2b8)
__TSYSCALL0_UNUSED(0x2b9, 0x2b9, 0x2b9)
__TSYSCALL0_UNUSED(0x2ba, 0x2ba, 0x2ba)
__TSYSCALL0_UNUSED(0x2bb, 0x2bb, 0x2bb)
__TSYSCALL0_UNUSED(0x2bc, 0x2bc, 0x2bc)
__TSYSCALL0_UNUSED(0x2bd, 0x2bd, 0x2bd)
__TSYSCALL0_UNUSED(0x2be, 0x2be, 0x2be)
__TSYSCALL0_UNUSED(0x2bf, 0x2bf, 0x2bf)
__TSYSCALL0_UNUSED(0x2c0, 0x2c0, 0x2c0)
__TSYSCALL0_UNUSED(0x2c1, 0x2c1, 0x2c1)
__TSYSCALL0_UNUSED(0x2c2, 0x2c2, 0x2c2)
__TSYSCALL0_UNUSED(0x2c3, 0x2c3, 0x2c3)
__TSYSCALL0_UNUSED(0x2c4, 0x2c4, 0x2c4)
__TSYSCALL0_UNUSED(0x2c5, 0x2c5, 0x2c5)
__TSYSCALL0_UNUSED(0x2c6, 0x2c6, 0x2c6)
__TSYSCALL0_UNUSED(0x2c7, 0x2c7, 0x2c7)
__TSYSCALL0_UNUSED(0x2c8, 0x2c8, 0x2c8)
__TSYSCALL0_UNUSED(0x2c9, 0x2c9, 0x2c9)
__TSYSCALL0_UNUSED(0x2ca, 0x2ca, 0x2ca)
__TSYSCALL0_UNUSED(0x2cb, 0x2cb, 0x2cb)
__TSYSCALL0_UNUSED(0x2cc, 0x2cc, 0x2cc)
__TSYSCALL0_UNUSED(0x2cd, 0x2cd, 0x2cd)
__TSYSCALL0_UNUSED(0x2ce, 0x2ce, 0x2ce)
__TSYSCALL0_UNUSED(0x2cf, 0x2cf, 0x2cf)
__TSYSCALL0_UNUSED(0x2d0, 0x2d0, 0x2d0)
__TSYSCALL0_UNUSED(0x2d1, 0x2d1, 0x2d1)
__TSYSCALL0_UNUSED(0x2d2, 0x2d2, 0x2d2)
__TSYSCALL0_UNUSED(0x2d3, 0x2d3, 0x2d3)
__TSYSCALL0_UNUSED(0x2d4, 0x2d4, 0x2d4)
__TSYSCALL0_UNUSED(0x2d5, 0x2d5, 0x2d5)
__TSYSCALL0_UNUSED(0x2d6, 0x2d6, 0x2d6)
__TSYSCALL0_UNUSED(0x2d7, 0x2d7, 0x2d7)
__TSYSCALL0_UNUSED(0x2d8, 0x2d8, 0x2d8)
__TSYSCALL0_UNUSED(0x2d9, 0x2d9, 0x2d9)
__TSYSCALL0_UNUSED(0x2da, 0x2da, 0x2da)
__TSYSCALL0_UNUSED(0x2db, 0x2db, 0x2db)
__TSYSCALL0_UNUSED(0x2dc, 0x2dc, 0x2dc)
__TSYSCALL0_UNUSED(0x2dd, 0x2dd, 0x2dd)
__TSYSCALL0_UNUSED(0x2de, 0x2de, 0x2de)
__TSYSCALL0_UNUSED(0x2df, 0x2df, 0x2df)
__TSYSCALL0_UNUSED(0x2e0, 0x2e0, 0x2e0)
__TSYSCALL0_UNUSED(0x2e1, 0x2e1, 0x2e1)
__TSYSCALL0_UNUSED(0x2e2, 0x2e2, 0x2e2)
__TSYSCALL0_UNUSED(0x2e3, 0x2e3, 0x2e3)
__TSYSCALL0_UNUSED(0x2e4, 0x2e4, 0x2e4)
__TSYSCALL0_UNUSED(0x2e5, 0x2e5, 0x2e5)
__TSYSCALL0_UNUSED(0x2e6, 0x2e6, 0x2e6)
__TSYSCALL0_UNUSED(0x2e7, 0x2e7, 0x2e7)
__TSYSCALL0_UNUSED(0x2e8, 0x2e8, 0x2e8)
__TSYSCALL0_UNUSED(0x2e9, 0x2e9, 0x2e9)
__TSYSCALL0_UNUSED(0x2ea, 0x2ea, 0x2ea)
__TSYSCALL0_UNUSED(0x2eb, 0x2eb, 0x2eb)
__TSYSCALL0_UNUSED(0x2ec, 0x2ec, 0x2ec)
__TSYSCALL0_UNUSED(0x2ed, 0x2ed, 0x2ed)
__TSYSCALL0_UNUSED(0x2ee, 0x2ee, 0x2ee)
__TSYSCALL0_UNUSED(0x2ef, 0x2ef, 0x2ef)
__TSYSCALL0_UNUSED(0x2f0, 0x2f0, 0x2f0)
__TSYSCALL0_UNUSED(0x2f1, 0x2f1, 0x2f1)
__TSYSCALL0_UNUSED(0x2f2, 0x2f2, 0x2f2)
__TSYSCALL0_UNUSED(0x2f3, 0x2f3, 0x2f3)
__TSYSCALL0_UNUSED(0x2f4, 0x2f4, 0x2f4)
__TSYSCALL0_UNUSED(0x2f5, 0x2f5, 0x2f5)
__TSYSCALL0_UNUSED(0x2f6, 0x2f6, 0x2f6)
__TSYSCALL0_UNUSED(0x2f7, 0x2f7, 0x2f7)
__TSYSCALL0_UNUSED(0x2f8, 0x2f8, 0x2f8)
__TSYSCALL0_UNUSED(0x2f9, 0x2f9, 0x2f9)
__TSYSCALL0_UNUSED(0x2fa, 0x2fa, 0x2fa)
__TSYSCALL0_UNUSED(0x2fb, 0x2fb, 0x2fb)
__TSYSCALL0_UNUSED(0x2fc, 0x2fc, 0x2fc)
__TSYSCALL0_UNUSED(0x2fd, 0x2fd, 0x2fd)
__TSYSCALL0_UNUSED(0x2fe, 0x2fe, 0x2fe)
__TSYSCALL0_UNUSED(0x2ff, 0x2ff, 0x2ff)
__TSYSCALL0_UNUSED(0x300, 0x300, 0x300)
__TSYSCALL0_UNUSED(0x301, 0x301, 0x301)
__TSYSCALL0_UNUSED(0x302, 0x302, 0x302)
__TSYSCALL0_UNUSED(0x303, 0x303, 0x303)
__TSYSCALL0_UNUSED(0x304, 0x304, 0x304)
__TSYSCALL0_UNUSED(0x305, 0x305, 0x305)
__TSYSCALL0_UNUSED(0x306, 0x306, 0x306)
__TSYSCALL0_UNUSED(0x307, 0x307, 0x307)
__TSYSCALL0_UNUSED(0x308, 0x308, 0x308)
__TSYSCALL0_UNUSED(0x309, 0x309, 0x309)
__TSYSCALL0_UNUSED(0x30a, 0x30a, 0x30a)
__TSYSCALL0_UNUSED(0x30b, 0x30b, 0x30b)
__TSYSCALL0_UNUSED(0x30c, 0x30c, 0x30c)
__TSYSCALL0_UNUSED(0x30d, 0x30d, 0x30d)
__TSYSCALL0_UNUSED(0x30e, 0x30e, 0x30e)
__TSYSCALL0_UNUSED(0x30f, 0x30f, 0x30f)
__TSYSCALL0_UNUSED(0x310, 0x310, 0x310)
__TSYSCALL0_UNUSED(0x311, 0x311, 0x311)
__TSYSCALL0_UNUSED(0x312, 0x312, 0x312)
__TSYSCALL0_UNUSED(0x313, 0x313, 0x313)
__TSYSCALL0_UNUSED(0x314, 0x314, 0x314)
__TSYSCALL0_UNUSED(0x315, 0x315, 0x315)
__TSYSCALL0_UNUSED(0x316, 0x316, 0x316)
__TSYSCALL0_UNUSED(0x317, 0x317, 0x317)
__TSYSCALL0_UNUSED(0x318, 0x318, 0x318)
__TSYSCALL0_UNUSED(0x319, 0x319, 0x319)
__TSYSCALL0_UNUSED(0x31a, 0x31a, 0x31a)
__TSYSCALL0_UNUSED(0x31b, 0x31b, 0x31b)
__TSYSCALL0_UNUSED(0x31c, 0x31c, 0x31c)
__TSYSCALL0_UNUSED(0x31d, 0x31d, 0x31d)
__TSYSCALL0_UNUSED(0x31e, 0x31e, 0x31e)
__TSYSCALL0_UNUSED(0x31f, 0x31f, 0x31f)
__TSYSCALL0_UNUSED(0x320, 0x320, 0x320)
__TSYSCALL0_UNUSED(0x321, 0x321, 0x321)
__TSYSCALL0_UNUSED(0x322, 0x322, 0x322)
__TSYSCALL0_UNUSED(0x323, 0x323, 0x323)
__TSYSCALL0_UNUSED(0x324, 0x324, 0x324)
__TSYSCALL0_UNUSED(0x325, 0x325, 0x325)
__TSYSCALL0_UNUSED(0x326, 0x326, 0x326)
__TSYSCALL0_UNUSED(0x327, 0x327, 0x327)
__TSYSCALL0_UNUSED(0x328, 0x328, 0x328)
__TSYSCALL0_UNUSED(0x329, 0x329, 0x329)
__TSYSCALL0_UNUSED(0x32a, 0x32a, 0x32a)
__TSYSCALL0_UNUSED(0x32b, 0x32b, 0x32b)
__TSYSCALL0_UNUSED(0x32c, 0x32c, 0x32c)
__TSYSCALL0_UNUSED(0x32d, 0x32d, 0x32d)
__TSYSCALL0_UNUSED(0x32e, 0x32e, 0x32e)
__TSYSCALL0_UNUSED(0x32f, 0x32f, 0x32f)
__TSYSCALL0_UNUSED(0x330, 0x330, 0x330)
__TSYSCALL0_UNUSED(0x331, 0x331, 0x331)
__TSYSCALL0_UNUSED(0x332, 0x332, 0x332)
__TSYSCALL0_UNUSED(0x333, 0x333, 0x333)
__TSYSCALL0_UNUSED(0x334, 0x334, 0x334)
__TSYSCALL0_UNUSED(0x335, 0x335, 0x335)
__TSYSCALL0_UNUSED(0x336, 0x336, 0x336)
__TSYSCALL0_UNUSED(0x337, 0x337, 0x337)
__TSYSCALL0_UNUSED(0x338, 0x338, 0x338)
__TSYSCALL0_UNUSED(0x339, 0x339, 0x339)
__TSYSCALL0_UNUSED(0x33a, 0x33a, 0x33a)
__TSYSCALL0_UNUSED(0x33b, 0x33b, 0x33b)
__TSYSCALL0_UNUSED(0x33c, 0x33c, 0x33c)
__TSYSCALL0_UNUSED(0x33d, 0x33d, 0x33d)
__TSYSCALL0_UNUSED(0x33e, 0x33e, 0x33e)
__TSYSCALL0_UNUSED(0x33f, 0x33f, 0x33f)
__TSYSCALL0_UNUSED(0x340, 0x340, 0x340)
__TSYSCALL0_UNUSED(0x341, 0x341, 0x341)
__TSYSCALL0_UNUSED(0x342, 0x342, 0x342)
__TSYSCALL0_UNUSED(0x343, 0x343, 0x343)
__TSYSCALL0_UNUSED(0x344, 0x344, 0x344)
__TSYSCALL0_UNUSED(0x345, 0x345, 0x345)
__TSYSCALL0_UNUSED(0x346, 0x346, 0x346)
__TSYSCALL0_UNUSED(0x347, 0x347, 0x347)
__TSYSCALL0_UNUSED(0x348, 0x348, 0x348)
__TSYSCALL0_UNUSED(0x349, 0x349, 0x349)
__TSYSCALL0_UNUSED(0x34a, 0x34a, 0x34a)
__TSYSCALL0_UNUSED(0x34b, 0x34b, 0x34b)
__TSYSCALL0_UNUSED(0x34c, 0x34c, 0x34c)
__TSYSCALL0_UNUSED(0x34d, 0x34d, 0x34d)
__TSYSCALL0_UNUSED(0x34e, 0x34e, 0x34e)
__TSYSCALL0_UNUSED(0x34f, 0x34f, 0x34f)
__TSYSCALL0_UNUSED(0x350, 0x350, 0x350)
__TSYSCALL0_UNUSED(0x351, 0x351, 0x351)
__TSYSCALL0_UNUSED(0x352, 0x352, 0x352)
__TSYSCALL0_UNUSED(0x353, 0x353, 0x353)
__TSYSCALL0_UNUSED(0x354, 0x354, 0x354)
__TSYSCALL0_UNUSED(0x355, 0x355, 0x355)
__TSYSCALL0_UNUSED(0x356, 0x356, 0x356)
__TSYSCALL0_UNUSED(0x357, 0x357, 0x357)
__TSYSCALL0_UNUSED(0x358, 0x358, 0x358)
__TSYSCALL0_UNUSED(0x359, 0x359, 0x359)
__TSYSCALL0_UNUSED(0x35a, 0x35a, 0x35a)
__TSYSCALL0_UNUSED(0x35b, 0x35b, 0x35b)
__TSYSCALL0_UNUSED(0x35c, 0x35c, 0x35c)
__TSYSCALL0_UNUSED(0x35d, 0x35d, 0x35d)
__TSYSCALL0_UNUSED(0x35e, 0x35e, 0x35e)
__TSYSCALL0_UNUSED(0x35f, 0x35f, 0x35f)
__TSYSCALL0_UNUSED(0x360, 0x360, 0x360)
__TSYSCALL0_UNUSED(0x361, 0x361, 0x361)
__TSYSCALL0_UNUSED(0x362, 0x362, 0x362)
__TSYSCALL0_UNUSED(0x363, 0x363, 0x363)
__TSYSCALL0_UNUSED(0x364, 0x364, 0x364)
__TSYSCALL0_UNUSED(0x365, 0x365, 0x365)
__TSYSCALL0_UNUSED(0x366, 0x366, 0x366)
__TSYSCALL0_UNUSED(0x367, 0x367, 0x367)
__TSYSCALL0_UNUSED(0x368, 0x368, 0x368)
__TSYSCALL0_UNUSED(0x369, 0x369, 0x369)
__TSYSCALL0_UNUSED(0x36a, 0x36a, 0x36a)
__TSYSCALL0_UNUSED(0x36b, 0x36b, 0x36b)
__TSYSCALL0_UNUSED(0x36c, 0x36c, 0x36c)
__TSYSCALL0_UNUSED(0x36d, 0x36d, 0x36d)
__TSYSCALL0_UNUSED(0x36e, 0x36e, 0x36e)
__TSYSCALL0_UNUSED(0x36f, 0x36f, 0x36f)
__TSYSCALL0_UNUSED(0x370, 0x370, 0x370)
__TSYSCALL0_UNUSED(0x371, 0x371, 0x371)
__TSYSCALL0_UNUSED(0x372, 0x372, 0x372)
__TSYSCALL0_UNUSED(0x373, 0x373, 0x373)
__TSYSCALL0_UNUSED(0x374, 0x374, 0x374)
__TSYSCALL0_UNUSED(0x375, 0x375, 0x375)
__TSYSCALL0_UNUSED(0x376, 0x376, 0x376)
__TSYSCALL0_UNUSED(0x377, 0x377, 0x377)
__TSYSCALL0_UNUSED(0x378, 0x378, 0x378)
__TSYSCALL0_UNUSED(0x379, 0x379, 0x379)
__TSYSCALL0_UNUSED(0x37a, 0x37a, 0x37a)
__TSYSCALL0_UNUSED(0x37b, 0x37b, 0x37b)
__TSYSCALL0_UNUSED(0x37c, 0x37c, 0x37c)
__TSYSCALL0_UNUSED(0x37d, 0x37d, 0x37d)
__TSYSCALL0_UNUSED(0x37e, 0x37e, 0x37e)
__TSYSCALL0_UNUSED(0x37f, 0x37f, 0x37f)
__TSYSCALL0_UNUSED(0x380, 0x380, 0x380)
__TSYSCALL0_UNUSED(0x381, 0x381, 0x381)
__TSYSCALL0_UNUSED(0x382, 0x382, 0x382)
__TSYSCALL0_UNUSED(0x383, 0x383, 0x383)
__TSYSCALL0_UNUSED(0x384, 0x384, 0x384)
__TSYSCALL0_UNUSED(0x385, 0x385, 0x385)
__TSYSCALL0_UNUSED(0x386, 0x386, 0x386)
__TSYSCALL0_UNUSED(0x387, 0x387, 0x387)
__TSYSCALL0_UNUSED(0x388, 0x388, 0x388)
__TSYSCALL0_UNUSED(0x389, 0x389, 0x389)
__TSYSCALL0_UNUSED(0x38a, 0x38a, 0x38a)
__TSYSCALL0_UNUSED(0x38b, 0x38b, 0x38b)
__TSYSCALL0_UNUSED(0x38c, 0x38c, 0x38c)
__TSYSCALL0_UNUSED(0x38d, 0x38d, 0x38d)
__TSYSCALL0_UNUSED(0x38e, 0x38e, 0x38e)
__TSYSCALL0_UNUSED(0x38f, 0x38f, 0x38f)
__TSYSCALL0_UNUSED(0x390, 0x390, 0x390)
__TSYSCALL0_UNUSED(0x391, 0x391, 0x391)
__TSYSCALL0_UNUSED(0x392, 0x392, 0x392)
__TSYSCALL0_UNUSED(0x393, 0x393, 0x393)
__TSYSCALL0_UNUSED(0x394, 0x394, 0x394)
__TSYSCALL0_UNUSED(0x395, 0x395, 0x395)
__TSYSCALL0_UNUSED(0x396, 0x396, 0x396)
__TSYSCALL0_UNUSED(0x397, 0x397, 0x397)
__TSYSCALL0_UNUSED(0x398, 0x398, 0x398)
__TSYSCALL0_UNUSED(0x399, 0x399, 0x399)
__TSYSCALL0_UNUSED(0x39a, 0x39a, 0x39a)
__TSYSCALL0_UNUSED(0x39b, 0x39b, 0x39b)
__TSYSCALL0_UNUSED(0x39c, 0x39c, 0x39c)
__TSYSCALL0_UNUSED(0x39d, 0x39d, 0x39d)
__TSYSCALL0_UNUSED(0x39e, 0x39e, 0x39e)
__TSYSCALL0_UNUSED(0x39f, 0x39f, 0x39f)
__TSYSCALL0_UNUSED(0x3a0, 0x3a0, 0x3a0)
__TSYSCALL0_UNUSED(0x3a1, 0x3a1, 0x3a1)
__TSYSCALL0_UNUSED(0x3a2, 0x3a2, 0x3a2)
__TSYSCALL0_UNUSED(0x3a3, 0x3a3, 0x3a3)
__TSYSCALL0_UNUSED(0x3a4, 0x3a4, 0x3a4)
__TSYSCALL0_UNUSED(0x3a5, 0x3a5, 0x3a5)
__TSYSCALL0_UNUSED(0x3a6, 0x3a6, 0x3a6)
__TSYSCALL0_UNUSED(0x3a7, 0x3a7, 0x3a7)
__TSYSCALL0_UNUSED(0x3a8, 0x3a8, 0x3a8)
__TSYSCALL0_UNUSED(0x3a9, 0x3a9, 0x3a9)
__TSYSCALL0_UNUSED(0x3aa, 0x3aa, 0x3aa)
__TSYSCALL0_UNUSED(0x3ab, 0x3ab, 0x3ab)
__TSYSCALL0_UNUSED(0x3ac, 0x3ac, 0x3ac)
__TSYSCALL0_UNUSED(0x3ad, 0x3ad, 0x3ad)
__TSYSCALL0_UNUSED(0x3ae, 0x3ae, 0x3ae)
__TSYSCALL0_UNUSED(0x3af, 0x3af, 0x3af)
__TSYSCALL0_UNUSED(0x3b0, 0x3b0, 0x3b0)
__TSYSCALL0_UNUSED(0x3b1, 0x3b1, 0x3b1)
__TSYSCALL0_UNUSED(0x3b2, 0x3b2, 0x3b2)
__TSYSCALL0_UNUSED(0x3b3, 0x3b3, 0x3b3)
__TSYSCALL0_UNUSED(0x3b4, 0x3b4, 0x3b4)
__TSYSCALL0_UNUSED(0x3b5, 0x3b5, 0x3b5)
__TSYSCALL0_UNUSED(0x3b6, 0x3b6, 0x3b6)
__TSYSCALL0_UNUSED(0x3b7, 0x3b7, 0x3b7)
__TSYSCALL0_UNUSED(0x3b8, 0x3b8, 0x3b8)
__TSYSCALL0_UNUSED(0x3b9, 0x3b9, 0x3b9)
__TSYSCALL0_UNUSED(0x3ba, 0x3ba, 0x3ba)
__TSYSCALL0_UNUSED(0x3bb, 0x3bb, 0x3bb)
__TSYSCALL0_UNUSED(0x3bc, 0x3bc, 0x3bc)
__TSYSCALL0_UNUSED(0x3bd, 0x3bd, 0x3bd)
__TSYSCALL0_UNUSED(0x3be, 0x3be, 0x3be)
__TSYSCALL0_UNUSED(0x3bf, 0x3bf, 0x3bf)
__TSYSCALL0_UNUSED(0x3c0, 0x3c0, 0x3c0)
__TSYSCALL0_UNUSED(0x3c1, 0x3c1, 0x3c1)
__TSYSCALL0_UNUSED(0x3c2, 0x3c2, 0x3c2)
__TSYSCALL0_UNUSED(0x3c3, 0x3c3, 0x3c3)
__TSYSCALL0_UNUSED(0x3c4, 0x3c4, 0x3c4)
__TSYSCALL0_UNUSED(0x3c5, 0x3c5, 0x3c5)
__TSYSCALL0_UNUSED(0x3c6, 0x3c6, 0x3c6)
__TSYSCALL0_UNUSED(0x3c7, 0x3c7, 0x3c7)
__TSYSCALL0_UNUSED(0x3c8, 0x3c8, 0x3c8)
__TSYSCALL0_UNUSED(0x3c9, 0x3c9, 0x3c9)
__TSYSCALL0_UNUSED(0x3ca, 0x3ca, 0x3ca)
__TSYSCALL0_UNUSED(0x3cb, 0x3cb, 0x3cb)
__TSYSCALL0_UNUSED(0x3cc, 0x3cc, 0x3cc)
__TSYSCALL0_UNUSED(0x3cd, 0x3cd, 0x3cd)
__TSYSCALL0_UNUSED(0x3ce, 0x3ce, 0x3ce)
__TSYSCALL0_UNUSED(0x3cf, 0x3cf, 0x3cf)
__TSYSCALL0_UNUSED(0x3d0, 0x3d0, 0x3d0)
__TSYSCALL0_UNUSED(0x3d1, 0x3d1, 0x3d1)
__TSYSCALL0_UNUSED(0x3d2, 0x3d2, 0x3d2)
__TSYSCALL0_UNUSED(0x3d3, 0x3d3, 0x3d3)
__TSYSCALL0_UNUSED(0x3d4, 0x3d4, 0x3d4)
__TSYSCALL0_UNUSED(0x3d5, 0x3d5, 0x3d5)
__TSYSCALL0_UNUSED(0x3d6, 0x3d6, 0x3d6)
__TSYSCALL0_UNUSED(0x3d7, 0x3d7, 0x3d7)
__TSYSCALL0_UNUSED(0x3d8, 0x3d8, 0x3d8)
__TSYSCALL0_UNUSED(0x3d9, 0x3d9, 0x3d9)
__TSYSCALL0_UNUSED(0x3da, 0x3da, 0x3da)
__TSYSCALL0_UNUSED(0x3db, 0x3db, 0x3db)
__TSYSCALL0_UNUSED(0x3dc, 0x3dc, 0x3dc)
__TSYSCALL0_UNUSED(0x3dd, 0x3dd, 0x3dd)
__TSYSCALL0_UNUSED(0x3de, 0x3de, 0x3de)
__TSYSCALL0_UNUSED(0x3df, 0x3df, 0x3df)
__TSYSCALL0_UNUSED(0x3e0, 0x3e0, 0x3e0)
__TSYSCALL0_UNUSED(0x3e1, 0x3e1, 0x3e1)
__TSYSCALL0_UNUSED(0x3e2, 0x3e2, 0x3e2)
__TSYSCALL0_UNUSED(0x3e3, 0x3e3, 0x3e3)
__TSYSCALL0_UNUSED(0x3e4, 0x3e4, 0x3e4)
__TSYSCALL0_UNUSED(0x3e5, 0x3e5, 0x3e5)
__TSYSCALL0_UNUSED(0x3e6, 0x3e6, 0x3e6)
__TSYSCALL0_UNUSED(0x3e7, 0x3e7, 0x3e7)
__TSYSCALL0_UNUSED(0x3e8, 0x3e8, 0x3e8)
__TSYSCALL0_UNUSED(0x3e9, 0x3e9, 0x3e9)
__TSYSCALL0_UNUSED(0x3ea, 0x3ea, 0x3ea)
__TSYSCALL0_UNUSED(0x3eb, 0x3eb, 0x3eb)
__TSYSCALL0_UNUSED(0x3ec, 0x3ec, 0x3ec)
__TSYSCALL0_UNUSED(0x3ed, 0x3ed, 0x3ed)
__TSYSCALL0_UNUSED(0x3ee, 0x3ee, 0x3ee)
__TSYSCALL0_UNUSED(0x3ef, 0x3ef, 0x3ef)
__TSYSCALL0_UNUSED(0x3f0, 0x3f0, 0x3f0)
__TSYSCALL0_UNUSED(0x3f1, 0x3f1, 0x3f1)
__TSYSCALL0_UNUSED(0x3f2, 0x3f2, 0x3f2)
__TSYSCALL0_UNUSED(0x3f3, 0x3f3, 0x3f3)
__TSYSCALL0_UNUSED(0x3f4, 0x3f4, 0x3f4)
__TSYSCALL0_UNUSED(0x3f5, 0x3f5, 0x3f5)
__TSYSCALL0_UNUSED(0x3f6, 0x3f6, 0x3f6)
__TSYSCALL0_UNUSED(0x3f7, 0x3f7, 0x3f7)
__TSYSCALL0_UNUSED(0x3f8, 0x3f8, 0x3f8)
__TSYSCALL0_UNUSED(0x3f9, 0x3f9, 0x3f9)
__TSYSCALL0_UNUSED(0x3fa, 0x3fa, 0x3fa)
__TSYSCALL0_UNUSED(0x3fb, 0x3fb, 0x3fb)
__TSYSCALL0_UNUSED(0x3fc, 0x3fc, 0x3fc)
__TSYSCALL0_UNUSED(0x3fd, 0x3fd, 0x3fd)
__TSYSCALL0_UNUSED(0x3fe, 0x3fe, 0x3fe)
__TSYSCALL0_UNUSED(0x3ff, 0x3ff, 0x3ff)
__TSYSCALL0(open, 0x400, 0x400)
__TSYSCALL0(link, 0x401, 0x401)
__TSYSCALL0(unlink, 0x402, 0x402)
__TSYSCALL0(mknod, 0x403, 0x403)
__TSYSCALL0(chmod, 0x404, 0x404)
__TSYSCALL0(chown, 0x405, 0x405)
__TSYSCALL0(mkdir, 0x406, 0x406)
__TSYSCALL0(rmdir, 0x407, 0x407)
__TSYSCALL0(lchown, 0x408, 0x408)
__TSYSCALL0(access, 0x409, 0x409)
__TSYSCALL0(rename, 0x40a, 0x40a)
__TSYSCALL0(readlink, 0x40b, 0x40b)
__TSYSCALL0(symlink, 0x40c, 0x40c)
__TSYSCALL0(utimes, 0x40d, 0x40d)
__TSYSCALL0_UNUSED(0x40e, 0x40e, 0x40e)
__TSYSCALL0_UNUSED(0x40f, 0x40f, 0x40f)
__TSYSCALL0(pipe, 0x410, 0x410)
__TSYSCALL0(dup2, 0x411, 0x411)
__TSYSCALL0(epoll_create, 0x412, 0x412)
__TSYSCALL0(inotify_init, 0x413, 0x413)
__TSYSCALL0(eventfd, 0x414, 0x414)
__TSYSCALL0(signalfd, 0x415, 0x415)
__TSYSCALL0(sendfile, 0x416, 0x416)
__TSYSCALL0(ftruncate, 0x417, 0x417)
__TSYSCALL0(truncate, 0x418, 0x418)
__TSYSCALL0(stat, 0x419, 0x419)
__TSYSCALL0(lstat, 0x41a, 0x41a)
__TSYSCALL0(fstat, 0x41b, 0x41b)
__TSYSCALL0(fcntl, 0x41c, 0x41c)
__TSYSCALL0(fadvise64, 0x41d, 0x41d)
__TSYSCALL0(newfstatat, 0x41e, 0x41e)
__TSYSCALL0(fstatfs, 0x41f, 0x41f)
__TSYSCALL0(statfs, 0x420, 0x420)
__TSYSCALL0(lseek, 0x421, 0x421)
__TSYSCALL0(mmap, 0x422, 0x422)
__TSYSCALL0(alarm, 0x423, 0x423)
__TSYSCALL0(getpgrp, 0x424, 0x424)
__TSYSCALL0(pause, 0x425, 0x425)
__TSYSCALL0(time, 0x426, 0x426)
__TSYSCALL0(utime, 0x427, 0x427)
__TSYSCALL0(creat, 0x428, 0x428)
__TSYSCALL0(getdents, 0x429, 0x429)
__TSYSCALL0(futimesat, 0x42a, 0x42a)
__TSYSCALL0(select, 0x42b, 0x42b)
__TSYSCALL0(poll, 0x42c, 0x42c)
__TSYSCALL0(epoll_wait, 0x42d, 0x42d)
__TSYSCALL0(ustat, 0x42e, 0x42e)
__TSYSCALL0(vfork, 0x42f, 0x42f)
__TSYSCALL0(oldwait4, 0x430, 0x430)
__TSYSCALL0(recv, 0x431, 0x431)
__TSYSCALL0(send, 0x432, 0x432)
__TSYSCALL0(bdflush, 0x433, 0x433)
__TSYSCALL0(umount, 0x434, 0x434)
__TSYSCALL0(uselib, 0x435, 0x435)
__TSYSCALL0(_sysctl, 0x436, 0x436)
__TSYSCALL0(fork, 0x437, 0x437)
__TSYSCALL0_TABLE_END(0x0, 0x437, 0x438, 0x0, 0x437, 0x438)

#undef __TSYSCALL0_TABLE_END
#undef __TSYSCALL0_TABLE_BEGIN
#undef __TSYSCALL0_UNUSED_TRAILING
#undef __TSYSCALL0_UNUSED_LEADING
#undef __TSYSCALL0_UNUSED
#undef __TSYSCALL0
#undef __TSYSCALL_TABLE_END
#undef __TSYSCALL_TABLE_BEGIN
#undef __TSYSCALL_UNUSED_TRAILING
#undef __TSYSCALL_UNUSED_LEADING
#undef __TSYSCALL_UNUSED
#undef __TSYSCALL
#undef __SYSCALL_UNUSED
#undef __SYSCALL
