/* Copyright (c) 2019-2024 Griefer@Work                                       *
 *                                                                            *
 * This software is provided 'as-is', without any express or implied          *
 * warranty. In no event will the authors be held liable for any damages      *
 * arising from the use of this software.                                     *
 *                                                                            *
 * Permission is granted to anyone to use this software for any purpose,      *
 * including commercial applications, and to alter it and redistribute it     *
 * freely, subject to the following restrictions:                             *
 *                                                                            *
 * 1. The origin of this software must not be misrepresented; you must not    *
 *    claim that you wrote the original software. If you use this software    *
 *    in a product, an acknowledgement (see the following) in the product     *
 *    documentation is required:                                              *
 *    Portions Copyright (c) 2019-2024 Griefer@Work                           *
 * 2. Altered source versions must be plainly marked as such, and must not be *
 *    misrepresented as being the original software.                          *
 * 3. This notice may not be removed or altered from any source distribution. *
 */
#ifndef _ASM_CRT_STDIO_H
#define _ASM_CRT_STDIO_H 1

#include <__crt.h>
#include <hybrid/typecore.h>

#ifdef __CRT_DOS_PRIMARY
#define ___IOFBF 0x0000 /* Fully buffered. */
#define ___IOLBF 0x0040 /* Line buffered. */
#define ___IONBF 0x0004 /* No buffering. */
#else /* __CRT_DOS_PRIMARY */
#define ___IOFBF 0 /* Fully buffered. */
#define ___IOLBF 1 /* Line buffered. */
#define ___IONBF 2 /* No buffering. */
#endif /* !__CRT_DOS_PRIMARY */

#ifdef __CRT_DOS_PRIMARY
#define __BUFSIZ 512
#else /* __CRT_DOS_PRIMARY */
#define __BUFSIZ 8192
#endif /* !__CRT_DOS_PRIMARY */

#define __EOF    (-1)
#define __WEOF16 (__CCAST(__WINT16_TYPE__)-1)
#define __WEOF32 (__CCAST(__WINT32_TYPE__)-1)
#define __WEOF   (__CCAST(__WINT_TYPE__)-1)


#ifdef __CRT_DOS_PRIMARY
#define __L_tmpnam     14    /* Minimum buffer size for temporary file names */
#define __FILENAME_MAX 260   /* Recommended buffer size for file names. */
#define __TMP_MAX      32767 /* Min # of unique temporary file names what can be generated by `tmpnam()' */
#define __FOPEN_MAX    20
#else /* __CRT_DOS_PRIMARY */
#define __L_tmpnam     20     /* Minimum buffer size for temporary file names */
#define __FILENAME_MAX 4096   /* Recommended buffer size for file names. */
#define __TMP_MAX      238328 /* Min # of unique temporary file names what can be generated by `tmpnam()' */
#define __FOPEN_MAX    16
#endif /* !__CRT_DOS_PRIMARY */

/* - Max # of characters in the string returned by `ctermid()'
 * - Buffer size that must be passed to `ctermid_r()' */
#ifdef _WIN32
#define __L_ctermid 4 /* "CON\0" */
#else /* _WIN32 */
#define __L_ctermid 9 /* "/dev/tty\0" */
#endif /* !_WIN32 */

/* Max # of characters in the string returned by `cuserid()' */
#define __L_cuserid 9

#endif /* !_ASM_CRT_STDIO_H */
