/* HASH CRC-32:0x68b339ec */
/* Copyright (c) 2019-2024 Griefer@Work                                       *
 *                                                                            *
 * This software is provided 'as-is', without any express or implied          *
 * warranty. In no event will the authors be held liable for any damages      *
 * arising from the use of this software.                                     *
 *                                                                            *
 * Permission is granted to anyone to use this software for any purpose,      *
 * including commercial applications, and to alter it and redistribute it     *
 * freely, subject to the following restrictions:                             *
 *                                                                            *
 * 1. The origin of this software must not be misrepresented; you must not    *
 *    claim that you wrote the original software. If you use this software    *
 *    in a product, an acknowledgement (see the following) in the product     *
 *    documentation is required:                                              *
 *    Portions Copyright (c) 2019-2024 Griefer@Work                           *
 * 2. Altered source versions must be plainly marked as such, and must not be *
 *    misrepresented as being the original software.                          *
 * 3. This notice may not be removed or altered from any source distribution. *
 */

/* Enumerate known system calls by name */
#ifndef __SYSCALL
#define __SYSCALL(name) /* nothing */
#endif /* !__SYSCALL */

/* Enumerate unused system calls IDs */
#ifndef __SYSCALL_UNUSED
#define __SYSCALL_UNUSED(sysno) /* nothing */
#endif /* !__SYSCALL_UNUSED */

/* Enumerate used system calls */
#ifndef __TSYSCALL
#define __TSYSCALL(table_id, name, table_index, table_index_without_unused_leading) __SYSCALL(name)
#endif /* !__TSYSCALL */

/* Enumerate unused system calls */
#ifndef __TSYSCALL_UNUSED
#define __TSYSCALL_UNUSED(table_id, sysno, table_index, table_index_without_unused_leading) __SYSCALL_UNUSED(sysno)
#endif /* !__TSYSCALL_UNUSED */

/* Enumerate unused system calls at the start of a table */
#ifndef __TSYSCALL_UNUSED_LEADING
#define __TSYSCALL_UNUSED_LEADING(table_id, sysno, table_index) __SYSCALL_UNUSED(sysno)
#endif /* !__TSYSCALL_UNUSED_LEADING */

/* Enumerate unused system calls at the end of a table */
#ifndef __TSYSCALL_UNUSED_TRAILING
#define __TSYSCALL_UNUSED_TRAILING(table_id, sysno, table_index, table_index_without_unused_leading, index_in_unused_trailing) __SYSCALL_UNUSED(sysno)
#endif /* !__TSYSCALL_UNUSED_TRAILING */

/* Invoked at the start of a system call table */
#ifndef __TSYSCALL_TABLE_BEGIN
#define __TSYSCALL_TABLE_BEGIN(table_id, minsysno, maxsysno, sysnocnt, minsysno_without_unused_leading, maxsysno_without_unused_trailing, sysnocnt_without_unused_surrounding) /* nothing */
#endif /* !__TSYSCALL_TABLE_BEGIN */

/* Invoked at the end of a system call table */
#ifndef __TSYSCALL_TABLE_END
#define __TSYSCALL_TABLE_END(table_id, minsysno, maxsysno, sysnocnt, minsysno_without_unused_leading, maxsysno_without_unused_trailing, sysnocnt_without_unused_surrounding) /* nothing */
#endif /* !__TSYSCALL_TABLE_END */

/* Enumerate used system calls in the 1st system call */
#ifndef __TSYSCALL0
#define __TSYSCALL0(name, index, index_without_unused_leading) __TSYSCALL(0, name, index, index_without_unused_leading)
#endif /* !__TSYSCALL0 */

/* Enumerate unused system calls in the middle of the 1st system call table*/
#ifndef __TSYSCALL0_UNUSED
#define __TSYSCALL0_UNUSED(sysno, index, index_without_unused_leading) __TSYSCALL_UNUSED(0, sysno, index, index_without_unused_leading)
#endif /* !__TSYSCALL0_UNUSED */

/* Enumerate unused system calls at the start of the 1st system call table */
#ifndef __TSYSCALL0_UNUSED_LEADING
#define __TSYSCALL0_UNUSED_LEADING(sysno, index) __TSYSCALL_UNUSED_LEADING(0, sysno, index)
#endif /* !__TSYSCALL0_UNUSED_LEADING */

/* Enumerate unused system calls at the end of the 1st system call table */
#ifndef __TSYSCALL0_UNUSED_TRAILING
#define __TSYSCALL0_UNUSED_TRAILING(sysno, index, index_without_unused_leading, index_in_unused_trailing) __TSYSCALL_UNUSED_TRAILING(0, sysno, index, index_without_unused_leading, index_in_unused_trailing)
#endif /* !__TSYSCALL0_UNUSED_TRAILING */

/* Invoked at the start of the 1st system call table */
#ifndef __TSYSCALL0_TABLE_BEGIN
#define __TSYSCALL0_TABLE_BEGIN(minsysno, maxsysno, sysnocnt, minsysno_without_unused_leading, maxsysno_without_unused_trailing, sysnocnt_without_unused_surrounding) \
	__TSYSCALL_TABLE_BEGIN(0, minsysno, maxsysno, sysnocnt, minsysno_without_unused_leading, maxsysno_without_unused_trailing, sysnocnt_without_unused_surrounding)
#endif /* !__TSYSCALL0_TABLE_BEGIN */

/* Invoked at the end of the 1st system call table */
#ifndef __TSYSCALL0_TABLE_END
#define __TSYSCALL0_TABLE_END(minsysno, maxsysno, sysnocnt, minsysno_without_unused_leading, maxsysno_without_unused_trailing, sysnocnt_without_unused_surrounding) \
	__TSYSCALL_TABLE_END(0, minsysno, maxsysno, sysnocnt, minsysno_without_unused_leading, maxsysno_without_unused_trailing, sysnocnt_without_unused_surrounding)
#endif /* !__TSYSCALL0_TABLE_END */

/* Enumerate used system calls in the 2nd system call */
#ifndef __TSYSCALL1
#define __TSYSCALL1(name, index, index_without_unused_leading) __TSYSCALL(1, name, index, index_without_unused_leading)
#endif /* !__TSYSCALL1 */

/* Enumerate unused system calls in the middle of the 2nd system call table*/
#ifndef __TSYSCALL1_UNUSED
#define __TSYSCALL1_UNUSED(sysno, index, index_without_unused_leading) __TSYSCALL_UNUSED(1, sysno, index, index_without_unused_leading)
#endif /* !__TSYSCALL1_UNUSED */

/* Enumerate unused system calls at the start of the 2nd system call table */
#ifndef __TSYSCALL1_UNUSED_LEADING
#define __TSYSCALL1_UNUSED_LEADING(sysno, index) __TSYSCALL_UNUSED_LEADING(1, sysno, index)
#endif /* !__TSYSCALL1_UNUSED_LEADING */

/* Enumerate unused system calls at the end of the 2nd system call table */
#ifndef __TSYSCALL1_UNUSED_TRAILING
#define __TSYSCALL1_UNUSED_TRAILING(sysno, index, index_without_unused_leading, index_in_unused_trailing) __TSYSCALL_UNUSED_TRAILING(1, sysno, index, index_without_unused_leading, index_in_unused_trailing)
#endif /* !__TSYSCALL1_UNUSED_TRAILING */

/* Invoked at the start of the 2nd system call table */
#ifndef __TSYSCALL1_TABLE_BEGIN
#define __TSYSCALL1_TABLE_BEGIN(minsysno, maxsysno, sysnocnt, minsysno_without_unused_leading, maxsysno_without_unused_trailing, sysnocnt_without_unused_surrounding) \
	__TSYSCALL_TABLE_BEGIN(1, minsysno, maxsysno, sysnocnt, minsysno_without_unused_leading, maxsysno_without_unused_trailing, sysnocnt_without_unused_surrounding)
#endif /* !__TSYSCALL1_TABLE_BEGIN */

/* Invoked at the end of the 2nd system call table */
#ifndef __TSYSCALL1_TABLE_END
#define __TSYSCALL1_TABLE_END(minsysno, maxsysno, sysnocnt, minsysno_without_unused_leading, maxsysno_without_unused_trailing, sysnocnt_without_unused_surrounding) \
	__TSYSCALL_TABLE_END(1, minsysno, maxsysno, sysnocnt, minsysno_without_unused_leading, maxsysno_without_unused_trailing, sysnocnt_without_unused_surrounding)
#endif /* !__TSYSCALL1_TABLE_END */

/* Enumerate used system calls in the 3rd system call */
#ifndef __TSYSCALL2
#define __TSYSCALL2(name, index, index_without_unused_leading) __TSYSCALL(2, name, index, index_without_unused_leading)
#endif /* !__TSYSCALL2 */

/* Enumerate unused system calls in the middle of the 3rd system call table*/
#ifndef __TSYSCALL2_UNUSED
#define __TSYSCALL2_UNUSED(sysno, index, index_without_unused_leading) __TSYSCALL_UNUSED(2, sysno, index, index_without_unused_leading)
#endif /* !__TSYSCALL2_UNUSED */

/* Enumerate unused system calls at the start of the 3rd system call table */
#ifndef __TSYSCALL2_UNUSED_LEADING
#define __TSYSCALL2_UNUSED_LEADING(sysno, index) __TSYSCALL_UNUSED_LEADING(2, sysno, index)
#endif /* !__TSYSCALL2_UNUSED_LEADING */

/* Enumerate unused system calls at the end of the 3rd system call table */
#ifndef __TSYSCALL2_UNUSED_TRAILING
#define __TSYSCALL2_UNUSED_TRAILING(sysno, index, index_without_unused_leading, index_in_unused_trailing) __TSYSCALL_UNUSED_TRAILING(2, sysno, index, index_without_unused_leading, index_in_unused_trailing)
#endif /* !__TSYSCALL2_UNUSED_TRAILING */

/* Invoked at the start of the 3rd system call table */
#ifndef __TSYSCALL2_TABLE_BEGIN
#define __TSYSCALL2_TABLE_BEGIN(minsysno, maxsysno, sysnocnt, minsysno_without_unused_leading, maxsysno_without_unused_trailing, sysnocnt_without_unused_surrounding) \
	__TSYSCALL_TABLE_BEGIN(2, minsysno, maxsysno, sysnocnt, minsysno_without_unused_leading, maxsysno_without_unused_trailing, sysnocnt_without_unused_surrounding)
#endif /* !__TSYSCALL2_TABLE_BEGIN */

/* Invoked at the end of the 3rd system call table */
#ifndef __TSYSCALL2_TABLE_END
#define __TSYSCALL2_TABLE_END(minsysno, maxsysno, sysnocnt, minsysno_without_unused_leading, maxsysno_without_unused_trailing, sysnocnt_without_unused_surrounding) \
	__TSYSCALL_TABLE_END(2, minsysno, maxsysno, sysnocnt, minsysno_without_unused_leading, maxsysno_without_unused_trailing, sysnocnt_without_unused_surrounding)
#endif /* !__TSYSCALL2_TABLE_END */

/************************************************************************/
/* Contents of the 1st table                                            */
/************************************************************************/
__TSYSCALL0_TABLE_BEGIN(0x0, 0x1b8, 0x1b9, 0x0, 0x1b8, 0x1b9)
__TSYSCALL0(restart_syscall, 0x0, 0x0)
__TSYSCALL0(exit, 0x1, 0x1)
__TSYSCALL0(fork, 0x2, 0x2)
__TSYSCALL0(read, 0x3, 0x3)
__TSYSCALL0(write, 0x4, 0x4)
__TSYSCALL0(open, 0x5, 0x5)
__TSYSCALL0(close, 0x6, 0x6)
__TSYSCALL0_UNUSED(0x7, 0x7, 0x7)
__TSYSCALL0(creat, 0x8, 0x8)
__TSYSCALL0(link, 0x9, 0x9)
__TSYSCALL0(unlink, 0xa, 0xa)
__TSYSCALL0(execve, 0xb, 0xb)
__TSYSCALL0(chdir, 0xc, 0xc)
__TSYSCALL0(time, 0xd, 0xd)
__TSYSCALL0(mknod, 0xe, 0xe)
__TSYSCALL0(chmod, 0xf, 0xf)
__TSYSCALL0(lchown, 0x10, 0x10)
__TSYSCALL0_UNUSED(0x11, 0x11, 0x11)
__TSYSCALL0_UNUSED(0x12, 0x12, 0x12)
__TSYSCALL0(lseek, 0x13, 0x13)
__TSYSCALL0(getpid, 0x14, 0x14)
__TSYSCALL0(mount, 0x15, 0x15)
__TSYSCALL0(umount, 0x16, 0x16)
__TSYSCALL0(setuid, 0x17, 0x17)
__TSYSCALL0(getuid, 0x18, 0x18)
__TSYSCALL0(stime, 0x19, 0x19)
__TSYSCALL0(ptrace, 0x1a, 0x1a)
__TSYSCALL0(alarm, 0x1b, 0x1b)
__TSYSCALL0_UNUSED(0x1c, 0x1c, 0x1c)
__TSYSCALL0(pause, 0x1d, 0x1d)
__TSYSCALL0(utime, 0x1e, 0x1e)
__TSYSCALL0_UNUSED(0x1f, 0x1f, 0x1f)
__TSYSCALL0_UNUSED(0x20, 0x20, 0x20)
__TSYSCALL0(access, 0x21, 0x21)
__TSYSCALL0(nice, 0x22, 0x22)
__TSYSCALL0_UNUSED(0x23, 0x23, 0x23)
__TSYSCALL0(sync, 0x24, 0x24)
__TSYSCALL0(kill, 0x25, 0x25)
__TSYSCALL0(rename, 0x26, 0x26)
__TSYSCALL0(mkdir, 0x27, 0x27)
__TSYSCALL0(rmdir, 0x28, 0x28)
__TSYSCALL0(dup, 0x29, 0x29)
__TSYSCALL0(pipe, 0x2a, 0x2a)
__TSYSCALL0(times, 0x2b, 0x2b)
__TSYSCALL0_UNUSED(0x2c, 0x2c, 0x2c)
__TSYSCALL0(brk, 0x2d, 0x2d)
__TSYSCALL0(setgid, 0x2e, 0x2e)
__TSYSCALL0(getgid, 0x2f, 0x2f)
__TSYSCALL0_UNUSED(0x30, 0x30, 0x30)
__TSYSCALL0(geteuid, 0x31, 0x31)
__TSYSCALL0(getegid, 0x32, 0x32)
__TSYSCALL0(acct, 0x33, 0x33)
__TSYSCALL0(umount2, 0x34, 0x34)
__TSYSCALL0_UNUSED(0x35, 0x35, 0x35)
__TSYSCALL0(ioctl, 0x36, 0x36)
__TSYSCALL0(fcntl, 0x37, 0x37)
__TSYSCALL0_UNUSED(0x38, 0x38, 0x38)
__TSYSCALL0(setpgid, 0x39, 0x39)
__TSYSCALL0_UNUSED(0x3a, 0x3a, 0x3a)
__TSYSCALL0_UNUSED(0x3b, 0x3b, 0x3b)
__TSYSCALL0(umask, 0x3c, 0x3c)
__TSYSCALL0(chroot, 0x3d, 0x3d)
__TSYSCALL0(ustat, 0x3e, 0x3e)
__TSYSCALL0(dup2, 0x3f, 0x3f)
__TSYSCALL0(getppid, 0x40, 0x40)
__TSYSCALL0(getpgrp, 0x41, 0x41)
__TSYSCALL0(setsid, 0x42, 0x42)
__TSYSCALL0(sigaction, 0x43, 0x43)
__TSYSCALL0_UNUSED(0x44, 0x44, 0x44)
__TSYSCALL0_UNUSED(0x45, 0x45, 0x45)
__TSYSCALL0(setreuid, 0x46, 0x46)
__TSYSCALL0(setregid, 0x47, 0x47)
__TSYSCALL0(sigsuspend, 0x48, 0x48)
__TSYSCALL0(sigpending, 0x49, 0x49)
__TSYSCALL0(sethostname, 0x4a, 0x4a)
__TSYSCALL0(setrlimit, 0x4b, 0x4b)
__TSYSCALL0(getrlimit, 0x4c, 0x4c)
__TSYSCALL0(getrusage, 0x4d, 0x4d)
__TSYSCALL0(gettimeofday, 0x4e, 0x4e)
__TSYSCALL0(settimeofday, 0x4f, 0x4f)
__TSYSCALL0(getgroups, 0x50, 0x50)
__TSYSCALL0(setgroups, 0x51, 0x51)
__TSYSCALL0(select, 0x52, 0x52)
__TSYSCALL0(symlink, 0x53, 0x53)
__TSYSCALL0_UNUSED(0x54, 0x54, 0x54)
__TSYSCALL0(readlink, 0x55, 0x55)
__TSYSCALL0(uselib, 0x56, 0x56)
__TSYSCALL0(swapon, 0x57, 0x57)
__TSYSCALL0(reboot, 0x58, 0x58)
__TSYSCALL0(readdir, 0x59, 0x59)
__TSYSCALL0(mmap, 0x5a, 0x5a)
__TSYSCALL0(munmap, 0x5b, 0x5b)
__TSYSCALL0(truncate, 0x5c, 0x5c)
__TSYSCALL0(ftruncate, 0x5d, 0x5d)
__TSYSCALL0(fchmod, 0x5e, 0x5e)
__TSYSCALL0(fchown, 0x5f, 0x5f)
__TSYSCALL0(getpriority, 0x60, 0x60)
__TSYSCALL0(setpriority, 0x61, 0x61)
__TSYSCALL0_UNUSED(0x62, 0x62, 0x62)
__TSYSCALL0(statfs, 0x63, 0x63)
__TSYSCALL0(fstatfs, 0x64, 0x64)
__TSYSCALL0_UNUSED(0x65, 0x65, 0x65)
__TSYSCALL0(socketcall, 0x66, 0x66)
__TSYSCALL0(syslog, 0x67, 0x67)
__TSYSCALL0(setitimer, 0x68, 0x68)
__TSYSCALL0(getitimer, 0x69, 0x69)
__TSYSCALL0(stat, 0x6a, 0x6a)
__TSYSCALL0(lstat, 0x6b, 0x6b)
__TSYSCALL0(fstat, 0x6c, 0x6c)
__TSYSCALL0_UNUSED(0x6d, 0x6d, 0x6d)
__TSYSCALL0_UNUSED(0x6e, 0x6e, 0x6e)
__TSYSCALL0(vhangup, 0x6f, 0x6f)
__TSYSCALL0_UNUSED(0x70, 0x70, 0x70)
__TSYSCALL0(syscall, 0x71, 0x71)
__TSYSCALL0(wait4, 0x72, 0x72)
__TSYSCALL0(swapoff, 0x73, 0x73)
__TSYSCALL0(sysinfo, 0x74, 0x74)
__TSYSCALL0(ipc, 0x75, 0x75)
__TSYSCALL0(fsync, 0x76, 0x76)
__TSYSCALL0(sigreturn, 0x77, 0x77)
__TSYSCALL0(clone, 0x78, 0x78)
__TSYSCALL0(setdomainname, 0x79, 0x79)
__TSYSCALL0(uname, 0x7a, 0x7a)
__TSYSCALL0_UNUSED(0x7b, 0x7b, 0x7b)
__TSYSCALL0(adjtimex, 0x7c, 0x7c)
__TSYSCALL0(mprotect, 0x7d, 0x7d)
__TSYSCALL0(sigprocmask, 0x7e, 0x7e)
__TSYSCALL0_UNUSED(0x7f, 0x7f, 0x7f)
__TSYSCALL0(init_module, 0x80, 0x80)
__TSYSCALL0(delete_module, 0x81, 0x81)
__TSYSCALL0_UNUSED(0x82, 0x82, 0x82)
__TSYSCALL0(quotactl, 0x83, 0x83)
__TSYSCALL0(getpgid, 0x84, 0x84)
__TSYSCALL0(fchdir, 0x85, 0x85)
__TSYSCALL0(bdflush, 0x86, 0x86)
__TSYSCALL0(sysfs, 0x87, 0x87)
__TSYSCALL0(personality, 0x88, 0x88)
__TSYSCALL0_UNUSED(0x89, 0x89, 0x89)
__TSYSCALL0(setfsuid, 0x8a, 0x8a)
__TSYSCALL0(setfsgid, 0x8b, 0x8b)
__TSYSCALL0(_llseek, 0x8c, 0x8c)
__TSYSCALL0(getdents, 0x8d, 0x8d)
__TSYSCALL0(_newselect, 0x8e, 0x8e)
__TSYSCALL0(flock, 0x8f, 0x8f)
__TSYSCALL0(msync, 0x90, 0x90)
__TSYSCALL0(readv, 0x91, 0x91)
__TSYSCALL0(writev, 0x92, 0x92)
__TSYSCALL0(getsid, 0x93, 0x93)
__TSYSCALL0(fdatasync, 0x94, 0x94)
__TSYSCALL0(_sysctl, 0x95, 0x95)
__TSYSCALL0(mlock, 0x96, 0x96)
__TSYSCALL0(munlock, 0x97, 0x97)
__TSYSCALL0(mlockall, 0x98, 0x98)
__TSYSCALL0(munlockall, 0x99, 0x99)
__TSYSCALL0(sched_setparam, 0x9a, 0x9a)
__TSYSCALL0(sched_getparam, 0x9b, 0x9b)
__TSYSCALL0(sched_setscheduler, 0x9c, 0x9c)
__TSYSCALL0(sched_getscheduler, 0x9d, 0x9d)
__TSYSCALL0(sched_yield, 0x9e, 0x9e)
__TSYSCALL0(sched_get_priority_max, 0x9f, 0x9f)
__TSYSCALL0(sched_get_priority_min, 0xa0, 0xa0)
__TSYSCALL0(sched_rr_get_interval, 0xa1, 0xa1)
__TSYSCALL0(nanosleep, 0xa2, 0xa2)
__TSYSCALL0(mremap, 0xa3, 0xa3)
__TSYSCALL0(setresuid, 0xa4, 0xa4)
__TSYSCALL0(getresuid, 0xa5, 0xa5)
__TSYSCALL0_UNUSED(0xa6, 0xa6, 0xa6)
__TSYSCALL0_UNUSED(0xa7, 0xa7, 0xa7)
__TSYSCALL0(poll, 0xa8, 0xa8)
__TSYSCALL0(nfsservctl, 0xa9, 0xa9)
__TSYSCALL0(setresgid, 0xaa, 0xaa)
__TSYSCALL0(getresgid, 0xab, 0xab)
__TSYSCALL0(prctl, 0xac, 0xac)
__TSYSCALL0(rt_sigreturn, 0xad, 0xad)
__TSYSCALL0(rt_sigaction, 0xae, 0xae)
__TSYSCALL0(rt_sigprocmask, 0xaf, 0xaf)
__TSYSCALL0(rt_sigpending, 0xb0, 0xb0)
__TSYSCALL0(rt_sigtimedwait, 0xb1, 0xb1)
__TSYSCALL0(rt_sigqueueinfo, 0xb2, 0xb2)
__TSYSCALL0(rt_sigsuspend, 0xb3, 0xb3)
__TSYSCALL0(pread64, 0xb4, 0xb4)
__TSYSCALL0(pwrite64, 0xb5, 0xb5)
__TSYSCALL0(chown, 0xb6, 0xb6)
__TSYSCALL0(getcwd, 0xb7, 0xb7)
__TSYSCALL0(capget, 0xb8, 0xb8)
__TSYSCALL0(capset, 0xb9, 0xb9)
__TSYSCALL0(sigaltstack, 0xba, 0xba)
__TSYSCALL0(sendfile, 0xbb, 0xbb)
__TSYSCALL0_UNUSED(0xbc, 0xbc, 0xbc)
__TSYSCALL0_UNUSED(0xbd, 0xbd, 0xbd)
__TSYSCALL0(vfork, 0xbe, 0xbe)
__TSYSCALL0(ugetrlimit, 0xbf, 0xbf)
__TSYSCALL0(mmap2, 0xc0, 0xc0)
__TSYSCALL0(truncate64, 0xc1, 0xc1)
__TSYSCALL0(ftruncate64, 0xc2, 0xc2)
__TSYSCALL0(stat64, 0xc3, 0xc3)
__TSYSCALL0(lstat64, 0xc4, 0xc4)
__TSYSCALL0(fstat64, 0xc5, 0xc5)
__TSYSCALL0(lchown32, 0xc6, 0xc6)
__TSYSCALL0(getuid32, 0xc7, 0xc7)
__TSYSCALL0(getgid32, 0xc8, 0xc8)
__TSYSCALL0(geteuid32, 0xc9, 0xc9)
__TSYSCALL0(getegid32, 0xca, 0xca)
__TSYSCALL0(setreuid32, 0xcb, 0xcb)
__TSYSCALL0(setregid32, 0xcc, 0xcc)
__TSYSCALL0(getgroups32, 0xcd, 0xcd)
__TSYSCALL0(setgroups32, 0xce, 0xce)
__TSYSCALL0(fchown32, 0xcf, 0xcf)
__TSYSCALL0(setresuid32, 0xd0, 0xd0)
__TSYSCALL0(getresuid32, 0xd1, 0xd1)
__TSYSCALL0(setresgid32, 0xd2, 0xd2)
__TSYSCALL0(getresgid32, 0xd3, 0xd3)
__TSYSCALL0(chown32, 0xd4, 0xd4)
__TSYSCALL0(setuid32, 0xd5, 0xd5)
__TSYSCALL0(setgid32, 0xd6, 0xd6)
__TSYSCALL0(setfsuid32, 0xd7, 0xd7)
__TSYSCALL0(setfsgid32, 0xd8, 0xd8)
__TSYSCALL0(getdents64, 0xd9, 0xd9)
__TSYSCALL0(pivot_root, 0xda, 0xda)
__TSYSCALL0(mincore, 0xdb, 0xdb)
__TSYSCALL0(madvise, 0xdc, 0xdc)
__TSYSCALL0(fcntl64, 0xdd, 0xdd)
__TSYSCALL0_UNUSED(0xde, 0xde, 0xde)
__TSYSCALL0_UNUSED(0xdf, 0xdf, 0xdf)
__TSYSCALL0(gettid, 0xe0, 0xe0)
__TSYSCALL0(readahead, 0xe1, 0xe1)
__TSYSCALL0(setxattr, 0xe2, 0xe2)
__TSYSCALL0(lsetxattr, 0xe3, 0xe3)
__TSYSCALL0(fsetxattr, 0xe4, 0xe4)
__TSYSCALL0(getxattr, 0xe5, 0xe5)
__TSYSCALL0(lgetxattr, 0xe6, 0xe6)
__TSYSCALL0(fgetxattr, 0xe7, 0xe7)
__TSYSCALL0(listxattr, 0xe8, 0xe8)
__TSYSCALL0(llistxattr, 0xe9, 0xe9)
__TSYSCALL0(flistxattr, 0xea, 0xea)
__TSYSCALL0(removexattr, 0xeb, 0xeb)
__TSYSCALL0(lremovexattr, 0xec, 0xec)
__TSYSCALL0(fremovexattr, 0xed, 0xed)
__TSYSCALL0(tkill, 0xee, 0xee)
__TSYSCALL0(sendfile64, 0xef, 0xef)
__TSYSCALL0(futex, 0xf0, 0xf0)
__TSYSCALL0(sched_setaffinity, 0xf1, 0xf1)
__TSYSCALL0(sched_getaffinity, 0xf2, 0xf2)
__TSYSCALL0(io_setup, 0xf3, 0xf3)
__TSYSCALL0(io_destroy, 0xf4, 0xf4)
__TSYSCALL0(io_getevents, 0xf5, 0xf5)
__TSYSCALL0(io_submit, 0xf6, 0xf6)
__TSYSCALL0(io_cancel, 0xf7, 0xf7)
__TSYSCALL0(exit_group, 0xf8, 0xf8)
__TSYSCALL0(lookup_dcookie, 0xf9, 0xf9)
__TSYSCALL0(epoll_create, 0xfa, 0xfa)
__TSYSCALL0(epoll_ctl, 0xfb, 0xfb)
__TSYSCALL0(epoll_wait, 0xfc, 0xfc)
__TSYSCALL0(remap_file_pages, 0xfd, 0xfd)
__TSYSCALL0_UNUSED(0xfe, 0xfe, 0xfe)
__TSYSCALL0_UNUSED(0xff, 0xff, 0xff)
__TSYSCALL0(set_tid_address, 0x100, 0x100)
__TSYSCALL0(timer_create, 0x101, 0x101)
__TSYSCALL0(timer_settime, 0x102, 0x102)
__TSYSCALL0(timer_gettime, 0x103, 0x103)
__TSYSCALL0(timer_getoverrun, 0x104, 0x104)
__TSYSCALL0(timer_delete, 0x105, 0x105)
__TSYSCALL0(clock_settime, 0x106, 0x106)
__TSYSCALL0(clock_gettime, 0x107, 0x107)
__TSYSCALL0(clock_getres, 0x108, 0x108)
__TSYSCALL0(clock_nanosleep, 0x109, 0x109)
__TSYSCALL0(statfs64, 0x10a, 0x10a)
__TSYSCALL0(fstatfs64, 0x10b, 0x10b)
__TSYSCALL0(tgkill, 0x10c, 0x10c)
__TSYSCALL0(utimes, 0x10d, 0x10d)
__TSYSCALL0(arm_fadvise64_64, 0x10e, 0x10e)
__TSYSCALL0(pciconfig_iobase, 0x10f, 0x10f)
__TSYSCALL0(pciconfig_read, 0x110, 0x110)
__TSYSCALL0(pciconfig_write, 0x111, 0x111)
__TSYSCALL0(mq_open, 0x112, 0x112)
__TSYSCALL0(mq_unlink, 0x113, 0x113)
__TSYSCALL0(mq_timedsend, 0x114, 0x114)
__TSYSCALL0(mq_timedreceive, 0x115, 0x115)
__TSYSCALL0(mq_notify, 0x116, 0x116)
__TSYSCALL0(mq_getsetattr, 0x117, 0x117)
__TSYSCALL0(waitid, 0x118, 0x118)
__TSYSCALL0(socket, 0x119, 0x119)
__TSYSCALL0(bind, 0x11a, 0x11a)
__TSYSCALL0(connect, 0x11b, 0x11b)
__TSYSCALL0(listen, 0x11c, 0x11c)
__TSYSCALL0(accept, 0x11d, 0x11d)
__TSYSCALL0(getsockname, 0x11e, 0x11e)
__TSYSCALL0(getpeername, 0x11f, 0x11f)
__TSYSCALL0(socketpair, 0x120, 0x120)
__TSYSCALL0(send, 0x121, 0x121)
__TSYSCALL0(sendto, 0x122, 0x122)
__TSYSCALL0(recv, 0x123, 0x123)
__TSYSCALL0(recvfrom, 0x124, 0x124)
__TSYSCALL0(shutdown, 0x125, 0x125)
__TSYSCALL0(setsockopt, 0x126, 0x126)
__TSYSCALL0(getsockopt, 0x127, 0x127)
__TSYSCALL0(sendmsg, 0x128, 0x128)
__TSYSCALL0(recvmsg, 0x129, 0x129)
__TSYSCALL0(semop, 0x12a, 0x12a)
__TSYSCALL0(semget, 0x12b, 0x12b)
__TSYSCALL0(semctl, 0x12c, 0x12c)
__TSYSCALL0(msgsnd, 0x12d, 0x12d)
__TSYSCALL0(msgrcv, 0x12e, 0x12e)
__TSYSCALL0(msgget, 0x12f, 0x12f)
__TSYSCALL0(msgctl, 0x130, 0x130)
__TSYSCALL0(shmat, 0x131, 0x131)
__TSYSCALL0(shmdt, 0x132, 0x132)
__TSYSCALL0(shmget, 0x133, 0x133)
__TSYSCALL0(shmctl, 0x134, 0x134)
__TSYSCALL0(add_key, 0x135, 0x135)
__TSYSCALL0(request_key, 0x136, 0x136)
__TSYSCALL0(keyctl, 0x137, 0x137)
__TSYSCALL0(semtimedop, 0x138, 0x138)
__TSYSCALL0(vserve, 0x139, 0x139)
__TSYSCALL0(ioprio_set, 0x13a, 0x13a)
__TSYSCALL0(ioprio_get, 0x13b, 0x13b)
__TSYSCALL0(inotify_init, 0x13c, 0x13c)
__TSYSCALL0(inotify_add_watch, 0x13d, 0x13d)
__TSYSCALL0(inotify_rm_watch, 0x13e, 0x13e)
__TSYSCALL0(mbind, 0x13f, 0x13f)
__TSYSCALL0(get_mempolicy, 0x140, 0x140)
__TSYSCALL0(set_mempolicy, 0x141, 0x141)
__TSYSCALL0(openat, 0x142, 0x142)
__TSYSCALL0(mkdirat, 0x143, 0x143)
__TSYSCALL0(mknodat, 0x144, 0x144)
__TSYSCALL0(fchownat, 0x145, 0x145)
__TSYSCALL0(futimesat, 0x146, 0x146)
__TSYSCALL0(fstatat64, 0x147, 0x147)
__TSYSCALL0(unlinkat, 0x148, 0x148)
__TSYSCALL0(renameat, 0x149, 0x149)
__TSYSCALL0(linkat, 0x14a, 0x14a)
__TSYSCALL0(symlinkat, 0x14b, 0x14b)
__TSYSCALL0(readlinkat, 0x14c, 0x14c)
__TSYSCALL0(fchmodat, 0x14d, 0x14d)
__TSYSCALL0(faccessat, 0x14e, 0x14e)
__TSYSCALL0(pselect6, 0x14f, 0x14f)
__TSYSCALL0(ppoll, 0x150, 0x150)
__TSYSCALL0(unshare, 0x151, 0x151)
__TSYSCALL0(set_robust_list, 0x152, 0x152)
__TSYSCALL0(get_robust_list, 0x153, 0x153)
__TSYSCALL0(splice, 0x154, 0x154)
__TSYSCALL0(sync_file_range2, 0x155, 0x155)
__TSYSCALL0(tee, 0x156, 0x156)
__TSYSCALL0(vmsplice, 0x157, 0x157)
__TSYSCALL0(move_pages, 0x158, 0x158)
__TSYSCALL0(getcpu, 0x159, 0x159)
__TSYSCALL0(epoll_pwait, 0x15a, 0x15a)
__TSYSCALL0(kexec_load, 0x15b, 0x15b)
__TSYSCALL0(utimensat, 0x15c, 0x15c)
__TSYSCALL0(signalfd, 0x15d, 0x15d)
__TSYSCALL0(timerfd_create, 0x15e, 0x15e)
__TSYSCALL0(eventfd, 0x15f, 0x15f)
__TSYSCALL0(fallocate, 0x160, 0x160)
__TSYSCALL0(timerfd_settime, 0x161, 0x161)
__TSYSCALL0(timerfd_gettime, 0x162, 0x162)
__TSYSCALL0(signalfd4, 0x163, 0x163)
__TSYSCALL0(eventfd2, 0x164, 0x164)
__TSYSCALL0(epoll_create1, 0x165, 0x165)
__TSYSCALL0(dup3, 0x166, 0x166)
__TSYSCALL0(pipe2, 0x167, 0x167)
__TSYSCALL0(inotify_init1, 0x168, 0x168)
__TSYSCALL0(preadv, 0x169, 0x169)
__TSYSCALL0(pwritev, 0x16a, 0x16a)
__TSYSCALL0(rt_tgsigqueueinfo, 0x16b, 0x16b)
__TSYSCALL0(perf_event_open, 0x16c, 0x16c)
__TSYSCALL0(recvmmsg, 0x16d, 0x16d)
__TSYSCALL0(accept4, 0x16e, 0x16e)
__TSYSCALL0(fanotify_init, 0x16f, 0x16f)
__TSYSCALL0(fanotify_mark, 0x170, 0x170)
__TSYSCALL0(prlimit64, 0x171, 0x171)
__TSYSCALL0(name_to_handle_at, 0x172, 0x172)
__TSYSCALL0(open_by_handle_at, 0x173, 0x173)
__TSYSCALL0(clock_adjtime, 0x174, 0x174)
__TSYSCALL0(syncfs, 0x175, 0x175)
__TSYSCALL0(sendmmsg, 0x176, 0x176)
__TSYSCALL0(setns, 0x177, 0x177)
__TSYSCALL0(process_vm_readv, 0x178, 0x178)
__TSYSCALL0(process_vm_writev, 0x179, 0x179)
__TSYSCALL0(kcmp, 0x17a, 0x17a)
__TSYSCALL0(finit_module, 0x17b, 0x17b)
__TSYSCALL0(sched_setattr, 0x17c, 0x17c)
__TSYSCALL0(sched_getattr, 0x17d, 0x17d)
__TSYSCALL0(renameat2, 0x17e, 0x17e)
__TSYSCALL0(seccomp, 0x17f, 0x17f)
__TSYSCALL0(getrandom, 0x180, 0x180)
__TSYSCALL0(memfd_create, 0x181, 0x181)
__TSYSCALL0(bpf, 0x182, 0x182)
__TSYSCALL0(execveat, 0x183, 0x183)
__TSYSCALL0(userfaultfd, 0x184, 0x184)
__TSYSCALL0(membarrier, 0x185, 0x185)
__TSYSCALL0(mlock2, 0x186, 0x186)
__TSYSCALL0(copy_file_range, 0x187, 0x187)
__TSYSCALL0(preadv2, 0x188, 0x188)
__TSYSCALL0(pwritev2, 0x189, 0x189)
__TSYSCALL0(pkey_mprotect, 0x18a, 0x18a)
__TSYSCALL0(pkey_alloc, 0x18b, 0x18b)
__TSYSCALL0(pkey_free, 0x18c, 0x18c)
__TSYSCALL0(statx, 0x18d, 0x18d)
__TSYSCALL0(rseq, 0x18e, 0x18e)
__TSYSCALL0(io_pgetevents, 0x18f, 0x18f)
__TSYSCALL0(migrate_pages, 0x190, 0x190)
__TSYSCALL0(kexec_file_load, 0x191, 0x191)
__TSYSCALL0_UNUSED(0x192, 0x192, 0x192)
__TSYSCALL0(clock_gettime64, 0x193, 0x193)
__TSYSCALL0(clock_settime64, 0x194, 0x194)
__TSYSCALL0(clock_adjtime64, 0x195, 0x195)
__TSYSCALL0(clock_getres_time64, 0x196, 0x196)
__TSYSCALL0(clock_nanosleep_time64, 0x197, 0x197)
__TSYSCALL0(timer_gettime64, 0x198, 0x198)
__TSYSCALL0(timer_settime64, 0x199, 0x199)
__TSYSCALL0(timerfd_gettime64, 0x19a, 0x19a)
__TSYSCALL0(timerfd_settime64, 0x19b, 0x19b)
__TSYSCALL0(utimensat_time64, 0x19c, 0x19c)
__TSYSCALL0(pselect6_time64, 0x19d, 0x19d)
__TSYSCALL0(ppoll_time64, 0x19e, 0x19e)
__TSYSCALL0_UNUSED(0x19f, 0x19f, 0x19f)
__TSYSCALL0(io_pgetevents_time64, 0x1a0, 0x1a0)
__TSYSCALL0(recvmmsg_time64, 0x1a1, 0x1a1)
__TSYSCALL0(mq_timedsend_time64, 0x1a2, 0x1a2)
__TSYSCALL0(mq_timedreceive_time64, 0x1a3, 0x1a3)
__TSYSCALL0(semtimedop_time64, 0x1a4, 0x1a4)
__TSYSCALL0(rt_sigtimedwait_time64, 0x1a5, 0x1a5)
__TSYSCALL0(futex_time64, 0x1a6, 0x1a6)
__TSYSCALL0(sched_rr_get_interval_time64, 0x1a7, 0x1a7)
__TSYSCALL0(pidfd_send_signal, 0x1a8, 0x1a8)
__TSYSCALL0(io_uring_setup, 0x1a9, 0x1a9)
__TSYSCALL0(io_uring_enter, 0x1aa, 0x1aa)
__TSYSCALL0(io_uring_register, 0x1ab, 0x1ab)
__TSYSCALL0(open_tree, 0x1ac, 0x1ac)
__TSYSCALL0(move_mount, 0x1ad, 0x1ad)
__TSYSCALL0(fsopen, 0x1ae, 0x1ae)
__TSYSCALL0(fsconfig, 0x1af, 0x1af)
__TSYSCALL0(fsmount, 0x1b0, 0x1b0)
__TSYSCALL0(fspick, 0x1b1, 0x1b1)
__TSYSCALL0(pidfd_open, 0x1b2, 0x1b2)
__TSYSCALL0(clone3, 0x1b3, 0x1b3)
__TSYSCALL0(close_range, 0x1b4, 0x1b4)
__TSYSCALL0(openat2, 0x1b5, 0x1b5)
__TSYSCALL0(pidfd_getfd, 0x1b6, 0x1b6)
__TSYSCALL0(faccessat2, 0x1b7, 0x1b7)
__TSYSCALL0(process_madvise, 0x1b8, 0x1b8)
__TSYSCALL0_TABLE_END(0x0, 0x1b8, 0x1b9, 0x0, 0x1b8, 0x1b9)

/************************************************************************/
/* Contents of the 2nd table                                            */
/************************************************************************/
__TSYSCALL1_TABLE_BEGIN(0xf0001, 0xf0006, 0x6, 0xf0001, 0xf0006, 0x6)
__TSYSCALL1(breakpoint, 0x0, 0x0)
__TSYSCALL1(cacheflush, 0x1, 0x1)
__TSYSCALL1(usr26, 0x2, 0x2)
__TSYSCALL1(usr32, 0x3, 0x3)
__TSYSCALL1(set_tls, 0x4, 0x4)
__TSYSCALL1(get_tls, 0x5, 0x5)
__TSYSCALL1_TABLE_END(0xf0001, 0xf0006, 0x6, 0xf0001, 0xf0006, 0x6)

/************************************************************************/
/* Contents of the 3rd table                                            */
/************************************************************************/
__TSYSCALL2_TABLE_BEGIN(0x7f0003, 0x7f0160, 0x15e, 0x7f0003, 0x7f0160, 0x15e)
__TSYSCALL2(readf, 0x0, 0x0)
__TSYSCALL2(writef, 0x1, 0x1)
__TSYSCALL2(getdrives, 0x2, 0x2)
__TSYSCALL2(frealpath4, 0x3, 0x3)
__TSYSCALL2(detach, 0x4, 0x4)
__TSYSCALL2(frealpathat, 0x5, 0x5)
__TSYSCALL2(rpc_schedule, 0x6, 0x6)
__TSYSCALL2_UNUSED(0x7f000a, 0x7, 0x7)
__TSYSCALL2(openpty, 0x8, 0x8)
__TSYSCALL2(fchdirat, 0x9, 0x9)
__TSYSCALL2(time64, 0xa, 0xa)
__TSYSCALL2(mktty, 0xb, 0xb)
__TSYSCALL2(set_exception_handler, 0xc, 0xc)
__TSYSCALL2(get_exception_handler, 0xd, 0xd)
__TSYSCALL2(debugtrap, 0xe, 0xe)
__TSYSCALL2(coredump, 0xf, 0xf)
__TSYSCALL2(lseek64, 0x10, 0x10)
__TSYSCALL2(userviofd, 0x11, 0x11)
__TSYSCALL2_UNUSED(0x7f0015, 0x12, 0x12)
__TSYSCALL2_UNUSED(0x7f0016, 0x13, 0x13)
__TSYSCALL2_UNUSED(0x7f0017, 0x14, 0x14)
__TSYSCALL2_UNUSED(0x7f0018, 0x15, 0x15)
__TSYSCALL2(stime64, 0x16, 0x16)
__TSYSCALL2_UNUSED(0x7f001a, 0x17, 0x17)
__TSYSCALL2_UNUSED(0x7f001b, 0x18, 0x18)
__TSYSCALL2_UNUSED(0x7f001c, 0x19, 0x19)
__TSYSCALL2_UNUSED(0x7f001d, 0x1a, 0x1a)
__TSYSCALL2(utime64, 0x1b, 0x1b)
__TSYSCALL2_UNUSED(0x7f001f, 0x1c, 0x1c)
__TSYSCALL2_UNUSED(0x7f0020, 0x1d, 0x1d)
__TSYSCALL2_UNUSED(0x7f0021, 0x1e, 0x1e)
__TSYSCALL2_UNUSED(0x7f0022, 0x1f, 0x1f)
__TSYSCALL2(ftime64, 0x20, 0x20)
__TSYSCALL2_UNUSED(0x7f0024, 0x21, 0x21)
__TSYSCALL2_UNUSED(0x7f0025, 0x22, 0x22)
__TSYSCALL2_UNUSED(0x7f0026, 0x23, 0x23)
__TSYSCALL2_UNUSED(0x7f0027, 0x24, 0x24)
__TSYSCALL2_UNUSED(0x7f0028, 0x25, 0x25)
__TSYSCALL2_UNUSED(0x7f0029, 0x26, 0x26)
__TSYSCALL2_UNUSED(0x7f002a, 0x27, 0x27)
__TSYSCALL2_UNUSED(0x7f002b, 0x28, 0x28)
__TSYSCALL2_UNUSED(0x7f002c, 0x29, 0x29)
__TSYSCALL2_UNUSED(0x7f002d, 0x2a, 0x2a)
__TSYSCALL2_UNUSED(0x7f002e, 0x2b, 0x2b)
__TSYSCALL2_UNUSED(0x7f002f, 0x2c, 0x2c)
__TSYSCALL2(rtm_begin, 0x2d, 0x2d)
__TSYSCALL2(rtm_end, 0x2e, 0x2e)
__TSYSCALL2(rtm_abort, 0x2f, 0x2f)
__TSYSCALL2(rtm_test, 0x30, 0x30)
__TSYSCALL2_UNUSED(0x7f0034, 0x31, 0x31)
__TSYSCALL2_UNUSED(0x7f0035, 0x32, 0x32)
__TSYSCALL2(ioctlf, 0x33, 0x33)
__TSYSCALL2_UNUSED(0x7f0037, 0x34, 0x34)
__TSYSCALL2_UNUSED(0x7f0038, 0x35, 0x35)
__TSYSCALL2_UNUSED(0x7f0039, 0x36, 0x36)
__TSYSCALL2_UNUSED(0x7f003a, 0x37, 0x37)
__TSYSCALL2_UNUSED(0x7f003b, 0x38, 0x38)
__TSYSCALL2(fsmode, 0x39, 0x39)
__TSYSCALL2_UNUSED(0x7f003d, 0x3a, 0x3a)
__TSYSCALL2_UNUSED(0x7f003e, 0x3b, 0x3b)
__TSYSCALL2_UNUSED(0x7f003f, 0x3c, 0x3c)
__TSYSCALL2_UNUSED(0x7f0040, 0x3d, 0x3d)
__TSYSCALL2_UNUSED(0x7f0041, 0x3e, 0x3e)
__TSYSCALL2_UNUSED(0x7f0042, 0x3f, 0x3f)
__TSYSCALL2_UNUSED(0x7f0043, 0x40, 0x40)
__TSYSCALL2_UNUSED(0x7f0044, 0x41, 0x41)
__TSYSCALL2_UNUSED(0x7f0045, 0x42, 0x42)
__TSYSCALL2_UNUSED(0x7f0046, 0x43, 0x43)
__TSYSCALL2_UNUSED(0x7f0047, 0x44, 0x44)
__TSYSCALL2_UNUSED(0x7f0048, 0x45, 0x45)
__TSYSCALL2_UNUSED(0x7f0049, 0x46, 0x46)
__TSYSCALL2_UNUSED(0x7f004a, 0x47, 0x47)
__TSYSCALL2_UNUSED(0x7f004b, 0x48, 0x48)
__TSYSCALL2_UNUSED(0x7f004c, 0x49, 0x49)
__TSYSCALL2(getrusage64, 0x4a, 0x4a)
__TSYSCALL2(gettimeofday64, 0x4b, 0x4b)
__TSYSCALL2(settimeofday64, 0x4c, 0x4c)
__TSYSCALL2_UNUSED(0x7f0050, 0x4d, 0x4d)
__TSYSCALL2_UNUSED(0x7f0051, 0x4e, 0x4e)
__TSYSCALL2_UNUSED(0x7f0052, 0x4f, 0x4f)
__TSYSCALL2_UNUSED(0x7f0053, 0x50, 0x50)
__TSYSCALL2_UNUSED(0x7f0054, 0x51, 0x51)
__TSYSCALL2_UNUSED(0x7f0055, 0x52, 0x52)
__TSYSCALL2(maplibrary, 0x53, 0x53)
__TSYSCALL2_UNUSED(0x7f0057, 0x54, 0x54)
__TSYSCALL2_UNUSED(0x7f0058, 0x55, 0x55)
__TSYSCALL2_UNUSED(0x7f0059, 0x56, 0x56)
__TSYSCALL2_UNUSED(0x7f005a, 0x57, 0x57)
__TSYSCALL2_UNUSED(0x7f005b, 0x58, 0x58)
__TSYSCALL2_UNUSED(0x7f005c, 0x59, 0x59)
__TSYSCALL2_UNUSED(0x7f005d, 0x5a, 0x5a)
__TSYSCALL2_UNUSED(0x7f005e, 0x5b, 0x5b)
__TSYSCALL2_UNUSED(0x7f005f, 0x5c, 0x5c)
__TSYSCALL2_UNUSED(0x7f0060, 0x5d, 0x5d)
__TSYSCALL2_UNUSED(0x7f0061, 0x5e, 0x5e)
__TSYSCALL2_UNUSED(0x7f0062, 0x5f, 0x5f)
__TSYSCALL2_UNUSED(0x7f0063, 0x60, 0x60)
__TSYSCALL2_UNUSED(0x7f0064, 0x61, 0x61)
__TSYSCALL2_UNUSED(0x7f0065, 0x62, 0x62)
__TSYSCALL2_UNUSED(0x7f0066, 0x63, 0x63)
__TSYSCALL2_UNUSED(0x7f0067, 0x64, 0x64)
__TSYSCALL2(setitimer64, 0x65, 0x65)
__TSYSCALL2(getitimer64, 0x66, 0x66)
__TSYSCALL2_UNUSED(0x7f006a, 0x67, 0x67)
__TSYSCALL2_UNUSED(0x7f006b, 0x68, 0x68)
__TSYSCALL2_UNUSED(0x7f006c, 0x69, 0x69)
__TSYSCALL2_UNUSED(0x7f006d, 0x6a, 0x6a)
__TSYSCALL2_UNUSED(0x7f006e, 0x6b, 0x6b)
__TSYSCALL2_UNUSED(0x7f006f, 0x6c, 0x6c)
__TSYSCALL2_UNUSED(0x7f0070, 0x6d, 0x6d)
__TSYSCALL2_UNUSED(0x7f0071, 0x6e, 0x6e)
__TSYSCALL2(wait4_64, 0x6f, 0x6f)
__TSYSCALL2_UNUSED(0x7f0073, 0x70, 0x70)
__TSYSCALL2_UNUSED(0x7f0074, 0x71, 0x71)
__TSYSCALL2_UNUSED(0x7f0075, 0x72, 0x72)
__TSYSCALL2_UNUSED(0x7f0076, 0x73, 0x73)
__TSYSCALL2_UNUSED(0x7f0077, 0x74, 0x74)
__TSYSCALL2_UNUSED(0x7f0078, 0x75, 0x75)
__TSYSCALL2_UNUSED(0x7f0079, 0x76, 0x76)
__TSYSCALL2_UNUSED(0x7f007a, 0x77, 0x77)
__TSYSCALL2_UNUSED(0x7f007b, 0x78, 0x78)
__TSYSCALL2_UNUSED(0x7f007c, 0x79, 0x79)
__TSYSCALL2_UNUSED(0x7f007d, 0x7a, 0x7a)
__TSYSCALL2_UNUSED(0x7f007e, 0x7b, 0x7b)
__TSYSCALL2_UNUSED(0x7f007f, 0x7c, 0x7c)
__TSYSCALL2_UNUSED(0x7f0080, 0x7d, 0x7d)
__TSYSCALL2_UNUSED(0x7f0081, 0x7e, 0x7e)
__TSYSCALL2_UNUSED(0x7f0082, 0x7f, 0x7f)
__TSYSCALL2_UNUSED(0x7f0083, 0x80, 0x80)
__TSYSCALL2_UNUSED(0x7f0084, 0x81, 0x81)
__TSYSCALL2_UNUSED(0x7f0085, 0x82, 0x82)
__TSYSCALL2_UNUSED(0x7f0086, 0x83, 0x83)
__TSYSCALL2_UNUSED(0x7f0087, 0x84, 0x84)
__TSYSCALL2_UNUSED(0x7f0088, 0x85, 0x85)
__TSYSCALL2_UNUSED(0x7f0089, 0x86, 0x86)
__TSYSCALL2_UNUSED(0x7f008a, 0x87, 0x87)
__TSYSCALL2_UNUSED(0x7f008b, 0x88, 0x88)
__TSYSCALL2_UNUSED(0x7f008c, 0x89, 0x89)
__TSYSCALL2_UNUSED(0x7f008d, 0x8a, 0x8a)
__TSYSCALL2(select64, 0x8b, 0x8b)
__TSYSCALL2_UNUSED(0x7f008f, 0x8c, 0x8c)
__TSYSCALL2_UNUSED(0x7f0090, 0x8d, 0x8d)
__TSYSCALL2(readvf, 0x8e, 0x8e)
__TSYSCALL2(writevf, 0x8f, 0x8f)
__TSYSCALL2_UNUSED(0x7f0093, 0x90, 0x90)
__TSYSCALL2_UNUSED(0x7f0094, 0x91, 0x91)
__TSYSCALL2(ksysctl, 0x92, 0x92)
__TSYSCALL2_UNUSED(0x7f0096, 0x93, 0x93)
__TSYSCALL2_UNUSED(0x7f0097, 0x94, 0x94)
__TSYSCALL2_UNUSED(0x7f0098, 0x95, 0x95)
__TSYSCALL2_UNUSED(0x7f0099, 0x96, 0x96)
__TSYSCALL2_UNUSED(0x7f009a, 0x97, 0x97)
__TSYSCALL2_UNUSED(0x7f009b, 0x98, 0x98)
__TSYSCALL2_UNUSED(0x7f009c, 0x99, 0x99)
__TSYSCALL2_UNUSED(0x7f009d, 0x9a, 0x9a)
__TSYSCALL2(rpc_serve, 0x9b, 0x9b)
__TSYSCALL2(rpc_serve_sysret, 0x9c, 0x9c)
__TSYSCALL2_UNUSED(0x7f00a0, 0x9d, 0x9d)
__TSYSCALL2_UNUSED(0x7f00a1, 0x9e, 0x9e)
__TSYSCALL2(nanosleep64, 0x9f, 0x9f)
__TSYSCALL2_UNUSED(0x7f00a3, 0xa0, 0xa0)
__TSYSCALL2_UNUSED(0x7f00a4, 0xa1, 0xa1)
__TSYSCALL2_UNUSED(0x7f00a5, 0xa2, 0xa2)
__TSYSCALL2_UNUSED(0x7f00a6, 0xa3, 0xa3)
__TSYSCALL2_UNUSED(0x7f00a7, 0xa4, 0xa4)
__TSYSCALL2_UNUSED(0x7f00a8, 0xa5, 0xa5)
__TSYSCALL2_UNUSED(0x7f00a9, 0xa6, 0xa6)
__TSYSCALL2_UNUSED(0x7f00aa, 0xa7, 0xa7)
__TSYSCALL2_UNUSED(0x7f00ab, 0xa8, 0xa8)
__TSYSCALL2_UNUSED(0x7f00ac, 0xa9, 0xa9)
__TSYSCALL2(ksigreturn, 0xaa, 0xaa)
__TSYSCALL2_UNUSED(0x7f00ae, 0xab, 0xab)
__TSYSCALL2_UNUSED(0x7f00af, 0xac, 0xac)
__TSYSCALL2_UNUSED(0x7f00b0, 0xad, 0xad)
__TSYSCALL2_UNUSED(0x7f00b1, 0xae, 0xae)
__TSYSCALL2_UNUSED(0x7f00b2, 0xaf, 0xaf)
__TSYSCALL2_UNUSED(0x7f00b3, 0xb0, 0xb0)
__TSYSCALL2(pread64f, 0xb1, 0xb1)
__TSYSCALL2(pwrite64f, 0xb2, 0xb2)
__TSYSCALL2_UNUSED(0x7f00b6, 0xb3, 0xb3)
__TSYSCALL2_UNUSED(0x7f00b7, 0xb4, 0xb4)
__TSYSCALL2_UNUSED(0x7f00b8, 0xb5, 0xb5)
__TSYSCALL2_UNUSED(0x7f00b9, 0xb6, 0xb6)
__TSYSCALL2_UNUSED(0x7f00ba, 0xb7, 0xb7)
__TSYSCALL2_UNUSED(0x7f00bb, 0xb8, 0xb8)
__TSYSCALL2_UNUSED(0x7f00bc, 0xb9, 0xb9)
__TSYSCALL2_UNUSED(0x7f00bd, 0xba, 0xba)
__TSYSCALL2_UNUSED(0x7f00be, 0xbb, 0xbb)
__TSYSCALL2_UNUSED(0x7f00bf, 0xbc, 0xbc)
__TSYSCALL2_UNUSED(0x7f00c0, 0xbd, 0xbd)
__TSYSCALL2_UNUSED(0x7f00c1, 0xbe, 0xbe)
__TSYSCALL2_UNUSED(0x7f00c2, 0xbf, 0xbf)
__TSYSCALL2(kstat, 0xc0, 0xc0)
__TSYSCALL2(klstat, 0xc1, 0xc1)
__TSYSCALL2(kfstat, 0xc2, 0xc2)
__TSYSCALL2_UNUSED(0x7f00c6, 0xc3, 0xc3)
__TSYSCALL2_UNUSED(0x7f00c7, 0xc4, 0xc4)
__TSYSCALL2_UNUSED(0x7f00c8, 0xc5, 0xc5)
__TSYSCALL2_UNUSED(0x7f00c9, 0xc6, 0xc6)
__TSYSCALL2_UNUSED(0x7f00ca, 0xc7, 0xc7)
__TSYSCALL2_UNUSED(0x7f00cb, 0xc8, 0xc8)
__TSYSCALL2_UNUSED(0x7f00cc, 0xc9, 0xc9)
__TSYSCALL2_UNUSED(0x7f00cd, 0xca, 0xca)
__TSYSCALL2_UNUSED(0x7f00ce, 0xcb, 0xcb)
__TSYSCALL2_UNUSED(0x7f00cf, 0xcc, 0xcc)
__TSYSCALL2_UNUSED(0x7f00d0, 0xcd, 0xcd)
__TSYSCALL2_UNUSED(0x7f00d1, 0xce, 0xce)
__TSYSCALL2_UNUSED(0x7f00d2, 0xcf, 0xcf)
__TSYSCALL2_UNUSED(0x7f00d3, 0xd0, 0xd0)
__TSYSCALL2_UNUSED(0x7f00d4, 0xd1, 0xd1)
__TSYSCALL2_UNUSED(0x7f00d5, 0xd2, 0xd2)
__TSYSCALL2_UNUSED(0x7f00d6, 0xd3, 0xd3)
__TSYSCALL2_UNUSED(0x7f00d7, 0xd4, 0xd4)
__TSYSCALL2_UNUSED(0x7f00d8, 0xd5, 0xd5)
__TSYSCALL2(kreaddir, 0xd6, 0xd6)
__TSYSCALL2(kreaddirf, 0xd7, 0xd7)
__TSYSCALL2_UNUSED(0x7f00db, 0xd8, 0xd8)
__TSYSCALL2_UNUSED(0x7f00dc, 0xd9, 0xd9)
__TSYSCALL2_UNUSED(0x7f00dd, 0xda, 0xda)
__TSYSCALL2_UNUSED(0x7f00de, 0xdb, 0xdb)
__TSYSCALL2_UNUSED(0x7f00df, 0xdc, 0xdc)
__TSYSCALL2_UNUSED(0x7f00e0, 0xdd, 0xdd)
__TSYSCALL2_UNUSED(0x7f00e1, 0xde, 0xde)
__TSYSCALL2_UNUSED(0x7f00e2, 0xdf, 0xdf)
__TSYSCALL2_UNUSED(0x7f00e3, 0xe0, 0xe0)
__TSYSCALL2_UNUSED(0x7f00e4, 0xe1, 0xe1)
__TSYSCALL2_UNUSED(0x7f00e5, 0xe2, 0xe2)
__TSYSCALL2_UNUSED(0x7f00e6, 0xe3, 0xe3)
__TSYSCALL2_UNUSED(0x7f00e7, 0xe4, 0xe4)
__TSYSCALL2_UNUSED(0x7f00e8, 0xe5, 0xe5)
__TSYSCALL2_UNUSED(0x7f00e9, 0xe6, 0xe6)
__TSYSCALL2_UNUSED(0x7f00ea, 0xe7, 0xe7)
__TSYSCALL2_UNUSED(0x7f00eb, 0xe8, 0xe8)
__TSYSCALL2_UNUSED(0x7f00ec, 0xe9, 0xe9)
__TSYSCALL2_UNUSED(0x7f00ed, 0xea, 0xea)
__TSYSCALL2_UNUSED(0x7f00ee, 0xeb, 0xeb)
__TSYSCALL2_UNUSED(0x7f00ef, 0xec, 0xec)
__TSYSCALL2(lfutex, 0xed, 0xed)
__TSYSCALL2(lfutexexpr, 0xee, 0xee)
__TSYSCALL2_UNUSED(0x7f00f2, 0xef, 0xef)
__TSYSCALL2_UNUSED(0x7f00f3, 0xf0, 0xf0)
__TSYSCALL2_UNUSED(0x7f00f4, 0xf1, 0xf1)
__TSYSCALL2_UNUSED(0x7f00f5, 0xf2, 0xf2)
__TSYSCALL2_UNUSED(0x7f00f6, 0xf3, 0xf3)
__TSYSCALL2_UNUSED(0x7f00f7, 0xf4, 0xf4)
__TSYSCALL2_UNUSED(0x7f00f8, 0xf5, 0xf5)
__TSYSCALL2_UNUSED(0x7f00f9, 0xf6, 0xf6)
__TSYSCALL2_UNUSED(0x7f00fa, 0xf7, 0xf7)
__TSYSCALL2_UNUSED(0x7f00fb, 0xf8, 0xf8)
__TSYSCALL2_UNUSED(0x7f00fc, 0xf9, 0xf9)
__TSYSCALL2_UNUSED(0x7f00fd, 0xfa, 0xfa)
__TSYSCALL2_UNUSED(0x7f00fe, 0xfb, 0xfb)
__TSYSCALL2_UNUSED(0x7f00ff, 0xfc, 0xfc)
__TSYSCALL2(set_userprocmask_address, 0xfd, 0xfd)
__TSYSCALL2_UNUSED(0x7f0101, 0xfe, 0xfe)
__TSYSCALL2_UNUSED(0x7f0102, 0xff, 0xff)
__TSYSCALL2_UNUSED(0x7f0103, 0x100, 0x100)
__TSYSCALL2_UNUSED(0x7f0104, 0x101, 0x101)
__TSYSCALL2_UNUSED(0x7f0105, 0x102, 0x102)
__TSYSCALL2_UNUSED(0x7f0106, 0x103, 0x103)
__TSYSCALL2_UNUSED(0x7f0107, 0x104, 0x104)
__TSYSCALL2_UNUSED(0x7f0108, 0x105, 0x105)
__TSYSCALL2_UNUSED(0x7f0109, 0x106, 0x106)
__TSYSCALL2_UNUSED(0x7f010a, 0x107, 0x107)
__TSYSCALL2_UNUSED(0x7f010b, 0x108, 0x108)
__TSYSCALL2_UNUSED(0x7f010c, 0x109, 0x109)
__TSYSCALL2(utimes64, 0x10a, 0x10a)
__TSYSCALL2_UNUSED(0x7f010e, 0x10b, 0x10b)
__TSYSCALL2_UNUSED(0x7f010f, 0x10c, 0x10c)
__TSYSCALL2_UNUSED(0x7f0110, 0x10d, 0x10d)
__TSYSCALL2_UNUSED(0x7f0111, 0x10e, 0x10e)
__TSYSCALL2_UNUSED(0x7f0112, 0x10f, 0x10f)
__TSYSCALL2_UNUSED(0x7f0113, 0x110, 0x110)
__TSYSCALL2_UNUSED(0x7f0114, 0x111, 0x111)
__TSYSCALL2_UNUSED(0x7f0115, 0x112, 0x112)
__TSYSCALL2_UNUSED(0x7f0116, 0x113, 0x113)
__TSYSCALL2_UNUSED(0x7f0117, 0x114, 0x114)
__TSYSCALL2(waitid64, 0x115, 0x115)
__TSYSCALL2_UNUSED(0x7f0119, 0x116, 0x116)
__TSYSCALL2_UNUSED(0x7f011a, 0x117, 0x117)
__TSYSCALL2_UNUSED(0x7f011b, 0x118, 0x118)
__TSYSCALL2_UNUSED(0x7f011c, 0x119, 0x119)
__TSYSCALL2_UNUSED(0x7f011d, 0x11a, 0x11a)
__TSYSCALL2_UNUSED(0x7f011e, 0x11b, 0x11b)
__TSYSCALL2_UNUSED(0x7f011f, 0x11c, 0x11c)
__TSYSCALL2_UNUSED(0x7f0120, 0x11d, 0x11d)
__TSYSCALL2_UNUSED(0x7f0121, 0x11e, 0x11e)
__TSYSCALL2_UNUSED(0x7f0122, 0x11f, 0x11f)
__TSYSCALL2_UNUSED(0x7f0123, 0x120, 0x120)
__TSYSCALL2_UNUSED(0x7f0124, 0x121, 0x121)
__TSYSCALL2_UNUSED(0x7f0125, 0x122, 0x122)
__TSYSCALL2_UNUSED(0x7f0126, 0x123, 0x123)
__TSYSCALL2_UNUSED(0x7f0127, 0x124, 0x124)
__TSYSCALL2_UNUSED(0x7f0128, 0x125, 0x125)
__TSYSCALL2_UNUSED(0x7f0129, 0x126, 0x126)
__TSYSCALL2_UNUSED(0x7f012a, 0x127, 0x127)
__TSYSCALL2_UNUSED(0x7f012b, 0x128, 0x128)
__TSYSCALL2_UNUSED(0x7f012c, 0x129, 0x129)
__TSYSCALL2_UNUSED(0x7f012d, 0x12a, 0x12a)
__TSYSCALL2_UNUSED(0x7f012e, 0x12b, 0x12b)
__TSYSCALL2_UNUSED(0x7f012f, 0x12c, 0x12c)
__TSYSCALL2_UNUSED(0x7f0130, 0x12d, 0x12d)
__TSYSCALL2_UNUSED(0x7f0131, 0x12e, 0x12e)
__TSYSCALL2_UNUSED(0x7f0132, 0x12f, 0x12f)
__TSYSCALL2_UNUSED(0x7f0133, 0x130, 0x130)
__TSYSCALL2_UNUSED(0x7f0134, 0x131, 0x131)
__TSYSCALL2_UNUSED(0x7f0135, 0x132, 0x132)
__TSYSCALL2_UNUSED(0x7f0136, 0x133, 0x133)
__TSYSCALL2_UNUSED(0x7f0137, 0x134, 0x134)
__TSYSCALL2_UNUSED(0x7f0138, 0x135, 0x135)
__TSYSCALL2_UNUSED(0x7f0139, 0x136, 0x136)
__TSYSCALL2_UNUSED(0x7f013a, 0x137, 0x137)
__TSYSCALL2_UNUSED(0x7f013b, 0x138, 0x138)
__TSYSCALL2_UNUSED(0x7f013c, 0x139, 0x139)
__TSYSCALL2(inotify_add_watch_at, 0x13a, 0x13a)
__TSYSCALL2_UNUSED(0x7f013e, 0x13b, 0x13b)
__TSYSCALL2_UNUSED(0x7f013f, 0x13c, 0x13c)
__TSYSCALL2_UNUSED(0x7f0140, 0x13d, 0x13d)
__TSYSCALL2_UNUSED(0x7f0141, 0x13e, 0x13e)
__TSYSCALL2_UNUSED(0x7f0142, 0x13f, 0x13f)
__TSYSCALL2(fmkdirat, 0x140, 0x140)
__TSYSCALL2(fmknodat, 0x141, 0x141)
__TSYSCALL2_UNUSED(0x7f0145, 0x142, 0x142)
__TSYSCALL2(futimesat64, 0x143, 0x143)
__TSYSCALL2(kfstatat, 0x144, 0x144)
__TSYSCALL2_UNUSED(0x7f0148, 0x145, 0x145)
__TSYSCALL2_UNUSED(0x7f0149, 0x146, 0x146)
__TSYSCALL2_UNUSED(0x7f014a, 0x147, 0x147)
__TSYSCALL2(fsymlinkat, 0x148, 0x148)
__TSYSCALL2(freadlinkat, 0x149, 0x149)
__TSYSCALL2(preadvf, 0x14a, 0x14a)
__TSYSCALL2(pwritevf, 0x14b, 0x14b)
__TSYSCALL2_UNUSED(0x7f014f, 0x14c, 0x14c)
__TSYSCALL2_UNUSED(0x7f0150, 0x14d, 0x14d)
__TSYSCALL2_UNUSED(0x7f0151, 0x14e, 0x14e)
__TSYSCALL2_UNUSED(0x7f0152, 0x14f, 0x14f)
__TSYSCALL2_UNUSED(0x7f0153, 0x150, 0x150)
__TSYSCALL2_UNUSED(0x7f0154, 0x151, 0x151)
__TSYSCALL2_UNUSED(0x7f0155, 0x152, 0x152)
__TSYSCALL2_UNUSED(0x7f0156, 0x153, 0x153)
__TSYSCALL2_UNUSED(0x7f0157, 0x154, 0x154)
__TSYSCALL2_UNUSED(0x7f0158, 0x155, 0x155)
__TSYSCALL2_UNUSED(0x7f0159, 0x156, 0x156)
__TSYSCALL2_UNUSED(0x7f015a, 0x157, 0x157)
__TSYSCALL2_UNUSED(0x7f015b, 0x158, 0x158)
__TSYSCALL2_UNUSED(0x7f015c, 0x159, 0x159)
__TSYSCALL2_UNUSED(0x7f015d, 0x15a, 0x15a)
__TSYSCALL2_UNUSED(0x7f015e, 0x15b, 0x15b)
__TSYSCALL2_UNUSED(0x7f015f, 0x15c, 0x15c)
__TSYSCALL2(fallocate64, 0x15d, 0x15d)
__TSYSCALL2_TABLE_END(0x7f0003, 0x7f0160, 0x15e, 0x7f0003, 0x7f0160, 0x15e)

#undef __TSYSCALL2_TABLE_END
#undef __TSYSCALL2_TABLE_BEGIN
#undef __TSYSCALL2_UNUSED_TRAILING
#undef __TSYSCALL2_UNUSED_LEADING
#undef __TSYSCALL2_UNUSED
#undef __TSYSCALL2
#undef __TSYSCALL1_TABLE_END
#undef __TSYSCALL1_TABLE_BEGIN
#undef __TSYSCALL1_UNUSED_TRAILING
#undef __TSYSCALL1_UNUSED_LEADING
#undef __TSYSCALL1_UNUSED
#undef __TSYSCALL1
#undef __TSYSCALL0_TABLE_END
#undef __TSYSCALL0_TABLE_BEGIN
#undef __TSYSCALL0_UNUSED_TRAILING
#undef __TSYSCALL0_UNUSED_LEADING
#undef __TSYSCALL0_UNUSED
#undef __TSYSCALL0
#undef __TSYSCALL_TABLE_END
#undef __TSYSCALL_TABLE_BEGIN
#undef __TSYSCALL_UNUSED_TRAILING
#undef __TSYSCALL_UNUSED_LEADING
#undef __TSYSCALL_UNUSED
#undef __TSYSCALL
#undef __SYSCALL_UNUSED
#undef __SYSCALL
