﻿//******************************************************************************************************
//  Program.cs - Gbtc
//
//  Copyright © 2020, Grid Protection Alliance.  All Rights Reserved.
//
//  Licensed to the Grid Protection Alliance (GPA) under one or more contributor license agreements. See
//  the NOTICE file distributed with this work for additional information regarding copyright ownership.
//  The GPA licenses this file to you under the MIT License (MIT), the "License"; you may not use this
//  file except in compliance with the License. You may obtain a copy of the License at:
//
//      http://opensource.org/licenses/MIT
//
//  Unless agreed to in writing, the subject software distributed under the License is distributed on an
//  "AS-IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. Refer to the
//  License for the specific language governing permissions and limitations.
//
//  Code Modification History:
//  ----------------------------------------------------------------------------------------------------
//  10/09/2020 - J. Ritchie Carroll
//       Generated original version of source code.
//
//******************************************************************************************************

using Gemstone.Configuration;
using Microsoft.Extensions.Configuration;

namespace udp2serial
{
    internal class Program
    {
        private static int Main(string[] args)
        {
            IConfiguration configuration = new ConfigurationBuilder()
                .ConfigureGemstoneDefaults(Settings.ConfigureAppSettings, useINI: true)
                .AddCommandLine(args, Settings.SwitchMappings)
                .Build();

            Settings settings = new Settings(configuration);
            ExitCode result = settings.Parse(args);

            if (result == ExitCode.Success)
                ForwardEngine.Start(settings);

            return (int)result;
        }
    }
}
