EXECUTABLE="../bin/tcpsnitch"
LD_PRELOAD="LD_PRELOAD=../libtcpsnitch.so.1.0"
TEST_DIR="/tmp/netspy"

# LOGS
PROCESS_DIR_REGEX="*.out*"
LOG_FILE="logs.txt"
LOG_LABEL_ERROR="ERROR"
LOG_LABEL_WARN="WARN"
LOG_LABEL_INFO="INFO"

# EVENTS
# sys/socket.h
SOCK_EV_SOCKET="socket"
SOCK_EV_BIND="bind"
SOCK_EV_CONNECT="connect"
SOCK_EV_SHUTDOWN="shutdown"
SOCK_EV_LISTEN="listen"
SOCK_EV_ACCEPT="accept"
SOCK_EV_ACCEPT4="accept4"
SOCK_EV_GETSOCKOPT="getsockopt"
SOCK_EV_SETSOCKOPT="setsockopt"
SOCK_EV_SEND="send"
SOCK_EV_RECV="recv"
SOCK_EV_SENDTO="sendto"
SOCK_EV_RECVFROM="recvfrom"
SOCK_EV_SENDMSG="sendmsg"
SOCK_EV_RECVMSG="recvmsg"
SOCK_EV_SENDMMSG="sendmmsg"
SOCK_EV_RECVMMSG="recvmmsg"
SOCK_EV_GETSOCKNAME="getsockname"
SOCK_EV_GETPEERNAME="getpeername"
SOCK_EV_SOCKATMARK="sockatmark"
SOCK_EV_ISFDTYPE="isfdtype"

# unistd.h
SOCK_EV_WRITE="write"
SOCK_EV_READ="read"
SOCK_EV_CLOSE="close"
SOCK_EV_DUP="dup"
SOCK_EV_DUP2="dup2"
SOCK_EV_DUP3="dup3"

# sys/uio.h
SOCK_EV_WRITEV="writev"
SOCK_EV_READV="readv"
SOCK_EV_IOCTL="ioctl"

# sys/sendfile.h
SOCK_EV_SENDFILE="sendfile"

# poll.h
SOCK_EV_POLL="poll"
SOCK_EV_PPOLL="ppoll"

# sys/select.h
SOCK_EV_SELECT="select"
SOCK_EV_PSELECT="pselect"

# fcntl.h
SOCK_EV_FCNTL="fcntl"

# epoll.h
SOCK_EV_EPOLL_CTL="epoll_ctl"
SOCK_EV_EPOLL_WAIT="epoll_wait"
SOCK_EV_EPOLL_PWAIT="epoll_pwait"

# stdio.h
SOCK_EV_FDOPEN="fdopen"

SOCK_EV_TCP_INFO="tcp_info"

SOCKET_SYSCALLS = [
  SOCK_EV_SOCKET,
  SOCK_EV_BIND,
  SOCK_EV_CONNECT,
  SOCK_EV_SHUTDOWN,
  SOCK_EV_LISTEN,
#  SOCK_EV_ACCEPT,
#  SOCK_EV_ACCEPT4,
  SOCK_EV_GETSOCKOPT,
  SOCK_EV_SETSOCKOPT,
  SOCK_EV_SEND,
  SOCK_EV_RECV,
  SOCK_EV_SENDTO,
  SOCK_EV_RECVFROM,
  SOCK_EV_SENDMSG,
  SOCK_EV_RECVMSG,
  SOCK_EV_SENDMMSG,
	SOCK_EV_RECVMMSG,
  SOCK_EV_GETSOCKNAME,
  SOCK_EV_GETPEERNAME,
  SOCK_EV_SOCKATMARK,
  SOCK_EV_ISFDTYPE,
  SOCK_EV_WRITE,
  SOCK_EV_READ,
  SOCK_EV_CLOSE,
  SOCK_EV_DUP,
  SOCK_EV_DUP2,
  SOCK_EV_DUP3,
  SOCK_EV_WRITEV,
  SOCK_EV_READV,
  SOCK_EV_IOCTL,
  SOCK_EV_SENDFILE,
  SOCK_EV_POLL,
  SOCK_EV_PPOLL,
  SOCK_EV_SELECT,
  SOCK_EV_PSELECT,
  SOCK_EV_FCNTL,
  SOCK_EV_EPOLL_CTL,
  SOCK_EV_EPOLL_WAIT,
  SOCK_EV_EPOLL_PWAIT,
  SOCK_EV_ISFDTYPE
]


